/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_planner;

import org.agreement_technologies.common.map_communication.AgentCommunication;
import org.agreement_technologies.common.map_grounding.GroundedTask;
import org.agreement_technologies.common.map_planner.PlannerFactory;
import org.agreement_technologies.service.map_planner.POPIncrementalPlan;
import org.agreement_technologies.service.map_planner.POPSolutionChecker;

public class POPSolutionCheckerPrivateGoals
extends POPSolutionChecker {
    private final AgentCommunication comm;
    private final GroundedTask task;
    private final double threshold;

    public POPSolutionCheckerPrivateGoals(AgentCommunication c, GroundedTask t) {
        this.comm = c;
        this.task = t;
        this.threshold = this.task.getMetricThreshold();
    }

    @Override
    public Boolean isSolution(POPIncrementalPlan candidate, PlannerFactory pf) {
        if (this.comm.numAgents() == 1) {
            if (candidate.isSolution()) {
                return this.task.evaluateMetric(candidate.computeState(candidate.getFather().linearization(), pf), 0.0) - this.threshold <= 0.0;
            }
            return false;
        }
        if (candidate.isSolution()) {
            int approvals = 0;
            int totalAgents = this.comm.getAgentList().size();
            if (this.comm.batonAgent()) {
                for (int i = 0; i < this.comm.getOtherAgents().size(); ++i) {
                    if (!((Boolean)this.comm.receiveMessage(true)).booleanValue()) continue;
                    ++approvals;
                }
                double metric = this.task.evaluateMetric(candidate.computeState(candidate.getFather().linearization(), pf), 0.0);
                candidate.setMetric(metric);
                if (metric - this.threshold <= 0.0) {
                    ++approvals;
                }
                Boolean finalRes = (float)approvals / (float)totalAgents > 0.5f;
                this.comm.sendMessage(finalRes, false);
                return finalRes;
            }
            double metric = this.task.evaluateMetric(candidate.computeState(candidate.getFather().linearization(), pf), 0.0);
            candidate.setMetric(metric);
            Boolean res = metric - this.threshold <= 0.0;
            this.comm.sendMessage(this.comm.getBatonAgent(), res, true);
            res = (Boolean)this.comm.receiveMessage(false);
            return res;
        }
        return false;
    }
}

