/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_planner;

import org.agreement_technologies.common.map_planner.Condition;
import org.agreement_technologies.service.map_planner.POPFunction;

public class POPPrecEff {
    static final int EQUAL = 1;
    static final int DISTINCT = 2;
    static final boolean IS_PREC = true;
    static final boolean IS_EFF = false;
    private Condition condition;
    private POPFunction function;
    private final String value;
    private final int conditionType;
    private String key;
    private int index;

    public POPPrecEff(Condition cond, POPFunction var, String val, int co) {
        this.condition = cond;
        this.conditionType = co;
        this.function = var;
        this.value = val;
        this.key = null;
        this.key = this.toKey();
    }

    public int getVarCode() {
        return this.condition.getVarCode();
    }

    public int getValueCode() {
        return this.condition.getValueCode();
    }

    public void setIndex(int i) {
        this.index = i;
    }

    public int getIndex() {
        return this.index;
    }

    public void setFunction(POPFunction v) {
        this.function = v;
    }

    public String getValue() {
        return this.value;
    }

    public int getType() {
        return this.conditionType;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setGroundedCondition(Condition gc) {
        this.condition = gc;
    }

    public final String toKey() {
        if (this.key == null) {
            String res = this.conditionType == 1 ? "=" : (this.conditionType == 2 ? "<>" : "?");
            this.key = this.condition.getVarCode() + res + this.condition.getValueCode();
            return this.key;
        }
        return this.key;
    }

    public String toString() {
        int n = 0;
        String res = this.function.getName() + "(";
        for (String s : this.function.getParams()) {
            if (n == 0) {
                ++n;
            } else {
                res = res + ", ";
            }
            res = res + s;
        }
        if (this.conditionType == 1) {
            res = res + ") = ";
        }
        if (this.conditionType == 2) {
            res = res + ") <> ";
        }
        res = res + this.getValue();
        return res;
    }

    public POPFunction getFunction() {
        return this.function;
    }
}

