/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_planner;

import org.agreement_technologies.common.map_planner.CausalLink;
import org.agreement_technologies.common.map_planner.Ordering;
import org.agreement_technologies.service.map_planner.OrderingManager;
import org.agreement_technologies.service.map_planner.POPInternalPlan;
import org.agreement_technologies.service.tools.CustomArrayList;

public class POPOrderingManagerMemorization
implements OrderingManager {
    private int indexT;
    private int indexF;
    private int size;
    private int[][] matrix;
    private CustomArrayList<CustomArrayList<Integer>> list;

    public POPOrderingManagerMemorization(int x) {
        this.matrix = new int[x][x];
        this.indexT = -1;
        this.indexF = 0;
        this.size = 0;
        this.list = new CustomArrayList(x);
        for (int i = 0; i < x; ++i) {
            this.list.insert(new CustomArrayList(x));
            for (int j = 0; j < x; ++j) {
                this.matrix[i][j] = 0;
            }
        }
    }

    public POPOrderingManagerMemorization() {
        this(20);
    }

    @Override
    public boolean checkOrdering(int i, int j) {
        if (i == 0 || j == 1) {
            return true;
        }
        if (i == 1 || j == 0) {
            return false;
        }
        if (i > this.size) {
            return false;
        }
        if (this.matrix[i][j] == this.indexT) {
            return true;
        }
        if (this.matrix[i][j] == this.indexF) {
            return false;
        }
        return this.findAntecessors(j, i);
    }

    private boolean findAntecessors(int node, int target) {
        CustomArrayList<Integer> nodes = new CustomArrayList<Integer>();
        CustomArrayList<Integer> memorization = new CustomArrayList<Integer>();
        nodes.add(node);
        memorization.add(node);
        while (!nodes.isEmpty()) {
            int aux = (Integer)nodes.retrieve();
            if (this.matrix[target][aux] == this.indexT) {
                this.memorize(memorization, node);
                return true;
            }
            if (this.list.get(aux).contains(target)) {
                this.memorize(memorization, node);
                return true;
            }
            nodes.append(this.list.get(aux));
            memorization.append(this.list.get(aux));
        }
        this.memorize(memorization, node);
        return false;
    }

    private void memorize(CustomArrayList<Integer> mem, int node) {
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < mem.size(); ++j) {
                if (this.matrix[node][i] != this.indexT) continue;
                this.matrix[mem.get((int)j).intValue()][i] = this.indexT;
            }
        }
    }

    @Override
    public void update(POPInternalPlan p) {
        POPInternalPlan iter = p;
        this.indexF += 2;
        this.indexT += 2;
        this.size = 0;
        while (this.size == 0) {
            if (this.size == 0 && iter.getStep() != null) {
                this.resize(iter.getStep().getIndex() + 1);
                this.size = iter.getStep().getIndex() + 1;
            }
            iter = iter.getFather();
        }
        for (iter = p; iter != null; iter = iter.getFather()) {
            if (iter.getOrdering() != null) {
                this.list.get(iter.getOrdering().getIndex2()).addNotRepeated(iter.getOrdering().getIndex1());
                this.matrix[iter.getOrdering().getIndex1()][iter.getOrdering().getIndex2()] = this.indexT;
                this.matrix[iter.getOrdering().getIndex2()][iter.getOrdering().getIndex1()] = this.indexF;
            }
            if (iter.getCausalLink() == null) continue;
            this.list.get(iter.getCausalLink().getIndex2()).addNotRepeated(iter.getCausalLink().getIndex1());
            this.matrix[iter.getCausalLink().getIndex1()][iter.getCausalLink().getIndex2()] = this.indexT;
            this.matrix[iter.getCausalLink().getIndex2()][iter.getCausalLink().getIndex1()] = this.indexF;
        }
    }

    @Override
    public void newPlan() {
        this.indexF += 2;
        this.indexT += 2;
        for (int i = 0; i < this.list.size(); ++i) {
            this.list.get(i).clear();
        }
    }

    @Override
    public void setSize(int size) {
        if (this.size < size) {
            this.size = size;
            this.resize(size);
        }
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public void resize(int s) {
        if (s > this.matrix.length) {
            int i;
            int newSize = s + (s >> 1);
            for (i = this.size; i < newSize; ++i) {
                this.list.add(new CustomArrayList(newSize));
            }
            this.matrix = new int[newSize][newSize];
            for (i = 0; i < newSize; ++i) {
                for (int j = 0; j < newSize; ++j) {
                    this.matrix[i][j] = 0;
                }
            }
        }
    }

    public void printMatrix() {
        String res = "[0]\n";
        res = res + "[1]\n";
        res = res + "[2] ";
        for (int i = 2; i < this.size; ++i) {
            for (int j = 2; j < this.size; ++j) {
                res = this.matrix[i][j] == this.indexT ? res + "1 " : (this.matrix[i][j] == this.indexF ? res + "0 " : res + "8 ");
            }
            if (i + 1 >= this.size) continue;
            res = res + "\n[" + (i + 1) + "] ";
        }
        System.out.print(res + "\n");
    }

    public String toString() {
        String res = "[0]\n";
        res = res + "[1]\n";
        res = res + "[2] ";
        for (int i = 2; i < this.size; ++i) {
            for (int j = 2; j < this.size; ++j) {
                if (this.matrix[i][j] == this.indexT) {
                    res = res + "1 ";
                    continue;
                }
                if (this.matrix[i][j] != this.indexF) continue;
                res = res + "0 ";
            }
            if (i + 1 >= this.size) continue;
            res = res + "\n[" + (i + 1) + "] ";
        }
        return res;
    }

    @Override
    public void addOrdering(int o1, int o2) {
        this.list.get(o2).addNotRepeated(o1);
        this.matrix[o1][o2] = this.indexT;
        this.matrix[o2][o1] = this.indexF;
    }

    @Override
    public void computeAccessibilityMatrix() {
    }

    @Override
    public void removeOrdering(int o1, int o2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void rebuild(POPInternalPlan plan) {
        this.newPlan();
        this.setSize(plan.numSteps());
        if (!plan.getTotalOrderings().isEmpty()) {
            for (Ordering o : plan.getTotalOrderings()) {
                this.addOrdering(o.getIndex1(), o.getIndex2());
            }
        }
        if (!plan.getTotalCausalLinks().isEmpty()) {
            for (CausalLink l : plan.getTotalCausalLinks()) {
                this.addOrdering(l.getIndex1(), l.getIndex2());
            }
        }
    }
}

