/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_planner;

import org.agreement_technologies.common.map_planner.CausalLink;
import org.agreement_technologies.common.map_planner.Ordering;
import org.agreement_technologies.service.map_planner.OrderingManager;
import org.agreement_technologies.service.map_planner.POPInternalPlan;

public class POPMatrix
implements OrderingManager {
    private int index;
    private int size;
    private int[][] matrix;

    public POPMatrix(int x) {
        this.matrix = new int[x][x];
        this.index = 1;
        this.size = 0;
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < x; ++j) {
                this.matrix[i][j] = 0;
            }
        }
    }

    @Override
    public void newPlan() {
        ++this.index;
    }

    @Override
    public void setSize(int s) {
        this.size = s;
        if (s >= this.matrix.length) {
            this.resizeMatrix(Math.max(s, this.matrix.length * 2));
        }
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void update(POPInternalPlan p) {
        POPInternalPlan iter = p;
        this.newPlan();
        this.size = 0;
        while (this.size == 0) {
            if (this.size == 0 && iter.getStep() != null) {
                this.setSize(iter.getStep().getIndex() + 1);
            }
            iter = iter.getFather();
        }
        for (iter = p; iter != null; iter = iter.getFather()) {
            if (iter.getOrdering() == null) continue;
            this.matrix[iter.getOrdering().getIndex1()][iter.getOrdering().getIndex2()] = this.index;
        }
    }

    private void resizeMatrix(int size) {
        if (size > this.matrix.length) {
            this.matrix = new int[size][size];
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < size; ++j) {
                    this.matrix[i][j] = 0;
                }
            }
        }
    }

    @Override
    public void rebuild(POPInternalPlan plan) {
        this.newPlan();
        this.setSize(plan.numSteps());
        if (!plan.getTotalOrderings().isEmpty()) {
            for (Ordering o : plan.getTotalOrderings()) {
                this.addOrdering(o.getIndex1(), o.getIndex2());
            }
        }
        if (!plan.getTotalCausalLinks().isEmpty()) {
            for (CausalLink l : plan.getTotalCausalLinks()) {
                this.addOrdering(l.getIndex1(), l.getIndex2());
            }
        }
        this.computeAccessibilityMatrix();
    }

    @Override
    public void computeAccessibilityMatrix() {
        for (int k = 2; k < this.size; ++k) {
            for (int i = 2; i < this.size; ++i) {
                for (int j = 2; j < this.size; ++j) {
                    if (this.matrix[i][j] == this.index || this.matrix[i][k] != this.index || this.matrix[k][j] != this.index) continue;
                    this.matrix[i][j] = this.index;
                }
            }
        }
    }

    @Override
    public void addOrdering(int step1, int step2) {
        this.matrix[step1][step2] = this.index;
    }

    @Override
    public boolean checkOrdering(int i, int j) {
        if (i == 0) {
            return true;
        }
        if (j == 1) {
            return true;
        }
        if (i > this.size) {
            return false;
        }
        return this.matrix[i][j] == this.index;
    }

    public void printMatrix() {
        String res = "[0]\n";
        res = res + "[1]\n";
        res = res + "[2] ";
        for (int i = 2; i < this.size; ++i) {
            for (int j = 2; j < this.size; ++j) {
                res = this.matrix[i][j] == this.index ? res + "1 " : res + "0 ";
            }
            if (i + 1 >= this.size) continue;
            res = res + "\n[" + (i + 1) + "] ";
        }
        System.out.print(res + "\n");
    }

    public String toString() {
        String res = "[0]\n";
        res = res + "[1]\n";
        res = res + "[2] ";
        for (int i = 2; i < this.size; ++i) {
            for (int j = 2; j < this.size; ++j) {
                res = this.matrix[i][j] == this.index ? res + "1 " : res + "0 ";
            }
            if (i + 1 >= this.size) continue;
            res = res + "\n[" + (i + 1) + "] ";
        }
        return res;
    }

    @Override
    public void removeOrdering(int o1, int o2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

