/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_planner;

import java.util.ArrayList;
import java.util.Stack;
import org.agreement_technologies.service.map_planner.POPInternalPlan;

class POPInternalSearchTree {
    private final Stack<POPInternalPlan> planStack = new Stack();
    private final POPInternalPlan basePlan;

    public POPInternalSearchTree(POPInternalPlan initialIncrementalPlan) {
        this.basePlan = initialIncrementalPlan;
        this.planStack.push(this.basePlan);
    }

    public POPInternalPlan getNextPlan() {
        return this.planStack.pop();
    }

    public void addSuccessors(ArrayList<POPInternalPlan> successors) {
        for (POPInternalPlan s : successors) {
            this.planStack.push(s);
        }
    }

    public boolean isEmpty() {
        return this.planStack.isEmpty();
    }

    public void addPlan(POPInternalPlan plan) {
        this.planStack.push(plan);
    }

    public String toString() {
        return "Plans stored: " + this.planStack.size();
    }
}

