/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_planner;

import java.util.ArrayList;
import java.util.Iterator;
import org.agreement_technologies.common.map_planner.CausalLink;
import org.agreement_technologies.common.map_planner.ExtendedPlanner;
import org.agreement_technologies.common.map_planner.OpenCondition;
import org.agreement_technologies.common.map_planner.Ordering;
import org.agreement_technologies.common.map_planner.Step;
import org.agreement_technologies.service.map_planner.POPCausalLink;
import org.agreement_technologies.service.map_planner.POPOpenCondition;
import org.agreement_technologies.service.map_planner.POPOrdering;
import org.agreement_technologies.service.map_planner.POPPrecEff;
import org.agreement_technologies.service.map_planner.POPStep;
import org.agreement_technologies.service.map_planner.POPThreat;
import org.agreement_technologies.service.tools.CustomArrayList;

public class POPInternalPlan
implements Cloneable {
    private final ExtendedPlanner POP;
    private final POPInternalPlan father;
    private final POPStep step;
    private final POPCausalLink causalLink;
    private ArrayList<OpenCondition> openConditions;
    private ArrayList<POPThreat> threats;
    private POPOrdering ordering;
    private int steps;

    POPInternalPlan(POPInternalPlan basePlan, POPStep newStep, POPCausalLink newLink, POPOrdering newOrdering, ArrayList<OpenCondition> precs, ArrayList<POPThreat> thre, OpenCondition solvedPrec, boolean supportFinalStep, ExtendedPlanner planner) {
        this.POP = planner;
        if (this.POP.getAntecessors() != null) {
            this.steps = this.POP.getAntecessors().length + 2;
            if (supportFinalStep) {
                --this.steps;
            }
        } else {
            this.steps = -1;
        }
        this.father = basePlan;
        this.step = newStep;
        this.causalLink = newLink;
        if (this.causalLink == null) {
            this.ordering = newOrdering;
        }
        this.threats = new ArrayList();
        if (precs != null) {
            this.openConditions = new ArrayList(precs.size());
        }
        Iterator<OpenCondition> it = null;
        if (basePlan != null && basePlan.getPreconditions() != null) {
            it = basePlan.getPreconditions().iterator();
        }
        if (it == null) {
            if (precs != null) {
                for (OpenCondition o : precs) {
                    this.openConditions.add(o);
                }
            }
        } else {
            while (it.hasNext()) {
                POPOpenCondition prec = (POPOpenCondition)it.next();
                if (!(solvedPrec != null && prec.getCondition() != ((POPOpenCondition)solvedPrec).getCondition() || solvedPrec != null && prec.getCondition() == ((POPOpenCondition)solvedPrec).getCondition() && prec.getStep().getIndex() != solvedPrec.getStep().getIndex()) && solvedPrec != null) continue;
                this.openConditions.add(prec);
            }
        }
        if (newStep != null) {
            for (POPPrecEff pe : newStep.getAction().getPrecs()) {
                if (pe.getCondition().toString().equals(solvedPrec.getCondition().toString())) continue;
                this.openConditions.add(new POPOpenCondition(pe, newStep, true));
            }
        }
        if (thre != null) {
            for (int i = 0; i < thre.size(); ++i) {
                this.threats.add(thre.get(i));
            }
        }
    }

    public Object clone() {
        POPInternalPlan c = new POPInternalPlan(null, null, null, null, null, null, null, false, this.POP);
        ArrayList<OpenCondition> precs = new ArrayList<OpenCondition>(this.getPreconditions().size());
        for (OpenCondition p : this.getPreconditions()) {
            precs.add((POPOpenCondition)p);
        }
        c.setPreconditions(precs);
        return c;
    }

    public ExtendedPlanner getPlanner() {
        return this.POP;
    }

    public void setPreconditions(ArrayList<OpenCondition> p) {
        this.openConditions = p;
    }

    public ArrayList<OpenCondition> getPreconditions() {
        return this.openConditions;
    }

    public ArrayList<POPThreat> getThreats() {
        return this.threats;
    }

    public POPInternalPlan getFather() {
        return this.father;
    }

    public POPOrdering getOrdering() {
        return this.ordering;
    }

    public POPStep getStep() {
        return this.step;
    }

    public POPCausalLink getCausalLink() {
        return this.causalLink;
    }

    public void setOrdering(int v1, int v2) {
        this.ordering = new POPOrdering(v1, v2);
    }

    public void setNumSteps(int n) {
        this.steps = n;
    }

    public Step getFinalStep() {
        return this.POP.getFinalStep();
    }

    public void addThreats(ArrayList<POPThreat> v) {
        for (POPThreat t : v) {
            this.threats.add(t);
        }
    }

    public void restorePlan(ArrayList<OpenCondition> oc) {
        this.threats = new ArrayList();
        this.openConditions = new ArrayList();
        for (OpenCondition o : oc) {
            this.openConditions.add(o);
        }
    }

    public void cleanPlan() {
        this.openConditions = null;
        this.threats = null;
    }

    public String toString() {
        String res = "";
        res = res + "Precs: " + this.openConditions.size() + "\n";
        res = res + "Threats: " + this.threats.size();
        return res;
    }

    public Step getStep(int index) {
        if (index == 0) {
            return this.POP.getInitialStep();
        }
        if (index == 1) {
            return this.POP.getFinalStep();
        }
        if (this.isRoot() || index <= this.numSteps() - 2) {
            return this.POP.getAntecessors()[index - 1].getStep();
        }
        POPInternalPlan aux = this;
        while (!aux.isRoot()) {
            if (aux.step != null) {
                return aux.step;
            }
            aux = aux.father;
        }
        if (this.POP.getAntecessors()[this.POP.getAntecessors().length - 1].getStep().getIndex() == index) {
            return this.POP.getAntecessors()[this.POP.getAntecessors().length - 1].getStep();
        }
        return null;
    }

    public ArrayList<OpenCondition> getTotalOpenConditions() {
        return this.openConditions;
    }

    public void getInternalCausalLinks(CausalLink[] cl) {
        POPInternalPlan p = this;
        int i = cl.length - 1;
        if (this.causalLink != null) {
            cl[i] = this.causalLink;
            --i;
        }
        while (p.father != null) {
            p = p.father;
            if (p.causalLink == null) continue;
            cl[i] = p.causalLink;
            --i;
        }
    }

    public void addCausalLinks() {
        if (!this.POP.getModifiedCausalLinks()) {
            POPInternalPlan p = this;
            if (this.causalLink != null) {
                this.POP.addCausalLink(this.causalLink);
            }
            while (p.father != null) {
                p = p.father;
                if (p.causalLink == null) continue;
                this.POP.addCausalLink(p.causalLink);
            }
            this.POP.setModifiedCausalLinks(true);
        }
    }

    public ArrayList<Ordering> getInternalOrderings() {
        ArrayList<Ordering> or = new ArrayList<Ordering>(3);
        POPInternalPlan p = this;
        if (this.ordering != null) {
            or.add(this.ordering);
        }
        while (p.father != null) {
            p = p.father;
            if (p.ordering == null) continue;
            or.add(p.ordering);
        }
        return or;
    }

    public void addOrderings() {
        if (!this.POP.getModifiedOrderings()) {
            POPInternalPlan p = this;
            if (this.ordering != null) {
                this.POP.addOrdering(this.ordering);
            }
            while (p.father != null) {
                p = p.father;
                if (p.ordering == null) continue;
                this.POP.addOrdering(p.ordering);
            }
            this.POP.setModifiedOrderings(true);
        }
    }

    public CustomArrayList<CausalLink> getTotalCausalLinks() {
        return this.POP.getTotalCausalLinks();
    }

    public CustomArrayList<Ordering> getTotalOrderings() {
        return this.POP.getTotalOrderings();
    }

    public int numSteps() {
        if (this.steps == -1) {
            this.steps = this.POP.getAntecessors().length + 1;
        }
        return this.steps;
    }

    public boolean isRoot() {
        return this.father == null;
    }

    public boolean isSolution() {
        if (this.step != null && this.step.getIndex() == 1) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        return this.father.isSolution();
    }

    Step getLatestStep() {
        POPInternalPlan aux = this;
        while (aux != null && aux.step == null) {
            aux = aux.father;
        }
        if (aux == null && this.isRoot()) {
            return this.POP.getAntecessors()[this.POP.getAntecessors().length - 1].getStep();
        }
        if (aux == null) {
            return this.step;
        }
        return aux.step;
    }

    POPInternalPlan(POPInternalPlan original, ExtendedPlanner thread) {
        this.POP = thread;
        this.father = original.father;
        this.step = original.step;
        this.causalLink = original.causalLink;
        this.openConditions = original.openConditions;
        this.threats = original.threats;
        this.ordering = original.ordering;
        this.steps = original.steps;
    }
}

