/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_planner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import org.agreement_technologies.common.map_planner.CausalLink;
import org.agreement_technologies.common.map_planner.Condition;
import org.agreement_technologies.common.map_planner.ExtendedPlanner;
import org.agreement_technologies.common.map_planner.IPlan;
import org.agreement_technologies.common.map_planner.Ordering;
import org.agreement_technologies.common.map_planner.Plan;
import org.agreement_technologies.common.map_planner.PlannerFactory;
import org.agreement_technologies.common.map_planner.Step;
import org.agreement_technologies.service.map_planner.POPInternalPlan;
import org.agreement_technologies.service.map_planner.Planner;
import org.agreement_technologies.service.map_planner.PlannerFactoryImp;
import org.agreement_technologies.service.map_planner.ProposalToSend;
import org.agreement_technologies.service.tools.CustomArrayList;

public class POPIncrementalPlan
implements IPlan {
    private String name;
    private POPIncrementalPlan father;
    private Step step;
    private ArrayList<Ordering> orderings;
    private CausalLink[] causalLinks;
    private int g;
    private int h;
    private int[] hPriv;
    private int hLan;
    private int numSteps;
    private double metric;
    private int[] totalOrder;
    private ExtendedPlanner POP;
    private boolean isSolution;

    public POPIncrementalPlan(POPInternalPlan p, POPIncrementalPlan prev, ExtendedPlanner planner) {
        this.POP = planner;
        this.father = prev;
        if (prev != null) {
            this.step = p.getLatestStep();
            this.numSteps = this.father.numSteps + 1;
        } else {
            this.step = this.POP.getInitialStep();
            this.numSteps = 2;
        }
        this.isSolution = false;
        this.orderings = p.getInternalOrderings();
        if (this.step == null && prev != null) {
            this.step = this.POP.getFinalStep();
            --this.numSteps;
            this.isSolution = true;
        }
        if (this.step != null) {
            this.causalLinks = new CausalLink[this.step.getPrecs().length];
            p.getInternalCausalLinks(this.causalLinks);
        }
        this.totalOrder = null;
        this.hPriv = null;
    }

    public POPIncrementalPlan(ProposalToSend pp, IPlan basePlan, PlannerFactoryImp configuration, ExtendedPlanner planner) {
        this.POP = planner;
        this.father = (POPIncrementalPlan)basePlan;
        this.h = pp.getH();
        this.hLan = pp.getHLand();
        this.g = this.father.g + 1;
        this.step = pp.getStep(configuration);
        this.numSteps = this.father.numSteps + (this.step != null ? 1 : 0);
        this.orderings = pp.getOrderings(configuration);
        this.causalLinks = pp.getCausalLinks(configuration, this.father, this.step, this.orderings);
        this.isSolution = pp.isSolution();
        this.totalOrder = null;
        this.metric = -1.0;
        this.hPriv = null;
    }

    public POPIncrementalPlan(String planName) {
        this.name = planName;
        this.totalOrder = null;
    }

    public void calculateCausalLinks() {
        this.POP.getTotalCausalLinks().clear();
        if (!this.isRoot()) {
            POPIncrementalPlan aux = this;
            while (!aux.isRoot()) {
                for (CausalLink c : aux.getCausalLinks()) {
                    this.POP.getTotalCausalLinks().add(c);
                }
                aux = aux.father;
            }
        }
        this.POP.setNumCausalLinks(this.POP.getTotalCausalLinks().size());
        this.POP.setModifiedCausalLinks(false);
    }

    public void calculateOrderings() {
        this.POP.getTotalOrderings().clear();
        if (!this.isRoot()) {
            POPIncrementalPlan aux = this;
            while (!aux.isRoot()) {
                for (Ordering o : aux.getOrderings()) {
                    this.POP.getTotalOrderings().add(o);
                }
                aux = aux.father;
            }
        }
        this.POP.setNumOrderings(this.POP.getTotalOrderings().size());
        this.POP.setModifiedOrderings(false);
    }

    public CausalLink[] getCausalLinks() {
        return this.causalLinks;
    }

    public ArrayList<Ordering> getOrderings() {
        return this.orderings;
    }

    public Step getStep() {
        return this.step;
    }

    @Override
    public POPIncrementalPlan getFather() {
        return this.father;
    }

    @Override
    public CustomArrayList<CausalLink> getTotalCausalLinks() {
        return this.POP.getTotalCausalLinks();
    }

    @Override
    public ArrayList<Step> getTotalSteps() {
        ArrayList<Step> st = new ArrayList<Step>();
        POPIncrementalPlan aux = this;
        while (!aux.isRoot()) {
            if (aux.step != null) {
                st.add(aux.step);
            }
            aux = aux.father;
        }
        ArrayList<Step> sti = new ArrayList<Step>(st.size() + 2);
        sti.add(this.POP.getInitialStep());
        sti.add(this.POP.getFinalStep());
        int bound = ((Step)st.get(0)).getIndex() == 1 ? 1 : 0;
        for (int i = st.size() - 1; i >= bound; --i) {
            sti.add((Step)st.get(i));
        }
        return sti;
    }

    @Override
    public double getMetric() {
        if (this.metric == -1.0) {
            this.metric = ((Planner)this.POP).evaluateMetric(this);
        }
        return this.metric;
    }

    @Override
    public CustomArrayList<Ordering> getTotalOrderings() {
        return this.POP.getTotalOrderings();
    }

    @Override
    public Step getInitialStep() {
        return this.POP.getInitialStep();
    }

    @Override
    public Step getFinalStep() {
        return this.POP.getFinalStep();
    }

    @Override
    public boolean isSolution() {
        return this.isSolution;
    }

    @Override
    public int numSteps() {
        return this.numSteps;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(int n, Plan father) {
        this.name = this.isRoot() ? "\u03a00" : this.father.getName() + "-" + n;
    }

    @Override
    public void setG(int g) {
        this.g = g;
    }

    @Override
    public boolean isRoot() {
        return this.father == null;
    }

    @Override
    public int getG() {
        return this.g;
    }

    @Override
    public int getH() {
        return this.h;
    }

    public String toString() {
        String res = this.name + " (H=" + this.h + ",Hl=" + this.hLan + ",Hp=";
        if (this.hPriv == null || this.hPriv.length == 0) {
            res = res + "none";
        } else {
            res = res + this.hPriv[0];
            for (int i = 1; i < this.hPriv.length; ++i) {
                res = res + "," + this.hPriv[i];
            }
        }
        return res + ")";
    }

    @Override
    public ArrayList<CausalLink> getCausalLinksArray() {
        POPIncrementalPlan aux = this;
        ArrayList<CausalLink> cl = new ArrayList<CausalLink>();
        while (!aux.isRoot()) {
            if (aux.getCausalLinks() != null) {
                for (CausalLink l : aux.getCausalLinks()) {
                    cl.add(l);
                }
            }
            aux = aux.father;
        }
        return cl;
    }

    @Override
    public ArrayList<Step> getStepsArray() {
        POPIncrementalPlan aux = this;
        ArrayList<Step> s = new ArrayList<Step>();
        ArrayList<POPIncrementalPlan> p = new ArrayList<POPIncrementalPlan>();
        while (!aux.isRoot()) {
            p.add(aux);
            aux = aux.father;
        }
        s.add(this.POP.getInitialStep());
        s.add(this.POP.getFinalStep());
        for (int i = p.size() - 1; i >= 0; --i) {
            if (((POPIncrementalPlan)p.get((int)i)).isSolution) continue;
            s.add(((POPIncrementalPlan)p.get(i)).getStep());
        }
        return s;
    }

    @Override
    public ArrayList<Ordering> getOrderingsArray() {
        POPIncrementalPlan aux = this;
        ArrayList<Ordering> or = new ArrayList<Ordering>();
        while (!aux.isRoot()) {
            if (aux.getOrderings() != null) {
                for (Ordering o : aux.getOrderings()) {
                    or.add(o);
                }
            }
            aux = aux.father;
        }
        return or;
    }

    public boolean equals(Object x) {
        return ((POPIncrementalPlan)x).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int[] linearization() {
        if (this.totalOrder != null) {
            return this.totalOrder;
        }
        int index = 0;
        this.totalOrder = new int[this.numSteps - 1];
        boolean[] visited = new boolean[this.numSteps];
        HashMap<Integer, ArrayList<Integer>> orderings = new HashMap<Integer, ArrayList<Integer>>(this.numSteps);
        HashMap<Integer, POPIncrementalPlan> incPlans = new HashMap<Integer, POPIncrementalPlan>(this.numSteps);
        POPIncrementalPlan p = this;
        while (p != null) {
            for (Ordering o : p.orderings) {
                ArrayList<Integer> prev = (ArrayList<Integer>)orderings.get(o.getIndex2());
                if (prev == null) {
                    prev = new ArrayList<Integer>();
                    prev.add(o.getIndex1());
                    orderings.put(o.getIndex2(), prev);
                    continue;
                }
                if (prev.contains(o.getIndex1())) continue;
                prev.add(o.getIndex1());
            }
            incPlans.put(p.step.getIndex(), p);
            p = p.father;
        }
        p = this;
        while (p.father != null) {
            if (!visited[p.step.getIndex()]) {
                index = POPIncrementalPlan.linearization(p, this.totalOrder, index, visited, orderings, incPlans);
            }
            p = p.father;
        }
        return this.totalOrder;
    }

    private static int linearization(POPIncrementalPlan p, int[] toPlan, int index, boolean[] visited, HashMap<Integer, ArrayList<Integer>> orderings, HashMap<Integer, POPIncrementalPlan> incPlans) {
        int s = p.getStep().getIndex();
        visited[s] = true;
        for (CausalLink cl : p.causalLinks) {
            if (visited[cl.getIndex1()]) continue;
            index = POPIncrementalPlan.linearization(incPlans.get(cl.getIndex1()), toPlan, index, visited, orderings, incPlans);
        }
        ArrayList<Integer> prev = orderings.get(s);
        if (prev != null) {
            for (Integer s1 : prev) {
                if (visited[s1]) continue;
                index = POPIncrementalPlan.linearization(incPlans.get(s1), toPlan, index, visited, orderings, incPlans);
            }
        }
        if (s != 1) {
            toPlan[index++] = s;
        }
        return index;
    }

    @Override
    public HashMap<String, String> computeState(int[] totalOrder, PlannerFactory pf) {
        HashMap<String, String> varValue = new HashMap<String, String>();
        ArrayList<Step> stepList = this.getStepsArray();
        for (int step : totalOrder) {
            Step a = stepList.get(step);
            for (Condition eff : a.getEffs()) {
                String value;
                String var = pf.getVarNameFromCode(eff.getVarCode());
                if (var == null || (value = pf.getValueFromCode(eff.getValueCode())) == null) continue;
                varValue.put(var, value);
            }
        }
        return varValue;
    }

    @Override
    public HashMap<String, ArrayList<String>> computeMultiState(int[] totalOrder, PlannerFactory pf) {
        HashMap<String, ArrayList<String>> varValue = new HashMap<String, ArrayList<String>>();
        ArrayList<Step> stepList = this.getStepsArray();
        for (int step : totalOrder) {
            Step a = stepList.get(step);
            for (Condition eff : a.getEffs()) {
                ArrayList<Object> list;
                String value;
                String v = pf.getVarNameFromCode(eff.getVarCode());
                if (v == null || (value = pf.getValueFromCode(eff.getValueCode())) == null) continue;
                if (varValue.containsKey(v)) {
                    list = varValue.get(v);
                    list.set(0, value);
                    continue;
                }
                list = new ArrayList();
                list.add(value);
                varValue.put(v, list);
            }
        }
        return varValue;
    }

    @Override
    public Step lastAddedStep() {
        return this.step;
    }

    @Override
    public int countSteps() {
        int n = 0;
        POPIncrementalPlan father = this;
        while (!father.isRoot()) {
            if (father.getStep() != null) {
                ++n;
            }
            father = father.getFather();
        }
        return n - 1;
    }

    @Override
    public int getHpriv(int prefIndex) {
        if (this.hPriv == null) {
            return 0;
        }
        return this.hPriv[prefIndex];
    }

    @Override
    public int getHLan() {
        return this.hLan;
    }

    @Override
    public void setH(int h, int hLan) {
        this.h = h;
        this.hLan = hLan;
    }

    @Override
    public void setHPriv(int h, int prefIndex) {
        if (this.hPriv == null) {
            this.hPriv = new int[prefIndex + 1];
        } else if (this.hPriv.length <= prefIndex) {
            int[] tmp = new int[prefIndex + 1];
            System.arraycopy(this.hPriv, 0, tmp, 0, this.hPriv.length);
            this.hPriv = tmp;
        }
        this.hPriv[prefIndex] = h;
    }

    void setMetric(double metric) {
        this.metric = metric;
    }

    private int calculateSteps() {
        int steps = 0;
        for (POPIncrementalPlan father = this; father != null; father = father.getFather()) {
            ++steps;
        }
        return steps;
    }

    public double computeMakespan() {
        if (this.g == 0) {
            this.g = this.calculateSteps();
        }
        ArrayList[] adjacents = new ArrayList[this.g];
        for (int i = 0; i < adjacents.length; ++i) {
            adjacents[i] = new ArrayList();
        }
        ArrayList<Ordering> orderings = this.getOrderingsArray();
        ArrayList<CausalLink> causalLinks = this.getCausalLinksArray();
        for (Ordering po : orderings) {
            if (adjacents[po.getIndex1()].contains(po.getIndex2())) continue;
            adjacents[po.getIndex1()].add(po.getIndex2());
        }
        for (CausalLink cl : causalLinks) {
            if (adjacents[cl.getIndex1()].contains(cl.getIndex2())) continue;
            adjacents[cl.getIndex1()].add(cl.getIndex2());
        }
        int[] distance = new int[adjacents.length];
        this.computeMaxDistance(0, distance, adjacents);
        if (this.step.getIndex() == 1) {
            return distance[1] - 1;
        }
        int max = 1;
        for (int i = 2; i < distance.length; ++i) {
            if (distance[max] >= distance[i]) continue;
            max = i;
        }
        return distance[max];
    }

    private void computeMaxDistance(int v, int[] distance, ArrayList<Integer>[] adjacents) {
        for (Integer w : adjacents[v]) {
            if (distance[w] > distance[v]) continue;
            distance[w.intValue()] = distance[v] + 1;
            this.computeMaxDistance(w, distance, adjacents);
        }
    }

    @Override
    public Plan getParentPlan() {
        return this.father;
    }

    @Override
    public int[] computeCodeState(int[] totalOrder, int numVars) {
        int[] state = new int[numVars];
        ArrayList<Step> stepList = this.getStepsArray();
        for (int step : totalOrder) {
            Step a = stepList.get(step);
            for (Condition eff : a.getEffs()) {
                state[eff.getVarCode()] = eff.getValueCode();
            }
        }
        return state;
    }

    @Override
    public void printPlan(int output, String myAgent, ArrayList<String> agents) {
        block11: {
            int i;
            int[] actions;
            ArrayList<Step> steps;
            int makespan;
            block10: {
                makespan = 0;
                steps = this.getTotalSteps();
                switch (output) {
                    case 1: {
                        actions = this.linearizePlan(1, agents);
                        break;
                    }
                    case 2: {
                        actions = this.linearizePlan(2, agents);
                        break;
                    }
                    default: {
                        actions = this.linearizePlan(0, agents);
                    }
                }
                for (i = 0; i < actions.length; ++i) {
                    if (actions[i] <= makespan) continue;
                    makespan = actions[i];
                }
                if (output != 2) break block10;
                for (i = 0; i <= makespan; ++i) {
                    for (int j = 2; j < actions.length; ++j) {
                        if (actions[j] != i || !steps.get(j).getAgent().equals(myAgent)) continue;
                        System.out.println(i + ": (" + steps.get(j).getActionName() + ")");
                    }
                }
                break block11;
            }
            if (!myAgent.equals(agents.get(0))) break block11;
            for (i = 0; i <= makespan; ++i) {
                for (int j = 2; j < actions.length; ++j) {
                    if (actions[j] != i) continue;
                    if (output == 1) {
                        System.out.println("(" + steps.get(j).getActionName() + ")");
                        continue;
                    }
                    System.out.println(i + ": (" + steps.get(j).getActionName() + ")");
                }
            }
        }
    }

    private int[] linearizePlan(int mode, ArrayList<String> agents) {
        int i;
        int[] actions = new int[this.getTotalSteps().size()];
        ArrayList<Step> steps = this.getTotalSteps();
        Hashtable predecessors = new Hashtable();
        for (i = 0; i < steps.size(); ++i) {
            predecessors.put(i, new ArrayList());
            actions[i] = -2;
        }
        actions[0] = -1;
        for (Ordering o : this.getTotalOrderings()) {
            ((ArrayList)predecessors.get(o.getIndex2())).add(o.getIndex1());
        }
        for (CausalLink l : this.getTotalCausalLinks()) {
            ((ArrayList)predecessors.get(l.getStep2().getIndex())).add(l.getStep1().getIndex());
        }
        switch (mode) {
            case 1: {
                block7: for (int level = 0; level <= actions.length - 2; ++level) {
                    for (i = 2; i < actions.length; ++i) {
                        if (actions[i] != -2) continue;
                        boolean assign = true;
                        ArrayList pre = (ArrayList)predecessors.get(i);
                        Iterator i$ = pre.iterator();
                        while (i$.hasNext()) {
                            int p = (Integer)i$.next();
                            if (actions[p] != -2) continue;
                            assign = false;
                            break;
                        }
                        if (!assign) continue;
                        actions[i] = level;
                        continue block7;
                    }
                }
                break;
            }
            case 2: {
                int[] succSequenceSizes = new int[actions.length];
                for (i = 0; i < succSequenceSizes.length; ++i) {
                    succSequenceSizes[i] = -1;
                }
                Hashtable successors = new Hashtable();
                for (i = 0; i < steps.size(); ++i) {
                    successors.put(i, new ArrayList());
                }
                for (Ordering o : this.getTotalOrderings()) {
                    ((ArrayList)successors.get(o.getIndex1())).add(o.getIndex2());
                }
                for (CausalLink l : this.getTotalCausalLinks()) {
                    ((ArrayList)successors.get(l.getStep1().getIndex())).add(l.getStep2().getIndex());
                }
                for (i = 2; i < succSequenceSizes.length; ++i) {
                    if (!((ArrayList)successors.get(i)).isEmpty()) continue;
                    succSequenceSizes[i] = 0;
                }
                boolean completed = false;
                while (!completed) {
                    for (i = 2; i < succSequenceSizes.length; ++i) {
                        int j;
                        if (succSequenceSizes[i] != -1) continue;
                        ArrayList sequence = (ArrayList)successors.get(i);
                        boolean exit = false;
                        for (j = 0; j < sequence.size(); ++j) {
                            if (succSequenceSizes[(Integer)sequence.get(j)] != -1) continue;
                            exit = true;
                            break;
                        }
                        if (exit) continue;
                        int max = Integer.MIN_VALUE;
                        for (j = 0; j < sequence.size(); ++j) {
                            if (succSequenceSizes[(Integer)sequence.get(j)] <= max) continue;
                            max = succSequenceSizes[(Integer)sequence.get(j)];
                        }
                        succSequenceSizes[i] = max + 1;
                    }
                    boolean notCalculated = false;
                    for (i = 2; i < succSequenceSizes.length; ++i) {
                        if (succSequenceSizes[i] != -1) continue;
                        notCalculated = true;
                        break;
                    }
                    if (notCalculated) continue;
                    completed = true;
                }
                int scheduled = 0;
                int level = 0;
                while (scheduled < actions.length - 2) {
                    for (String ag : agents) {
                        int bestAction = -1;
                        int longestSuccessorSequence = Integer.MIN_VALUE;
                        for (i = 2; i < actions.length; ++i) {
                            if (actions[i] != -2 || !steps.get(i).getAgent().equals(ag)) continue;
                            boolean assign = true;
                            ArrayList pre = (ArrayList)predecessors.get(i);
                            Iterator i$ = pre.iterator();
                            while (i$.hasNext()) {
                                int p = (Integer)i$.next();
                                if (actions[p] != -2 && actions[p] != level) continue;
                                assign = false;
                                break;
                            }
                            if (!assign || succSequenceSizes[i] <= longestSuccessorSequence) continue;
                            bestAction = i;
                            longestSuccessorSequence = succSequenceSizes[i];
                        }
                        if (bestAction == -1) continue;
                        actions[bestAction] = level;
                        ++scheduled;
                    }
                    ++level;
                }
                break;
            }
            default: {
                int level = 0;
                int assigned = 0;
                while (assigned < actions.length - 2) {
                    for (i = 2; i < actions.length; ++i) {
                        if (actions[i] != -2) continue;
                        boolean assign = true;
                        ArrayList pre = (ArrayList)predecessors.get(i);
                        Iterator i$ = pre.iterator();
                        while (i$.hasNext()) {
                            int p = (Integer)i$.next();
                            if (actions[p] != -2 && actions[p] != level) continue;
                            assign = false;
                            break;
                        }
                        if (!assign) continue;
                        actions[i] = level;
                        ++assigned;
                    }
                    ++level;
                }
                break block0;
            }
        }
        return actions;
    }
}

