/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_planner;

import java.util.ArrayList;
import org.agreement_technologies.common.map_communication.AgentCommunication;
import org.agreement_technologies.common.map_communication.PlanningAgentListener;
import org.agreement_technologies.common.map_heuristic.Heuristic;
import org.agreement_technologies.common.map_planner.IPlan;
import org.agreement_technologies.common.map_planner.OpenCondition;
import org.agreement_technologies.service.map_planner.POPAction;
import org.agreement_technologies.service.map_planner.POPIncrementalPlan;
import org.agreement_technologies.service.map_planner.POPInternalPlan;
import org.agreement_technologies.service.map_planner.POPMatrix;
import org.agreement_technologies.service.map_planner.POPSearchMethodTwoQueues;
import org.agreement_technologies.service.map_planner.POPStep;
import org.agreement_technologies.service.map_planner.Planner;
import org.agreement_technologies.service.map_planner.PlannerFactoryImp;
import org.agreement_technologies.service.map_planner.StateMemoization;
import org.agreement_technologies.service.tools.CustomArrayList;

public class POP
extends Planner {
    public POP(PlannerFactoryImp conf, POPStep initial, POPStep last, ArrayList<OpenCondition> goals, Heuristic h, AgentCommunication comm, PlanningAgentListener agentListener, int searchType) {
        super(comm);
        this.configuration = conf;
        this.solutionChecker = this.configuration.getSolutionChecker();
        this.agentListener = agentListener;
        this.heuristic = h;
        this.comm = comm;
        this.myAgent = conf.getAgent();
        this.parent = this;
        this.setInitialStep(initial);
        this.setFinalStep(last);
        this.initialInternalPlan = new POPInternalPlan(null, null, null, null, goals, null, null, false, this);
        this.initialIncrementalPlan = new POPIncrementalPlan(this.initialInternalPlan, null, this);
        if (agentListener != null) {
            agentListener.newPlan(this.initialIncrementalPlan, this.configuration);
        }
        this.successors = new ArrayList();
        this.initialIncrementalPlan.setName(0, null);
        this.searchTree = new POPSearchMethodTwoQueues(this.initialIncrementalPlan);
        this.planSelection = this.configuration.getNegotiationFactory().getNegotiationMethod(comm, this.searchTree);
        this.totalCausalLinks = new CustomArrayList(50);
        this.totalOrderings = new CustomArrayList(50);
        this.matrix = new POPMatrix(20);
        this.memoization = new StateMemoization(this.configuration.getNumGlobalVariables());
    }

    @Override
    public ArrayList<IPlan> POPForwardLoop() {
        ArrayList<IPlan> refinements = new ArrayList<IPlan>();
        this.hashEffects = null;
        POPInternalPlan auxInternal = this.currentInternal;
        ArrayList<POPAction> applicableActions = super.calculateApplicableActions();
        for (POPAction act : applicableActions) {
            this.currentInternal = auxInternal;
            if (!this.internalSearchTree.isEmpty()) {
                this.internalSearchTree.getNextPlan();
            }
            this.internalSearchTree.addPlan(this.currentInternal);
            POPStep step = new POPStep(act, this.currentInternal.numSteps(), this.myAgent);
            ArrayList<IPlan> succ = this.solveAction(step);
            if (succ.size() <= 0) continue;
            for (IPlan s : succ) {
                refinements.add(s);
            }
            succ.clear();
        }
        this.restoreCausalLinks();
        this.restoreOrderings();
        return refinements;
    }

    @Override
    public IPlan sendProposalsMonoagent(ArrayList<IPlan> proposals, IPlan basePlan) {
        IPlan solution = null;
        for (int i = 0; i < proposals.size(); ++i) {
            IPlan plan = proposals.get(i);
            if (!plan.isSolution() && this.memoization.search((POPIncrementalPlan)plan) != null) continue;
            plan.setName(i, basePlan);
            if (plan.isSolution()) {
                plan.setH(0, 0);
            } else {
                this.heuristic.evaluatePlan(plan, 0);
            }
            this.searchTree.addPlan(plan);
            if (!plan.isSolution()) {
                this.memoization.add((POPIncrementalPlan)plan);
            } else {
                solution = plan;
            }
            if (this.agentListener == null) continue;
            this.agentListener.newPlan(plan, this.configuration);
        }
        return solution;
    }

    @Override
    public void evaluatePlan(IPlan plan, ArrayList<Planner.EvaluationThread> evThreads) {
    }
}

