/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_planner;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.agreement_technologies.service.map_planner.ProposalToSend;

public class HeuristicAdjustment
implements Serializable {
    private static final long serialVersionUID = 8516447848966468906L;
    private final HashMap<String, ArrayList<Integer>> newLandmarks;
    private ArrayList<ProposalToSend> proposals;

    public HeuristicAdjustment(int size) {
        this.newLandmarks = new HashMap(size);
        this.proposals = null;
    }

    public void add(String name, ArrayList<Integer> newLandmarks) {
        this.newLandmarks.put(name, newLandmarks);
    }

    public void addOwnProposals(ArrayList<ProposalToSend> proposals) {
        this.proposals = proposals;
    }

    public ArrayList<ProposalToSend> getProposals() {
        return this.proposals;
    }

    public void merge(String name, ArrayList<Integer> newLand) {
        if (newLand == null || newLand.isEmpty()) {
            return;
        }
        ArrayList<Integer> storedLand = this.newLandmarks.get(name);
        if (storedLand == null) {
            this.add(name, newLand);
        } else {
            for (Integer l : newLand) {
                if (storedLand.contains(l)) continue;
                storedLand.add(l);
            }
        }
    }

    public int getNumNewLandmarks(String name) {
        ArrayList<Integer> storedLand = this.newLandmarks.get(name);
        if (storedLand == null) {
            return 0;
        }
        return storedLand.size();
    }

    public String newLandmarksList(String name) {
        ArrayList<Integer> storedLand = this.newLandmarks.get(name);
        return storedLand == null ? "[]" : storedLand.toString();
    }

    public ArrayList<Integer> getNewLandmarks(String name) {
        return this.newLandmarks.get(name);
    }

    public ArrayList<String> proposalsWithAdjustments() {
        ArrayList<String> plans = new ArrayList<String>();
        for (String name : this.newLandmarks.keySet()) {
            if (this.newLandmarks.get(name).isEmpty()) continue;
            plans.add(name);
        }
        return plans;
    }
}

