/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_parser;

import java.text.ParseException;
import java.util.ArrayList;
import org.agreement_technologies.common.map_parser.Congestion;
import org.agreement_technologies.common.map_parser.CongestionFluent;
import org.agreement_technologies.common.map_parser.CongestionPenalty;
import org.agreement_technologies.common.map_parser.CongestionUsage;
import org.agreement_technologies.common.map_parser.Fact;
import org.agreement_technologies.common.map_parser.Metric;
import org.agreement_technologies.common.map_parser.NumericExpression;
import org.agreement_technologies.common.map_parser.NumericFact;
import org.agreement_technologies.common.map_parser.Task;
import org.agreement_technologies.service.map_parser.SynAnalyzer;
import org.agreement_technologies.service.map_parser.TaskTypes;

public class TaskImp
implements Task {
    static final int OBJECT_TYPE = 0;
    static final int BOOLEAN_TYPE = 1;
    static final int AGENT_TYPE = 2;
    static final int NUMBER_TYPE = 3;
    static final int TRUE_VALUE = 0;
    static final int FALSE_VALUE = 1;
    String domainName;
    String problemName;
    ArrayList<String> requirements;
    ArrayList<Type> types = new ArrayList();
    ArrayList<Value> values;
    ArrayList<Variable> predicates;
    ArrayList<Function> functions;
    ArrayList<Operator> operators;
    ArrayList<SharedData> sharedData;
    ArrayList<Assignment> init;
    ArrayList<Operator> beliefs;
    ArrayList<Assignment> gGoals;
    ArrayList<PreferenceImp> preferences;
    ArrayList<CongestionImp> congestions;
    MetricImp metric;
    double selfInterest;
    double metricThreshold;

    public TaskImp() {
        this.types.add(new Type("object"));
        this.types.add(new Type("boolean"));
        this.types.add(new Type("agent"));
        this.types.add(new Type("number"));
        this.requirements = new ArrayList();
        this.values = new ArrayList();
        Value bv = new Value("true");
        bv.types.add(this.types.get(1));
        this.values.add(bv);
        bv = new Value("false");
        bv.types.add(this.types.get(1));
        this.values.add(bv);
        this.predicates = new ArrayList();
        this.functions = new ArrayList();
        this.operators = new ArrayList();
        this.sharedData = new ArrayList();
        this.init = new ArrayList();
        this.beliefs = new ArrayList();
        this.gGoals = new ArrayList();
        this.preferences = new ArrayList();
        this.congestions = new ArrayList();
        this.metric = null;
        this.selfInterest = 0.0;
        this.metricThreshold = 0.0;
    }

    public void addRequirement(String reqName) {
        if (!this.requirements.contains(reqName)) {
            this.requirements.add(reqName);
        }
    }

    public boolean existVariable(Variable v) {
        if (this.predicates.contains(v)) {
            return true;
        }
        return this.functions.contains(new Function(v, false));
    }

    public Type getAgentType() {
        int typeIndex = this.types.indexOf(new Type("agent"));
        if (typeIndex == -1) {
            return null;
        }
        return this.types.get(typeIndex);
    }

    @Override
    public String getDomainName() {
        return this.domainName;
    }

    @Override
    public String getProblemName() {
        return this.problemName;
    }

    @Override
    public String[] getRequirements() {
        String[] res = new String[this.requirements.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.requirements.get(i);
        }
        return res;
    }

    @Override
    public String[] getTypes() {
        String[] res = new String[this.types.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.types.get((int)i).name;
        }
        return res;
    }

    @Override
    public String[] getParentTypes(String type) {
        int index = this.types.indexOf(new Type(type));
        if (index == -1) {
            return null;
        }
        Type t = this.types.get(index);
        String[] res = new String[t.parentTypes.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = t.parentTypes.get((int)i).name;
        }
        return res;
    }

    @Override
    public String[] getObjects() {
        String[] res = new String[this.values.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.values.get((int)i).name;
        }
        return res;
    }

    @Override
    public String[] getObjectTypes(String objName) {
        int index = this.values.indexOf(new Value(objName));
        if (index == -1) {
            return null;
        }
        Value v = this.values.get(index);
        String[] res = new String[v.types.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = v.types.get((int)i).name;
        }
        return res;
    }

    @Override
    public org.agreement_technologies.common.map_parser.Function[] getFunctions() {
        int t;
        Value param;
        TaskTypes.FunctionImp f;
        Variable v;
        int i;
        org.agreement_technologies.common.map_parser.Function[] res = new TaskTypes.FunctionImp[this.predicates.size() + this.functions.size()];
        for (i = 0; i < this.predicates.size(); ++i) {
            v = this.predicates.get(i);
            f = new TaskTypes.FunctionImp(v.name, false);
            f.parameters = new TaskTypes.ParameterImp[v.params.size()];
            for (int p = 0; p < f.parameters.length; ++p) {
                param = v.params.get(p);
                f.parameters[p] = new TaskTypes.ParameterImp(param.name);
                f.parameters[p].types = new String[param.types.size()];
                for (t = 0; t < param.types.size(); ++t) {
                    f.parameters[p].types[t] = param.types.get((int)t).name;
                }
            }
            f.domain = new String[1];
            f.domain[0] = this.types.get((int)1).name;
            res[i] = f;
        }
        for (i = 0; i < this.functions.size(); ++i) {
            Function fnc = this.functions.get(i);
            v = fnc.var;
            f = new TaskTypes.FunctionImp(v.name, fnc.multiFunction);
            f.parameters = new TaskTypes.ParameterImp[v.params.size()];
            for (int p = 0; p < f.parameters.length; ++p) {
                param = v.params.get(p);
                f.parameters[p] = new TaskTypes.ParameterImp(param.name);
                f.parameters[p].types = new String[param.types.size()];
                for (int t2 = 0; t2 < param.types.size(); ++t2) {
                    f.parameters[p].types[t2] = param.types.get((int)t2).name;
                }
            }
            f.domain = new String[fnc.domain.size()];
            for (t = 0; t < f.domain.length; ++t) {
                f.domain[t] = fnc.domain.get((int)t).name;
            }
            res[i + this.predicates.size()] = f;
        }
        return res;
    }

    @Override
    public org.agreement_technologies.common.map_parser.Operator[] getOperators() {
        org.agreement_technologies.common.map_parser.Operator[] res = new TaskTypes.OperatorImp[this.operators.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.getOperator(this.operators.get(i));
        }
        return res;
    }

    private TaskTypes.OperatorImp getOperator(Operator operator) {
        TaskTypes.OperatorImp op = new TaskTypes.OperatorImp(operator.name, operator.preference);
        op.parameters = new TaskTypes.ParameterImp[operator.params.size()];
        for (int i = 0; i < op.parameters.length; ++i) {
            Value p = operator.params.get(i);
            op.parameters[i] = new TaskTypes.ParameterImp(p.name);
            op.parameters[i].types = new String[p.types.size()];
            for (int t = 0; t < p.types.size(); ++t) {
                op.parameters[i].types[t] = p.types.get((int)t).name;
            }
        }
        op.prec = this.getOperatorCondition(operator.prec, true);
        op.eff = this.getOperatorCondition(operator.eff, false);
        op.numEff = this.getOperatorNumericEffects(operator.eff);
        return op;
    }

    private TaskTypes.ConditionImp[] getOperatorCondition(ArrayList<OperatorCondition> cond, boolean cmp) {
        int numConditions = 0;
        for (OperatorCondition oc : cond) {
            if (oc.type == OperatorConditionType.CT_INCREASE) continue;
            ++numConditions;
        }
        TaskTypes.ConditionImp[] res = new TaskTypes.ConditionImp[numConditions];
        numConditions = 0;
        for (OperatorCondition oc : cond) {
            if (oc.type == OperatorConditionType.CT_INCREASE) continue;
            Variable varCond = null;
            Function fncCond = null;
            int index = this.predicates.indexOf(new Variable(oc.var.name));
            if (index == -1) {
                index = this.functions.indexOf(new Function(new Variable(oc.var.name), false));
                fncCond = this.functions.get(index);
            } else {
                varCond = this.predicates.get(index);
            }
            res[numConditions] = new TaskTypes.ConditionImp();
            switch (oc.type) {
                case CT_NONE: {
                    if (cmp) {
                        res[numConditions].type = 0;
                        break;
                    }
                    res[numConditions].type = 4;
                    break;
                }
                case CT_EQUAL: {
                    if (oc.neg) {
                        res[numConditions].type = 1;
                        break;
                    }
                    res[numConditions].type = 0;
                    break;
                }
                case CT_MEMBER: {
                    if (oc.neg) {
                        res[numConditions].type = 3;
                        break;
                    }
                    res[numConditions].type = 2;
                    break;
                }
                case CT_ASSIGN: {
                    res[numConditions].type = 4;
                    break;
                }
                case CT_ADD: {
                    res[numConditions].type = 5;
                    break;
                }
                case CT_DEL: {
                    res[numConditions].type = 6;
                }
            }
            res[numConditions].fnc = new TaskTypes.FunctionImp(oc.var.name, fncCond != null && fncCond.multiFunction);
            res[numConditions].fnc.parameters = new TaskTypes.ParameterImp[oc.var.params.size()];
            for (int p = 0; p < oc.var.params.size(); ++p) {
                Value param = oc.var.params.get(p);
                res[numConditions].fnc.parameters[p] = new TaskTypes.ParameterImp(param.name);
                res[numConditions].fnc.parameters[p].types = new String[param.types.size()];
                for (int t = 0; t < param.types.size(); ++t) {
                    res[numConditions].fnc.parameters[p].types[t] = param.types.get((int)t).name;
                }
            }
            if (varCond != null) {
                res[numConditions].fnc.domain = new String[1];
                res[numConditions].fnc.domain[0] = this.types.get((int)1).name;
                res[numConditions].value = oc.neg ? this.values.get((int)1).name : this.values.get((int)0).name;
            } else {
                res[numConditions].fnc.domain = new String[fncCond.domain.size()];
                for (int t = 0; t < res[numConditions].fnc.domain.length; ++t) {
                    res[numConditions].fnc.domain[t] = fncCond.domain.get((int)t).name;
                }
                res[numConditions].value = oc.value.name;
            }
            ++numConditions;
        }
        return res;
    }

    @Override
    public org.agreement_technologies.common.map_parser.SharedData[] getSharedData() {
        org.agreement_technologies.common.map_parser.SharedData[] sd = new TaskTypes.SharedDataImp[this.sharedData.size()];
        for (int i = 0; i < sd.length; ++i) {
            SharedData sData = this.sharedData.get(i);
            sd[i] = new TaskTypes.SharedDataImp();
            Variable v = sData.var != null ? sData.var : sData.fnc.var;
            ((TaskTypes.SharedDataImp)sd[i]).fnc = new TaskTypes.FunctionImp(v.name, sData.fnc != null && sData.fnc.multiFunction);
            ((TaskTypes.SharedDataImp)sd[i]).fnc.parameters = new TaskTypes.ParameterImp[v.params.size()];
            for (int p = 0; p < v.params.size(); ++p) {
                Value param = v.params.get(p);
                ((TaskTypes.SharedDataImp)sd[i]).fnc.parameters[p] = new TaskTypes.ParameterImp(param.name);
                ((TaskTypes.SharedDataImp)sd[i]).fnc.parameters[p].types = new String[param.types.size()];
                for (int t = 0; t < param.types.size(); ++t) {
                    ((TaskTypes.SharedDataImp)sd[i]).fnc.parameters[p].types[t] = param.types.get((int)t).name;
                }
            }
            if (sData.fnc == null) {
                ((TaskTypes.SharedDataImp)sd[i]).fnc.domain = new String[1];
                ((TaskTypes.SharedDataImp)sd[i]).fnc.domain[0] = this.types.get((int)1).name;
            } else {
                ((TaskTypes.SharedDataImp)sd[i]).fnc.domain = new String[sData.fnc.domain.size()];
                for (int t = 0; t < ((TaskTypes.SharedDataImp)sd[i]).fnc.domain.length; ++t) {
                    ((TaskTypes.SharedDataImp)sd[i]).fnc.domain[t] = sData.fnc.domain.get((int)t).name;
                }
            }
            ((TaskTypes.SharedDataImp)sd[i]).agents = new String[sData.agents.size()];
            for (int a = 0; a < ((TaskTypes.SharedDataImp)sd[i]).agents.length; ++a) {
                ((TaskTypes.SharedDataImp)sd[i]).agents[a] = sData.agents.get((int)a).name;
            }
        }
        return sd;
    }

    @Override
    public Fact[] getInit() {
        Fact[] res = new TaskTypes.FactImp[this.init.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.getFact(this.init.get(i));
        }
        return res;
    }

    private TaskTypes.FactImp getFact(Assignment as) {
        int i;
        Variable v = as.var != null ? as.var : as.fnc.var;
        TaskTypes.FactImp f = new TaskTypes.FactImp(v.name, as.neg);
        f.parameters = new String[as.params.size()];
        for (i = 0; i < f.parameters.length; ++i) {
            Value param = as.params.get(i);
            f.parameters[i] = param.name;
        }
        f.values = new String[as.values.size()];
        for (i = 0; i < f.values.length; ++i) {
            f.values[i] = as.values.get((int)i).name;
        }
        return f;
    }

    @Override
    public org.agreement_technologies.common.map_parser.Operator[] getBeliefs() {
        org.agreement_technologies.common.map_parser.Operator[] res = new TaskTypes.OperatorImp[this.beliefs.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.getOperator(this.beliefs.get(i));
        }
        return res;
    }

    @Override
    public Fact[] getGoals() {
        Fact[] res = new TaskTypes.FactImp[this.gGoals.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.getFact(this.gGoals.get(i));
        }
        return res;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("(domain ").append(this.domainName).append(")\n");
        s.append("(problem ").append(this.problemName).append(")\n");
        s.append("(requirements ").append(this.toString(this.getRequirements())).append(")\n");
        s.append("(types\n");
        for (String string : this.getTypes()) {
            s.append("\t").append(string);
            if (this.getParentTypes(string).length == 0) {
                s.append("\n");
                continue;
            }
            s.append(" - ").append(this.toString(this.getParentTypes(string))).append("\n");
        }
        s.append(")\n(objects\n");
        for (String string : this.getObjects()) {
            s.append("\t").append(string);
            if (this.getObjectTypes(string).length == 0) {
                s.append("\n");
                continue;
            }
            s.append(" - ").append(this.toString(this.getObjectTypes(string))).append("\n");
        }
        s.append(")\n(functions\n");
        for (org.agreement_technologies.common.map_parser.Function function : this.getFunctions()) {
            s.append("\t").append(function).append("\n");
        }
        for (org.agreement_technologies.common.map_parser.Operator operator : this.getOperators()) {
            s.append(operator).append("\n");
        }
        s.append("(shared-data\n");
        for (org.agreement_technologies.common.map_parser.SharedData sharedData : this.getSharedData()) {
            s.append("\t").append(sharedData).append("\n");
        }
        s.append(")\n(init\n");
        for (Fact fact : this.getInit()) {
            s.append("\t").append(fact).append("\n");
        }
        s.append(")\n");
        for (org.agreement_technologies.common.map_parser.Operator operator : this.getBeliefs()) {
            s.append(operator).append("\n");
        }
        s.append("(global-goal\n");
        for (Fact fact : this.getGoals()) {
            s.append("\t").append(fact).append("\n");
        }
        s.append(")\n");
        return s.toString();
    }

    private String toString(String[] v) {
        if (v.length == 0) {
            return "";
        }
        String res = v[0];
        for (int i = 1; i < v.length; ++i) {
            res = res + " " + v[i];
        }
        return res;
    }

    private TaskTypes.NumericEffectImp[] getOperatorNumericEffects(ArrayList<OperatorCondition> eff) {
        int numConditions = 0;
        for (OperatorCondition e : eff) {
            if (e.type != OperatorConditionType.CT_INCREASE) continue;
            ++numConditions;
        }
        TaskTypes.NumericEffectImp[] res = new TaskTypes.NumericEffectImp[numConditions];
        if (numConditions == 0) {
            return res;
        }
        numConditions = 0;
        for (OperatorCondition e : eff) {
            if (e.type != OperatorConditionType.CT_INCREASE) continue;
            res[numConditions] = new TaskTypes.NumericEffectImp(0);
            res[numConditions].var = this.getOperatorNumericVariable(e.var);
            res[numConditions].exp = this.getOperatorNumericEffectsExpression(e.exp);
            ++numConditions;
        }
        return res;
    }

    private TaskTypes.FunctionImp getOperatorNumericVariable(Variable var) {
        TaskTypes.FunctionImp res = new TaskTypes.FunctionImp(var.name, false);
        int index = this.functions.indexOf(new Function(new Variable(var.name), false));
        Function fncEff = this.functions.get(index);
        res.parameters = new TaskTypes.ParameterImp[var.params.size()];
        for (int p = 0; p < var.params.size(); ++p) {
            Value param = var.params.get(p);
            res.parameters[p] = new TaskTypes.ParameterImp(param.name);
            res.parameters[p].types = new String[param.types.size()];
            for (int t = 0; t < param.types.size(); ++t) {
                res.parameters[p].types[t] = param.types.get((int)t).name;
            }
        }
        res.domain = new String[fncEff.domain.size()];
        for (int t = 0; t < res.domain.length; ++t) {
            res.domain[t] = fncEff.domain.get((int)t).name;
        }
        return res;
    }

    private TaskTypes.NumericExpressionImp getOperatorNumericEffectsExpression(NumericExpressionImp exp) {
        int type = -1;
        switch (exp.type) {
            case NET_NUMBER: {
                type = 0;
                break;
            }
            case NET_VAR: {
                type = 1;
                break;
            }
            case NET_ADD: {
                type = 2;
                break;
            }
            case NET_DEL: {
                type = 3;
                break;
            }
            case NET_PROD: {
                type = 4;
                break;
            }
            case NET_DIV: {
                type = 5;
                break;
            }
            case NET_USAGE: {
                type = 6;
            }
        }
        TaskTypes.NumericExpressionImp e = new TaskTypes.NumericExpressionImp(type);
        if (exp.type == NumericExpressionType.NET_NUMBER) {
            e.value = exp.value;
        } else if (exp.type == NumericExpressionType.NET_VAR) {
            e.var = this.getOperatorNumericVariable(exp.var);
        } else {
            e.left = this.getOperatorNumericEffectsExpression(exp.left);
            e.right = this.getOperatorNumericEffectsExpression(exp.right);
        }
        return e;
    }

    @Override
    public Congestion[] getCongestion() {
        Congestion[] res = new Congestion[this.congestions.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.congestions.get(i);
        }
        return res;
    }

    @Override
    public NumericFact[] getInitialNumericFacts() {
        ArrayList<Assignment> res = new ArrayList<Assignment>();
        for (Assignment a : this.init) {
            if (!a.isNumeric) continue;
            res.add(a);
        }
        return res.toArray(new NumericFact[res.size()]);
    }

    public void addPreference(String name, Assignment a, SynAnalyzer syn) throws ParseException {
        for (PreferenceImp p : this.preferences) {
            if (!p.name.equalsIgnoreCase(name)) continue;
            syn.notifyError("Preference '" + name + "' redefined");
        }
        this.preferences.add(new PreferenceImp(name, a));
    }

    @Override
    public double getSelfInterest() {
        return this.selfInterest;
    }

    @Override
    public double getMetricThreshold() {
        return this.metricThreshold;
    }

    @Override
    public Fact[] getPreferences() {
        Fact[] res = new TaskTypes.FactImp[this.preferences.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.getFact(this.preferences.get((int)i).goal);
        }
        return res;
    }

    @Override
    public String getPreferenceName(int index) {
        return this.preferences.get((int)index).name;
    }

    @Override
    public Metric getMetric() {
        return this.metric;
    }

    public class CongestionImp
    implements Congestion {
        String name;
        ArrayList<Value> params;
        ArrayList<Value> vars;
        CongestionUsageImp usage;
        ArrayList<CongestionPenaltyImp> penalty;

        CongestionImp(String name) {
            this.name = name;
            this.params = new ArrayList();
            this.vars = new ArrayList();
            this.usage = null;
            this.penalty = new ArrayList();
        }

        public boolean equals(Object x) {
            return ((CongestionImp)x).name.equalsIgnoreCase(this.name);
        }

        void addParameter(Value p, SynAnalyzer syn) throws ParseException {
            if (this.params.contains(p) || this.vars.contains(p)) {
                syn.notifyError("Parameter '" + p.name + "' redefined");
            }
            this.params.add(p);
        }

        void addVariable(Value p, SynAnalyzer syn) throws ParseException {
            if (this.params.contains(p) || this.vars.contains(p)) {
                syn.notifyError("Variable '" + p.name + "' redefined");
            }
            this.vars.add(p);
        }

        Value getParamOrVar(String name) {
            for (Value v : this.params) {
                if (!v.name.equalsIgnoreCase(name)) continue;
                return v;
            }
            for (Value v : this.vars) {
                if (!v.name.equalsIgnoreCase(name)) continue;
                return v;
            }
            return null;
        }

        void addPenalty(CongestionPenaltyImp p) {
            this.penalty.add(p);
        }

        @Override
        public int getNumParams() {
            return this.params.size();
        }

        @Override
        public String[] getParamTypes(int paramNumber) {
            Value v = this.params.get(paramNumber);
            String[] types = new String[v.types.size()];
            for (int i = 0; i < types.length; ++i) {
                types[i] = v.types.get((int)i).name;
            }
            return types;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String[] getVariableNames() {
            String[] varNames = new String[this.vars.size()];
            for (int i = 0; i < this.vars.size(); ++i) {
                varNames[i] = this.vars.get((int)i).name;
            }
            return varNames;
        }

        @Override
        public String[] getVarTypes(int varNumber) {
            Value v = this.vars.get(varNumber);
            String[] types = new String[v.types.size()];
            for (int i = 0; i < types.length; ++i) {
                types[i] = v.types.get((int)i).name;
            }
            return types;
        }

        @Override
        public CongestionUsage getUsage() {
            return this.usage;
        }

        @Override
        public int getParamIndex(String paramName) {
            int index = -1;
            for (int i = 0; i < this.params.size(); ++i) {
                if (!this.params.get((int)i).name.equalsIgnoreCase(paramName)) continue;
                index = i;
                break;
            }
            return index;
        }

        @Override
        public int getNumPenalties() {
            return this.penalty.size();
        }

        @Override
        public CongestionPenalty getPenalty(int index) {
            return this.penalty.get(index);
        }
    }

    public class CongestionPenaltyImp
    implements CongestionPenalty {
        ConditionType condition;
        double conditionValue;
        Variable incVariable;
        NumericExpressionImp increment;

        CongestionPenaltyImp(ConditionType conditionType) {
            this.condition = conditionType;
        }

        void setVariable(Variable var) {
            this.incVariable = var;
        }

        void setIncrement(NumericExpressionImp inc) {
            this.increment = inc;
        }

        @Override
        public int getConditionType() {
            switch (this.condition) {
                case CT_EQUAL: {
                    return 0;
                }
                case CT_GREATER: {
                    return 1;
                }
                case CT_GREATER_EQ: {
                    return 2;
                }
                case CT_LESS: {
                    return 3;
                }
                case CT_LESS_EQ: {
                    return 4;
                }
            }
            return 5;
        }

        @Override
        public CongestionFluent getIncVariable() {
            return this.incVariable;
        }

        @Override
        public double getConditionValue() {
            return this.conditionValue;
        }

        @Override
        public NumericExpression getIncExpression() {
            return this.increment;
        }
    }

    public static enum ConditionType {
        CT_EQUAL,
        CT_GREATER,
        CT_GREATER_EQ,
        CT_LESS,
        CT_LESS_EQ,
        CT_DISTINCT;

    }

    public class CongestionUsageImp
    implements CongestionUsage {
        CongestionUsageType type;
        CongestionAction action;
        ArrayList<CongestionUsageImp> cond;

        CongestionUsageImp(CongestionUsageType type) {
            this.type = type;
            this.cond = new ArrayList();
        }

        CongestionUsageImp(CongestionAction action) {
            this.type = CongestionUsageType.CUT_ACTION;
            this.action = action;
        }

        void addCondition(CongestionUsageImp condition) {
            this.cond.add(condition);
        }

        @Override
        public int getType() {
            switch (this.type) {
                case CUT_OR: {
                    return 0;
                }
                case CUT_AND: {
                    return 1;
                }
            }
            return 2;
        }

        @Override
        public int numTerms() {
            return this.cond.size();
        }

        @Override
        public CongestionUsage getTerm(int index) {
            return this.cond.get(index);
        }

        @Override
        public String getActionName() {
            return this.action.op.name;
        }

        @Override
        public int numActionParams() {
            return this.action.params.size();
        }

        @Override
        public String getParamName(int paramNumber) {
            return this.action.params.get((int)paramNumber).name;
        }
    }

    public class CongestionAction {
        Operator op;
        ArrayList<Value> params;

        CongestionAction(Operator op) {
            this.op = op;
            this.params = new ArrayList(op.params.size());
        }

        void addParameter(Value value) {
            this.params.add(value);
        }
    }

    public static enum CongestionUsageType {
        CUT_OR,
        CUT_AND,
        CUT_ACTION;

    }

    public class MetricImp
    implements Metric {
        int metricType;
        double number;
        String preference;
        ArrayList<MetricImp> term;

        public MetricImp(String id, SynAnalyzer syn) throws ParseException {
            this.metricType = 0;
            this.preference = id;
            boolean found = false;
            for (PreferenceImp p : TaskImp.this.preferences) {
                if (!p.name.equalsIgnoreCase(id)) continue;
                found = true;
                break;
            }
            if (!found) {
                syn.notifyError("Unknown preference '" + id + "' in metric");
            }
        }

        public MetricImp(SynAnalyzer.Symbol sym) {
            this.metricType = sym.equals((Object)SynAnalyzer.Symbol.SS_PLUS) ? 1 : 2;
            this.term = new ArrayList();
        }

        public MetricImp(double n) {
            this.metricType = 3;
            this.number = n;
        }

        public MetricImp() {
            this.metricType = 4;
        }

        @Override
        public int getMetricType() {
            return this.metricType;
        }

        @Override
        public String getPreference() {
            return this.preference;
        }

        @Override
        public double getNumber() {
            return this.number;
        }

        @Override
        public int getNumTerms() {
            return this.term.size();
        }

        @Override
        public MetricImp getTerm(int index) {
            return this.term.get(index);
        }
    }

    public class PreferenceImp {
        String name;
        Assignment goal;

        public PreferenceImp(String name, Assignment a) {
            this.name = name;
            this.goal = a;
        }
    }

    public class Assignment
    implements NumericFact {
        Variable var;
        Function fnc;
        ArrayList<Value> params;
        ArrayList<Value> values;
        boolean neg;
        boolean isNumeric;
        double value;

        public Assignment(Variable var, boolean neg) {
            this.var = var;
            this.fnc = null;
            this.params = new ArrayList();
            this.values = new ArrayList();
            this.neg = neg;
            this.isNumeric = false;
        }

        public Assignment(Function fnc, boolean neg) {
            this.var = null;
            this.fnc = fnc;
            this.params = new ArrayList();
            this.values = new ArrayList();
            this.neg = neg;
            this.isNumeric = false;
        }

        @Override
        public String getFunctionName() {
            return this.fnc.var.getName();
        }

        @Override
        public String[] getParameters() {
            String[] res = new String[this.params.size()];
            for (int i = 0; i < res.length; ++i) {
                res[i] = this.params.get((int)i).name;
            }
            return res;
        }

        @Override
        public double getValue() {
            return this.value;
        }
    }

    public class SharedData {
        Variable var;
        Function fnc;
        ArrayList<Value> agents;

        public SharedData(Variable var) {
            this.var = var;
            this.fnc = null;
            this.agents = new ArrayList();
        }

        public SharedData(Function fnc) {
            this.var = null;
            this.fnc = fnc;
            this.agents = new ArrayList();
        }
    }

    public class Operator {
        String name;
        ArrayList<Value> params;
        ArrayList<OperatorCondition> prec;
        ArrayList<OperatorCondition> eff;
        int preference;

        public Operator(String name) {
            this.name = name;
            this.params = new ArrayList();
            this.prec = new ArrayList();
            this.eff = new ArrayList();
            this.preference = -1;
        }

        public boolean equals(Object x) {
            return this.name.equalsIgnoreCase(((Operator)x).name);
        }
    }

    public class OperatorCondition {
        OperatorConditionType type;
        boolean neg;
        Variable var;
        Value value;
        NumericExpressionImp exp;

        public OperatorCondition(OperatorConditionType type) {
            this.type = type;
            this.neg = false;
        }
    }

    public static enum OperatorConditionType {
        CT_NONE,
        CT_EQUAL,
        CT_MEMBER,
        CT_ASSIGN,
        CT_ADD,
        CT_DEL,
        CT_INCREASE;

    }

    public class NumericExpressionImp
    implements NumericExpression {
        NumericExpressionType type;
        double value;
        Variable var;
        NumericExpressionImp left;
        NumericExpressionImp right;

        NumericExpressionImp(double value) {
            this.type = NumericExpressionType.NET_NUMBER;
            this.value = value;
        }

        NumericExpressionImp(Variable v) {
            this.type = NumericExpressionType.NET_VAR;
            this.var = v;
        }

        NumericExpressionImp(NumericExpressionType type) {
            this.type = type;
            this.right = null;
            this.left = null;
        }

        @Override
        public int getType() {
            switch (this.type) {
                case NET_NUMBER: {
                    return 0;
                }
                case NET_VAR: {
                    return 1;
                }
                case NET_ADD: {
                    return 2;
                }
                case NET_DEL: {
                    return 3;
                }
                case NET_PROD: {
                    return 4;
                }
                case NET_DIV: {
                    return 5;
                }
            }
            return 6;
        }

        @Override
        public double getValue() {
            return this.value;
        }

        @Override
        public org.agreement_technologies.common.map_parser.Function getNumericVariable() {
            return null;
        }

        @Override
        public NumericExpression getLeftExp() {
            return this.left;
        }

        @Override
        public NumericExpression getRightExp() {
            return this.right;
        }

        @Override
        public CongestionFluent getCongestionFluent() {
            return this.var;
        }
    }

    public static enum NumericExpressionType {
        NET_NUMBER,
        NET_VAR,
        NET_ADD,
        NET_DEL,
        NET_PROD,
        NET_DIV,
        NET_USAGE;

    }

    public class Function {
        Variable var;
        ArrayList<Type> domain;
        boolean multiFunction;

        public Function(Variable v, boolean multifunction) {
            this.var = v;
            this.multiFunction = multifunction;
            this.domain = new ArrayList();
        }

        public boolean equals(Object x) {
            return this.var.equals(((Function)x).var);
        }

        public void setDomain(ArrayList<Type> domain) {
            for (Type t : domain) {
                this.domain.add(t);
            }
        }

        public void addDomainType(SynAnalyzer syn, String typeName) throws ParseException {
            Type t;
            int typeIndex = TaskImp.this.types.indexOf(new Type(typeName));
            if (typeIndex == -1) {
                syn.notifyError("Type '" + typeName + "' undefined");
            }
            if (this.domain.contains(t = TaskImp.this.types.get(typeIndex))) {
                syn.notifyError("Type '" + typeName + "' duplicated in domain definition");
            }
            this.domain.add(t);
        }

        boolean isNumeric() {
            Type number = TaskImp.this.types.get(3);
            for (Type t : this.domain) {
                if (!t.isCompatible(number)) continue;
                return true;
            }
            return false;
        }
    }

    public class Variable
    implements CongestionFluent {
        String name;
        ArrayList<Value> params;

        public Variable(String name) {
            this.name = name;
            this.params = new ArrayList();
        }

        public boolean equals(Object x) {
            return this.name.equalsIgnoreCase(((Variable)x).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getNumParams() {
            return this.params.size();
        }

        @Override
        public String getParamName(int index) {
            return this.params.get((int)index).name;
        }
    }

    public class Value {
        String name;
        ArrayList<Type> types;
        boolean isVariable;

        public Value(String name) {
            this.name = name;
            this.types = new ArrayList();
            this.isVariable = false;
        }

        public boolean equals(Object x) {
            return this.name.equals(((Value)x).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public void addType(Type type, SynAnalyzer syn) throws ParseException {
            if (this.types.contains(type)) {
                syn.notifyError("Type '" + type.name + "' already defined for object '" + this.name + "'");
            }
            this.types.add(type);
        }

        public boolean isCompatible(Value param) {
            boolean comp = false;
            for (Type t : this.types) {
                for (Type tp : param.types) {
                    if (!t.isCompatible(tp)) continue;
                    comp = true;
                    break;
                }
                if (!comp) continue;
                break;
            }
            return comp;
        }

        public boolean isCompatible(ArrayList<Type> domain) {
            boolean comp = false;
            for (Type t : this.types) {
                for (Type td : domain) {
                    if (!t.isCompatible(td)) continue;
                    comp = true;
                    break;
                }
                if (!comp) continue;
                break;
            }
            return comp;
        }

        public String toString() {
            return this.name;
        }
    }

    public class Type {
        String name;
        ArrayList<Type> parentTypes;

        public Type(String name) {
            this.name = name;
            this.parentTypes = new ArrayList();
        }

        public void addParentType(Type parent, SynAnalyzer syn) throws ParseException {
            if (this.parentTypes.contains(parent)) {
                syn.notifyError("Parent type '" + parent.name + "' already defined for type '" + this.name + "'");
            }
            this.parentTypes.add(parent);
        }

        public boolean equals(Object x) {
            return this.name.equals(((Type)x).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean isCompatible(Type tp) {
            boolean comp = this.equals(tp);
            if (!comp) {
                for (Type t : this.parentTypes) {
                    if (!t.isCompatible(tp)) continue;
                    comp = true;
                    break;
                }
            }
            return comp;
        }

        public boolean isCompatible(ArrayList<Type> domain) {
            for (Type t : domain) {
                if (!this.isCompatible(t)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return this.name;
        }
    }
}

