/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_parser;

import java.text.ParseException;
import java.util.Scanner;

public class SynAnalyzer {
    private final Scanner file;
    private boolean useLastToken = false;
    private Token lastToken = null;
    private String buffer = "";
    private int lineNumber = 0;

    public SynAnalyzer(String fileContent) {
        this.file = new Scanner(fileContent);
    }

    public Token nextToken() {
        if (this.useLastToken) {
            this.useLastToken = false;
            return this.lastToken;
        }
        Token res = new Token();
        if (this.buffer.length() > 0 && (this.buffer.charAt(0) == ';' || this.buffer.charAt(0) == '\\')) {
            this.buffer = "";
        }
        while (this.buffer.length() == 0 && this.file.hasNext()) {
            this.buffer = this.file.nextLine().trim();
            ++this.lineNumber;
            if (this.buffer.length() <= 0 || this.buffer.charAt(0) != ';' && this.buffer.charAt(0) != '\\') continue;
            this.buffer = "";
        }
        if (this.buffer.length() > 0) {
            switch (this.buffer.charAt(0)) {
                case '(': {
                    res.set(Symbol.SS_OPEN_PAR, "(");
                    break;
                }
                case ')': {
                    res.set(Symbol.SS_CLOSE_PAR, ")");
                    break;
                }
                case '{': {
                    res.set(Symbol.SS_OPEN_SET, "{");
                    break;
                }
                case '}': {
                    res.set(Symbol.SS_CLOSE_SET, "}");
                    break;
                }
                case ':': {
                    res.set(Symbol.SS_COLON, ":");
                    break;
                }
                case '-': {
                    res.set(Symbol.SS_DASH, "-");
                    break;
                }
                case '=': {
                    res.set(Symbol.SS_EQUAL, "=");
                    break;
                }
                case '+': {
                    res.set(Symbol.SS_PLUS, "+");
                    break;
                }
                case '*': {
                    res.set(Symbol.SS_MULT, "*");
                    break;
                }
                case '/': {
                    res.set(Symbol.SS_DIV, "/");
                    break;
                }
                case '>': {
                    if (this.buffer.length() > 1 && this.buffer.charAt(1) == '=') {
                        this.buffer = this.buffer.substring(1).trim();
                        res.set(Symbol.SS_GREATER_EQ, ">=");
                        break;
                    }
                    res.set(Symbol.SS_GREATER, ">");
                    break;
                }
                case '<': {
                    if (this.buffer.length() > 1 && this.buffer.charAt(1) == '=') {
                        this.buffer = this.buffer.substring(1).trim();
                        res.set(Symbol.SS_LESS_EQ, "<=");
                        break;
                    }
                    res.set(Symbol.SS_LESS, "<");
                    break;
                }
                case '!': {
                    if (this.buffer.length() <= 1 || this.buffer.charAt(1) != '=') break;
                    res.set(Symbol.SS_DISTINCT, "!=");
                    this.buffer = this.buffer.substring(1).trim();
                }
            }
            if (res.undefined()) {
                int pos;
                for (pos = 1; pos < this.buffer.length() && this.buffer.charAt(pos) > ' ' && this.buffer.charAt(pos) != ')' && this.buffer.charAt(pos) != '(' && this.buffer.charAt(pos) != '[' && this.buffer.charAt(pos) != ']' && this.buffer.charAt(pos) != '{' && this.buffer.charAt(pos) != '}' && this.buffer.charAt(pos) != ','; ++pos) {
                }
                String word = this.buffer.substring(0, pos);
                if (word.startsWith("?")) {
                    res.set(Symbol.SS_VAR, word);
                } else if (word.charAt(0) >= '0' && word.charAt(0) <= '9' || word.startsWith(".")) {
                    res.set(Symbol.SS_NUMBER, word);
                } else {
                    res.set(Symbol.SS_ID, word);
                }
                this.buffer = this.buffer.substring(pos).trim();
            } else {
                this.buffer = this.buffer.substring(1).trim();
            }
        }
        this.lastToken = res;
        return res;
    }

    public Token readSym(Symbol ... sym) throws ParseException {
        Token res = this.nextToken();
        boolean found = false;
        for (int i = 0; i < sym.length && !found; ++i) {
            if (!res.isSym(sym[i])) continue;
            found = true;
            res.symbol = sym[i];
        }
        if (!found) {
            this.notifyError("Unexpected token: '" + res.desc + "'");
        }
        return res;
    }

    public void openPar() throws ParseException {
        Token res = this.nextToken();
        if (!res.isSym(Symbol.SS_OPEN_PAR)) {
            this.notifyError("Open parenthesis expected");
        }
    }

    public void closePar() throws ParseException {
        Token res = this.nextToken();
        if (!res.isSym(Symbol.SS_CLOSE_PAR)) {
            this.notifyError("Close parenthesis expected");
        }
    }

    public void colon() throws ParseException {
        Token res = this.nextToken();
        if (!res.isSym(Symbol.SS_COLON)) {
            this.notifyError("Colon expected");
        }
    }

    public String readId() throws ParseException {
        Token res = this.nextToken();
        if (!res.isSym(Symbol.SS_ID)) {
            this.notifyError("Identifier expected");
        }
        return res.desc;
    }

    public void notifyError(String msg) throws ParseException {
        throw new ParseException("Parser error: " + msg, this.lineNumber);
    }

    public void restoreLastToken() {
        this.useLastToken = true;
    }

    public static class Token {
        private Symbol symbol = Symbol.SS_UNDEFINED;
        private String desc = "";
        private String descLower = "";

        public boolean isSym(Symbol sym) {
            if (this.symbol.equals((Object)sym)) {
                return true;
            }
            return this.descLower.equals(Symbol.getName(sym));
        }

        public boolean undefined() {
            return this.symbol == Symbol.SS_UNDEFINED;
        }

        public void set(Symbol s, String desc) {
            this.symbol = s;
            this.desc = desc;
            this.descLower = desc.toLowerCase();
        }

        public Symbol getSym() {
            return this.symbol;
        }

        public String getDesc() {
            return this.desc;
        }

        public String getDescLower() {
            return this.descLower;
        }
    }

    public static enum Symbol {
        SS_UNDEFINED,
        SS_OPEN_PAR,
        SS_CLOSE_PAR,
        SS_OPEN_SET,
        SS_CLOSE_SET,
        SS_COLON,
        SS_DASH,
        SS_EQUAL,
        SS_ID,
        SS_DEFINE,
        SS_DOMAIN,
        SS_PROBLEM,
        SS_REQUIREMENTS,
        SS_TYPES,
        SS_CONSTANTS,
        SS_PREDICATES,
        SS_FUNCTIONS,
        SS_MULTI_FUNCTIONS,
        SS_EITHER,
        SS_ACTION,
        SS_PREC,
        SS_EFF,
        SS_PARAMS,
        SS_AND,
        SS_NOT,
        SS_MEMBER,
        SS_ASSIGN,
        SS_ADD,
        SS_DEL,
        SS_OBJECTS,
        SS_SHARED_DATA,
        SS_INIT,
        SS_BELIEFS,
        SS_GLOBAL_GOAL,
        SS_GOAL,
        SS_CONSTRAINTS,
        SS_PREFERENCE,
        SS_METRIC,
        SS_MINIMIZE,
        SS_IS_VIOLATED,
        SS_BEHAVIOUR,
        SS_SELF_INTEREST,
        SS_METRIC_THRESHOLD,
        SS_PLUS,
        SS_MULT,
        SS_VAR,
        SS_HEAD,
        SS_BODY,
        SS_DEF_RULE,
        SS_ACTION_PREF,
        SS_NUMBER,
        SS_TOTAL_TIME,
        SS_INCREASE,
        SS_DIV,
        SS_CONGESTION,
        SS_VARIABLES,
        SS_USAGE,
        SS_PENALTY,
        SS_OR,
        SS_WHEN,
        SS_GREATER,
        SS_GREATER_EQ,
        SS_LESS,
        SS_LESS_EQ,
        SS_DISTINCT;

        private static final String[] sname;

        public static String getName(Symbol sym) {
            return sname[sym.ordinal()];
        }

        static {
            sname = new String[]{"undefined", "(", ")", "{", "}", ":", "-", "=", "identifier", "define", "domain", "problem", "requirements", "types", "constants", "predicates", "functions", "multi-functions", "either", "action", "precondition", "effect", "parameters", "and", "not", "member", "assign", "add", "del", "objects", "shared-data", "init", "beliefs", "global-goal", "goal", "constraints", "preference", "metric", "minimize", "is-violated", "behaviour", "self-interest", "metric-threshold", "+", "*", "variable", "head", "body", "def-rule", "action-preferences", "number", "total-time", "increase", "/", "congestion", "variables", "usage", "penalty", "or", "when", ">", ">=", "<", "<=", "!="};
        }
    }
}

