/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_parser;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.agreement_technologies.common.map_parser.AgentList;
import org.agreement_technologies.common.map_parser.PDDLParser;
import org.agreement_technologies.common.map_parser.Task;
import org.agreement_technologies.service.map_parser.AgentListImp;
import org.agreement_technologies.service.map_parser.SynAnalyzer;
import org.agreement_technologies.service.map_parser.TaskImp;

public class MAPDDLParserImp
implements PDDLParser {
    private final ArrayList<TaskImp.Variable> privatePredicates = new ArrayList();
    private final ArrayList<TaskImp.Value> privateObjects = new ArrayList();

    @Override
    public Task parseDomain(String domainFile) throws ParseException, IOException {
        String content = this.readToString(domainFile);
        SynAnalyzer syn = new SynAnalyzer(content);
        TaskImp task = new TaskImp();
        syn.openPar();
        syn.readSym(SynAnalyzer.Symbol.SS_DEFINE);
        syn.openPar();
        syn.readSym(SynAnalyzer.Symbol.SS_DOMAIN);
        task.domainName = syn.readId();
        syn.closePar();
        SynAnalyzer.Token token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR);
        while (token.isSym(SynAnalyzer.Symbol.SS_OPEN_PAR)) {
            syn.colon();
            token = syn.readSym(SynAnalyzer.Symbol.SS_REQUIREMENTS, SynAnalyzer.Symbol.SS_TYPES, SynAnalyzer.Symbol.SS_CONSTANTS, SynAnalyzer.Symbol.SS_PREDICATES, SynAnalyzer.Symbol.SS_FUNCTIONS, SynAnalyzer.Symbol.SS_MULTI_FUNCTIONS, SynAnalyzer.Symbol.SS_ACTION);
            switch (token.getSym()) {
                case SS_REQUIREMENTS: {
                    this.parseRequirements(syn, task);
                    break;
                }
                case SS_TYPES: {
                    this.parseTypes(syn, task);
                    break;
                }
                case SS_CONSTANTS: {
                    this.parseObjects(syn, task, false);
                    break;
                }
                case SS_PREDICATES: {
                    this.parsePredicates(syn, task, false);
                    break;
                }
                case SS_FUNCTIONS: {
                    this.parseFunctions(syn, task, false);
                    break;
                }
                case SS_ACTION: {
                    this.parseAction(syn, task);
                }
            }
            token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR);
        }
        return task;
    }

    private String readToString(String fileName) throws IOException {
        FileReader source = new FileReader(fileName);
        StringBuilder buf = new StringBuilder();
        try {
            int c22 = ((Reader)source).read();
            while (c22 != -1) {
                buf.append((char)c22);
                c22 = ((Reader)source).read();
            }
            String c22 = buf.toString();
            return c22;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                ((Reader)source).close();
            }
            catch (Exception e) {}
        }
    }

    @Override
    public AgentList parseAgentList(String agentsFile) throws ParseException, IOException {
        SynAnalyzer.Token t;
        String content = this.readToString(agentsFile);
        SynAnalyzer syn = new SynAnalyzer(content);
        AgentListImp agList = new AgentListImp();
        do {
            if ((t = syn.readSym(SynAnalyzer.Symbol.SS_ID, SynAnalyzer.Symbol.SS_UNDEFINED)).undefined()) continue;
            String agName = t.getDesc();
            t = syn.readSym(SynAnalyzer.Symbol.SS_NUMBER);
            String ip = t.getDesc();
            agList.addAgent(agName, ip);
        } while (!t.undefined());
        if (agList.isEmpty()) {
            throw new ParseException("No agents defined in the file", 1);
        }
        return agList;
    }

    private void parseRequirements(SynAnalyzer syn, TaskImp task) throws ParseException {
        SynAnalyzer.Token token;
        do {
            if (!(token = syn.readSym(SynAnalyzer.Symbol.SS_COLON, SynAnalyzer.Symbol.SS_CLOSE_PAR)).isSym(SynAnalyzer.Symbol.SS_COLON)) continue;
            String req = syn.readId().toUpperCase();
            task.addRequirement(req);
        } while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR));
    }

    private void parseTypes(SynAnalyzer syn, TaskImp task) throws ParseException {
        SynAnalyzer.Token token = syn.readSym(SynAnalyzer.Symbol.SS_ID, SynAnalyzer.Symbol.SS_CLOSE_PAR);
        while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR)) {
            ArrayList<String> typeNames = new ArrayList<String>();
            while (token.isSym(SynAnalyzer.Symbol.SS_ID)) {
                typeNames.add(token.getDescLower());
                token = syn.readSym(SynAnalyzer.Symbol.SS_ID, SynAnalyzer.Symbol.SS_DASH, SynAnalyzer.Symbol.SS_CLOSE_PAR);
            }
            ArrayList<String> parentTypes = new ArrayList<String>();
            if (token.isSym(SynAnalyzer.Symbol.SS_DASH)) {
                this.parseTypeList(syn, parentTypes, task);
                token = syn.readSym(SynAnalyzer.Symbol.SS_ID, SynAnalyzer.Symbol.SS_CLOSE_PAR);
            } else {
                parentTypes.add("object");
            }
            this.addTypes(syn, typeNames, parentTypes, task);
        }
    }

    private void parseTypeList(SynAnalyzer syn, ArrayList<String> parentTypes, TaskImp task) throws ParseException {
        SynAnalyzer.Token token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_ID);
        if (token.isSym(SynAnalyzer.Symbol.SS_ID)) {
            TaskImp taskImp = task;
            taskImp.getClass();
            TaskImp.Type type = new TaskImp.Type(taskImp, token.getDescLower());
            parentTypes.add(type.name);
        } else {
            syn.readSym(SynAnalyzer.Symbol.SS_EITHER);
            do {
                if (!(token = syn.readSym(SynAnalyzer.Symbol.SS_ID, SynAnalyzer.Symbol.SS_CLOSE_PAR)).isSym(SynAnalyzer.Symbol.SS_ID)) continue;
                TaskImp taskImp = task;
                taskImp.getClass();
                TaskImp.Type type = new TaskImp.Type(taskImp, token.getDescLower());
                parentTypes.add(type.name);
            } while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR));
        }
    }

    private TaskImp.Type addNewType(SynAnalyzer syn, String typeName, TaskImp task) throws ParseException {
        TaskImp taskImp = task;
        taskImp.getClass();
        TaskImp.Type type = new TaskImp.Type(taskImp, typeName);
        int pos = task.types.indexOf(type);
        if (pos == -1) {
            task.types.add(type);
        } else if (pos > 2) {
            syn.notifyError("Type '" + typeName + "' redefined");
        } else {
            type = task.types.get(pos);
        }
        return type;
    }

    private void addTypes(SynAnalyzer syn, ArrayList<String> typeNames, ArrayList<String> parentTypes, TaskImp task) throws ParseException {
        for (String name : typeNames) {
            TaskImp.Type type = this.addNewType(syn, name, task);
            if (parentTypes.contains(name)) {
                type.addParentType(task.types.get(0), syn);
                continue;
            }
            for (String parent : parentTypes) {
                ArrayList<TaskImp.Type> arrayList = task.types;
                TaskImp taskImp = task;
                taskImp.getClass();
                int typeIndex = arrayList.indexOf(new TaskImp.Type(taskImp, parent));
                if (typeIndex == -1) {
                    TaskImp.Type ptype = this.addNewType(syn, parent, task);
                    ptype.addParentType(task.types.get(0), syn);
                    typeIndex = task.types.indexOf(ptype);
                }
                type.addParentType(task.types.get(typeIndex), syn);
            }
        }
    }

    private void parsePredicates(SynAnalyzer syn, TaskImp task, boolean priv) throws ParseException {
        SynAnalyzer.Token token;
        do {
            if (!(token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR)).isSym(SynAnalyzer.Symbol.SS_OPEN_PAR)) continue;
            syn.restoreLastToken();
            TaskImp.Variable v = this.parsePredicate(syn, task, false, true, priv);
            if (v == null) continue;
            task.predicates.add(v);
            if (!priv) continue;
            this.privatePredicates.add(v);
        } while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR));
    }

    private TaskImp.Variable parsePredicate(SynAnalyzer syn, TaskImp task, boolean allowDuplicates, boolean readPar, boolean priv) throws ParseException {
        SynAnalyzer.Token token;
        if (readPar) {
            syn.openPar();
        }
        if ((token = priv ? syn.readSym(SynAnalyzer.Symbol.SS_ID) : syn.readSym(SynAnalyzer.Symbol.SS_ID, SynAnalyzer.Symbol.SS_COLON)).isSym(SynAnalyzer.Symbol.SS_COLON)) {
            this.readPrivateToken(syn);
            this.parsePredicates(syn, task, true);
            return null;
        }
        TaskImp taskImp = task;
        taskImp.getClass();
        TaskImp.Variable v = new TaskImp.Variable(taskImp, token.getDesc());
        if (!allowDuplicates && task.existVariable(v)) {
            syn.notifyError("Predicate '" + v.name + "' redefined");
        }
        ArrayList<TaskImp.Value> params = this.parseParameters(syn, task);
        for (TaskImp.Value p : params) {
            v.params.add(p);
        }
        if (readPar) {
            syn.closePar();
        }
        return v;
    }

    private ArrayList<TaskImp.Value> parseParameters(SynAnalyzer syn, TaskImp task) throws ParseException {
        SynAnalyzer.Token token;
        ArrayList<TaskImp.Value> res = new ArrayList<TaskImp.Value>();
        do {
            if ((token = syn.readSym(SynAnalyzer.Symbol.SS_VAR, SynAnalyzer.Symbol.SS_CLOSE_PAR)).isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR)) continue;
            String desc = token.getDescLower();
            ArrayList<String> paramList = new ArrayList<String>();
            ArrayList<String> typeList = new ArrayList<String>();
            do {
                paramList.add(desc);
                token = syn.readSym(SynAnalyzer.Symbol.SS_VAR, SynAnalyzer.Symbol.SS_DASH, SynAnalyzer.Symbol.SS_CLOSE_PAR);
                desc = token.getDescLower();
            } while (token.isSym(SynAnalyzer.Symbol.SS_VAR));
            if (token.isSym(SynAnalyzer.Symbol.SS_DASH)) {
                this.parseTypeList(syn, typeList, task);
            } else {
                typeList.add("object");
            }
            for (String paramName : paramList) {
                TaskImp taskImp = task;
                taskImp.getClass();
                TaskImp.Value v = new TaskImp.Value(taskImp, paramName);
                v.isVariable = true;
                if (res.contains(v)) {
                    syn.notifyError("Parameter '" + paramName + "' redefined");
                }
                for (String t : typeList) {
                    v.addType(this.getType(t, task, syn), syn);
                }
                res.add(v);
            }
        } while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR));
        syn.restoreLastToken();
        return res;
    }

    private TaskImp.Type getType(String typeName, TaskImp task, SynAnalyzer syn) throws ParseException {
        ArrayList<TaskImp.Type> arrayList = task.types;
        TaskImp taskImp = task;
        taskImp.getClass();
        int index = arrayList.indexOf(new TaskImp.Type(taskImp, typeName));
        if (index == -1) {
            syn.notifyError("Type '" + typeName + "' undefined");
        }
        return task.types.get(index);
    }

    private void readPrivateToken(SynAnalyzer syn) throws ParseException {
        String id = syn.readId();
        if (!id.equalsIgnoreCase("private")) {
            syn.notifyError("Keyword 'private' expected");
        }
    }

    private void parseAction(SynAnalyzer syn, TaskImp task) throws ParseException {
        TaskImp taskImp = task;
        taskImp.getClass();
        TaskImp.Operator op = new TaskImp.Operator(taskImp, syn.readId());
        if (task.operators.contains(op)) {
            syn.notifyError("Operator '" + op.name + "' redefined");
        }
        task.operators.add(op);
        syn.colon();
        boolean precRead = false;
        boolean effRead = false;
        SynAnalyzer.Token token = syn.readSym(SynAnalyzer.Symbol.SS_PARAMS, SynAnalyzer.Symbol.SS_PREC, SynAnalyzer.Symbol.SS_EFF);
        do {
            switch (token.getSym()) {
                case SS_PARAMS: {
                    syn.openPar();
                    ArrayList<TaskImp.Value> params = this.parseParameters(syn, task);
                    for (TaskImp.Value p : params) {
                        op.params.add(p);
                    }
                    syn.closePar();
                    break;
                }
                case SS_PREC: {
                    this.parseOperatorCondition(syn, task, op, true);
                    precRead = true;
                    break;
                }
                case SS_EFF: {
                    this.parseOperatorCondition(syn, task, op, false);
                    effRead = true;
                }
            }
            token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_COLON, SynAnalyzer.Symbol.SS_CLOSE_PAR);
            if (!token.isSym(SynAnalyzer.Symbol.SS_COLON)) continue;
            if (!precRead) {
                token = syn.readSym(SynAnalyzer.Symbol.SS_PREC, SynAnalyzer.Symbol.SS_EFF);
                continue;
            }
            if (!effRead) {
                token = syn.readSym(SynAnalyzer.Symbol.SS_EFF);
                continue;
            }
            syn.notifyError("Unexpected colon");
        } while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR) && !token.isSym(SynAnalyzer.Symbol.SS_OPEN_PAR));
        if (token.isSym(SynAnalyzer.Symbol.SS_OPEN_PAR)) {
            syn.restoreLastToken();
        }
    }

    private void parseOperatorCondition(SynAnalyzer syn, TaskImp task, TaskImp.Operator op, boolean isPrec) throws ParseException {
        syn.openPar();
        SynAnalyzer.Token token = syn.readSym(SynAnalyzer.Symbol.SS_AND, SynAnalyzer.Symbol.SS_ID, SynAnalyzer.Symbol.SS_EQUAL);
        if (token.isSym(SynAnalyzer.Symbol.SS_AND)) {
            do {
                if (!(token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR)).isSym(SynAnalyzer.Symbol.SS_OPEN_PAR)) continue;
                TaskImp.OperatorCondition cond = this.parseSingleOperatorCondition(syn, task, op, isPrec);
                syn.closePar();
                if (isPrec) {
                    op.prec.add(cond);
                    continue;
                }
                op.eff.add(cond);
            } while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR));
        } else {
            syn.restoreLastToken();
            TaskImp.OperatorCondition cond = this.parseSingleOperatorCondition(syn, task, op, isPrec);
            syn.closePar();
            if (isPrec) {
                op.prec.add(cond);
            } else {
                op.eff.add(cond);
            }
        }
    }

    private TaskImp.OperatorCondition parseSingleOperatorCondition(SynAnalyzer syn, TaskImp task, TaskImp.Operator op, boolean isPrec) throws ParseException {
        TaskImp.OperatorCondition cond;
        SynAnalyzer.Token token = isPrec ? syn.readSym(SynAnalyzer.Symbol.SS_NOT, SynAnalyzer.Symbol.SS_EQUAL, SynAnalyzer.Symbol.SS_MEMBER, SynAnalyzer.Symbol.SS_ID) : syn.readSym(SynAnalyzer.Symbol.SS_NOT, SynAnalyzer.Symbol.SS_ASSIGN, SynAnalyzer.Symbol.SS_ADD, SynAnalyzer.Symbol.SS_DEL, SynAnalyzer.Symbol.SS_INCREASE, SynAnalyzer.Symbol.SS_ID);
        if (token.isSym(SynAnalyzer.Symbol.SS_NOT)) {
            syn.openPar();
            cond = this.parseSingleOperatorCondition(syn, task, op, isPrec);
            syn.closePar();
            cond.neg = !cond.neg;
        } else if (token.isSym(SynAnalyzer.Symbol.SS_INCREASE)) {
            TaskImp taskImp = task;
            taskImp.getClass();
            cond = new TaskImp.OperatorCondition(taskImp, TaskImp.OperatorConditionType.CT_INCREASE);
            syn.openPar();
            cond.var = this.parseOperatorVariable(syn, task, op);
            syn.closePar();
            TaskImp.Function function = this.checkFunction(cond.var, syn, task);
            if (!function.isNumeric()) {
                syn.notifyError("Function '" + cond.var.name + "' is not numeric");
            }
            cond.exp = this.parseNumericExpression(syn, task, op, null);
        } else if (token.isSym(SynAnalyzer.Symbol.SS_ID)) {
            syn.restoreLastToken();
            TaskImp taskImp = task;
            taskImp.getClass();
            cond = new TaskImp.OperatorCondition(taskImp, TaskImp.OperatorConditionType.CT_NONE);
            cond.var = this.parseOperatorVariable(syn, task, op);
            this.checkPredicate(cond.var, syn, task);
        } else {
            TaskImp.OperatorConditionType type = null;
            switch (token.getSym()) {
                case SS_EQUAL: {
                    type = TaskImp.OperatorConditionType.CT_EQUAL;
                    break;
                }
                case SS_MEMBER: {
                    type = TaskImp.OperatorConditionType.CT_MEMBER;
                    break;
                }
                case SS_ASSIGN: {
                    type = TaskImp.OperatorConditionType.CT_ASSIGN;
                    break;
                }
                case SS_ADD: {
                    type = TaskImp.OperatorConditionType.CT_ADD;
                    break;
                }
                case SS_DEL: {
                    type = TaskImp.OperatorConditionType.CT_DEL;
                    break;
                }
                default: {
                    syn.notifyError("Unknown condition type");
                }
            }
            TaskImp taskImp = task;
            taskImp.getClass();
            cond = new TaskImp.OperatorCondition(taskImp, type);
            syn.openPar();
            cond.var = this.parseOperatorVariable(syn, task, op);
            syn.closePar();
            cond.value = this.parseOperatorValue(syn, task, op);
            this.checkFunction(cond, syn, task);
        }
        return cond;
    }

    private TaskImp.Variable parseOperatorVariable(SynAnalyzer syn, TaskImp task, TaskImp.Operator op) throws ParseException {
        SynAnalyzer.Token token;
        TaskImp taskImp = task;
        taskImp.getClass();
        TaskImp.Variable v = new TaskImp.Variable(taskImp, syn.readId());
        do {
            if ((token = syn.readSym(SynAnalyzer.Symbol.SS_VAR, SynAnalyzer.Symbol.SS_CLOSE_PAR, SynAnalyzer.Symbol.SS_ID)).isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR)) continue;
            syn.restoreLastToken();
            v.params.add(this.parseOperatorValue(syn, task, op));
        } while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR));
        syn.restoreLastToken();
        return v;
    }

    private TaskImp.Value parseOperatorValue(SynAnalyzer syn, TaskImp task, TaskImp.Operator op) throws ParseException {
        TaskImp.Value v;
        SynAnalyzer.Token token = syn.readSym(SynAnalyzer.Symbol.SS_VAR, SynAnalyzer.Symbol.SS_ID);
        if (token.isSym(SynAnalyzer.Symbol.SS_VAR)) {
            ArrayList<TaskImp.Value> arrayList = op.params;
            TaskImp taskImp = task;
            taskImp.getClass();
            int paramIndex = arrayList.indexOf(new TaskImp.Value(taskImp, token.getDescLower()));
            if (paramIndex == -1) {
                syn.notifyError("Parameter '" + token.getDesc() + "' undefined in operator '" + op.name + "'");
            }
            v = op.params.get(paramIndex);
        } else {
            ArrayList<TaskImp.Value> arrayList = task.values;
            TaskImp taskImp = task;
            taskImp.getClass();
            int objIndex = arrayList.indexOf(new TaskImp.Value(taskImp, token.getDescLower()));
            if (objIndex == -1) {
                syn.notifyError("Constant '" + token.getDesc() + "' undefined");
            }
            v = task.values.get(objIndex);
        }
        return v;
    }

    private void checkPredicate(TaskImp.Variable var, SynAnalyzer syn, TaskImp task) throws ParseException {
        int vIndex = task.predicates.indexOf(var);
        if (vIndex == -1) {
            syn.notifyError("Predicate '" + var.name + "' undefined");
        }
        TaskImp.Variable pred = task.predicates.get(vIndex);
        if (var.params.size() != pred.params.size()) {
            syn.notifyError("Wrong number of parameters in predicate '" + var.name + "'");
        }
        for (int i = 0; i < pred.params.size(); ++i) {
            TaskImp.Value predParam = pred.params.get(i);
            TaskImp.Value varParam = var.params.get(i);
            if (varParam.isCompatible(predParam)) continue;
            syn.notifyError("Invalid parameter '" + varParam.name + "' in predicate '" + var.name + "'");
        }
    }

    private TaskImp.Function checkFunction(TaskImp.Variable var, SynAnalyzer syn, TaskImp task) throws ParseException {
        ArrayList<TaskImp.Function> arrayList = task.functions;
        TaskImp taskImp = task;
        taskImp.getClass();
        int fIndex = arrayList.indexOf(new TaskImp.Function(taskImp, var, false));
        if (fIndex == -1) {
            syn.notifyError("Function '" + var.name + "' undefined");
        }
        TaskImp.Function fnc = task.functions.get(fIndex);
        if (var.params.size() != fnc.var.params.size()) {
            syn.notifyError("Wrong number of parameters in function '" + var.name + "'");
        }
        for (int i = 0; i < var.params.size(); ++i) {
            TaskImp.Value fncParam = fnc.var.params.get(i);
            TaskImp.Value varParam = var.params.get(i);
            if (varParam.isCompatible(fncParam)) continue;
            syn.notifyError("Invalid parameter '" + varParam.name + "' in function '" + var.name + "'");
        }
        return fnc;
    }

    private void checkFunction(TaskImp.OperatorCondition cond, SynAnalyzer syn, TaskImp task) throws ParseException {
        ArrayList<TaskImp.Function> arrayList = task.functions;
        TaskImp taskImp = task;
        taskImp.getClass();
        int fIndex = arrayList.indexOf(new TaskImp.Function(taskImp, cond.var, false));
        if (fIndex == -1) {
            syn.notifyError("Function '" + cond.var.name + "' undefined");
        }
        TaskImp.Function fnc = task.functions.get(fIndex);
        switch (cond.type) {
            case CT_EQUAL: {
                if (!fnc.multiFunction) break;
                syn.notifyError("Operator '=' not valid for multi-functions");
                break;
            }
            case CT_MEMBER: {
                if (fnc.multiFunction) break;
                syn.notifyError("Operator 'member' not valid for functions");
                break;
            }
            case CT_ASSIGN: {
                if (!fnc.multiFunction) break;
                syn.notifyError("Operator 'assign' not valid for multi-functions");
                break;
            }
            case CT_ADD: {
                if (fnc.multiFunction) break;
                syn.notifyError("Operator 'add' not valid for functions");
                break;
            }
            case CT_DEL: {
                if (fnc.multiFunction) break;
                syn.notifyError("Operator 'del' not valid for functions");
                break;
            }
            case CT_NONE: {
                syn.notifyError("Operator expected");
            }
        }
        if (cond.var.params.size() != fnc.var.params.size()) {
            syn.notifyError("Wrong number of parameters in function '" + cond.var.name + "'");
        }
        for (int i = 0; i < cond.var.params.size(); ++i) {
            TaskImp.Value fncParam = fnc.var.params.get(i);
            TaskImp.Value varParam = cond.var.params.get(i);
            if (varParam.isCompatible(fncParam)) continue;
            syn.notifyError("Invalid parameter '" + varParam.name + "' in function '" + cond.var.name + "'");
        }
        if (!cond.value.isCompatible(fnc.domain)) {
            syn.notifyError("Wrong value '" + cond.value.name + "' for function '" + cond.var.name + "'");
        }
    }

    @Override
    public void parseProblem(String problemFile, Task planningTask, AgentList agList, String agentName) throws ParseException, IOException {
        String content = this.readToString(problemFile);
        SynAnalyzer syn = new SynAnalyzer(content);
        TaskImp taskImp = (TaskImp)planningTask;
        syn.openPar();
        syn.readSym(SynAnalyzer.Symbol.SS_DEFINE);
        syn.openPar();
        syn.readSym(SynAnalyzer.Symbol.SS_PROBLEM);
        taskImp.problemName = syn.readId();
        syn.closePar();
        SynAnalyzer.Token token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR);
        while (token.isSym(SynAnalyzer.Symbol.SS_OPEN_PAR)) {
            syn.colon();
            token = syn.readSym(SynAnalyzer.Symbol.SS_DOMAIN, SynAnalyzer.Symbol.SS_OBJECTS, SynAnalyzer.Symbol.SS_INIT, SynAnalyzer.Symbol.SS_GOAL, SynAnalyzer.Symbol.SS_METRIC);
            switch (token.getSym()) {
                case SS_DOMAIN: {
                    syn.readId();
                    syn.closePar();
                    break;
                }
                case SS_OBJECTS: {
                    this.parseObjects(syn, taskImp, false);
                    break;
                }
                case SS_INIT: {
                    this.parseInit(syn, taskImp);
                    break;
                }
                case SS_GOAL: {
                    this.parseGoal(syn, taskImp);
                    break;
                }
                case SS_METRIC: {
                    this.parseMetric(syn, taskImp);
                }
            }
            token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR);
        }
        this.processSharedData(syn, taskImp, agList, agentName);
    }

    private void parseObjects(SynAnalyzer syn, TaskImp task, boolean priv) throws ParseException {
        SynAnalyzer.Token token;
        SynAnalyzer.Token token2 = token = priv ? syn.readSym(SynAnalyzer.Symbol.SS_ID, SynAnalyzer.Symbol.SS_CLOSE_PAR) : syn.readSym(SynAnalyzer.Symbol.SS_ID, SynAnalyzer.Symbol.SS_CLOSE_PAR, SynAnalyzer.Symbol.SS_OPEN_PAR);
        while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR)) {
            if (token.isSym(SynAnalyzer.Symbol.SS_OPEN_PAR)) {
                syn.colon();
                this.readPrivateToken(syn);
                this.parseObjects(syn, task, true);
            } else {
                ArrayList<String> objNames = new ArrayList<String>();
                ArrayList<String> parentTypes = new ArrayList<String>();
                while (token.isSym(SynAnalyzer.Symbol.SS_ID)) {
                    objNames.add(token.getDescLower());
                    token = syn.readSym(SynAnalyzer.Symbol.SS_ID, SynAnalyzer.Symbol.SS_CLOSE_PAR, SynAnalyzer.Symbol.SS_DASH);
                }
                if (token.isSym(SynAnalyzer.Symbol.SS_DASH)) {
                    this.parseTypeList(syn, parentTypes, task);
                } else {
                    parentTypes.add("object");
                }
                for (String objName : objNames) {
                    TaskImp.Value obj = this.addNewObject(syn, objName, task, priv);
                    for (String parent : parentTypes) {
                        TaskImp.Type type = this.getType(parent, task, syn);
                        obj.addType(type, syn);
                    }
                }
            }
            token = priv ? syn.readSym(SynAnalyzer.Symbol.SS_ID, SynAnalyzer.Symbol.SS_CLOSE_PAR) : syn.readSym(SynAnalyzer.Symbol.SS_ID, SynAnalyzer.Symbol.SS_CLOSE_PAR, SynAnalyzer.Symbol.SS_OPEN_PAR);
        }
    }

    private TaskImp.Value addNewObject(SynAnalyzer syn, String objName, TaskImp task, boolean priv) throws ParseException {
        TaskImp taskImp = task;
        taskImp.getClass();
        TaskImp.Value v = new TaskImp.Value(taskImp, objName);
        if (task.values.contains(v)) {
            syn.notifyError("Object '" + objName + "' redefined");
        }
        task.values.add(v);
        if (priv) {
            this.privateObjects.add(v);
        }
        return v;
    }

    private void parseInit(SynAnalyzer syn, TaskImp task) throws ParseException {
        SynAnalyzer.Token token;
        do {
            if (!(token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR)).isSym(SynAnalyzer.Symbol.SS_OPEN_PAR)) continue;
            syn.restoreLastToken();
            TaskImp.Assignment a = this.parseAssignment(syn, task, true);
            task.init.add(a);
        } while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR));
    }

    private TaskImp.Assignment parseAssignment(SynAnalyzer syn, TaskImp task, boolean readPar) throws ParseException {
        TaskImp.Assignment a;
        SynAnalyzer.Token token;
        if (readPar) {
            syn.openPar();
        }
        if ((token = syn.readSym(SynAnalyzer.Symbol.SS_EQUAL, SynAnalyzer.Symbol.SS_NOT, SynAnalyzer.Symbol.SS_PREFERENCE, SynAnalyzer.Symbol.SS_ID)).isSym(SynAnalyzer.Symbol.SS_PREFERENCE)) {
            String name = syn.readId();
            TaskImp.Assignment a2 = this.parseAssignment(syn, task, true);
            task.addPreference(name, a2, syn);
            syn.closePar();
            return null;
        }
        boolean isLiteral = !token.isSym(SynAnalyzer.Symbol.SS_EQUAL);
        boolean neg = token.isSym(SynAnalyzer.Symbol.SS_NOT);
        if (!neg) {
            if (isLiteral) {
                syn.restoreLastToken();
            } else {
                syn.openPar();
            }
        } else {
            syn.openPar();
            token = syn.readSym(SynAnalyzer.Symbol.SS_EQUAL, SynAnalyzer.Symbol.SS_ID);
            boolean bl = isLiteral = !token.isSym(SynAnalyzer.Symbol.SS_EQUAL);
            if (isLiteral) {
                syn.restoreLastToken();
            } else {
                syn.openPar();
            }
        }
        String varName = syn.readId();
        if (isLiteral) {
            ArrayList<TaskImp.Variable> arrayList = task.predicates;
            TaskImp taskImp = task;
            taskImp.getClass();
            int index = arrayList.indexOf(new TaskImp.Variable(taskImp, varName));
            if (index == -1) {
                syn.notifyError("Predicate '" + varName + "' undefined");
            }
            TaskImp taskImp2 = task;
            taskImp2.getClass();
            a = new TaskImp.Assignment(taskImp2, task.predicates.get(index), neg);
        } else {
            ArrayList<TaskImp.Function> arrayList = task.functions;
            TaskImp taskImp = task;
            taskImp.getClass();
            TaskImp taskImp3 = task;
            taskImp3.getClass();
            int index = arrayList.indexOf(new TaskImp.Function(taskImp, new TaskImp.Variable(taskImp3, varName), false));
            if (index == -1) {
                syn.notifyError("Function '" + varName + "' undefined");
            }
            TaskImp taskImp4 = task;
            taskImp4.getClass();
            a = new TaskImp.Assignment(taskImp4, task.functions.get(index), neg);
        }
        do {
            if (!(token = syn.readSym(SynAnalyzer.Symbol.SS_CLOSE_PAR, SynAnalyzer.Symbol.SS_ID)).isSym(SynAnalyzer.Symbol.SS_ID)) continue;
            syn.restoreLastToken();
            TaskImp.Value param = this.parseAssignmentValue(syn, task);
            a.params.add(param);
        } while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR));
        if (isLiteral) {
            a.values.add(task.values.get(0));
        } else {
            if (a.fnc.multiFunction) {
                syn.readSym(SynAnalyzer.Symbol.SS_OPEN_SET);
                do {
                    if (!(token = syn.readSym(SynAnalyzer.Symbol.SS_CLOSE_SET, SynAnalyzer.Symbol.SS_ID)).isSym(SynAnalyzer.Symbol.SS_ID)) continue;
                    syn.restoreLastToken();
                    a.values.add(this.parseAssignmentValue(syn, task));
                } while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_SET));
            } else {
                token = syn.readSym(SynAnalyzer.Symbol.SS_NUMBER, SynAnalyzer.Symbol.SS_ID);
                if (token.isSym(SynAnalyzer.Symbol.SS_NUMBER)) {
                    a.isNumeric = true;
                    try {
                        a.value = Double.parseDouble(token.getDesc());
                    }
                    catch (NumberFormatException e) {
                        syn.notifyError("'" + token.getDesc() + "' is not a valid number");
                    }
                } else {
                    syn.restoreLastToken();
                    a.values.add(this.parseAssignmentValue(syn, task));
                }
            }
            syn.closePar();
        }
        if (neg) {
            syn.closePar();
        }
        this.checkAssignment(syn, task, a);
        if (!readPar) {
            syn.restoreLastToken();
        }
        return a;
    }

    private TaskImp.Value parseAssignmentValue(SynAnalyzer syn, TaskImp task) throws ParseException {
        String valueName = syn.readId().toLowerCase();
        ArrayList<TaskImp.Value> arrayList = task.values;
        TaskImp taskImp = task;
        taskImp.getClass();
        int valueIndex = arrayList.indexOf(new TaskImp.Value(taskImp, valueName));
        if (valueIndex == -1) {
            syn.notifyError("Object '" + valueName + "' undefined");
        }
        return task.values.get(valueIndex);
    }

    private void checkAssignment(SynAnalyzer syn, TaskImp task, TaskImp.Assignment a) throws ParseException {
        TaskImp.Variable var;
        boolean isLiteral = a.var != null;
        TaskImp.Variable variable = var = isLiteral ? a.var : a.fnc.var;
        if (var.params.size() != a.params.size()) {
            syn.notifyError("Wrong number of parameters for literal '" + var.name + "'");
        }
        for (int i = 0; i < a.params.size(); ++i) {
            TaskImp.Value predParam = var.params.get(i);
            TaskImp.Value varParam = a.params.get(i);
            if (varParam.isCompatible(predParam)) continue;
            syn.notifyError("Invalid parameter '" + varParam.name + "' for literal '" + var.name + "'");
        }
        if (!isLiteral) {
            for (TaskImp.Value v : a.values) {
                if (v.isCompatible(a.fnc.domain)) continue;
                syn.notifyError("Wrong value '" + v.name + "' for function '" + var.name + "'");
            }
        }
    }

    private void parseGoal(SynAnalyzer syn, TaskImp task) throws ParseException {
        syn.openPar();
        SynAnalyzer.Token token = syn.readSym(SynAnalyzer.Symbol.SS_AND, SynAnalyzer.Symbol.SS_EQUAL, SynAnalyzer.Symbol.SS_ID, SynAnalyzer.Symbol.SS_PREFERENCE);
        if (token.isSym(SynAnalyzer.Symbol.SS_AND)) {
            do {
                if (!(token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR)).isSym(SynAnalyzer.Symbol.SS_OPEN_PAR)) continue;
                syn.restoreLastToken();
                TaskImp.Assignment a = this.parseAssignment(syn, task, true);
                if (a == null) continue;
                task.gGoals.add(a);
            } while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR));
            syn.closePar();
        } else if (token.isSym(SynAnalyzer.Symbol.SS_PREFERENCE)) {
            String name = syn.readId();
            TaskImp.Assignment a = this.parseAssignment(syn, task, true);
            task.addPreference(name, a, syn);
            syn.closePar();
        } else {
            syn.restoreLastToken();
            TaskImp.Assignment a = this.parseAssignment(syn, task, false);
            task.gGoals.add(a);
        }
    }

    private void processSharedData(SynAnalyzer syn, TaskImp task, AgentList agList, String agentName) throws ParseException {
        Map<TaskImp.Type, ArrayList<TaskImp.Type>> subtypesMap = this.generateRequiredSubtypes(syn, task);
        Map<String, TaskImp.Value> agents = this.generateAgentValues(agList, task, syn);
        this.changeObjectTypes(subtypesMap, task);
        for (TaskImp.Variable pred : task.predicates) {
            if (this.privatePredicates.contains(pred)) continue;
            this.generateSharedData(pred, subtypesMap, task, agents, agentName);
        }
    }

    private boolean usedInPublicPredicate(TaskImp.Value obj, TaskImp task) {
        boolean used = false;
        for (TaskImp.Variable pred : task.predicates) {
            if (this.privatePredicates.contains(pred)) continue;
            for (TaskImp.Value param : pred.params) {
                if (!obj.isCompatible(param)) continue;
                used = true;
                break;
            }
            if (!used) continue;
            break;
        }
        return used;
    }

    private Map<TaskImp.Type, ArrayList<TaskImp.Type>> generateRequiredSubtypes(SynAnalyzer syn, TaskImp task) throws ParseException {
        HashMap<TaskImp.Type, ArrayList<TaskImp.Type>> subtypesMap = new HashMap<TaskImp.Type, ArrayList<TaskImp.Type>>();
        for (TaskImp.Value obj : this.privateObjects) {
            if (!this.usedInPublicPredicate(obj, task)) continue;
            if (obj.types.size() != 1) {
                throw new UnsupportedOperationException("Private objects with multiple types not supported");
            }
            TaskImp.Type type = obj.types.get(0);
            if (subtypesMap.containsKey(type)) continue;
            TaskImp.Type pubSubtype = this.addNewType(syn, "pub-" + type.name, task);
            pubSubtype.addParentType(type, syn);
            TaskImp.Type privSubtype = this.addNewType(syn, "priv-" + type.name, task);
            privSubtype.addParentType(type, syn);
            ArrayList<TaskImp.Type> subtypes = new ArrayList<TaskImp.Type>(2);
            subtypes.add(pubSubtype);
            subtypes.add(privSubtype);
            subtypesMap.put(type, subtypes);
        }
        return subtypesMap;
    }

    private void changeObjectTypes(Map<TaskImp.Type, ArrayList<TaskImp.Type>> subtypesMap, TaskImp task) {
        for (TaskImp.Value obj : task.values) {
            boolean priv = this.privateObjects.contains(obj);
            for (int i = 0; i < obj.types.size(); ++i) {
                TaskImp.Type type = obj.types.get(i);
                ArrayList<TaskImp.Type> subtypes = subtypesMap.get(type);
                if (subtypes == null) continue;
                TaskImp.Type newType = subtypes.get(priv ? 1 : 0);
                obj.types.set(i, newType);
            }
        }
    }

    private void generateSharedData(TaskImp.Variable pred, Map<TaskImp.Type, ArrayList<TaskImp.Type>> subtypesMap, TaskImp task, Map<String, TaskImp.Value> agList, String agentName) {
        TaskImp taskImp = task;
        taskImp.getClass();
        TaskImp.Variable sharedPred = new TaskImp.Variable(taskImp, pred.name);
        for (TaskImp.Value param : pred.params) {
            ArrayList<TaskImp.Type> paramTypes = this.getBasicTypes(param, subtypesMap, task);
            TaskImp taskImp2 = task;
            taskImp2.getClass();
            TaskImp.Value newParam = new TaskImp.Value(taskImp2, param.name);
            newParam.isVariable = param.isVariable;
            for (TaskImp.Type type : paramTypes) {
                ArrayList<TaskImp.Type> subtypes = subtypesMap.get(type);
                if (subtypes == null) {
                    newParam.types.add(type);
                    continue;
                }
                newParam.types.add(subtypes.get(0));
            }
            sharedPred.params.add(newParam);
        }
        TaskImp taskImp3 = task;
        taskImp3.getClass();
        TaskImp.SharedData sd = new TaskImp.SharedData(taskImp3, sharedPred);
        for (String agName : agList.keySet()) {
            if (agentName.equalsIgnoreCase(agName)) continue;
            TaskImp.Value agent = agList.get(agName);
            sd.agents.add(agent);
        }
        task.sharedData.add(sd);
    }

    private ArrayList<TaskImp.Type> getBasicTypes(TaskImp.Value param, Map<TaskImp.Type, ArrayList<TaskImp.Type>> subtypesMap, TaskImp task) {
        ArrayList<TaskImp.Type> paramTypes = new ArrayList<TaskImp.Type>();
        for (TaskImp.Type type : param.types) {
            this.addBasicTypes(type, paramTypes, subtypesMap, task);
        }
        return paramTypes;
    }

    private void addBasicTypes(TaskImp.Type type, ArrayList<TaskImp.Type> paramTypes, Map<TaskImp.Type, ArrayList<TaskImp.Type>> subtypesMap, TaskImp task) {
        if (!this.hasSubtypes(type, task)) {
            paramTypes.add(type);
        } else {
            ArrayList<TaskImp.Type> subtypes = subtypesMap.get(type);
            if (subtypes != null || this.areObjectsOfThisType(type, task)) {
                paramTypes.add(type);
            }
            for (TaskImp.Type t : task.types) {
                if (!t.parentTypes.contains(type) || subtypes != null && (t.equals(subtypes.get(0)) || t.equals(subtypes.get(1)))) continue;
                this.addBasicTypes(t, paramTypes, subtypesMap, task);
            }
        }
    }

    private boolean hasSubtypes(TaskImp.Type type, TaskImp task) {
        for (TaskImp.Type t : task.types) {
            if (!t.parentTypes.contains(type)) continue;
            return true;
        }
        return false;
    }

    private boolean areObjectsOfThisType(TaskImp.Type type, TaskImp task) {
        for (TaskImp.Value obj : task.values) {
            if (!obj.types.contains(type)) continue;
            return true;
        }
        return false;
    }

    private Map<String, TaskImp.Value> generateAgentValues(AgentList agList, TaskImp task, SynAnalyzer syn) throws ParseException {
        HashMap<String, TaskImp.Value> agents = new HashMap<String, TaskImp.Value>(agList.numAgents());
        TaskImp.Type agType = this.getType("agent", task, syn);
        ArrayList<TaskImp.Type> agTypeList = new ArrayList<TaskImp.Type>(1);
        agTypeList.add(agType);
        for (int i = 0; i < agList.numAgents(); ++i) {
            String name = agList.getName(i);
            TaskImp taskImp = task;
            taskImp.getClass();
            TaskImp.Value value = new TaskImp.Value(taskImp, name);
            int objIndex = task.values.indexOf(value);
            if (objIndex < 0) {
                value.types.add(agType);
                task.values.add(value);
            } else {
                value = task.values.get(objIndex);
                if (!value.isCompatible(agTypeList)) {
                    value.types.add(agType);
                }
            }
            agents.put(name, value);
        }
        return agents;
    }

    private void parseFunctions(SynAnalyzer syn, TaskImp task, boolean multi) throws ParseException {
        SynAnalyzer.Token token;
        do {
            if (!(token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR)).isSym(SynAnalyzer.Symbol.SS_OPEN_PAR)) continue;
            ArrayList<TaskImp.Variable> functionList = new ArrayList<TaskImp.Variable>();
            ArrayList<TaskImp.Type> domain = new ArrayList<TaskImp.Type>();
            do {
                syn.restoreLastToken();
                functionList.add(this.parsePredicate(syn, task, false, true, false));
            } while ((token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_DASH)).isSym(SynAnalyzer.Symbol.SS_OPEN_PAR));
            ArrayList<String> typeNames = new ArrayList<String>();
            this.parseTypeList(syn, typeNames, task);
            domain.clear();
            for (String type : typeNames) {
                TaskImp.Type t = this.getType(type, task, syn);
                domain.add(t);
            }
            for (TaskImp.Variable v : functionList) {
                if (task.existVariable(v)) {
                    syn.notifyError("Function '" + v.name + "' redefined");
                }
                TaskImp taskImp = task;
                taskImp.getClass();
                TaskImp.Function f = new TaskImp.Function(taskImp, v, multi);
                f.setDomain(domain);
                task.functions.add(f);
            }
        } while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR));
    }

    private TaskImp.NumericExpressionImp parseNumericExpression(SynAnalyzer syn, TaskImp task, TaskImp.Operator op, TaskImp.CongestionImp congestion) throws ParseException {
        SynAnalyzer.Token token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_NUMBER);
        TaskImp.NumericExpressionImp exp = null;
        if (token.isSym(SynAnalyzer.Symbol.SS_NUMBER)) {
            try {
                double value = Double.parseDouble(token.getDesc());
                TaskImp taskImp = task;
                taskImp.getClass();
                exp = new TaskImp.NumericExpressionImp(taskImp, value);
            }
            catch (NumberFormatException e) {
                syn.notifyError("Invalid number: " + token.getDesc());
            }
        } else {
            token = syn.readSym(SynAnalyzer.Symbol.SS_PLUS, SynAnalyzer.Symbol.SS_DASH, SynAnalyzer.Symbol.SS_MULT, SynAnalyzer.Symbol.SS_DIV, SynAnalyzer.Symbol.SS_NUMBER, SynAnalyzer.Symbol.SS_ID);
            if (token.isSym(SynAnalyzer.Symbol.SS_NUMBER)) {
                syn.restoreLastToken();
                exp = this.parseNumericExpression(syn, task, op, congestion);
            } else if (token.isSym(SynAnalyzer.Symbol.SS_ID)) {
                if (token.getDesc().equalsIgnoreCase("usage")) {
                    TaskImp taskImp = task;
                    taskImp.getClass();
                    exp = new TaskImp.NumericExpressionImp(taskImp, TaskImp.NumericExpressionType.NET_USAGE);
                } else {
                    syn.restoreLastToken();
                    TaskImp.Variable v = this.parseOperatorVariable(syn, task, op);
                    TaskImp.Function function = this.checkFunction(v, syn, task);
                    if (!function.isNumeric()) {
                        syn.notifyError("Function '" + v.name + "' is not numeric");
                    }
                    TaskImp taskImp = task;
                    taskImp.getClass();
                    exp = new TaskImp.NumericExpressionImp(taskImp, v);
                }
            } else {
                switch (token.getSym()) {
                    case SS_PLUS: {
                        TaskImp taskImp = task;
                        taskImp.getClass();
                        exp = new TaskImp.NumericExpressionImp(taskImp, TaskImp.NumericExpressionType.NET_ADD);
                        break;
                    }
                    case SS_DASH: {
                        TaskImp taskImp = task;
                        taskImp.getClass();
                        exp = new TaskImp.NumericExpressionImp(taskImp, TaskImp.NumericExpressionType.NET_DEL);
                        break;
                    }
                    case SS_MULT: {
                        TaskImp taskImp = task;
                        taskImp.getClass();
                        exp = new TaskImp.NumericExpressionImp(taskImp, TaskImp.NumericExpressionType.NET_PROD);
                        break;
                    }
                    case SS_DIV: {
                        TaskImp taskImp = task;
                        taskImp.getClass();
                        exp = new TaskImp.NumericExpressionImp(taskImp, TaskImp.NumericExpressionType.NET_DIV);
                    }
                }
                exp.left = this.parseNumericExpression(syn, task, op, congestion);
                exp.right = this.parseNumericExpression(syn, task, op, congestion);
            }
            syn.closePar();
        }
        return exp;
    }

    private void parseMetric(SynAnalyzer syn, TaskImp task) throws ParseException {
        syn.readSym(SynAnalyzer.Symbol.SS_MINIMIZE);
        SynAnalyzer.Token token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR, SynAnalyzer.Symbol.SS_TOTAL_TIME);
        if (token.isSym(SynAnalyzer.Symbol.SS_TOTAL_TIME)) {
            syn.restoreLastToken();
            task.metric = this.parseMetricTerm(syn, task);
        } else {
            while (token.isSym(SynAnalyzer.Symbol.SS_OPEN_PAR)) {
                task.metric = this.parseMetricTerm(syn, task);
                token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR);
            }
        }
    }

    private TaskImp.MetricImp parseMetricTerm(SynAnalyzer syn, TaskImp task) throws ParseException {
        TaskImp.MetricImp m = null;
        SynAnalyzer.Token token = syn.readSym(SynAnalyzer.Symbol.SS_IS_VIOLATED, SynAnalyzer.Symbol.SS_PLUS, SynAnalyzer.Symbol.SS_MULT, SynAnalyzer.Symbol.SS_TOTAL_TIME, SynAnalyzer.Symbol.SS_ID);
        if (token.isSym(SynAnalyzer.Symbol.SS_IS_VIOLATED)) {
            TaskImp taskImp = task;
            taskImp.getClass();
            m = new TaskImp.MetricImp(taskImp, syn.readId(), syn);
            syn.closePar();
        } else if (token.isSym(SynAnalyzer.Symbol.SS_TOTAL_TIME)) {
            m = new TaskImp.MetricImp(task);
            syn.closePar();
        } else if (!token.isSym(SynAnalyzer.Symbol.SS_ID)) {
            TaskImp taskImp = task;
            taskImp.getClass();
            m = new TaskImp.MetricImp(taskImp, token.getSym());
            token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR, SynAnalyzer.Symbol.SS_NUMBER);
            while (!token.isSym(SynAnalyzer.Symbol.SS_CLOSE_PAR)) {
                if (token.isSym(SynAnalyzer.Symbol.SS_OPEN_PAR)) {
                    m.term.add(this.parseMetricTerm(syn, task));
                } else {
                    try {
                        ArrayList<TaskImp.MetricImp> arrayList = m.term;
                        TaskImp taskImp2 = task;
                        taskImp2.getClass();
                        arrayList.add(new TaskImp.MetricImp(taskImp2, Double.parseDouble(token.getDesc())));
                    }
                    catch (NumberFormatException e) {
                        syn.notifyError("Invalid number format in metric: " + token.getDesc());
                    }
                }
                token = syn.readSym(SynAnalyzer.Symbol.SS_OPEN_PAR, SynAnalyzer.Symbol.SS_CLOSE_PAR, SynAnalyzer.Symbol.SS_NUMBER);
            }
        } else {
            m = new TaskImp.MetricImp(task);
            syn.closePar();
        }
        return m;
    }

    @Override
    public boolean isMAPDDL(String domainFile) throws IOException {
        String content = this.readToString(domainFile).toLowerCase();
        return content.contains(":factored");
    }

    @Override
    public AgentList createEmptyAgentList() {
        return new AgentListImp();
    }
}

