/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_negotiation;

import org.agreement_technologies.common.map_communication.AgentCommunication;
import org.agreement_technologies.common.map_negotiation.NegotiationFactory;
import org.agreement_technologies.common.map_negotiation.PlanSelection;
import org.agreement_technologies.common.map_planner.POPSearchMethod;
import org.agreement_technologies.service.map_negotiation.CooperativePlanSelection;
import org.agreement_technologies.service.map_negotiation.CustomBordaNegotiation;

public class NegotiationFactoryImp
implements NegotiationFactory {
    private final int negotiationType;

    public NegotiationFactoryImp(int neg) {
        this.negotiationType = neg;
    }

    @Override
    public PlanSelection getNegotiationMethod(AgentCommunication c, POPSearchMethod st) {
        PlanSelection ps;
        switch (this.negotiationType) {
            case 0: {
                ps = new CooperativePlanSelection(c, st);
                break;
            }
            case 1: {
                ps = new CustomBordaNegotiation(c, st, 10);
                break;
            }
            default: {
                ps = null;
            }
        }
        return ps;
    }

    @Override
    public int getNegotiationType() {
        return this.negotiationType;
    }
}

