/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_landmarks;

import java.util.ArrayList;
import org.agreement_technologies.common.map_grounding.GroundedVar;
import org.agreement_technologies.common.map_landmarks.LandmarkAction;
import org.agreement_technologies.common.map_landmarks.LandmarkFluent;

public class LMLiteral
implements LandmarkFluent {
    private final GroundedVar var;
    private final String value;
    private int level;
    private int index;
    private ArrayList<LandmarkAction> producers;
    private ArrayList<LandmarkAction> totalProducers;
    private final boolean isGoal;
    private final ArrayList<String> agents;

    public LMLiteral(GroundedVar v, String val, int t, String[] ag, boolean goal) {
        this.var = v;
        this.value = val;
        this.level = t;
        this.isGoal = goal;
        this.agents = new ArrayList(ag.length);
        if (ag.length == 1) {
            this.agents.add(ag[0]);
        } else {
            for (String a : ag) {
                this.agents.add(a);
            }
        }
    }

    public LMLiteral(String val, ArrayList<String> ag) {
        this.value = val;
        this.agents = ag;
        this.var = null;
        this.level = -1;
        this.index = -1;
        this.isGoal = false;
    }

    public void setProducers(ArrayList<LandmarkAction> p) {
        this.producers = p;
    }

    @Override
    public ArrayList<LandmarkAction> getProducers() {
        return this.producers;
    }

    public void setTotalProducers(ArrayList<LandmarkAction> p) {
        this.totalProducers = p;
    }

    @Override
    public ArrayList<LandmarkAction> getTotalProducers() {
        return this.totalProducers;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public GroundedVar getVar() {
        return this.var;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public void setLevel(int l) {
        this.level = l;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public boolean isGoal() {
        return this.isGoal;
    }

    public String toString() {
        if (this.var != null) {
            return this.var.toString() + " " + this.value;
        }
        return this.value;
    }

    @Override
    public String getVarName() {
        return this.var.toString();
    }

    @Override
    public ArrayList<String> getAgents() {
        return this.agents;
    }
}

