/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_landmarks;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.agreement_technologies.common.map_grounding.Action;
import org.agreement_technologies.common.map_grounding.GroundedCond;
import org.agreement_technologies.common.map_grounding.GroundedEff;
import org.agreement_technologies.common.map_grounding.GroundedTask;
import org.agreement_technologies.common.map_grounding.GroundedVar;
import org.agreement_technologies.common.map_landmarks.LandmarkAction;
import org.agreement_technologies.common.map_landmarks.LandmarkFluent;
import org.agreement_technologies.service.map_landmarks.LMLiteral;
import org.agreement_technologies.service.map_landmarks.RPG;

public class LMAction
implements LandmarkAction {
    private String name;
    private int level;
    private final ArrayList<LandmarkFluent> preconditions;
    private final ArrayList<LandmarkFluent> effects;

    public LMAction(Action a, Hashtable<String, GroundedVar> vars, Hashtable<String, LMLiteral> lits, RPG rpg) {
        LMLiteral l;
        String[] agents;
        this.name = a.getOperatorName();
        for (String s : a.getParams()) {
            this.name = this.name + " " + s;
        }
        this.level = a.getMinTime();
        this.preconditions = new ArrayList();
        this.effects = new ArrayList();
        for (GroundedCond p : a.getPrecs()) {
            if (vars.get(p.getVar().toString()) == null) {
                vars.put(p.getVar().toString(), p.getVar());
            }
            if (lits.get(p.getVar().toString() + " " + p.getValue()) == null) {
                agents = rpg.getAgents(p.getVar(), p.getValue());
                l = new LMLiteral(vars.get(p.getVar().toString()), p.getValue(), p.getVar().getMinTime(p.getValue()), agents, false);
                lits.put(l.toString(), l);
            }
            this.preconditions.add(lits.get(p.getVar().toString() + " " + p.getValue()));
        }
        for (GroundedEff e : a.getEffs()) {
            if (vars.get(e.getVar().toString()) == null) {
                vars.put(e.getVar().toString(), e.getVar());
            }
            if (lits.get(e.getVar().toString() + " " + e.getValue()) == null) {
                agents = rpg.getAgents(e.getVar(), e.getValue());
                l = new LMLiteral(vars.get(e.getVar().toString()), e.getValue(), e.getVar().getMinTime(e.getValue()), agents, false);
                lits.put(l.toString(), l);
            }
            this.effects.add(lits.get(e.getVar().toString() + " " + e.getValue()));
        }
    }

    private String[] getAgents(GroundedTask gt, GroundedVar v, String val) {
        ArrayList<String> agents = new ArrayList<String>();
        for (int i = 0; i < gt.getAgentNames().length; ++i) {
            if (gt.getAgentNames()[i].equals(gt.getAgentName())) {
                agents.add(gt.getAgentNames()[i]);
                continue;
            }
            if (!v.shareable(val, gt.getAgentNames()[i])) continue;
            agents.add(gt.getAgentNames()[i]);
        }
        String[] agentsArray = new String[agents.size()];
        int pos = 0;
        Iterator i$ = agents.iterator();
        while (i$.hasNext()) {
            String ag;
            agentsArray[pos] = ag = (String)i$.next();
            ++pos;
        }
        return agentsArray;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int l) {
        this.level = l;
    }

    @Override
    public ArrayList<LandmarkFluent> getPreconditions() {
        return this.preconditions;
    }

    @Override
    public ArrayList<LandmarkFluent> getEffects() {
        return this.effects;
    }

    public String toString() {
        return this.name;
    }
}

