/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_landmarks;

import java.util.ArrayList;
import org.agreement_technologies.common.map_landmarks.LandmarkAction;
import org.agreement_technologies.common.map_landmarks.LandmarkFluent;
import org.agreement_technologies.common.map_landmarks.LandmarkNode;
import org.agreement_technologies.common.map_landmarks.LandmarkSet;

public class LGNode
implements LandmarkNode {
    private final LandmarkFluent literal;
    private final LandmarkSet disjunction;
    private final boolean type;
    private int index;
    private ArrayList<String> agents;
    private ArrayList<Integer> antecessors;
    private int globalId;

    public LGNode(LandmarkSet u) {
        this.literal = null;
        this.disjunction = u;
        this.type = false;
        this.antecessors = new ArrayList();
        this.globalId = -1;
    }

    public LGNode(LandmarkFluent lit) {
        this.literal = lit;
        this.disjunction = null;
        this.type = true;
        this.antecessors = new ArrayList();
        this.globalId = -1;
    }

    @Override
    public int setGlobalId(int globalIndex) {
        this.globalId = globalIndex;
        return globalIndex + 1;
    }

    @Override
    public int getGlobalId() {
        return this.globalId;
    }

    @Override
    public void setAntecessors(ArrayList<Integer> ant) {
        this.antecessors = ant;
    }

    public ArrayList<Integer> getAntecessors() {
        return this.antecessors;
    }

    @Override
    public ArrayList<LandmarkAction> getProducers() {
        if (this.type) {
            return this.literal.getProducers();
        }
        ArrayList<LandmarkAction> a = new ArrayList<LandmarkAction>();
        for (LandmarkFluent l : this.disjunction.getElements()) {
            for (LandmarkAction p : l.getProducers()) {
                if (a.contains(p)) continue;
                a.add(p);
            }
        }
        return a;
    }

    public ArrayList<LandmarkAction> getTotalProducers() {
        if (this.type) {
            return this.literal.getTotalProducers();
        }
        ArrayList<LandmarkAction> a = new ArrayList<LandmarkAction>();
        for (LandmarkFluent l : this.disjunction.getElements()) {
            for (LandmarkAction p : l.getTotalProducers()) {
                if (a.contains(p)) continue;
                a.add(p);
            }
        }
        return a;
    }

    @Override
    public ArrayList<String> getAgents() {
        if (this.type) {
            return this.literal.getAgents();
        }
        return this.agents;
    }

    @Override
    public void setAgents(ArrayList<String> ag) {
        this.agents = ag;
    }

    @Override
    public boolean isSingleLiteral() {
        return this.type;
    }

    @Override
    public LandmarkFluent getLiteral() {
        return this.literal;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public String identify() {
        if (this.type) {
            return this.literal.toString();
        }
        return this.disjunction.identify();
    }

    public String toString() {
        if (this.type) {
            if (this.literal != null) {
                if (this.isGoal()) {
                    return "Global[" + this.getGlobalId() + "]Local[" + this.index + "] " + this.literal.toString() + " [Goal]";
                }
                if (this.literal.getLevel() == 0) {
                    return "Global[" + this.getGlobalId() + "]Local[" + this.index + "] " + this.literal.toString() + " [Initial state]";
                }
                return "Global[" + this.getGlobalId() + "]Local[" + this.index + "] " + this.literal.toString();
            }
            return "[" + this.index + "] " + this.literal.toString();
        }
        String res = "[" + this.index + "] " + "{";
        for (LandmarkFluent l : this.disjunction.getElements()) {
            res = res + l.toString() + ", ";
        }
        return res + "}";
    }

    @Override
    public LandmarkSet getDisjunction() {
        if (this.type) {
            return null;
        }
        return this.disjunction;
    }

    @Override
    public LandmarkFluent[] getLiterals() {
        LandmarkFluent[] f;
        if (this.type) {
            f = new LandmarkFluent[]{this.literal};
        } else {
            f = new LandmarkFluent[this.disjunction.getElements().size()];
            for (int i = 0; i < this.disjunction.getElements().size(); ++i) {
                f[i] = this.disjunction.getElements().get(i);
            }
        }
        return f;
    }

    @Override
    public boolean isGoal() {
        return this.type && this.literal.isGoal();
    }

    public boolean equals(Object x) {
        return this.index == ((LandmarkNode)x).getIndex();
    }

    public int hashCode() {
        return this.index;
    }
}

