/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_heuristic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.agreement_technologies.common.map_grounding.Action;
import org.agreement_technologies.common.map_grounding.GroundedCond;

public class RPG {
    private HashMap<VarValue, Integer> literalLevels;
    private HashMap<String, Integer> actionLevels;
    private int numLevels;

    public RPG(HashMap<String, ArrayList<String>> state, ArrayList<GroundedCond> goals, ArrayList<GroundedCond> pgoals, HashMap<String, ArrayList<Action>> requirers) {
        VarValue gv;
        ArrayList<VarValue> lastLevel = new ArrayList<VarValue>(2 * state.size());
        ArrayList<VarValue> newLevel = new ArrayList<VarValue>(2 * state.size());
        this.literalLevels = new HashMap();
        this.actionLevels = new HashMap();
        ArrayList<VarValue> remainingGoals = new ArrayList<VarValue>(goals.size());
        for (String var : state.keySet()) {
            VarValue v = new VarValue(var, state.get(var).get(0), 0);
            lastLevel.add(v);
            this.literalLevels.put(v, 0);
        }
        for (GroundedCond g : goals) {
            gv = new VarValue(g.getVar().toString(), g.getValue(), 0);
            if (this.literalLevels.containsKey(gv)) continue;
            remainingGoals.add(gv);
        }
        for (GroundedCond g : pgoals) {
            gv = new VarValue(g.getVar().toString(), g.getValue(), 0);
            if (this.literalLevels.containsKey(gv)) continue;
            remainingGoals.add(gv);
        }
        this.numLevels = 0;
        while (!remainingGoals.isEmpty() && !lastLevel.isEmpty()) {
            newLevel.clear();
            for (VarValue v : lastLevel) {
                ArrayList<Action> aList = requirers.get(v.getId());
                if (aList == null) continue;
                for (Action a : aList) {
                    if (this.actionLevels.containsKey(a.toString())) continue;
                    boolean executable = true;
                    for (GroundedCond groundedCond : a.getPrecs()) {
                        if (this.holds(groundedCond)) continue;
                        executable = false;
                        break;
                    }
                    if (!executable) continue;
                    this.actionLevels.put(a.toString(), this.numLevels);
                    for (Serializable serializable : a.getEffs()) {
                        VarValue ev = new VarValue(serializable.getVar().toString(), serializable.getValue(), this.numLevels + 1);
                        if (this.literalLevels.containsKey(ev) || newLevel.contains(ev)) continue;
                        newLevel.add(ev);
                    }
                }
            }
            ++this.numLevels;
            for (VarValue v : newLevel) {
                this.literalLevels.put(v, v.level);
                remainingGoals.remove(v);
            }
            ArrayList<VarValue> aux = lastLevel;
            lastLevel = newLevel;
            newLevel = aux;
        }
    }

    private boolean holds(GroundedCond prec) {
        return this.literalLevels.containsKey(new VarValue(prec.getVar().toString(), prec.getValue(), 0));
    }

    public int numLevels() {
        return this.numLevels;
    }

    public VarValue getVarValue(GroundedCond g) {
        VarValue v = new VarValue(g.getVar().toString(), g.getValue(), 0);
        Integer level = this.literalLevels.get(v);
        if (level == null) {
            return null;
        }
        v.level = level;
        return v;
    }

    public int getLevel(Action a) {
        Integer level = this.actionLevels.get(a.toString());
        return level != null ? level : -1;
    }

    public int getDifficulty(Action a) {
        int d = 0;
        for (GroundedCond prec : a.getPrecs()) {
            VarValue v = new VarValue(prec.getVar().toString(), prec.getValue(), 0);
            d += this.literalLevels.get(v).intValue();
        }
        return d;
    }

    public static class VarValue
    implements Comparable<VarValue> {
        String var;
        String value;
        int level;

        public VarValue(String var, String value, int level) {
            this.var = var;
            this.value = value;
            this.level = level;
        }

        public String toString() {
            return this.var + "=" + this.value + "(" + this.level + ")";
        }

        public String getId() {
            return this.var + "=" + this.value;
        }

        public boolean equals(Object x) {
            VarValue v = (VarValue)x;
            return this.var.equals(v.var) && this.value.equals(v.value);
        }

        public int hashCode() {
            return (this.var + this.value).hashCode();
        }

        @Override
        public int compareTo(VarValue v) {
            return v.level - this.level;
        }
    }
}

