/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_heuristic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.PriorityQueue;
import org.agreement_technologies.common.map_communication.AgentCommunication;
import org.agreement_technologies.common.map_communication.Message;
import org.agreement_technologies.common.map_communication.MessageFilter;
import org.agreement_technologies.common.map_dtg.DTG;
import org.agreement_technologies.common.map_dtg.DTGSet;
import org.agreement_technologies.common.map_dtg.DTGTransition;
import org.agreement_technologies.common.map_grounding.Action;
import org.agreement_technologies.common.map_grounding.GroundedCond;
import org.agreement_technologies.common.map_grounding.GroundedEff;
import org.agreement_technologies.common.map_grounding.GroundedTask;
import org.agreement_technologies.common.map_grounding.GroundedVar;
import org.agreement_technologies.common.map_heuristic.HPlan;
import org.agreement_technologies.common.map_heuristic.Heuristic;
import org.agreement_technologies.common.map_landmarks.LandmarkFluent;
import org.agreement_technologies.common.map_landmarks.LandmarkNode;
import org.agreement_technologies.common.map_landmarks.LandmarkOrdering;
import org.agreement_technologies.common.map_landmarks.Landmarks;
import org.agreement_technologies.common.map_planner.Condition;
import org.agreement_technologies.common.map_planner.PlannerFactory;
import org.agreement_technologies.common.map_planner.Step;
import org.agreement_technologies.service.map_dtg.DTGSetImp;
import org.agreement_technologies.service.map_heuristic.GoalCondition;
import org.agreement_technologies.service.map_heuristic.HeuristicToolkit;
import org.agreement_technologies.service.map_landmarks.LandmarksImp;

public class LandmarksHeuristic
implements Heuristic {
    private static final int PENALTY = 1000;
    private static final int DTG_PENALTY = 1;
    protected GroundedTask groundedTask;
    protected AgentCommunication comm;
    protected ArrayList<Goal> goals;
    protected ArrayList<Goal> pgoals;
    protected HashMap<String, ArrayList<Action>> productors;
    protected DTGSet dtgs;
    private Landmarks landmarks;
    private ArrayList<LandmarkCheck> landmarkNodes;
    private ArrayList<LandmarkCheck> rootLandmarkNodes;
    private HPlan basePlan;
    private int[] totalOrderBase;
    private int requestId;
    private int ready;
    private boolean incremental_dtg;
    private boolean requiresHLandStage;
    private PlannerFactory pf;
    private HashMap<String, Boolean> booleanVariable;

    public LandmarksHeuristic(AgentCommunication comm, GroundedTask gTask, boolean incremental_dtg, PlannerFactory pf) {
        this.pf = pf;
        this.groundedTask = gTask;
        this.comm = comm;
        this.incremental_dtg = incremental_dtg;
        this.dtgs = new DTGSetImp(gTask);
        this.dtgs.distributeDTGs(comm, gTask);
        this.goals = new ArrayList();
        this.pgoals = new ArrayList();
        ArrayList<GoalCondition> gc = HeuristicToolkit.computeTaskGoals(comm, gTask);
        for (GoalCondition goalCondition : gc) {
            GroundedVar var = null;
            for (GroundedVar v : gTask.getVars()) {
                if (!v.toString().equals(goalCondition.varName)) continue;
                var = v;
                break;
            }
            if (var == null) continue;
            Goal ng = new Goal(gTask.createGroundedCondition(1, var, goalCondition.value), 0);
            this.goals.add(ng);
        }
        for (GroundedCond groundedCond : gTask.getPreferences()) {
            this.pgoals.add(new Goal(groundedCond, 0));
        }
        this.productors = new HashMap();
        for (Action action : gTask.getActions()) {
            for (GroundedEff e : action.getEffs()) {
                String desc = e.getVar().toString() + "," + e.getValue();
                ArrayList<Action> list = this.productors.get(desc);
                if (list == null) {
                    list = new ArrayList();
                    this.productors.put(desc, list);
                }
                list.add(action);
            }
        }
        this.booleanVariable = new HashMap(gTask.getVars().length);
        for (GroundedVar v : gTask.getVars()) {
            this.booleanVariable.put(v.toString(), v.isBoolean());
        }
        this.initializeLandmarks();
        this.requestId = 0;
    }

    private void initializeLandmarks() {
        LandmarkCheck l;
        this.landmarks = new LandmarksImp(this.groundedTask, this.comm);
        this.landmarks.filterTransitiveOrders();
        ArrayList<LandmarkNode> nodes = this.landmarks.getNodes();
        this.checkIfRequiresHLandStage(nodes);
        this.landmarkNodes = new ArrayList(nodes.size());
        for (LandmarkNode n : nodes) {
            l = new LandmarkCheck(n, false, this.goals);
            this.landmarkNodes.add(l);
        }
        ArrayList<LandmarkOrdering> orderings = this.landmarks.getOrderings(3, false);
        for (LandmarkOrdering o : orderings) {
            int n1 = o.getNode1().getIndex();
            int n2 = o.getNode2().getIndex();
            LandmarkCheck l1 = this.landmarkNodes.get(n1);
            LandmarkCheck l2 = this.landmarkNodes.get(n2);
            l1.addSuccessor(l2);
            l2.addPredecessor(l1);
        }
        for (Goal g : this.goals) {
            boolean found = false;
            for (LandmarkCheck l2 : this.landmarkNodes) {
                if (!l2.matches(g)) continue;
                found = true;
                break;
            }
            if (found) continue;
            LandmarkCheck l3 = new LandmarkCheck(g);
            this.landmarkNodes.add(l3);
        }
        int i = 0;
        while (i < this.landmarkNodes.size()) {
            l = this.landmarkNodes.get(i);
            if (l.single && l.predecessors.isEmpty()) {
                GroundedVar v = this.groundedTask.getVarByName(l.varNames[0]);
                if (this.InInitialState(l, v)) {
                    this.landmarkNodes.remove(i);
                    for (LandmarkCheck s : l.successors) {
                        s.removePredecessor(l);
                    }
                    continue;
                }
                ++i;
                continue;
            }
            ++i;
        }
        this.rootLandmarkNodes = new ArrayList();
        for (i = 0; i < this.landmarkNodes.size(); ++i) {
            l = this.landmarkNodes.get(i);
            l.index = i;
            if (!l.predecessors.isEmpty()) continue;
            l.isRoot = true;
            this.rootLandmarkNodes.add(l);
        }
    }

    private boolean InInitialState(LandmarkCheck l, GroundedVar v) {
        String lValue = l.varValues[0];
        for (String obj : v.getReachableValues()) {
            int time = v.getMinTime(obj);
            if (time != 0 || !obj.equals(lValue)) continue;
            return true;
        }
        return false;
    }

    private void checkIfRequiresHLandStage(ArrayList<LandmarkNode> nodes) {
        this.requiresHLandStage = false;
        if (this.comm.numAgents() == 1) {
            return;
        }
        int numNodes = this.landmarks.numTotalNodes();
        boolean[] visibleNode = new boolean[numNodes];
        for (LandmarkNode n : nodes) {
            if (!n.isSingleLiteral()) continue;
            visibleNode[n.getGlobalId()] = true;
        }
        for (int i = 0; i < numNodes; ++i) {
            if (visibleNode[i]) continue;
            this.requiresHLandStage = true;
            break;
        }
        if (this.comm.batonAgent()) {
            for (String ag : this.comm.getOtherAgents()) {
                Boolean req = (Boolean)this.comm.receiveMessage(ag, false);
                if (!req.booleanValue()) continue;
                this.requiresHLandStage = true;
            }
            this.comm.sendMessage(Boolean.valueOf(this.requiresHLandStage), false);
        } else {
            this.comm.sendMessage(this.comm.getBatonAgent(), Boolean.valueOf(this.requiresHLandStage), false);
            this.requiresHLandStage = (Boolean)this.comm.receiveMessage(this.comm.getBatonAgent(), false);
        }
    }

    @Override
    public void startEvaluation(HPlan basePlan) {
        this.basePlan = basePlan;
        this.ready = 0;
        this.totalOrderBase = null;
    }

    @Override
    public void evaluatePlan(HPlan p, int threadIndex) {
        if (p.isSolution()) {
            return;
        }
        this.dtgs.clearCache(threadIndex);
        if (this.comm.numAgents() == 1) {
            this.evaluateMonoagentPlan(p, threadIndex);
        } else {
            this.evaluateMultiagentPlan(p, null);
        }
    }

    @Override
    public void evaluatePlan(HPlan p, int threadIndex, ArrayList<Integer> achievedLandmarks) {
        if (p.isSolution()) {
            return;
        }
        this.dtgs.clearCache(threadIndex);
        this.evaluateMultiagentPlan(p, achievedLandmarks);
    }

    private void computeState(HPlan currentPlan, HashMap<String, String> state, int[] totalOrder, boolean[] checked) {
        ArrayList<LandmarkCheck> openLandmarkNodes = new ArrayList<LandmarkCheck>(this.landmarkNodes.size());
        for (LandmarkCheck l : this.rootLandmarkNodes) {
            openLandmarkNodes.add(l);
        }
        ArrayList<Step> stepList = currentPlan.getStepsArray();
        for (int step : totalOrder) {
            Step action = stepList.get(step);
            for (Condition eff : action.getEffs()) {
                String varName = this.pf.getVarNameFromCode(eff.getVarCode());
                String varValue = this.pf.getValueFromCode(eff.getValueCode());
                if (varName == null || varValue == null) continue;
                state.put(varName, varValue);
            }
            this.checkLandmarks(openLandmarkNodes, state, checked);
        }
    }

    private void checkLandmarks(ArrayList<LandmarkCheck> openLandmarkNodes, HashMap<String, String> state, boolean[] checked) {
        int i = 0;
        while (i < openLandmarkNodes.size()) {
            LandmarkCheck l = openLandmarkNodes.get(i);
            if (l.goOn(state, checked)) {
                openLandmarkNodes.remove(i);
                for (LandmarkCheck s : l.successors) {
                    if (checked[s.index]) continue;
                    int pos = openLandmarkNodes.indexOf(s);
                    if (pos == -1) {
                        openLandmarkNodes.add(s);
                        continue;
                    }
                    if (pos >= i) continue;
                    i = pos;
                }
                continue;
            }
            ++i;
        }
    }

    private void computeMultiState(HPlan currentPlan, HashMap<String, ArrayList<String>> state, int[] totalOrder, boolean[] checked) {
        ArrayList<LandmarkCheck> openLandmarkNodes = new ArrayList<LandmarkCheck>(this.landmarkNodes.size());
        for (LandmarkCheck l : this.rootLandmarkNodes) {
            openLandmarkNodes.add(l);
        }
        ArrayList<Step> stepList = currentPlan.getStepsArray();
        for (int step : totalOrder) {
            Step action = stepList.get(step);
            for (Condition eff : action.getEffs()) {
                ArrayList<Object> list;
                String v = this.pf.getVarNameFromCode(eff.getVarCode());
                String value = this.pf.getValueFromCode(eff.getValueCode());
                if (v == null || value == null) continue;
                if (state.containsKey(v)) {
                    list = state.get(v);
                    list.set(0, value);
                    continue;
                }
                list = new ArrayList();
                list.add(value);
                state.put(v, list);
            }
            this.checkLandmarksMulti(openLandmarkNodes, state, checked);
        }
    }

    private void checkLandmarksMulti(ArrayList<LandmarkCheck> openLandmarkNodes, HashMap<String, ArrayList<String>> state, boolean[] checked) {
        int i = 0;
        while (i < openLandmarkNodes.size()) {
            LandmarkCheck l = openLandmarkNodes.get(i);
            if (l.goOnMulti(state, checked)) {
                openLandmarkNodes.remove(i);
                for (LandmarkCheck s : l.successors) {
                    if (checked[s.index]) continue;
                    int pos = openLandmarkNodes.indexOf(s);
                    if (pos == -1) {
                        openLandmarkNodes.add(s);
                        continue;
                    }
                    if (pos >= i) continue;
                    i = pos;
                }
                continue;
            }
            ++i;
        }
    }

    private void evaluateMonoagentPlan(HPlan currentPlan, int threadIndex) {
        HashMap<String, String> state = new HashMap<String, String>();
        int[] totalOrder = currentPlan.linearization();
        boolean[] checked = new boolean[this.landmarkNodes.size()];
        this.computeState(currentPlan, state, totalOrder, checked);
        int hl = 0;
        for (int i = 0; i < this.landmarkNodes.size(); ++i) {
            if (checked[i]) continue;
            ++hl;
        }
        int h = 0;
        if (this.incremental_dtg) {
            Goal g;
            boolean[] evaluated = new boolean[this.landmarkNodes.size()];
            HashMap<String, ArrayList<String>> newValues = new HashMap<String, ArrayList<String>>();
            ArrayList<LandmarkCheck> unreachedSubgoals = new ArrayList<LandmarkCheck>(this.landmarkNodes.size());
            for (LandmarkCheck l : this.rootLandmarkNodes) {
                unreachedSubgoals.add(l);
                evaluated[l.index] = true;
            }
            int i = 0;
            while (i < unreachedSubgoals.size()) {
                LandmarkCheck l;
                l = (LandmarkCheck)unreachedSubgoals.get(i);
                if (checked[l.index]) {
                    unreachedSubgoals.remove(i);
                    for (LandmarkCheck s : l.successors) {
                        if (evaluated[s.index]) continue;
                        unreachedSubgoals.add(s);
                        evaluated[s.index] = true;
                    }
                    continue;
                }
                ++i;
            }
            PriorityQueue<Goal> openGoals = new PriorityQueue<Goal>();
            while (!unreachedSubgoals.isEmpty()) {
                for (i = 0; i < unreachedSubgoals.size(); ++i) {
                    String end;
                    String v;
                    LandmarkCheck l = (LandmarkCheck)unreachedSubgoals.get(i);
                    if (!l.single || l.isGoal || LandmarksHeuristic.holdsMono(v = l.varNames[0], end = l.varValues[0], state, newValues)) continue;
                    String init = LandmarksHeuristic.selectInitialValueMono(v, end, this.dtgs.getDTG(v), state, newValues, threadIndex);
                    int dst = this.pathCostMono(v, init, end, state, threadIndex);
                    if (dst >= 0x2AAAAAAA) {
                        h = 0x2AAAAAAA;
                        break;
                    }
                    openGoals.add(new Goal(v, end, dst));
                }
                if (h >= 0x2AAAAAAA) break;
                while (!openGoals.isEmpty() && h < 0x2AAAAAAA) {
                    g = (Goal)openGoals.poll();
                    h += this.solveConditionMono(g, openGoals, state, newValues, threadIndex);
                }
                if (h >= 0x2AAAAAAA) break;
                this.advanceSubgoalSet(unreachedSubgoals, evaluated);
            }
            for (Goal g2 : this.goals) {
                String v = g2.varName;
                String end = g2.varValue;
                if (LandmarksHeuristic.holdsMono(v, end, state, newValues)) continue;
                String init = LandmarksHeuristic.selectInitialValueMono(v, end, this.dtgs.getDTG(v), state, newValues, threadIndex);
                int dst = this.pathCostMono(v, init, end, state, threadIndex);
                if (dst >= 0x2AAAAAAA) {
                    h = 0x2AAAAAAA;
                    break;
                }
                openGoals.add(new Goal(v, end, dst));
            }
            while (!openGoals.isEmpty() && h < 0x2AAAAAAA) {
                g = (Goal)openGoals.poll();
                h += this.solveConditionMono(g, openGoals, state, newValues, threadIndex);
            }
        } else {
            HashMap<String, ArrayList<String>> newValues = new HashMap<String, ArrayList<String>>();
            PriorityQueue<Goal> openGoals = new PriorityQueue<Goal>();
            for (Goal g : this.goals) {
                String v = g.varName;
                String end = g.varValue;
                if (LandmarksHeuristic.holdsMono(v, end, state, newValues)) continue;
                String init = LandmarksHeuristic.selectInitialValueMono(v, end, this.dtgs.getDTG(v), state, newValues, threadIndex);
                int dst = this.pathCostMono(v, init, end, state, threadIndex);
                if (dst >= 0x2AAAAAAA) {
                    h = 0x2AAAAAAA;
                    break;
                }
                openGoals.add(new Goal(v, end, dst));
            }
            while (!openGoals.isEmpty() && h < 0x2AAAAAAA) {
                Goal g = (Goal)openGoals.poll();
                h += this.solveConditionMono(g, openGoals, state, newValues, threadIndex);
            }
        }
        currentPlan.setH(h, hl);
    }

    private void advanceSubgoalSet(ArrayList<LandmarkCheck> unreachedSubgoals, boolean[] evaluated) {
        ArrayList<LandmarkCheck> newSet = new ArrayList<LandmarkCheck>(unreachedSubgoals.size());
        for (LandmarkCheck l : unreachedSubgoals) {
            for (LandmarkCheck s : l.successors) {
                if (evaluated[s.index]) continue;
                newSet.add(s);
                evaluated[s.index] = true;
            }
        }
        unreachedSubgoals.clear();
        for (LandmarkCheck l : newSet) {
            unreachedSubgoals.add(l);
        }
    }

    private static String selectInitialValueMono(String varName, String endValue, DTG dtg, HashMap<String, String> state, HashMap<String, ArrayList<String>> newValues, int threadIndex) {
        String bestValue = state.get(varName);
        int bestCost = dtg.pathCost(bestValue, endValue, state, newValues, threadIndex);
        ArrayList<String> valueList = newValues.get(varName);
        if (valueList != null) {
            for (int i = 0; i < valueList.size(); ++i) {
                String value = valueList.get(i);
                int cost = dtg.pathCost(value, endValue, state, newValues, threadIndex);
                if (cost == -1 || cost >= bestCost) continue;
                bestCost = cost;
                bestValue = value;
            }
        }
        return bestValue;
    }

    private int solveConditionMono(Goal goal, PriorityQueue<Goal> openGoals, HashMap<String, String> state, HashMap<String, ArrayList<String>> newValues, int threadIndex) {
        String initValue;
        int h = 0;
        String varName = goal.varName;
        String varValue = goal.varValue;
        if (LandmarksHeuristic.holdsMono(varName, varValue, state, newValues)) {
            return h;
        }
        DTG dtg = this.dtgs.getDTG(varName);
        String[] path = dtg.getPath(initValue = LandmarksHeuristic.selectInitialValueMono(varName, varValue, dtg, state, newValues, threadIndex), varValue, state, newValues, threadIndex);
        if (path == null) {
            return 0x2AAAAAAA;
        }
        String prevValue = path[0];
        for (int i = 1; i < path.length; ++i) {
            String nextValue = path[i];
            Action a = this.selectProductorMono(varName, prevValue, nextValue, state, newValues, threadIndex);
            if (a == null) {
                h = 0x2AAAAAAA;
                break;
            }
            ++h;
            this.updateValuesAndGoalsMono(a, openGoals, state, newValues, threadIndex);
            prevValue = nextValue;
        }
        return h;
    }

    private Action selectProductorMono(String varName, String startValue, String endValue, HashMap<String, String> state, HashMap<String, ArrayList<String>> newValues, int threadIndex) {
        ArrayList<Action> productors = this.productors.get(varName + "," + endValue);
        if (productors == null || productors.isEmpty()) {
            return null;
        }
        Action bestAction = null;
        int costBest = 0x2AAAAAAA;
        for (int i = 0; i < productors.size(); ++i) {
            int cost;
            if (!this.hasPrecondition(productors.get(i), varName, startValue) || (cost = this.computeCostMono(productors.get(i), state, newValues, threadIndex)) >= costBest) continue;
            costBest = cost;
            bestAction = productors.get(i);
        }
        return bestAction;
    }

    private boolean hasPrecondition(Action action, String varName, String startValue) {
        for (GroundedCond prec : action.getPrecs()) {
            if (!varName.equals(prec.getVar().toString())) continue;
            return prec.getValue().equals(startValue);
        }
        return true;
    }

    private void updateValuesAndGoalsMono(Action a, PriorityQueue<Goal> openGoals, HashMap<String, String> state, HashMap<String, ArrayList<String>> newValues, int threadIndex) {
        for (GroundedCond groundedCond : a.getPrecs()) {
            String precVarName = groundedCond.getVar().toString();
            if (LandmarksHeuristic.holdsMono(precVarName, groundedCond.getValue(), state, newValues)) continue;
            String precInitValue = LandmarksHeuristic.selectInitialValueMono(precVarName, groundedCond.getValue(), this.dtgs.getDTG(precVarName), state, newValues, threadIndex);
            Goal newOpenGoal = new Goal(groundedCond, this.pathCostMono(precVarName, precInitValue, groundedCond.getValue(), state, threadIndex));
            openGoals.add(newOpenGoal);
        }
        for (Serializable serializable : a.getEffs()) {
            String v = serializable.getVar().toString();
            if (state.get(v).equals(serializable.getValue())) continue;
            ArrayList<String> values = newValues.get(v);
            if (values == null) {
                values = new ArrayList();
                values.add(serializable.getValue());
                newValues.put(v, values);
                continue;
            }
            if (values.contains(serializable.getValue())) continue;
            values.add(serializable.getValue());
        }
    }

    private static boolean holdsMono(String varName, String value, HashMap<String, String> state, HashMap<String, ArrayList<String>> newValues) {
        String v = state.get(varName);
        if (v != null && v.equals(value)) {
            return true;
        }
        ArrayList<String> values = newValues.get(varName);
        if (values == null) {
            return false;
        }
        return values.contains(value);
    }

    private int pathCostMono(String var, String initValue, String endValue, HashMap<String, String> state, int threadIndex) {
        DTG dtg = this.dtgs.getDTG(var);
        return dtg.pathCost(initValue, endValue, state, null, threadIndex);
    }

    private int computeCostMono(Action a, HashMap<String, String> state, HashMap<String, ArrayList<String>> newValues, int threadIndex) {
        int cost = 0;
        for (GroundedCond prec : a.getPrecs()) {
            String var = prec.getVar().toString();
            DTG dtg = this.dtgs.getDTG(var);
            String iValue = state.get(var);
            int minPrecCost = dtg.pathCost(iValue, prec.getValue(), state, newValues, threadIndex);
            ArrayList<String> initValues = newValues.get(var);
            if (initValues != null) {
                for (String initValue : initValues) {
                    int precCost = dtg.pathCost(initValue, prec.getValue(), state, newValues, threadIndex);
                    if (precCost >= minPrecCost) continue;
                    minPrecCost = precCost;
                }
            }
            cost += minPrecCost;
        }
        return cost;
    }

    private void evaluateMultiagentPlan(HPlan currentPlan, ArrayList<Integer> achievedLandmarks) {
        HashMap<String, ArrayList<String>> state = new HashMap<String, ArrayList<String>>();
        int[] totalOrder = currentPlan.linearization();
        boolean[] checked = new boolean[this.landmarkNodes.size()];
        this.computeMultiState(currentPlan, state, totalOrder, checked);
        int hl = this.landmarks.numGlobalNodes();
        for (LandmarkCheck l : this.landmarkNodes) {
            if (!checked[l.index] || !l.single) continue;
            --hl;
            if (achievedLandmarks == null) continue;
            achievedLandmarks.add(l.globalIndex);
        }
        int h = 0;
        PriorityQueue<Goal> openGoals = new PriorityQueue<Goal>();
        for (Goal g : this.goals) {
            String v = g.varName;
            String end = g.varValue;
            if (this.holdsMulti(v, end, state)) continue;
            String init = this.selectInitialValueMulti(v, end, this.dtgs.getDTG(v), state);
            g.distance = this.pathCostMulti(v, init, end);
            openGoals.add(g);
        }
        while (!openGoals.isEmpty()) {
            Goal g = (Goal)openGoals.poll();
            if (g.distance >= 0x2AAAAAAA || g.distance < 0) {
                ++h;
                continue;
            }
            h += this.solveConditionMulti(g, state, openGoals, null);
        }
        currentPlan.setH(h, hl);
    }

    private int pathCostMulti(String var, String initValue, String endValue) {
        DTG dtg = this.dtgs.getDTG(var);
        return dtg.pathCostMulti(initValue, endValue);
    }

    private int solveConditionMulti(Goal goal, HashMap<String, ArrayList<String>> varValues, PriorityQueue<Goal> openGoals, TransitionCostRequest tcr) {
        String varName = goal.varName;
        String varValue = goal.varValue;
        if (this.holdsMulti(varName, varValue, varValues)) {
            return 0;
        }
        DTG dtg = this.dtgs.getDTG(varName);
        String initValue = this.selectInitialValueMulti(varName, varValue, dtg, varValues);
        int h = !dtg.unknownValue(varValue) && !dtg.unknownValue(initValue) ? this.evaluateWithKnownValues(varName, initValue, varValue, dtg, varValues, tcr, openGoals) : (dtg.unknownValue(varValue) ? this.evaluateWithUnknownFinalvalue(varName, initValue, varValue, dtg, varValues, tcr, openGoals) : this.evaluateWithUnknownInitialvalue(varName, varValue, dtg, varValues, tcr, openGoals));
        return h;
    }

    private String selectInitialValueMulti(String varName, String endValue, DTG dtg, HashMap<String, ArrayList<String>> varValues) {
        ArrayList<String> valueList = varValues.get(varName);
        if (valueList == null) {
            return this.groundedTask.negationByFailure() && this.booleanVariable.get(varName) != false ? "false" : "?";
        }
        String bestValue = null;
        int bestCost = -1;
        for (String value : valueList) {
            if (bestValue == null) {
                bestCost = dtg.pathCostMulti(value, endValue);
                bestValue = value;
                continue;
            }
            int cost = dtg.pathCostMulti(value, endValue);
            if (cost == -1 || cost >= bestCost) continue;
            bestCost = cost;
            bestValue = value;
        }
        if (bestValue != null) {
            return bestValue;
        }
        return this.groundedTask.negationByFailure() && this.booleanVariable.get(varName) != false ? "false" : "?";
    }

    private boolean holdsMulti(String varName, String value, HashMap<String, ArrayList<String>> varValues) {
        ArrayList<String> values = varValues.get(varName);
        if (values == null) {
            return false;
        }
        return values.contains(value);
    }

    private int evaluateWithUnknownInitialvalue(String varName, String varValue, DTG dtg, HashMap<String, ArrayList<String>> varValues, TransitionCostRequest tcr, PriorityQueue<Goal> openGoals) {
        DTGTransition[] transitions;
        int h = 1000;
        for (DTGTransition t : transitions = dtg.getTransitionsFrom("?")) {
            int cost;
            if (tcr != null && tcr.varName.equals(varName) && tcr.endValue.equals(t.getFinalValue()) || (cost = this.requestTransitionCost(varName, "?", t.getFinalValue(), varValues, dtg, tcr)) == 1000) continue;
            ArrayList<String> values = varValues.get(varName);
            if (values == null) {
                values = new ArrayList();
                values.add(t.getFinalValue());
                varValues.put(varName, values);
            } else if (!values.contains(t.getFinalValue())) {
                values.add(t.getFinalValue());
            }
            int restCost = this.evaluateWithKnownValues(varName, t.getFinalValue(), varValue, dtg, varValues, tcr, openGoals);
            if (restCost == 1000) continue;
            h = cost + restCost;
            break;
        }
        return h;
    }

    private int evaluateWithKnownValues(String varName, String initValue, String varValue, DTG dtg, HashMap<String, ArrayList<String>> varValues, TransitionCostRequest tcr, PriorityQueue<Goal> openGoals) {
        int h = 0;
        String[] path = dtg.getPathMulti(initValue, varValue);
        String prevValue = path[0];
        for (int i = 1; i < path.length; ++i) {
            String nextValue;
            block6: {
                Action a;
                block4: {
                    ArrayList<String> values;
                    block5: {
                        nextValue = path[i];
                        a = this.selectProductorMulti(varName, prevValue, nextValue, varValues);
                        if (a != null) break block4;
                        h += this.requestTransitionCost(varName, prevValue, nextValue, varValues, dtg, tcr);
                        values = varValues.get(varName);
                        if (values != null) break block5;
                        values = new ArrayList();
                        values.add(nextValue);
                        varValues.put(varName, values);
                        break block6;
                    }
                    if (values.contains(nextValue)) break block6;
                    values.add(nextValue);
                    break block6;
                }
                ++h;
                for (GroundedCond groundedCond : a.getPrecs()) {
                    String precVarName = groundedCond.getVar().toString();
                    if (this.holdsMulti(precVarName, groundedCond.getValue(), varValues)) continue;
                    String precInitValue = this.selectInitialValueMulti(precVarName, groundedCond.getValue(), this.dtgs.getDTG(precVarName), varValues);
                    Goal newOpenGoal = new Goal(groundedCond, this.pathCostMulti(precVarName, precInitValue, groundedCond.getValue()));
                    openGoals.add(newOpenGoal);
                }
                for (Serializable serializable : a.getEffs()) {
                    ArrayList<String> values = varValues.get(serializable.getVar().toString());
                    if (values == null) {
                        values = new ArrayList();
                        values.add(serializable.getValue());
                        varValues.put(serializable.getVar().toString(), values);
                        continue;
                    }
                    if (values.contains(serializable.getValue())) continue;
                    values.add(serializable.getValue());
                }
            }
            prevValue = nextValue;
        }
        return h;
    }

    private Action selectProductorMulti(String varName, String startValue, String endValue, HashMap<String, ArrayList<String>> varValues) {
        ArrayList<Action> productors = this.productors.get(varName + "," + endValue);
        if (productors == null || productors.isEmpty()) {
            return null;
        }
        Action bestAction = null;
        int costBest = 1000;
        for (int i = 0; i < productors.size(); ++i) {
            int cost;
            if (!this.hasPrecondition(productors.get(i), varName, startValue) || (cost = this.computeCostMulti(productors.get(i), varValues)) >= costBest) continue;
            costBest = cost;
            bestAction = productors.get(i);
        }
        return bestAction;
    }

    private int computeCostMulti(Action a, HashMap<String, ArrayList<String>> varValues) {
        int cost = 0;
        for (GroundedCond prec : a.getPrecs()) {
            String var = prec.getVar().toString();
            DTG dtg = this.dtgs.getDTG(var);
            int minPrecCost = 1000;
            ArrayList<String> initValues = varValues.get(var);
            if (initValues != null && !initValues.isEmpty()) {
                for (String initValue : initValues) {
                    int precCost = dtg.pathCostMulti(initValue, prec.getValue());
                    if (precCost >= minPrecCost) continue;
                    minPrecCost = precCost;
                }
                cost += minPrecCost;
                continue;
            }
            if (this.groundedTask.negationByFailure() && prec.getVar().isBoolean()) {
                cost += dtg.pathCostMulti("false", prec.getValue());
                continue;
            }
            cost += dtg.pathCostMulti("?", prec.getValue());
        }
        return cost;
    }

    private int evaluateWithUnknownFinalvalue(String varName, String initValue, String varValue, DTG dtg, HashMap<String, ArrayList<String>> varValues, TransitionCostRequest tcr, PriorityQueue<Goal> openGoals) {
        int h = 1000;
        DTGTransition[] transitions = dtg.getTransitionsTo("?");
        if (transitions != null) {
            for (DTGTransition t : transitions) {
                int restCost;
                openGoals = new PriorityQueue();
                int cost = this.evaluateWithKnownValues(varName, initValue, t.getStartValue(), dtg, varValues, tcr, openGoals);
                if (cost == 1000 || (restCost = this.requestTransitionCost(varName, t.getStartValue(), varValue, varValues, dtg, tcr)) == 1000) continue;
                h = cost + restCost;
                break;
            }
        }
        return h;
    }

    private int requestTransitionCost(String varName, String prevValue, String nextValue, HashMap<String, ArrayList<String>> varValues, DTG dtg, TransitionCostRequest prevTcr) {
        int h = 1000;
        DTGTransition t = dtg.getTransition(prevValue, nextValue);
        ArrayList<String> askedAgents = new ArrayList<String>();
        for (String ag : t.getAgents()) {
            if (ag.equals(this.comm.getThisAgentName()) || this.detectLoop(ag, prevTcr)) continue;
            TransitionCostRequest tcr = new TransitionCostRequest(varName, prevValue, nextValue, this.comm.getThisAgentName(), prevTcr, this.requestId);
            tcr.setState(varValues, this.groundedTask, ag);
            this.comm.sendMessage(ag, tcr, false);
            askedAgents.add(ag);
        }
        DTGMessageFilter filter = new DTGMessageFilter(askedAgents, this.requestId++);
        while (!askedAgents.isEmpty()) {
            Serializable msg = this.comm.receiveMessage(filter, false);
            if (msg instanceof ReplyTransitionCost) {
                int index = askedAgents.indexOf(this.comm.getSenderAgent());
                askedAgents.remove(index);
                int cost = ((ReplyTransitionCost)msg).cost;
                if (cost >= h) continue;
                h = cost;
                continue;
            }
            if (msg instanceof String) {
                assert (((String)((Object)msg)).equals("<END>"));
                ++this.ready;
                continue;
            }
            TransitionCostRequest tcr = (TransitionCostRequest)msg;
            this.evaluateRequest(tcr, this.comm.getSenderAgent());
        }
        return h;
    }

    private boolean detectLoop(String ag, TransitionCostRequest t) {
        if (t == null) {
            return false;
        }
        int index = t.agents.indexOf(ag);
        if (index == -1) {
            return false;
        }
        if (this.groundedTask.negationByFailure()) {
            return true;
        }
        int count = 1;
        for (int i = index + 1; i < t.agents.size(); ++i) {
            if (!t.agents.get(i).equals(ag) || ++count <= 2) continue;
            return true;
        }
        return false;
    }

    private void evaluateRequest(TransitionCostRequest t, String fromAgent) {
        if (this.totalOrderBase == null) {
            this.totalOrderBase = this.basePlan.linearization();
        }
        HashMap<String, ArrayList<String>> varValues = this.basePlan.computeMultiState(this.totalOrderBase, this.pf);
        t.updateState(varValues);
        PriorityQueue<Goal> openGoals = new PriorityQueue<Goal>();
        openGoals.add(t.getGoal());
        int h = 0;
        while (!openGoals.isEmpty()) {
            h += this.solveConditionMulti((Goal)openGoals.poll(), varValues, openGoals, t);
        }
        this.comm.sendMessage(fromAgent, new ReplyTransitionCost(h, t.requestId), false);
    }

    @Override
    public void evaluatePlanPrivacy(HPlan p, int threadIndex) {
        if (p.isSolution() || this.pgoals.isEmpty()) {
            return;
        }
        this.dtgs.clearCache(threadIndex);
        HashMap<String, String> state = new HashMap<String, String>();
        HashMap<String, ArrayList<String>> newValues = new HashMap<String, ArrayList<String>>();
        int[] totalOrder = p.linearization();
        boolean[] checked = new boolean[this.landmarkNodes.size()];
        this.computeState(p, state, totalOrder, checked);
        PriorityQueue<Goal> openGoals = new PriorityQueue<Goal>();
        for (int i = 0; i < this.pgoals.size(); ++i) {
            int hp = 0;
            openGoals.clear();
            newValues.clear();
            Goal g = this.pgoals.get(i);
            String v = g.varName;
            String end = g.varValue;
            if (!LandmarksHeuristic.holdsMono(v, end, state, newValues)) {
                String init = LandmarksHeuristic.selectInitialValueMono(v, end, this.dtgs.getDTG(v), state, newValues, threadIndex);
                int dst = this.pathCostMono(v, init, end, state, threadIndex);
                if (dst >= 0x2AAAAAAA) {
                    hp = 0x2AAAAAAA;
                } else {
                    openGoals.add(new Goal(v, end, dst));
                }
            }
            while (!openGoals.isEmpty() && hp < 0x2AAAAAAA) {
                g = (Goal)openGoals.poll();
                hp += this.solveConditionMono(g, openGoals, state, newValues, threadIndex);
            }
            p.setHPriv(hp, i);
        }
    }

    @Override
    public void waitEndEvaluation() {
        WaitMessageFilter filter = new WaitMessageFilter();
        if (this.comm.batonAgent()) {
            ++this.ready;
            while (this.ready < this.comm.numAgents()) {
                Serializable msg = this.comm.receiveMessage(filter, false);
                if (msg instanceof String) {
                    assert (((String)((Object)msg)).equals("<END>"));
                    ++this.ready;
                    continue;
                }
                String fromAgent = this.comm.getSenderAgent();
                TransitionCostRequest tcr = (TransitionCostRequest)msg;
                this.evaluateRequest(tcr, fromAgent);
            }
            this.comm.sendMessage((Serializable)((Object)"<END>"), false);
        } else {
            boolean endStage = false;
            this.comm.sendMessage(this.comm.getBatonAgent(), (Serializable)((Object)"<END>"), false);
            while (!endStage) {
                Serializable msg = this.comm.receiveMessage(filter, false);
                if (msg instanceof String) {
                    assert (((String)((Object)msg)).equals("<END>"));
                    endStage = true;
                    continue;
                }
                String fromAgent = this.comm.getSenderAgent();
                TransitionCostRequest tcr = (TransitionCostRequest)msg;
                this.evaluateRequest(tcr, fromAgent);
            }
        }
    }

    @Override
    public boolean supportsMultiThreading() {
        return this.comm.numAgents() == 1;
    }

    @Override
    public Object getInformation(int infoFlag) {
        if (infoFlag == 1) {
            return this.landmarks;
        }
        return null;
    }

    @Override
    public boolean requiresHLandStage() {
        return this.comm.numAgents() > 1 && this.requiresHLandStage;
    }

    @Override
    public int numGlobalLandmarks() {
        return this.landmarks.numGlobalNodes();
    }

    @Override
    public ArrayList<Integer> checkNewLandmarks(HPlan plan, BitSet achievedLandmarks) {
        ArrayList<Integer> newLandmarks = new ArrayList<Integer>();
        HashMap<String, String> state = new HashMap<String, String>();
        int[] totalOrder = plan.linearization();
        boolean[] checked = new boolean[this.landmarkNodes.size()];
        ArrayList<LandmarkCheck> openLandmarkNodes = new ArrayList<LandmarkCheck>(this.landmarkNodes.size());
        for (LandmarkCheck l : this.rootLandmarkNodes) {
            openLandmarkNodes.add(l);
        }
        ArrayList<Step> stepList = plan.getStepsArray();
        for (int step : totalOrder) {
            Step action = stepList.get(step);
            for (Condition eff : action.getEffs()) {
                String varName = this.pf.getVarNameFromCode(eff.getVarCode());
                String valueName = this.pf.getValueFromCode(eff.getValueCode());
                if (varName == null || valueName == null) continue;
                state.put(varName, valueName);
            }
            this.checkLandmarks(openLandmarkNodes, state, checked);
        }
        for (int i = 0; i < checked.length; ++i) {
            if (!checked[i]) continue;
            LandmarkCheck l = this.landmarkNodes.get(i);
            if (!l.single || achievedLandmarks.get(l.globalIndex)) continue;
            newLandmarks.add(l.globalIndex);
        }
        return newLandmarks;
    }

    public static class WaitMessageFilter
    implements MessageFilter {
        @Override
        public boolean validMessage(Message m) {
            return m.content() instanceof String || m.content() instanceof TransitionCostRequest;
        }
    }

    public static class DTGMessageFilter
    implements MessageFilter {
        private final int requestId;
        private final ArrayList<String> askedAgents;

        public DTGMessageFilter(ArrayList<String> askedAgents, int requestId) {
            this.requestId = requestId;
            this.askedAgents = askedAgents;
        }

        @Override
        public boolean validMessage(Message m) {
            if (m.content() instanceof ReplyTransitionCost) {
                return ((ReplyTransitionCost)m.content()).requestId == this.requestId && this.askedAgents.contains(m.sender());
            }
            if (m.content() instanceof String && ((String)((Object)m.content())).equals("<END>")) {
                return true;
            }
            return m.content() instanceof TransitionCostRequest;
        }
    }

    private static class LandmarkCheck {
        int index;
        int globalIndex;
        boolean isRoot;
        boolean single;
        boolean isGoal;
        String[] varNames;
        String[] varValues;
        ArrayList<LandmarkCheck> successors;
        ArrayList<LandmarkCheck> predecessors;

        private LandmarkCheck(LandmarkNode n, boolean isRoot, ArrayList<Goal> goals) {
            this.globalIndex = n.getGlobalId();
            this.isRoot = isRoot;
            LandmarkFluent[] lfs = n.getLiterals();
            this.varNames = new String[lfs.length];
            this.varValues = new String[lfs.length];
            for (int i = 0; i < lfs.length; ++i) {
                this.varNames[i] = lfs[i].getVarName();
                this.varValues[i] = lfs[i].getValue();
            }
            this.single = n.isSingleLiteral();
            this.isGoal = false;
            if (this.single) {
                for (Goal g : goals) {
                    if (!this.varNames[0].equals(g.varName) || !this.varValues[0].equals(g.varValue)) continue;
                    this.isGoal = true;
                    break;
                }
            }
            this.successors = new ArrayList();
            this.predecessors = new ArrayList();
        }

        public LandmarkCheck(Goal g) {
            this.isRoot = false;
            this.single = true;
            this.isGoal = true;
            this.varNames = new String[1];
            this.varValues = new String[1];
            this.varNames[0] = g.varName;
            this.varValues[0] = g.varValue;
            this.successors = new ArrayList();
            this.predecessors = new ArrayList();
        }

        public boolean matches(Goal g) {
            if (!this.single || !this.isGoal) {
                return false;
            }
            return g.varName.equals(this.varNames[0]) && g.varValue.equals(this.varValues[0]);
        }

        public void removePredecessor(LandmarkCheck l) {
            for (int i = 0; i < this.predecessors.size(); ++i) {
                if (this.predecessors.get(i) != l) continue;
                this.predecessors.remove(i);
                break;
            }
        }

        public void addPredecessor(LandmarkCheck l) {
            this.predecessors.add(l);
        }

        public void addSuccessor(LandmarkCheck l) {
            this.successors.add(l);
        }

        public boolean goOnMulti(HashMap<String, ArrayList<String>> state, boolean[] checked) {
            if (checked[this.index]) {
                return false;
            }
            for (LandmarkCheck p : this.predecessors) {
                if (checked[p.index]) continue;
                return false;
            }
            checked[this.index] = !this.single || this.holdsMulti(state);
            return checked[this.index];
        }

        private boolean holdsMulti(HashMap<String, ArrayList<String>> state) {
            for (int i = 0; i < this.varNames.length; ++i) {
                ArrayList<String> values = state.get(this.varNames[i]);
                if (values == null || !values.contains(this.varValues[i])) continue;
                return true;
            }
            return false;
        }

        public boolean goOn(HashMap<String, String> state, boolean[] checked) {
            if (checked[this.index]) {
                return false;
            }
            for (LandmarkCheck p : this.predecessors) {
                if (checked[p.index]) continue;
                return false;
            }
            checked[this.index] = !this.single || this.holds(state);
            return checked[this.index];
        }

        private boolean holds(HashMap<String, String> state) {
            for (int i = 0; i < this.varNames.length; ++i) {
                String stateValue = state.get(this.varNames[i]);
                if (stateValue == null || !stateValue.equals(this.varValues[i])) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            String s = this.varNames[0] + "=" + this.varValues[0];
            for (int i = 1; i < this.varNames.length; ++i) {
                s = s + " v " + this.varNames[i] + "=" + this.varValues[i];
            }
            return s;
        }
    }

    public static class ReplyTransitionCost
    implements Serializable {
        private static final long serialVersionUID = 8450612556336972847L;
        int cost;
        int requestId;

        public ReplyTransitionCost(int cost, int requestId) {
            this.cost = cost;
            this.requestId = requestId;
        }
    }

    public static class TransitionCostRequest
    implements Serializable {
        private static final long serialVersionUID = 5485301296724177527L;
        public ArrayList<String> agents;
        public String varName;
        public String startValue;
        public String endValue;
        public ArrayList<ArrayList<String>> varValuesList;
        public int requestId;

        public TransitionCostRequest(String varName, String prevValue, String nextValue, String agentName, TransitionCostRequest prevTcr, int requestId) {
            this.varName = varName;
            this.startValue = prevValue;
            this.endValue = nextValue;
            this.agents = new ArrayList();
            if (prevTcr != null) {
                for (String ag : prevTcr.agents) {
                    this.agents.add(ag);
                }
            }
            this.agents.add(agentName);
            this.varValuesList = new ArrayList();
            this.requestId = requestId;
        }

        public Goal getGoal() {
            return new Goal(this.varName, this.endValue, -1);
        }

        public void updateState(HashMap<String, ArrayList<String>> varValues) {
            for (ArrayList<String> list : this.varValuesList) {
                int i;
                ArrayList<String> values = varValues.get(list.get(0));
                if (values == null) {
                    values = new ArrayList();
                    for (i = 1; i < list.size(); ++i) {
                        values.add(list.get(i));
                    }
                    varValues.put(list.get(0), values);
                    continue;
                }
                for (i = 1; i < list.size(); ++i) {
                    if (values.contains(list.get(i))) continue;
                    values.add(list.get(i));
                }
            }
        }

        public void setState(HashMap<String, ArrayList<String>> varValues, GroundedTask groundedTask, String toAgent) {
            for (String v : varValues.keySet()) {
                GroundedVar gv = groundedTask.getVarByName(v);
                if (!gv.shareable(toAgent)) continue;
                ArrayList<String> list = varValues.get(v);
                ArrayList<String> newList = new ArrayList<String>(list.size() + 1);
                newList.add(v);
                for (String value : list) {
                    if (!gv.shareable(value, toAgent)) continue;
                    newList.add(value);
                }
                this.varValuesList.add(newList);
            }
        }

        public String toString() {
            return this.varName + "(" + this.startValue + "->" + this.endValue + ")";
        }
    }

    private static class Goal
    implements Comparable<Goal> {
        String varName;
        String varValue;
        int distance;

        public Goal(GroundedCond goal, int distance) {
            this(goal.getVar().toString(), goal.getValue(), distance);
        }

        public Goal(String varName, String varValue, int distance) {
            this.varName = varName;
            this.varValue = varValue;
            this.distance = distance;
        }

        @Override
        public int compareTo(Goal g) {
            return g.distance - this.distance;
        }

        public String toString() {
            return this.varName + "=" + this.varValue + "(" + this.distance + ")";
        }

        public int hashCode() {
            return (this.varName + "=" + this.varValue).hashCode();
        }

        public boolean equals(Object x) {
            Goal g = (Goal)x;
            return this.varName.equals(g.varName) && this.varValue.equals(g.varValue);
        }
    }
}

