/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_heuristic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.PriorityQueue;
import org.agreement_technologies.common.map_communication.AgentCommunication;
import org.agreement_technologies.common.map_communication.Message;
import org.agreement_technologies.common.map_communication.MessageFilter;
import org.agreement_technologies.common.map_dtg.DTG;
import org.agreement_technologies.common.map_dtg.DTGSet;
import org.agreement_technologies.common.map_dtg.DTGTransition;
import org.agreement_technologies.common.map_grounding.Action;
import org.agreement_technologies.common.map_grounding.GroundedCond;
import org.agreement_technologies.common.map_grounding.GroundedEff;
import org.agreement_technologies.common.map_grounding.GroundedTask;
import org.agreement_technologies.common.map_grounding.GroundedVar;
import org.agreement_technologies.common.map_heuristic.HPlan;
import org.agreement_technologies.common.map_heuristic.Heuristic;
import org.agreement_technologies.common.map_planner.PlannerFactory;
import org.agreement_technologies.service.map_dtg.DTGSetImp;
import org.agreement_technologies.service.map_heuristic.GoalCondition;
import org.agreement_technologies.service.map_heuristic.HeuristicToolkit;

public class DTGHeuristic
implements Heuristic {
    private static final int PENALTY = 1000;
    protected GroundedTask groundedTask;
    protected AgentCommunication comm;
    protected ArrayList<Goal> goals;
    protected ArrayList<Goal> pgoals;
    protected HashMap<String, ArrayList<Action>> productors;
    protected DTGSet dtgs;
    protected PlannerFactory pf;
    private HPlan basePlan;
    private HPlan currentPlan;
    private int ready;
    private int requestId;
    private int[] totalOrderBase;

    public DTGHeuristic(AgentCommunication comm, GroundedTask gTask, PlannerFactory pf) {
        this.pf = pf;
        this.groundedTask = gTask;
        this.comm = comm;
        this.dtgs = new DTGSetImp(gTask);
        this.dtgs.distributeDTGs(comm, gTask);
        this.goals = new ArrayList();
        this.pgoals = new ArrayList();
        ArrayList<GoalCondition> gc = HeuristicToolkit.computeTaskGoals(comm, gTask);
        for (GoalCondition goalCondition : gc) {
            GroundedVar var = null;
            for (GroundedVar v : gTask.getVars()) {
                if (!v.toString().equals(goalCondition.varName)) continue;
                var = v;
                break;
            }
            if (var == null) continue;
            Goal ng = new Goal(gTask.createGroundedCondition(1, var, goalCondition.value), 0);
            this.goals.add(ng);
        }
        for (GroundedCond groundedCond : gTask.getPreferences()) {
            this.pgoals.add(new Goal(groundedCond, 0));
        }
        this.productors = new HashMap();
        for (Action action : gTask.getActions()) {
            for (GroundedEff e : action.getEffs()) {
                String desc = e.getVar().toString() + "," + e.getValue();
                ArrayList<Action> list = this.productors.get(desc);
                if (list == null) {
                    list = new ArrayList();
                    this.productors.put(desc, list);
                }
                list.add(action);
            }
        }
        this.requestId = 0;
    }

    @Override
    public void startEvaluation(HPlan basePlan) {
        this.basePlan = basePlan;
        this.ready = 0;
        this.totalOrderBase = null;
    }

    @Override
    public void evaluatePlan(HPlan p, int threadIndex) {
        if (p.isSolution()) {
            return;
        }
        this.currentPlan = p;
        if (this.comm.numAgents() == 1) {
            this.evaluateMonoagentPlan();
        } else {
            this.evaluateMultiagentPlan();
        }
    }

    @Override
    public void evaluatePlanPrivacy(HPlan p, int threadIndex) {
        if (p.isSolution() || this.pgoals.isEmpty()) {
            return;
        }
        this.currentPlan = p;
        if (this.comm.numAgents() == 1) {
            this.evaluateMonoagentPlanPrivacy(null, null);
        } else {
            this.evaluateMultiagentPlanPrivacy(null);
        }
    }

    private void evaluateMonoagentPlan() {
        int h = 0;
        HashMap<String, ArrayList<String>> newValues = new HashMap<String, ArrayList<String>>();
        int[] totalOrder = this.currentPlan.linearization();
        HashMap<String, String> state = this.currentPlan.computeState(totalOrder, this.pf);
        PriorityQueue<Goal> openGoals = new PriorityQueue<Goal>();
        for (Goal g : this.goals) {
            String v = g.varName;
            String end = g.varValue;
            if (DTGHeuristic.holdsMono(v, end, state, newValues)) continue;
            String init = DTGHeuristic.selectInitialValueMono(v, end, this.dtgs.getDTG(v), state, newValues);
            g.distance = this.pathCostMono(v, init, end, state, newValues);
            if (g.distance >= 0x2AAAAAAA) {
                h = 0x2AAAAAAA;
                break;
            }
            openGoals.add(g);
        }
        while (!openGoals.isEmpty() && h < 0x2AAAAAAA) {
            Goal g = (Goal)openGoals.poll();
            h += this.solveConditionMono(g, openGoals, state, newValues);
        }
        this.currentPlan.setH(h, 0);
        this.evaluateMonoagentPlanPrivacy(state, newValues);
    }

    private void evaluateMonoagentPlanPrivacy(HashMap<String, String> state, HashMap<String, ArrayList<String>> newValues) {
        if (state == null) {
            int[] totalOrder = this.currentPlan.linearization();
            state = this.currentPlan.computeState(totalOrder, this.pf);
            newValues = new HashMap();
        }
        PriorityQueue<Goal> openGoals = new PriorityQueue<Goal>();
        for (int i = 0; i < this.pgoals.size(); ++i) {
            int hp = 0;
            Goal g = this.pgoals.get(i);
            String v = g.varName;
            String end = g.varValue;
            if (!DTGHeuristic.holdsMono(v, end, state, newValues)) {
                String init = DTGHeuristic.selectInitialValueMono(v, end, this.dtgs.getDTG(v), state, newValues);
                int dst = this.pathCostMono(v, init, end, state, newValues);
                if (dst >= 0x2AAAAAAA) {
                    hp = 0x2AAAAAAA;
                } else {
                    openGoals.add(new Goal(v, end, dst));
                }
            }
            while (!openGoals.isEmpty() && hp < 0x2AAAAAAA) {
                g = (Goal)openGoals.poll();
                hp += this.solveConditionMono(g, openGoals, state, newValues);
            }
            this.currentPlan.setHPriv(hp, i);
        }
    }

    private static String selectInitialValueMono(String varName, String endValue, DTG dtg, HashMap<String, String> state, HashMap<String, ArrayList<String>> newValues) {
        String bestValue = state.get(varName);
        int bestCost = dtg.pathCost(bestValue, endValue, state, newValues, 0);
        ArrayList<String> valueList = newValues.get(varName);
        if (valueList != null) {
            for (int i = 0; i < valueList.size(); ++i) {
                String value = valueList.get(i);
                int cost = dtg.pathCost(value, endValue, state, newValues, 0);
                if (cost == -1 || cost >= bestCost) continue;
                bestCost = cost;
                bestValue = value;
            }
        }
        return bestValue;
    }

    private int solveConditionMono(Goal goal, PriorityQueue<Goal> openGoals, HashMap<String, String> state, HashMap<String, ArrayList<String>> newValues) {
        String initValue;
        int h = 0;
        String varName = goal.varName;
        String varValue = goal.varValue;
        if (DTGHeuristic.holdsMono(varName, varValue, state, newValues)) {
            return h;
        }
        DTG dtg = this.dtgs.getDTG(varName);
        String[] path = dtg.getPath(initValue = DTGHeuristic.selectInitialValueMono(varName, varValue, dtg, state, newValues), varValue, state, newValues, 0);
        if (path == null) {
            return 0x2AAAAAAA;
        }
        String prevValue = path[0];
        for (int i = 1; i < path.length; ++i) {
            String nextValue = path[i];
            Action a = this.selectProductorMono(varName, prevValue, nextValue, state, newValues);
            if (a == null) {
                h = 0x2AAAAAAA;
                break;
            }
            ++h;
            this.updateValuesAndGoalsMono(a, openGoals, state, newValues);
            prevValue = nextValue;
        }
        return h;
    }

    private Action selectProductorMono(String varName, String startValue, String endValue, HashMap<String, String> state, HashMap<String, ArrayList<String>> newValues) {
        ArrayList<Action> productors = this.productors.get(varName + "," + endValue);
        if (productors == null || productors.isEmpty()) {
            return null;
        }
        Action bestAction = null;
        int costBest = 0x2AAAAAAA;
        for (int i = 0; i < productors.size(); ++i) {
            int cost;
            if (!this.hasPrecondition(productors.get(i), varName, startValue) || (cost = this.computeCostMono(productors.get(i), state, newValues)) >= costBest) continue;
            costBest = cost;
            bestAction = productors.get(i);
        }
        return bestAction;
    }

    private boolean hasPrecondition(Action action, String varName, String startValue) {
        for (GroundedCond prec : action.getPrecs()) {
            if (!varName.equals(prec.getVar().toString())) continue;
            return prec.getValue().equals(startValue);
        }
        return true;
    }

    private void updateValuesAndGoalsMono(Action a, PriorityQueue<Goal> openGoals, HashMap<String, String> state, HashMap<String, ArrayList<String>> newValues) {
        for (GroundedCond groundedCond : a.getPrecs()) {
            String precVarName = groundedCond.getVar().toString();
            if (DTGHeuristic.holdsMono(precVarName, groundedCond.getValue(), state, newValues)) continue;
            String precInitValue = DTGHeuristic.selectInitialValueMono(precVarName, groundedCond.getValue(), this.dtgs.getDTG(precVarName), state, newValues);
            Goal newOpenGoal = new Goal(groundedCond, this.pathCostMono(precVarName, precInitValue, groundedCond.getValue(), state, newValues));
            openGoals.add(newOpenGoal);
        }
        for (Serializable serializable : a.getEffs()) {
            String v = serializable.getVar().toString();
            if (state.get(v).equals(serializable.getValue())) continue;
            ArrayList<String> values = newValues.get(v);
            if (values == null) {
                values = new ArrayList();
                values.add(serializable.getValue());
                newValues.put(v, values);
                continue;
            }
            if (values.contains(serializable.getValue())) continue;
            values.add(serializable.getValue());
        }
    }

    private static boolean holdsMono(String varName, String value, HashMap<String, String> state, HashMap<String, ArrayList<String>> newValues) {
        String v = state.get(varName);
        if (v != null && v.equals(value)) {
            return true;
        }
        ArrayList<String> values = newValues.get(varName);
        if (values == null) {
            return false;
        }
        return values.contains(value);
    }

    private int pathCostMono(String var, String initValue, String endValue, HashMap<String, String> state, HashMap<String, ArrayList<String>> newValues) {
        DTG dtg = this.dtgs.getDTG(var);
        return dtg.pathCost(initValue, endValue, state, newValues, 0);
    }

    private int computeCostMono(Action a, HashMap<String, String> state, HashMap<String, ArrayList<String>> newValues) {
        int cost = 0;
        for (GroundedCond prec : a.getPrecs()) {
            String var = prec.getVar().toString();
            DTG dtg = this.dtgs.getDTG(var);
            String iValue = state.get(var);
            int minPrecCost = dtg.pathCost(iValue, prec.getValue(), state, newValues, 0);
            ArrayList<String> initValues = newValues.get(var);
            if (initValues != null) {
                for (String initValue : initValues) {
                    int precCost = dtg.pathCost(initValue, prec.getValue(), state, newValues, 0);
                    if (precCost >= minPrecCost) continue;
                    minPrecCost = precCost;
                }
            }
            cost += minPrecCost;
        }
        return cost;
    }

    private void evaluateMultiagentPlan() {
        int[] totalOrder = this.currentPlan.linearization();
        HashMap<String, ArrayList<String>> varValues = this.currentPlan.computeMultiState(totalOrder, this.pf);
        PriorityQueue<Goal> openGoals = new PriorityQueue<Goal>();
        int h = 0;
        for (Goal g : this.goals) {
            String v = g.varName;
            String end = g.varValue;
            if (DTGHeuristic.holds(v, end, varValues)) continue;
            String init = DTGHeuristic.selectInitialValueMulti(v, end, this.dtgs.getDTG(v), varValues);
            g.distance = this.pathCostMulti(v, init, end);
            openGoals.add(g);
        }
        while (!openGoals.isEmpty()) {
            h += this.solveConditionMulti((Goal)openGoals.poll(), varValues, openGoals, null);
        }
        this.currentPlan.setH(h, 0);
        this.evaluateMultiagentPlanPrivacy(varValues);
    }

    private void evaluateMultiagentPlanPrivacy(HashMap<String, ArrayList<String>> varValues) {
        if (varValues == null) {
            int[] totalOrder = this.currentPlan.linearization();
            varValues = this.currentPlan.computeMultiState(totalOrder, this.pf);
        }
        PriorityQueue<Goal> openGoals = new PriorityQueue<Goal>();
        for (int i = 0; i < this.pgoals.size(); ++i) {
            int hp = 0;
            Goal g = this.pgoals.get(i);
            String v = g.varName;
            String end = g.varValue;
            if (!DTGHeuristic.holds(v, end, varValues)) {
                String init = DTGHeuristic.selectInitialValueMulti(v, end, this.dtgs.getDTG(v), varValues);
                g.distance = this.pathCostMulti(v, init, end);
                openGoals.add(g);
            }
            while (!openGoals.isEmpty()) {
                hp += this.solveConditionMulti((Goal)openGoals.poll(), varValues, openGoals, null);
            }
            this.currentPlan.setHPriv(hp, i);
        }
    }

    private int pathCostMulti(String var, String initValue, String endValue) {
        DTG dtg = this.dtgs.getDTG(var);
        return dtg.pathCostMulti(initValue, endValue);
    }

    private static String selectInitialValueMulti(String varName, String endValue, DTG dtg, HashMap<String, ArrayList<String>> varValues) {
        ArrayList<String> valueList = varValues.get(varName);
        if (valueList == null) {
            return "?";
        }
        String bestValue = null;
        int bestCost = -1;
        for (String value : valueList) {
            if (bestValue == null) {
                bestCost = dtg.pathCostMulti(value, endValue);
                bestValue = value;
                continue;
            }
            int cost = dtg.pathCostMulti(value, endValue);
            if (cost == -1 || cost >= bestCost) continue;
            bestCost = cost;
            bestValue = value;
        }
        return bestValue != null ? bestValue : "?";
    }

    private int solveConditionMulti(Goal goal, HashMap<String, ArrayList<String>> varValues, PriorityQueue<Goal> openGoals, TransitionCostRequest tcr) {
        String varName = goal.varName;
        String varValue = goal.varValue;
        if (DTGHeuristic.holds(varName, varValue, varValues)) {
            return 0;
        }
        DTG dtg = this.dtgs.getDTG(varName);
        String initValue = DTGHeuristic.selectInitialValueMulti(varName, varValue, dtg, varValues);
        int h = !dtg.unknownValue(varValue) && !dtg.unknownValue(initValue) ? this.evaluateWithKnownValues(varName, initValue, varValue, dtg, varValues, tcr, openGoals) : (dtg.unknownValue(varValue) ? this.evaluateWithUnknownFinalvalue(varName, initValue, varValue, dtg, varValues, tcr, openGoals) : this.evaluateWithUnknownInitialvalue(varName, varValue, dtg, varValues, tcr, openGoals));
        return h;
    }

    private int evaluateWithUnknownInitialvalue(String varName, String varValue, DTG dtg, HashMap<String, ArrayList<String>> varValues, TransitionCostRequest tcr, PriorityQueue<Goal> openGoals) {
        DTGTransition[] transitions;
        int h = 1000;
        for (DTGTransition t : transitions = dtg.getTransitionsFrom("?")) {
            int cost;
            if (tcr != null && tcr.varName.equals(varName) && tcr.endValue.equals(t.getFinalValue()) || (cost = this.requestTransitionCost(varName, "?", t.getFinalValue(), varValues, dtg, tcr)) == 1000) continue;
            ArrayList<String> values = varValues.get(varName);
            if (values == null) {
                values = new ArrayList();
                values.add(t.getFinalValue());
                varValues.put(varName, values);
            } else if (!values.contains(t.getFinalValue())) {
                values.add(t.getFinalValue());
            }
            int restCost = this.evaluateWithKnownValues(varName, t.getFinalValue(), varValue, dtg, varValues, tcr, openGoals);
            if (restCost == 1000) continue;
            h = cost + restCost;
            break;
        }
        return h;
    }

    private int evaluateWithUnknownFinalvalue(String varName, String initValue, String varValue, DTG dtg, HashMap<String, ArrayList<String>> varValues, TransitionCostRequest tcr, PriorityQueue<Goal> openGoals) {
        int h = 1000;
        DTGTransition[] transitions = dtg.getTransitionsTo("?");
        if (transitions != null) {
            for (DTGTransition t : transitions) {
                int restCost;
                openGoals = new PriorityQueue();
                int cost = this.evaluateWithKnownValues(varName, initValue, t.getStartValue(), dtg, varValues, tcr, openGoals);
                if (cost == 1000 || (restCost = this.requestTransitionCost(varName, t.getStartValue(), varValue, varValues, dtg, tcr)) == 1000) continue;
                h = cost + restCost;
                break;
            }
        }
        return h;
    }

    private static boolean holds(String varName, String value, HashMap<String, ArrayList<String>> varValues) {
        ArrayList<String> values = varValues.get(varName);
        if (values == null) {
            return false;
        }
        return values.contains(value);
    }

    private int evaluateWithKnownValues(String varName, String initValue, String varValue, DTG dtg, HashMap<String, ArrayList<String>> varValues, TransitionCostRequest tcr, PriorityQueue<Goal> openGoals) {
        int h = 0;
        String[] path = dtg.getPathMulti(initValue, varValue);
        String prevValue = path[0];
        for (int i = 1; i < path.length; ++i) {
            String nextValue;
            block6: {
                Action a;
                block4: {
                    ArrayList<String> values;
                    block5: {
                        nextValue = path[i];
                        a = this.selectProductorMulti(varName, prevValue, nextValue, varValues);
                        if (a != null) break block4;
                        h += this.requestTransitionCost(varName, prevValue, nextValue, varValues, dtg, tcr);
                        values = varValues.get(varName);
                        if (values != null) break block5;
                        values = new ArrayList();
                        values.add(nextValue);
                        varValues.put(varName, values);
                        break block6;
                    }
                    if (values.contains(nextValue)) break block6;
                    values.add(nextValue);
                    break block6;
                }
                ++h;
                for (GroundedCond groundedCond : a.getPrecs()) {
                    String precVarName = groundedCond.getVar().toString();
                    if (DTGHeuristic.holds(precVarName, groundedCond.getValue(), varValues)) continue;
                    String precInitValue = DTGHeuristic.selectInitialValueMulti(precVarName, groundedCond.getValue(), this.dtgs.getDTG(precVarName), varValues);
                    Goal newOpenGoal = new Goal(groundedCond, this.pathCostMulti(precVarName, precInitValue, groundedCond.getValue()));
                    openGoals.add(newOpenGoal);
                }
                for (Serializable serializable : a.getEffs()) {
                    ArrayList<String> values = varValues.get(serializable.getVar().toString());
                    if (values == null) {
                        values = new ArrayList();
                        values.add(serializable.getValue());
                        varValues.put(serializable.getVar().toString(), values);
                        continue;
                    }
                    if (values.contains(serializable.getValue())) continue;
                    values.add(serializable.getValue());
                }
            }
            prevValue = nextValue;
        }
        return h;
    }

    private Action selectProductorMulti(String varName, String startValue, String endValue, HashMap<String, ArrayList<String>> varValues) {
        ArrayList<Action> productors = this.productors.get(varName + "," + endValue);
        if (productors == null || productors.isEmpty()) {
            return null;
        }
        Action bestAction = null;
        int costBest = 1000;
        for (int i = 0; i < productors.size(); ++i) {
            int cost;
            if (!this.hasPrecondition(productors.get(i), varName, startValue) || (cost = this.computeCostMulti(productors.get(i), varValues)) >= costBest) continue;
            costBest = cost;
            bestAction = productors.get(i);
        }
        return bestAction;
    }

    private int computeCostMulti(Action a, HashMap<String, ArrayList<String>> varValues) {
        int cost = 0;
        for (GroundedCond prec : a.getPrecs()) {
            String var = prec.getVar().toString();
            DTG dtg = this.dtgs.getDTG(var);
            int minPrecCost = 1000;
            ArrayList<String> initValues = varValues.get(var);
            if (initValues != null && !initValues.isEmpty()) {
                for (String initValue : initValues) {
                    int precCost = dtg.pathCostMulti(initValue, prec.getValue());
                    if (precCost >= minPrecCost) continue;
                    minPrecCost = precCost;
                }
                cost += minPrecCost;
                continue;
            }
            cost += dtg.pathCostMulti("?", prec.getValue());
        }
        return cost;
    }

    private int requestTransitionCost(String varName, String prevValue, String nextValue, HashMap<String, ArrayList<String>> varValues, DTG dtg, TransitionCostRequest prevTcr) {
        DTGTransition t = dtg.getTransition(prevValue, nextValue);
        ArrayList<String> askedAgents = new ArrayList<String>();
        int h = 1000;
        for (String ag : t.getAgents()) {
            if (ag.equals(this.comm.getThisAgentName()) || this.detectLoop(ag, prevTcr)) continue;
            TransitionCostRequest tcr = new TransitionCostRequest(varName, prevValue, nextValue, this.comm.getThisAgentName(), prevTcr, this.requestId);
            tcr.setState(varValues, this.groundedTask, ag);
            this.comm.sendMessage(ag, tcr, false);
            askedAgents.add(ag);
        }
        DTGMessageFilter filter = new DTGMessageFilter(askedAgents, this.requestId++);
        while (!askedAgents.isEmpty()) {
            Serializable msg = this.comm.receiveMessage(filter, false);
            if (msg instanceof ReplyTransitionCost) {
                int index = askedAgents.indexOf(this.comm.getSenderAgent());
                askedAgents.remove(index);
                int cost = ((ReplyTransitionCost)msg).cost;
                if (cost >= h) continue;
                h = cost;
                continue;
            }
            if (msg instanceof String) {
                assert (((String)((Object)msg)).equals("<END>"));
                ++this.ready;
                continue;
            }
            TransitionCostRequest tcr = (TransitionCostRequest)msg;
            this.evaluateRequest(tcr, this.comm.getSenderAgent());
        }
        return h;
    }

    private boolean detectLoop(String ag, TransitionCostRequest t) {
        if (t == null) {
            return false;
        }
        int index = t.agents.indexOf(ag);
        return index != -1;
    }

    private void evaluateRequest(TransitionCostRequest t, String fromAgent) {
        if (this.totalOrderBase == null) {
            this.totalOrderBase = this.basePlan.linearization();
        }
        HashMap<String, ArrayList<String>> varValues = this.basePlan.computeMultiState(this.totalOrderBase, this.pf);
        t.updateState(varValues);
        PriorityQueue<Goal> openGoals = new PriorityQueue<Goal>();
        openGoals.add(t.getGoal());
        int h = 0;
        while (!openGoals.isEmpty()) {
            h += this.solveConditionMulti((Goal)openGoals.poll(), varValues, openGoals, t);
        }
        this.comm.sendMessage(fromAgent, new ReplyTransitionCost(h, t.requestId), false);
    }

    @Override
    public void waitEndEvaluation() {
        if (this.comm.batonAgent()) {
            ++this.ready;
            while (this.ready < this.comm.numAgents()) {
                Serializable msg = this.comm.receiveMessage(false);
                if (msg instanceof String) {
                    assert (((String)((Object)msg)).equals("<END>"));
                    ++this.ready;
                    continue;
                }
                String fromAgent = this.comm.getSenderAgent();
                TransitionCostRequest tcr = (TransitionCostRequest)msg;
                this.evaluateRequest(tcr, fromAgent);
            }
            this.comm.sendMessage((Serializable)((Object)"<END>"), false);
        } else {
            boolean endStage = false;
            this.comm.sendMessage(this.comm.getBatonAgent(), (Serializable)((Object)"<END>"), false);
            while (!endStage) {
                Serializable msg = this.comm.receiveMessage(false);
                if (msg instanceof String) {
                    assert (((String)((Object)msg)).equals("<END>"));
                    endStage = true;
                    continue;
                }
                String fromAgent = this.comm.getSenderAgent();
                TransitionCostRequest tcr = (TransitionCostRequest)msg;
                this.evaluateRequest(tcr, fromAgent);
            }
        }
    }

    @Override
    public boolean supportsMultiThreading() {
        return false;
    }

    @Override
    public Object getInformation(int infoFlag) {
        return null;
    }

    @Override
    public boolean requiresHLandStage() {
        return false;
    }

    @Override
    public void evaluatePlan(HPlan p, int threadIndex, ArrayList<Integer> achievedLandmarks) {
    }

    @Override
    public int numGlobalLandmarks() {
        return 0;
    }

    @Override
    public ArrayList<Integer> checkNewLandmarks(HPlan plan, BitSet achievedLandmarks) {
        return null;
    }

    public static class DTGMessageFilter
    implements MessageFilter {
        private final int requestId;
        private final ArrayList<String> askedAgents;

        public DTGMessageFilter(ArrayList<String> askedAgents, int requestId) {
            this.requestId = requestId;
            this.askedAgents = askedAgents;
        }

        @Override
        public boolean validMessage(Message m) {
            if (m.content() instanceof ReplyTransitionCost) {
                return ((ReplyTransitionCost)m.content()).requestId == this.requestId && this.askedAgents.contains(m.sender());
            }
            if (m.content() instanceof String && ((String)((Object)m.content())).equals("<END>")) {
                return true;
            }
            return m.content() instanceof TransitionCostRequest;
        }
    }

    public static class ReplyTransitionCost
    implements Serializable {
        private static final long serialVersionUID = 8450612556336972847L;
        int cost;
        int requestId;

        public ReplyTransitionCost(int cost, int requestId) {
            this.cost = cost;
            this.requestId = requestId;
        }
    }

    public static class TransitionCostRequest
    implements Serializable {
        private static final long serialVersionUID = 5485301296724177527L;
        public ArrayList<String> agents;
        public String varName;
        public String startValue;
        public String endValue;
        public ArrayList<ArrayList<String>> varValuesList;
        public int requestId;

        public TransitionCostRequest(String varName, String prevValue, String nextValue, String agentName, TransitionCostRequest prevTcr, int requestId) {
            this.varName = varName;
            this.startValue = prevValue;
            this.endValue = nextValue;
            this.agents = new ArrayList();
            if (prevTcr != null) {
                for (String ag : prevTcr.agents) {
                    this.agents.add(ag);
                }
            }
            this.agents.add(agentName);
            this.varValuesList = new ArrayList();
            this.requestId = requestId;
        }

        public Goal getGoal() {
            return new Goal(this.varName, this.endValue, -1);
        }

        public void updateState(HashMap<String, ArrayList<String>> varValues) {
            for (ArrayList<String> list : this.varValuesList) {
                int i;
                ArrayList<String> values = varValues.get(list.get(0));
                if (values == null) {
                    values = new ArrayList();
                    for (i = 1; i < list.size(); ++i) {
                        values.add(list.get(i));
                    }
                    varValues.put(list.get(0), values);
                    continue;
                }
                for (i = 1; i < list.size(); ++i) {
                    if (values.contains(list.get(i))) continue;
                    values.add(list.get(i));
                }
            }
        }

        public void setState(HashMap<String, ArrayList<String>> varValues, GroundedTask groundedTask, String toAgent) {
            for (String v : varValues.keySet()) {
                GroundedVar gv = groundedTask.getVarByName(v);
                if (!gv.shareable(toAgent)) continue;
                ArrayList<String> list = varValues.get(v);
                ArrayList<String> newList = new ArrayList<String>(list.size() + 1);
                newList.add(v);
                for (String value : list) {
                    if (!gv.shareable(value, toAgent)) continue;
                    newList.add(value);
                }
                this.varValuesList.add(newList);
            }
        }

        public String toString() {
            return this.varName + "(" + this.startValue + "->" + this.endValue + ")";
        }
    }

    private static class Goal
    implements Comparable<Goal> {
        String varName;
        String varValue;
        int distance;

        public Goal(GroundedCond goal, int distance) {
            this(goal.getVar().toString(), goal.getValue(), distance);
        }

        public Goal(String varName, String varValue, int distance) {
            this.varName = varName;
            this.varValue = varValue;
            this.distance = distance;
        }

        @Override
        public int compareTo(Goal g) {
            return g.distance - this.distance;
        }

        public String toString() {
            return this.varName + "=" + this.varValue + "(" + this.distance + ")";
        }

        public int hashCode() {
            return (this.varName + "=" + this.varValue).hashCode();
        }

        public boolean equals(Object x) {
            Goal g = (Goal)x;
            return this.varName.equals(g.varName) && this.varValue.equals(g.varValue);
        }
    }
}

