/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_grounding;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import org.agreement_technologies.common.map_grounding.Action;
import org.agreement_technologies.common.map_grounding.GroundedCond;
import org.agreement_technologies.common.map_grounding.GroundedEff;
import org.agreement_technologies.common.map_grounding.GroundedNumericEff;
import org.agreement_technologies.common.map_grounding.GroundedNumericExpression;
import org.agreement_technologies.common.map_grounding.GroundedRule;
import org.agreement_technologies.common.map_grounding.GroundedTask;
import org.agreement_technologies.common.map_grounding.GroundedVar;
import org.agreement_technologies.common.map_grounding.ReachedValue;
import org.agreement_technologies.common.map_parser.Fact;
import org.agreement_technologies.common.map_parser.Function;
import org.agreement_technologies.common.map_parser.Metric;
import org.agreement_technologies.common.map_parser.Parameter;
import org.agreement_technologies.common.map_parser.SharedData;
import org.agreement_technologies.common.map_parser.Task;

public class GroundedTaskImp
implements GroundedTask {
    private static final long serialVersionUID = 9198476578040469582L;
    static final int UNDEFINED = 0;
    String domainName;
    String problemName;
    String[] requirements;
    String[] types;
    boolean[][] typesMatrix;
    Hashtable<String, Integer> typeIndex;
    int booleanTypeIndex;
    ArrayList<String> objects;
    Hashtable<String, Integer> objectIndex;
    ArrayList<ArrayList<Integer>> objectTypes;
    ArrayList<Function> functions;
    Hashtable<String, Integer> functionIndex;
    ArrayList<Boolean> staticFunction;
    ArrayList<GroundedVarImp> vars;
    ArrayList<GroundedVarImp> numericVars;
    Hashtable<GroundedVarImp, Integer> varIndex;
    Hashtable<String, GroundedVarImp> varNames;
    ArrayList<Action> actions;
    Hashtable<String, Integer> actionIndex;
    ArrayList<ActionImp> rules;
    Hashtable<String, Integer> ruleIndex;
    ArrayList<GroundedValue> values;
    Hashtable<GroundedValue, Integer> valueIndex;
    ArrayList<GroundedValue> newValues;
    ArrayList<GroundedCond> globalGoals;
    Hashtable<String, Integer> agentIndex;
    int thisAgentIndex;
    String agentName;
    ArrayList<ArrayList<GroundedSharedData>> sharedDataByFunction;
    int sameObjects;
    double selfInterest;
    double metricThreshold;
    ArrayList<GroundedCond> preferences;
    Hashtable<String, Integer> preferenceIndex;
    ArrayList<String> preferenceNames;
    GroundedMetric metric;
    double[] violatedCost;
    boolean metricRequiresMakespan;
    final boolean negationByFailure;

    public GroundedTaskImp(Task task, int sameObjects, boolean negationByFailure) {
        this.domainName = task.getDomainName();
        this.problemName = task.getProblemName();
        this.sameObjects = sameObjects;
        this.negationByFailure = negationByFailure;
        String[] aux = task.getRequirements();
        this.requirements = new String[aux.length];
        System.arraycopy(aux, 0, this.requirements, 0, aux.length);
        aux = task.getTypes();
        this.types = new String[aux.length];
        System.arraycopy(aux, 0, this.types, 0, aux.length);
        this.initTypesMatrix(task);
        aux = task.getObjects();
        this.objects = new ArrayList(aux.length + 1);
        this.objects.add("?");
        for (String obj : aux) {
            this.objects.add(obj);
        }
        this.initObjects(task);
        this.vars = new ArrayList();
        this.numericVars = new ArrayList();
        this.initVariables(task);
        this.actions = new ArrayList();
        this.actionIndex = new Hashtable();
        this.rules = new ArrayList();
        this.ruleIndex = new Hashtable();
        this.values = new ArrayList();
        this.valueIndex = new Hashtable();
        this.newValues = null;
        this.globalGoals = this.initGoals(task);
        this.selfInterest = task.getSelfInterest();
        this.metricThreshold = task.getMetricThreshold();
        this.preferences = this.initPreferences(task);
        this.metric = new GroundedMetric(task.getMetric());
        this.computeViolatedCosts();
    }

    private void computeViolatedCosts() {
        this.violatedCost = new double[this.preferences.size()];
        this.computeViolatedCosts(this.metric, null);
    }

    private void computeViolatedCosts(GroundedMetric m, GroundedMetric parent) {
        switch (m.metricType) {
            case 0: {
                int prefIndex = -1;
                for (int i = 0; i < this.preferences.size() && prefIndex == -1; ++i) {
                    if (this.preferences.get(i) != m.preference) continue;
                    prefIndex = i;
                }
                this.violatedCost[prefIndex] = 1.0;
                if (parent == null) break;
                for (GroundedMetric t : parent.term) {
                    if (t.metricType != 3) continue;
                    int n = prefIndex;
                    this.violatedCost[n] = this.violatedCost[n] * t.number;
                }
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                for (GroundedMetric t : m.term) {
                    this.computeViolatedCosts(t, m);
                }
            }
        }
    }

    private ArrayList<GroundedCond> initPreferences(Task task) {
        this.preferenceIndex = new Hashtable();
        this.preferenceNames = new ArrayList();
        ArrayList<GroundedCond> pref = new ArrayList<GroundedCond>();
        Fact[] g = task.getPreferences();
        for (int i = 0; i < g.length; ++i) {
            String pname = task.getPreferenceName(i);
            int index = this.functionIndex.get(g[i].getFunctionName());
            Function func = this.functions.get(index);
            if (func.isMultifunction() || g[i].getValues().length != 1) {
                throw new RuntimeException("Invalid preference '" + pname + "'");
            }
            GroundedVarImp v = this.initSingleFunctionVariable(g[i], func, false);
            String value = g[i].getValues()[0];
            GroundedValue gv = new GroundedValue(v.varIndex, this.objectIndex.get(value));
            ActionCondition ac = new ActionCondition(gv, !g[i].negated());
            this.preferenceIndex.put(pname, pref.size());
            this.preferenceNames.add(pname);
            pref.add(ac);
        }
        return pref;
    }

    @Override
    public void optimize() {
        for (Action a : this.actions) {
            a.optimize();
        }
        this.varNames = new Hashtable(this.vars.size());
        for (GroundedVarImp v : this.vars) {
            this.varNames.put(v.toString(), v);
        }
    }

    @Override
    public GroundedCond createGroundedCondition(int condition, GroundedVar var, String value) {
        if (var == null) {
            return null;
        }
        Integer varIndex = this.getVarIndex((GroundedVarImp)var);
        if (varIndex == null) {
            return null;
        }
        Integer valueIndex = this.getObjectIndex(value);
        if (valueIndex == null) {
            valueIndex = 0;
        }
        GroundedValue gVar = new GroundedValue(varIndex, valueIndex);
        ActionCondition ac = new ActionCondition(gVar, condition == 1);
        return ac;
    }

    @Override
    public GroundedEff createGroundedEffect(GroundedVar var, String value) {
        if (var == null) {
            return null;
        }
        Integer varIndex = this.getVarIndex((GroundedVarImp)var);
        if (varIndex == null) {
            return null;
        }
        Integer valueIndex = this.getObjectIndex(value);
        if (valueIndex == null) {
            valueIndex = 0;
        }
        GroundedValue gVar = new GroundedValue(varIndex, valueIndex);
        ActionCondition ac = new ActionCondition(gVar);
        return ac;
    }

    @Override
    public Action createAction(String opName, String[] params, GroundedCond[] prec, GroundedEff[] eff) {
        int i;
        ActionImp a = new ActionImp(opName, params.length, prec.length, eff.length);
        for (i = 0; i < params.length; ++i) {
            Integer objIndex = this.getObjectIndex(params[i]);
            if (objIndex == null) {
                objIndex = 0;
            }
            a.setParam(i, objIndex, params[i]);
        }
        for (i = 0; i < prec.length; ++i) {
            a.prec[i] = new ActionCondition(prec[i]);
        }
        for (i = 0; i < eff.length; ++i) {
            a.eff[i] = new ActionCondition(eff[i]);
        }
        return a;
    }

    public void initAgents(Task task, String agentName) {
        int i;
        this.agentName = agentName;
        int[] agType = new int[]{this.typeIndex.get("agent")};
        ArrayList<String> agentList = new ArrayList<String>();
        for (i = 0; i < this.objects.size(); ++i) {
            if (!this.objectIsCompatible(i, agType)) continue;
            agentList.add(this.objects.get(i));
        }
        if (!agentList.contains(agentName)) {
            agentList.add(agentName);
        }
        Collections.sort(agentList);
        this.thisAgentIndex = agentList.indexOf(agentName);
        this.agentIndex = new Hashtable();
        for (i = 0; i < agentList.size(); ++i) {
            String agName = (String)agentList.get(i);
            this.agentIndex.put(agName, i);
        }
        this.initSharedData(task);
    }

    private void initSharedData(Task task) {
        this.sharedDataByFunction = new ArrayList();
        for (int i = 0; i < this.functions.size(); ++i) {
            this.sharedDataByFunction.add(new ArrayList());
        }
        for (SharedData sd : task.getSharedData()) {
            GroundedSharedData gsd = new GroundedSharedData(sd);
            this.sharedDataByFunction.get(gsd.fncIndex).add(gsd);
        }
    }

    private ArrayList<GroundedCond> initGoals(Task task) {
        ArrayList<GroundedCond> goals = new ArrayList<GroundedCond>();
        Fact[] g = task.getGoals();
        for (int i = 0; i < g.length; ++i) {
            String[] values;
            int index = this.functionIndex.get(g[i].getFunctionName());
            Function func = this.functions.get(index);
            if (func.isMultifunction()) {
                GroundedVarImp[] varList;
                for (GroundedVarImp v : varList = this.initMultiFunctionVariable(g[i], false)) {
                    GroundedValue gv = new GroundedValue(v.varIndex, g[i].negated() ? this.objectIndex.get("false") : this.objectIndex.get("true"));
                    goals.add(new ActionCondition(gv, true));
                }
                continue;
            }
            GroundedVarImp v = this.initSingleFunctionVariable(g[i], func, false);
            for (String value : values = g[i].getValues()) {
                GroundedValue gv = new GroundedValue(v.varIndex, this.objectIndex.get(value));
                goals.add(new ActionCondition(gv, !g[i].negated()));
            }
        }
        return goals;
    }

    private void initVariables(Task task) {
        Function[] funcList = task.getFunctions();
        this.functions = new ArrayList(funcList.length);
        this.functionIndex = new Hashtable(funcList.length);
        for (int i = 0; i < funcList.length; ++i) {
            this.functions.add(funcList[i]);
            this.functionIndex.put(funcList[i].getName(), i);
        }
        this.varIndex = new Hashtable();
        for (Fact fact : task.getInit()) {
            int index = this.functionIndex.get(fact.getFunctionName());
            Function func = this.functions.get(index);
            if (func.isMultifunction()) {
                this.initMultiFunctionVariable(fact, true);
                continue;
            }
            this.initSingleFunctionVariable(fact, func, true);
        }
    }

    private GroundedVarImp[] initMultiFunctionVariable(Fact fact, boolean initialState) {
        String[] values = fact.getValues();
        GroundedVarImp[] gvList = new GroundedVarImp[values.length];
        for (int i = 0; i < values.length; ++i) {
            int fncIndex = this.getFunctionIndex(fact.getFunctionName());
            GroundedVarImp v = new GroundedVarImp(fact.getFunctionName(), this.varIndex.size(), fncIndex, fact.getParameters(), values[i]);
            if (this.varIndex.containsKey(v)) {
                v = this.vars.get(this.varIndex.get(v));
                if (initialState) {
                    this.updateInitialVariableValues(v, fact, true);
                }
            } else {
                if (initialState) {
                    this.updateInitialVariableValues(v, fact, true);
                }
                v.setDomain(new String[]{"boolean"});
                this.varIndex.put(v, this.vars.size());
                this.vars.add(v);
            }
            gvList[i] = v;
        }
        return gvList;
    }

    private GroundedVarImp initSingleFunctionVariable(Fact fact, Function func, boolean initialState) {
        int fncIndex = this.getFunctionIndex(fact.getFunctionName());
        GroundedVarImp v = new GroundedVarImp(fact.getFunctionName(), this.varIndex.size(), fncIndex, fact.getParameters());
        if (this.varIndex.containsKey(v)) {
            v = this.vars.get(this.varIndex.get(v));
            if (initialState) {
                this.updateInitialVariableValues(v, fact, false);
            }
        } else {
            if (initialState) {
                this.updateInitialVariableValues(v, fact, false);
            }
            v.setDomain(func.getDomain());
            this.varIndex.put(v, this.vars.size());
            this.vars.add(v);
        }
        return v;
    }

    private void updateInitialVariableValues(GroundedVarImp v, Fact fact, boolean multi) {
        if (multi) {
            if (fact.negated()) {
                v.setTrueValue("false", this.objectIndex);
                v.addFalseValue("true", this.objectIndex);
            } else {
                v.setTrueValue("true", this.objectIndex);
                v.addFalseValue("false", this.objectIndex);
            }
        } else {
            String[] values;
            for (String value : values = fact.getValues()) {
                if (value.equalsIgnoreCase("true") && values.length == 1) {
                    if (fact.negated()) {
                        v.setTrueValue("false", this.objectIndex);
                        v.addFalseValue(value, this.objectIndex);
                        continue;
                    }
                    v.setTrueValue(value, this.objectIndex);
                    v.addFalseValue("false", this.objectIndex);
                    continue;
                }
                if (value.equalsIgnoreCase("false") && values.length == 1) {
                    if (fact.negated()) {
                        v.setTrueValue("true", this.objectIndex);
                        v.addFalseValue(value, this.objectIndex);
                        continue;
                    }
                    v.setTrueValue(value, this.objectIndex);
                    v.addFalseValue("true", this.objectIndex);
                    continue;
                }
                if (fact.negated()) {
                    v.addFalseValue(value, this.objectIndex);
                    continue;
                }
                v.setTrueValue(value, this.objectIndex);
            }
        }
    }

    private void initObjects(Task task) {
        int numObjs = this.objects.size();
        this.objectIndex = new Hashtable(numObjs);
        this.objectTypes = new ArrayList(numObjs);
        for (int i = 0; i < numObjs; ++i) {
            this.objectIndex.put(this.objects.get(i), i);
            String[] types = i != 0 ? task.getObjectTypes(this.objects.get(i)) : new String[]{};
            this.objectTypes.add(new ArrayList(types.length));
            for (int j = 0; j < types.length; ++j) {
                this.objectTypes.get(i).add(this.typeIndex.get(types[j]));
            }
        }
    }

    public int createNewObject(String objName, String[] objTypes) {
        int index = this.objects.size();
        this.objects.add(objName);
        this.objectIndex.put(objName, index);
        ArrayList<Integer> types = new ArrayList<Integer>();
        for (String t : objTypes) {
            Integer tindex = this.typeIndex.get(t);
            if (tindex == null) continue;
            types.add(tindex);
        }
        this.objectTypes.add(types);
        return index;
    }

    private void initTypesMatrix(Task task) {
        int numTypes = this.types.length;
        this.booleanTypeIndex = -1;
        this.typeIndex = new Hashtable(numTypes);
        for (int i = 0; i < numTypes; ++i) {
            this.typeIndex.put(this.types[i], i);
            if (!this.types[i].equalsIgnoreCase("boolean")) continue;
            this.booleanTypeIndex = i;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        this.typesMatrix = new boolean[numTypes][numTypes];
        for (int i = 0; i < numTypes; ++i) {
            this.typesMatrix[i][i] = true;
            this.getParentTypes(task, i, list);
            for (Integer j : list) {
                this.typesMatrix[i][j.intValue()] = true;
            }
            list.clear();
        }
    }

    private void getParentTypes(Task task, int typeIndex, ArrayList<Integer> list) {
        String[] pTypes;
        for (String pType : pTypes = task.getParentTypes(this.types[typeIndex])) {
            int pTypeIndex = this.typeIndex.get(pType);
            if (list.contains(pTypeIndex)) continue;
            list.add(pTypeIndex);
            this.getParentTypes(task, pTypeIndex, list);
        }
    }

    public ReachedValue[] getNewValues() {
        ArrayList<GroundedValue> nv = this.newValues == null ? this.values : this.newValues;
        int numValues = 0;
        for (GroundedValue v : nv) {
            if (this.staticFunction.get(v.var().fncIndex).booleanValue()) continue;
            ++numValues;
        }
        ReachedValue[] res = new ReachedValue[numValues];
        int i = 0;
        for (GroundedValue v : nv) {
            if (this.staticFunction.get(v.var().fncIndex).booleanValue()) continue;
            res[i++] = v;
        }
        return res;
    }

    public void resetNewValues() {
        this.newValues = new ArrayList();
    }

    public void setStaticFunctions(Hashtable<String, Boolean> staticFunctions) {
        this.staticFunction = new ArrayList(this.functions.size());
        for (Function f : this.functions) {
            this.staticFunction.add(staticFunctions.containsKey(f.getName()));
        }
    }

    @Override
    public String getDomainName() {
        return this.domainName;
    }

    @Override
    public String getProblemName() {
        return this.problemName;
    }

    @Override
    public String getAgentName() {
        return this.agentName;
    }

    @Override
    public String[] getAgentNames() {
        Enumeration<String> list = this.agentIndex.keys();
        String[] ags = new String[this.agentIndex.size()];
        int n = 0;
        while (list.hasMoreElements()) {
            ags[n++] = list.nextElement();
        }
        return ags;
    }

    @Override
    public String[] getRequirements() {
        return this.requirements;
    }

    @Override
    public String[] getTypes() {
        return this.types;
    }

    @Override
    public String[] getParentTypes(String type) {
        int n = 0;
        int typeIndex = this.typeIndex.get(type);
        for (int i = 0; i < this.types.length; ++i) {
            if (!this.typesMatrix[typeIndex][i] || typeIndex == i) continue;
            ++n;
        }
        String[] pTypes = new String[n];
        n = 0;
        for (int i = 0; i < this.types.length; ++i) {
            if (!this.typesMatrix[typeIndex][i] || typeIndex == i) continue;
            pTypes[n++] = this.types[i];
        }
        return pTypes;
    }

    @Override
    public String[] getObjects() {
        return this.objects.toArray(new String[this.objects.size()]);
    }

    @Override
    public String[] getObjectTypes(String objName) {
        int objIndex = this.objectIndex.get(objName);
        ArrayList<Integer> objTypes = this.objectTypes.get(objIndex);
        String[] res = new String[objTypes.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.types[objTypes.get(i)];
        }
        return res;
    }

    @Override
    public GroundedVar[] getVars() {
        int numVars = 0;
        for (GroundedVarImp v : this.vars) {
            if (this.staticFunction.get(v.fncIndex).booleanValue()) continue;
            ++numVars;
        }
        GroundedVar[] res = new GroundedVar[numVars];
        int i = 0;
        for (GroundedVarImp v : this.vars) {
            if (this.staticFunction.get(v.fncIndex).booleanValue()) continue;
            res[i++] = v;
        }
        return res;
    }

    @Override
    public ArrayList<Action> getActions() {
        return this.actions;
    }

    @Override
    public GroundedRule[] getBeliefs() {
        return this.rules.toArray(new GroundedRule[this.rules.size()]);
    }

    @Override
    public ArrayList<GroundedCond> getGlobalGoals() {
        return this.globalGoals;
    }

    public String toString() {
        String[] pt;
        StringBuilder s = new StringBuilder();
        s.append("Domain: ").append(this.getDomainName()).append("\n");
        s.append("Problem: ").append(this.getProblemName()).append("\n");
        s.append("Agent: ").append(this.getAgentName()).append("\n");
        for (String a : this.getAgentNames()) {
            s.append("* ").append(a).append("\n");
        }
        s.append("Requirements:\n");
        for (String r : this.getRequirements()) {
            s.append("* ").append(r).append("\n");
        }
        s.append("Types:\n");
        for (String t : this.getTypes()) {
            pt = this.getParentTypes(t);
            s.append("* ").append(t).append(" [ ");
            for (String t2 : pt) {
                s.append(t2).append(" ");
            }
            s.append("]\n");
        }
        s.append("Objects:\n");
        for (String t : this.getObjects()) {
            pt = this.getObjectTypes(t);
            s.append("* ").append(t).append(" [ ");
            for (String t2 : pt) {
                s.append(t2).append(" ");
            }
            s.append("]\n");
        }
        s.append("Variables:\n");
        for (GroundedVar gv : this.getVars()) {
            s.append("* ").append(gv).append("\n");
        }
        s.append("Global goals:\n");
        for (GroundedCond g : this.getGlobalGoals()) {
            s.append("* ").append(g).append("\n");
        }
        return s.toString();
    }

    public int getTypeIndex(String name) {
        return this.typeIndex.get(name);
    }

    public int getFunctionIndex(String name) {
        return this.functionIndex.get(name);
    }

    public Integer getObjectIndex(String name) {
        return this.objectIndex.get(name);
    }

    public ArrayList<Integer> getAllDomainValues(int[] domainIndex) {
        ArrayList<Integer> dv = new ArrayList<Integer>();
        block0: for (int i = 0; i < this.objects.size(); ++i) {
            ArrayList<Integer> types = this.objectTypes.get(i);
            boolean isCompatible = false;
            for (Integer type : types) {
                for (int j = 0; j < domainIndex.length; ++j) {
                    if (!this.typesMatrix[type][domainIndex[j]]) continue;
                    isCompatible = true;
                }
                if (!isCompatible) continue;
                dv.add(i);
                continue block0;
            }
        }
        return dv;
    }

    public boolean objectIsCompatible(int objIndex, int[] types) {
        ArrayList<Integer> objTypes = this.objectTypes.get(objIndex);
        for (Integer ot : objTypes) {
            for (int t : types) {
                if (!this.typesMatrix[ot][t]) continue;
                return true;
            }
        }
        return false;
    }

    public GroundedVarImp addVariable(GroundedVarImp var) {
        int fncIndex = this.functionIndex.get(var.name);
        if (fncIndex == -1) {
            throw new RuntimeException("Unknown function: " + var.name);
        }
        String[] params = new String[var.paramIndex.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = this.objects.get(var.paramIndex[i]);
        }
        GroundedVarImp newVar = new GroundedVarImp(var.name, this.vars.size(), fncIndex, params);
        newVar.setDomain(var.domain);
        this.varIndex.put(newVar, newVar.varIndex);
        this.vars.add(newVar);
        return newVar;
    }

    private int addValue(int varIndex, int value, int currentLevel, int agIndex) {
        GroundedValue gv = new GroundedValue(varIndex, value);
        Integer gvIndex = this.valueIndex.get(gv);
        if (gvIndex == null) {
            gv.minTime = new int[this.agentIndex.size()];
            Arrays.fill(gv.minTime, -1);
            gvIndex = this.values.size();
            this.valueIndex.put(gv, gvIndex);
            this.values.add(gv);
        } else {
            gv = this.values.get(gvIndex);
        }
        if (currentLevel < gv.minTime[agIndex] || gv.minTime[agIndex] == -1) {
            gv.minTime[agIndex] = currentLevel;
        }
        return gvIndex;
    }

    public int addValue(int varIndex, int value, int currentLevel) {
        return this.addValue(varIndex, value, currentLevel, this.thisAgentIndex);
    }

    public Integer getVarIndex(GroundedVarImp v) {
        return this.varIndex.get(v);
    }

    public int createNewVariable(GroundedVarImp v) {
        v.varIndex = this.vars.size();
        v.fncIndex = this.functionIndex.get(v.name);
        v.paramNames = new String[v.paramIndex.length];
        for (int i = 0; i < v.paramIndex.length; ++i) {
            v.paramNames[i] = this.objects.get(v.paramIndex[i]);
        }
        Function f = this.functions.get(v.fncIndex);
        String[] domain = f.getDomain();
        v.domain = new String[domain.length];
        v.domainIndex = new int[domain.length];
        for (int i = 0; i < domain.length; ++i) {
            v.domain[i] = domain[i];
            v.domainIndex[i] = this.typeIndex.get(domain[i]);
        }
        v.trueValue = -1;
        v.falseValues = new ArrayList();
        this.vars.add(v);
        this.varIndex.put(v, v.varIndex);
        return v.varIndex;
    }

    public GroundedVarImp createNewNumericVariable(GroundedVarImp v) {
        v.varIndex = this.numericVars.size();
        v.fncIndex = this.functionIndex.get(v.name);
        v.paramNames = new String[v.paramIndex.length];
        for (int i = 0; i < v.paramIndex.length; ++i) {
            v.paramNames[i] = this.objects.get(v.paramIndex[i]);
        }
        Function f = this.functions.get(v.fncIndex);
        String[] domain = f.getDomain();
        v.domain = new String[domain.length];
        v.domainIndex = new int[domain.length];
        for (int i = 0; i < domain.length; ++i) {
            v.domain[i] = domain[i];
            v.domainIndex[i] = this.typeIndex.get(domain[i]);
        }
        v.trueValue = -1;
        v.falseValues = new ArrayList();
        this.numericVars.add(v);
        return v;
    }

    @Override
    public boolean negationByFailure() {
        return this.negationByFailure;
    }

    @Override
    public GroundedVar getVarByName(String varName) {
        return this.varNames.get(varName);
    }

    @Override
    public double getSelfInterestLevel() {
        return this.selfInterest;
    }

    @Override
    public double getMetricThreshold() {
        return this.metricThreshold;
    }

    @Override
    public double evaluateMetric(HashMap<String, String> state, double makespan) {
        return this.evaluateMetric(this.metric, state, makespan);
    }

    private double evaluateMetric(GroundedMetric m, HashMap<String, String> state, double makespan) {
        double res;
        switch (m.metricType) {
            case 0: {
                String value = state.get(m.preference.getVar().toString());
                res = value.equals(m.preference.getValue()) ? 0.0 : 1.0;
                break;
            }
            case 1: {
                res = 0.0;
                for (GroundedMetric mt : m.term) {
                    res += this.evaluateMetric(mt, state, makespan);
                }
                break;
            }
            case 2: {
                res = this.evaluateMetric(m.term.get(0), state, makespan);
                for (int i = 1; i < m.term.size(); ++i) {
                    res *= this.evaluateMetric(m.term.get(i), state, makespan);
                }
                break;
            }
            case 4: {
                res = makespan;
                break;
            }
            case 5: {
                res = 0.0;
                break;
            }
            default: {
                res = m.number;
            }
        }
        return res;
    }

    @Override
    public double evaluateMetricMulti(HashMap<String, ArrayList<String>> state, double makespan) {
        return this.evaluateMetricMulti(this.metric, state, makespan);
    }

    private double evaluateMetricMulti(GroundedMetric m, HashMap<String, ArrayList<String>> state, double makespan) {
        double res;
        block0 : switch (m.metricType) {
            case 0: {
                ArrayList<String> values = state.get(m.preference.getVar().toString());
                res = 1.0;
                if (values == null) break;
                for (String value : values) {
                    if (!value.equals(m.preference.getValue())) continue;
                    res = 0.0;
                    break block0;
                }
                break;
            }
            case 1: {
                res = 0.0;
                for (GroundedMetric mt : m.term) {
                    res += this.evaluateMetricMulti(mt, state, makespan);
                }
                break;
            }
            case 2: {
                res = this.evaluateMetricMulti(m.term.get(0), state, makespan);
                for (int i = 1; i < m.term.size(); ++i) {
                    res *= this.evaluateMetricMulti(m.term.get(i), state, makespan);
                }
                break;
            }
            case 4: {
                res = makespan;
                break;
            }
            default: {
                res = m.number;
            }
        }
        return res;
    }

    @Override
    public ArrayList<GroundedCond> getPreferences() {
        return this.preferences;
    }

    @Override
    public int getNumPreferences() {
        return this.preferences.size();
    }

    @Override
    public double getViolatedCost(int prefIndex) {
        return this.violatedCost[prefIndex];
    }

    @Override
    public boolean metricRequiresMakespan() {
        return this.metricRequiresMakespan;
    }

    public class GroundedMetric {
        public static final int MT_PREFERENCE = 0;
        public static final int MT_ADD = 1;
        public static final int MT_MULT = 2;
        public static final int MT_NUMBER = 3;
        public static final int MT_TOTAL_TIME = 4;
        public static final int MT_NONE = 5;
        int metricType;
        double number;
        GroundedCond preference;
        ArrayList<GroundedMetric> term;

        public GroundedMetric(Metric m) {
            GroundedTaskImp.this.metricRequiresMakespan = false;
            if (m == null) {
                this.metricType = 5;
            } else {
                this.metricType = m.getMetricType();
                switch (this.metricType) {
                    case 0: {
                        int prefIndex = GroundedTaskImp.this.preferenceIndex.get(m.getPreference());
                        this.preference = GroundedTaskImp.this.preferences.get(prefIndex);
                        break;
                    }
                    case 4: {
                        GroundedTaskImp.this.metricRequiresMakespan = true;
                        break;
                    }
                    case 3: {
                        this.number = m.getNumber();
                        break;
                    }
                    default: {
                        int n = m.getNumTerms();
                        this.term = new ArrayList();
                        for (int i = 0; i < n; ++i) {
                            this.term.add(new GroundedMetric(m.getTerm(i)));
                        }
                    }
                }
            }
        }
    }

    public class GroundedSharedData
    implements Serializable {
        private static final long serialVersionUID = -2147732192053461311L;
        int[] agents;
        int fncIndex;
        int[] params;
        int[][] paramTypes;
        int[] valueTypes;

        public GroundedSharedData(SharedData sd) {
            int i;
            String[] ag = sd.getAgents();
            this.agents = new int[ag.length];
            for (int i2 = 0; i2 < ag.length; ++i2) {
                this.agents[i2] = GroundedTaskImp.this.agentIndex.get(ag[i2]);
            }
            Function f = sd.getFunction();
            this.fncIndex = GroundedTaskImp.this.functionIndex.get(f.getName());
            Parameter[] fparams = f.getParameters();
            int numParams = fparams.length;
            if (f.isMultifunction()) {
                ++numParams;
            }
            this.params = new int[numParams];
            this.paramTypes = new int[numParams][];
            for (i = 0; i < fparams.length; ++i) {
                Parameter fparam = fparams[i];
                if (fparam.getName().startsWith("?")) {
                    this.params[i] = -1;
                    String[] types = fparam.getTypes();
                    this.paramTypes[i] = new int[types.length];
                    for (int j = 0; j < types.length; ++j) {
                        this.paramTypes[i][j] = GroundedTaskImp.this.typeIndex.get(types[j]);
                    }
                    continue;
                }
                this.params[i] = GroundedTaskImp.this.objectIndex.get(fparam.getName());
            }
            if (f.isMultifunction()) {
                i = this.params.length - 1;
                String[] types = f.getDomain();
                this.paramTypes[i] = new int[types.length];
                for (int j = 0; j < types.length; ++j) {
                    this.paramTypes[i][j] = GroundedTaskImp.this.typeIndex.get(types[j]);
                }
                this.valueTypes = new int[1];
                this.valueTypes[0] = GroundedTaskImp.this.typeIndex.get("boolean");
            } else {
                String[] types = f.getDomain();
                this.valueTypes = new int[types.length];
                for (int j = 0; j < types.length; ++j) {
                    this.valueTypes[j] = GroundedTaskImp.this.typeIndex.get(types[j]);
                }
            }
        }

        public boolean isShareable(GroundedVarImp v, int agIndex) {
            int i;
            if (this.fncIndex != v.fncIndex) {
                return false;
            }
            boolean validAgent = false;
            for (i = 0; i < this.agents.length; ++i) {
                if (this.agents[i] != agIndex) continue;
                validAgent = true;
                break;
            }
            if (!validAgent) {
                return false;
            }
            for (i = 0; i < this.params.length; ++i) {
                if (!(this.params[i] == -1 ? !GroundedTaskImp.this.objectIsCompatible(v.paramIndex[i], this.paramTypes[i]) : this.params[i] != v.paramIndex[i])) continue;
                return false;
            }
            return true;
        }

        public boolean isShareable(GroundedVarImp v, int valueIndex, int agIndex) {
            int i;
            if (this.fncIndex != v.fncIndex) {
                return false;
            }
            boolean validAgent = false;
            for (i = 0; i < this.agents.length; ++i) {
                if (this.agents[i] != agIndex) continue;
                validAgent = true;
                break;
            }
            if (!validAgent) {
                return false;
            }
            for (i = 0; i < this.params.length; ++i) {
                if (!(this.params[i] == -1 ? !GroundedTaskImp.this.objectIsCompatible(v.paramIndex[i], this.paramTypes[i]) : this.params[i] != v.paramIndex[i])) continue;
                return false;
            }
            return GroundedTaskImp.this.objectIsCompatible(valueIndex, this.valueTypes);
        }
    }

    public class ActionImp
    implements Action,
    GroundedRule {
        private static final long serialVersionUID = 379765009600369268L;
        String opName;
        String[] params;
        int[] paramIndex;
        ActionCondition[] prec;
        ActionCondition[] eff;
        GroundedNumericEff[] numEff;
        ArrayList<GroundedVar> mutexVar;

        public ActionImp(String opName, int numParams, int numPrecs, int numEffs) {
            this.opName = opName;
            this.params = new String[numParams];
            this.paramIndex = new int[numParams];
            this.prec = new ActionCondition[numPrecs];
            this.eff = new ActionCondition[numEffs];
            this.mutexVar = null;
        }

        public void setParam(int paramIndex, int objIndex, String objName) {
            this.params[paramIndex] = objName;
            this.paramIndex[paramIndex] = objIndex;
        }

        public String toString() {
            String res = this.opName;
            for (String param : this.params) {
                res = res + " " + param;
            }
            return res;
        }

        @Override
        public String getOperatorName() {
            return this.opName;
        }

        @Override
        public String[] getParams() {
            return this.params;
        }

        @Override
        public void optimize() {
            int n = 0;
            for (ActionCondition c : this.prec) {
                if (GroundedTaskImp.this.staticFunction.get(c.gv.var().fncIndex).booleanValue()) continue;
                ++n;
            }
            ActionCondition[] auxP = new ActionCondition[n];
            n = 0;
            for (ActionCondition c : this.prec) {
                if (GroundedTaskImp.this.staticFunction.get(c.gv.var().fncIndex).booleanValue()) continue;
                auxP[n++] = c;
            }
            this.prec = auxP;
            n = 0;
            for (ActionCondition c : this.eff) {
                if (GroundedTaskImp.this.staticFunction.get(c.gv.var().fncIndex).booleanValue()) continue;
                ++n;
            }
            ActionCondition[] auxE = new ActionCondition[n];
            n = 0;
            for (ActionCondition c : this.eff) {
                if (GroundedTaskImp.this.staticFunction.get(c.gv.var().fncIndex).booleanValue()) continue;
                auxE[n++] = c;
            }
            this.eff = auxE;
        }

        @Override
        public GroundedCond[] getPrecs() {
            return this.prec;
        }

        @Override
        public GroundedEff[] getEffs() {
            return this.eff;
        }

        @Override
        public String getRuleName() {
            return this.opName;
        }

        @Override
        public GroundedCond[] getBody() {
            return this.getPrecs();
        }

        @Override
        public GroundedEff[] getHead() {
            return this.getEffs();
        }

        @Override
        public int getMinTime() {
            int t = 0;
            for (ActionCondition c : this.prec) {
                int vt;
                if (c.condition != 1 || (vt = c.getVar().getMinTime(c.getValue())) <= t) continue;
                t = vt;
            }
            return t;
        }

        public boolean addEffect(int effIndex, GroundedValue gv) {
            if ((GroundedTaskImp.this.sameObjects & 1) != 0) {
                for (String param : gv.getVar().getParams()) {
                    if (!param.equals(gv.getValue())) continue;
                    return false;
                }
            }
            if ((GroundedTaskImp.this.sameObjects & 2) != 0) {
                for (ActionCondition c : this.prec) {
                    if (c.condition != 1 || c.gv.varIndex != gv.varIndex || c.gv.valueIndex != gv.valueIndex) continue;
                    return false;
                }
            }
            this.eff[effIndex] = new ActionCondition(gv);
            return true;
        }

        public void addPrecondition(int precIndex, GroundedValue gv, boolean truePrec) {
            this.prec[precIndex] = new ActionCondition(gv, truePrec);
        }

        public void addAdditionalPrecondition(int precIndex, GroundedValue gv, boolean truePrec) {
            int i;
            ActionCondition[] aux = new ActionCondition[this.prec.length + 1];
            for (i = 0; i < precIndex; ++i) {
                aux[i] = this.prec[i];
            }
            for (i = precIndex; i < this.prec.length; ++i) {
                aux[i + 1] = this.prec[i];
            }
            this.prec = aux;
            this.prec[precIndex] = new ActionCondition(gv, truePrec);
        }

        public boolean requiresVar(GroundedVar var) {
            for (ActionCondition p : this.prec) {
                if (!p.getVar().equals(var)) continue;
                return true;
            }
            return false;
        }

        @Override
        public GroundedNumericEff[] getNumEffs() {
            return this.numEff;
        }

        void addMutexVariable(GroundedVar var) {
            if (this.mutexVar == null) {
                this.mutexVar = new ArrayList(1);
            }
            if (!this.mutexVar.contains(var)) {
                this.mutexVar.add(var);
            }
        }

        @Override
        public boolean isMutex(Action a) {
            ActionImp ai = (ActionImp)a;
            return this.deletesPrecOrEff(ai) || ai.deletesPrecOrEff(this);
        }

        private boolean deletesPrecOrEff(ActionImp a) {
            for (ActionCondition e : this.eff) {
                GroundedVar v = e.getVar();
                String value = e.getValue();
                for (ActionCondition prec : a.prec) {
                    if (!prec.getVar().equals(v) || !(prec.getCondition() == 1 ? !value.equalsIgnoreCase(prec.getValue()) : value.equalsIgnoreCase(prec.getValue()))) continue;
                    return true;
                }
                for (ActionCondition eff2 : a.eff) {
                    if (!eff2.getVar().equals(v) || value.equalsIgnoreCase(eff2.getValue())) continue;
                    return true;
                }
                if (a.mutexVar == null || !a.mutexVar.contains(v)) continue;
                return true;
            }
            if (this.mutexVar != null) {
                for (GroundedVar v : this.mutexVar) {
                    if (a.requiresVar(v)) {
                        return true;
                    }
                    for (ActionCondition e : a.eff) {
                        if (!e.getVar().equals(v)) continue;
                        return true;
                    }
                    if (a.mutexVar == null || !a.mutexVar.contains(v)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public class ActionCondition
    implements GroundedCond,
    GroundedEff {
        private static final long serialVersionUID = -8669437306147623737L;
        GroundedValue gv;
        int condition;

        public ActionCondition(GroundedValue gv) {
            this.gv = gv;
            this.condition = -1;
        }

        public ActionCondition(GroundedValue gv, boolean isEqual) {
            this.gv = gv;
            this.condition = isEqual ? 1 : 2;
        }

        public ActionCondition(GroundedCond cond) {
            this(cond.getCondition(), cond.getVar(), cond.getValue());
        }

        public ActionCondition(GroundedEff eff) {
            this(-1, eff.getVar(), eff.getValue());
        }

        public ActionCondition(int condition, GroundedVar var, String value) {
            this.condition = condition;
            int valueIndex = GroundedTaskImp.this.getObjectIndex(value);
            int variableIndex = GroundedTaskImp.this.varIndex.get(var);
            this.gv = new GroundedValue(variableIndex, valueIndex);
        }

        @Override
        public int getCondition() {
            return this.condition;
        }

        @Override
        public GroundedVar getVar() {
            return this.gv.var();
        }

        @Override
        public String getValue() {
            return this.gv.getValue();
        }

        public String toString() {
            String res = this.condition != 2 ? "=" : "<>";
            return res + " (" + this.gv.var() + ") " + this.gv.getValue();
        }
    }

    public class GroundedValue
    implements ReachedValue {
        private static final long serialVersionUID = -9105490290945167341L;
        int varIndex;
        int valueIndex;
        int[] minTime;

        public GroundedValue(int varIndex, int valueIndex) {
            this.varIndex = varIndex;
            this.valueIndex = valueIndex;
        }

        public boolean equals(Object x) {
            GroundedValue v = (GroundedValue)x;
            return this.varIndex == v.varIndex && this.valueIndex == v.valueIndex;
        }

        public int hashCode() {
            return this.varIndex * 131071 + this.valueIndex;
        }

        GroundedVarImp var() {
            return GroundedTaskImp.this.vars.get(this.varIndex);
        }

        @Override
        public int getMinTime() {
            int min = this.minTime[0];
            for (int i = 1; i < this.minTime.length; ++i) {
                if (this.minTime[i] == -1 || min != -1 && this.minTime[i] >= min) continue;
                min = this.minTime[i];
            }
            return min;
        }

        @Override
        public GroundedVar getVar() {
            return this.var();
        }

        @Override
        public String getValue() {
            return GroundedTaskImp.this.objects.get(this.valueIndex);
        }

        public String toString() {
            return "(= " + this.var() + " " + this.getValue() + ")[" + this.getMinTime() + "]";
        }

        @Override
        public boolean shareable(String agName) {
            return this.var().shareable(this.getValue(), agName);
        }
    }

    public static class GroundedNumericExpressionImp
    implements GroundedNumericExpression {
        int type;
        double value;
        GroundedVar var;
        GroundedNumericExpression left;
        GroundedNumericExpression right;

        GroundedNumericExpressionImp(int type, double value) {
            this.type = type;
            this.value = value;
        }

        GroundedNumericExpressionImp(GroundedVar var) {
            this.type = 1;
            this.var = var;
        }

        GroundedNumericExpressionImp(int type) {
            this.type = type;
        }

        GroundedNumericExpressionImp(int type, GroundedNumericExpression left, GroundedNumericExpression right) {
            this.type = type;
            this.left = left;
            this.right = right;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public double getValue() {
            return this.value;
        }

        @Override
        public GroundedVar getVariable() {
            return this.var;
        }

        @Override
        public GroundedNumericExpression getLeftOperand() {
            return this.left;
        }

        @Override
        public GroundedNumericExpression getRightOperand() {
            return this.right;
        }

        public String toString() {
            switch (this.type) {
                case 0: {
                    return "" + this.value;
                }
                case 1: {
                    return this.var.toString();
                }
                case 2: {
                    return "(+ (" + this.left + ") (" + this.right + "))";
                }
                case 3: {
                    return "(- (" + this.left + ") (" + this.right + "))";
                }
                case 4: {
                    return "(* (" + this.left + ") (" + this.right + "))";
                }
                case 5: {
                    return "(/ (" + this.left + ") (" + this.right + "))";
                }
                case 6: {
                    return "(usage)";
                }
            }
            return "<error>";
        }
    }

    public static class GroundedNumericEffImp
    implements GroundedNumericEff {
        int type;
        GroundedVar var;
        GroundedNumericExpression exp;

        GroundedNumericEffImp(int type, GroundedVar var, GroundedNumericExpression exp) {
            this.type = type;
            this.var = var;
            this.exp = exp;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public GroundedVar getVariable() {
            return this.var;
        }

        @Override
        public GroundedNumericExpression getExpression() {
            return this.exp;
        }
    }

    public class GroundedVarImp
    implements GroundedVar {
        private static final long serialVersionUID = -1727789113615885154L;
        int varIndex;
        String name;
        int fncIndex;
        String[] paramNames;
        int[] paramIndex;
        String[] domain;
        int[] domainIndex;
        int trueValue;
        ArrayList<Integer> falseValues;

        private GroundedVarImp(String name, int varIndex, int fncIndex) {
            this.name = name;
            this.varIndex = varIndex;
            this.fncIndex = fncIndex;
            this.trueValue = -1;
            this.falseValues = new ArrayList();
        }

        public GroundedVarImp(String name, int numParams) {
            this.name = name;
            this.paramIndex = new int[numParams];
        }

        public GroundedVarImp(String name, int varIndex, int fncIndex, String[] params) {
            this(name, varIndex, fncIndex);
            this.paramNames = new String[params.length];
            this.paramIndex = new int[params.length];
            for (int i = 0; i < params.length; ++i) {
                this.paramNames[i] = params[i];
                this.paramIndex[i] = groundedTaskImp.objectIndex.get(params[i]);
            }
        }

        public GroundedVarImp(String name, int varIndex, int fncIndex, String[] params, String value) {
            this(name, varIndex, fncIndex);
            this.paramNames = new String[params.length + 1];
            this.paramIndex = new int[params.length + 1];
            for (int i = 0; i < params.length; ++i) {
                this.paramNames[i] = params[i];
                this.paramIndex[i] = groundedTaskImp.objectIndex.get(params[i]);
            }
            this.paramNames[params.length] = value;
            this.paramIndex[params.length] = groundedTaskImp.objectIndex.get(value);
        }

        public void setDomain(String[] domain) {
            this.domain = new String[domain.length];
            this.domainIndex = new int[domain.length];
            for (int i = 0; i < domain.length; ++i) {
                this.domain[i] = domain[i];
                this.domainIndex[i] = GroundedTaskImp.this.typeIndex.get(domain[i]);
            }
        }

        public void setTrueValue(String value, Hashtable<String, Integer> objectIndex) {
            Integer valueIndex = objectIndex.get(value);
            if (this.trueValue == -1) {
                int falseIndex = this.falseValues.indexOf(valueIndex);
                if (falseIndex == -1) {
                    this.trueValue = valueIndex;
                } else {
                    this.falseValues.remove(falseIndex);
                }
            } else {
                throw new RuntimeException("True value already set for variable: " + this.toString());
            }
        }

        public void addFalseValue(String value, Hashtable<String, Integer> objectIndex) {
            Integer valueIndex = objectIndex.get(value);
            if (!this.falseValues.contains(valueIndex)) {
                if (this.trueValue != valueIndex) {
                    this.falseValues.add(valueIndex);
                } else {
                    this.trueValue = -1;
                }
            }
        }

        public String toString() {
            String res = this.name;
            for (int i = 0; i < this.paramNames.length; ++i) {
                res = res + " " + this.paramNames[i];
            }
            return res;
        }

        public boolean equals(Object v) {
            GroundedVarImp gv = (GroundedVarImp)v;
            return this.name.equals(gv.name) && Arrays.equals(this.paramIndex, gv.paramIndex);
        }

        public int hashCode() {
            return (this.name + Arrays.toString(this.paramIndex)).hashCode();
        }

        @Override
        public String getFuctionName() {
            return this.name;
        }

        @Override
        public String[] getParams() {
            return this.paramNames;
        }

        @Override
        public String[] getDomainTypes() {
            return this.domain;
        }

        @Override
        public String initialTrueValue() {
            return this.trueValue != -1 ? GroundedTaskImp.this.objects.get(this.trueValue) : null;
        }

        @Override
        public String[] initialFalseValues() {
            String[] res = new String[this.falseValues.size()];
            for (int i = 0; i < res.length; ++i) {
                res[i] = GroundedTaskImp.this.objects.get(this.falseValues.get(i));
            }
            return res;
        }

        @Override
        public int getMinTime(String objName) {
            GroundedValue gv = new GroundedValue(this.varIndex, GroundedTaskImp.this.objectIndex.get(objName));
            Integer index = GroundedTaskImp.this.valueIndex.get(gv);
            if (index == null) {
                return -1;
            }
            gv = GroundedTaskImp.this.values.get(index);
            int time = gv.getMinTime();
            return time;
        }

        @Override
        public int getMinTime(String objName, String agent) {
            GroundedValue gv = new GroundedValue(this.varIndex, GroundedTaskImp.this.objectIndex.get(objName));
            Integer index = GroundedTaskImp.this.valueIndex.get(gv);
            Integer agIndex = GroundedTaskImp.this.agentIndex.get(agent);
            if (index == null || agIndex == null) {
                return -1;
            }
            gv = GroundedTaskImp.this.values.get(index);
            int time = gv.minTime[agIndex];
            return time;
        }

        @Override
        public boolean shareable(String objName, String agent) {
            boolean res = false;
            int agIndex = GroundedTaskImp.this.agentIndex.get(agent);
            if (!GroundedTaskImp.this.objectIndex.containsKey(objName)) {
                return false;
            }
            int valueIndex = GroundedTaskImp.this.objectIndex.get(objName);
            ArrayList<GroundedSharedData> sdList = GroundedTaskImp.this.sharedDataByFunction.get(this.fncIndex);
            for (GroundedSharedData sd : sdList) {
                if (!sd.isShareable(this, valueIndex, agIndex)) continue;
                res = true;
                break;
            }
            return res;
        }

        @Override
        public boolean shareable(String agent) {
            boolean res = false;
            int agIndex = GroundedTaskImp.this.agentIndex.get(agent);
            for (GroundedSharedData sd : GroundedTaskImp.this.sharedDataByFunction.get(this.fncIndex)) {
                if (!sd.isShareable(this, agIndex)) continue;
                res = true;
                break;
            }
            return res;
        }

        @Override
        public String[] getReachableValues() {
            ArrayList<Integer> pv = GroundedTaskImp.this.getAllDomainValues(this.domainIndex);
            ArrayList<String> rv = new ArrayList<String>(pv.size());
            for (Integer objIndex : pv) {
                Integer gvIndex = GroundedTaskImp.this.valueIndex.get(new GroundedValue(this.varIndex, objIndex));
                if (gvIndex == null) continue;
                rv.add(GroundedTaskImp.this.objects.get(objIndex));
            }
            return rv.toArray(new String[rv.size()]);
        }

        @Override
        public String[] getParamTypes(int paramNumber) {
            Function f = GroundedTaskImp.this.functions.get(this.fncIndex);
            Parameter p = f.getParameters()[paramNumber];
            return p.getTypes();
        }

        @Override
        public boolean isBoolean() {
            return this.domainIndex[0] == GroundedTaskImp.this.booleanTypeIndex;
        }
    }
}

