/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_dtg;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.agreement_technologies.common.map_communication.AgentCommunication;
import org.agreement_technologies.common.map_dtg.DTG;
import org.agreement_technologies.common.map_dtg.DTGSet;
import org.agreement_technologies.common.map_dtg.DTGTransition;
import org.agreement_technologies.common.map_grounding.GroundedCond;
import org.agreement_technologies.common.map_grounding.GroundedEff;
import org.agreement_technologies.common.map_grounding.GroundedTask;
import org.agreement_technologies.common.map_grounding.GroundedVar;
import org.agreement_technologies.service.map_dtg.DTGData;
import org.agreement_technologies.service.map_dtg.DTGImp;

public class DTGSetImp
implements DTGSet {
    private final Hashtable<String, DTG> dtgs;

    public DTGSetImp(GroundedTask task) {
        GroundedVar[] vars = task.getVars();
        this.dtgs = new Hashtable(vars.length);
        for (GroundedVar v : vars) {
            DTGImp dtg = new DTGImp(this, v, task);
            this.dtgs.put(v.toString(), dtg);
        }
    }

    @Override
    public void distributeDTGs(AgentCommunication comm, GroundedTask gTask) {
        if (comm.numAgents() > 1) {
            boolean[] endDTG = new boolean[comm.numAgents()];
            do {
                this.sendDTGTransitions(comm, endDTG);
                this.receiveDTGTransitions(comm, gTask, endDTG);
            } while (!this.checkEndDTG(comm, endDTG));
        }
    }

    @Override
    public DTG getDTG(GroundedVar v) {
        return this.dtgs.get(v.toString());
    }

    @Override
    public DTG getDTG(String varName) {
        return this.dtgs.get(varName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Enumeration<String> e = this.dtgs.keys();
        while (e.hasMoreElements()) {
            DTG dtg = this.dtgs.get(e.nextElement());
            sb.append(dtg.toString()).append("\n");
        }
        return sb.toString();
    }

    private void addTransition(String varName, String startValue, String finalValue, GroundedCond[] commonPrecs, GroundedEff[] commonEffs, String fromAgent) {
        DTG dtg = this.dtgs.get(varName);
        if (dtg == null) {
            return;
        }
        ((DTGImp)dtg).addTransition(startValue, finalValue, commonPrecs, commonEffs, fromAgent);
    }

    private DTGTransition[] getNewTransitions() {
        ArrayList<DTGTransition> newTransitions = new ArrayList<DTGTransition>();
        Enumeration<String> e = this.dtgs.keys();
        while (e.hasMoreElements()) {
            DTGTransition[] tList;
            DTG dtg = this.dtgs.get(e.nextElement());
            for (DTGTransition t : tList = ((DTGImp)dtg).getNewTransitions()) {
                newTransitions.add(t);
            }
        }
        return newTransitions.toArray(new DTGTransition[newTransitions.size()]);
    }

    private void receiveDTGTransitions(AgentCommunication comm, GroundedTask gTask, boolean[] endDTG) {
        for (String ag : comm.getOtherAgents()) {
            Serializable data = comm.receiveMessage(ag, false);
            if (data instanceof String) {
                if (((String)((Object)data)).equals("<END>")) {
                    endDTG[comm.getAgentIndex((String)ag)] = true;
                    continue;
                }
                throw new RuntimeException("Agent " + ag + " is not following the DTG protocol");
            }
            ArrayList dataReceived = (ArrayList)data;
            endDTG[comm.getAgentIndex((String)ag)] = false;
            for (DTGData d : dataReceived) {
                this.addTransition(d.getVarName(), d.getStartValue(), d.getFinalValue(), d.getCommonPrecs(gTask), d.getCommonEffs(gTask), ag);
            }
        }
    }

    private void sendDTGTransitions(AgentCommunication comm, boolean[] endDTG) {
        String myAgent = comm.getThisAgentName();
        DTGTransition[] newTransitions = this.getNewTransitions();
        boolean somethingToSend = newTransitions.length > 0;
        boolean bl = endDTG[comm.getThisAgentIndex()] = !somethingToSend;
        if (somethingToSend) {
            for (String ag : comm.getOtherAgents()) {
                ArrayList<DTGData> data = new ArrayList<DTGData>(newTransitions.length);
                for (DTGTransition t : newTransitions) {
                    if (!DTGData.shareable(t, ag) || !t.getAgents().contains(myAgent)) continue;
                    data.add(new DTGData(t, ag));
                }
                comm.sendMessage(ag, data, false);
            }
        } else {
            comm.sendMessage((Serializable)((Object)"<END>"), false);
        }
    }

    private boolean checkEndDTG(AgentCommunication comm, boolean[] endDTG) {
        boolean finished = true;
        for (boolean end : endDTG) {
            if (end) continue;
            finished = false;
            break;
        }
        if (!finished) {
            if (comm.batonAgent()) {
                comm.sendMessage((Serializable)((Object)"<SYNC>"), true);
            } else {
                comm.receiveMessage(comm.getBatonAgent(), true);
            }
        }
        return finished;
    }

    @Override
    public void clearCache(int threadIndex) {
        for (DTG dtg : this.dtgs.values()) {
            dtg.clearCache(threadIndex);
        }
    }
}

