/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.service.map_communication;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.agreement_technologies.common.map_communication.AgentCommunication;
import org.agreement_technologies.common.map_communication.Message;
import org.agreement_technologies.service.map_communication.MessageImp;

public class CommunicationServer
extends Thread {
    private final ServerSocket server;
    private final AgentCommunication comm;
    private final int numConnections;

    public CommunicationServer(AgentCommunication comm, int agentIndex, int numConnections) throws IOException {
        this.server = new ServerSocket(38000 + agentIndex);
        this.comm = comm;
        this.numConnections = numConnections;
    }

    @Override
    public void run() {
        try {
            for (int i = 0; i < this.numConnections; ++i) {
                try {
                    Socket client = this.server.accept();
                    Connection newConnection = new Connection(client);
                    newConnection.start();
                    continue;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            System.out.println("SERVER ERROR: " + e);
        }
    }

    private class Connection
    extends Thread {
        private final Socket client;

        private Connection(Socket client) {
            this.client = client;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    ObjectInputStream in;
                    Object obj;
                    if ((obj = (in = new ObjectInputStream(this.client.getInputStream())).readObject()) instanceof MessageImp) {
                        CommunicationServer.this.comm.enqueueMsg((Message)obj);
                        continue;
                    }
                    ObjectOutputStream out = new ObjectOutputStream(this.client.getOutputStream());
                    out.writeObject(obj);
                    out.flush();
                }
            }
            catch (IOException | ClassNotFoundException exception) {
                return;
            }
        }
    }
}

