/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.agents;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.ParseException;
import java.util.ArrayList;
import org.agreement_technologies.common.map_communication.AgentCommunication;
import org.agreement_technologies.common.map_communication.PlanningAgentListener;
import org.agreement_technologies.common.map_grounding.GroundedTask;
import org.agreement_technologies.common.map_heuristic.Heuristic;
import org.agreement_technologies.common.map_heuristic.HeuristicFactory;
import org.agreement_technologies.common.map_landmarks.Landmarks;
import org.agreement_technologies.common.map_parser.AgentList;
import org.agreement_technologies.common.map_parser.PDDLParser;
import org.agreement_technologies.common.map_parser.Task;
import org.agreement_technologies.common.map_planner.Plan;
import org.agreement_technologies.common.map_planner.Planner;
import org.agreement_technologies.common.map_planner.PlannerFactory;
import org.agreement_technologies.service.map_communication.AgentCommunicationImp;
import org.agreement_technologies.service.map_grounding.GroundingImp;
import org.agreement_technologies.service.map_heuristic.HeuristicFactoryImp;
import org.agreement_technologies.service.map_parser.MAPDDLParserImp;
import org.agreement_technologies.service.map_parser.ParserImp;
import org.agreement_technologies.service.map_planner.PlannerFactoryImp;
import org.agreement_technologies.service.map_viewer.PlanViewerImp;
import org.agreement_technologies.service.tools.Redirect;

public class PlanningAlgorithm {
    public static final int STATUS_STARTING = 0;
    public static final int STATUS_PARSING = 1;
    public static final int STATUS_GROUNDING = 2;
    public static final int STATUS_PLANNING = 3;
    public static final int STATUS_LANDMARKS = 4;
    public static final int STATUS_IDLE = 8;
    public static final int STATUS_ERROR = 9;
    public static final int STATUS_ARGUMENTATION = 10;
    protected static final String[] STATUS_DESC = new String[]{"starting", "parsing", "grounding", "planning", "landmarks", "undefined", "undefined", "undefined", "idle", "error", "arguing"};
    protected String name;
    protected String domainFile;
    protected String problemFile;
    protected int status;
    protected int sameObjects;
    protected boolean traceOn;
    protected int heuristicType;
    protected AgentCommunication comm;
    protected Task planningTask;
    protected GroundedTask groundedTask;
    protected Landmarks landmarks;
    protected PlannerFactory plannerFactory;
    protected Planner planner;
    protected PlanningAgentListener paListener;
    protected Plan solutionPlan;
    protected long planningTime;
    protected int iterations;
    protected int searchPerformance;
    protected AgentList agList;
    protected boolean waitSynch;
    protected boolean negationByFailure;
    protected boolean isMAPDDL;

    public static String getStatusDesc(int status) {
        return STATUS_DESC[status];
    }

    public PlanningAlgorithm(String name, String domainFile, String problemFile, AgentList agList, boolean waitSynch, int sameObjects, boolean traceOn, int h, int searchPerformance) throws Exception {
        this.name = name.toLowerCase();
        this.comm = new AgentCommunicationImp(this.name, agList);
        this.waitSynch = waitSynch;
        this.agList = agList;
        this.plannerFactory = null;
        this.domainFile = domainFile;
        this.problemFile = problemFile;
        this.sameObjects = sameObjects;
        this.traceOn = traceOn;
        this.searchPerformance = searchPerformance;
        this.status = 0;
        this.heuristicType = h;
        this.paListener = null;
        this.solutionPlan = null;
        this.landmarks = null;
        this.negationByFailure = this.isMAPDDL = new ParserImp().isMAPDDL(domainFile);
    }

    protected void trace(int indentLevel, String msg) {
        if (this.paListener != null) {
            this.paListener.trace(indentLevel, msg);
        }
    }

    protected void changeStatus(int status) {
        this.status = status;
        if (this.paListener != null) {
            this.paListener.statusChanged(this.status);
        }
    }

    protected void notifyError(String msg) {
        this.changeStatus(9);
        if (this.paListener != null) {
            this.paListener.notyfyError(msg);
        } else {
            System.out.println(msg);
        }
    }

    protected void execute() {
        if (this.waitSynch) {
            this.executeWithAsynchronousStart();
        } else {
            this.executeWithSynchronousStart();
        }
        if (this.comm != null) {
            this.comm.close();
        }
    }

    protected long parseTask() {
        this.changeStatus(1);
        long startTime = System.currentTimeMillis();
        this.planningTask = null;
        PDDLParser parser = this.isMAPDDL ? new MAPDDLParserImp() : new ParserImp();
        try {
            this.planningTask = parser.parseDomain(this.domainFile);
        }
        catch (ParseException e) {
            this.notifyError(e.getMessage() + ", at line " + e.getErrorOffset() + " (" + this.domainFile + ")");
        }
        catch (IOException e) {
            this.notifyError("Read error: " + e.getMessage() + " (" + this.domainFile + ")");
        }
        if (this.status != 9) {
            try {
                parser.parseProblem(this.problemFile, this.planningTask, this.agList, this.name);
            }
            catch (ParseException e) {
                this.notifyError(e.getMessage() + ", at line " + e.getErrorOffset() + " (" + this.problemFile + ")");
            }
            catch (IOException e) {
                this.notifyError("Read error: " + e.getMessage() + " (" + this.problemFile + ")");
            }
        }
        long endTime = System.currentTimeMillis() - startTime;
        this.trace(0, "Parsing completed in " + endTime + "ms.");
        return endTime;
    }

    protected long groundTask() throws IOException {
        if (this.status == 9) {
            return 0L;
        }
        this.changeStatus(2);
        long startTime = System.currentTimeMillis();
        GroundingImp g = new GroundingImp(this.sameObjects);
        g.computeStaticFunctions(this.planningTask, this.comm);
        this.groundedTask = g.ground(this.planningTask, this.comm, this.negationByFailure);
        this.groundedTask.optimize();
        long endTime = System.currentTimeMillis() - startTime;
        this.trace(0, "Grounding completed in " + endTime + "ms. (" + this.comm.getNumMessages() + " messages, " + this.groundedTask.getActions().size() + " actions)");
        return endTime;
    }

    protected long planningStage() {
        if (this.status == 9) {
            return 0L;
        }
        PlanningAgentListener al = this.traceOn ? this.paListener : null;
        this.plannerFactory = new PlannerFactoryImp(this.groundedTask, this.comm);
        HeuristicFactoryImp hf = new HeuristicFactoryImp();
        boolean usesLandmarks = HeuristicFactory.getHeuristicInfo(this.heuristicType, 1).equals("yes");
        if (usesLandmarks) {
            this.changeStatus(4);
        }
        Heuristic heuristic = ((HeuristicFactory)hf).getHeuristic(this.heuristicType, this.comm, this.groundedTask, this.plannerFactory);
        this.landmarks = usesLandmarks ? (Landmarks)heuristic.getInformation(1) : null;
        this.changeStatus(3);
        this.planner = this.plannerFactory.createPlanner(this.groundedTask, heuristic, this.comm, al, this.searchPerformance);
        long startTime = System.currentTimeMillis();
        this.solutionPlan = this.planner.computePlan(startTime);
        long endTime = System.currentTimeMillis() - startTime;
        this.trace(0, String.format("Planning completed in %.3f sec.", (double)endTime / 1000.0));
        this.trace(0, "Used memory: " + Runtime.getRuntime().totalMemory() / 1024L + "kb.");
        if (this.solutionPlan != null) {
            this.trace(0, "Plan length: " + this.solutionPlan.countSteps());
            if (!this.traceOn && this.paListener != null) {
                this.paListener.showPlan(this.solutionPlan, this.plannerFactory);
            }
        }
        this.iterations = this.planner.getIterations();
        return endTime;
    }

    public boolean solutionFound() {
        return this.solutionPlan != null;
    }

    public double getSolutionMetric() {
        return this.solutionPlan.getMetric();
    }

    public int getSolutionLength() {
        return this.solutionPlan.numSteps() - 2;
    }

    public int getSolutionMakespan() {
        PlanViewerImp pv = new PlanViewerImp();
        pv.showPlan(this.solutionPlan, this.plannerFactory);
        return pv.getMakespan() - 2;
    }

    public double getPlanningTime() {
        return (double)this.planningTime / 1000.0;
    }

    public int getIterations() {
        return this.iterations;
    }

    private void executeWithSynchronousStart() {
        try {
            long totalTime = this.parseTask();
            totalTime += this.groundTask();
            this.planningTime = this.planningStage();
            totalTime += this.planningTime;
            if (this.status != 9) {
                this.changeStatus(8);
                this.trace(0, "Number of messages: " + this.comm.getNumMessages());
                this.trace(0, String.format("Total time: %.3f sec.", (double)totalTime / 1000.0));
            }
        }
        catch (Throwable e) {
            String error = e.toString() + "\n";
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            this.notifyError(error + sw.toString());
        }
    }

    private void executeWithAsynchronousStart() {
        try {
            this.parseTask();
            if (this.waitSynch) {
                this.waitSynchronization();
            }
            this.planningTime = this.maPDDLGroundTask();
            this.planningTime += this.planningStage();
            this.showResult();
        }
        catch (Throwable e) {
            String error = e.toString() + "\n";
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            System.out.println(error + sw.toString());
        }
    }

    private void waitSynchronization() {
        System.out.println("; Waiting to start");
        ArrayList<String> agentNames = this.comm.getAgentList();
        boolean[] registered = new boolean[this.comm.numAgents()];
        registered[this.comm.getThisAgentIndex()] = true;
        int activeAgents = 1;
        Redirect red = Redirect.captureOutput();
        do {
            for (int i = 0; i < this.comm.numAgents(); ++i) {
                if (registered[i] || !this.comm.registeredAgent(agentNames.get(i))) continue;
                registered[i] = true;
                ++activeAgents;
            }
        } while (activeAgents < this.comm.numAgents());
        red.releaseOutput();
    }

    private long maPDDLGroundTask() {
        if (this.status == 9) {
            return 0L;
        }
        long startTime = System.currentTimeMillis();
        GroundingImp g = new GroundingImp(this.sameObjects);
        g.computeStaticFunctions(this.planningTask, this.comm);
        this.groundedTask = g.ground(this.planningTask, this.comm, this.negationByFailure);
        this.groundedTask.optimize();
        long endTime = System.currentTimeMillis() - startTime;
        System.out.println("; Grounding time: " + String.format("%.3f sec.", (double)endTime / 1000.0));
        return endTime;
    }

    private void showResult() {
        System.out.println("; Planning time: " + String.format("%.3f sec.", (double)this.planningTime / 1000.0));
        if (this.solutionPlan != null) {
            System.out.println("; Plan length: " + this.solutionPlan.countSteps());
            this.solutionPlan.printPlan(1, this.comm.getThisAgentName(), this.comm.getAgentList());
        } else {
            System.out.println("; No plan found");
        }
    }
}

