/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.agents;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.agreement_technologies.agents.AgentListener;
import org.agreement_technologies.common.map_grounding.Action;
import org.agreement_technologies.common.map_grounding.GroundedCond;
import org.agreement_technologies.common.map_grounding.GroundedEff;
import org.agreement_technologies.common.map_grounding.GroundedTask;
import org.agreement_technologies.common.map_grounding.GroundedVar;

public class GUIdisRPG
extends JFrame
implements MouseListener {
    private static final long serialVersionUID = 3080890313036553788L;
    private final AgentListener ag;
    private JTable jTableRPG;

    public GUIdisRPG(AgentListener ag) {
        this.ag = ag;
        this.setTitle("disRPG: " + this.ag.getShortName());
        this.setSize(700, 600);
        this.setLocationRelativeTo(null);
        this.initComponents();
    }

    private void initComponents() {
        JScrollPane jScrollPaneRPG = new JScrollPane();
        this.jTableRPG = new JTable();
        this.jTableRPG.setModel(new RPGTableModel());
        this.jTableRPG.setFillsViewportHeight(true);
        this.jTableRPG.setShowHorizontalLines(false);
        this.jTableRPG.setAutoResizeMode(0);
        this.jTableRPG.addMouseListener(this);
        for (int i = 0; i < this.jTableRPG.getModel().getColumnCount(); ++i) {
            this.jTableRPG.getColumnModel().getColumn(i).setPreferredWidth(150);
        }
        jScrollPaneRPG.setViewportView(this.jTableRPG);
        this.getContentPane().add(jScrollPaneRPG);
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (event.getButton() == 1 && event.getClickCount() == 2) {
            Point p = event.getPoint();
            int row = this.jTableRPG.rowAtPoint(p);
            int column = this.jTableRPG.columnAtPoint(p);
            Object obj = this.jTableRPG.getModel().getValueAt(row, column);
            String desc = null;
            String title = "";
            if (obj instanceof Action) {
                Action a = (Action)obj;
                title = a.toString();
                desc = a.getOperatorName() + " (";
                for (String param : a.getParams()) {
                    desc = desc + " " + param;
                }
                desc = desc + ")\n* Precs:\n";
                for (GroundedCond prec : a.getPrecs()) {
                    desc = desc + "    (" + prec + ")\n";
                }
                desc = desc + "* Effs:";
                for (GroundedEff eff : a.getEffs()) {
                    desc = desc + "\n    (" + eff + ")";
                }
            } else if (obj instanceof RPGTableModel.RPGFact) {
                RPGTableModel.RPGFact f = (RPGTableModel.RPGFact)obj;
                title = f.v.toString();
                desc = "(" + f.v + ")";
                for (String a : this.ag.getCommunication().getAgentList()) {
                    int time = f.v.getMinTime(f.obj, a);
                    if (time == -1) continue;
                    desc = desc + "\n* " + a + ": level " + time;
                }
            }
            if (desc != null) {
                JOptionPane.showMessageDialog(this, desc, title, 1);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    private class RPGTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -6431770911028834234L;
        private final ArrayList<ArrayList<Object>> levels = new ArrayList();
        private int largestLevel = 0;

        public RPGTableModel() {
            GroundedTask g = GUIdisRPG.this.ag.getGroundedTask();
            for (GroundedVar v : g.getVars()) {
                for (String obj : v.getReachableValues()) {
                    int time = v.getMinTime(obj);
                    if (time == -1) continue;
                    this.addFact(v, obj, time);
                }
            }
            for (Action a : g.getActions()) {
                this.addAction(a, a.getMinTime());
            }
        }

        private void addAction(Action a, int time) {
            time = 2 * time + 1;
            while (this.levels.size() <= time) {
                this.levels.add(new ArrayList());
            }
            this.levels.get(time).add(a);
            if (this.levels.get(time).size() > this.largestLevel) {
                this.largestLevel = this.levels.get(time).size();
            }
        }

        private void addFact(GroundedVar v, String obj, int time) {
            time *= 2;
            while (this.levels.size() <= time) {
                this.levels.add(new ArrayList());
            }
            this.levels.get(time).add(new RPGFact(v, obj));
            if (this.levels.get(time).size() > this.largestLevel) {
                this.largestLevel = this.levels.get(time).size();
            }
        }

        @Override
        public String getColumnName(int col) {
            if (col % 2 == 0) {
                return "Fact level " + col / 2;
            }
            return "Action level " + col / 2;
        }

        @Override
        public int getColumnCount() {
            return this.levels.size();
        }

        @Override
        public int getRowCount() {
            return this.largestLevel;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col >= 0 && col < this.levels.size()) {
                ArrayList<Object> level = this.levels.get(col);
                if (row >= 0 && row < level.size()) {
                    return level.get(row);
                }
            }
            return "";
        }

        private class RPGFact {
            GroundedVar v;
            String obj;

            public RPGFact(GroundedVar v, String obj) {
                this.v = v;
                this.obj = obj;
            }

            public String toString() {
                String desc = "[";
                boolean first = true;
                for (String a : GUIdisRPG.this.ag.getCommunication().getAgentList()) {
                    if (this.v.getMinTime(this.obj, a) == -1) continue;
                    desc = desc + (first ? a : "," + a);
                    first = false;
                }
                return desc + "](= (" + this.v + ") " + this.obj + ")";
            }
        }
    }
}

