/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.agents;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.agreement_technologies.agents.AgentListener;
import org.agreement_technologies.common.map_planner.Plan;
import org.agreement_technologies.common.map_planner.PlannerFactory;
import org.agreement_technologies.common.map_viewer.PlanViewer;
import org.agreement_technologies.service.map_viewer.PlanViewerImp;

public class GUISearchTree
extends JFrame
implements MouseListener {
    private static final long serialVersionUID = 978564368530575647L;
    private JScrollPane jScrollPanePlan;
    private JScrollPane jScrollPaneTree;
    private JTree jTreePlans;
    private PlanViewer planViewer;
    private PlannerFactory pf = null;

    public GUISearchTree(AgentListener ag) {
        if (ag != null) {
            this.setTitle("Search tree: " + ag.getShortName());
        }
        this.setSize(800, 600);
        this.setLocationRelativeTo(null);
        this.initComponents();
    }

    private void initComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        this.planViewer = new PlanViewerImp();
        this.planViewer.setBackground(Color.white);
        this.planViewer.setPreferredSize(new Dimension(3200, 1000));
        this.jScrollPanePlan = new JScrollPane();
        this.jScrollPanePlan.setHorizontalScrollBarPolicy(32);
        this.jScrollPanePlan.setPreferredSize(new Dimension(200, 150));
        this.jScrollPanePlan.add(this.planViewer.getComponent());
        this.jScrollPanePlan.setViewportView(this.planViewer.getComponent());
        this.jTreePlans = new JTree();
        this.jTreePlans.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.jTreePlans.addMouseListener(this);
        this.jTreePlans.setPreferredSize(null);
        this.jScrollPaneTree = new JScrollPane();
        this.jScrollPaneTree.setPreferredSize(new Dimension(200, 100));
        this.jScrollPaneTree.setViewportView(this.jTreePlans);
        JSplitPane jsPane = new JSplitPane(1, this.jScrollPaneTree, this.jScrollPanePlan);
        this.getContentPane().add(jsPane);
    }

    public void newPlan(Plan plan, PlannerFactory pf) {
        this.pf = pf;
        DefaultTreeModel m = (DefaultTreeModel)this.jTreePlans.getModel();
        if (plan.isRoot()) {
            m.setRoot(new DefaultMutableTreeNode(plan));
        } else {
            String pName = plan.getName();
            int pos = pName.lastIndexOf(45);
            pName = pName.substring(0, pos);
            DefaultMutableTreeNode pNode = this.searchNode((DefaultMutableTreeNode)m.getRoot(), pName);
            if (pNode != null) {
                pNode.add(new DefaultMutableTreeNode(plan));
            }
        }
    }

    public void showPlan(Plan plan, PlannerFactory pf) {
        this.pf = pf;
        DefaultTreeModel m = (DefaultTreeModel)this.jTreePlans.getModel();
        m.setRoot(new DefaultMutableTreeNode(plan));
    }

    private DefaultMutableTreeNode searchNode(DefaultMutableTreeNode n, String parentName) {
        Plan p = (Plan)n.getUserObject();
        if (p.getName().equals(parentName)) {
            return n;
        }
        for (int i = 0; i < n.getChildCount(); ++i) {
            DefaultMutableTreeNode cn = (DefaultMutableTreeNode)n.getChildAt(i);
            p = (Plan)cn.getUserObject();
            if (parentName.equals(p.getName())) {
                return cn;
            }
            if (!parentName.startsWith(p.getName() + "-")) continue;
            return this.searchNode(cn, parentName);
        }
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.jTreePlans && e.getClickCount() == 1) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.jTreePlans.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            Plan plan = (Plan)node.getUserObject();
            if (e.getButton() == 1) {
                this.planViewer.showPlan(plan, this.pf);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void selectPlan(String planName) {
        DefaultTreeModel m = (DefaultTreeModel)this.jTreePlans.getModel();
        DefaultMutableTreeNode pNode = this.searchNode((DefaultMutableTreeNode)m.getRoot(), planName);
        if (pNode != null) {
            TreePath path = new TreePath(pNode.getPath());
            this.jTreePlans.setExpandsSelectedPaths(true);
            this.jTreePlans.expandPath(path);
            this.jTreePlans.setSelectionPath(path);
            this.jTreePlans.scrollPathToVisible(path);
            this.planViewer.showPlan((Plan)pNode.getUserObject(), this.pf);
        }
    }
}

