/*
 * Decompiled with CFR 0.152.
 */
package org.agreement_technologies.agents;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.agreement_technologies.agents.GUIPlanningAgent;
import org.agreement_technologies.agents.MAPboot;
import org.agreement_technologies.agents.PlanningAgent;
import org.agreement_technologies.common.map_heuristic.HeuristicFactory;
import org.agreement_technologies.common.map_parser.AgentList;
import org.agreement_technologies.common.map_planner.PlannerFactory;
import org.agreement_technologies.service.map_parser.ParserImp;

public class GUIBoot
extends JFrame {
    private static final long serialVersionUID = -5039304283931395812L;
    private String startDir = null;
    private JButton jButtonAddAgent;
    private JButton jButtonClearAgents;
    private JButton jButtonLoadConfig;
    private JButton jButtonLoadDomain;
    private JButton jButtonLoadProblem;
    private JButton jButtonSaveConfig;
    private JButton jButtonStart;
    private JList jListAgents;
    private JPanel jPanel;
    private JScrollPane jScrollPane1;
    private JTextField jTextFieldAgent;
    private JTextField jTextFieldDomain;
    private JTextField jTextFieldProblem;
    private JComboBox searchMethod;
    private JComboBox heuristicType;
    private JCheckBox sameObjects;
    private JCheckBox trace;

    public GUIBoot() {
        try {
            Scanner f = new Scanner(new File("configuration/startDir.txt"));
            this.startDir = f.nextLine();
            f.close();
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        try {
            if (this.startDir == null) {
                this.startDir = new File(".").getCanonicalPath();
            }
        }
        catch (IOException e) {
            this.startDir = "";
        }
        this.initComponents();
        this.setSize(648, 380);
        this.setLocationRelativeTo(null);
    }

    public void saveStartDir() {
        try {
            FileWriter outFile = new FileWriter("configuration/startDir.txt");
            PrintWriter out = new PrintWriter(outFile);
            out.println(this.startDir);
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void initComponents() {
        JLabel jLabelAgentName = new JLabel();
        this.jTextFieldAgent = new JTextField();
        JLabel jLabelDomain = new JLabel();
        this.jTextFieldDomain = new JTextField();
        JLabel jLabelProblem = new JLabel();
        this.jTextFieldProblem = new JTextField();
        this.jButtonLoadDomain = new JButton();
        this.jButtonLoadProblem = new JButton();
        this.jPanel = new JPanel();
        this.jButtonClearAgents = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jListAgents = new JList();
        this.jButtonAddAgent = new JButton();
        this.jButtonLoadConfig = new JButton();
        this.jButtonSaveConfig = new JButton();
        this.jButtonStart = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("FMAP - Multi-Agent Planning");
        this.setResizable(false);
        this.getContentPane().setLayout(null);
        int posY = 20;
        jLabelAgentName.setText("Agent's name:");
        this.getContentPane().add(jLabelAgentName);
        jLabelAgentName.setBounds(20, posY, 120, 14);
        this.getContentPane().add(this.jTextFieldAgent);
        this.jTextFieldAgent.setBounds(140, posY, 130, 20);
        jLabelDomain.setText("Domain file:");
        this.getContentPane().add(jLabelDomain);
        jLabelDomain.setBounds(20, posY += 32, 110, 14);
        this.getContentPane().add(this.jTextFieldDomain);
        this.jTextFieldDomain.setBounds(140, posY, 408, 20);
        this.jButtonLoadDomain.setBounds(558, posY, 70, 20);
        jLabelProblem.setText("Problem file:");
        this.getContentPane().add(jLabelProblem);
        jLabelProblem.setBounds(20, posY += 24, 110, 14);
        this.getContentPane().add(this.jTextFieldProblem);
        this.jTextFieldProblem.setBounds(140, posY, 408, 20);
        this.jButtonLoadProblem.setBounds(558, posY, 70, 20);
        JLabel jLabelSearch = new JLabel("Search method:");
        this.getContentPane().add(jLabelSearch);
        jLabelSearch.setBounds(20, posY += 32, 130, 16);
        this.searchMethod = new JComboBox<String>(PlannerFactory.SEARCH_METHODS);
        this.searchMethod.setSelectedIndex(PlannerFactory.getDefaultSearchMethod());
        this.getContentPane().add(this.searchMethod);
        this.searchMethod.setBounds(140, posY, 170, 18);
        JLabel jLabelHeuristic = new JLabel("Heuristic function:");
        this.getContentPane().add(jLabelHeuristic);
        jLabelHeuristic.setBounds(320, posY, 130, 16);
        this.heuristicType = new JComboBox<String>(HeuristicFactory.HEURISTICS);
        this.heuristicType.setSelectedIndex(2);
        this.getContentPane().add(this.heuristicType);
        this.heuristicType.setBounds(458, posY, 170, 18);
        this.jButtonLoadDomain.setText("Load");
        this.jButtonLoadDomain.setFocusable(false);
        this.jButtonLoadDomain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUIBoot.this.jButtonLoadDomainActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.jButtonLoadDomain);
        this.jButtonLoadProblem.setText("Load");
        this.jButtonLoadProblem.setFocusable(false);
        this.jButtonLoadProblem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUIBoot.this.jButtonLoadProblemActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.jButtonLoadProblem);
        this.jPanel.setBorder(BorderFactory.createBevelBorder(0));
        this.jPanel.setLayout(null);
        this.jButtonClearAgents.setText("Clear agents");
        this.jButtonClearAgents.setFocusable(false);
        this.jButtonClearAgents.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUIBoot.this.jButtonClearAgentsActionPerformed(evt);
            }
        });
        this.jPanel.add(this.jButtonClearAgents);
        this.jButtonClearAgents.setBounds(10, 40, 130, 23);
        this.jListAgents.setModel(new DefaultListModel());
        this.jListAgents.setFocusable(false);
        this.jScrollPane1.setViewportView(this.jListAgents);
        this.jPanel.add(this.jScrollPane1);
        this.jScrollPane1.setBounds(160, 10, 448, 130);
        this.jButtonAddAgent.setText("Add agent");
        this.jButtonAddAgent.setFocusable(false);
        this.jButtonAddAgent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUIBoot.this.jButtonAddAgentActionPerformed(evt);
            }
        });
        this.jPanel.add(this.jButtonAddAgent);
        this.jButtonAddAgent.setBounds(10, 10, 130, 30);
        this.jButtonLoadConfig.setText("Load agents");
        this.jButtonLoadConfig.setFocusable(false);
        this.jButtonLoadConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUIBoot.this.jButtonLoadConfigActionPerformed(evt);
            }
        });
        this.jPanel.add(this.jButtonLoadConfig);
        this.jButtonLoadConfig.setBounds(10, 110, 130, 30);
        this.jButtonSaveConfig.setText("Save agents");
        this.jButtonSaveConfig.setFocusable(false);
        this.jButtonSaveConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUIBoot.this.jButtonSaveConfigActionPerformed(evt);
            }
        });
        this.jPanel.add(this.jButtonSaveConfig);
        this.jButtonSaveConfig.setBounds(10, 80, 130, 30);
        this.getContentPane().add(this.jPanel);
        int posPanel = posY + 32;
        this.jPanel.setBounds(10, posPanel, 618, 150);
        this.jButtonStart.setText("Start agents");
        this.jButtonStart.setFocusable(false);
        this.jButtonStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUIBoot.this.jButtonStartActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.jButtonStart);
        this.jButtonStart.setBounds(249, posPanel + 160, 150, 40);
        this.sameObjects = new JCheckBox("Same objects filtering");
        this.getContentPane().add(this.sameObjects);
        this.sameObjects.setBounds(450, posPanel + 160, 190, 16);
        this.sameObjects.setSelected(true);
        this.trace = new JCheckBox("Planning trace");
        this.getContentPane().add(this.trace);
        this.trace.setBounds(450, posPanel + 180, 170, 16);
        this.trace.setSelected(true);
        this.pack();
    }

    private void jButtonLoadDomainActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser(this.startDir);
        if (fileChooser.showOpenDialog(this) == 0) {
            this.startDir = fileChooser.getCurrentDirectory().toString();
            this.saveStartDir();
            this.jTextFieldDomain.setText(fileChooser.getSelectedFile().toString());
        }
    }

    private void jButtonLoadProblemActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser(this.startDir);
        if (fileChooser.showOpenDialog(this) == 0) {
            this.startDir = fileChooser.getCurrentDirectory().toString();
            this.saveStartDir();
            this.jTextFieldProblem.setText(fileChooser.getSelectedFile().toString());
        }
    }

    private void jButtonClearAgentsActionPerformed(ActionEvent evt) {
        DefaultListModel model = (DefaultListModel)this.jListAgents.getModel();
        model.clear();
    }

    private void jButtonAddAgentActionPerformed(ActionEvent evt) {
        Agent a = new Agent(this.jTextFieldAgent.getText(), this.jTextFieldDomain.getText(), this.jTextFieldProblem.getText());
        if (a.name.equals("")) {
            JOptionPane.showMessageDialog(this, "The agent must have a name", "Error", 0);
        } else {
            DefaultListModel model = (DefaultListModel)this.jListAgents.getModel();
            model.addElement(a);
        }
    }

    private void jButtonLoadConfigActionPerformed(ActionEvent evt) {
        DefaultListModel model = (DefaultListModel)this.jListAgents.getModel();
        JFileChooser fileChooser = new JFileChooser(this.startDir);
        if (fileChooser.showOpenDialog(this) == 0) {
            this.startDir = fileChooser.getCurrentDirectory().toString();
            this.saveStartDir();
            String fileName = fileChooser.getSelectedFile().toString();
            try {
                Scanner s = new Scanner(new File(fileName));
                while (s.hasNext()) {
                    String agName = s.nextLine();
                    String domain = s.nextLine();
                    String problem = s.nextLine();
                    Agent a = new Agent(agName, domain, problem);
                    model.addElement(a);
                }
                s.close();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "The file could not be read", "Error", 0);
            }
        }
    }

    private void jButtonSaveConfigActionPerformed(ActionEvent evt) {
        DefaultListModel model = (DefaultListModel)this.jListAgents.getModel();
        JFileChooser fileChooser = new JFileChooser(this.startDir);
        if (fileChooser.showSaveDialog(this) == 0) {
            this.startDir = fileChooser.getCurrentDirectory().toString();
            this.saveStartDir();
            String fileName = fileChooser.getSelectedFile().toString();
            try {
                PrintWriter w = new PrintWriter(fileName);
                for (int i = 0; i < model.size(); ++i) {
                    Agent a = (Agent)model.elementAt(i);
                    w.println(a.name);
                    w.println(a.domain);
                    w.println(a.problem);
                }
                w.close();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "The file could not be saved", "Error", 0);
            }
        }
    }

    private void jButtonStartActionPerformed(ActionEvent evt) {
        this.saveStartDir();
        DefaultListModel model = (DefaultListModel)this.jListAgents.getModel();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = 0;
        int y = 0;
        int h = this.heuristicType.getSelectedIndex();
        int searchType = this.searchMethod.getSelectedIndex();
        if (!PlannerFactory.checkSearchConstraints(searchType, h)) {
            JOptionPane.showMessageDialog(this, "The search method and the heuristic function are not compatible", "Error", 0);
            return;
        }
        if (model.size() > 1 && HeuristicFactory.getHeuristicInfo(h, 2).equals("no")) {
            JOptionPane.showMessageDialog(this, "The selected heuristic function is not available for multi-agent tasks", "Error", 0);
            return;
        }
        try {
            int i;
            int sameObjects = this.sameObjects.isSelected() ? 3 : 0;
            AgentList agList = new ParserImp().createEmptyAgentList();
            for (i = 0; i < model.size(); ++i) {
                agList.addAgent(((Agent)model.getElementAt((int)i)).name.toLowerCase(), "127.0.0.1");
            }
            for (i = 0; i < model.size(); ++i) {
                Agent a = (Agent)model.getElementAt(i);
                PlanningAgent ag = new PlanningAgent(a.name.toLowerCase(), a.domain, a.problem, agList, false, sameObjects, this.trace.isSelected(), h, searchType);
                GUIPlanningAgent gui = new GUIPlanningAgent(ag);
                gui.setLocation(x, y);
                if ((y += gui.getHeight()) + gui.getHeight() > screenSize.height) {
                    x += gui.getWidth();
                    y = 0;
                }
                MAPboot.planningAgents.add(ag);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Could not create the planning agents", "Error", 0);
            return;
        }
        try {
            for (PlanningAgent ag : MAPboot.planningAgents) {
                ag.start();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Could not start the planning agents", "Error", 0);
            return;
        }
        this.jButtonStart.setEnabled(false);
        this.setState(1);
    }

    private class Agent {
        String name;
        String domain;
        String problem;

        Agent(String n, String d, String p) {
            this.name = n;
            this.domain = d;
            this.problem = p;
        }

        public String toString() {
            return this.name + " (" + this.domain + "," + this.problem + ")";
        }
    }
}

