import dataclasses
import logging
import irisml.core
from typing import Union, List

logger = logging.getLogger(__name__)


class Task(irisml.core.TaskBase):
    """ pick from vals based on conditions. Task will return the first val with condition being True.
    default will be returned, if all conditions are false.

    Inputs:
        conditions (bool): conditions
        vals (float, int, str): vals
        default (float, int, str): default value
    """
    VERSION = '0.1.0'

    @dataclasses.dataclass
    class Inputs:
        conditions: List[bool]
        vals: List[Union[float, int, str]]
        default: Union[float, int, str] = None

    @dataclasses.dataclass
    class Outputs:
        result: Union[float, int, str]

    def execute(self, inputs):
        assert len(inputs.conditions) == len(inputs.vals)

        for i, cond in enumerate(inputs.conditions):
            if cond:
                return self.Outputs(inputs.vals[i])

        return self.Outputs(inputs.default)

    def dry_run(self, inputs):
        return self.execute(inputs)
