"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImageRecipeVersionBump = void 0;
const path = require("path");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const logs = require("@aws-cdk/aws-logs");
const cdk = require("@aws-cdk/core");
const cr = require("@aws-cdk/custom-resources");
class ImageRecipeVersionBump extends cdk.Construct {
    constructor(scope, id, recipeName) {
        super(scope, id);
        this.recipeName = recipeName;
        const fn = new lambda.SingletonFunction(this, 'ImageRecipeLatestVersion', {
            uuid: '35399eb5-3b70-49d2-bcf6-ab26006ee648',
            runtime: lambda.Runtime.PYTHON_3_8,
            handler: 'index.handler',
            code: lambda.Code.fromAsset(path.join(__dirname, '..', 'lambda', 'imagerecipe-latest-version')),
            initialPolicy: [
                aws_iam_1.PolicyStatement.fromJson({
                    Sid: 'VisualEditor0',
                    Effect: 'Allow',
                    Action: [
                        'imagebuilder:ListImagePipelines',
                        'imagebuilder:ListComponents',
                        'imagebuilder:ListImageRecipes',
                    ],
                    Resource: '*',
                }),
            ],
        });
        const provider = new cr.Provider(this, 'ImageRecipeCrProvider', {
            onEventHandler: fn,
            logRetention: logs.RetentionDays.ONE_DAY,
        });
        const customResource = new cdk.CustomResource(this, 'ImageRecipeLatestVersionCustom', {
            serviceToken: provider.serviceToken,
            properties: {
                RecipeName: this.recipeName,
                RefreshToken: Date.now(),
            },
        });
        this.nextVersion = customResource.getAtt('NextVersion').toString();
    }
}
exports.ImageRecipeVersionBump = ImageRecipeVersionBump;
//# sourceMappingURL=data:application/json;base64,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