"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ComponentVersionBump = void 0;
const path = require("path");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const logs = require("@aws-cdk/aws-logs");
const cdk = require("@aws-cdk/core");
const cr = require("@aws-cdk/custom-resources");
class ComponentVersionBump extends cdk.Construct {
    constructor(scope, id, componentName) {
        super(scope, id);
        this.componentName = componentName;
        const fn = new lambda.SingletonFunction(this, 'ComponentLatestVersion', {
            uuid: '2e19301f-4792-43a6-ba35-8899ff89a708',
            runtime: lambda.Runtime.PYTHON_3_8,
            handler: 'index.handler',
            code: lambda.Code.fromAsset(path.join(__dirname, '..', 'lambda', 'component-latest-version')),
            initialPolicy: [
                aws_iam_1.PolicyStatement.fromJson({
                    Sid: 'ListComponents',
                    Effect: 'Allow',
                    Action: [
                        'imagebuilder:ListComponents',
                    ],
                    Resource: '*',
                }),
            ],
            timeout: cdk.Duration.seconds(30),
        });
        const provider = new cr.Provider(this, `ComponentVersionProvider${this.componentName}`, {
            onEventHandler: fn,
            logRetention: logs.RetentionDays.ONE_DAY,
        });
        const customResource = new cdk.CustomResource(this, 'ComponentLatestVersionCustom', {
            serviceToken: provider.serviceToken,
            properties: {
                ComponentName: this.componentName,
                RefreshToken: Date.now(),
            },
        });
        this.nextVersion = customResource.getAtt('NextVersion').toString();
    }
}
exports.ComponentVersionBump = ComponentVersionBump;
//# sourceMappingURL=data:application/json;base64,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