# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/04_vision_loss_functions.ipynb.

# %% auto 0
__all__ = ['CustomLoss']

# %% ../nbs/04_vision_loss_functions.ipynb 1
from .vision_core import *
from .vision_data import pred_to_binary_mask, batch_pred_to_multiclass_mask
from monai.losses import DiceLoss

# %% ../nbs/04_vision_loss_functions.ipynb 3
class CustomLoss:
    '''Wrapper to get show_results to work.'''

    def __init__(self, loss_func):
        self.loss_func = loss_func

    def __call__(self, pred, targ):
        if isinstance(pred, MedBase): pred, targ = torch.Tensor(pred.cpu()), torch.Tensor(targ.cpu().float())
        return self.loss_func(pred, targ)

    def activation(self, x):
        return x
    
    def decodes(self, x):
        '''Converts model output to target format.

        Args:
            x: Activations for each class [B, C, W, H, D]

        Returns:
            torch.Tensor: Predicted mask.
        '''

        n_classes = x.shape[1]
        if n_classes == 1: x = pred_to_binary_mask(x)
        else: x,_ = batch_pred_to_multiclass_mask(x)

        return x
