(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     42128,       1163]
NotebookOptionsPosition[     35352,       1031]
NotebookOutlinePosition[     35773,       1048]
CellTagsIndexPosition[     35730,       1045]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{
   RowBox[{"EvaluationNotebook", "[", "]"}], ",", 
   RowBox[{"CellContext", "\[Rule]", "Notebook"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.83637182481455*^9, 3.836371824815637*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"6490e92c-354d-4b7d-bbda-9fa6bc118791"],

Cell[BoxData[
 RowBox[{"Import", "[", 
  "\"\<https://raw.githubusercontent.com/zwicker-group/MathematicaToPython/\
master/ToPython.wl\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.836371070591913*^9, 3.83637109729657*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"d8ccbffb-7fdc-4cd0-800f-608fd7fe2321"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"cs", "=", 
   RowBox[{"{", 
    RowBox[{"r", ",", "\[Phi]"}], "}"}]}], ";", 
  RowBox[{"css", "=", 
   RowBox[{"ToString", "/@", "cs"}]}]}]], "Input",
 CellChangeTimes->{{3.836369954315196*^9, 3.836369960763295*^9}, 
   3.8363718310778503`*^9, {3.836372088794228*^9, 3.836372089546751*^9}, {
   3.836372459186178*^9, 3.836372464500045*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"27cf09c3-e0f9-44f9-9397-fc6f153aa1ac"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"r\"\>", ",", "\<\"\[Phi]\"\>"}], "}"}]], "Output",
 CellChangeTimes->{
  3.8363699658626347`*^9, 3.8363700422911*^9, {3.836370976064389*^9, 
   3.8363709774311533`*^9}, 3.836371623652684*^9, {3.836371827054821*^9, 
   3.836371848038763*^9}, 3.836372090039114*^9, 3.836372464830434*^9, 
   3.836444786704893*^9, 3.836549661675757*^9, 3.836550655849607*^9, 
   3.837265524501672*^9, 3.840879351310215*^9, 3.841378826281588*^9},
 CellLabel->"Out[3]=",ExpressionUUID->"f72b0487-e71c-4986-9c58-5c0df7354e76"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"vel", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Subscript", "[", 
       RowBox[{"v", ",", "i"}], "]"}], "[", "r", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "css"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[4]:=",ExpressionUUID->"5e256c64-683a-4319-be87-6e1073c2f6bf"],

Cell[CellGroupData[{

Cell["Scalar fields", "Section",
 CellChangeTimes->{{3.836371867491858*^9, 
  3.836371871207691*^9}},ExpressionUUID->"752a9a5b-318b-4b33-a799-\
2b60b3ff4b06"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"grad", "=", 
    RowBox[{"Grad", "[", 
     RowBox[{
      RowBox[{"s", "[", "r", "]"}], ",", "cs", ",", "\"\<Polar\>\""}], 
     "]"}]}], ")"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.8363699708374*^9, 3.836369985165965*^9}, 
   3.8363701599949017`*^9, 3.8363718394927673`*^9, 3.836372100214382*^9, {
   3.840879341781928*^9, 3.8408793437056026`*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"78c971c1-e81c-4e91-b5ae-b2af0866856f"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "r", "]"}]},
      {"0"}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.836369985555266*^9, {3.836370074172127*^9, 3.836370125015613*^9}, 
   3.836370160217512*^9, 3.8363709775676527`*^9, 3.836371625581029*^9, 
   3.8363718574480762`*^9, 3.83637210290324*^9, 3.836444786762356*^9, 
   3.83654966175391*^9, 3.8365506559685087`*^9, 3.837265524602209*^9, 
   3.840879353022511*^9, 3.8413788263568583`*^9},
 CellLabel->
  "Out[5]//MatrixForm=",ExpressionUUID->"7b3a1c1c-a4d2-4747-a864-\
367fd28654cd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gradSq", "=", 
  RowBox[{
   RowBox[{"Grad", "[", 
    RowBox[{
     RowBox[{"s", "[", "r", "]"}], ",", "cs", ",", "\"\<Polar\>\""}], "]"}], 
   ".", 
   RowBox[{"Grad", "[", 
    RowBox[{
     RowBox[{"s", "[", "r", "]"}], ",", "cs", ",", "\"\<Polar\>\""}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.836385469603888*^9, 3.836385477190271*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"7254c095-d9bd-4b97-953b-8765158693f7"],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{
   SuperscriptBox["s", "\[Prime]",
    MultilineFunction->None], "[", "r", "]"}], "2"]], "Output",
 CellChangeTimes->{3.836385477976693*^9, 3.836444786777528*^9, 
  3.8365496617669783`*^9, 3.836550656014895*^9, 3.837265524648548*^9, 
  3.840879353521462*^9, 3.841378826369897*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"9f46a9be-8c9a-4f90-b5a2-36a7b6753214"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Laplacian", "[", 
  RowBox[{
   RowBox[{"s", "[", "r", "]"}], ",", "cs", ",", "\"\<Polar\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.8363701285502*^9, 3.836370135842626*^9}, 
   3.8363718395019627`*^9, 3.836372100217833*^9},
 CellLabel->"In[7]:=",ExpressionUUID->"bb39561b-7268-4107-8e1d-157174194579"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SuperscriptBox["s", "\[Prime]",
     MultilineFunction->None], "[", "r", "]"}], "r"], "+", 
  RowBox[{
   SuperscriptBox["s", "\[Prime]\[Prime]",
    MultilineFunction->None], "[", "r", "]"}]}]], "Output",
 CellChangeTimes->{3.836370136147089*^9, 3.836370977648357*^9, 
  3.836371860450674*^9, 3.836372104310245*^9, 3.8364447868262577`*^9, 
  3.836549661847735*^9, 3.836550656096918*^9, 3.8372655247028418`*^9, 
  3.840879354001001*^9, 3.8413788263929453`*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"2f541fc0-43cb-4e2d-a448-4234220f7fa9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"advection", " ", "operator"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"vel", ".", "grad"}]}]], "Input",
 CellChangeTimes->{{3.8408794364235973`*^9, 3.840879443158708*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"d7928bdb-57e3-4976-840d-af92ed897258"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["v", "\<\"r\"\>"], "[", "r", "]"}], " ", 
  RowBox[{
   SuperscriptBox["s", "\[Prime]",
    MultilineFunction->None], "[", "r", "]"}]}]], "Output",
 CellChangeTimes->{3.8408793670640297`*^9, 3.8413788264005737`*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"6ba3d33b-d186-4f64-b74d-72602050620b"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example", "Subsection",
 CellChangeTimes->{{3.836372195143363*^9, 
  3.836372196929399*^9}},ExpressionUUID->"7ac48f1b-c410-4d8d-adf5-\
4bd127074c5c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"grad", "/.", 
   RowBox[{"s", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{"r", ",", 
      RowBox[{"r", "^", "3"}]}], "]"}]}]}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.836372736942079*^9, 3.8363727375520687`*^9}, {
  3.836384485111569*^9, 3.836384487593574*^9}, {3.840879359102824*^9, 
  3.840879360622148*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"0c48a488-3f2a-48c4-92e7-8471b231abda"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{"3", " ", 
        SuperscriptBox["r", "2"]}]},
      {"0"}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.836372737877419*^9, 3.8363727472519484`*^9}, 
   3.836384489679385*^9, 3.8364447868911247`*^9, 3.836549661927141*^9, 
   3.836550656105324*^9, 3.837265524707878*^9, 3.840879360944687*^9, 
   3.841378826412876*^9},
 CellLabel->
  "Out[9]//MatrixForm=",ExpressionUUID->"c6a45bb8-6113-47c1-8c9a-\
54d479e6f77a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gradSq", "/.", 
  RowBox[{"s", "\[Rule]", 
   RowBox[{"Function", "[", 
    RowBox[{"r", ",", 
     RowBox[{"r", "^", "3"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.836385485083066*^9, 3.8363854923616753`*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"a89c98bb-c4da-42e5-b865-7ee89981e767"],

Cell[BoxData[
 RowBox[{"9", " ", 
  SuperscriptBox["r", "4"]}]], "Output",
 CellChangeTimes->{3.836385492671417*^9, 3.8364447868964453`*^9, 
  3.836549661994113*^9, 3.836550656151525*^9, 3.8372655247519007`*^9, 
  3.840879361496711*^9, 3.841378826418992*^9},
 CellLabel->"Out[10]=",ExpressionUUID->"bbab47dc-1e5d-4705-a860-06f2c4460918"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Laplacian", "[", 
  RowBox[{
   RowBox[{"r", "^", "3"}], ",", "cs", ",", "\"\<Polar\>\""}], "]"}]], "Input",\

 CellChangeTimes->{{3.836372200940014*^9, 3.836372212035387*^9}, {
  3.836372255314764*^9, 3.836372297833495*^9}, {3.836372347308304*^9, 
  3.836372377108037*^9}, {3.836372717497493*^9, 3.836372719180459*^9}, {
  3.836384496489346*^9, 3.8363844997025337`*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"877531a3-09f4-4a1b-bb26-0e0f0d65be55"],

Cell[BoxData[
 RowBox[{"9", " ", "r"}]], "Output",
 CellChangeTimes->{{3.836372371116045*^9, 3.8363723774457197`*^9}, {
   3.836372719634886*^9, 3.8363727477739887`*^9}, 3.8363845001150227`*^9, 
   3.836444786959626*^9, 3.836549662057701*^9, 3.836550656501967*^9, 
   3.8372655247597113`*^9, 3.8408793619009657`*^9, 3.841378826431306*^9},
 CellLabel->"Out[11]=",ExpressionUUID->"db2319cf-5188-4285-84ab-8c0ee93044fd"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vector fields", "Section",
 CellChangeTimes->{{3.836371875544259*^9, 
  3.83637187964915*^9}},ExpressionUUID->"10a6a951-c2ec-4510-9025-\
b114352779c7"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"vec", "[", "r_", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Subscript", "[", 
      RowBox[{"f", ",", "c"}], "]"}], "[", "r", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "css"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"vec", "[", "r", "]"}]}], "Input",
 CellChangeTimes->{{3.8363699901621637`*^9, 3.836370104025691*^9}, {
   3.8363866679272137`*^9, 3.836386685592009*^9}, 3.840879369996498*^9},
 CellLabel->"In[12]:=",ExpressionUUID->"a8d2c5cb-fb65-4db0-8825-4b0e42b073d2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["f", "\<\"r\"\>"], "[", "r", "]"}], ",", 
   RowBox[{
    SubscriptBox["f", "\<\"\[Phi]\"\>"], "[", "r", "]"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.836370104413557*^9, 3.836370977514279*^9, 3.836371624654104*^9, 
   3.836371850274251*^9, 3.836371891488089*^9, 3.8363721108067713`*^9, {
   3.836386672926589*^9, 3.8363866860497007`*^9}, 3.83644478696769*^9, 
   3.8365496620654488`*^9, 3.836550656508885*^9, 3.837265524806203*^9, 
   3.840879371692503*^9, 3.8413788264377737`*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"f2130651-612c-4df2-beb7-e0f16f50d91b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "@", 
  RowBox[{"Div", "[", 
   RowBox[{
    RowBox[{"vec", "[", "r", "]"}], ",", "cs", ",", "\"\<Polar\>\""}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.836369987083974*^9, 3.836369988094116*^9}, {
   3.836370077016363*^9, 3.836370081951086*^9}, {3.836371637099867*^9, 
   3.836371641271962*^9}, 3.8363718394976807`*^9, 3.8363721002211857`*^9},
 CellLabel->"In[14]:=",ExpressionUUID->"34922ada-c7b6-4ba1-8293-d801a26bbd09"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SubscriptBox["f", "\<\"r\"\>"], "[", "r", "]"}], "r"], "+", 
  RowBox[{
   SuperscriptBox[
    SubscriptBox["f", "\<\"r\"\>"], "\[Prime]",
    MultilineFunction->None], "[", "r", "]"}]}]], "Output",
 CellChangeTimes->{{3.8363700821985693`*^9, 3.836370125387701*^9}, 
   3.836370977609374*^9, {3.83637162606951*^9, 3.8363716415076847`*^9}, 
   3.8363718590892973`*^9, 3.836371892137411*^9, 3.836372112362536*^9, {
   3.836386673914762*^9, 3.836386686881311*^9}, 3.836444787032507*^9, 
   3.8365496621234837`*^9, 3.8365506566484528`*^9, 3.837265524858323*^9, 
   3.8408793721018353`*^9, 3.841378826452662*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"524c430d-fd07-4448-a492-d72e99d2f129"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vecDiv", "=", 
  RowBox[{"Div", "[", 
   RowBox[{
    RowBox[{"vec", "[", "r", "]"}], ",", "cs", ",", "\"\<Polar\>\""}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.836384921216298*^9, 3.836384933259495*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"1a256924-88ce-4a89-8bc6-eca77d993bae"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SubscriptBox["f", "\<\"r\"\>"], "[", "r", "]"}], "r"], "+", 
  RowBox[{
   SuperscriptBox[
    SubscriptBox["f", "\<\"r\"\>"], "\[Prime]",
    MultilineFunction->None], "[", "r", "]"}]}]], "Output",
 CellChangeTimes->{{3.8363849309405622`*^9, 3.836384933533781*^9}, 
   3.8363866876631002`*^9, 3.836444787094132*^9, 3.836549662187117*^9, 
   3.836550656690885*^9, 3.8372655248660383`*^9, 3.840879372538518*^9, 
   3.841378826460354*^9},
 CellLabel->"Out[15]=",ExpressionUUID->"4c702006-2bf5-4954-8266-10871da29dd7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"vecLap", "=", 
    RowBox[{"FullSimplify", "@", 
     RowBox[{"Laplacian", "[", 
      RowBox[{
       RowBox[{"vec", "[", "r", "]"}], ",", "cs", ",", "\"\<Polar\>\""}], 
      "]"}]}]}], ")"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.8365496650664*^9, 3.836549686814152*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"f72c0a45-6fb4-446f-9ef6-e52a5013f7d9"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{
        FractionBox[
         RowBox[{
          RowBox[{"-", 
           RowBox[{
            SubscriptBox["f", "\<\"r\"\>"], "[", "r", "]"}]}], "+", 
          RowBox[{"r", " ", 
           RowBox[{
            SuperscriptBox[
             SubscriptBox["f", "\<\"r\"\>"], "\[Prime]",
             MultilineFunction->None], "[", "r", "]"}]}]}], 
         SuperscriptBox["r", "2"]], "+", 
        RowBox[{
         SuperscriptBox[
          SubscriptBox["f", "\<\"r\"\>"], "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "r", "]"}]}]},
      {
       RowBox[{
        FractionBox[
         RowBox[{
          RowBox[{"-", 
           RowBox[{
            SubscriptBox["f", "\<\"\[Phi]\"\>"], "[", "r", "]"}]}], "+", 
          RowBox[{"r", " ", 
           RowBox[{
            SuperscriptBox[
             SubscriptBox["f", "\<\"\[Phi]\"\>"], "\[Prime]",
             MultilineFunction->None], "[", "r", "]"}]}]}], 
         SuperscriptBox["r", "2"]], "+", 
        RowBox[{
         SuperscriptBox[
          SubscriptBox["f", "\<\"\[Phi]\"\>"], "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "r", "]"}]}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.836549674762115*^9, 3.836549687058689*^9}, 
   3.836550657988823*^9, 3.837265524917098*^9, 3.840879372993885*^9, 
   3.84137882651339*^9},
 CellLabel->
  "Out[16]//MatrixForm=",ExpressionUUID->"fcff5e3b-1dcd-45b3-87a6-\
0f4e1c9b7d74"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"vecGrad", "=", 
    RowBox[{"Grad", "[", 
     RowBox[{
      RowBox[{"vec", "[", "r", "]"}], ",", "cs", ",", "\"\<Polar\>\""}], 
     "]"}]}], ")"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.8363701383494577`*^9, 3.836370150533133*^9}, 
   3.8363718395052567`*^9, 3.836372100224373*^9, {3.8363849088802834`*^9, 
   3.836384915704623*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"59e9d153-6012-44b9-8592-f5d31e6a3597"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       SuperscriptBox[
        SubscriptBox["f", "\<\"r\"\>"], "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SubscriptBox["f", "\<\"\[Phi]\"\>"], "[", "r", "]"}], "r"]}]},
     {
      RowBox[{
       SuperscriptBox[
        SubscriptBox["f", "\<\"\[Phi]\"\>"], "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}], 
      FractionBox[
       RowBox[{
        SubscriptBox["f", "\<\"r\"\>"], "[", "r", "]"}], "r"]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.8363701470255013`*^9, 3.836370150682934*^9}, 
   3.836370977688388*^9, 3.836371892734676*^9, 3.836372113298606*^9, 
   3.836384916027377*^9, 3.836386688271297*^9, 3.8364447871579742`*^9, 
   3.836549662249322*^9, 3.836550658223588*^9, 3.837265524961335*^9, 
   3.840879373334375*^9, 3.841378826526022*^9},
 CellLabel->
  "Out[17]//MatrixForm=",ExpressionUUID->"3e629171-db1f-4139-b10e-\
1d035d9028cf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"advection", " ", "operator"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"FullSimplify", "[", 
    RowBox[{"vecGrad", ".", "vel"}], "]"}], "//", "MatrixForm"}]}]], "Input",
 CellChangeTimes->{{3.836386264974743*^9, 3.836386274937785*^9}, {
  3.840879383927628*^9, 3.840879431654324*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"1ec843fd-00e2-4eca-94d9-7eeb350079e4"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{
            SubscriptBox["f", "\<\"\[Phi]\"\>"], "[", "r", "]"}], " ", 
           RowBox[{
            SubscriptBox["v", "\<\"\[Phi]\"\>"], "[", "r", "]"}]}], "r"]}], 
        "+", 
        RowBox[{
         RowBox[{
          SubscriptBox["v", "\<\"r\"\>"], "[", "r", "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           SubscriptBox["f", "\<\"r\"\>"], "\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}]}]},
      {
       RowBox[{
        FractionBox[
         RowBox[{
          RowBox[{
           SubscriptBox["f", "\<\"r\"\>"], "[", "r", "]"}], " ", 
          RowBox[{
           SubscriptBox["v", "\<\"\[Phi]\"\>"], "[", "r", "]"}]}], "r"], "+", 
        
        RowBox[{
         RowBox[{
          SubscriptBox["v", "\<\"r\"\>"], "[", "r", "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           SubscriptBox["f", "\<\"\[Phi]\"\>"], "\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}]}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.836386267126193*^9, 3.836386275137932*^9}, 
   3.836444787165412*^9, 3.836549662260446*^9, 3.836550658232082*^9, 
   3.837265524967998*^9, {3.840879373744586*^9, 3.8408794139282846`*^9}, 
   3.8413788265461473`*^9},
 CellLabel->
  "Out[18]//MatrixForm=",ExpressionUUID->"321f3831-a1e6-4c38-aa7e-\
3b833cb406af"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example", "Subsection",
 CellChangeTimes->{{3.836372195143363*^9, 
  3.836372196929399*^9}},ExpressionUUID->"7d443796-8015-4743-b780-\
550908fbc656"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vecRepl", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["f", "\"\<r\>\""], "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{"r", ",", 
       RowBox[{"r", "^", "3"}]}], "]"}]}], ",", 
    RowBox[{
     SubscriptBox["f", "\"\<\[Phi]\>\""], "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{"r", ",", 
       RowBox[{"r", "^", "2"}]}], "]"}]}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.836372390000723*^9, 3.836372550681477*^9}, {
  3.836372711766611*^9, 3.836372745637924*^9}, {3.836384885223749*^9, 
  3.8363848933245687`*^9}, {3.836386618598819*^9, 3.836386655647317*^9}, {
  3.8364444678559437`*^9, 3.836444468528571*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"c4151ed8-dd8b-48b9-84aa-d9aca7a067fc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["f", "\<\"r\"\>"], "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{"r", ",", 
      SuperscriptBox["r", "3"]}], "]"}]}], ",", 
   RowBox[{
    SubscriptBox["f", "\<\"\[Phi]\"\>"], "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{"r", ",", 
      SuperscriptBox["r", "2"]}], "]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.836384894277358*^9, 3.836386618941798*^9, 
  3.836386656502522*^9, 3.836386713943344*^9, 3.836444787233335*^9, 
  3.836549662327715*^9, 3.836549693007271*^9, 3.836550658293523*^9, 
  3.837265525022434*^9, 3.841378826552918*^9},
 CellLabel->"Out[19]=",ExpressionUUID->"a8bd6cec-34e9-48b3-bec2-e4ef0f14cca1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vecDiv", "/.", "vecRepl"}]], "Input",
 CellChangeTimes->{{3.836384935880455*^9, 3.836384939063075*^9}, {
  3.836444470929605*^9, 3.836444471165875*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"91a0a9c9-fddc-4fb2-8ba3-6710e778d927"],

Cell[BoxData[
 RowBox[{"4", " ", 
  SuperscriptBox["r", "2"]}]], "Output",
 CellChangeTimes->{3.836384939308898*^9, 3.836386657877061*^9, 
  3.8363867144385223`*^9, 3.8364447872405157`*^9, 3.836549662638681*^9, 
  3.8365496935828*^9, 3.836550658301695*^9, 3.837265525093585*^9, 
  3.841378826564514*^9},
 CellLabel->"Out[20]=",ExpressionUUID->"62996270-cd71-4b80-abdc-251491c7e7ce"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"vecLap", "/.", "vecRepl"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.836549693902418*^9, 3.836549702008287*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"44d9a81c-2cc0-4831-8176-c8594f55e8b3"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{"8", " ", "r"}]},
      {"3"}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.836549697632815*^9, 3.836549702257201*^9}, 
   3.836550658362563*^9, 3.837265525195868*^9, 3.841378826572083*^9},
 CellLabel->
  "Out[21]//MatrixForm=",ExpressionUUID->"18f10375-93b4-48ba-be74-\
235aaa910290"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "[", 
   RowBox[{"vecGrad", "/.", "vecRepl"}], "]"}], "//", "MatrixForm"}]], "Input",\

 CellChangeTimes->{{3.8363849434963617`*^9, 3.836384949601533*^9}, {
  3.836444473020082*^9, 3.836444473226873*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"4cd9f4d1-4b23-4989-a628-1406ad5c70f9"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"3", " ", 
       SuperscriptBox["r", "2"]}], 
      RowBox[{"-", "r"}]},
     {
      RowBox[{"2", " ", "r"}], 
      SuperscriptBox["r", "2"]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.836384945449993*^9, 3.836384949826185*^9}, 
   3.836386658661292*^9, 3.836386714750093*^9, 3.8364447873056917`*^9, 
   3.83654966266038*^9, 3.836550658370572*^9, 3.837265525202235*^9, 
   3.8413788265901747`*^9},
 CellLabel->
  "Out[22]//MatrixForm=",ExpressionUUID->"84fcc8ef-4db7-4824-9037-\
6b661bbc2591"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tensor fields", "Section",
 CellChangeTimes->{{3.836371885306631*^9, 
  3.836371888891665*^9}},ExpressionUUID->"9146df12-be82-41bb-8649-\
212b7f936243"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ten", "[", "r_", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Subscript", "[", 
      RowBox[{"f", ",", 
       RowBox[{"i", "<>", "j"}]}], "]"}], "[", "r", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "css"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "css"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ten", "[", "r", "]"}], "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.83637010952188*^9, 3.836370119247219*^9}, {
  3.836372120552487*^9, 3.83637212203662*^9}, {3.8363866928853703`*^9, 
  3.836386697361527*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"16d8340c-be44-464c-a026-527051e116ac"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       SubscriptBox["f", "\<\"rr\"\>"], "[", "r", "]"}], 
      RowBox[{
       SubscriptBox["f", "\<\"r\[Phi]\"\>"], "[", "r", "]"}]},
     {
      RowBox[{
       SubscriptBox["f", "\<\"\[Phi]r\"\>"], "[", "r", "]"}], 
      RowBox[{
       SubscriptBox["f", "\<\"\[Phi]\[Phi]\"\>"], "[", "r", "]"}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.836370120606689*^9, 3.836370977520944*^9, 3.836371625092572*^9, 
   3.836371852112905*^9, 3.836371894867639*^9, {3.836372118074243*^9, 
   3.836372122299355*^9}, 3.8363866981605797`*^9, {3.836388186184881*^9, 
   3.836388209328699*^9}, 3.836444787313724*^9, 3.836549662737336*^9, 
   3.836550658430099*^9, 3.8372655252392483`*^9, 3.841378826597967*^9},
 CellLabel->
  "Out[24]//MatrixForm=",ExpressionUUID->"a6dcbc2e-c26d-4bf0-a1cd-\
2b6da93c5ac7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"tenDiv", "=", 
    RowBox[{"FullSimplify", "@", 
     RowBox[{"Div", "[", 
      RowBox[{
       RowBox[{"ten", "[", "r", "]"}], ",", "cs", ",", "\"\<Polar\>\""}], 
      "]"}]}]}], ")"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.8363701665733557`*^9, 3.836370178993874*^9}, {
   3.836370247943989*^9, 3.836370249907168*^9}, {3.836370836040866*^9, 
   3.836370858626197*^9}, 3.836371839508522*^9, 3.836372100227384*^9},
 CellLabel->"In[25]:=",ExpressionUUID->"9a0a1130-fd4d-44f0-b2cc-825134f49813"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{
        FractionBox[
         RowBox[{
          RowBox[{
           SubscriptBox["f", "\<\"rr\"\>"], "[", "r", "]"}], "-", 
          RowBox[{
           SubscriptBox["f", "\<\"\[Phi]\[Phi]\"\>"], "[", "r", "]"}]}], "r"],
         "+", 
        RowBox[{
         SuperscriptBox[
          SubscriptBox["f", "\<\"rr\"\>"], "\[Prime]",
          MultilineFunction->None], "[", "r", "]"}]}]},
      {
       RowBox[{
        FractionBox[
         RowBox[{
          RowBox[{
           SubscriptBox["f", "\<\"r\[Phi]\"\>"], "[", "r", "]"}], "+", 
          RowBox[{
           SubscriptBox["f", "\<\"\[Phi]r\"\>"], "[", "r", "]"}]}], "r"], "+", 
        RowBox[{
         SuperscriptBox[
          SubscriptBox["f", "\<\"\[Phi]r\"\>"], "\[Prime]",
          MultilineFunction->None], "[", "r", "]"}]}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.836370173124909*^9, 3.83637017920778*^9}, 
   3.836370250978726*^9, {3.836370838524267*^9, 3.836370858886882*^9}, 
   3.8363709777313013`*^9, 3.836371895480771*^9, 3.836372124516178*^9, 
   3.8363866988183107`*^9, {3.836388196831894*^9, 3.836388209886491*^9}, 
   3.836444787383272*^9, 3.836549662820393*^9, 3.836550658496566*^9, 
   3.837265525282897*^9, 3.841378826643179*^9},
 CellLabel->
  "Out[25]//MatrixForm=",ExpressionUUID->"fb70971a-f96f-4949-8b27-\
6694726adc03"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"tenDiv", "\[Equal]", 
   RowBox[{"TensorContract", "[", 
    RowBox[{
     RowBox[{"Grad", "[", 
      RowBox[{
       RowBox[{"ten", "[", "r", "]"}], ",", "cs", ",", "\"\<Polar\>\""}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.836388230890355*^9, 3.836388244869604*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"847f485a-d18a-4043-813f-ddb195e98dc1"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.836388227149798*^9, 3.836388245164488*^9}, 
   3.836444787673118*^9, 3.836549662891253*^9, 3.836550658562468*^9, 
   3.8372655252924347`*^9, 3.841378826662634*^9},
 CellLabel->"Out[26]=",ExpressionUUID->"863de721-0088-4a01-a7a1-8f9898d9e084"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example", "Subsection",
 CellChangeTimes->{{3.836372195143363*^9, 
  3.836372196929399*^9}},ExpressionUUID->"90b15339-0f2a-4ccd-ba02-\
6bd172a000c2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"tenRepl", "=", 
   RowBox[{"Flatten", "@", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"With", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"i", "=", "i"}], ",", 
          RowBox[{"j", "=", "j"}]}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Subscript", "[", 
          RowBox[{"f", ",", 
           RowBox[{
            RowBox[{"css", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "<>", 
            RowBox[{"css", "[", 
             RowBox[{"[", "j", "]"}], "]"}]}]}], "]"}], "\[RuleDelayed]", 
         RowBox[{"Function", "[", 
          RowBox[{"r", ",", 
           RowBox[{"r", "^", 
            RowBox[{"(", 
             RowBox[{"i", "+", "j"}], ")"}]}]}], "]"}]}]}], 
       "\[IndentingNewLine]", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "2"}], "}"}]}], "]"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.836372390000723*^9, 3.836372550681477*^9}, {
  3.836372711766611*^9, 3.836372745637924*^9}, {3.836444761885659*^9, 
  3.83644479704241*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"6538d94a-1355-4ef3-ba01-9219ce56be5f"],

Cell[CellGroupData[{

Cell[BoxData["tenDiv"], "Input",
 CellChangeTimes->{{3.836372736942079*^9, 3.8363727375520687`*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"0d3e797b-b7d0-4dbc-a523-77c322d776db"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{
       SubscriptBox["f", "\<\"rr\"\>"], "[", "r", "]"}], "-", 
      RowBox[{
       SubscriptBox["f", "\<\"\[Phi]\[Phi]\"\>"], "[", "r", "]"}]}], "r"], 
    "+", 
    RowBox[{
     SuperscriptBox[
      SubscriptBox["f", "\<\"rr\"\>"], "\[Prime]",
      MultilineFunction->None], "[", "r", "]"}]}], ",", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{
       SubscriptBox["f", "\<\"r\[Phi]\"\>"], "[", "r", "]"}], "+", 
      RowBox[{
       SubscriptBox["f", "\<\"\[Phi]r\"\>"], "[", "r", "]"}]}], "r"], "+", 
    RowBox[{
     SuperscriptBox[
      SubscriptBox["f", "\<\"\[Phi]r\"\>"], "\[Prime]",
      MultilineFunction->None], "[", "r", "]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.836372737877419*^9, 3.8363727472519484`*^9}, 
   3.836388250509758*^9, 3.836444787742942*^9, 3.836549662909136*^9, 
   3.836550658627984*^9, 3.83726552533954*^9, 3.841378826695648*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"2f00f61b-fbe9-4a55-858e-057afc362c9b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"tenDiv", "/.", "tenRepl"}], "]"}]], "Input",
 CellChangeTimes->{{3.836372200940014*^9, 3.836372212035387*^9}, {
  3.836372255314764*^9, 3.836372297833495*^9}, {3.836372347308304*^9, 
  3.836372377108037*^9}, {3.836372717497493*^9, 3.836372719180459*^9}},
 CellLabel->"In[29]:=",ExpressionUUID->"841eebc7-c23d-48d4-a807-8987098f97dd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "r"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", 
      SuperscriptBox["r", "2"]}], ")"}]}], ",", 
   RowBox[{"5", " ", 
    SuperscriptBox["r", "2"]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.836372371116045*^9, 3.8363723774457197`*^9}, {
   3.836372719634886*^9, 3.8363727477739887`*^9}, 3.836388251805581*^9, 
   3.8364447877736*^9, 3.836549662978437*^9, 3.836550658637382*^9, 
   3.8372655253787746`*^9, 3.841378826703277*^9},
 CellLabel->"Out[29]=",ExpressionUUID->"3f4e3736-cc41-4d83-89d4-460d1ab3aff1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Div", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"ten", "[", "r", "]"}], "[", 
       RowBox[{"[", "i", "]"}], "]"}], ",", "cs", ",", "\"\<Polar\>\""}], 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "2"}], "}"}]}], "]"}], "/.", "tenRepl"}]], "Input",
 CellChangeTimes->{{3.836372763361558*^9, 3.836372764961549*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"6d377ce9-c8dc-4097-a59a-b5766f72a934"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"3", " ", "r"}], ",", 
   RowBox[{"4", " ", 
    SuperscriptBox["r", "2"]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.8363727617651453`*^9, 3.8363727652041607`*^9}, 
   3.836444787827886*^9, 3.8365496630511208`*^9, 3.836550658698497*^9, 
   3.8372655254157887`*^9, 3.8413788267310877`*^9},
 CellLabel->"Out[30]=",ExpressionUUID->"c92bb0f0-d600-4c70-972e-7d48ad0e922e"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1194, 789},
WindowMargins->{{239, Automatic}, {Automatic, -834}},
CellContext->Notebook,
FrontEndVersion->"12.1 for Mac OS X x86 (64-bit) (March 13, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"d70c917d-1ad2-4a26-a5c9-b72b1a6b41c8"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 317, 6, 30, "Input",ExpressionUUID->"6490e92c-354d-4b7d-bbda-9fa6bc118791"],
Cell[878, 28, 300, 5, 30, "Input",ExpressionUUID->"d8ccbffb-7fdc-4cd0-800f-608fd7fe2321"],
Cell[CellGroupData[{
Cell[1203, 37, 453, 10, 30, "Input",ExpressionUUID->"27cf09c3-e0f9-44f9-9397-fc6f153aa1ac"],
Cell[1659, 49, 547, 9, 34, "Output",ExpressionUUID->"f72b0487-e71c-4986-9c58-5c0df7354e76"]
}, Open  ]],
Cell[2221, 61, 359, 10, 30, "Input",ExpressionUUID->"5e256c64-683a-4319-be87-6e1073c2f6bf"],
Cell[CellGroupData[{
Cell[2605, 75, 158, 3, 67, "Section",ExpressionUUID->"752a9a5b-318b-4b33-a799-2b60b3ff4b06"],
Cell[CellGroupData[{
Cell[2788, 82, 497, 11, 30, "Input",ExpressionUUID->"78c971c1-e81c-4e91-b5ae-b2af0866856f"],
Cell[3288, 95, 1076, 29, 60, "Output",ExpressionUUID->"7b3a1c1c-a4d2-4747-a864-367fd28654cd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4401, 129, 452, 12, 30, "Input",ExpressionUUID->"7254c095-d9bd-4b97-953b-8765158693f7"],
Cell[4856, 143, 400, 8, 34, "Output",ExpressionUUID->"9f46a9be-8c9a-4f90-b5a2-36a7b6753214"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5293, 156, 332, 7, 30, "Input",ExpressionUUID->"bb39561b-7268-4107-8e1d-157174194579"],
Cell[5628, 165, 593, 13, 51, "Output",ExpressionUUID->"2f541fc0-43cb-4e2d-a448-4234220f7fa9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6258, 183, 315, 6, 52, "Input",ExpressionUUID->"d7928bdb-57e3-4976-840d-af92ed897258"],
Cell[6576, 191, 344, 8, 34, "Output",ExpressionUUID->"6ba3d33b-d186-4f64-b74d-72602050620b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6957, 204, 155, 3, 54, "Subsection",ExpressionUUID->"7ac48f1b-c410-4d8d-adf5-4bd127074c5c"],
Cell[CellGroupData[{
Cell[7137, 211, 450, 10, 30, "Input",ExpressionUUID->"0c48a488-3f2a-48c4-92e7-8471b231abda"],
Cell[7590, 223, 911, 26, 62, "Output",ExpressionUUID->"c6a45bb8-6113-47c1-8c9a-54d479e6f77a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8538, 254, 318, 7, 30, "Input",ExpressionUUID->"a89c98bb-c4da-42e5-b865-7ee89981e767"],
Cell[8859, 263, 337, 6, 34, "Output",ExpressionUUID->"bbab47dc-1e5d-4705-a860-06f2c4460918"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9233, 274, 474, 9, 30, "Input",ExpressionUUID->"877531a3-09f4-4a1b-bb26-0e0f0d65be55"],
Cell[9710, 285, 417, 6, 34, "Output",ExpressionUUID->"db2319cf-5188-4285-84ab-8c0ee93044fd"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10188, 298, 157, 3, 67, "Section",ExpressionUUID->"10a6a951-c2ec-4510-9025-b114352779c7"],
Cell[CellGroupData[{
Cell[10370, 305, 566, 13, 52, "Input",ExpressionUUID->"a8d2c5cb-fb65-4db0-8825-4b0e42b073d2"],
Cell[10939, 320, 635, 13, 37, "Output",ExpressionUUID->"f2130651-612c-4df2-beb7-e0f16f50d91b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11611, 338, 466, 9, 30, "Input",ExpressionUUID->"34922ada-c7b6-4ba1-8293-d801a26bbd09"],
Cell[12080, 349, 741, 15, 51, "Output",ExpressionUUID->"524c430d-fd07-4448-a492-d72e99d2f129"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12858, 369, 312, 7, 30, "Input",ExpressionUUID->"1a256924-88ce-4a89-8bc6-eca77d993bae"],
Cell[13173, 378, 570, 13, 51, "Output",ExpressionUUID->"4c702006-2bf5-4954-8266-10871da29dd7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13780, 396, 421, 10, 30, "Input",ExpressionUUID->"f72c0a45-6fb4-446f-9ef6-e52a5013f7d9"],
Cell[14204, 408, 1914, 55, 88, "Output",ExpressionUUID->"fcff5e3b-1dcd-45b3-87a6-0f4e1c9b7d74"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16155, 468, 483, 11, 30, "Input",ExpressionUUID->"59e9d153-6012-44b9-8592-f5d31e6a3597"],
Cell[16641, 481, 1403, 38, 84, "Output",ExpressionUUID->"3e629171-db1f-4139-b10e-1d035d9028cf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18081, 524, 441, 9, 52, "Input",ExpressionUUID->"1ec843fd-00e2-4eca-94d9-7eeb350079e4"],
Cell[18525, 535, 1896, 55, 86, "Output",ExpressionUUID->"321f3831-a1e6-4c38-aa7e-3b833cb406af"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20458, 595, 155, 3, 54, "Subsection",ExpressionUUID->"7d443796-8015-4743-b780-550908fbc656"],
Cell[CellGroupData[{
Cell[20638, 602, 763, 18, 33, "Input",ExpressionUUID->"c4151ed8-dd8b-48b9-84aa-d9aca7a067fc"],
Cell[21404, 622, 712, 17, 37, "Output",ExpressionUUID->"a8bd6cec-34e9-48b3-bec2-e4ef0f14cca1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22153, 644, 255, 4, 30, "Input",ExpressionUUID->"91a0a9c9-fddc-4fb2-8ba3-6710e778d927"],
Cell[22411, 650, 382, 7, 34, "Output",ExpressionUUID->"62996270-cd71-4b80-abdc-251491c7e7ce"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22830, 662, 239, 4, 30, "Input",ExpressionUUID->"44d9a81c-2cc0-4831-8176-c8594f55e8b3"],
Cell[23072, 668, 782, 23, 60, "Output",ExpressionUUID->"18f10375-93b4-48ba-be74-235aaa910290"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23891, 696, 333, 7, 30, "Input",ExpressionUUID->"4cd9f4d1-4b23-4989-a628-1406ad5c70f9"],
Cell[24227, 705, 946, 27, 66, "Output",ExpressionUUID->"84fcc8ef-4db7-4824-9037-6b661bbc2591"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25234, 739, 158, 3, 67, "Section",ExpressionUUID->"9146df12-be82-41bb-8649-212b7f936243"],
Cell[CellGroupData[{
Cell[25417, 746, 713, 18, 52, "Input",ExpressionUUID->"16d8340c-be44-464c-a026-527051e116ac"],
Cell[26133, 766, 1247, 32, 66, "Output",ExpressionUUID->"a6dcbc2e-c26d-4bf0-a1cd-2b6da93c5ac7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27417, 803, 563, 12, 30, "Input",ExpressionUUID->"9a0a1130-fd4d-44f0-b2cc-825134f49813"],
Cell[27983, 817, 1819, 49, 86, "Output",ExpressionUUID->"fb70971a-f96f-4949-8b27-6694726adc03"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29839, 871, 487, 12, 30, "Input",ExpressionUUID->"847f485a-d18a-4043-813f-ddb195e98dc1"],
Cell[30329, 885, 296, 4, 34, "Output",ExpressionUUID->"863de721-0088-4a01-a7a1-8f9898d9e084"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30662, 894, 155, 3, 54, "Subsection",ExpressionUUID->"90b15339-0f2a-4ccd-ba02-6bd172a000c2"],
Cell[30820, 899, 1232, 33, 73, "Input",ExpressionUUID->"6538d94a-1355-4ef3-ba01-9219ce56be5f"],
Cell[CellGroupData[{
Cell[32077, 936, 179, 2, 30, "Input",ExpressionUUID->"0d3e797b-b7d0-4dbc-a523-77c322d776db"],
Cell[32259, 940, 1067, 29, 52, "Output",ExpressionUUID->"2f00f61b-fbe9-4a55-858e-057afc362c9b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33363, 974, 389, 6, 30, "Input",ExpressionUUID->"841eebc7-c23d-48d4-a807-8987098f97dd"],
Cell[33755, 982, 607, 15, 37, "Output",ExpressionUUID->"3f4e3736-cc41-4d83-89d4-460d1ab3aff1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34399, 1002, 490, 13, 30, "Input",ExpressionUUID->"6d377ce9-c8dc-4097-a59a-b5766f72a934"],
Cell[34892, 1017, 420, 9, 37, "Output",ExpressionUUID->"c92bb0f0-d600-4c70-972e-7d48ad0e922e"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

