SPD API
================

<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

## Install

Install using:

    pip install spd_api

## This is a basic interface with the EA web files to extract data

We can choose a year and get a dataframe of the available files:

``` python
extract_spd_list(2020)
```

<div>
<style scoped>
    .dataframe tbody tr th:only-of-type {
        vertical-align: middle;
    }

    .dataframe tbody tr th {
        vertical-align: top;
    }

    .dataframe thead th {
        text-align: right;
    }
</style>
<table border="1" class="dataframe">
  <thead>
    <tr style="text-align: right;">
      <th></th>
      <th>Name</th>
      <th>Date modified</th>
      <th>File size</th>
      <th>file_size</th>
    </tr>
    <tr>
      <th>file_date</th>
      <th></th>
      <th></th>
      <th></th>
      <th></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>2020-01-01</th>
      <td>MSS_311112019121100875_0X.ZIP</td>
      <td>02 Jan 2020</td>
      <td>6,340 KB</td>
      <td>6340</td>
    </tr>
    <tr>
      <th>2020-01-02</th>
      <td>MSS_11112020011100861_0X.ZIP</td>
      <td>02 Jan 2020</td>
      <td>6,350 KB</td>
      <td>6350</td>
    </tr>
    <tr>
      <th>2020-01-03</th>
      <td>MSS_21112020011100145_0X.ZIP</td>
      <td>05 Jan 2020</td>
      <td>6,378 KB</td>
      <td>6378</td>
    </tr>
    <tr>
      <th>2020-01-04</th>
      <td>MSS_31112020011100230_0X.ZIP</td>
      <td>06 Jan 2020</td>
      <td>6,378 KB</td>
      <td>6378</td>
    </tr>
    <tr>
      <th>2020-01-05</th>
      <td>MSS_41112020011100102_0X.ZIP</td>
      <td>05 Jan 2020</td>
      <td>6,382 KB</td>
      <td>6382</td>
    </tr>
    <tr>
      <th>...</th>
      <td>...</td>
      <td>...</td>
      <td>...</td>
      <td>...</td>
    </tr>
    <tr>
      <th>2020-12-27</th>
      <td>MSS_261112020121100745_0X.ZIP</td>
      <td>28 Dec 2020</td>
      <td>6,375 KB</td>
      <td>6375</td>
    </tr>
    <tr>
      <th>2020-12-28</th>
      <td>MSS_271112020121100873_0X.ZIP</td>
      <td>29 Dec 2020</td>
      <td>6,382 KB</td>
      <td>6382</td>
    </tr>
    <tr>
      <th>2020-12-29</th>
      <td>MSS_281112020121100340_0X.ZIP</td>
      <td>29 Dec 2020</td>
      <td>6,389 KB</td>
      <td>6389</td>
    </tr>
    <tr>
      <th>2020-12-30</th>
      <td>MSS_291112020121100051_0X.ZIP</td>
      <td>30 Dec 2020</td>
      <td>6,390 KB</td>
      <td>6390</td>
    </tr>
    <tr>
      <th>2020-12-31</th>
      <td>MSS_301112020121100813_0X.ZIP</td>
      <td>31 Dec 2020</td>
      <td>6,388 KB</td>
      <td>6388</td>
    </tr>
  </tbody>
</table>
<p>366 rows × 4 columns</p>
</div>

More practically is to list a month and a year (due to size issues) and
this will return the bus and branch data

``` python
month, year = 1 , 2022
spd_df = extract_spd_list(year)
await main_spd(spd_df.loc[f'{year}-{month}'], year)
```

    (                INTERVAL               BRANCHNAME FROM_STATION TO_STATION  \
     0    2022-01-01 00:00:00         ABY     MXT1MXT1          ABY        ABY   
     1    2022-01-01 00:00:00           ABY     T2  T2          ABY        ABY   
     2    2022-01-01 00:00:00  ALB     ALB_HEN3      1          ALB        HEN   
     3    2022-01-01 00:00:00  ALB     ALB_HPI1      1          ALB        HPI   
     4    2022-01-01 00:00:00  ALB     ALB_SVL1      1          ALB        SVL   
     ...                  ...                      ...          ...        ...   
     1077 2022-01-31 23:30:00           WTU     T4  T4          WTU        WTU   
     1078 2022-01-31 23:30:00         WVY     MXT1MXT1          WVY        WVY   
     1079 2022-01-31 23:30:00           WVY     T1  T1          WVY        WVY   
     1080 2022-01-31 23:30:00           WWD     T1  T1          WWD        WWD   
     1081 2022-01-31 23:30:00           WWD     T2  T2          WWD        WWD   
     
             FROM_MW      TO_MW  BRANCHLOSSES  
     0      0.000000   0.000000       0.00000  
     1     -4.597000  -4.606000       0.01446  
     2    -18.837000 -18.860001       0.02267  
     3     13.488000  13.478000       0.00905  
     4     14.881000  14.872000       0.00912  
     ...         ...        ...           ...  
     1077  19.447001  19.407000       0.06421  
     1078   0.000000   0.000000       0.00000  
     1079   2.808000   2.799000       0.01193  
     1080  -0.318000  -0.318000       0.00000  
     1081  -2.753000  -2.753000       0.00000  
     
     [1612512 rows x 7 columns],
                    INTERVAL ID_BUS ID_ST       LOAD  GENERATION
     0   2022-01-01 00:00:00    100   MVE   0.000000      0.0000
     1   2022-01-01 00:00:00    101   MVE   0.000000      0.0000
     2   2022-01-01 00:00:00    102   RTO   0.000000      0.0000
     3   2022-01-01 00:00:00    103   CBG  19.943001      0.0000
     4   2022-01-01 00:00:00    104   CBG   0.000000      0.0000
     ..                  ...    ...   ...        ...         ...
     930 2022-01-31 23:30:00     95   ARI   0.000000     15.3333
     931 2022-01-31 23:30:00     96   ARI   0.000000     15.3333
     932 2022-01-31 23:30:00     97   ARI   0.000000     15.3333
     933 2022-01-31 23:30:00     98   ARI   0.000000      0.0000
     934 2022-01-31 23:30:00     99   MVE   0.000000      0.0000
     
     [1392881 rows x 5 columns])
