# ISSA
The Input Scripting and Statistical Analysis (ISSA) software package allows for the easy scripting of large batches of input files for "black box" codes, and the statistical evaluation of their corresponding output values.

## Running ISSA
ISSA 

### Dependencies 

## Software Development for Engineering Research Project Proposal
### Winter 2022
#### Michael Branco-Katcher
## Summary
The proposed work for this project will be to create a tool that can create batches of input files for a "black box" or specific use code using a number of different methods, run these files from command line, and perform both batch statistics and display individual statics of result figures where requires. A "black box" tool is one with an output that cannot be easily directly computed with the input information. This tool would aim to decrease the lead time necessary to use these sorts of tool and to aid in exploring new ways meaningful statsitics may be gained through different methods of sampling data to be used as input for these tools. 

The ideal user would be one who uses a black box tool in their research, understands their input/output file format, understands their input parameters well enough to be able to define constriants, assign distributions, and assign appropriate ranges to values. This code will be written to cater to a nuclear industry specific code, but if a user writes their own parameterized input file it should be applicable to any tool. 

Other industries that could potentially benefit may be Material Science, whose field relies heavily on the use of Monte-Carlo tools as well to predict potentially irradiation damage.
## Background
In the nuclear industry, an example of a "black box" type of tool is a common tool used in the nuclear MCNP6 (MCNP), a radiation transport code. While radiation transport tools can be written by an individual, MCNP6 is already heavily trusted by the industry and regulators and is a familiar format to other researchers. MCNP can be used for a variety of reasons, but the largest use case is to tally number of radiation interactions with materials present in a system. This tally will come with an associated error from the data being used to calculate the chance of nuclear interaction, and the natural error associated with the Monte-Carlo method. A third source of error is not accounted for by this code, any possible physical variations in the input parameters. Many scientists seek to understand how these measured uncertainties could potentially influence the results of their experiments through MCNP. Currently, researchers tend to find the range of potentially data for these values and write individual input decks to represent the different potential cases. Others, such as Jesse Norris at Lawrence Livermore National Laboratory [1], have developed tools that may automate this specific process once the data has been generated by the individual but does not deal with generating the data.

Two barriers for entry to use for tools of this nature are that these code tend to use a proprietary input file format, and that it requires a long time to run. In a standard setting, MCNP could potentially need to be run nearly 1000 times using a standard sampling sceheme over 

The first problem is also solved by using automation tools such as the one listed above, by creating a script that places input variables in only the necessary locations from a base input deck. However, depending on the use, different methods of sampling may be used to reduce the number of values needed to reach similar statistics. For example, Latin Hypercube Sampling (LHS) versus the standard Random sampling to fill the potential design space faster. A further approach may be to calculate how sensitive the result of a simulation is to a small change in a specific parameter. This would result in many reduced runs, but may not capture sought detail in the output.

Researchers have created tools to carry out these individual tasks, but there is not an open source tool that intends to cater to various project needs for more than one industry.
## Approach
The base of this work was previously completed by me during an internship over the Summer of 2022. This is a combination of both original methods, open-source Python packages, and common industry practices. 

This project seeks to create one piece of software that will:
1. Produce ranges of data for user chosen input files. This will produce multiple different sets of data using different sampling methods.
2. Allow for the generation of input files according to a parameterized input deck. 
3. Run the desired code, and extract specific output parameters as defined by the user.
4. Process output data, including calculating average values, variance, and sensitivity curves.

#### Expected Inputs
1. The user is expected to provide the base data for their input, as well as know what the general shape of the distribution of possible values is, and the mean and standard deviation of values.
2. The user is expected to parameterize their own input decks. This will be accomplished through a provided blank Python file detailed how to match a general input deck to the format including how to allow for specific lines to be changes by the data generated in step one. 
3. The typical command to run their chosen tool from command line.
4. Identification of any outputs of particular interst, and where they may be found in a typical input file.

#### Expected Outputs
1. Sorted scripts of desired input files, separated based on means of sampling.
    a. Including statistics on input parameters.
2. Output files from tool.
3. Statistics performed on results of inoput files.

#### Python Packages
This work will make heavy use of the *os* Python package for navigating file trees, the *re* package for regex writing of files, the *subprocess* package to access the command line to run tools, the *Scipy* and *Math* packages for their various sampling schemes, the *Numpy* package to perform statistics on output values, and finally the *Seaborn* and *MatplotLib* packages for visualization.

## References
1. Norris, J. (2019). Critical experiment design using OPTIMUS. ICNC 2019: 11 international conference on nuclear criticality safety, France

## Packages Information
| Package | Link |
| ------ | ------ |
| os | [os — Miscellaneous operating system interfaces][PlDb] |
| re | [re — Regular expression operations][PlGh] |
| subprocess | [subprocess — Subprocess management][PlGd] |
| Math | [math — Mathematical functions][PlOd] |
| Scipy | [Fundamental algorithms for scientific computing in Python][PlMe] |
| Numpy | [The fundamental package for scientific computing with Python][PlGa] |
| Seaborn | [seaborn: statistical data visualization][PlGb] |
| Matplotlib | [Visualizing With Python][PlGc] |



[PlDb]: <https://docs.python.org/3/library/os.html>
[PlGh]: <https://docs.python.org/3/library/re.html>
[PlGd]: <https://docs.python.org/3/library/subprocess.html>
[PlOd]: <https://docs.python.org/3/library/math.html>
[PlMe]: <https://scipy.org/>
[PlGa]: <https://numpy.org/>
[PlGb]: <https://seaborn.pydata.org/>
[PlGc]: <https://matplotlib.org/>

