
from setuptools import setup, find_packages
import codecs
import os
import setuptools

with open('README.rst') as readme_file:
    readme = readme_file.read()
requirements = [
	'absl-py==0.9.0',
	'asgiref==3.4.1',
	'astor==0.8.0',
	'astunparse==1.6.3',
	'backcall==0.2.0',
	'blinker==1.4',
	'brotlipy==0.7.0',
	'cached-property==1.5.2',
	'cachetools==4.1.0',
	'certifi==2021.5.30',
	'cffi==1.14.0',
	'chardet==3.0.4',
	'charset-normalizer==2.0.7',
	'clang==5.0',
	'click==7.1.2',
	'cloudpickle', 
	'colorama==0.4.4',
	'cryptography==2.9.2',
	'cycler==0.10.0',
	'cytoolz==0.11.0',
	'dask==2021.9.1',
	'decorator==5.1.0',
	'flatbuffers==1.12',
	'fsspec',
	'gast==0.2.2',
	'google-auth',
	'google-auth-oauthlib==0.4.1',
	'google-pasta==0.2.0',
	'grpcio==1.27.2',
	'h5py==2.10.0',
	'idna',
	'imageio', 
	'imutils', 
	'jedi==0.18.1',
	'joblib==1.1.0',
	'Keras==2.3.1',
	'Keras-Applications', 
	'Keras-Preprocessing==1.1.0',
	'keras-resnet==0.2.0',
	'kiwisolver',
	'locket==0.2.1',
	'Markdown==3.1.1',
	'matplotlib',
	'matplotlib-inline==0.1.3',
	'mrcnn==0.2',
	'networkx',
	'numpy==1.19.1',
	'oauthlib==3.1.0',
	'olefile',
	'opencv-python==4.5.4.58',
	'opt-einsum==3.1.0',
	'packaging',
	'pandas==1.3.5',
	'parso==0.8.2',
	'partd',
	'pickleshare==0.7.5',
	'Pillow==8.4.0',
	'PyJWT==1.7.1',
	'pyOpenSSL',
	'pyparsing==2.4.7',
	'pyreadline==2.1',
	'PySocks',
	'python-dateutil==2.8.1',
	'pytz==2021.3',
	'PyWavelets',
	'PyYAML==5.3.1',
	'requests',
	'requests-oauthlib==1.3.0',
	'rich==12.4.1',
	'rsa==4.0',
	'scikit-image==0.18.1',
	'scikit-learn==1.0.1',
	'scipy==1.2.1',
	'seaborn==0.11.2',
	'six==1.15.0',
	'sqlparse==0.4.2',
	'tensorboard==1.14.0',
	'tensorboard-data-server==0.6.1',
	'tensorboard-plugin-wit==1.8.0',
	'tensorflow==1.14.0',
	'tensorflow-estimator==1.14.0',
	'twine==4.0.0',
	'urllib3==1.25.9'
    ]
# Setting up
setup(
    name="grmrcnn",
    version='0.1',
	description='This is for object detection model by combining Gradcam++ with MaskRCNN',
	long_description=readme,
	long_description_content_type="text/markdown",
    author="AlphonseInbarajXavier",
    author_email="xalphonse@gmail.com",
    url='https://github.com/xalphonseinbaraj/grmrcnn.git',
	packages=[
        'grmrcnn',
    ],
    package_dir={'grmrcnn': 'grmrcnn'},
	package_data={
        'grmrcnn': ['*.dat','*.xml','*.h5']
		    },
	install_requires=requirements,
    license="MIT license",
    zip_safe=False,
    keywords='gradcam++ with mask rcnn',
    classifiers=[
        "Development Status :: 2 - Pre-Alpha",
        "Intended Audience :: Developers",
        "Programming Language :: Python :: 3",
        "Operating System :: Microsoft :: Windows",
        "Programming Language :: Python :: 3.6",
        "Natural Language :: English",
    ]
)

