/*! For license information please see index.js.LICENSE.txt */
define("pgljupyter",["@jupyter-widgets/base","@jupyter-widgets/controls","@lumino/widgets","@jupyterlab/ui-components"],(function(__WEBPACK_EXTERNAL_MODULE__0__,__WEBPACK_EXTERNAL_MODULE__3__,__WEBPACK_EXTERNAL_MODULE__27__,__WEBPACK_EXTERNAL_MODULE__28__){return function(modules){var installedModules={};function __webpack_require__(moduleId){if(installedModules[moduleId])return installedModules[moduleId].exports;var module=installedModules[moduleId]={i:moduleId,l:!1,exports:{}};return modules[moduleId].call(module.exports,module,module.exports,__webpack_require__),module.l=!0,module.exports}return __webpack_require__.m=modules,__webpack_require__.c=installedModules,__webpack_require__.d=function(exports,name,getter){__webpack_require__.o(exports,name)||Object.defineProperty(exports,name,{enumerable:!0,get:getter})},__webpack_require__.r=function(exports){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(exports,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(exports,"__esModule",{value:!0})},__webpack_require__.t=function(value,mode){if(1&mode&&(value=__webpack_require__(value)),8&mode)return value;if(4&mode&&"object"==typeof value&&value&&value.__esModule)return value;var ns=Object.create(null);if(__webpack_require__.r(ns),Object.defineProperty(ns,"default",{enumerable:!0,value}),2&mode&&"string"!=typeof value)for(var key in value)__webpack_require__.d(ns,key,function(key){return value[key]}.bind(null,key));return ns},__webpack_require__.n=function(module){var getter=module&&module.__esModule?function(){return module.default}:function(){return module};return __webpack_require__.d(getter,"a",getter),getter},__webpack_require__.o=function(object,property){return Object.prototype.hasOwnProperty.call(object,property)},__webpack_require__.p="",__webpack_require__(__webpack_require__.s=85)}([function(module,exports){module.exports=__WEBPACK_EXTERNAL_MODULE__0__},,,function(module,exports){module.exports=__WEBPACK_EXTERNAL_MODULE__3__},function(module,exports,__webpack_require__){"use strict";var isNdarray=__webpack_require__(25),isNdarrayLike=__webpack_require__(16),isArrayLike=__webpack_require__(5);function inferType(x){if(x){if(isNdarray(x)||isNdarrayLike(x))return"generic"===x.dtype?inferType.GENERIC_NDARRAY:inferType.NDARRAY;if(isArrayLike(x))return inferType.ARRAY_OF_ARRAYS;throw new Error("Unhandled data type. Got type: "+typeof x)}}inferType.ARRAY_OF_ARRAYS="Arr",inferType.NDARRAY="Nd",inferType.GENERIC_NDARRAY="GenNd",inferType.PACKED="PackArr",module.exports=inferType},function(module,exports,__webpack_require__){"use strict";module.exports=function(data){return Array.isArray(data)||ArrayBuffer.isView(data)}},,,,function(module,exports,__webpack_require__){"use strict";var createVariable=function createVariable(name,nurbs){return function(i,period){void 0===i||Array.isArray(i)||(i=[i]);for(var dimAccessors=[],j=0;j<i.length;j++)dimAccessors.push(createVariable.sum(i[j]));if(period)for(i=0;i<dimAccessors.length;i++)void 0!==period[i]&&(dimAccessors[i]="("+dimAccessors[i]+" + "+period[i]+") % "+period[i]);return name+dimAccessors.join("_")}};createVariable.sum=function(parts){return 0===(parts=(parts=Array.isArray(parts)?parts:[parts]).filter((function(part){return void 0!==part&&0!==part}))).length&&parts.push(0),parts.join(" + ")},module.exports=createVariable},,,,,,,function(module,exports){module.exports=function(arr){return!!arr&&(void 0!==arr.data&&Array.isArray(arr.shape)&&void 0!==arr.offset&&void 0!==arr.stride)}},function(module,exports,__webpack_require__){var inferType=__webpack_require__(4);module.exports=function(nurbs,variableName,propertyName,data){var i,code=[];switch(inferType(data)){case inferType.NDARRAY:for(code.push("  var "+variableName+" = "+propertyName+".data;"),code.push("  var "+variableName+"Offset = "+propertyName+".offset;"),i=0;i<data.dimension;i++)code.push("  var "+variableName+"Stride"+i+" = "+propertyName+".stride["+i+"];");break;case inferType.ARRAY_OF_ARRAYS:code.push("  var "+variableName+" = "+propertyName+";")}return code.join("\n")}},function(module,exports,__webpack_require__){"use strict";var isNdarrayLike=__webpack_require__(16);module.exports=function(data,dataVariableName,dimension){if(data){if(isNdarrayLike(data))return dataVariableName+".shape["+dimension+"]";for(var str=dataVariableName,i=0;i<dimension;i++)str+="[0]";return str+".length"}return"this.size["+dimension+"]"}},,,,,,function(module,exports,__webpack_require__){var api=__webpack_require__(76),content=__webpack_require__(77);"string"==typeof(content=content.__esModule?content.default:content)&&(content=[[module.i,content,""]]);var options={insert:"head",singleton:!1};api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){"use strict";module.exports=function(arr){return!!arr&&(!!arr.dtype&&new RegExp("function View[0-9]+d(:?"+arr.dtype+")+").test(String(arr.constructor)))}},function(module,exports,__webpack_require__){"use strict";module.exports=function(n,callback){for(var m=1,k=0,i=[];k<n.length;k++)m*=Array.isArray(n[k])?n[k][1]-n[k][0]:n[k],i[k]=Array.isArray(n[k])?n[k][0]:0;for(var ptr=0;ptr<m;ptr++)for(callback(i.slice()),k=n.length-1;k>=0;k--){if(i[k]!==(Array.isArray(n[k])?n[k][1]:n[k])-1){i[k]++;break}i[k]=Array.isArray(n[k])?n[k][0]:0}}},function(module,exports){module.exports=__WEBPACK_EXTERNAL_MODULE__27__},function(module,exports){module.exports=__WEBPACK_EXTERNAL_MODULE__28__},function(module,exports,__webpack_require__){"use strict";var inferType=__webpack_require__(4),computeCacheKey=__webpack_require__(79),isNdarray=__webpack_require__(25),isNdarrayLike=__webpack_require__(16),createAccessors=__webpack_require__(80),numericalDerivative=__webpack_require__(81),isArrayLike=__webpack_require__(5),createEvaluator=__webpack_require__(82),createTransform=__webpack_require__(83),createSupport=__webpack_require__(84),BOUNDARY_TYPES={open:"open",closed:"closed",clamped:"clamped"};function isBlank(x){return null==x}function parseNURBS(points,degree,knots,weights,boundary,opts){var i,dflt;!points||isArrayLike(points)||isNdarray(points)?(opts=opts||{},this.weights=weights,this.knots=knots,this.degree=degree,this.points=points,this.boundary=boundary,this.debug=opts.debug,this.checkBounds=!!opts.checkBounds,Object.defineProperty(this,"size",{value:opts.size,writable:!0,configurable:!0})):(opts=points,this.debug=points.debug,this.checkBounds=!!points.checkBounds,this.weights=points.weights,this.knots=points.knots,this.degree=points.degree,this.boundary=points.boundary,this.points=points.points,Object.defineProperty(this,"size",{value:opts.size,writable:!0,configurable:!0}));var pointType=inferType(this.points),weightType=inferType(this.weights),knotType=inferType(this.knots);if(this.points)switch(pointType){case inferType.GENERIC_NDARRAY:case inferType.NDARRAY:Object.defineProperties(this,{splineDimension:{value:this.points.shape.length-1,writable:!1,configurable:!0},dimension:{value:this.points.shape[this.points.shape.length-1],writable:!1,configurable:!0},size:{get:function(){return this.points.shape.slice(0,this.points.shape.length-1)},set:function(){throw new Error("Cannot assign to read only property 'size'")},configurable:!0}});break;case inferType.ARRAY_OF_ARRAYS:var splineDimension=0,size=this.size||[];size.length=0;for(var ptr=this.points;isArrayLike(ptr[0]);ptr=ptr[0])splineDimension++,size.push(ptr.length);if(0===splineDimension)throw new Error("Expected an array of points");Object.defineProperties(this,{splineDimension:{value:splineDimension,writable:!1,configurable:!0},dimension:{value:ptr.length,writable:!1,configurable:!0},size:{get:function(){var size=[];size.length=0;for(var i=0,ptr=this.points;i<this.splineDimension;i++,ptr=ptr[0])size[i]=ptr.length;return size},set:function(){throw new Error("Cannot assign to read only property 'size'")},configurable:!0}});break;case inferType.PACKED:default:throw new Error("Expected either a packed array, array of arrays, or ndarray of points")}else{if(void 0===this.size||null===this.size)throw new Error("Either points or a control hull size must be provided.");if(isArrayLike(this.size)||Object.defineProperty(this,"size",{value:[this.size],writable:!0,configurable:!0}),0===this.size.length)throw new Error("`size` must be a number or an array of length at least one.");Object.defineProperties(this,{splineDimension:{value:this.size.length,writable:!1,configurable:!0},dimension:{value:0,writable:!1,configurable:!0}})}if(isArrayLike(this.degree)){for(i=0;i<this.splineDimension;i++)if(isBlank(this.degree[i]))throw new Error("Missing degree in dimension "+(i+1))}else{var hasBaseDegree=!isBlank(this.degree),baseDegree=isBlank(this.degree)?2:this.degree;for(this.degree=[],i=0;i<this.splineDimension;i++)if(this.size[i]<=baseDegree){if(hasBaseDegree)throw new Error("Expected at least "+(baseDegree+1)+" points for degree "+baseDegree+" spline in dimension "+(i+1)+" but got only "+this.size[i]);this.degree[i]=this.size[i]-1}else this.degree[i]=baseDegree}if(dflt="string"!=typeof this.boundary?"open":this.boundary,!BOUNDARY_TYPES[dflt])throw new Error("Boundary type must be one of "+Object.keys(BOUNDARY_TYPES)+". Got "+dflt);for(this.boundary=isArrayLike(this.boundary)?this.boundary:[],this.boundary.length=this.splineDimension,i=0;i<this.splineDimension;i++)if(this.boundary[i]=isBlank(this.boundary[i])?dflt:this.boundary[i],!BOUNDARY_TYPES[dflt])throw new Error("Boundary type must be one of "+Object.keys(BOUNDARY_TYPES)+". Got "+dflt+" for dimension "+(i+1));switch(knotType){case inferType.ARRAY_OF_ARRAYS:for(isArrayLike(this.knots)&&this.knots.length>0&&!isArrayLike(this.knots[0])&&(this.knots=[this.knots]),i=0;i<this.splineDimension;i++){if(this.size[i]<=this.degree[i])throw new Error("Expected at least "+(this.degree[i]+1)+" points in dimension "+(i+1)+" but got "+this.size[i]+".");if(isArrayLike(this.knots[i])){if("closed"!==this.boundary[i]&&this.knots[i].length!==this.degree[i]+this.size[i]+1)throw new Error("Expected "+(this.degree[i]+this.size[i]+1)+" knots in dimension "+(i+1)+" but got "+this.knots[i].length+".");if("closed"===this.boundary[i]&&this.knots[i].length!==this.size[i]+1&&!(this.knots[i].length===this.size[i]+this.degree[i]+1))throw new Error("Expected "+(this.size[i]+1)+" knots for closed spline in dimension "+(i+1)+" but got "+this.knots[i].length+".")}}break;case inferType.NDARRAY:}var newCacheKey=computeCacheKey(this,this.debug,this.checkBounds,pointType,weightType,knotType);if(newCacheKey!==this.__cacheKey){this.__cacheKey=newCacheKey;var accessors=createAccessors(this);this.evaluate=createEvaluator(this.__cacheKey,this,accessors,this.debug,this.checkBounds,!1),this.transform=createTransform(this.__cacheKey,this,accessors,this.debug),this.support=createSupport(this.__cacheKey,this,accessors,this.debug,this.checkBounds),this.evaluator=function(derivativeOrder,isBasis){return createEvaluator(this.__cacheKey,this,accessors,this.debug,this.checkBounds,isBasis,derivativeOrder)}}return this.numericalDerivative=numericalDerivative.bind(this),this}function domainGetter(){var sizeArray,ret=[],ptr=this.points;ptr?isNdarrayLike(ptr)&&(sizeArray=ptr.shape):sizeArray=this.size;for(var d=0;d<this.splineDimension;d++){var size=sizeArray?sizeArray[d]:ptr.length,p=this.degree[d],isClosed="closed"===this.boundary[d];if(this.knots&&this.knots[d]){var k=this.knots[d];ret[d]=[k[isClosed?0:p],k[size]]}else ret[d]=[isClosed?0:p,size];ptr&&(ptr=ptr[0])}return ret}module.exports=function(points,degree,knots,weights,boundary,opts){var ctor=function(points,degree,knots,weights,boundary,opts){return parseFcn(points,degree,knots,weights,boundary,opts),ctor},parseFcn=parseNURBS.bind(ctor);return Object.defineProperty(ctor,"domain",{get:domainGetter}),parseFcn(points,degree,knots,weights,boundary,opts),ctor}},,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,function(module){module.exports=JSON.parse('{"name":"pgljupyter","version":"0.1.10","description":"PlantGL jupyter widget","keywords":["jupyter","jupyterlab","jupyterlab-extension","widgets","PlantGL","Lpy"],"files":["lib/**/*.js","dist/*.js","css/*.css"],"homepage":"https://github.com/jvail/plantgl-jupyter","bugs":{"url":"https://github.com/jvail/plantgl-jupyter/issues"},"license":"CeCILL","author":{"name":"Jan Vaillant","email":"jan.vaillant@cirad.fr"},"repository":{"type":"git","url":"https://github.com/jvail/plantgl-jupyter.git"},"main":"lib/index.js","types":"./lib/index.d.ts","scripts":{"build":"npm run build:lib && npm run build:nbextension","build:labextension":"npm run clean:labextension && mkdirp pgljupyter/labextension && cd pgljupyter/labextension && npm pack ../..","build:lib":"tsc","build:pgljs":"cd src/pgljs && npm run build && mkdir -p ../../lib/pgljs && cp -a dist ../../lib/pgljs","build:nbextension":"webpack -p","build:all":"npm run build:pgljs && npm run build:labextension && npm run build:nbextension","clean":"npm run clean:lib && npm run clean:nbextension","clean:lib":"rimraf lib","clean:labextension":"rimraf pgljupyter/labextension","clean:nbextension":"rimraf pgljupyter/nbextension/static/index.js","prepack":"npm run build:lib","watch":"npm-run-all -p watch:*","watch:lib":"tsc -w","watch:nbextension":"webpack --watch --mode=development"},"dependencies":{"@jupyter-widgets/base":"^3.0.0","@jupyter-widgets/controls":"^2.0.0","@jupyterlab/application":"^2.2.2","@jupyterlab/codemirror":"^2.2.1","@jupyterlab/docregistry":"^2.2.1","@jupyterlab/rendermime":"^2.2.1","@jupyterlab/rendermime-interfaces":"^2.2.0","@jupyterlab/ui-components":"^2.2.1","@material/mwc-formfield":"^0.18.0","@material/mwc-icon-button":"^0.18.0","@material/mwc-icon-button-toggle":"^0.18.0","@material/mwc-linear-progress":"^0.18.0","@material/mwc-switch":"^0.18.0","d3":"^5.16.0","lit-html":"^1.2.1","nurbs":"^1.1.1","three":"^0.119.1"},"devDependencies":{"@lumino/application":"^1.10.4","@lumino/widgets":"^1.13.4","@types/d3":"^5.7.2","@types/expect.js":"^0.3.29","@types/node":"^10.17.28","@types/webpack-env":"^1.13.6","css-loader":"^3.6.0","expect.js":"^0.3.1","fs-extra":"^7.0.0","mkdirp":"^0.5.1","npm-run-all":"^4.1.3","rimraf":"^2.6.2","source-map-loader":"^0.2.4","style-loader":"^1.0.0","terser-webpack-plugin":"^3.1.0","ts-loader":"^5.2.1","typescript":"^3.9.7","webpack":"^4.44.1","webpack-bundle-analyzer":"^3.8.0","webpack-cli":"^3.3.12"},"jupyterlab":{"extension":"lib/labplugin"}}')},function(module,exports,__webpack_require__){"use strict";var memo,isOldIE=function(){return void 0===memo&&(memo=Boolean(window&&document&&document.all&&!window.atob)),memo},getTarget=function(){var memo={};return function(target){if(void 0===memo[target]){var styleTarget=document.querySelector(target);if(window.HTMLIFrameElement&&styleTarget instanceof window.HTMLIFrameElement)try{styleTarget=styleTarget.contentDocument.head}catch(e){styleTarget=null}memo[target]=styleTarget}return memo[target]}}(),stylesInDom=[];function getIndexByIdentifier(identifier){for(var result=-1,i=0;i<stylesInDom.length;i++)if(stylesInDom[i].identifier===identifier){result=i;break}return result}function modulesToDom(list,options){for(var idCountMap={},identifiers=[],i=0;i<list.length;i++){var item=list[i],id=options.base?item[0]+options.base:item[0],count=idCountMap[id]||0,identifier="".concat(id," ").concat(count);idCountMap[id]=count+1;var index=getIndexByIdentifier(identifier),obj={css:item[1],media:item[2],sourceMap:item[3]};-1!==index?(stylesInDom[index].references++,stylesInDom[index].updater(obj)):stylesInDom.push({identifier,updater:addStyle(obj,options),references:1}),identifiers.push(identifier)}return identifiers}function insertStyleElement(options){var style=document.createElement("style"),attributes=options.attributes||{};if(void 0===attributes.nonce){var nonce=__webpack_require__.nc;nonce&&(attributes.nonce=nonce)}if(Object.keys(attributes).forEach((function(key){style.setAttribute(key,attributes[key])})),"function"==typeof options.insert)options.insert(style);else{var target=getTarget(options.insert||"head");if(!target)throw new Error("Couldn't find a style target. This probably means that the value for the 'insert' parameter is invalid.");target.appendChild(style)}return style}var textStore,replaceText=(textStore=[],function(index,replacement){return textStore[index]=replacement,textStore.filter(Boolean).join("\n")});function applyToSingletonTag(style,index,remove,obj){var css=remove?"":obj.media?"@media ".concat(obj.media," {").concat(obj.css,"}"):obj.css;if(style.styleSheet)style.styleSheet.cssText=replaceText(index,css);else{var cssNode=document.createTextNode(css),childNodes=style.childNodes;childNodes[index]&&style.removeChild(childNodes[index]),childNodes.length?style.insertBefore(cssNode,childNodes[index]):style.appendChild(cssNode)}}function applyToTag(style,options,obj){var css=obj.css,media=obj.media,sourceMap=obj.sourceMap;if(media?style.setAttribute("media",media):style.removeAttribute("media"),sourceMap&&btoa&&(css+="\n/*# sourceMappingURL=data:application/json;base64,".concat(btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap))))," */")),style.styleSheet)style.styleSheet.cssText=css;else{for(;style.firstChild;)style.removeChild(style.firstChild);style.appendChild(document.createTextNode(css))}}var singleton=null,singletonCounter=0;function addStyle(obj,options){var style,update,remove;if(options.singleton){var styleIndex=singletonCounter++;style=singleton||(singleton=insertStyleElement(options)),update=applyToSingletonTag.bind(null,style,styleIndex,!1),remove=applyToSingletonTag.bind(null,style,styleIndex,!0)}else style=insertStyleElement(options),update=applyToTag.bind(null,style,options),remove=function(){!function(style){if(null===style.parentNode)return!1;style.parentNode.removeChild(style)}(style)};return update(obj),function(newObj){if(newObj){if(newObj.css===obj.css&&newObj.media===obj.media&&newObj.sourceMap===obj.sourceMap)return;update(obj=newObj)}else remove()}}module.exports=function(list,options){(options=options||{}).singleton||"boolean"==typeof options.singleton||(options.singleton=isOldIE());var lastIdentifiers=modulesToDom(list=list||[],options);return function(newList){if(newList=newList||[],"[object Array]"===Object.prototype.toString.call(newList)){for(var i=0;i<lastIdentifiers.length;i++){var index=getIndexByIdentifier(lastIdentifiers[i]);stylesInDom[index].references--}for(var newLastIdentifiers=modulesToDom(newList,options),_i=0;_i<lastIdentifiers.length;_i++){var _index=getIndexByIdentifier(lastIdentifiers[_i]);0===stylesInDom[_index].references&&(stylesInDom[_index].updater(),stylesInDom.splice(_index,1))}lastIdentifiers=newLastIdentifiers}}}},function(module,exports,__webpack_require__){(exports=__webpack_require__(78)(!1)).push([module.i,".unselectable {\n    -webkit-touch-callout: none;\n    -webkit-user-select: none;\n    -khtml-user-select: none;\n    -moz-user-select: none;\n    -ms-user-select: none;\n    user-select: none;\n}\n\n*:focus {\n    outline: none;\n}\n\n.pgl-widget {\n    box-sizing: border-box;\n    min-width: 400px;\n    min-height: 400px;\n}\n\n.pgl-resizable{\n    width: 100%;\n    height: 100%;\n    overflow: hidden;\n}\n\n.pgl-jupyter-pgl-widget {\n    display: inline-block;\n    position: relative;\n    min-width: 400px;\n    min-height: 400px;\n    box-sizing: border-box;\n}\n\n.pgl-jupyter-pgl-widget-controls {\n    position: absolute;\n    top: 0px;\n    right: 0px;\n    width: 160px;\n    height: 99%; /* FIXME: there is an odd height overshoot in jupyter */\n    pointer-events: none;\n}\n\n.pgl-jupyter-pgl-widget-controls-container {\n    padding: 5px;\n    height: 100%;\n    pointer-events: none;\n    overflow-y: auto;\n    overflow-x: hidden;\n    --mdc-typography-body1-font-size: 12px;\n    --mdc-typography-body2-font-size: 12px;\n    --mdc-typography-body2-color: white;\n    --mdc-theme-secondary: #f57c24;\n    --mdc-theme-primary: rgb(75, 75, 75);\n    --mdc-icon-size: 30px;\n    --mdc-button-size: 35px;\n}\n\n.pgl-jupyter-pgl-widget-controls-header {\n    pointer-events: none;\n    float: right;\n}\n\n.pgl-jupyter-pgl-widget-controls-body {\n    pointer-events: none;\n    clear: both;\n}\n\n.pgl-jupyter-pgl-widget-controls-header * {\n    pointer-events: all;\n}\n\n.pgl-jupyter-pgl-widget-controls-body > * {\n    display: block;\n    pointer-events: all;\n    padding: 12px;\n}\n\n.pgl-jupyter-lsystem-widget-controls {\n    position: absolute;\n    bottom: 0px;\n    left: 0px;\n    width: 100%;\n    height: 80px; /* FIXME: there is an odd height overshoot in jupyter */\n    pointer-events: none;\n}\n\n.pgl-jupyter-lsystem-widget-controls-container {\n    padding: 5px;\n    overflow-y: hidden;\n    overflow-x: hidden;\n    text-align: center;\n    --mdc-typography-body1-font-size: 12px;\n    --mdc-typography-body2-font-size: 12px;\n    --mdc-typography-body2-color: white;\n    --mdc-theme-primary: #f57c24;\n    --mdc-theme-secondary: rgb(75, 75, 75);\n    --mdc-icon-size: 30px;\n    --mdc-button-size: 35px;\n}\n\n.pgl-jupyter-lsystem-widget-controls-container * {\n    display: inline;\n    pointer-events: all;\n}\n\n.pgl-jupyter-lsystem-widget-controls-container mwc-linear-progress {\n    margin: 5px 12px;\n    display: block;\n    text-align: left;\n    --mdc-theme-primary: #f57c24;\n    --mdc-theme-secondary: rgb(75, 75, 75);\n}\n\nmwc-icon-button-toggle, mwc-icon-button {\n    color: #f57c24;\n    --mdc-icon-button-ripple-opacity: 0\n}\n\n/* .pgl-curve-editor {\n    margin: 10px 10px 10px 10px;\n} */\n\n.pgl-curve-editor-svg {\n    width: 250px;\n    height: 250px;\n    overflow: visible;\n    background-color: #f5f5f5;\n    display: block;\n    margin: auto 0px auto auto;\n}\n\n.pgl-curve-editor-svg .grid {\n    stroke: lightgrey;\n    stroke-width: 1;\n    fill: none;\n}\n\n.pgl-curve-editor-svg .line {\n    stroke: grey;\n    stroke-dasharray: 2 2;\n    fill: none;\n}\n\n.pgl-curve-editor-svg .curve {\n    stroke: #f57c24;\n    fill: none;\n    stroke-width: 2;\n}\n\n.pgl-curve-editor-svg .point {\n    fill: #f57c24;\n    cursor: pointer;\n}\n",""]),module.exports=exports},function(module,exports,__webpack_require__){"use strict";module.exports=function(useSourceMap){var list=[];return list.toString=function(){return this.map((function(item){var content=function(item,useSourceMap){var content=item[1]||"",cssMapping=item[3];if(!cssMapping)return content;if(useSourceMap&&"function"==typeof btoa){var sourceMapping=(sourceMap=cssMapping,base64=btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap)))),data="sourceMappingURL=data:application/json;charset=utf-8;base64,".concat(base64),"/*# ".concat(data," */")),sourceURLs=cssMapping.sources.map((function(source){return"/*# sourceURL=".concat(cssMapping.sourceRoot||"").concat(source," */")}));return[content].concat(sourceURLs).concat([sourceMapping]).join("\n")}var sourceMap,base64,data;return[content].join("\n")}(item,useSourceMap);return item[2]?"@media ".concat(item[2]," {").concat(content,"}"):content})).join("")},list.i=function(modules,mediaQuery,dedupe){"string"==typeof modules&&(modules=[[null,modules,""]]);var alreadyImportedModules={};if(dedupe)for(var i=0;i<this.length;i++){var id=this[i][0];null!=id&&(alreadyImportedModules[id]=!0)}for(var _i=0;_i<modules.length;_i++){var item=[].concat(modules[_i]);dedupe&&alreadyImportedModules[item[0]]||(mediaQuery&&(item[2]?item[2]="".concat(mediaQuery," and ").concat(item[2]):item[2]=mediaQuery),list.push(item))}},list}},function(module,exports,__webpack_require__){"use strict";var isArrayLike=__webpack_require__(5);module.exports=function(nurbs,debug,checkBounds,pointType,weightType,knotType){var d,str,degreeParts=[],hasAnyKnots=!1;for(d=0;d<nurbs.splineDimension;d++){var hasKnots=isArrayLike(nurbs.knots)&&isArrayLike(nurbs.knots[d]);hasKnots&&(hasAnyKnots=!0),degreeParts.push("Deg"+nurbs.degree[d]+(hasKnots?"":"Uniform")+((str=nurbs.boundary[d])[0].toUpperCase()+str.slice(1)))}var parts=[[hasAnyKnots?"NU":"",nurbs.weights?"RBS":"BS"].join("")+nurbs.dimension+"D",degreeParts.join("_")];return pointType&&parts.push(pointType+"Pts"),weightType&&parts.push(weightType+"Wts"),knotType&&parts.push(knotType+"Kts"),debug&&parts.push("debug"),checkBounds&&parts.push("chk"),parts.join("_")}},function(module,exports,__webpack_require__){"use strict";var inferType=__webpack_require__(4),createVariable=__webpack_require__(9);function wrapAccessor(callback){return function(i,period){void 0===i||Array.isArray(i)||(i=[i]);for(var dimAccessors=[],j=0;j<i.length;j++)dimAccessors.push(createVariable.sum(i[j]));if(period)for(i=0;i<dimAccessors.length;i++)void 0!==period[i]&&(dimAccessors[i]="("+dimAccessors[i]+" + "+period[i]+") % "+period[i]);return callback(dimAccessors)}}function createAccessor(name,data){var i;if(data)switch(inferType(data)){case inferType.ARRAY_OF_ARRAYS:return wrapAccessor((function(accessors){return name+"["+accessors.join("][")+"]"}));case inferType.GENERIC_NDARRAY:return wrapAccessor((function(accessors){return name+".get("+accessors.join(",")+")"}));case inferType.NDARRAY:return wrapAccessor((function(accessors){var code=[name+"Offset"];for(i=0;i<accessors.length;i++)code.push(name+"Stride"+i+" * ("+accessors[i]+")");return name+"["+code.join(" + ")+"]"}));case inferType.PACKED:default:return}}module.exports=function(nurbs){var accessor,accessors={};return(accessor=createAccessor("x",nurbs.points))&&(accessors.point=accessor),(accessor=createAccessor("w",nurbs.weights))&&(accessors.weight=accessor),(accessor=createAccessor("k",nurbs.knots))&&(accessors.knot=accessor),accessors}},function(module,exports,__webpack_require__){"use strict";var args=[],tmp=[];module.exports=function(out,order,dimension){if(1!==order)throw new Error("Numerical derivative not implemented for order n = "+order+".");var i,h=void 0===arguments[this.splineDimension+3]?1e-4:arguments[this.splineDimension+3];for(args.length=this.splineDimension,i=0;i<this.splineDimension;i++)args[i+1]=arguments[i+3];var tm,tp,T,domain=this.domain,k0=domain[dimension][0],k1=domain[dimension][1],t0=args[dimension+1],dt=(k1-k0)*h;for("closed"===this.boundary[dimension]?(tm=k0+(t0-k0-dt+(T=k1-k0))%T,tp=k0+(t0-k0+dt+T)%T,dt*=2):(tm=Math.min(k1,Math.max(k0,t0-dt)),dt=(tp=Math.min(k1,Math.max(k0,t0+dt)))-tm),args[dimension+1]=tm,args[0]=tmp,this.evaluate.apply(null,args),args[dimension+1]=tp,args[0]=out,this.evaluate.apply(null,args),i=0;i<this.dimension;i++)out[i]=(out[i]-tmp[i])/dt;return out}},function(module,exports,__webpack_require__){"use strict";var ndloop=__webpack_require__(26),variable=__webpack_require__(9),accessorPreamble=__webpack_require__(17),inferType=__webpack_require__(4),isArrayLike=__webpack_require__(5),sizeGetter=__webpack_require__(18),evaluatorCache={},codeCache={};module.exports=function(cacheKey,nurbs,accessors,debug,checkBounds,isBasis,derivative){var i,j,n,m,d,kvar,splineDimension=nurbs.splineDimension,points=nurbs.points,degree=nurbs.degree,weights=nurbs.weights,hasWeights=void 0!==weights,knots=nurbs.knots,spaceDimension=nurbs.dimension,boundary=nurbs.boundary;if(null!=derivative){Array.isArray(derivative)||(derivative=[derivative]);var totalDerivativeOrder=0;for(i=0;i<splineDimension;i++)void 0===derivative[i]&&(derivative[i]=0),totalDerivativeOrder+=derivative[i];if(hasWeights&&totalDerivativeOrder>1)throw new Error("Analytical derivative not implemented for rational b-splines with order n = "+totalDerivativeOrder+".")}isBasis&&(cacheKey="Basis"+cacheKey),derivative&&(cacheKey="Der"+derivative.join("_")+"_"+cacheKey);var cachedEvaluator=evaluatorCache[cacheKey];if(debug)var logger="function"==typeof debug?debug:console.log;if(cachedEvaluator)return debug&&logger(codeCache[cacheKey]),cachedEvaluator.bind(nurbs);var code=[],functionName="evaluate"+cacheKey,pointAccessor=accessors.point;isBasis&&(pointAccessor=function(src,period){for(var terms=[],i=0;i<src.length;i++){for(var accessor=src[i],terms2=[],j=0;j<accessor.length;j++)0!==accessor[j]&&terms2.push(accessor[j]);accessor=terms2.join(" + "),period[i]&&(accessor="("+accessor+" + "+period[i]+") % "+period[i]),terms.push(accessor+" === "+indexVar(i))}return"(("+terms.join(" && ")+") ? 1 : 0)"});var weightAccessor=accessors.weight,knotAccessor=accessors.knot,knotVar=variable("k"),pointVar=variable("x"),weightVar=variable("w"),indexVar=variable("i"),tVar=variable("t"),domainVar=debug?"domain":"d",sizeVar=variable(debug?"size":"s"),knotIndex=variable(debug?"knotIndex":"j"),allDimensionUniform=!0;for(d=0;d<splineDimension;d++)isArrayLike(knots)&&isArrayLike(knots[d])&&(allDimensionUniform=!1);function line(str){code.push("  "+(str||""))}function debugLine(str){debug&&line(str)}if(isBasis)var indexArgs=[];var parameterArgs=[];for(i=0;i<splineDimension;i++)isBasis&&indexArgs.push(indexVar([i])),parameterArgs.push(tVar([i]));for(code.push("function "+functionName+" ("+(isBasis?"":"out, ")+parameterArgs.join(", ")+(isBasis?", "+indexArgs.join(", "):"")+") {"),line("var h, m, a, b;"),checkBounds&&(line("var "+domainVar+" = this.domain;"),line("for (var i = 0; i < this.splineDimension; i++) {"),line("  a = arguments[i + 1];"),line("  if (a < "+domainVar+"[i][0] || a > "+domainVar+"[i][1] || a === undefined || isNaN(a)) {"),line("    throw new Error('Invalid Spline parameter in dimension '+i+'. Valid domain is ['+"+domainVar+"[i][0]+', '+"+domainVar+"[i][1]+']. but got t'+i+' = '+arguments[i + 1]+'.');"),line("  }"),line("}")),d=0;d<splineDimension;d++)line("var "+sizeVar(d)+" = "+sizeGetter(points,"this.points",d)+";");function ternary(cond,a,b){return"("+cond+") ? ("+a+") : ("+b+")"}code.push(accessorPreamble(nurbs,"x","this.points",points)),hasWeights&&code.push(accessorPreamble(nurbs,"w","this.weights",weights)),allDimensionUniform||code.push(accessorPreamble(nurbs,"k","this.knots",knots));var hasKnots=[];for(d=0;d<splineDimension;d++)switch(inferType(knots)){case inferType.NDARRAY:hasKnots[d]=!0;break;case inferType.ARRAY_OF_ARRAYS:hasKnots[d]=isArrayLike(knots[d])}for(d=0;d<splineDimension;d++)if(hasKnots[d])for(debugLine("\n  // Bisect to locate the knot interval in dimension "+d+"\n"),line("var "+knotIndex(d)+" = 0;"),line("h = "+sizeVar(d)+";"),line("while(h > "+knotIndex(d)+" + 1) {"),line("  m = 0.5 * (h + "+knotIndex(d)+") | 0;"),line("  if ("+knotAccessor([d,"m"])+" > "+tVar(d)+") h = m;"),line("  else "+knotIndex(d)+" = m;"),line("}"),debugLine("\n  // Fetch knots for dimension "+d+"\n"),i=1-degree[d];i<=degree[d];i++)"closed"===boundary[d]?line(i<0?"var "+knotVar([d,i+degree[d]-1])+" = "+ternary(knotIndex(d)+" < "+-i,knotAccessor([d,0])+" + "+knotAccessor([d,[sizeVar(d),knotIndex(d),i]])+" - "+knotAccessor([d,[sizeVar(d)]]),knotAccessor([d,[knotIndex(d),i]]))+";":i>0?"var "+knotVar([d,i+degree[d]-1])+" = "+ternary(knotIndex(d)+" + "+i+" > "+sizeVar(d),knotAccessor([d,sizeVar(d)])+" + "+knotAccessor([d,i+" + "+knotIndex(d)+" - "+sizeVar(d)])+" - "+knotAccessor([d,0]),knotAccessor([d,[knotIndex(d),i]]))+";":"var "+knotVar([d,i+degree[d]-1])+" = "+knotAccessor([d,[knotIndex(d),i]])+";"):line("var "+knotVar([d,i+degree[d]-1])+" = "+knotAccessor([d,[knotIndex(d),i]])+";");else{for(debugLine("\n  // Directly compute knot interval for dimension "+d+"\n"),"closed"===boundary[d]?line(knotIndex(d)+" = ("+tVar(d)+" | 0) % "+sizeVar(d)+";"):(line(knotIndex(d)+" = ("+tVar(d)+" | 0);"),line("if ("+knotIndex(d)+" < "+degree[d]+") "+knotIndex(d)+" = "+degree[d]+";"),line("if ("+knotIndex(d)+" > "+sizeVar(d)+" - 1) "+knotIndex(d)+" = "+sizeVar(d)+" - 1;")),debugLine("\n  // Compute and clamp knots for dimension "+d+"\n"),i=1-degree[d];i<=degree[d];i++)line("var "+(kvar=knotVar([d,i+degree[d]-1]))+" = "+knotIndex(d)+" + "+i+";");if("clamped"===boundary[d])for(i=1-degree[d];i<=degree[d];i++)kvar=knotVar([d,i+degree[d]-1]),i<0&&line("if ("+kvar+" < "+degree[d]+") "+kvar+" = "+degree[d]+";"),i>0&&line("if ("+kvar+" > "+sizeVar(d)+") "+kvar+" = "+sizeVar(d)+";");"closed"===boundary[d]&&(debugLine("\n  // Wrap the B-Spline parameter for closed boundary"),line(tVar(d)+" %= "+sizeVar(d)+";"))}for(d=0,n=[];d<splineDimension;d++)n[d]=degree[d]+1;for(hasWeights&&(debugLine("\n  // Fetch weights\n"),ndloop(n,(function(dst){for(var readIdx=[],period=[],d=0;d<splineDimension;d++)readIdx[d]=[knotIndex(d),dst[d]-degree[d]],"closed"===boundary[d]&&dst[d]-degree[d]<0&&(period[d]=sizeVar(d));line("var "+weightVar(dst)+" = "+weightAccessor(readIdx,period)+";")}))),debug&&line(hasWeights?"\n  // Fetch points and project into homogeneous (weighted) coordinates\n":"\n  // Fetch points\n"),ndloop(n,(function(dst){for(var readIdx=[],period=[],d=0;d<splineDimension;d++)readIdx[d]=[knotIndex(d),dst[d]-degree[d]],"closed"===boundary[d]&&dst[d]-degree[d]<0&&(period[d]=sizeVar(d));if(isBasis)line(hasWeights?"var "+pointVar(dst)+" = "+pointAccessor(readIdx,period)+" * "+weightVar(dst)+";":"var "+pointVar(dst)+" = "+pointAccessor(readIdx,period)+";");else for(d=0;d<spaceDimension;d++){var dstWithDim=dst.concat(d);readIdx[splineDimension]=d,line(hasWeights?"var "+pointVar(dstWithDim)+" = "+pointAccessor(readIdx,period)+" * "+weightVar(dst)+";":"var "+pointVar(dstWithDim)+" = "+pointAccessor(readIdx,period)+";")}})),debugLine("\n"),debugLine("// Perform De Boor's algorithm"),d=n.length-1;d>=0;d--)for(n[d]=[degree[d],degree[d]+1],i=0;i<degree[d];i++)for(debugLine("\n  // Degree "+degree[d]+" evaluation in dimension "+d+", step "+(i+1)+"\n"),j=degree[d];j>i;j--){var isDerivative=derivative&&degree[d]-i-derivative[d]<=0;isDerivative?(line("m = 1 / ("+knotVar([d,j-i+degree[d]-1])+" - "+knotVar([d,j-1])+");"),hasWeights&&(line("a = ("+tVar(d)+" - "+knotVar([d,j-1])+") * m;"),line("b = 1 - a;"))):(line("a = ("+tVar(d)+" - "+knotVar([d,j-1])+") / ("+knotVar([d,j-i+degree[d]-1])+" - "+knotVar([d,j-1])+");"),line("b = 1 - a;")),hasWeights&&ndloop(n,(function(ii){var ij=ii.slice(),ij1=ii.slice();ij[d]=j,ij1[d]=j-1,isDerivative&&hasWeights&&line("h = "+weightVar(ij)+";"),line(weightVar(ij)+" = b * "+weightVar(ij1)+" + a * "+weightVar(ij)+";")})),ndloop(n,(function(ii){var weightFactor,pt1,pt2,ij=ii.slice(),ij1=ii.slice();if(ij[d]=j,ij1[d]=j-1,isDerivative){var derivCoeff=i+1;if(isBasis)weightFactor=hasWeights?"h * "+weightVar(ij1)+" / "+weightVar(ij)+" * ":"",pt1=pointVar(ij)+(hasWeights?" / h":""),pt2=pointVar(ij1)+(hasWeights?" / "+weightVar(ij1):""),line(pointVar(ij)+" = "+derivCoeff+" * "+weightFactor+"("+pt1+" - "+pt2+") * m;");else{var ijWithDimension=ij.slice(),ij1WithDimension=ij1.slice();for(m=0;m<spaceDimension;m++)ijWithDimension[splineDimension]=ij1WithDimension[splineDimension]=m,weightFactor=hasWeights?"h * "+weightVar(ij1)+" / "+weightVar(ij)+" * ":"",pt1=pointVar(ijWithDimension)+(hasWeights?" / h":""),pt2=pointVar(ij1WithDimension)+(hasWeights?" / "+weightVar(ij1):""),line(pointVar(ijWithDimension)+" = "+derivCoeff+" * "+weightFactor+"("+pt1+" - "+pt2+") * m;")}}else if(isBasis)line(pointVar(ij)+" = b * "+pointVar(ij1)+" + a * "+pointVar(ij)+";");else for(m=0;m<spaceDimension;m++)ij[splineDimension]=ij1[splineDimension]=m,line(pointVar(ij)+" = b * "+pointVar(ij1)+" + a * "+pointVar(ij)+";")})),debugLine("\n")}if(debug&&line(hasWeights?"\n  // Project back from homogeneous coordinates and return final output\n":"\n  // Return final output\n"),isBasis)line(hasWeights?"return "+pointVar(degree)+" / "+weightVar(degree)+";":"return "+pointVar(degree)+";");else for(d=0;d<spaceDimension;d++)line(hasWeights?"out["+d+"] = "+pointVar(degree.concat([d]))+" / "+weightVar(degree)+";":"out["+d+"] = "+pointVar(degree.concat([d]))+";");if(isBasis||line("return out;"),code.push("}"),debug){var codeStr=code.join("\n");logger(codeStr),codeCache[cacheKey]=codeStr}var evaluator=new Function([code.join("\n"),"; return ",functionName].join(""))();return evaluatorCache[cacheKey]=evaluator,evaluator.bind(nurbs)}},function(module,exports,__webpack_require__){"use strict";var transformerCache={},accessorPreamble=__webpack_require__(17),sizeGetter=__webpack_require__(18),variable=__webpack_require__(9);module.exports=function(cacheKey,nurbs,accessors,debug){var i,j,iterator,iterators,terms,n,rvalue,lvalue,cachedTransformer=transformerCache[cacheKey];if(cachedTransformer)return cachedTransformer.bind(nurbs);var code=[],functionName="transform"+cacheKey;code.push("function "+functionName+"(m) {"),code.push("var i, w;"),code.push(accessorPreamble(nurbs,"x","this.points",nurbs.points));var sizeVar=variable(debug?"size":"s");for(i=0;i<nurbs.splineDimension;i++)code.push("var "+sizeVar(i)+" = "+sizeGetter(nurbs.points,"this.points",i)+";");for(iterators=[],i=0;i<nurbs.splineDimension;i++)iterator="i"+i,iterators.push(iterator),code.push("for ("+iterator+" = "+sizeVar(i)+"- 1; "+iterator+" >= 0; "+iterator+"--) {");for(i=0;i<nurbs.dimension;i++)code.push("x"+i+" = "+accessors.point(iterators.concat([i])));for(terms=[],i=0;i<nurbs.dimension;i++)terms.push("m["+((nurbs.dimension+1)*(i+1)-1)+"] * x"+i);for(terms.push("m["+((nurbs.dimension+1)*(nurbs.dimension+1)-1)+"]"),code.push("var w = ("+terms.join(" + ")+") || 1.0;"),i=0;i<nurbs.dimension;i++){for(terms=[],n=nurbs.dimension,j=0;j<n;j++)terms.push("m["+(j*(n+1)+i)+"] * x"+j);terms.push("m["+(j*(n+1)+i)+"]"),lvalue=accessors.point(iterators.concat([i])),rvalue="("+terms.join(" + ")+") / w",code.push(lvalue+" = "+rvalue+";")}for(i=nurbs.splineDimension-1;i>=0;i--)code.push("}");code.push("return this;"),code.push("}");var transform=new Function([code.join("\n"),"; return ",functionName].join(""))();return debug&&console.log(code.join("\n")),transformerCache[cacheKey]=transform,transform.bind(nurbs)}},function(module,exports,__webpack_require__){"use strict";var ndloop=__webpack_require__(26),variable=__webpack_require__(9),accessorPreamble=__webpack_require__(17),inferType=__webpack_require__(4),isArrayLike=__webpack_require__(5),sizeGetter=__webpack_require__(18),supportCache={};module.exports=function(cacheKey,nurbs,accessors,debug,checkBounds){var cachedSupport=supportCache[cacheKey];if(cachedSupport)return cachedSupport.bind(nurbs);var i,n,d,degree=nurbs.degree,knots=nurbs.knots,splineDimension=nurbs.splineDimension,boundary=nurbs.boundary,code=[],functionName="support"+cacheKey,knotAccessor=accessors.knot,tVar=variable("t"),domainVar=debug?"domain":"d",sizeVar=variable(debug?"size":"s"),knotIndex=variable(debug?"knotIndex":"i"),allDimensionUniform=!0;for(d=0;d<splineDimension;d++)isArrayLike(knots)&&isArrayLike(knots[d])&&(allDimensionUniform=!1);function line(str){code.push("  "+(str||""))}var parameterArgs=[];for(i=0;i<splineDimension;i++)parameterArgs.push(tVar([i]));code.push("function "+functionName+" (out, "+parameterArgs.join(", ")+") {");var c=0;function pushSupport(args,period){line(void 0===period?"out["+c+++"] = "+args.join(" + ")+";":"out["+c+++"] = ("+args.join(" + ")+" + "+period+") % "+period+";")}for(line("var h, m;"),line("var c = 0;"),checkBounds&&(line("var "+domainVar+" = this.domain;"),line("for (var i = 0; i < this.splineDimension; i++) {"),line("  a = arguments[i + 1];"),line("  if (a < "+domainVar+"[i][0] || a > "+domainVar+"[i][1] || a === undefined || isNaN(a)) {"),line("    throw new Error('Invalid Spline parameter in dimension '+i+'. Valid domain is ['+"+domainVar+"[i][0]+', '+"+domainVar+"[i][1]+']. but got t'+i+' = '+arguments[i + 1]+'.');"),line("  }"),line("}")),d=0;d<splineDimension;d++)line("var "+sizeVar(d)+" = "+sizeGetter(nurbs.points,"this.points",d)+";");allDimensionUniform||code.push(accessorPreamble(nurbs,"k","this.knots",knots));var hasKnots=[];for(d=0;d<splineDimension;d++)switch(inferType(knots)){case inferType.NDARRAY:hasKnots[d]=!0;break;case inferType.ARRAY_OF_ARRAYS:hasKnots[d]=isArrayLike(knots[d])}for(d=0;d<splineDimension;d++)hasKnots[d]?(line("var "+knotIndex(d)+" = 0;"),line("h = "+sizeVar(d)+";"),line("while(h > "+knotIndex(d)+" + 1) {"),line("  m = 0.5 * (h + "+knotIndex(d)+") | 0;"),line("  if ("+knotAccessor([d,"m"])+" > "+tVar(d)+") h = m;"),line("  else "+knotIndex(d)+" = m;"),line("}")):"closed"===boundary[d]?line(knotIndex(d)+" = ("+tVar(d)+" | 0) % "+sizeVar(d)+";"):(line(knotIndex(d)+" = ("+tVar(d)+" | 0);"),line("if ("+knotIndex(d)+" < "+degree[d]+") "+knotIndex(d)+" = "+degree[d]+";"),line("if ("+knotIndex(d)+" > "+sizeVar(d)+" - 1) "+knotIndex(d)+" = "+sizeVar(d)+" - 1;"));for(d=0,n=[];d<splineDimension;d++)n[d]=degree[d]+1;ndloop(n,(function(dst){for(var readIdx=[],period=[],d=0;d<splineDimension;d++)readIdx[d]=[knotIndex(d),dst[d]-degree[d]],"closed"===boundary[d]&&dst[d]-degree[d]<0&&(period[d]=sizeVar(d));for(d=0;d<splineDimension;d++)pushSupport(readIdx[d],period[d])})),line("out.length = "+c+";"),line("return out;"),code.push("}"),debug&&console.log(code.join("\n"));var evaluator=new Function([code.join("\n"),"; return ",functionName].join(""))();return supportCache[cacheKey]=evaluator,evaluator.bind(nurbs)}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__),__webpack_require__.d(__webpack_exports__,"MODULE_VERSION",(function(){return MODULE_VERSION})),__webpack_require__.d(__webpack_exports__,"MODULE_NAME",(function(){return MODULE_NAME})),__webpack_require__.d(__webpack_exports__,"GeomWidget",(function(){return geom_GeomWidget})),__webpack_require__.d(__webpack_exports__,"rendererFactory",(function(){return rendererFactory})),__webpack_require__.d(__webpack_exports__,"PGLWidgetView",(function(){return widgets_PGLWidgetView})),__webpack_require__.d(__webpack_exports__,"SceneWidgetView",(function(){return widgets_SceneWidgetView})),__webpack_require__.d(__webpack_exports__,"LsystemWidgetView",(function(){return widgets_LsystemWidgetView})),__webpack_require__.d(__webpack_exports__,"ParameterEditorView",(function(){return editors_ParameterEditorView})),__webpack_require__.d(__webpack_exports__,"_EditorView",(function(){return editors_EditorView})),__webpack_require__.d(__webpack_exports__,"BoolEditorView",(function(){return BoolEditorView})),__webpack_require__.d(__webpack_exports__,"IntEditorView",(function(){return IntEditorView})),__webpack_require__.d(__webpack_exports__,"FloatEditorView",(function(){return FloatEditorView})),__webpack_require__.d(__webpack_exports__,"StringEditorView",(function(){return StringEditorView})),__webpack_require__.d(__webpack_exports__,"MaterialEditorView",(function(){return MaterialEditorView})),__webpack_require__.d(__webpack_exports__,"CurveEditorView",(function(){return CurveEditorView})),__webpack_require__.d(__webpack_exports__,"_CurveEditorView",(function(){return editors_CurveEditorView})),__webpack_require__.d(__webpack_exports__,"PGLWidgetModel",(function(){return models_PGLWidgetModel})),__webpack_require__.d(__webpack_exports__,"SceneWidgetModel",(function(){return models_SceneWidgetModel})),__webpack_require__.d(__webpack_exports__,"LsystemWidgetModel",(function(){return models_LsystemWidgetModel})),__webpack_require__.d(__webpack_exports__,"ParameterEditorModel",(function(){return models_ParameterEditorModel})),__webpack_require__.d(__webpack_exports__,"_EditorModel",(function(){return models_EditorModel})),__webpack_require__.d(__webpack_exports__,"BoolEditorModel",(function(){return BoolEditorModel})),__webpack_require__.d(__webpack_exports__,"IntEditorModel",(function(){return IntEditorModel})),__webpack_require__.d(__webpack_exports__,"FloatEditorModel",(function(){return FloatEditorModel})),__webpack_require__.d(__webpack_exports__,"StringEditorModel",(function(){return StringEditorModel})),__webpack_require__.d(__webpack_exports__,"MaterialEditorModel",(function(){return MaterialEditorModel})),__webpack_require__.d(__webpack_exports__,"CurveEditorModel",(function(){return CurveEditorModel})),__webpack_require__.d(__webpack_exports__,"_CurveEditorModel",(function(){return models_CurveEditorModel}));const version_data=__webpack_require__(75),MODULE_VERSION=version_data.version,MODULE_NAME=version_data.name;var widgets_=__webpack_require__(27);void 0===Number.EPSILON&&(Number.EPSILON=Math.pow(2,-52)),void 0===Number.isInteger&&(Number.isInteger=function(value){return"number"==typeof value&&isFinite(value)&&Math.floor(value)===value}),void 0===Math.sign&&(Math.sign=function(x){return x<0?-1:x>0?1:+x}),"name"in Function.prototype==!1&&Object.defineProperty(Function.prototype,"name",{get:function(){return this.toString().match(/^\s*function\s*([^\(\s]*)/)[1]}}),void 0===Object.assign&&(Object.assign=function(target){if(null==target)throw new TypeError("Cannot convert undefined or null to object");const output=Object(target);for(let index=1;index<arguments.length;index++){const source=arguments[index];if(null!=source)for(const nextKey in source)Object.prototype.hasOwnProperty.call(source,nextKey)&&(output[nextKey]=source[nextKey])}return output});const MOUSE_ROTATE=0,MOUSE_DOLLY=1,MOUSE_PAN=2,TOUCH_ROTATE=0,TOUCH_PAN=1,TOUCH_DOLLY_PAN=2,TOUCH_DOLLY_ROTATE=3;function EventDispatcher(){}Object.assign(EventDispatcher.prototype,{addEventListener:function(type,listener){void 0===this._listeners&&(this._listeners={});const listeners=this._listeners;void 0===listeners[type]&&(listeners[type]=[]),-1===listeners[type].indexOf(listener)&&listeners[type].push(listener)},hasEventListener:function(type,listener){if(void 0===this._listeners)return!1;const listeners=this._listeners;return void 0!==listeners[type]&&-1!==listeners[type].indexOf(listener)},removeEventListener:function(type,listener){if(void 0===this._listeners)return;const listenerArray=this._listeners[type];if(void 0!==listenerArray){const index=listenerArray.indexOf(listener);-1!==index&&listenerArray.splice(index,1)}},dispatchEvent:function(event){if(void 0===this._listeners)return;const listenerArray=this._listeners[event.type];if(void 0!==listenerArray){event.target=this;const array=listenerArray.slice(0);for(let i=0,l=array.length;i<l;i++)array[i].call(this,event)}}});const _lut=[];for(let i=0;i<256;i++)_lut[i]=(i<16?"0":"")+i.toString(16);let _seed=1234567;const MathUtils={DEG2RAD:Math.PI/180,RAD2DEG:180/Math.PI,generateUUID:function(){const d0=4294967295*Math.random()|0,d1=4294967295*Math.random()|0,d2=4294967295*Math.random()|0,d3=4294967295*Math.random()|0;return(_lut[255&d0]+_lut[d0>>8&255]+_lut[d0>>16&255]+_lut[d0>>24&255]+"-"+_lut[255&d1]+_lut[d1>>8&255]+"-"+_lut[d1>>16&15|64]+_lut[d1>>24&255]+"-"+_lut[63&d2|128]+_lut[d2>>8&255]+"-"+_lut[d2>>16&255]+_lut[d2>>24&255]+_lut[255&d3]+_lut[d3>>8&255]+_lut[d3>>16&255]+_lut[d3>>24&255]).toUpperCase()},clamp:function(value,min,max){return Math.max(min,Math.min(max,value))},euclideanModulo:function(n,m){return(n%m+m)%m},mapLinear:function(x,a1,a2,b1,b2){return b1+(x-a1)*(b2-b1)/(a2-a1)},lerp:function(x,y,t){return(1-t)*x+t*y},smoothstep:function(x,min,max){return x<=min?0:x>=max?1:(x=(x-min)/(max-min))*x*(3-2*x)},smootherstep:function(x,min,max){return x<=min?0:x>=max?1:(x=(x-min)/(max-min))*x*x*(x*(6*x-15)+10)},randInt:function(low,high){return low+Math.floor(Math.random()*(high-low+1))},randFloat:function(low,high){return low+Math.random()*(high-low)},randFloatSpread:function(range){return range*(.5-Math.random())},seededRandom:function(s){return void 0!==s&&(_seed=s%2147483647),_seed=16807*_seed%2147483647,(_seed-1)/2147483646},degToRad:function(degrees){return degrees*MathUtils.DEG2RAD},radToDeg:function(radians){return radians*MathUtils.RAD2DEG},isPowerOfTwo:function(value){return 0==(value&value-1)&&0!==value},ceilPowerOfTwo:function(value){return Math.pow(2,Math.ceil(Math.log(value)/Math.LN2))},floorPowerOfTwo:function(value){return Math.pow(2,Math.floor(Math.log(value)/Math.LN2))},setQuaternionFromProperEuler:function(q,a,b,c,order){const cos=Math.cos,sin=Math.sin,c2=cos(b/2),s2=sin(b/2),c13=cos((a+c)/2),s13=sin((a+c)/2),c1_3=cos((a-c)/2),s1_3=sin((a-c)/2),c3_1=cos((c-a)/2),s3_1=sin((c-a)/2);switch(order){case"XYX":q.set(c2*s13,s2*c1_3,s2*s1_3,c2*c13);break;case"YZY":q.set(s2*s1_3,c2*s13,s2*c1_3,c2*c13);break;case"ZXZ":q.set(s2*c1_3,s2*s1_3,c2*s13,c2*c13);break;case"XZX":q.set(c2*s13,s2*s3_1,s2*c3_1,c2*c13);break;case"YXY":q.set(s2*c3_1,c2*s13,s2*s3_1,c2*c13);break;case"ZYZ":q.set(s2*s3_1,s2*c3_1,c2*s13,c2*c13);break;default:console.warn("THREE.MathUtils: .setQuaternionFromProperEuler() encountered an unknown order: "+order)}}};function Vector2(x=0,y=0){this.x=x,this.y=y}function Matrix3(){this.elements=[1,0,0,0,1,0,0,0,1],arguments.length>0&&console.error("THREE.Matrix3: the constructor no longer reads arguments. use .set() instead.")}let _canvas;Object.defineProperties(Vector2.prototype,{width:{get:function(){return this.x},set:function(value){this.x=value}},height:{get:function(){return this.y},set:function(value){this.y=value}}}),Object.assign(Vector2.prototype,{isVector2:!0,set:function(x,y){return this.x=x,this.y=y,this},setScalar:function(scalar){return this.x=scalar,this.y=scalar,this},setX:function(x){return this.x=x,this},setY:function(y){return this.y=y,this},setComponent:function(index,value){switch(index){case 0:this.x=value;break;case 1:this.y=value;break;default:throw new Error("index is out of range: "+index)}return this},getComponent:function(index){switch(index){case 0:return this.x;case 1:return this.y;default:throw new Error("index is out of range: "+index)}},clone:function(){return new this.constructor(this.x,this.y)},copy:function(v){return this.x=v.x,this.y=v.y,this},add:function(v,w){return void 0!==w?(console.warn("THREE.Vector2: .add() now only accepts one argument. Use .addVectors( a, b ) instead."),this.addVectors(v,w)):(this.x+=v.x,this.y+=v.y,this)},addScalar:function(s){return this.x+=s,this.y+=s,this},addVectors:function(a,b){return this.x=a.x+b.x,this.y=a.y+b.y,this},addScaledVector:function(v,s){return this.x+=v.x*s,this.y+=v.y*s,this},sub:function(v,w){return void 0!==w?(console.warn("THREE.Vector2: .sub() now only accepts one argument. Use .subVectors( a, b ) instead."),this.subVectors(v,w)):(this.x-=v.x,this.y-=v.y,this)},subScalar:function(s){return this.x-=s,this.y-=s,this},subVectors:function(a,b){return this.x=a.x-b.x,this.y=a.y-b.y,this},multiply:function(v){return this.x*=v.x,this.y*=v.y,this},multiplyScalar:function(scalar){return this.x*=scalar,this.y*=scalar,this},divide:function(v){return this.x/=v.x,this.y/=v.y,this},divideScalar:function(scalar){return this.multiplyScalar(1/scalar)},applyMatrix3:function(m){const x=this.x,y=this.y,e=m.elements;return this.x=e[0]*x+e[3]*y+e[6],this.y=e[1]*x+e[4]*y+e[7],this},min:function(v){return this.x=Math.min(this.x,v.x),this.y=Math.min(this.y,v.y),this},max:function(v){return this.x=Math.max(this.x,v.x),this.y=Math.max(this.y,v.y),this},clamp:function(min,max){return this.x=Math.max(min.x,Math.min(max.x,this.x)),this.y=Math.max(min.y,Math.min(max.y,this.y)),this},clampScalar:function(minVal,maxVal){return this.x=Math.max(minVal,Math.min(maxVal,this.x)),this.y=Math.max(minVal,Math.min(maxVal,this.y)),this},clampLength:function(min,max){const length=this.length();return this.divideScalar(length||1).multiplyScalar(Math.max(min,Math.min(max,length)))},floor:function(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this},ceil:function(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this},round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this},roundToZero:function(){return this.x=this.x<0?Math.ceil(this.x):Math.floor(this.x),this.y=this.y<0?Math.ceil(this.y):Math.floor(this.y),this},negate:function(){return this.x=-this.x,this.y=-this.y,this},dot:function(v){return this.x*v.x+this.y*v.y},cross:function(v){return this.x*v.y-this.y*v.x},lengthSq:function(){return this.x*this.x+this.y*this.y},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},manhattanLength:function(){return Math.abs(this.x)+Math.abs(this.y)},normalize:function(){return this.divideScalar(this.length()||1)},angle:function(){return Math.atan2(-this.y,-this.x)+Math.PI},distanceTo:function(v){return Math.sqrt(this.distanceToSquared(v))},distanceToSquared:function(v){const dx=this.x-v.x,dy=this.y-v.y;return dx*dx+dy*dy},manhattanDistanceTo:function(v){return Math.abs(this.x-v.x)+Math.abs(this.y-v.y)},setLength:function(length){return this.normalize().multiplyScalar(length)},lerp:function(v,alpha){return this.x+=(v.x-this.x)*alpha,this.y+=(v.y-this.y)*alpha,this},lerpVectors:function(v1,v2,alpha){return this.x=v1.x+(v2.x-v1.x)*alpha,this.y=v1.y+(v2.y-v1.y)*alpha,this},equals:function(v){return v.x===this.x&&v.y===this.y},fromArray:function(array,offset){return void 0===offset&&(offset=0),this.x=array[offset],this.y=array[offset+1],this},toArray:function(array,offset){return void 0===array&&(array=[]),void 0===offset&&(offset=0),array[offset]=this.x,array[offset+1]=this.y,array},fromBufferAttribute:function(attribute,index,offset){return void 0!==offset&&console.warn("THREE.Vector2: offset has been removed from .fromBufferAttribute()."),this.x=attribute.getX(index),this.y=attribute.getY(index),this},rotateAround:function(center,angle){const c=Math.cos(angle),s=Math.sin(angle),x=this.x-center.x,y=this.y-center.y;return this.x=x*c-y*s+center.x,this.y=x*s+y*c+center.y,this},random:function(){return this.x=Math.random(),this.y=Math.random(),this}}),Object.assign(Matrix3.prototype,{isMatrix3:!0,set:function(n11,n12,n13,n21,n22,n23,n31,n32,n33){const te=this.elements;return te[0]=n11,te[1]=n21,te[2]=n31,te[3]=n12,te[4]=n22,te[5]=n32,te[6]=n13,te[7]=n23,te[8]=n33,this},identity:function(){return this.set(1,0,0,0,1,0,0,0,1),this},clone:function(){return(new this.constructor).fromArray(this.elements)},copy:function(m){const te=this.elements,me=m.elements;return te[0]=me[0],te[1]=me[1],te[2]=me[2],te[3]=me[3],te[4]=me[4],te[5]=me[5],te[6]=me[6],te[7]=me[7],te[8]=me[8],this},extractBasis:function(xAxis,yAxis,zAxis){return xAxis.setFromMatrix3Column(this,0),yAxis.setFromMatrix3Column(this,1),zAxis.setFromMatrix3Column(this,2),this},setFromMatrix4:function(m){const me=m.elements;return this.set(me[0],me[4],me[8],me[1],me[5],me[9],me[2],me[6],me[10]),this},multiply:function(m){return this.multiplyMatrices(this,m)},premultiply:function(m){return this.multiplyMatrices(m,this)},multiplyMatrices:function(a,b){const ae=a.elements,be=b.elements,te=this.elements,a11=ae[0],a12=ae[3],a13=ae[6],a21=ae[1],a22=ae[4],a23=ae[7],a31=ae[2],a32=ae[5],a33=ae[8],b11=be[0],b12=be[3],b13=be[6],b21=be[1],b22=be[4],b23=be[7],b31=be[2],b32=be[5],b33=be[8];return te[0]=a11*b11+a12*b21+a13*b31,te[3]=a11*b12+a12*b22+a13*b32,te[6]=a11*b13+a12*b23+a13*b33,te[1]=a21*b11+a22*b21+a23*b31,te[4]=a21*b12+a22*b22+a23*b32,te[7]=a21*b13+a22*b23+a23*b33,te[2]=a31*b11+a32*b21+a33*b31,te[5]=a31*b12+a32*b22+a33*b32,te[8]=a31*b13+a32*b23+a33*b33,this},multiplyScalar:function(s){const te=this.elements;return te[0]*=s,te[3]*=s,te[6]*=s,te[1]*=s,te[4]*=s,te[7]*=s,te[2]*=s,te[5]*=s,te[8]*=s,this},determinant:function(){const te=this.elements,a=te[0],b=te[1],c=te[2],d=te[3],e=te[4],f=te[5],g=te[6],h=te[7],i=te[8];return a*e*i-a*f*h-b*d*i+b*f*g+c*d*h-c*e*g},getInverse:function(matrix,throwOnDegenerate){void 0!==throwOnDegenerate&&console.warn("THREE.Matrix3: .getInverse() can no longer be configured to throw on degenerate.");const me=matrix.elements,te=this.elements,n11=me[0],n21=me[1],n31=me[2],n12=me[3],n22=me[4],n32=me[5],n13=me[6],n23=me[7],n33=me[8],t11=n33*n22-n32*n23,t12=n32*n13-n33*n12,t13=n23*n12-n22*n13,det=n11*t11+n21*t12+n31*t13;if(0===det)return this.set(0,0,0,0,0,0,0,0,0);const detInv=1/det;return te[0]=t11*detInv,te[1]=(n31*n23-n33*n21)*detInv,te[2]=(n32*n21-n31*n22)*detInv,te[3]=t12*detInv,te[4]=(n33*n11-n31*n13)*detInv,te[5]=(n31*n12-n32*n11)*detInv,te[6]=t13*detInv,te[7]=(n21*n13-n23*n11)*detInv,te[8]=(n22*n11-n21*n12)*detInv,this},transpose:function(){let tmp;const m=this.elements;return tmp=m[1],m[1]=m[3],m[3]=tmp,tmp=m[2],m[2]=m[6],m[6]=tmp,tmp=m[5],m[5]=m[7],m[7]=tmp,this},getNormalMatrix:function(matrix4){return this.setFromMatrix4(matrix4).getInverse(this).transpose()},transposeIntoArray:function(r){const m=this.elements;return r[0]=m[0],r[1]=m[3],r[2]=m[6],r[3]=m[1],r[4]=m[4],r[5]=m[7],r[6]=m[2],r[7]=m[5],r[8]=m[8],this},setUvTransform:function(tx,ty,sx,sy,rotation,cx,cy){const c=Math.cos(rotation),s=Math.sin(rotation);this.set(sx*c,sx*s,-sx*(c*cx+s*cy)+cx+tx,-sy*s,sy*c,-sy*(-s*cx+c*cy)+cy+ty,0,0,1)},scale:function(sx,sy){const te=this.elements;return te[0]*=sx,te[3]*=sx,te[6]*=sx,te[1]*=sy,te[4]*=sy,te[7]*=sy,this},rotate:function(theta){const c=Math.cos(theta),s=Math.sin(theta),te=this.elements,a11=te[0],a12=te[3],a13=te[6],a21=te[1],a22=te[4],a23=te[7];return te[0]=c*a11+s*a21,te[3]=c*a12+s*a22,te[6]=c*a13+s*a23,te[1]=-s*a11+c*a21,te[4]=-s*a12+c*a22,te[7]=-s*a13+c*a23,this},translate:function(tx,ty){const te=this.elements;return te[0]+=tx*te[2],te[3]+=tx*te[5],te[6]+=tx*te[8],te[1]+=ty*te[2],te[4]+=ty*te[5],te[7]+=ty*te[8],this},equals:function(matrix){const te=this.elements,me=matrix.elements;for(let i=0;i<9;i++)if(te[i]!==me[i])return!1;return!0},fromArray:function(array,offset){void 0===offset&&(offset=0);for(let i=0;i<9;i++)this.elements[i]=array[i+offset];return this},toArray:function(array,offset){void 0===array&&(array=[]),void 0===offset&&(offset=0);const te=this.elements;return array[offset]=te[0],array[offset+1]=te[1],array[offset+2]=te[2],array[offset+3]=te[3],array[offset+4]=te[4],array[offset+5]=te[5],array[offset+6]=te[6],array[offset+7]=te[7],array[offset+8]=te[8],array}});const ImageUtils={getDataURL:function(image){if(/^data:/i.test(image.src))return image.src;if("undefined"==typeof HTMLCanvasElement)return image.src;let canvas;if(image instanceof HTMLCanvasElement)canvas=image;else{void 0===_canvas&&(_canvas=document.createElementNS("http://www.w3.org/1999/xhtml","canvas")),_canvas.width=image.width,_canvas.height=image.height;const context=_canvas.getContext("2d");image instanceof ImageData?context.putImageData(image,0,0):context.drawImage(image,0,0,image.width,image.height),canvas=_canvas}return canvas.width>2048||canvas.height>2048?canvas.toDataURL("image/jpeg",.6):canvas.toDataURL("image/png")}};let textureId=0;function Texture(image,mapping,wrapS,wrapT,magFilter,minFilter,format,type,anisotropy,encoding){Object.defineProperty(this,"id",{value:textureId++}),this.uuid=MathUtils.generateUUID(),this.name="",this.image=void 0!==image?image:Texture.DEFAULT_IMAGE,this.mipmaps=[],this.mapping=void 0!==mapping?mapping:Texture.DEFAULT_MAPPING,this.wrapS=void 0!==wrapS?wrapS:1001,this.wrapT=void 0!==wrapT?wrapT:1001,this.magFilter=void 0!==magFilter?magFilter:1006,this.minFilter=void 0!==minFilter?minFilter:1008,this.anisotropy=void 0!==anisotropy?anisotropy:1,this.format=void 0!==format?format:1023,this.internalFormat=null,this.type=void 0!==type?type:1009,this.offset=new Vector2(0,0),this.repeat=new Vector2(1,1),this.center=new Vector2(0,0),this.rotation=0,this.matrixAutoUpdate=!0,this.matrix=new Matrix3,this.generateMipmaps=!0,this.premultiplyAlpha=!1,this.flipY=!0,this.unpackAlignment=4,this.encoding=void 0!==encoding?encoding:3e3,this.version=0,this.onUpdate=null}function Vector4(x=0,y=0,z=0,w=1){this.x=x,this.y=y,this.z=z,this.w=w}function WebGLRenderTarget(width,height,options){this.width=width,this.height=height,this.scissor=new Vector4(0,0,width,height),this.scissorTest=!1,this.viewport=new Vector4(0,0,width,height),options=options||{},this.texture=new Texture(void 0,options.mapping,options.wrapS,options.wrapT,options.magFilter,options.minFilter,options.format,options.type,options.anisotropy,options.encoding),this.texture.image={},this.texture.image.width=width,this.texture.image.height=height,this.texture.generateMipmaps=void 0!==options.generateMipmaps&&options.generateMipmaps,this.texture.minFilter=void 0!==options.minFilter?options.minFilter:1006,this.depthBuffer=void 0===options.depthBuffer||options.depthBuffer,this.stencilBuffer=void 0===options.stencilBuffer||options.stencilBuffer,this.depthTexture=void 0!==options.depthTexture?options.depthTexture:null}function WebGLMultisampleRenderTarget(width,height,options){WebGLRenderTarget.call(this,width,height,options),this.samples=4}function Quaternion(x=0,y=0,z=0,w=1){this._x=x,this._y=y,this._z=z,this._w=w}Texture.DEFAULT_IMAGE=void 0,Texture.DEFAULT_MAPPING=300,Texture.prototype=Object.assign(Object.create(EventDispatcher.prototype),{constructor:Texture,isTexture:!0,updateMatrix:function(){this.matrix.setUvTransform(this.offset.x,this.offset.y,this.repeat.x,this.repeat.y,this.rotation,this.center.x,this.center.y)},clone:function(){return(new this.constructor).copy(this)},copy:function(source){return this.name=source.name,this.image=source.image,this.mipmaps=source.mipmaps.slice(0),this.mapping=source.mapping,this.wrapS=source.wrapS,this.wrapT=source.wrapT,this.magFilter=source.magFilter,this.minFilter=source.minFilter,this.anisotropy=source.anisotropy,this.format=source.format,this.internalFormat=source.internalFormat,this.type=source.type,this.offset.copy(source.offset),this.repeat.copy(source.repeat),this.center.copy(source.center),this.rotation=source.rotation,this.matrixAutoUpdate=source.matrixAutoUpdate,this.matrix.copy(source.matrix),this.generateMipmaps=source.generateMipmaps,this.premultiplyAlpha=source.premultiplyAlpha,this.flipY=source.flipY,this.unpackAlignment=source.unpackAlignment,this.encoding=source.encoding,this},toJSON:function(meta){const isRootObject=void 0===meta||"string"==typeof meta;if(!isRootObject&&void 0!==meta.textures[this.uuid])return meta.textures[this.uuid];const output={metadata:{version:4.5,type:"Texture",generator:"Texture.toJSON"},uuid:this.uuid,name:this.name,mapping:this.mapping,repeat:[this.repeat.x,this.repeat.y],offset:[this.offset.x,this.offset.y],center:[this.center.x,this.center.y],rotation:this.rotation,wrap:[this.wrapS,this.wrapT],format:this.format,type:this.type,encoding:this.encoding,minFilter:this.minFilter,magFilter:this.magFilter,anisotropy:this.anisotropy,flipY:this.flipY,premultiplyAlpha:this.premultiplyAlpha,unpackAlignment:this.unpackAlignment};if(void 0!==this.image){const image=this.image;if(void 0===image.uuid&&(image.uuid=MathUtils.generateUUID()),!isRootObject&&void 0===meta.images[image.uuid]){let url;if(Array.isArray(image)){url=[];for(let i=0,l=image.length;i<l;i++)url.push(ImageUtils.getDataURL(image[i]))}else url=ImageUtils.getDataURL(image);meta.images[image.uuid]={uuid:image.uuid,url}}output.image=image.uuid}return isRootObject||(meta.textures[this.uuid]=output),output},dispose:function(){this.dispatchEvent({type:"dispose"})},transformUv:function(uv){if(300!==this.mapping)return uv;if(uv.applyMatrix3(this.matrix),uv.x<0||uv.x>1)switch(this.wrapS){case 1e3:uv.x=uv.x-Math.floor(uv.x);break;case 1001:uv.x=uv.x<0?0:1;break;case 1002:1===Math.abs(Math.floor(uv.x)%2)?uv.x=Math.ceil(uv.x)-uv.x:uv.x=uv.x-Math.floor(uv.x)}if(uv.y<0||uv.y>1)switch(this.wrapT){case 1e3:uv.y=uv.y-Math.floor(uv.y);break;case 1001:uv.y=uv.y<0?0:1;break;case 1002:1===Math.abs(Math.floor(uv.y)%2)?uv.y=Math.ceil(uv.y)-uv.y:uv.y=uv.y-Math.floor(uv.y)}return this.flipY&&(uv.y=1-uv.y),uv}}),Object.defineProperty(Texture.prototype,"needsUpdate",{set:function(value){!0===value&&this.version++}}),Object.defineProperties(Vector4.prototype,{width:{get:function(){return this.z},set:function(value){this.z=value}},height:{get:function(){return this.w},set:function(value){this.w=value}}}),Object.assign(Vector4.prototype,{isVector4:!0,set:function(x,y,z,w){return this.x=x,this.y=y,this.z=z,this.w=w,this},setScalar:function(scalar){return this.x=scalar,this.y=scalar,this.z=scalar,this.w=scalar,this},setX:function(x){return this.x=x,this},setY:function(y){return this.y=y,this},setZ:function(z){return this.z=z,this},setW:function(w){return this.w=w,this},setComponent:function(index,value){switch(index){case 0:this.x=value;break;case 1:this.y=value;break;case 2:this.z=value;break;case 3:this.w=value;break;default:throw new Error("index is out of range: "+index)}return this},getComponent:function(index){switch(index){case 0:return this.x;case 1:return this.y;case 2:return this.z;case 3:return this.w;default:throw new Error("index is out of range: "+index)}},clone:function(){return new this.constructor(this.x,this.y,this.z,this.w)},copy:function(v){return this.x=v.x,this.y=v.y,this.z=v.z,this.w=void 0!==v.w?v.w:1,this},add:function(v,w){return void 0!==w?(console.warn("THREE.Vector4: .add() now only accepts one argument. Use .addVectors( a, b ) instead."),this.addVectors(v,w)):(this.x+=v.x,this.y+=v.y,this.z+=v.z,this.w+=v.w,this)},addScalar:function(s){return this.x+=s,this.y+=s,this.z+=s,this.w+=s,this},addVectors:function(a,b){return this.x=a.x+b.x,this.y=a.y+b.y,this.z=a.z+b.z,this.w=a.w+b.w,this},addScaledVector:function(v,s){return this.x+=v.x*s,this.y+=v.y*s,this.z+=v.z*s,this.w+=v.w*s,this},sub:function(v,w){return void 0!==w?(console.warn("THREE.Vector4: .sub() now only accepts one argument. Use .subVectors( a, b ) instead."),this.subVectors(v,w)):(this.x-=v.x,this.y-=v.y,this.z-=v.z,this.w-=v.w,this)},subScalar:function(s){return this.x-=s,this.y-=s,this.z-=s,this.w-=s,this},subVectors:function(a,b){return this.x=a.x-b.x,this.y=a.y-b.y,this.z=a.z-b.z,this.w=a.w-b.w,this},multiplyScalar:function(scalar){return this.x*=scalar,this.y*=scalar,this.z*=scalar,this.w*=scalar,this},applyMatrix4:function(m){const x=this.x,y=this.y,z=this.z,w=this.w,e=m.elements;return this.x=e[0]*x+e[4]*y+e[8]*z+e[12]*w,this.y=e[1]*x+e[5]*y+e[9]*z+e[13]*w,this.z=e[2]*x+e[6]*y+e[10]*z+e[14]*w,this.w=e[3]*x+e[7]*y+e[11]*z+e[15]*w,this},divideScalar:function(scalar){return this.multiplyScalar(1/scalar)},setAxisAngleFromQuaternion:function(q){this.w=2*Math.acos(q.w);const s=Math.sqrt(1-q.w*q.w);return s<1e-4?(this.x=1,this.y=0,this.z=0):(this.x=q.x/s,this.y=q.y/s,this.z=q.z/s),this},setAxisAngleFromRotationMatrix:function(m){let angle,x,y,z;const te=m.elements,m11=te[0],m12=te[4],m13=te[8],m21=te[1],m22=te[5],m23=te[9],m31=te[2],m32=te[6],m33=te[10];if(Math.abs(m12-m21)<.01&&Math.abs(m13-m31)<.01&&Math.abs(m23-m32)<.01){if(Math.abs(m12+m21)<.1&&Math.abs(m13+m31)<.1&&Math.abs(m23+m32)<.1&&Math.abs(m11+m22+m33-3)<.1)return this.set(1,0,0,0),this;angle=Math.PI;const xx=(m11+1)/2,yy=(m22+1)/2,zz=(m33+1)/2,xy=(m12+m21)/4,xz=(m13+m31)/4,yz=(m23+m32)/4;return xx>yy&&xx>zz?xx<.01?(x=0,y=.707106781,z=.707106781):(x=Math.sqrt(xx),y=xy/x,z=xz/x):yy>zz?yy<.01?(x=.707106781,y=0,z=.707106781):(y=Math.sqrt(yy),x=xy/y,z=yz/y):zz<.01?(x=.707106781,y=.707106781,z=0):(z=Math.sqrt(zz),x=xz/z,y=yz/z),this.set(x,y,z,angle),this}let s=Math.sqrt((m32-m23)*(m32-m23)+(m13-m31)*(m13-m31)+(m21-m12)*(m21-m12));return Math.abs(s)<.001&&(s=1),this.x=(m32-m23)/s,this.y=(m13-m31)/s,this.z=(m21-m12)/s,this.w=Math.acos((m11+m22+m33-1)/2),this},min:function(v){return this.x=Math.min(this.x,v.x),this.y=Math.min(this.y,v.y),this.z=Math.min(this.z,v.z),this.w=Math.min(this.w,v.w),this},max:function(v){return this.x=Math.max(this.x,v.x),this.y=Math.max(this.y,v.y),this.z=Math.max(this.z,v.z),this.w=Math.max(this.w,v.w),this},clamp:function(min,max){return this.x=Math.max(min.x,Math.min(max.x,this.x)),this.y=Math.max(min.y,Math.min(max.y,this.y)),this.z=Math.max(min.z,Math.min(max.z,this.z)),this.w=Math.max(min.w,Math.min(max.w,this.w)),this},clampScalar:function(minVal,maxVal){return this.x=Math.max(minVal,Math.min(maxVal,this.x)),this.y=Math.max(minVal,Math.min(maxVal,this.y)),this.z=Math.max(minVal,Math.min(maxVal,this.z)),this.w=Math.max(minVal,Math.min(maxVal,this.w)),this},clampLength:function(min,max){const length=this.length();return this.divideScalar(length||1).multiplyScalar(Math.max(min,Math.min(max,length)))},floor:function(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this.z=Math.floor(this.z),this.w=Math.floor(this.w),this},ceil:function(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this.z=Math.ceil(this.z),this.w=Math.ceil(this.w),this},round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this.z=Math.round(this.z),this.w=Math.round(this.w),this},roundToZero:function(){return this.x=this.x<0?Math.ceil(this.x):Math.floor(this.x),this.y=this.y<0?Math.ceil(this.y):Math.floor(this.y),this.z=this.z<0?Math.ceil(this.z):Math.floor(this.z),this.w=this.w<0?Math.ceil(this.w):Math.floor(this.w),this},negate:function(){return this.x=-this.x,this.y=-this.y,this.z=-this.z,this.w=-this.w,this},dot:function(v){return this.x*v.x+this.y*v.y+this.z*v.z+this.w*v.w},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},manhattanLength:function(){return Math.abs(this.x)+Math.abs(this.y)+Math.abs(this.z)+Math.abs(this.w)},normalize:function(){return this.divideScalar(this.length()||1)},setLength:function(length){return this.normalize().multiplyScalar(length)},lerp:function(v,alpha){return this.x+=(v.x-this.x)*alpha,this.y+=(v.y-this.y)*alpha,this.z+=(v.z-this.z)*alpha,this.w+=(v.w-this.w)*alpha,this},lerpVectors:function(v1,v2,alpha){return this.x=v1.x+(v2.x-v1.x)*alpha,this.y=v1.y+(v2.y-v1.y)*alpha,this.z=v1.z+(v2.z-v1.z)*alpha,this.w=v1.w+(v2.w-v1.w)*alpha,this},equals:function(v){return v.x===this.x&&v.y===this.y&&v.z===this.z&&v.w===this.w},fromArray:function(array,offset){return void 0===offset&&(offset=0),this.x=array[offset],this.y=array[offset+1],this.z=array[offset+2],this.w=array[offset+3],this},toArray:function(array,offset){return void 0===array&&(array=[]),void 0===offset&&(offset=0),array[offset]=this.x,array[offset+1]=this.y,array[offset+2]=this.z,array[offset+3]=this.w,array},fromBufferAttribute:function(attribute,index,offset){return void 0!==offset&&console.warn("THREE.Vector4: offset has been removed from .fromBufferAttribute()."),this.x=attribute.getX(index),this.y=attribute.getY(index),this.z=attribute.getZ(index),this.w=attribute.getW(index),this},random:function(){return this.x=Math.random(),this.y=Math.random(),this.z=Math.random(),this.w=Math.random(),this}}),WebGLRenderTarget.prototype=Object.assign(Object.create(EventDispatcher.prototype),{constructor:WebGLRenderTarget,isWebGLRenderTarget:!0,setSize:function(width,height){this.width===width&&this.height===height||(this.width=width,this.height=height,this.texture.image.width=width,this.texture.image.height=height,this.dispose()),this.viewport.set(0,0,width,height),this.scissor.set(0,0,width,height)},clone:function(){return(new this.constructor).copy(this)},copy:function(source){return this.width=source.width,this.height=source.height,this.viewport.copy(source.viewport),this.texture=source.texture.clone(),this.depthBuffer=source.depthBuffer,this.stencilBuffer=source.stencilBuffer,this.depthTexture=source.depthTexture,this},dispose:function(){this.dispatchEvent({type:"dispose"})}}),WebGLMultisampleRenderTarget.prototype=Object.assign(Object.create(WebGLRenderTarget.prototype),{constructor:WebGLMultisampleRenderTarget,isWebGLMultisampleRenderTarget:!0,copy:function(source){return WebGLRenderTarget.prototype.copy.call(this,source),this.samples=source.samples,this}}),Object.assign(Quaternion,{slerp:function(qa,qb,qm,t){return qm.copy(qa).slerp(qb,t)},slerpFlat:function(dst,dstOffset,src0,srcOffset0,src1,srcOffset1,t){let x0=src0[srcOffset0+0],y0=src0[srcOffset0+1],z0=src0[srcOffset0+2],w0=src0[srcOffset0+3];const x1=src1[srcOffset1+0],y1=src1[srcOffset1+1],z1=src1[srcOffset1+2],w1=src1[srcOffset1+3];if(w0!==w1||x0!==x1||y0!==y1||z0!==z1){let s=1-t,cos=x0*x1+y0*y1+z0*z1+w0*w1,dir=cos>=0?1:-1,sqrSin=1-cos*cos;if(sqrSin>Number.EPSILON){const sin=Math.sqrt(sqrSin),len=Math.atan2(sin,cos*dir);s=Math.sin(s*len)/sin,t=Math.sin(t*len)/sin}const tDir=t*dir;if(x0=x0*s+x1*tDir,y0=y0*s+y1*tDir,z0=z0*s+z1*tDir,w0=w0*s+w1*tDir,s===1-t){const f=1/Math.sqrt(x0*x0+y0*y0+z0*z0+w0*w0);x0*=f,y0*=f,z0*=f,w0*=f}}dst[dstOffset]=x0,dst[dstOffset+1]=y0,dst[dstOffset+2]=z0,dst[dstOffset+3]=w0},multiplyQuaternionsFlat:function(dst,dstOffset,src0,srcOffset0,src1,srcOffset1){const x0=src0[srcOffset0],y0=src0[srcOffset0+1],z0=src0[srcOffset0+2],w0=src0[srcOffset0+3],x1=src1[srcOffset1],y1=src1[srcOffset1+1],z1=src1[srcOffset1+2],w1=src1[srcOffset1+3];return dst[dstOffset]=x0*w1+w0*x1+y0*z1-z0*y1,dst[dstOffset+1]=y0*w1+w0*y1+z0*x1-x0*z1,dst[dstOffset+2]=z0*w1+w0*z1+x0*y1-y0*x1,dst[dstOffset+3]=w0*w1-x0*x1-y0*y1-z0*z1,dst}}),Object.defineProperties(Quaternion.prototype,{x:{get:function(){return this._x},set:function(value){this._x=value,this._onChangeCallback()}},y:{get:function(){return this._y},set:function(value){this._y=value,this._onChangeCallback()}},z:{get:function(){return this._z},set:function(value){this._z=value,this._onChangeCallback()}},w:{get:function(){return this._w},set:function(value){this._w=value,this._onChangeCallback()}}}),Object.assign(Quaternion.prototype,{isQuaternion:!0,set:function(x,y,z,w){return this._x=x,this._y=y,this._z=z,this._w=w,this._onChangeCallback(),this},clone:function(){return new this.constructor(this._x,this._y,this._z,this._w)},copy:function(quaternion){return this._x=quaternion.x,this._y=quaternion.y,this._z=quaternion.z,this._w=quaternion.w,this._onChangeCallback(),this},setFromEuler:function(euler,update){if(!euler||!euler.isEuler)throw new Error("THREE.Quaternion: .setFromEuler() now expects an Euler rotation rather than a Vector3 and order.");const x=euler._x,y=euler._y,z=euler._z,order=euler.order,cos=Math.cos,sin=Math.sin,c1=cos(x/2),c2=cos(y/2),c3=cos(z/2),s1=sin(x/2),s2=sin(y/2),s3=sin(z/2);switch(order){case"XYZ":this._x=s1*c2*c3+c1*s2*s3,this._y=c1*s2*c3-s1*c2*s3,this._z=c1*c2*s3+s1*s2*c3,this._w=c1*c2*c3-s1*s2*s3;break;case"YXZ":this._x=s1*c2*c3+c1*s2*s3,this._y=c1*s2*c3-s1*c2*s3,this._z=c1*c2*s3-s1*s2*c3,this._w=c1*c2*c3+s1*s2*s3;break;case"ZXY":this._x=s1*c2*c3-c1*s2*s3,this._y=c1*s2*c3+s1*c2*s3,this._z=c1*c2*s3+s1*s2*c3,this._w=c1*c2*c3-s1*s2*s3;break;case"ZYX":this._x=s1*c2*c3-c1*s2*s3,this._y=c1*s2*c3+s1*c2*s3,this._z=c1*c2*s3-s1*s2*c3,this._w=c1*c2*c3+s1*s2*s3;break;case"YZX":this._x=s1*c2*c3+c1*s2*s3,this._y=c1*s2*c3+s1*c2*s3,this._z=c1*c2*s3-s1*s2*c3,this._w=c1*c2*c3-s1*s2*s3;break;case"XZY":this._x=s1*c2*c3-c1*s2*s3,this._y=c1*s2*c3-s1*c2*s3,this._z=c1*c2*s3+s1*s2*c3,this._w=c1*c2*c3+s1*s2*s3;break;default:console.warn("THREE.Quaternion: .setFromEuler() encountered an unknown order: "+order)}return!1!==update&&this._onChangeCallback(),this},setFromAxisAngle:function(axis,angle){const halfAngle=angle/2,s=Math.sin(halfAngle);return this._x=axis.x*s,this._y=axis.y*s,this._z=axis.z*s,this._w=Math.cos(halfAngle),this._onChangeCallback(),this},setFromRotationMatrix:function(m){const te=m.elements,m11=te[0],m12=te[4],m13=te[8],m21=te[1],m22=te[5],m23=te[9],m31=te[2],m32=te[6],m33=te[10],trace=m11+m22+m33;if(trace>0){const s=.5/Math.sqrt(trace+1);this._w=.25/s,this._x=(m32-m23)*s,this._y=(m13-m31)*s,this._z=(m21-m12)*s}else if(m11>m22&&m11>m33){const s=2*Math.sqrt(1+m11-m22-m33);this._w=(m32-m23)/s,this._x=.25*s,this._y=(m12+m21)/s,this._z=(m13+m31)/s}else if(m22>m33){const s=2*Math.sqrt(1+m22-m11-m33);this._w=(m13-m31)/s,this._x=(m12+m21)/s,this._y=.25*s,this._z=(m23+m32)/s}else{const s=2*Math.sqrt(1+m33-m11-m22);this._w=(m21-m12)/s,this._x=(m13+m31)/s,this._y=(m23+m32)/s,this._z=.25*s}return this._onChangeCallback(),this},setFromUnitVectors:function(vFrom,vTo){let r=vFrom.dot(vTo)+1;return r<1e-6?(r=0,Math.abs(vFrom.x)>Math.abs(vFrom.z)?(this._x=-vFrom.y,this._y=vFrom.x,this._z=0,this._w=r):(this._x=0,this._y=-vFrom.z,this._z=vFrom.y,this._w=r)):(this._x=vFrom.y*vTo.z-vFrom.z*vTo.y,this._y=vFrom.z*vTo.x-vFrom.x*vTo.z,this._z=vFrom.x*vTo.y-vFrom.y*vTo.x,this._w=r),this.normalize()},angleTo:function(q){return 2*Math.acos(Math.abs(MathUtils.clamp(this.dot(q),-1,1)))},rotateTowards:function(q,step){const angle=this.angleTo(q);if(0===angle)return this;const t=Math.min(1,step/angle);return this.slerp(q,t),this},identity:function(){return this.set(0,0,0,1)},inverse:function(){return this.conjugate()},conjugate:function(){return this._x*=-1,this._y*=-1,this._z*=-1,this._onChangeCallback(),this},dot:function(v){return this._x*v._x+this._y*v._y+this._z*v._z+this._w*v._w},lengthSq:function(){return this._x*this._x+this._y*this._y+this._z*this._z+this._w*this._w},length:function(){return Math.sqrt(this._x*this._x+this._y*this._y+this._z*this._z+this._w*this._w)},normalize:function(){let l=this.length();return 0===l?(this._x=0,this._y=0,this._z=0,this._w=1):(l=1/l,this._x=this._x*l,this._y=this._y*l,this._z=this._z*l,this._w=this._w*l),this._onChangeCallback(),this},multiply:function(q,p){return void 0!==p?(console.warn("THREE.Quaternion: .multiply() now only accepts one argument. Use .multiplyQuaternions( a, b ) instead."),this.multiplyQuaternions(q,p)):this.multiplyQuaternions(this,q)},premultiply:function(q){return this.multiplyQuaternions(q,this)},multiplyQuaternions:function(a,b){const qax=a._x,qay=a._y,qaz=a._z,qaw=a._w,qbx=b._x,qby=b._y,qbz=b._z,qbw=b._w;return this._x=qax*qbw+qaw*qbx+qay*qbz-qaz*qby,this._y=qay*qbw+qaw*qby+qaz*qbx-qax*qbz,this._z=qaz*qbw+qaw*qbz+qax*qby-qay*qbx,this._w=qaw*qbw-qax*qbx-qay*qby-qaz*qbz,this._onChangeCallback(),this},slerp:function(qb,t){if(0===t)return this;if(1===t)return this.copy(qb);const x=this._x,y=this._y,z=this._z,w=this._w;let cosHalfTheta=w*qb._w+x*qb._x+y*qb._y+z*qb._z;if(cosHalfTheta<0?(this._w=-qb._w,this._x=-qb._x,this._y=-qb._y,this._z=-qb._z,cosHalfTheta=-cosHalfTheta):this.copy(qb),cosHalfTheta>=1)return this._w=w,this._x=x,this._y=y,this._z=z,this;const sqrSinHalfTheta=1-cosHalfTheta*cosHalfTheta;if(sqrSinHalfTheta<=Number.EPSILON){const s=1-t;return this._w=s*w+t*this._w,this._x=s*x+t*this._x,this._y=s*y+t*this._y,this._z=s*z+t*this._z,this.normalize(),this._onChangeCallback(),this}const sinHalfTheta=Math.sqrt(sqrSinHalfTheta),halfTheta=Math.atan2(sinHalfTheta,cosHalfTheta),ratioA=Math.sin((1-t)*halfTheta)/sinHalfTheta,ratioB=Math.sin(t*halfTheta)/sinHalfTheta;return this._w=w*ratioA+this._w*ratioB,this._x=x*ratioA+this._x*ratioB,this._y=y*ratioA+this._y*ratioB,this._z=z*ratioA+this._z*ratioB,this._onChangeCallback(),this},equals:function(quaternion){return quaternion._x===this._x&&quaternion._y===this._y&&quaternion._z===this._z&&quaternion._w===this._w},fromArray:function(array,offset){return void 0===offset&&(offset=0),this._x=array[offset],this._y=array[offset+1],this._z=array[offset+2],this._w=array[offset+3],this._onChangeCallback(),this},toArray:function(array,offset){return void 0===array&&(array=[]),void 0===offset&&(offset=0),array[offset]=this._x,array[offset+1]=this._y,array[offset+2]=this._z,array[offset+3]=this._w,array},fromBufferAttribute:function(attribute,index){return this._x=attribute.getX(index),this._y=attribute.getY(index),this._z=attribute.getZ(index),this._w=attribute.getW(index),this},_onChange:function(callback){return this._onChangeCallback=callback,this},_onChangeCallback:function(){}});const _vector=new Vector3,_quaternion=new Quaternion;function Vector3(x=0,y=0,z=0){this.x=x,this.y=y,this.z=z}Object.assign(Vector3.prototype,{isVector3:!0,set:function(x,y,z){return void 0===z&&(z=this.z),this.x=x,this.y=y,this.z=z,this},setScalar:function(scalar){return this.x=scalar,this.y=scalar,this.z=scalar,this},setX:function(x){return this.x=x,this},setY:function(y){return this.y=y,this},setZ:function(z){return this.z=z,this},setComponent:function(index,value){switch(index){case 0:this.x=value;break;case 1:this.y=value;break;case 2:this.z=value;break;default:throw new Error("index is out of range: "+index)}return this},getComponent:function(index){switch(index){case 0:return this.x;case 1:return this.y;case 2:return this.z;default:throw new Error("index is out of range: "+index)}},clone:function(){return new this.constructor(this.x,this.y,this.z)},copy:function(v){return this.x=v.x,this.y=v.y,this.z=v.z,this},add:function(v,w){return void 0!==w?(console.warn("THREE.Vector3: .add() now only accepts one argument. Use .addVectors( a, b ) instead."),this.addVectors(v,w)):(this.x+=v.x,this.y+=v.y,this.z+=v.z,this)},addScalar:function(s){return this.x+=s,this.y+=s,this.z+=s,this},addVectors:function(a,b){return this.x=a.x+b.x,this.y=a.y+b.y,this.z=a.z+b.z,this},addScaledVector:function(v,s){return this.x+=v.x*s,this.y+=v.y*s,this.z+=v.z*s,this},sub:function(v,w){return void 0!==w?(console.warn("THREE.Vector3: .sub() now only accepts one argument. Use .subVectors( a, b ) instead."),this.subVectors(v,w)):(this.x-=v.x,this.y-=v.y,this.z-=v.z,this)},subScalar:function(s){return this.x-=s,this.y-=s,this.z-=s,this},subVectors:function(a,b){return this.x=a.x-b.x,this.y=a.y-b.y,this.z=a.z-b.z,this},multiply:function(v,w){return void 0!==w?(console.warn("THREE.Vector3: .multiply() now only accepts one argument. Use .multiplyVectors( a, b ) instead."),this.multiplyVectors(v,w)):(this.x*=v.x,this.y*=v.y,this.z*=v.z,this)},multiplyScalar:function(scalar){return this.x*=scalar,this.y*=scalar,this.z*=scalar,this},multiplyVectors:function(a,b){return this.x=a.x*b.x,this.y=a.y*b.y,this.z=a.z*b.z,this},applyEuler:function(euler){return euler&&euler.isEuler||console.error("THREE.Vector3: .applyEuler() now expects an Euler rotation rather than a Vector3 and order."),this.applyQuaternion(_quaternion.setFromEuler(euler))},applyAxisAngle:function(axis,angle){return this.applyQuaternion(_quaternion.setFromAxisAngle(axis,angle))},applyMatrix3:function(m){const x=this.x,y=this.y,z=this.z,e=m.elements;return this.x=e[0]*x+e[3]*y+e[6]*z,this.y=e[1]*x+e[4]*y+e[7]*z,this.z=e[2]*x+e[5]*y+e[8]*z,this},applyNormalMatrix:function(m){return this.applyMatrix3(m).normalize()},applyMatrix4:function(m){const x=this.x,y=this.y,z=this.z,e=m.elements,w=1/(e[3]*x+e[7]*y+e[11]*z+e[15]);return this.x=(e[0]*x+e[4]*y+e[8]*z+e[12])*w,this.y=(e[1]*x+e[5]*y+e[9]*z+e[13])*w,this.z=(e[2]*x+e[6]*y+e[10]*z+e[14])*w,this},applyQuaternion:function(q){const x=this.x,y=this.y,z=this.z,qx=q.x,qy=q.y,qz=q.z,qw=q.w,ix=qw*x+qy*z-qz*y,iy=qw*y+qz*x-qx*z,iz=qw*z+qx*y-qy*x,iw=-qx*x-qy*y-qz*z;return this.x=ix*qw+iw*-qx+iy*-qz-iz*-qy,this.y=iy*qw+iw*-qy+iz*-qx-ix*-qz,this.z=iz*qw+iw*-qz+ix*-qy-iy*-qx,this},project:function(camera){return this.applyMatrix4(camera.matrixWorldInverse).applyMatrix4(camera.projectionMatrix)},unproject:function(camera){return this.applyMatrix4(camera.projectionMatrixInverse).applyMatrix4(camera.matrixWorld)},transformDirection:function(m){const x=this.x,y=this.y,z=this.z,e=m.elements;return this.x=e[0]*x+e[4]*y+e[8]*z,this.y=e[1]*x+e[5]*y+e[9]*z,this.z=e[2]*x+e[6]*y+e[10]*z,this.normalize()},divide:function(v){return this.x/=v.x,this.y/=v.y,this.z/=v.z,this},divideScalar:function(scalar){return this.multiplyScalar(1/scalar)},min:function(v){return this.x=Math.min(this.x,v.x),this.y=Math.min(this.y,v.y),this.z=Math.min(this.z,v.z),this},max:function(v){return this.x=Math.max(this.x,v.x),this.y=Math.max(this.y,v.y),this.z=Math.max(this.z,v.z),this},clamp:function(min,max){return this.x=Math.max(min.x,Math.min(max.x,this.x)),this.y=Math.max(min.y,Math.min(max.y,this.y)),this.z=Math.max(min.z,Math.min(max.z,this.z)),this},clampScalar:function(minVal,maxVal){return this.x=Math.max(minVal,Math.min(maxVal,this.x)),this.y=Math.max(minVal,Math.min(maxVal,this.y)),this.z=Math.max(minVal,Math.min(maxVal,this.z)),this},clampLength:function(min,max){const length=this.length();return this.divideScalar(length||1).multiplyScalar(Math.max(min,Math.min(max,length)))},floor:function(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this.z=Math.floor(this.z),this},ceil:function(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this.z=Math.ceil(this.z),this},round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this.z=Math.round(this.z),this},roundToZero:function(){return this.x=this.x<0?Math.ceil(this.x):Math.floor(this.x),this.y=this.y<0?Math.ceil(this.y):Math.floor(this.y),this.z=this.z<0?Math.ceil(this.z):Math.floor(this.z),this},negate:function(){return this.x=-this.x,this.y=-this.y,this.z=-this.z,this},dot:function(v){return this.x*v.x+this.y*v.y+this.z*v.z},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z)},manhattanLength:function(){return Math.abs(this.x)+Math.abs(this.y)+Math.abs(this.z)},normalize:function(){return this.divideScalar(this.length()||1)},setLength:function(length){return this.normalize().multiplyScalar(length)},lerp:function(v,alpha){return this.x+=(v.x-this.x)*alpha,this.y+=(v.y-this.y)*alpha,this.z+=(v.z-this.z)*alpha,this},lerpVectors:function(v1,v2,alpha){return this.x=v1.x+(v2.x-v1.x)*alpha,this.y=v1.y+(v2.y-v1.y)*alpha,this.z=v1.z+(v2.z-v1.z)*alpha,this},cross:function(v,w){return void 0!==w?(console.warn("THREE.Vector3: .cross() now only accepts one argument. Use .crossVectors( a, b ) instead."),this.crossVectors(v,w)):this.crossVectors(this,v)},crossVectors:function(a,b){const ax=a.x,ay=a.y,az=a.z,bx=b.x,by=b.y,bz=b.z;return this.x=ay*bz-az*by,this.y=az*bx-ax*bz,this.z=ax*by-ay*bx,this},projectOnVector:function(v){const denominator=v.lengthSq();if(0===denominator)return this.set(0,0,0);const scalar=v.dot(this)/denominator;return this.copy(v).multiplyScalar(scalar)},projectOnPlane:function(planeNormal){return _vector.copy(this).projectOnVector(planeNormal),this.sub(_vector)},reflect:function(normal){return this.sub(_vector.copy(normal).multiplyScalar(2*this.dot(normal)))},angleTo:function(v){const denominator=Math.sqrt(this.lengthSq()*v.lengthSq());if(0===denominator)return Math.PI/2;const theta=this.dot(v)/denominator;return Math.acos(MathUtils.clamp(theta,-1,1))},distanceTo:function(v){return Math.sqrt(this.distanceToSquared(v))},distanceToSquared:function(v){const dx=this.x-v.x,dy=this.y-v.y,dz=this.z-v.z;return dx*dx+dy*dy+dz*dz},manhattanDistanceTo:function(v){return Math.abs(this.x-v.x)+Math.abs(this.y-v.y)+Math.abs(this.z-v.z)},setFromSpherical:function(s){return this.setFromSphericalCoords(s.radius,s.phi,s.theta)},setFromSphericalCoords:function(radius,phi,theta){const sinPhiRadius=Math.sin(phi)*radius;return this.x=sinPhiRadius*Math.sin(theta),this.y=Math.cos(phi)*radius,this.z=sinPhiRadius*Math.cos(theta),this},setFromCylindrical:function(c){return this.setFromCylindricalCoords(c.radius,c.theta,c.y)},setFromCylindricalCoords:function(radius,theta,y){return this.x=radius*Math.sin(theta),this.y=y,this.z=radius*Math.cos(theta),this},setFromMatrixPosition:function(m){const e=m.elements;return this.x=e[12],this.y=e[13],this.z=e[14],this},setFromMatrixScale:function(m){const sx=this.setFromMatrixColumn(m,0).length(),sy=this.setFromMatrixColumn(m,1).length(),sz=this.setFromMatrixColumn(m,2).length();return this.x=sx,this.y=sy,this.z=sz,this},setFromMatrixColumn:function(m,index){return this.fromArray(m.elements,4*index)},setFromMatrix3Column:function(m,index){return this.fromArray(m.elements,3*index)},equals:function(v){return v.x===this.x&&v.y===this.y&&v.z===this.z},fromArray:function(array,offset){return void 0===offset&&(offset=0),this.x=array[offset],this.y=array[offset+1],this.z=array[offset+2],this},toArray:function(array,offset){return void 0===array&&(array=[]),void 0===offset&&(offset=0),array[offset]=this.x,array[offset+1]=this.y,array[offset+2]=this.z,array},fromBufferAttribute:function(attribute,index,offset){return void 0!==offset&&console.warn("THREE.Vector3: offset has been removed from .fromBufferAttribute()."),this.x=attribute.getX(index),this.y=attribute.getY(index),this.z=attribute.getZ(index),this},random:function(){return this.x=Math.random(),this.y=Math.random(),this.z=Math.random(),this}});const _v1=new Vector3,_m1=new Matrix4,_zero=new Vector3(0,0,0),_one=new Vector3(1,1,1),_x=new Vector3,_y=new Vector3,_z=new Vector3;function Matrix4(){this.elements=[1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1],arguments.length>0&&console.error("THREE.Matrix4: the constructor no longer reads arguments. use .set() instead.")}Object.assign(Matrix4.prototype,{isMatrix4:!0,set:function(n11,n12,n13,n14,n21,n22,n23,n24,n31,n32,n33,n34,n41,n42,n43,n44){const te=this.elements;return te[0]=n11,te[4]=n12,te[8]=n13,te[12]=n14,te[1]=n21,te[5]=n22,te[9]=n23,te[13]=n24,te[2]=n31,te[6]=n32,te[10]=n33,te[14]=n34,te[3]=n41,te[7]=n42,te[11]=n43,te[15]=n44,this},identity:function(){return this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1),this},clone:function(){return(new Matrix4).fromArray(this.elements)},copy:function(m){const te=this.elements,me=m.elements;return te[0]=me[0],te[1]=me[1],te[2]=me[2],te[3]=me[3],te[4]=me[4],te[5]=me[5],te[6]=me[6],te[7]=me[7],te[8]=me[8],te[9]=me[9],te[10]=me[10],te[11]=me[11],te[12]=me[12],te[13]=me[13],te[14]=me[14],te[15]=me[15],this},copyPosition:function(m){const te=this.elements,me=m.elements;return te[12]=me[12],te[13]=me[13],te[14]=me[14],this},extractBasis:function(xAxis,yAxis,zAxis){return xAxis.setFromMatrixColumn(this,0),yAxis.setFromMatrixColumn(this,1),zAxis.setFromMatrixColumn(this,2),this},makeBasis:function(xAxis,yAxis,zAxis){return this.set(xAxis.x,yAxis.x,zAxis.x,0,xAxis.y,yAxis.y,zAxis.y,0,xAxis.z,yAxis.z,zAxis.z,0,0,0,0,1),this},extractRotation:function(m){const te=this.elements,me=m.elements,scaleX=1/_v1.setFromMatrixColumn(m,0).length(),scaleY=1/_v1.setFromMatrixColumn(m,1).length(),scaleZ=1/_v1.setFromMatrixColumn(m,2).length();return te[0]=me[0]*scaleX,te[1]=me[1]*scaleX,te[2]=me[2]*scaleX,te[3]=0,te[4]=me[4]*scaleY,te[5]=me[5]*scaleY,te[6]=me[6]*scaleY,te[7]=0,te[8]=me[8]*scaleZ,te[9]=me[9]*scaleZ,te[10]=me[10]*scaleZ,te[11]=0,te[12]=0,te[13]=0,te[14]=0,te[15]=1,this},makeRotationFromEuler:function(euler){euler&&euler.isEuler||console.error("THREE.Matrix4: .makeRotationFromEuler() now expects a Euler rotation rather than a Vector3 and order.");const te=this.elements,x=euler.x,y=euler.y,z=euler.z,a=Math.cos(x),b=Math.sin(x),c=Math.cos(y),d=Math.sin(y),e=Math.cos(z),f=Math.sin(z);if("XYZ"===euler.order){const ae=a*e,af=a*f,be=b*e,bf=b*f;te[0]=c*e,te[4]=-c*f,te[8]=d,te[1]=af+be*d,te[5]=ae-bf*d,te[9]=-b*c,te[2]=bf-ae*d,te[6]=be+af*d,te[10]=a*c}else if("YXZ"===euler.order){const ce=c*e,cf=c*f,de=d*e,df=d*f;te[0]=ce+df*b,te[4]=de*b-cf,te[8]=a*d,te[1]=a*f,te[5]=a*e,te[9]=-b,te[2]=cf*b-de,te[6]=df+ce*b,te[10]=a*c}else if("ZXY"===euler.order){const ce=c*e,cf=c*f,de=d*e,df=d*f;te[0]=ce-df*b,te[4]=-a*f,te[8]=de+cf*b,te[1]=cf+de*b,te[5]=a*e,te[9]=df-ce*b,te[2]=-a*d,te[6]=b,te[10]=a*c}else if("ZYX"===euler.order){const ae=a*e,af=a*f,be=b*e,bf=b*f;te[0]=c*e,te[4]=be*d-af,te[8]=ae*d+bf,te[1]=c*f,te[5]=bf*d+ae,te[9]=af*d-be,te[2]=-d,te[6]=b*c,te[10]=a*c}else if("YZX"===euler.order){const ac=a*c,ad=a*d,bc=b*c,bd=b*d;te[0]=c*e,te[4]=bd-ac*f,te[8]=bc*f+ad,te[1]=f,te[5]=a*e,te[9]=-b*e,te[2]=-d*e,te[6]=ad*f+bc,te[10]=ac-bd*f}else if("XZY"===euler.order){const ac=a*c,ad=a*d,bc=b*c,bd=b*d;te[0]=c*e,te[4]=-f,te[8]=d*e,te[1]=ac*f+bd,te[5]=a*e,te[9]=ad*f-bc,te[2]=bc*f-ad,te[6]=b*e,te[10]=bd*f+ac}return te[3]=0,te[7]=0,te[11]=0,te[12]=0,te[13]=0,te[14]=0,te[15]=1,this},makeRotationFromQuaternion:function(q){return this.compose(_zero,q,_one)},lookAt:function(eye,target,up){const te=this.elements;return _z.subVectors(eye,target),0===_z.lengthSq()&&(_z.z=1),_z.normalize(),_x.crossVectors(up,_z),0===_x.lengthSq()&&(1===Math.abs(up.z)?_z.x+=1e-4:_z.z+=1e-4,_z.normalize(),_x.crossVectors(up,_z)),_x.normalize(),_y.crossVectors(_z,_x),te[0]=_x.x,te[4]=_y.x,te[8]=_z.x,te[1]=_x.y,te[5]=_y.y,te[9]=_z.y,te[2]=_x.z,te[6]=_y.z,te[10]=_z.z,this},multiply:function(m,n){return void 0!==n?(console.warn("THREE.Matrix4: .multiply() now only accepts one argument. Use .multiplyMatrices( a, b ) instead."),this.multiplyMatrices(m,n)):this.multiplyMatrices(this,m)},premultiply:function(m){return this.multiplyMatrices(m,this)},multiplyMatrices:function(a,b){const ae=a.elements,be=b.elements,te=this.elements,a11=ae[0],a12=ae[4],a13=ae[8],a14=ae[12],a21=ae[1],a22=ae[5],a23=ae[9],a24=ae[13],a31=ae[2],a32=ae[6],a33=ae[10],a34=ae[14],a41=ae[3],a42=ae[7],a43=ae[11],a44=ae[15],b11=be[0],b12=be[4],b13=be[8],b14=be[12],b21=be[1],b22=be[5],b23=be[9],b24=be[13],b31=be[2],b32=be[6],b33=be[10],b34=be[14],b41=be[3],b42=be[7],b43=be[11],b44=be[15];return te[0]=a11*b11+a12*b21+a13*b31+a14*b41,te[4]=a11*b12+a12*b22+a13*b32+a14*b42,te[8]=a11*b13+a12*b23+a13*b33+a14*b43,te[12]=a11*b14+a12*b24+a13*b34+a14*b44,te[1]=a21*b11+a22*b21+a23*b31+a24*b41,te[5]=a21*b12+a22*b22+a23*b32+a24*b42,te[9]=a21*b13+a22*b23+a23*b33+a24*b43,te[13]=a21*b14+a22*b24+a23*b34+a24*b44,te[2]=a31*b11+a32*b21+a33*b31+a34*b41,te[6]=a31*b12+a32*b22+a33*b32+a34*b42,te[10]=a31*b13+a32*b23+a33*b33+a34*b43,te[14]=a31*b14+a32*b24+a33*b34+a34*b44,te[3]=a41*b11+a42*b21+a43*b31+a44*b41,te[7]=a41*b12+a42*b22+a43*b32+a44*b42,te[11]=a41*b13+a42*b23+a43*b33+a44*b43,te[15]=a41*b14+a42*b24+a43*b34+a44*b44,this},multiplyScalar:function(s){const te=this.elements;return te[0]*=s,te[4]*=s,te[8]*=s,te[12]*=s,te[1]*=s,te[5]*=s,te[9]*=s,te[13]*=s,te[2]*=s,te[6]*=s,te[10]*=s,te[14]*=s,te[3]*=s,te[7]*=s,te[11]*=s,te[15]*=s,this},determinant:function(){const te=this.elements,n11=te[0],n12=te[4],n13=te[8],n14=te[12],n21=te[1],n22=te[5],n23=te[9],n24=te[13],n31=te[2],n32=te[6],n33=te[10],n34=te[14];return te[3]*(+n14*n23*n32-n13*n24*n32-n14*n22*n33+n12*n24*n33+n13*n22*n34-n12*n23*n34)+te[7]*(+n11*n23*n34-n11*n24*n33+n14*n21*n33-n13*n21*n34+n13*n24*n31-n14*n23*n31)+te[11]*(+n11*n24*n32-n11*n22*n34-n14*n21*n32+n12*n21*n34+n14*n22*n31-n12*n24*n31)+te[15]*(-n13*n22*n31-n11*n23*n32+n11*n22*n33+n13*n21*n32-n12*n21*n33+n12*n23*n31)},transpose:function(){const te=this.elements;let tmp;return tmp=te[1],te[1]=te[4],te[4]=tmp,tmp=te[2],te[2]=te[8],te[8]=tmp,tmp=te[6],te[6]=te[9],te[9]=tmp,tmp=te[3],te[3]=te[12],te[12]=tmp,tmp=te[7],te[7]=te[13],te[13]=tmp,tmp=te[11],te[11]=te[14],te[14]=tmp,this},setPosition:function(x,y,z){const te=this.elements;return x.isVector3?(te[12]=x.x,te[13]=x.y,te[14]=x.z):(te[12]=x,te[13]=y,te[14]=z),this},getInverse:function(m,throwOnDegenerate){void 0!==throwOnDegenerate&&console.warn("THREE.Matrix4: .getInverse() can no longer be configured to throw on degenerate.");const te=this.elements,me=m.elements,n11=me[0],n21=me[1],n31=me[2],n41=me[3],n12=me[4],n22=me[5],n32=me[6],n42=me[7],n13=me[8],n23=me[9],n33=me[10],n43=me[11],n14=me[12],n24=me[13],n34=me[14],n44=me[15],t11=n23*n34*n42-n24*n33*n42+n24*n32*n43-n22*n34*n43-n23*n32*n44+n22*n33*n44,t12=n14*n33*n42-n13*n34*n42-n14*n32*n43+n12*n34*n43+n13*n32*n44-n12*n33*n44,t13=n13*n24*n42-n14*n23*n42+n14*n22*n43-n12*n24*n43-n13*n22*n44+n12*n23*n44,t14=n14*n23*n32-n13*n24*n32-n14*n22*n33+n12*n24*n33+n13*n22*n34-n12*n23*n34,det=n11*t11+n21*t12+n31*t13+n41*t14;if(0===det)return this.set(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);const detInv=1/det;return te[0]=t11*detInv,te[1]=(n24*n33*n41-n23*n34*n41-n24*n31*n43+n21*n34*n43+n23*n31*n44-n21*n33*n44)*detInv,te[2]=(n22*n34*n41-n24*n32*n41+n24*n31*n42-n21*n34*n42-n22*n31*n44+n21*n32*n44)*detInv,te[3]=(n23*n32*n41-n22*n33*n41-n23*n31*n42+n21*n33*n42+n22*n31*n43-n21*n32*n43)*detInv,te[4]=t12*detInv,te[5]=(n13*n34*n41-n14*n33*n41+n14*n31*n43-n11*n34*n43-n13*n31*n44+n11*n33*n44)*detInv,te[6]=(n14*n32*n41-n12*n34*n41-n14*n31*n42+n11*n34*n42+n12*n31*n44-n11*n32*n44)*detInv,te[7]=(n12*n33*n41-n13*n32*n41+n13*n31*n42-n11*n33*n42-n12*n31*n43+n11*n32*n43)*detInv,te[8]=t13*detInv,te[9]=(n14*n23*n41-n13*n24*n41-n14*n21*n43+n11*n24*n43+n13*n21*n44-n11*n23*n44)*detInv,te[10]=(n12*n24*n41-n14*n22*n41+n14*n21*n42-n11*n24*n42-n12*n21*n44+n11*n22*n44)*detInv,te[11]=(n13*n22*n41-n12*n23*n41-n13*n21*n42+n11*n23*n42+n12*n21*n43-n11*n22*n43)*detInv,te[12]=t14*detInv,te[13]=(n13*n24*n31-n14*n23*n31+n14*n21*n33-n11*n24*n33-n13*n21*n34+n11*n23*n34)*detInv,te[14]=(n14*n22*n31-n12*n24*n31-n14*n21*n32+n11*n24*n32+n12*n21*n34-n11*n22*n34)*detInv,te[15]=(n12*n23*n31-n13*n22*n31+n13*n21*n32-n11*n23*n32-n12*n21*n33+n11*n22*n33)*detInv,this},scale:function(v){const te=this.elements,x=v.x,y=v.y,z=v.z;return te[0]*=x,te[4]*=y,te[8]*=z,te[1]*=x,te[5]*=y,te[9]*=z,te[2]*=x,te[6]*=y,te[10]*=z,te[3]*=x,te[7]*=y,te[11]*=z,this},getMaxScaleOnAxis:function(){const te=this.elements,scaleXSq=te[0]*te[0]+te[1]*te[1]+te[2]*te[2],scaleYSq=te[4]*te[4]+te[5]*te[5]+te[6]*te[6],scaleZSq=te[8]*te[8]+te[9]*te[9]+te[10]*te[10];return Math.sqrt(Math.max(scaleXSq,scaleYSq,scaleZSq))},makeTranslation:function(x,y,z){return this.set(1,0,0,x,0,1,0,y,0,0,1,z,0,0,0,1),this},makeRotationX:function(theta){const c=Math.cos(theta),s=Math.sin(theta);return this.set(1,0,0,0,0,c,-s,0,0,s,c,0,0,0,0,1),this},makeRotationY:function(theta){const c=Math.cos(theta),s=Math.sin(theta);return this.set(c,0,s,0,0,1,0,0,-s,0,c,0,0,0,0,1),this},makeRotationZ:function(theta){const c=Math.cos(theta),s=Math.sin(theta);return this.set(c,-s,0,0,s,c,0,0,0,0,1,0,0,0,0,1),this},makeRotationAxis:function(axis,angle){const c=Math.cos(angle),s=Math.sin(angle),t=1-c,x=axis.x,y=axis.y,z=axis.z,tx=t*x,ty=t*y;return this.set(tx*x+c,tx*y-s*z,tx*z+s*y,0,tx*y+s*z,ty*y+c,ty*z-s*x,0,tx*z-s*y,ty*z+s*x,t*z*z+c,0,0,0,0,1),this},makeScale:function(x,y,z){return this.set(x,0,0,0,0,y,0,0,0,0,z,0,0,0,0,1),this},makeShear:function(x,y,z){return this.set(1,y,z,0,x,1,z,0,x,y,1,0,0,0,0,1),this},compose:function(position,quaternion,scale){const te=this.elements,x=quaternion._x,y=quaternion._y,z=quaternion._z,w=quaternion._w,x2=x+x,y2=y+y,z2=z+z,xx=x*x2,xy=x*y2,xz=x*z2,yy=y*y2,yz=y*z2,zz=z*z2,wx=w*x2,wy=w*y2,wz=w*z2,sx=scale.x,sy=scale.y,sz=scale.z;return te[0]=(1-(yy+zz))*sx,te[1]=(xy+wz)*sx,te[2]=(xz-wy)*sx,te[3]=0,te[4]=(xy-wz)*sy,te[5]=(1-(xx+zz))*sy,te[6]=(yz+wx)*sy,te[7]=0,te[8]=(xz+wy)*sz,te[9]=(yz-wx)*sz,te[10]=(1-(xx+yy))*sz,te[11]=0,te[12]=position.x,te[13]=position.y,te[14]=position.z,te[15]=1,this},decompose:function(position,quaternion,scale){const te=this.elements;let sx=_v1.set(te[0],te[1],te[2]).length(),sy=_v1.set(te[4],te[5],te[6]).length(),sz=_v1.set(te[8],te[9],te[10]).length();this.determinant()<0&&(sx=-sx),position.x=te[12],position.y=te[13],position.z=te[14],_m1.copy(this);const invSX=1/sx,invSY=1/sy,invSZ=1/sz;return _m1.elements[0]*=invSX,_m1.elements[1]*=invSX,_m1.elements[2]*=invSX,_m1.elements[4]*=invSY,_m1.elements[5]*=invSY,_m1.elements[6]*=invSY,_m1.elements[8]*=invSZ,_m1.elements[9]*=invSZ,_m1.elements[10]*=invSZ,quaternion.setFromRotationMatrix(_m1),scale.x=sx,scale.y=sy,scale.z=sz,this},makePerspective:function(left,right,top,bottom,near,far){void 0===far&&console.warn("THREE.Matrix4: .makePerspective() has been redefined and has a new signature. Please check the docs.");const te=this.elements,x=2*near/(right-left),y=2*near/(top-bottom),a=(right+left)/(right-left),b=(top+bottom)/(top-bottom),c=-(far+near)/(far-near),d=-2*far*near/(far-near);return te[0]=x,te[4]=0,te[8]=a,te[12]=0,te[1]=0,te[5]=y,te[9]=b,te[13]=0,te[2]=0,te[6]=0,te[10]=c,te[14]=d,te[3]=0,te[7]=0,te[11]=-1,te[15]=0,this},makeOrthographic:function(left,right,top,bottom,near,far){const te=this.elements,w=1/(right-left),h=1/(top-bottom),p=1/(far-near),x=(right+left)*w,y=(top+bottom)*h,z=(far+near)*p;return te[0]=2*w,te[4]=0,te[8]=0,te[12]=-x,te[1]=0,te[5]=2*h,te[9]=0,te[13]=-y,te[2]=0,te[6]=0,te[10]=-2*p,te[14]=-z,te[3]=0,te[7]=0,te[11]=0,te[15]=1,this},equals:function(matrix){const te=this.elements,me=matrix.elements;for(let i=0;i<16;i++)if(te[i]!==me[i])return!1;return!0},fromArray:function(array,offset){void 0===offset&&(offset=0);for(let i=0;i<16;i++)this.elements[i]=array[i+offset];return this},toArray:function(array,offset){void 0===array&&(array=[]),void 0===offset&&(offset=0);const te=this.elements;return array[offset]=te[0],array[offset+1]=te[1],array[offset+2]=te[2],array[offset+3]=te[3],array[offset+4]=te[4],array[offset+5]=te[5],array[offset+6]=te[6],array[offset+7]=te[7],array[offset+8]=te[8],array[offset+9]=te[9],array[offset+10]=te[10],array[offset+11]=te[11],array[offset+12]=te[12],array[offset+13]=te[13],array[offset+14]=te[14],array[offset+15]=te[15],array}});const _matrix=new Matrix4,_quaternion$1=new Quaternion;function Euler(x=0,y=0,z=0,order=Euler.DefaultOrder){this._x=x,this._y=y,this._z=z,this._order=order}function Layers(){this.mask=1}Euler.RotationOrders=["XYZ","YZX","ZXY","XZY","YXZ","ZYX"],Euler.DefaultOrder="XYZ",Object.defineProperties(Euler.prototype,{x:{get:function(){return this._x},set:function(value){this._x=value,this._onChangeCallback()}},y:{get:function(){return this._y},set:function(value){this._y=value,this._onChangeCallback()}},z:{get:function(){return this._z},set:function(value){this._z=value,this._onChangeCallback()}},order:{get:function(){return this._order},set:function(value){this._order=value,this._onChangeCallback()}}}),Object.assign(Euler.prototype,{isEuler:!0,set:function(x,y,z,order){return this._x=x,this._y=y,this._z=z,this._order=order||this._order,this._onChangeCallback(),this},clone:function(){return new this.constructor(this._x,this._y,this._z,this._order)},copy:function(euler){return this._x=euler._x,this._y=euler._y,this._z=euler._z,this._order=euler._order,this._onChangeCallback(),this},setFromRotationMatrix:function(m,order,update){const clamp=MathUtils.clamp,te=m.elements,m11=te[0],m12=te[4],m13=te[8],m21=te[1],m22=te[5],m23=te[9],m31=te[2],m32=te[6],m33=te[10];switch(order=order||this._order){case"XYZ":this._y=Math.asin(clamp(m13,-1,1)),Math.abs(m13)<.9999999?(this._x=Math.atan2(-m23,m33),this._z=Math.atan2(-m12,m11)):(this._x=Math.atan2(m32,m22),this._z=0);break;case"YXZ":this._x=Math.asin(-clamp(m23,-1,1)),Math.abs(m23)<.9999999?(this._y=Math.atan2(m13,m33),this._z=Math.atan2(m21,m22)):(this._y=Math.atan2(-m31,m11),this._z=0);break;case"ZXY":this._x=Math.asin(clamp(m32,-1,1)),Math.abs(m32)<.9999999?(this._y=Math.atan2(-m31,m33),this._z=Math.atan2(-m12,m22)):(this._y=0,this._z=Math.atan2(m21,m11));break;case"ZYX":this._y=Math.asin(-clamp(m31,-1,1)),Math.abs(m31)<.9999999?(this._x=Math.atan2(m32,m33),this._z=Math.atan2(m21,m11)):(this._x=0,this._z=Math.atan2(-m12,m22));break;case"YZX":this._z=Math.asin(clamp(m21,-1,1)),Math.abs(m21)<.9999999?(this._x=Math.atan2(-m23,m22),this._y=Math.atan2(-m31,m11)):(this._x=0,this._y=Math.atan2(m13,m33));break;case"XZY":this._z=Math.asin(-clamp(m12,-1,1)),Math.abs(m12)<.9999999?(this._x=Math.atan2(m32,m22),this._y=Math.atan2(m13,m11)):(this._x=Math.atan2(-m23,m33),this._y=0);break;default:console.warn("THREE.Euler: .setFromRotationMatrix() encountered an unknown order: "+order)}return this._order=order,!1!==update&&this._onChangeCallback(),this},setFromQuaternion:function(q,order,update){return _matrix.makeRotationFromQuaternion(q),this.setFromRotationMatrix(_matrix,order,update)},setFromVector3:function(v,order){return this.set(v.x,v.y,v.z,order||this._order)},reorder:function(newOrder){return _quaternion$1.setFromEuler(this),this.setFromQuaternion(_quaternion$1,newOrder)},equals:function(euler){return euler._x===this._x&&euler._y===this._y&&euler._z===this._z&&euler._order===this._order},fromArray:function(array){return this._x=array[0],this._y=array[1],this._z=array[2],void 0!==array[3]&&(this._order=array[3]),this._onChangeCallback(),this},toArray:function(array,offset){return void 0===array&&(array=[]),void 0===offset&&(offset=0),array[offset]=this._x,array[offset+1]=this._y,array[offset+2]=this._z,array[offset+3]=this._order,array},toVector3:function(optionalResult){return optionalResult?optionalResult.set(this._x,this._y,this._z):new Vector3(this._x,this._y,this._z)},_onChange:function(callback){return this._onChangeCallback=callback,this},_onChangeCallback:function(){}}),Object.assign(Layers.prototype,{set:function(channel){this.mask=1<<channel|0},enable:function(channel){this.mask|=1<<channel|0},enableAll:function(){this.mask=-1},toggle:function(channel){this.mask^=1<<channel|0},disable:function(channel){this.mask&=~(1<<channel|0)},disableAll:function(){this.mask=0},test:function(layers){return 0!=(this.mask&layers.mask)}});let _object3DId=0;const _v1$1=new Vector3,_q1=new Quaternion,_m1$1=new Matrix4,_target=new Vector3,_position=new Vector3,_scale=new Vector3,_quaternion$2=new Quaternion,_xAxis=new Vector3(1,0,0),_yAxis=new Vector3(0,1,0),_zAxis=new Vector3(0,0,1),_addedEvent={type:"added"},_removedEvent={type:"removed"};function Object3D(){Object.defineProperty(this,"id",{value:_object3DId++}),this.uuid=MathUtils.generateUUID(),this.name="",this.type="Object3D",this.parent=null,this.children=[],this.up=Object3D.DefaultUp.clone();const position=new Vector3,rotation=new Euler,quaternion=new Quaternion,scale=new Vector3(1,1,1);rotation._onChange((function(){quaternion.setFromEuler(rotation,!1)})),quaternion._onChange((function(){rotation.setFromQuaternion(quaternion,void 0,!1)})),Object.defineProperties(this,{position:{configurable:!0,enumerable:!0,value:position},rotation:{configurable:!0,enumerable:!0,value:rotation},quaternion:{configurable:!0,enumerable:!0,value:quaternion},scale:{configurable:!0,enumerable:!0,value:scale},modelViewMatrix:{value:new Matrix4},normalMatrix:{value:new Matrix3}}),this.matrix=new Matrix4,this.matrixWorld=new Matrix4,this.matrixAutoUpdate=Object3D.DefaultMatrixAutoUpdate,this.matrixWorldNeedsUpdate=!1,this.layers=new Layers,this.visible=!0,this.castShadow=!1,this.receiveShadow=!1,this.frustumCulled=!0,this.renderOrder=0,this.userData={}}function Scene(){Object3D.call(this),this.type="Scene",this.background=null,this.environment=null,this.fog=null,this.overrideMaterial=null,this.autoUpdate=!0,"undefined"!=typeof __THREE_DEVTOOLS__&&__THREE_DEVTOOLS__.dispatchEvent(new CustomEvent("observe",{detail:this}))}Object3D.DefaultUp=new Vector3(0,1,0),Object3D.DefaultMatrixAutoUpdate=!0,Object3D.prototype=Object.assign(Object.create(EventDispatcher.prototype),{constructor:Object3D,isObject3D:!0,onBeforeRender:function(){},onAfterRender:function(){},applyMatrix4:function(matrix){this.matrixAutoUpdate&&this.updateMatrix(),this.matrix.premultiply(matrix),this.matrix.decompose(this.position,this.quaternion,this.scale)},applyQuaternion:function(q){return this.quaternion.premultiply(q),this},setRotationFromAxisAngle:function(axis,angle){this.quaternion.setFromAxisAngle(axis,angle)},setRotationFromEuler:function(euler){this.quaternion.setFromEuler(euler,!0)},setRotationFromMatrix:function(m){this.quaternion.setFromRotationMatrix(m)},setRotationFromQuaternion:function(q){this.quaternion.copy(q)},rotateOnAxis:function(axis,angle){return _q1.setFromAxisAngle(axis,angle),this.quaternion.multiply(_q1),this},rotateOnWorldAxis:function(axis,angle){return _q1.setFromAxisAngle(axis,angle),this.quaternion.premultiply(_q1),this},rotateX:function(angle){return this.rotateOnAxis(_xAxis,angle)},rotateY:function(angle){return this.rotateOnAxis(_yAxis,angle)},rotateZ:function(angle){return this.rotateOnAxis(_zAxis,angle)},translateOnAxis:function(axis,distance){return _v1$1.copy(axis).applyQuaternion(this.quaternion),this.position.add(_v1$1.multiplyScalar(distance)),this},translateX:function(distance){return this.translateOnAxis(_xAxis,distance)},translateY:function(distance){return this.translateOnAxis(_yAxis,distance)},translateZ:function(distance){return this.translateOnAxis(_zAxis,distance)},localToWorld:function(vector){return vector.applyMatrix4(this.matrixWorld)},worldToLocal:function(vector){return vector.applyMatrix4(_m1$1.getInverse(this.matrixWorld))},lookAt:function(x,y,z){x.isVector3?_target.copy(x):_target.set(x,y,z);const parent=this.parent;this.updateWorldMatrix(!0,!1),_position.setFromMatrixPosition(this.matrixWorld),this.isCamera||this.isLight?_m1$1.lookAt(_position,_target,this.up):_m1$1.lookAt(_target,_position,this.up),this.quaternion.setFromRotationMatrix(_m1$1),parent&&(_m1$1.extractRotation(parent.matrixWorld),_q1.setFromRotationMatrix(_m1$1),this.quaternion.premultiply(_q1.inverse()))},add:function(object){if(arguments.length>1){for(let i=0;i<arguments.length;i++)this.add(arguments[i]);return this}return object===this?(console.error("THREE.Object3D.add: object can't be added as a child of itself.",object),this):(object&&object.isObject3D?(null!==object.parent&&object.parent.remove(object),object.parent=this,this.children.push(object),object.dispatchEvent(_addedEvent)):console.error("THREE.Object3D.add: object not an instance of THREE.Object3D.",object),this)},remove:function(object){if(arguments.length>1){for(let i=0;i<arguments.length;i++)this.remove(arguments[i]);return this}const index=this.children.indexOf(object);return-1!==index&&(object.parent=null,this.children.splice(index,1),object.dispatchEvent(_removedEvent)),this},attach:function(object){return this.updateWorldMatrix(!0,!1),_m1$1.getInverse(this.matrixWorld),null!==object.parent&&(object.parent.updateWorldMatrix(!0,!1),_m1$1.multiply(object.parent.matrixWorld)),object.applyMatrix4(_m1$1),object.updateWorldMatrix(!1,!1),this.add(object),this},getObjectById:function(id){return this.getObjectByProperty("id",id)},getObjectByName:function(name){return this.getObjectByProperty("name",name)},getObjectByProperty:function(name,value){if(this[name]===value)return this;for(let i=0,l=this.children.length;i<l;i++){const object=this.children[i].getObjectByProperty(name,value);if(void 0!==object)return object}},getWorldPosition:function(target){return void 0===target&&(console.warn("THREE.Object3D: .getWorldPosition() target is now required"),target=new Vector3),this.updateMatrixWorld(!0),target.setFromMatrixPosition(this.matrixWorld)},getWorldQuaternion:function(target){return void 0===target&&(console.warn("THREE.Object3D: .getWorldQuaternion() target is now required"),target=new Quaternion),this.updateMatrixWorld(!0),this.matrixWorld.decompose(_position,target,_scale),target},getWorldScale:function(target){return void 0===target&&(console.warn("THREE.Object3D: .getWorldScale() target is now required"),target=new Vector3),this.updateMatrixWorld(!0),this.matrixWorld.decompose(_position,_quaternion$2,target),target},getWorldDirection:function(target){void 0===target&&(console.warn("THREE.Object3D: .getWorldDirection() target is now required"),target=new Vector3),this.updateMatrixWorld(!0);const e=this.matrixWorld.elements;return target.set(e[8],e[9],e[10]).normalize()},raycast:function(){},traverse:function(callback){callback(this);const children=this.children;for(let i=0,l=children.length;i<l;i++)children[i].traverse(callback)},traverseVisible:function(callback){if(!1===this.visible)return;callback(this);const children=this.children;for(let i=0,l=children.length;i<l;i++)children[i].traverseVisible(callback)},traverseAncestors:function(callback){const parent=this.parent;null!==parent&&(callback(parent),parent.traverseAncestors(callback))},updateMatrix:function(){this.matrix.compose(this.position,this.quaternion,this.scale),this.matrixWorldNeedsUpdate=!0},updateMatrixWorld:function(force){this.matrixAutoUpdate&&this.updateMatrix(),(this.matrixWorldNeedsUpdate||force)&&(null===this.parent?this.matrixWorld.copy(this.matrix):this.matrixWorld.multiplyMatrices(this.parent.matrixWorld,this.matrix),this.matrixWorldNeedsUpdate=!1,force=!0);const children=this.children;for(let i=0,l=children.length;i<l;i++)children[i].updateMatrixWorld(force)},updateWorldMatrix:function(updateParents,updateChildren){const parent=this.parent;if(!0===updateParents&&null!==parent&&parent.updateWorldMatrix(!0,!1),this.matrixAutoUpdate&&this.updateMatrix(),null===this.parent?this.matrixWorld.copy(this.matrix):this.matrixWorld.multiplyMatrices(this.parent.matrixWorld,this.matrix),!0===updateChildren){const children=this.children;for(let i=0,l=children.length;i<l;i++)children[i].updateWorldMatrix(!1,!0)}},toJSON:function(meta){const isRootObject=void 0===meta||"string"==typeof meta,output={};isRootObject&&(meta={geometries:{},materials:{},textures:{},images:{},shapes:{}},output.metadata={version:4.5,type:"Object",generator:"Object3D.toJSON"});const object={};function serialize(library,element){return void 0===library[element.uuid]&&(library[element.uuid]=element.toJSON(meta)),element.uuid}if(object.uuid=this.uuid,object.type=this.type,""!==this.name&&(object.name=this.name),!0===this.castShadow&&(object.castShadow=!0),!0===this.receiveShadow&&(object.receiveShadow=!0),!1===this.visible&&(object.visible=!1),!1===this.frustumCulled&&(object.frustumCulled=!1),0!==this.renderOrder&&(object.renderOrder=this.renderOrder),"{}"!==JSON.stringify(this.userData)&&(object.userData=this.userData),object.layers=this.layers.mask,object.matrix=this.matrix.toArray(),!1===this.matrixAutoUpdate&&(object.matrixAutoUpdate=!1),this.isInstancedMesh&&(object.type="InstancedMesh",object.count=this.count,object.instanceMatrix=this.instanceMatrix.toJSON()),this.isMesh||this.isLine||this.isPoints){object.geometry=serialize(meta.geometries,this.geometry);const parameters=this.geometry.parameters;if(void 0!==parameters&&void 0!==parameters.shapes){const shapes=parameters.shapes;if(Array.isArray(shapes))for(let i=0,l=shapes.length;i<l;i++){const shape=shapes[i];serialize(meta.shapes,shape)}else serialize(meta.shapes,shapes)}}if(void 0!==this.material)if(Array.isArray(this.material)){const uuids=[];for(let i=0,l=this.material.length;i<l;i++)uuids.push(serialize(meta.materials,this.material[i]));object.material=uuids}else object.material=serialize(meta.materials,this.material);if(this.children.length>0){object.children=[];for(let i=0;i<this.children.length;i++)object.children.push(this.children[i].toJSON(meta).object)}if(isRootObject){const geometries=extractFromCache(meta.geometries),materials=extractFromCache(meta.materials),textures=extractFromCache(meta.textures),images=extractFromCache(meta.images),shapes=extractFromCache(meta.shapes);geometries.length>0&&(output.geometries=geometries),materials.length>0&&(output.materials=materials),textures.length>0&&(output.textures=textures),images.length>0&&(output.images=images),shapes.length>0&&(output.shapes=shapes)}return output.object=object,output;function extractFromCache(cache){const values=[];for(const key in cache){const data=cache[key];delete data.metadata,values.push(data)}return values}},clone:function(recursive){return(new this.constructor).copy(this,recursive)},copy:function(source,recursive){if(void 0===recursive&&(recursive=!0),this.name=source.name,this.up.copy(source.up),this.position.copy(source.position),this.rotation.order=source.rotation.order,this.quaternion.copy(source.quaternion),this.scale.copy(source.scale),this.matrix.copy(source.matrix),this.matrixWorld.copy(source.matrixWorld),this.matrixAutoUpdate=source.matrixAutoUpdate,this.matrixWorldNeedsUpdate=source.matrixWorldNeedsUpdate,this.layers.mask=source.layers.mask,this.visible=source.visible,this.castShadow=source.castShadow,this.receiveShadow=source.receiveShadow,this.frustumCulled=source.frustumCulled,this.renderOrder=source.renderOrder,this.userData=JSON.parse(JSON.stringify(source.userData)),!0===recursive)for(let i=0;i<source.children.length;i++){const child=source.children[i];this.add(child.clone())}return this}}),Scene.prototype=Object.assign(Object.create(Object3D.prototype),{constructor:Scene,isScene:!0,copy:function(source,recursive){return Object3D.prototype.copy.call(this,source,recursive),null!==source.background&&(this.background=source.background.clone()),null!==source.environment&&(this.environment=source.environment.clone()),null!==source.fog&&(this.fog=source.fog.clone()),null!==source.overrideMaterial&&(this.overrideMaterial=source.overrideMaterial.clone()),this.autoUpdate=source.autoUpdate,this.matrixAutoUpdate=source.matrixAutoUpdate,this},toJSON:function(meta){const data=Object3D.prototype.toJSON.call(this,meta);return null!==this.background&&(data.object.background=this.background.toJSON(meta)),null!==this.environment&&(data.object.environment=this.environment.toJSON(meta)),null!==this.fog&&(data.object.fog=this.fog.toJSON()),data},dispose:function(){this.dispatchEvent({type:"dispose"})}});const _points=[new Vector3,new Vector3,new Vector3,new Vector3,new Vector3,new Vector3,new Vector3,new Vector3],_vector$1=new Vector3,_box=new Box3,_v0=new Vector3,_v1$2=new Vector3,_v2=new Vector3,_f0=new Vector3,_f1=new Vector3,_f2=new Vector3,_center=new Vector3,_extents=new Vector3,_triangleNormal=new Vector3,_testAxis=new Vector3;function Box3(min,max){this.min=void 0!==min?min:new Vector3(1/0,1/0,1/0),this.max=void 0!==max?max:new Vector3(-1/0,-1/0,-1/0)}function satForAxes(axes,v0,v1,v2,extents){for(let i=0,j=axes.length-3;i<=j;i+=3){_testAxis.fromArray(axes,i);const r=extents.x*Math.abs(_testAxis.x)+extents.y*Math.abs(_testAxis.y)+extents.z*Math.abs(_testAxis.z),p0=v0.dot(_testAxis),p1=v1.dot(_testAxis),p2=v2.dot(_testAxis);if(Math.max(-Math.max(p0,p1,p2),Math.min(p0,p1,p2))>r)return!1}return!0}Object.assign(Box3.prototype,{isBox3:!0,set:function(min,max){return this.min.copy(min),this.max.copy(max),this},setFromArray:function(array){let minX=1/0,minY=1/0,minZ=1/0,maxX=-1/0,maxY=-1/0,maxZ=-1/0;for(let i=0,l=array.length;i<l;i+=3){const x=array[i],y=array[i+1],z=array[i+2];x<minX&&(minX=x),y<minY&&(minY=y),z<minZ&&(minZ=z),x>maxX&&(maxX=x),y>maxY&&(maxY=y),z>maxZ&&(maxZ=z)}return this.min.set(minX,minY,minZ),this.max.set(maxX,maxY,maxZ),this},setFromBufferAttribute:function(attribute){let minX=1/0,minY=1/0,minZ=1/0,maxX=-1/0,maxY=-1/0,maxZ=-1/0;for(let i=0,l=attribute.count;i<l;i++){const x=attribute.getX(i),y=attribute.getY(i),z=attribute.getZ(i);x<minX&&(minX=x),y<minY&&(minY=y),z<minZ&&(minZ=z),x>maxX&&(maxX=x),y>maxY&&(maxY=y),z>maxZ&&(maxZ=z)}return this.min.set(minX,minY,minZ),this.max.set(maxX,maxY,maxZ),this},setFromPoints:function(points){this.makeEmpty();for(let i=0,il=points.length;i<il;i++)this.expandByPoint(points[i]);return this},setFromCenterAndSize:function(center,size){const halfSize=_vector$1.copy(size).multiplyScalar(.5);return this.min.copy(center).sub(halfSize),this.max.copy(center).add(halfSize),this},setFromObject:function(object){return this.makeEmpty(),this.expandByObject(object)},clone:function(){return(new this.constructor).copy(this)},copy:function(box){return this.min.copy(box.min),this.max.copy(box.max),this},makeEmpty:function(){return this.min.x=this.min.y=this.min.z=1/0,this.max.x=this.max.y=this.max.z=-1/0,this},isEmpty:function(){return this.max.x<this.min.x||this.max.y<this.min.y||this.max.z<this.min.z},getCenter:function(target){return void 0===target&&(console.warn("THREE.Box3: .getCenter() target is now required"),target=new Vector3),this.isEmpty()?target.set(0,0,0):target.addVectors(this.min,this.max).multiplyScalar(.5)},getSize:function(target){return void 0===target&&(console.warn("THREE.Box3: .getSize() target is now required"),target=new Vector3),this.isEmpty()?target.set(0,0,0):target.subVectors(this.max,this.min)},expandByPoint:function(point){return this.min.min(point),this.max.max(point),this},expandByVector:function(vector){return this.min.sub(vector),this.max.add(vector),this},expandByScalar:function(scalar){return this.min.addScalar(-scalar),this.max.addScalar(scalar),this},expandByObject:function(object){object.updateWorldMatrix(!1,!1);const geometry=object.geometry;void 0!==geometry&&(null===geometry.boundingBox&&geometry.computeBoundingBox(),_box.copy(geometry.boundingBox),_box.applyMatrix4(object.matrixWorld),this.union(_box));const children=object.children;for(let i=0,l=children.length;i<l;i++)this.expandByObject(children[i]);return this},containsPoint:function(point){return!(point.x<this.min.x||point.x>this.max.x||point.y<this.min.y||point.y>this.max.y||point.z<this.min.z||point.z>this.max.z)},containsBox:function(box){return this.min.x<=box.min.x&&box.max.x<=this.max.x&&this.min.y<=box.min.y&&box.max.y<=this.max.y&&this.min.z<=box.min.z&&box.max.z<=this.max.z},getParameter:function(point,target){return void 0===target&&(console.warn("THREE.Box3: .getParameter() target is now required"),target=new Vector3),target.set((point.x-this.min.x)/(this.max.x-this.min.x),(point.y-this.min.y)/(this.max.y-this.min.y),(point.z-this.min.z)/(this.max.z-this.min.z))},intersectsBox:function(box){return!(box.max.x<this.min.x||box.min.x>this.max.x||box.max.y<this.min.y||box.min.y>this.max.y||box.max.z<this.min.z||box.min.z>this.max.z)},intersectsSphere:function(sphere){return this.clampPoint(sphere.center,_vector$1),_vector$1.distanceToSquared(sphere.center)<=sphere.radius*sphere.radius},intersectsPlane:function(plane){let min,max;return plane.normal.x>0?(min=plane.normal.x*this.min.x,max=plane.normal.x*this.max.x):(min=plane.normal.x*this.max.x,max=plane.normal.x*this.min.x),plane.normal.y>0?(min+=plane.normal.y*this.min.y,max+=plane.normal.y*this.max.y):(min+=plane.normal.y*this.max.y,max+=plane.normal.y*this.min.y),plane.normal.z>0?(min+=plane.normal.z*this.min.z,max+=plane.normal.z*this.max.z):(min+=plane.normal.z*this.max.z,max+=plane.normal.z*this.min.z),min<=-plane.constant&&max>=-plane.constant},intersectsTriangle:function(triangle){if(this.isEmpty())return!1;this.getCenter(_center),_extents.subVectors(this.max,_center),_v0.subVectors(triangle.a,_center),_v1$2.subVectors(triangle.b,_center),_v2.subVectors(triangle.c,_center),_f0.subVectors(_v1$2,_v0),_f1.subVectors(_v2,_v1$2),_f2.subVectors(_v0,_v2);let axes=[0,-_f0.z,_f0.y,0,-_f1.z,_f1.y,0,-_f2.z,_f2.y,_f0.z,0,-_f0.x,_f1.z,0,-_f1.x,_f2.z,0,-_f2.x,-_f0.y,_f0.x,0,-_f1.y,_f1.x,0,-_f2.y,_f2.x,0];return!!satForAxes(axes,_v0,_v1$2,_v2,_extents)&&(axes=[1,0,0,0,1,0,0,0,1],!!satForAxes(axes,_v0,_v1$2,_v2,_extents)&&(_triangleNormal.crossVectors(_f0,_f1),axes=[_triangleNormal.x,_triangleNormal.y,_triangleNormal.z],satForAxes(axes,_v0,_v1$2,_v2,_extents)))},clampPoint:function(point,target){return void 0===target&&(console.warn("THREE.Box3: .clampPoint() target is now required"),target=new Vector3),target.copy(point).clamp(this.min,this.max)},distanceToPoint:function(point){return _vector$1.copy(point).clamp(this.min,this.max).sub(point).length()},getBoundingSphere:function(target){return void 0===target&&console.error("THREE.Box3: .getBoundingSphere() target is now required"),this.getCenter(target.center),target.radius=.5*this.getSize(_vector$1).length(),target},intersect:function(box){return this.min.max(box.min),this.max.min(box.max),this.isEmpty()&&this.makeEmpty(),this},union:function(box){return this.min.min(box.min),this.max.max(box.max),this},applyMatrix4:function(matrix){return this.isEmpty()||(_points[0].set(this.min.x,this.min.y,this.min.z).applyMatrix4(matrix),_points[1].set(this.min.x,this.min.y,this.max.z).applyMatrix4(matrix),_points[2].set(this.min.x,this.max.y,this.min.z).applyMatrix4(matrix),_points[3].set(this.min.x,this.max.y,this.max.z).applyMatrix4(matrix),_points[4].set(this.max.x,this.min.y,this.min.z).applyMatrix4(matrix),_points[5].set(this.max.x,this.min.y,this.max.z).applyMatrix4(matrix),_points[6].set(this.max.x,this.max.y,this.min.z).applyMatrix4(matrix),_points[7].set(this.max.x,this.max.y,this.max.z).applyMatrix4(matrix),this.setFromPoints(_points)),this},translate:function(offset){return this.min.add(offset),this.max.add(offset),this},equals:function(box){return box.min.equals(this.min)&&box.max.equals(this.max)}});const _box$1=new Box3;function Sphere(center,radius){this.center=void 0!==center?center:new Vector3,this.radius=void 0!==radius?radius:-1}Object.assign(Sphere.prototype,{set:function(center,radius){return this.center.copy(center),this.radius=radius,this},setFromPoints:function(points,optionalCenter){const center=this.center;void 0!==optionalCenter?center.copy(optionalCenter):_box$1.setFromPoints(points).getCenter(center);let maxRadiusSq=0;for(let i=0,il=points.length;i<il;i++)maxRadiusSq=Math.max(maxRadiusSq,center.distanceToSquared(points[i]));return this.radius=Math.sqrt(maxRadiusSq),this},clone:function(){return(new this.constructor).copy(this)},copy:function(sphere){return this.center.copy(sphere.center),this.radius=sphere.radius,this},isEmpty:function(){return this.radius<0},makeEmpty:function(){return this.center.set(0,0,0),this.radius=-1,this},containsPoint:function(point){return point.distanceToSquared(this.center)<=this.radius*this.radius},distanceToPoint:function(point){return point.distanceTo(this.center)-this.radius},intersectsSphere:function(sphere){const radiusSum=this.radius+sphere.radius;return sphere.center.distanceToSquared(this.center)<=radiusSum*radiusSum},intersectsBox:function(box){return box.intersectsSphere(this)},intersectsPlane:function(plane){return Math.abs(plane.distanceToPoint(this.center))<=this.radius},clampPoint:function(point,target){const deltaLengthSq=this.center.distanceToSquared(point);return void 0===target&&(console.warn("THREE.Sphere: .clampPoint() target is now required"),target=new Vector3),target.copy(point),deltaLengthSq>this.radius*this.radius&&(target.sub(this.center).normalize(),target.multiplyScalar(this.radius).add(this.center)),target},getBoundingBox:function(target){return void 0===target&&(console.warn("THREE.Sphere: .getBoundingBox() target is now required"),target=new Box3),this.isEmpty()?(target.makeEmpty(),target):(target.set(this.center,this.center),target.expandByScalar(this.radius),target)},applyMatrix4:function(matrix){return this.center.applyMatrix4(matrix),this.radius=this.radius*matrix.getMaxScaleOnAxis(),this},translate:function(offset){return this.center.add(offset),this},equals:function(sphere){return sphere.center.equals(this.center)&&sphere.radius===this.radius}});const _vector$2=new Vector3,_segCenter=new Vector3,_segDir=new Vector3,_diff=new Vector3,_edge1=new Vector3,_edge2=new Vector3,_normal=new Vector3;function Ray(origin,direction){this.origin=void 0!==origin?origin:new Vector3,this.direction=void 0!==direction?direction:new Vector3(0,0,-1)}Object.assign(Ray.prototype,{set:function(origin,direction){return this.origin.copy(origin),this.direction.copy(direction),this},clone:function(){return(new this.constructor).copy(this)},copy:function(ray){return this.origin.copy(ray.origin),this.direction.copy(ray.direction),this},at:function(t,target){return void 0===target&&(console.warn("THREE.Ray: .at() target is now required"),target=new Vector3),target.copy(this.direction).multiplyScalar(t).add(this.origin)},lookAt:function(v){return this.direction.copy(v).sub(this.origin).normalize(),this},recast:function(t){return this.origin.copy(this.at(t,_vector$2)),this},closestPointToPoint:function(point,target){void 0===target&&(console.warn("THREE.Ray: .closestPointToPoint() target is now required"),target=new Vector3),target.subVectors(point,this.origin);const directionDistance=target.dot(this.direction);return directionDistance<0?target.copy(this.origin):target.copy(this.direction).multiplyScalar(directionDistance).add(this.origin)},distanceToPoint:function(point){return Math.sqrt(this.distanceSqToPoint(point))},distanceSqToPoint:function(point){const directionDistance=_vector$2.subVectors(point,this.origin).dot(this.direction);return directionDistance<0?this.origin.distanceToSquared(point):(_vector$2.copy(this.direction).multiplyScalar(directionDistance).add(this.origin),_vector$2.distanceToSquared(point))},distanceSqToSegment:function(v0,v1,optionalPointOnRay,optionalPointOnSegment){_segCenter.copy(v0).add(v1).multiplyScalar(.5),_segDir.copy(v1).sub(v0).normalize(),_diff.copy(this.origin).sub(_segCenter);const segExtent=.5*v0.distanceTo(v1),a01=-this.direction.dot(_segDir),b0=_diff.dot(this.direction),b1=-_diff.dot(_segDir),c=_diff.lengthSq(),det=Math.abs(1-a01*a01);let s0,s1,sqrDist,extDet;if(det>0)if(s0=a01*b1-b0,s1=a01*b0-b1,extDet=segExtent*det,s0>=0)if(s1>=-extDet)if(s1<=extDet){const invDet=1/det;s0*=invDet,s1*=invDet,sqrDist=s0*(s0+a01*s1+2*b0)+s1*(a01*s0+s1+2*b1)+c}else s1=segExtent,s0=Math.max(0,-(a01*s1+b0)),sqrDist=-s0*s0+s1*(s1+2*b1)+c;else s1=-segExtent,s0=Math.max(0,-(a01*s1+b0)),sqrDist=-s0*s0+s1*(s1+2*b1)+c;else s1<=-extDet?(s0=Math.max(0,-(-a01*segExtent+b0)),s1=s0>0?-segExtent:Math.min(Math.max(-segExtent,-b1),segExtent),sqrDist=-s0*s0+s1*(s1+2*b1)+c):s1<=extDet?(s0=0,s1=Math.min(Math.max(-segExtent,-b1),segExtent),sqrDist=s1*(s1+2*b1)+c):(s0=Math.max(0,-(a01*segExtent+b0)),s1=s0>0?segExtent:Math.min(Math.max(-segExtent,-b1),segExtent),sqrDist=-s0*s0+s1*(s1+2*b1)+c);else s1=a01>0?-segExtent:segExtent,s0=Math.max(0,-(a01*s1+b0)),sqrDist=-s0*s0+s1*(s1+2*b1)+c;return optionalPointOnRay&&optionalPointOnRay.copy(this.direction).multiplyScalar(s0).add(this.origin),optionalPointOnSegment&&optionalPointOnSegment.copy(_segDir).multiplyScalar(s1).add(_segCenter),sqrDist},intersectSphere:function(sphere,target){_vector$2.subVectors(sphere.center,this.origin);const tca=_vector$2.dot(this.direction),d2=_vector$2.dot(_vector$2)-tca*tca,radius2=sphere.radius*sphere.radius;if(d2>radius2)return null;const thc=Math.sqrt(radius2-d2),t0=tca-thc,t1=tca+thc;return t0<0&&t1<0?null:t0<0?this.at(t1,target):this.at(t0,target)},intersectsSphere:function(sphere){return this.distanceSqToPoint(sphere.center)<=sphere.radius*sphere.radius},distanceToPlane:function(plane){const denominator=plane.normal.dot(this.direction);if(0===denominator)return 0===plane.distanceToPoint(this.origin)?0:null;const t=-(this.origin.dot(plane.normal)+plane.constant)/denominator;return t>=0?t:null},intersectPlane:function(plane,target){const t=this.distanceToPlane(plane);return null===t?null:this.at(t,target)},intersectsPlane:function(plane){const distToPoint=plane.distanceToPoint(this.origin);if(0===distToPoint)return!0;return plane.normal.dot(this.direction)*distToPoint<0},intersectBox:function(box,target){let tmin,tmax,tymin,tymax,tzmin,tzmax;const invdirx=1/this.direction.x,invdiry=1/this.direction.y,invdirz=1/this.direction.z,origin=this.origin;return invdirx>=0?(tmin=(box.min.x-origin.x)*invdirx,tmax=(box.max.x-origin.x)*invdirx):(tmin=(box.max.x-origin.x)*invdirx,tmax=(box.min.x-origin.x)*invdirx),invdiry>=0?(tymin=(box.min.y-origin.y)*invdiry,tymax=(box.max.y-origin.y)*invdiry):(tymin=(box.max.y-origin.y)*invdiry,tymax=(box.min.y-origin.y)*invdiry),tmin>tymax||tymin>tmax?null:((tymin>tmin||tmin!=tmin)&&(tmin=tymin),(tymax<tmax||tmax!=tmax)&&(tmax=tymax),invdirz>=0?(tzmin=(box.min.z-origin.z)*invdirz,tzmax=(box.max.z-origin.z)*invdirz):(tzmin=(box.max.z-origin.z)*invdirz,tzmax=(box.min.z-origin.z)*invdirz),tmin>tzmax||tzmin>tmax?null:((tzmin>tmin||tmin!=tmin)&&(tmin=tzmin),(tzmax<tmax||tmax!=tmax)&&(tmax=tzmax),tmax<0?null:this.at(tmin>=0?tmin:tmax,target)))},intersectsBox:function(box){return null!==this.intersectBox(box,_vector$2)},intersectTriangle:function(a,b,c,backfaceCulling,target){_edge1.subVectors(b,a),_edge2.subVectors(c,a),_normal.crossVectors(_edge1,_edge2);let sign,DdN=this.direction.dot(_normal);if(DdN>0){if(backfaceCulling)return null;sign=1}else{if(!(DdN<0))return null;sign=-1,DdN=-DdN}_diff.subVectors(this.origin,a);const DdQxE2=sign*this.direction.dot(_edge2.crossVectors(_diff,_edge2));if(DdQxE2<0)return null;const DdE1xQ=sign*this.direction.dot(_edge1.cross(_diff));if(DdE1xQ<0)return null;if(DdQxE2+DdE1xQ>DdN)return null;const QdN=-sign*_diff.dot(_normal);return QdN<0?null:this.at(QdN/DdN,target)},applyMatrix4:function(matrix4){return this.origin.applyMatrix4(matrix4),this.direction.transformDirection(matrix4),this},equals:function(ray){return ray.origin.equals(this.origin)&&ray.direction.equals(this.direction)}});const _vector1=new Vector3,_vector2=new Vector3,_normalMatrix=new Matrix3;function Plane(normal,constant){this.normal=void 0!==normal?normal:new Vector3(1,0,0),this.constant=void 0!==constant?constant:0}Object.assign(Plane.prototype,{isPlane:!0,set:function(normal,constant){return this.normal.copy(normal),this.constant=constant,this},setComponents:function(x,y,z,w){return this.normal.set(x,y,z),this.constant=w,this},setFromNormalAndCoplanarPoint:function(normal,point){return this.normal.copy(normal),this.constant=-point.dot(this.normal),this},setFromCoplanarPoints:function(a,b,c){const normal=_vector1.subVectors(c,b).cross(_vector2.subVectors(a,b)).normalize();return this.setFromNormalAndCoplanarPoint(normal,a),this},clone:function(){return(new this.constructor).copy(this)},copy:function(plane){return this.normal.copy(plane.normal),this.constant=plane.constant,this},normalize:function(){const inverseNormalLength=1/this.normal.length();return this.normal.multiplyScalar(inverseNormalLength),this.constant*=inverseNormalLength,this},negate:function(){return this.constant*=-1,this.normal.negate(),this},distanceToPoint:function(point){return this.normal.dot(point)+this.constant},distanceToSphere:function(sphere){return this.distanceToPoint(sphere.center)-sphere.radius},projectPoint:function(point,target){return void 0===target&&(console.warn("THREE.Plane: .projectPoint() target is now required"),target=new Vector3),target.copy(this.normal).multiplyScalar(-this.distanceToPoint(point)).add(point)},intersectLine:function(line,target){void 0===target&&(console.warn("THREE.Plane: .intersectLine() target is now required"),target=new Vector3);const direction=line.delta(_vector1),denominator=this.normal.dot(direction);if(0===denominator)return 0===this.distanceToPoint(line.start)?target.copy(line.start):void 0;const t=-(line.start.dot(this.normal)+this.constant)/denominator;return t<0||t>1?void 0:target.copy(direction).multiplyScalar(t).add(line.start)},intersectsLine:function(line){const startSign=this.distanceToPoint(line.start),endSign=this.distanceToPoint(line.end);return startSign<0&&endSign>0||endSign<0&&startSign>0},intersectsBox:function(box){return box.intersectsPlane(this)},intersectsSphere:function(sphere){return sphere.intersectsPlane(this)},coplanarPoint:function(target){return void 0===target&&(console.warn("THREE.Plane: .coplanarPoint() target is now required"),target=new Vector3),target.copy(this.normal).multiplyScalar(-this.constant)},applyMatrix4:function(matrix,optionalNormalMatrix){const normalMatrix=optionalNormalMatrix||_normalMatrix.getNormalMatrix(matrix),referencePoint=this.coplanarPoint(_vector1).applyMatrix4(matrix),normal=this.normal.applyMatrix3(normalMatrix).normalize();return this.constant=-referencePoint.dot(normal),this},translate:function(offset){return this.constant-=offset.dot(this.normal),this},equals:function(plane){return plane.normal.equals(this.normal)&&plane.constant===this.constant}});const _v0$1=new Vector3,_v1$3=new Vector3,_v2$1=new Vector3,_v3=new Vector3,_vab=new Vector3,_vac=new Vector3,_vbc=new Vector3,_vap=new Vector3,_vbp=new Vector3,_vcp=new Vector3;function Triangle(a,b,c){this.a=void 0!==a?a:new Vector3,this.b=void 0!==b?b:new Vector3,this.c=void 0!==c?c:new Vector3}Object.assign(Triangle,{getNormal:function(a,b,c,target){void 0===target&&(console.warn("THREE.Triangle: .getNormal() target is now required"),target=new Vector3),target.subVectors(c,b),_v0$1.subVectors(a,b),target.cross(_v0$1);const targetLengthSq=target.lengthSq();return targetLengthSq>0?target.multiplyScalar(1/Math.sqrt(targetLengthSq)):target.set(0,0,0)},getBarycoord:function(point,a,b,c,target){_v0$1.subVectors(c,a),_v1$3.subVectors(b,a),_v2$1.subVectors(point,a);const dot00=_v0$1.dot(_v0$1),dot01=_v0$1.dot(_v1$3),dot02=_v0$1.dot(_v2$1),dot11=_v1$3.dot(_v1$3),dot12=_v1$3.dot(_v2$1),denom=dot00*dot11-dot01*dot01;if(void 0===target&&(console.warn("THREE.Triangle: .getBarycoord() target is now required"),target=new Vector3),0===denom)return target.set(-2,-1,-1);const invDenom=1/denom,u=(dot11*dot02-dot01*dot12)*invDenom,v=(dot00*dot12-dot01*dot02)*invDenom;return target.set(1-u-v,v,u)},containsPoint:function(point,a,b,c){return Triangle.getBarycoord(point,a,b,c,_v3),_v3.x>=0&&_v3.y>=0&&_v3.x+_v3.y<=1},getUV:function(point,p1,p2,p3,uv1,uv2,uv3,target){return this.getBarycoord(point,p1,p2,p3,_v3),target.set(0,0),target.addScaledVector(uv1,_v3.x),target.addScaledVector(uv2,_v3.y),target.addScaledVector(uv3,_v3.z),target},isFrontFacing:function(a,b,c,direction){return _v0$1.subVectors(c,b),_v1$3.subVectors(a,b),_v0$1.cross(_v1$3).dot(direction)<0}}),Object.assign(Triangle.prototype,{set:function(a,b,c){return this.a.copy(a),this.b.copy(b),this.c.copy(c),this},setFromPointsAndIndices:function(points,i0,i1,i2){return this.a.copy(points[i0]),this.b.copy(points[i1]),this.c.copy(points[i2]),this},clone:function(){return(new this.constructor).copy(this)},copy:function(triangle){return this.a.copy(triangle.a),this.b.copy(triangle.b),this.c.copy(triangle.c),this},getArea:function(){return _v0$1.subVectors(this.c,this.b),_v1$3.subVectors(this.a,this.b),.5*_v0$1.cross(_v1$3).length()},getMidpoint:function(target){return void 0===target&&(console.warn("THREE.Triangle: .getMidpoint() target is now required"),target=new Vector3),target.addVectors(this.a,this.b).add(this.c).multiplyScalar(1/3)},getNormal:function(target){return Triangle.getNormal(this.a,this.b,this.c,target)},getPlane:function(target){return void 0===target&&(console.warn("THREE.Triangle: .getPlane() target is now required"),target=new Plane),target.setFromCoplanarPoints(this.a,this.b,this.c)},getBarycoord:function(point,target){return Triangle.getBarycoord(point,this.a,this.b,this.c,target)},getUV:function(point,uv1,uv2,uv3,target){return Triangle.getUV(point,this.a,this.b,this.c,uv1,uv2,uv3,target)},containsPoint:function(point){return Triangle.containsPoint(point,this.a,this.b,this.c)},isFrontFacing:function(direction){return Triangle.isFrontFacing(this.a,this.b,this.c,direction)},intersectsBox:function(box){return box.intersectsTriangle(this)},closestPointToPoint:function(p,target){void 0===target&&(console.warn("THREE.Triangle: .closestPointToPoint() target is now required"),target=new Vector3);const a=this.a,b=this.b,c=this.c;let v,w;_vab.subVectors(b,a),_vac.subVectors(c,a),_vap.subVectors(p,a);const d1=_vab.dot(_vap),d2=_vac.dot(_vap);if(d1<=0&&d2<=0)return target.copy(a);_vbp.subVectors(p,b);const d3=_vab.dot(_vbp),d4=_vac.dot(_vbp);if(d3>=0&&d4<=d3)return target.copy(b);const vc=d1*d4-d3*d2;if(vc<=0&&d1>=0&&d3<=0)return v=d1/(d1-d3),target.copy(a).addScaledVector(_vab,v);_vcp.subVectors(p,c);const d5=_vab.dot(_vcp),d6=_vac.dot(_vcp);if(d6>=0&&d5<=d6)return target.copy(c);const vb=d5*d2-d1*d6;if(vb<=0&&d2>=0&&d6<=0)return w=d2/(d2-d6),target.copy(a).addScaledVector(_vac,w);const va=d3*d6-d5*d4;if(va<=0&&d4-d3>=0&&d5-d6>=0)return _vbc.subVectors(c,b),w=(d4-d3)/(d4-d3+(d5-d6)),target.copy(b).addScaledVector(_vbc,w);const denom=1/(va+vb+vc);return v=vb*denom,w=vc*denom,target.copy(a).addScaledVector(_vab,v).addScaledVector(_vac,w)},equals:function(triangle){return triangle.a.equals(this.a)&&triangle.b.equals(this.b)&&triangle.c.equals(this.c)}});const _colorKeywords={aliceblue:15792383,antiquewhite:16444375,aqua:65535,aquamarine:8388564,azure:15794175,beige:16119260,bisque:16770244,black:0,blanchedalmond:16772045,blue:255,blueviolet:9055202,brown:10824234,burlywood:14596231,cadetblue:6266528,chartreuse:8388352,chocolate:13789470,coral:16744272,cornflowerblue:6591981,cornsilk:16775388,crimson:14423100,cyan:65535,darkblue:139,darkcyan:35723,darkgoldenrod:12092939,darkgray:11119017,darkgreen:25600,darkgrey:11119017,darkkhaki:12433259,darkmagenta:9109643,darkolivegreen:5597999,darkorange:16747520,darkorchid:10040012,darkred:9109504,darksalmon:15308410,darkseagreen:9419919,darkslateblue:4734347,darkslategray:3100495,darkslategrey:3100495,darkturquoise:52945,darkviolet:9699539,deeppink:16716947,deepskyblue:49151,dimgray:6908265,dimgrey:6908265,dodgerblue:2003199,firebrick:11674146,floralwhite:16775920,forestgreen:2263842,fuchsia:16711935,gainsboro:14474460,ghostwhite:16316671,gold:16766720,goldenrod:14329120,gray:8421504,green:32768,greenyellow:11403055,grey:8421504,honeydew:15794160,hotpink:16738740,indianred:13458524,indigo:4915330,ivory:16777200,khaki:15787660,lavender:15132410,lavenderblush:16773365,lawngreen:8190976,lemonchiffon:16775885,lightblue:11393254,lightcoral:15761536,lightcyan:14745599,lightgoldenrodyellow:16448210,lightgray:13882323,lightgreen:9498256,lightgrey:13882323,lightpink:16758465,lightsalmon:16752762,lightseagreen:2142890,lightskyblue:8900346,lightslategray:7833753,lightslategrey:7833753,lightsteelblue:11584734,lightyellow:16777184,lime:65280,limegreen:3329330,linen:16445670,magenta:16711935,maroon:8388608,mediumaquamarine:6737322,mediumblue:205,mediumorchid:12211667,mediumpurple:9662683,mediumseagreen:3978097,mediumslateblue:8087790,mediumspringgreen:64154,mediumturquoise:4772300,mediumvioletred:13047173,midnightblue:1644912,mintcream:16121850,mistyrose:16770273,moccasin:16770229,navajowhite:16768685,navy:128,oldlace:16643558,olive:8421376,olivedrab:7048739,orange:16753920,orangered:16729344,orchid:14315734,palegoldenrod:15657130,palegreen:10025880,paleturquoise:11529966,palevioletred:14381203,papayawhip:16773077,peachpuff:16767673,peru:13468991,pink:16761035,plum:14524637,powderblue:11591910,purple:8388736,rebeccapurple:6697881,red:16711680,rosybrown:12357519,royalblue:4286945,saddlebrown:9127187,salmon:16416882,sandybrown:16032864,seagreen:3050327,seashell:16774638,sienna:10506797,silver:12632256,skyblue:8900331,slateblue:6970061,slategray:7372944,slategrey:7372944,snow:16775930,springgreen:65407,steelblue:4620980,tan:13808780,teal:32896,thistle:14204888,tomato:16737095,turquoise:4251856,violet:15631086,wheat:16113331,white:16777215,whitesmoke:16119285,yellow:16776960,yellowgreen:10145074},_hslA={h:0,s:0,l:0},_hslB={h:0,s:0,l:0};function Color(r,g,b){return void 0===g&&void 0===b?this.set(r):this.setRGB(r,g,b)}function hue2rgb(p,q,t){return t<0&&(t+=1),t>1&&(t-=1),t<1/6?p+6*(q-p)*t:t<.5?q:t<2/3?p+6*(q-p)*(2/3-t):p}function SRGBToLinear(c){return c<.04045?.0773993808*c:Math.pow(.9478672986*c+.0521327014,2.4)}function LinearToSRGB(c){return c<.0031308?12.92*c:1.055*Math.pow(c,.41666)-.055}function Face3(a,b,c,normal,color,materialIndex){this.a=a,this.b=b,this.c=c,this.normal=normal&&normal.isVector3?normal:new Vector3,this.vertexNormals=Array.isArray(normal)?normal:[],this.color=color&&color.isColor?color:new Color,this.vertexColors=Array.isArray(color)?color:[],this.materialIndex=void 0!==materialIndex?materialIndex:0}Object.assign(Color.prototype,{isColor:!0,r:1,g:1,b:1,set:function(value){return value&&value.isColor?this.copy(value):"number"==typeof value?this.setHex(value):"string"==typeof value&&this.setStyle(value),this},setScalar:function(scalar){return this.r=scalar,this.g=scalar,this.b=scalar,this},setHex:function(hex){return hex=Math.floor(hex),this.r=(hex>>16&255)/255,this.g=(hex>>8&255)/255,this.b=(255&hex)/255,this},setRGB:function(r,g,b){return this.r=r,this.g=g,this.b=b,this},setHSL:function(h,s,l){if(h=MathUtils.euclideanModulo(h,1),s=MathUtils.clamp(s,0,1),l=MathUtils.clamp(l,0,1),0===s)this.r=this.g=this.b=l;else{const p=l<=.5?l*(1+s):l+s-l*s,q=2*l-p;this.r=hue2rgb(q,p,h+1/3),this.g=hue2rgb(q,p,h),this.b=hue2rgb(q,p,h-1/3)}return this},setStyle:function(style){function handleAlpha(string){void 0!==string&&parseFloat(string)<1&&console.warn("THREE.Color: Alpha component of "+style+" will be ignored.")}let m;if(m=/^((?:rgb|hsl)a?)\(\s*([^\)]*)\)/.exec(style)){let color;const name=m[1],components=m[2];switch(name){case"rgb":case"rgba":if(color=/^(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*(,\s*([0-9]*\.?[0-9]+)\s*)?$/.exec(components))return this.r=Math.min(255,parseInt(color[1],10))/255,this.g=Math.min(255,parseInt(color[2],10))/255,this.b=Math.min(255,parseInt(color[3],10))/255,handleAlpha(color[5]),this;if(color=/^(\d+)\%\s*,\s*(\d+)\%\s*,\s*(\d+)\%\s*(,\s*([0-9]*\.?[0-9]+)\s*)?$/.exec(components))return this.r=Math.min(100,parseInt(color[1],10))/100,this.g=Math.min(100,parseInt(color[2],10))/100,this.b=Math.min(100,parseInt(color[3],10))/100,handleAlpha(color[5]),this;break;case"hsl":case"hsla":if(color=/^([0-9]*\.?[0-9]+)\s*,\s*(\d+)\%\s*,\s*(\d+)\%\s*(,\s*([0-9]*\.?[0-9]+)\s*)?$/.exec(components)){const h=parseFloat(color[1])/360,s=parseInt(color[2],10)/100,l=parseInt(color[3],10)/100;return handleAlpha(color[5]),this.setHSL(h,s,l)}}}else if(m=/^\#([A-Fa-f0-9]+)$/.exec(style)){const hex=m[1],size=hex.length;if(3===size)return this.r=parseInt(hex.charAt(0)+hex.charAt(0),16)/255,this.g=parseInt(hex.charAt(1)+hex.charAt(1),16)/255,this.b=parseInt(hex.charAt(2)+hex.charAt(2),16)/255,this;if(6===size)return this.r=parseInt(hex.charAt(0)+hex.charAt(1),16)/255,this.g=parseInt(hex.charAt(2)+hex.charAt(3),16)/255,this.b=parseInt(hex.charAt(4)+hex.charAt(5),16)/255,this}return style&&style.length>0?this.setColorName(style):this},setColorName:function(style){const hex=_colorKeywords[style];return void 0!==hex?this.setHex(hex):console.warn("THREE.Color: Unknown color "+style),this},clone:function(){return new this.constructor(this.r,this.g,this.b)},copy:function(color){return this.r=color.r,this.g=color.g,this.b=color.b,this},copyGammaToLinear:function(color,gammaFactor){return void 0===gammaFactor&&(gammaFactor=2),this.r=Math.pow(color.r,gammaFactor),this.g=Math.pow(color.g,gammaFactor),this.b=Math.pow(color.b,gammaFactor),this},copyLinearToGamma:function(color,gammaFactor){void 0===gammaFactor&&(gammaFactor=2);const safeInverse=gammaFactor>0?1/gammaFactor:1;return this.r=Math.pow(color.r,safeInverse),this.g=Math.pow(color.g,safeInverse),this.b=Math.pow(color.b,safeInverse),this},convertGammaToLinear:function(gammaFactor){return this.copyGammaToLinear(this,gammaFactor),this},convertLinearToGamma:function(gammaFactor){return this.copyLinearToGamma(this,gammaFactor),this},copySRGBToLinear:function(color){return this.r=SRGBToLinear(color.r),this.g=SRGBToLinear(color.g),this.b=SRGBToLinear(color.b),this},copyLinearToSRGB:function(color){return this.r=LinearToSRGB(color.r),this.g=LinearToSRGB(color.g),this.b=LinearToSRGB(color.b),this},convertSRGBToLinear:function(){return this.copySRGBToLinear(this),this},convertLinearToSRGB:function(){return this.copyLinearToSRGB(this),this},getHex:function(){return 255*this.r<<16^255*this.g<<8^255*this.b<<0},getHexString:function(){return("000000"+this.getHex().toString(16)).slice(-6)},getHSL:function(target){void 0===target&&(console.warn("THREE.Color: .getHSL() target is now required"),target={h:0,s:0,l:0});const r=this.r,g=this.g,b=this.b,max=Math.max(r,g,b),min=Math.min(r,g,b);let hue,saturation;const lightness=(min+max)/2;if(min===max)hue=0,saturation=0;else{const delta=max-min;switch(saturation=lightness<=.5?delta/(max+min):delta/(2-max-min),max){case r:hue=(g-b)/delta+(g<b?6:0);break;case g:hue=(b-r)/delta+2;break;case b:hue=(r-g)/delta+4}hue/=6}return target.h=hue,target.s=saturation,target.l=lightness,target},getStyle:function(){return"rgb("+(255*this.r|0)+","+(255*this.g|0)+","+(255*this.b|0)+")"},offsetHSL:function(h,s,l){return this.getHSL(_hslA),_hslA.h+=h,_hslA.s+=s,_hslA.l+=l,this.setHSL(_hslA.h,_hslA.s,_hslA.l),this},add:function(color){return this.r+=color.r,this.g+=color.g,this.b+=color.b,this},addColors:function(color1,color2){return this.r=color1.r+color2.r,this.g=color1.g+color2.g,this.b=color1.b+color2.b,this},addScalar:function(s){return this.r+=s,this.g+=s,this.b+=s,this},sub:function(color){return this.r=Math.max(0,this.r-color.r),this.g=Math.max(0,this.g-color.g),this.b=Math.max(0,this.b-color.b),this},multiply:function(color){return this.r*=color.r,this.g*=color.g,this.b*=color.b,this},multiplyScalar:function(s){return this.r*=s,this.g*=s,this.b*=s,this},lerp:function(color,alpha){return this.r+=(color.r-this.r)*alpha,this.g+=(color.g-this.g)*alpha,this.b+=(color.b-this.b)*alpha,this},lerpHSL:function(color,alpha){this.getHSL(_hslA),color.getHSL(_hslB);const h=MathUtils.lerp(_hslA.h,_hslB.h,alpha),s=MathUtils.lerp(_hslA.s,_hslB.s,alpha),l=MathUtils.lerp(_hslA.l,_hslB.l,alpha);return this.setHSL(h,s,l),this},equals:function(c){return c.r===this.r&&c.g===this.g&&c.b===this.b},fromArray:function(array,offset){return void 0===offset&&(offset=0),this.r=array[offset],this.g=array[offset+1],this.b=array[offset+2],this},toArray:function(array,offset){return void 0===array&&(array=[]),void 0===offset&&(offset=0),array[offset]=this.r,array[offset+1]=this.g,array[offset+2]=this.b,array},fromBufferAttribute:function(attribute,index){return this.r=attribute.getX(index),this.g=attribute.getY(index),this.b=attribute.getZ(index),!0===attribute.normalized&&(this.r/=255,this.g/=255,this.b/=255),this},toJSON:function(){return this.getHex()}}),Color.NAMES=_colorKeywords,Object.assign(Face3.prototype,{clone:function(){return(new this.constructor).copy(this)},copy:function(source){this.a=source.a,this.b=source.b,this.c=source.c,this.normal.copy(source.normal),this.color.copy(source.color),this.materialIndex=source.materialIndex;for(let i=0,il=source.vertexNormals.length;i<il;i++)this.vertexNormals[i]=source.vertexNormals[i].clone();for(let i=0,il=source.vertexColors.length;i<il;i++)this.vertexColors[i]=source.vertexColors[i].clone();return this}});let materialId=0;function Material(){Object.defineProperty(this,"id",{value:materialId++}),this.uuid=MathUtils.generateUUID(),this.name="",this.type="Material",this.fog=!0,this.blending=1,this.side=0,this.flatShading=!1,this.vertexColors=!1,this.opacity=1,this.transparent=!1,this.blendSrc=204,this.blendDst=205,this.blendEquation=100,this.blendSrcAlpha=null,this.blendDstAlpha=null,this.blendEquationAlpha=null,this.depthFunc=3,this.depthTest=!0,this.depthWrite=!0,this.stencilWriteMask=255,this.stencilFunc=519,this.stencilRef=0,this.stencilFuncMask=255,this.stencilFail=7680,this.stencilZFail=7680,this.stencilZPass=7680,this.stencilWrite=!1,this.clippingPlanes=null,this.clipIntersection=!1,this.clipShadows=!1,this.shadowSide=null,this.colorWrite=!0,this.precision=null,this.polygonOffset=!1,this.polygonOffsetFactor=0,this.polygonOffsetUnits=0,this.dithering=!1,this.alphaTest=0,this.premultipliedAlpha=!1,this.visible=!0,this.toneMapped=!0,this.userData={},this.version=0}function MeshBasicMaterial(parameters){Material.call(this),this.type="MeshBasicMaterial",this.color=new Color(16777215),this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.specularMap=null,this.alphaMap=null,this.envMap=null,this.combine=0,this.reflectivity=1,this.refractionRatio=.98,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.skinning=!1,this.morphTargets=!1,this.setValues(parameters)}Material.prototype=Object.assign(Object.create(EventDispatcher.prototype),{constructor:Material,isMaterial:!0,onBeforeCompile:function(){},customProgramCacheKey:function(){return this.onBeforeCompile.toString()},setValues:function(values){if(void 0!==values)for(const key in values){const newValue=values[key];if(void 0===newValue){console.warn("THREE.Material: '"+key+"' parameter is undefined.");continue}if("shading"===key){console.warn("THREE."+this.type+": .shading has been removed. Use the boolean .flatShading instead."),this.flatShading=1===newValue;continue}const currentValue=this[key];void 0!==currentValue?currentValue&&currentValue.isColor?currentValue.set(newValue):currentValue&&currentValue.isVector3&&newValue&&newValue.isVector3?currentValue.copy(newValue):this[key]=newValue:console.warn("THREE."+this.type+": '"+key+"' is not a property of this material.")}},toJSON:function(meta){const isRoot=void 0===meta||"string"==typeof meta;isRoot&&(meta={textures:{},images:{}});const data={metadata:{version:4.5,type:"Material",generator:"Material.toJSON"}};function extractFromCache(cache){const values=[];for(const key in cache){const data=cache[key];delete data.metadata,values.push(data)}return values}if(data.uuid=this.uuid,data.type=this.type,""!==this.name&&(data.name=this.name),this.color&&this.color.isColor&&(data.color=this.color.getHex()),void 0!==this.roughness&&(data.roughness=this.roughness),void 0!==this.metalness&&(data.metalness=this.metalness),this.sheen&&this.sheen.isColor&&(data.sheen=this.sheen.getHex()),this.emissive&&this.emissive.isColor&&(data.emissive=this.emissive.getHex()),this.emissiveIntensity&&1!==this.emissiveIntensity&&(data.emissiveIntensity=this.emissiveIntensity),this.specular&&this.specular.isColor&&(data.specular=this.specular.getHex()),void 0!==this.shininess&&(data.shininess=this.shininess),void 0!==this.clearcoat&&(data.clearcoat=this.clearcoat),void 0!==this.clearcoatRoughness&&(data.clearcoatRoughness=this.clearcoatRoughness),this.clearcoatMap&&this.clearcoatMap.isTexture&&(data.clearcoatMap=this.clearcoatMap.toJSON(meta).uuid),this.clearcoatRoughnessMap&&this.clearcoatRoughnessMap.isTexture&&(data.clearcoatRoughnessMap=this.clearcoatRoughnessMap.toJSON(meta).uuid),this.clearcoatNormalMap&&this.clearcoatNormalMap.isTexture&&(data.clearcoatNormalMap=this.clearcoatNormalMap.toJSON(meta).uuid,data.clearcoatNormalScale=this.clearcoatNormalScale.toArray()),this.map&&this.map.isTexture&&(data.map=this.map.toJSON(meta).uuid),this.matcap&&this.matcap.isTexture&&(data.matcap=this.matcap.toJSON(meta).uuid),this.alphaMap&&this.alphaMap.isTexture&&(data.alphaMap=this.alphaMap.toJSON(meta).uuid),this.lightMap&&this.lightMap.isTexture&&(data.lightMap=this.lightMap.toJSON(meta).uuid),this.aoMap&&this.aoMap.isTexture&&(data.aoMap=this.aoMap.toJSON(meta).uuid,data.aoMapIntensity=this.aoMapIntensity),this.bumpMap&&this.bumpMap.isTexture&&(data.bumpMap=this.bumpMap.toJSON(meta).uuid,data.bumpScale=this.bumpScale),this.normalMap&&this.normalMap.isTexture&&(data.normalMap=this.normalMap.toJSON(meta).uuid,data.normalMapType=this.normalMapType,data.normalScale=this.normalScale.toArray()),this.displacementMap&&this.displacementMap.isTexture&&(data.displacementMap=this.displacementMap.toJSON(meta).uuid,data.displacementScale=this.displacementScale,data.displacementBias=this.displacementBias),this.roughnessMap&&this.roughnessMap.isTexture&&(data.roughnessMap=this.roughnessMap.toJSON(meta).uuid),this.metalnessMap&&this.metalnessMap.isTexture&&(data.metalnessMap=this.metalnessMap.toJSON(meta).uuid),this.emissiveMap&&this.emissiveMap.isTexture&&(data.emissiveMap=this.emissiveMap.toJSON(meta).uuid),this.specularMap&&this.specularMap.isTexture&&(data.specularMap=this.specularMap.toJSON(meta).uuid),this.envMap&&this.envMap.isTexture&&(data.envMap=this.envMap.toJSON(meta).uuid,data.reflectivity=this.reflectivity,data.refractionRatio=this.refractionRatio,void 0!==this.combine&&(data.combine=this.combine),void 0!==this.envMapIntensity&&(data.envMapIntensity=this.envMapIntensity)),this.gradientMap&&this.gradientMap.isTexture&&(data.gradientMap=this.gradientMap.toJSON(meta).uuid),void 0!==this.size&&(data.size=this.size),void 0!==this.sizeAttenuation&&(data.sizeAttenuation=this.sizeAttenuation),1!==this.blending&&(data.blending=this.blending),!0===this.flatShading&&(data.flatShading=this.flatShading),0!==this.side&&(data.side=this.side),this.vertexColors&&(data.vertexColors=!0),this.opacity<1&&(data.opacity=this.opacity),!0===this.transparent&&(data.transparent=this.transparent),data.depthFunc=this.depthFunc,data.depthTest=this.depthTest,data.depthWrite=this.depthWrite,data.stencilWrite=this.stencilWrite,data.stencilWriteMask=this.stencilWriteMask,data.stencilFunc=this.stencilFunc,data.stencilRef=this.stencilRef,data.stencilFuncMask=this.stencilFuncMask,data.stencilFail=this.stencilFail,data.stencilZFail=this.stencilZFail,data.stencilZPass=this.stencilZPass,this.rotation&&0!==this.rotation&&(data.rotation=this.rotation),!0===this.polygonOffset&&(data.polygonOffset=!0),0!==this.polygonOffsetFactor&&(data.polygonOffsetFactor=this.polygonOffsetFactor),0!==this.polygonOffsetUnits&&(data.polygonOffsetUnits=this.polygonOffsetUnits),this.linewidth&&1!==this.linewidth&&(data.linewidth=this.linewidth),void 0!==this.dashSize&&(data.dashSize=this.dashSize),void 0!==this.gapSize&&(data.gapSize=this.gapSize),void 0!==this.scale&&(data.scale=this.scale),!0===this.dithering&&(data.dithering=!0),this.alphaTest>0&&(data.alphaTest=this.alphaTest),!0===this.premultipliedAlpha&&(data.premultipliedAlpha=this.premultipliedAlpha),!0===this.wireframe&&(data.wireframe=this.wireframe),this.wireframeLinewidth>1&&(data.wireframeLinewidth=this.wireframeLinewidth),"round"!==this.wireframeLinecap&&(data.wireframeLinecap=this.wireframeLinecap),"round"!==this.wireframeLinejoin&&(data.wireframeLinejoin=this.wireframeLinejoin),!0===this.morphTargets&&(data.morphTargets=!0),!0===this.morphNormals&&(data.morphNormals=!0),!0===this.skinning&&(data.skinning=!0),!1===this.visible&&(data.visible=!1),!1===this.toneMapped&&(data.toneMapped=!1),"{}"!==JSON.stringify(this.userData)&&(data.userData=this.userData),isRoot){const textures=extractFromCache(meta.textures),images=extractFromCache(meta.images);textures.length>0&&(data.textures=textures),images.length>0&&(data.images=images)}return data},clone:function(){return(new this.constructor).copy(this)},copy:function(source){this.name=source.name,this.fog=source.fog,this.blending=source.blending,this.side=source.side,this.flatShading=source.flatShading,this.vertexColors=source.vertexColors,this.opacity=source.opacity,this.transparent=source.transparent,this.blendSrc=source.blendSrc,this.blendDst=source.blendDst,this.blendEquation=source.blendEquation,this.blendSrcAlpha=source.blendSrcAlpha,this.blendDstAlpha=source.blendDstAlpha,this.blendEquationAlpha=source.blendEquationAlpha,this.depthFunc=source.depthFunc,this.depthTest=source.depthTest,this.depthWrite=source.depthWrite,this.stencilWriteMask=source.stencilWriteMask,this.stencilFunc=source.stencilFunc,this.stencilRef=source.stencilRef,this.stencilFuncMask=source.stencilFuncMask,this.stencilFail=source.stencilFail,this.stencilZFail=source.stencilZFail,this.stencilZPass=source.stencilZPass,this.stencilWrite=source.stencilWrite;const srcPlanes=source.clippingPlanes;let dstPlanes=null;if(null!==srcPlanes){const n=srcPlanes.length;dstPlanes=new Array(n);for(let i=0;i!==n;++i)dstPlanes[i]=srcPlanes[i].clone()}return this.clippingPlanes=dstPlanes,this.clipIntersection=source.clipIntersection,this.clipShadows=source.clipShadows,this.shadowSide=source.shadowSide,this.colorWrite=source.colorWrite,this.precision=source.precision,this.polygonOffset=source.polygonOffset,this.polygonOffsetFactor=source.polygonOffsetFactor,this.polygonOffsetUnits=source.polygonOffsetUnits,this.dithering=source.dithering,this.alphaTest=source.alphaTest,this.premultipliedAlpha=source.premultipliedAlpha,this.visible=source.visible,this.toneMapped=source.toneMapped,this.userData=JSON.parse(JSON.stringify(source.userData)),this},dispose:function(){this.dispatchEvent({type:"dispose"})}}),Object.defineProperty(Material.prototype,"needsUpdate",{set:function(value){!0===value&&this.version++}}),MeshBasicMaterial.prototype=Object.create(Material.prototype),MeshBasicMaterial.prototype.constructor=MeshBasicMaterial,MeshBasicMaterial.prototype.isMeshBasicMaterial=!0,MeshBasicMaterial.prototype.copy=function(source){return Material.prototype.copy.call(this,source),this.color.copy(source.color),this.map=source.map,this.lightMap=source.lightMap,this.lightMapIntensity=source.lightMapIntensity,this.aoMap=source.aoMap,this.aoMapIntensity=source.aoMapIntensity,this.specularMap=source.specularMap,this.alphaMap=source.alphaMap,this.envMap=source.envMap,this.combine=source.combine,this.reflectivity=source.reflectivity,this.refractionRatio=source.refractionRatio,this.wireframe=source.wireframe,this.wireframeLinewidth=source.wireframeLinewidth,this.wireframeLinecap=source.wireframeLinecap,this.wireframeLinejoin=source.wireframeLinejoin,this.skinning=source.skinning,this.morphTargets=source.morphTargets,this};const _vector$3=new Vector3,_vector2$1=new Vector2;function BufferAttribute(array,itemSize,normalized){if(Array.isArray(array))throw new TypeError("THREE.BufferAttribute: array should be a Typed Array.");this.name="",this.array=array,this.itemSize=itemSize,this.count=void 0!==array?array.length/itemSize:0,this.normalized=!0===normalized,this.usage=35044,this.updateRange={offset:0,count:-1},this.version=0}function Int8BufferAttribute(array,itemSize,normalized){BufferAttribute.call(this,new Int8Array(array),itemSize,normalized)}function Uint8BufferAttribute(array,itemSize,normalized){BufferAttribute.call(this,new Uint8Array(array),itemSize,normalized)}function Uint8ClampedBufferAttribute(array,itemSize,normalized){BufferAttribute.call(this,new Uint8ClampedArray(array),itemSize,normalized)}function Int16BufferAttribute(array,itemSize,normalized){BufferAttribute.call(this,new Int16Array(array),itemSize,normalized)}function Uint16BufferAttribute(array,itemSize,normalized){BufferAttribute.call(this,new Uint16Array(array),itemSize,normalized)}function Int32BufferAttribute(array,itemSize,normalized){BufferAttribute.call(this,new Int32Array(array),itemSize,normalized)}function Uint32BufferAttribute(array,itemSize,normalized){BufferAttribute.call(this,new Uint32Array(array),itemSize,normalized)}function Float32BufferAttribute(array,itemSize,normalized){BufferAttribute.call(this,new Float32Array(array),itemSize,normalized)}function Float64BufferAttribute(array,itemSize,normalized){BufferAttribute.call(this,new Float64Array(array),itemSize,normalized)}function DirectGeometry(){this.vertices=[],this.normals=[],this.colors=[],this.uvs=[],this.uvs2=[],this.groups=[],this.morphTargets={},this.skinWeights=[],this.skinIndices=[],this.boundingBox=null,this.boundingSphere=null,this.verticesNeedUpdate=!1,this.normalsNeedUpdate=!1,this.colorsNeedUpdate=!1,this.uvsNeedUpdate=!1,this.groupsNeedUpdate=!1}function arrayMax(array){if(0===array.length)return-1/0;let max=array[0];for(let i=1,l=array.length;i<l;++i)array[i]>max&&(max=array[i]);return max}Object.defineProperty(BufferAttribute.prototype,"needsUpdate",{set:function(value){!0===value&&this.version++}}),Object.assign(BufferAttribute.prototype,{isBufferAttribute:!0,onUploadCallback:function(){},setUsage:function(value){return this.usage=value,this},copy:function(source){return this.name=source.name,this.array=new source.array.constructor(source.array),this.itemSize=source.itemSize,this.count=source.count,this.normalized=source.normalized,this.usage=source.usage,this},copyAt:function(index1,attribute,index2){index1*=this.itemSize,index2*=attribute.itemSize;for(let i=0,l=this.itemSize;i<l;i++)this.array[index1+i]=attribute.array[index2+i];return this},copyArray:function(array){return this.array.set(array),this},copyColorsArray:function(colors){const array=this.array;let offset=0;for(let i=0,l=colors.length;i<l;i++){let color=colors[i];void 0===color&&(console.warn("THREE.BufferAttribute.copyColorsArray(): color is undefined",i),color=new Color),array[offset++]=color.r,array[offset++]=color.g,array[offset++]=color.b}return this},copyVector2sArray:function(vectors){const array=this.array;let offset=0;for(let i=0,l=vectors.length;i<l;i++){let vector=vectors[i];void 0===vector&&(console.warn("THREE.BufferAttribute.copyVector2sArray(): vector is undefined",i),vector=new Vector2),array[offset++]=vector.x,array[offset++]=vector.y}return this},copyVector3sArray:function(vectors){const array=this.array;let offset=0;for(let i=0,l=vectors.length;i<l;i++){let vector=vectors[i];void 0===vector&&(console.warn("THREE.BufferAttribute.copyVector3sArray(): vector is undefined",i),vector=new Vector3),array[offset++]=vector.x,array[offset++]=vector.y,array[offset++]=vector.z}return this},copyVector4sArray:function(vectors){const array=this.array;let offset=0;for(let i=0,l=vectors.length;i<l;i++){let vector=vectors[i];void 0===vector&&(console.warn("THREE.BufferAttribute.copyVector4sArray(): vector is undefined",i),vector=new Vector4),array[offset++]=vector.x,array[offset++]=vector.y,array[offset++]=vector.z,array[offset++]=vector.w}return this},applyMatrix3:function(m){if(2===this.itemSize)for(let i=0,l=this.count;i<l;i++)_vector2$1.fromBufferAttribute(this,i),_vector2$1.applyMatrix3(m),this.setXY(i,_vector2$1.x,_vector2$1.y);else if(3===this.itemSize)for(let i=0,l=this.count;i<l;i++)_vector$3.fromBufferAttribute(this,i),_vector$3.applyMatrix3(m),this.setXYZ(i,_vector$3.x,_vector$3.y,_vector$3.z);return this},applyMatrix4:function(m){for(let i=0,l=this.count;i<l;i++)_vector$3.x=this.getX(i),_vector$3.y=this.getY(i),_vector$3.z=this.getZ(i),_vector$3.applyMatrix4(m),this.setXYZ(i,_vector$3.x,_vector$3.y,_vector$3.z);return this},applyNormalMatrix:function(m){for(let i=0,l=this.count;i<l;i++)_vector$3.x=this.getX(i),_vector$3.y=this.getY(i),_vector$3.z=this.getZ(i),_vector$3.applyNormalMatrix(m),this.setXYZ(i,_vector$3.x,_vector$3.y,_vector$3.z);return this},transformDirection:function(m){for(let i=0,l=this.count;i<l;i++)_vector$3.x=this.getX(i),_vector$3.y=this.getY(i),_vector$3.z=this.getZ(i),_vector$3.transformDirection(m),this.setXYZ(i,_vector$3.x,_vector$3.y,_vector$3.z);return this},set:function(value,offset){return void 0===offset&&(offset=0),this.array.set(value,offset),this},getX:function(index){return this.array[index*this.itemSize]},setX:function(index,x){return this.array[index*this.itemSize]=x,this},getY:function(index){return this.array[index*this.itemSize+1]},setY:function(index,y){return this.array[index*this.itemSize+1]=y,this},getZ:function(index){return this.array[index*this.itemSize+2]},setZ:function(index,z){return this.array[index*this.itemSize+2]=z,this},getW:function(index){return this.array[index*this.itemSize+3]},setW:function(index,w){return this.array[index*this.itemSize+3]=w,this},setXY:function(index,x,y){return index*=this.itemSize,this.array[index+0]=x,this.array[index+1]=y,this},setXYZ:function(index,x,y,z){return index*=this.itemSize,this.array[index+0]=x,this.array[index+1]=y,this.array[index+2]=z,this},setXYZW:function(index,x,y,z,w){return index*=this.itemSize,this.array[index+0]=x,this.array[index+1]=y,this.array[index+2]=z,this.array[index+3]=w,this},onUpload:function(callback){return this.onUploadCallback=callback,this},clone:function(){return new this.constructor(this.array,this.itemSize).copy(this)},toJSON:function(){return{itemSize:this.itemSize,type:this.array.constructor.name,array:Array.prototype.slice.call(this.array),normalized:this.normalized}}}),Int8BufferAttribute.prototype=Object.create(BufferAttribute.prototype),Int8BufferAttribute.prototype.constructor=Int8BufferAttribute,Uint8BufferAttribute.prototype=Object.create(BufferAttribute.prototype),Uint8BufferAttribute.prototype.constructor=Uint8BufferAttribute,Uint8ClampedBufferAttribute.prototype=Object.create(BufferAttribute.prototype),Uint8ClampedBufferAttribute.prototype.constructor=Uint8ClampedBufferAttribute,Int16BufferAttribute.prototype=Object.create(BufferAttribute.prototype),Int16BufferAttribute.prototype.constructor=Int16BufferAttribute,Uint16BufferAttribute.prototype=Object.create(BufferAttribute.prototype),Uint16BufferAttribute.prototype.constructor=Uint16BufferAttribute,Int32BufferAttribute.prototype=Object.create(BufferAttribute.prototype),Int32BufferAttribute.prototype.constructor=Int32BufferAttribute,Uint32BufferAttribute.prototype=Object.create(BufferAttribute.prototype),Uint32BufferAttribute.prototype.constructor=Uint32BufferAttribute,Float32BufferAttribute.prototype=Object.create(BufferAttribute.prototype),Float32BufferAttribute.prototype.constructor=Float32BufferAttribute,Float64BufferAttribute.prototype=Object.create(BufferAttribute.prototype),Float64BufferAttribute.prototype.constructor=Float64BufferAttribute,Object.assign(DirectGeometry.prototype,{computeGroups:function(geometry){const groups=[];let group,i,materialIndex=void 0;const faces=geometry.faces;for(i=0;i<faces.length;i++){const face=faces[i];face.materialIndex!==materialIndex&&(materialIndex=face.materialIndex,void 0!==group&&(group.count=3*i-group.start,groups.push(group)),group={start:3*i,materialIndex})}void 0!==group&&(group.count=3*i-group.start,groups.push(group)),this.groups=groups},fromGeometry:function(geometry){const faces=geometry.faces,vertices=geometry.vertices,faceVertexUvs=geometry.faceVertexUvs,hasFaceVertexUv=faceVertexUvs[0]&&faceVertexUvs[0].length>0,hasFaceVertexUv2=faceVertexUvs[1]&&faceVertexUvs[1].length>0,morphTargets=geometry.morphTargets,morphTargetsLength=morphTargets.length;let morphTargetsPosition;if(morphTargetsLength>0){morphTargetsPosition=[];for(let i=0;i<morphTargetsLength;i++)morphTargetsPosition[i]={name:morphTargets[i].name,data:[]};this.morphTargets.position=morphTargetsPosition}const morphNormals=geometry.morphNormals,morphNormalsLength=morphNormals.length;let morphTargetsNormal;if(morphNormalsLength>0){morphTargetsNormal=[];for(let i=0;i<morphNormalsLength;i++)morphTargetsNormal[i]={name:morphNormals[i].name,data:[]};this.morphTargets.normal=morphTargetsNormal}const skinIndices=geometry.skinIndices,skinWeights=geometry.skinWeights,hasSkinIndices=skinIndices.length===vertices.length,hasSkinWeights=skinWeights.length===vertices.length;vertices.length>0&&0===faces.length&&console.error("THREE.DirectGeometry: Faceless geometries are not supported.");for(let i=0;i<faces.length;i++){const face=faces[i];this.vertices.push(vertices[face.a],vertices[face.b],vertices[face.c]);const vertexNormals=face.vertexNormals;if(3===vertexNormals.length)this.normals.push(vertexNormals[0],vertexNormals[1],vertexNormals[2]);else{const normal=face.normal;this.normals.push(normal,normal,normal)}const vertexColors=face.vertexColors;if(3===vertexColors.length)this.colors.push(vertexColors[0],vertexColors[1],vertexColors[2]);else{const color=face.color;this.colors.push(color,color,color)}if(!0===hasFaceVertexUv){const vertexUvs=faceVertexUvs[0][i];void 0!==vertexUvs?this.uvs.push(vertexUvs[0],vertexUvs[1],vertexUvs[2]):(console.warn("THREE.DirectGeometry.fromGeometry(): Undefined vertexUv ",i),this.uvs.push(new Vector2,new Vector2,new Vector2))}if(!0===hasFaceVertexUv2){const vertexUvs=faceVertexUvs[1][i];void 0!==vertexUvs?this.uvs2.push(vertexUvs[0],vertexUvs[1],vertexUvs[2]):(console.warn("THREE.DirectGeometry.fromGeometry(): Undefined vertexUv2 ",i),this.uvs2.push(new Vector2,new Vector2,new Vector2))}for(let j=0;j<morphTargetsLength;j++){const morphTarget=morphTargets[j].vertices;morphTargetsPosition[j].data.push(morphTarget[face.a],morphTarget[face.b],morphTarget[face.c])}for(let j=0;j<morphNormalsLength;j++){const morphNormal=morphNormals[j].vertexNormals[i];morphTargetsNormal[j].data.push(morphNormal.a,morphNormal.b,morphNormal.c)}hasSkinIndices&&this.skinIndices.push(skinIndices[face.a],skinIndices[face.b],skinIndices[face.c]),hasSkinWeights&&this.skinWeights.push(skinWeights[face.a],skinWeights[face.b],skinWeights[face.c])}return this.computeGroups(geometry),this.verticesNeedUpdate=geometry.verticesNeedUpdate,this.normalsNeedUpdate=geometry.normalsNeedUpdate,this.colorsNeedUpdate=geometry.colorsNeedUpdate,this.uvsNeedUpdate=geometry.uvsNeedUpdate,this.groupsNeedUpdate=geometry.groupsNeedUpdate,null!==geometry.boundingSphere&&(this.boundingSphere=geometry.boundingSphere.clone()),null!==geometry.boundingBox&&(this.boundingBox=geometry.boundingBox.clone()),this}});let _bufferGeometryId=1;const _m1$2=new Matrix4,_obj=new Object3D,_offset=new Vector3,_box$2=new Box3,_boxMorphTargets=new Box3,_vector$4=new Vector3;function BufferGeometry(){Object.defineProperty(this,"id",{value:_bufferGeometryId+=2}),this.uuid=MathUtils.generateUUID(),this.name="",this.type="BufferGeometry",this.index=null,this.attributes={},this.morphAttributes={},this.morphTargetsRelative=!1,this.groups=[],this.boundingBox=null,this.boundingSphere=null,this.drawRange={start:0,count:1/0},this.userData={}}BufferGeometry.prototype=Object.assign(Object.create(EventDispatcher.prototype),{constructor:BufferGeometry,isBufferGeometry:!0,getIndex:function(){return this.index},setIndex:function(index){Array.isArray(index)?this.index=new(arrayMax(index)>65535?Uint32BufferAttribute:Uint16BufferAttribute)(index,1):this.index=index},getAttribute:function(name){return this.attributes[name]},setAttribute:function(name,attribute){return this.attributes[name]=attribute,this},deleteAttribute:function(name){return delete this.attributes[name],this},addGroup:function(start,count,materialIndex){this.groups.push({start,count,materialIndex:void 0!==materialIndex?materialIndex:0})},clearGroups:function(){this.groups=[]},setDrawRange:function(start,count){this.drawRange.start=start,this.drawRange.count=count},applyMatrix4:function(matrix){const position=this.attributes.position;void 0!==position&&(position.applyMatrix4(matrix),position.needsUpdate=!0);const normal=this.attributes.normal;if(void 0!==normal){const normalMatrix=(new Matrix3).getNormalMatrix(matrix);normal.applyNormalMatrix(normalMatrix),normal.needsUpdate=!0}const tangent=this.attributes.tangent;return void 0!==tangent&&(tangent.transformDirection(matrix),tangent.needsUpdate=!0),null!==this.boundingBox&&this.computeBoundingBox(),null!==this.boundingSphere&&this.computeBoundingSphere(),this},rotateX:function(angle){return _m1$2.makeRotationX(angle),this.applyMatrix4(_m1$2),this},rotateY:function(angle){return _m1$2.makeRotationY(angle),this.applyMatrix4(_m1$2),this},rotateZ:function(angle){return _m1$2.makeRotationZ(angle),this.applyMatrix4(_m1$2),this},translate:function(x,y,z){return _m1$2.makeTranslation(x,y,z),this.applyMatrix4(_m1$2),this},scale:function(x,y,z){return _m1$2.makeScale(x,y,z),this.applyMatrix4(_m1$2),this},lookAt:function(vector){return _obj.lookAt(vector),_obj.updateMatrix(),this.applyMatrix4(_obj.matrix),this},center:function(){return this.computeBoundingBox(),this.boundingBox.getCenter(_offset).negate(),this.translate(_offset.x,_offset.y,_offset.z),this},setFromObject:function(object){const geometry=object.geometry;if(object.isPoints||object.isLine){const positions=new Float32BufferAttribute(3*geometry.vertices.length,3),colors=new Float32BufferAttribute(3*geometry.colors.length,3);if(this.setAttribute("position",positions.copyVector3sArray(geometry.vertices)),this.setAttribute("color",colors.copyColorsArray(geometry.colors)),geometry.lineDistances&&geometry.lineDistances.length===geometry.vertices.length){const lineDistances=new Float32BufferAttribute(geometry.lineDistances.length,1);this.setAttribute("lineDistance",lineDistances.copyArray(geometry.lineDistances))}null!==geometry.boundingSphere&&(this.boundingSphere=geometry.boundingSphere.clone()),null!==geometry.boundingBox&&(this.boundingBox=geometry.boundingBox.clone())}else object.isMesh&&geometry&&geometry.isGeometry&&this.fromGeometry(geometry);return this},setFromPoints:function(points){const position=[];for(let i=0,l=points.length;i<l;i++){const point=points[i];position.push(point.x,point.y,point.z||0)}return this.setAttribute("position",new Float32BufferAttribute(position,3)),this},updateFromObject:function(object){let geometry=object.geometry;if(object.isMesh){let direct=geometry.__directGeometry;if(!0===geometry.elementsNeedUpdate&&(direct=void 0,geometry.elementsNeedUpdate=!1),void 0===direct)return this.fromGeometry(geometry);direct.verticesNeedUpdate=geometry.verticesNeedUpdate,direct.normalsNeedUpdate=geometry.normalsNeedUpdate,direct.colorsNeedUpdate=geometry.colorsNeedUpdate,direct.uvsNeedUpdate=geometry.uvsNeedUpdate,direct.groupsNeedUpdate=geometry.groupsNeedUpdate,geometry.verticesNeedUpdate=!1,geometry.normalsNeedUpdate=!1,geometry.colorsNeedUpdate=!1,geometry.uvsNeedUpdate=!1,geometry.groupsNeedUpdate=!1,geometry=direct}if(!0===geometry.verticesNeedUpdate){const attribute=this.attributes.position;void 0!==attribute&&(attribute.copyVector3sArray(geometry.vertices),attribute.needsUpdate=!0),geometry.verticesNeedUpdate=!1}if(!0===geometry.normalsNeedUpdate){const attribute=this.attributes.normal;void 0!==attribute&&(attribute.copyVector3sArray(geometry.normals),attribute.needsUpdate=!0),geometry.normalsNeedUpdate=!1}if(!0===geometry.colorsNeedUpdate){const attribute=this.attributes.color;void 0!==attribute&&(attribute.copyColorsArray(geometry.colors),attribute.needsUpdate=!0),geometry.colorsNeedUpdate=!1}if(geometry.uvsNeedUpdate){const attribute=this.attributes.uv;void 0!==attribute&&(attribute.copyVector2sArray(geometry.uvs),attribute.needsUpdate=!0),geometry.uvsNeedUpdate=!1}if(geometry.lineDistancesNeedUpdate){const attribute=this.attributes.lineDistance;void 0!==attribute&&(attribute.copyArray(geometry.lineDistances),attribute.needsUpdate=!0),geometry.lineDistancesNeedUpdate=!1}return geometry.groupsNeedUpdate&&(geometry.computeGroups(object.geometry),this.groups=geometry.groups,geometry.groupsNeedUpdate=!1),this},fromGeometry:function(geometry){return geometry.__directGeometry=(new DirectGeometry).fromGeometry(geometry),this.fromDirectGeometry(geometry.__directGeometry)},fromDirectGeometry:function(geometry){const positions=new Float32Array(3*geometry.vertices.length);if(this.setAttribute("position",new BufferAttribute(positions,3).copyVector3sArray(geometry.vertices)),geometry.normals.length>0){const normals=new Float32Array(3*geometry.normals.length);this.setAttribute("normal",new BufferAttribute(normals,3).copyVector3sArray(geometry.normals))}if(geometry.colors.length>0){const colors=new Float32Array(3*geometry.colors.length);this.setAttribute("color",new BufferAttribute(colors,3).copyColorsArray(geometry.colors))}if(geometry.uvs.length>0){const uvs=new Float32Array(2*geometry.uvs.length);this.setAttribute("uv",new BufferAttribute(uvs,2).copyVector2sArray(geometry.uvs))}if(geometry.uvs2.length>0){const uvs2=new Float32Array(2*geometry.uvs2.length);this.setAttribute("uv2",new BufferAttribute(uvs2,2).copyVector2sArray(geometry.uvs2))}this.groups=geometry.groups;for(const name in geometry.morphTargets){const array=[],morphTargets=geometry.morphTargets[name];for(let i=0,l=morphTargets.length;i<l;i++){const morphTarget=morphTargets[i],attribute=new Float32BufferAttribute(3*morphTarget.data.length,3);attribute.name=morphTarget.name,array.push(attribute.copyVector3sArray(morphTarget.data))}this.morphAttributes[name]=array}if(geometry.skinIndices.length>0){const skinIndices=new Float32BufferAttribute(4*geometry.skinIndices.length,4);this.setAttribute("skinIndex",skinIndices.copyVector4sArray(geometry.skinIndices))}if(geometry.skinWeights.length>0){const skinWeights=new Float32BufferAttribute(4*geometry.skinWeights.length,4);this.setAttribute("skinWeight",skinWeights.copyVector4sArray(geometry.skinWeights))}return null!==geometry.boundingSphere&&(this.boundingSphere=geometry.boundingSphere.clone()),null!==geometry.boundingBox&&(this.boundingBox=geometry.boundingBox.clone()),this},computeBoundingBox:function(){null===this.boundingBox&&(this.boundingBox=new Box3);const position=this.attributes.position,morphAttributesPosition=this.morphAttributes.position;if(void 0!==position){if(this.boundingBox.setFromBufferAttribute(position),morphAttributesPosition)for(let i=0,il=morphAttributesPosition.length;i<il;i++){const morphAttribute=morphAttributesPosition[i];_box$2.setFromBufferAttribute(morphAttribute),this.morphTargetsRelative?(_vector$4.addVectors(this.boundingBox.min,_box$2.min),this.boundingBox.expandByPoint(_vector$4),_vector$4.addVectors(this.boundingBox.max,_box$2.max),this.boundingBox.expandByPoint(_vector$4)):(this.boundingBox.expandByPoint(_box$2.min),this.boundingBox.expandByPoint(_box$2.max))}}else this.boundingBox.makeEmpty();(isNaN(this.boundingBox.min.x)||isNaN(this.boundingBox.min.y)||isNaN(this.boundingBox.min.z))&&console.error('THREE.BufferGeometry.computeBoundingBox: Computed min/max have NaN values. The "position" attribute is likely to have NaN values.',this)},computeBoundingSphere:function(){null===this.boundingSphere&&(this.boundingSphere=new Sphere);const position=this.attributes.position,morphAttributesPosition=this.morphAttributes.position;if(position){const center=this.boundingSphere.center;if(_box$2.setFromBufferAttribute(position),morphAttributesPosition)for(let i=0,il=morphAttributesPosition.length;i<il;i++){const morphAttribute=morphAttributesPosition[i];_boxMorphTargets.setFromBufferAttribute(morphAttribute),this.morphTargetsRelative?(_vector$4.addVectors(_box$2.min,_boxMorphTargets.min),_box$2.expandByPoint(_vector$4),_vector$4.addVectors(_box$2.max,_boxMorphTargets.max),_box$2.expandByPoint(_vector$4)):(_box$2.expandByPoint(_boxMorphTargets.min),_box$2.expandByPoint(_boxMorphTargets.max))}_box$2.getCenter(center);let maxRadiusSq=0;for(let i=0,il=position.count;i<il;i++)_vector$4.fromBufferAttribute(position,i),maxRadiusSq=Math.max(maxRadiusSq,center.distanceToSquared(_vector$4));if(morphAttributesPosition)for(let i=0,il=morphAttributesPosition.length;i<il;i++){const morphAttribute=morphAttributesPosition[i],morphTargetsRelative=this.morphTargetsRelative;for(let j=0,jl=morphAttribute.count;j<jl;j++)_vector$4.fromBufferAttribute(morphAttribute,j),morphTargetsRelative&&(_offset.fromBufferAttribute(position,j),_vector$4.add(_offset)),maxRadiusSq=Math.max(maxRadiusSq,center.distanceToSquared(_vector$4))}this.boundingSphere.radius=Math.sqrt(maxRadiusSq),isNaN(this.boundingSphere.radius)&&console.error('THREE.BufferGeometry.computeBoundingSphere(): Computed radius is NaN. The "position" attribute is likely to have NaN values.',this)}},computeFaceNormals:function(){},computeVertexNormals:function(){const index=this.index,positionAttribute=this.getAttribute("position");if(void 0!==positionAttribute){let normalAttribute=this.getAttribute("normal");if(void 0===normalAttribute)normalAttribute=new BufferAttribute(new Float32Array(3*positionAttribute.count),3),this.setAttribute("normal",normalAttribute);else for(let i=0,il=normalAttribute.count;i<il;i++)normalAttribute.setXYZ(i,0,0,0);const pA=new Vector3,pB=new Vector3,pC=new Vector3,nA=new Vector3,nB=new Vector3,nC=new Vector3,cb=new Vector3,ab=new Vector3;if(index)for(let i=0,il=index.count;i<il;i+=3){const vA=index.getX(i+0),vB=index.getX(i+1),vC=index.getX(i+2);pA.fromBufferAttribute(positionAttribute,vA),pB.fromBufferAttribute(positionAttribute,vB),pC.fromBufferAttribute(positionAttribute,vC),cb.subVectors(pC,pB),ab.subVectors(pA,pB),cb.cross(ab),nA.fromBufferAttribute(normalAttribute,vA),nB.fromBufferAttribute(normalAttribute,vB),nC.fromBufferAttribute(normalAttribute,vC),nA.add(cb),nB.add(cb),nC.add(cb),normalAttribute.setXYZ(vA,nA.x,nA.y,nA.z),normalAttribute.setXYZ(vB,nB.x,nB.y,nB.z),normalAttribute.setXYZ(vC,nC.x,nC.y,nC.z)}else for(let i=0,il=positionAttribute.count;i<il;i+=3)pA.fromBufferAttribute(positionAttribute,i+0),pB.fromBufferAttribute(positionAttribute,i+1),pC.fromBufferAttribute(positionAttribute,i+2),cb.subVectors(pC,pB),ab.subVectors(pA,pB),cb.cross(ab),normalAttribute.setXYZ(i+0,cb.x,cb.y,cb.z),normalAttribute.setXYZ(i+1,cb.x,cb.y,cb.z),normalAttribute.setXYZ(i+2,cb.x,cb.y,cb.z);this.normalizeNormals(),normalAttribute.needsUpdate=!0}},merge:function(geometry,offset){if(!geometry||!geometry.isBufferGeometry)return void console.error("THREE.BufferGeometry.merge(): geometry not an instance of THREE.BufferGeometry.",geometry);void 0===offset&&(offset=0,console.warn("THREE.BufferGeometry.merge(): Overwriting original geometry, starting at offset=0. Use BufferGeometryUtils.mergeBufferGeometries() for lossless merge."));const attributes=this.attributes;for(const key in attributes){if(void 0===geometry.attributes[key])continue;const attributeArray1=attributes[key].array,attribute2=geometry.attributes[key],attributeArray2=attribute2.array,attributeOffset=attribute2.itemSize*offset,length=Math.min(attributeArray2.length,attributeArray1.length-attributeOffset);for(let i=0,j=attributeOffset;i<length;i++,j++)attributeArray1[j]=attributeArray2[i]}return this},normalizeNormals:function(){const normals=this.attributes.normal;for(let i=0,il=normals.count;i<il;i++)_vector$4.fromBufferAttribute(normals,i),_vector$4.normalize(),normals.setXYZ(i,_vector$4.x,_vector$4.y,_vector$4.z)},toNonIndexed:function(){function convertBufferAttribute(attribute,indices){const array=attribute.array,itemSize=attribute.itemSize,normalized=attribute.normalized,array2=new array.constructor(indices.length*itemSize);let index=0,index2=0;for(let i=0,l=indices.length;i<l;i++){index=indices[i]*itemSize;for(let j=0;j<itemSize;j++)array2[index2++]=array[index++]}return new BufferAttribute(array2,itemSize,normalized)}if(null===this.index)return console.warn("THREE.BufferGeometry.toNonIndexed(): Geometry is already non-indexed."),this;const geometry2=new BufferGeometry,indices=this.index.array,attributes=this.attributes;for(const name in attributes){const newAttribute=convertBufferAttribute(attributes[name],indices);geometry2.setAttribute(name,newAttribute)}const morphAttributes=this.morphAttributes;for(const name in morphAttributes){const morphArray=[],morphAttribute=morphAttributes[name];for(let i=0,il=morphAttribute.length;i<il;i++){const newAttribute=convertBufferAttribute(morphAttribute[i],indices);morphArray.push(newAttribute)}geometry2.morphAttributes[name]=morphArray}geometry2.morphTargetsRelative=this.morphTargetsRelative;const groups=this.groups;for(let i=0,l=groups.length;i<l;i++){const group=groups[i];geometry2.addGroup(group.start,group.count,group.materialIndex)}return geometry2},toJSON:function(){const data={metadata:{version:4.5,type:"BufferGeometry",generator:"BufferGeometry.toJSON"}};if(data.uuid=this.uuid,data.type=this.type,""!==this.name&&(data.name=this.name),Object.keys(this.userData).length>0&&(data.userData=this.userData),void 0!==this.parameters){const parameters=this.parameters;for(const key in parameters)void 0!==parameters[key]&&(data[key]=parameters[key]);return data}data.data={attributes:{}};const index=this.index;null!==index&&(data.data.index={type:index.array.constructor.name,array:Array.prototype.slice.call(index.array)});const attributes=this.attributes;for(const key in attributes){const attribute=attributes[key],attributeData=attribute.toJSON(data.data);""!==attribute.name&&(attributeData.name=attribute.name),data.data.attributes[key]=attributeData}const morphAttributes={};let hasMorphAttributes=!1;for(const key in this.morphAttributes){const attributeArray=this.morphAttributes[key],array=[];for(let i=0,il=attributeArray.length;i<il;i++){const attribute=attributeArray[i],attributeData=attribute.toJSON(data.data);""!==attribute.name&&(attributeData.name=attribute.name),array.push(attributeData)}array.length>0&&(morphAttributes[key]=array,hasMorphAttributes=!0)}hasMorphAttributes&&(data.data.morphAttributes=morphAttributes,data.data.morphTargetsRelative=this.morphTargetsRelative);const groups=this.groups;groups.length>0&&(data.data.groups=JSON.parse(JSON.stringify(groups)));const boundingSphere=this.boundingSphere;return null!==boundingSphere&&(data.data.boundingSphere={center:boundingSphere.center.toArray(),radius:boundingSphere.radius}),data},clone:function(){return(new BufferGeometry).copy(this)},copy:function(source){this.index=null,this.attributes={},this.morphAttributes={},this.groups=[],this.boundingBox=null,this.boundingSphere=null;const data={};this.name=source.name;const index=source.index;null!==index&&this.setIndex(index.clone(data));const attributes=source.attributes;for(const name in attributes){const attribute=attributes[name];this.setAttribute(name,attribute.clone(data))}const morphAttributes=source.morphAttributes;for(const name in morphAttributes){const array=[],morphAttribute=morphAttributes[name];for(let i=0,l=morphAttribute.length;i<l;i++)array.push(morphAttribute[i].clone(data));this.morphAttributes[name]=array}this.morphTargetsRelative=source.morphTargetsRelative;const groups=source.groups;for(let i=0,l=groups.length;i<l;i++){const group=groups[i];this.addGroup(group.start,group.count,group.materialIndex)}const boundingBox=source.boundingBox;null!==boundingBox&&(this.boundingBox=boundingBox.clone());const boundingSphere=source.boundingSphere;return null!==boundingSphere&&(this.boundingSphere=boundingSphere.clone()),this.drawRange.start=source.drawRange.start,this.drawRange.count=source.drawRange.count,this.userData=source.userData,this},dispose:function(){this.dispatchEvent({type:"dispose"})}});const _inverseMatrix=new Matrix4,_ray=new Ray,_sphere=new Sphere,_vA=new Vector3,_vB=new Vector3,_vC=new Vector3,_tempA=new Vector3,_tempB=new Vector3,_tempC=new Vector3,_morphA=new Vector3,_morphB=new Vector3,_morphC=new Vector3,_uvA=new Vector2,_uvB=new Vector2,_uvC=new Vector2,_intersectionPoint=new Vector3,_intersectionPointWorld=new Vector3;function Mesh(geometry,material){Object3D.call(this),this.type="Mesh",this.geometry=void 0!==geometry?geometry:new BufferGeometry,this.material=void 0!==material?material:new MeshBasicMaterial,this.updateMorphTargets()}function checkIntersection(object,material,raycaster,ray,pA,pB,pC,point){let intersect;if(intersect=1===material.side?ray.intersectTriangle(pC,pB,pA,!0,point):ray.intersectTriangle(pA,pB,pC,2!==material.side,point),null===intersect)return null;_intersectionPointWorld.copy(point),_intersectionPointWorld.applyMatrix4(object.matrixWorld);const distance=raycaster.ray.origin.distanceTo(_intersectionPointWorld);return distance<raycaster.near||distance>raycaster.far?null:{distance,point:_intersectionPointWorld.clone(),object}}function checkBufferGeometryIntersection(object,material,raycaster,ray,position,morphPosition,morphTargetsRelative,uv,uv2,a,b,c){_vA.fromBufferAttribute(position,a),_vB.fromBufferAttribute(position,b),_vC.fromBufferAttribute(position,c);const morphInfluences=object.morphTargetInfluences;if(material.morphTargets&&morphPosition&&morphInfluences){_morphA.set(0,0,0),_morphB.set(0,0,0),_morphC.set(0,0,0);for(let i=0,il=morphPosition.length;i<il;i++){const influence=morphInfluences[i],morphAttribute=morphPosition[i];0!==influence&&(_tempA.fromBufferAttribute(morphAttribute,a),_tempB.fromBufferAttribute(morphAttribute,b),_tempC.fromBufferAttribute(morphAttribute,c),morphTargetsRelative?(_morphA.addScaledVector(_tempA,influence),_morphB.addScaledVector(_tempB,influence),_morphC.addScaledVector(_tempC,influence)):(_morphA.addScaledVector(_tempA.sub(_vA),influence),_morphB.addScaledVector(_tempB.sub(_vB),influence),_morphC.addScaledVector(_tempC.sub(_vC),influence)))}_vA.add(_morphA),_vB.add(_morphB),_vC.add(_morphC)}object.isSkinnedMesh&&(object.boneTransform(a,_vA),object.boneTransform(b,_vB),object.boneTransform(c,_vC));const intersection=checkIntersection(object,material,raycaster,ray,_vA,_vB,_vC,_intersectionPoint);if(intersection){uv&&(_uvA.fromBufferAttribute(uv,a),_uvB.fromBufferAttribute(uv,b),_uvC.fromBufferAttribute(uv,c),intersection.uv=Triangle.getUV(_intersectionPoint,_vA,_vB,_vC,_uvA,_uvB,_uvC,new Vector2)),uv2&&(_uvA.fromBufferAttribute(uv2,a),_uvB.fromBufferAttribute(uv2,b),_uvC.fromBufferAttribute(uv2,c),intersection.uv2=Triangle.getUV(_intersectionPoint,_vA,_vB,_vC,_uvA,_uvB,_uvC,new Vector2));const face=new Face3(a,b,c);Triangle.getNormal(_vA,_vB,_vC,face.normal),intersection.face=face}return intersection}Mesh.prototype=Object.assign(Object.create(Object3D.prototype),{constructor:Mesh,isMesh:!0,copy:function(source){return Object3D.prototype.copy.call(this,source),void 0!==source.morphTargetInfluences&&(this.morphTargetInfluences=source.morphTargetInfluences.slice()),void 0!==source.morphTargetDictionary&&(this.morphTargetDictionary=Object.assign({},source.morphTargetDictionary)),this.material=source.material,this.geometry=source.geometry,this},updateMorphTargets:function(){const geometry=this.geometry;if(geometry.isBufferGeometry){const morphAttributes=geometry.morphAttributes,keys=Object.keys(morphAttributes);if(keys.length>0){const morphAttribute=morphAttributes[keys[0]];if(void 0!==morphAttribute){this.morphTargetInfluences=[],this.morphTargetDictionary={};for(let m=0,ml=morphAttribute.length;m<ml;m++){const name=morphAttribute[m].name||String(m);this.morphTargetInfluences.push(0),this.morphTargetDictionary[name]=m}}}}else{const morphTargets=geometry.morphTargets;void 0!==morphTargets&&morphTargets.length>0&&console.error("THREE.Mesh.updateMorphTargets() no longer supports THREE.Geometry. Use THREE.BufferGeometry instead.")}},raycast:function(raycaster,intersects){const geometry=this.geometry,material=this.material,matrixWorld=this.matrixWorld;if(void 0===material)return;if(null===geometry.boundingSphere&&geometry.computeBoundingSphere(),_sphere.copy(geometry.boundingSphere),_sphere.applyMatrix4(matrixWorld),!1===raycaster.ray.intersectsSphere(_sphere))return;if(_inverseMatrix.getInverse(matrixWorld),_ray.copy(raycaster.ray).applyMatrix4(_inverseMatrix),null!==geometry.boundingBox&&!1===_ray.intersectsBox(geometry.boundingBox))return;let intersection;if(geometry.isBufferGeometry){const index=geometry.index,position=geometry.attributes.position,morphPosition=geometry.morphAttributes.position,morphTargetsRelative=geometry.morphTargetsRelative,uv=geometry.attributes.uv,uv2=geometry.attributes.uv2,groups=geometry.groups,drawRange=geometry.drawRange;if(null!==index)if(Array.isArray(material))for(let i=0,il=groups.length;i<il;i++){const group=groups[i],groupMaterial=material[group.materialIndex];for(let j=Math.max(group.start,drawRange.start),jl=Math.min(group.start+group.count,drawRange.start+drawRange.count);j<jl;j+=3){const a=index.getX(j),b=index.getX(j+1),c=index.getX(j+2);intersection=checkBufferGeometryIntersection(this,groupMaterial,raycaster,_ray,position,morphPosition,morphTargetsRelative,uv,uv2,a,b,c),intersection&&(intersection.faceIndex=Math.floor(j/3),intersection.face.materialIndex=group.materialIndex,intersects.push(intersection))}}else{for(let i=Math.max(0,drawRange.start),il=Math.min(index.count,drawRange.start+drawRange.count);i<il;i+=3){const a=index.getX(i),b=index.getX(i+1),c=index.getX(i+2);intersection=checkBufferGeometryIntersection(this,material,raycaster,_ray,position,morphPosition,morphTargetsRelative,uv,uv2,a,b,c),intersection&&(intersection.faceIndex=Math.floor(i/3),intersects.push(intersection))}}else if(void 0!==position)if(Array.isArray(material))for(let i=0,il=groups.length;i<il;i++){const group=groups[i],groupMaterial=material[group.materialIndex];for(let j=Math.max(group.start,drawRange.start),jl=Math.min(group.start+group.count,drawRange.start+drawRange.count);j<jl;j+=3){intersection=checkBufferGeometryIntersection(this,groupMaterial,raycaster,_ray,position,morphPosition,morphTargetsRelative,uv,uv2,j,j+1,j+2),intersection&&(intersection.faceIndex=Math.floor(j/3),intersection.face.materialIndex=group.materialIndex,intersects.push(intersection))}}else{for(let i=Math.max(0,drawRange.start),il=Math.min(position.count,drawRange.start+drawRange.count);i<il;i+=3){intersection=checkBufferGeometryIntersection(this,material,raycaster,_ray,position,morphPosition,morphTargetsRelative,uv,uv2,i,i+1,i+2),intersection&&(intersection.faceIndex=Math.floor(i/3),intersects.push(intersection))}}}else if(geometry.isGeometry){const isMultiMaterial=Array.isArray(material),vertices=geometry.vertices,faces=geometry.faces;let uvs;const faceVertexUvs=geometry.faceVertexUvs[0];faceVertexUvs.length>0&&(uvs=faceVertexUvs);for(let f=0,fl=faces.length;f<fl;f++){const face=faces[f],faceMaterial=isMultiMaterial?material[face.materialIndex]:material;if(void 0===faceMaterial)continue;const fvA=vertices[face.a],fvB=vertices[face.b],fvC=vertices[face.c];if(intersection=checkIntersection(this,faceMaterial,raycaster,_ray,fvA,fvB,fvC,_intersectionPoint),intersection){if(uvs&&uvs[f]){const uvs_f=uvs[f];_uvA.copy(uvs_f[0]),_uvB.copy(uvs_f[1]),_uvC.copy(uvs_f[2]),intersection.uv=Triangle.getUV(_intersectionPoint,fvA,fvB,fvC,_uvA,_uvB,_uvC,new Vector2)}intersection.face=face,intersection.faceIndex=f,intersects.push(intersection)}}}}});let _geometryId=0;const _m1$3=new Matrix4,_obj$1=new Object3D,_offset$1=new Vector3;function Geometry(){Object.defineProperty(this,"id",{value:_geometryId+=2}),this.uuid=MathUtils.generateUUID(),this.name="",this.type="Geometry",this.vertices=[],this.colors=[],this.faces=[],this.faceVertexUvs=[[]],this.morphTargets=[],this.morphNormals=[],this.skinWeights=[],this.skinIndices=[],this.lineDistances=[],this.boundingBox=null,this.boundingSphere=null,this.elementsNeedUpdate=!1,this.verticesNeedUpdate=!1,this.uvsNeedUpdate=!1,this.normalsNeedUpdate=!1,this.colorsNeedUpdate=!1,this.lineDistancesNeedUpdate=!1,this.groupsNeedUpdate=!1}Geometry.prototype=Object.assign(Object.create(EventDispatcher.prototype),{constructor:Geometry,isGeometry:!0,applyMatrix4:function(matrix){const normalMatrix=(new Matrix3).getNormalMatrix(matrix);for(let i=0,il=this.vertices.length;i<il;i++){this.vertices[i].applyMatrix4(matrix)}for(let i=0,il=this.faces.length;i<il;i++){const face=this.faces[i];face.normal.applyMatrix3(normalMatrix).normalize();for(let j=0,jl=face.vertexNormals.length;j<jl;j++)face.vertexNormals[j].applyMatrix3(normalMatrix).normalize()}return null!==this.boundingBox&&this.computeBoundingBox(),null!==this.boundingSphere&&this.computeBoundingSphere(),this.verticesNeedUpdate=!0,this.normalsNeedUpdate=!0,this},rotateX:function(angle){return _m1$3.makeRotationX(angle),this.applyMatrix4(_m1$3),this},rotateY:function(angle){return _m1$3.makeRotationY(angle),this.applyMatrix4(_m1$3),this},rotateZ:function(angle){return _m1$3.makeRotationZ(angle),this.applyMatrix4(_m1$3),this},translate:function(x,y,z){return _m1$3.makeTranslation(x,y,z),this.applyMatrix4(_m1$3),this},scale:function(x,y,z){return _m1$3.makeScale(x,y,z),this.applyMatrix4(_m1$3),this},lookAt:function(vector){return _obj$1.lookAt(vector),_obj$1.updateMatrix(),this.applyMatrix4(_obj$1.matrix),this},fromBufferGeometry:function(geometry){const scope=this,index=null!==geometry.index?geometry.index:void 0,attributes=geometry.attributes;if(void 0===attributes.position)return console.error("THREE.Geometry.fromBufferGeometry(): Position attribute required for conversion."),this;const position=attributes.position,normal=attributes.normal,color=attributes.color,uv=attributes.uv,uv2=attributes.uv2;void 0!==uv2&&(this.faceVertexUvs[1]=[]);for(let i=0;i<position.count;i++)scope.vertices.push((new Vector3).fromBufferAttribute(position,i)),void 0!==color&&scope.colors.push((new Color).fromBufferAttribute(color,i));function addFace(a,b,c,materialIndex){const vertexColors=void 0===color?[]:[scope.colors[a].clone(),scope.colors[b].clone(),scope.colors[c].clone()],face=new Face3(a,b,c,void 0===normal?[]:[(new Vector3).fromBufferAttribute(normal,a),(new Vector3).fromBufferAttribute(normal,b),(new Vector3).fromBufferAttribute(normal,c)],vertexColors,materialIndex);scope.faces.push(face),void 0!==uv&&scope.faceVertexUvs[0].push([(new Vector2).fromBufferAttribute(uv,a),(new Vector2).fromBufferAttribute(uv,b),(new Vector2).fromBufferAttribute(uv,c)]),void 0!==uv2&&scope.faceVertexUvs[1].push([(new Vector2).fromBufferAttribute(uv2,a),(new Vector2).fromBufferAttribute(uv2,b),(new Vector2).fromBufferAttribute(uv2,c)])}const groups=geometry.groups;if(groups.length>0)for(let i=0;i<groups.length;i++){const group=groups[i],start=group.start;for(let j=start,jl=start+group.count;j<jl;j+=3)void 0!==index?addFace(index.getX(j),index.getX(j+1),index.getX(j+2),group.materialIndex):addFace(j,j+1,j+2,group.materialIndex)}else if(void 0!==index)for(let i=0;i<index.count;i+=3)addFace(index.getX(i),index.getX(i+1),index.getX(i+2));else for(let i=0;i<position.count;i+=3)addFace(i,i+1,i+2);return this.computeFaceNormals(),null!==geometry.boundingBox&&(this.boundingBox=geometry.boundingBox.clone()),null!==geometry.boundingSphere&&(this.boundingSphere=geometry.boundingSphere.clone()),this},center:function(){return this.computeBoundingBox(),this.boundingBox.getCenter(_offset$1).negate(),this.translate(_offset$1.x,_offset$1.y,_offset$1.z),this},normalize:function(){this.computeBoundingSphere();const center=this.boundingSphere.center,radius=this.boundingSphere.radius,s=0===radius?1:1/radius,matrix=new Matrix4;return matrix.set(s,0,0,-s*center.x,0,s,0,-s*center.y,0,0,s,-s*center.z,0,0,0,1),this.applyMatrix4(matrix),this},computeFaceNormals:function(){const cb=new Vector3,ab=new Vector3;for(let f=0,fl=this.faces.length;f<fl;f++){const face=this.faces[f],vA=this.vertices[face.a],vB=this.vertices[face.b],vC=this.vertices[face.c];cb.subVectors(vC,vB),ab.subVectors(vA,vB),cb.cross(ab),cb.normalize(),face.normal.copy(cb)}},computeVertexNormals:function(areaWeighted){void 0===areaWeighted&&(areaWeighted=!0);const vertices=new Array(this.vertices.length);for(let v=0,vl=this.vertices.length;v<vl;v++)vertices[v]=new Vector3;if(areaWeighted){const cb=new Vector3,ab=new Vector3;for(let f=0,fl=this.faces.length;f<fl;f++){const face=this.faces[f],vA=this.vertices[face.a],vB=this.vertices[face.b],vC=this.vertices[face.c];cb.subVectors(vC,vB),ab.subVectors(vA,vB),cb.cross(ab),vertices[face.a].add(cb),vertices[face.b].add(cb),vertices[face.c].add(cb)}}else{this.computeFaceNormals();for(let f=0,fl=this.faces.length;f<fl;f++){const face=this.faces[f];vertices[face.a].add(face.normal),vertices[face.b].add(face.normal),vertices[face.c].add(face.normal)}}for(let v=0,vl=this.vertices.length;v<vl;v++)vertices[v].normalize();for(let f=0,fl=this.faces.length;f<fl;f++){const face=this.faces[f],vertexNormals=face.vertexNormals;3===vertexNormals.length?(vertexNormals[0].copy(vertices[face.a]),vertexNormals[1].copy(vertices[face.b]),vertexNormals[2].copy(vertices[face.c])):(vertexNormals[0]=vertices[face.a].clone(),vertexNormals[1]=vertices[face.b].clone(),vertexNormals[2]=vertices[face.c].clone())}this.faces.length>0&&(this.normalsNeedUpdate=!0)},computeFlatVertexNormals:function(){this.computeFaceNormals();for(let f=0,fl=this.faces.length;f<fl;f++){const face=this.faces[f],vertexNormals=face.vertexNormals;3===vertexNormals.length?(vertexNormals[0].copy(face.normal),vertexNormals[1].copy(face.normal),vertexNormals[2].copy(face.normal)):(vertexNormals[0]=face.normal.clone(),vertexNormals[1]=face.normal.clone(),vertexNormals[2]=face.normal.clone())}this.faces.length>0&&(this.normalsNeedUpdate=!0)},computeMorphNormals:function(){for(let f=0,fl=this.faces.length;f<fl;f++){const face=this.faces[f];face.__originalFaceNormal?face.__originalFaceNormal.copy(face.normal):face.__originalFaceNormal=face.normal.clone(),face.__originalVertexNormals||(face.__originalVertexNormals=[]);for(let i=0,il=face.vertexNormals.length;i<il;i++)face.__originalVertexNormals[i]?face.__originalVertexNormals[i].copy(face.vertexNormals[i]):face.__originalVertexNormals[i]=face.vertexNormals[i].clone()}const tmpGeo=new Geometry;tmpGeo.faces=this.faces;for(let i=0,il=this.morphTargets.length;i<il;i++){if(!this.morphNormals[i]){this.morphNormals[i]={},this.morphNormals[i].faceNormals=[],this.morphNormals[i].vertexNormals=[];const dstNormalsFace=this.morphNormals[i].faceNormals,dstNormalsVertex=this.morphNormals[i].vertexNormals;for(let f=0,fl=this.faces.length;f<fl;f++){const faceNormal=new Vector3,vertexNormals={a:new Vector3,b:new Vector3,c:new Vector3};dstNormalsFace.push(faceNormal),dstNormalsVertex.push(vertexNormals)}}const morphNormals=this.morphNormals[i];tmpGeo.vertices=this.morphTargets[i].vertices,tmpGeo.computeFaceNormals(),tmpGeo.computeVertexNormals();for(let f=0,fl=this.faces.length;f<fl;f++){const face=this.faces[f],faceNormal=morphNormals.faceNormals[f],vertexNormals=morphNormals.vertexNormals[f];faceNormal.copy(face.normal),vertexNormals.a.copy(face.vertexNormals[0]),vertexNormals.b.copy(face.vertexNormals[1]),vertexNormals.c.copy(face.vertexNormals[2])}}for(let f=0,fl=this.faces.length;f<fl;f++){const face=this.faces[f];face.normal=face.__originalFaceNormal,face.vertexNormals=face.__originalVertexNormals}},computeBoundingBox:function(){null===this.boundingBox&&(this.boundingBox=new Box3),this.boundingBox.setFromPoints(this.vertices)},computeBoundingSphere:function(){null===this.boundingSphere&&(this.boundingSphere=new Sphere),this.boundingSphere.setFromPoints(this.vertices)},merge:function(geometry,matrix,materialIndexOffset){if(!geometry||!geometry.isGeometry)return void console.error("THREE.Geometry.merge(): geometry not an instance of THREE.Geometry.",geometry);let normalMatrix,vertexOffset=this.vertices.length,vertices1=this.vertices,vertices2=geometry.vertices,faces1=this.faces,faces2=geometry.faces,colors1=this.colors,colors2=geometry.colors;void 0===materialIndexOffset&&(materialIndexOffset=0),void 0!==matrix&&(normalMatrix=(new Matrix3).getNormalMatrix(matrix));for(let i=0,il=vertices2.length;i<il;i++){const vertexCopy=vertices2[i].clone();void 0!==matrix&&vertexCopy.applyMatrix4(matrix),vertices1.push(vertexCopy)}for(let i=0,il=colors2.length;i<il;i++)colors1.push(colors2[i].clone());for(let i=0,il=faces2.length;i<il;i++){let faceCopy,normal,color,face=faces2[i],faceVertexNormals=face.vertexNormals,faceVertexColors=face.vertexColors;faceCopy=new Face3(face.a+vertexOffset,face.b+vertexOffset,face.c+vertexOffset),faceCopy.normal.copy(face.normal),void 0!==normalMatrix&&faceCopy.normal.applyMatrix3(normalMatrix).normalize();for(let j=0,jl=faceVertexNormals.length;j<jl;j++)normal=faceVertexNormals[j].clone(),void 0!==normalMatrix&&normal.applyMatrix3(normalMatrix).normalize(),faceCopy.vertexNormals.push(normal);faceCopy.color.copy(face.color);for(let j=0,jl=faceVertexColors.length;j<jl;j++)color=faceVertexColors[j],faceCopy.vertexColors.push(color.clone());faceCopy.materialIndex=face.materialIndex+materialIndexOffset,faces1.push(faceCopy)}for(let i=0,il=geometry.faceVertexUvs.length;i<il;i++){const faceVertexUvs2=geometry.faceVertexUvs[i];void 0===this.faceVertexUvs[i]&&(this.faceVertexUvs[i]=[]);for(let j=0,jl=faceVertexUvs2.length;j<jl;j++){const uvs2=faceVertexUvs2[j],uvsCopy=[];for(let k=0,kl=uvs2.length;k<kl;k++)uvsCopy.push(uvs2[k].clone());this.faceVertexUvs[i].push(uvsCopy)}}},mergeMesh:function(mesh){mesh&&mesh.isMesh?(mesh.matrixAutoUpdate&&mesh.updateMatrix(),this.merge(mesh.geometry,mesh.matrix)):console.error("THREE.Geometry.mergeMesh(): mesh not an instance of THREE.Mesh.",mesh)},mergeVertices:function(){const verticesMap={},unique=[],changes=[],precision=Math.pow(10,4);for(let i=0,il=this.vertices.length;i<il;i++){const v=this.vertices[i],key=Math.round(v.x*precision)+"_"+Math.round(v.y*precision)+"_"+Math.round(v.z*precision);void 0===verticesMap[key]?(verticesMap[key]=i,unique.push(this.vertices[i]),changes[i]=unique.length-1):changes[i]=changes[verticesMap[key]]}const faceIndicesToRemove=[];for(let i=0,il=this.faces.length;i<il;i++){const face=this.faces[i];face.a=changes[face.a],face.b=changes[face.b],face.c=changes[face.c];const indices=[face.a,face.b,face.c];for(let n=0;n<3;n++)if(indices[n]===indices[(n+1)%3]){faceIndicesToRemove.push(i);break}}for(let i=faceIndicesToRemove.length-1;i>=0;i--){const idx=faceIndicesToRemove[i];this.faces.splice(idx,1);for(let j=0,jl=this.faceVertexUvs.length;j<jl;j++)this.faceVertexUvs[j].splice(idx,1)}const diff=this.vertices.length-unique.length;return this.vertices=unique,diff},setFromPoints:function(points){this.vertices=[];for(let i=0,l=points.length;i<l;i++){const point=points[i];this.vertices.push(new Vector3(point.x,point.y,point.z||0))}return this},sortFacesByMaterialIndex:function(){const faces=this.faces,length=faces.length;for(let i=0;i<length;i++)faces[i]._id=i;faces.sort((function(a,b){return a.materialIndex-b.materialIndex}));const uvs1=this.faceVertexUvs[0],uvs2=this.faceVertexUvs[1];let newUvs1,newUvs2;uvs1&&uvs1.length===length&&(newUvs1=[]),uvs2&&uvs2.length===length&&(newUvs2=[]);for(let i=0;i<length;i++){const id=faces[i]._id;newUvs1&&newUvs1.push(uvs1[id]),newUvs2&&newUvs2.push(uvs2[id])}newUvs1&&(this.faceVertexUvs[0]=newUvs1),newUvs2&&(this.faceVertexUvs[1]=newUvs2)},toJSON:function(){const data={metadata:{version:4.5,type:"Geometry",generator:"Geometry.toJSON"}};if(data.uuid=this.uuid,data.type=this.type,""!==this.name&&(data.name=this.name),void 0!==this.parameters){const parameters=this.parameters;for(const key in parameters)void 0!==parameters[key]&&(data[key]=parameters[key]);return data}const vertices=[];for(let i=0;i<this.vertices.length;i++){const vertex=this.vertices[i];vertices.push(vertex.x,vertex.y,vertex.z)}const faces=[],normals=[],normalsHash={},colors=[],colorsHash={},uvs=[],uvsHash={};for(let i=0;i<this.faces.length;i++){const face=this.faces[i],hasMaterial=!0,hasFaceUv=!1,hasFaceVertexUv=void 0!==this.faceVertexUvs[0][i],hasFaceNormal=face.normal.length()>0,hasFaceVertexNormal=face.vertexNormals.length>0,hasFaceColor=1!==face.color.r||1!==face.color.g||1!==face.color.b,hasFaceVertexColor=face.vertexColors.length>0;let faceType=0;if(faceType=setBit(faceType,0,0),faceType=setBit(faceType,1,hasMaterial),faceType=setBit(faceType,2,hasFaceUv),faceType=setBit(faceType,3,hasFaceVertexUv),faceType=setBit(faceType,4,hasFaceNormal),faceType=setBit(faceType,5,hasFaceVertexNormal),faceType=setBit(faceType,6,hasFaceColor),faceType=setBit(faceType,7,hasFaceVertexColor),faces.push(faceType),faces.push(face.a,face.b,face.c),faces.push(face.materialIndex),hasFaceVertexUv){const faceVertexUvs=this.faceVertexUvs[0][i];faces.push(getUvIndex(faceVertexUvs[0]),getUvIndex(faceVertexUvs[1]),getUvIndex(faceVertexUvs[2]))}if(hasFaceNormal&&faces.push(getNormalIndex(face.normal)),hasFaceVertexNormal){const vertexNormals=face.vertexNormals;faces.push(getNormalIndex(vertexNormals[0]),getNormalIndex(vertexNormals[1]),getNormalIndex(vertexNormals[2]))}if(hasFaceColor&&faces.push(getColorIndex(face.color)),hasFaceVertexColor){const vertexColors=face.vertexColors;faces.push(getColorIndex(vertexColors[0]),getColorIndex(vertexColors[1]),getColorIndex(vertexColors[2]))}}function setBit(value,position,enabled){return enabled?value|1<<position:value&~(1<<position)}function getNormalIndex(normal){const hash=normal.x.toString()+normal.y.toString()+normal.z.toString();return void 0!==normalsHash[hash]||(normalsHash[hash]=normals.length/3,normals.push(normal.x,normal.y,normal.z)),normalsHash[hash]}function getColorIndex(color){const hash=color.r.toString()+color.g.toString()+color.b.toString();return void 0!==colorsHash[hash]||(colorsHash[hash]=colors.length,colors.push(color.getHex())),colorsHash[hash]}function getUvIndex(uv){const hash=uv.x.toString()+uv.y.toString();return void 0!==uvsHash[hash]||(uvsHash[hash]=uvs.length/2,uvs.push(uv.x,uv.y)),uvsHash[hash]}return data.data={},data.data.vertices=vertices,data.data.normals=normals,colors.length>0&&(data.data.colors=colors),uvs.length>0&&(data.data.uvs=[uvs]),data.data.faces=faces,data},clone:function(){return(new Geometry).copy(this)},copy:function(source){this.vertices=[],this.colors=[],this.faces=[],this.faceVertexUvs=[[]],this.morphTargets=[],this.morphNormals=[],this.skinWeights=[],this.skinIndices=[],this.lineDistances=[],this.boundingBox=null,this.boundingSphere=null,this.name=source.name;const vertices=source.vertices;for(let i=0,il=vertices.length;i<il;i++)this.vertices.push(vertices[i].clone());const colors=source.colors;for(let i=0,il=colors.length;i<il;i++)this.colors.push(colors[i].clone());const faces=source.faces;for(let i=0,il=faces.length;i<il;i++)this.faces.push(faces[i].clone());for(let i=0,il=source.faceVertexUvs.length;i<il;i++){const faceVertexUvs=source.faceVertexUvs[i];void 0===this.faceVertexUvs[i]&&(this.faceVertexUvs[i]=[]);for(let j=0,jl=faceVertexUvs.length;j<jl;j++){const uvs=faceVertexUvs[j],uvsCopy=[];for(let k=0,kl=uvs.length;k<kl;k++){const uv=uvs[k];uvsCopy.push(uv.clone())}this.faceVertexUvs[i].push(uvsCopy)}}const morphTargets=source.morphTargets;for(let i=0,il=morphTargets.length;i<il;i++){const morphTarget={};if(morphTarget.name=morphTargets[i].name,void 0!==morphTargets[i].vertices){morphTarget.vertices=[];for(let j=0,jl=morphTargets[i].vertices.length;j<jl;j++)morphTarget.vertices.push(morphTargets[i].vertices[j].clone())}if(void 0!==morphTargets[i].normals){morphTarget.normals=[];for(let j=0,jl=morphTargets[i].normals.length;j<jl;j++)morphTarget.normals.push(morphTargets[i].normals[j].clone())}this.morphTargets.push(morphTarget)}const morphNormals=source.morphNormals;for(let i=0,il=morphNormals.length;i<il;i++){const morphNormal={};if(void 0!==morphNormals[i].vertexNormals){morphNormal.vertexNormals=[];for(let j=0,jl=morphNormals[i].vertexNormals.length;j<jl;j++){const srcVertexNormal=morphNormals[i].vertexNormals[j],destVertexNormal={};destVertexNormal.a=srcVertexNormal.a.clone(),destVertexNormal.b=srcVertexNormal.b.clone(),destVertexNormal.c=srcVertexNormal.c.clone(),morphNormal.vertexNormals.push(destVertexNormal)}}if(void 0!==morphNormals[i].faceNormals){morphNormal.faceNormals=[];for(let j=0,jl=morphNormals[i].faceNormals.length;j<jl;j++)morphNormal.faceNormals.push(morphNormals[i].faceNormals[j].clone())}this.morphNormals.push(morphNormal)}const skinWeights=source.skinWeights;for(let i=0,il=skinWeights.length;i<il;i++)this.skinWeights.push(skinWeights[i].clone());const skinIndices=source.skinIndices;for(let i=0,il=skinIndices.length;i<il;i++)this.skinIndices.push(skinIndices[i].clone());const lineDistances=source.lineDistances;for(let i=0,il=lineDistances.length;i<il;i++)this.lineDistances.push(lineDistances[i]);const boundingBox=source.boundingBox;null!==boundingBox&&(this.boundingBox=boundingBox.clone());const boundingSphere=source.boundingSphere;return null!==boundingSphere&&(this.boundingSphere=boundingSphere.clone()),this.elementsNeedUpdate=source.elementsNeedUpdate,this.verticesNeedUpdate=source.verticesNeedUpdate,this.uvsNeedUpdate=source.uvsNeedUpdate,this.normalsNeedUpdate=source.normalsNeedUpdate,this.colorsNeedUpdate=source.colorsNeedUpdate,this.lineDistancesNeedUpdate=source.lineDistancesNeedUpdate,this.groupsNeedUpdate=source.groupsNeedUpdate,this},dispose:function(){this.dispatchEvent({type:"dispose"})}});class BoxBufferGeometry extends BufferGeometry{constructor(width=1,height=1,depth=1,widthSegments=1,heightSegments=1,depthSegments=1){super(),this.type="BoxBufferGeometry",this.parameters={width,height,depth,widthSegments,heightSegments,depthSegments};const scope=this;widthSegments=Math.floor(widthSegments),heightSegments=Math.floor(heightSegments),depthSegments=Math.floor(depthSegments);const indices=[],vertices=[],normals=[],uvs=[];let numberOfVertices=0,groupStart=0;function buildPlane(u,v,w,udir,vdir,width,height,depth,gridX,gridY,materialIndex){const segmentWidth=width/gridX,segmentHeight=height/gridY,widthHalf=width/2,heightHalf=height/2,depthHalf=depth/2,gridX1=gridX+1,gridY1=gridY+1;let vertexCounter=0,groupCount=0;const vector=new Vector3;for(let iy=0;iy<gridY1;iy++){const y=iy*segmentHeight-heightHalf;for(let ix=0;ix<gridX1;ix++){const x=ix*segmentWidth-widthHalf;vector[u]=x*udir,vector[v]=y*vdir,vector[w]=depthHalf,vertices.push(vector.x,vector.y,vector.z),vector[u]=0,vector[v]=0,vector[w]=depth>0?1:-1,normals.push(vector.x,vector.y,vector.z),uvs.push(ix/gridX),uvs.push(1-iy/gridY),vertexCounter+=1}}for(let iy=0;iy<gridY;iy++)for(let ix=0;ix<gridX;ix++){const a=numberOfVertices+ix+gridX1*iy,b=numberOfVertices+ix+gridX1*(iy+1),c=numberOfVertices+(ix+1)+gridX1*(iy+1),d=numberOfVertices+(ix+1)+gridX1*iy;indices.push(a,b,d),indices.push(b,c,d),groupCount+=6}scope.addGroup(groupStart,groupCount,materialIndex),groupStart+=groupCount,numberOfVertices+=vertexCounter}buildPlane("z","y","x",-1,-1,depth,height,width,depthSegments,heightSegments,0),buildPlane("z","y","x",1,-1,depth,height,-width,depthSegments,heightSegments,1),buildPlane("x","z","y",1,1,width,depth,height,widthSegments,depthSegments,2),buildPlane("x","z","y",1,-1,width,depth,-height,widthSegments,depthSegments,3),buildPlane("x","y","z",1,-1,width,height,depth,widthSegments,heightSegments,4),buildPlane("x","y","z",-1,-1,width,height,-depth,widthSegments,heightSegments,5),this.setIndex(indices),this.setAttribute("position",new Float32BufferAttribute(vertices,3)),this.setAttribute("normal",new Float32BufferAttribute(normals,3)),this.setAttribute("uv",new Float32BufferAttribute(uvs,2))}}function cloneUniforms(src){const dst={};for(const u in src){dst[u]={};for(const p in src[u]){const property=src[u][p];property&&(property.isColor||property.isMatrix3||property.isMatrix4||property.isVector2||property.isVector3||property.isVector4||property.isTexture)?dst[u][p]=property.clone():Array.isArray(property)?dst[u][p]=property.slice():dst[u][p]=property}}return dst}function mergeUniforms(uniforms){const merged={};for(let u=0;u<uniforms.length;u++){const tmp=cloneUniforms(uniforms[u]);for(const p in tmp)merged[p]=tmp[p]}return merged}const UniformsUtils={clone:cloneUniforms,merge:mergeUniforms};function ShaderMaterial(parameters){Material.call(this),this.type="ShaderMaterial",this.defines={},this.uniforms={},this.vertexShader="void main() {\n\tgl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",this.fragmentShader="void main() {\n\tgl_FragColor = vec4( 1.0, 0.0, 0.0, 1.0 );\n}",this.linewidth=1,this.wireframe=!1,this.wireframeLinewidth=1,this.fog=!1,this.lights=!1,this.clipping=!1,this.skinning=!1,this.morphTargets=!1,this.morphNormals=!1,this.extensions={derivatives:!1,fragDepth:!1,drawBuffers:!1,shaderTextureLOD:!1},this.defaultAttributeValues={color:[1,1,1],uv:[0,0],uv2:[0,0]},this.index0AttributeName=void 0,this.uniformsNeedUpdate=!1,void 0!==parameters&&(void 0!==parameters.attributes&&console.error("THREE.ShaderMaterial: attributes should now be defined in THREE.BufferGeometry instead."),this.setValues(parameters))}function Camera(){Object3D.call(this),this.type="Camera",this.matrixWorldInverse=new Matrix4,this.projectionMatrix=new Matrix4,this.projectionMatrixInverse=new Matrix4}function PerspectiveCamera(fov,aspect,near,far){Camera.call(this),this.type="PerspectiveCamera",this.fov=void 0!==fov?fov:50,this.zoom=1,this.near=void 0!==near?near:.1,this.far=void 0!==far?far:2e3,this.focus=10,this.aspect=void 0!==aspect?aspect:1,this.view=null,this.filmGauge=35,this.filmOffset=0,this.updateProjectionMatrix()}ShaderMaterial.prototype=Object.create(Material.prototype),ShaderMaterial.prototype.constructor=ShaderMaterial,ShaderMaterial.prototype.isShaderMaterial=!0,ShaderMaterial.prototype.copy=function(source){return Material.prototype.copy.call(this,source),this.fragmentShader=source.fragmentShader,this.vertexShader=source.vertexShader,this.uniforms=cloneUniforms(source.uniforms),this.defines=Object.assign({},source.defines),this.wireframe=source.wireframe,this.wireframeLinewidth=source.wireframeLinewidth,this.lights=source.lights,this.clipping=source.clipping,this.skinning=source.skinning,this.morphTargets=source.morphTargets,this.morphNormals=source.morphNormals,this.extensions=Object.assign({},source.extensions),this},ShaderMaterial.prototype.toJSON=function(meta){const data=Material.prototype.toJSON.call(this,meta);data.uniforms={};for(const name in this.uniforms){const value=this.uniforms[name].value;value&&value.isTexture?data.uniforms[name]={type:"t",value:value.toJSON(meta).uuid}:value&&value.isColor?data.uniforms[name]={type:"c",value:value.getHex()}:value&&value.isVector2?data.uniforms[name]={type:"v2",value:value.toArray()}:value&&value.isVector3?data.uniforms[name]={type:"v3",value:value.toArray()}:value&&value.isVector4?data.uniforms[name]={type:"v4",value:value.toArray()}:value&&value.isMatrix3?data.uniforms[name]={type:"m3",value:value.toArray()}:value&&value.isMatrix4?data.uniforms[name]={type:"m4",value:value.toArray()}:data.uniforms[name]={value}}Object.keys(this.defines).length>0&&(data.defines=this.defines),data.vertexShader=this.vertexShader,data.fragmentShader=this.fragmentShader;const extensions={};for(const key in this.extensions)!0===this.extensions[key]&&(extensions[key]=!0);return Object.keys(extensions).length>0&&(data.extensions=extensions),data},Camera.prototype=Object.assign(Object.create(Object3D.prototype),{constructor:Camera,isCamera:!0,copy:function(source,recursive){return Object3D.prototype.copy.call(this,source,recursive),this.matrixWorldInverse.copy(source.matrixWorldInverse),this.projectionMatrix.copy(source.projectionMatrix),this.projectionMatrixInverse.copy(source.projectionMatrixInverse),this},getWorldDirection:function(target){void 0===target&&(console.warn("THREE.Camera: .getWorldDirection() target is now required"),target=new Vector3),this.updateMatrixWorld(!0);const e=this.matrixWorld.elements;return target.set(-e[8],-e[9],-e[10]).normalize()},updateMatrixWorld:function(force){Object3D.prototype.updateMatrixWorld.call(this,force),this.matrixWorldInverse.getInverse(this.matrixWorld)},updateWorldMatrix:function(updateParents,updateChildren){Object3D.prototype.updateWorldMatrix.call(this,updateParents,updateChildren),this.matrixWorldInverse.getInverse(this.matrixWorld)},clone:function(){return(new this.constructor).copy(this)}}),PerspectiveCamera.prototype=Object.assign(Object.create(Camera.prototype),{constructor:PerspectiveCamera,isPerspectiveCamera:!0,copy:function(source,recursive){return Camera.prototype.copy.call(this,source,recursive),this.fov=source.fov,this.zoom=source.zoom,this.near=source.near,this.far=source.far,this.focus=source.focus,this.aspect=source.aspect,this.view=null===source.view?null:Object.assign({},source.view),this.filmGauge=source.filmGauge,this.filmOffset=source.filmOffset,this},setFocalLength:function(focalLength){const vExtentSlope=.5*this.getFilmHeight()/focalLength;this.fov=2*MathUtils.RAD2DEG*Math.atan(vExtentSlope),this.updateProjectionMatrix()},getFocalLength:function(){const vExtentSlope=Math.tan(.5*MathUtils.DEG2RAD*this.fov);return.5*this.getFilmHeight()/vExtentSlope},getEffectiveFOV:function(){return 2*MathUtils.RAD2DEG*Math.atan(Math.tan(.5*MathUtils.DEG2RAD*this.fov)/this.zoom)},getFilmWidth:function(){return this.filmGauge*Math.min(this.aspect,1)},getFilmHeight:function(){return this.filmGauge/Math.max(this.aspect,1)},setViewOffset:function(fullWidth,fullHeight,x,y,width,height){this.aspect=fullWidth/fullHeight,null===this.view&&(this.view={enabled:!0,fullWidth:1,fullHeight:1,offsetX:0,offsetY:0,width:1,height:1}),this.view.enabled=!0,this.view.fullWidth=fullWidth,this.view.fullHeight=fullHeight,this.view.offsetX=x,this.view.offsetY=y,this.view.width=width,this.view.height=height,this.updateProjectionMatrix()},clearViewOffset:function(){null!==this.view&&(this.view.enabled=!1),this.updateProjectionMatrix()},updateProjectionMatrix:function(){let near=this.near,top=near*Math.tan(.5*MathUtils.DEG2RAD*this.fov)/this.zoom,height=2*top,width=this.aspect*height,left=-.5*width,view=this.view;if(null!==this.view&&this.view.enabled){const fullWidth=view.fullWidth,fullHeight=view.fullHeight;left+=view.offsetX*width/fullWidth,top-=view.offsetY*height/fullHeight,width*=view.width/fullWidth,height*=view.height/fullHeight}const skew=this.filmOffset;0!==skew&&(left+=near*skew/this.getFilmWidth()),this.projectionMatrix.makePerspective(left,left+width,top,top-height,near,this.far),this.projectionMatrixInverse.getInverse(this.projectionMatrix)},toJSON:function(meta){const data=Object3D.prototype.toJSON.call(this,meta);return data.object.fov=this.fov,data.object.zoom=this.zoom,data.object.near=this.near,data.object.far=this.far,data.object.focus=this.focus,data.object.aspect=this.aspect,null!==this.view&&(data.object.view=Object.assign({},this.view)),data.object.filmGauge=this.filmGauge,data.object.filmOffset=this.filmOffset,data}});function CubeCamera(near,far,renderTarget){if(Object3D.call(this),this.type="CubeCamera",!0!==renderTarget.isWebGLCubeRenderTarget)return void console.error("THREE.CubeCamera: The constructor now expects an instance of WebGLCubeRenderTarget as third parameter.");this.renderTarget=renderTarget;const cameraPX=new PerspectiveCamera(90,1,near,far);cameraPX.layers=this.layers,cameraPX.up.set(0,-1,0),cameraPX.lookAt(new Vector3(1,0,0)),this.add(cameraPX);const cameraNX=new PerspectiveCamera(90,1,near,far);cameraNX.layers=this.layers,cameraNX.up.set(0,-1,0),cameraNX.lookAt(new Vector3(-1,0,0)),this.add(cameraNX);const cameraPY=new PerspectiveCamera(90,1,near,far);cameraPY.layers=this.layers,cameraPY.up.set(0,0,1),cameraPY.lookAt(new Vector3(0,1,0)),this.add(cameraPY);const cameraNY=new PerspectiveCamera(90,1,near,far);cameraNY.layers=this.layers,cameraNY.up.set(0,0,-1),cameraNY.lookAt(new Vector3(0,-1,0)),this.add(cameraNY);const cameraPZ=new PerspectiveCamera(90,1,near,far);cameraPZ.layers=this.layers,cameraPZ.up.set(0,-1,0),cameraPZ.lookAt(new Vector3(0,0,1)),this.add(cameraPZ);const cameraNZ=new PerspectiveCamera(90,1,near,far);cameraNZ.layers=this.layers,cameraNZ.up.set(0,-1,0),cameraNZ.lookAt(new Vector3(0,0,-1)),this.add(cameraNZ),this.update=function(renderer,scene){null===this.parent&&this.updateMatrixWorld();const currentXrEnabled=renderer.xr.enabled,currentRenderTarget=renderer.getRenderTarget();renderer.xr.enabled=!1;const generateMipmaps=renderTarget.texture.generateMipmaps;renderTarget.texture.generateMipmaps=!1,renderer.setRenderTarget(renderTarget,0),renderer.render(scene,cameraPX),renderer.setRenderTarget(renderTarget,1),renderer.render(scene,cameraNX),renderer.setRenderTarget(renderTarget,2),renderer.render(scene,cameraPY),renderer.setRenderTarget(renderTarget,3),renderer.render(scene,cameraNY),renderer.setRenderTarget(renderTarget,4),renderer.render(scene,cameraPZ),renderTarget.texture.generateMipmaps=generateMipmaps,renderer.setRenderTarget(renderTarget,5),renderer.render(scene,cameraNZ),renderer.setRenderTarget(currentRenderTarget),renderer.xr.enabled=currentXrEnabled},this.clear=function(renderer,color,depth,stencil){const currentRenderTarget=renderer.getRenderTarget();for(let i=0;i<6;i++)renderer.setRenderTarget(renderTarget,i),renderer.clear(color,depth,stencil);renderer.setRenderTarget(currentRenderTarget)}}function WebGLCubeRenderTarget(size,options,dummy){Number.isInteger(options)&&(console.warn("THREE.WebGLCubeRenderTarget: constructor signature is now WebGLCubeRenderTarget( size, options )"),options=dummy),WebGLRenderTarget.call(this,size,size,options)}function DataTexture(data,width,height,format,type,mapping,wrapS,wrapT,magFilter,minFilter,anisotropy,encoding){Texture.call(this,null,mapping,wrapS,wrapT,magFilter,minFilter,format,type,anisotropy,encoding),this.image={data:data||null,width:width||1,height:height||1},this.magFilter=void 0!==magFilter?magFilter:1003,this.minFilter=void 0!==minFilter?minFilter:1003,this.generateMipmaps=!1,this.flipY=!1,this.unpackAlignment=1,this.needsUpdate=!0}CubeCamera.prototype=Object.create(Object3D.prototype),CubeCamera.prototype.constructor=CubeCamera,WebGLCubeRenderTarget.prototype=Object.create(WebGLRenderTarget.prototype),WebGLCubeRenderTarget.prototype.constructor=WebGLCubeRenderTarget,WebGLCubeRenderTarget.prototype.isWebGLCubeRenderTarget=!0,WebGLCubeRenderTarget.prototype.fromEquirectangularTexture=function(renderer,texture){this.texture.type=texture.type,this.texture.format=1023,this.texture.encoding=texture.encoding,this.texture.generateMipmaps=texture.generateMipmaps,this.texture.minFilter=texture.minFilter,this.texture.magFilter=texture.magFilter;const scene=new Scene,shader={uniforms:{tEquirect:{value:null}},vertexShader:"\n\n\t\t\tvarying vec3 vWorldDirection;\n\n\t\t\tvec3 transformDirection( in vec3 dir, in mat4 matrix ) {\n\n\t\t\t\treturn normalize( ( matrix * vec4( dir, 0.0 ) ).xyz );\n\n\t\t\t}\n\n\t\t\tvoid main() {\n\n\t\t\t\tvWorldDirection = transformDirection( position, modelMatrix );\n\n\t\t\t\t#include <begin_vertex>\n\t\t\t\t#include <project_vertex>\n\n\t\t\t}\n\t\t",fragmentShader:"\n\n\t\t\tuniform sampler2D tEquirect;\n\n\t\t\tvarying vec3 vWorldDirection;\n\n\t\t\t#include <common>\n\n\t\t\tvoid main() {\n\n\t\t\t\tvec3 direction = normalize( vWorldDirection );\n\n\t\t\t\tvec2 sampleUV = equirectUv( direction );\n\n\t\t\t\tgl_FragColor = texture2D( tEquirect, sampleUV );\n\n\t\t\t}\n\t\t"},material=new ShaderMaterial({name:"CubemapFromEquirect",uniforms:cloneUniforms(shader.uniforms),vertexShader:shader.vertexShader,fragmentShader:shader.fragmentShader,side:1,blending:0});material.uniforms.tEquirect.value=texture;const mesh=new Mesh(new BoxBufferGeometry(5,5,5),material);scene.add(mesh);return new CubeCamera(1,10,this).update(renderer,scene),mesh.geometry.dispose(),mesh.material.dispose(),this},DataTexture.prototype=Object.create(Texture.prototype),DataTexture.prototype.constructor=DataTexture,DataTexture.prototype.isDataTexture=!0;const _sphere$1=new Sphere,_vector$5=new Vector3;function Frustum(p0,p1,p2,p3,p4,p5){this.planes=[void 0!==p0?p0:new Plane,void 0!==p1?p1:new Plane,void 0!==p2?p2:new Plane,void 0!==p3?p3:new Plane,void 0!==p4?p4:new Plane,void 0!==p5?p5:new Plane]}Object.assign(Frustum.prototype,{set:function(p0,p1,p2,p3,p4,p5){const planes=this.planes;return planes[0].copy(p0),planes[1].copy(p1),planes[2].copy(p2),planes[3].copy(p3),planes[4].copy(p4),planes[5].copy(p5),this},clone:function(){return(new this.constructor).copy(this)},copy:function(frustum){const planes=this.planes;for(let i=0;i<6;i++)planes[i].copy(frustum.planes[i]);return this},setFromProjectionMatrix:function(m){const planes=this.planes,me=m.elements,me0=me[0],me1=me[1],me2=me[2],me3=me[3],me4=me[4],me5=me[5],me6=me[6],me7=me[7],me8=me[8],me9=me[9],me10=me[10],me11=me[11],me12=me[12],me13=me[13],me14=me[14],me15=me[15];return planes[0].setComponents(me3-me0,me7-me4,me11-me8,me15-me12).normalize(),planes[1].setComponents(me3+me0,me7+me4,me11+me8,me15+me12).normalize(),planes[2].setComponents(me3+me1,me7+me5,me11+me9,me15+me13).normalize(),planes[3].setComponents(me3-me1,me7-me5,me11-me9,me15-me13).normalize(),planes[4].setComponents(me3-me2,me7-me6,me11-me10,me15-me14).normalize(),planes[5].setComponents(me3+me2,me7+me6,me11+me10,me15+me14).normalize(),this},intersectsObject:function(object){const geometry=object.geometry;return null===geometry.boundingSphere&&geometry.computeBoundingSphere(),_sphere$1.copy(geometry.boundingSphere).applyMatrix4(object.matrixWorld),this.intersectsSphere(_sphere$1)},intersectsSprite:function(sprite){return _sphere$1.center.set(0,0,0),_sphere$1.radius=.7071067811865476,_sphere$1.applyMatrix4(sprite.matrixWorld),this.intersectsSphere(_sphere$1)},intersectsSphere:function(sphere){const planes=this.planes,center=sphere.center,negRadius=-sphere.radius;for(let i=0;i<6;i++){if(planes[i].distanceToPoint(center)<negRadius)return!1}return!0},intersectsBox:function(box){const planes=this.planes;for(let i=0;i<6;i++){const plane=planes[i];if(_vector$5.x=plane.normal.x>0?box.max.x:box.min.x,_vector$5.y=plane.normal.y>0?box.max.y:box.min.y,_vector$5.z=plane.normal.z>0?box.max.z:box.min.z,plane.distanceToPoint(_vector$5)<0)return!1}return!0},containsPoint:function(point){const planes=this.planes;for(let i=0;i<6;i++)if(planes[i].distanceToPoint(point)<0)return!1;return!0}});const UniformsLib={common:{diffuse:{value:new Color(15658734)},opacity:{value:1},map:{value:null},uvTransform:{value:new Matrix3},uv2Transform:{value:new Matrix3},alphaMap:{value:null}},specularmap:{specularMap:{value:null}},envmap:{envMap:{value:null},flipEnvMap:{value:-1},reflectivity:{value:1},refractionRatio:{value:.98},maxMipLevel:{value:0}},aomap:{aoMap:{value:null},aoMapIntensity:{value:1}},lightmap:{lightMap:{value:null},lightMapIntensity:{value:1}},emissivemap:{emissiveMap:{value:null}},bumpmap:{bumpMap:{value:null},bumpScale:{value:1}},normalmap:{normalMap:{value:null},normalScale:{value:new Vector2(1,1)}},displacementmap:{displacementMap:{value:null},displacementScale:{value:1},displacementBias:{value:0}},roughnessmap:{roughnessMap:{value:null}},metalnessmap:{metalnessMap:{value:null}},gradientmap:{gradientMap:{value:null}},fog:{fogDensity:{value:25e-5},fogNear:{value:1},fogFar:{value:2e3},fogColor:{value:new Color(16777215)}},lights:{ambientLightColor:{value:[]},lightProbe:{value:[]},directionalLights:{value:[],properties:{direction:{},color:{}}},directionalLightShadows:{value:[],properties:{shadowBias:{},shadowNormalBias:{},shadowRadius:{},shadowMapSize:{}}},directionalShadowMap:{value:[]},directionalShadowMatrix:{value:[]},spotLights:{value:[],properties:{color:{},position:{},direction:{},distance:{},coneCos:{},penumbraCos:{},decay:{}}},spotLightShadows:{value:[],properties:{shadowBias:{},shadowNormalBias:{},shadowRadius:{},shadowMapSize:{}}},spotShadowMap:{value:[]},spotShadowMatrix:{value:[]},pointLights:{value:[],properties:{color:{},position:{},decay:{},distance:{}}},pointLightShadows:{value:[],properties:{shadowBias:{},shadowNormalBias:{},shadowRadius:{},shadowMapSize:{},shadowCameraNear:{},shadowCameraFar:{}}},pointShadowMap:{value:[]},pointShadowMatrix:{value:[]},hemisphereLights:{value:[],properties:{direction:{},skyColor:{},groundColor:{}}},rectAreaLights:{value:[],properties:{color:{},position:{},width:{},height:{}}}},points:{diffuse:{value:new Color(15658734)},opacity:{value:1},size:{value:1},scale:{value:1},map:{value:null},alphaMap:{value:null},uvTransform:{value:new Matrix3}},sprite:{diffuse:{value:new Color(15658734)},opacity:{value:1},center:{value:new Vector2(.5,.5)},rotation:{value:0},map:{value:null},alphaMap:{value:null},uvTransform:{value:new Matrix3}}};function WebGLAnimation(){let context=null,isAnimating=!1,animationLoop=null,requestId=null;function onAnimationFrame(time,frame){animationLoop(time,frame),requestId=context.requestAnimationFrame(onAnimationFrame)}return{start:function(){!0!==isAnimating&&null!==animationLoop&&(requestId=context.requestAnimationFrame(onAnimationFrame),isAnimating=!0)},stop:function(){context.cancelAnimationFrame(requestId),isAnimating=!1},setAnimationLoop:function(callback){animationLoop=callback},setContext:function(value){context=value}}}function WebGLAttributes(gl,capabilities){const isWebGL2=capabilities.isWebGL2,buffers=new WeakMap;return{get:function(attribute){return attribute.isInterleavedBufferAttribute&&(attribute=attribute.data),buffers.get(attribute)},remove:function(attribute){attribute.isInterleavedBufferAttribute&&(attribute=attribute.data);const data=buffers.get(attribute);data&&(gl.deleteBuffer(data.buffer),buffers.delete(attribute))},update:function(attribute,bufferType){attribute.isInterleavedBufferAttribute&&(attribute=attribute.data);const data=buffers.get(attribute);void 0===data?buffers.set(attribute,function(attribute,bufferType){const array=attribute.array,usage=attribute.usage,buffer=gl.createBuffer();gl.bindBuffer(bufferType,buffer),gl.bufferData(bufferType,array,usage),attribute.onUploadCallback();let type=5126;return array instanceof Float32Array?type=5126:array instanceof Float64Array?console.warn("THREE.WebGLAttributes: Unsupported data buffer format: Float64Array."):array instanceof Uint16Array?type=5123:array instanceof Int16Array?type=5122:array instanceof Uint32Array?type=5125:array instanceof Int32Array?type=5124:array instanceof Int8Array?type=5120:array instanceof Uint8Array&&(type=5121),{buffer,type,bytesPerElement:array.BYTES_PER_ELEMENT,version:attribute.version}}(attribute,bufferType)):data.version<attribute.version&&(!function(buffer,attribute,bufferType){const array=attribute.array,updateRange=attribute.updateRange;gl.bindBuffer(bufferType,buffer),-1===updateRange.count?gl.bufferSubData(bufferType,0,array):(isWebGL2?gl.bufferSubData(bufferType,updateRange.offset*array.BYTES_PER_ELEMENT,array,updateRange.offset,updateRange.count):gl.bufferSubData(bufferType,updateRange.offset*array.BYTES_PER_ELEMENT,array.subarray(updateRange.offset,updateRange.offset+updateRange.count)),updateRange.count=-1)}(data.buffer,attribute,bufferType),data.version=attribute.version)}}}function PlaneGeometry(width,height,widthSegments,heightSegments){Geometry.call(this),this.type="PlaneGeometry",this.parameters={width,height,widthSegments,heightSegments},this.fromBufferGeometry(new PlaneBufferGeometry(width,height,widthSegments,heightSegments)),this.mergeVertices()}function PlaneBufferGeometry(width,height,widthSegments,heightSegments){BufferGeometry.call(this),this.type="PlaneBufferGeometry",this.parameters={width,height,widthSegments,heightSegments};const width_half=(width=width||1)/2,height_half=(height=height||1)/2,gridX=Math.floor(widthSegments)||1,gridY=Math.floor(heightSegments)||1,gridX1=gridX+1,gridY1=gridY+1,segment_width=width/gridX,segment_height=height/gridY,indices=[],vertices=[],normals=[],uvs=[];for(let iy=0;iy<gridY1;iy++){const y=iy*segment_height-height_half;for(let ix=0;ix<gridX1;ix++){const x=ix*segment_width-width_half;vertices.push(x,-y,0),normals.push(0,0,1),uvs.push(ix/gridX),uvs.push(1-iy/gridY)}}for(let iy=0;iy<gridY;iy++)for(let ix=0;ix<gridX;ix++){const a=ix+gridX1*iy,b=ix+gridX1*(iy+1),c=ix+1+gridX1*(iy+1),d=ix+1+gridX1*iy;indices.push(a,b,d),indices.push(b,c,d)}this.setIndex(indices),this.setAttribute("position",new Float32BufferAttribute(vertices,3)),this.setAttribute("normal",new Float32BufferAttribute(normals,3)),this.setAttribute("uv",new Float32BufferAttribute(uvs,2))}PlaneGeometry.prototype=Object.create(Geometry.prototype),PlaneGeometry.prototype.constructor=PlaneGeometry,PlaneBufferGeometry.prototype=Object.create(BufferGeometry.prototype),PlaneBufferGeometry.prototype.constructor=PlaneBufferGeometry;const ShaderChunk={alphamap_fragment:"#ifdef USE_ALPHAMAP\n\tdiffuseColor.a *= texture2D( alphaMap, vUv ).g;\n#endif",alphamap_pars_fragment:"#ifdef USE_ALPHAMAP\n\tuniform sampler2D alphaMap;\n#endif",alphatest_fragment:"#ifdef ALPHATEST\n\tif ( diffuseColor.a < ALPHATEST ) discard;\n#endif",aomap_fragment:"#ifdef USE_AOMAP\n\tfloat ambientOcclusion = ( texture2D( aoMap, vUv2 ).r - 1.0 ) * aoMapIntensity + 1.0;\n\treflectedLight.indirectDiffuse *= ambientOcclusion;\n\t#if defined( USE_ENVMAP ) && defined( STANDARD )\n\t\tfloat dotNV = saturate( dot( geometry.normal, geometry.viewDir ) );\n\t\treflectedLight.indirectSpecular *= computeSpecularOcclusion( dotNV, ambientOcclusion, material.specularRoughness );\n\t#endif\n#endif",aomap_pars_fragment:"#ifdef USE_AOMAP\n\tuniform sampler2D aoMap;\n\tuniform float aoMapIntensity;\n#endif",begin_vertex:"vec3 transformed = vec3( position );",beginnormal_vertex:"vec3 objectNormal = vec3( normal );\n#ifdef USE_TANGENT\n\tvec3 objectTangent = vec3( tangent.xyz );\n#endif",bsdfs:"vec2 integrateSpecularBRDF( const in float dotNV, const in float roughness ) {\n\tconst vec4 c0 = vec4( - 1, - 0.0275, - 0.572, 0.022 );\n\tconst vec4 c1 = vec4( 1, 0.0425, 1.04, - 0.04 );\n\tvec4 r = roughness * c0 + c1;\n\tfloat a004 = min( r.x * r.x, exp2( - 9.28 * dotNV ) ) * r.x + r.y;\n\treturn vec2( -1.04, 1.04 ) * a004 + r.zw;\n}\nfloat punctualLightIntensityToIrradianceFactor( const in float lightDistance, const in float cutoffDistance, const in float decayExponent ) {\n#if defined ( PHYSICALLY_CORRECT_LIGHTS )\n\tfloat distanceFalloff = 1.0 / max( pow( lightDistance, decayExponent ), 0.01 );\n\tif( cutoffDistance > 0.0 ) {\n\t\tdistanceFalloff *= pow2( saturate( 1.0 - pow4( lightDistance / cutoffDistance ) ) );\n\t}\n\treturn distanceFalloff;\n#else\n\tif( cutoffDistance > 0.0 && decayExponent > 0.0 ) {\n\t\treturn pow( saturate( -lightDistance / cutoffDistance + 1.0 ), decayExponent );\n\t}\n\treturn 1.0;\n#endif\n}\nvec3 BRDF_Diffuse_Lambert( const in vec3 diffuseColor ) {\n\treturn RECIPROCAL_PI * diffuseColor;\n}\nvec3 F_Schlick( const in vec3 specularColor, const in float dotLH ) {\n\tfloat fresnel = exp2( ( -5.55473 * dotLH - 6.98316 ) * dotLH );\n\treturn ( 1.0 - specularColor ) * fresnel + specularColor;\n}\nvec3 F_Schlick_RoughnessDependent( const in vec3 F0, const in float dotNV, const in float roughness ) {\n\tfloat fresnel = exp2( ( -5.55473 * dotNV - 6.98316 ) * dotNV );\n\tvec3 Fr = max( vec3( 1.0 - roughness ), F0 ) - F0;\n\treturn Fr * fresnel + F0;\n}\nfloat G_GGX_Smith( const in float alpha, const in float dotNL, const in float dotNV ) {\n\tfloat a2 = pow2( alpha );\n\tfloat gl = dotNL + sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNL ) );\n\tfloat gv = dotNV + sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNV ) );\n\treturn 1.0 / ( gl * gv );\n}\nfloat G_GGX_SmithCorrelated( const in float alpha, const in float dotNL, const in float dotNV ) {\n\tfloat a2 = pow2( alpha );\n\tfloat gv = dotNL * sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNV ) );\n\tfloat gl = dotNV * sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNL ) );\n\treturn 0.5 / max( gv + gl, EPSILON );\n}\nfloat D_GGX( const in float alpha, const in float dotNH ) {\n\tfloat a2 = pow2( alpha );\n\tfloat denom = pow2( dotNH ) * ( a2 - 1.0 ) + 1.0;\n\treturn RECIPROCAL_PI * a2 / pow2( denom );\n}\nvec3 BRDF_Specular_GGX( const in IncidentLight incidentLight, const in vec3 viewDir, const in vec3 normal, const in vec3 specularColor, const in float roughness ) {\n\tfloat alpha = pow2( roughness );\n\tvec3 halfDir = normalize( incidentLight.direction + viewDir );\n\tfloat dotNL = saturate( dot( normal, incidentLight.direction ) );\n\tfloat dotNV = saturate( dot( normal, viewDir ) );\n\tfloat dotNH = saturate( dot( normal, halfDir ) );\n\tfloat dotLH = saturate( dot( incidentLight.direction, halfDir ) );\n\tvec3 F = F_Schlick( specularColor, dotLH );\n\tfloat G = G_GGX_SmithCorrelated( alpha, dotNL, dotNV );\n\tfloat D = D_GGX( alpha, dotNH );\n\treturn F * ( G * D );\n}\nvec2 LTC_Uv( const in vec3 N, const in vec3 V, const in float roughness ) {\n\tconst float LUT_SIZE  = 64.0;\n\tconst float LUT_SCALE = ( LUT_SIZE - 1.0 ) / LUT_SIZE;\n\tconst float LUT_BIAS  = 0.5 / LUT_SIZE;\n\tfloat dotNV = saturate( dot( N, V ) );\n\tvec2 uv = vec2( roughness, sqrt( 1.0 - dotNV ) );\n\tuv = uv * LUT_SCALE + LUT_BIAS;\n\treturn uv;\n}\nfloat LTC_ClippedSphereFormFactor( const in vec3 f ) {\n\tfloat l = length( f );\n\treturn max( ( l * l + f.z ) / ( l + 1.0 ), 0.0 );\n}\nvec3 LTC_EdgeVectorFormFactor( const in vec3 v1, const in vec3 v2 ) {\n\tfloat x = dot( v1, v2 );\n\tfloat y = abs( x );\n\tfloat a = 0.8543985 + ( 0.4965155 + 0.0145206 * y ) * y;\n\tfloat b = 3.4175940 + ( 4.1616724 + y ) * y;\n\tfloat v = a / b;\n\tfloat theta_sintheta = ( x > 0.0 ) ? v : 0.5 * inversesqrt( max( 1.0 - x * x, 1e-7 ) ) - v;\n\treturn cross( v1, v2 ) * theta_sintheta;\n}\nvec3 LTC_Evaluate( const in vec3 N, const in vec3 V, const in vec3 P, const in mat3 mInv, const in vec3 rectCoords[ 4 ] ) {\n\tvec3 v1 = rectCoords[ 1 ] - rectCoords[ 0 ];\n\tvec3 v2 = rectCoords[ 3 ] - rectCoords[ 0 ];\n\tvec3 lightNormal = cross( v1, v2 );\n\tif( dot( lightNormal, P - rectCoords[ 0 ] ) < 0.0 ) return vec3( 0.0 );\n\tvec3 T1, T2;\n\tT1 = normalize( V - N * dot( V, N ) );\n\tT2 = - cross( N, T1 );\n\tmat3 mat = mInv * transposeMat3( mat3( T1, T2, N ) );\n\tvec3 coords[ 4 ];\n\tcoords[ 0 ] = mat * ( rectCoords[ 0 ] - P );\n\tcoords[ 1 ] = mat * ( rectCoords[ 1 ] - P );\n\tcoords[ 2 ] = mat * ( rectCoords[ 2 ] - P );\n\tcoords[ 3 ] = mat * ( rectCoords[ 3 ] - P );\n\tcoords[ 0 ] = normalize( coords[ 0 ] );\n\tcoords[ 1 ] = normalize( coords[ 1 ] );\n\tcoords[ 2 ] = normalize( coords[ 2 ] );\n\tcoords[ 3 ] = normalize( coords[ 3 ] );\n\tvec3 vectorFormFactor = vec3( 0.0 );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 0 ], coords[ 1 ] );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 1 ], coords[ 2 ] );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 2 ], coords[ 3 ] );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 3 ], coords[ 0 ] );\n\tfloat result = LTC_ClippedSphereFormFactor( vectorFormFactor );\n\treturn vec3( result );\n}\nvec3 BRDF_Specular_GGX_Environment( const in vec3 viewDir, const in vec3 normal, const in vec3 specularColor, const in float roughness ) {\n\tfloat dotNV = saturate( dot( normal, viewDir ) );\n\tvec2 brdf = integrateSpecularBRDF( dotNV, roughness );\n\treturn specularColor * brdf.x + brdf.y;\n}\nvoid BRDF_Specular_Multiscattering_Environment( const in GeometricContext geometry, const in vec3 specularColor, const in float roughness, inout vec3 singleScatter, inout vec3 multiScatter ) {\n\tfloat dotNV = saturate( dot( geometry.normal, geometry.viewDir ) );\n\tvec3 F = F_Schlick_RoughnessDependent( specularColor, dotNV, roughness );\n\tvec2 brdf = integrateSpecularBRDF( dotNV, roughness );\n\tvec3 FssEss = F * brdf.x + brdf.y;\n\tfloat Ess = brdf.x + brdf.y;\n\tfloat Ems = 1.0 - Ess;\n\tvec3 Favg = specularColor + ( 1.0 - specularColor ) * 0.047619;\tvec3 Fms = FssEss * Favg / ( 1.0 - Ems * Favg );\n\tsingleScatter += FssEss;\n\tmultiScatter += Fms * Ems;\n}\nfloat G_BlinnPhong_Implicit( ) {\n\treturn 0.25;\n}\nfloat D_BlinnPhong( const in float shininess, const in float dotNH ) {\n\treturn RECIPROCAL_PI * ( shininess * 0.5 + 1.0 ) * pow( dotNH, shininess );\n}\nvec3 BRDF_Specular_BlinnPhong( const in IncidentLight incidentLight, const in GeometricContext geometry, const in vec3 specularColor, const in float shininess ) {\n\tvec3 halfDir = normalize( incidentLight.direction + geometry.viewDir );\n\tfloat dotNH = saturate( dot( geometry.normal, halfDir ) );\n\tfloat dotLH = saturate( dot( incidentLight.direction, halfDir ) );\n\tvec3 F = F_Schlick( specularColor, dotLH );\n\tfloat G = G_BlinnPhong_Implicit( );\n\tfloat D = D_BlinnPhong( shininess, dotNH );\n\treturn F * ( G * D );\n}\nfloat GGXRoughnessToBlinnExponent( const in float ggxRoughness ) {\n\treturn ( 2.0 / pow2( ggxRoughness + 0.0001 ) - 2.0 );\n}\nfloat BlinnExponentToGGXRoughness( const in float blinnExponent ) {\n\treturn sqrt( 2.0 / ( blinnExponent + 2.0 ) );\n}\n#if defined( USE_SHEEN )\nfloat D_Charlie(float roughness, float NoH) {\n\tfloat invAlpha  = 1.0 / roughness;\n\tfloat cos2h = NoH * NoH;\n\tfloat sin2h = max(1.0 - cos2h, 0.0078125);\treturn (2.0 + invAlpha) * pow(sin2h, invAlpha * 0.5) / (2.0 * PI);\n}\nfloat V_Neubelt(float NoV, float NoL) {\n\treturn saturate(1.0 / (4.0 * (NoL + NoV - NoL * NoV)));\n}\nvec3 BRDF_Specular_Sheen( const in float roughness, const in vec3 L, const in GeometricContext geometry, vec3 specularColor ) {\n\tvec3 N = geometry.normal;\n\tvec3 V = geometry.viewDir;\n\tvec3 H = normalize( V + L );\n\tfloat dotNH = saturate( dot( N, H ) );\n\treturn specularColor * D_Charlie( roughness, dotNH ) * V_Neubelt( dot(N, V), dot(N, L) );\n}\n#endif",bumpmap_pars_fragment:"#ifdef USE_BUMPMAP\n\tuniform sampler2D bumpMap;\n\tuniform float bumpScale;\n\tvec2 dHdxy_fwd() {\n\t\tvec2 dSTdx = dFdx( vUv );\n\t\tvec2 dSTdy = dFdy( vUv );\n\t\tfloat Hll = bumpScale * texture2D( bumpMap, vUv ).x;\n\t\tfloat dBx = bumpScale * texture2D( bumpMap, vUv + dSTdx ).x - Hll;\n\t\tfloat dBy = bumpScale * texture2D( bumpMap, vUv + dSTdy ).x - Hll;\n\t\treturn vec2( dBx, dBy );\n\t}\n\tvec3 perturbNormalArb( vec3 surf_pos, vec3 surf_norm, vec2 dHdxy ) {\n\t\tvec3 vSigmaX = vec3( dFdx( surf_pos.x ), dFdx( surf_pos.y ), dFdx( surf_pos.z ) );\n\t\tvec3 vSigmaY = vec3( dFdy( surf_pos.x ), dFdy( surf_pos.y ), dFdy( surf_pos.z ) );\n\t\tvec3 vN = surf_norm;\n\t\tvec3 R1 = cross( vSigmaY, vN );\n\t\tvec3 R2 = cross( vN, vSigmaX );\n\t\tfloat fDet = dot( vSigmaX, R1 );\n\t\tfDet *= ( float( gl_FrontFacing ) * 2.0 - 1.0 );\n\t\tvec3 vGrad = sign( fDet ) * ( dHdxy.x * R1 + dHdxy.y * R2 );\n\t\treturn normalize( abs( fDet ) * surf_norm - vGrad );\n\t}\n#endif",clipping_planes_fragment:"#if NUM_CLIPPING_PLANES > 0\n\tvec4 plane;\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < UNION_CLIPPING_PLANES; i ++ ) {\n\t\tplane = clippingPlanes[ i ];\n\t\tif ( dot( vClipPosition, plane.xyz ) > plane.w ) discard;\n\t}\n\t#pragma unroll_loop_end\n\t#if UNION_CLIPPING_PLANES < NUM_CLIPPING_PLANES\n\t\tbool clipped = true;\n\t\t#pragma unroll_loop_start\n\t\tfor ( int i = UNION_CLIPPING_PLANES; i < NUM_CLIPPING_PLANES; i ++ ) {\n\t\t\tplane = clippingPlanes[ i ];\n\t\t\tclipped = ( dot( vClipPosition, plane.xyz ) > plane.w ) && clipped;\n\t\t}\n\t\t#pragma unroll_loop_end\n\t\tif ( clipped ) discard;\n\t#endif\n#endif",clipping_planes_pars_fragment:"#if NUM_CLIPPING_PLANES > 0\n\tvarying vec3 vClipPosition;\n\tuniform vec4 clippingPlanes[ NUM_CLIPPING_PLANES ];\n#endif",clipping_planes_pars_vertex:"#if NUM_CLIPPING_PLANES > 0\n\tvarying vec3 vClipPosition;\n#endif",clipping_planes_vertex:"#if NUM_CLIPPING_PLANES > 0\n\tvClipPosition = - mvPosition.xyz;\n#endif",color_fragment:"#ifdef USE_COLOR\n\tdiffuseColor.rgb *= vColor;\n#endif",color_pars_fragment:"#ifdef USE_COLOR\n\tvarying vec3 vColor;\n#endif",color_pars_vertex:"#ifdef USE_COLOR\n\tvarying vec3 vColor;\n#endif",color_vertex:"#ifdef USE_COLOR\n\tvColor.xyz = color.xyz;\n#endif",common:"#define PI 3.141592653589793\n#define PI2 6.283185307179586\n#define PI_HALF 1.5707963267948966\n#define RECIPROCAL_PI 0.3183098861837907\n#define RECIPROCAL_PI2 0.15915494309189535\n#define EPSILON 1e-6\n#ifndef saturate\n#define saturate(a) clamp( a, 0.0, 1.0 )\n#endif\n#define whiteComplement(a) ( 1.0 - saturate( a ) )\nfloat pow2( const in float x ) { return x*x; }\nfloat pow3( const in float x ) { return x*x*x; }\nfloat pow4( const in float x ) { float x2 = x*x; return x2*x2; }\nfloat average( const in vec3 color ) { return dot( color, vec3( 0.3333 ) ); }\nhighp float rand( const in vec2 uv ) {\n\tconst highp float a = 12.9898, b = 78.233, c = 43758.5453;\n\thighp float dt = dot( uv.xy, vec2( a,b ) ), sn = mod( dt, PI );\n\treturn fract(sin(sn) * c);\n}\n#ifdef HIGH_PRECISION\n\tfloat precisionSafeLength( vec3 v ) { return length( v ); }\n#else\n\tfloat max3( vec3 v ) { return max( max( v.x, v.y ), v.z ); }\n\tfloat precisionSafeLength( vec3 v ) {\n\t\tfloat maxComponent = max3( abs( v ) );\n\t\treturn length( v / maxComponent ) * maxComponent;\n\t}\n#endif\nstruct IncidentLight {\n\tvec3 color;\n\tvec3 direction;\n\tbool visible;\n};\nstruct ReflectedLight {\n\tvec3 directDiffuse;\n\tvec3 directSpecular;\n\tvec3 indirectDiffuse;\n\tvec3 indirectSpecular;\n};\nstruct GeometricContext {\n\tvec3 position;\n\tvec3 normal;\n\tvec3 viewDir;\n#ifdef CLEARCOAT\n\tvec3 clearcoatNormal;\n#endif\n};\nvec3 transformDirection( in vec3 dir, in mat4 matrix ) {\n\treturn normalize( ( matrix * vec4( dir, 0.0 ) ).xyz );\n}\nvec3 inverseTransformDirection( in vec3 dir, in mat4 matrix ) {\n\treturn normalize( ( vec4( dir, 0.0 ) * matrix ).xyz );\n}\nvec3 projectOnPlane(in vec3 point, in vec3 pointOnPlane, in vec3 planeNormal ) {\n\tfloat distance = dot( planeNormal, point - pointOnPlane );\n\treturn - distance * planeNormal + point;\n}\nfloat sideOfPlane( in vec3 point, in vec3 pointOnPlane, in vec3 planeNormal ) {\n\treturn sign( dot( point - pointOnPlane, planeNormal ) );\n}\nvec3 linePlaneIntersect( in vec3 pointOnLine, in vec3 lineDirection, in vec3 pointOnPlane, in vec3 planeNormal ) {\n\treturn lineDirection * ( dot( planeNormal, pointOnPlane - pointOnLine ) / dot( planeNormal, lineDirection ) ) + pointOnLine;\n}\nmat3 transposeMat3( const in mat3 m ) {\n\tmat3 tmp;\n\ttmp[ 0 ] = vec3( m[ 0 ].x, m[ 1 ].x, m[ 2 ].x );\n\ttmp[ 1 ] = vec3( m[ 0 ].y, m[ 1 ].y, m[ 2 ].y );\n\ttmp[ 2 ] = vec3( m[ 0 ].z, m[ 1 ].z, m[ 2 ].z );\n\treturn tmp;\n}\nfloat linearToRelativeLuminance( const in vec3 color ) {\n\tvec3 weights = vec3( 0.2126, 0.7152, 0.0722 );\n\treturn dot( weights, color.rgb );\n}\nbool isPerspectiveMatrix( mat4 m ) {\n\treturn m[ 2 ][ 3 ] == - 1.0;\n}\nvec2 equirectUv( in vec3 dir ) {\n\tfloat u = atan( dir.z, dir.x ) * RECIPROCAL_PI2 + 0.5;\n\tfloat v = asin( clamp( dir.y, - 1.0, 1.0 ) ) * RECIPROCAL_PI + 0.5;\n\treturn vec2( u, v );\n}",cube_uv_reflection_fragment:"#ifdef ENVMAP_TYPE_CUBE_UV\n#define cubeUV_maxMipLevel 8.0\n#define cubeUV_minMipLevel 4.0\n#define cubeUV_maxTileSize 256.0\n#define cubeUV_minTileSize 16.0\nfloat getFace(vec3 direction) {\n    vec3 absDirection = abs(direction);\n    float face = -1.0;\n    if (absDirection.x > absDirection.z) {\n      if (absDirection.x > absDirection.y)\n        face = direction.x > 0.0 ? 0.0 : 3.0;\n      else\n        face = direction.y > 0.0 ? 1.0 : 4.0;\n    } else {\n      if (absDirection.z > absDirection.y)\n        face = direction.z > 0.0 ? 2.0 : 5.0;\n      else\n        face = direction.y > 0.0 ? 1.0 : 4.0;\n    }\n    return face;\n}\nvec2 getUV(vec3 direction, float face) {\n    vec2 uv;\n    if (face == 0.0) {\n      uv = vec2(direction.z, direction.y) / abs(direction.x);    } else if (face == 1.0) {\n      uv = vec2(-direction.x, -direction.z) / abs(direction.y);    } else if (face == 2.0) {\n      uv = vec2(-direction.x, direction.y) / abs(direction.z);    } else if (face == 3.0) {\n      uv = vec2(-direction.z, direction.y) / abs(direction.x);    } else if (face == 4.0) {\n      uv = vec2(-direction.x, direction.z) / abs(direction.y);    } else {\n      uv = vec2(direction.x, direction.y) / abs(direction.z);    }\n    return 0.5 * (uv + 1.0);\n}\nvec3 bilinearCubeUV(sampler2D envMap, vec3 direction, float mipInt) {\n  float face = getFace(direction);\n  float filterInt = max(cubeUV_minMipLevel - mipInt, 0.0);\n  mipInt = max(mipInt, cubeUV_minMipLevel);\n  float faceSize = exp2(mipInt);\n  float texelSize = 1.0 / (3.0 * cubeUV_maxTileSize);\n  vec2 uv = getUV(direction, face) * (faceSize - 1.0);\n  vec2 f = fract(uv);\n  uv += 0.5 - f;\n  if (face > 2.0) {\n    uv.y += faceSize;\n    face -= 3.0;\n  }\n  uv.x += face * faceSize;\n  if(mipInt < cubeUV_maxMipLevel){\n    uv.y += 2.0 * cubeUV_maxTileSize;\n  }\n  uv.y += filterInt * 2.0 * cubeUV_minTileSize;\n  uv.x += 3.0 * max(0.0, cubeUV_maxTileSize - 2.0 * faceSize);\n  uv *= texelSize;\n  vec3 tl = envMapTexelToLinear(texture2D(envMap, uv)).rgb;\n  uv.x += texelSize;\n  vec3 tr = envMapTexelToLinear(texture2D(envMap, uv)).rgb;\n  uv.y += texelSize;\n  vec3 br = envMapTexelToLinear(texture2D(envMap, uv)).rgb;\n  uv.x -= texelSize;\n  vec3 bl = envMapTexelToLinear(texture2D(envMap, uv)).rgb;\n  vec3 tm = mix(tl, tr, f.x);\n  vec3 bm = mix(bl, br, f.x);\n  return mix(tm, bm, f.y);\n}\n#define r0 1.0\n#define v0 0.339\n#define m0 -2.0\n#define r1 0.8\n#define v1 0.276\n#define m1 -1.0\n#define r4 0.4\n#define v4 0.046\n#define m4 2.0\n#define r5 0.305\n#define v5 0.016\n#define m5 3.0\n#define r6 0.21\n#define v6 0.0038\n#define m6 4.0\nfloat roughnessToMip(float roughness) {\n  float mip = 0.0;\n  if (roughness >= r1) {\n    mip = (r0 - roughness) * (m1 - m0) / (r0 - r1) + m0;\n  } else if (roughness >= r4) {\n    mip = (r1 - roughness) * (m4 - m1) / (r1 - r4) + m1;\n  } else if (roughness >= r5) {\n    mip = (r4 - roughness) * (m5 - m4) / (r4 - r5) + m4;\n  } else if (roughness >= r6) {\n    mip = (r5 - roughness) * (m6 - m5) / (r5 - r6) + m5;\n  } else {\n    mip = -2.0 * log2(1.16 * roughness);  }\n  return mip;\n}\nvec4 textureCubeUV(sampler2D envMap, vec3 sampleDir, float roughness) {\n  float mip = clamp(roughnessToMip(roughness), m0, cubeUV_maxMipLevel);\n  float mipF = fract(mip);\n  float mipInt = floor(mip);\n  vec3 color0 = bilinearCubeUV(envMap, sampleDir, mipInt);\n  if (mipF == 0.0) {\n    return vec4(color0, 1.0);\n  } else {\n    vec3 color1 = bilinearCubeUV(envMap, sampleDir, mipInt + 1.0);\n    return vec4(mix(color0, color1, mipF), 1.0);\n  }\n}\n#endif",defaultnormal_vertex:"vec3 transformedNormal = objectNormal;\n#ifdef USE_INSTANCING\n\tmat3 m = mat3( instanceMatrix );\n\ttransformedNormal /= vec3( dot( m[ 0 ], m[ 0 ] ), dot( m[ 1 ], m[ 1 ] ), dot( m[ 2 ], m[ 2 ] ) );\n\ttransformedNormal = m * transformedNormal;\n#endif\ntransformedNormal = normalMatrix * transformedNormal;\n#ifdef FLIP_SIDED\n\ttransformedNormal = - transformedNormal;\n#endif\n#ifdef USE_TANGENT\n\tvec3 transformedTangent = ( modelViewMatrix * vec4( objectTangent, 0.0 ) ).xyz;\n\t#ifdef FLIP_SIDED\n\t\ttransformedTangent = - transformedTangent;\n\t#endif\n#endif",displacementmap_pars_vertex:"#ifdef USE_DISPLACEMENTMAP\n\tuniform sampler2D displacementMap;\n\tuniform float displacementScale;\n\tuniform float displacementBias;\n#endif",displacementmap_vertex:"#ifdef USE_DISPLACEMENTMAP\n\ttransformed += normalize( objectNormal ) * ( texture2D( displacementMap, vUv ).x * displacementScale + displacementBias );\n#endif",emissivemap_fragment:"#ifdef USE_EMISSIVEMAP\n\tvec4 emissiveColor = texture2D( emissiveMap, vUv );\n\temissiveColor.rgb = emissiveMapTexelToLinear( emissiveColor ).rgb;\n\ttotalEmissiveRadiance *= emissiveColor.rgb;\n#endif",emissivemap_pars_fragment:"#ifdef USE_EMISSIVEMAP\n\tuniform sampler2D emissiveMap;\n#endif",encodings_fragment:"gl_FragColor = linearToOutputTexel( gl_FragColor );",encodings_pars_fragment:"\nvec4 LinearToLinear( in vec4 value ) {\n\treturn value;\n}\nvec4 GammaToLinear( in vec4 value, in float gammaFactor ) {\n\treturn vec4( pow( value.rgb, vec3( gammaFactor ) ), value.a );\n}\nvec4 LinearToGamma( in vec4 value, in float gammaFactor ) {\n\treturn vec4( pow( value.rgb, vec3( 1.0 / gammaFactor ) ), value.a );\n}\nvec4 sRGBToLinear( in vec4 value ) {\n\treturn vec4( mix( pow( value.rgb * 0.9478672986 + vec3( 0.0521327014 ), vec3( 2.4 ) ), value.rgb * 0.0773993808, vec3( lessThanEqual( value.rgb, vec3( 0.04045 ) ) ) ), value.a );\n}\nvec4 LinearTosRGB( in vec4 value ) {\n\treturn vec4( mix( pow( value.rgb, vec3( 0.41666 ) ) * 1.055 - vec3( 0.055 ), value.rgb * 12.92, vec3( lessThanEqual( value.rgb, vec3( 0.0031308 ) ) ) ), value.a );\n}\nvec4 RGBEToLinear( in vec4 value ) {\n\treturn vec4( value.rgb * exp2( value.a * 255.0 - 128.0 ), 1.0 );\n}\nvec4 LinearToRGBE( in vec4 value ) {\n\tfloat maxComponent = max( max( value.r, value.g ), value.b );\n\tfloat fExp = clamp( ceil( log2( maxComponent ) ), -128.0, 127.0 );\n\treturn vec4( value.rgb / exp2( fExp ), ( fExp + 128.0 ) / 255.0 );\n}\nvec4 RGBMToLinear( in vec4 value, in float maxRange ) {\n\treturn vec4( value.rgb * value.a * maxRange, 1.0 );\n}\nvec4 LinearToRGBM( in vec4 value, in float maxRange ) {\n\tfloat maxRGB = max( value.r, max( value.g, value.b ) );\n\tfloat M = clamp( maxRGB / maxRange, 0.0, 1.0 );\n\tM = ceil( M * 255.0 ) / 255.0;\n\treturn vec4( value.rgb / ( M * maxRange ), M );\n}\nvec4 RGBDToLinear( in vec4 value, in float maxRange ) {\n\treturn vec4( value.rgb * ( ( maxRange / 255.0 ) / value.a ), 1.0 );\n}\nvec4 LinearToRGBD( in vec4 value, in float maxRange ) {\n\tfloat maxRGB = max( value.r, max( value.g, value.b ) );\n\tfloat D = max( maxRange / maxRGB, 1.0 );\n\tD = clamp( floor( D ) / 255.0, 0.0, 1.0 );\n\treturn vec4( value.rgb * ( D * ( 255.0 / maxRange ) ), D );\n}\nconst mat3 cLogLuvM = mat3( 0.2209, 0.3390, 0.4184, 0.1138, 0.6780, 0.7319, 0.0102, 0.1130, 0.2969 );\nvec4 LinearToLogLuv( in vec4 value )  {\n\tvec3 Xp_Y_XYZp = cLogLuvM * value.rgb;\n\tXp_Y_XYZp = max( Xp_Y_XYZp, vec3( 1e-6, 1e-6, 1e-6 ) );\n\tvec4 vResult;\n\tvResult.xy = Xp_Y_XYZp.xy / Xp_Y_XYZp.z;\n\tfloat Le = 2.0 * log2(Xp_Y_XYZp.y) + 127.0;\n\tvResult.w = fract( Le );\n\tvResult.z = ( Le - ( floor( vResult.w * 255.0 ) ) / 255.0 ) / 255.0;\n\treturn vResult;\n}\nconst mat3 cLogLuvInverseM = mat3( 6.0014, -2.7008, -1.7996, -1.3320, 3.1029, -5.7721, 0.3008, -1.0882, 5.6268 );\nvec4 LogLuvToLinear( in vec4 value ) {\n\tfloat Le = value.z * 255.0 + value.w;\n\tvec3 Xp_Y_XYZp;\n\tXp_Y_XYZp.y = exp2( ( Le - 127.0 ) / 2.0 );\n\tXp_Y_XYZp.z = Xp_Y_XYZp.y / value.y;\n\tXp_Y_XYZp.x = value.x * Xp_Y_XYZp.z;\n\tvec3 vRGB = cLogLuvInverseM * Xp_Y_XYZp.rgb;\n\treturn vec4( max( vRGB, 0.0 ), 1.0 );\n}",envmap_fragment:"#ifdef USE_ENVMAP\n\t#ifdef ENV_WORLDPOS\n\t\tvec3 cameraToFrag;\n\t\t\n\t\tif ( isOrthographic ) {\n\t\t\tcameraToFrag = normalize( vec3( - viewMatrix[ 0 ][ 2 ], - viewMatrix[ 1 ][ 2 ], - viewMatrix[ 2 ][ 2 ] ) );\n\t\t}  else {\n\t\t\tcameraToFrag = normalize( vWorldPosition - cameraPosition );\n\t\t}\n\t\tvec3 worldNormal = inverseTransformDirection( normal, viewMatrix );\n\t\t#ifdef ENVMAP_MODE_REFLECTION\n\t\t\tvec3 reflectVec = reflect( cameraToFrag, worldNormal );\n\t\t#else\n\t\t\tvec3 reflectVec = refract( cameraToFrag, worldNormal, refractionRatio );\n\t\t#endif\n\t#else\n\t\tvec3 reflectVec = vReflect;\n\t#endif\n\t#ifdef ENVMAP_TYPE_CUBE\n\t\tvec4 envColor = textureCube( envMap, vec3( flipEnvMap * reflectVec.x, reflectVec.yz ) );\n\t#elif defined( ENVMAP_TYPE_CUBE_UV )\n\t\tvec4 envColor = textureCubeUV( envMap, reflectVec, 0.0 );\n\t#elif defined( ENVMAP_TYPE_EQUIREC )\n\t\treflectVec = normalize( reflectVec );\n\t\tvec2 sampleUV = equirectUv( reflectVec );\n\t\tvec4 envColor = texture2D( envMap, sampleUV );\n\t#else\n\t\tvec4 envColor = vec4( 0.0 );\n\t#endif\n\t#ifndef ENVMAP_TYPE_CUBE_UV\n\t\tenvColor = envMapTexelToLinear( envColor );\n\t#endif\n\t#ifdef ENVMAP_BLENDING_MULTIPLY\n\t\toutgoingLight = mix( outgoingLight, outgoingLight * envColor.xyz, specularStrength * reflectivity );\n\t#elif defined( ENVMAP_BLENDING_MIX )\n\t\toutgoingLight = mix( outgoingLight, envColor.xyz, specularStrength * reflectivity );\n\t#elif defined( ENVMAP_BLENDING_ADD )\n\t\toutgoingLight += envColor.xyz * specularStrength * reflectivity;\n\t#endif\n#endif",envmap_common_pars_fragment:"#ifdef USE_ENVMAP\n\tuniform float envMapIntensity;\n\tuniform float flipEnvMap;\n\tuniform int maxMipLevel;\n\t#ifdef ENVMAP_TYPE_CUBE\n\t\tuniform samplerCube envMap;\n\t#else\n\t\tuniform sampler2D envMap;\n\t#endif\n\t\n#endif",envmap_pars_fragment:"#ifdef USE_ENVMAP\n\tuniform float reflectivity;\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG )\n\t\t#define ENV_WORLDPOS\n\t#endif\n\t#ifdef ENV_WORLDPOS\n\t\tvarying vec3 vWorldPosition;\n\t\tuniform float refractionRatio;\n\t#else\n\t\tvarying vec3 vReflect;\n\t#endif\n#endif",envmap_pars_vertex:"#ifdef USE_ENVMAP\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) ||defined( PHONG )\n\t\t#define ENV_WORLDPOS\n\t#endif\n\t#ifdef ENV_WORLDPOS\n\t\t\n\t\tvarying vec3 vWorldPosition;\n\t#else\n\t\tvarying vec3 vReflect;\n\t\tuniform float refractionRatio;\n\t#endif\n#endif",envmap_physical_pars_fragment:"#if defined( USE_ENVMAP )\n\t#ifdef ENVMAP_MODE_REFRACTION\n\t\tuniform float refractionRatio;\n\t#endif\n\tvec3 getLightProbeIndirectIrradiance( const in GeometricContext geometry, const in int maxMIPLevel ) {\n\t\tvec3 worldNormal = inverseTransformDirection( geometry.normal, viewMatrix );\n\t\t#ifdef ENVMAP_TYPE_CUBE\n\t\t\tvec3 queryVec = vec3( flipEnvMap * worldNormal.x, worldNormal.yz );\n\t\t\t#ifdef TEXTURE_LOD_EXT\n\t\t\t\tvec4 envMapColor = textureCubeLodEXT( envMap, queryVec, float( maxMIPLevel ) );\n\t\t\t#else\n\t\t\t\tvec4 envMapColor = textureCube( envMap, queryVec, float( maxMIPLevel ) );\n\t\t\t#endif\n\t\t\tenvMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n\t\t#elif defined( ENVMAP_TYPE_CUBE_UV )\n\t\t\tvec4 envMapColor = textureCubeUV( envMap, worldNormal, 1.0 );\n\t\t#else\n\t\t\tvec4 envMapColor = vec4( 0.0 );\n\t\t#endif\n\t\treturn PI * envMapColor.rgb * envMapIntensity;\n\t}\n\tfloat getSpecularMIPLevel( const in float roughness, const in int maxMIPLevel ) {\n\t\tfloat maxMIPLevelScalar = float( maxMIPLevel );\n\t\tfloat sigma = PI * roughness * roughness / ( 1.0 + roughness );\n\t\tfloat desiredMIPLevel = maxMIPLevelScalar + log2( sigma );\n\t\treturn clamp( desiredMIPLevel, 0.0, maxMIPLevelScalar );\n\t}\n\tvec3 getLightProbeIndirectRadiance( const in vec3 viewDir, const in vec3 normal, const in float roughness, const in int maxMIPLevel ) {\n\t\t#ifdef ENVMAP_MODE_REFLECTION\n\t\t  vec3 reflectVec = reflect( -viewDir, normal );\n\t\t  reflectVec = normalize( mix( reflectVec, normal, roughness * roughness) );\n\t\t#else\n\t\t  vec3 reflectVec = refract( -viewDir, normal, refractionRatio );\n\t\t#endif\n\t\treflectVec = inverseTransformDirection( reflectVec, viewMatrix );\n\t\tfloat specularMIPLevel = getSpecularMIPLevel( roughness, maxMIPLevel );\n\t\t#ifdef ENVMAP_TYPE_CUBE\n\t\t\tvec3 queryReflectVec = vec3( flipEnvMap * reflectVec.x, reflectVec.yz );\n\t\t\t#ifdef TEXTURE_LOD_EXT\n\t\t\t\tvec4 envMapColor = textureCubeLodEXT( envMap, queryReflectVec, specularMIPLevel );\n\t\t\t#else\n\t\t\t\tvec4 envMapColor = textureCube( envMap, queryReflectVec, specularMIPLevel );\n\t\t\t#endif\n\t\t\tenvMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n\t\t#elif defined( ENVMAP_TYPE_CUBE_UV )\n\t\t\tvec4 envMapColor = textureCubeUV( envMap, reflectVec, roughness );\n\t\t#elif defined( ENVMAP_TYPE_EQUIREC )\n\t\t\tvec2 sampleUV = equirectUv( reflectVec );\n\t\t\t#ifdef TEXTURE_LOD_EXT\n\t\t\t\tvec4 envMapColor = texture2DLodEXT( envMap, sampleUV, specularMIPLevel );\n\t\t\t#else\n\t\t\t\tvec4 envMapColor = texture2D( envMap, sampleUV, specularMIPLevel );\n\t\t\t#endif\n\t\t\tenvMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n\t\t#endif\n\t\treturn envMapColor.rgb * envMapIntensity;\n\t}\n#endif",envmap_vertex:"#ifdef USE_ENVMAP\n\t#ifdef ENV_WORLDPOS\n\t\tvWorldPosition = worldPosition.xyz;\n\t#else\n\t\tvec3 cameraToVertex;\n\t\tif ( isOrthographic ) {\n\t\t\tcameraToVertex = normalize( vec3( - viewMatrix[ 0 ][ 2 ], - viewMatrix[ 1 ][ 2 ], - viewMatrix[ 2 ][ 2 ] ) );\n\t\t} else {\n\t\t\tcameraToVertex = normalize( worldPosition.xyz - cameraPosition );\n\t\t}\n\t\tvec3 worldNormal = inverseTransformDirection( transformedNormal, viewMatrix );\n\t\t#ifdef ENVMAP_MODE_REFLECTION\n\t\t\tvReflect = reflect( cameraToVertex, worldNormal );\n\t\t#else\n\t\t\tvReflect = refract( cameraToVertex, worldNormal, refractionRatio );\n\t\t#endif\n\t#endif\n#endif",fog_vertex:"#ifdef USE_FOG\n\tfogDepth = - mvPosition.z;\n#endif",fog_pars_vertex:"#ifdef USE_FOG\n\tvarying float fogDepth;\n#endif",fog_fragment:"#ifdef USE_FOG\n\t#ifdef FOG_EXP2\n\t\tfloat fogFactor = 1.0 - exp( - fogDensity * fogDensity * fogDepth * fogDepth );\n\t#else\n\t\tfloat fogFactor = smoothstep( fogNear, fogFar, fogDepth );\n\t#endif\n\tgl_FragColor.rgb = mix( gl_FragColor.rgb, fogColor, fogFactor );\n#endif",fog_pars_fragment:"#ifdef USE_FOG\n\tuniform vec3 fogColor;\n\tvarying float fogDepth;\n\t#ifdef FOG_EXP2\n\t\tuniform float fogDensity;\n\t#else\n\t\tuniform float fogNear;\n\t\tuniform float fogFar;\n\t#endif\n#endif",gradientmap_pars_fragment:"#ifdef USE_GRADIENTMAP\n\tuniform sampler2D gradientMap;\n#endif\nvec3 getGradientIrradiance( vec3 normal, vec3 lightDirection ) {\n\tfloat dotNL = dot( normal, lightDirection );\n\tvec2 coord = vec2( dotNL * 0.5 + 0.5, 0.0 );\n\t#ifdef USE_GRADIENTMAP\n\t\treturn texture2D( gradientMap, coord ).rgb;\n\t#else\n\t\treturn ( coord.x < 0.7 ) ? vec3( 0.7 ) : vec3( 1.0 );\n\t#endif\n}",lightmap_fragment:"#ifdef USE_LIGHTMAP\n\tvec4 lightMapTexel= texture2D( lightMap, vUv2 );\n\treflectedLight.indirectDiffuse += PI * lightMapTexelToLinear( lightMapTexel ).rgb * lightMapIntensity;\n#endif",lightmap_pars_fragment:"#ifdef USE_LIGHTMAP\n\tuniform sampler2D lightMap;\n\tuniform float lightMapIntensity;\n#endif",lights_lambert_vertex:"vec3 diffuse = vec3( 1.0 );\nGeometricContext geometry;\ngeometry.position = mvPosition.xyz;\ngeometry.normal = normalize( transformedNormal );\ngeometry.viewDir = ( isOrthographic ) ? vec3( 0, 0, 1 ) : normalize( -mvPosition.xyz );\nGeometricContext backGeometry;\nbackGeometry.position = geometry.position;\nbackGeometry.normal = -geometry.normal;\nbackGeometry.viewDir = geometry.viewDir;\nvLightFront = vec3( 0.0 );\nvIndirectFront = vec3( 0.0 );\n#ifdef DOUBLE_SIDED\n\tvLightBack = vec3( 0.0 );\n\tvIndirectBack = vec3( 0.0 );\n#endif\nIncidentLight directLight;\nfloat dotNL;\nvec3 directLightColor_Diffuse;\nvIndirectFront += getAmbientLightIrradiance( ambientLightColor );\nvIndirectFront += getLightProbeIrradiance( lightProbe, geometry );\n#ifdef DOUBLE_SIDED\n\tvIndirectBack += getAmbientLightIrradiance( ambientLightColor );\n\tvIndirectBack += getLightProbeIrradiance( lightProbe, backGeometry );\n#endif\n#if NUM_POINT_LIGHTS > 0\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n\t\tgetPointDirectLightIrradiance( pointLights[ i ], geometry, directLight );\n\t\tdotNL = dot( geometry.normal, directLight.direction );\n\t\tdirectLightColor_Diffuse = PI * directLight.color;\n\t\tvLightFront += saturate( dotNL ) * directLightColor_Diffuse;\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvLightBack += saturate( -dotNL ) * directLightColor_Diffuse;\n\t\t#endif\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if NUM_SPOT_LIGHTS > 0\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n\t\tgetSpotDirectLightIrradiance( spotLights[ i ], geometry, directLight );\n\t\tdotNL = dot( geometry.normal, directLight.direction );\n\t\tdirectLightColor_Diffuse = PI * directLight.color;\n\t\tvLightFront += saturate( dotNL ) * directLightColor_Diffuse;\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvLightBack += saturate( -dotNL ) * directLightColor_Diffuse;\n\t\t#endif\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if NUM_DIR_LIGHTS > 0\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n\t\tgetDirectionalDirectLightIrradiance( directionalLights[ i ], geometry, directLight );\n\t\tdotNL = dot( geometry.normal, directLight.direction );\n\t\tdirectLightColor_Diffuse = PI * directLight.color;\n\t\tvLightFront += saturate( dotNL ) * directLightColor_Diffuse;\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvLightBack += saturate( -dotNL ) * directLightColor_Diffuse;\n\t\t#endif\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if NUM_HEMI_LIGHTS > 0\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_HEMI_LIGHTS; i ++ ) {\n\t\tvIndirectFront += getHemisphereLightIrradiance( hemisphereLights[ i ], geometry );\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvIndirectBack += getHemisphereLightIrradiance( hemisphereLights[ i ], backGeometry );\n\t\t#endif\n\t}\n\t#pragma unroll_loop_end\n#endif",lights_pars_begin:"uniform bool receiveShadow;\nuniform vec3 ambientLightColor;\nuniform vec3 lightProbe[ 9 ];\nvec3 shGetIrradianceAt( in vec3 normal, in vec3 shCoefficients[ 9 ] ) {\n\tfloat x = normal.x, y = normal.y, z = normal.z;\n\tvec3 result = shCoefficients[ 0 ] * 0.886227;\n\tresult += shCoefficients[ 1 ] * 2.0 * 0.511664 * y;\n\tresult += shCoefficients[ 2 ] * 2.0 * 0.511664 * z;\n\tresult += shCoefficients[ 3 ] * 2.0 * 0.511664 * x;\n\tresult += shCoefficients[ 4 ] * 2.0 * 0.429043 * x * y;\n\tresult += shCoefficients[ 5 ] * 2.0 * 0.429043 * y * z;\n\tresult += shCoefficients[ 6 ] * ( 0.743125 * z * z - 0.247708 );\n\tresult += shCoefficients[ 7 ] * 2.0 * 0.429043 * x * z;\n\tresult += shCoefficients[ 8 ] * 0.429043 * ( x * x - y * y );\n\treturn result;\n}\nvec3 getLightProbeIrradiance( const in vec3 lightProbe[ 9 ], const in GeometricContext geometry ) {\n\tvec3 worldNormal = inverseTransformDirection( geometry.normal, viewMatrix );\n\tvec3 irradiance = shGetIrradianceAt( worldNormal, lightProbe );\n\treturn irradiance;\n}\nvec3 getAmbientLightIrradiance( const in vec3 ambientLightColor ) {\n\tvec3 irradiance = ambientLightColor;\n\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\tirradiance *= PI;\n\t#endif\n\treturn irradiance;\n}\n#if NUM_DIR_LIGHTS > 0\n\tstruct DirectionalLight {\n\t\tvec3 direction;\n\t\tvec3 color;\n\t};\n\tuniform DirectionalLight directionalLights[ NUM_DIR_LIGHTS ];\n\tvoid getDirectionalDirectLightIrradiance( const in DirectionalLight directionalLight, const in GeometricContext geometry, out IncidentLight directLight ) {\n\t\tdirectLight.color = directionalLight.color;\n\t\tdirectLight.direction = directionalLight.direction;\n\t\tdirectLight.visible = true;\n\t}\n#endif\n#if NUM_POINT_LIGHTS > 0\n\tstruct PointLight {\n\t\tvec3 position;\n\t\tvec3 color;\n\t\tfloat distance;\n\t\tfloat decay;\n\t};\n\tuniform PointLight pointLights[ NUM_POINT_LIGHTS ];\n\tvoid getPointDirectLightIrradiance( const in PointLight pointLight, const in GeometricContext geometry, out IncidentLight directLight ) {\n\t\tvec3 lVector = pointLight.position - geometry.position;\n\t\tdirectLight.direction = normalize( lVector );\n\t\tfloat lightDistance = length( lVector );\n\t\tdirectLight.color = pointLight.color;\n\t\tdirectLight.color *= punctualLightIntensityToIrradianceFactor( lightDistance, pointLight.distance, pointLight.decay );\n\t\tdirectLight.visible = ( directLight.color != vec3( 0.0 ) );\n\t}\n#endif\n#if NUM_SPOT_LIGHTS > 0\n\tstruct SpotLight {\n\t\tvec3 position;\n\t\tvec3 direction;\n\t\tvec3 color;\n\t\tfloat distance;\n\t\tfloat decay;\n\t\tfloat coneCos;\n\t\tfloat penumbraCos;\n\t};\n\tuniform SpotLight spotLights[ NUM_SPOT_LIGHTS ];\n\tvoid getSpotDirectLightIrradiance( const in SpotLight spotLight, const in GeometricContext geometry, out IncidentLight directLight  ) {\n\t\tvec3 lVector = spotLight.position - geometry.position;\n\t\tdirectLight.direction = normalize( lVector );\n\t\tfloat lightDistance = length( lVector );\n\t\tfloat angleCos = dot( directLight.direction, spotLight.direction );\n\t\tif ( angleCos > spotLight.coneCos ) {\n\t\t\tfloat spotEffect = smoothstep( spotLight.coneCos, spotLight.penumbraCos, angleCos );\n\t\t\tdirectLight.color = spotLight.color;\n\t\t\tdirectLight.color *= spotEffect * punctualLightIntensityToIrradianceFactor( lightDistance, spotLight.distance, spotLight.decay );\n\t\t\tdirectLight.visible = true;\n\t\t} else {\n\t\t\tdirectLight.color = vec3( 0.0 );\n\t\t\tdirectLight.visible = false;\n\t\t}\n\t}\n#endif\n#if NUM_RECT_AREA_LIGHTS > 0\n\tstruct RectAreaLight {\n\t\tvec3 color;\n\t\tvec3 position;\n\t\tvec3 halfWidth;\n\t\tvec3 halfHeight;\n\t};\n\tuniform sampler2D ltc_1;\tuniform sampler2D ltc_2;\n\tuniform RectAreaLight rectAreaLights[ NUM_RECT_AREA_LIGHTS ];\n#endif\n#if NUM_HEMI_LIGHTS > 0\n\tstruct HemisphereLight {\n\t\tvec3 direction;\n\t\tvec3 skyColor;\n\t\tvec3 groundColor;\n\t};\n\tuniform HemisphereLight hemisphereLights[ NUM_HEMI_LIGHTS ];\n\tvec3 getHemisphereLightIrradiance( const in HemisphereLight hemiLight, const in GeometricContext geometry ) {\n\t\tfloat dotNL = dot( geometry.normal, hemiLight.direction );\n\t\tfloat hemiDiffuseWeight = 0.5 * dotNL + 0.5;\n\t\tvec3 irradiance = mix( hemiLight.groundColor, hemiLight.skyColor, hemiDiffuseWeight );\n\t\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\t\tirradiance *= PI;\n\t\t#endif\n\t\treturn irradiance;\n\t}\n#endif",lights_toon_fragment:"ToonMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb;",lights_toon_pars_fragment:"varying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\nstruct ToonMaterial {\n\tvec3 diffuseColor;\n};\nvoid RE_Direct_Toon( const in IncidentLight directLight, const in GeometricContext geometry, const in ToonMaterial material, inout ReflectedLight reflectedLight ) {\n\tvec3 irradiance = getGradientIrradiance( geometry.normal, directLight.direction ) * directLight.color;\n\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\tirradiance *= PI;\n\t#endif\n\treflectedLight.directDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n}\nvoid RE_IndirectDiffuse_Toon( const in vec3 irradiance, const in GeometricContext geometry, const in ToonMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n}\n#define RE_Direct\t\t\t\tRE_Direct_Toon\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_Toon\n#define Material_LightProbeLOD( material )\t(0)",lights_phong_fragment:"BlinnPhongMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb;\nmaterial.specularColor = specular;\nmaterial.specularShininess = shininess;\nmaterial.specularStrength = specularStrength;",lights_phong_pars_fragment:"varying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\nstruct BlinnPhongMaterial {\n\tvec3 diffuseColor;\n\tvec3 specularColor;\n\tfloat specularShininess;\n\tfloat specularStrength;\n};\nvoid RE_Direct_BlinnPhong( const in IncidentLight directLight, const in GeometricContext geometry, const in BlinnPhongMaterial material, inout ReflectedLight reflectedLight ) {\n\tfloat dotNL = saturate( dot( geometry.normal, directLight.direction ) );\n\tvec3 irradiance = dotNL * directLight.color;\n\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\tirradiance *= PI;\n\t#endif\n\treflectedLight.directDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n\treflectedLight.directSpecular += irradiance * BRDF_Specular_BlinnPhong( directLight, geometry, material.specularColor, material.specularShininess ) * material.specularStrength;\n}\nvoid RE_IndirectDiffuse_BlinnPhong( const in vec3 irradiance, const in GeometricContext geometry, const in BlinnPhongMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n}\n#define RE_Direct\t\t\t\tRE_Direct_BlinnPhong\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_BlinnPhong\n#define Material_LightProbeLOD( material )\t(0)",lights_physical_fragment:"PhysicalMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb * ( 1.0 - metalnessFactor );\nvec3 dxy = max( abs( dFdx( geometryNormal ) ), abs( dFdy( geometryNormal ) ) );\nfloat geometryRoughness = max( max( dxy.x, dxy.y ), dxy.z );\nmaterial.specularRoughness = max( roughnessFactor, 0.0525 );material.specularRoughness += geometryRoughness;\nmaterial.specularRoughness = min( material.specularRoughness, 1.0 );\n#ifdef REFLECTIVITY\n\tmaterial.specularColor = mix( vec3( MAXIMUM_SPECULAR_COEFFICIENT * pow2( reflectivity ) ), diffuseColor.rgb, metalnessFactor );\n#else\n\tmaterial.specularColor = mix( vec3( DEFAULT_SPECULAR_COEFFICIENT ), diffuseColor.rgb, metalnessFactor );\n#endif\n#ifdef CLEARCOAT\n\tmaterial.clearcoat = clearcoat;\n\tmaterial.clearcoatRoughness = clearcoatRoughness;\n\t#ifdef USE_CLEARCOATMAP\n\t\tmaterial.clearcoat *= texture2D( clearcoatMap, vUv ).x;\n\t#endif\n\t#ifdef USE_CLEARCOAT_ROUGHNESSMAP\n\t\tmaterial.clearcoatRoughness *= texture2D( clearcoatRoughnessMap, vUv ).y;\n\t#endif\n\tmaterial.clearcoat = saturate( material.clearcoat );\tmaterial.clearcoatRoughness = max( material.clearcoatRoughness, 0.0525 );\n\tmaterial.clearcoatRoughness += geometryRoughness;\n\tmaterial.clearcoatRoughness = min( material.clearcoatRoughness, 1.0 );\n#endif\n#ifdef USE_SHEEN\n\tmaterial.sheenColor = sheen;\n#endif",lights_physical_pars_fragment:"struct PhysicalMaterial {\n\tvec3 diffuseColor;\n\tfloat specularRoughness;\n\tvec3 specularColor;\n#ifdef CLEARCOAT\n\tfloat clearcoat;\n\tfloat clearcoatRoughness;\n#endif\n#ifdef USE_SHEEN\n\tvec3 sheenColor;\n#endif\n};\n#define MAXIMUM_SPECULAR_COEFFICIENT 0.16\n#define DEFAULT_SPECULAR_COEFFICIENT 0.04\nfloat clearcoatDHRApprox( const in float roughness, const in float dotNL ) {\n\treturn DEFAULT_SPECULAR_COEFFICIENT + ( 1.0 - DEFAULT_SPECULAR_COEFFICIENT ) * ( pow( 1.0 - dotNL, 5.0 ) * pow( 1.0 - roughness, 2.0 ) );\n}\n#if NUM_RECT_AREA_LIGHTS > 0\n\tvoid RE_Direct_RectArea_Physical( const in RectAreaLight rectAreaLight, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\t\tvec3 normal = geometry.normal;\n\t\tvec3 viewDir = geometry.viewDir;\n\t\tvec3 position = geometry.position;\n\t\tvec3 lightPos = rectAreaLight.position;\n\t\tvec3 halfWidth = rectAreaLight.halfWidth;\n\t\tvec3 halfHeight = rectAreaLight.halfHeight;\n\t\tvec3 lightColor = rectAreaLight.color;\n\t\tfloat roughness = material.specularRoughness;\n\t\tvec3 rectCoords[ 4 ];\n\t\trectCoords[ 0 ] = lightPos + halfWidth - halfHeight;\t\trectCoords[ 1 ] = lightPos - halfWidth - halfHeight;\n\t\trectCoords[ 2 ] = lightPos - halfWidth + halfHeight;\n\t\trectCoords[ 3 ] = lightPos + halfWidth + halfHeight;\n\t\tvec2 uv = LTC_Uv( normal, viewDir, roughness );\n\t\tvec4 t1 = texture2D( ltc_1, uv );\n\t\tvec4 t2 = texture2D( ltc_2, uv );\n\t\tmat3 mInv = mat3(\n\t\t\tvec3( t1.x, 0, t1.y ),\n\t\t\tvec3(    0, 1,    0 ),\n\t\t\tvec3( t1.z, 0, t1.w )\n\t\t);\n\t\tvec3 fresnel = ( material.specularColor * t2.x + ( vec3( 1.0 ) - material.specularColor ) * t2.y );\n\t\treflectedLight.directSpecular += lightColor * fresnel * LTC_Evaluate( normal, viewDir, position, mInv, rectCoords );\n\t\treflectedLight.directDiffuse += lightColor * material.diffuseColor * LTC_Evaluate( normal, viewDir, position, mat3( 1.0 ), rectCoords );\n\t}\n#endif\nvoid RE_Direct_Physical( const in IncidentLight directLight, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\tfloat dotNL = saturate( dot( geometry.normal, directLight.direction ) );\n\tvec3 irradiance = dotNL * directLight.color;\n\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\tirradiance *= PI;\n\t#endif\n\t#ifdef CLEARCOAT\n\t\tfloat ccDotNL = saturate( dot( geometry.clearcoatNormal, directLight.direction ) );\n\t\tvec3 ccIrradiance = ccDotNL * directLight.color;\n\t\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\t\tccIrradiance *= PI;\n\t\t#endif\n\t\tfloat clearcoatDHR = material.clearcoat * clearcoatDHRApprox( material.clearcoatRoughness, ccDotNL );\n\t\treflectedLight.directSpecular += ccIrradiance * material.clearcoat * BRDF_Specular_GGX( directLight, geometry.viewDir, geometry.clearcoatNormal, vec3( DEFAULT_SPECULAR_COEFFICIENT ), material.clearcoatRoughness );\n\t#else\n\t\tfloat clearcoatDHR = 0.0;\n\t#endif\n\t#ifdef USE_SHEEN\n\t\treflectedLight.directSpecular += ( 1.0 - clearcoatDHR ) * irradiance * BRDF_Specular_Sheen(\n\t\t\tmaterial.specularRoughness,\n\t\t\tdirectLight.direction,\n\t\t\tgeometry,\n\t\t\tmaterial.sheenColor\n\t\t);\n\t#else\n\t\treflectedLight.directSpecular += ( 1.0 - clearcoatDHR ) * irradiance * BRDF_Specular_GGX( directLight, geometry.viewDir, geometry.normal, material.specularColor, material.specularRoughness);\n\t#endif\n\treflectedLight.directDiffuse += ( 1.0 - clearcoatDHR ) * irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n}\nvoid RE_IndirectDiffuse_Physical( const in vec3 irradiance, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n}\nvoid RE_IndirectSpecular_Physical( const in vec3 radiance, const in vec3 irradiance, const in vec3 clearcoatRadiance, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight) {\n\t#ifdef CLEARCOAT\n\t\tfloat ccDotNV = saturate( dot( geometry.clearcoatNormal, geometry.viewDir ) );\n\t\treflectedLight.indirectSpecular += clearcoatRadiance * material.clearcoat * BRDF_Specular_GGX_Environment( geometry.viewDir, geometry.clearcoatNormal, vec3( DEFAULT_SPECULAR_COEFFICIENT ), material.clearcoatRoughness );\n\t\tfloat ccDotNL = ccDotNV;\n\t\tfloat clearcoatDHR = material.clearcoat * clearcoatDHRApprox( material.clearcoatRoughness, ccDotNL );\n\t#else\n\t\tfloat clearcoatDHR = 0.0;\n\t#endif\n\tfloat clearcoatInv = 1.0 - clearcoatDHR;\n\tvec3 singleScattering = vec3( 0.0 );\n\tvec3 multiScattering = vec3( 0.0 );\n\tvec3 cosineWeightedIrradiance = irradiance * RECIPROCAL_PI;\n\tBRDF_Specular_Multiscattering_Environment( geometry, material.specularColor, material.specularRoughness, singleScattering, multiScattering );\n\tvec3 diffuse = material.diffuseColor * ( 1.0 - ( singleScattering + multiScattering ) );\n\treflectedLight.indirectSpecular += clearcoatInv * radiance * singleScattering;\n\treflectedLight.indirectSpecular += multiScattering * cosineWeightedIrradiance;\n\treflectedLight.indirectDiffuse += diffuse * cosineWeightedIrradiance;\n}\n#define RE_Direct\t\t\t\tRE_Direct_Physical\n#define RE_Direct_RectArea\t\tRE_Direct_RectArea_Physical\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_Physical\n#define RE_IndirectSpecular\t\tRE_IndirectSpecular_Physical\nfloat computeSpecularOcclusion( const in float dotNV, const in float ambientOcclusion, const in float roughness ) {\n\treturn saturate( pow( dotNV + ambientOcclusion, exp2( - 16.0 * roughness - 1.0 ) ) - 1.0 + ambientOcclusion );\n}",lights_fragment_begin:"\nGeometricContext geometry;\ngeometry.position = - vViewPosition;\ngeometry.normal = normal;\ngeometry.viewDir = ( isOrthographic ) ? vec3( 0, 0, 1 ) : normalize( vViewPosition );\n#ifdef CLEARCOAT\n\tgeometry.clearcoatNormal = clearcoatNormal;\n#endif\nIncidentLight directLight;\n#if ( NUM_POINT_LIGHTS > 0 ) && defined( RE_Direct )\n\tPointLight pointLight;\n\t#if defined( USE_SHADOWMAP ) && NUM_POINT_LIGHT_SHADOWS > 0\n\tPointLightShadow pointLightShadow;\n\t#endif\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n\t\tpointLight = pointLights[ i ];\n\t\tgetPointDirectLightIrradiance( pointLight, geometry, directLight );\n\t\t#if defined( USE_SHADOWMAP ) && ( UNROLLED_LOOP_INDEX < NUM_POINT_LIGHT_SHADOWS )\n\t\tpointLightShadow = pointLightShadows[ i ];\n\t\tdirectLight.color *= all( bvec2( directLight.visible, receiveShadow ) ) ? getPointShadow( pointShadowMap[ i ], pointLightShadow.shadowMapSize, pointLightShadow.shadowBias, pointLightShadow.shadowRadius, vPointShadowCoord[ i ], pointLightShadow.shadowCameraNear, pointLightShadow.shadowCameraFar ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometry, material, reflectedLight );\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if ( NUM_SPOT_LIGHTS > 0 ) && defined( RE_Direct )\n\tSpotLight spotLight;\n\t#if defined( USE_SHADOWMAP ) && NUM_SPOT_LIGHT_SHADOWS > 0\n\tSpotLightShadow spotLightShadow;\n\t#endif\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n\t\tspotLight = spotLights[ i ];\n\t\tgetSpotDirectLightIrradiance( spotLight, geometry, directLight );\n\t\t#if defined( USE_SHADOWMAP ) && ( UNROLLED_LOOP_INDEX < NUM_SPOT_LIGHT_SHADOWS )\n\t\tspotLightShadow = spotLightShadows[ i ];\n\t\tdirectLight.color *= all( bvec2( directLight.visible, receiveShadow ) ) ? getShadow( spotShadowMap[ i ], spotLightShadow.shadowMapSize, spotLightShadow.shadowBias, spotLightShadow.shadowRadius, vSpotShadowCoord[ i ] ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometry, material, reflectedLight );\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if ( NUM_DIR_LIGHTS > 0 ) && defined( RE_Direct )\n\tDirectionalLight directionalLight;\n\t#if defined( USE_SHADOWMAP ) && NUM_DIR_LIGHT_SHADOWS > 0\n\tDirectionalLightShadow directionalLightShadow;\n\t#endif\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n\t\tdirectionalLight = directionalLights[ i ];\n\t\tgetDirectionalDirectLightIrradiance( directionalLight, geometry, directLight );\n\t\t#if defined( USE_SHADOWMAP ) && ( UNROLLED_LOOP_INDEX < NUM_DIR_LIGHT_SHADOWS )\n\t\tdirectionalLightShadow = directionalLightShadows[ i ];\n\t\tdirectLight.color *= all( bvec2( directLight.visible, receiveShadow ) ) ? getShadow( directionalShadowMap[ i ], directionalLightShadow.shadowMapSize, directionalLightShadow.shadowBias, directionalLightShadow.shadowRadius, vDirectionalShadowCoord[ i ] ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometry, material, reflectedLight );\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if ( NUM_RECT_AREA_LIGHTS > 0 ) && defined( RE_Direct_RectArea )\n\tRectAreaLight rectAreaLight;\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_RECT_AREA_LIGHTS; i ++ ) {\n\t\trectAreaLight = rectAreaLights[ i ];\n\t\tRE_Direct_RectArea( rectAreaLight, geometry, material, reflectedLight );\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if defined( RE_IndirectDiffuse )\n\tvec3 iblIrradiance = vec3( 0.0 );\n\tvec3 irradiance = getAmbientLightIrradiance( ambientLightColor );\n\tirradiance += getLightProbeIrradiance( lightProbe, geometry );\n\t#if ( NUM_HEMI_LIGHTS > 0 )\n\t\t#pragma unroll_loop_start\n\t\tfor ( int i = 0; i < NUM_HEMI_LIGHTS; i ++ ) {\n\t\t\tirradiance += getHemisphereLightIrradiance( hemisphereLights[ i ], geometry );\n\t\t}\n\t\t#pragma unroll_loop_end\n\t#endif\n#endif\n#if defined( RE_IndirectSpecular )\n\tvec3 radiance = vec3( 0.0 );\n\tvec3 clearcoatRadiance = vec3( 0.0 );\n#endif",lights_fragment_maps:"#if defined( RE_IndirectDiffuse )\n\t#ifdef USE_LIGHTMAP\n\t\tvec4 lightMapTexel= texture2D( lightMap, vUv2 );\n\t\tvec3 lightMapIrradiance = lightMapTexelToLinear( lightMapTexel ).rgb * lightMapIntensity;\n\t\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\t\tlightMapIrradiance *= PI;\n\t\t#endif\n\t\tirradiance += lightMapIrradiance;\n\t#endif\n\t#if defined( USE_ENVMAP ) && defined( STANDARD ) && defined( ENVMAP_TYPE_CUBE_UV )\n\t\tiblIrradiance += getLightProbeIndirectIrradiance( geometry, maxMipLevel );\n\t#endif\n#endif\n#if defined( USE_ENVMAP ) && defined( RE_IndirectSpecular )\n\tradiance += getLightProbeIndirectRadiance( geometry.viewDir, geometry.normal, material.specularRoughness, maxMipLevel );\n\t#ifdef CLEARCOAT\n\t\tclearcoatRadiance += getLightProbeIndirectRadiance( geometry.viewDir, geometry.clearcoatNormal, material.clearcoatRoughness, maxMipLevel );\n\t#endif\n#endif",lights_fragment_end:"#if defined( RE_IndirectDiffuse )\n\tRE_IndirectDiffuse( irradiance, geometry, material, reflectedLight );\n#endif\n#if defined( RE_IndirectSpecular )\n\tRE_IndirectSpecular( radiance, iblIrradiance, clearcoatRadiance, geometry, material, reflectedLight );\n#endif",logdepthbuf_fragment:"#if defined( USE_LOGDEPTHBUF ) && defined( USE_LOGDEPTHBUF_EXT )\n\tgl_FragDepthEXT = vIsPerspective == 0.0 ? gl_FragCoord.z : log2( vFragDepth ) * logDepthBufFC * 0.5;\n#endif",logdepthbuf_pars_fragment:"#if defined( USE_LOGDEPTHBUF ) && defined( USE_LOGDEPTHBUF_EXT )\n\tuniform float logDepthBufFC;\n\tvarying float vFragDepth;\n\tvarying float vIsPerspective;\n#endif",logdepthbuf_pars_vertex:"#ifdef USE_LOGDEPTHBUF\n\t#ifdef USE_LOGDEPTHBUF_EXT\n\t\tvarying float vFragDepth;\n\t\tvarying float vIsPerspective;\n\t#else\n\t\tuniform float logDepthBufFC;\n\t#endif\n#endif",logdepthbuf_vertex:"#ifdef USE_LOGDEPTHBUF\n\t#ifdef USE_LOGDEPTHBUF_EXT\n\t\tvFragDepth = 1.0 + gl_Position.w;\n\t\tvIsPerspective = float( isPerspectiveMatrix( projectionMatrix ) );\n\t#else\n\t\tif ( isPerspectiveMatrix( projectionMatrix ) ) {\n\t\t\tgl_Position.z = log2( max( EPSILON, gl_Position.w + 1.0 ) ) * logDepthBufFC - 1.0;\n\t\t\tgl_Position.z *= gl_Position.w;\n\t\t}\n\t#endif\n#endif",map_fragment:"#ifdef USE_MAP\n\tvec4 texelColor = texture2D( map, vUv );\n\ttexelColor = mapTexelToLinear( texelColor );\n\tdiffuseColor *= texelColor;\n#endif",map_pars_fragment:"#ifdef USE_MAP\n\tuniform sampler2D map;\n#endif",map_particle_fragment:"#if defined( USE_MAP ) || defined( USE_ALPHAMAP )\n\tvec2 uv = ( uvTransform * vec3( gl_PointCoord.x, 1.0 - gl_PointCoord.y, 1 ) ).xy;\n#endif\n#ifdef USE_MAP\n\tvec4 mapTexel = texture2D( map, uv );\n\tdiffuseColor *= mapTexelToLinear( mapTexel );\n#endif\n#ifdef USE_ALPHAMAP\n\tdiffuseColor.a *= texture2D( alphaMap, uv ).g;\n#endif",map_particle_pars_fragment:"#if defined( USE_MAP ) || defined( USE_ALPHAMAP )\n\tuniform mat3 uvTransform;\n#endif\n#ifdef USE_MAP\n\tuniform sampler2D map;\n#endif\n#ifdef USE_ALPHAMAP\n\tuniform sampler2D alphaMap;\n#endif",metalnessmap_fragment:"float metalnessFactor = metalness;\n#ifdef USE_METALNESSMAP\n\tvec4 texelMetalness = texture2D( metalnessMap, vUv );\n\tmetalnessFactor *= texelMetalness.b;\n#endif",metalnessmap_pars_fragment:"#ifdef USE_METALNESSMAP\n\tuniform sampler2D metalnessMap;\n#endif",morphnormal_vertex:"#ifdef USE_MORPHNORMALS\n\tobjectNormal *= morphTargetBaseInfluence;\n\tobjectNormal += morphNormal0 * morphTargetInfluences[ 0 ];\n\tobjectNormal += morphNormal1 * morphTargetInfluences[ 1 ];\n\tobjectNormal += morphNormal2 * morphTargetInfluences[ 2 ];\n\tobjectNormal += morphNormal3 * morphTargetInfluences[ 3 ];\n#endif",morphtarget_pars_vertex:"#ifdef USE_MORPHTARGETS\n\tuniform float morphTargetBaseInfluence;\n\t#ifndef USE_MORPHNORMALS\n\t\tuniform float morphTargetInfluences[ 8 ];\n\t#else\n\t\tuniform float morphTargetInfluences[ 4 ];\n\t#endif\n#endif",morphtarget_vertex:"#ifdef USE_MORPHTARGETS\n\ttransformed *= morphTargetBaseInfluence;\n\ttransformed += morphTarget0 * morphTargetInfluences[ 0 ];\n\ttransformed += morphTarget1 * morphTargetInfluences[ 1 ];\n\ttransformed += morphTarget2 * morphTargetInfluences[ 2 ];\n\ttransformed += morphTarget3 * morphTargetInfluences[ 3 ];\n\t#ifndef USE_MORPHNORMALS\n\t\ttransformed += morphTarget4 * morphTargetInfluences[ 4 ];\n\t\ttransformed += morphTarget5 * morphTargetInfluences[ 5 ];\n\t\ttransformed += morphTarget6 * morphTargetInfluences[ 6 ];\n\t\ttransformed += morphTarget7 * morphTargetInfluences[ 7 ];\n\t#endif\n#endif",normal_fragment_begin:"#ifdef FLAT_SHADED\n\tvec3 fdx = vec3( dFdx( vViewPosition.x ), dFdx( vViewPosition.y ), dFdx( vViewPosition.z ) );\n\tvec3 fdy = vec3( dFdy( vViewPosition.x ), dFdy( vViewPosition.y ), dFdy( vViewPosition.z ) );\n\tvec3 normal = normalize( cross( fdx, fdy ) );\n#else\n\tvec3 normal = normalize( vNormal );\n\t#ifdef DOUBLE_SIDED\n\t\tnormal = normal * ( float( gl_FrontFacing ) * 2.0 - 1.0 );\n\t#endif\n\t#ifdef USE_TANGENT\n\t\tvec3 tangent = normalize( vTangent );\n\t\tvec3 bitangent = normalize( vBitangent );\n\t\t#ifdef DOUBLE_SIDED\n\t\t\ttangent = tangent * ( float( gl_FrontFacing ) * 2.0 - 1.0 );\n\t\t\tbitangent = bitangent * ( float( gl_FrontFacing ) * 2.0 - 1.0 );\n\t\t#endif\n\t\t#if defined( TANGENTSPACE_NORMALMAP ) || defined( USE_CLEARCOAT_NORMALMAP )\n\t\t\tmat3 vTBN = mat3( tangent, bitangent, normal );\n\t\t#endif\n\t#endif\n#endif\nvec3 geometryNormal = normal;",normal_fragment_maps:"#ifdef OBJECTSPACE_NORMALMAP\n\tnormal = texture2D( normalMap, vUv ).xyz * 2.0 - 1.0;\n\t#ifdef FLIP_SIDED\n\t\tnormal = - normal;\n\t#endif\n\t#ifdef DOUBLE_SIDED\n\t\tnormal = normal * ( float( gl_FrontFacing ) * 2.0 - 1.0 );\n\t#endif\n\tnormal = normalize( normalMatrix * normal );\n#elif defined( TANGENTSPACE_NORMALMAP )\n\tvec3 mapN = texture2D( normalMap, vUv ).xyz * 2.0 - 1.0;\n\tmapN.xy *= normalScale;\n\t#ifdef USE_TANGENT\n\t\tnormal = normalize( vTBN * mapN );\n\t#else\n\t\tnormal = perturbNormal2Arb( -vViewPosition, normal, mapN );\n\t#endif\n#elif defined( USE_BUMPMAP )\n\tnormal = perturbNormalArb( -vViewPosition, normal, dHdxy_fwd() );\n#endif",normalmap_pars_fragment:"#ifdef USE_NORMALMAP\n\tuniform sampler2D normalMap;\n\tuniform vec2 normalScale;\n#endif\n#ifdef OBJECTSPACE_NORMALMAP\n\tuniform mat3 normalMatrix;\n#endif\n#if ! defined ( USE_TANGENT ) && ( defined ( TANGENTSPACE_NORMALMAP ) || defined ( USE_CLEARCOAT_NORMALMAP ) )\n\tvec3 perturbNormal2Arb( vec3 eye_pos, vec3 surf_norm, vec3 mapN ) {\n\t\tvec3 q0 = vec3( dFdx( eye_pos.x ), dFdx( eye_pos.y ), dFdx( eye_pos.z ) );\n\t\tvec3 q1 = vec3( dFdy( eye_pos.x ), dFdy( eye_pos.y ), dFdy( eye_pos.z ) );\n\t\tvec2 st0 = dFdx( vUv.st );\n\t\tvec2 st1 = dFdy( vUv.st );\n\t\tfloat scale = sign( st1.t * st0.s - st0.t * st1.s );\n\t\tvec3 S = normalize( ( q0 * st1.t - q1 * st0.t ) * scale );\n\t\tvec3 T = normalize( ( - q0 * st1.s + q1 * st0.s ) * scale );\n\t\tvec3 N = normalize( surf_norm );\n\t\tmat3 tsn = mat3( S, T, N );\n\t\tmapN.xy *= ( float( gl_FrontFacing ) * 2.0 - 1.0 );\n\t\treturn normalize( tsn * mapN );\n\t}\n#endif",clearcoat_normal_fragment_begin:"#ifdef CLEARCOAT\n\tvec3 clearcoatNormal = geometryNormal;\n#endif",clearcoat_normal_fragment_maps:"#ifdef USE_CLEARCOAT_NORMALMAP\n\tvec3 clearcoatMapN = texture2D( clearcoatNormalMap, vUv ).xyz * 2.0 - 1.0;\n\tclearcoatMapN.xy *= clearcoatNormalScale;\n\t#ifdef USE_TANGENT\n\t\tclearcoatNormal = normalize( vTBN * clearcoatMapN );\n\t#else\n\t\tclearcoatNormal = perturbNormal2Arb( - vViewPosition, clearcoatNormal, clearcoatMapN );\n\t#endif\n#endif",clearcoat_pars_fragment:"#ifdef USE_CLEARCOATMAP\n\tuniform sampler2D clearcoatMap;\n#endif\n#ifdef USE_CLEARCOAT_ROUGHNESSMAP\n\tuniform sampler2D clearcoatRoughnessMap;\n#endif\n#ifdef USE_CLEARCOAT_NORMALMAP\n\tuniform sampler2D clearcoatNormalMap;\n\tuniform vec2 clearcoatNormalScale;\n#endif",packing:"vec3 packNormalToRGB( const in vec3 normal ) {\n\treturn normalize( normal ) * 0.5 + 0.5;\n}\nvec3 unpackRGBToNormal( const in vec3 rgb ) {\n\treturn 2.0 * rgb.xyz - 1.0;\n}\nconst float PackUpscale = 256. / 255.;const float UnpackDownscale = 255. / 256.;\nconst vec3 PackFactors = vec3( 256. * 256. * 256., 256. * 256.,  256. );\nconst vec4 UnpackFactors = UnpackDownscale / vec4( PackFactors, 1. );\nconst float ShiftRight8 = 1. / 256.;\nvec4 packDepthToRGBA( const in float v ) {\n\tvec4 r = vec4( fract( v * PackFactors ), v );\n\tr.yzw -= r.xyz * ShiftRight8;\treturn r * PackUpscale;\n}\nfloat unpackRGBAToDepth( const in vec4 v ) {\n\treturn dot( v, UnpackFactors );\n}\nvec4 pack2HalfToRGBA( vec2 v ) {\n\tvec4 r = vec4( v.x, fract( v.x * 255.0 ), v.y, fract( v.y * 255.0 ));\n\treturn vec4( r.x - r.y / 255.0, r.y, r.z - r.w / 255.0, r.w);\n}\nvec2 unpackRGBATo2Half( vec4 v ) {\n\treturn vec2( v.x + ( v.y / 255.0 ), v.z + ( v.w / 255.0 ) );\n}\nfloat viewZToOrthographicDepth( const in float viewZ, const in float near, const in float far ) {\n\treturn ( viewZ + near ) / ( near - far );\n}\nfloat orthographicDepthToViewZ( const in float linearClipZ, const in float near, const in float far ) {\n\treturn linearClipZ * ( near - far ) - near;\n}\nfloat viewZToPerspectiveDepth( const in float viewZ, const in float near, const in float far ) {\n\treturn (( near + viewZ ) * far ) / (( far - near ) * viewZ );\n}\nfloat perspectiveDepthToViewZ( const in float invClipZ, const in float near, const in float far ) {\n\treturn ( near * far ) / ( ( far - near ) * invClipZ - far );\n}",premultiplied_alpha_fragment:"#ifdef PREMULTIPLIED_ALPHA\n\tgl_FragColor.rgb *= gl_FragColor.a;\n#endif",project_vertex:"vec4 mvPosition = vec4( transformed, 1.0 );\n#ifdef USE_INSTANCING\n\tmvPosition = instanceMatrix * mvPosition;\n#endif\nmvPosition = modelViewMatrix * mvPosition;\ngl_Position = projectionMatrix * mvPosition;",dithering_fragment:"#ifdef DITHERING\n\tgl_FragColor.rgb = dithering( gl_FragColor.rgb );\n#endif",dithering_pars_fragment:"#ifdef DITHERING\n\tvec3 dithering( vec3 color ) {\n\t\tfloat grid_position = rand( gl_FragCoord.xy );\n\t\tvec3 dither_shift_RGB = vec3( 0.25 / 255.0, -0.25 / 255.0, 0.25 / 255.0 );\n\t\tdither_shift_RGB = mix( 2.0 * dither_shift_RGB, -2.0 * dither_shift_RGB, grid_position );\n\t\treturn color + dither_shift_RGB;\n\t}\n#endif",roughnessmap_fragment:"float roughnessFactor = roughness;\n#ifdef USE_ROUGHNESSMAP\n\tvec4 texelRoughness = texture2D( roughnessMap, vUv );\n\troughnessFactor *= texelRoughness.g;\n#endif",roughnessmap_pars_fragment:"#ifdef USE_ROUGHNESSMAP\n\tuniform sampler2D roughnessMap;\n#endif",shadowmap_pars_fragment:"#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHT_SHADOWS > 0\n\t\tuniform sampler2D directionalShadowMap[ NUM_DIR_LIGHT_SHADOWS ];\n\t\tvarying vec4 vDirectionalShadowCoord[ NUM_DIR_LIGHT_SHADOWS ];\n\t\tstruct DirectionalLightShadow {\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t};\n\t\tuniform DirectionalLightShadow directionalLightShadows[ NUM_DIR_LIGHT_SHADOWS ];\n\t#endif\n\t#if NUM_SPOT_LIGHT_SHADOWS > 0\n\t\tuniform sampler2D spotShadowMap[ NUM_SPOT_LIGHT_SHADOWS ];\n\t\tvarying vec4 vSpotShadowCoord[ NUM_SPOT_LIGHT_SHADOWS ];\n\t\tstruct SpotLightShadow {\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t};\n\t\tuniform SpotLightShadow spotLightShadows[ NUM_SPOT_LIGHT_SHADOWS ];\n\t#endif\n\t#if NUM_POINT_LIGHT_SHADOWS > 0\n\t\tuniform sampler2D pointShadowMap[ NUM_POINT_LIGHT_SHADOWS ];\n\t\tvarying vec4 vPointShadowCoord[ NUM_POINT_LIGHT_SHADOWS ];\n\t\tstruct PointLightShadow {\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t\tfloat shadowCameraNear;\n\t\t\tfloat shadowCameraFar;\n\t\t};\n\t\tuniform PointLightShadow pointLightShadows[ NUM_POINT_LIGHT_SHADOWS ];\n\t#endif\n\tfloat texture2DCompare( sampler2D depths, vec2 uv, float compare ) {\n\t\treturn step( compare, unpackRGBAToDepth( texture2D( depths, uv ) ) );\n\t}\n\tvec2 texture2DDistribution( sampler2D shadow, vec2 uv ) {\n\t\treturn unpackRGBATo2Half( texture2D( shadow, uv ) );\n\t}\n\tfloat VSMShadow (sampler2D shadow, vec2 uv, float compare ){\n\t\tfloat occlusion = 1.0;\n\t\tvec2 distribution = texture2DDistribution( shadow, uv );\n\t\tfloat hard_shadow = step( compare , distribution.x );\n\t\tif (hard_shadow != 1.0 ) {\n\t\t\tfloat distance = compare - distribution.x ;\n\t\t\tfloat variance = max( 0.00000, distribution.y * distribution.y );\n\t\t\tfloat softness_probability = variance / (variance + distance * distance );\t\t\tsoftness_probability = clamp( ( softness_probability - 0.3 ) / ( 0.95 - 0.3 ), 0.0, 1.0 );\t\t\tocclusion = clamp( max( hard_shadow, softness_probability ), 0.0, 1.0 );\n\t\t}\n\t\treturn occlusion;\n\t}\n\tfloat getShadow( sampler2D shadowMap, vec2 shadowMapSize, float shadowBias, float shadowRadius, vec4 shadowCoord ) {\n\t\tfloat shadow = 1.0;\n\t\tshadowCoord.xyz /= shadowCoord.w;\n\t\tshadowCoord.z += shadowBias;\n\t\tbvec4 inFrustumVec = bvec4 ( shadowCoord.x >= 0.0, shadowCoord.x <= 1.0, shadowCoord.y >= 0.0, shadowCoord.y <= 1.0 );\n\t\tbool inFrustum = all( inFrustumVec );\n\t\tbvec2 frustumTestVec = bvec2( inFrustum, shadowCoord.z <= 1.0 );\n\t\tbool frustumTest = all( frustumTestVec );\n\t\tif ( frustumTest ) {\n\t\t#if defined( SHADOWMAP_TYPE_PCF )\n\t\t\tvec2 texelSize = vec2( 1.0 ) / shadowMapSize;\n\t\t\tfloat dx0 = - texelSize.x * shadowRadius;\n\t\t\tfloat dy0 = - texelSize.y * shadowRadius;\n\t\t\tfloat dx1 = + texelSize.x * shadowRadius;\n\t\t\tfloat dy1 = + texelSize.y * shadowRadius;\n\t\t\tfloat dx2 = dx0 / 2.0;\n\t\t\tfloat dy2 = dy0 / 2.0;\n\t\t\tfloat dx3 = dx1 / 2.0;\n\t\t\tfloat dy3 = dy1 / 2.0;\n\t\t\tshadow = (\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx2, dy2 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy2 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx3, dy2 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx2, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy, shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx3, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx2, dy3 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy3 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx3, dy3 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, dy1 ), shadowCoord.z )\n\t\t\t) * ( 1.0 / 17.0 );\n\t\t#elif defined( SHADOWMAP_TYPE_PCF_SOFT )\n\t\t\tvec2 texelSize = vec2( 1.0 ) / shadowMapSize;\n\t\t\tfloat dx = texelSize.x;\n\t\t\tfloat dy = texelSize.y;\n\t\t\tvec2 uv = shadowCoord.xy;\n\t\t\tvec2 f = fract( uv * shadowMapSize + 0.5 );\n\t\t\tuv -= f * texelSize;\n\t\t\tshadow = (\n\t\t\t\ttexture2DCompare( shadowMap, uv, shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, uv + vec2( dx, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, uv + vec2( 0.0, dy ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, uv + texelSize, shadowCoord.z ) +\n\t\t\t\tmix( texture2DCompare( shadowMap, uv + vec2( -dx, 0.0 ), shadowCoord.z ), \n\t\t\t\t\t texture2DCompare( shadowMap, uv + vec2( 2.0 * dx, 0.0 ), shadowCoord.z ),\n\t\t\t\t\t f.x ) +\n\t\t\t\tmix( texture2DCompare( shadowMap, uv + vec2( -dx, dy ), shadowCoord.z ), \n\t\t\t\t\t texture2DCompare( shadowMap, uv + vec2( 2.0 * dx, dy ), shadowCoord.z ),\n\t\t\t\t\t f.x ) +\n\t\t\t\tmix( texture2DCompare( shadowMap, uv + vec2( 0.0, -dy ), shadowCoord.z ), \n\t\t\t\t\t texture2DCompare( shadowMap, uv + vec2( 0.0, 2.0 * dy ), shadowCoord.z ),\n\t\t\t\t\t f.y ) +\n\t\t\t\tmix( texture2DCompare( shadowMap, uv + vec2( dx, -dy ), shadowCoord.z ), \n\t\t\t\t\t texture2DCompare( shadowMap, uv + vec2( dx, 2.0 * dy ), shadowCoord.z ),\n\t\t\t\t\t f.y ) +\n\t\t\t\tmix( mix( texture2DCompare( shadowMap, uv + vec2( -dx, -dy ), shadowCoord.z ), \n\t\t\t\t\t\t  texture2DCompare( shadowMap, uv + vec2( 2.0 * dx, -dy ), shadowCoord.z ),\n\t\t\t\t\t\t  f.x ),\n\t\t\t\t\t mix( texture2DCompare( shadowMap, uv + vec2( -dx, 2.0 * dy ), shadowCoord.z ), \n\t\t\t\t\t\t  texture2DCompare( shadowMap, uv + vec2( 2.0 * dx, 2.0 * dy ), shadowCoord.z ),\n\t\t\t\t\t\t  f.x ),\n\t\t\t\t\t f.y )\n\t\t\t) * ( 1.0 / 9.0 );\n\t\t#elif defined( SHADOWMAP_TYPE_VSM )\n\t\t\tshadow = VSMShadow( shadowMap, shadowCoord.xy, shadowCoord.z );\n\t\t#else\n\t\t\tshadow = texture2DCompare( shadowMap, shadowCoord.xy, shadowCoord.z );\n\t\t#endif\n\t\t}\n\t\treturn shadow;\n\t}\n\tvec2 cubeToUV( vec3 v, float texelSizeY ) {\n\t\tvec3 absV = abs( v );\n\t\tfloat scaleToCube = 1.0 / max( absV.x, max( absV.y, absV.z ) );\n\t\tabsV *= scaleToCube;\n\t\tv *= scaleToCube * ( 1.0 - 2.0 * texelSizeY );\n\t\tvec2 planar = v.xy;\n\t\tfloat almostATexel = 1.5 * texelSizeY;\n\t\tfloat almostOne = 1.0 - almostATexel;\n\t\tif ( absV.z >= almostOne ) {\n\t\t\tif ( v.z > 0.0 )\n\t\t\t\tplanar.x = 4.0 - v.x;\n\t\t} else if ( absV.x >= almostOne ) {\n\t\t\tfloat signX = sign( v.x );\n\t\t\tplanar.x = v.z * signX + 2.0 * signX;\n\t\t} else if ( absV.y >= almostOne ) {\n\t\t\tfloat signY = sign( v.y );\n\t\t\tplanar.x = v.x + 2.0 * signY + 2.0;\n\t\t\tplanar.y = v.z * signY - 2.0;\n\t\t}\n\t\treturn vec2( 0.125, 0.25 ) * planar + vec2( 0.375, 0.75 );\n\t}\n\tfloat getPointShadow( sampler2D shadowMap, vec2 shadowMapSize, float shadowBias, float shadowRadius, vec4 shadowCoord, float shadowCameraNear, float shadowCameraFar ) {\n\t\tvec2 texelSize = vec2( 1.0 ) / ( shadowMapSize * vec2( 4.0, 2.0 ) );\n\t\tvec3 lightToPosition = shadowCoord.xyz;\n\t\tfloat dp = ( length( lightToPosition ) - shadowCameraNear ) / ( shadowCameraFar - shadowCameraNear );\t\tdp += shadowBias;\n\t\tvec3 bd3D = normalize( lightToPosition );\n\t\t#if defined( SHADOWMAP_TYPE_PCF ) || defined( SHADOWMAP_TYPE_PCF_SOFT ) || defined( SHADOWMAP_TYPE_VSM )\n\t\t\tvec2 offset = vec2( - 1, 1 ) * shadowRadius * texelSize.y;\n\t\t\treturn (\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xyy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yyy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xyx, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yyx, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xxy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yxy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xxx, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yxx, texelSize.y ), dp )\n\t\t\t) * ( 1.0 / 9.0 );\n\t\t#else\n\t\t\treturn texture2DCompare( shadowMap, cubeToUV( bd3D, texelSize.y ), dp );\n\t\t#endif\n\t}\n#endif",shadowmap_pars_vertex:"#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHT_SHADOWS > 0\n\t\tuniform mat4 directionalShadowMatrix[ NUM_DIR_LIGHT_SHADOWS ];\n\t\tvarying vec4 vDirectionalShadowCoord[ NUM_DIR_LIGHT_SHADOWS ];\n\t\tstruct DirectionalLightShadow {\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t};\n\t\tuniform DirectionalLightShadow directionalLightShadows[ NUM_DIR_LIGHT_SHADOWS ];\n\t#endif\n\t#if NUM_SPOT_LIGHT_SHADOWS > 0\n\t\tuniform mat4 spotShadowMatrix[ NUM_SPOT_LIGHT_SHADOWS ];\n\t\tvarying vec4 vSpotShadowCoord[ NUM_SPOT_LIGHT_SHADOWS ];\n\t\tstruct SpotLightShadow {\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t};\n\t\tuniform SpotLightShadow spotLightShadows[ NUM_SPOT_LIGHT_SHADOWS ];\n\t#endif\n\t#if NUM_POINT_LIGHT_SHADOWS > 0\n\t\tuniform mat4 pointShadowMatrix[ NUM_POINT_LIGHT_SHADOWS ];\n\t\tvarying vec4 vPointShadowCoord[ NUM_POINT_LIGHT_SHADOWS ];\n\t\tstruct PointLightShadow {\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t\tfloat shadowCameraNear;\n\t\t\tfloat shadowCameraFar;\n\t\t};\n\t\tuniform PointLightShadow pointLightShadows[ NUM_POINT_LIGHT_SHADOWS ];\n\t#endif\n#endif",shadowmap_vertex:"#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHT_SHADOWS > 0 || NUM_SPOT_LIGHT_SHADOWS > 0 || NUM_POINT_LIGHT_SHADOWS > 0\n\t\tvec3 shadowWorldNormal = inverseTransformDirection( transformedNormal, viewMatrix );\n\t\tvec4 shadowWorldPosition;\n\t#endif\n\t#if NUM_DIR_LIGHT_SHADOWS > 0\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_DIR_LIGHT_SHADOWS; i ++ ) {\n\t\tshadowWorldPosition = worldPosition + vec4( shadowWorldNormal * directionalLightShadows[ i ].shadowNormalBias, 0 );\n\t\tvDirectionalShadowCoord[ i ] = directionalShadowMatrix[ i ] * shadowWorldPosition;\n\t}\n\t#pragma unroll_loop_end\n\t#endif\n\t#if NUM_SPOT_LIGHT_SHADOWS > 0\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_SPOT_LIGHT_SHADOWS; i ++ ) {\n\t\tshadowWorldPosition = worldPosition + vec4( shadowWorldNormal * spotLightShadows[ i ].shadowNormalBias, 0 );\n\t\tvSpotShadowCoord[ i ] = spotShadowMatrix[ i ] * shadowWorldPosition;\n\t}\n\t#pragma unroll_loop_end\n\t#endif\n\t#if NUM_POINT_LIGHT_SHADOWS > 0\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_POINT_LIGHT_SHADOWS; i ++ ) {\n\t\tshadowWorldPosition = worldPosition + vec4( shadowWorldNormal * pointLightShadows[ i ].shadowNormalBias, 0 );\n\t\tvPointShadowCoord[ i ] = pointShadowMatrix[ i ] * shadowWorldPosition;\n\t}\n\t#pragma unroll_loop_end\n\t#endif\n#endif",shadowmask_pars_fragment:"float getShadowMask() {\n\tfloat shadow = 1.0;\n\t#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHT_SHADOWS > 0\n\tDirectionalLightShadow directionalLight;\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_DIR_LIGHT_SHADOWS; i ++ ) {\n\t\tdirectionalLight = directionalLightShadows[ i ];\n\t\tshadow *= receiveShadow ? getShadow( directionalShadowMap[ i ], directionalLight.shadowMapSize, directionalLight.shadowBias, directionalLight.shadowRadius, vDirectionalShadowCoord[ i ] ) : 1.0;\n\t}\n\t#pragma unroll_loop_end\n\t#endif\n\t#if NUM_SPOT_LIGHT_SHADOWS > 0\n\tSpotLightShadow spotLight;\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_SPOT_LIGHT_SHADOWS; i ++ ) {\n\t\tspotLight = spotLightShadows[ i ];\n\t\tshadow *= receiveShadow ? getShadow( spotShadowMap[ i ], spotLight.shadowMapSize, spotLight.shadowBias, spotLight.shadowRadius, vSpotShadowCoord[ i ] ) : 1.0;\n\t}\n\t#pragma unroll_loop_end\n\t#endif\n\t#if NUM_POINT_LIGHT_SHADOWS > 0\n\tPointLightShadow pointLight;\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_POINT_LIGHT_SHADOWS; i ++ ) {\n\t\tpointLight = pointLightShadows[ i ];\n\t\tshadow *= receiveShadow ? getPointShadow( pointShadowMap[ i ], pointLight.shadowMapSize, pointLight.shadowBias, pointLight.shadowRadius, vPointShadowCoord[ i ], pointLight.shadowCameraNear, pointLight.shadowCameraFar ) : 1.0;\n\t}\n\t#pragma unroll_loop_end\n\t#endif\n\t#endif\n\treturn shadow;\n}",skinbase_vertex:"#ifdef USE_SKINNING\n\tmat4 boneMatX = getBoneMatrix( skinIndex.x );\n\tmat4 boneMatY = getBoneMatrix( skinIndex.y );\n\tmat4 boneMatZ = getBoneMatrix( skinIndex.z );\n\tmat4 boneMatW = getBoneMatrix( skinIndex.w );\n#endif",skinning_pars_vertex:"#ifdef USE_SKINNING\n\tuniform mat4 bindMatrix;\n\tuniform mat4 bindMatrixInverse;\n\t#ifdef BONE_TEXTURE\n\t\tuniform highp sampler2D boneTexture;\n\t\tuniform int boneTextureSize;\n\t\tmat4 getBoneMatrix( const in float i ) {\n\t\t\tfloat j = i * 4.0;\n\t\t\tfloat x = mod( j, float( boneTextureSize ) );\n\t\t\tfloat y = floor( j / float( boneTextureSize ) );\n\t\t\tfloat dx = 1.0 / float( boneTextureSize );\n\t\t\tfloat dy = 1.0 / float( boneTextureSize );\n\t\t\ty = dy * ( y + 0.5 );\n\t\t\tvec4 v1 = texture2D( boneTexture, vec2( dx * ( x + 0.5 ), y ) );\n\t\t\tvec4 v2 = texture2D( boneTexture, vec2( dx * ( x + 1.5 ), y ) );\n\t\t\tvec4 v3 = texture2D( boneTexture, vec2( dx * ( x + 2.5 ), y ) );\n\t\t\tvec4 v4 = texture2D( boneTexture, vec2( dx * ( x + 3.5 ), y ) );\n\t\t\tmat4 bone = mat4( v1, v2, v3, v4 );\n\t\t\treturn bone;\n\t\t}\n\t#else\n\t\tuniform mat4 boneMatrices[ MAX_BONES ];\n\t\tmat4 getBoneMatrix( const in float i ) {\n\t\t\tmat4 bone = boneMatrices[ int(i) ];\n\t\t\treturn bone;\n\t\t}\n\t#endif\n#endif",skinning_vertex:"#ifdef USE_SKINNING\n\tvec4 skinVertex = bindMatrix * vec4( transformed, 1.0 );\n\tvec4 skinned = vec4( 0.0 );\n\tskinned += boneMatX * skinVertex * skinWeight.x;\n\tskinned += boneMatY * skinVertex * skinWeight.y;\n\tskinned += boneMatZ * skinVertex * skinWeight.z;\n\tskinned += boneMatW * skinVertex * skinWeight.w;\n\ttransformed = ( bindMatrixInverse * skinned ).xyz;\n#endif",skinnormal_vertex:"#ifdef USE_SKINNING\n\tmat4 skinMatrix = mat4( 0.0 );\n\tskinMatrix += skinWeight.x * boneMatX;\n\tskinMatrix += skinWeight.y * boneMatY;\n\tskinMatrix += skinWeight.z * boneMatZ;\n\tskinMatrix += skinWeight.w * boneMatW;\n\tskinMatrix  = bindMatrixInverse * skinMatrix * bindMatrix;\n\tobjectNormal = vec4( skinMatrix * vec4( objectNormal, 0.0 ) ).xyz;\n\t#ifdef USE_TANGENT\n\t\tobjectTangent = vec4( skinMatrix * vec4( objectTangent, 0.0 ) ).xyz;\n\t#endif\n#endif",specularmap_fragment:"float specularStrength;\n#ifdef USE_SPECULARMAP\n\tvec4 texelSpecular = texture2D( specularMap, vUv );\n\tspecularStrength = texelSpecular.r;\n#else\n\tspecularStrength = 1.0;\n#endif",specularmap_pars_fragment:"#ifdef USE_SPECULARMAP\n\tuniform sampler2D specularMap;\n#endif",tonemapping_fragment:"#if defined( TONE_MAPPING )\n\tgl_FragColor.rgb = toneMapping( gl_FragColor.rgb );\n#endif",tonemapping_pars_fragment:"#ifndef saturate\n#define saturate(a) clamp( a, 0.0, 1.0 )\n#endif\nuniform float toneMappingExposure;\nvec3 LinearToneMapping( vec3 color ) {\n\treturn toneMappingExposure * color;\n}\nvec3 ReinhardToneMapping( vec3 color ) {\n\tcolor *= toneMappingExposure;\n\treturn saturate( color / ( vec3( 1.0 ) + color ) );\n}\nvec3 OptimizedCineonToneMapping( vec3 color ) {\n\tcolor *= toneMappingExposure;\n\tcolor = max( vec3( 0.0 ), color - 0.004 );\n\treturn pow( ( color * ( 6.2 * color + 0.5 ) ) / ( color * ( 6.2 * color + 1.7 ) + 0.06 ), vec3( 2.2 ) );\n}\nvec3 RRTAndODTFit( vec3 v ) {\n\tvec3 a = v * ( v + 0.0245786 ) - 0.000090537;\n\tvec3 b = v * ( 0.983729 * v + 0.4329510 ) + 0.238081;\n\treturn a / b;\n}\nvec3 ACESFilmicToneMapping( vec3 color ) {\n\tconst mat3 ACESInputMat = mat3(\n\t\tvec3( 0.59719, 0.07600, 0.02840 ),\t\tvec3( 0.35458, 0.90834, 0.13383 ),\n\t\tvec3( 0.04823, 0.01566, 0.83777 )\n\t);\n\tconst mat3 ACESOutputMat = mat3(\n\t\tvec3(  1.60475, -0.10208, -0.00327 ),\t\tvec3( -0.53108,  1.10813, -0.07276 ),\n\t\tvec3( -0.07367, -0.00605,  1.07602 )\n\t);\n\tcolor *= toneMappingExposure / 0.6;\n\tcolor = ACESInputMat * color;\n\tcolor = RRTAndODTFit( color );\n\tcolor = ACESOutputMat * color;\n\treturn saturate( color );\n}\nvec3 CustomToneMapping( vec3 color ) { return color; }",transmissionmap_fragment:"#ifdef USE_TRANSMISSIONMAP\n\ttotalTransmission *= texture2D( transmissionMap, vUv ).r;\n#endif",transmissionmap_pars_fragment:"#ifdef USE_TRANSMISSIONMAP\n\tuniform sampler2D transmissionMap;\n#endif",uv_pars_fragment:"#if ( defined( USE_UV ) && ! defined( UVS_VERTEX_ONLY ) )\n\tvarying vec2 vUv;\n#endif",uv_pars_vertex:"#ifdef USE_UV\n\t#ifdef UVS_VERTEX_ONLY\n\t\tvec2 vUv;\n\t#else\n\t\tvarying vec2 vUv;\n\t#endif\n\tuniform mat3 uvTransform;\n#endif",uv_vertex:"#ifdef USE_UV\n\tvUv = ( uvTransform * vec3( uv, 1 ) ).xy;\n#endif",uv2_pars_fragment:"#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\n\tvarying vec2 vUv2;\n#endif",uv2_pars_vertex:"#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\n\tattribute vec2 uv2;\n\tvarying vec2 vUv2;\n\tuniform mat3 uv2Transform;\n#endif",uv2_vertex:"#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\n\tvUv2 = ( uv2Transform * vec3( uv2, 1 ) ).xy;\n#endif",worldpos_vertex:"#if defined( USE_ENVMAP ) || defined( DISTANCE ) || defined ( USE_SHADOWMAP )\n\tvec4 worldPosition = vec4( transformed, 1.0 );\n\t#ifdef USE_INSTANCING\n\t\tworldPosition = instanceMatrix * worldPosition;\n\t#endif\n\tworldPosition = modelMatrix * worldPosition;\n#endif",background_frag:"uniform sampler2D t2D;\nvarying vec2 vUv;\nvoid main() {\n\tvec4 texColor = texture2D( t2D, vUv );\n\tgl_FragColor = mapTexelToLinear( texColor );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n}",background_vert:"varying vec2 vUv;\nuniform mat3 uvTransform;\nvoid main() {\n\tvUv = ( uvTransform * vec3( uv, 1 ) ).xy;\n\tgl_Position = vec4( position.xy, 1.0, 1.0 );\n}",cube_frag:"#include <envmap_common_pars_fragment>\nuniform float opacity;\nvarying vec3 vWorldDirection;\n#include <cube_uv_reflection_fragment>\nvoid main() {\n\tvec3 vReflect = vWorldDirection;\n\t#include <envmap_fragment>\n\tgl_FragColor = envColor;\n\tgl_FragColor.a *= opacity;\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n}",cube_vert:"varying vec3 vWorldDirection;\n#include <common>\nvoid main() {\n\tvWorldDirection = transformDirection( position, modelMatrix );\n\t#include <begin_vertex>\n\t#include <project_vertex>\n\tgl_Position.z = gl_Position.w;\n}",depth_frag:"#if DEPTH_PACKING == 3200\n\tuniform float opacity;\n#endif\n#include <common>\n#include <packing>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvarying vec2 vHighPrecisionZW;\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( 1.0 );\n\t#if DEPTH_PACKING == 3200\n\t\tdiffuseColor.a = opacity;\n\t#endif\n\t#include <map_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <logdepthbuf_fragment>\n\tfloat fragCoordZ = 0.5 * vHighPrecisionZW[0] / vHighPrecisionZW[1] + 0.5;\n\t#if DEPTH_PACKING == 3200\n\t\tgl_FragColor = vec4( vec3( 1.0 - fragCoordZ ), opacity );\n\t#elif DEPTH_PACKING == 3201\n\t\tgl_FragColor = packDepthToRGBA( fragCoordZ );\n\t#endif\n}",depth_vert:"#include <common>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvarying vec2 vHighPrecisionZW;\nvoid main() {\n\t#include <uv_vertex>\n\t#include <skinbase_vertex>\n\t#ifdef USE_DISPLACEMENTMAP\n\t\t#include <beginnormal_vertex>\n\t\t#include <morphnormal_vertex>\n\t\t#include <skinnormal_vertex>\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvHighPrecisionZW = gl_Position.zw;\n}",distanceRGBA_frag:"#define DISTANCE\nuniform vec3 referencePosition;\nuniform float nearDistance;\nuniform float farDistance;\nvarying vec3 vWorldPosition;\n#include <common>\n#include <packing>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main () {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( 1.0 );\n\t#include <map_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\tfloat dist = length( vWorldPosition - referencePosition );\n\tdist = ( dist - nearDistance ) / ( farDistance - nearDistance );\n\tdist = saturate( dist );\n\tgl_FragColor = packDepthToRGBA( dist );\n}",distanceRGBA_vert:"#define DISTANCE\nvarying vec3 vWorldPosition;\n#include <common>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <skinbase_vertex>\n\t#ifdef USE_DISPLACEMENTMAP\n\t\t#include <beginnormal_vertex>\n\t\t#include <morphnormal_vertex>\n\t\t#include <skinnormal_vertex>\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <worldpos_vertex>\n\t#include <clipping_planes_vertex>\n\tvWorldPosition = worldPosition.xyz;\n}",equirect_frag:"uniform sampler2D tEquirect;\nvarying vec3 vWorldDirection;\n#include <common>\nvoid main() {\n\tvec3 direction = normalize( vWorldDirection );\n\tvec2 sampleUV = equirectUv( direction );\n\tvec4 texColor = texture2D( tEquirect, sampleUV );\n\tgl_FragColor = mapTexelToLinear( texColor );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n}",equirect_vert:"varying vec3 vWorldDirection;\n#include <common>\nvoid main() {\n\tvWorldDirection = transformDirection( position, modelMatrix );\n\t#include <begin_vertex>\n\t#include <project_vertex>\n}",linedashed_frag:"uniform vec3 diffuse;\nuniform float opacity;\nuniform float dashSize;\nuniform float totalSize;\nvarying float vLineDistance;\n#include <common>\n#include <color_pars_fragment>\n#include <fog_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tif ( mod( vLineDistance, totalSize ) > dashSize ) {\n\t\tdiscard;\n\t}\n\tvec3 outgoingLight = vec3( 0.0 );\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <logdepthbuf_fragment>\n\t#include <color_fragment>\n\toutgoingLight = diffuseColor.rgb;\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n}",linedashed_vert:"uniform float scale;\nattribute float lineDistance;\nvarying float vLineDistance;\n#include <common>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\tvLineDistance = scale * lineDistance;\n\t#include <color_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <fog_vertex>\n}",meshbasic_frag:"uniform vec3 diffuse;\nuniform float opacity;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <envmap_common_pars_fragment>\n#include <envmap_pars_fragment>\n#include <cube_uv_reflection_fragment>\n#include <fog_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <specularmap_fragment>\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\t#ifdef USE_LIGHTMAP\n\t\n\t\tvec4 lightMapTexel= texture2D( lightMap, vUv2 );\n\t\treflectedLight.indirectDiffuse += lightMapTexelToLinear( lightMapTexel ).rgb * lightMapIntensity;\n\t#else\n\t\treflectedLight.indirectDiffuse += vec3( 1.0 );\n\t#endif\n\t#include <aomap_fragment>\n\treflectedLight.indirectDiffuse *= diffuseColor.rgb;\n\tvec3 outgoingLight = reflectedLight.indirectDiffuse;\n\t#include <envmap_fragment>\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}",meshbasic_vert:"#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <skinbase_vertex>\n\t#ifdef USE_ENVMAP\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <worldpos_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <envmap_vertex>\n\t#include <fog_vertex>\n}",meshlambert_frag:"uniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float opacity;\nvarying vec3 vLightFront;\nvarying vec3 vIndirectFront;\n#ifdef DOUBLE_SIDED\n\tvarying vec3 vLightBack;\n\tvarying vec3 vIndirectBack;\n#endif\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_common_pars_fragment>\n#include <envmap_pars_fragment>\n#include <cube_uv_reflection_fragment>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <fog_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <shadowmask_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <specularmap_fragment>\n\t#include <emissivemap_fragment>\n\t#ifdef DOUBLE_SIDED\n\t\treflectedLight.indirectDiffuse += ( gl_FrontFacing ) ? vIndirectFront : vIndirectBack;\n\t#else\n\t\treflectedLight.indirectDiffuse += vIndirectFront;\n\t#endif\n\t#include <lightmap_fragment>\n\treflectedLight.indirectDiffuse *= BRDF_Diffuse_Lambert( diffuseColor.rgb );\n\t#ifdef DOUBLE_SIDED\n\t\treflectedLight.directDiffuse = ( gl_FrontFacing ) ? vLightFront : vLightBack;\n\t#else\n\t\treflectedLight.directDiffuse = vLightFront;\n\t#endif\n\treflectedLight.directDiffuse *= BRDF_Diffuse_Lambert( diffuseColor.rgb ) * getShadowMask();\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + totalEmissiveRadiance;\n\t#include <envmap_fragment>\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}",meshlambert_vert:"#define LAMBERT\nvarying vec3 vLightFront;\nvarying vec3 vIndirectFront;\n#ifdef DOUBLE_SIDED\n\tvarying vec3 vLightBack;\n\tvarying vec3 vIndirectBack;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <envmap_pars_vertex>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <worldpos_vertex>\n\t#include <envmap_vertex>\n\t#include <lights_lambert_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}",meshmatcap_frag:"#define MATCAP\nuniform vec3 diffuse;\nuniform float opacity;\nuniform sampler2D matcap;\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <fog_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\tvec3 viewDir = normalize( vViewPosition );\n\tvec3 x = normalize( vec3( viewDir.z, 0.0, - viewDir.x ) );\n\tvec3 y = cross( viewDir, x );\n\tvec2 uv = vec2( dot( x, normal ), dot( y, normal ) ) * 0.495 + 0.5;\n\t#ifdef USE_MATCAP\n\t\tvec4 matcapColor = texture2D( matcap, uv );\n\t\tmatcapColor = matcapTexelToLinear( matcapColor );\n\t#else\n\t\tvec4 matcapColor = vec4( 1.0 );\n\t#endif\n\tvec3 outgoingLight = diffuseColor.rgb * matcapColor.rgb;\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}",meshmatcap_vert:"#define MATCAP\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <color_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <color_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#ifndef FLAT_SHADED\n\t\tvNormal = normalize( transformedNormal );\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <fog_vertex>\n\tvViewPosition = - mvPosition.xyz;\n}",meshtoon_frag:"#define TOON\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <gradientmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <lights_toon_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\t#include <emissivemap_fragment>\n\t#include <lights_toon_fragment>\n\t#include <lights_fragment_begin>\n\t#include <lights_fragment_maps>\n\t#include <lights_fragment_end>\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + totalEmissiveRadiance;\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}",meshtoon_vert:"#define TOON\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n#ifndef FLAT_SHADED\n\tvNormal = normalize( transformedNormal );\n#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}",meshphong_frag:"#define PHONG\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform vec3 specular;\nuniform float shininess;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_common_pars_fragment>\n#include <envmap_pars_fragment>\n#include <cube_uv_reflection_fragment>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <lights_phong_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <specularmap_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\t#include <emissivemap_fragment>\n\t#include <lights_phong_fragment>\n\t#include <lights_fragment_begin>\n\t#include <lights_fragment_maps>\n\t#include <lights_fragment_end>\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveRadiance;\n\t#include <envmap_fragment>\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}",meshphong_vert:"#define PHONG\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n#ifndef FLAT_SHADED\n\tvNormal = normalize( transformedNormal );\n#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <envmap_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}",meshphysical_frag:"#define STANDARD\n#ifdef PHYSICAL\n\t#define REFLECTIVITY\n\t#define CLEARCOAT\n\t#define TRANSMISSION\n#endif\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float roughness;\nuniform float metalness;\nuniform float opacity;\n#ifdef TRANSMISSION\n\tuniform float transmission;\n#endif\n#ifdef REFLECTIVITY\n\tuniform float reflectivity;\n#endif\n#ifdef CLEARCOAT\n\tuniform float clearcoat;\n\tuniform float clearcoatRoughness;\n#endif\n#ifdef USE_SHEEN\n\tuniform vec3 sheen;\n#endif\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n\t#ifdef USE_TANGENT\n\t\tvarying vec3 vTangent;\n\t\tvarying vec3 vBitangent;\n\t#endif\n#endif\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <transmissionmap_pars_fragment>\n#include <bsdfs>\n#include <cube_uv_reflection_fragment>\n#include <envmap_common_pars_fragment>\n#include <envmap_physical_pars_fragment>\n#include <fog_pars_fragment>\n#include <lights_pars_begin>\n#include <lights_physical_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <clearcoat_pars_fragment>\n#include <roughnessmap_pars_fragment>\n#include <metalnessmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#ifdef TRANSMISSION\n\t\tfloat totalTransmission = transmission;\n\t#endif\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <roughnessmap_fragment>\n\t#include <metalnessmap_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\t#include <clearcoat_normal_fragment_begin>\n\t#include <clearcoat_normal_fragment_maps>\n\t#include <emissivemap_fragment>\n\t#include <transmissionmap_fragment>\n\t#include <lights_physical_fragment>\n\t#include <lights_fragment_begin>\n\t#include <lights_fragment_maps>\n\t#include <lights_fragment_end>\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveRadiance;\n\t#ifdef TRANSMISSION\n\t\tdiffuseColor.a *= saturate( 1. - totalTransmission + linearToRelativeLuminance( reflectedLight.directSpecular + reflectedLight.indirectSpecular ) );\n\t#endif\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}",meshphysical_vert:"#define STANDARD\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n\t#ifdef USE_TANGENT\n\t\tvarying vec3 vTangent;\n\t\tvarying vec3 vBitangent;\n\t#endif\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n#ifndef FLAT_SHADED\n\tvNormal = normalize( transformedNormal );\n\t#ifdef USE_TANGENT\n\t\tvTangent = normalize( transformedTangent );\n\t\tvBitangent = normalize( cross( vNormal, vTangent ) * tangent.w );\n\t#endif\n#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}",normal_frag:"#define NORMAL\nuniform float opacity;\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( TANGENTSPACE_NORMALMAP )\n\tvarying vec3 vViewPosition;\n#endif\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n\t#ifdef USE_TANGENT\n\t\tvarying vec3 vTangent;\n\t\tvarying vec3 vBitangent;\n\t#endif\n#endif\n#include <packing>\n#include <uv_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\t#include <logdepthbuf_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\tgl_FragColor = vec4( packNormalToRGB( normal ), opacity );\n}",normal_vert:"#define NORMAL\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( TANGENTSPACE_NORMALMAP )\n\tvarying vec3 vViewPosition;\n#endif\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n\t#ifdef USE_TANGENT\n\t\tvarying vec3 vTangent;\n\t\tvarying vec3 vBitangent;\n\t#endif\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n#ifndef FLAT_SHADED\n\tvNormal = normalize( transformedNormal );\n\t#ifdef USE_TANGENT\n\t\tvTangent = normalize( transformedTangent );\n\t\tvBitangent = normalize( cross( vNormal, vTangent ) * tangent.w );\n\t#endif\n#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( TANGENTSPACE_NORMALMAP )\n\tvViewPosition = - mvPosition.xyz;\n#endif\n}",points_frag:"uniform vec3 diffuse;\nuniform float opacity;\n#include <common>\n#include <color_pars_fragment>\n#include <map_particle_pars_fragment>\n#include <fog_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec3 outgoingLight = vec3( 0.0 );\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <logdepthbuf_fragment>\n\t#include <map_particle_fragment>\n\t#include <color_fragment>\n\t#include <alphatest_fragment>\n\toutgoingLight = diffuseColor.rgb;\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n}",points_vert:"uniform float size;\nuniform float scale;\n#include <common>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <color_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <project_vertex>\n\tgl_PointSize = size;\n\t#ifdef USE_SIZEATTENUATION\n\t\tbool isPerspective = isPerspectiveMatrix( projectionMatrix );\n\t\tif ( isPerspective ) gl_PointSize *= ( scale / - mvPosition.z );\n\t#endif\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <worldpos_vertex>\n\t#include <fog_vertex>\n}",shadow_frag:"uniform vec3 color;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <shadowmap_pars_fragment>\n#include <shadowmask_pars_fragment>\nvoid main() {\n\tgl_FragColor = vec4( color, opacity * ( 1.0 - getShadowMask() ) );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n}",shadow_vert:"#include <common>\n#include <fog_pars_vertex>\n#include <shadowmap_pars_vertex>\nvoid main() {\n\t#include <begin_vertex>\n\t#include <project_vertex>\n\t#include <worldpos_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}",sprite_frag:"uniform vec3 diffuse;\nuniform float opacity;\n#include <common>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <fog_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec3 outgoingLight = vec3( 0.0 );\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\toutgoingLight = diffuseColor.rgb;\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n}",sprite_vert:"uniform float rotation;\nuniform vec2 center;\n#include <common>\n#include <uv_pars_vertex>\n#include <fog_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\tvec4 mvPosition = modelViewMatrix * vec4( 0.0, 0.0, 0.0, 1.0 );\n\tvec2 scale;\n\tscale.x = length( vec3( modelMatrix[ 0 ].x, modelMatrix[ 0 ].y, modelMatrix[ 0 ].z ) );\n\tscale.y = length( vec3( modelMatrix[ 1 ].x, modelMatrix[ 1 ].y, modelMatrix[ 1 ].z ) );\n\t#ifndef USE_SIZEATTENUATION\n\t\tbool isPerspective = isPerspectiveMatrix( projectionMatrix );\n\t\tif ( isPerspective ) scale *= - mvPosition.z;\n\t#endif\n\tvec2 alignedPosition = ( position.xy - ( center - vec2( 0.5 ) ) ) * scale;\n\tvec2 rotatedPosition;\n\trotatedPosition.x = cos( rotation ) * alignedPosition.x - sin( rotation ) * alignedPosition.y;\n\trotatedPosition.y = sin( rotation ) * alignedPosition.x + cos( rotation ) * alignedPosition.y;\n\tmvPosition.xy += rotatedPosition;\n\tgl_Position = projectionMatrix * mvPosition;\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <fog_vertex>\n}"},ShaderLib={basic:{uniforms:mergeUniforms([UniformsLib.common,UniformsLib.specularmap,UniformsLib.envmap,UniformsLib.aomap,UniformsLib.lightmap,UniformsLib.fog]),vertexShader:ShaderChunk.meshbasic_vert,fragmentShader:ShaderChunk.meshbasic_frag},lambert:{uniforms:mergeUniforms([UniformsLib.common,UniformsLib.specularmap,UniformsLib.envmap,UniformsLib.aomap,UniformsLib.lightmap,UniformsLib.emissivemap,UniformsLib.fog,UniformsLib.lights,{emissive:{value:new Color(0)}}]),vertexShader:ShaderChunk.meshlambert_vert,fragmentShader:ShaderChunk.meshlambert_frag},phong:{uniforms:mergeUniforms([UniformsLib.common,UniformsLib.specularmap,UniformsLib.envmap,UniformsLib.aomap,UniformsLib.lightmap,UniformsLib.emissivemap,UniformsLib.bumpmap,UniformsLib.normalmap,UniformsLib.displacementmap,UniformsLib.fog,UniformsLib.lights,{emissive:{value:new Color(0)},specular:{value:new Color(1118481)},shininess:{value:30}}]),vertexShader:ShaderChunk.meshphong_vert,fragmentShader:ShaderChunk.meshphong_frag},standard:{uniforms:mergeUniforms([UniformsLib.common,UniformsLib.envmap,UniformsLib.aomap,UniformsLib.lightmap,UniformsLib.emissivemap,UniformsLib.bumpmap,UniformsLib.normalmap,UniformsLib.displacementmap,UniformsLib.roughnessmap,UniformsLib.metalnessmap,UniformsLib.fog,UniformsLib.lights,{emissive:{value:new Color(0)},roughness:{value:1},metalness:{value:0},envMapIntensity:{value:1}}]),vertexShader:ShaderChunk.meshphysical_vert,fragmentShader:ShaderChunk.meshphysical_frag},toon:{uniforms:mergeUniforms([UniformsLib.common,UniformsLib.aomap,UniformsLib.lightmap,UniformsLib.emissivemap,UniformsLib.bumpmap,UniformsLib.normalmap,UniformsLib.displacementmap,UniformsLib.gradientmap,UniformsLib.fog,UniformsLib.lights,{emissive:{value:new Color(0)}}]),vertexShader:ShaderChunk.meshtoon_vert,fragmentShader:ShaderChunk.meshtoon_frag},matcap:{uniforms:mergeUniforms([UniformsLib.common,UniformsLib.bumpmap,UniformsLib.normalmap,UniformsLib.displacementmap,UniformsLib.fog,{matcap:{value:null}}]),vertexShader:ShaderChunk.meshmatcap_vert,fragmentShader:ShaderChunk.meshmatcap_frag},points:{uniforms:mergeUniforms([UniformsLib.points,UniformsLib.fog]),vertexShader:ShaderChunk.points_vert,fragmentShader:ShaderChunk.points_frag},dashed:{uniforms:mergeUniforms([UniformsLib.common,UniformsLib.fog,{scale:{value:1},dashSize:{value:1},totalSize:{value:2}}]),vertexShader:ShaderChunk.linedashed_vert,fragmentShader:ShaderChunk.linedashed_frag},depth:{uniforms:mergeUniforms([UniformsLib.common,UniformsLib.displacementmap]),vertexShader:ShaderChunk.depth_vert,fragmentShader:ShaderChunk.depth_frag},normal:{uniforms:mergeUniforms([UniformsLib.common,UniformsLib.bumpmap,UniformsLib.normalmap,UniformsLib.displacementmap,{opacity:{value:1}}]),vertexShader:ShaderChunk.normal_vert,fragmentShader:ShaderChunk.normal_frag},sprite:{uniforms:mergeUniforms([UniformsLib.sprite,UniformsLib.fog]),vertexShader:ShaderChunk.sprite_vert,fragmentShader:ShaderChunk.sprite_frag},background:{uniforms:{uvTransform:{value:new Matrix3},t2D:{value:null}},vertexShader:ShaderChunk.background_vert,fragmentShader:ShaderChunk.background_frag},cube:{uniforms:mergeUniforms([UniformsLib.envmap,{opacity:{value:1}}]),vertexShader:ShaderChunk.cube_vert,fragmentShader:ShaderChunk.cube_frag},equirect:{uniforms:{tEquirect:{value:null}},vertexShader:ShaderChunk.equirect_vert,fragmentShader:ShaderChunk.equirect_frag},distanceRGBA:{uniforms:mergeUniforms([UniformsLib.common,UniformsLib.displacementmap,{referencePosition:{value:new Vector3},nearDistance:{value:1},farDistance:{value:1e3}}]),vertexShader:ShaderChunk.distanceRGBA_vert,fragmentShader:ShaderChunk.distanceRGBA_frag},shadow:{uniforms:mergeUniforms([UniformsLib.lights,UniformsLib.fog,{color:{value:new Color(0)},opacity:{value:1}}]),vertexShader:ShaderChunk.shadow_vert,fragmentShader:ShaderChunk.shadow_frag}};function WebGLBackground(renderer,state,objects,premultipliedAlpha){const clearColor=new Color(0);let planeMesh,boxMesh,clearAlpha=0,currentBackground=null,currentBackgroundVersion=0,currentTonemapping=null;function setClear(color,alpha){state.buffers.color.setClear(color.r,color.g,color.b,alpha,premultipliedAlpha)}return{getClearColor:function(){return clearColor},setClearColor:function(color,alpha){clearColor.set(color),clearAlpha=void 0!==alpha?alpha:1,setClear(clearColor,clearAlpha)},getClearAlpha:function(){return clearAlpha},setClearAlpha:function(alpha){clearAlpha=alpha,setClear(clearColor,clearAlpha)},render:function(renderList,scene,camera,forceClear){let background=!0===scene.isScene?scene.background:null;const xr=renderer.xr,session=xr.getSession&&xr.getSession();if(session&&"additive"===session.environmentBlendMode&&(background=null),null===background?setClear(clearColor,clearAlpha):background&&background.isColor&&(setClear(background,1),forceClear=!0),(renderer.autoClear||forceClear)&&renderer.clear(renderer.autoClearColor,renderer.autoClearDepth,renderer.autoClearStencil),background&&(background.isCubeTexture||background.isWebGLCubeRenderTarget||306===background.mapping)){void 0===boxMesh&&(boxMesh=new Mesh(new BoxBufferGeometry(1,1,1),new ShaderMaterial({name:"BackgroundCubeMaterial",uniforms:cloneUniforms(ShaderLib.cube.uniforms),vertexShader:ShaderLib.cube.vertexShader,fragmentShader:ShaderLib.cube.fragmentShader,side:1,depthTest:!1,depthWrite:!1,fog:!1})),boxMesh.geometry.deleteAttribute("normal"),boxMesh.geometry.deleteAttribute("uv"),boxMesh.onBeforeRender=function(renderer,scene,camera){this.matrixWorld.copyPosition(camera.matrixWorld)},Object.defineProperty(boxMesh.material,"envMap",{get:function(){return this.uniforms.envMap.value}}),objects.update(boxMesh));const texture=background.isWebGLCubeRenderTarget?background.texture:background;boxMesh.material.uniforms.envMap.value=texture,boxMesh.material.uniforms.flipEnvMap.value=texture.isCubeTexture?-1:1,currentBackground===background&&currentBackgroundVersion===texture.version&&currentTonemapping===renderer.toneMapping||(boxMesh.material.needsUpdate=!0,currentBackground=background,currentBackgroundVersion=texture.version,currentTonemapping=renderer.toneMapping),renderList.unshift(boxMesh,boxMesh.geometry,boxMesh.material,0,0,null)}else background&&background.isTexture&&(void 0===planeMesh&&(planeMesh=new Mesh(new PlaneBufferGeometry(2,2),new ShaderMaterial({name:"BackgroundMaterial",uniforms:cloneUniforms(ShaderLib.background.uniforms),vertexShader:ShaderLib.background.vertexShader,fragmentShader:ShaderLib.background.fragmentShader,side:0,depthTest:!1,depthWrite:!1,fog:!1})),planeMesh.geometry.deleteAttribute("normal"),Object.defineProperty(planeMesh.material,"map",{get:function(){return this.uniforms.t2D.value}}),objects.update(planeMesh)),planeMesh.material.uniforms.t2D.value=background,!0===background.matrixAutoUpdate&&background.updateMatrix(),planeMesh.material.uniforms.uvTransform.value.copy(background.matrix),currentBackground===background&&currentBackgroundVersion===background.version&&currentTonemapping===renderer.toneMapping||(planeMesh.material.needsUpdate=!0,currentBackground=background,currentBackgroundVersion=background.version,currentTonemapping=renderer.toneMapping),renderList.unshift(planeMesh,planeMesh.geometry,planeMesh.material,0,0,null))}}}function WebGLBindingStates(gl,extensions,attributes,capabilities){const maxVertexAttributes=gl.getParameter(34921),extension=capabilities.isWebGL2?null:extensions.get("OES_vertex_array_object"),vaoAvailable=capabilities.isWebGL2||null!==extension,bindingStates={},defaultState=createBindingState(null);let currentState=defaultState;function bindVertexArrayObject(vao){return capabilities.isWebGL2?gl.bindVertexArray(vao):extension.bindVertexArrayOES(vao)}function deleteVertexArrayObject(vao){return capabilities.isWebGL2?gl.deleteVertexArray(vao):extension.deleteVertexArrayOES(vao)}function createBindingState(vao){const newAttributes=[],enabledAttributes=[],attributeDivisors=[];for(let i=0;i<maxVertexAttributes;i++)newAttributes[i]=0,enabledAttributes[i]=0,attributeDivisors[i]=0;return{geometry:null,program:null,wireframe:!1,newAttributes,enabledAttributes,attributeDivisors,object:vao,attributes:{}}}function initAttributes(){const newAttributes=currentState.newAttributes;for(let i=0,il=newAttributes.length;i<il;i++)newAttributes[i]=0}function enableAttribute(attribute){enableAttributeAndDivisor(attribute,0)}function enableAttributeAndDivisor(attribute,meshPerAttribute){const newAttributes=currentState.newAttributes,enabledAttributes=currentState.enabledAttributes,attributeDivisors=currentState.attributeDivisors;if(newAttributes[attribute]=1,0===enabledAttributes[attribute]&&(gl.enableVertexAttribArray(attribute),enabledAttributes[attribute]=1),attributeDivisors[attribute]!==meshPerAttribute){(capabilities.isWebGL2?gl:extensions.get("ANGLE_instanced_arrays"))[capabilities.isWebGL2?"vertexAttribDivisor":"vertexAttribDivisorANGLE"](attribute,meshPerAttribute),attributeDivisors[attribute]=meshPerAttribute}}function disableUnusedAttributes(){const newAttributes=currentState.newAttributes,enabledAttributes=currentState.enabledAttributes;for(let i=0,il=enabledAttributes.length;i<il;i++)enabledAttributes[i]!==newAttributes[i]&&(gl.disableVertexAttribArray(i),enabledAttributes[i]=0)}function vertexAttribPointer(index,size,type,normalized,stride,offset){!0!==capabilities.isWebGL2||5124!==type&&5125!==type?gl.vertexAttribPointer(index,size,type,normalized,stride,offset):gl.vertexAttribIPointer(index,size,type,stride,offset)}function reset(){resetDefaultState(),currentState!==defaultState&&(currentState=defaultState,bindVertexArrayObject(currentState.object))}function resetDefaultState(){defaultState.geometry=null,defaultState.program=null,defaultState.wireframe=!1}return{setup:function(object,material,program,geometry,index){let updateBuffers=!1;if(vaoAvailable){const state=function(geometry,program,material){const wireframe=!0===material.wireframe;let programMap=bindingStates[geometry.id];void 0===programMap&&(programMap={},bindingStates[geometry.id]=programMap);let stateMap=programMap[program.id];void 0===stateMap&&(stateMap={},programMap[program.id]=stateMap);let state=stateMap[wireframe];void 0===state&&(state=createBindingState(capabilities.isWebGL2?gl.createVertexArray():extension.createVertexArrayOES()),stateMap[wireframe]=state);return state}(geometry,program,material);currentState!==state&&(currentState=state,bindVertexArrayObject(currentState.object)),updateBuffers=function(geometry){const cachedAttributes=currentState.attributes,geometryAttributes=geometry.attributes;if(Object.keys(cachedAttributes).length!==Object.keys(geometryAttributes).length)return!0;for(const key in geometryAttributes){const cachedAttribute=cachedAttributes[key],geometryAttribute=geometryAttributes[key];if(cachedAttribute.attribute!==geometryAttribute)return!0;if(cachedAttribute.data!==geometryAttribute.data)return!0}return!1}(geometry),updateBuffers&&function(geometry){const cache={},attributes=geometry.attributes;for(const key in attributes){const attribute=attributes[key],data={};data.attribute=attribute,attribute.data&&(data.data=attribute.data),cache[key]=data}currentState.attributes=cache}(geometry)}else{const wireframe=!0===material.wireframe;currentState.geometry===geometry.id&&currentState.program===program.id&&currentState.wireframe===wireframe||(currentState.geometry=geometry.id,currentState.program=program.id,currentState.wireframe=wireframe,updateBuffers=!0)}!0===object.isInstancedMesh&&(updateBuffers=!0),null!==index&&attributes.update(index,34963),updateBuffers&&(!function(object,material,program,geometry){if(!1===capabilities.isWebGL2&&(object.isInstancedMesh||geometry.isInstancedBufferGeometry)&&null===extensions.get("ANGLE_instanced_arrays"))return;initAttributes();const geometryAttributes=geometry.attributes,programAttributes=program.getAttributes(),materialDefaultAttributeValues=material.defaultAttributeValues;for(const name in programAttributes){const programAttribute=programAttributes[name];if(programAttribute>=0){const geometryAttribute=geometryAttributes[name];if(void 0!==geometryAttribute){const normalized=geometryAttribute.normalized,size=geometryAttribute.itemSize,attribute=attributes.get(geometryAttribute);if(void 0===attribute)continue;const buffer=attribute.buffer,type=attribute.type,bytesPerElement=attribute.bytesPerElement;if(geometryAttribute.isInterleavedBufferAttribute){const data=geometryAttribute.data,stride=data.stride,offset=geometryAttribute.offset;data&&data.isInstancedInterleavedBuffer?(enableAttributeAndDivisor(programAttribute,data.meshPerAttribute),void 0===geometry._maxInstanceCount&&(geometry._maxInstanceCount=data.meshPerAttribute*data.count)):enableAttribute(programAttribute),gl.bindBuffer(34962,buffer),vertexAttribPointer(programAttribute,size,type,normalized,stride*bytesPerElement,offset*bytesPerElement)}else geometryAttribute.isInstancedBufferAttribute?(enableAttributeAndDivisor(programAttribute,geometryAttribute.meshPerAttribute),void 0===geometry._maxInstanceCount&&(geometry._maxInstanceCount=geometryAttribute.meshPerAttribute*geometryAttribute.count)):enableAttribute(programAttribute),gl.bindBuffer(34962,buffer),vertexAttribPointer(programAttribute,size,type,normalized,0,0)}else if("instanceMatrix"===name){const attribute=attributes.get(object.instanceMatrix);if(void 0===attribute)continue;const buffer=attribute.buffer,type=attribute.type;enableAttributeAndDivisor(programAttribute+0,1),enableAttributeAndDivisor(programAttribute+1,1),enableAttributeAndDivisor(programAttribute+2,1),enableAttributeAndDivisor(programAttribute+3,1),gl.bindBuffer(34962,buffer),gl.vertexAttribPointer(programAttribute+0,4,type,!1,64,0),gl.vertexAttribPointer(programAttribute+1,4,type,!1,64,16),gl.vertexAttribPointer(programAttribute+2,4,type,!1,64,32),gl.vertexAttribPointer(programAttribute+3,4,type,!1,64,48)}else if(void 0!==materialDefaultAttributeValues){const value=materialDefaultAttributeValues[name];if(void 0!==value)switch(value.length){case 2:gl.vertexAttrib2fv(programAttribute,value);break;case 3:gl.vertexAttrib3fv(programAttribute,value);break;case 4:gl.vertexAttrib4fv(programAttribute,value);break;default:gl.vertexAttrib1fv(programAttribute,value)}}}}disableUnusedAttributes()}(object,material,program,geometry),null!==index&&gl.bindBuffer(34963,attributes.get(index).buffer))},reset,resetDefaultState,dispose:function(){reset();for(const geometryId in bindingStates){const programMap=bindingStates[geometryId];for(const programId in programMap){const stateMap=programMap[programId];for(const wireframe in stateMap)deleteVertexArrayObject(stateMap[wireframe].object),delete stateMap[wireframe];delete programMap[programId]}delete bindingStates[geometryId]}},releaseStatesOfGeometry:function(geometry){if(void 0===bindingStates[geometry.id])return;const programMap=bindingStates[geometry.id];for(const programId in programMap){const stateMap=programMap[programId];for(const wireframe in stateMap)deleteVertexArrayObject(stateMap[wireframe].object),delete stateMap[wireframe];delete programMap[programId]}delete bindingStates[geometry.id]},releaseStatesOfProgram:function(program){for(const geometryId in bindingStates){const programMap=bindingStates[geometryId];if(void 0===programMap[program.id])continue;const stateMap=programMap[program.id];for(const wireframe in stateMap)deleteVertexArrayObject(stateMap[wireframe].object),delete stateMap[wireframe];delete programMap[program.id]}},initAttributes,enableAttribute,disableUnusedAttributes}}function WebGLBufferRenderer(gl,extensions,info,capabilities){const isWebGL2=capabilities.isWebGL2;let mode;this.setMode=function(value){mode=value},this.render=function(start,count){gl.drawArrays(mode,start,count),info.update(count,mode,1)},this.renderInstances=function(start,count,primcount){if(0===primcount)return;let extension,methodName;if(isWebGL2)extension=gl,methodName="drawArraysInstanced";else if(extension=extensions.get("ANGLE_instanced_arrays"),methodName="drawArraysInstancedANGLE",null===extension)return void console.error("THREE.WebGLBufferRenderer: using THREE.InstancedBufferGeometry but hardware does not support extension ANGLE_instanced_arrays.");extension[methodName](mode,start,count,primcount),info.update(count,mode,primcount)}}function WebGLCapabilities(gl,extensions,parameters){let maxAnisotropy;function getMaxPrecision(precision){if("highp"===precision){if(gl.getShaderPrecisionFormat(35633,36338).precision>0&&gl.getShaderPrecisionFormat(35632,36338).precision>0)return"highp";precision="mediump"}return"mediump"===precision&&gl.getShaderPrecisionFormat(35633,36337).precision>0&&gl.getShaderPrecisionFormat(35632,36337).precision>0?"mediump":"lowp"}const isWebGL2="undefined"!=typeof WebGL2RenderingContext&&gl instanceof WebGL2RenderingContext||"undefined"!=typeof WebGL2ComputeRenderingContext&&gl instanceof WebGL2ComputeRenderingContext;let precision=void 0!==parameters.precision?parameters.precision:"highp";const maxPrecision=getMaxPrecision(precision);maxPrecision!==precision&&(console.warn("THREE.WebGLRenderer:",precision,"not supported, using",maxPrecision,"instead."),precision=maxPrecision);const logarithmicDepthBuffer=!0===parameters.logarithmicDepthBuffer,maxTextures=gl.getParameter(34930),maxVertexTextures=gl.getParameter(35660),maxTextureSize=gl.getParameter(3379),maxCubemapSize=gl.getParameter(34076),maxAttributes=gl.getParameter(34921),maxVertexUniforms=gl.getParameter(36347),maxVaryings=gl.getParameter(36348),maxFragmentUniforms=gl.getParameter(36349),vertexTextures=maxVertexTextures>0,floatFragmentTextures=isWebGL2||!!extensions.get("OES_texture_float");return{isWebGL2,getMaxAnisotropy:function(){if(void 0!==maxAnisotropy)return maxAnisotropy;const extension=extensions.get("EXT_texture_filter_anisotropic");return maxAnisotropy=null!==extension?gl.getParameter(extension.MAX_TEXTURE_MAX_ANISOTROPY_EXT):0,maxAnisotropy},getMaxPrecision,precision,logarithmicDepthBuffer,maxTextures,maxVertexTextures,maxTextureSize,maxCubemapSize,maxAttributes,maxVertexUniforms,maxVaryings,maxFragmentUniforms,vertexTextures,floatFragmentTextures,floatVertexTextures:vertexTextures&&floatFragmentTextures,maxSamples:isWebGL2?gl.getParameter(36183):0}}function WebGLClipping(){const scope=this;let globalState=null,numGlobalPlanes=0,localClippingEnabled=!1,renderingShadows=!1;const plane=new Plane,viewNormalMatrix=new Matrix3,uniform={value:null,needsUpdate:!1};function resetGlobalState(){uniform.value!==globalState&&(uniform.value=globalState,uniform.needsUpdate=numGlobalPlanes>0),scope.numPlanes=numGlobalPlanes,scope.numIntersection=0}function projectPlanes(planes,camera,dstOffset,skipTransform){let nPlanes=null!==planes?planes.length:0,dstArray=null;if(0!==nPlanes){if(dstArray=uniform.value,!0!==skipTransform||null===dstArray){const flatSize=dstOffset+4*nPlanes,viewMatrix=camera.matrixWorldInverse;viewNormalMatrix.getNormalMatrix(viewMatrix),(null===dstArray||dstArray.length<flatSize)&&(dstArray=new Float32Array(flatSize));for(let i=0,i4=dstOffset;i!==nPlanes;++i,i4+=4)plane.copy(planes[i]).applyMatrix4(viewMatrix,viewNormalMatrix),plane.normal.toArray(dstArray,i4),dstArray[i4+3]=plane.constant}uniform.value=dstArray,uniform.needsUpdate=!0}return scope.numPlanes=nPlanes,scope.numIntersection=0,dstArray}this.uniform=uniform,this.numPlanes=0,this.numIntersection=0,this.init=function(planes,enableLocalClipping,camera){const enabled=0!==planes.length||enableLocalClipping||0!==numGlobalPlanes||localClippingEnabled;return localClippingEnabled=enableLocalClipping,globalState=projectPlanes(planes,camera,0),numGlobalPlanes=planes.length,enabled},this.beginShadows=function(){renderingShadows=!0,projectPlanes(null)},this.endShadows=function(){renderingShadows=!1,resetGlobalState()},this.setState=function(planes,clipIntersection,clipShadows,camera,cache,fromCache){if(!localClippingEnabled||null===planes||0===planes.length||renderingShadows&&!clipShadows)renderingShadows?projectPlanes(null):resetGlobalState();else{const nGlobal=renderingShadows?0:numGlobalPlanes,lGlobal=4*nGlobal;let dstArray=cache.clippingState||null;uniform.value=dstArray,dstArray=projectPlanes(planes,camera,lGlobal,fromCache);for(let i=0;i!==lGlobal;++i)dstArray[i]=globalState[i];cache.clippingState=dstArray,this.numIntersection=clipIntersection?this.numPlanes:0,this.numPlanes+=nGlobal}}}function WebGLExtensions(gl){const extensions={};return{has:function(name){if(void 0!==extensions[name])return extensions[name];let extension;switch(name){case"WEBGL_depth_texture":extension=gl.getExtension("WEBGL_depth_texture")||gl.getExtension("MOZ_WEBGL_depth_texture")||gl.getExtension("WEBKIT_WEBGL_depth_texture");break;case"EXT_texture_filter_anisotropic":extension=gl.getExtension("EXT_texture_filter_anisotropic")||gl.getExtension("MOZ_EXT_texture_filter_anisotropic")||gl.getExtension("WEBKIT_EXT_texture_filter_anisotropic");break;case"WEBGL_compressed_texture_s3tc":extension=gl.getExtension("WEBGL_compressed_texture_s3tc")||gl.getExtension("MOZ_WEBGL_compressed_texture_s3tc")||gl.getExtension("WEBKIT_WEBGL_compressed_texture_s3tc");break;case"WEBGL_compressed_texture_pvrtc":extension=gl.getExtension("WEBGL_compressed_texture_pvrtc")||gl.getExtension("WEBKIT_WEBGL_compressed_texture_pvrtc");break;default:extension=gl.getExtension(name)}return extensions[name]=extension,!!extension},get:function(name){return this.has(name)||console.warn("THREE.WebGLRenderer: "+name+" extension not supported."),extensions[name]}}}function WebGLGeometries(gl,attributes,info,bindingStates){const geometries=new WeakMap,wireframeAttributes=new WeakMap;function onGeometryDispose(event){const geometry=event.target,buffergeometry=geometries.get(geometry);null!==buffergeometry.index&&attributes.remove(buffergeometry.index);for(const name in buffergeometry.attributes)attributes.remove(buffergeometry.attributes[name]);geometry.removeEventListener("dispose",onGeometryDispose),geometries.delete(geometry);const attribute=wireframeAttributes.get(buffergeometry);attribute&&(attributes.remove(attribute),wireframeAttributes.delete(buffergeometry)),bindingStates.releaseStatesOfGeometry(geometry),!0===geometry.isInstancedBufferGeometry&&delete geometry._maxInstanceCount,info.memory.geometries--}function updateWireframeAttribute(geometry){const indices=[],geometryIndex=geometry.index,geometryPosition=geometry.attributes.position;let version=0;if(null!==geometryIndex){const array=geometryIndex.array;version=geometryIndex.version;for(let i=0,l=array.length;i<l;i+=3){const a=array[i+0],b=array[i+1],c=array[i+2];indices.push(a,b,b,c,c,a)}}else{const array=geometryPosition.array;version=geometryPosition.version;for(let i=0,l=array.length/3-1;i<l;i+=3){const a=i+0,b=i+1,c=i+2;indices.push(a,b,b,c,c,a)}}const attribute=new(arrayMax(indices)>65535?Uint32BufferAttribute:Uint16BufferAttribute)(indices,1);attribute.version=version;const previousAttribute=wireframeAttributes.get(geometry);previousAttribute&&attributes.remove(previousAttribute),wireframeAttributes.set(geometry,attribute)}return{get:function(object,geometry){let buffergeometry=geometries.get(geometry);return buffergeometry||(geometry.addEventListener("dispose",onGeometryDispose),geometry.isBufferGeometry?buffergeometry=geometry:geometry.isGeometry&&(void 0===geometry._bufferGeometry&&(geometry._bufferGeometry=(new BufferGeometry).setFromObject(object)),buffergeometry=geometry._bufferGeometry),geometries.set(geometry,buffergeometry),info.memory.geometries++,buffergeometry)},update:function(geometry){const geometryAttributes=geometry.attributes;for(const name in geometryAttributes)attributes.update(geometryAttributes[name],34962);const morphAttributes=geometry.morphAttributes;for(const name in morphAttributes){const array=morphAttributes[name];for(let i=0,l=array.length;i<l;i++)attributes.update(array[i],34962)}},getWireframeAttribute:function(geometry){const currentAttribute=wireframeAttributes.get(geometry);if(currentAttribute){const geometryIndex=geometry.index;null!==geometryIndex&&currentAttribute.version<geometryIndex.version&&updateWireframeAttribute(geometry)}else updateWireframeAttribute(geometry);return wireframeAttributes.get(geometry)}}}function WebGLIndexedBufferRenderer(gl,extensions,info,capabilities){const isWebGL2=capabilities.isWebGL2;let mode,type,bytesPerElement;this.setMode=function(value){mode=value},this.setIndex=function(value){type=value.type,bytesPerElement=value.bytesPerElement},this.render=function(start,count){gl.drawElements(mode,count,type,start*bytesPerElement),info.update(count,mode,1)},this.renderInstances=function(start,count,primcount){if(0===primcount)return;let extension,methodName;if(isWebGL2)extension=gl,methodName="drawElementsInstanced";else if(extension=extensions.get("ANGLE_instanced_arrays"),methodName="drawElementsInstancedANGLE",null===extension)return void console.error("THREE.WebGLIndexedBufferRenderer: using THREE.InstancedBufferGeometry but hardware does not support extension ANGLE_instanced_arrays.");extension[methodName](mode,count,type,start*bytesPerElement,primcount),info.update(count,mode,primcount)}}function WebGLInfo(gl){const render={frame:0,calls:0,triangles:0,points:0,lines:0};return{memory:{geometries:0,textures:0},render,programs:null,autoReset:!0,reset:function(){render.frame++,render.calls=0,render.triangles=0,render.points=0,render.lines=0},update:function(count,mode,instanceCount){switch(render.calls++,mode){case 4:render.triangles+=instanceCount*(count/3);break;case 1:render.lines+=instanceCount*(count/2);break;case 3:render.lines+=instanceCount*(count-1);break;case 2:render.lines+=instanceCount*count;break;case 0:render.points+=instanceCount*count;break;default:console.error("THREE.WebGLInfo: Unknown draw mode:",mode)}}}}function numericalSort(a,b){return a[0]-b[0]}function absNumericalSort(a,b){return Math.abs(b[1])-Math.abs(a[1])}function WebGLMorphtargets(gl){const influencesList={},morphInfluences=new Float32Array(8),workInfluences=[];for(let i=0;i<8;i++)workInfluences[i]=[i,0];return{update:function(object,geometry,material,program){const objectInfluences=object.morphTargetInfluences,length=void 0===objectInfluences?0:objectInfluences.length;let influences=influencesList[geometry.id];if(void 0===influences){influences=[];for(let i=0;i<length;i++)influences[i]=[i,0];influencesList[geometry.id]=influences}for(let i=0;i<length;i++){const influence=influences[i];influence[0]=i,influence[1]=objectInfluences[i]}influences.sort(absNumericalSort);for(let i=0;i<8;i++)i<length&&influences[i][1]?(workInfluences[i][0]=influences[i][0],workInfluences[i][1]=influences[i][1]):(workInfluences[i][0]=Number.MAX_SAFE_INTEGER,workInfluences[i][1]=0);workInfluences.sort(numericalSort);const morphTargets=material.morphTargets&&geometry.morphAttributes.position,morphNormals=material.morphNormals&&geometry.morphAttributes.normal;let morphInfluencesSum=0;for(let i=0;i<8;i++){const influence=workInfluences[i],index=influence[0],value=influence[1];index!==Number.MAX_SAFE_INTEGER&&value?(morphTargets&&geometry.getAttribute("morphTarget"+i)!==morphTargets[index]&&geometry.setAttribute("morphTarget"+i,morphTargets[index]),morphNormals&&geometry.getAttribute("morphNormal"+i)!==morphNormals[index]&&geometry.setAttribute("morphNormal"+i,morphNormals[index]),morphInfluences[i]=value,morphInfluencesSum+=value):(morphTargets&&void 0!==geometry.getAttribute("morphTarget"+i)&&geometry.deleteAttribute("morphTarget"+i),morphNormals&&void 0!==geometry.getAttribute("morphNormal"+i)&&geometry.deleteAttribute("morphNormal"+i),morphInfluences[i]=0)}const morphBaseInfluence=geometry.morphTargetsRelative?1:1-morphInfluencesSum;program.getUniforms().setValue(gl,"morphTargetBaseInfluence",morphBaseInfluence),program.getUniforms().setValue(gl,"morphTargetInfluences",morphInfluences)}}}function WebGLObjects(gl,geometries,attributes,info){let updateMap=new WeakMap;return{update:function(object){const frame=info.render.frame,geometry=object.geometry,buffergeometry=geometries.get(object,geometry);return updateMap.get(buffergeometry)!==frame&&(geometry.isGeometry&&buffergeometry.updateFromObject(object),geometries.update(buffergeometry),updateMap.set(buffergeometry,frame)),object.isInstancedMesh&&attributes.update(object.instanceMatrix,34962),buffergeometry},dispose:function(){updateMap=new WeakMap}}}function CubeTexture(images,mapping,wrapS,wrapT,magFilter,minFilter,format,type,anisotropy,encoding){images=void 0!==images?images:[],mapping=void 0!==mapping?mapping:301,format=void 0!==format?format:1022,Texture.call(this,images,mapping,wrapS,wrapT,magFilter,minFilter,format,type,anisotropy,encoding),this.flipY=!1}function DataTexture2DArray(data,width,height,depth){Texture.call(this,null),this.image={data:data||null,width:width||1,height:height||1,depth:depth||1},this.magFilter=1003,this.minFilter=1003,this.wrapR=1001,this.generateMipmaps=!1,this.flipY=!1,this.needsUpdate=!0}function DataTexture3D(data,width,height,depth){Texture.call(this,null),this.image={data:data||null,width:width||1,height:height||1,depth:depth||1},this.magFilter=1003,this.minFilter=1003,this.wrapR=1001,this.generateMipmaps=!1,this.flipY=!1,this.needsUpdate=!0}ShaderLib.physical={uniforms:mergeUniforms([ShaderLib.standard.uniforms,{clearcoat:{value:0},clearcoatMap:{value:null},clearcoatRoughness:{value:0},clearcoatRoughnessMap:{value:null},clearcoatNormalScale:{value:new Vector2(1,1)},clearcoatNormalMap:{value:null},sheen:{value:new Color(0)},transmission:{value:0},transmissionMap:{value:null}}]),vertexShader:ShaderChunk.meshphysical_vert,fragmentShader:ShaderChunk.meshphysical_frag},CubeTexture.prototype=Object.create(Texture.prototype),CubeTexture.prototype.constructor=CubeTexture,CubeTexture.prototype.isCubeTexture=!0,Object.defineProperty(CubeTexture.prototype,"images",{get:function(){return this.image},set:function(value){this.image=value}}),DataTexture2DArray.prototype=Object.create(Texture.prototype),DataTexture2DArray.prototype.constructor=DataTexture2DArray,DataTexture2DArray.prototype.isDataTexture2DArray=!0,DataTexture3D.prototype=Object.create(Texture.prototype),DataTexture3D.prototype.constructor=DataTexture3D,DataTexture3D.prototype.isDataTexture3D=!0;const emptyTexture=new Texture,emptyTexture2dArray=new DataTexture2DArray,emptyTexture3d=new DataTexture3D,emptyCubeTexture=new CubeTexture,arrayCacheF32=[],arrayCacheI32=[],mat4array=new Float32Array(16),mat3array=new Float32Array(9),mat2array=new Float32Array(4);function flatten(array,nBlocks,blockSize){const firstElem=array[0];if(firstElem<=0||firstElem>0)return array;let n=nBlocks*blockSize,r=arrayCacheF32[n];if(void 0===r&&(r=new Float32Array(n),arrayCacheF32[n]=r),0!==nBlocks){firstElem.toArray(r,0);for(let i=1,offset=0;i!==nBlocks;++i)offset+=blockSize,array[i].toArray(r,offset)}return r}function arraysEqual(a,b){if(a.length!==b.length)return!1;for(let i=0,l=a.length;i<l;i++)if(a[i]!==b[i])return!1;return!0}function copyArray(a,b){for(let i=0,l=b.length;i<l;i++)a[i]=b[i]}function allocTexUnits(textures,n){let r=arrayCacheI32[n];void 0===r&&(r=new Int32Array(n),arrayCacheI32[n]=r);for(let i=0;i!==n;++i)r[i]=textures.allocateTextureUnit();return r}function setValueV1f(gl,v){const cache=this.cache;cache[0]!==v&&(gl.uniform1f(this.addr,v),cache[0]=v)}function setValueV2f(gl,v){const cache=this.cache;if(void 0!==v.x)cache[0]===v.x&&cache[1]===v.y||(gl.uniform2f(this.addr,v.x,v.y),cache[0]=v.x,cache[1]=v.y);else{if(arraysEqual(cache,v))return;gl.uniform2fv(this.addr,v),copyArray(cache,v)}}function setValueV3f(gl,v){const cache=this.cache;if(void 0!==v.x)cache[0]===v.x&&cache[1]===v.y&&cache[2]===v.z||(gl.uniform3f(this.addr,v.x,v.y,v.z),cache[0]=v.x,cache[1]=v.y,cache[2]=v.z);else if(void 0!==v.r)cache[0]===v.r&&cache[1]===v.g&&cache[2]===v.b||(gl.uniform3f(this.addr,v.r,v.g,v.b),cache[0]=v.r,cache[1]=v.g,cache[2]=v.b);else{if(arraysEqual(cache,v))return;gl.uniform3fv(this.addr,v),copyArray(cache,v)}}function setValueV4f(gl,v){const cache=this.cache;if(void 0!==v.x)cache[0]===v.x&&cache[1]===v.y&&cache[2]===v.z&&cache[3]===v.w||(gl.uniform4f(this.addr,v.x,v.y,v.z,v.w),cache[0]=v.x,cache[1]=v.y,cache[2]=v.z,cache[3]=v.w);else{if(arraysEqual(cache,v))return;gl.uniform4fv(this.addr,v),copyArray(cache,v)}}function setValueM2(gl,v){const cache=this.cache,elements=v.elements;if(void 0===elements){if(arraysEqual(cache,v))return;gl.uniformMatrix2fv(this.addr,!1,v),copyArray(cache,v)}else{if(arraysEqual(cache,elements))return;mat2array.set(elements),gl.uniformMatrix2fv(this.addr,!1,mat2array),copyArray(cache,elements)}}function setValueM3(gl,v){const cache=this.cache,elements=v.elements;if(void 0===elements){if(arraysEqual(cache,v))return;gl.uniformMatrix3fv(this.addr,!1,v),copyArray(cache,v)}else{if(arraysEqual(cache,elements))return;mat3array.set(elements),gl.uniformMatrix3fv(this.addr,!1,mat3array),copyArray(cache,elements)}}function setValueM4(gl,v){const cache=this.cache,elements=v.elements;if(void 0===elements){if(arraysEqual(cache,v))return;gl.uniformMatrix4fv(this.addr,!1,v),copyArray(cache,v)}else{if(arraysEqual(cache,elements))return;mat4array.set(elements),gl.uniformMatrix4fv(this.addr,!1,mat4array),copyArray(cache,elements)}}function setValueT1(gl,v,textures){const cache=this.cache,unit=textures.allocateTextureUnit();cache[0]!==unit&&(gl.uniform1i(this.addr,unit),cache[0]=unit),textures.safeSetTexture2D(v||emptyTexture,unit)}function setValueT2DArray1(gl,v,textures){const cache=this.cache,unit=textures.allocateTextureUnit();cache[0]!==unit&&(gl.uniform1i(this.addr,unit),cache[0]=unit),textures.setTexture2DArray(v||emptyTexture2dArray,unit)}function setValueT3D1(gl,v,textures){const cache=this.cache,unit=textures.allocateTextureUnit();cache[0]!==unit&&(gl.uniform1i(this.addr,unit),cache[0]=unit),textures.setTexture3D(v||emptyTexture3d,unit)}function setValueT6(gl,v,textures){const cache=this.cache,unit=textures.allocateTextureUnit();cache[0]!==unit&&(gl.uniform1i(this.addr,unit),cache[0]=unit),textures.safeSetTextureCube(v||emptyCubeTexture,unit)}function setValueV1i(gl,v){const cache=this.cache;cache[0]!==v&&(gl.uniform1i(this.addr,v),cache[0]=v)}function setValueV2i(gl,v){const cache=this.cache;arraysEqual(cache,v)||(gl.uniform2iv(this.addr,v),copyArray(cache,v))}function setValueV3i(gl,v){const cache=this.cache;arraysEqual(cache,v)||(gl.uniform3iv(this.addr,v),copyArray(cache,v))}function setValueV4i(gl,v){const cache=this.cache;arraysEqual(cache,v)||(gl.uniform4iv(this.addr,v),copyArray(cache,v))}function setValueV1ui(gl,v){const cache=this.cache;cache[0]!==v&&(gl.uniform1ui(this.addr,v),cache[0]=v)}function setValueV1fArray(gl,v){gl.uniform1fv(this.addr,v)}function setValueV1iArray(gl,v){gl.uniform1iv(this.addr,v)}function setValueV2iArray(gl,v){gl.uniform2iv(this.addr,v)}function setValueV3iArray(gl,v){gl.uniform3iv(this.addr,v)}function setValueV4iArray(gl,v){gl.uniform4iv(this.addr,v)}function setValueV2fArray(gl,v){const data=flatten(v,this.size,2);gl.uniform2fv(this.addr,data)}function setValueV3fArray(gl,v){const data=flatten(v,this.size,3);gl.uniform3fv(this.addr,data)}function setValueV4fArray(gl,v){const data=flatten(v,this.size,4);gl.uniform4fv(this.addr,data)}function setValueM2Array(gl,v){const data=flatten(v,this.size,4);gl.uniformMatrix2fv(this.addr,!1,data)}function setValueM3Array(gl,v){const data=flatten(v,this.size,9);gl.uniformMatrix3fv(this.addr,!1,data)}function setValueM4Array(gl,v){const data=flatten(v,this.size,16);gl.uniformMatrix4fv(this.addr,!1,data)}function setValueT1Array(gl,v,textures){const n=v.length,units=allocTexUnits(textures,n);gl.uniform1iv(this.addr,units);for(let i=0;i!==n;++i)textures.safeSetTexture2D(v[i]||emptyTexture,units[i])}function setValueT6Array(gl,v,textures){const n=v.length,units=allocTexUnits(textures,n);gl.uniform1iv(this.addr,units);for(let i=0;i!==n;++i)textures.safeSetTextureCube(v[i]||emptyCubeTexture,units[i])}function SingleUniform(id,activeInfo,addr){this.id=id,this.addr=addr,this.cache=[],this.setValue=function(type){switch(type){case 5126:return setValueV1f;case 35664:return setValueV2f;case 35665:return setValueV3f;case 35666:return setValueV4f;case 35674:return setValueM2;case 35675:return setValueM3;case 35676:return setValueM4;case 5124:case 35670:return setValueV1i;case 35667:case 35671:return setValueV2i;case 35668:case 35672:return setValueV3i;case 35669:case 35673:return setValueV4i;case 5125:return setValueV1ui;case 35678:case 36198:case 36298:case 36306:case 35682:return setValueT1;case 35679:case 36299:case 36307:return setValueT3D1;case 35680:case 36300:case 36308:case 36293:return setValueT6;case 36289:case 36303:case 36311:case 36292:return setValueT2DArray1}}(activeInfo.type)}function PureArrayUniform(id,activeInfo,addr){this.id=id,this.addr=addr,this.cache=[],this.size=activeInfo.size,this.setValue=function(type){switch(type){case 5126:return setValueV1fArray;case 35664:return setValueV2fArray;case 35665:return setValueV3fArray;case 35666:return setValueV4fArray;case 35674:return setValueM2Array;case 35675:return setValueM3Array;case 35676:return setValueM4Array;case 5124:case 35670:return setValueV1iArray;case 35667:case 35671:return setValueV2iArray;case 35668:case 35672:return setValueV3iArray;case 35669:case 35673:return setValueV4iArray;case 35678:case 36198:case 36298:case 36306:case 35682:return setValueT1Array;case 35680:case 36300:case 36308:case 36293:return setValueT6Array}}(activeInfo.type)}function StructuredUniform(id){this.id=id,this.seq=[],this.map={}}PureArrayUniform.prototype.updateCache=function(data){let cache=this.cache;data instanceof Float32Array&&cache.length!==data.length&&(this.cache=new Float32Array(data.length)),copyArray(cache,data)},StructuredUniform.prototype.setValue=function(gl,value,textures){const seq=this.seq;for(let i=0,n=seq.length;i!==n;++i){const u=seq[i];u.setValue(gl,value[u.id],textures)}};const RePathPart=/([\w\d_]+)(\])?(\[|\.)?/g;function addUniform(container,uniformObject){container.seq.push(uniformObject),container.map[uniformObject.id]=uniformObject}function parseUniform(activeInfo,addr,container){const path=activeInfo.name,pathLength=path.length;for(RePathPart.lastIndex=0;;){const match=RePathPart.exec(path),matchEnd=RePathPart.lastIndex;let id=match[1],idIsIndex="]"===match[2],subscript=match[3];if(idIsIndex&&(id|=0),void 0===subscript||"["===subscript&&matchEnd+2===pathLength){addUniform(container,void 0===subscript?new SingleUniform(id,activeInfo,addr):new PureArrayUniform(id,activeInfo,addr));break}{let next=container.map[id];void 0===next&&(next=new StructuredUniform(id),addUniform(container,next)),container=next}}}function WebGLUniforms(gl,program){this.seq=[],this.map={};const n=gl.getProgramParameter(program,35718);for(let i=0;i<n;++i){const info=gl.getActiveUniform(program,i);parseUniform(info,gl.getUniformLocation(program,info.name),this)}}function WebGLShader(gl,type,string){const shader=gl.createShader(type);return gl.shaderSource(shader,string),gl.compileShader(shader),shader}WebGLUniforms.prototype.setValue=function(gl,name,value,textures){const u=this.map[name];void 0!==u&&u.setValue(gl,value,textures)},WebGLUniforms.prototype.setOptional=function(gl,object,name){const v=object[name];void 0!==v&&this.setValue(gl,name,v)},WebGLUniforms.upload=function(gl,seq,values,textures){for(let i=0,n=seq.length;i!==n;++i){const u=seq[i],v=values[u.id];!1!==v.needsUpdate&&u.setValue(gl,v.value,textures)}},WebGLUniforms.seqWithValue=function(seq,values){const r=[];for(let i=0,n=seq.length;i!==n;++i){const u=seq[i];u.id in values&&r.push(u)}return r};let programIdCount=0;function getEncodingComponents(encoding){switch(encoding){case 3e3:return["Linear","( value )"];case 3001:return["sRGB","( value )"];case 3002:return["RGBE","( value )"];case 3004:return["RGBM","( value, 7.0 )"];case 3005:return["RGBM","( value, 16.0 )"];case 3006:return["RGBD","( value, 256.0 )"];case 3007:return["Gamma","( value, float( GAMMA_FACTOR ) )"];case 3003:return["LogLuv","( value )"];default:return console.warn("THREE.WebGLProgram: Unsupported encoding:",encoding),["Linear","( value )"]}}function getShaderErrors(gl,shader,type){const status=gl.getShaderParameter(shader,35713),log=gl.getShaderInfoLog(shader).trim();if(status&&""===log)return"";return"THREE.WebGLShader: gl.getShaderInfoLog() "+type+"\n"+log+function(string){const lines=string.split("\n");for(let i=0;i<lines.length;i++)lines[i]=i+1+": "+lines[i];return lines.join("\n")}(gl.getShaderSource(shader))}function getTexelDecodingFunction(functionName,encoding){const components=getEncodingComponents(encoding);return"vec4 "+functionName+"( vec4 value ) { return "+components[0]+"ToLinear"+components[1]+"; }"}function getTexelEncodingFunction(functionName,encoding){const components=getEncodingComponents(encoding);return"vec4 "+functionName+"( vec4 value ) { return LinearTo"+components[0]+components[1]+"; }"}function getToneMappingFunction(functionName,toneMapping){let toneMappingName;switch(toneMapping){case 1:toneMappingName="Linear";break;case 2:toneMappingName="Reinhard";break;case 3:toneMappingName="OptimizedCineon";break;case 4:toneMappingName="ACESFilmic";break;case 5:toneMappingName="Custom";break;default:console.warn("THREE.WebGLProgram: Unsupported toneMapping:",toneMapping),toneMappingName="Linear"}return"vec3 "+functionName+"( vec3 color ) { return "+toneMappingName+"ToneMapping( color ); }"}function filterEmptyLine(string){return""!==string}function replaceLightNums(string,parameters){return string.replace(/NUM_DIR_LIGHTS/g,parameters.numDirLights).replace(/NUM_SPOT_LIGHTS/g,parameters.numSpotLights).replace(/NUM_RECT_AREA_LIGHTS/g,parameters.numRectAreaLights).replace(/NUM_POINT_LIGHTS/g,parameters.numPointLights).replace(/NUM_HEMI_LIGHTS/g,parameters.numHemiLights).replace(/NUM_DIR_LIGHT_SHADOWS/g,parameters.numDirLightShadows).replace(/NUM_SPOT_LIGHT_SHADOWS/g,parameters.numSpotLightShadows).replace(/NUM_POINT_LIGHT_SHADOWS/g,parameters.numPointLightShadows)}function replaceClippingPlaneNums(string,parameters){return string.replace(/NUM_CLIPPING_PLANES/g,parameters.numClippingPlanes).replace(/UNION_CLIPPING_PLANES/g,parameters.numClippingPlanes-parameters.numClipIntersection)}const includePattern=/^[ \t]*#include +<([\w\d./]+)>/gm;function resolveIncludes(string){return string.replace(includePattern,includeReplacer)}function includeReplacer(match,include){const string=ShaderChunk[include];if(void 0===string)throw new Error("Can not resolve #include <"+include+">");return resolveIncludes(string)}const deprecatedUnrollLoopPattern=/#pragma unroll_loop[\s]+?for \( int i \= (\d+)\; i < (\d+)\; i \+\+ \) \{([\s\S]+?)(?=\})\}/g,unrollLoopPattern=/#pragma unroll_loop_start[\s]+?for \( int i \= (\d+)\; i < (\d+)\; i \+\+ \) \{([\s\S]+?)(?=\})\}[\s]+?#pragma unroll_loop_end/g;function unrollLoops(string){return string.replace(unrollLoopPattern,loopReplacer).replace(deprecatedUnrollLoopPattern,deprecatedLoopReplacer)}function deprecatedLoopReplacer(match,start,end,snippet){return console.warn("WebGLProgram: #pragma unroll_loop shader syntax is deprecated. Please use #pragma unroll_loop_start syntax instead."),loopReplacer(match,start,end,snippet)}function loopReplacer(match,start,end,snippet){let string="";for(let i=parseInt(start);i<parseInt(end);i++)string+=snippet.replace(/\[ i \]/g,"[ "+i+" ]").replace(/UNROLLED_LOOP_INDEX/g,i);return string}function generatePrecision(parameters){let precisionstring="precision "+parameters.precision+" float;\nprecision "+parameters.precision+" int;";return"highp"===parameters.precision?precisionstring+="\n#define HIGH_PRECISION":"mediump"===parameters.precision?precisionstring+="\n#define MEDIUM_PRECISION":"lowp"===parameters.precision&&(precisionstring+="\n#define LOW_PRECISION"),precisionstring}function WebGLProgram(renderer,cacheKey,parameters,bindingStates){const gl=renderer.getContext(),defines=parameters.defines;let vertexShader=parameters.vertexShader,fragmentShader=parameters.fragmentShader;const shadowMapTypeDefine=function(parameters){let shadowMapTypeDefine="SHADOWMAP_TYPE_BASIC";return 1===parameters.shadowMapType?shadowMapTypeDefine="SHADOWMAP_TYPE_PCF":2===parameters.shadowMapType?shadowMapTypeDefine="SHADOWMAP_TYPE_PCF_SOFT":3===parameters.shadowMapType&&(shadowMapTypeDefine="SHADOWMAP_TYPE_VSM"),shadowMapTypeDefine}(parameters),envMapTypeDefine=function(parameters){let envMapTypeDefine="ENVMAP_TYPE_CUBE";if(parameters.envMap)switch(parameters.envMapMode){case 301:case 302:envMapTypeDefine="ENVMAP_TYPE_CUBE";break;case 306:case 307:envMapTypeDefine="ENVMAP_TYPE_CUBE_UV";break;case 303:case 304:envMapTypeDefine="ENVMAP_TYPE_EQUIREC"}return envMapTypeDefine}(parameters),envMapModeDefine=function(parameters){let envMapModeDefine="ENVMAP_MODE_REFLECTION";if(parameters.envMap)switch(parameters.envMapMode){case 302:case 304:case 307:envMapModeDefine="ENVMAP_MODE_REFRACTION"}return envMapModeDefine}(parameters),envMapBlendingDefine=function(parameters){let envMapBlendingDefine="ENVMAP_BLENDING_NONE";if(parameters.envMap)switch(parameters.combine){case 0:envMapBlendingDefine="ENVMAP_BLENDING_MULTIPLY";break;case 1:envMapBlendingDefine="ENVMAP_BLENDING_MIX";break;case 2:envMapBlendingDefine="ENVMAP_BLENDING_ADD"}return envMapBlendingDefine}(parameters),gammaFactorDefine=renderer.gammaFactor>0?renderer.gammaFactor:1,customExtensions=parameters.isWebGL2?"":function(parameters){return[parameters.extensionDerivatives||parameters.envMapCubeUV||parameters.bumpMap||parameters.tangentSpaceNormalMap||parameters.clearcoatNormalMap||parameters.flatShading||"physical"===parameters.shaderID?"#extension GL_OES_standard_derivatives : enable":"",(parameters.extensionFragDepth||parameters.logarithmicDepthBuffer)&&parameters.rendererExtensionFragDepth?"#extension GL_EXT_frag_depth : enable":"",parameters.extensionDrawBuffers&&parameters.rendererExtensionDrawBuffers?"#extension GL_EXT_draw_buffers : require":"",(parameters.extensionShaderTextureLOD||parameters.envMap)&&parameters.rendererExtensionShaderTextureLod?"#extension GL_EXT_shader_texture_lod : enable":""].filter(filterEmptyLine).join("\n")}(parameters),customDefines=function(defines){const chunks=[];for(const name in defines){const value=defines[name];!1!==value&&chunks.push("#define "+name+" "+value)}return chunks.join("\n")}(defines),program=gl.createProgram();let prefixVertex,prefixFragment;parameters.isRawShaderMaterial?(prefixVertex=[customDefines].filter(filterEmptyLine).join("\n"),prefixVertex.length>0&&(prefixVertex+="\n"),prefixFragment=[customExtensions,customDefines].filter(filterEmptyLine).join("\n"),prefixFragment.length>0&&(prefixFragment+="\n")):(prefixVertex=[generatePrecision(parameters),"#define SHADER_NAME "+parameters.shaderName,customDefines,parameters.instancing?"#define USE_INSTANCING":"",parameters.supportsVertexTextures?"#define VERTEX_TEXTURES":"","#define GAMMA_FACTOR "+gammaFactorDefine,"#define MAX_BONES "+parameters.maxBones,parameters.useFog&&parameters.fog?"#define USE_FOG":"",parameters.useFog&&parameters.fogExp2?"#define FOG_EXP2":"",parameters.map?"#define USE_MAP":"",parameters.envMap?"#define USE_ENVMAP":"",parameters.envMap?"#define "+envMapModeDefine:"",parameters.lightMap?"#define USE_LIGHTMAP":"",parameters.aoMap?"#define USE_AOMAP":"",parameters.emissiveMap?"#define USE_EMISSIVEMAP":"",parameters.bumpMap?"#define USE_BUMPMAP":"",parameters.normalMap?"#define USE_NORMALMAP":"",parameters.normalMap&&parameters.objectSpaceNormalMap?"#define OBJECTSPACE_NORMALMAP":"",parameters.normalMap&&parameters.tangentSpaceNormalMap?"#define TANGENTSPACE_NORMALMAP":"",parameters.clearcoatMap?"#define USE_CLEARCOATMAP":"",parameters.clearcoatRoughnessMap?"#define USE_CLEARCOAT_ROUGHNESSMAP":"",parameters.clearcoatNormalMap?"#define USE_CLEARCOAT_NORMALMAP":"",parameters.displacementMap&&parameters.supportsVertexTextures?"#define USE_DISPLACEMENTMAP":"",parameters.specularMap?"#define USE_SPECULARMAP":"",parameters.roughnessMap?"#define USE_ROUGHNESSMAP":"",parameters.metalnessMap?"#define USE_METALNESSMAP":"",parameters.alphaMap?"#define USE_ALPHAMAP":"",parameters.transmissionMap?"#define USE_TRANSMISSIONMAP":"",parameters.vertexTangents?"#define USE_TANGENT":"",parameters.vertexColors?"#define USE_COLOR":"",parameters.vertexUvs?"#define USE_UV":"",parameters.uvsVertexOnly?"#define UVS_VERTEX_ONLY":"",parameters.flatShading?"#define FLAT_SHADED":"",parameters.skinning?"#define USE_SKINNING":"",parameters.useVertexTexture?"#define BONE_TEXTURE":"",parameters.morphTargets?"#define USE_MORPHTARGETS":"",parameters.morphNormals&&!1===parameters.flatShading?"#define USE_MORPHNORMALS":"",parameters.doubleSided?"#define DOUBLE_SIDED":"",parameters.flipSided?"#define FLIP_SIDED":"",parameters.shadowMapEnabled?"#define USE_SHADOWMAP":"",parameters.shadowMapEnabled?"#define "+shadowMapTypeDefine:"",parameters.sizeAttenuation?"#define USE_SIZEATTENUATION":"",parameters.logarithmicDepthBuffer?"#define USE_LOGDEPTHBUF":"",parameters.logarithmicDepthBuffer&&parameters.rendererExtensionFragDepth?"#define USE_LOGDEPTHBUF_EXT":"","uniform mat4 modelMatrix;","uniform mat4 modelViewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 viewMatrix;","uniform mat3 normalMatrix;","uniform vec3 cameraPosition;","uniform bool isOrthographic;","#ifdef USE_INSTANCING"," attribute mat4 instanceMatrix;","#endif","attribute vec3 position;","attribute vec3 normal;","attribute vec2 uv;","#ifdef USE_TANGENT","\tattribute vec4 tangent;","#endif","#ifdef USE_COLOR","\tattribute vec3 color;","#endif","#ifdef USE_MORPHTARGETS","\tattribute vec3 morphTarget0;","\tattribute vec3 morphTarget1;","\tattribute vec3 morphTarget2;","\tattribute vec3 morphTarget3;","\t#ifdef USE_MORPHNORMALS","\t\tattribute vec3 morphNormal0;","\t\tattribute vec3 morphNormal1;","\t\tattribute vec3 morphNormal2;","\t\tattribute vec3 morphNormal3;","\t#else","\t\tattribute vec3 morphTarget4;","\t\tattribute vec3 morphTarget5;","\t\tattribute vec3 morphTarget6;","\t\tattribute vec3 morphTarget7;","\t#endif","#endif","#ifdef USE_SKINNING","\tattribute vec4 skinIndex;","\tattribute vec4 skinWeight;","#endif","\n"].filter(filterEmptyLine).join("\n"),prefixFragment=[customExtensions,generatePrecision(parameters),"#define SHADER_NAME "+parameters.shaderName,customDefines,parameters.alphaTest?"#define ALPHATEST "+parameters.alphaTest+(parameters.alphaTest%1?"":".0"):"","#define GAMMA_FACTOR "+gammaFactorDefine,parameters.useFog&&parameters.fog?"#define USE_FOG":"",parameters.useFog&&parameters.fogExp2?"#define FOG_EXP2":"",parameters.map?"#define USE_MAP":"",parameters.matcap?"#define USE_MATCAP":"",parameters.envMap?"#define USE_ENVMAP":"",parameters.envMap?"#define "+envMapTypeDefine:"",parameters.envMap?"#define "+envMapModeDefine:"",parameters.envMap?"#define "+envMapBlendingDefine:"",parameters.lightMap?"#define USE_LIGHTMAP":"",parameters.aoMap?"#define USE_AOMAP":"",parameters.emissiveMap?"#define USE_EMISSIVEMAP":"",parameters.bumpMap?"#define USE_BUMPMAP":"",parameters.normalMap?"#define USE_NORMALMAP":"",parameters.normalMap&&parameters.objectSpaceNormalMap?"#define OBJECTSPACE_NORMALMAP":"",parameters.normalMap&&parameters.tangentSpaceNormalMap?"#define TANGENTSPACE_NORMALMAP":"",parameters.clearcoatMap?"#define USE_CLEARCOATMAP":"",parameters.clearcoatRoughnessMap?"#define USE_CLEARCOAT_ROUGHNESSMAP":"",parameters.clearcoatNormalMap?"#define USE_CLEARCOAT_NORMALMAP":"",parameters.specularMap?"#define USE_SPECULARMAP":"",parameters.roughnessMap?"#define USE_ROUGHNESSMAP":"",parameters.metalnessMap?"#define USE_METALNESSMAP":"",parameters.alphaMap?"#define USE_ALPHAMAP":"",parameters.sheen?"#define USE_SHEEN":"",parameters.transmissionMap?"#define USE_TRANSMISSIONMAP":"",parameters.vertexTangents?"#define USE_TANGENT":"",parameters.vertexColors?"#define USE_COLOR":"",parameters.vertexUvs?"#define USE_UV":"",parameters.uvsVertexOnly?"#define UVS_VERTEX_ONLY":"",parameters.gradientMap?"#define USE_GRADIENTMAP":"",parameters.flatShading?"#define FLAT_SHADED":"",parameters.doubleSided?"#define DOUBLE_SIDED":"",parameters.flipSided?"#define FLIP_SIDED":"",parameters.shadowMapEnabled?"#define USE_SHADOWMAP":"",parameters.shadowMapEnabled?"#define "+shadowMapTypeDefine:"",parameters.premultipliedAlpha?"#define PREMULTIPLIED_ALPHA":"",parameters.physicallyCorrectLights?"#define PHYSICALLY_CORRECT_LIGHTS":"",parameters.logarithmicDepthBuffer?"#define USE_LOGDEPTHBUF":"",parameters.logarithmicDepthBuffer&&parameters.rendererExtensionFragDepth?"#define USE_LOGDEPTHBUF_EXT":"",(parameters.extensionShaderTextureLOD||parameters.envMap)&&parameters.rendererExtensionShaderTextureLod?"#define TEXTURE_LOD_EXT":"","uniform mat4 viewMatrix;","uniform vec3 cameraPosition;","uniform bool isOrthographic;",0!==parameters.toneMapping?"#define TONE_MAPPING":"",0!==parameters.toneMapping?ShaderChunk.tonemapping_pars_fragment:"",0!==parameters.toneMapping?getToneMappingFunction("toneMapping",parameters.toneMapping):"",parameters.dithering?"#define DITHERING":"",ShaderChunk.encodings_pars_fragment,parameters.map?getTexelDecodingFunction("mapTexelToLinear",parameters.mapEncoding):"",parameters.matcap?getTexelDecodingFunction("matcapTexelToLinear",parameters.matcapEncoding):"",parameters.envMap?getTexelDecodingFunction("envMapTexelToLinear",parameters.envMapEncoding):"",parameters.emissiveMap?getTexelDecodingFunction("emissiveMapTexelToLinear",parameters.emissiveMapEncoding):"",parameters.lightMap?getTexelDecodingFunction("lightMapTexelToLinear",parameters.lightMapEncoding):"",getTexelEncodingFunction("linearToOutputTexel",parameters.outputEncoding),parameters.depthPacking?"#define DEPTH_PACKING "+parameters.depthPacking:"","\n"].filter(filterEmptyLine).join("\n")),vertexShader=resolveIncludes(vertexShader),vertexShader=replaceLightNums(vertexShader,parameters),vertexShader=replaceClippingPlaneNums(vertexShader,parameters),fragmentShader=resolveIncludes(fragmentShader),fragmentShader=replaceLightNums(fragmentShader,parameters),fragmentShader=replaceClippingPlaneNums(fragmentShader,parameters),vertexShader=unrollLoops(vertexShader),fragmentShader=unrollLoops(fragmentShader),parameters.isWebGL2&&!parameters.isRawShaderMaterial&&(prefixVertex=["#version 300 es\n","#define attribute in","#define varying out","#define texture2D texture"].join("\n")+"\n"+prefixVertex,prefixFragment=["#version 300 es\n","#define varying in","out highp vec4 pc_fragColor;","#define gl_FragColor pc_fragColor","#define gl_FragDepthEXT gl_FragDepth","#define texture2D texture","#define textureCube texture","#define texture2DProj textureProj","#define texture2DLodEXT textureLod","#define texture2DProjLodEXT textureProjLod","#define textureCubeLodEXT textureLod","#define texture2DGradEXT textureGrad","#define texture2DProjGradEXT textureProjGrad","#define textureCubeGradEXT textureGrad"].join("\n")+"\n"+prefixFragment);const fragmentGlsl=prefixFragment+fragmentShader,glVertexShader=WebGLShader(gl,35633,prefixVertex+vertexShader),glFragmentShader=WebGLShader(gl,35632,fragmentGlsl);if(gl.attachShader(program,glVertexShader),gl.attachShader(program,glFragmentShader),void 0!==parameters.index0AttributeName?gl.bindAttribLocation(program,0,parameters.index0AttributeName):!0===parameters.morphTargets&&gl.bindAttribLocation(program,0,"position"),gl.linkProgram(program),renderer.debug.checkShaderErrors){const programLog=gl.getProgramInfoLog(program).trim(),vertexLog=gl.getShaderInfoLog(glVertexShader).trim(),fragmentLog=gl.getShaderInfoLog(glFragmentShader).trim();let runnable=!0,haveDiagnostics=!0;if(!1===gl.getProgramParameter(program,35714)){runnable=!1;const vertexErrors=getShaderErrors(gl,glVertexShader,"vertex"),fragmentErrors=getShaderErrors(gl,glFragmentShader,"fragment");console.error("THREE.WebGLProgram: shader error: ",gl.getError(),"35715",gl.getProgramParameter(program,35715),"gl.getProgramInfoLog",programLog,vertexErrors,fragmentErrors)}else""!==programLog?console.warn("THREE.WebGLProgram: gl.getProgramInfoLog()",programLog):""!==vertexLog&&""!==fragmentLog||(haveDiagnostics=!1);haveDiagnostics&&(this.diagnostics={runnable,programLog,vertexShader:{log:vertexLog,prefix:prefixVertex},fragmentShader:{log:fragmentLog,prefix:prefixFragment}})}let cachedUniforms,cachedAttributes;return gl.deleteShader(glVertexShader),gl.deleteShader(glFragmentShader),this.getUniforms=function(){return void 0===cachedUniforms&&(cachedUniforms=new WebGLUniforms(gl,program)),cachedUniforms},this.getAttributes=function(){return void 0===cachedAttributes&&(cachedAttributes=function(gl,program){const attributes={},n=gl.getProgramParameter(program,35721);for(let i=0;i<n;i++){const name=gl.getActiveAttrib(program,i).name;attributes[name]=gl.getAttribLocation(program,name)}return attributes}(gl,program)),cachedAttributes},this.destroy=function(){bindingStates.releaseStatesOfProgram(this),gl.deleteProgram(program),this.program=void 0},this.name=parameters.shaderName,this.id=programIdCount++,this.cacheKey=cacheKey,this.usedTimes=1,this.program=program,this.vertexShader=glVertexShader,this.fragmentShader=glFragmentShader,this}function WebGLPrograms(renderer,extensions,capabilities,bindingStates){const programs=[],isWebGL2=capabilities.isWebGL2,logarithmicDepthBuffer=capabilities.logarithmicDepthBuffer,floatVertexTextures=capabilities.floatVertexTextures,maxVertexUniforms=capabilities.maxVertexUniforms,vertexTextures=capabilities.vertexTextures;let precision=capabilities.precision;const shaderIDs={MeshDepthMaterial:"depth",MeshDistanceMaterial:"distanceRGBA",MeshNormalMaterial:"normal",MeshBasicMaterial:"basic",MeshLambertMaterial:"lambert",MeshPhongMaterial:"phong",MeshToonMaterial:"toon",MeshStandardMaterial:"physical",MeshPhysicalMaterial:"physical",MeshMatcapMaterial:"matcap",LineBasicMaterial:"basic",LineDashedMaterial:"dashed",PointsMaterial:"points",ShadowMaterial:"shadow",SpriteMaterial:"sprite"},parameterNames=["precision","isWebGL2","supportsVertexTextures","outputEncoding","instancing","map","mapEncoding","matcap","matcapEncoding","envMap","envMapMode","envMapEncoding","envMapCubeUV","lightMap","lightMapEncoding","aoMap","emissiveMap","emissiveMapEncoding","bumpMap","normalMap","objectSpaceNormalMap","tangentSpaceNormalMap","clearcoatMap","clearcoatRoughnessMap","clearcoatNormalMap","displacementMap","specularMap","roughnessMap","metalnessMap","gradientMap","alphaMap","combine","vertexColors","vertexTangents","vertexUvs","uvsVertexOnly","fog","useFog","fogExp2","flatShading","sizeAttenuation","logarithmicDepthBuffer","skinning","maxBones","useVertexTexture","morphTargets","morphNormals","maxMorphTargets","maxMorphNormals","premultipliedAlpha","numDirLights","numPointLights","numSpotLights","numHemiLights","numRectAreaLights","numDirLightShadows","numPointLightShadows","numSpotLightShadows","shadowMapEnabled","shadowMapType","toneMapping","physicallyCorrectLights","alphaTest","doubleSided","flipSided","numClippingPlanes","numClipIntersection","depthPacking","dithering","sheen","transmissionMap"];function getTextureEncodingFromMap(map){let encoding;return map?map.isTexture?encoding=map.encoding:map.isWebGLRenderTarget&&(console.warn("THREE.WebGLPrograms.getTextureEncodingFromMap: don't use render targets as textures. Use their .texture property instead."),encoding=map.texture.encoding):encoding=3e3,encoding}return{getParameters:function(material,lights,shadows,scene,nClipPlanes,nClipIntersection,object){const fog=scene.fog,environment=material.isMeshStandardMaterial?scene.environment:null,envMap=material.envMap||environment,shaderID=shaderIDs[material.type],maxBones=object.isSkinnedMesh?function(object){const bones=object.skeleton.bones;if(floatVertexTextures)return 1024;{const nVertexUniforms=maxVertexUniforms,nVertexMatrices=Math.floor((nVertexUniforms-20)/4),maxBones=Math.min(nVertexMatrices,bones.length);return maxBones<bones.length?(console.warn("THREE.WebGLRenderer: Skeleton has "+bones.length+" bones. This GPU supports "+maxBones+"."),0):maxBones}}(object):0;let vertexShader,fragmentShader;if(null!==material.precision&&(precision=capabilities.getMaxPrecision(material.precision),precision!==material.precision&&console.warn("THREE.WebGLProgram.getParameters:",material.precision,"not supported, using",precision,"instead.")),shaderID){const shader=ShaderLib[shaderID];vertexShader=shader.vertexShader,fragmentShader=shader.fragmentShader}else vertexShader=material.vertexShader,fragmentShader=material.fragmentShader;const currentRenderTarget=renderer.getRenderTarget();return{isWebGL2,shaderID,shaderName:material.type,vertexShader,fragmentShader,defines:material.defines,isRawShaderMaterial:material.isRawShaderMaterial,isShaderMaterial:material.isShaderMaterial,precision,instancing:!0===object.isInstancedMesh,supportsVertexTextures:vertexTextures,outputEncoding:null!==currentRenderTarget?getTextureEncodingFromMap(currentRenderTarget.texture):renderer.outputEncoding,map:!!material.map,mapEncoding:getTextureEncodingFromMap(material.map),matcap:!!material.matcap,matcapEncoding:getTextureEncodingFromMap(material.matcap),envMap:!!envMap,envMapMode:envMap&&envMap.mapping,envMapEncoding:getTextureEncodingFromMap(envMap),envMapCubeUV:!!envMap&&(306===envMap.mapping||307===envMap.mapping),lightMap:!!material.lightMap,lightMapEncoding:getTextureEncodingFromMap(material.lightMap),aoMap:!!material.aoMap,emissiveMap:!!material.emissiveMap,emissiveMapEncoding:getTextureEncodingFromMap(material.emissiveMap),bumpMap:!!material.bumpMap,normalMap:!!material.normalMap,objectSpaceNormalMap:1===material.normalMapType,tangentSpaceNormalMap:0===material.normalMapType,clearcoatMap:!!material.clearcoatMap,clearcoatRoughnessMap:!!material.clearcoatRoughnessMap,clearcoatNormalMap:!!material.clearcoatNormalMap,displacementMap:!!material.displacementMap,roughnessMap:!!material.roughnessMap,metalnessMap:!!material.metalnessMap,specularMap:!!material.specularMap,alphaMap:!!material.alphaMap,gradientMap:!!material.gradientMap,sheen:!!material.sheen,transmissionMap:!!material.transmissionMap,combine:material.combine,vertexTangents:material.normalMap&&material.vertexTangents,vertexColors:material.vertexColors,vertexUvs:!!(material.map||material.bumpMap||material.normalMap||material.specularMap||material.alphaMap||material.emissiveMap||material.roughnessMap||material.metalnessMap||material.clearcoatMap||material.clearcoatRoughnessMap||material.clearcoatNormalMap||material.displacementMap||material.transmissionMap),uvsVertexOnly:!(material.map||material.bumpMap||material.normalMap||material.specularMap||material.alphaMap||material.emissiveMap||material.roughnessMap||material.metalnessMap||material.clearcoatNormalMap||material.transmissionMap||!material.displacementMap),fog:!!fog,useFog:material.fog,fogExp2:fog&&fog.isFogExp2,flatShading:material.flatShading,sizeAttenuation:material.sizeAttenuation,logarithmicDepthBuffer,skinning:material.skinning&&maxBones>0,maxBones,useVertexTexture:floatVertexTextures,morphTargets:material.morphTargets,morphNormals:material.morphNormals,maxMorphTargets:renderer.maxMorphTargets,maxMorphNormals:renderer.maxMorphNormals,numDirLights:lights.directional.length,numPointLights:lights.point.length,numSpotLights:lights.spot.length,numRectAreaLights:lights.rectArea.length,numHemiLights:lights.hemi.length,numDirLightShadows:lights.directionalShadowMap.length,numPointLightShadows:lights.pointShadowMap.length,numSpotLightShadows:lights.spotShadowMap.length,numClippingPlanes:nClipPlanes,numClipIntersection:nClipIntersection,dithering:material.dithering,shadowMapEnabled:renderer.shadowMap.enabled&&shadows.length>0,shadowMapType:renderer.shadowMap.type,toneMapping:material.toneMapped?renderer.toneMapping:0,physicallyCorrectLights:renderer.physicallyCorrectLights,premultipliedAlpha:material.premultipliedAlpha,alphaTest:material.alphaTest,doubleSided:2===material.side,flipSided:1===material.side,depthPacking:void 0!==material.depthPacking&&material.depthPacking,index0AttributeName:material.index0AttributeName,extensionDerivatives:material.extensions&&material.extensions.derivatives,extensionFragDepth:material.extensions&&material.extensions.fragDepth,extensionDrawBuffers:material.extensions&&material.extensions.drawBuffers,extensionShaderTextureLOD:material.extensions&&material.extensions.shaderTextureLOD,rendererExtensionFragDepth:isWebGL2||null!==extensions.get("EXT_frag_depth"),rendererExtensionDrawBuffers:isWebGL2||null!==extensions.get("WEBGL_draw_buffers"),rendererExtensionShaderTextureLod:isWebGL2||null!==extensions.get("EXT_shader_texture_lod"),customProgramCacheKey:material.customProgramCacheKey()}},getProgramCacheKey:function(parameters){const array=[];if(parameters.shaderID?array.push(parameters.shaderID):(array.push(parameters.fragmentShader),array.push(parameters.vertexShader)),void 0!==parameters.defines)for(const name in parameters.defines)array.push(name),array.push(parameters.defines[name]);if(void 0===parameters.isRawShaderMaterial){for(let i=0;i<parameterNames.length;i++)array.push(parameters[parameterNames[i]]);array.push(renderer.outputEncoding),array.push(renderer.gammaFactor)}return array.push(parameters.customProgramCacheKey),array.join()},getUniforms:function(material){const shaderID=shaderIDs[material.type];let uniforms;if(shaderID){const shader=ShaderLib[shaderID];uniforms=UniformsUtils.clone(shader.uniforms)}else uniforms=material.uniforms;return uniforms},acquireProgram:function(parameters,cacheKey){let program;for(let p=0,pl=programs.length;p<pl;p++){const preexistingProgram=programs[p];if(preexistingProgram.cacheKey===cacheKey){program=preexistingProgram,++program.usedTimes;break}}return void 0===program&&(program=new WebGLProgram(renderer,cacheKey,parameters,bindingStates),programs.push(program)),program},releaseProgram:function(program){if(0==--program.usedTimes){const i=programs.indexOf(program);programs[i]=programs[programs.length-1],programs.pop(),program.destroy()}},programs}}function WebGLProperties(){let properties=new WeakMap;return{get:function(object){let map=properties.get(object);return void 0===map&&(map={},properties.set(object,map)),map},remove:function(object){properties.delete(object)},update:function(object,key,value){properties.get(object)[key]=value},dispose:function(){properties=new WeakMap}}}function painterSortStable(a,b){return a.groupOrder!==b.groupOrder?a.groupOrder-b.groupOrder:a.renderOrder!==b.renderOrder?a.renderOrder-b.renderOrder:a.program!==b.program?a.program.id-b.program.id:a.material.id!==b.material.id?a.material.id-b.material.id:a.z!==b.z?a.z-b.z:a.id-b.id}function reversePainterSortStable(a,b){return a.groupOrder!==b.groupOrder?a.groupOrder-b.groupOrder:a.renderOrder!==b.renderOrder?a.renderOrder-b.renderOrder:a.z!==b.z?b.z-a.z:a.id-b.id}function WebGLRenderList(properties){const renderItems=[];let renderItemsIndex=0;const opaque=[],transparent=[],defaultProgram={id:-1};function getNextRenderItem(object,geometry,material,groupOrder,z,group){let renderItem=renderItems[renderItemsIndex];const materialProperties=properties.get(material);return void 0===renderItem?(renderItem={id:object.id,object,geometry,material,program:materialProperties.program||defaultProgram,groupOrder,renderOrder:object.renderOrder,z,group},renderItems[renderItemsIndex]=renderItem):(renderItem.id=object.id,renderItem.object=object,renderItem.geometry=geometry,renderItem.material=material,renderItem.program=materialProperties.program||defaultProgram,renderItem.groupOrder=groupOrder,renderItem.renderOrder=object.renderOrder,renderItem.z=z,renderItem.group=group),renderItemsIndex++,renderItem}return{opaque,transparent,init:function(){renderItemsIndex=0,opaque.length=0,transparent.length=0},push:function(object,geometry,material,groupOrder,z,group){const renderItem=getNextRenderItem(object,geometry,material,groupOrder,z,group);(!0===material.transparent?transparent:opaque).push(renderItem)},unshift:function(object,geometry,material,groupOrder,z,group){const renderItem=getNextRenderItem(object,geometry,material,groupOrder,z,group);(!0===material.transparent?transparent:opaque).unshift(renderItem)},finish:function(){for(let i=renderItemsIndex,il=renderItems.length;i<il;i++){const renderItem=renderItems[i];if(null===renderItem.id)break;renderItem.id=null,renderItem.object=null,renderItem.geometry=null,renderItem.material=null,renderItem.program=null,renderItem.group=null}},sort:function(customOpaqueSort,customTransparentSort){opaque.length>1&&opaque.sort(customOpaqueSort||painterSortStable),transparent.length>1&&transparent.sort(customTransparentSort||reversePainterSortStable)}}}function WebGLRenderLists(properties){let lists=new WeakMap;function onSceneDispose(event){const scene=event.target;scene.removeEventListener("dispose",onSceneDispose),lists.delete(scene)}return{get:function(scene,camera){const cameras=lists.get(scene);let list;return void 0===cameras?(list=new WebGLRenderList(properties),lists.set(scene,new WeakMap),lists.get(scene).set(camera,list),scene.addEventListener("dispose",onSceneDispose)):(list=cameras.get(camera),void 0===list&&(list=new WebGLRenderList(properties),cameras.set(camera,list))),list},dispose:function(){lists=new WeakMap}}}function UniformsCache(){const lights={};return{get:function(light){if(void 0!==lights[light.id])return lights[light.id];let uniforms;switch(light.type){case"DirectionalLight":uniforms={direction:new Vector3,color:new Color};break;case"SpotLight":uniforms={position:new Vector3,direction:new Vector3,color:new Color,distance:0,coneCos:0,penumbraCos:0,decay:0};break;case"PointLight":uniforms={position:new Vector3,color:new Color,distance:0,decay:0};break;case"HemisphereLight":uniforms={direction:new Vector3,skyColor:new Color,groundColor:new Color};break;case"RectAreaLight":uniforms={color:new Color,position:new Vector3,halfWidth:new Vector3,halfHeight:new Vector3}}return lights[light.id]=uniforms,uniforms}}}let nextVersion=0;function shadowCastingLightsFirst(lightA,lightB){return(lightB.castShadow?1:0)-(lightA.castShadow?1:0)}function WebGLLights(){const cache=new UniformsCache,shadowCache=function(){const lights={};return{get:function(light){if(void 0!==lights[light.id])return lights[light.id];let uniforms;switch(light.type){case"DirectionalLight":case"SpotLight":uniforms={shadowBias:0,shadowNormalBias:0,shadowRadius:1,shadowMapSize:new Vector2};break;case"PointLight":uniforms={shadowBias:0,shadowNormalBias:0,shadowRadius:1,shadowMapSize:new Vector2,shadowCameraNear:1,shadowCameraFar:1e3}}return lights[light.id]=uniforms,uniforms}}}(),state={version:0,hash:{directionalLength:-1,pointLength:-1,spotLength:-1,rectAreaLength:-1,hemiLength:-1,numDirectionalShadows:-1,numPointShadows:-1,numSpotShadows:-1},ambient:[0,0,0],probe:[],directional:[],directionalShadow:[],directionalShadowMap:[],directionalShadowMatrix:[],spot:[],spotShadow:[],spotShadowMap:[],spotShadowMatrix:[],rectArea:[],point:[],pointShadow:[],pointShadowMap:[],pointShadowMatrix:[],hemi:[]};for(let i=0;i<9;i++)state.probe.push(new Vector3);const vector3=new Vector3,matrix4=new Matrix4,matrix42=new Matrix4;return{setup:function(lights,shadows,camera){let r=0,g=0,b=0;for(let i=0;i<9;i++)state.probe[i].set(0,0,0);let directionalLength=0,pointLength=0,spotLength=0,rectAreaLength=0,hemiLength=0,numDirectionalShadows=0,numPointShadows=0,numSpotShadows=0;const viewMatrix=camera.matrixWorldInverse;lights.sort(shadowCastingLightsFirst);for(let i=0,l=lights.length;i<l;i++){const light=lights[i],color=light.color,intensity=light.intensity,distance=light.distance,shadowMap=light.shadow&&light.shadow.map?light.shadow.map.texture:null;if(light.isAmbientLight)r+=color.r*intensity,g+=color.g*intensity,b+=color.b*intensity;else if(light.isLightProbe)for(let j=0;j<9;j++)state.probe[j].addScaledVector(light.sh.coefficients[j],intensity);else if(light.isDirectionalLight){const uniforms=cache.get(light);if(uniforms.color.copy(light.color).multiplyScalar(light.intensity),uniforms.direction.setFromMatrixPosition(light.matrixWorld),vector3.setFromMatrixPosition(light.target.matrixWorld),uniforms.direction.sub(vector3),uniforms.direction.transformDirection(viewMatrix),light.castShadow){const shadow=light.shadow,shadowUniforms=shadowCache.get(light);shadowUniforms.shadowBias=shadow.bias,shadowUniforms.shadowNormalBias=shadow.normalBias,shadowUniforms.shadowRadius=shadow.radius,shadowUniforms.shadowMapSize=shadow.mapSize,state.directionalShadow[directionalLength]=shadowUniforms,state.directionalShadowMap[directionalLength]=shadowMap,state.directionalShadowMatrix[directionalLength]=light.shadow.matrix,numDirectionalShadows++}state.directional[directionalLength]=uniforms,directionalLength++}else if(light.isSpotLight){const uniforms=cache.get(light);if(uniforms.position.setFromMatrixPosition(light.matrixWorld),uniforms.position.applyMatrix4(viewMatrix),uniforms.color.copy(color).multiplyScalar(intensity),uniforms.distance=distance,uniforms.direction.setFromMatrixPosition(light.matrixWorld),vector3.setFromMatrixPosition(light.target.matrixWorld),uniforms.direction.sub(vector3),uniforms.direction.transformDirection(viewMatrix),uniforms.coneCos=Math.cos(light.angle),uniforms.penumbraCos=Math.cos(light.angle*(1-light.penumbra)),uniforms.decay=light.decay,light.castShadow){const shadow=light.shadow,shadowUniforms=shadowCache.get(light);shadowUniforms.shadowBias=shadow.bias,shadowUniforms.shadowNormalBias=shadow.normalBias,shadowUniforms.shadowRadius=shadow.radius,shadowUniforms.shadowMapSize=shadow.mapSize,state.spotShadow[spotLength]=shadowUniforms,state.spotShadowMap[spotLength]=shadowMap,state.spotShadowMatrix[spotLength]=light.shadow.matrix,numSpotShadows++}state.spot[spotLength]=uniforms,spotLength++}else if(light.isRectAreaLight){const uniforms=cache.get(light);uniforms.color.copy(color).multiplyScalar(intensity),uniforms.position.setFromMatrixPosition(light.matrixWorld),uniforms.position.applyMatrix4(viewMatrix),matrix42.identity(),matrix4.copy(light.matrixWorld),matrix4.premultiply(viewMatrix),matrix42.extractRotation(matrix4),uniforms.halfWidth.set(.5*light.width,0,0),uniforms.halfHeight.set(0,.5*light.height,0),uniforms.halfWidth.applyMatrix4(matrix42),uniforms.halfHeight.applyMatrix4(matrix42),state.rectArea[rectAreaLength]=uniforms,rectAreaLength++}else if(light.isPointLight){const uniforms=cache.get(light);if(uniforms.position.setFromMatrixPosition(light.matrixWorld),uniforms.position.applyMatrix4(viewMatrix),uniforms.color.copy(light.color).multiplyScalar(light.intensity),uniforms.distance=light.distance,uniforms.decay=light.decay,light.castShadow){const shadow=light.shadow,shadowUniforms=shadowCache.get(light);shadowUniforms.shadowBias=shadow.bias,shadowUniforms.shadowNormalBias=shadow.normalBias,shadowUniforms.shadowRadius=shadow.radius,shadowUniforms.shadowMapSize=shadow.mapSize,shadowUniforms.shadowCameraNear=shadow.camera.near,shadowUniforms.shadowCameraFar=shadow.camera.far,state.pointShadow[pointLength]=shadowUniforms,state.pointShadowMap[pointLength]=shadowMap,state.pointShadowMatrix[pointLength]=light.shadow.matrix,numPointShadows++}state.point[pointLength]=uniforms,pointLength++}else if(light.isHemisphereLight){const uniforms=cache.get(light);uniforms.direction.setFromMatrixPosition(light.matrixWorld),uniforms.direction.transformDirection(viewMatrix),uniforms.direction.normalize(),uniforms.skyColor.copy(light.color).multiplyScalar(intensity),uniforms.groundColor.copy(light.groundColor).multiplyScalar(intensity),state.hemi[hemiLength]=uniforms,hemiLength++}}state.ambient[0]=r,state.ambient[1]=g,state.ambient[2]=b;const hash=state.hash;hash.directionalLength===directionalLength&&hash.pointLength===pointLength&&hash.spotLength===spotLength&&hash.rectAreaLength===rectAreaLength&&hash.hemiLength===hemiLength&&hash.numDirectionalShadows===numDirectionalShadows&&hash.numPointShadows===numPointShadows&&hash.numSpotShadows===numSpotShadows||(state.directional.length=directionalLength,state.spot.length=spotLength,state.rectArea.length=rectAreaLength,state.point.length=pointLength,state.hemi.length=hemiLength,state.directionalShadow.length=numDirectionalShadows,state.directionalShadowMap.length=numDirectionalShadows,state.pointShadow.length=numPointShadows,state.pointShadowMap.length=numPointShadows,state.spotShadow.length=numSpotShadows,state.spotShadowMap.length=numSpotShadows,state.directionalShadowMatrix.length=numDirectionalShadows,state.pointShadowMatrix.length=numPointShadows,state.spotShadowMatrix.length=numSpotShadows,hash.directionalLength=directionalLength,hash.pointLength=pointLength,hash.spotLength=spotLength,hash.rectAreaLength=rectAreaLength,hash.hemiLength=hemiLength,hash.numDirectionalShadows=numDirectionalShadows,hash.numPointShadows=numPointShadows,hash.numSpotShadows=numSpotShadows,state.version=nextVersion++)},state}}function WebGLRenderState(){const lights=new WebGLLights,lightsArray=[],shadowsArray=[];return{init:function(){lightsArray.length=0,shadowsArray.length=0},state:{lightsArray,shadowsArray,lights},setupLights:function(camera){lights.setup(lightsArray,shadowsArray,camera)},pushLight:function(light){lightsArray.push(light)},pushShadow:function(shadowLight){shadowsArray.push(shadowLight)}}}function WebGLRenderStates(){let renderStates=new WeakMap;function onSceneDispose(event){const scene=event.target;scene.removeEventListener("dispose",onSceneDispose),renderStates.delete(scene)}return{get:function(scene,camera){let renderState;return!1===renderStates.has(scene)?(renderState=new WebGLRenderState,renderStates.set(scene,new WeakMap),renderStates.get(scene).set(camera,renderState),scene.addEventListener("dispose",onSceneDispose)):!1===renderStates.get(scene).has(camera)?(renderState=new WebGLRenderState,renderStates.get(scene).set(camera,renderState)):renderState=renderStates.get(scene).get(camera),renderState},dispose:function(){renderStates=new WeakMap}}}function MeshDepthMaterial(parameters){Material.call(this),this.type="MeshDepthMaterial",this.depthPacking=3200,this.skinning=!1,this.morphTargets=!1,this.map=null,this.alphaMap=null,this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.wireframe=!1,this.wireframeLinewidth=1,this.fog=!1,this.setValues(parameters)}function MeshDistanceMaterial(parameters){Material.call(this),this.type="MeshDistanceMaterial",this.referencePosition=new Vector3,this.nearDistance=1,this.farDistance=1e3,this.skinning=!1,this.morphTargets=!1,this.map=null,this.alphaMap=null,this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.fog=!1,this.setValues(parameters)}MeshDepthMaterial.prototype=Object.create(Material.prototype),MeshDepthMaterial.prototype.constructor=MeshDepthMaterial,MeshDepthMaterial.prototype.isMeshDepthMaterial=!0,MeshDepthMaterial.prototype.copy=function(source){return Material.prototype.copy.call(this,source),this.depthPacking=source.depthPacking,this.skinning=source.skinning,this.morphTargets=source.morphTargets,this.map=source.map,this.alphaMap=source.alphaMap,this.displacementMap=source.displacementMap,this.displacementScale=source.displacementScale,this.displacementBias=source.displacementBias,this.wireframe=source.wireframe,this.wireframeLinewidth=source.wireframeLinewidth,this},MeshDistanceMaterial.prototype=Object.create(Material.prototype),MeshDistanceMaterial.prototype.constructor=MeshDistanceMaterial,MeshDistanceMaterial.prototype.isMeshDistanceMaterial=!0,MeshDistanceMaterial.prototype.copy=function(source){return Material.prototype.copy.call(this,source),this.referencePosition.copy(source.referencePosition),this.nearDistance=source.nearDistance,this.farDistance=source.farDistance,this.skinning=source.skinning,this.morphTargets=source.morphTargets,this.map=source.map,this.alphaMap=source.alphaMap,this.displacementMap=source.displacementMap,this.displacementScale=source.displacementScale,this.displacementBias=source.displacementBias,this};function WebGLShadowMap(_renderer,_objects,maxTextureSize){let _frustum=new Frustum;const _shadowMapSize=new Vector2,_viewportSize=new Vector2,_viewport=new Vector4,_depthMaterials=[],_distanceMaterials=[],_materialCache={},shadowSide={0:1,1:0,2:2},shadowMaterialVertical=new ShaderMaterial({defines:{SAMPLE_RATE:2/8,HALF_SAMPLE_RATE:1/8},uniforms:{shadow_pass:{value:null},resolution:{value:new Vector2},radius:{value:4}},vertexShader:"void main() {\n\tgl_Position = vec4( position, 1.0 );\n}",fragmentShader:"uniform sampler2D shadow_pass;\nuniform vec2 resolution;\nuniform float radius;\n#include <packing>\nvoid main() {\n  float mean = 0.0;\n  float squared_mean = 0.0;\n\tfloat depth = unpackRGBAToDepth( texture2D( shadow_pass, ( gl_FragCoord.xy  ) / resolution ) );\n  for ( float i = -1.0; i < 1.0 ; i += SAMPLE_RATE) {\n    #ifdef HORIZONAL_PASS\n      vec2 distribution = unpackRGBATo2Half( texture2D( shadow_pass, ( gl_FragCoord.xy + vec2( i, 0.0 ) * radius ) / resolution ) );\n      mean += distribution.x;\n      squared_mean += distribution.y * distribution.y + distribution.x * distribution.x;\n    #else\n      float depth = unpackRGBAToDepth( texture2D( shadow_pass, ( gl_FragCoord.xy + vec2( 0.0,  i )  * radius ) / resolution ) );\n      mean += depth;\n      squared_mean += depth * depth;\n    #endif\n  }\n  mean = mean * HALF_SAMPLE_RATE;\n  squared_mean = squared_mean * HALF_SAMPLE_RATE;\n  float std_dev = sqrt( squared_mean - mean * mean );\n  gl_FragColor = pack2HalfToRGBA( vec2( mean, std_dev ) );\n}"}),shadowMaterialHorizonal=shadowMaterialVertical.clone();shadowMaterialHorizonal.defines.HORIZONAL_PASS=1;const fullScreenTri=new BufferGeometry;fullScreenTri.setAttribute("position",new BufferAttribute(new Float32Array([-1,-1,.5,3,-1,.5,-1,3,.5]),3));const fullScreenMesh=new Mesh(fullScreenTri,shadowMaterialVertical),scope=this;function VSMPass(shadow,camera){const geometry=_objects.update(fullScreenMesh);shadowMaterialVertical.uniforms.shadow_pass.value=shadow.map.texture,shadowMaterialVertical.uniforms.resolution.value=shadow.mapSize,shadowMaterialVertical.uniforms.radius.value=shadow.radius,_renderer.setRenderTarget(shadow.mapPass),_renderer.clear(),_renderer.renderBufferDirect(camera,null,geometry,shadowMaterialVertical,fullScreenMesh,null),shadowMaterialHorizonal.uniforms.shadow_pass.value=shadow.mapPass.texture,shadowMaterialHorizonal.uniforms.resolution.value=shadow.mapSize,shadowMaterialHorizonal.uniforms.radius.value=shadow.radius,_renderer.setRenderTarget(shadow.map),_renderer.clear(),_renderer.renderBufferDirect(camera,null,geometry,shadowMaterialHorizonal,fullScreenMesh,null)}function getDepthMaterialVariant(useMorphing,useSkinning,useInstancing){const index=useMorphing<<0|useSkinning<<1|useInstancing<<2;let material=_depthMaterials[index];return void 0===material&&(material=new MeshDepthMaterial({depthPacking:3201,morphTargets:useMorphing,skinning:useSkinning}),_depthMaterials[index]=material),material}function getDistanceMaterialVariant(useMorphing,useSkinning,useInstancing){const index=useMorphing<<0|useSkinning<<1|useInstancing<<2;let material=_distanceMaterials[index];return void 0===material&&(material=new MeshDistanceMaterial({morphTargets:useMorphing,skinning:useSkinning}),_distanceMaterials[index]=material),material}function getDepthMaterial(object,geometry,material,light,shadowCameraNear,shadowCameraFar,type){let result=null,getMaterialVariant=getDepthMaterialVariant,customMaterial=object.customDepthMaterial;if(!0===light.isPointLight&&(getMaterialVariant=getDistanceMaterialVariant,customMaterial=object.customDistanceMaterial),void 0===customMaterial){let useMorphing=!1;!0===material.morphTargets&&(useMorphing=geometry.morphAttributes&&geometry.morphAttributes.position&&geometry.morphAttributes.position.length>0);let useSkinning=!1;!0===object.isSkinnedMesh&&(!0===material.skinning?useSkinning=!0:console.warn("THREE.WebGLShadowMap: THREE.SkinnedMesh with material.skinning set to false:",object));result=getMaterialVariant(useMorphing,useSkinning,!0===object.isInstancedMesh)}else result=customMaterial;if(_renderer.localClippingEnabled&&!0===material.clipShadows&&0!==material.clippingPlanes.length){const keyA=result.uuid,keyB=material.uuid;let materialsForVariant=_materialCache[keyA];void 0===materialsForVariant&&(materialsForVariant={},_materialCache[keyA]=materialsForVariant);let cachedMaterial=materialsForVariant[keyB];void 0===cachedMaterial&&(cachedMaterial=result.clone(),materialsForVariant[keyB]=cachedMaterial),result=cachedMaterial}return result.visible=material.visible,result.wireframe=material.wireframe,result.side=3===type?null!==material.shadowSide?material.shadowSide:material.side:null!==material.shadowSide?material.shadowSide:shadowSide[material.side],result.clipShadows=material.clipShadows,result.clippingPlanes=material.clippingPlanes,result.clipIntersection=material.clipIntersection,result.wireframeLinewidth=material.wireframeLinewidth,result.linewidth=material.linewidth,!0===light.isPointLight&&!0===result.isMeshDistanceMaterial&&(result.referencePosition.setFromMatrixPosition(light.matrixWorld),result.nearDistance=shadowCameraNear,result.farDistance=shadowCameraFar),result}function renderObject(object,camera,shadowCamera,light,type){if(!1===object.visible)return;if(object.layers.test(camera.layers)&&(object.isMesh||object.isLine||object.isPoints)&&(object.castShadow||object.receiveShadow&&3===type)&&(!object.frustumCulled||_frustum.intersectsObject(object))){object.modelViewMatrix.multiplyMatrices(shadowCamera.matrixWorldInverse,object.matrixWorld);const geometry=_objects.update(object),material=object.material;if(Array.isArray(material)){const groups=geometry.groups;for(let k=0,kl=groups.length;k<kl;k++){const group=groups[k],groupMaterial=material[group.materialIndex];if(groupMaterial&&groupMaterial.visible){const depthMaterial=getDepthMaterial(object,geometry,groupMaterial,light,shadowCamera.near,shadowCamera.far,type);_renderer.renderBufferDirect(shadowCamera,null,geometry,depthMaterial,object,group)}}}else if(material.visible){const depthMaterial=getDepthMaterial(object,geometry,material,light,shadowCamera.near,shadowCamera.far,type);_renderer.renderBufferDirect(shadowCamera,null,geometry,depthMaterial,object,null)}}const children=object.children;for(let i=0,l=children.length;i<l;i++)renderObject(children[i],camera,shadowCamera,light,type)}this.enabled=!1,this.autoUpdate=!0,this.needsUpdate=!1,this.type=1,this.render=function(lights,scene,camera){if(!1===scope.enabled)return;if(!1===scope.autoUpdate&&!1===scope.needsUpdate)return;if(0===lights.length)return;const currentRenderTarget=_renderer.getRenderTarget(),activeCubeFace=_renderer.getActiveCubeFace(),activeMipmapLevel=_renderer.getActiveMipmapLevel(),_state=_renderer.state;_state.setBlending(0),_state.buffers.color.setClear(1,1,1,1),_state.buffers.depth.setTest(!0),_state.setScissorTest(!1);for(let i=0,il=lights.length;i<il;i++){const light=lights[i],shadow=light.shadow;if(!1===shadow.autoUpdate&&!1===shadow.needsUpdate)continue;if(void 0===shadow){console.warn("THREE.WebGLShadowMap:",light,"has no shadow.");continue}_shadowMapSize.copy(shadow.mapSize);const shadowFrameExtents=shadow.getFrameExtents();if(_shadowMapSize.multiply(shadowFrameExtents),_viewportSize.copy(shadow.mapSize),(_shadowMapSize.x>maxTextureSize||_shadowMapSize.y>maxTextureSize)&&(_shadowMapSize.x>maxTextureSize&&(_viewportSize.x=Math.floor(maxTextureSize/shadowFrameExtents.x),_shadowMapSize.x=_viewportSize.x*shadowFrameExtents.x,shadow.mapSize.x=_viewportSize.x),_shadowMapSize.y>maxTextureSize&&(_viewportSize.y=Math.floor(maxTextureSize/shadowFrameExtents.y),_shadowMapSize.y=_viewportSize.y*shadowFrameExtents.y,shadow.mapSize.y=_viewportSize.y)),null===shadow.map&&!shadow.isPointLightShadow&&3===this.type){const pars={minFilter:1006,magFilter:1006,format:1023,stencilBuffer:!1};shadow.map=new WebGLRenderTarget(_shadowMapSize.x,_shadowMapSize.y,pars),shadow.map.texture.name=light.name+".shadowMap",shadow.mapPass=new WebGLRenderTarget(_shadowMapSize.x,_shadowMapSize.y,pars),shadow.camera.updateProjectionMatrix()}if(null===shadow.map){const pars={minFilter:1003,magFilter:1003,format:1023,stencilBuffer:!1};shadow.map=new WebGLRenderTarget(_shadowMapSize.x,_shadowMapSize.y,pars),shadow.map.texture.name=light.name+".shadowMap",shadow.camera.updateProjectionMatrix()}_renderer.setRenderTarget(shadow.map),_renderer.clear();const viewportCount=shadow.getViewportCount();for(let vp=0;vp<viewportCount;vp++){const viewport=shadow.getViewport(vp);_viewport.set(_viewportSize.x*viewport.x,_viewportSize.y*viewport.y,_viewportSize.x*viewport.z,_viewportSize.y*viewport.w),_state.viewport(_viewport),shadow.updateMatrices(light,vp),_frustum=shadow.getFrustum(),renderObject(scene,camera,shadow.camera,light,this.type)}shadow.isPointLightShadow||3!==this.type||VSMPass(shadow,camera),shadow.needsUpdate=!1}scope.needsUpdate=!1,_renderer.setRenderTarget(currentRenderTarget,activeCubeFace,activeMipmapLevel)}}function WebGLState(gl,extensions,capabilities){const isWebGL2=capabilities.isWebGL2;const colorBuffer=new function(){let locked=!1;const color=new Vector4;let currentColorMask=null;const currentColorClear=new Vector4(0,0,0,0);return{setMask:function(colorMask){currentColorMask===colorMask||locked||(gl.colorMask(colorMask,colorMask,colorMask,colorMask),currentColorMask=colorMask)},setLocked:function(lock){locked=lock},setClear:function(r,g,b,a,premultipliedAlpha){!0===premultipliedAlpha&&(r*=a,g*=a,b*=a),color.set(r,g,b,a),!1===currentColorClear.equals(color)&&(gl.clearColor(r,g,b,a),currentColorClear.copy(color))},reset:function(){locked=!1,currentColorMask=null,currentColorClear.set(-1,0,0,0)}}},depthBuffer=new function(){let locked=!1,currentDepthMask=null,currentDepthFunc=null,currentDepthClear=null;return{setTest:function(depthTest){depthTest?enable(2929):disable(2929)},setMask:function(depthMask){currentDepthMask===depthMask||locked||(gl.depthMask(depthMask),currentDepthMask=depthMask)},setFunc:function(depthFunc){if(currentDepthFunc!==depthFunc){if(depthFunc)switch(depthFunc){case 0:gl.depthFunc(512);break;case 1:gl.depthFunc(519);break;case 2:gl.depthFunc(513);break;case 3:gl.depthFunc(515);break;case 4:gl.depthFunc(514);break;case 5:gl.depthFunc(518);break;case 6:gl.depthFunc(516);break;case 7:gl.depthFunc(517);break;default:gl.depthFunc(515)}else gl.depthFunc(515);currentDepthFunc=depthFunc}},setLocked:function(lock){locked=lock},setClear:function(depth){currentDepthClear!==depth&&(gl.clearDepth(depth),currentDepthClear=depth)},reset:function(){locked=!1,currentDepthMask=null,currentDepthFunc=null,currentDepthClear=null}}},stencilBuffer=new function(){let locked=!1,currentStencilMask=null,currentStencilFunc=null,currentStencilRef=null,currentStencilFuncMask=null,currentStencilFail=null,currentStencilZFail=null,currentStencilZPass=null,currentStencilClear=null;return{setTest:function(stencilTest){locked||(stencilTest?enable(2960):disable(2960))},setMask:function(stencilMask){currentStencilMask===stencilMask||locked||(gl.stencilMask(stencilMask),currentStencilMask=stencilMask)},setFunc:function(stencilFunc,stencilRef,stencilMask){currentStencilFunc===stencilFunc&&currentStencilRef===stencilRef&&currentStencilFuncMask===stencilMask||(gl.stencilFunc(stencilFunc,stencilRef,stencilMask),currentStencilFunc=stencilFunc,currentStencilRef=stencilRef,currentStencilFuncMask=stencilMask)},setOp:function(stencilFail,stencilZFail,stencilZPass){currentStencilFail===stencilFail&&currentStencilZFail===stencilZFail&&currentStencilZPass===stencilZPass||(gl.stencilOp(stencilFail,stencilZFail,stencilZPass),currentStencilFail=stencilFail,currentStencilZFail=stencilZFail,currentStencilZPass=stencilZPass)},setLocked:function(lock){locked=lock},setClear:function(stencil){currentStencilClear!==stencil&&(gl.clearStencil(stencil),currentStencilClear=stencil)},reset:function(){locked=!1,currentStencilMask=null,currentStencilFunc=null,currentStencilRef=null,currentStencilFuncMask=null,currentStencilFail=null,currentStencilZFail=null,currentStencilZPass=null,currentStencilClear=null}}};let enabledCapabilities={},currentProgram=null,currentBlendingEnabled=null,currentBlending=null,currentBlendEquation=null,currentBlendSrc=null,currentBlendDst=null,currentBlendEquationAlpha=null,currentBlendSrcAlpha=null,currentBlendDstAlpha=null,currentPremultipledAlpha=!1,currentFlipSided=null,currentCullFace=null,currentLineWidth=null,currentPolygonOffsetFactor=null,currentPolygonOffsetUnits=null;const maxTextures=gl.getParameter(35661);let lineWidthAvailable=!1,version=0;const glVersion=gl.getParameter(7938);-1!==glVersion.indexOf("WebGL")?(version=parseFloat(/^WebGL\ ([0-9])/.exec(glVersion)[1]),lineWidthAvailable=version>=1):-1!==glVersion.indexOf("OpenGL ES")&&(version=parseFloat(/^OpenGL\ ES\ ([0-9])/.exec(glVersion)[1]),lineWidthAvailable=version>=2);let currentTextureSlot=null,currentBoundTextures={};const currentScissor=new Vector4,currentViewport=new Vector4;function createTexture(type,target,count){const data=new Uint8Array(4),texture=gl.createTexture();gl.bindTexture(type,texture),gl.texParameteri(type,10241,9728),gl.texParameteri(type,10240,9728);for(let i=0;i<count;i++)gl.texImage2D(target+i,0,6408,1,1,0,6408,5121,data);return texture}const emptyTextures={};function enable(id){!0!==enabledCapabilities[id]&&(gl.enable(id),enabledCapabilities[id]=!0)}function disable(id){!1!==enabledCapabilities[id]&&(gl.disable(id),enabledCapabilities[id]=!1)}emptyTextures[3553]=createTexture(3553,3553,1),emptyTextures[34067]=createTexture(34067,34069,6),colorBuffer.setClear(0,0,0,1),depthBuffer.setClear(1),stencilBuffer.setClear(0),enable(2929),depthBuffer.setFunc(3),setFlipSided(!1),setCullFace(1),enable(2884),setBlending(0);const equationToGL={100:32774,101:32778,102:32779};if(isWebGL2)equationToGL[103]=32775,equationToGL[104]=32776;else{const extension=extensions.get("EXT_blend_minmax");null!==extension&&(equationToGL[103]=extension.MIN_EXT,equationToGL[104]=extension.MAX_EXT)}const factorToGL={200:0,201:1,202:768,204:770,210:776,208:774,206:772,203:769,205:771,209:775,207:773};function setBlending(blending,blendEquation,blendSrc,blendDst,blendEquationAlpha,blendSrcAlpha,blendDstAlpha,premultipliedAlpha){if(0!==blending){if(currentBlendingEnabled||(enable(3042),currentBlendingEnabled=!0),5===blending)blendEquationAlpha=blendEquationAlpha||blendEquation,blendSrcAlpha=blendSrcAlpha||blendSrc,blendDstAlpha=blendDstAlpha||blendDst,blendEquation===currentBlendEquation&&blendEquationAlpha===currentBlendEquationAlpha||(gl.blendEquationSeparate(equationToGL[blendEquation],equationToGL[blendEquationAlpha]),currentBlendEquation=blendEquation,currentBlendEquationAlpha=blendEquationAlpha),blendSrc===currentBlendSrc&&blendDst===currentBlendDst&&blendSrcAlpha===currentBlendSrcAlpha&&blendDstAlpha===currentBlendDstAlpha||(gl.blendFuncSeparate(factorToGL[blendSrc],factorToGL[blendDst],factorToGL[blendSrcAlpha],factorToGL[blendDstAlpha]),currentBlendSrc=blendSrc,currentBlendDst=blendDst,currentBlendSrcAlpha=blendSrcAlpha,currentBlendDstAlpha=blendDstAlpha),currentBlending=blending,currentPremultipledAlpha=null;else if(blending!==currentBlending||premultipliedAlpha!==currentPremultipledAlpha){if(100===currentBlendEquation&&100===currentBlendEquationAlpha||(gl.blendEquation(32774),currentBlendEquation=100,currentBlendEquationAlpha=100),premultipliedAlpha)switch(blending){case 1:gl.blendFuncSeparate(1,771,1,771);break;case 2:gl.blendFunc(1,1);break;case 3:gl.blendFuncSeparate(0,0,769,771);break;case 4:gl.blendFuncSeparate(0,768,0,770);break;default:console.error("THREE.WebGLState: Invalid blending: ",blending)}else switch(blending){case 1:gl.blendFuncSeparate(770,771,1,771);break;case 2:gl.blendFunc(770,1);break;case 3:gl.blendFunc(0,769);break;case 4:gl.blendFunc(0,768);break;default:console.error("THREE.WebGLState: Invalid blending: ",blending)}currentBlendSrc=null,currentBlendDst=null,currentBlendSrcAlpha=null,currentBlendDstAlpha=null,currentBlending=blending,currentPremultipledAlpha=premultipliedAlpha}}else currentBlendingEnabled&&(disable(3042),currentBlendingEnabled=!1)}function setFlipSided(flipSided){currentFlipSided!==flipSided&&(flipSided?gl.frontFace(2304):gl.frontFace(2305),currentFlipSided=flipSided)}function setCullFace(cullFace){0!==cullFace?(enable(2884),cullFace!==currentCullFace&&(1===cullFace?gl.cullFace(1029):2===cullFace?gl.cullFace(1028):gl.cullFace(1032))):disable(2884),currentCullFace=cullFace}function setPolygonOffset(polygonOffset,factor,units){polygonOffset?(enable(32823),currentPolygonOffsetFactor===factor&&currentPolygonOffsetUnits===units||(gl.polygonOffset(factor,units),currentPolygonOffsetFactor=factor,currentPolygonOffsetUnits=units)):disable(32823)}function activeTexture(webglSlot){void 0===webglSlot&&(webglSlot=33984+maxTextures-1),currentTextureSlot!==webglSlot&&(gl.activeTexture(webglSlot),currentTextureSlot=webglSlot)}return{buffers:{color:colorBuffer,depth:depthBuffer,stencil:stencilBuffer},enable,disable,useProgram:function(program){return currentProgram!==program&&(gl.useProgram(program),currentProgram=program,!0)},setBlending,setMaterial:function(material,frontFaceCW){2===material.side?disable(2884):enable(2884);let flipSided=1===material.side;frontFaceCW&&(flipSided=!flipSided),setFlipSided(flipSided),1===material.blending&&!1===material.transparent?setBlending(0):setBlending(material.blending,material.blendEquation,material.blendSrc,material.blendDst,material.blendEquationAlpha,material.blendSrcAlpha,material.blendDstAlpha,material.premultipliedAlpha),depthBuffer.setFunc(material.depthFunc),depthBuffer.setTest(material.depthTest),depthBuffer.setMask(material.depthWrite),colorBuffer.setMask(material.colorWrite);const stencilWrite=material.stencilWrite;stencilBuffer.setTest(stencilWrite),stencilWrite&&(stencilBuffer.setMask(material.stencilWriteMask),stencilBuffer.setFunc(material.stencilFunc,material.stencilRef,material.stencilFuncMask),stencilBuffer.setOp(material.stencilFail,material.stencilZFail,material.stencilZPass)),setPolygonOffset(material.polygonOffset,material.polygonOffsetFactor,material.polygonOffsetUnits)},setFlipSided,setCullFace,setLineWidth:function(width){width!==currentLineWidth&&(lineWidthAvailable&&gl.lineWidth(width),currentLineWidth=width)},setPolygonOffset,setScissorTest:function(scissorTest){scissorTest?enable(3089):disable(3089)},activeTexture,bindTexture:function(webglType,webglTexture){null===currentTextureSlot&&activeTexture();let boundTexture=currentBoundTextures[currentTextureSlot];void 0===boundTexture&&(boundTexture={type:void 0,texture:void 0},currentBoundTextures[currentTextureSlot]=boundTexture),boundTexture.type===webglType&&boundTexture.texture===webglTexture||(gl.bindTexture(webglType,webglTexture||emptyTextures[webglType]),boundTexture.type=webglType,boundTexture.texture=webglTexture)},unbindTexture:function(){const boundTexture=currentBoundTextures[currentTextureSlot];void 0!==boundTexture&&void 0!==boundTexture.type&&(gl.bindTexture(boundTexture.type,null),boundTexture.type=void 0,boundTexture.texture=void 0)},compressedTexImage2D:function(){try{gl.compressedTexImage2D.apply(gl,arguments)}catch(error){console.error("THREE.WebGLState:",error)}},texImage2D:function(){try{gl.texImage2D.apply(gl,arguments)}catch(error){console.error("THREE.WebGLState:",error)}},texImage3D:function(){try{gl.texImage3D.apply(gl,arguments)}catch(error){console.error("THREE.WebGLState:",error)}},scissor:function(scissor){!1===currentScissor.equals(scissor)&&(gl.scissor(scissor.x,scissor.y,scissor.z,scissor.w),currentScissor.copy(scissor))},viewport:function(viewport){!1===currentViewport.equals(viewport)&&(gl.viewport(viewport.x,viewport.y,viewport.z,viewport.w),currentViewport.copy(viewport))},reset:function(){enabledCapabilities={},currentTextureSlot=null,currentBoundTextures={},currentProgram=null,currentBlending=null,currentFlipSided=null,currentCullFace=null,colorBuffer.reset(),depthBuffer.reset(),stencilBuffer.reset()}}}function WebGLTextures(_gl,extensions,state,properties,capabilities,utils,info){const isWebGL2=capabilities.isWebGL2,maxTextures=capabilities.maxTextures,maxCubemapSize=capabilities.maxCubemapSize,maxTextureSize=capabilities.maxTextureSize,maxSamples=capabilities.maxSamples,_videoTextures=new WeakMap;let _canvas,useOffscreenCanvas=!1;try{useOffscreenCanvas="undefined"!=typeof OffscreenCanvas&&null!==new OffscreenCanvas(1,1).getContext("2d")}catch(err){}function createCanvas(width,height){return useOffscreenCanvas?new OffscreenCanvas(width,height):document.createElementNS("http://www.w3.org/1999/xhtml","canvas")}function resizeImage(image,needsPowerOfTwo,needsNewCanvas,maxSize){let scale=1;if((image.width>maxSize||image.height>maxSize)&&(scale=maxSize/Math.max(image.width,image.height)),scale<1||!0===needsPowerOfTwo){if("undefined"!=typeof HTMLImageElement&&image instanceof HTMLImageElement||"undefined"!=typeof HTMLCanvasElement&&image instanceof HTMLCanvasElement||"undefined"!=typeof ImageBitmap&&image instanceof ImageBitmap){const floor=needsPowerOfTwo?MathUtils.floorPowerOfTwo:Math.floor,width=floor(scale*image.width),height=floor(scale*image.height);void 0===_canvas&&(_canvas=createCanvas(width,height));const canvas=needsNewCanvas?createCanvas(width,height):_canvas;canvas.width=width,canvas.height=height;return canvas.getContext("2d").drawImage(image,0,0,width,height),console.warn("THREE.WebGLRenderer: Texture has been resized from ("+image.width+"x"+image.height+") to ("+width+"x"+height+")."),canvas}return"data"in image&&console.warn("THREE.WebGLRenderer: Image in DataTexture is too big ("+image.width+"x"+image.height+")."),image}return image}function isPowerOfTwo(image){return MathUtils.isPowerOfTwo(image.width)&&MathUtils.isPowerOfTwo(image.height)}function textureNeedsGenerateMipmaps(texture,supportsMips){return texture.generateMipmaps&&supportsMips&&1003!==texture.minFilter&&1006!==texture.minFilter}function generateMipmap(target,texture,width,height){_gl.generateMipmap(target);properties.get(texture).__maxMipLevel=Math.log(Math.max(width,height))*Math.LOG2E}function getInternalFormat(internalFormatName,glFormat,glType){if(!1===isWebGL2)return glFormat;if(null!==internalFormatName){if(void 0!==_gl[internalFormatName])return _gl[internalFormatName];console.warn("THREE.WebGLRenderer: Attempt to use non-existing WebGL internal format '"+internalFormatName+"'")}let internalFormat=glFormat;return 6403===glFormat&&(5126===glType&&(internalFormat=33326),5131===glType&&(internalFormat=33325),5121===glType&&(internalFormat=33321)),6407===glFormat&&(5126===glType&&(internalFormat=34837),5131===glType&&(internalFormat=34843),5121===glType&&(internalFormat=32849)),6408===glFormat&&(5126===glType&&(internalFormat=34836),5131===glType&&(internalFormat=34842),5121===glType&&(internalFormat=32856)),33325!==internalFormat&&33326!==internalFormat&&34842!==internalFormat&&34836!==internalFormat||extensions.get("EXT_color_buffer_float"),internalFormat}function filterFallback(f){return 1003===f||1004===f||1005===f?9728:9729}function onTextureDispose(event){const texture=event.target;texture.removeEventListener("dispose",onTextureDispose),function(texture){const textureProperties=properties.get(texture);if(void 0===textureProperties.__webglInit)return;_gl.deleteTexture(textureProperties.__webglTexture),properties.remove(texture)}(texture),texture.isVideoTexture&&_videoTextures.delete(texture),info.memory.textures--}function onRenderTargetDispose(event){const renderTarget=event.target;renderTarget.removeEventListener("dispose",onRenderTargetDispose),function(renderTarget){const renderTargetProperties=properties.get(renderTarget),textureProperties=properties.get(renderTarget.texture);if(!renderTarget)return;void 0!==textureProperties.__webglTexture&&_gl.deleteTexture(textureProperties.__webglTexture);renderTarget.depthTexture&&renderTarget.depthTexture.dispose();if(renderTarget.isWebGLCubeRenderTarget)for(let i=0;i<6;i++)_gl.deleteFramebuffer(renderTargetProperties.__webglFramebuffer[i]),renderTargetProperties.__webglDepthbuffer&&_gl.deleteRenderbuffer(renderTargetProperties.__webglDepthbuffer[i]);else _gl.deleteFramebuffer(renderTargetProperties.__webglFramebuffer),renderTargetProperties.__webglDepthbuffer&&_gl.deleteRenderbuffer(renderTargetProperties.__webglDepthbuffer),renderTargetProperties.__webglMultisampledFramebuffer&&_gl.deleteFramebuffer(renderTargetProperties.__webglMultisampledFramebuffer),renderTargetProperties.__webglColorRenderbuffer&&_gl.deleteRenderbuffer(renderTargetProperties.__webglColorRenderbuffer),renderTargetProperties.__webglDepthRenderbuffer&&_gl.deleteRenderbuffer(renderTargetProperties.__webglDepthRenderbuffer);properties.remove(renderTarget.texture),properties.remove(renderTarget)}(renderTarget),info.memory.textures--}let textureUnits=0;function setTexture2D(texture,slot){const textureProperties=properties.get(texture);if(texture.isVideoTexture&&function(texture){const frame=info.render.frame;_videoTextures.get(texture)!==frame&&(_videoTextures.set(texture,frame),texture.update())}(texture),texture.version>0&&textureProperties.__version!==texture.version){const image=texture.image;if(void 0===image)console.warn("THREE.WebGLRenderer: Texture marked for update but image is undefined");else{if(!1!==image.complete)return void uploadTexture(textureProperties,texture,slot);console.warn("THREE.WebGLRenderer: Texture marked for update but image is incomplete")}}state.activeTexture(33984+slot),state.bindTexture(3553,textureProperties.__webglTexture)}function setTextureCube(texture,slot){if(6!==texture.image.length)return;const textureProperties=properties.get(texture);if(texture.version>0&&textureProperties.__version!==texture.version){initTexture(textureProperties,texture),state.activeTexture(33984+slot),state.bindTexture(34067,textureProperties.__webglTexture),_gl.pixelStorei(37440,texture.flipY);const isCompressed=texture&&(texture.isCompressedTexture||texture.image[0].isCompressedTexture),isDataTexture=texture.image[0]&&texture.image[0].isDataTexture,cubeImage=[];for(let i=0;i<6;i++)cubeImage[i]=isCompressed||isDataTexture?isDataTexture?texture.image[i].image:texture.image[i]:resizeImage(texture.image[i],!1,!0,maxCubemapSize);const image=cubeImage[0],supportsMips=isPowerOfTwo(image)||isWebGL2,glFormat=utils.convert(texture.format),glType=utils.convert(texture.type),glInternalFormat=getInternalFormat(texture.internalFormat,glFormat,glType);let mipmaps;if(setTextureParameters(34067,texture,supportsMips),isCompressed){for(let i=0;i<6;i++){mipmaps=cubeImage[i].mipmaps;for(let j=0;j<mipmaps.length;j++){const mipmap=mipmaps[j];1023!==texture.format&&1022!==texture.format?null!==glFormat?state.compressedTexImage2D(34069+i,j,glInternalFormat,mipmap.width,mipmap.height,0,mipmap.data):console.warn("THREE.WebGLRenderer: Attempt to load unsupported compressed texture format in .setTextureCube()"):state.texImage2D(34069+i,j,glInternalFormat,mipmap.width,mipmap.height,0,glFormat,glType,mipmap.data)}}textureProperties.__maxMipLevel=mipmaps.length-1}else{mipmaps=texture.mipmaps;for(let i=0;i<6;i++)if(isDataTexture){state.texImage2D(34069+i,0,glInternalFormat,cubeImage[i].width,cubeImage[i].height,0,glFormat,glType,cubeImage[i].data);for(let j=0;j<mipmaps.length;j++){const mipmapImage=mipmaps[j].image[i].image;state.texImage2D(34069+i,j+1,glInternalFormat,mipmapImage.width,mipmapImage.height,0,glFormat,glType,mipmapImage.data)}}else{state.texImage2D(34069+i,0,glInternalFormat,glFormat,glType,cubeImage[i]);for(let j=0;j<mipmaps.length;j++){const mipmap=mipmaps[j];state.texImage2D(34069+i,j+1,glInternalFormat,glFormat,glType,mipmap.image[i])}}textureProperties.__maxMipLevel=mipmaps.length}textureNeedsGenerateMipmaps(texture,supportsMips)&&generateMipmap(34067,texture,image.width,image.height),textureProperties.__version=texture.version,texture.onUpdate&&texture.onUpdate(texture)}else state.activeTexture(33984+slot),state.bindTexture(34067,textureProperties.__webglTexture)}function setTextureCubeDynamic(texture,slot){state.activeTexture(33984+slot),state.bindTexture(34067,properties.get(texture).__webglTexture)}const wrappingToGL={1e3:10497,1001:33071,1002:33648},filterToGL={1003:9728,1004:9984,1005:9986,1006:9729,1007:9985,1008:9987};function setTextureParameters(textureType,texture,supportsMips){supportsMips?(_gl.texParameteri(textureType,10242,wrappingToGL[texture.wrapS]),_gl.texParameteri(textureType,10243,wrappingToGL[texture.wrapT]),32879!==textureType&&35866!==textureType||_gl.texParameteri(textureType,32882,wrappingToGL[texture.wrapR]),_gl.texParameteri(textureType,10240,filterToGL[texture.magFilter]),_gl.texParameteri(textureType,10241,filterToGL[texture.minFilter])):(_gl.texParameteri(textureType,10242,33071),_gl.texParameteri(textureType,10243,33071),32879!==textureType&&35866!==textureType||_gl.texParameteri(textureType,32882,33071),1001===texture.wrapS&&1001===texture.wrapT||console.warn("THREE.WebGLRenderer: Texture is not power of two. Texture.wrapS and Texture.wrapT should be set to THREE.ClampToEdgeWrapping."),_gl.texParameteri(textureType,10240,filterFallback(texture.magFilter)),_gl.texParameteri(textureType,10241,filterFallback(texture.minFilter)),1003!==texture.minFilter&&1006!==texture.minFilter&&console.warn("THREE.WebGLRenderer: Texture is not power of two. Texture.minFilter should be set to THREE.NearestFilter or THREE.LinearFilter."));const extension=extensions.get("EXT_texture_filter_anisotropic");if(extension){if(1015===texture.type&&null===extensions.get("OES_texture_float_linear"))return;if(1016===texture.type&&null===(isWebGL2||extensions.get("OES_texture_half_float_linear")))return;(texture.anisotropy>1||properties.get(texture).__currentAnisotropy)&&(_gl.texParameterf(textureType,extension.TEXTURE_MAX_ANISOTROPY_EXT,Math.min(texture.anisotropy,capabilities.getMaxAnisotropy())),properties.get(texture).__currentAnisotropy=texture.anisotropy)}}function initTexture(textureProperties,texture){void 0===textureProperties.__webglInit&&(textureProperties.__webglInit=!0,texture.addEventListener("dispose",onTextureDispose),textureProperties.__webglTexture=_gl.createTexture(),info.memory.textures++)}function uploadTexture(textureProperties,texture,slot){let textureType=3553;texture.isDataTexture2DArray&&(textureType=35866),texture.isDataTexture3D&&(textureType=32879),initTexture(textureProperties,texture),state.activeTexture(33984+slot),state.bindTexture(textureType,textureProperties.__webglTexture),_gl.pixelStorei(37440,texture.flipY),_gl.pixelStorei(37441,texture.premultiplyAlpha),_gl.pixelStorei(3317,texture.unpackAlignment);const needsPowerOfTwo=function(texture){return!isWebGL2&&(1001!==texture.wrapS||1001!==texture.wrapT||1003!==texture.minFilter&&1006!==texture.minFilter)}(texture)&&!1===isPowerOfTwo(texture.image),image=resizeImage(texture.image,needsPowerOfTwo,!1,maxTextureSize),supportsMips=isPowerOfTwo(image)||isWebGL2,glFormat=utils.convert(texture.format);let mipmap,glType=utils.convert(texture.type),glInternalFormat=getInternalFormat(texture.internalFormat,glFormat,glType);setTextureParameters(textureType,texture,supportsMips);const mipmaps=texture.mipmaps;if(texture.isDepthTexture)glInternalFormat=6402,isWebGL2?glInternalFormat=1015===texture.type?36012:1014===texture.type?33190:1020===texture.type?35056:33189:1015===texture.type&&console.error("WebGLRenderer: Floating point depth texture requires WebGL2."),1026===texture.format&&6402===glInternalFormat&&1012!==texture.type&&1014!==texture.type&&(console.warn("THREE.WebGLRenderer: Use UnsignedShortType or UnsignedIntType for DepthFormat DepthTexture."),texture.type=1012,glType=utils.convert(texture.type)),1027===texture.format&&6402===glInternalFormat&&(glInternalFormat=34041,1020!==texture.type&&(console.warn("THREE.WebGLRenderer: Use UnsignedInt248Type for DepthStencilFormat DepthTexture."),texture.type=1020,glType=utils.convert(texture.type))),state.texImage2D(3553,0,glInternalFormat,image.width,image.height,0,glFormat,glType,null);else if(texture.isDataTexture)if(mipmaps.length>0&&supportsMips){for(let i=0,il=mipmaps.length;i<il;i++)mipmap=mipmaps[i],state.texImage2D(3553,i,glInternalFormat,mipmap.width,mipmap.height,0,glFormat,glType,mipmap.data);texture.generateMipmaps=!1,textureProperties.__maxMipLevel=mipmaps.length-1}else state.texImage2D(3553,0,glInternalFormat,image.width,image.height,0,glFormat,glType,image.data),textureProperties.__maxMipLevel=0;else if(texture.isCompressedTexture){for(let i=0,il=mipmaps.length;i<il;i++)mipmap=mipmaps[i],1023!==texture.format&&1022!==texture.format?null!==glFormat?state.compressedTexImage2D(3553,i,glInternalFormat,mipmap.width,mipmap.height,0,mipmap.data):console.warn("THREE.WebGLRenderer: Attempt to load unsupported compressed texture format in .uploadTexture()"):state.texImage2D(3553,i,glInternalFormat,mipmap.width,mipmap.height,0,glFormat,glType,mipmap.data);textureProperties.__maxMipLevel=mipmaps.length-1}else if(texture.isDataTexture2DArray)state.texImage3D(35866,0,glInternalFormat,image.width,image.height,image.depth,0,glFormat,glType,image.data),textureProperties.__maxMipLevel=0;else if(texture.isDataTexture3D)state.texImage3D(32879,0,glInternalFormat,image.width,image.height,image.depth,0,glFormat,glType,image.data),textureProperties.__maxMipLevel=0;else if(mipmaps.length>0&&supportsMips){for(let i=0,il=mipmaps.length;i<il;i++)mipmap=mipmaps[i],state.texImage2D(3553,i,glInternalFormat,glFormat,glType,mipmap);texture.generateMipmaps=!1,textureProperties.__maxMipLevel=mipmaps.length-1}else state.texImage2D(3553,0,glInternalFormat,glFormat,glType,image),textureProperties.__maxMipLevel=0;textureNeedsGenerateMipmaps(texture,supportsMips)&&generateMipmap(textureType,texture,image.width,image.height),textureProperties.__version=texture.version,texture.onUpdate&&texture.onUpdate(texture)}function setupFrameBufferTexture(framebuffer,renderTarget,attachment,textureTarget){const glFormat=utils.convert(renderTarget.texture.format),glType=utils.convert(renderTarget.texture.type),glInternalFormat=getInternalFormat(renderTarget.texture.internalFormat,glFormat,glType);state.texImage2D(textureTarget,0,glInternalFormat,renderTarget.width,renderTarget.height,0,glFormat,glType,null),_gl.bindFramebuffer(36160,framebuffer),_gl.framebufferTexture2D(36160,attachment,textureTarget,properties.get(renderTarget.texture).__webglTexture,0),_gl.bindFramebuffer(36160,null)}function setupRenderBufferStorage(renderbuffer,renderTarget,isMultisample){if(_gl.bindRenderbuffer(36161,renderbuffer),renderTarget.depthBuffer&&!renderTarget.stencilBuffer){let glInternalFormat=33189;if(isMultisample){const depthTexture=renderTarget.depthTexture;depthTexture&&depthTexture.isDepthTexture&&(1015===depthTexture.type?glInternalFormat=36012:1014===depthTexture.type&&(glInternalFormat=33190));const samples=getRenderTargetSamples(renderTarget);_gl.renderbufferStorageMultisample(36161,samples,glInternalFormat,renderTarget.width,renderTarget.height)}else _gl.renderbufferStorage(36161,glInternalFormat,renderTarget.width,renderTarget.height);_gl.framebufferRenderbuffer(36160,36096,36161,renderbuffer)}else if(renderTarget.depthBuffer&&renderTarget.stencilBuffer){if(isMultisample){const samples=getRenderTargetSamples(renderTarget);_gl.renderbufferStorageMultisample(36161,samples,35056,renderTarget.width,renderTarget.height)}else _gl.renderbufferStorage(36161,34041,renderTarget.width,renderTarget.height);_gl.framebufferRenderbuffer(36160,33306,36161,renderbuffer)}else{const glFormat=utils.convert(renderTarget.texture.format),glType=utils.convert(renderTarget.texture.type),glInternalFormat=getInternalFormat(renderTarget.texture.internalFormat,glFormat,glType);if(isMultisample){const samples=getRenderTargetSamples(renderTarget);_gl.renderbufferStorageMultisample(36161,samples,glInternalFormat,renderTarget.width,renderTarget.height)}else _gl.renderbufferStorage(36161,glInternalFormat,renderTarget.width,renderTarget.height)}_gl.bindRenderbuffer(36161,null)}function setupDepthRenderbuffer(renderTarget){const renderTargetProperties=properties.get(renderTarget),isCube=!0===renderTarget.isWebGLCubeRenderTarget;if(renderTarget.depthTexture){if(isCube)throw new Error("target.depthTexture not supported in Cube render targets");!function(framebuffer,renderTarget){if(renderTarget&&renderTarget.isWebGLCubeRenderTarget)throw new Error("Depth Texture with cube render targets is not supported");if(_gl.bindFramebuffer(36160,framebuffer),!renderTarget.depthTexture||!renderTarget.depthTexture.isDepthTexture)throw new Error("renderTarget.depthTexture must be an instance of THREE.DepthTexture");properties.get(renderTarget.depthTexture).__webglTexture&&renderTarget.depthTexture.image.width===renderTarget.width&&renderTarget.depthTexture.image.height===renderTarget.height||(renderTarget.depthTexture.image.width=renderTarget.width,renderTarget.depthTexture.image.height=renderTarget.height,renderTarget.depthTexture.needsUpdate=!0),setTexture2D(renderTarget.depthTexture,0);const webglDepthTexture=properties.get(renderTarget.depthTexture).__webglTexture;if(1026===renderTarget.depthTexture.format)_gl.framebufferTexture2D(36160,36096,3553,webglDepthTexture,0);else{if(1027!==renderTarget.depthTexture.format)throw new Error("Unknown depthTexture format");_gl.framebufferTexture2D(36160,33306,3553,webglDepthTexture,0)}}(renderTargetProperties.__webglFramebuffer,renderTarget)}else if(isCube){renderTargetProperties.__webglDepthbuffer=[];for(let i=0;i<6;i++)_gl.bindFramebuffer(36160,renderTargetProperties.__webglFramebuffer[i]),renderTargetProperties.__webglDepthbuffer[i]=_gl.createRenderbuffer(),setupRenderBufferStorage(renderTargetProperties.__webglDepthbuffer[i],renderTarget,!1)}else _gl.bindFramebuffer(36160,renderTargetProperties.__webglFramebuffer),renderTargetProperties.__webglDepthbuffer=_gl.createRenderbuffer(),setupRenderBufferStorage(renderTargetProperties.__webglDepthbuffer,renderTarget,!1);_gl.bindFramebuffer(36160,null)}function getRenderTargetSamples(renderTarget){return isWebGL2&&renderTarget.isWebGLMultisampleRenderTarget?Math.min(maxSamples,renderTarget.samples):0}let warnedTexture2D=!1,warnedTextureCube=!1;this.allocateTextureUnit=function(){const textureUnit=textureUnits;return textureUnit>=maxTextures&&console.warn("THREE.WebGLTextures: Trying to use "+textureUnit+" texture units while this GPU supports only "+maxTextures),textureUnits+=1,textureUnit},this.resetTextureUnits=function(){textureUnits=0},this.setTexture2D=setTexture2D,this.setTexture2DArray=function(texture,slot){const textureProperties=properties.get(texture);texture.version>0&&textureProperties.__version!==texture.version?uploadTexture(textureProperties,texture,slot):(state.activeTexture(33984+slot),state.bindTexture(35866,textureProperties.__webglTexture))},this.setTexture3D=function(texture,slot){const textureProperties=properties.get(texture);texture.version>0&&textureProperties.__version!==texture.version?uploadTexture(textureProperties,texture,slot):(state.activeTexture(33984+slot),state.bindTexture(32879,textureProperties.__webglTexture))},this.setTextureCube=setTextureCube,this.setTextureCubeDynamic=setTextureCubeDynamic,this.setupRenderTarget=function(renderTarget){const renderTargetProperties=properties.get(renderTarget),textureProperties=properties.get(renderTarget.texture);renderTarget.addEventListener("dispose",onRenderTargetDispose),textureProperties.__webglTexture=_gl.createTexture(),info.memory.textures++;const isCube=!0===renderTarget.isWebGLCubeRenderTarget,isMultisample=!0===renderTarget.isWebGLMultisampleRenderTarget,supportsMips=isPowerOfTwo(renderTarget)||isWebGL2;if(!isWebGL2||1022!==renderTarget.texture.format||1015!==renderTarget.texture.type&&1016!==renderTarget.texture.type||(renderTarget.texture.format=1023,console.warn("THREE.WebGLRenderer: Rendering to textures with RGB format is not supported. Using RGBA format instead.")),isCube){renderTargetProperties.__webglFramebuffer=[];for(let i=0;i<6;i++)renderTargetProperties.__webglFramebuffer[i]=_gl.createFramebuffer()}else if(renderTargetProperties.__webglFramebuffer=_gl.createFramebuffer(),isMultisample)if(isWebGL2){renderTargetProperties.__webglMultisampledFramebuffer=_gl.createFramebuffer(),renderTargetProperties.__webglColorRenderbuffer=_gl.createRenderbuffer(),_gl.bindRenderbuffer(36161,renderTargetProperties.__webglColorRenderbuffer);const glFormat=utils.convert(renderTarget.texture.format),glType=utils.convert(renderTarget.texture.type),glInternalFormat=getInternalFormat(renderTarget.texture.internalFormat,glFormat,glType),samples=getRenderTargetSamples(renderTarget);_gl.renderbufferStorageMultisample(36161,samples,glInternalFormat,renderTarget.width,renderTarget.height),_gl.bindFramebuffer(36160,renderTargetProperties.__webglMultisampledFramebuffer),_gl.framebufferRenderbuffer(36160,36064,36161,renderTargetProperties.__webglColorRenderbuffer),_gl.bindRenderbuffer(36161,null),renderTarget.depthBuffer&&(renderTargetProperties.__webglDepthRenderbuffer=_gl.createRenderbuffer(),setupRenderBufferStorage(renderTargetProperties.__webglDepthRenderbuffer,renderTarget,!0)),_gl.bindFramebuffer(36160,null)}else console.warn("THREE.WebGLRenderer: WebGLMultisampleRenderTarget can only be used with WebGL2.");if(isCube){state.bindTexture(34067,textureProperties.__webglTexture),setTextureParameters(34067,renderTarget.texture,supportsMips);for(let i=0;i<6;i++)setupFrameBufferTexture(renderTargetProperties.__webglFramebuffer[i],renderTarget,36064,34069+i);textureNeedsGenerateMipmaps(renderTarget.texture,supportsMips)&&generateMipmap(34067,renderTarget.texture,renderTarget.width,renderTarget.height),state.bindTexture(34067,null)}else state.bindTexture(3553,textureProperties.__webglTexture),setTextureParameters(3553,renderTarget.texture,supportsMips),setupFrameBufferTexture(renderTargetProperties.__webglFramebuffer,renderTarget,36064,3553),textureNeedsGenerateMipmaps(renderTarget.texture,supportsMips)&&generateMipmap(3553,renderTarget.texture,renderTarget.width,renderTarget.height),state.bindTexture(3553,null);renderTarget.depthBuffer&&setupDepthRenderbuffer(renderTarget)},this.updateRenderTargetMipmap=function(renderTarget){const texture=renderTarget.texture;if(textureNeedsGenerateMipmaps(texture,isPowerOfTwo(renderTarget)||isWebGL2)){const target=renderTarget.isWebGLCubeRenderTarget?34067:3553,webglTexture=properties.get(texture).__webglTexture;state.bindTexture(target,webglTexture),generateMipmap(target,texture,renderTarget.width,renderTarget.height),state.bindTexture(target,null)}},this.updateMultisampleRenderTarget=function(renderTarget){if(renderTarget.isWebGLMultisampleRenderTarget)if(isWebGL2){const renderTargetProperties=properties.get(renderTarget);_gl.bindFramebuffer(36008,renderTargetProperties.__webglMultisampledFramebuffer),_gl.bindFramebuffer(36009,renderTargetProperties.__webglFramebuffer);const width=renderTarget.width,height=renderTarget.height;let mask=16384;renderTarget.depthBuffer&&(mask|=256),renderTarget.stencilBuffer&&(mask|=1024),_gl.blitFramebuffer(0,0,width,height,0,0,width,height,mask,9728),_gl.bindFramebuffer(36160,renderTargetProperties.__webglMultisampledFramebuffer)}else console.warn("THREE.WebGLRenderer: WebGLMultisampleRenderTarget can only be used with WebGL2.")},this.safeSetTexture2D=function(texture,slot){texture&&texture.isWebGLRenderTarget&&(!1===warnedTexture2D&&(console.warn("THREE.WebGLTextures.safeSetTexture2D: don't use render targets as textures. Use their .texture property instead."),warnedTexture2D=!0),texture=texture.texture),setTexture2D(texture,slot)},this.safeSetTextureCube=function(texture,slot){texture&&texture.isWebGLCubeRenderTarget&&(!1===warnedTextureCube&&(console.warn("THREE.WebGLTextures.safeSetTextureCube: don't use cube render targets as textures. Use their .texture property instead."),warnedTextureCube=!0),texture=texture.texture),texture&&texture.isCubeTexture||Array.isArray(texture.image)&&6===texture.image.length?setTextureCube(texture,slot):setTextureCubeDynamic(texture,slot)}}function WebGLUtils(gl,extensions,capabilities){const isWebGL2=capabilities.isWebGL2;return{convert:function(p){let extension;if(1009===p)return 5121;if(1017===p)return 32819;if(1018===p)return 32820;if(1019===p)return 33635;if(1010===p)return 5120;if(1011===p)return 5122;if(1012===p)return 5123;if(1013===p)return 5124;if(1014===p)return 5125;if(1015===p)return 5126;if(1016===p)return isWebGL2?5131:(extension=extensions.get("OES_texture_half_float"),null!==extension?extension.HALF_FLOAT_OES:null);if(1021===p)return 6406;if(1022===p)return 6407;if(1023===p)return 6408;if(1024===p)return 6409;if(1025===p)return 6410;if(1026===p)return 6402;if(1027===p)return 34041;if(1028===p)return 6403;if(1029===p)return 36244;if(1030===p)return 33319;if(1031===p)return 33320;if(1032===p)return 36248;if(1033===p)return 36249;if(33776===p||33777===p||33778===p||33779===p){if(extension=extensions.get("WEBGL_compressed_texture_s3tc"),null===extension)return null;if(33776===p)return extension.COMPRESSED_RGB_S3TC_DXT1_EXT;if(33777===p)return extension.COMPRESSED_RGBA_S3TC_DXT1_EXT;if(33778===p)return extension.COMPRESSED_RGBA_S3TC_DXT3_EXT;if(33779===p)return extension.COMPRESSED_RGBA_S3TC_DXT5_EXT}if(35840===p||35841===p||35842===p||35843===p){if(extension=extensions.get("WEBGL_compressed_texture_pvrtc"),null===extension)return null;if(35840===p)return extension.COMPRESSED_RGB_PVRTC_4BPPV1_IMG;if(35841===p)return extension.COMPRESSED_RGB_PVRTC_2BPPV1_IMG;if(35842===p)return extension.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG;if(35843===p)return extension.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG}if(36196===p)return extension=extensions.get("WEBGL_compressed_texture_etc1"),null!==extension?extension.COMPRESSED_RGB_ETC1_WEBGL:null;if((37492===p||37496===p)&&(extension=extensions.get("WEBGL_compressed_texture_etc"),null!==extension)){if(37492===p)return extension.COMPRESSED_RGB8_ETC2;if(37496===p)return extension.COMPRESSED_RGBA8_ETC2_EAC}return 37808===p||37809===p||37810===p||37811===p||37812===p||37813===p||37814===p||37815===p||37816===p||37817===p||37818===p||37819===p||37820===p||37821===p||37840===p||37841===p||37842===p||37843===p||37844===p||37845===p||37846===p||37847===p||37848===p||37849===p||37850===p||37851===p||37852===p||37853===p?(extension=extensions.get("WEBGL_compressed_texture_astc"),null!==extension?p:null):36492===p?(extension=extensions.get("EXT_texture_compression_bptc"),null!==extension?p:null):1020===p?isWebGL2?34042:(extension=extensions.get("WEBGL_depth_texture"),null!==extension?extension.UNSIGNED_INT_24_8_WEBGL:null):void 0}}}function ArrayCamera(array){PerspectiveCamera.call(this),this.cameras=array||[]}function Group(){Object3D.call(this),this.type="Group"}function WebXRController(){this._targetRay=null,this._grip=null,this._hand=null}function WebXRManager(renderer,gl){const scope=this;let session=null,framebufferScaleFactor=1,referenceSpace=null,referenceSpaceType="local-floor",pose=null;const controllers=[],inputSourcesMap=new Map,cameraL=new PerspectiveCamera;cameraL.layers.enable(1),cameraL.viewport=new Vector4;const cameraR=new PerspectiveCamera;cameraR.layers.enable(2),cameraR.viewport=new Vector4;const cameras=[cameraL,cameraR],cameraVR=new ArrayCamera;cameraVR.layers.enable(1),cameraVR.layers.enable(2);let _currentDepthNear=null,_currentDepthFar=null;function onSessionEvent(event){const controller=inputSourcesMap.get(event.inputSource);controller&&controller.dispatchEvent({type:event.type})}function onSessionEnd(){inputSourcesMap.forEach((function(controller,inputSource){controller.disconnect(inputSource)})),inputSourcesMap.clear(),renderer.setFramebuffer(null),renderer.setRenderTarget(renderer.getRenderTarget()),animation.stop(),scope.isPresenting=!1,scope.dispatchEvent({type:"sessionend"})}function onRequestReferenceSpace(value){referenceSpace=value,animation.setContext(session),animation.start(),scope.isPresenting=!0,scope.dispatchEvent({type:"sessionstart"})}function updateInputSources(event){const inputSources=session.inputSources;for(let i=0;i<controllers.length;i++)inputSourcesMap.set(inputSources[i],controllers[i]);for(let i=0;i<event.removed.length;i++){const inputSource=event.removed[i],controller=inputSourcesMap.get(inputSource);controller&&(controller.dispatchEvent({type:"disconnected",data:inputSource}),inputSourcesMap.delete(inputSource))}for(let i=0;i<event.added.length;i++){const inputSource=event.added[i],controller=inputSourcesMap.get(inputSource);controller&&controller.dispatchEvent({type:"connected",data:inputSource})}}this.enabled=!1,this.isPresenting=!1,this.getController=function(index){let controller=controllers[index];return void 0===controller&&(controller=new WebXRController,controllers[index]=controller),controller.getTargetRaySpace()},this.getControllerGrip=function(index){let controller=controllers[index];return void 0===controller&&(controller=new WebXRController,controllers[index]=controller),controller.getGripSpace()},this.getHand=function(index){let controller=controllers[index];return void 0===controller&&(controller=new WebXRController,controllers[index]=controller),controller.getHandSpace()},this.setFramebufferScaleFactor=function(value){framebufferScaleFactor=value,!0===scope.isPresenting&&console.warn("THREE.WebXRManager: Cannot change framebuffer scale while presenting.")},this.setReferenceSpaceType=function(value){referenceSpaceType=value,!0===scope.isPresenting&&console.warn("THREE.WebXRManager: Cannot change reference space type while presenting.")},this.getReferenceSpace=function(){return referenceSpace},this.getSession=function(){return session},this.setSession=function(value){if(session=value,null!==session){session.addEventListener("select",onSessionEvent),session.addEventListener("selectstart",onSessionEvent),session.addEventListener("selectend",onSessionEvent),session.addEventListener("squeeze",onSessionEvent),session.addEventListener("squeezestart",onSessionEvent),session.addEventListener("squeezeend",onSessionEvent),session.addEventListener("end",onSessionEnd);const attributes=gl.getContextAttributes();!0!==attributes.xrCompatible&&gl.makeXRCompatible();const layerInit={antialias:attributes.antialias,alpha:attributes.alpha,depth:attributes.depth,stencil:attributes.stencil,framebufferScaleFactor},baseLayer=new XRWebGLLayer(session,gl,layerInit);session.updateRenderState({baseLayer}),session.requestReferenceSpace(referenceSpaceType).then(onRequestReferenceSpace),session.addEventListener("inputsourceschange",updateInputSources)}};const cameraLPos=new Vector3,cameraRPos=new Vector3;function updateCamera(camera,parent){null===parent?camera.matrixWorld.copy(camera.matrix):camera.matrixWorld.multiplyMatrices(parent.matrixWorld,camera.matrix),camera.matrixWorldInverse.getInverse(camera.matrixWorld)}this.getCamera=function(camera){cameraVR.near=cameraR.near=cameraL.near=camera.near,cameraVR.far=cameraR.far=cameraL.far=camera.far,_currentDepthNear===cameraVR.near&&_currentDepthFar===cameraVR.far||(session.updateRenderState({depthNear:cameraVR.near,depthFar:cameraVR.far}),_currentDepthNear=cameraVR.near,_currentDepthFar=cameraVR.far);const parent=camera.parent,cameras=cameraVR.cameras;updateCamera(cameraVR,parent);for(let i=0;i<cameras.length;i++)updateCamera(cameras[i],parent);camera.matrixWorld.copy(cameraVR.matrixWorld);const children=camera.children;for(let i=0,l=children.length;i<l;i++)children[i].updateMatrixWorld(!0);return 2===cameras.length?function(camera,cameraL,cameraR){cameraLPos.setFromMatrixPosition(cameraL.matrixWorld),cameraRPos.setFromMatrixPosition(cameraR.matrixWorld);const ipd=cameraLPos.distanceTo(cameraRPos),projL=cameraL.projectionMatrix.elements,projR=cameraR.projectionMatrix.elements,near=projL[14]/(projL[10]-1),far=projL[14]/(projL[10]+1),topFov=(projL[9]+1)/projL[5],bottomFov=(projL[9]-1)/projL[5],leftFov=(projL[8]-1)/projL[0],rightFov=(projR[8]+1)/projR[0],left=near*leftFov,right=near*rightFov,zOffset=ipd/(-leftFov+rightFov),xOffset=zOffset*-leftFov;cameraL.matrixWorld.decompose(camera.position,camera.quaternion,camera.scale),camera.translateX(xOffset),camera.translateZ(zOffset),camera.matrixWorld.compose(camera.position,camera.quaternion,camera.scale),camera.matrixWorldInverse.getInverse(camera.matrixWorld);const near2=near+zOffset,far2=far+zOffset,left2=left-xOffset,right2=right+(ipd-xOffset),top2=topFov*far/far2*near2,bottom2=bottomFov*far/far2*near2;camera.projectionMatrix.makePerspective(left2,right2,top2,bottom2,near2,far2)}(cameraVR,cameraL,cameraR):cameraVR.projectionMatrix.copy(cameraL.projectionMatrix),cameraVR};let onAnimationFrameCallback=null;const animation=new WebGLAnimation;animation.setAnimationLoop((function(time,frame){if(pose=frame.getViewerPose(referenceSpace),null!==pose){const views=pose.views,baseLayer=session.renderState.baseLayer;renderer.setFramebuffer(baseLayer.framebuffer);let cameraVRNeedsUpdate=!1;views.length!==cameraVR.cameras.length&&(cameraVR.cameras.length=0,cameraVRNeedsUpdate=!0);for(let i=0;i<views.length;i++){const view=views[i],viewport=baseLayer.getViewport(view),camera=cameras[i];camera.matrix.fromArray(view.transform.matrix),camera.projectionMatrix.fromArray(view.projectionMatrix),camera.viewport.set(viewport.x,viewport.y,viewport.width,viewport.height),0===i&&cameraVR.matrix.copy(camera.matrix),!0===cameraVRNeedsUpdate&&cameraVR.cameras.push(camera)}}const inputSources=session.inputSources;for(let i=0;i<controllers.length;i++){const controller=controllers[i],inputSource=inputSources[i];controller.update(inputSource,frame,referenceSpace)}onAnimationFrameCallback&&onAnimationFrameCallback(time,frame)})),this.setAnimationLoop=function(callback){onAnimationFrameCallback=callback},this.dispose=function(){}}function WebGLMaterials(properties){function refreshUniformsCommon(uniforms,material,environment){uniforms.opacity.value=material.opacity,material.color&&uniforms.diffuse.value.copy(material.color),material.emissive&&uniforms.emissive.value.copy(material.emissive).multiplyScalar(material.emissiveIntensity),material.map&&(uniforms.map.value=material.map),material.alphaMap&&(uniforms.alphaMap.value=material.alphaMap),material.specularMap&&(uniforms.specularMap.value=material.specularMap);const envMap=material.envMap||environment;if(envMap){uniforms.envMap.value=envMap,uniforms.flipEnvMap.value=envMap.isCubeTexture?-1:1,uniforms.reflectivity.value=material.reflectivity,uniforms.refractionRatio.value=material.refractionRatio;var maxMipLevel=properties.get(envMap).__maxMipLevel;void 0!==maxMipLevel&&(uniforms.maxMipLevel.value=maxMipLevel)}let uvScaleMap,uv2ScaleMap;material.lightMap&&(uniforms.lightMap.value=material.lightMap,uniforms.lightMapIntensity.value=material.lightMapIntensity),material.aoMap&&(uniforms.aoMap.value=material.aoMap,uniforms.aoMapIntensity.value=material.aoMapIntensity),material.map?uvScaleMap=material.map:material.specularMap?uvScaleMap=material.specularMap:material.displacementMap?uvScaleMap=material.displacementMap:material.normalMap?uvScaleMap=material.normalMap:material.bumpMap?uvScaleMap=material.bumpMap:material.roughnessMap?uvScaleMap=material.roughnessMap:material.metalnessMap?uvScaleMap=material.metalnessMap:material.alphaMap?uvScaleMap=material.alphaMap:material.emissiveMap&&(uvScaleMap=material.emissiveMap),void 0!==uvScaleMap&&(uvScaleMap.isWebGLRenderTarget&&(uvScaleMap=uvScaleMap.texture),!0===uvScaleMap.matrixAutoUpdate&&uvScaleMap.updateMatrix(),uniforms.uvTransform.value.copy(uvScaleMap.matrix)),material.aoMap?uv2ScaleMap=material.aoMap:material.lightMap&&(uv2ScaleMap=material.lightMap),void 0!==uv2ScaleMap&&(uv2ScaleMap.isWebGLRenderTarget&&(uv2ScaleMap=uv2ScaleMap.texture),!0===uv2ScaleMap.matrixAutoUpdate&&uv2ScaleMap.updateMatrix(),uniforms.uv2Transform.value.copy(uv2ScaleMap.matrix))}function refreshUniformsStandard(uniforms,material,environment){uniforms.roughness.value=material.roughness,uniforms.metalness.value=material.metalness,material.roughnessMap&&(uniforms.roughnessMap.value=material.roughnessMap),material.metalnessMap&&(uniforms.metalnessMap.value=material.metalnessMap),material.emissiveMap&&(uniforms.emissiveMap.value=material.emissiveMap),material.bumpMap&&(uniforms.bumpMap.value=material.bumpMap,uniforms.bumpScale.value=material.bumpScale,1===material.side&&(uniforms.bumpScale.value*=-1)),material.normalMap&&(uniforms.normalMap.value=material.normalMap,uniforms.normalScale.value.copy(material.normalScale),1===material.side&&uniforms.normalScale.value.negate()),material.displacementMap&&(uniforms.displacementMap.value=material.displacementMap,uniforms.displacementScale.value=material.displacementScale,uniforms.displacementBias.value=material.displacementBias),(material.envMap||environment)&&(uniforms.envMapIntensity.value=material.envMapIntensity)}return{refreshFogUniforms:function(uniforms,fog){uniforms.fogColor.value.copy(fog.color),fog.isFog?(uniforms.fogNear.value=fog.near,uniforms.fogFar.value=fog.far):fog.isFogExp2&&(uniforms.fogDensity.value=fog.density)},refreshMaterialUniforms:function(uniforms,material,environment,pixelRatio,height){material.isMeshBasicMaterial?refreshUniformsCommon(uniforms,material):material.isMeshLambertMaterial?(refreshUniformsCommon(uniforms,material),function(uniforms,material){material.emissiveMap&&(uniforms.emissiveMap.value=material.emissiveMap)}(uniforms,material)):material.isMeshToonMaterial?(refreshUniformsCommon(uniforms,material),function(uniforms,material){material.gradientMap&&(uniforms.gradientMap.value=material.gradientMap);material.emissiveMap&&(uniforms.emissiveMap.value=material.emissiveMap);material.bumpMap&&(uniforms.bumpMap.value=material.bumpMap,uniforms.bumpScale.value=material.bumpScale,1===material.side&&(uniforms.bumpScale.value*=-1));material.normalMap&&(uniforms.normalMap.value=material.normalMap,uniforms.normalScale.value.copy(material.normalScale),1===material.side&&uniforms.normalScale.value.negate());material.displacementMap&&(uniforms.displacementMap.value=material.displacementMap,uniforms.displacementScale.value=material.displacementScale,uniforms.displacementBias.value=material.displacementBias)}(uniforms,material)):material.isMeshPhongMaterial?(refreshUniformsCommon(uniforms,material),function(uniforms,material){uniforms.specular.value.copy(material.specular),uniforms.shininess.value=Math.max(material.shininess,1e-4),material.emissiveMap&&(uniforms.emissiveMap.value=material.emissiveMap);material.bumpMap&&(uniforms.bumpMap.value=material.bumpMap,uniforms.bumpScale.value=material.bumpScale,1===material.side&&(uniforms.bumpScale.value*=-1));material.normalMap&&(uniforms.normalMap.value=material.normalMap,uniforms.normalScale.value.copy(material.normalScale),1===material.side&&uniforms.normalScale.value.negate());material.displacementMap&&(uniforms.displacementMap.value=material.displacementMap,uniforms.displacementScale.value=material.displacementScale,uniforms.displacementBias.value=material.displacementBias)}(uniforms,material)):material.isMeshStandardMaterial?(refreshUniformsCommon(uniforms,material,environment),material.isMeshPhysicalMaterial?function(uniforms,material,environment){refreshUniformsStandard(uniforms,material,environment),uniforms.reflectivity.value=material.reflectivity,uniforms.clearcoat.value=material.clearcoat,uniforms.clearcoatRoughness.value=material.clearcoatRoughness,material.sheen&&uniforms.sheen.value.copy(material.sheen);material.clearcoatMap&&(uniforms.clearcoatMap.value=material.clearcoatMap);material.clearcoatRoughnessMap&&(uniforms.clearcoatRoughnessMap.value=material.clearcoatRoughnessMap);material.clearcoatNormalMap&&(uniforms.clearcoatNormalScale.value.copy(material.clearcoatNormalScale),uniforms.clearcoatNormalMap.value=material.clearcoatNormalMap,1===material.side&&uniforms.clearcoatNormalScale.value.negate());uniforms.transmission.value=material.transmission,material.transmissionMap&&(uniforms.transmissionMap.value=material.transmissionMap)}(uniforms,material,environment):refreshUniformsStandard(uniforms,material,environment)):material.isMeshMatcapMaterial?(refreshUniformsCommon(uniforms,material),function(uniforms,material){material.matcap&&(uniforms.matcap.value=material.matcap);material.bumpMap&&(uniforms.bumpMap.value=material.bumpMap,uniforms.bumpScale.value=material.bumpScale,1===material.side&&(uniforms.bumpScale.value*=-1));material.normalMap&&(uniforms.normalMap.value=material.normalMap,uniforms.normalScale.value.copy(material.normalScale),1===material.side&&uniforms.normalScale.value.negate());material.displacementMap&&(uniforms.displacementMap.value=material.displacementMap,uniforms.displacementScale.value=material.displacementScale,uniforms.displacementBias.value=material.displacementBias)}(uniforms,material)):material.isMeshDepthMaterial?(refreshUniformsCommon(uniforms,material),function(uniforms,material){material.displacementMap&&(uniforms.displacementMap.value=material.displacementMap,uniforms.displacementScale.value=material.displacementScale,uniforms.displacementBias.value=material.displacementBias)}(uniforms,material)):material.isMeshDistanceMaterial?(refreshUniformsCommon(uniforms,material),function(uniforms,material){material.displacementMap&&(uniforms.displacementMap.value=material.displacementMap,uniforms.displacementScale.value=material.displacementScale,uniforms.displacementBias.value=material.displacementBias);uniforms.referencePosition.value.copy(material.referencePosition),uniforms.nearDistance.value=material.nearDistance,uniforms.farDistance.value=material.farDistance}(uniforms,material)):material.isMeshNormalMaterial?(refreshUniformsCommon(uniforms,material),function(uniforms,material){material.bumpMap&&(uniforms.bumpMap.value=material.bumpMap,uniforms.bumpScale.value=material.bumpScale,1===material.side&&(uniforms.bumpScale.value*=-1));material.normalMap&&(uniforms.normalMap.value=material.normalMap,uniforms.normalScale.value.copy(material.normalScale),1===material.side&&uniforms.normalScale.value.negate());material.displacementMap&&(uniforms.displacementMap.value=material.displacementMap,uniforms.displacementScale.value=material.displacementScale,uniforms.displacementBias.value=material.displacementBias)}(uniforms,material)):material.isLineBasicMaterial?(function(uniforms,material){uniforms.diffuse.value.copy(material.color),uniforms.opacity.value=material.opacity}(uniforms,material),material.isLineDashedMaterial&&function(uniforms,material){uniforms.dashSize.value=material.dashSize,uniforms.totalSize.value=material.dashSize+material.gapSize,uniforms.scale.value=material.scale}(uniforms,material)):material.isPointsMaterial?function(uniforms,material,pixelRatio,height){uniforms.diffuse.value.copy(material.color),uniforms.opacity.value=material.opacity,uniforms.size.value=material.size*pixelRatio,uniforms.scale.value=.5*height,material.map&&(uniforms.map.value=material.map);material.alphaMap&&(uniforms.alphaMap.value=material.alphaMap);let uvScaleMap;material.map?uvScaleMap=material.map:material.alphaMap&&(uvScaleMap=material.alphaMap);void 0!==uvScaleMap&&(!0===uvScaleMap.matrixAutoUpdate&&uvScaleMap.updateMatrix(),uniforms.uvTransform.value.copy(uvScaleMap.matrix))}(uniforms,material,pixelRatio,height):material.isSpriteMaterial?function(uniforms,material){uniforms.diffuse.value.copy(material.color),uniforms.opacity.value=material.opacity,uniforms.rotation.value=material.rotation,material.map&&(uniforms.map.value=material.map);material.alphaMap&&(uniforms.alphaMap.value=material.alphaMap);let uvScaleMap;material.map?uvScaleMap=material.map:material.alphaMap&&(uvScaleMap=material.alphaMap);void 0!==uvScaleMap&&(!0===uvScaleMap.matrixAutoUpdate&&uvScaleMap.updateMatrix(),uniforms.uvTransform.value.copy(uvScaleMap.matrix))}(uniforms,material):material.isShadowMaterial?(uniforms.color.value.copy(material.color),uniforms.opacity.value=material.opacity):material.isShaderMaterial&&(material.uniformsNeedUpdate=!1)}}}function WebGLRenderer(parameters){const _canvas=void 0!==(parameters=parameters||{}).canvas?parameters.canvas:document.createElementNS("http://www.w3.org/1999/xhtml","canvas"),_context=void 0!==parameters.context?parameters.context:null,_alpha=void 0!==parameters.alpha&&parameters.alpha,_depth=void 0===parameters.depth||parameters.depth,_stencil=void 0===parameters.stencil||parameters.stencil,_antialias=void 0!==parameters.antialias&&parameters.antialias,_premultipliedAlpha=void 0===parameters.premultipliedAlpha||parameters.premultipliedAlpha,_preserveDrawingBuffer=void 0!==parameters.preserveDrawingBuffer&&parameters.preserveDrawingBuffer,_powerPreference=void 0!==parameters.powerPreference?parameters.powerPreference:"default",_failIfMajorPerformanceCaveat=void 0!==parameters.failIfMajorPerformanceCaveat&&parameters.failIfMajorPerformanceCaveat;let currentRenderList=null,currentRenderState=null;this.domElement=_canvas,this.debug={checkShaderErrors:!0},this.autoClear=!0,this.autoClearColor=!0,this.autoClearDepth=!0,this.autoClearStencil=!0,this.sortObjects=!0,this.clippingPlanes=[],this.localClippingEnabled=!1,this.gammaFactor=2,this.outputEncoding=3e3,this.physicallyCorrectLights=!1,this.toneMapping=0,this.toneMappingExposure=1,this.maxMorphTargets=8,this.maxMorphNormals=4;const _this=this;let _isContextLost=!1,_framebuffer=null,_currentActiveCubeFace=0,_currentActiveMipmapLevel=0,_currentRenderTarget=null,_currentFramebuffer=null,_currentMaterialId=-1,_currentCamera=null,_currentArrayCamera=null;const _currentViewport=new Vector4,_currentScissor=new Vector4;let _currentScissorTest=null,_width=_canvas.width,_height=_canvas.height,_pixelRatio=1,_opaqueSort=null,_transparentSort=null;const _viewport=new Vector4(0,0,_width,_height),_scissor=new Vector4(0,0,_width,_height);let _scissorTest=!1;const _frustum=new Frustum,_clipping=new WebGLClipping;let _clippingEnabled=!1,_localClippingEnabled=!1;const _projScreenMatrix=new Matrix4,_vector3=new Vector3,_emptyScene={background:null,fog:null,environment:null,overrideMaterial:null,isScene:!0};function getTargetPixelRatio(){return null===_currentRenderTarget?_pixelRatio:1}let extensions,capabilities,state,info,properties,textures,attributes,geometries,objects,programCache,materials,renderLists,renderStates,background,morphtargets,bufferRenderer,indexedBufferRenderer,utils,bindingStates,_gl=_context;function getContext(contextNames,contextAttributes){for(let i=0;i<contextNames.length;i++){const contextName=contextNames[i],context=_canvas.getContext(contextName,contextAttributes);if(null!==context)return context}return null}try{const contextAttributes={alpha:_alpha,depth:_depth,stencil:_stencil,antialias:_antialias,premultipliedAlpha:_premultipliedAlpha,preserveDrawingBuffer:_preserveDrawingBuffer,powerPreference:_powerPreference,failIfMajorPerformanceCaveat:_failIfMajorPerformanceCaveat};if(_canvas.addEventListener("webglcontextlost",onContextLost,!1),_canvas.addEventListener("webglcontextrestored",onContextRestore,!1),null===_gl){const contextNames=["webgl2","webgl","experimental-webgl"];if(!0===_this.isWebGL1Renderer&&contextNames.shift(),_gl=getContext(contextNames,contextAttributes),null===_gl)throw getContext(contextNames)?new Error("Error creating WebGL context with your selected attributes."):new Error("Error creating WebGL context.")}void 0===_gl.getShaderPrecisionFormat&&(_gl.getShaderPrecisionFormat=function(){return{rangeMin:1,rangeMax:1,precision:1}})}catch(error){throw console.error("THREE.WebGLRenderer: "+error.message),error}function initGLContext(){extensions=new WebGLExtensions(_gl),capabilities=new WebGLCapabilities(_gl,extensions,parameters),!1===capabilities.isWebGL2&&(extensions.get("WEBGL_depth_texture"),extensions.get("OES_texture_float"),extensions.get("OES_texture_half_float"),extensions.get("OES_texture_half_float_linear"),extensions.get("OES_standard_derivatives"),extensions.get("OES_element_index_uint"),extensions.get("OES_vertex_array_object"),extensions.get("ANGLE_instanced_arrays")),extensions.get("OES_texture_float_linear"),utils=new WebGLUtils(_gl,extensions,capabilities),state=new WebGLState(_gl,extensions,capabilities),state.scissor(_currentScissor.copy(_scissor).multiplyScalar(_pixelRatio).floor()),state.viewport(_currentViewport.copy(_viewport).multiplyScalar(_pixelRatio).floor()),info=new WebGLInfo(_gl),properties=new WebGLProperties,textures=new WebGLTextures(_gl,extensions,state,properties,capabilities,utils,info),attributes=new WebGLAttributes(_gl,capabilities),bindingStates=new WebGLBindingStates(_gl,extensions,attributes,capabilities),geometries=new WebGLGeometries(_gl,attributes,info,bindingStates),objects=new WebGLObjects(_gl,geometries,attributes,info),morphtargets=new WebGLMorphtargets(_gl),programCache=new WebGLPrograms(_this,extensions,capabilities,bindingStates),materials=new WebGLMaterials(properties),renderLists=new WebGLRenderLists(properties),renderStates=new WebGLRenderStates,background=new WebGLBackground(_this,state,objects,_premultipliedAlpha),bufferRenderer=new WebGLBufferRenderer(_gl,extensions,info,capabilities),indexedBufferRenderer=new WebGLIndexedBufferRenderer(_gl,extensions,info,capabilities),info.programs=programCache.programs,_this.capabilities=capabilities,_this.extensions=extensions,_this.properties=properties,_this.renderLists=renderLists,_this.state=state,_this.info=info}initGLContext();const xr=new WebXRManager(_this,_gl);this.xr=xr;const shadowMap=new WebGLShadowMap(_this,objects,capabilities.maxTextureSize);function onContextLost(event){event.preventDefault(),console.log("THREE.WebGLRenderer: Context Lost."),_isContextLost=!0}function onContextRestore(){console.log("THREE.WebGLRenderer: Context Restored."),_isContextLost=!1,initGLContext()}function onMaterialDispose(event){const material=event.target;material.removeEventListener("dispose",onMaterialDispose),function(material){releaseMaterialProgramReference(material),properties.remove(material)}(material)}function releaseMaterialProgramReference(material){const programInfo=properties.get(material).program;void 0!==programInfo&&programCache.releaseProgram(programInfo)}this.shadowMap=shadowMap,this.getContext=function(){return _gl},this.getContextAttributes=function(){return _gl.getContextAttributes()},this.forceContextLoss=function(){const extension=extensions.get("WEBGL_lose_context");extension&&extension.loseContext()},this.forceContextRestore=function(){const extension=extensions.get("WEBGL_lose_context");extension&&extension.restoreContext()},this.getPixelRatio=function(){return _pixelRatio},this.setPixelRatio=function(value){void 0!==value&&(_pixelRatio=value,this.setSize(_width,_height,!1))},this.getSize=function(target){return void 0===target&&(console.warn("WebGLRenderer: .getsize() now requires a Vector2 as an argument"),target=new Vector2),target.set(_width,_height)},this.setSize=function(width,height,updateStyle){xr.isPresenting?console.warn("THREE.WebGLRenderer: Can't change size while VR device is presenting."):(_width=width,_height=height,_canvas.width=Math.floor(width*_pixelRatio),_canvas.height=Math.floor(height*_pixelRatio),!1!==updateStyle&&(_canvas.style.width=width+"px",_canvas.style.height=height+"px"),this.setViewport(0,0,width,height))},this.getDrawingBufferSize=function(target){return void 0===target&&(console.warn("WebGLRenderer: .getdrawingBufferSize() now requires a Vector2 as an argument"),target=new Vector2),target.set(_width*_pixelRatio,_height*_pixelRatio).floor()},this.setDrawingBufferSize=function(width,height,pixelRatio){_width=width,_height=height,_pixelRatio=pixelRatio,_canvas.width=Math.floor(width*pixelRatio),_canvas.height=Math.floor(height*pixelRatio),this.setViewport(0,0,width,height)},this.getCurrentViewport=function(target){return void 0===target&&(console.warn("WebGLRenderer: .getCurrentViewport() now requires a Vector4 as an argument"),target=new Vector4),target.copy(_currentViewport)},this.getViewport=function(target){return target.copy(_viewport)},this.setViewport=function(x,y,width,height){x.isVector4?_viewport.set(x.x,x.y,x.z,x.w):_viewport.set(x,y,width,height),state.viewport(_currentViewport.copy(_viewport).multiplyScalar(_pixelRatio).floor())},this.getScissor=function(target){return target.copy(_scissor)},this.setScissor=function(x,y,width,height){x.isVector4?_scissor.set(x.x,x.y,x.z,x.w):_scissor.set(x,y,width,height),state.scissor(_currentScissor.copy(_scissor).multiplyScalar(_pixelRatio).floor())},this.getScissorTest=function(){return _scissorTest},this.setScissorTest=function(boolean){state.setScissorTest(_scissorTest=boolean)},this.setOpaqueSort=function(method){_opaqueSort=method},this.setTransparentSort=function(method){_transparentSort=method},this.getClearColor=function(){return background.getClearColor()},this.setClearColor=function(){background.setClearColor.apply(background,arguments)},this.getClearAlpha=function(){return background.getClearAlpha()},this.setClearAlpha=function(){background.setClearAlpha.apply(background,arguments)},this.clear=function(color,depth,stencil){let bits=0;(void 0===color||color)&&(bits|=16384),(void 0===depth||depth)&&(bits|=256),(void 0===stencil||stencil)&&(bits|=1024),_gl.clear(bits)},this.clearColor=function(){this.clear(!0,!1,!1)},this.clearDepth=function(){this.clear(!1,!0,!1)},this.clearStencil=function(){this.clear(!1,!1,!0)},this.dispose=function(){_canvas.removeEventListener("webglcontextlost",onContextLost,!1),_canvas.removeEventListener("webglcontextrestored",onContextRestore,!1),renderLists.dispose(),renderStates.dispose(),properties.dispose(),objects.dispose(),bindingStates.dispose(),xr.dispose(),animation.stop()},this.renderBufferImmediate=function(object,program){bindingStates.initAttributes();const buffers=properties.get(object);object.hasPositions&&!buffers.position&&(buffers.position=_gl.createBuffer()),object.hasNormals&&!buffers.normal&&(buffers.normal=_gl.createBuffer()),object.hasUvs&&!buffers.uv&&(buffers.uv=_gl.createBuffer()),object.hasColors&&!buffers.color&&(buffers.color=_gl.createBuffer());const programAttributes=program.getAttributes();object.hasPositions&&(_gl.bindBuffer(34962,buffers.position),_gl.bufferData(34962,object.positionArray,35048),bindingStates.enableAttribute(programAttributes.position),_gl.vertexAttribPointer(programAttributes.position,3,5126,!1,0,0)),object.hasNormals&&(_gl.bindBuffer(34962,buffers.normal),_gl.bufferData(34962,object.normalArray,35048),bindingStates.enableAttribute(programAttributes.normal),_gl.vertexAttribPointer(programAttributes.normal,3,5126,!1,0,0)),object.hasUvs&&(_gl.bindBuffer(34962,buffers.uv),_gl.bufferData(34962,object.uvArray,35048),bindingStates.enableAttribute(programAttributes.uv),_gl.vertexAttribPointer(programAttributes.uv,2,5126,!1,0,0)),object.hasColors&&(_gl.bindBuffer(34962,buffers.color),_gl.bufferData(34962,object.colorArray,35048),bindingStates.enableAttribute(programAttributes.color),_gl.vertexAttribPointer(programAttributes.color,3,5126,!1,0,0)),bindingStates.disableUnusedAttributes(),_gl.drawArrays(4,0,object.count),object.count=0},this.renderBufferDirect=function(camera,scene,geometry,material,object,group){null===scene&&(scene=_emptyScene);const frontFaceCW=object.isMesh&&object.matrixWorld.determinant()<0,program=setProgram(camera,scene,material,object);state.setMaterial(material,frontFaceCW);let index=geometry.index;const position=geometry.attributes.position;if(null===index){if(void 0===position||0===position.count)return}else if(0===index.count)return;let attribute,rangeFactor=1;!0===material.wireframe&&(index=geometries.getWireframeAttribute(geometry),rangeFactor=2),(material.morphTargets||material.morphNormals)&&morphtargets.update(object,geometry,material,program),bindingStates.setup(object,material,program,geometry,index);let renderer=bufferRenderer;null!==index&&(attribute=attributes.get(index),renderer=indexedBufferRenderer,renderer.setIndex(attribute));const dataCount=null!==index?index.count:position.count,rangeStart=geometry.drawRange.start*rangeFactor,rangeCount=geometry.drawRange.count*rangeFactor,groupStart=null!==group?group.start*rangeFactor:0,groupCount=null!==group?group.count*rangeFactor:1/0,drawStart=Math.max(rangeStart,groupStart),drawEnd=Math.min(dataCount,rangeStart+rangeCount,groupStart+groupCount)-1,drawCount=Math.max(0,drawEnd-drawStart+1);if(0!==drawCount){if(object.isMesh)!0===material.wireframe?(state.setLineWidth(material.wireframeLinewidth*getTargetPixelRatio()),renderer.setMode(1)):renderer.setMode(4);else if(object.isLine){let lineWidth=material.linewidth;void 0===lineWidth&&(lineWidth=1),state.setLineWidth(lineWidth*getTargetPixelRatio()),object.isLineSegments?renderer.setMode(1):object.isLineLoop?renderer.setMode(2):renderer.setMode(3)}else object.isPoints?renderer.setMode(0):object.isSprite&&renderer.setMode(4);if(object.isInstancedMesh)renderer.renderInstances(drawStart,drawCount,object.count);else if(geometry.isInstancedBufferGeometry){const instanceCount=Math.min(geometry.instanceCount,geometry._maxInstanceCount);renderer.renderInstances(drawStart,drawCount,instanceCount)}else renderer.render(drawStart,drawCount)}},this.compile=function(scene,camera){currentRenderState=renderStates.get(scene,camera),currentRenderState.init(),scene.traverse((function(object){object.isLight&&(currentRenderState.pushLight(object),object.castShadow&&currentRenderState.pushShadow(object))})),currentRenderState.setupLights(camera);const compiled=new WeakMap;scene.traverse((function(object){let material=object.material;if(material)if(Array.isArray(material))for(let i=0;i<material.length;i++){let material2=material[i];!1===compiled.has(material2)&&(initMaterial(material2,scene,object),compiled.set(material2))}else!1===compiled.has(material)&&(initMaterial(material,scene,object),compiled.set(material))}))};let onAnimationFrameCallback=null;const animation=new WebGLAnimation;function projectObject(object,camera,groupOrder,sortObjects){if(!1===object.visible)return;if(object.layers.test(camera.layers))if(object.isGroup)groupOrder=object.renderOrder;else if(object.isLOD)!0===object.autoUpdate&&object.update(camera);else if(object.isLight)currentRenderState.pushLight(object),object.castShadow&&currentRenderState.pushShadow(object);else if(object.isSprite){if(!object.frustumCulled||_frustum.intersectsSprite(object)){sortObjects&&_vector3.setFromMatrixPosition(object.matrixWorld).applyMatrix4(_projScreenMatrix);const geometry=objects.update(object),material=object.material;material.visible&&currentRenderList.push(object,geometry,material,groupOrder,_vector3.z,null)}}else if(object.isImmediateRenderObject)sortObjects&&_vector3.setFromMatrixPosition(object.matrixWorld).applyMatrix4(_projScreenMatrix),currentRenderList.push(object,null,object.material,groupOrder,_vector3.z,null);else if((object.isMesh||object.isLine||object.isPoints)&&(object.isSkinnedMesh&&object.skeleton.frame!==info.render.frame&&(object.skeleton.update(),object.skeleton.frame=info.render.frame),!object.frustumCulled||_frustum.intersectsObject(object))){sortObjects&&_vector3.setFromMatrixPosition(object.matrixWorld).applyMatrix4(_projScreenMatrix);const geometry=objects.update(object),material=object.material;if(Array.isArray(material)){const groups=geometry.groups;for(let i=0,l=groups.length;i<l;i++){const group=groups[i],groupMaterial=material[group.materialIndex];groupMaterial&&groupMaterial.visible&&currentRenderList.push(object,geometry,groupMaterial,groupOrder,_vector3.z,group)}}else material.visible&&currentRenderList.push(object,geometry,material,groupOrder,_vector3.z,null)}const children=object.children;for(let i=0,l=children.length;i<l;i++)projectObject(children[i],camera,groupOrder,sortObjects)}function renderObjects(renderList,scene,camera){const overrideMaterial=!0===scene.isScene?scene.overrideMaterial:null;for(let i=0,l=renderList.length;i<l;i++){const renderItem=renderList[i],object=renderItem.object,geometry=renderItem.geometry,material=null===overrideMaterial?renderItem.material:overrideMaterial,group=renderItem.group;if(camera.isArrayCamera){_currentArrayCamera=camera;const cameras=camera.cameras;for(let j=0,jl=cameras.length;j<jl;j++){const camera2=cameras[j];object.layers.test(camera2.layers)&&(state.viewport(_currentViewport.copy(camera2.viewport)),currentRenderState.setupLights(camera2),renderObject(object,scene,camera2,geometry,material,group))}}else _currentArrayCamera=null,renderObject(object,scene,camera,geometry,material,group)}}function renderObject(object,scene,camera,geometry,material,group){if(object.onBeforeRender(_this,scene,camera,geometry,material,group),currentRenderState=renderStates.get(scene,_currentArrayCamera||camera),object.modelViewMatrix.multiplyMatrices(camera.matrixWorldInverse,object.matrixWorld),object.normalMatrix.getNormalMatrix(object.modelViewMatrix),object.isImmediateRenderObject){const program=setProgram(camera,scene,material,object);state.setMaterial(material),bindingStates.reset(),function(object,program){object.render((function(object){_this.renderBufferImmediate(object,program)}))}(object,program)}else _this.renderBufferDirect(camera,scene,geometry,material,object,group);object.onAfterRender(_this,scene,camera,geometry,material,group),currentRenderState=renderStates.get(scene,_currentArrayCamera||camera)}function initMaterial(material,scene,object){!0!==scene.isScene&&(scene=_emptyScene);const materialProperties=properties.get(material),lights=currentRenderState.state.lights,shadowsArray=currentRenderState.state.shadowsArray,lightsStateVersion=lights.state.version,parameters=programCache.getParameters(material,lights.state,shadowsArray,scene,_clipping.numPlanes,_clipping.numIntersection,object),programCacheKey=programCache.getProgramCacheKey(parameters);let program=materialProperties.program,programChange=!0;if(void 0===program)material.addEventListener("dispose",onMaterialDispose);else if(program.cacheKey!==programCacheKey)releaseMaterialProgramReference(material);else if(materialProperties.lightsStateVersion!==lightsStateVersion)materialProperties.lightsStateVersion=lightsStateVersion,programChange=!1;else{if(void 0!==parameters.shaderID)return;programChange=!1}programChange&&(parameters.uniforms=programCache.getUniforms(material,parameters),material.onBeforeCompile(parameters,_this),program=programCache.acquireProgram(parameters,programCacheKey),materialProperties.program=program,materialProperties.uniforms=parameters.uniforms,materialProperties.outputEncoding=parameters.outputEncoding);const programAttributes=program.getAttributes();if(material.morphTargets){material.numSupportedMorphTargets=0;for(let i=0;i<_this.maxMorphTargets;i++)programAttributes["morphTarget"+i]>=0&&material.numSupportedMorphTargets++}if(material.morphNormals){material.numSupportedMorphNormals=0;for(let i=0;i<_this.maxMorphNormals;i++)programAttributes["morphNormal"+i]>=0&&material.numSupportedMorphNormals++}const uniforms=materialProperties.uniforms;(material.isShaderMaterial||material.isRawShaderMaterial)&&!0!==material.clipping||(materialProperties.numClippingPlanes=_clipping.numPlanes,materialProperties.numIntersection=_clipping.numIntersection,uniforms.clippingPlanes=_clipping.uniform),materialProperties.environment=material.isMeshStandardMaterial?scene.environment:null,materialProperties.fog=scene.fog,materialProperties.needsLights=function(material){return material.isMeshLambertMaterial||material.isMeshToonMaterial||material.isMeshPhongMaterial||material.isMeshStandardMaterial||material.isShadowMaterial||material.isShaderMaterial&&!0===material.lights}(material),materialProperties.lightsStateVersion=lightsStateVersion,materialProperties.needsLights&&(uniforms.ambientLightColor.value=lights.state.ambient,uniforms.lightProbe.value=lights.state.probe,uniforms.directionalLights.value=lights.state.directional,uniforms.directionalLightShadows.value=lights.state.directionalShadow,uniforms.spotLights.value=lights.state.spot,uniforms.spotLightShadows.value=lights.state.spotShadow,uniforms.rectAreaLights.value=lights.state.rectArea,uniforms.pointLights.value=lights.state.point,uniforms.pointLightShadows.value=lights.state.pointShadow,uniforms.hemisphereLights.value=lights.state.hemi,uniforms.directionalShadowMap.value=lights.state.directionalShadowMap,uniforms.directionalShadowMatrix.value=lights.state.directionalShadowMatrix,uniforms.spotShadowMap.value=lights.state.spotShadowMap,uniforms.spotShadowMatrix.value=lights.state.spotShadowMatrix,uniforms.pointShadowMap.value=lights.state.pointShadowMap,uniforms.pointShadowMatrix.value=lights.state.pointShadowMatrix);const progUniforms=materialProperties.program.getUniforms(),uniformsList=WebGLUniforms.seqWithValue(progUniforms.seq,uniforms);materialProperties.uniformsList=uniformsList}function setProgram(camera,scene,material,object){!0!==scene.isScene&&(scene=_emptyScene),textures.resetTextureUnits();const fog=scene.fog,environment=material.isMeshStandardMaterial?scene.environment:null,encoding=null===_currentRenderTarget?_this.outputEncoding:_currentRenderTarget.texture.encoding,materialProperties=properties.get(material),lights=currentRenderState.state.lights;if(!0===_clippingEnabled&&(!0===_localClippingEnabled||camera!==_currentCamera)){const useCache=camera===_currentCamera&&material.id===_currentMaterialId;_clipping.setState(material.clippingPlanes,material.clipIntersection,material.clipShadows,camera,materialProperties,useCache)}material.version===materialProperties.__version?void 0===materialProperties.program||material.fog&&materialProperties.fog!==fog||materialProperties.environment!==environment||materialProperties.needsLights&&materialProperties.lightsStateVersion!==lights.state.version?initMaterial(material,scene,object):void 0===materialProperties.numClippingPlanes||materialProperties.numClippingPlanes===_clipping.numPlanes&&materialProperties.numIntersection===_clipping.numIntersection?materialProperties.outputEncoding!==encoding&&initMaterial(material,scene,object):initMaterial(material,scene,object):(initMaterial(material,scene,object),materialProperties.__version=material.version);let refreshProgram=!1,refreshMaterial=!1,refreshLights=!1;const program=materialProperties.program,p_uniforms=program.getUniforms(),m_uniforms=materialProperties.uniforms;if(state.useProgram(program.program)&&(refreshProgram=!0,refreshMaterial=!0,refreshLights=!0),material.id!==_currentMaterialId&&(_currentMaterialId=material.id,refreshMaterial=!0),refreshProgram||_currentCamera!==camera){if(p_uniforms.setValue(_gl,"projectionMatrix",camera.projectionMatrix),capabilities.logarithmicDepthBuffer&&p_uniforms.setValue(_gl,"logDepthBufFC",2/(Math.log(camera.far+1)/Math.LN2)),_currentCamera!==camera&&(_currentCamera=camera,refreshMaterial=!0,refreshLights=!0),material.isShaderMaterial||material.isMeshPhongMaterial||material.isMeshToonMaterial||material.isMeshStandardMaterial||material.envMap){const uCamPos=p_uniforms.map.cameraPosition;void 0!==uCamPos&&uCamPos.setValue(_gl,_vector3.setFromMatrixPosition(camera.matrixWorld))}(material.isMeshPhongMaterial||material.isMeshToonMaterial||material.isMeshLambertMaterial||material.isMeshBasicMaterial||material.isMeshStandardMaterial||material.isShaderMaterial)&&p_uniforms.setValue(_gl,"isOrthographic",!0===camera.isOrthographicCamera),(material.isMeshPhongMaterial||material.isMeshToonMaterial||material.isMeshLambertMaterial||material.isMeshBasicMaterial||material.isMeshStandardMaterial||material.isShaderMaterial||material.isShadowMaterial||material.skinning)&&p_uniforms.setValue(_gl,"viewMatrix",camera.matrixWorldInverse)}if(material.skinning){p_uniforms.setOptional(_gl,object,"bindMatrix"),p_uniforms.setOptional(_gl,object,"bindMatrixInverse");const skeleton=object.skeleton;if(skeleton){const bones=skeleton.bones;if(capabilities.floatVertexTextures){if(void 0===skeleton.boneTexture){let size=Math.sqrt(4*bones.length);size=MathUtils.ceilPowerOfTwo(size),size=Math.max(size,4);const boneMatrices=new Float32Array(size*size*4);boneMatrices.set(skeleton.boneMatrices);const boneTexture=new DataTexture(boneMatrices,size,size,1023,1015);skeleton.boneMatrices=boneMatrices,skeleton.boneTexture=boneTexture,skeleton.boneTextureSize=size}p_uniforms.setValue(_gl,"boneTexture",skeleton.boneTexture,textures),p_uniforms.setValue(_gl,"boneTextureSize",skeleton.boneTextureSize)}else p_uniforms.setOptional(_gl,skeleton,"boneMatrices")}}var uniforms,value;return(refreshMaterial||materialProperties.receiveShadow!==object.receiveShadow)&&(materialProperties.receiveShadow=object.receiveShadow,p_uniforms.setValue(_gl,"receiveShadow",object.receiveShadow)),refreshMaterial&&(p_uniforms.setValue(_gl,"toneMappingExposure",_this.toneMappingExposure),materialProperties.needsLights&&(value=refreshLights,(uniforms=m_uniforms).ambientLightColor.needsUpdate=value,uniforms.lightProbe.needsUpdate=value,uniforms.directionalLights.needsUpdate=value,uniforms.directionalLightShadows.needsUpdate=value,uniforms.pointLights.needsUpdate=value,uniforms.pointLightShadows.needsUpdate=value,uniforms.spotLights.needsUpdate=value,uniforms.spotLightShadows.needsUpdate=value,uniforms.rectAreaLights.needsUpdate=value,uniforms.hemisphereLights.needsUpdate=value),fog&&material.fog&&materials.refreshFogUniforms(m_uniforms,fog),materials.refreshMaterialUniforms(m_uniforms,material,environment,_pixelRatio,_height),void 0!==m_uniforms.ltc_1&&(m_uniforms.ltc_1.value=UniformsLib.LTC_1),void 0!==m_uniforms.ltc_2&&(m_uniforms.ltc_2.value=UniformsLib.LTC_2),WebGLUniforms.upload(_gl,materialProperties.uniformsList,m_uniforms,textures)),material.isShaderMaterial&&!0===material.uniformsNeedUpdate&&(WebGLUniforms.upload(_gl,materialProperties.uniformsList,m_uniforms,textures),material.uniformsNeedUpdate=!1),material.isSpriteMaterial&&p_uniforms.setValue(_gl,"center",object.center),p_uniforms.setValue(_gl,"modelViewMatrix",object.modelViewMatrix),p_uniforms.setValue(_gl,"normalMatrix",object.normalMatrix),p_uniforms.setValue(_gl,"modelMatrix",object.matrixWorld),program}animation.setAnimationLoop((function(time){xr.isPresenting||onAnimationFrameCallback&&onAnimationFrameCallback(time)})),"undefined"!=typeof window&&animation.setContext(window),this.setAnimationLoop=function(callback){onAnimationFrameCallback=callback,xr.setAnimationLoop(callback),null===callback?animation.stop():animation.start()},this.render=function(scene,camera){let renderTarget,forceClear;if(void 0!==arguments[2]&&(console.warn("THREE.WebGLRenderer.render(): the renderTarget argument has been removed. Use .setRenderTarget() instead."),renderTarget=arguments[2]),void 0!==arguments[3]&&(console.warn("THREE.WebGLRenderer.render(): the forceClear argument has been removed. Use .clear() instead."),forceClear=arguments[3]),void 0!==camera&&!0!==camera.isCamera)return void console.error("THREE.WebGLRenderer.render: camera is not an instance of THREE.Camera.");if(!0===_isContextLost)return;bindingStates.resetDefaultState(),_currentMaterialId=-1,_currentCamera=null,!0===scene.autoUpdate&&scene.updateMatrixWorld(),null===camera.parent&&camera.updateMatrixWorld(),!0===xr.enabled&&!0===xr.isPresenting&&(camera=xr.getCamera(camera)),!0===scene.isScene&&scene.onBeforeRender(_this,scene,camera,renderTarget||_currentRenderTarget),currentRenderState=renderStates.get(scene,camera),currentRenderState.init(),_projScreenMatrix.multiplyMatrices(camera.projectionMatrix,camera.matrixWorldInverse),_frustum.setFromProjectionMatrix(_projScreenMatrix),_localClippingEnabled=this.localClippingEnabled,_clippingEnabled=_clipping.init(this.clippingPlanes,_localClippingEnabled,camera),currentRenderList=renderLists.get(scene,camera),currentRenderList.init(),projectObject(scene,camera,0,_this.sortObjects),currentRenderList.finish(),!0===_this.sortObjects&&currentRenderList.sort(_opaqueSort,_transparentSort),!0===_clippingEnabled&&_clipping.beginShadows();const shadowsArray=currentRenderState.state.shadowsArray;shadowMap.render(shadowsArray,scene,camera),currentRenderState.setupLights(camera),!0===_clippingEnabled&&_clipping.endShadows(),!0===this.info.autoReset&&this.info.reset(),void 0!==renderTarget&&this.setRenderTarget(renderTarget),background.render(currentRenderList,scene,camera,forceClear);const opaqueObjects=currentRenderList.opaque,transparentObjects=currentRenderList.transparent;opaqueObjects.length>0&&renderObjects(opaqueObjects,scene,camera),transparentObjects.length>0&&renderObjects(transparentObjects,scene,camera),!0===scene.isScene&&scene.onAfterRender(_this,scene,camera),null!==_currentRenderTarget&&(textures.updateRenderTargetMipmap(_currentRenderTarget),textures.updateMultisampleRenderTarget(_currentRenderTarget)),state.buffers.depth.setTest(!0),state.buffers.depth.setMask(!0),state.buffers.color.setMask(!0),state.setPolygonOffset(!1),currentRenderList=null,currentRenderState=null},this.setFramebuffer=function(value){_framebuffer!==value&&null===_currentRenderTarget&&_gl.bindFramebuffer(36160,value),_framebuffer=value},this.getActiveCubeFace=function(){return _currentActiveCubeFace},this.getActiveMipmapLevel=function(){return _currentActiveMipmapLevel},this.getRenderTarget=function(){return _currentRenderTarget},this.setRenderTarget=function(renderTarget,activeCubeFace,activeMipmapLevel){_currentRenderTarget=renderTarget,_currentActiveCubeFace=activeCubeFace,_currentActiveMipmapLevel=activeMipmapLevel,renderTarget&&void 0===properties.get(renderTarget).__webglFramebuffer&&textures.setupRenderTarget(renderTarget);let framebuffer=_framebuffer,isCube=!1;if(renderTarget){const __webglFramebuffer=properties.get(renderTarget).__webglFramebuffer;renderTarget.isWebGLCubeRenderTarget?(framebuffer=__webglFramebuffer[activeCubeFace||0],isCube=!0):framebuffer=renderTarget.isWebGLMultisampleRenderTarget?properties.get(renderTarget).__webglMultisampledFramebuffer:__webglFramebuffer,_currentViewport.copy(renderTarget.viewport),_currentScissor.copy(renderTarget.scissor),_currentScissorTest=renderTarget.scissorTest}else _currentViewport.copy(_viewport).multiplyScalar(_pixelRatio).floor(),_currentScissor.copy(_scissor).multiplyScalar(_pixelRatio).floor(),_currentScissorTest=_scissorTest;if(_currentFramebuffer!==framebuffer&&(_gl.bindFramebuffer(36160,framebuffer),_currentFramebuffer=framebuffer),state.viewport(_currentViewport),state.scissor(_currentScissor),state.setScissorTest(_currentScissorTest),isCube){const textureProperties=properties.get(renderTarget.texture);_gl.framebufferTexture2D(36160,36064,34069+(activeCubeFace||0),textureProperties.__webglTexture,activeMipmapLevel||0)}},this.readRenderTargetPixels=function(renderTarget,x,y,width,height,buffer,activeCubeFaceIndex){if(!renderTarget||!renderTarget.isWebGLRenderTarget)return void console.error("THREE.WebGLRenderer.readRenderTargetPixels: renderTarget is not THREE.WebGLRenderTarget.");let framebuffer=properties.get(renderTarget).__webglFramebuffer;if(renderTarget.isWebGLCubeRenderTarget&&void 0!==activeCubeFaceIndex&&(framebuffer=framebuffer[activeCubeFaceIndex]),framebuffer){let restore=!1;framebuffer!==_currentFramebuffer&&(_gl.bindFramebuffer(36160,framebuffer),restore=!0);try{const texture=renderTarget.texture,textureFormat=texture.format,textureType=texture.type;if(1023!==textureFormat&&utils.convert(textureFormat)!==_gl.getParameter(35739))return void console.error("THREE.WebGLRenderer.readRenderTargetPixels: renderTarget is not in RGBA or implementation defined format.");if(!(1009===textureType||utils.convert(textureType)===_gl.getParameter(35738)||1015===textureType&&(capabilities.isWebGL2||extensions.get("OES_texture_float")||extensions.get("WEBGL_color_buffer_float"))||1016===textureType&&(capabilities.isWebGL2?extensions.get("EXT_color_buffer_float"):extensions.get("EXT_color_buffer_half_float"))))return void console.error("THREE.WebGLRenderer.readRenderTargetPixels: renderTarget is not in UnsignedByteType or implementation defined type.");36053===_gl.checkFramebufferStatus(36160)?x>=0&&x<=renderTarget.width-width&&y>=0&&y<=renderTarget.height-height&&_gl.readPixels(x,y,width,height,utils.convert(textureFormat),utils.convert(textureType),buffer):console.error("THREE.WebGLRenderer.readRenderTargetPixels: readPixels from renderTarget failed. Framebuffer not complete.")}finally{restore&&_gl.bindFramebuffer(36160,_currentFramebuffer)}}},this.copyFramebufferToTexture=function(position,texture,level){void 0===level&&(level=0);const levelScale=Math.pow(2,-level),width=Math.floor(texture.image.width*levelScale),height=Math.floor(texture.image.height*levelScale),glFormat=utils.convert(texture.format);textures.setTexture2D(texture,0),_gl.copyTexImage2D(3553,level,glFormat,position.x,position.y,width,height,0),state.unbindTexture()},this.copyTextureToTexture=function(position,srcTexture,dstTexture,level){void 0===level&&(level=0);const width=srcTexture.image.width,height=srcTexture.image.height,glFormat=utils.convert(dstTexture.format),glType=utils.convert(dstTexture.type);textures.setTexture2D(dstTexture,0),_gl.pixelStorei(37440,dstTexture.flipY),_gl.pixelStorei(37441,dstTexture.premultiplyAlpha),_gl.pixelStorei(3317,dstTexture.unpackAlignment),srcTexture.isDataTexture?_gl.texSubImage2D(3553,level,position.x,position.y,width,height,glFormat,glType,srcTexture.image.data):srcTexture.isCompressedTexture?_gl.compressedTexSubImage2D(3553,level,position.x,position.y,srcTexture.mipmaps[0].width,srcTexture.mipmaps[0].height,glFormat,srcTexture.mipmaps[0].data):_gl.texSubImage2D(3553,level,position.x,position.y,glFormat,glType,srcTexture.image),0===level&&dstTexture.generateMipmaps&&_gl.generateMipmap(3553),state.unbindTexture()},this.initTexture=function(texture){textures.setTexture2D(texture,0),state.unbindTexture()},"undefined"!=typeof __THREE_DEVTOOLS__&&__THREE_DEVTOOLS__.dispatchEvent(new CustomEvent("observe",{detail:this}))}function WebGL1Renderer(parameters){WebGLRenderer.call(this,parameters)}function FogExp2(color,density){this.name="",this.color=new Color(color),this.density=void 0!==density?density:25e-5}function Fog(color,near,far){this.name="",this.color=new Color(color),this.near=void 0!==near?near:1,this.far=void 0!==far?far:1e3}function InterleavedBuffer(array,stride){this.array=array,this.stride=stride,this.count=void 0!==array?array.length/stride:0,this.usage=35044,this.updateRange={offset:0,count:-1},this.version=0,this.uuid=MathUtils.generateUUID()}ArrayCamera.prototype=Object.assign(Object.create(PerspectiveCamera.prototype),{constructor:ArrayCamera,isArrayCamera:!0}),Group.prototype=Object.assign(Object.create(Object3D.prototype),{constructor:Group,isGroup:!0}),Object.assign(WebXRController.prototype,{constructor:WebXRController,getHandSpace:function(){if(null===this._hand&&(this._hand=new Group,this._hand.matrixAutoUpdate=!1,this._hand.visible=!1,this._hand.joints=[],this._hand.inputState={pinching:!1},window.XRHand))for(let i=0;i<=window.XRHand.LITTLE_PHALANX_TIP;i++){let joint=new Group;joint.matrixAutoUpdate=!1,joint.visible=!1,this._hand.joints.push(joint),this._hand.add(joint)}return this._hand},getTargetRaySpace:function(){return null===this._targetRay&&(this._targetRay=new Group,this._targetRay.matrixAutoUpdate=!1,this._targetRay.visible=!1),this._targetRay},getGripSpace:function(){return null===this._grip&&(this._grip=new Group,this._grip.matrixAutoUpdate=!1,this._grip.visible=!1),this._grip},dispatchEvent:function(event){return null!==this._targetRay&&this._targetRay.dispatchEvent(event),null!==this._grip&&this._grip.dispatchEvent(event),null!==this._hand&&this._hand.dispatchEvent(event),this},disconnect:function(inputSource){return this.dispatchEvent({type:"disconnected",data:inputSource}),null!==this._targetRay&&(this._targetRay.visible=!1),null!==this._grip&&(this._grip.visible=!1),null!==this._hand&&(this._hand.visible=!1),this},update:function(inputSource,frame,referenceSpace){let inputPose=null,gripPose=null,handPose=null;const targetRay=this._targetRay,grip=this._grip,hand=this._hand;if(inputSource)if(inputSource.hand){handPose=!0;for(let i=0;i<=window.XRHand.LITTLE_PHALANX_TIP;i++)if(inputSource.hand[i]){let jointPose=frame.getJointPose(inputSource.hand[i],referenceSpace);const joint=hand.joints[i];null!==jointPose&&(joint.matrix.fromArray(jointPose.transform.matrix),joint.matrix.decompose(joint.position,joint.rotation,joint.scale),joint.jointRadius=jointPose.radius),joint.visible=null!==jointPose;const indexTip=hand.joints[window.XRHand.INDEX_PHALANX_TIP],thumbTip=hand.joints[window.XRHand.THUMB_PHALANX_TIP],distance=indexTip.position.distanceTo(thumbTip.position),distanceToPinch=.02,threshold=.005;hand.inputState.pinching&&distance>distanceToPinch+threshold?(hand.inputState.pinching=!1,this.dispatchEvent({type:"pinchend",handedness:inputSource.handedness,target:this})):!hand.inputState.pinching&&distance<=distanceToPinch-threshold&&(hand.inputState.pinching=!0,this.dispatchEvent({type:"pinchstart",handedness:inputSource.handedness,target:this}))}}else null!==targetRay&&(inputPose=frame.getPose(inputSource.targetRaySpace,referenceSpace),null!==inputPose&&(targetRay.matrix.fromArray(inputPose.transform.matrix),targetRay.matrix.decompose(targetRay.position,targetRay.rotation,targetRay.scale))),null!==grip&&inputSource.gripSpace&&(gripPose=frame.getPose(inputSource.gripSpace,referenceSpace),null!==gripPose&&(grip.matrix.fromArray(gripPose.transform.matrix),grip.matrix.decompose(grip.position,grip.rotation,grip.scale)));return null!==targetRay&&(targetRay.visible=null!==inputPose),null!==grip&&(grip.visible=null!==gripPose),null!==hand&&(hand.visible=null!==handPose),this}}),Object.assign(WebXRManager.prototype,EventDispatcher.prototype),WebGL1Renderer.prototype=Object.assign(Object.create(WebGLRenderer.prototype),{constructor:WebGL1Renderer,isWebGL1Renderer:!0}),Object.assign(FogExp2.prototype,{isFogExp2:!0,clone:function(){return new FogExp2(this.color,this.density)},toJSON:function(){return{type:"FogExp2",color:this.color.getHex(),density:this.density}}}),Object.assign(Fog.prototype,{isFog:!0,clone:function(){return new Fog(this.color,this.near,this.far)},toJSON:function(){return{type:"Fog",color:this.color.getHex(),near:this.near,far:this.far}}}),Object.defineProperty(InterleavedBuffer.prototype,"needsUpdate",{set:function(value){!0===value&&this.version++}}),Object.assign(InterleavedBuffer.prototype,{isInterleavedBuffer:!0,onUploadCallback:function(){},setUsage:function(value){return this.usage=value,this},copy:function(source){return this.array=new source.array.constructor(source.array),this.count=source.count,this.stride=source.stride,this.usage=source.usage,this},copyAt:function(index1,attribute,index2){index1*=this.stride,index2*=attribute.stride;for(let i=0,l=this.stride;i<l;i++)this.array[index1+i]=attribute.array[index2+i];return this},set:function(value,offset){return void 0===offset&&(offset=0),this.array.set(value,offset),this},clone:function(data){void 0===data.arrayBuffers&&(data.arrayBuffers={}),void 0===this.array.buffer._uuid&&(this.array.buffer._uuid=MathUtils.generateUUID()),void 0===data.arrayBuffers[this.array.buffer._uuid]&&(data.arrayBuffers[this.array.buffer._uuid]=this.array.slice(0).buffer);const ib=new InterleavedBuffer(new this.array.constructor(data.arrayBuffers[this.array.buffer._uuid]),this.stride);return ib.setUsage(this.usage),ib},onUpload:function(callback){return this.onUploadCallback=callback,this},toJSON:function(data){return void 0===data.arrayBuffers&&(data.arrayBuffers={}),void 0===this.array.buffer._uuid&&(this.array.buffer._uuid=MathUtils.generateUUID()),void 0===data.arrayBuffers[this.array.buffer._uuid]&&(data.arrayBuffers[this.array.buffer._uuid]=Array.prototype.slice.call(new Uint32Array(this.array.buffer))),{uuid:this.uuid,buffer:this.array.buffer._uuid,type:this.array.constructor.name,stride:this.stride}}});const _vector$6=new Vector3;function InterleavedBufferAttribute(interleavedBuffer,itemSize,offset,normalized){this.name="",this.data=interleavedBuffer,this.itemSize=itemSize,this.offset=offset,this.normalized=!0===normalized}function SpriteMaterial(parameters){Material.call(this),this.type="SpriteMaterial",this.color=new Color(16777215),this.map=null,this.alphaMap=null,this.rotation=0,this.sizeAttenuation=!0,this.transparent=!0,this.setValues(parameters)}let _geometry;Object.defineProperties(InterleavedBufferAttribute.prototype,{count:{get:function(){return this.data.count}},array:{get:function(){return this.data.array}},needsUpdate:{set:function(value){this.data.needsUpdate=value}}}),Object.assign(InterleavedBufferAttribute.prototype,{isInterleavedBufferAttribute:!0,applyMatrix4:function(m){for(let i=0,l=this.data.count;i<l;i++)_vector$6.x=this.getX(i),_vector$6.y=this.getY(i),_vector$6.z=this.getZ(i),_vector$6.applyMatrix4(m),this.setXYZ(i,_vector$6.x,_vector$6.y,_vector$6.z);return this},setX:function(index,x){return this.data.array[index*this.data.stride+this.offset]=x,this},setY:function(index,y){return this.data.array[index*this.data.stride+this.offset+1]=y,this},setZ:function(index,z){return this.data.array[index*this.data.stride+this.offset+2]=z,this},setW:function(index,w){return this.data.array[index*this.data.stride+this.offset+3]=w,this},getX:function(index){return this.data.array[index*this.data.stride+this.offset]},getY:function(index){return this.data.array[index*this.data.stride+this.offset+1]},getZ:function(index){return this.data.array[index*this.data.stride+this.offset+2]},getW:function(index){return this.data.array[index*this.data.stride+this.offset+3]},setXY:function(index,x,y){return index=index*this.data.stride+this.offset,this.data.array[index+0]=x,this.data.array[index+1]=y,this},setXYZ:function(index,x,y,z){return index=index*this.data.stride+this.offset,this.data.array[index+0]=x,this.data.array[index+1]=y,this.data.array[index+2]=z,this},setXYZW:function(index,x,y,z,w){return index=index*this.data.stride+this.offset,this.data.array[index+0]=x,this.data.array[index+1]=y,this.data.array[index+2]=z,this.data.array[index+3]=w,this},clone:function(data){if(void 0===data){console.log("THREE.InterleavedBufferAttribute.clone(): Cloning an interlaved buffer attribute will deinterleave buffer data.");const array=[];for(let i=0;i<this.count;i++){const index=i*this.data.stride+this.offset;for(let j=0;j<this.itemSize;j++)array.push(this.data.array[index+j])}return new BufferAttribute(new this.array.constructor(array),this.itemSize,this.normalized)}return void 0===data.interleavedBuffers&&(data.interleavedBuffers={}),void 0===data.interleavedBuffers[this.data.uuid]&&(data.interleavedBuffers[this.data.uuid]=this.data.clone(data)),new InterleavedBufferAttribute(data.interleavedBuffers[this.data.uuid],this.itemSize,this.offset,this.normalized)},toJSON:function(data){if(void 0===data){console.log("THREE.InterleavedBufferAttribute.toJSON(): Serializing an interlaved buffer attribute will deinterleave buffer data.");const array=[];for(let i=0;i<this.count;i++){const index=i*this.data.stride+this.offset;for(let j=0;j<this.itemSize;j++)array.push(this.data.array[index+j])}return{itemSize:this.itemSize,type:this.array.constructor.name,array,normalized:this.normalized}}return void 0===data.interleavedBuffers&&(data.interleavedBuffers={}),void 0===data.interleavedBuffers[this.data.uuid]&&(data.interleavedBuffers[this.data.uuid]=this.data.toJSON(data)),{isInterleavedBufferAttribute:!0,itemSize:this.itemSize,data:this.data.uuid,offset:this.offset,normalized:this.normalized}}}),SpriteMaterial.prototype=Object.create(Material.prototype),SpriteMaterial.prototype.constructor=SpriteMaterial,SpriteMaterial.prototype.isSpriteMaterial=!0,SpriteMaterial.prototype.copy=function(source){return Material.prototype.copy.call(this,source),this.color.copy(source.color),this.map=source.map,this.alphaMap=source.alphaMap,this.rotation=source.rotation,this.sizeAttenuation=source.sizeAttenuation,this};const _intersectPoint=new Vector3,_worldScale=new Vector3,_mvPosition=new Vector3,_alignedPosition=new Vector2,_rotatedPosition=new Vector2,_viewWorldMatrix=new Matrix4,_vA$1=new Vector3,_vB$1=new Vector3,_vC$1=new Vector3,_uvA$1=new Vector2,_uvB$1=new Vector2,_uvC$1=new Vector2;function Sprite(material){if(Object3D.call(this),this.type="Sprite",void 0===_geometry){_geometry=new BufferGeometry;const interleavedBuffer=new InterleavedBuffer(new Float32Array([-.5,-.5,0,0,0,.5,-.5,0,1,0,.5,.5,0,1,1,-.5,.5,0,0,1]),5);_geometry.setIndex([0,1,2,0,2,3]),_geometry.setAttribute("position",new InterleavedBufferAttribute(interleavedBuffer,3,0,!1)),_geometry.setAttribute("uv",new InterleavedBufferAttribute(interleavedBuffer,2,3,!1))}this.geometry=_geometry,this.material=void 0!==material?material:new SpriteMaterial,this.center=new Vector2(.5,.5)}function transformVertex(vertexPosition,mvPosition,center,scale,sin,cos){_alignedPosition.subVectors(vertexPosition,center).addScalar(.5).multiply(scale),void 0!==sin?(_rotatedPosition.x=cos*_alignedPosition.x-sin*_alignedPosition.y,_rotatedPosition.y=sin*_alignedPosition.x+cos*_alignedPosition.y):_rotatedPosition.copy(_alignedPosition),vertexPosition.copy(mvPosition),vertexPosition.x+=_rotatedPosition.x,vertexPosition.y+=_rotatedPosition.y,vertexPosition.applyMatrix4(_viewWorldMatrix)}Sprite.prototype=Object.assign(Object.create(Object3D.prototype),{constructor:Sprite,isSprite:!0,raycast:function(raycaster,intersects){null===raycaster.camera&&console.error('THREE.Sprite: "Raycaster.camera" needs to be set in order to raycast against sprites.'),_worldScale.setFromMatrixScale(this.matrixWorld),_viewWorldMatrix.copy(raycaster.camera.matrixWorld),this.modelViewMatrix.multiplyMatrices(raycaster.camera.matrixWorldInverse,this.matrixWorld),_mvPosition.setFromMatrixPosition(this.modelViewMatrix),raycaster.camera.isPerspectiveCamera&&!1===this.material.sizeAttenuation&&_worldScale.multiplyScalar(-_mvPosition.z);const rotation=this.material.rotation;let sin,cos;0!==rotation&&(cos=Math.cos(rotation),sin=Math.sin(rotation));const center=this.center;transformVertex(_vA$1.set(-.5,-.5,0),_mvPosition,center,_worldScale,sin,cos),transformVertex(_vB$1.set(.5,-.5,0),_mvPosition,center,_worldScale,sin,cos),transformVertex(_vC$1.set(.5,.5,0),_mvPosition,center,_worldScale,sin,cos),_uvA$1.set(0,0),_uvB$1.set(1,0),_uvC$1.set(1,1);let intersect=raycaster.ray.intersectTriangle(_vA$1,_vB$1,_vC$1,!1,_intersectPoint);if(null===intersect&&(transformVertex(_vB$1.set(-.5,.5,0),_mvPosition,center,_worldScale,sin,cos),_uvB$1.set(0,1),intersect=raycaster.ray.intersectTriangle(_vA$1,_vC$1,_vB$1,!1,_intersectPoint),null===intersect))return;const distance=raycaster.ray.origin.distanceTo(_intersectPoint);distance<raycaster.near||distance>raycaster.far||intersects.push({distance,point:_intersectPoint.clone(),uv:Triangle.getUV(_intersectPoint,_vA$1,_vB$1,_vC$1,_uvA$1,_uvB$1,_uvC$1,new Vector2),face:null,object:this})},copy:function(source){return Object3D.prototype.copy.call(this,source),void 0!==source.center&&this.center.copy(source.center),this.material=source.material,this}});const _v1$4=new Vector3,_v2$2=new Vector3;function LOD(){Object3D.call(this),this._currentLevel=0,this.type="LOD",Object.defineProperties(this,{levels:{enumerable:!0,value:[]}}),this.autoUpdate=!0}function SkinnedMesh(geometry,material){geometry&&geometry.isGeometry&&console.error("THREE.SkinnedMesh no longer supports THREE.Geometry. Use THREE.BufferGeometry instead."),Mesh.call(this,geometry,material),this.type="SkinnedMesh",this.bindMode="attached",this.bindMatrix=new Matrix4,this.bindMatrixInverse=new Matrix4}LOD.prototype=Object.assign(Object.create(Object3D.prototype),{constructor:LOD,isLOD:!0,copy:function(source){Object3D.prototype.copy.call(this,source,!1);const levels=source.levels;for(let i=0,l=levels.length;i<l;i++){const level=levels[i];this.addLevel(level.object.clone(),level.distance)}return this.autoUpdate=source.autoUpdate,this},addLevel:function(object,distance){void 0===distance&&(distance=0),distance=Math.abs(distance);const levels=this.levels;let l;for(l=0;l<levels.length&&!(distance<levels[l].distance);l++);return levels.splice(l,0,{distance,object}),this.add(object),this},getCurrentLevel:function(){return this._currentLevel},getObjectForDistance:function(distance){const levels=this.levels;if(levels.length>0){let i,l;for(i=1,l=levels.length;i<l&&!(distance<levels[i].distance);i++);return levels[i-1].object}return null},raycast:function(raycaster,intersects){if(this.levels.length>0){_v1$4.setFromMatrixPosition(this.matrixWorld);const distance=raycaster.ray.origin.distanceTo(_v1$4);this.getObjectForDistance(distance).raycast(raycaster,intersects)}},update:function(camera){const levels=this.levels;if(levels.length>1){_v1$4.setFromMatrixPosition(camera.matrixWorld),_v2$2.setFromMatrixPosition(this.matrixWorld);const distance=_v1$4.distanceTo(_v2$2)/camera.zoom;let i,l;for(levels[0].object.visible=!0,i=1,l=levels.length;i<l&&distance>=levels[i].distance;i++)levels[i-1].object.visible=!1,levels[i].object.visible=!0;for(this._currentLevel=i-1;i<l;i++)levels[i].object.visible=!1}},toJSON:function(meta){const data=Object3D.prototype.toJSON.call(this,meta);!1===this.autoUpdate&&(data.object.autoUpdate=!1),data.object.levels=[];const levels=this.levels;for(let i=0,l=levels.length;i<l;i++){const level=levels[i];data.object.levels.push({object:level.object.uuid,distance:level.distance})}return data}}),SkinnedMesh.prototype=Object.assign(Object.create(Mesh.prototype),{constructor:SkinnedMesh,isSkinnedMesh:!0,copy:function(source){return Mesh.prototype.copy.call(this,source),this.bindMode=source.bindMode,this.bindMatrix.copy(source.bindMatrix),this.bindMatrixInverse.copy(source.bindMatrixInverse),this.skeleton=source.skeleton,this},bind:function(skeleton,bindMatrix){this.skeleton=skeleton,void 0===bindMatrix&&(this.updateMatrixWorld(!0),this.skeleton.calculateInverses(),bindMatrix=this.matrixWorld),this.bindMatrix.copy(bindMatrix),this.bindMatrixInverse.getInverse(bindMatrix)},pose:function(){this.skeleton.pose()},normalizeSkinWeights:function(){const vector=new Vector4,skinWeight=this.geometry.attributes.skinWeight;for(let i=0,l=skinWeight.count;i<l;i++){vector.x=skinWeight.getX(i),vector.y=skinWeight.getY(i),vector.z=skinWeight.getZ(i),vector.w=skinWeight.getW(i);const scale=1/vector.manhattanLength();scale!==1/0?vector.multiplyScalar(scale):vector.set(1,0,0,0),skinWeight.setXYZW(i,vector.x,vector.y,vector.z,vector.w)}},updateMatrixWorld:function(force){Mesh.prototype.updateMatrixWorld.call(this,force),"attached"===this.bindMode?this.bindMatrixInverse.getInverse(this.matrixWorld):"detached"===this.bindMode?this.bindMatrixInverse.getInverse(this.bindMatrix):console.warn("THREE.SkinnedMesh: Unrecognized bindMode: "+this.bindMode)},boneTransform:function(){const basePosition=new Vector3,skinIndex=new Vector4,skinWeight=new Vector4,vector=new Vector3,matrix=new Matrix4;return function(index,target){const skeleton=this.skeleton,geometry=this.geometry;skinIndex.fromBufferAttribute(geometry.attributes.skinIndex,index),skinWeight.fromBufferAttribute(geometry.attributes.skinWeight,index),basePosition.fromBufferAttribute(geometry.attributes.position,index).applyMatrix4(this.bindMatrix),target.set(0,0,0);for(let i=0;i<4;i++){const weight=skinWeight.getComponent(i);if(0!==weight){const boneIndex=skinIndex.getComponent(i);matrix.multiplyMatrices(skeleton.bones[boneIndex].matrixWorld,skeleton.boneInverses[boneIndex]),target.addScaledVector(vector.copy(basePosition).applyMatrix4(matrix),weight)}}return target.applyMatrix4(this.bindMatrixInverse)}}()});const _offsetMatrix=new Matrix4,_identityMatrix=new Matrix4;function Skeleton(bones,boneInverses){if(bones=bones||[],this.bones=bones.slice(0),this.boneMatrices=new Float32Array(16*this.bones.length),this.frame=-1,void 0===boneInverses)this.calculateInverses();else if(this.bones.length===boneInverses.length)this.boneInverses=boneInverses.slice(0);else{console.warn("THREE.Skeleton boneInverses is the wrong length."),this.boneInverses=[];for(let i=0,il=this.bones.length;i<il;i++)this.boneInverses.push(new Matrix4)}}function Bone(){Object3D.call(this),this.type="Bone"}Object.assign(Skeleton.prototype,{calculateInverses:function(){this.boneInverses=[];for(let i=0,il=this.bones.length;i<il;i++){const inverse=new Matrix4;this.bones[i]&&inverse.getInverse(this.bones[i].matrixWorld),this.boneInverses.push(inverse)}},pose:function(){for(let i=0,il=this.bones.length;i<il;i++){const bone=this.bones[i];bone&&bone.matrixWorld.getInverse(this.boneInverses[i])}for(let i=0,il=this.bones.length;i<il;i++){const bone=this.bones[i];bone&&(bone.parent&&bone.parent.isBone?(bone.matrix.getInverse(bone.parent.matrixWorld),bone.matrix.multiply(bone.matrixWorld)):bone.matrix.copy(bone.matrixWorld),bone.matrix.decompose(bone.position,bone.quaternion,bone.scale))}},update:function(){const bones=this.bones,boneInverses=this.boneInverses,boneMatrices=this.boneMatrices,boneTexture=this.boneTexture;for(let i=0,il=bones.length;i<il;i++){const matrix=bones[i]?bones[i].matrixWorld:_identityMatrix;_offsetMatrix.multiplyMatrices(matrix,boneInverses[i]),_offsetMatrix.toArray(boneMatrices,16*i)}void 0!==boneTexture&&(boneTexture.needsUpdate=!0)},clone:function(){return new Skeleton(this.bones,this.boneInverses)},getBoneByName:function(name){for(let i=0,il=this.bones.length;i<il;i++){const bone=this.bones[i];if(bone.name===name)return bone}},dispose:function(){this.boneTexture&&(this.boneTexture.dispose(),this.boneTexture=void 0)}}),Bone.prototype=Object.assign(Object.create(Object3D.prototype),{constructor:Bone,isBone:!0});const _instanceLocalMatrix=new Matrix4,_instanceWorldMatrix=new Matrix4,_instanceIntersects=[],_mesh=new Mesh;function InstancedMesh(geometry,material,count){Mesh.call(this,geometry,material),this.instanceMatrix=new BufferAttribute(new Float32Array(16*count),16),this.count=count,this.frustumCulled=!1}function LineBasicMaterial(parameters){Material.call(this),this.type="LineBasicMaterial",this.color=new Color(16777215),this.linewidth=1,this.linecap="round",this.linejoin="round",this.morphTargets=!1,this.setValues(parameters)}InstancedMesh.prototype=Object.assign(Object.create(Mesh.prototype),{constructor:InstancedMesh,isInstancedMesh:!0,copy:function(source){return Mesh.prototype.copy.call(this,source),this.instanceMatrix.copy(source.instanceMatrix),this.count=source.count,this},getMatrixAt:function(index,matrix){matrix.fromArray(this.instanceMatrix.array,16*index)},raycast:function(raycaster,intersects){const matrixWorld=this.matrixWorld,raycastTimes=this.count;if(_mesh.geometry=this.geometry,_mesh.material=this.material,void 0!==_mesh.material)for(let instanceId=0;instanceId<raycastTimes;instanceId++){this.getMatrixAt(instanceId,_instanceLocalMatrix),_instanceWorldMatrix.multiplyMatrices(matrixWorld,_instanceLocalMatrix),_mesh.matrixWorld=_instanceWorldMatrix,_mesh.raycast(raycaster,_instanceIntersects);for(let i=0,l=_instanceIntersects.length;i<l;i++){const intersect=_instanceIntersects[i];intersect.instanceId=instanceId,intersect.object=this,intersects.push(intersect)}_instanceIntersects.length=0}},setMatrixAt:function(index,matrix){matrix.toArray(this.instanceMatrix.array,16*index)},updateMorphTargets:function(){}}),LineBasicMaterial.prototype=Object.create(Material.prototype),LineBasicMaterial.prototype.constructor=LineBasicMaterial,LineBasicMaterial.prototype.isLineBasicMaterial=!0,LineBasicMaterial.prototype.copy=function(source){return Material.prototype.copy.call(this,source),this.color.copy(source.color),this.linewidth=source.linewidth,this.linecap=source.linecap,this.linejoin=source.linejoin,this.morphTargets=source.morphTargets,this};const _start=new Vector3,_end=new Vector3,_inverseMatrix$1=new Matrix4,_ray$1=new Ray,_sphere$2=new Sphere;function Line(geometry,material,mode){1===mode&&console.error("THREE.Line: parameter THREE.LinePieces no longer supported. Use THREE.LineSegments instead."),Object3D.call(this),this.type="Line",this.geometry=void 0!==geometry?geometry:new BufferGeometry,this.material=void 0!==material?material:new LineBasicMaterial,this.updateMorphTargets()}Line.prototype=Object.assign(Object.create(Object3D.prototype),{constructor:Line,isLine:!0,copy:function(source){return Object3D.prototype.copy.call(this,source),this.material=source.material,this.geometry=source.geometry,this},computeLineDistances:function(){const geometry=this.geometry;if(geometry.isBufferGeometry)if(null===geometry.index){const positionAttribute=geometry.attributes.position,lineDistances=[0];for(let i=1,l=positionAttribute.count;i<l;i++)_start.fromBufferAttribute(positionAttribute,i-1),_end.fromBufferAttribute(positionAttribute,i),lineDistances[i]=lineDistances[i-1],lineDistances[i]+=_start.distanceTo(_end);geometry.setAttribute("lineDistance",new Float32BufferAttribute(lineDistances,1))}else console.warn("THREE.Line.computeLineDistances(): Computation only possible with non-indexed BufferGeometry.");else if(geometry.isGeometry){const vertices=geometry.vertices,lineDistances=geometry.lineDistances;lineDistances[0]=0;for(let i=1,l=vertices.length;i<l;i++)lineDistances[i]=lineDistances[i-1],lineDistances[i]+=vertices[i-1].distanceTo(vertices[i])}return this},raycast:function(raycaster,intersects){const geometry=this.geometry,matrixWorld=this.matrixWorld,threshold=raycaster.params.Line.threshold;if(null===geometry.boundingSphere&&geometry.computeBoundingSphere(),_sphere$2.copy(geometry.boundingSphere),_sphere$2.applyMatrix4(matrixWorld),_sphere$2.radius+=threshold,!1===raycaster.ray.intersectsSphere(_sphere$2))return;_inverseMatrix$1.getInverse(matrixWorld),_ray$1.copy(raycaster.ray).applyMatrix4(_inverseMatrix$1);const localThreshold=threshold/((this.scale.x+this.scale.y+this.scale.z)/3),localThresholdSq=localThreshold*localThreshold,vStart=new Vector3,vEnd=new Vector3,interSegment=new Vector3,interRay=new Vector3,step=this&&this.isLineSegments?2:1;if(geometry.isBufferGeometry){const index=geometry.index,positions=geometry.attributes.position.array;if(null!==index){const indices=index.array;for(let i=0,l=indices.length-1;i<l;i+=step){const a=indices[i],b=indices[i+1];vStart.fromArray(positions,3*a),vEnd.fromArray(positions,3*b);if(_ray$1.distanceSqToSegment(vStart,vEnd,interRay,interSegment)>localThresholdSq)continue;interRay.applyMatrix4(this.matrixWorld);const distance=raycaster.ray.origin.distanceTo(interRay);distance<raycaster.near||distance>raycaster.far||intersects.push({distance,point:interSegment.clone().applyMatrix4(this.matrixWorld),index:i,face:null,faceIndex:null,object:this})}}else for(let i=0,l=positions.length/3-1;i<l;i+=step){vStart.fromArray(positions,3*i),vEnd.fromArray(positions,3*i+3);if(_ray$1.distanceSqToSegment(vStart,vEnd,interRay,interSegment)>localThresholdSq)continue;interRay.applyMatrix4(this.matrixWorld);const distance=raycaster.ray.origin.distanceTo(interRay);distance<raycaster.near||distance>raycaster.far||intersects.push({distance,point:interSegment.clone().applyMatrix4(this.matrixWorld),index:i,face:null,faceIndex:null,object:this})}}else if(geometry.isGeometry){const vertices=geometry.vertices,nbVertices=vertices.length;for(let i=0;i<nbVertices-1;i+=step){if(_ray$1.distanceSqToSegment(vertices[i],vertices[i+1],interRay,interSegment)>localThresholdSq)continue;interRay.applyMatrix4(this.matrixWorld);const distance=raycaster.ray.origin.distanceTo(interRay);distance<raycaster.near||distance>raycaster.far||intersects.push({distance,point:interSegment.clone().applyMatrix4(this.matrixWorld),index:i,face:null,faceIndex:null,object:this})}}},updateMorphTargets:function(){const geometry=this.geometry;if(geometry.isBufferGeometry){const morphAttributes=geometry.morphAttributes,keys=Object.keys(morphAttributes);if(keys.length>0){const morphAttribute=morphAttributes[keys[0]];if(void 0!==morphAttribute){this.morphTargetInfluences=[],this.morphTargetDictionary={};for(let m=0,ml=morphAttribute.length;m<ml;m++){const name=morphAttribute[m].name||String(m);this.morphTargetInfluences.push(0),this.morphTargetDictionary[name]=m}}}}else{const morphTargets=geometry.morphTargets;void 0!==morphTargets&&morphTargets.length>0&&console.error("THREE.Line.updateMorphTargets() does not support THREE.Geometry. Use THREE.BufferGeometry instead.")}}});const _start$1=new Vector3,_end$1=new Vector3;function LineSegments(geometry,material){Line.call(this,geometry,material),this.type="LineSegments"}function LineLoop(geometry,material){Line.call(this,geometry,material),this.type="LineLoop"}function PointsMaterial(parameters){Material.call(this),this.type="PointsMaterial",this.color=new Color(16777215),this.map=null,this.alphaMap=null,this.size=1,this.sizeAttenuation=!0,this.morphTargets=!1,this.setValues(parameters)}LineSegments.prototype=Object.assign(Object.create(Line.prototype),{constructor:LineSegments,isLineSegments:!0,computeLineDistances:function(){const geometry=this.geometry;if(geometry.isBufferGeometry)if(null===geometry.index){const positionAttribute=geometry.attributes.position,lineDistances=[];for(let i=0,l=positionAttribute.count;i<l;i+=2)_start$1.fromBufferAttribute(positionAttribute,i),_end$1.fromBufferAttribute(positionAttribute,i+1),lineDistances[i]=0===i?0:lineDistances[i-1],lineDistances[i+1]=lineDistances[i]+_start$1.distanceTo(_end$1);geometry.setAttribute("lineDistance",new Float32BufferAttribute(lineDistances,1))}else console.warn("THREE.LineSegments.computeLineDistances(): Computation only possible with non-indexed BufferGeometry.");else if(geometry.isGeometry){const vertices=geometry.vertices,lineDistances=geometry.lineDistances;for(let i=0,l=vertices.length;i<l;i+=2)_start$1.copy(vertices[i]),_end$1.copy(vertices[i+1]),lineDistances[i]=0===i?0:lineDistances[i-1],lineDistances[i+1]=lineDistances[i]+_start$1.distanceTo(_end$1)}return this}}),LineLoop.prototype=Object.assign(Object.create(Line.prototype),{constructor:LineLoop,isLineLoop:!0}),PointsMaterial.prototype=Object.create(Material.prototype),PointsMaterial.prototype.constructor=PointsMaterial,PointsMaterial.prototype.isPointsMaterial=!0,PointsMaterial.prototype.copy=function(source){return Material.prototype.copy.call(this,source),this.color.copy(source.color),this.map=source.map,this.alphaMap=source.alphaMap,this.size=source.size,this.sizeAttenuation=source.sizeAttenuation,this.morphTargets=source.morphTargets,this};const _inverseMatrix$2=new Matrix4,_ray$2=new Ray,_sphere$3=new Sphere,_position$1=new Vector3;function Points(geometry,material){Object3D.call(this),this.type="Points",this.geometry=void 0!==geometry?geometry:new BufferGeometry,this.material=void 0!==material?material:new PointsMaterial,this.updateMorphTargets()}function testPoint(point,index,localThresholdSq,matrixWorld,raycaster,intersects,object){const rayPointDistanceSq=_ray$2.distanceSqToPoint(point);if(rayPointDistanceSq<localThresholdSq){const intersectPoint=new Vector3;_ray$2.closestPointToPoint(point,intersectPoint),intersectPoint.applyMatrix4(matrixWorld);const distance=raycaster.ray.origin.distanceTo(intersectPoint);if(distance<raycaster.near||distance>raycaster.far)return;intersects.push({distance,distanceToRay:Math.sqrt(rayPointDistanceSq),point:intersectPoint,index,face:null,object})}}function VideoTexture(video,mapping,wrapS,wrapT,magFilter,minFilter,format,type,anisotropy){Texture.call(this,video,mapping,wrapS,wrapT,magFilter,minFilter,format,type,anisotropy),this.format=void 0!==format?format:1022,this.minFilter=void 0!==minFilter?minFilter:1006,this.magFilter=void 0!==magFilter?magFilter:1006,this.generateMipmaps=!1;const scope=this;"requestVideoFrameCallback"in video&&video.requestVideoFrameCallback((function updateVideo(){scope.needsUpdate=!0,video.requestVideoFrameCallback(updateVideo)}))}function CompressedTexture(mipmaps,width,height,format,type,mapping,wrapS,wrapT,magFilter,minFilter,anisotropy,encoding){Texture.call(this,null,mapping,wrapS,wrapT,magFilter,minFilter,format,type,anisotropy,encoding),this.image={width,height},this.mipmaps=mipmaps,this.flipY=!1,this.generateMipmaps=!1}function CanvasTexture(canvas,mapping,wrapS,wrapT,magFilter,minFilter,format,type,anisotropy){Texture.call(this,canvas,mapping,wrapS,wrapT,magFilter,minFilter,format,type,anisotropy),this.needsUpdate=!0}function DepthTexture(width,height,type,mapping,wrapS,wrapT,magFilter,minFilter,anisotropy,format){if(1026!==(format=void 0!==format?format:1026)&&1027!==format)throw new Error("DepthTexture format must be either THREE.DepthFormat or THREE.DepthStencilFormat");void 0===type&&1026===format&&(type=1012),void 0===type&&1027===format&&(type=1020),Texture.call(this,null,mapping,wrapS,wrapT,magFilter,minFilter,format,type,anisotropy),this.image={width,height},this.magFilter=void 0!==magFilter?magFilter:1003,this.minFilter=void 0!==minFilter?minFilter:1003,this.flipY=!1,this.generateMipmaps=!1}function WireframeGeometry(geometry){BufferGeometry.call(this),this.type="WireframeGeometry";const vertices=[],edge=[0,0],edges={},keys=["a","b","c"];if(geometry&&geometry.isGeometry){const faces=geometry.faces;for(let i=0,l=faces.length;i<l;i++){const face=faces[i];for(let j=0;j<3;j++){const edge1=face[keys[j]],edge2=face[keys[(j+1)%3]];edge[0]=Math.min(edge1,edge2),edge[1]=Math.max(edge1,edge2);const key=edge[0]+","+edge[1];void 0===edges[key]&&(edges[key]={index1:edge[0],index2:edge[1]})}}for(const key in edges){const e=edges[key];let vertex=geometry.vertices[e.index1];vertices.push(vertex.x,vertex.y,vertex.z),vertex=geometry.vertices[e.index2],vertices.push(vertex.x,vertex.y,vertex.z)}}else if(geometry&&geometry.isBufferGeometry){let vertex=new Vector3;if(null!==geometry.index){const position=geometry.attributes.position,indices=geometry.index;let groups=geometry.groups;0===groups.length&&(groups=[{start:0,count:indices.count,materialIndex:0}]);for(let o=0,ol=groups.length;o<ol;++o){const group=groups[o],start=group.start;for(let i=start,l=start+group.count;i<l;i+=3)for(let j=0;j<3;j++){const edge1=indices.getX(i+j),edge2=indices.getX(i+(j+1)%3);edge[0]=Math.min(edge1,edge2),edge[1]=Math.max(edge1,edge2);const key=edge[0]+","+edge[1];void 0===edges[key]&&(edges[key]={index1:edge[0],index2:edge[1]})}}for(const key in edges){const e=edges[key];vertex.fromBufferAttribute(position,e.index1),vertices.push(vertex.x,vertex.y,vertex.z),vertex.fromBufferAttribute(position,e.index2),vertices.push(vertex.x,vertex.y,vertex.z)}}else{const position=geometry.attributes.position;for(let i=0,l=position.count/3;i<l;i++)for(let j=0;j<3;j++){const index1=3*i+j;vertex.fromBufferAttribute(position,index1),vertices.push(vertex.x,vertex.y,vertex.z);const index2=3*i+(j+1)%3;vertex.fromBufferAttribute(position,index2),vertices.push(vertex.x,vertex.y,vertex.z)}}}this.setAttribute("position",new Float32BufferAttribute(vertices,3))}function ParametricGeometry(func,slices,stacks){Geometry.call(this),this.type="ParametricGeometry",this.parameters={func,slices,stacks},this.fromBufferGeometry(new ParametricBufferGeometry(func,slices,stacks)),this.mergeVertices()}function ParametricBufferGeometry(func,slices,stacks){BufferGeometry.call(this),this.type="ParametricBufferGeometry",this.parameters={func,slices,stacks};const indices=[],vertices=[],normals=[],uvs=[],EPS=1e-5,normal=new Vector3,p0=new Vector3,p1=new Vector3,pu=new Vector3,pv=new Vector3;func.length<3&&console.error("THREE.ParametricGeometry: Function must now modify a Vector3 as third parameter.");const sliceCount=slices+1;for(let i=0;i<=stacks;i++){const v=i/stacks;for(let j=0;j<=slices;j++){const u=j/slices;func(u,v,p0),vertices.push(p0.x,p0.y,p0.z),u-EPS>=0?(func(u-EPS,v,p1),pu.subVectors(p0,p1)):(func(u+EPS,v,p1),pu.subVectors(p1,p0)),v-EPS>=0?(func(u,v-EPS,p1),pv.subVectors(p0,p1)):(func(u,v+EPS,p1),pv.subVectors(p1,p0)),normal.crossVectors(pu,pv).normalize(),normals.push(normal.x,normal.y,normal.z),uvs.push(u,v)}}for(let i=0;i<stacks;i++)for(let j=0;j<slices;j++){const a=i*sliceCount+j,b=i*sliceCount+j+1,c=(i+1)*sliceCount+j+1,d=(i+1)*sliceCount+j;indices.push(a,b,d),indices.push(b,c,d)}this.setIndex(indices),this.setAttribute("position",new Float32BufferAttribute(vertices,3)),this.setAttribute("normal",new Float32BufferAttribute(normals,3)),this.setAttribute("uv",new Float32BufferAttribute(uvs,2))}function PolyhedronGeometry(vertices,indices,radius,detail){Geometry.call(this),this.type="PolyhedronGeometry",this.parameters={vertices,indices,radius,detail},this.fromBufferGeometry(new PolyhedronBufferGeometry(vertices,indices,radius,detail)),this.mergeVertices()}function PolyhedronBufferGeometry(vertices,indices,radius,detail){BufferGeometry.call(this),this.type="PolyhedronBufferGeometry",this.parameters={vertices,indices,radius,detail},radius=radius||1;const vertexBuffer=[],uvBuffer=[];function subdivideFace(a,b,c,detail){const cols=Math.pow(2,detail),v=[];for(let i=0;i<=cols;i++){v[i]=[];const aj=a.clone().lerp(c,i/cols),bj=b.clone().lerp(c,i/cols),rows=cols-i;for(let j=0;j<=rows;j++)v[i][j]=0===j&&i===cols?aj:aj.clone().lerp(bj,j/rows)}for(let i=0;i<cols;i++)for(let j=0;j<2*(cols-i)-1;j++){const k=Math.floor(j/2);j%2==0?(pushVertex(v[i][k+1]),pushVertex(v[i+1][k]),pushVertex(v[i][k])):(pushVertex(v[i][k+1]),pushVertex(v[i+1][k+1]),pushVertex(v[i+1][k]))}}function pushVertex(vertex){vertexBuffer.push(vertex.x,vertex.y,vertex.z)}function getVertexByIndex(index,vertex){const stride=3*index;vertex.x=vertices[stride+0],vertex.y=vertices[stride+1],vertex.z=vertices[stride+2]}function correctUV(uv,stride,vector,azimuth){azimuth<0&&1===uv.x&&(uvBuffer[stride]=uv.x-1),0===vector.x&&0===vector.z&&(uvBuffer[stride]=azimuth/2/Math.PI+.5)}function azimuth(vector){return Math.atan2(vector.z,-vector.x)}!function(detail){const a=new Vector3,b=new Vector3,c=new Vector3;for(let i=0;i<indices.length;i+=3)getVertexByIndex(indices[i+0],a),getVertexByIndex(indices[i+1],b),getVertexByIndex(indices[i+2],c),subdivideFace(a,b,c,detail)}(detail=detail||0),function(radius){const vertex=new Vector3;for(let i=0;i<vertexBuffer.length;i+=3)vertex.x=vertexBuffer[i+0],vertex.y=vertexBuffer[i+1],vertex.z=vertexBuffer[i+2],vertex.normalize().multiplyScalar(radius),vertexBuffer[i+0]=vertex.x,vertexBuffer[i+1]=vertex.y,vertexBuffer[i+2]=vertex.z}(radius),function(){const vertex=new Vector3;for(let i=0;i<vertexBuffer.length;i+=3){vertex.x=vertexBuffer[i+0],vertex.y=vertexBuffer[i+1],vertex.z=vertexBuffer[i+2];const u=azimuth(vertex)/2/Math.PI+.5,v=(vector=vertex,Math.atan2(-vector.y,Math.sqrt(vector.x*vector.x+vector.z*vector.z))/Math.PI+.5);uvBuffer.push(u,1-v)}var vector;(function(){const a=new Vector3,b=new Vector3,c=new Vector3,centroid=new Vector3,uvA=new Vector2,uvB=new Vector2,uvC=new Vector2;for(let i=0,j=0;i<vertexBuffer.length;i+=9,j+=6){a.set(vertexBuffer[i+0],vertexBuffer[i+1],vertexBuffer[i+2]),b.set(vertexBuffer[i+3],vertexBuffer[i+4],vertexBuffer[i+5]),c.set(vertexBuffer[i+6],vertexBuffer[i+7],vertexBuffer[i+8]),uvA.set(uvBuffer[j+0],uvBuffer[j+1]),uvB.set(uvBuffer[j+2],uvBuffer[j+3]),uvC.set(uvBuffer[j+4],uvBuffer[j+5]),centroid.copy(a).add(b).add(c).divideScalar(3);const azi=azimuth(centroid);correctUV(uvA,j+0,a,azi),correctUV(uvB,j+2,b,azi),correctUV(uvC,j+4,c,azi)}})(),function(){for(let i=0;i<uvBuffer.length;i+=6){const x0=uvBuffer[i+0],x1=uvBuffer[i+2],x2=uvBuffer[i+4],max=Math.max(x0,x1,x2),min=Math.min(x0,x1,x2);max>.9&&min<.1&&(x0<.2&&(uvBuffer[i+0]+=1),x1<.2&&(uvBuffer[i+2]+=1),x2<.2&&(uvBuffer[i+4]+=1))}}()}(),this.setAttribute("position",new Float32BufferAttribute(vertexBuffer,3)),this.setAttribute("normal",new Float32BufferAttribute(vertexBuffer.slice(),3)),this.setAttribute("uv",new Float32BufferAttribute(uvBuffer,2)),0===detail?this.computeVertexNormals():this.normalizeNormals()}function TetrahedronGeometry(radius,detail){Geometry.call(this),this.type="TetrahedronGeometry",this.parameters={radius,detail},this.fromBufferGeometry(new TetrahedronBufferGeometry(radius,detail)),this.mergeVertices()}function TetrahedronBufferGeometry(radius,detail){PolyhedronBufferGeometry.call(this,[1,1,1,-1,-1,1,-1,1,-1,1,-1,-1],[2,1,0,0,3,2,1,3,0,2,3,1],radius,detail),this.type="TetrahedronBufferGeometry",this.parameters={radius,detail}}function OctahedronGeometry(radius,detail){Geometry.call(this),this.type="OctahedronGeometry",this.parameters={radius,detail},this.fromBufferGeometry(new OctahedronBufferGeometry(radius,detail)),this.mergeVertices()}function OctahedronBufferGeometry(radius,detail){PolyhedronBufferGeometry.call(this,[1,0,0,-1,0,0,0,1,0,0,-1,0,0,0,1,0,0,-1],[0,2,4,0,4,3,0,3,5,0,5,2,1,2,5,1,5,3,1,3,4,1,4,2],radius,detail),this.type="OctahedronBufferGeometry",this.parameters={radius,detail}}function IcosahedronGeometry(radius,detail){Geometry.call(this),this.type="IcosahedronGeometry",this.parameters={radius,detail},this.fromBufferGeometry(new IcosahedronBufferGeometry(radius,detail)),this.mergeVertices()}function IcosahedronBufferGeometry(radius,detail){const t=(1+Math.sqrt(5))/2,vertices=[-1,t,0,1,t,0,-1,-t,0,1,-t,0,0,-1,t,0,1,t,0,-1,-t,0,1,-t,t,0,-1,t,0,1,-t,0,-1,-t,0,1];PolyhedronBufferGeometry.call(this,vertices,[0,11,5,0,5,1,0,1,7,0,7,10,0,10,11,1,5,9,5,11,4,11,10,2,10,7,6,7,1,8,3,9,4,3,4,2,3,2,6,3,6,8,3,8,9,4,9,5,2,4,11,6,2,10,8,6,7,9,8,1],radius,detail),this.type="IcosahedronBufferGeometry",this.parameters={radius,detail}}function DodecahedronGeometry(radius,detail){Geometry.call(this),this.type="DodecahedronGeometry",this.parameters={radius,detail},this.fromBufferGeometry(new DodecahedronBufferGeometry(radius,detail)),this.mergeVertices()}function DodecahedronBufferGeometry(radius,detail){const t=(1+Math.sqrt(5))/2,r=1/t,vertices=[-1,-1,-1,-1,-1,1,-1,1,-1,-1,1,1,1,-1,-1,1,-1,1,1,1,-1,1,1,1,0,-r,-t,0,-r,t,0,r,-t,0,r,t,-r,-t,0,-r,t,0,r,-t,0,r,t,0,-t,0,-r,t,0,-r,-t,0,r,t,0,r];PolyhedronBufferGeometry.call(this,vertices,[3,11,7,3,7,15,3,15,13,7,19,17,7,17,6,7,6,15,17,4,8,17,8,10,17,10,6,8,0,16,8,16,2,8,2,10,0,12,1,0,1,18,0,18,16,6,10,2,6,2,13,6,13,15,2,16,18,2,18,3,2,3,13,18,1,9,18,9,11,18,11,3,4,14,12,4,12,0,4,0,8,11,9,5,11,5,19,11,19,7,19,5,14,19,14,4,19,4,17,1,12,14,1,14,5,1,5,9],radius,detail),this.type="DodecahedronBufferGeometry",this.parameters={radius,detail}}function TubeGeometry(path,tubularSegments,radius,radialSegments,closed,taper){Geometry.call(this),this.type="TubeGeometry",this.parameters={path,tubularSegments,radius,radialSegments,closed},void 0!==taper&&console.warn("THREE.TubeGeometry: taper has been removed.");const bufferGeometry=new TubeBufferGeometry(path,tubularSegments,radius,radialSegments,closed);this.tangents=bufferGeometry.tangents,this.normals=bufferGeometry.normals,this.binormals=bufferGeometry.binormals,this.fromBufferGeometry(bufferGeometry),this.mergeVertices()}function TubeBufferGeometry(path,tubularSegments,radius,radialSegments,closed){BufferGeometry.call(this),this.type="TubeBufferGeometry",this.parameters={path,tubularSegments,radius,radialSegments,closed},tubularSegments=tubularSegments||64,radius=radius||1,radialSegments=radialSegments||8,closed=closed||!1;const frames=path.computeFrenetFrames(tubularSegments,closed);this.tangents=frames.tangents,this.normals=frames.normals,this.binormals=frames.binormals;const vertex=new Vector3,normal=new Vector3,uv=new Vector2;let P=new Vector3;const vertices=[],normals=[],uvs=[],indices=[];function generateSegment(i){P=path.getPointAt(i/tubularSegments,P);const N=frames.normals[i],B=frames.binormals[i];for(let j=0;j<=radialSegments;j++){const v=j/radialSegments*Math.PI*2,sin=Math.sin(v),cos=-Math.cos(v);normal.x=cos*N.x+sin*B.x,normal.y=cos*N.y+sin*B.y,normal.z=cos*N.z+sin*B.z,normal.normalize(),normals.push(normal.x,normal.y,normal.z),vertex.x=P.x+radius*normal.x,vertex.y=P.y+radius*normal.y,vertex.z=P.z+radius*normal.z,vertices.push(vertex.x,vertex.y,vertex.z)}}!function(){for(let i=0;i<tubularSegments;i++)generateSegment(i);generateSegment(!1===closed?tubularSegments:0),function(){for(let i=0;i<=tubularSegments;i++)for(let j=0;j<=radialSegments;j++)uv.x=i/tubularSegments,uv.y=j/radialSegments,uvs.push(uv.x,uv.y)}(),function(){for(let j=1;j<=tubularSegments;j++)for(let i=1;i<=radialSegments;i++){const a=(radialSegments+1)*(j-1)+(i-1),b=(radialSegments+1)*j+(i-1),c=(radialSegments+1)*j+i,d=(radialSegments+1)*(j-1)+i;indices.push(a,b,d),indices.push(b,c,d)}}()}(),this.setIndex(indices),this.setAttribute("position",new Float32BufferAttribute(vertices,3)),this.setAttribute("normal",new Float32BufferAttribute(normals,3)),this.setAttribute("uv",new Float32BufferAttribute(uvs,2))}function TorusKnotGeometry(radius,tube,tubularSegments,radialSegments,p,q,heightScale){Geometry.call(this),this.type="TorusKnotGeometry",this.parameters={radius,tube,tubularSegments,radialSegments,p,q},void 0!==heightScale&&console.warn("THREE.TorusKnotGeometry: heightScale has been deprecated. Use .scale( x, y, z ) instead."),this.fromBufferGeometry(new TorusKnotBufferGeometry(radius,tube,tubularSegments,radialSegments,p,q)),this.mergeVertices()}function TorusKnotBufferGeometry(radius,tube,tubularSegments,radialSegments,p,q){BufferGeometry.call(this),this.type="TorusKnotBufferGeometry",this.parameters={radius,tube,tubularSegments,radialSegments,p,q},radius=radius||1,tube=tube||.4,tubularSegments=Math.floor(tubularSegments)||64,radialSegments=Math.floor(radialSegments)||8,p=p||2,q=q||3;const indices=[],vertices=[],normals=[],uvs=[],vertex=new Vector3,normal=new Vector3,P1=new Vector3,P2=new Vector3,B=new Vector3,T=new Vector3,N=new Vector3;for(let i=0;i<=tubularSegments;++i){const u=i/tubularSegments*p*Math.PI*2;calculatePositionOnCurve(u,p,q,radius,P1),calculatePositionOnCurve(u+.01,p,q,radius,P2),T.subVectors(P2,P1),N.addVectors(P2,P1),B.crossVectors(T,N),N.crossVectors(B,T),B.normalize(),N.normalize();for(let j=0;j<=radialSegments;++j){const v=j/radialSegments*Math.PI*2,cx=-tube*Math.cos(v),cy=tube*Math.sin(v);vertex.x=P1.x+(cx*N.x+cy*B.x),vertex.y=P1.y+(cx*N.y+cy*B.y),vertex.z=P1.z+(cx*N.z+cy*B.z),vertices.push(vertex.x,vertex.y,vertex.z),normal.subVectors(vertex,P1).normalize(),normals.push(normal.x,normal.y,normal.z),uvs.push(i/tubularSegments),uvs.push(j/radialSegments)}}for(let j=1;j<=tubularSegments;j++)for(let i=1;i<=radialSegments;i++){const a=(radialSegments+1)*(j-1)+(i-1),b=(radialSegments+1)*j+(i-1),c=(radialSegments+1)*j+i,d=(radialSegments+1)*(j-1)+i;indices.push(a,b,d),indices.push(b,c,d)}function calculatePositionOnCurve(u,p,q,radius,position){const cu=Math.cos(u),su=Math.sin(u),quOverP=q/p*u,cs=Math.cos(quOverP);position.x=radius*(2+cs)*.5*cu,position.y=radius*(2+cs)*su*.5,position.z=radius*Math.sin(quOverP)*.5}this.setIndex(indices),this.setAttribute("position",new Float32BufferAttribute(vertices,3)),this.setAttribute("normal",new Float32BufferAttribute(normals,3)),this.setAttribute("uv",new Float32BufferAttribute(uvs,2))}function TorusGeometry(radius,tube,radialSegments,tubularSegments,arc){Geometry.call(this),this.type="TorusGeometry",this.parameters={radius,tube,radialSegments,tubularSegments,arc},this.fromBufferGeometry(new TorusBufferGeometry(radius,tube,radialSegments,tubularSegments,arc)),this.mergeVertices()}function TorusBufferGeometry(radius,tube,radialSegments,tubularSegments,arc){BufferGeometry.call(this),this.type="TorusBufferGeometry",this.parameters={radius,tube,radialSegments,tubularSegments,arc},radius=radius||1,tube=tube||.4,radialSegments=Math.floor(radialSegments)||8,tubularSegments=Math.floor(tubularSegments)||6,arc=arc||2*Math.PI;const indices=[],vertices=[],normals=[],uvs=[],center=new Vector3,vertex=new Vector3,normal=new Vector3;for(let j=0;j<=radialSegments;j++)for(let i=0;i<=tubularSegments;i++){const u=i/tubularSegments*arc,v=j/radialSegments*Math.PI*2;vertex.x=(radius+tube*Math.cos(v))*Math.cos(u),vertex.y=(radius+tube*Math.cos(v))*Math.sin(u),vertex.z=tube*Math.sin(v),vertices.push(vertex.x,vertex.y,vertex.z),center.x=radius*Math.cos(u),center.y=radius*Math.sin(u),normal.subVectors(vertex,center).normalize(),normals.push(normal.x,normal.y,normal.z),uvs.push(i/tubularSegments),uvs.push(j/radialSegments)}for(let j=1;j<=radialSegments;j++)for(let i=1;i<=tubularSegments;i++){const a=(tubularSegments+1)*j+i-1,b=(tubularSegments+1)*(j-1)+i-1,c=(tubularSegments+1)*(j-1)+i,d=(tubularSegments+1)*j+i;indices.push(a,b,d),indices.push(b,c,d)}this.setIndex(indices),this.setAttribute("position",new Float32BufferAttribute(vertices,3)),this.setAttribute("normal",new Float32BufferAttribute(normals,3)),this.setAttribute("uv",new Float32BufferAttribute(uvs,2))}Points.prototype=Object.assign(Object.create(Object3D.prototype),{constructor:Points,isPoints:!0,copy:function(source){return Object3D.prototype.copy.call(this,source),this.material=source.material,this.geometry=source.geometry,this},raycast:function(raycaster,intersects){const geometry=this.geometry,matrixWorld=this.matrixWorld,threshold=raycaster.params.Points.threshold;if(null===geometry.boundingSphere&&geometry.computeBoundingSphere(),_sphere$3.copy(geometry.boundingSphere),_sphere$3.applyMatrix4(matrixWorld),_sphere$3.radius+=threshold,!1===raycaster.ray.intersectsSphere(_sphere$3))return;_inverseMatrix$2.getInverse(matrixWorld),_ray$2.copy(raycaster.ray).applyMatrix4(_inverseMatrix$2);const localThreshold=threshold/((this.scale.x+this.scale.y+this.scale.z)/3),localThresholdSq=localThreshold*localThreshold;if(geometry.isBufferGeometry){const index=geometry.index,positions=geometry.attributes.position.array;if(null!==index){const indices=index.array;for(let i=0,il=indices.length;i<il;i++){const a=indices[i];_position$1.fromArray(positions,3*a),testPoint(_position$1,a,localThresholdSq,matrixWorld,raycaster,intersects,this)}}else for(let i=0,l=positions.length/3;i<l;i++)_position$1.fromArray(positions,3*i),testPoint(_position$1,i,localThresholdSq,matrixWorld,raycaster,intersects,this)}else{const vertices=geometry.vertices;for(let i=0,l=vertices.length;i<l;i++)testPoint(vertices[i],i,localThresholdSq,matrixWorld,raycaster,intersects,this)}},updateMorphTargets:function(){const geometry=this.geometry;if(geometry.isBufferGeometry){const morphAttributes=geometry.morphAttributes,keys=Object.keys(morphAttributes);if(keys.length>0){const morphAttribute=morphAttributes[keys[0]];if(void 0!==morphAttribute){this.morphTargetInfluences=[],this.morphTargetDictionary={};for(let m=0,ml=morphAttribute.length;m<ml;m++){const name=morphAttribute[m].name||String(m);this.morphTargetInfluences.push(0),this.morphTargetDictionary[name]=m}}}}else{const morphTargets=geometry.morphTargets;void 0!==morphTargets&&morphTargets.length>0&&console.error("THREE.Points.updateMorphTargets() does not support THREE.Geometry. Use THREE.BufferGeometry instead.")}}}),VideoTexture.prototype=Object.assign(Object.create(Texture.prototype),{constructor:VideoTexture,isVideoTexture:!0,update:function(){const video=this.image;!1==="requestVideoFrameCallback"in video&&video.readyState>=video.HAVE_CURRENT_DATA&&(this.needsUpdate=!0)}}),CompressedTexture.prototype=Object.create(Texture.prototype),CompressedTexture.prototype.constructor=CompressedTexture,CompressedTexture.prototype.isCompressedTexture=!0,CanvasTexture.prototype=Object.create(Texture.prototype),CanvasTexture.prototype.constructor=CanvasTexture,CanvasTexture.prototype.isCanvasTexture=!0,DepthTexture.prototype=Object.create(Texture.prototype),DepthTexture.prototype.constructor=DepthTexture,DepthTexture.prototype.isDepthTexture=!0,WireframeGeometry.prototype=Object.create(BufferGeometry.prototype),WireframeGeometry.prototype.constructor=WireframeGeometry,ParametricGeometry.prototype=Object.create(Geometry.prototype),ParametricGeometry.prototype.constructor=ParametricGeometry,ParametricBufferGeometry.prototype=Object.create(BufferGeometry.prototype),ParametricBufferGeometry.prototype.constructor=ParametricBufferGeometry,PolyhedronGeometry.prototype=Object.create(Geometry.prototype),PolyhedronGeometry.prototype.constructor=PolyhedronGeometry,PolyhedronBufferGeometry.prototype=Object.create(BufferGeometry.prototype),PolyhedronBufferGeometry.prototype.constructor=PolyhedronBufferGeometry,TetrahedronGeometry.prototype=Object.create(Geometry.prototype),TetrahedronGeometry.prototype.constructor=TetrahedronGeometry,TetrahedronBufferGeometry.prototype=Object.create(PolyhedronBufferGeometry.prototype),TetrahedronBufferGeometry.prototype.constructor=TetrahedronBufferGeometry,OctahedronGeometry.prototype=Object.create(Geometry.prototype),OctahedronGeometry.prototype.constructor=OctahedronGeometry,OctahedronBufferGeometry.prototype=Object.create(PolyhedronBufferGeometry.prototype),OctahedronBufferGeometry.prototype.constructor=OctahedronBufferGeometry,IcosahedronGeometry.prototype=Object.create(Geometry.prototype),IcosahedronGeometry.prototype.constructor=IcosahedronGeometry,IcosahedronBufferGeometry.prototype=Object.create(PolyhedronBufferGeometry.prototype),IcosahedronBufferGeometry.prototype.constructor=IcosahedronBufferGeometry,DodecahedronGeometry.prototype=Object.create(Geometry.prototype),DodecahedronGeometry.prototype.constructor=DodecahedronGeometry,DodecahedronBufferGeometry.prototype=Object.create(PolyhedronBufferGeometry.prototype),DodecahedronBufferGeometry.prototype.constructor=DodecahedronBufferGeometry,TubeGeometry.prototype=Object.create(Geometry.prototype),TubeGeometry.prototype.constructor=TubeGeometry,TubeBufferGeometry.prototype=Object.create(BufferGeometry.prototype),TubeBufferGeometry.prototype.constructor=TubeBufferGeometry,TubeBufferGeometry.prototype.toJSON=function(){const data=BufferGeometry.prototype.toJSON.call(this);return data.path=this.parameters.path.toJSON(),data},TorusKnotGeometry.prototype=Object.create(Geometry.prototype),TorusKnotGeometry.prototype.constructor=TorusKnotGeometry,TorusKnotBufferGeometry.prototype=Object.create(BufferGeometry.prototype),TorusKnotBufferGeometry.prototype.constructor=TorusKnotBufferGeometry,TorusGeometry.prototype=Object.create(Geometry.prototype),TorusGeometry.prototype.constructor=TorusGeometry,TorusBufferGeometry.prototype=Object.create(BufferGeometry.prototype),TorusBufferGeometry.prototype.constructor=TorusBufferGeometry;const Earcut_triangulate=function(data,holeIndices,dim){dim=dim||2;let minX,minY,maxX,maxY,x,y,invSize,hasHoles=holeIndices&&holeIndices.length,outerLen=hasHoles?holeIndices[0]*dim:data.length,outerNode=linkedList(data,0,outerLen,dim,!0),triangles=[];if(!outerNode||outerNode.next===outerNode.prev)return triangles;if(hasHoles&&(outerNode=function(data,holeIndices,outerNode,dim){let i,len,start,end,list,queue=[];for(i=0,len=holeIndices.length;i<len;i++)start=holeIndices[i]*dim,end=i<len-1?holeIndices[i+1]*dim:data.length,list=linkedList(data,start,end,dim,!1),list===list.next&&(list.steiner=!0),queue.push(getLeftmost(list));for(queue.sort(compareX),i=0;i<queue.length;i++)eliminateHole(queue[i],outerNode),outerNode=filterPoints(outerNode,outerNode.next);return outerNode}(data,holeIndices,outerNode,dim)),data.length>80*dim){minX=maxX=data[0],minY=maxY=data[1];for(let i=dim;i<outerLen;i+=dim)x=data[i],y=data[i+1],x<minX&&(minX=x),y<minY&&(minY=y),x>maxX&&(maxX=x),y>maxY&&(maxY=y);invSize=Math.max(maxX-minX,maxY-minY),invSize=0!==invSize?1/invSize:0}return earcutLinked(outerNode,triangles,dim,minX,minY,invSize),triangles};function linkedList(data,start,end,dim,clockwise){let i,last;if(clockwise===function(data,start,end,dim){let sum=0;for(let i=start,j=end-dim;i<end;i+=dim)sum+=(data[j]-data[i])*(data[i+1]+data[j+1]),j=i;return sum}(data,start,end,dim)>0)for(i=start;i<end;i+=dim)last=insertNode(i,data[i],data[i+1],last);else for(i=end-dim;i>=start;i-=dim)last=insertNode(i,data[i],data[i+1],last);return last&&equals(last,last.next)&&(removeNode(last),last=last.next),last}function filterPoints(start,end){if(!start)return start;end||(end=start);let again,p=start;do{if(again=!1,p.steiner||!equals(p,p.next)&&0!==three_module_area(p.prev,p,p.next))p=p.next;else{if(removeNode(p),p=end=p.prev,p===p.next)break;again=!0}}while(again||p!==end);return end}function earcutLinked(ear,triangles,dim,minX,minY,invSize,pass){if(!ear)return;!pass&&invSize&&function(start,minX,minY,invSize){let p=start;do{null===p.z&&(p.z=zOrder(p.x,p.y,minX,minY,invSize)),p.prevZ=p.prev,p.nextZ=p.next,p=p.next}while(p!==start);p.prevZ.nextZ=null,p.prevZ=null,function(list){let i,p,q,e,tail,numMerges,pSize,qSize,inSize=1;do{for(p=list,list=null,tail=null,numMerges=0;p;){for(numMerges++,q=p,pSize=0,i=0;i<inSize&&(pSize++,q=q.nextZ,q);i++);for(qSize=inSize;pSize>0||qSize>0&&q;)0!==pSize&&(0===qSize||!q||p.z<=q.z)?(e=p,p=p.nextZ,pSize--):(e=q,q=q.nextZ,qSize--),tail?tail.nextZ=e:list=e,e.prevZ=tail,tail=e;p=q}tail.nextZ=null,inSize*=2}while(numMerges>1)}(p)}(ear,minX,minY,invSize);let prev,next,stop=ear;for(;ear.prev!==ear.next;)if(prev=ear.prev,next=ear.next,invSize?isEarHashed(ear,minX,minY,invSize):isEar(ear))triangles.push(prev.i/dim),triangles.push(ear.i/dim),triangles.push(next.i/dim),removeNode(ear),ear=next.next,stop=next.next;else if((ear=next)===stop){pass?1===pass?earcutLinked(ear=cureLocalIntersections(filterPoints(ear),triangles,dim),triangles,dim,minX,minY,invSize,2):2===pass&&splitEarcut(ear,triangles,dim,minX,minY,invSize):earcutLinked(filterPoints(ear),triangles,dim,minX,minY,invSize,1);break}}function isEar(ear){let a=ear.prev,b=ear,c=ear.next;if(three_module_area(a,b,c)>=0)return!1;let p=ear.next.next;for(;p!==ear.prev;){if(pointInTriangle(a.x,a.y,b.x,b.y,c.x,c.y,p.x,p.y)&&three_module_area(p.prev,p,p.next)>=0)return!1;p=p.next}return!0}function isEarHashed(ear,minX,minY,invSize){let a=ear.prev,b=ear,c=ear.next;if(three_module_area(a,b,c)>=0)return!1;let minTX=a.x<b.x?a.x<c.x?a.x:c.x:b.x<c.x?b.x:c.x,minTY=a.y<b.y?a.y<c.y?a.y:c.y:b.y<c.y?b.y:c.y,maxTX=a.x>b.x?a.x>c.x?a.x:c.x:b.x>c.x?b.x:c.x,maxTY=a.y>b.y?a.y>c.y?a.y:c.y:b.y>c.y?b.y:c.y,minZ=zOrder(minTX,minTY,minX,minY,invSize),maxZ=zOrder(maxTX,maxTY,minX,minY,invSize),p=ear.prevZ,n=ear.nextZ;for(;p&&p.z>=minZ&&n&&n.z<=maxZ;){if(p!==ear.prev&&p!==ear.next&&pointInTriangle(a.x,a.y,b.x,b.y,c.x,c.y,p.x,p.y)&&three_module_area(p.prev,p,p.next)>=0)return!1;if(p=p.prevZ,n!==ear.prev&&n!==ear.next&&pointInTriangle(a.x,a.y,b.x,b.y,c.x,c.y,n.x,n.y)&&three_module_area(n.prev,n,n.next)>=0)return!1;n=n.nextZ}for(;p&&p.z>=minZ;){if(p!==ear.prev&&p!==ear.next&&pointInTriangle(a.x,a.y,b.x,b.y,c.x,c.y,p.x,p.y)&&three_module_area(p.prev,p,p.next)>=0)return!1;p=p.prevZ}for(;n&&n.z<=maxZ;){if(n!==ear.prev&&n!==ear.next&&pointInTriangle(a.x,a.y,b.x,b.y,c.x,c.y,n.x,n.y)&&three_module_area(n.prev,n,n.next)>=0)return!1;n=n.nextZ}return!0}function cureLocalIntersections(start,triangles,dim){let p=start;do{let a=p.prev,b=p.next.next;!equals(a,b)&&intersects(a,p,p.next,b)&&locallyInside(a,b)&&locallyInside(b,a)&&(triangles.push(a.i/dim),triangles.push(p.i/dim),triangles.push(b.i/dim),removeNode(p),removeNode(p.next),p=start=b),p=p.next}while(p!==start);return filterPoints(p)}function splitEarcut(start,triangles,dim,minX,minY,invSize){let a=start;do{let b=a.next.next;for(;b!==a.prev;){if(a.i!==b.i&&isValidDiagonal(a,b)){let c=splitPolygon(a,b);return a=filterPoints(a,a.next),c=filterPoints(c,c.next),earcutLinked(a,triangles,dim,minX,minY,invSize),void earcutLinked(c,triangles,dim,minX,minY,invSize)}b=b.next}a=a.next}while(a!==start)}function compareX(a,b){return a.x-b.x}function eliminateHole(hole,outerNode){if(outerNode=function(hole,outerNode){let m,p=outerNode,hx=hole.x,hy=hole.y,qx=-1/0;do{if(hy<=p.y&&hy>=p.next.y&&p.next.y!==p.y){let x=p.x+(hy-p.y)*(p.next.x-p.x)/(p.next.y-p.y);if(x<=hx&&x>qx){if(qx=x,x===hx){if(hy===p.y)return p;if(hy===p.next.y)return p.next}m=p.x<p.next.x?p:p.next}}p=p.next}while(p!==outerNode);if(!m)return null;if(hx===qx)return m;let tan,stop=m,mx=m.x,my=m.y,tanMin=1/0;p=m;do{hx>=p.x&&p.x>=mx&&hx!==p.x&&pointInTriangle(hy<my?hx:qx,hy,mx,my,hy<my?qx:hx,hy,p.x,p.y)&&(tan=Math.abs(hy-p.y)/(hx-p.x),locallyInside(p,hole)&&(tan<tanMin||tan===tanMin&&(p.x>m.x||p.x===m.x&&sectorContainsSector(m,p)))&&(m=p,tanMin=tan)),p=p.next}while(p!==stop);return m}(hole,outerNode)){const b=splitPolygon(outerNode,hole);filterPoints(outerNode,outerNode.next),filterPoints(b,b.next)}}function sectorContainsSector(m,p){return three_module_area(m.prev,m,p.prev)<0&&three_module_area(p.next,m,m.next)<0}function zOrder(x,y,minX,minY,invSize){return(x=1431655765&((x=858993459&((x=252645135&((x=16711935&((x=32767*(x-minX)*invSize)|x<<8))|x<<4))|x<<2))|x<<1))|(y=1431655765&((y=858993459&((y=252645135&((y=16711935&((y=32767*(y-minY)*invSize)|y<<8))|y<<4))|y<<2))|y<<1))<<1}function getLeftmost(start){let p=start,leftmost=start;do{(p.x<leftmost.x||p.x===leftmost.x&&p.y<leftmost.y)&&(leftmost=p),p=p.next}while(p!==start);return leftmost}function pointInTriangle(ax,ay,bx,by,cx,cy,px,py){return(cx-px)*(ay-py)-(ax-px)*(cy-py)>=0&&(ax-px)*(by-py)-(bx-px)*(ay-py)>=0&&(bx-px)*(cy-py)-(cx-px)*(by-py)>=0}function isValidDiagonal(a,b){return a.next.i!==b.i&&a.prev.i!==b.i&&!function(a,b){let p=a;do{if(p.i!==a.i&&p.next.i!==a.i&&p.i!==b.i&&p.next.i!==b.i&&intersects(p,p.next,a,b))return!0;p=p.next}while(p!==a);return!1}(a,b)&&(locallyInside(a,b)&&locallyInside(b,a)&&function(a,b){let p=a,inside=!1,px=(a.x+b.x)/2,py=(a.y+b.y)/2;do{p.y>py!=p.next.y>py&&p.next.y!==p.y&&px<(p.next.x-p.x)*(py-p.y)/(p.next.y-p.y)+p.x&&(inside=!inside),p=p.next}while(p!==a);return inside}(a,b)&&(three_module_area(a.prev,a,b.prev)||three_module_area(a,b.prev,b))||equals(a,b)&&three_module_area(a.prev,a,a.next)>0&&three_module_area(b.prev,b,b.next)>0)}function three_module_area(p,q,r){return(q.y-p.y)*(r.x-q.x)-(q.x-p.x)*(r.y-q.y)}function equals(p1,p2){return p1.x===p2.x&&p1.y===p2.y}function intersects(p1,q1,p2,q2){const o1=three_module_sign(three_module_area(p1,q1,p2)),o2=three_module_sign(three_module_area(p1,q1,q2)),o3=three_module_sign(three_module_area(p2,q2,p1)),o4=three_module_sign(three_module_area(p2,q2,q1));return o1!==o2&&o3!==o4||(!(0!==o1||!onSegment(p1,p2,q1))||(!(0!==o2||!onSegment(p1,q2,q1))||(!(0!==o3||!onSegment(p2,p1,q2))||!(0!==o4||!onSegment(p2,q1,q2)))))}function onSegment(p,q,r){return q.x<=Math.max(p.x,r.x)&&q.x>=Math.min(p.x,r.x)&&q.y<=Math.max(p.y,r.y)&&q.y>=Math.min(p.y,r.y)}function three_module_sign(num){return num>0?1:num<0?-1:0}function locallyInside(a,b){return three_module_area(a.prev,a,a.next)<0?three_module_area(a,b,a.next)>=0&&three_module_area(a,a.prev,b)>=0:three_module_area(a,b,a.prev)<0||three_module_area(a,a.next,b)<0}function splitPolygon(a,b){let a2=new three_module_Node(a.i,a.x,a.y),b2=new three_module_Node(b.i,b.x,b.y),an=a.next,bp=b.prev;return a.next=b,b.prev=a,a2.next=an,an.prev=a2,b2.next=a2,a2.prev=b2,bp.next=b2,b2.prev=bp,b2}function insertNode(i,x,y,last){const p=new three_module_Node(i,x,y);return last?(p.next=last.next,p.prev=last,last.next.prev=p,last.next=p):(p.prev=p,p.next=p),p}function removeNode(p){p.next.prev=p.prev,p.prev.next=p.next,p.prevZ&&(p.prevZ.nextZ=p.nextZ),p.nextZ&&(p.nextZ.prevZ=p.prevZ)}function three_module_Node(i,x,y){this.i=i,this.x=x,this.y=y,this.prev=null,this.next=null,this.z=null,this.prevZ=null,this.nextZ=null,this.steiner=!1}const ShapeUtils={area:function(contour){const n=contour.length;let a=0;for(let p=n-1,q=0;q<n;p=q++)a+=contour[p].x*contour[q].y-contour[q].x*contour[p].y;return.5*a},isClockWise:function(pts){return ShapeUtils.area(pts)<0},triangulateShape:function(contour,holes){const vertices=[],holeIndices=[],faces=[];removeDupEndPts(contour),addContour(vertices,contour);let holeIndex=contour.length;holes.forEach(removeDupEndPts);for(let i=0;i<holes.length;i++)holeIndices.push(holeIndex),holeIndex+=holes[i].length,addContour(vertices,holes[i]);const triangles=Earcut_triangulate(vertices,holeIndices);for(let i=0;i<triangles.length;i+=3)faces.push(triangles.slice(i,i+3));return faces}};function removeDupEndPts(points){const l=points.length;l>2&&points[l-1].equals(points[0])&&points.pop()}function addContour(vertices,contour){for(let i=0;i<contour.length;i++)vertices.push(contour[i].x),vertices.push(contour[i].y)}function ExtrudeGeometry(shapes,options){Geometry.call(this),this.type="ExtrudeGeometry",this.parameters={shapes,options},this.fromBufferGeometry(new ExtrudeBufferGeometry(shapes,options)),this.mergeVertices()}function ExtrudeBufferGeometry(shapes,options){BufferGeometry.call(this),this.type="ExtrudeBufferGeometry",this.parameters={shapes,options},shapes=Array.isArray(shapes)?shapes:[shapes];const scope=this,verticesArray=[],uvArray=[];for(let i=0,l=shapes.length;i<l;i++){addShape(shapes[i])}function addShape(shape){const placeholder=[],curveSegments=void 0!==options.curveSegments?options.curveSegments:12,steps=void 0!==options.steps?options.steps:1;let depth=void 0!==options.depth?options.depth:100,bevelEnabled=void 0===options.bevelEnabled||options.bevelEnabled,bevelThickness=void 0!==options.bevelThickness?options.bevelThickness:6,bevelSize=void 0!==options.bevelSize?options.bevelSize:bevelThickness-2,bevelOffset=void 0!==options.bevelOffset?options.bevelOffset:0,bevelSegments=void 0!==options.bevelSegments?options.bevelSegments:3;const extrudePath=options.extrudePath,uvgen=void 0!==options.UVGenerator?options.UVGenerator:WorldUVGenerator;void 0!==options.amount&&(console.warn("THREE.ExtrudeBufferGeometry: amount has been renamed to depth."),depth=options.amount);let extrudePts,splineTube,binormal,normal,position2,extrudeByPath=!1;extrudePath&&(extrudePts=extrudePath.getSpacedPoints(steps),extrudeByPath=!0,bevelEnabled=!1,splineTube=extrudePath.computeFrenetFrames(steps,!1),binormal=new Vector3,normal=new Vector3,position2=new Vector3),bevelEnabled||(bevelSegments=0,bevelThickness=0,bevelSize=0,bevelOffset=0);const shapePoints=shape.extractPoints(curveSegments);let vertices=shapePoints.shape;const holes=shapePoints.holes;if(!ShapeUtils.isClockWise(vertices)){vertices=vertices.reverse();for(let h=0,hl=holes.length;h<hl;h++){const ahole=holes[h];ShapeUtils.isClockWise(ahole)&&(holes[h]=ahole.reverse())}}const faces=ShapeUtils.triangulateShape(vertices,holes),contour=vertices;for(let h=0,hl=holes.length;h<hl;h++){const ahole=holes[h];vertices=vertices.concat(ahole)}function scalePt2(pt,vec,size){return vec||console.error("THREE.ExtrudeGeometry: vec does not exist"),vec.clone().multiplyScalar(size).add(pt)}const vlen=vertices.length,flen=faces.length;function getBevelVec(inPt,inPrev,inNext){let v_trans_x,v_trans_y,shrink_by;const v_prev_x=inPt.x-inPrev.x,v_prev_y=inPt.y-inPrev.y,v_next_x=inNext.x-inPt.x,v_next_y=inNext.y-inPt.y,v_prev_lensq=v_prev_x*v_prev_x+v_prev_y*v_prev_y,collinear0=v_prev_x*v_next_y-v_prev_y*v_next_x;if(Math.abs(collinear0)>Number.EPSILON){const v_prev_len=Math.sqrt(v_prev_lensq),v_next_len=Math.sqrt(v_next_x*v_next_x+v_next_y*v_next_y),ptPrevShift_x=inPrev.x-v_prev_y/v_prev_len,ptPrevShift_y=inPrev.y+v_prev_x/v_prev_len,sf=((inNext.x-v_next_y/v_next_len-ptPrevShift_x)*v_next_y-(inNext.y+v_next_x/v_next_len-ptPrevShift_y)*v_next_x)/(v_prev_x*v_next_y-v_prev_y*v_next_x);v_trans_x=ptPrevShift_x+v_prev_x*sf-inPt.x,v_trans_y=ptPrevShift_y+v_prev_y*sf-inPt.y;const v_trans_lensq=v_trans_x*v_trans_x+v_trans_y*v_trans_y;if(v_trans_lensq<=2)return new Vector2(v_trans_x,v_trans_y);shrink_by=Math.sqrt(v_trans_lensq/2)}else{let direction_eq=!1;v_prev_x>Number.EPSILON?v_next_x>Number.EPSILON&&(direction_eq=!0):v_prev_x<-Number.EPSILON?v_next_x<-Number.EPSILON&&(direction_eq=!0):Math.sign(v_prev_y)===Math.sign(v_next_y)&&(direction_eq=!0),direction_eq?(v_trans_x=-v_prev_y,v_trans_y=v_prev_x,shrink_by=Math.sqrt(v_prev_lensq)):(v_trans_x=v_prev_x,v_trans_y=v_prev_y,shrink_by=Math.sqrt(v_prev_lensq/2))}return new Vector2(v_trans_x/shrink_by,v_trans_y/shrink_by)}const contourMovements=[];for(let i=0,il=contour.length,j=il-1,k=i+1;i<il;i++,j++,k++)j===il&&(j=0),k===il&&(k=0),contourMovements[i]=getBevelVec(contour[i],contour[j],contour[k]);const holesMovements=[];let oneHoleMovements,verticesMovements=contourMovements.concat();for(let h=0,hl=holes.length;h<hl;h++){const ahole=holes[h];oneHoleMovements=[];for(let i=0,il=ahole.length,j=il-1,k=i+1;i<il;i++,j++,k++)j===il&&(j=0),k===il&&(k=0),oneHoleMovements[i]=getBevelVec(ahole[i],ahole[j],ahole[k]);holesMovements.push(oneHoleMovements),verticesMovements=verticesMovements.concat(oneHoleMovements)}for(let b=0;b<bevelSegments;b++){const t=b/bevelSegments,z=bevelThickness*Math.cos(t*Math.PI/2),bs=bevelSize*Math.sin(t*Math.PI/2)+bevelOffset;for(let i=0,il=contour.length;i<il;i++){const vert=scalePt2(contour[i],contourMovements[i],bs);v(vert.x,vert.y,-z)}for(let h=0,hl=holes.length;h<hl;h++){const ahole=holes[h];oneHoleMovements=holesMovements[h];for(let i=0,il=ahole.length;i<il;i++){const vert=scalePt2(ahole[i],oneHoleMovements[i],bs);v(vert.x,vert.y,-z)}}}const bs=bevelSize+bevelOffset;for(let i=0;i<vlen;i++){const vert=bevelEnabled?scalePt2(vertices[i],verticesMovements[i],bs):vertices[i];extrudeByPath?(normal.copy(splineTube.normals[0]).multiplyScalar(vert.x),binormal.copy(splineTube.binormals[0]).multiplyScalar(vert.y),position2.copy(extrudePts[0]).add(normal).add(binormal),v(position2.x,position2.y,position2.z)):v(vert.x,vert.y,0)}for(let s=1;s<=steps;s++)for(let i=0;i<vlen;i++){const vert=bevelEnabled?scalePt2(vertices[i],verticesMovements[i],bs):vertices[i];extrudeByPath?(normal.copy(splineTube.normals[s]).multiplyScalar(vert.x),binormal.copy(splineTube.binormals[s]).multiplyScalar(vert.y),position2.copy(extrudePts[s]).add(normal).add(binormal),v(position2.x,position2.y,position2.z)):v(vert.x,vert.y,depth/steps*s)}for(let b=bevelSegments-1;b>=0;b--){const t=b/bevelSegments,z=bevelThickness*Math.cos(t*Math.PI/2),bs=bevelSize*Math.sin(t*Math.PI/2)+bevelOffset;for(let i=0,il=contour.length;i<il;i++){const vert=scalePt2(contour[i],contourMovements[i],bs);v(vert.x,vert.y,depth+z)}for(let h=0,hl=holes.length;h<hl;h++){const ahole=holes[h];oneHoleMovements=holesMovements[h];for(let i=0,il=ahole.length;i<il;i++){const vert=scalePt2(ahole[i],oneHoleMovements[i],bs);extrudeByPath?v(vert.x,vert.y+extrudePts[steps-1].y,extrudePts[steps-1].x+z):v(vert.x,vert.y,depth+z)}}}function sidewalls(contour,layeroffset){let i=contour.length;for(;--i>=0;){const j=i;let k=i-1;k<0&&(k=contour.length-1);for(let s=0,sl=steps+2*bevelSegments;s<sl;s++){const slen1=vlen*s,slen2=vlen*(s+1);f4(layeroffset+j+slen1,layeroffset+k+slen1,layeroffset+k+slen2,layeroffset+j+slen2)}}}function v(x,y,z){placeholder.push(x),placeholder.push(y),placeholder.push(z)}function f3(a,b,c){addVertex(a),addVertex(b),addVertex(c);const nextIndex=verticesArray.length/3,uvs=uvgen.generateTopUV(scope,verticesArray,nextIndex-3,nextIndex-2,nextIndex-1);addUV(uvs[0]),addUV(uvs[1]),addUV(uvs[2])}function f4(a,b,c,d){addVertex(a),addVertex(b),addVertex(d),addVertex(b),addVertex(c),addVertex(d);const nextIndex=verticesArray.length/3,uvs=uvgen.generateSideWallUV(scope,verticesArray,nextIndex-6,nextIndex-3,nextIndex-2,nextIndex-1);addUV(uvs[0]),addUV(uvs[1]),addUV(uvs[3]),addUV(uvs[1]),addUV(uvs[2]),addUV(uvs[3])}function addVertex(index){verticesArray.push(placeholder[3*index+0]),verticesArray.push(placeholder[3*index+1]),verticesArray.push(placeholder[3*index+2])}function addUV(vector2){uvArray.push(vector2.x),uvArray.push(vector2.y)}!function(){const start=verticesArray.length/3;if(bevelEnabled){let layer=0,offset=vlen*layer;for(let i=0;i<flen;i++){const face=faces[i];f3(face[2]+offset,face[1]+offset,face[0]+offset)}layer=steps+2*bevelSegments,offset=vlen*layer;for(let i=0;i<flen;i++){const face=faces[i];f3(face[0]+offset,face[1]+offset,face[2]+offset)}}else{for(let i=0;i<flen;i++){const face=faces[i];f3(face[2],face[1],face[0])}for(let i=0;i<flen;i++){const face=faces[i];f3(face[0]+vlen*steps,face[1]+vlen*steps,face[2]+vlen*steps)}}scope.addGroup(start,verticesArray.length/3-start,0)}(),function(){const start=verticesArray.length/3;let layeroffset=0;sidewalls(contour,layeroffset),layeroffset+=contour.length;for(let h=0,hl=holes.length;h<hl;h++){const ahole=holes[h];sidewalls(ahole,layeroffset),layeroffset+=ahole.length}scope.addGroup(start,verticesArray.length/3-start,1)}()}this.setAttribute("position",new Float32BufferAttribute(verticesArray,3)),this.setAttribute("uv",new Float32BufferAttribute(uvArray,2)),this.computeVertexNormals()}ExtrudeGeometry.prototype=Object.create(Geometry.prototype),ExtrudeGeometry.prototype.constructor=ExtrudeGeometry,ExtrudeGeometry.prototype.toJSON=function(){const data=Geometry.prototype.toJSON.call(this);return toJSON(this.parameters.shapes,this.parameters.options,data)},ExtrudeBufferGeometry.prototype=Object.create(BufferGeometry.prototype),ExtrudeBufferGeometry.prototype.constructor=ExtrudeBufferGeometry,ExtrudeBufferGeometry.prototype.toJSON=function(){const data=BufferGeometry.prototype.toJSON.call(this);return toJSON(this.parameters.shapes,this.parameters.options,data)};const WorldUVGenerator={generateTopUV:function(geometry,vertices,indexA,indexB,indexC){const a_x=vertices[3*indexA],a_y=vertices[3*indexA+1],b_x=vertices[3*indexB],b_y=vertices[3*indexB+1],c_x=vertices[3*indexC],c_y=vertices[3*indexC+1];return[new Vector2(a_x,a_y),new Vector2(b_x,b_y),new Vector2(c_x,c_y)]},generateSideWallUV:function(geometry,vertices,indexA,indexB,indexC,indexD){const a_x=vertices[3*indexA],a_y=vertices[3*indexA+1],a_z=vertices[3*indexA+2],b_x=vertices[3*indexB],b_y=vertices[3*indexB+1],b_z=vertices[3*indexB+2],c_x=vertices[3*indexC],c_y=vertices[3*indexC+1],c_z=vertices[3*indexC+2],d_x=vertices[3*indexD],d_y=vertices[3*indexD+1],d_z=vertices[3*indexD+2];return Math.abs(a_y-b_y)<.01?[new Vector2(a_x,1-a_z),new Vector2(b_x,1-b_z),new Vector2(c_x,1-c_z),new Vector2(d_x,1-d_z)]:[new Vector2(a_y,1-a_z),new Vector2(b_y,1-b_z),new Vector2(c_y,1-c_z),new Vector2(d_y,1-d_z)]}};function toJSON(shapes,options,data){if(data.shapes=[],Array.isArray(shapes))for(let i=0,l=shapes.length;i<l;i++){const shape=shapes[i];data.shapes.push(shape.uuid)}else data.shapes.push(shapes.uuid);return void 0!==options.extrudePath&&(data.options.extrudePath=options.extrudePath.toJSON()),data}function TextGeometry(text,parameters){Geometry.call(this),this.type="TextGeometry",this.parameters={text,parameters},this.fromBufferGeometry(new TextBufferGeometry(text,parameters)),this.mergeVertices()}function TextBufferGeometry(text,parameters){const font=(parameters=parameters||{}).font;if(!font||!font.isFont)return console.error("THREE.TextGeometry: font parameter is not an instance of THREE.Font."),new Geometry;const shapes=font.generateShapes(text,parameters.size);parameters.depth=void 0!==parameters.height?parameters.height:50,void 0===parameters.bevelThickness&&(parameters.bevelThickness=10),void 0===parameters.bevelSize&&(parameters.bevelSize=8),void 0===parameters.bevelEnabled&&(parameters.bevelEnabled=!1),ExtrudeBufferGeometry.call(this,shapes,parameters),this.type="TextBufferGeometry"}function SphereGeometry(radius,widthSegments,heightSegments,phiStart,phiLength,thetaStart,thetaLength){Geometry.call(this),this.type="SphereGeometry",this.parameters={radius,widthSegments,heightSegments,phiStart,phiLength,thetaStart,thetaLength},this.fromBufferGeometry(new SphereBufferGeometry(radius,widthSegments,heightSegments,phiStart,phiLength,thetaStart,thetaLength)),this.mergeVertices()}function SphereBufferGeometry(radius,widthSegments,heightSegments,phiStart,phiLength,thetaStart,thetaLength){BufferGeometry.call(this),this.type="SphereBufferGeometry",this.parameters={radius,widthSegments,heightSegments,phiStart,phiLength,thetaStart,thetaLength},radius=radius||1,widthSegments=Math.max(3,Math.floor(widthSegments)||8),heightSegments=Math.max(2,Math.floor(heightSegments)||6),phiStart=void 0!==phiStart?phiStart:0,phiLength=void 0!==phiLength?phiLength:2*Math.PI,thetaStart=void 0!==thetaStart?thetaStart:0,thetaLength=void 0!==thetaLength?thetaLength:Math.PI;const thetaEnd=Math.min(thetaStart+thetaLength,Math.PI);let index=0;const grid=[],vertex=new Vector3,normal=new Vector3,indices=[],vertices=[],normals=[],uvs=[];for(let iy=0;iy<=heightSegments;iy++){const verticesRow=[],v=iy/heightSegments;let uOffset=0;0==iy&&0==thetaStart?uOffset=.5/widthSegments:iy==heightSegments&&thetaEnd==Math.PI&&(uOffset=-.5/widthSegments);for(let ix=0;ix<=widthSegments;ix++){const u=ix/widthSegments;vertex.x=-radius*Math.cos(phiStart+u*phiLength)*Math.sin(thetaStart+v*thetaLength),vertex.y=radius*Math.cos(thetaStart+v*thetaLength),vertex.z=radius*Math.sin(phiStart+u*phiLength)*Math.sin(thetaStart+v*thetaLength),vertices.push(vertex.x,vertex.y,vertex.z),normal.copy(vertex).normalize(),normals.push(normal.x,normal.y,normal.z),uvs.push(u+uOffset,1-v),verticesRow.push(index++)}grid.push(verticesRow)}for(let iy=0;iy<heightSegments;iy++)for(let ix=0;ix<widthSegments;ix++){const a=grid[iy][ix+1],b=grid[iy][ix],c=grid[iy+1][ix],d=grid[iy+1][ix+1];(0!==iy||thetaStart>0)&&indices.push(a,b,d),(iy!==heightSegments-1||thetaEnd<Math.PI)&&indices.push(b,c,d)}this.setIndex(indices),this.setAttribute("position",new Float32BufferAttribute(vertices,3)),this.setAttribute("normal",new Float32BufferAttribute(normals,3)),this.setAttribute("uv",new Float32BufferAttribute(uvs,2))}function RingGeometry(innerRadius,outerRadius,thetaSegments,phiSegments,thetaStart,thetaLength){Geometry.call(this),this.type="RingGeometry",this.parameters={innerRadius,outerRadius,thetaSegments,phiSegments,thetaStart,thetaLength},this.fromBufferGeometry(new RingBufferGeometry(innerRadius,outerRadius,thetaSegments,phiSegments,thetaStart,thetaLength)),this.mergeVertices()}function RingBufferGeometry(innerRadius,outerRadius,thetaSegments,phiSegments,thetaStart,thetaLength){BufferGeometry.call(this),this.type="RingBufferGeometry",this.parameters={innerRadius,outerRadius,thetaSegments,phiSegments,thetaStart,thetaLength},innerRadius=innerRadius||.5,outerRadius=outerRadius||1,thetaStart=void 0!==thetaStart?thetaStart:0,thetaLength=void 0!==thetaLength?thetaLength:2*Math.PI,thetaSegments=void 0!==thetaSegments?Math.max(3,thetaSegments):8;const indices=[],vertices=[],normals=[],uvs=[];let radius=innerRadius;const radiusStep=(outerRadius-innerRadius)/(phiSegments=void 0!==phiSegments?Math.max(1,phiSegments):1),vertex=new Vector3,uv=new Vector2;for(let j=0;j<=phiSegments;j++){for(let i=0;i<=thetaSegments;i++){const segment=thetaStart+i/thetaSegments*thetaLength;vertex.x=radius*Math.cos(segment),vertex.y=radius*Math.sin(segment),vertices.push(vertex.x,vertex.y,vertex.z),normals.push(0,0,1),uv.x=(vertex.x/outerRadius+1)/2,uv.y=(vertex.y/outerRadius+1)/2,uvs.push(uv.x,uv.y)}radius+=radiusStep}for(let j=0;j<phiSegments;j++){const thetaSegmentLevel=j*(thetaSegments+1);for(let i=0;i<thetaSegments;i++){const segment=i+thetaSegmentLevel,a=segment,b=segment+thetaSegments+1,c=segment+thetaSegments+2,d=segment+1;indices.push(a,b,d),indices.push(b,c,d)}}this.setIndex(indices),this.setAttribute("position",new Float32BufferAttribute(vertices,3)),this.setAttribute("normal",new Float32BufferAttribute(normals,3)),this.setAttribute("uv",new Float32BufferAttribute(uvs,2))}function LatheGeometry(points,segments,phiStart,phiLength){Geometry.call(this),this.type="LatheGeometry",this.parameters={points,segments,phiStart,phiLength},this.fromBufferGeometry(new LatheBufferGeometry(points,segments,phiStart,phiLength)),this.mergeVertices()}function LatheBufferGeometry(points,segments,phiStart,phiLength){BufferGeometry.call(this),this.type="LatheBufferGeometry",this.parameters={points,segments,phiStart,phiLength},segments=Math.floor(segments)||12,phiStart=phiStart||0,phiLength=phiLength||2*Math.PI,phiLength=MathUtils.clamp(phiLength,0,2*Math.PI);const indices=[],vertices=[],uvs=[],inverseSegments=1/segments,vertex=new Vector3,uv=new Vector2;for(let i=0;i<=segments;i++){const phi=phiStart+i*inverseSegments*phiLength,sin=Math.sin(phi),cos=Math.cos(phi);for(let j=0;j<=points.length-1;j++)vertex.x=points[j].x*sin,vertex.y=points[j].y,vertex.z=points[j].x*cos,vertices.push(vertex.x,vertex.y,vertex.z),uv.x=i/segments,uv.y=j/(points.length-1),uvs.push(uv.x,uv.y)}for(let i=0;i<segments;i++)for(let j=0;j<points.length-1;j++){const base=j+i*points.length,a=base,b=base+points.length,c=base+points.length+1,d=base+1;indices.push(a,b,d),indices.push(b,c,d)}if(this.setIndex(indices),this.setAttribute("position",new Float32BufferAttribute(vertices,3)),this.setAttribute("uv",new Float32BufferAttribute(uvs,2)),this.computeVertexNormals(),phiLength===2*Math.PI){const normals=this.attributes.normal.array,n1=new Vector3,n2=new Vector3,n=new Vector3,base=segments*points.length*3;for(let i=0,j=0;i<points.length;i++,j+=3)n1.x=normals[j+0],n1.y=normals[j+1],n1.z=normals[j+2],n2.x=normals[base+j+0],n2.y=normals[base+j+1],n2.z=normals[base+j+2],n.addVectors(n1,n2).normalize(),normals[j+0]=normals[base+j+0]=n.x,normals[j+1]=normals[base+j+1]=n.y,normals[j+2]=normals[base+j+2]=n.z}}function ShapeGeometry(shapes,curveSegments){Geometry.call(this),this.type="ShapeGeometry","object"==typeof curveSegments&&(console.warn("THREE.ShapeGeometry: Options parameter has been removed."),curveSegments=curveSegments.curveSegments),this.parameters={shapes,curveSegments},this.fromBufferGeometry(new ShapeBufferGeometry(shapes,curveSegments)),this.mergeVertices()}function ShapeBufferGeometry(shapes,curveSegments){BufferGeometry.call(this),this.type="ShapeBufferGeometry",this.parameters={shapes,curveSegments},curveSegments=curveSegments||12;const indices=[],vertices=[],normals=[],uvs=[];let groupStart=0,groupCount=0;if(!1===Array.isArray(shapes))addShape(shapes);else for(let i=0;i<shapes.length;i++)addShape(shapes[i]),this.addGroup(groupStart,groupCount,i),groupStart+=groupCount,groupCount=0;function addShape(shape){const indexOffset=vertices.length/3,points=shape.extractPoints(curveSegments);let shapeVertices=points.shape;const shapeHoles=points.holes;!1===ShapeUtils.isClockWise(shapeVertices)&&(shapeVertices=shapeVertices.reverse());for(let i=0,l=shapeHoles.length;i<l;i++){const shapeHole=shapeHoles[i];!0===ShapeUtils.isClockWise(shapeHole)&&(shapeHoles[i]=shapeHole.reverse())}const faces=ShapeUtils.triangulateShape(shapeVertices,shapeHoles);for(let i=0,l=shapeHoles.length;i<l;i++){const shapeHole=shapeHoles[i];shapeVertices=shapeVertices.concat(shapeHole)}for(let i=0,l=shapeVertices.length;i<l;i++){const vertex=shapeVertices[i];vertices.push(vertex.x,vertex.y,0),normals.push(0,0,1),uvs.push(vertex.x,vertex.y)}for(let i=0,l=faces.length;i<l;i++){const face=faces[i],a=face[0]+indexOffset,b=face[1]+indexOffset,c=face[2]+indexOffset;indices.push(a,b,c),groupCount+=3}}this.setIndex(indices),this.setAttribute("position",new Float32BufferAttribute(vertices,3)),this.setAttribute("normal",new Float32BufferAttribute(normals,3)),this.setAttribute("uv",new Float32BufferAttribute(uvs,2))}function toJSON$1(shapes,data){if(data.shapes=[],Array.isArray(shapes))for(let i=0,l=shapes.length;i<l;i++){const shape=shapes[i];data.shapes.push(shape.uuid)}else data.shapes.push(shapes.uuid);return data}function EdgesGeometry(geometry,thresholdAngle){BufferGeometry.call(this),this.type="EdgesGeometry",this.parameters={thresholdAngle},thresholdAngle=void 0!==thresholdAngle?thresholdAngle:1;const vertices=[],thresholdDot=Math.cos(MathUtils.DEG2RAD*thresholdAngle),edge=[0,0],edges={};let edge1,edge2,key;const keys=["a","b","c"];let geometry2;geometry.isBufferGeometry?(geometry2=new Geometry,geometry2.fromBufferGeometry(geometry)):geometry2=geometry.clone(),geometry2.mergeVertices(),geometry2.computeFaceNormals();const sourceVertices=geometry2.vertices,faces=geometry2.faces;for(let i=0,l=faces.length;i<l;i++){const face=faces[i];for(let j=0;j<3;j++)edge1=face[keys[j]],edge2=face[keys[(j+1)%3]],edge[0]=Math.min(edge1,edge2),edge[1]=Math.max(edge1,edge2),key=edge[0]+","+edge[1],void 0===edges[key]?edges[key]={index1:edge[0],index2:edge[1],face1:i,face2:void 0}:edges[key].face2=i}for(key in edges){const e=edges[key];if(void 0===e.face2||faces[e.face1].normal.dot(faces[e.face2].normal)<=thresholdDot){let vertex=sourceVertices[e.index1];vertices.push(vertex.x,vertex.y,vertex.z),vertex=sourceVertices[e.index2],vertices.push(vertex.x,vertex.y,vertex.z)}}this.setAttribute("position",new Float32BufferAttribute(vertices,3))}function CylinderGeometry(radiusTop,radiusBottom,height,radialSegments,heightSegments,openEnded,thetaStart,thetaLength){Geometry.call(this),this.type="CylinderGeometry",this.parameters={radiusTop,radiusBottom,height,radialSegments,heightSegments,openEnded,thetaStart,thetaLength},this.fromBufferGeometry(new CylinderBufferGeometry(radiusTop,radiusBottom,height,radialSegments,heightSegments,openEnded,thetaStart,thetaLength)),this.mergeVertices()}function CylinderBufferGeometry(radiusTop,radiusBottom,height,radialSegments,heightSegments,openEnded,thetaStart,thetaLength){BufferGeometry.call(this),this.type="CylinderBufferGeometry",this.parameters={radiusTop,radiusBottom,height,radialSegments,heightSegments,openEnded,thetaStart,thetaLength};const scope=this;radiusTop=void 0!==radiusTop?radiusTop:1,radiusBottom=void 0!==radiusBottom?radiusBottom:1,height=height||1,radialSegments=Math.floor(radialSegments)||8,heightSegments=Math.floor(heightSegments)||1,openEnded=void 0!==openEnded&&openEnded,thetaStart=void 0!==thetaStart?thetaStart:0,thetaLength=void 0!==thetaLength?thetaLength:2*Math.PI;const indices=[],vertices=[],normals=[],uvs=[];let index=0;const indexArray=[],halfHeight=height/2;let groupStart=0;function generateCap(top){let centerIndexStart,centerIndexEnd;const uv=new Vector2,vertex=new Vector3;let groupCount=0;const radius=!0===top?radiusTop:radiusBottom,sign=!0===top?1:-1;centerIndexStart=index;for(let x=1;x<=radialSegments;x++)vertices.push(0,halfHeight*sign,0),normals.push(0,sign,0),uvs.push(.5,.5),index++;centerIndexEnd=index;for(let x=0;x<=radialSegments;x++){const theta=x/radialSegments*thetaLength+thetaStart,cosTheta=Math.cos(theta),sinTheta=Math.sin(theta);vertex.x=radius*sinTheta,vertex.y=halfHeight*sign,vertex.z=radius*cosTheta,vertices.push(vertex.x,vertex.y,vertex.z),normals.push(0,sign,0),uv.x=.5*cosTheta+.5,uv.y=.5*sinTheta*sign+.5,uvs.push(uv.x,uv.y),index++}for(let x=0;x<radialSegments;x++){const c=centerIndexStart+x,i=centerIndexEnd+x;!0===top?indices.push(i,i+1,c):indices.push(i+1,i,c),groupCount+=3}scope.addGroup(groupStart,groupCount,!0===top?1:2),groupStart+=groupCount}!function(){const normal=new Vector3,vertex=new Vector3;let groupCount=0;const slope=(radiusBottom-radiusTop)/height;for(let y=0;y<=heightSegments;y++){const indexRow=[],v=y/heightSegments,radius=v*(radiusBottom-radiusTop)+radiusTop;for(let x=0;x<=radialSegments;x++){const u=x/radialSegments,theta=u*thetaLength+thetaStart,sinTheta=Math.sin(theta),cosTheta=Math.cos(theta);vertex.x=radius*sinTheta,vertex.y=-v*height+halfHeight,vertex.z=radius*cosTheta,vertices.push(vertex.x,vertex.y,vertex.z),normal.set(sinTheta,slope,cosTheta).normalize(),normals.push(normal.x,normal.y,normal.z),uvs.push(u,1-v),indexRow.push(index++)}indexArray.push(indexRow)}for(let x=0;x<radialSegments;x++)for(let y=0;y<heightSegments;y++){const a=indexArray[y][x],b=indexArray[y+1][x],c=indexArray[y+1][x+1],d=indexArray[y][x+1];indices.push(a,b,d),indices.push(b,c,d),groupCount+=6}scope.addGroup(groupStart,groupCount,0),groupStart+=groupCount}(),!1===openEnded&&(radiusTop>0&&generateCap(!0),radiusBottom>0&&generateCap(!1)),this.setIndex(indices),this.setAttribute("position",new Float32BufferAttribute(vertices,3)),this.setAttribute("normal",new Float32BufferAttribute(normals,3)),this.setAttribute("uv",new Float32BufferAttribute(uvs,2))}function ConeGeometry(radius,height,radialSegments,heightSegments,openEnded,thetaStart,thetaLength){CylinderGeometry.call(this,0,radius,height,radialSegments,heightSegments,openEnded,thetaStart,thetaLength),this.type="ConeGeometry",this.parameters={radius,height,radialSegments,heightSegments,openEnded,thetaStart,thetaLength}}function ConeBufferGeometry(radius,height,radialSegments,heightSegments,openEnded,thetaStart,thetaLength){CylinderBufferGeometry.call(this,0,radius,height,radialSegments,heightSegments,openEnded,thetaStart,thetaLength),this.type="ConeBufferGeometry",this.parameters={radius,height,radialSegments,heightSegments,openEnded,thetaStart,thetaLength}}function CircleGeometry(radius,segments,thetaStart,thetaLength){Geometry.call(this),this.type="CircleGeometry",this.parameters={radius,segments,thetaStart,thetaLength},this.fromBufferGeometry(new CircleBufferGeometry(radius,segments,thetaStart,thetaLength)),this.mergeVertices()}function CircleBufferGeometry(radius,segments,thetaStart,thetaLength){BufferGeometry.call(this),this.type="CircleBufferGeometry",this.parameters={radius,segments,thetaStart,thetaLength},radius=radius||1,segments=void 0!==segments?Math.max(3,segments):8,thetaStart=void 0!==thetaStart?thetaStart:0,thetaLength=void 0!==thetaLength?thetaLength:2*Math.PI;const indices=[],vertices=[],normals=[],uvs=[],vertex=new Vector3,uv=new Vector2;vertices.push(0,0,0),normals.push(0,0,1),uvs.push(.5,.5);for(let s=0,i=3;s<=segments;s++,i+=3){const segment=thetaStart+s/segments*thetaLength;vertex.x=radius*Math.cos(segment),vertex.y=radius*Math.sin(segment),vertices.push(vertex.x,vertex.y,vertex.z),normals.push(0,0,1),uv.x=(vertices[i]/radius+1)/2,uv.y=(vertices[i+1]/radius+1)/2,uvs.push(uv.x,uv.y)}for(let i=1;i<=segments;i++)indices.push(i,i+1,0);this.setIndex(indices),this.setAttribute("position",new Float32BufferAttribute(vertices,3)),this.setAttribute("normal",new Float32BufferAttribute(normals,3)),this.setAttribute("uv",new Float32BufferAttribute(uvs,2))}TextGeometry.prototype=Object.create(Geometry.prototype),TextGeometry.prototype.constructor=TextGeometry,TextBufferGeometry.prototype=Object.create(ExtrudeBufferGeometry.prototype),TextBufferGeometry.prototype.constructor=TextBufferGeometry,SphereGeometry.prototype=Object.create(Geometry.prototype),SphereGeometry.prototype.constructor=SphereGeometry,SphereBufferGeometry.prototype=Object.create(BufferGeometry.prototype),SphereBufferGeometry.prototype.constructor=SphereBufferGeometry,RingGeometry.prototype=Object.create(Geometry.prototype),RingGeometry.prototype.constructor=RingGeometry,RingBufferGeometry.prototype=Object.create(BufferGeometry.prototype),RingBufferGeometry.prototype.constructor=RingBufferGeometry,LatheGeometry.prototype=Object.create(Geometry.prototype),LatheGeometry.prototype.constructor=LatheGeometry,LatheBufferGeometry.prototype=Object.create(BufferGeometry.prototype),LatheBufferGeometry.prototype.constructor=LatheBufferGeometry,ShapeGeometry.prototype=Object.create(Geometry.prototype),ShapeGeometry.prototype.constructor=ShapeGeometry,ShapeGeometry.prototype.toJSON=function(){const data=Geometry.prototype.toJSON.call(this);return toJSON$1(this.parameters.shapes,data)},ShapeBufferGeometry.prototype=Object.create(BufferGeometry.prototype),ShapeBufferGeometry.prototype.constructor=ShapeBufferGeometry,ShapeBufferGeometry.prototype.toJSON=function(){const data=BufferGeometry.prototype.toJSON.call(this);return toJSON$1(this.parameters.shapes,data)},EdgesGeometry.prototype=Object.create(BufferGeometry.prototype),EdgesGeometry.prototype.constructor=EdgesGeometry,CylinderGeometry.prototype=Object.create(Geometry.prototype),CylinderGeometry.prototype.constructor=CylinderGeometry,CylinderBufferGeometry.prototype=Object.create(BufferGeometry.prototype),CylinderBufferGeometry.prototype.constructor=CylinderBufferGeometry,ConeGeometry.prototype=Object.create(CylinderGeometry.prototype),ConeGeometry.prototype.constructor=ConeGeometry,ConeBufferGeometry.prototype=Object.create(CylinderBufferGeometry.prototype),ConeBufferGeometry.prototype.constructor=ConeBufferGeometry,CircleGeometry.prototype=Object.create(Geometry.prototype),CircleGeometry.prototype.constructor=CircleGeometry,CircleBufferGeometry.prototype=Object.create(BufferGeometry.prototype),CircleBufferGeometry.prototype.constructor=CircleBufferGeometry;var Geometries=Object.freeze({__proto__:null,WireframeGeometry,ParametricGeometry,ParametricBufferGeometry,TetrahedronGeometry,TetrahedronBufferGeometry,OctahedronGeometry,OctahedronBufferGeometry,IcosahedronGeometry,IcosahedronBufferGeometry,DodecahedronGeometry,DodecahedronBufferGeometry,PolyhedronGeometry,PolyhedronBufferGeometry,TubeGeometry,TubeBufferGeometry,TorusKnotGeometry,TorusKnotBufferGeometry,TorusGeometry,TorusBufferGeometry,TextGeometry,TextBufferGeometry,SphereGeometry,SphereBufferGeometry,RingGeometry,RingBufferGeometry,PlaneGeometry,PlaneBufferGeometry,LatheGeometry,LatheBufferGeometry,ShapeGeometry,ShapeBufferGeometry,ExtrudeGeometry,ExtrudeBufferGeometry,EdgesGeometry,ConeGeometry,ConeBufferGeometry,CylinderGeometry,CylinderBufferGeometry,CircleGeometry,CircleBufferGeometry,BoxGeometry:class extends Geometry{constructor(width,height,depth,widthSegments,heightSegments,depthSegments){super(),this.type="BoxGeometry",this.parameters={width,height,depth,widthSegments,heightSegments,depthSegments},this.fromBufferGeometry(new BoxBufferGeometry(width,height,depth,widthSegments,heightSegments,depthSegments)),this.mergeVertices()}},BoxBufferGeometry});function ShadowMaterial(parameters){Material.call(this),this.type="ShadowMaterial",this.color=new Color(0),this.transparent=!0,this.setValues(parameters)}function RawShaderMaterial(parameters){ShaderMaterial.call(this,parameters),this.type="RawShaderMaterial"}function MeshStandardMaterial(parameters){Material.call(this),this.defines={STANDARD:""},this.type="MeshStandardMaterial",this.color=new Color(16777215),this.roughness=1,this.metalness=0,this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new Color(0),this.emissiveIntensity=1,this.emissiveMap=null,this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalMapType=0,this.normalScale=new Vector2(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.roughnessMap=null,this.metalnessMap=null,this.alphaMap=null,this.envMap=null,this.envMapIntensity=1,this.refractionRatio=.98,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.skinning=!1,this.morphTargets=!1,this.morphNormals=!1,this.vertexTangents=!1,this.setValues(parameters)}function MeshPhysicalMaterial(parameters){MeshStandardMaterial.call(this),this.defines={STANDARD:"",PHYSICAL:""},this.type="MeshPhysicalMaterial",this.clearcoat=0,this.clearcoatMap=null,this.clearcoatRoughness=0,this.clearcoatRoughnessMap=null,this.clearcoatNormalScale=new Vector2(1,1),this.clearcoatNormalMap=null,this.reflectivity=.5,this.sheen=null,this.transmission=0,this.transmissionMap=null,this.setValues(parameters)}function MeshPhongMaterial(parameters){Material.call(this),this.type="MeshPhongMaterial",this.color=new Color(16777215),this.specular=new Color(1118481),this.shininess=30,this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new Color(0),this.emissiveIntensity=1,this.emissiveMap=null,this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalMapType=0,this.normalScale=new Vector2(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.specularMap=null,this.alphaMap=null,this.envMap=null,this.combine=0,this.reflectivity=1,this.refractionRatio=.98,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.skinning=!1,this.morphTargets=!1,this.morphNormals=!1,this.setValues(parameters)}function MeshToonMaterial(parameters){Material.call(this),this.defines={TOON:""},this.type="MeshToonMaterial",this.color=new Color(16777215),this.map=null,this.gradientMap=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new Color(0),this.emissiveIntensity=1,this.emissiveMap=null,this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalMapType=0,this.normalScale=new Vector2(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.alphaMap=null,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.skinning=!1,this.morphTargets=!1,this.morphNormals=!1,this.setValues(parameters)}function MeshNormalMaterial(parameters){Material.call(this),this.type="MeshNormalMaterial",this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalMapType=0,this.normalScale=new Vector2(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.wireframe=!1,this.wireframeLinewidth=1,this.fog=!1,this.skinning=!1,this.morphTargets=!1,this.morphNormals=!1,this.setValues(parameters)}function MeshLambertMaterial(parameters){Material.call(this),this.type="MeshLambertMaterial",this.color=new Color(16777215),this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new Color(0),this.emissiveIntensity=1,this.emissiveMap=null,this.specularMap=null,this.alphaMap=null,this.envMap=null,this.combine=0,this.reflectivity=1,this.refractionRatio=.98,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.skinning=!1,this.morphTargets=!1,this.morphNormals=!1,this.setValues(parameters)}function MeshMatcapMaterial(parameters){Material.call(this),this.defines={MATCAP:""},this.type="MeshMatcapMaterial",this.color=new Color(16777215),this.matcap=null,this.map=null,this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalMapType=0,this.normalScale=new Vector2(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.alphaMap=null,this.skinning=!1,this.morphTargets=!1,this.morphNormals=!1,this.setValues(parameters)}function LineDashedMaterial(parameters){LineBasicMaterial.call(this),this.type="LineDashedMaterial",this.scale=1,this.dashSize=3,this.gapSize=1,this.setValues(parameters)}ShadowMaterial.prototype=Object.create(Material.prototype),ShadowMaterial.prototype.constructor=ShadowMaterial,ShadowMaterial.prototype.isShadowMaterial=!0,ShadowMaterial.prototype.copy=function(source){return Material.prototype.copy.call(this,source),this.color.copy(source.color),this},RawShaderMaterial.prototype=Object.create(ShaderMaterial.prototype),RawShaderMaterial.prototype.constructor=RawShaderMaterial,RawShaderMaterial.prototype.isRawShaderMaterial=!0,MeshStandardMaterial.prototype=Object.create(Material.prototype),MeshStandardMaterial.prototype.constructor=MeshStandardMaterial,MeshStandardMaterial.prototype.isMeshStandardMaterial=!0,MeshStandardMaterial.prototype.copy=function(source){return Material.prototype.copy.call(this,source),this.defines={STANDARD:""},this.color.copy(source.color),this.roughness=source.roughness,this.metalness=source.metalness,this.map=source.map,this.lightMap=source.lightMap,this.lightMapIntensity=source.lightMapIntensity,this.aoMap=source.aoMap,this.aoMapIntensity=source.aoMapIntensity,this.emissive.copy(source.emissive),this.emissiveMap=source.emissiveMap,this.emissiveIntensity=source.emissiveIntensity,this.bumpMap=source.bumpMap,this.bumpScale=source.bumpScale,this.normalMap=source.normalMap,this.normalMapType=source.normalMapType,this.normalScale.copy(source.normalScale),this.displacementMap=source.displacementMap,this.displacementScale=source.displacementScale,this.displacementBias=source.displacementBias,this.roughnessMap=source.roughnessMap,this.metalnessMap=source.metalnessMap,this.alphaMap=source.alphaMap,this.envMap=source.envMap,this.envMapIntensity=source.envMapIntensity,this.refractionRatio=source.refractionRatio,this.wireframe=source.wireframe,this.wireframeLinewidth=source.wireframeLinewidth,this.wireframeLinecap=source.wireframeLinecap,this.wireframeLinejoin=source.wireframeLinejoin,this.skinning=source.skinning,this.morphTargets=source.morphTargets,this.morphNormals=source.morphNormals,this.vertexTangents=source.vertexTangents,this},MeshPhysicalMaterial.prototype=Object.create(MeshStandardMaterial.prototype),MeshPhysicalMaterial.prototype.constructor=MeshPhysicalMaterial,MeshPhysicalMaterial.prototype.isMeshPhysicalMaterial=!0,MeshPhysicalMaterial.prototype.copy=function(source){return MeshStandardMaterial.prototype.copy.call(this,source),this.defines={STANDARD:"",PHYSICAL:""},this.clearcoat=source.clearcoat,this.clearcoatMap=source.clearcoatMap,this.clearcoatRoughness=source.clearcoatRoughness,this.clearcoatRoughnessMap=source.clearcoatRoughnessMap,this.clearcoatNormalMap=source.clearcoatNormalMap,this.clearcoatNormalScale.copy(source.clearcoatNormalScale),this.reflectivity=source.reflectivity,source.sheen?this.sheen=(this.sheen||new Color).copy(source.sheen):this.sheen=null,this.transmission=source.transmission,this.transmissionMap=source.transmissionMap,this},MeshPhongMaterial.prototype=Object.create(Material.prototype),MeshPhongMaterial.prototype.constructor=MeshPhongMaterial,MeshPhongMaterial.prototype.isMeshPhongMaterial=!0,MeshPhongMaterial.prototype.copy=function(source){return Material.prototype.copy.call(this,source),this.color.copy(source.color),this.specular.copy(source.specular),this.shininess=source.shininess,this.map=source.map,this.lightMap=source.lightMap,this.lightMapIntensity=source.lightMapIntensity,this.aoMap=source.aoMap,this.aoMapIntensity=source.aoMapIntensity,this.emissive.copy(source.emissive),this.emissiveMap=source.emissiveMap,this.emissiveIntensity=source.emissiveIntensity,this.bumpMap=source.bumpMap,this.bumpScale=source.bumpScale,this.normalMap=source.normalMap,this.normalMapType=source.normalMapType,this.normalScale.copy(source.normalScale),this.displacementMap=source.displacementMap,this.displacementScale=source.displacementScale,this.displacementBias=source.displacementBias,this.specularMap=source.specularMap,this.alphaMap=source.alphaMap,this.envMap=source.envMap,this.combine=source.combine,this.reflectivity=source.reflectivity,this.refractionRatio=source.refractionRatio,this.wireframe=source.wireframe,this.wireframeLinewidth=source.wireframeLinewidth,this.wireframeLinecap=source.wireframeLinecap,this.wireframeLinejoin=source.wireframeLinejoin,this.skinning=source.skinning,this.morphTargets=source.morphTargets,this.morphNormals=source.morphNormals,this},MeshToonMaterial.prototype=Object.create(Material.prototype),MeshToonMaterial.prototype.constructor=MeshToonMaterial,MeshToonMaterial.prototype.isMeshToonMaterial=!0,MeshToonMaterial.prototype.copy=function(source){return Material.prototype.copy.call(this,source),this.color.copy(source.color),this.map=source.map,this.gradientMap=source.gradientMap,this.lightMap=source.lightMap,this.lightMapIntensity=source.lightMapIntensity,this.aoMap=source.aoMap,this.aoMapIntensity=source.aoMapIntensity,this.emissive.copy(source.emissive),this.emissiveMap=source.emissiveMap,this.emissiveIntensity=source.emissiveIntensity,this.bumpMap=source.bumpMap,this.bumpScale=source.bumpScale,this.normalMap=source.normalMap,this.normalMapType=source.normalMapType,this.normalScale.copy(source.normalScale),this.displacementMap=source.displacementMap,this.displacementScale=source.displacementScale,this.displacementBias=source.displacementBias,this.alphaMap=source.alphaMap,this.wireframe=source.wireframe,this.wireframeLinewidth=source.wireframeLinewidth,this.wireframeLinecap=source.wireframeLinecap,this.wireframeLinejoin=source.wireframeLinejoin,this.skinning=source.skinning,this.morphTargets=source.morphTargets,this.morphNormals=source.morphNormals,this},MeshNormalMaterial.prototype=Object.create(Material.prototype),MeshNormalMaterial.prototype.constructor=MeshNormalMaterial,MeshNormalMaterial.prototype.isMeshNormalMaterial=!0,MeshNormalMaterial.prototype.copy=function(source){return Material.prototype.copy.call(this,source),this.bumpMap=source.bumpMap,this.bumpScale=source.bumpScale,this.normalMap=source.normalMap,this.normalMapType=source.normalMapType,this.normalScale.copy(source.normalScale),this.displacementMap=source.displacementMap,this.displacementScale=source.displacementScale,this.displacementBias=source.displacementBias,this.wireframe=source.wireframe,this.wireframeLinewidth=source.wireframeLinewidth,this.skinning=source.skinning,this.morphTargets=source.morphTargets,this.morphNormals=source.morphNormals,this},MeshLambertMaterial.prototype=Object.create(Material.prototype),MeshLambertMaterial.prototype.constructor=MeshLambertMaterial,MeshLambertMaterial.prototype.isMeshLambertMaterial=!0,MeshLambertMaterial.prototype.copy=function(source){return Material.prototype.copy.call(this,source),this.color.copy(source.color),this.map=source.map,this.lightMap=source.lightMap,this.lightMapIntensity=source.lightMapIntensity,this.aoMap=source.aoMap,this.aoMapIntensity=source.aoMapIntensity,this.emissive.copy(source.emissive),this.emissiveMap=source.emissiveMap,this.emissiveIntensity=source.emissiveIntensity,this.specularMap=source.specularMap,this.alphaMap=source.alphaMap,this.envMap=source.envMap,this.combine=source.combine,this.reflectivity=source.reflectivity,this.refractionRatio=source.refractionRatio,this.wireframe=source.wireframe,this.wireframeLinewidth=source.wireframeLinewidth,this.wireframeLinecap=source.wireframeLinecap,this.wireframeLinejoin=source.wireframeLinejoin,this.skinning=source.skinning,this.morphTargets=source.morphTargets,this.morphNormals=source.morphNormals,this},MeshMatcapMaterial.prototype=Object.create(Material.prototype),MeshMatcapMaterial.prototype.constructor=MeshMatcapMaterial,MeshMatcapMaterial.prototype.isMeshMatcapMaterial=!0,MeshMatcapMaterial.prototype.copy=function(source){return Material.prototype.copy.call(this,source),this.defines={MATCAP:""},this.color.copy(source.color),this.matcap=source.matcap,this.map=source.map,this.bumpMap=source.bumpMap,this.bumpScale=source.bumpScale,this.normalMap=source.normalMap,this.normalMapType=source.normalMapType,this.normalScale.copy(source.normalScale),this.displacementMap=source.displacementMap,this.displacementScale=source.displacementScale,this.displacementBias=source.displacementBias,this.alphaMap=source.alphaMap,this.skinning=source.skinning,this.morphTargets=source.morphTargets,this.morphNormals=source.morphNormals,this},LineDashedMaterial.prototype=Object.create(LineBasicMaterial.prototype),LineDashedMaterial.prototype.constructor=LineDashedMaterial,LineDashedMaterial.prototype.isLineDashedMaterial=!0,LineDashedMaterial.prototype.copy=function(source){return LineBasicMaterial.prototype.copy.call(this,source),this.scale=source.scale,this.dashSize=source.dashSize,this.gapSize=source.gapSize,this};var Materials=Object.freeze({__proto__:null,ShadowMaterial,SpriteMaterial,RawShaderMaterial,ShaderMaterial,PointsMaterial,MeshPhysicalMaterial,MeshStandardMaterial,MeshPhongMaterial,MeshToonMaterial,MeshNormalMaterial,MeshLambertMaterial,MeshDepthMaterial,MeshDistanceMaterial,MeshBasicMaterial,MeshMatcapMaterial,LineDashedMaterial,LineBasicMaterial,Material});const AnimationUtils={arraySlice:function(array,from,to){return AnimationUtils.isTypedArray(array)?new array.constructor(array.subarray(from,void 0!==to?to:array.length)):array.slice(from,to)},convertArray:function(array,type,forceClone){return!array||!forceClone&&array.constructor===type?array:"number"==typeof type.BYTES_PER_ELEMENT?new type(array):Array.prototype.slice.call(array)},isTypedArray:function(object){return ArrayBuffer.isView(object)&&!(object instanceof DataView)},getKeyframeOrder:function(times){const n=times.length,result=new Array(n);for(let i=0;i!==n;++i)result[i]=i;return result.sort((function(i,j){return times[i]-times[j]})),result},sortedArray:function(values,stride,order){const nValues=values.length,result=new values.constructor(nValues);for(let i=0,dstOffset=0;dstOffset!==nValues;++i){const srcOffset=order[i]*stride;for(let j=0;j!==stride;++j)result[dstOffset++]=values[srcOffset+j]}return result},flattenJSON:function(jsonKeys,times,values,valuePropertyName){let i=1,key=jsonKeys[0];for(;void 0!==key&&void 0===key[valuePropertyName];)key=jsonKeys[i++];if(void 0===key)return;let value=key[valuePropertyName];if(void 0!==value)if(Array.isArray(value))do{value=key[valuePropertyName],void 0!==value&&(times.push(key.time),values.push.apply(values,value)),key=jsonKeys[i++]}while(void 0!==key);else if(void 0!==value.toArray)do{value=key[valuePropertyName],void 0!==value&&(times.push(key.time),value.toArray(values,values.length)),key=jsonKeys[i++]}while(void 0!==key);else do{value=key[valuePropertyName],void 0!==value&&(times.push(key.time),values.push(value)),key=jsonKeys[i++]}while(void 0!==key)},subclip:function(sourceClip,name,startFrame,endFrame,fps){fps=fps||30;const clip=sourceClip.clone();clip.name=name;const tracks=[];for(let i=0;i<clip.tracks.length;++i){const track=clip.tracks[i],valueSize=track.getValueSize(),times=[],values=[];for(let j=0;j<track.times.length;++j){const frame=track.times[j]*fps;if(!(frame<startFrame||frame>=endFrame)){times.push(track.times[j]);for(let k=0;k<valueSize;++k)values.push(track.values[j*valueSize+k])}}0!==times.length&&(track.times=AnimationUtils.convertArray(times,track.times.constructor),track.values=AnimationUtils.convertArray(values,track.values.constructor),tracks.push(track))}clip.tracks=tracks;let minStartTime=1/0;for(let i=0;i<clip.tracks.length;++i)minStartTime>clip.tracks[i].times[0]&&(minStartTime=clip.tracks[i].times[0]);for(let i=0;i<clip.tracks.length;++i)clip.tracks[i].shift(-1*minStartTime);return clip.resetDuration(),clip},makeClipAdditive:function(targetClip,referenceFrame,referenceClip,fps){void 0===referenceFrame&&(referenceFrame=0),void 0===referenceClip&&(referenceClip=targetClip),(void 0===fps||fps<=0)&&(fps=30);const numTracks=targetClip.tracks.length,referenceTime=referenceFrame/fps;for(let i=0;i<numTracks;++i){const referenceTrack=referenceClip.tracks[i],referenceTrackType=referenceTrack.ValueTypeName;if("bool"===referenceTrackType||"string"===referenceTrackType)continue;const targetTrack=targetClip.tracks.find((function(track){return track.name===referenceTrack.name&&track.ValueTypeName===referenceTrackType}));if(void 0===targetTrack)continue;const valueSize=referenceTrack.getValueSize(),lastIndex=referenceTrack.times.length-1;let referenceValue;if(referenceTime<=referenceTrack.times[0])referenceValue=AnimationUtils.arraySlice(referenceTrack.values,0,referenceTrack.valueSize);else if(referenceTime>=referenceTrack.times[lastIndex]){const startIndex=lastIndex*valueSize;referenceValue=AnimationUtils.arraySlice(referenceTrack.values,startIndex)}else{const interpolant=referenceTrack.createInterpolant();interpolant.evaluate(referenceTime),referenceValue=interpolant.resultBuffer}if("quaternion"===referenceTrackType){new Quaternion(referenceValue[0],referenceValue[1],referenceValue[2],referenceValue[3]).normalize().conjugate().toArray(referenceValue)}const numTimes=targetTrack.times.length;for(let j=0;j<numTimes;++j){const valueStart=j*valueSize;if("quaternion"===referenceTrackType)Quaternion.multiplyQuaternionsFlat(targetTrack.values,valueStart,referenceValue,0,targetTrack.values,valueStart);else for(let k=0;k<valueSize;++k)targetTrack.values[valueStart+k]-=referenceValue[k]}}return targetClip.blendMode=2501,targetClip}};function Interpolant(parameterPositions,sampleValues,sampleSize,resultBuffer){this.parameterPositions=parameterPositions,this._cachedIndex=0,this.resultBuffer=void 0!==resultBuffer?resultBuffer:new sampleValues.constructor(sampleSize),this.sampleValues=sampleValues,this.valueSize=sampleSize}function CubicInterpolant(parameterPositions,sampleValues,sampleSize,resultBuffer){Interpolant.call(this,parameterPositions,sampleValues,sampleSize,resultBuffer),this._weightPrev=-0,this._offsetPrev=-0,this._weightNext=-0,this._offsetNext=-0}function LinearInterpolant(parameterPositions,sampleValues,sampleSize,resultBuffer){Interpolant.call(this,parameterPositions,sampleValues,sampleSize,resultBuffer)}function DiscreteInterpolant(parameterPositions,sampleValues,sampleSize,resultBuffer){Interpolant.call(this,parameterPositions,sampleValues,sampleSize,resultBuffer)}function KeyframeTrack(name,times,values,interpolation){if(void 0===name)throw new Error("THREE.KeyframeTrack: track name is undefined");if(void 0===times||0===times.length)throw new Error("THREE.KeyframeTrack: no keyframes in track named "+name);this.name=name,this.times=AnimationUtils.convertArray(times,this.TimeBufferType),this.values=AnimationUtils.convertArray(values,this.ValueBufferType),this.setInterpolation(interpolation||this.DefaultInterpolation)}function BooleanKeyframeTrack(name,times,values){KeyframeTrack.call(this,name,times,values)}function ColorKeyframeTrack(name,times,values,interpolation){KeyframeTrack.call(this,name,times,values,interpolation)}function NumberKeyframeTrack(name,times,values,interpolation){KeyframeTrack.call(this,name,times,values,interpolation)}function QuaternionLinearInterpolant(parameterPositions,sampleValues,sampleSize,resultBuffer){Interpolant.call(this,parameterPositions,sampleValues,sampleSize,resultBuffer)}function QuaternionKeyframeTrack(name,times,values,interpolation){KeyframeTrack.call(this,name,times,values,interpolation)}function StringKeyframeTrack(name,times,values,interpolation){KeyframeTrack.call(this,name,times,values,interpolation)}function VectorKeyframeTrack(name,times,values,interpolation){KeyframeTrack.call(this,name,times,values,interpolation)}function AnimationClip(name,duration,tracks,blendMode){this.name=name,this.tracks=tracks,this.duration=void 0!==duration?duration:-1,this.blendMode=void 0!==blendMode?blendMode:2500,this.uuid=MathUtils.generateUUID(),this.duration<0&&this.resetDuration()}function parseKeyframeTrack(json){if(void 0===json.type)throw new Error("THREE.KeyframeTrack: track type undefined, can not parse");const trackType=function(typeName){switch(typeName.toLowerCase()){case"scalar":case"double":case"float":case"number":case"integer":return NumberKeyframeTrack;case"vector":case"vector2":case"vector3":case"vector4":return VectorKeyframeTrack;case"color":return ColorKeyframeTrack;case"quaternion":return QuaternionKeyframeTrack;case"bool":case"boolean":return BooleanKeyframeTrack;case"string":return StringKeyframeTrack}throw new Error("THREE.KeyframeTrack: Unsupported typeName: "+typeName)}(json.type);if(void 0===json.times){const times=[],values=[];AnimationUtils.flattenJSON(json.keys,times,values,"value"),json.times=times,json.values=values}return void 0!==trackType.parse?trackType.parse(json):new trackType(json.name,json.times,json.values,json.interpolation)}Object.assign(Interpolant.prototype,{evaluate:function(t){let pp=this.parameterPositions,i1=this._cachedIndex,t1=pp[i1],t0=pp[i1-1];validate_interval:{seek:{let right;linear_scan:{forward_scan:if(!(t<t1)){for(let giveUpAt=i1+2;;){if(void 0===t1){if(t<t0)break forward_scan;return i1=pp.length,this._cachedIndex=i1,this.afterEnd_(i1-1,t,t0)}if(i1===giveUpAt)break;if(t0=t1,t1=pp[++i1],t<t1)break seek}right=pp.length;break linear_scan}if(t>=t0)break validate_interval;{const t1global=pp[1];t<t1global&&(i1=2,t0=t1global);for(let giveUpAt=i1-2;;){if(void 0===t0)return this._cachedIndex=0,this.beforeStart_(0,t,t1);if(i1===giveUpAt)break;if(t1=t0,t0=pp[--i1-1],t>=t0)break seek}right=i1,i1=0}}for(;i1<right;){const mid=i1+right>>>1;t<pp[mid]?right=mid:i1=mid+1}if(t1=pp[i1],t0=pp[i1-1],void 0===t0)return this._cachedIndex=0,this.beforeStart_(0,t,t1);if(void 0===t1)return i1=pp.length,this._cachedIndex=i1,this.afterEnd_(i1-1,t0,t)}this._cachedIndex=i1,this.intervalChanged_(i1,t0,t1)}return this.interpolate_(i1,t0,t,t1)},settings:null,DefaultSettings_:{},getSettings_:function(){return this.settings||this.DefaultSettings_},copySampleValue_:function(index){const result=this.resultBuffer,values=this.sampleValues,stride=this.valueSize,offset=index*stride;for(let i=0;i!==stride;++i)result[i]=values[offset+i];return result},interpolate_:function(){throw new Error("call to abstract method")},intervalChanged_:function(){}}),Object.assign(Interpolant.prototype,{beforeStart_:Interpolant.prototype.copySampleValue_,afterEnd_:Interpolant.prototype.copySampleValue_}),CubicInterpolant.prototype=Object.assign(Object.create(Interpolant.prototype),{constructor:CubicInterpolant,DefaultSettings_:{endingStart:2400,endingEnd:2400},intervalChanged_:function(i1,t0,t1){let pp=this.parameterPositions,iPrev=i1-2,iNext=i1+1,tPrev=pp[iPrev],tNext=pp[iNext];if(void 0===tPrev)switch(this.getSettings_().endingStart){case 2401:iPrev=i1,tPrev=2*t0-t1;break;case 2402:iPrev=pp.length-2,tPrev=t0+pp[iPrev]-pp[iPrev+1];break;default:iPrev=i1,tPrev=t1}if(void 0===tNext)switch(this.getSettings_().endingEnd){case 2401:iNext=i1,tNext=2*t1-t0;break;case 2402:iNext=1,tNext=t1+pp[1]-pp[0];break;default:iNext=i1-1,tNext=t0}const halfDt=.5*(t1-t0),stride=this.valueSize;this._weightPrev=halfDt/(t0-tPrev),this._weightNext=halfDt/(tNext-t1),this._offsetPrev=iPrev*stride,this._offsetNext=iNext*stride},interpolate_:function(i1,t0,t,t1){const result=this.resultBuffer,values=this.sampleValues,stride=this.valueSize,o1=i1*stride,o0=o1-stride,oP=this._offsetPrev,oN=this._offsetNext,wP=this._weightPrev,wN=this._weightNext,p=(t-t0)/(t1-t0),pp=p*p,ppp=pp*p,sP=-wP*ppp+2*wP*pp-wP*p,s0=(1+wP)*ppp+(-1.5-2*wP)*pp+(-.5+wP)*p+1,s1=(-1-wN)*ppp+(1.5+wN)*pp+.5*p,sN=wN*ppp-wN*pp;for(let i=0;i!==stride;++i)result[i]=sP*values[oP+i]+s0*values[o0+i]+s1*values[o1+i]+sN*values[oN+i];return result}}),LinearInterpolant.prototype=Object.assign(Object.create(Interpolant.prototype),{constructor:LinearInterpolant,interpolate_:function(i1,t0,t,t1){const result=this.resultBuffer,values=this.sampleValues,stride=this.valueSize,offset1=i1*stride,offset0=offset1-stride,weight1=(t-t0)/(t1-t0),weight0=1-weight1;for(let i=0;i!==stride;++i)result[i]=values[offset0+i]*weight0+values[offset1+i]*weight1;return result}}),DiscreteInterpolant.prototype=Object.assign(Object.create(Interpolant.prototype),{constructor:DiscreteInterpolant,interpolate_:function(i1){return this.copySampleValue_(i1-1)}}),Object.assign(KeyframeTrack,{toJSON:function(track){const trackType=track.constructor;let json;if(void 0!==trackType.toJSON)json=trackType.toJSON(track);else{json={name:track.name,times:AnimationUtils.convertArray(track.times,Array),values:AnimationUtils.convertArray(track.values,Array)};const interpolation=track.getInterpolation();interpolation!==track.DefaultInterpolation&&(json.interpolation=interpolation)}return json.type=track.ValueTypeName,json}}),Object.assign(KeyframeTrack.prototype,{constructor:KeyframeTrack,TimeBufferType:Float32Array,ValueBufferType:Float32Array,DefaultInterpolation:2301,InterpolantFactoryMethodDiscrete:function(result){return new DiscreteInterpolant(this.times,this.values,this.getValueSize(),result)},InterpolantFactoryMethodLinear:function(result){return new LinearInterpolant(this.times,this.values,this.getValueSize(),result)},InterpolantFactoryMethodSmooth:function(result){return new CubicInterpolant(this.times,this.values,this.getValueSize(),result)},setInterpolation:function(interpolation){let factoryMethod;switch(interpolation){case 2300:factoryMethod=this.InterpolantFactoryMethodDiscrete;break;case 2301:factoryMethod=this.InterpolantFactoryMethodLinear;break;case 2302:factoryMethod=this.InterpolantFactoryMethodSmooth}if(void 0===factoryMethod){const message="unsupported interpolation for "+this.ValueTypeName+" keyframe track named "+this.name;if(void 0===this.createInterpolant){if(interpolation===this.DefaultInterpolation)throw new Error(message);this.setInterpolation(this.DefaultInterpolation)}return console.warn("THREE.KeyframeTrack:",message),this}return this.createInterpolant=factoryMethod,this},getInterpolation:function(){switch(this.createInterpolant){case this.InterpolantFactoryMethodDiscrete:return 2300;case this.InterpolantFactoryMethodLinear:return 2301;case this.InterpolantFactoryMethodSmooth:return 2302}},getValueSize:function(){return this.values.length/this.times.length},shift:function(timeOffset){if(0!==timeOffset){const times=this.times;for(let i=0,n=times.length;i!==n;++i)times[i]+=timeOffset}return this},scale:function(timeScale){if(1!==timeScale){const times=this.times;for(let i=0,n=times.length;i!==n;++i)times[i]*=timeScale}return this},trim:function(startTime,endTime){const times=this.times,nKeys=times.length;let from=0,to=nKeys-1;for(;from!==nKeys&&times[from]<startTime;)++from;for(;-1!==to&&times[to]>endTime;)--to;if(++to,0!==from||to!==nKeys){from>=to&&(to=Math.max(to,1),from=to-1);const stride=this.getValueSize();this.times=AnimationUtils.arraySlice(times,from,to),this.values=AnimationUtils.arraySlice(this.values,from*stride,to*stride)}return this},validate:function(){let valid=!0;const valueSize=this.getValueSize();valueSize-Math.floor(valueSize)!=0&&(console.error("THREE.KeyframeTrack: Invalid value size in track.",this),valid=!1);const times=this.times,values=this.values,nKeys=times.length;0===nKeys&&(console.error("THREE.KeyframeTrack: Track is empty.",this),valid=!1);let prevTime=null;for(let i=0;i!==nKeys;i++){const currTime=times[i];if("number"==typeof currTime&&isNaN(currTime)){console.error("THREE.KeyframeTrack: Time is not a valid number.",this,i,currTime),valid=!1;break}if(null!==prevTime&&prevTime>currTime){console.error("THREE.KeyframeTrack: Out of order keys.",this,i,currTime,prevTime),valid=!1;break}prevTime=currTime}if(void 0!==values&&AnimationUtils.isTypedArray(values))for(let i=0,n=values.length;i!==n;++i){const value=values[i];if(isNaN(value)){console.error("THREE.KeyframeTrack: Value is not a valid number.",this,i,value),valid=!1;break}}return valid},optimize:function(){const times=AnimationUtils.arraySlice(this.times),values=AnimationUtils.arraySlice(this.values),stride=this.getValueSize(),smoothInterpolation=2302===this.getInterpolation(),lastIndex=times.length-1;let writeIndex=1;for(let i=1;i<lastIndex;++i){let keep=!1;const time=times[i];if(time!==times[i+1]&&(1!==i||time!==time[0]))if(smoothInterpolation)keep=!0;else{const offset=i*stride,offsetP=offset-stride,offsetN=offset+stride;for(let j=0;j!==stride;++j){const value=values[offset+j];if(value!==values[offsetP+j]||value!==values[offsetN+j]){keep=!0;break}}}if(keep){if(i!==writeIndex){times[writeIndex]=times[i];const readOffset=i*stride,writeOffset=writeIndex*stride;for(let j=0;j!==stride;++j)values[writeOffset+j]=values[readOffset+j]}++writeIndex}}if(lastIndex>0){times[writeIndex]=times[lastIndex];for(let readOffset=lastIndex*stride,writeOffset=writeIndex*stride,j=0;j!==stride;++j)values[writeOffset+j]=values[readOffset+j];++writeIndex}return writeIndex!==times.length?(this.times=AnimationUtils.arraySlice(times,0,writeIndex),this.values=AnimationUtils.arraySlice(values,0,writeIndex*stride)):(this.times=times,this.values=values),this},clone:function(){const times=AnimationUtils.arraySlice(this.times,0),values=AnimationUtils.arraySlice(this.values,0),track=new(0,this.constructor)(this.name,times,values);return track.createInterpolant=this.createInterpolant,track}}),BooleanKeyframeTrack.prototype=Object.assign(Object.create(KeyframeTrack.prototype),{constructor:BooleanKeyframeTrack,ValueTypeName:"bool",ValueBufferType:Array,DefaultInterpolation:2300,InterpolantFactoryMethodLinear:void 0,InterpolantFactoryMethodSmooth:void 0}),ColorKeyframeTrack.prototype=Object.assign(Object.create(KeyframeTrack.prototype),{constructor:ColorKeyframeTrack,ValueTypeName:"color"}),NumberKeyframeTrack.prototype=Object.assign(Object.create(KeyframeTrack.prototype),{constructor:NumberKeyframeTrack,ValueTypeName:"number"}),QuaternionLinearInterpolant.prototype=Object.assign(Object.create(Interpolant.prototype),{constructor:QuaternionLinearInterpolant,interpolate_:function(i1,t0,t,t1){const result=this.resultBuffer,values=this.sampleValues,stride=this.valueSize,alpha=(t-t0)/(t1-t0);let offset=i1*stride;for(let end=offset+stride;offset!==end;offset+=4)Quaternion.slerpFlat(result,0,values,offset-stride,values,offset,alpha);return result}}),QuaternionKeyframeTrack.prototype=Object.assign(Object.create(KeyframeTrack.prototype),{constructor:QuaternionKeyframeTrack,ValueTypeName:"quaternion",DefaultInterpolation:2301,InterpolantFactoryMethodLinear:function(result){return new QuaternionLinearInterpolant(this.times,this.values,this.getValueSize(),result)},InterpolantFactoryMethodSmooth:void 0}),StringKeyframeTrack.prototype=Object.assign(Object.create(KeyframeTrack.prototype),{constructor:StringKeyframeTrack,ValueTypeName:"string",ValueBufferType:Array,DefaultInterpolation:2300,InterpolantFactoryMethodLinear:void 0,InterpolantFactoryMethodSmooth:void 0}),VectorKeyframeTrack.prototype=Object.assign(Object.create(KeyframeTrack.prototype),{constructor:VectorKeyframeTrack,ValueTypeName:"vector"}),Object.assign(AnimationClip,{parse:function(json){const tracks=[],jsonTracks=json.tracks,frameTime=1/(json.fps||1);for(let i=0,n=jsonTracks.length;i!==n;++i)tracks.push(parseKeyframeTrack(jsonTracks[i]).scale(frameTime));return new AnimationClip(json.name,json.duration,tracks,json.blendMode)},toJSON:function(clip){const tracks=[],clipTracks=clip.tracks,json={name:clip.name,duration:clip.duration,tracks,uuid:clip.uuid,blendMode:clip.blendMode};for(let i=0,n=clipTracks.length;i!==n;++i)tracks.push(KeyframeTrack.toJSON(clipTracks[i]));return json},CreateFromMorphTargetSequence:function(name,morphTargetSequence,fps,noLoop){const numMorphTargets=morphTargetSequence.length,tracks=[];for(let i=0;i<numMorphTargets;i++){let times=[],values=[];times.push((i+numMorphTargets-1)%numMorphTargets,i,(i+1)%numMorphTargets),values.push(0,1,0);const order=AnimationUtils.getKeyframeOrder(times);times=AnimationUtils.sortedArray(times,1,order),values=AnimationUtils.sortedArray(values,1,order),noLoop||0!==times[0]||(times.push(numMorphTargets),values.push(values[0])),tracks.push(new NumberKeyframeTrack(".morphTargetInfluences["+morphTargetSequence[i].name+"]",times,values).scale(1/fps))}return new AnimationClip(name,-1,tracks)},findByName:function(objectOrClipArray,name){let clipArray=objectOrClipArray;if(!Array.isArray(objectOrClipArray)){const o=objectOrClipArray;clipArray=o.geometry&&o.geometry.animations||o.animations}for(let i=0;i<clipArray.length;i++)if(clipArray[i].name===name)return clipArray[i];return null},CreateClipsFromMorphTargetSequences:function(morphTargets,fps,noLoop){const animationToMorphTargets={},pattern=/^([\w-]*?)([\d]+)$/;for(let i=0,il=morphTargets.length;i<il;i++){const morphTarget=morphTargets[i],parts=morphTarget.name.match(pattern);if(parts&&parts.length>1){const name=parts[1];let animationMorphTargets=animationToMorphTargets[name];animationMorphTargets||(animationToMorphTargets[name]=animationMorphTargets=[]),animationMorphTargets.push(morphTarget)}}const clips=[];for(const name in animationToMorphTargets)clips.push(AnimationClip.CreateFromMorphTargetSequence(name,animationToMorphTargets[name],fps,noLoop));return clips},parseAnimation:function(animation,bones){if(!animation)return console.error("THREE.AnimationClip: No animation in JSONLoader data."),null;const addNonemptyTrack=function(trackType,trackName,animationKeys,propertyName,destTracks){if(0!==animationKeys.length){const times=[],values=[];AnimationUtils.flattenJSON(animationKeys,times,values,propertyName),0!==times.length&&destTracks.push(new trackType(trackName,times,values))}},tracks=[],clipName=animation.name||"default",fps=animation.fps||30,blendMode=animation.blendMode;let duration=animation.length||-1;const hierarchyTracks=animation.hierarchy||[];for(let h=0;h<hierarchyTracks.length;h++){const animationKeys=hierarchyTracks[h].keys;if(animationKeys&&0!==animationKeys.length)if(animationKeys[0].morphTargets){const morphTargetNames={};let k;for(k=0;k<animationKeys.length;k++)if(animationKeys[k].morphTargets)for(let m=0;m<animationKeys[k].morphTargets.length;m++)morphTargetNames[animationKeys[k].morphTargets[m]]=-1;for(const morphTargetName in morphTargetNames){const times=[],values=[];for(let m=0;m!==animationKeys[k].morphTargets.length;++m){const animationKey=animationKeys[k];times.push(animationKey.time),values.push(animationKey.morphTarget===morphTargetName?1:0)}tracks.push(new NumberKeyframeTrack(".morphTargetInfluence["+morphTargetName+"]",times,values))}duration=morphTargetNames.length*(fps||1)}else{const boneName=".bones["+bones[h].name+"]";addNonemptyTrack(VectorKeyframeTrack,boneName+".position",animationKeys,"pos",tracks),addNonemptyTrack(QuaternionKeyframeTrack,boneName+".quaternion",animationKeys,"rot",tracks),addNonemptyTrack(VectorKeyframeTrack,boneName+".scale",animationKeys,"scl",tracks)}}if(0===tracks.length)return null;return new AnimationClip(clipName,duration,tracks,blendMode)}}),Object.assign(AnimationClip.prototype,{resetDuration:function(){let duration=0;for(let i=0,n=this.tracks.length;i!==n;++i){const track=this.tracks[i];duration=Math.max(duration,track.times[track.times.length-1])}return this.duration=duration,this},trim:function(){for(let i=0;i<this.tracks.length;i++)this.tracks[i].trim(0,this.duration);return this},validate:function(){let valid=!0;for(let i=0;i<this.tracks.length;i++)valid=valid&&this.tracks[i].validate();return valid},optimize:function(){for(let i=0;i<this.tracks.length;i++)this.tracks[i].optimize();return this},clone:function(){const tracks=[];for(let i=0;i<this.tracks.length;i++)tracks.push(this.tracks[i].clone());return new AnimationClip(this.name,this.duration,tracks,this.blendMode)}});const Cache={enabled:!1,files:{},add:function(key,file){!1!==this.enabled&&(this.files[key]=file)},get:function(key){if(!1!==this.enabled)return this.files[key]},remove:function(key){delete this.files[key]},clear:function(){this.files={}}};function LoadingManager(onLoad,onProgress,onError){const scope=this;let isLoading=!1,itemsLoaded=0,itemsTotal=0,urlModifier=void 0;const handlers=[];this.onStart=void 0,this.onLoad=onLoad,this.onProgress=onProgress,this.onError=onError,this.itemStart=function(url){itemsTotal++,!1===isLoading&&void 0!==scope.onStart&&scope.onStart(url,itemsLoaded,itemsTotal),isLoading=!0},this.itemEnd=function(url){itemsLoaded++,void 0!==scope.onProgress&&scope.onProgress(url,itemsLoaded,itemsTotal),itemsLoaded===itemsTotal&&(isLoading=!1,void 0!==scope.onLoad&&scope.onLoad())},this.itemError=function(url){void 0!==scope.onError&&scope.onError(url)},this.resolveURL=function(url){return urlModifier?urlModifier(url):url},this.setURLModifier=function(transform){return urlModifier=transform,this},this.addHandler=function(regex,loader){return handlers.push(regex,loader),this},this.removeHandler=function(regex){const index=handlers.indexOf(regex);return-1!==index&&handlers.splice(index,2),this},this.getHandler=function(file){for(let i=0,l=handlers.length;i<l;i+=2){const regex=handlers[i],loader=handlers[i+1];if(regex.global&&(regex.lastIndex=0),regex.test(file))return loader}return null}}const DefaultLoadingManager=new LoadingManager;function Loader(manager){this.manager=void 0!==manager?manager:DefaultLoadingManager,this.crossOrigin="anonymous",this.path="",this.resourcePath="",this.requestHeader={}}Object.assign(Loader.prototype,{load:function(){},loadAsync:function(url,onProgress){const scope=this;return new Promise((function(resolve,reject){scope.load(url,resolve,onProgress,reject)}))},parse:function(){},setCrossOrigin:function(crossOrigin){return this.crossOrigin=crossOrigin,this},setPath:function(path){return this.path=path,this},setResourcePath:function(resourcePath){return this.resourcePath=resourcePath,this},setRequestHeader:function(requestHeader){return this.requestHeader=requestHeader,this}});const loading={};function FileLoader(manager){Loader.call(this,manager)}function AnimationLoader(manager){Loader.call(this,manager)}function CompressedTextureLoader(manager){Loader.call(this,manager)}function DataTextureLoader(manager){Loader.call(this,manager)}function ImageLoader(manager){Loader.call(this,manager)}function CubeTextureLoader(manager){Loader.call(this,manager)}function TextureLoader(manager){Loader.call(this,manager)}function Curve(){this.type="Curve",this.arcLengthDivisions=200}function EllipseCurve(aX,aY,xRadius,yRadius,aStartAngle,aEndAngle,aClockwise,aRotation){Curve.call(this),this.type="EllipseCurve",this.aX=aX||0,this.aY=aY||0,this.xRadius=xRadius||1,this.yRadius=yRadius||1,this.aStartAngle=aStartAngle||0,this.aEndAngle=aEndAngle||2*Math.PI,this.aClockwise=aClockwise||!1,this.aRotation=aRotation||0}function ArcCurve(aX,aY,aRadius,aStartAngle,aEndAngle,aClockwise){EllipseCurve.call(this,aX,aY,aRadius,aRadius,aStartAngle,aEndAngle,aClockwise),this.type="ArcCurve"}function CubicPoly(){let c0=0,c1=0,c2=0,c3=0;function init(x0,x1,t0,t1){c0=x0,c1=t0,c2=-3*x0+3*x1-2*t0-t1,c3=2*x0-2*x1+t0+t1}return{initCatmullRom:function(x0,x1,x2,x3,tension){init(x1,x2,tension*(x2-x0),tension*(x3-x1))},initNonuniformCatmullRom:function(x0,x1,x2,x3,dt0,dt1,dt2){let t1=(x1-x0)/dt0-(x2-x0)/(dt0+dt1)+(x2-x1)/dt1,t2=(x2-x1)/dt1-(x3-x1)/(dt1+dt2)+(x3-x2)/dt2;t1*=dt1,t2*=dt1,init(x1,x2,t1,t2)},calc:function(t){const t2=t*t;return c0+c1*t+c2*t2+c3*(t2*t)}}}FileLoader.prototype=Object.assign(Object.create(Loader.prototype),{constructor:FileLoader,load:function(url,onLoad,onProgress,onError){void 0===url&&(url=""),void 0!==this.path&&(url=this.path+url),url=this.manager.resolveURL(url);const scope=this,cached=Cache.get(url);if(void 0!==cached)return scope.manager.itemStart(url),setTimeout((function(){onLoad&&onLoad(cached),scope.manager.itemEnd(url)}),0),cached;if(void 0!==loading[url])return void loading[url].push({onLoad,onProgress,onError});const dataUriRegexResult=url.match(/^data:(.*?)(;base64)?,(.*)$/);let request;if(dataUriRegexResult){const mimeType=dataUriRegexResult[1],isBase64=!!dataUriRegexResult[2];let data=dataUriRegexResult[3];data=decodeURIComponent(data),isBase64&&(data=atob(data));try{let response;const responseType=(this.responseType||"").toLowerCase();switch(responseType){case"arraybuffer":case"blob":const view=new Uint8Array(data.length);for(let i=0;i<data.length;i++)view[i]=data.charCodeAt(i);response="blob"===responseType?new Blob([view.buffer],{type:mimeType}):view.buffer;break;case"document":const parser=new DOMParser;response=parser.parseFromString(data,mimeType);break;case"json":response=JSON.parse(data);break;default:response=data}setTimeout((function(){onLoad&&onLoad(response),scope.manager.itemEnd(url)}),0)}catch(error){setTimeout((function(){onError&&onError(error),scope.manager.itemError(url),scope.manager.itemEnd(url)}),0)}}else{loading[url]=[],loading[url].push({onLoad,onProgress,onError}),request=new XMLHttpRequest,request.open("GET",url,!0),request.addEventListener("load",(function(event){const response=this.response,callbacks=loading[url];if(delete loading[url],200===this.status||0===this.status){0===this.status&&console.warn("THREE.FileLoader: HTTP Status 0 received."),Cache.add(url,response);for(let i=0,il=callbacks.length;i<il;i++){const callback=callbacks[i];callback.onLoad&&callback.onLoad(response)}scope.manager.itemEnd(url)}else{for(let i=0,il=callbacks.length;i<il;i++){const callback=callbacks[i];callback.onError&&callback.onError(event)}scope.manager.itemError(url),scope.manager.itemEnd(url)}}),!1),request.addEventListener("progress",(function(event){const callbacks=loading[url];for(let i=0,il=callbacks.length;i<il;i++){const callback=callbacks[i];callback.onProgress&&callback.onProgress(event)}}),!1),request.addEventListener("error",(function(event){const callbacks=loading[url];delete loading[url];for(let i=0,il=callbacks.length;i<il;i++){const callback=callbacks[i];callback.onError&&callback.onError(event)}scope.manager.itemError(url),scope.manager.itemEnd(url)}),!1),request.addEventListener("abort",(function(event){const callbacks=loading[url];delete loading[url];for(let i=0,il=callbacks.length;i<il;i++){const callback=callbacks[i];callback.onError&&callback.onError(event)}scope.manager.itemError(url),scope.manager.itemEnd(url)}),!1),void 0!==this.responseType&&(request.responseType=this.responseType),void 0!==this.withCredentials&&(request.withCredentials=this.withCredentials),request.overrideMimeType&&request.overrideMimeType(void 0!==this.mimeType?this.mimeType:"text/plain");for(const header in this.requestHeader)request.setRequestHeader(header,this.requestHeader[header]);request.send(null)}return scope.manager.itemStart(url),request},setResponseType:function(value){return this.responseType=value,this},setWithCredentials:function(value){return this.withCredentials=value,this},setMimeType:function(value){return this.mimeType=value,this}}),AnimationLoader.prototype=Object.assign(Object.create(Loader.prototype),{constructor:AnimationLoader,load:function(url,onLoad,onProgress,onError){const scope=this,loader=new FileLoader(scope.manager);loader.setPath(scope.path),loader.setRequestHeader(scope.requestHeader),loader.load(url,(function(text){try{onLoad(scope.parse(JSON.parse(text)))}catch(e){onError?onError(e):console.error(e),scope.manager.itemError(url)}}),onProgress,onError)},parse:function(json){const animations=[];for(let i=0;i<json.length;i++){const clip=AnimationClip.parse(json[i]);animations.push(clip)}return animations}}),CompressedTextureLoader.prototype=Object.assign(Object.create(Loader.prototype),{constructor:CompressedTextureLoader,load:function(url,onLoad,onProgress,onError){const scope=this,images=[],texture=new CompressedTexture;texture.image=images;const loader=new FileLoader(this.manager);loader.setPath(this.path),loader.setResponseType("arraybuffer"),loader.setRequestHeader(this.requestHeader);let loaded=0;function loadTexture(i){loader.load(url[i],(function(buffer){const texDatas=scope.parse(buffer,!0);images[i]={width:texDatas.width,height:texDatas.height,format:texDatas.format,mipmaps:texDatas.mipmaps},loaded+=1,6===loaded&&(1===texDatas.mipmapCount&&(texture.minFilter=1006),texture.format=texDatas.format,texture.needsUpdate=!0,onLoad&&onLoad(texture))}),onProgress,onError)}if(Array.isArray(url))for(let i=0,il=url.length;i<il;++i)loadTexture(i);else loader.load(url,(function(buffer){const texDatas=scope.parse(buffer,!0);if(texDatas.isCubemap){const faces=texDatas.mipmaps.length/texDatas.mipmapCount;for(let f=0;f<faces;f++){images[f]={mipmaps:[]};for(let i=0;i<texDatas.mipmapCount;i++)images[f].mipmaps.push(texDatas.mipmaps[f*texDatas.mipmapCount+i]),images[f].format=texDatas.format,images[f].width=texDatas.width,images[f].height=texDatas.height}}else texture.image.width=texDatas.width,texture.image.height=texDatas.height,texture.mipmaps=texDatas.mipmaps;1===texDatas.mipmapCount&&(texture.minFilter=1006),texture.format=texDatas.format,texture.needsUpdate=!0,onLoad&&onLoad(texture)}),onProgress,onError);return texture}}),DataTextureLoader.prototype=Object.assign(Object.create(Loader.prototype),{constructor:DataTextureLoader,load:function(url,onLoad,onProgress,onError){const scope=this,texture=new DataTexture,loader=new FileLoader(this.manager);return loader.setResponseType("arraybuffer"),loader.setRequestHeader(this.requestHeader),loader.setPath(this.path),loader.load(url,(function(buffer){const texData=scope.parse(buffer);texData&&(void 0!==texData.image?texture.image=texData.image:void 0!==texData.data&&(texture.image.width=texData.width,texture.image.height=texData.height,texture.image.data=texData.data),texture.wrapS=void 0!==texData.wrapS?texData.wrapS:1001,texture.wrapT=void 0!==texData.wrapT?texData.wrapT:1001,texture.magFilter=void 0!==texData.magFilter?texData.magFilter:1006,texture.minFilter=void 0!==texData.minFilter?texData.minFilter:1006,texture.anisotropy=void 0!==texData.anisotropy?texData.anisotropy:1,void 0!==texData.format&&(texture.format=texData.format),void 0!==texData.type&&(texture.type=texData.type),void 0!==texData.mipmaps&&(texture.mipmaps=texData.mipmaps,texture.minFilter=1008),1===texData.mipmapCount&&(texture.minFilter=1006),texture.needsUpdate=!0,onLoad&&onLoad(texture,texData))}),onProgress,onError),texture}}),ImageLoader.prototype=Object.assign(Object.create(Loader.prototype),{constructor:ImageLoader,load:function(url,onLoad,onProgress,onError){void 0!==this.path&&(url=this.path+url),url=this.manager.resolveURL(url);const scope=this,cached=Cache.get(url);if(void 0!==cached)return scope.manager.itemStart(url),setTimeout((function(){onLoad&&onLoad(cached),scope.manager.itemEnd(url)}),0),cached;const image=document.createElementNS("http://www.w3.org/1999/xhtml","img");function onImageLoad(){image.removeEventListener("load",onImageLoad,!1),image.removeEventListener("error",onImageError,!1),Cache.add(url,this),onLoad&&onLoad(this),scope.manager.itemEnd(url)}function onImageError(event){image.removeEventListener("load",onImageLoad,!1),image.removeEventListener("error",onImageError,!1),onError&&onError(event),scope.manager.itemError(url),scope.manager.itemEnd(url)}return image.addEventListener("load",onImageLoad,!1),image.addEventListener("error",onImageError,!1),"data:"!==url.substr(0,5)&&void 0!==this.crossOrigin&&(image.crossOrigin=this.crossOrigin),scope.manager.itemStart(url),image.src=url,image}}),CubeTextureLoader.prototype=Object.assign(Object.create(Loader.prototype),{constructor:CubeTextureLoader,load:function(urls,onLoad,onProgress,onError){const texture=new CubeTexture,loader=new ImageLoader(this.manager);loader.setCrossOrigin(this.crossOrigin),loader.setPath(this.path);let loaded=0;function loadTexture(i){loader.load(urls[i],(function(image){texture.images[i]=image,loaded++,6===loaded&&(texture.needsUpdate=!0,onLoad&&onLoad(texture))}),void 0,onError)}for(let i=0;i<urls.length;++i)loadTexture(i);return texture}}),TextureLoader.prototype=Object.assign(Object.create(Loader.prototype),{constructor:TextureLoader,load:function(url,onLoad,onProgress,onError){const texture=new Texture,loader=new ImageLoader(this.manager);return loader.setCrossOrigin(this.crossOrigin),loader.setPath(this.path),loader.load(url,(function(image){texture.image=image;const isJPEG=url.search(/\.jpe?g($|\?)/i)>0||0===url.search(/^data\:image\/jpeg/);texture.format=isJPEG?1022:1023,texture.needsUpdate=!0,void 0!==onLoad&&onLoad(texture)}),onProgress,onError),texture}}),Object.assign(Curve.prototype,{getPoint:function(){return console.warn("THREE.Curve: .getPoint() not implemented."),null},getPointAt:function(u,optionalTarget){const t=this.getUtoTmapping(u);return this.getPoint(t,optionalTarget)},getPoints:function(divisions){void 0===divisions&&(divisions=5);const points=[];for(let d=0;d<=divisions;d++)points.push(this.getPoint(d/divisions));return points},getSpacedPoints:function(divisions){void 0===divisions&&(divisions=5);const points=[];for(let d=0;d<=divisions;d++)points.push(this.getPointAt(d/divisions));return points},getLength:function(){const lengths=this.getLengths();return lengths[lengths.length-1]},getLengths:function(divisions){if(void 0===divisions&&(divisions=this.arcLengthDivisions),this.cacheArcLengths&&this.cacheArcLengths.length===divisions+1&&!this.needsUpdate)return this.cacheArcLengths;this.needsUpdate=!1;const cache=[];let current,last=this.getPoint(0),sum=0;cache.push(0);for(let p=1;p<=divisions;p++)current=this.getPoint(p/divisions),sum+=current.distanceTo(last),cache.push(sum),last=current;return this.cacheArcLengths=cache,cache},updateArcLengths:function(){this.needsUpdate=!0,this.getLengths()},getUtoTmapping:function(u,distance){const arcLengths=this.getLengths();let targetArcLength,i=0,il=arcLengths.length;targetArcLength=distance||u*arcLengths[il-1];let comparison,low=0,high=il-1;for(;low<=high;)if(i=Math.floor(low+(high-low)/2),comparison=arcLengths[i]-targetArcLength,comparison<0)low=i+1;else{if(!(comparison>0)){high=i;break}high=i-1}if(i=high,arcLengths[i]===targetArcLength)return i/(il-1);const lengthBefore=arcLengths[i];return(i+(targetArcLength-lengthBefore)/(arcLengths[i+1]-lengthBefore))/(il-1)},getTangent:function(t,optionalTarget){let t1=t-1e-4,t2=t+1e-4;t1<0&&(t1=0),t2>1&&(t2=1);const pt1=this.getPoint(t1),pt2=this.getPoint(t2),tangent=optionalTarget||(pt1.isVector2?new Vector2:new Vector3);return tangent.copy(pt2).sub(pt1).normalize(),tangent},getTangentAt:function(u,optionalTarget){const t=this.getUtoTmapping(u);return this.getTangent(t,optionalTarget)},computeFrenetFrames:function(segments,closed){const normal=new Vector3,tangents=[],normals=[],binormals=[],vec=new Vector3,mat=new Matrix4;for(let i=0;i<=segments;i++){const u=i/segments;tangents[i]=this.getTangentAt(u,new Vector3),tangents[i].normalize()}normals[0]=new Vector3,binormals[0]=new Vector3;let min=Number.MAX_VALUE;const tx=Math.abs(tangents[0].x),ty=Math.abs(tangents[0].y),tz=Math.abs(tangents[0].z);tx<=min&&(min=tx,normal.set(1,0,0)),ty<=min&&(min=ty,normal.set(0,1,0)),tz<=min&&normal.set(0,0,1),vec.crossVectors(tangents[0],normal).normalize(),normals[0].crossVectors(tangents[0],vec),binormals[0].crossVectors(tangents[0],normals[0]);for(let i=1;i<=segments;i++){if(normals[i]=normals[i-1].clone(),binormals[i]=binormals[i-1].clone(),vec.crossVectors(tangents[i-1],tangents[i]),vec.length()>Number.EPSILON){vec.normalize();const theta=Math.acos(MathUtils.clamp(tangents[i-1].dot(tangents[i]),-1,1));normals[i].applyMatrix4(mat.makeRotationAxis(vec,theta))}binormals[i].crossVectors(tangents[i],normals[i])}if(!0===closed){let theta=Math.acos(MathUtils.clamp(normals[0].dot(normals[segments]),-1,1));theta/=segments,tangents[0].dot(vec.crossVectors(normals[0],normals[segments]))>0&&(theta=-theta);for(let i=1;i<=segments;i++)normals[i].applyMatrix4(mat.makeRotationAxis(tangents[i],theta*i)),binormals[i].crossVectors(tangents[i],normals[i])}return{tangents,normals,binormals}},clone:function(){return(new this.constructor).copy(this)},copy:function(source){return this.arcLengthDivisions=source.arcLengthDivisions,this},toJSON:function(){const data={metadata:{version:4.5,type:"Curve",generator:"Curve.toJSON"}};return data.arcLengthDivisions=this.arcLengthDivisions,data.type=this.type,data},fromJSON:function(json){return this.arcLengthDivisions=json.arcLengthDivisions,this}}),EllipseCurve.prototype=Object.create(Curve.prototype),EllipseCurve.prototype.constructor=EllipseCurve,EllipseCurve.prototype.isEllipseCurve=!0,EllipseCurve.prototype.getPoint=function(t,optionalTarget){const point=optionalTarget||new Vector2,twoPi=2*Math.PI;let deltaAngle=this.aEndAngle-this.aStartAngle;const samePoints=Math.abs(deltaAngle)<Number.EPSILON;for(;deltaAngle<0;)deltaAngle+=twoPi;for(;deltaAngle>twoPi;)deltaAngle-=twoPi;deltaAngle<Number.EPSILON&&(deltaAngle=samePoints?0:twoPi),!0!==this.aClockwise||samePoints||(deltaAngle===twoPi?deltaAngle=-twoPi:deltaAngle-=twoPi);const angle=this.aStartAngle+t*deltaAngle;let x=this.aX+this.xRadius*Math.cos(angle),y=this.aY+this.yRadius*Math.sin(angle);if(0!==this.aRotation){const cos=Math.cos(this.aRotation),sin=Math.sin(this.aRotation),tx=x-this.aX,ty=y-this.aY;x=tx*cos-ty*sin+this.aX,y=tx*sin+ty*cos+this.aY}return point.set(x,y)},EllipseCurve.prototype.copy=function(source){return Curve.prototype.copy.call(this,source),this.aX=source.aX,this.aY=source.aY,this.xRadius=source.xRadius,this.yRadius=source.yRadius,this.aStartAngle=source.aStartAngle,this.aEndAngle=source.aEndAngle,this.aClockwise=source.aClockwise,this.aRotation=source.aRotation,this},EllipseCurve.prototype.toJSON=function(){const data=Curve.prototype.toJSON.call(this);return data.aX=this.aX,data.aY=this.aY,data.xRadius=this.xRadius,data.yRadius=this.yRadius,data.aStartAngle=this.aStartAngle,data.aEndAngle=this.aEndAngle,data.aClockwise=this.aClockwise,data.aRotation=this.aRotation,data},EllipseCurve.prototype.fromJSON=function(json){return Curve.prototype.fromJSON.call(this,json),this.aX=json.aX,this.aY=json.aY,this.xRadius=json.xRadius,this.yRadius=json.yRadius,this.aStartAngle=json.aStartAngle,this.aEndAngle=json.aEndAngle,this.aClockwise=json.aClockwise,this.aRotation=json.aRotation,this},ArcCurve.prototype=Object.create(EllipseCurve.prototype),ArcCurve.prototype.constructor=ArcCurve,ArcCurve.prototype.isArcCurve=!0;const tmp=new Vector3,px=new CubicPoly,py=new CubicPoly,pz=new CubicPoly;function CatmullRomCurve3(points,closed,curveType,tension){Curve.call(this),this.type="CatmullRomCurve3",this.points=points||[],this.closed=closed||!1,this.curveType=curveType||"centripetal",this.tension=void 0!==tension?tension:.5}function CatmullRom(t,p0,p1,p2,p3){const v0=.5*(p2-p0),v1=.5*(p3-p1),t2=t*t;return(2*p1-2*p2+v0+v1)*(t*t2)+(-3*p1+3*p2-2*v0-v1)*t2+v0*t+p1}function QuadraticBezier(t,p0,p1,p2){return function(t,p){const k=1-t;return k*k*p}(t,p0)+function(t,p){return 2*(1-t)*t*p}(t,p1)+function(t,p){return t*t*p}(t,p2)}function CubicBezier(t,p0,p1,p2,p3){return function(t,p){const k=1-t;return k*k*k*p}(t,p0)+function(t,p){const k=1-t;return 3*k*k*t*p}(t,p1)+function(t,p){return 3*(1-t)*t*t*p}(t,p2)+function(t,p){return t*t*t*p}(t,p3)}function CubicBezierCurve(v0,v1,v2,v3){Curve.call(this),this.type="CubicBezierCurve",this.v0=v0||new Vector2,this.v1=v1||new Vector2,this.v2=v2||new Vector2,this.v3=v3||new Vector2}function CubicBezierCurve3(v0,v1,v2,v3){Curve.call(this),this.type="CubicBezierCurve3",this.v0=v0||new Vector3,this.v1=v1||new Vector3,this.v2=v2||new Vector3,this.v3=v3||new Vector3}function LineCurve(v1,v2){Curve.call(this),this.type="LineCurve",this.v1=v1||new Vector2,this.v2=v2||new Vector2}function LineCurve3(v1,v2){Curve.call(this),this.type="LineCurve3",this.v1=v1||new Vector3,this.v2=v2||new Vector3}function QuadraticBezierCurve(v0,v1,v2){Curve.call(this),this.type="QuadraticBezierCurve",this.v0=v0||new Vector2,this.v1=v1||new Vector2,this.v2=v2||new Vector2}function QuadraticBezierCurve3(v0,v1,v2){Curve.call(this),this.type="QuadraticBezierCurve3",this.v0=v0||new Vector3,this.v1=v1||new Vector3,this.v2=v2||new Vector3}function SplineCurve(points){Curve.call(this),this.type="SplineCurve",this.points=points||[]}CatmullRomCurve3.prototype=Object.create(Curve.prototype),CatmullRomCurve3.prototype.constructor=CatmullRomCurve3,CatmullRomCurve3.prototype.isCatmullRomCurve3=!0,CatmullRomCurve3.prototype.getPoint=function(t,optionalTarget){const point=optionalTarget||new Vector3,points=this.points,l=points.length,p=(l-(this.closed?0:1))*t;let p0,p1,p2,p3,intPoint=Math.floor(p),weight=p-intPoint;if(this.closed?intPoint+=intPoint>0?0:(Math.floor(Math.abs(intPoint)/l)+1)*l:0===weight&&intPoint===l-1&&(intPoint=l-2,weight=1),this.closed||intPoint>0?p0=points[(intPoint-1)%l]:(tmp.subVectors(points[0],points[1]).add(points[0]),p0=tmp),p1=points[intPoint%l],p2=points[(intPoint+1)%l],this.closed||intPoint+2<l?p3=points[(intPoint+2)%l]:(tmp.subVectors(points[l-1],points[l-2]).add(points[l-1]),p3=tmp),"centripetal"===this.curveType||"chordal"===this.curveType){const pow="chordal"===this.curveType?.5:.25;let dt0=Math.pow(p0.distanceToSquared(p1),pow),dt1=Math.pow(p1.distanceToSquared(p2),pow),dt2=Math.pow(p2.distanceToSquared(p3),pow);dt1<1e-4&&(dt1=1),dt0<1e-4&&(dt0=dt1),dt2<1e-4&&(dt2=dt1),px.initNonuniformCatmullRom(p0.x,p1.x,p2.x,p3.x,dt0,dt1,dt2),py.initNonuniformCatmullRom(p0.y,p1.y,p2.y,p3.y,dt0,dt1,dt2),pz.initNonuniformCatmullRom(p0.z,p1.z,p2.z,p3.z,dt0,dt1,dt2)}else"catmullrom"===this.curveType&&(px.initCatmullRom(p0.x,p1.x,p2.x,p3.x,this.tension),py.initCatmullRom(p0.y,p1.y,p2.y,p3.y,this.tension),pz.initCatmullRom(p0.z,p1.z,p2.z,p3.z,this.tension));return point.set(px.calc(weight),py.calc(weight),pz.calc(weight)),point},CatmullRomCurve3.prototype.copy=function(source){Curve.prototype.copy.call(this,source),this.points=[];for(let i=0,l=source.points.length;i<l;i++){const point=source.points[i];this.points.push(point.clone())}return this.closed=source.closed,this.curveType=source.curveType,this.tension=source.tension,this},CatmullRomCurve3.prototype.toJSON=function(){const data=Curve.prototype.toJSON.call(this);data.points=[];for(let i=0,l=this.points.length;i<l;i++){const point=this.points[i];data.points.push(point.toArray())}return data.closed=this.closed,data.curveType=this.curveType,data.tension=this.tension,data},CatmullRomCurve3.prototype.fromJSON=function(json){Curve.prototype.fromJSON.call(this,json),this.points=[];for(let i=0,l=json.points.length;i<l;i++){const point=json.points[i];this.points.push((new Vector3).fromArray(point))}return this.closed=json.closed,this.curveType=json.curveType,this.tension=json.tension,this},CubicBezierCurve.prototype=Object.create(Curve.prototype),CubicBezierCurve.prototype.constructor=CubicBezierCurve,CubicBezierCurve.prototype.isCubicBezierCurve=!0,CubicBezierCurve.prototype.getPoint=function(t,optionalTarget){const point=optionalTarget||new Vector2,v0=this.v0,v1=this.v1,v2=this.v2,v3=this.v3;return point.set(CubicBezier(t,v0.x,v1.x,v2.x,v3.x),CubicBezier(t,v0.y,v1.y,v2.y,v3.y)),point},CubicBezierCurve.prototype.copy=function(source){return Curve.prototype.copy.call(this,source),this.v0.copy(source.v0),this.v1.copy(source.v1),this.v2.copy(source.v2),this.v3.copy(source.v3),this},CubicBezierCurve.prototype.toJSON=function(){const data=Curve.prototype.toJSON.call(this);return data.v0=this.v0.toArray(),data.v1=this.v1.toArray(),data.v2=this.v2.toArray(),data.v3=this.v3.toArray(),data},CubicBezierCurve.prototype.fromJSON=function(json){return Curve.prototype.fromJSON.call(this,json),this.v0.fromArray(json.v0),this.v1.fromArray(json.v1),this.v2.fromArray(json.v2),this.v3.fromArray(json.v3),this},CubicBezierCurve3.prototype=Object.create(Curve.prototype),CubicBezierCurve3.prototype.constructor=CubicBezierCurve3,CubicBezierCurve3.prototype.isCubicBezierCurve3=!0,CubicBezierCurve3.prototype.getPoint=function(t,optionalTarget){const point=optionalTarget||new Vector3,v0=this.v0,v1=this.v1,v2=this.v2,v3=this.v3;return point.set(CubicBezier(t,v0.x,v1.x,v2.x,v3.x),CubicBezier(t,v0.y,v1.y,v2.y,v3.y),CubicBezier(t,v0.z,v1.z,v2.z,v3.z)),point},CubicBezierCurve3.prototype.copy=function(source){return Curve.prototype.copy.call(this,source),this.v0.copy(source.v0),this.v1.copy(source.v1),this.v2.copy(source.v2),this.v3.copy(source.v3),this},CubicBezierCurve3.prototype.toJSON=function(){const data=Curve.prototype.toJSON.call(this);return data.v0=this.v0.toArray(),data.v1=this.v1.toArray(),data.v2=this.v2.toArray(),data.v3=this.v3.toArray(),data},CubicBezierCurve3.prototype.fromJSON=function(json){return Curve.prototype.fromJSON.call(this,json),this.v0.fromArray(json.v0),this.v1.fromArray(json.v1),this.v2.fromArray(json.v2),this.v3.fromArray(json.v3),this},LineCurve.prototype=Object.create(Curve.prototype),LineCurve.prototype.constructor=LineCurve,LineCurve.prototype.isLineCurve=!0,LineCurve.prototype.getPoint=function(t,optionalTarget){const point=optionalTarget||new Vector2;return 1===t?point.copy(this.v2):(point.copy(this.v2).sub(this.v1),point.multiplyScalar(t).add(this.v1)),point},LineCurve.prototype.getPointAt=function(u,optionalTarget){return this.getPoint(u,optionalTarget)},LineCurve.prototype.getTangent=function(t,optionalTarget){const tangent=optionalTarget||new Vector2;return tangent.copy(this.v2).sub(this.v1).normalize(),tangent},LineCurve.prototype.copy=function(source){return Curve.prototype.copy.call(this,source),this.v1.copy(source.v1),this.v2.copy(source.v2),this},LineCurve.prototype.toJSON=function(){const data=Curve.prototype.toJSON.call(this);return data.v1=this.v1.toArray(),data.v2=this.v2.toArray(),data},LineCurve.prototype.fromJSON=function(json){return Curve.prototype.fromJSON.call(this,json),this.v1.fromArray(json.v1),this.v2.fromArray(json.v2),this},LineCurve3.prototype=Object.create(Curve.prototype),LineCurve3.prototype.constructor=LineCurve3,LineCurve3.prototype.isLineCurve3=!0,LineCurve3.prototype.getPoint=function(t,optionalTarget){const point=optionalTarget||new Vector3;return 1===t?point.copy(this.v2):(point.copy(this.v2).sub(this.v1),point.multiplyScalar(t).add(this.v1)),point},LineCurve3.prototype.getPointAt=function(u,optionalTarget){return this.getPoint(u,optionalTarget)},LineCurve3.prototype.copy=function(source){return Curve.prototype.copy.call(this,source),this.v1.copy(source.v1),this.v2.copy(source.v2),this},LineCurve3.prototype.toJSON=function(){const data=Curve.prototype.toJSON.call(this);return data.v1=this.v1.toArray(),data.v2=this.v2.toArray(),data},LineCurve3.prototype.fromJSON=function(json){return Curve.prototype.fromJSON.call(this,json),this.v1.fromArray(json.v1),this.v2.fromArray(json.v2),this},QuadraticBezierCurve.prototype=Object.create(Curve.prototype),QuadraticBezierCurve.prototype.constructor=QuadraticBezierCurve,QuadraticBezierCurve.prototype.isQuadraticBezierCurve=!0,QuadraticBezierCurve.prototype.getPoint=function(t,optionalTarget){const point=optionalTarget||new Vector2,v0=this.v0,v1=this.v1,v2=this.v2;return point.set(QuadraticBezier(t,v0.x,v1.x,v2.x),QuadraticBezier(t,v0.y,v1.y,v2.y)),point},QuadraticBezierCurve.prototype.copy=function(source){return Curve.prototype.copy.call(this,source),this.v0.copy(source.v0),this.v1.copy(source.v1),this.v2.copy(source.v2),this},QuadraticBezierCurve.prototype.toJSON=function(){const data=Curve.prototype.toJSON.call(this);return data.v0=this.v0.toArray(),data.v1=this.v1.toArray(),data.v2=this.v2.toArray(),data},QuadraticBezierCurve.prototype.fromJSON=function(json){return Curve.prototype.fromJSON.call(this,json),this.v0.fromArray(json.v0),this.v1.fromArray(json.v1),this.v2.fromArray(json.v2),this},QuadraticBezierCurve3.prototype=Object.create(Curve.prototype),QuadraticBezierCurve3.prototype.constructor=QuadraticBezierCurve3,QuadraticBezierCurve3.prototype.isQuadraticBezierCurve3=!0,QuadraticBezierCurve3.prototype.getPoint=function(t,optionalTarget){const point=optionalTarget||new Vector3,v0=this.v0,v1=this.v1,v2=this.v2;return point.set(QuadraticBezier(t,v0.x,v1.x,v2.x),QuadraticBezier(t,v0.y,v1.y,v2.y),QuadraticBezier(t,v0.z,v1.z,v2.z)),point},QuadraticBezierCurve3.prototype.copy=function(source){return Curve.prototype.copy.call(this,source),this.v0.copy(source.v0),this.v1.copy(source.v1),this.v2.copy(source.v2),this},QuadraticBezierCurve3.prototype.toJSON=function(){const data=Curve.prototype.toJSON.call(this);return data.v0=this.v0.toArray(),data.v1=this.v1.toArray(),data.v2=this.v2.toArray(),data},QuadraticBezierCurve3.prototype.fromJSON=function(json){return Curve.prototype.fromJSON.call(this,json),this.v0.fromArray(json.v0),this.v1.fromArray(json.v1),this.v2.fromArray(json.v2),this},SplineCurve.prototype=Object.create(Curve.prototype),SplineCurve.prototype.constructor=SplineCurve,SplineCurve.prototype.isSplineCurve=!0,SplineCurve.prototype.getPoint=function(t,optionalTarget){const point=optionalTarget||new Vector2,points=this.points,p=(points.length-1)*t,intPoint=Math.floor(p),weight=p-intPoint,p0=points[0===intPoint?intPoint:intPoint-1],p1=points[intPoint],p2=points[intPoint>points.length-2?points.length-1:intPoint+1],p3=points[intPoint>points.length-3?points.length-1:intPoint+2];return point.set(CatmullRom(weight,p0.x,p1.x,p2.x,p3.x),CatmullRom(weight,p0.y,p1.y,p2.y,p3.y)),point},SplineCurve.prototype.copy=function(source){Curve.prototype.copy.call(this,source),this.points=[];for(let i=0,l=source.points.length;i<l;i++){const point=source.points[i];this.points.push(point.clone())}return this},SplineCurve.prototype.toJSON=function(){const data=Curve.prototype.toJSON.call(this);data.points=[];for(let i=0,l=this.points.length;i<l;i++){const point=this.points[i];data.points.push(point.toArray())}return data},SplineCurve.prototype.fromJSON=function(json){Curve.prototype.fromJSON.call(this,json),this.points=[];for(let i=0,l=json.points.length;i<l;i++){const point=json.points[i];this.points.push((new Vector2).fromArray(point))}return this};var Curves=Object.freeze({__proto__:null,ArcCurve,CatmullRomCurve3,CubicBezierCurve,CubicBezierCurve3,EllipseCurve,LineCurve,LineCurve3,QuadraticBezierCurve,QuadraticBezierCurve3,SplineCurve});function CurvePath(){Curve.call(this),this.type="CurvePath",this.curves=[],this.autoClose=!1}function Path(points){CurvePath.call(this),this.type="Path",this.currentPoint=new Vector2,points&&this.setFromPoints(points)}function Shape(points){Path.call(this,points),this.uuid=MathUtils.generateUUID(),this.type="Shape",this.holes=[]}function Light(color,intensity){Object3D.call(this),this.type="Light",this.color=new Color(color),this.intensity=void 0!==intensity?intensity:1,this.receiveShadow=void 0}function HemisphereLight(skyColor,groundColor,intensity){Light.call(this,skyColor,intensity),this.type="HemisphereLight",this.castShadow=void 0,this.position.copy(Object3D.DefaultUp),this.updateMatrix(),this.groundColor=new Color(groundColor)}function LightShadow(camera){this.camera=camera,this.bias=0,this.normalBias=0,this.radius=1,this.mapSize=new Vector2(512,512),this.map=null,this.mapPass=null,this.matrix=new Matrix4,this.autoUpdate=!0,this.needsUpdate=!1,this._frustum=new Frustum,this._frameExtents=new Vector2(1,1),this._viewportCount=1,this._viewports=[new Vector4(0,0,1,1)]}function SpotLightShadow(){LightShadow.call(this,new PerspectiveCamera(50,1,.5,500))}function SpotLight(color,intensity,distance,angle,penumbra,decay){Light.call(this,color,intensity),this.type="SpotLight",this.position.copy(Object3D.DefaultUp),this.updateMatrix(),this.target=new Object3D,Object.defineProperty(this,"power",{get:function(){return this.intensity*Math.PI},set:function(power){this.intensity=power/Math.PI}}),this.distance=void 0!==distance?distance:0,this.angle=void 0!==angle?angle:Math.PI/3,this.penumbra=void 0!==penumbra?penumbra:0,this.decay=void 0!==decay?decay:1,this.shadow=new SpotLightShadow}function PointLightShadow(){LightShadow.call(this,new PerspectiveCamera(90,1,.5,500)),this._frameExtents=new Vector2(4,2),this._viewportCount=6,this._viewports=[new Vector4(2,1,1,1),new Vector4(0,1,1,1),new Vector4(3,1,1,1),new Vector4(1,1,1,1),new Vector4(3,0,1,1),new Vector4(1,0,1,1)],this._cubeDirections=[new Vector3(1,0,0),new Vector3(-1,0,0),new Vector3(0,0,1),new Vector3(0,0,-1),new Vector3(0,1,0),new Vector3(0,-1,0)],this._cubeUps=[new Vector3(0,1,0),new Vector3(0,1,0),new Vector3(0,1,0),new Vector3(0,1,0),new Vector3(0,0,1),new Vector3(0,0,-1)]}function PointLight(color,intensity,distance,decay){Light.call(this,color,intensity),this.type="PointLight",Object.defineProperty(this,"power",{get:function(){return 4*this.intensity*Math.PI},set:function(power){this.intensity=power/(4*Math.PI)}}),this.distance=void 0!==distance?distance:0,this.decay=void 0!==decay?decay:1,this.shadow=new PointLightShadow}function OrthographicCamera(left,right,top,bottom,near,far){Camera.call(this),this.type="OrthographicCamera",this.zoom=1,this.view=null,this.left=void 0!==left?left:-1,this.right=void 0!==right?right:1,this.top=void 0!==top?top:1,this.bottom=void 0!==bottom?bottom:-1,this.near=void 0!==near?near:.1,this.far=void 0!==far?far:2e3,this.updateProjectionMatrix()}function DirectionalLightShadow(){LightShadow.call(this,new OrthographicCamera(-5,5,5,-5,.5,500))}function DirectionalLight(color,intensity){Light.call(this,color,intensity),this.type="DirectionalLight",this.position.copy(Object3D.DefaultUp),this.updateMatrix(),this.target=new Object3D,this.shadow=new DirectionalLightShadow}function AmbientLight(color,intensity){Light.call(this,color,intensity),this.type="AmbientLight",this.castShadow=void 0}function RectAreaLight(color,intensity,width,height){Light.call(this,color,intensity),this.type="RectAreaLight",this.width=void 0!==width?width:10,this.height=void 0!==height?height:10}function SphericalHarmonics3(){this.coefficients=[];for(let i=0;i<9;i++)this.coefficients.push(new Vector3)}function LightProbe(sh,intensity){Light.call(this,void 0,intensity),this.type="LightProbe",this.sh=void 0!==sh?sh:new SphericalHarmonics3}function MaterialLoader(manager){Loader.call(this,manager),this.textures={}}CurvePath.prototype=Object.assign(Object.create(Curve.prototype),{constructor:CurvePath,add:function(curve){this.curves.push(curve)},closePath:function(){const startPoint=this.curves[0].getPoint(0),endPoint=this.curves[this.curves.length-1].getPoint(1);startPoint.equals(endPoint)||this.curves.push(new LineCurve(endPoint,startPoint))},getPoint:function(t){const d=t*this.getLength(),curveLengths=this.getCurveLengths();let i=0;for(;i<curveLengths.length;){if(curveLengths[i]>=d){const diff=curveLengths[i]-d,curve=this.curves[i],segmentLength=curve.getLength(),u=0===segmentLength?0:1-diff/segmentLength;return curve.getPointAt(u)}i++}return null},getLength:function(){const lens=this.getCurveLengths();return lens[lens.length-1]},updateArcLengths:function(){this.needsUpdate=!0,this.cacheLengths=null,this.getCurveLengths()},getCurveLengths:function(){if(this.cacheLengths&&this.cacheLengths.length===this.curves.length)return this.cacheLengths;const lengths=[];let sums=0;for(let i=0,l=this.curves.length;i<l;i++)sums+=this.curves[i].getLength(),lengths.push(sums);return this.cacheLengths=lengths,lengths},getSpacedPoints:function(divisions){void 0===divisions&&(divisions=40);const points=[];for(let i=0;i<=divisions;i++)points.push(this.getPoint(i/divisions));return this.autoClose&&points.push(points[0]),points},getPoints:function(divisions){divisions=divisions||12;const points=[];let last;for(let i=0,curves=this.curves;i<curves.length;i++){const curve=curves[i],resolution=curve&&curve.isEllipseCurve?2*divisions:curve&&(curve.isLineCurve||curve.isLineCurve3)?1:curve&&curve.isSplineCurve?divisions*curve.points.length:divisions,pts=curve.getPoints(resolution);for(let j=0;j<pts.length;j++){const point=pts[j];last&&last.equals(point)||(points.push(point),last=point)}}return this.autoClose&&points.length>1&&!points[points.length-1].equals(points[0])&&points.push(points[0]),points},copy:function(source){Curve.prototype.copy.call(this,source),this.curves=[];for(let i=0,l=source.curves.length;i<l;i++){const curve=source.curves[i];this.curves.push(curve.clone())}return this.autoClose=source.autoClose,this},toJSON:function(){const data=Curve.prototype.toJSON.call(this);data.autoClose=this.autoClose,data.curves=[];for(let i=0,l=this.curves.length;i<l;i++){const curve=this.curves[i];data.curves.push(curve.toJSON())}return data},fromJSON:function(json){Curve.prototype.fromJSON.call(this,json),this.autoClose=json.autoClose,this.curves=[];for(let i=0,l=json.curves.length;i<l;i++){const curve=json.curves[i];this.curves.push((new Curves[curve.type]).fromJSON(curve))}return this}}),Path.prototype=Object.assign(Object.create(CurvePath.prototype),{constructor:Path,setFromPoints:function(points){this.moveTo(points[0].x,points[0].y);for(let i=1,l=points.length;i<l;i++)this.lineTo(points[i].x,points[i].y);return this},moveTo:function(x,y){return this.currentPoint.set(x,y),this},lineTo:function(x,y){const curve=new LineCurve(this.currentPoint.clone(),new Vector2(x,y));return this.curves.push(curve),this.currentPoint.set(x,y),this},quadraticCurveTo:function(aCPx,aCPy,aX,aY){const curve=new QuadraticBezierCurve(this.currentPoint.clone(),new Vector2(aCPx,aCPy),new Vector2(aX,aY));return this.curves.push(curve),this.currentPoint.set(aX,aY),this},bezierCurveTo:function(aCP1x,aCP1y,aCP2x,aCP2y,aX,aY){const curve=new CubicBezierCurve(this.currentPoint.clone(),new Vector2(aCP1x,aCP1y),new Vector2(aCP2x,aCP2y),new Vector2(aX,aY));return this.curves.push(curve),this.currentPoint.set(aX,aY),this},splineThru:function(pts){const curve=new SplineCurve([this.currentPoint.clone()].concat(pts));return this.curves.push(curve),this.currentPoint.copy(pts[pts.length-1]),this},arc:function(aX,aY,aRadius,aStartAngle,aEndAngle,aClockwise){const x0=this.currentPoint.x,y0=this.currentPoint.y;return this.absarc(aX+x0,aY+y0,aRadius,aStartAngle,aEndAngle,aClockwise),this},absarc:function(aX,aY,aRadius,aStartAngle,aEndAngle,aClockwise){return this.absellipse(aX,aY,aRadius,aRadius,aStartAngle,aEndAngle,aClockwise),this},ellipse:function(aX,aY,xRadius,yRadius,aStartAngle,aEndAngle,aClockwise,aRotation){const x0=this.currentPoint.x,y0=this.currentPoint.y;return this.absellipse(aX+x0,aY+y0,xRadius,yRadius,aStartAngle,aEndAngle,aClockwise,aRotation),this},absellipse:function(aX,aY,xRadius,yRadius,aStartAngle,aEndAngle,aClockwise,aRotation){const curve=new EllipseCurve(aX,aY,xRadius,yRadius,aStartAngle,aEndAngle,aClockwise,aRotation);if(this.curves.length>0){const firstPoint=curve.getPoint(0);firstPoint.equals(this.currentPoint)||this.lineTo(firstPoint.x,firstPoint.y)}this.curves.push(curve);const lastPoint=curve.getPoint(1);return this.currentPoint.copy(lastPoint),this},copy:function(source){return CurvePath.prototype.copy.call(this,source),this.currentPoint.copy(source.currentPoint),this},toJSON:function(){const data=CurvePath.prototype.toJSON.call(this);return data.currentPoint=this.currentPoint.toArray(),data},fromJSON:function(json){return CurvePath.prototype.fromJSON.call(this,json),this.currentPoint.fromArray(json.currentPoint),this}}),Shape.prototype=Object.assign(Object.create(Path.prototype),{constructor:Shape,getPointsHoles:function(divisions){const holesPts=[];for(let i=0,l=this.holes.length;i<l;i++)holesPts[i]=this.holes[i].getPoints(divisions);return holesPts},extractPoints:function(divisions){return{shape:this.getPoints(divisions),holes:this.getPointsHoles(divisions)}},copy:function(source){Path.prototype.copy.call(this,source),this.holes=[];for(let i=0,l=source.holes.length;i<l;i++){const hole=source.holes[i];this.holes.push(hole.clone())}return this},toJSON:function(){const data=Path.prototype.toJSON.call(this);data.uuid=this.uuid,data.holes=[];for(let i=0,l=this.holes.length;i<l;i++){const hole=this.holes[i];data.holes.push(hole.toJSON())}return data},fromJSON:function(json){Path.prototype.fromJSON.call(this,json),this.uuid=json.uuid,this.holes=[];for(let i=0,l=json.holes.length;i<l;i++){const hole=json.holes[i];this.holes.push((new Path).fromJSON(hole))}return this}}),Light.prototype=Object.assign(Object.create(Object3D.prototype),{constructor:Light,isLight:!0,copy:function(source){return Object3D.prototype.copy.call(this,source),this.color.copy(source.color),this.intensity=source.intensity,this},toJSON:function(meta){const data=Object3D.prototype.toJSON.call(this,meta);return data.object.color=this.color.getHex(),data.object.intensity=this.intensity,void 0!==this.groundColor&&(data.object.groundColor=this.groundColor.getHex()),void 0!==this.distance&&(data.object.distance=this.distance),void 0!==this.angle&&(data.object.angle=this.angle),void 0!==this.decay&&(data.object.decay=this.decay),void 0!==this.penumbra&&(data.object.penumbra=this.penumbra),void 0!==this.shadow&&(data.object.shadow=this.shadow.toJSON()),data}}),HemisphereLight.prototype=Object.assign(Object.create(Light.prototype),{constructor:HemisphereLight,isHemisphereLight:!0,copy:function(source){return Light.prototype.copy.call(this,source),this.groundColor.copy(source.groundColor),this}}),Object.assign(LightShadow.prototype,{_projScreenMatrix:new Matrix4,_lightPositionWorld:new Vector3,_lookTarget:new Vector3,getViewportCount:function(){return this._viewportCount},getFrustum:function(){return this._frustum},updateMatrices:function(light){const shadowCamera=this.camera,shadowMatrix=this.matrix,projScreenMatrix=this._projScreenMatrix,lookTarget=this._lookTarget,lightPositionWorld=this._lightPositionWorld;lightPositionWorld.setFromMatrixPosition(light.matrixWorld),shadowCamera.position.copy(lightPositionWorld),lookTarget.setFromMatrixPosition(light.target.matrixWorld),shadowCamera.lookAt(lookTarget),shadowCamera.updateMatrixWorld(),projScreenMatrix.multiplyMatrices(shadowCamera.projectionMatrix,shadowCamera.matrixWorldInverse),this._frustum.setFromProjectionMatrix(projScreenMatrix),shadowMatrix.set(.5,0,0,.5,0,.5,0,.5,0,0,.5,.5,0,0,0,1),shadowMatrix.multiply(shadowCamera.projectionMatrix),shadowMatrix.multiply(shadowCamera.matrixWorldInverse)},getViewport:function(viewportIndex){return this._viewports[viewportIndex]},getFrameExtents:function(){return this._frameExtents},copy:function(source){return this.camera=source.camera.clone(),this.bias=source.bias,this.radius=source.radius,this.mapSize.copy(source.mapSize),this},clone:function(){return(new this.constructor).copy(this)},toJSON:function(){const object={};return 0!==this.bias&&(object.bias=this.bias),0!==this.normalBias&&(object.normalBias=this.normalBias),1!==this.radius&&(object.radius=this.radius),512===this.mapSize.x&&512===this.mapSize.y||(object.mapSize=this.mapSize.toArray()),object.camera=this.camera.toJSON(!1).object,delete object.camera.matrix,object}}),SpotLightShadow.prototype=Object.assign(Object.create(LightShadow.prototype),{constructor:SpotLightShadow,isSpotLightShadow:!0,updateMatrices:function(light){const camera=this.camera,fov=2*MathUtils.RAD2DEG*light.angle,aspect=this.mapSize.width/this.mapSize.height,far=light.distance||camera.far;fov===camera.fov&&aspect===camera.aspect&&far===camera.far||(camera.fov=fov,camera.aspect=aspect,camera.far=far,camera.updateProjectionMatrix()),LightShadow.prototype.updateMatrices.call(this,light)}}),SpotLight.prototype=Object.assign(Object.create(Light.prototype),{constructor:SpotLight,isSpotLight:!0,copy:function(source){return Light.prototype.copy.call(this,source),this.distance=source.distance,this.angle=source.angle,this.penumbra=source.penumbra,this.decay=source.decay,this.target=source.target.clone(),this.shadow=source.shadow.clone(),this}}),PointLightShadow.prototype=Object.assign(Object.create(LightShadow.prototype),{constructor:PointLightShadow,isPointLightShadow:!0,updateMatrices:function(light,viewportIndex){void 0===viewportIndex&&(viewportIndex=0);const camera=this.camera,shadowMatrix=this.matrix,lightPositionWorld=this._lightPositionWorld,lookTarget=this._lookTarget,projScreenMatrix=this._projScreenMatrix;lightPositionWorld.setFromMatrixPosition(light.matrixWorld),camera.position.copy(lightPositionWorld),lookTarget.copy(camera.position),lookTarget.add(this._cubeDirections[viewportIndex]),camera.up.copy(this._cubeUps[viewportIndex]),camera.lookAt(lookTarget),camera.updateMatrixWorld(),shadowMatrix.makeTranslation(-lightPositionWorld.x,-lightPositionWorld.y,-lightPositionWorld.z),projScreenMatrix.multiplyMatrices(camera.projectionMatrix,camera.matrixWorldInverse),this._frustum.setFromProjectionMatrix(projScreenMatrix)}}),PointLight.prototype=Object.assign(Object.create(Light.prototype),{constructor:PointLight,isPointLight:!0,copy:function(source){return Light.prototype.copy.call(this,source),this.distance=source.distance,this.decay=source.decay,this.shadow=source.shadow.clone(),this}}),OrthographicCamera.prototype=Object.assign(Object.create(Camera.prototype),{constructor:OrthographicCamera,isOrthographicCamera:!0,copy:function(source,recursive){return Camera.prototype.copy.call(this,source,recursive),this.left=source.left,this.right=source.right,this.top=source.top,this.bottom=source.bottom,this.near=source.near,this.far=source.far,this.zoom=source.zoom,this.view=null===source.view?null:Object.assign({},source.view),this},setViewOffset:function(fullWidth,fullHeight,x,y,width,height){null===this.view&&(this.view={enabled:!0,fullWidth:1,fullHeight:1,offsetX:0,offsetY:0,width:1,height:1}),this.view.enabled=!0,this.view.fullWidth=fullWidth,this.view.fullHeight=fullHeight,this.view.offsetX=x,this.view.offsetY=y,this.view.width=width,this.view.height=height,this.updateProjectionMatrix()},clearViewOffset:function(){null!==this.view&&(this.view.enabled=!1),this.updateProjectionMatrix()},updateProjectionMatrix:function(){const dx=(this.right-this.left)/(2*this.zoom),dy=(this.top-this.bottom)/(2*this.zoom),cx=(this.right+this.left)/2,cy=(this.top+this.bottom)/2;let left=cx-dx,right=cx+dx,top=cy+dy,bottom=cy-dy;if(null!==this.view&&this.view.enabled){const scaleW=(this.right-this.left)/this.view.fullWidth/this.zoom,scaleH=(this.top-this.bottom)/this.view.fullHeight/this.zoom;left+=scaleW*this.view.offsetX,right=left+scaleW*this.view.width,top-=scaleH*this.view.offsetY,bottom=top-scaleH*this.view.height}this.projectionMatrix.makeOrthographic(left,right,top,bottom,this.near,this.far),this.projectionMatrixInverse.getInverse(this.projectionMatrix)},toJSON:function(meta){const data=Object3D.prototype.toJSON.call(this,meta);return data.object.zoom=this.zoom,data.object.left=this.left,data.object.right=this.right,data.object.top=this.top,data.object.bottom=this.bottom,data.object.near=this.near,data.object.far=this.far,null!==this.view&&(data.object.view=Object.assign({},this.view)),data}}),DirectionalLightShadow.prototype=Object.assign(Object.create(LightShadow.prototype),{constructor:DirectionalLightShadow,isDirectionalLightShadow:!0,updateMatrices:function(light){LightShadow.prototype.updateMatrices.call(this,light)}}),DirectionalLight.prototype=Object.assign(Object.create(Light.prototype),{constructor:DirectionalLight,isDirectionalLight:!0,copy:function(source){return Light.prototype.copy.call(this,source),this.target=source.target.clone(),this.shadow=source.shadow.clone(),this}}),AmbientLight.prototype=Object.assign(Object.create(Light.prototype),{constructor:AmbientLight,isAmbientLight:!0}),RectAreaLight.prototype=Object.assign(Object.create(Light.prototype),{constructor:RectAreaLight,isRectAreaLight:!0,copy:function(source){return Light.prototype.copy.call(this,source),this.width=source.width,this.height=source.height,this},toJSON:function(meta){const data=Light.prototype.toJSON.call(this,meta);return data.object.width=this.width,data.object.height=this.height,data}}),Object.assign(SphericalHarmonics3.prototype,{isSphericalHarmonics3:!0,set:function(coefficients){for(let i=0;i<9;i++)this.coefficients[i].copy(coefficients[i]);return this},zero:function(){for(let i=0;i<9;i++)this.coefficients[i].set(0,0,0);return this},getAt:function(normal,target){const x=normal.x,y=normal.y,z=normal.z,coeff=this.coefficients;return target.copy(coeff[0]).multiplyScalar(.282095),target.addScaledVector(coeff[1],.488603*y),target.addScaledVector(coeff[2],.488603*z),target.addScaledVector(coeff[3],.488603*x),target.addScaledVector(coeff[4],x*y*1.092548),target.addScaledVector(coeff[5],y*z*1.092548),target.addScaledVector(coeff[6],.315392*(3*z*z-1)),target.addScaledVector(coeff[7],x*z*1.092548),target.addScaledVector(coeff[8],.546274*(x*x-y*y)),target},getIrradianceAt:function(normal,target){const x=normal.x,y=normal.y,z=normal.z,coeff=this.coefficients;return target.copy(coeff[0]).multiplyScalar(.886227),target.addScaledVector(coeff[1],1.023328*y),target.addScaledVector(coeff[2],1.023328*z),target.addScaledVector(coeff[3],1.023328*x),target.addScaledVector(coeff[4],.858086*x*y),target.addScaledVector(coeff[5],.858086*y*z),target.addScaledVector(coeff[6],.743125*z*z-.247708),target.addScaledVector(coeff[7],.858086*x*z),target.addScaledVector(coeff[8],.429043*(x*x-y*y)),target},add:function(sh){for(let i=0;i<9;i++)this.coefficients[i].add(sh.coefficients[i]);return this},addScaledSH:function(sh,s){for(let i=0;i<9;i++)this.coefficients[i].addScaledVector(sh.coefficients[i],s);return this},scale:function(s){for(let i=0;i<9;i++)this.coefficients[i].multiplyScalar(s);return this},lerp:function(sh,alpha){for(let i=0;i<9;i++)this.coefficients[i].lerp(sh.coefficients[i],alpha);return this},equals:function(sh){for(let i=0;i<9;i++)if(!this.coefficients[i].equals(sh.coefficients[i]))return!1;return!0},copy:function(sh){return this.set(sh.coefficients)},clone:function(){return(new this.constructor).copy(this)},fromArray:function(array,offset){void 0===offset&&(offset=0);const coefficients=this.coefficients;for(let i=0;i<9;i++)coefficients[i].fromArray(array,offset+3*i);return this},toArray:function(array,offset){void 0===array&&(array=[]),void 0===offset&&(offset=0);const coefficients=this.coefficients;for(let i=0;i<9;i++)coefficients[i].toArray(array,offset+3*i);return array}}),Object.assign(SphericalHarmonics3,{getBasisAt:function(normal,shBasis){const x=normal.x,y=normal.y,z=normal.z;shBasis[0]=.282095,shBasis[1]=.488603*y,shBasis[2]=.488603*z,shBasis[3]=.488603*x,shBasis[4]=1.092548*x*y,shBasis[5]=1.092548*y*z,shBasis[6]=.315392*(3*z*z-1),shBasis[7]=1.092548*x*z,shBasis[8]=.546274*(x*x-y*y)}}),LightProbe.prototype=Object.assign(Object.create(Light.prototype),{constructor:LightProbe,isLightProbe:!0,copy:function(source){return Light.prototype.copy.call(this,source),this.sh.copy(source.sh),this},fromJSON:function(json){return this.intensity=json.intensity,this.sh.fromArray(json.sh),this},toJSON:function(meta){const data=Light.prototype.toJSON.call(this,meta);return data.object.sh=this.sh.toArray(),data}}),MaterialLoader.prototype=Object.assign(Object.create(Loader.prototype),{constructor:MaterialLoader,load:function(url,onLoad,onProgress,onError){const scope=this,loader=new FileLoader(scope.manager);loader.setPath(scope.path),loader.setRequestHeader(scope.requestHeader),loader.load(url,(function(text){try{onLoad(scope.parse(JSON.parse(text)))}catch(e){onError?onError(e):console.error(e),scope.manager.itemError(url)}}),onProgress,onError)},parse:function(json){const textures=this.textures;function getTexture(name){return void 0===textures[name]&&console.warn("THREE.MaterialLoader: Undefined texture",name),textures[name]}const material=new Materials[json.type];if(void 0!==json.uuid&&(material.uuid=json.uuid),void 0!==json.name&&(material.name=json.name),void 0!==json.color&&material.color.setHex(json.color),void 0!==json.roughness&&(material.roughness=json.roughness),void 0!==json.metalness&&(material.metalness=json.metalness),void 0!==json.sheen&&(material.sheen=(new Color).setHex(json.sheen)),void 0!==json.emissive&&material.emissive.setHex(json.emissive),void 0!==json.specular&&material.specular.setHex(json.specular),void 0!==json.shininess&&(material.shininess=json.shininess),void 0!==json.clearcoat&&(material.clearcoat=json.clearcoat),void 0!==json.clearcoatRoughness&&(material.clearcoatRoughness=json.clearcoatRoughness),void 0!==json.fog&&(material.fog=json.fog),void 0!==json.flatShading&&(material.flatShading=json.flatShading),void 0!==json.blending&&(material.blending=json.blending),void 0!==json.combine&&(material.combine=json.combine),void 0!==json.side&&(material.side=json.side),void 0!==json.opacity&&(material.opacity=json.opacity),void 0!==json.transparent&&(material.transparent=json.transparent),void 0!==json.alphaTest&&(material.alphaTest=json.alphaTest),void 0!==json.depthTest&&(material.depthTest=json.depthTest),void 0!==json.depthWrite&&(material.depthWrite=json.depthWrite),void 0!==json.colorWrite&&(material.colorWrite=json.colorWrite),void 0!==json.stencilWrite&&(material.stencilWrite=json.stencilWrite),void 0!==json.stencilWriteMask&&(material.stencilWriteMask=json.stencilWriteMask),void 0!==json.stencilFunc&&(material.stencilFunc=json.stencilFunc),void 0!==json.stencilRef&&(material.stencilRef=json.stencilRef),void 0!==json.stencilFuncMask&&(material.stencilFuncMask=json.stencilFuncMask),void 0!==json.stencilFail&&(material.stencilFail=json.stencilFail),void 0!==json.stencilZFail&&(material.stencilZFail=json.stencilZFail),void 0!==json.stencilZPass&&(material.stencilZPass=json.stencilZPass),void 0!==json.wireframe&&(material.wireframe=json.wireframe),void 0!==json.wireframeLinewidth&&(material.wireframeLinewidth=json.wireframeLinewidth),void 0!==json.wireframeLinecap&&(material.wireframeLinecap=json.wireframeLinecap),void 0!==json.wireframeLinejoin&&(material.wireframeLinejoin=json.wireframeLinejoin),void 0!==json.rotation&&(material.rotation=json.rotation),1!==json.linewidth&&(material.linewidth=json.linewidth),void 0!==json.dashSize&&(material.dashSize=json.dashSize),void 0!==json.gapSize&&(material.gapSize=json.gapSize),void 0!==json.scale&&(material.scale=json.scale),void 0!==json.polygonOffset&&(material.polygonOffset=json.polygonOffset),void 0!==json.polygonOffsetFactor&&(material.polygonOffsetFactor=json.polygonOffsetFactor),void 0!==json.polygonOffsetUnits&&(material.polygonOffsetUnits=json.polygonOffsetUnits),void 0!==json.skinning&&(material.skinning=json.skinning),void 0!==json.morphTargets&&(material.morphTargets=json.morphTargets),void 0!==json.morphNormals&&(material.morphNormals=json.morphNormals),void 0!==json.dithering&&(material.dithering=json.dithering),void 0!==json.vertexTangents&&(material.vertexTangents=json.vertexTangents),void 0!==json.visible&&(material.visible=json.visible),void 0!==json.toneMapped&&(material.toneMapped=json.toneMapped),void 0!==json.userData&&(material.userData=json.userData),void 0!==json.vertexColors&&("number"==typeof json.vertexColors?material.vertexColors=json.vertexColors>0:material.vertexColors=json.vertexColors),void 0!==json.uniforms)for(const name in json.uniforms){const uniform=json.uniforms[name];switch(material.uniforms[name]={},uniform.type){case"t":material.uniforms[name].value=getTexture(uniform.value);break;case"c":material.uniforms[name].value=(new Color).setHex(uniform.value);break;case"v2":material.uniforms[name].value=(new Vector2).fromArray(uniform.value);break;case"v3":material.uniforms[name].value=(new Vector3).fromArray(uniform.value);break;case"v4":material.uniforms[name].value=(new Vector4).fromArray(uniform.value);break;case"m3":material.uniforms[name].value=(new Matrix3).fromArray(uniform.value);case"m4":material.uniforms[name].value=(new Matrix4).fromArray(uniform.value);break;default:material.uniforms[name].value=uniform.value}}if(void 0!==json.defines&&(material.defines=json.defines),void 0!==json.vertexShader&&(material.vertexShader=json.vertexShader),void 0!==json.fragmentShader&&(material.fragmentShader=json.fragmentShader),void 0!==json.extensions)for(const key in json.extensions)material.extensions[key]=json.extensions[key];if(void 0!==json.shading&&(material.flatShading=1===json.shading),void 0!==json.size&&(material.size=json.size),void 0!==json.sizeAttenuation&&(material.sizeAttenuation=json.sizeAttenuation),void 0!==json.map&&(material.map=getTexture(json.map)),void 0!==json.matcap&&(material.matcap=getTexture(json.matcap)),void 0!==json.alphaMap&&(material.alphaMap=getTexture(json.alphaMap)),void 0!==json.bumpMap&&(material.bumpMap=getTexture(json.bumpMap)),void 0!==json.bumpScale&&(material.bumpScale=json.bumpScale),void 0!==json.normalMap&&(material.normalMap=getTexture(json.normalMap)),void 0!==json.normalMapType&&(material.normalMapType=json.normalMapType),void 0!==json.normalScale){let normalScale=json.normalScale;!1===Array.isArray(normalScale)&&(normalScale=[normalScale,normalScale]),material.normalScale=(new Vector2).fromArray(normalScale)}return void 0!==json.displacementMap&&(material.displacementMap=getTexture(json.displacementMap)),void 0!==json.displacementScale&&(material.displacementScale=json.displacementScale),void 0!==json.displacementBias&&(material.displacementBias=json.displacementBias),void 0!==json.roughnessMap&&(material.roughnessMap=getTexture(json.roughnessMap)),void 0!==json.metalnessMap&&(material.metalnessMap=getTexture(json.metalnessMap)),void 0!==json.emissiveMap&&(material.emissiveMap=getTexture(json.emissiveMap)),void 0!==json.emissiveIntensity&&(material.emissiveIntensity=json.emissiveIntensity),void 0!==json.specularMap&&(material.specularMap=getTexture(json.specularMap)),void 0!==json.envMap&&(material.envMap=getTexture(json.envMap)),void 0!==json.envMapIntensity&&(material.envMapIntensity=json.envMapIntensity),void 0!==json.reflectivity&&(material.reflectivity=json.reflectivity),void 0!==json.refractionRatio&&(material.refractionRatio=json.refractionRatio),void 0!==json.lightMap&&(material.lightMap=getTexture(json.lightMap)),void 0!==json.lightMapIntensity&&(material.lightMapIntensity=json.lightMapIntensity),void 0!==json.aoMap&&(material.aoMap=getTexture(json.aoMap)),void 0!==json.aoMapIntensity&&(material.aoMapIntensity=json.aoMapIntensity),void 0!==json.gradientMap&&(material.gradientMap=getTexture(json.gradientMap)),void 0!==json.clearcoatMap&&(material.clearcoatMap=getTexture(json.clearcoatMap)),void 0!==json.clearcoatRoughnessMap&&(material.clearcoatRoughnessMap=getTexture(json.clearcoatRoughnessMap)),void 0!==json.clearcoatNormalMap&&(material.clearcoatNormalMap=getTexture(json.clearcoatNormalMap)),void 0!==json.clearcoatNormalScale&&(material.clearcoatNormalScale=(new Vector2).fromArray(json.clearcoatNormalScale)),void 0!==json.transmission&&(material.transmission=json.transmission),void 0!==json.transmissionMap&&(material.transmissionMap=getTexture(json.transmissionMap)),material},setTextures:function(value){return this.textures=value,this}});const LoaderUtils_extractUrlBase=function(url){const index=url.lastIndexOf("/");return-1===index?"./":url.substr(0,index+1)};function InstancedBufferGeometry(){BufferGeometry.call(this),this.type="InstancedBufferGeometry",this.instanceCount=1/0}function InstancedBufferAttribute(array,itemSize,normalized,meshPerAttribute){"number"==typeof normalized&&(meshPerAttribute=normalized,normalized=!1,console.error("THREE.InstancedBufferAttribute: The constructor now expects normalized as the third argument.")),BufferAttribute.call(this,array,itemSize,normalized),this.meshPerAttribute=meshPerAttribute||1}function BufferGeometryLoader(manager){Loader.call(this,manager)}InstancedBufferGeometry.prototype=Object.assign(Object.create(BufferGeometry.prototype),{constructor:InstancedBufferGeometry,isInstancedBufferGeometry:!0,copy:function(source){return BufferGeometry.prototype.copy.call(this,source),this.instanceCount=source.instanceCount,this},clone:function(){return(new this.constructor).copy(this)},toJSON:function(){const data=BufferGeometry.prototype.toJSON.call(this);return data.instanceCount=this.instanceCount,data.isInstancedBufferGeometry=!0,data}}),InstancedBufferAttribute.prototype=Object.assign(Object.create(BufferAttribute.prototype),{constructor:InstancedBufferAttribute,isInstancedBufferAttribute:!0,copy:function(source){return BufferAttribute.prototype.copy.call(this,source),this.meshPerAttribute=source.meshPerAttribute,this},toJSON:function(){const data=BufferAttribute.prototype.toJSON.call(this);return data.meshPerAttribute=this.meshPerAttribute,data.isInstancedBufferAttribute=!0,data}}),BufferGeometryLoader.prototype=Object.assign(Object.create(Loader.prototype),{constructor:BufferGeometryLoader,load:function(url,onLoad,onProgress,onError){const scope=this,loader=new FileLoader(scope.manager);loader.setPath(scope.path),loader.setRequestHeader(scope.requestHeader),loader.load(url,(function(text){try{onLoad(scope.parse(JSON.parse(text)))}catch(e){onError?onError(e):console.error(e),scope.manager.itemError(url)}}),onProgress,onError)},parse:function(json){const interleavedBufferMap={},arrayBufferMap={};function getInterleavedBuffer(json,uuid){if(void 0!==interleavedBufferMap[uuid])return interleavedBufferMap[uuid];const interleavedBuffer=json.interleavedBuffers[uuid],buffer=function(json,uuid){if(void 0!==arrayBufferMap[uuid])return arrayBufferMap[uuid];const arrayBuffer=json.arrayBuffers[uuid],ab=new Uint32Array(arrayBuffer).buffer;return arrayBufferMap[uuid]=ab,ab}(json,interleavedBuffer.buffer),ib=new InterleavedBuffer(new TYPED_ARRAYS[interleavedBuffer.type](buffer),interleavedBuffer.stride);return ib.uuid=interleavedBuffer.uuid,interleavedBufferMap[uuid]=ib,ib}const geometry=json.isInstancedBufferGeometry?new InstancedBufferGeometry:new BufferGeometry,index=json.data.index;if(void 0!==index){const typedArray=new TYPED_ARRAYS[index.type](index.array);geometry.setIndex(new BufferAttribute(typedArray,1))}const attributes=json.data.attributes;for(const key in attributes){const attribute=attributes[key];let bufferAttribute;if(attribute.isInterleavedBufferAttribute){bufferAttribute=new InterleavedBufferAttribute(getInterleavedBuffer(json.data,attribute.data),attribute.itemSize,attribute.offset,attribute.normalized)}else{const typedArray=new TYPED_ARRAYS[attribute.type](attribute.array);bufferAttribute=new(attribute.isInstancedBufferAttribute?InstancedBufferAttribute:BufferAttribute)(typedArray,attribute.itemSize,attribute.normalized)}void 0!==attribute.name&&(bufferAttribute.name=attribute.name),geometry.setAttribute(key,bufferAttribute)}const morphAttributes=json.data.morphAttributes;if(morphAttributes)for(const key in morphAttributes){const attributeArray=morphAttributes[key],array=[];for(let i=0,il=attributeArray.length;i<il;i++){const attribute=attributeArray[i];let bufferAttribute;if(attribute.isInterleavedBufferAttribute){bufferAttribute=new InterleavedBufferAttribute(getInterleavedBuffer(json.data,attribute.data),attribute.itemSize,attribute.offset,attribute.normalized)}else{bufferAttribute=new BufferAttribute(new TYPED_ARRAYS[attribute.type](attribute.array),attribute.itemSize,attribute.normalized)}void 0!==attribute.name&&(bufferAttribute.name=attribute.name),array.push(bufferAttribute)}geometry.morphAttributes[key]=array}json.data.morphTargetsRelative&&(geometry.morphTargetsRelative=!0);const groups=json.data.groups||json.data.drawcalls||json.data.offsets;if(void 0!==groups)for(let i=0,n=groups.length;i!==n;++i){const group=groups[i];geometry.addGroup(group.start,group.count,group.materialIndex)}const boundingSphere=json.data.boundingSphere;if(void 0!==boundingSphere){const center=new Vector3;void 0!==boundingSphere.center&&center.fromArray(boundingSphere.center),geometry.boundingSphere=new Sphere(center,boundingSphere.radius)}return json.name&&(geometry.name=json.name),json.userData&&(geometry.userData=json.userData),geometry}});const TYPED_ARRAYS={Int8Array,Uint8Array,Uint8ClampedArray:"undefined"!=typeof Uint8ClampedArray?Uint8ClampedArray:Uint8Array,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array};function ObjectLoader(manager){Loader.call(this,manager)}ObjectLoader.prototype=Object.assign(Object.create(Loader.prototype),{constructor:ObjectLoader,load:function(url,onLoad,onProgress,onError){const scope=this,path=""===this.path?LoaderUtils_extractUrlBase(url):this.path;this.resourcePath=this.resourcePath||path;const loader=new FileLoader(scope.manager);loader.setPath(this.path),loader.setRequestHeader(this.requestHeader),loader.load(url,(function(text){let json=null;try{json=JSON.parse(text)}catch(error){return void 0!==onError&&onError(error),void console.error("THREE:ObjectLoader: Can't parse "+url+".",error.message)}const metadata=json.metadata;void 0!==metadata&&void 0!==metadata.type&&"geometry"!==metadata.type.toLowerCase()?scope.parse(json,onLoad):console.error("THREE.ObjectLoader: Can't load "+url)}),onProgress,onError)},parse:function(json,onLoad){const shapes=this.parseShape(json.shapes),geometries=this.parseGeometries(json.geometries,shapes),images=this.parseImages(json.images,(function(){void 0!==onLoad&&onLoad(object)})),textures=this.parseTextures(json.textures,images),materials=this.parseMaterials(json.materials,textures),object=this.parseObject(json.object,geometries,materials);return json.animations&&(object.animations=this.parseAnimations(json.animations)),void 0!==json.images&&0!==json.images.length||void 0!==onLoad&&onLoad(object),object},parseShape:function(json){const shapes={};if(void 0!==json)for(let i=0,l=json.length;i<l;i++){const shape=(new Shape).fromJSON(json[i]);shapes[shape.uuid]=shape}return shapes},parseGeometries:function(json,shapes){const geometries={};let geometryShapes;if(void 0!==json){const bufferGeometryLoader=new BufferGeometryLoader;for(let i=0,l=json.length;i<l;i++){let geometry;const data=json[i];switch(data.type){case"PlaneGeometry":case"PlaneBufferGeometry":geometry=new Geometries[data.type](data.width,data.height,data.widthSegments,data.heightSegments);break;case"BoxGeometry":case"BoxBufferGeometry":case"CubeGeometry":geometry=new Geometries[data.type](data.width,data.height,data.depth,data.widthSegments,data.heightSegments,data.depthSegments);break;case"CircleGeometry":case"CircleBufferGeometry":geometry=new Geometries[data.type](data.radius,data.segments,data.thetaStart,data.thetaLength);break;case"CylinderGeometry":case"CylinderBufferGeometry":geometry=new Geometries[data.type](data.radiusTop,data.radiusBottom,data.height,data.radialSegments,data.heightSegments,data.openEnded,data.thetaStart,data.thetaLength);break;case"ConeGeometry":case"ConeBufferGeometry":geometry=new Geometries[data.type](data.radius,data.height,data.radialSegments,data.heightSegments,data.openEnded,data.thetaStart,data.thetaLength);break;case"SphereGeometry":case"SphereBufferGeometry":geometry=new Geometries[data.type](data.radius,data.widthSegments,data.heightSegments,data.phiStart,data.phiLength,data.thetaStart,data.thetaLength);break;case"DodecahedronGeometry":case"DodecahedronBufferGeometry":case"IcosahedronGeometry":case"IcosahedronBufferGeometry":case"OctahedronGeometry":case"OctahedronBufferGeometry":case"TetrahedronGeometry":case"TetrahedronBufferGeometry":geometry=new Geometries[data.type](data.radius,data.detail);break;case"RingGeometry":case"RingBufferGeometry":geometry=new Geometries[data.type](data.innerRadius,data.outerRadius,data.thetaSegments,data.phiSegments,data.thetaStart,data.thetaLength);break;case"TorusGeometry":case"TorusBufferGeometry":geometry=new Geometries[data.type](data.radius,data.tube,data.radialSegments,data.tubularSegments,data.arc);break;case"TorusKnotGeometry":case"TorusKnotBufferGeometry":geometry=new Geometries[data.type](data.radius,data.tube,data.tubularSegments,data.radialSegments,data.p,data.q);break;case"TubeGeometry":case"TubeBufferGeometry":geometry=new Geometries[data.type]((new Curves[data.path.type]).fromJSON(data.path),data.tubularSegments,data.radius,data.radialSegments,data.closed);break;case"LatheGeometry":case"LatheBufferGeometry":geometry=new Geometries[data.type](data.points,data.segments,data.phiStart,data.phiLength);break;case"PolyhedronGeometry":case"PolyhedronBufferGeometry":geometry=new Geometries[data.type](data.vertices,data.indices,data.radius,data.details);break;case"ShapeGeometry":case"ShapeBufferGeometry":geometryShapes=[];for(let j=0,jl=data.shapes.length;j<jl;j++){const shape=shapes[data.shapes[j]];geometryShapes.push(shape)}geometry=new Geometries[data.type](geometryShapes,data.curveSegments);break;case"ExtrudeGeometry":case"ExtrudeBufferGeometry":geometryShapes=[];for(let j=0,jl=data.shapes.length;j<jl;j++){const shape=shapes[data.shapes[j]];geometryShapes.push(shape)}const extrudePath=data.options.extrudePath;void 0!==extrudePath&&(data.options.extrudePath=(new Curves[extrudePath.type]).fromJSON(extrudePath)),geometry=new Geometries[data.type](geometryShapes,data.options);break;case"BufferGeometry":case"InstancedBufferGeometry":geometry=bufferGeometryLoader.parse(data);break;case"Geometry":console.error('THREE.ObjectLoader: Loading "Geometry" is not supported anymore.');break;default:console.warn('THREE.ObjectLoader: Unsupported geometry type "'+data.type+'"');continue}geometry.uuid=data.uuid,void 0!==data.name&&(geometry.name=data.name),!0===geometry.isBufferGeometry&&void 0!==data.userData&&(geometry.userData=data.userData),geometries[data.uuid]=geometry}}return geometries},parseMaterials:function(json,textures){const cache={},materials={};if(void 0!==json){const loader=new MaterialLoader;loader.setTextures(textures);for(let i=0,l=json.length;i<l;i++){const data=json[i];if("MultiMaterial"===data.type){const array=[];for(let j=0;j<data.materials.length;j++){const material=data.materials[j];void 0===cache[material.uuid]&&(cache[material.uuid]=loader.parse(material)),array.push(cache[material.uuid])}materials[data.uuid]=array}else void 0===cache[data.uuid]&&(cache[data.uuid]=loader.parse(data)),materials[data.uuid]=cache[data.uuid]}}return materials},parseAnimations:function(json){const animations=[];for(let i=0;i<json.length;i++){const data=json[i],clip=AnimationClip.parse(data);void 0!==data.uuid&&(clip.uuid=data.uuid),animations.push(clip)}return animations},parseImages:function(json,onLoad){const scope=this,images={};let loader;function loadImage(url){return scope.manager.itemStart(url),loader.load(url,(function(){scope.manager.itemEnd(url)}),void 0,(function(){scope.manager.itemError(url),scope.manager.itemEnd(url)}))}if(void 0!==json&&json.length>0){const manager=new LoadingManager(onLoad);loader=new ImageLoader(manager),loader.setCrossOrigin(this.crossOrigin);for(let i=0,il=json.length;i<il;i++){const image=json[i],url=image.url;if(Array.isArray(url)){images[image.uuid]=[];for(let j=0,jl=url.length;j<jl;j++){const currentUrl=url[j],path=/^(\/\/)|([a-z]+:(\/\/)?)/i.test(currentUrl)?currentUrl:scope.resourcePath+currentUrl;images[image.uuid].push(loadImage(path))}}else{const path=/^(\/\/)|([a-z]+:(\/\/)?)/i.test(image.url)?image.url:scope.resourcePath+image.url;images[image.uuid]=loadImage(path)}}}return images},parseTextures:function(json,images){function parseConstant(value,type){return"number"==typeof value?value:(console.warn("THREE.ObjectLoader.parseTexture: Constant should be in numeric form.",value),type[value])}const textures={};if(void 0!==json)for(let i=0,l=json.length;i<l;i++){const data=json[i];let texture;void 0===data.image&&console.warn('THREE.ObjectLoader: No "image" specified for',data.uuid),void 0===images[data.image]&&console.warn("THREE.ObjectLoader: Undefined image",data.image),texture=Array.isArray(images[data.image])?new CubeTexture(images[data.image]):new Texture(images[data.image]),texture.needsUpdate=!0,texture.uuid=data.uuid,void 0!==data.name&&(texture.name=data.name),void 0!==data.mapping&&(texture.mapping=parseConstant(data.mapping,TEXTURE_MAPPING)),void 0!==data.offset&&texture.offset.fromArray(data.offset),void 0!==data.repeat&&texture.repeat.fromArray(data.repeat),void 0!==data.center&&texture.center.fromArray(data.center),void 0!==data.rotation&&(texture.rotation=data.rotation),void 0!==data.wrap&&(texture.wrapS=parseConstant(data.wrap[0],TEXTURE_WRAPPING),texture.wrapT=parseConstant(data.wrap[1],TEXTURE_WRAPPING)),void 0!==data.format&&(texture.format=data.format),void 0!==data.type&&(texture.type=data.type),void 0!==data.encoding&&(texture.encoding=data.encoding),void 0!==data.minFilter&&(texture.minFilter=parseConstant(data.minFilter,TEXTURE_FILTER)),void 0!==data.magFilter&&(texture.magFilter=parseConstant(data.magFilter,TEXTURE_FILTER)),void 0!==data.anisotropy&&(texture.anisotropy=data.anisotropy),void 0!==data.flipY&&(texture.flipY=data.flipY),void 0!==data.premultiplyAlpha&&(texture.premultiplyAlpha=data.premultiplyAlpha),void 0!==data.unpackAlignment&&(texture.unpackAlignment=data.unpackAlignment),textures[data.uuid]=texture}return textures},parseObject:function(data,geometries,materials){let object,geometry,material;function getGeometry(name){return void 0===geometries[name]&&console.warn("THREE.ObjectLoader: Undefined geometry",name),geometries[name]}function getMaterial(name){if(void 0!==name){if(Array.isArray(name)){const array=[];for(let i=0,l=name.length;i<l;i++){const uuid=name[i];void 0===materials[uuid]&&console.warn("THREE.ObjectLoader: Undefined material",uuid),array.push(materials[uuid])}return array}return void 0===materials[name]&&console.warn("THREE.ObjectLoader: Undefined material",name),materials[name]}}switch(data.type){case"Scene":object=new Scene,void 0!==data.background&&Number.isInteger(data.background)&&(object.background=new Color(data.background)),void 0!==data.fog&&("Fog"===data.fog.type?object.fog=new Fog(data.fog.color,data.fog.near,data.fog.far):"FogExp2"===data.fog.type&&(object.fog=new FogExp2(data.fog.color,data.fog.density)));break;case"PerspectiveCamera":object=new PerspectiveCamera(data.fov,data.aspect,data.near,data.far),void 0!==data.focus&&(object.focus=data.focus),void 0!==data.zoom&&(object.zoom=data.zoom),void 0!==data.filmGauge&&(object.filmGauge=data.filmGauge),void 0!==data.filmOffset&&(object.filmOffset=data.filmOffset),void 0!==data.view&&(object.view=Object.assign({},data.view));break;case"OrthographicCamera":object=new OrthographicCamera(data.left,data.right,data.top,data.bottom,data.near,data.far),void 0!==data.zoom&&(object.zoom=data.zoom),void 0!==data.view&&(object.view=Object.assign({},data.view));break;case"AmbientLight":object=new AmbientLight(data.color,data.intensity);break;case"DirectionalLight":object=new DirectionalLight(data.color,data.intensity);break;case"PointLight":object=new PointLight(data.color,data.intensity,data.distance,data.decay);break;case"RectAreaLight":object=new RectAreaLight(data.color,data.intensity,data.width,data.height);break;case"SpotLight":object=new SpotLight(data.color,data.intensity,data.distance,data.angle,data.penumbra,data.decay);break;case"HemisphereLight":object=new HemisphereLight(data.color,data.groundColor,data.intensity);break;case"LightProbe":object=(new LightProbe).fromJSON(data);break;case"SkinnedMesh":console.warn("THREE.ObjectLoader.parseObject() does not support SkinnedMesh yet.");case"Mesh":geometry=getGeometry(data.geometry),material=getMaterial(data.material),object=new Mesh(geometry,material);break;case"InstancedMesh":geometry=getGeometry(data.geometry),material=getMaterial(data.material);const count=data.count,instanceMatrix=data.instanceMatrix;object=new InstancedMesh(geometry,material,count),object.instanceMatrix=new BufferAttribute(new Float32Array(instanceMatrix.array),16);break;case"LOD":object=new LOD;break;case"Line":object=new Line(getGeometry(data.geometry),getMaterial(data.material),data.mode);break;case"LineLoop":object=new LineLoop(getGeometry(data.geometry),getMaterial(data.material));break;case"LineSegments":object=new LineSegments(getGeometry(data.geometry),getMaterial(data.material));break;case"PointCloud":case"Points":object=new Points(getGeometry(data.geometry),getMaterial(data.material));break;case"Sprite":object=new Sprite(getMaterial(data.material));break;case"Group":object=new Group;break;default:object=new Object3D}if(object.uuid=data.uuid,void 0!==data.name&&(object.name=data.name),void 0!==data.matrix?(object.matrix.fromArray(data.matrix),void 0!==data.matrixAutoUpdate&&(object.matrixAutoUpdate=data.matrixAutoUpdate),object.matrixAutoUpdate&&object.matrix.decompose(object.position,object.quaternion,object.scale)):(void 0!==data.position&&object.position.fromArray(data.position),void 0!==data.rotation&&object.rotation.fromArray(data.rotation),void 0!==data.quaternion&&object.quaternion.fromArray(data.quaternion),void 0!==data.scale&&object.scale.fromArray(data.scale)),void 0!==data.castShadow&&(object.castShadow=data.castShadow),void 0!==data.receiveShadow&&(object.receiveShadow=data.receiveShadow),data.shadow&&(void 0!==data.shadow.bias&&(object.shadow.bias=data.shadow.bias),void 0!==data.shadow.normalBias&&(object.shadow.normalBias=data.shadow.normalBias),void 0!==data.shadow.radius&&(object.shadow.radius=data.shadow.radius),void 0!==data.shadow.mapSize&&object.shadow.mapSize.fromArray(data.shadow.mapSize),void 0!==data.shadow.camera&&(object.shadow.camera=this.parseObject(data.shadow.camera))),void 0!==data.visible&&(object.visible=data.visible),void 0!==data.frustumCulled&&(object.frustumCulled=data.frustumCulled),void 0!==data.renderOrder&&(object.renderOrder=data.renderOrder),void 0!==data.userData&&(object.userData=data.userData),void 0!==data.layers&&(object.layers.mask=data.layers),void 0!==data.children){const children=data.children;for(let i=0;i<children.length;i++)object.add(this.parseObject(children[i],geometries,materials))}if("LOD"===data.type){void 0!==data.autoUpdate&&(object.autoUpdate=data.autoUpdate);const levels=data.levels;for(let l=0;l<levels.length;l++){const level=levels[l],child=object.getObjectByProperty("uuid",level.object);void 0!==child&&object.addLevel(child,level.distance)}}return object}});const TEXTURE_MAPPING={UVMapping:300,CubeReflectionMapping:301,CubeRefractionMapping:302,EquirectangularReflectionMapping:303,EquirectangularRefractionMapping:304,CubeUVReflectionMapping:306,CubeUVRefractionMapping:307},TEXTURE_WRAPPING={RepeatWrapping:1e3,ClampToEdgeWrapping:1001,MirroredRepeatWrapping:1002},TEXTURE_FILTER={NearestFilter:1003,NearestMipmapNearestFilter:1004,NearestMipmapLinearFilter:1005,LinearFilter:1006,LinearMipmapNearestFilter:1007,LinearMipmapLinearFilter:1008};function ImageBitmapLoader(manager){"undefined"==typeof createImageBitmap&&console.warn("THREE.ImageBitmapLoader: createImageBitmap() not supported."),"undefined"==typeof fetch&&console.warn("THREE.ImageBitmapLoader: fetch() not supported."),Loader.call(this,manager),this.options={premultiplyAlpha:"none"}}function ShapePath(){this.type="ShapePath",this.color=new Color,this.subPaths=[],this.currentPath=null}function Font(data){this.type="Font",this.data=data}function createPath(char,scale,offsetX,offsetY,data){const glyph=data.glyphs[char]||data.glyphs["?"];if(!glyph)return void console.error('THREE.Font: character "'+char+'" does not exists in font family '+data.familyName+".");const path=new ShapePath;let x,y,cpx,cpy,cpx1,cpy1,cpx2,cpy2;if(glyph.o){const outline=glyph._cachedOutline||(glyph._cachedOutline=glyph.o.split(" "));for(let i=0,l=outline.length;i<l;){switch(outline[i++]){case"m":x=outline[i++]*scale+offsetX,y=outline[i++]*scale+offsetY,path.moveTo(x,y);break;case"l":x=outline[i++]*scale+offsetX,y=outline[i++]*scale+offsetY,path.lineTo(x,y);break;case"q":cpx=outline[i++]*scale+offsetX,cpy=outline[i++]*scale+offsetY,cpx1=outline[i++]*scale+offsetX,cpy1=outline[i++]*scale+offsetY,path.quadraticCurveTo(cpx1,cpy1,cpx,cpy);break;case"b":cpx=outline[i++]*scale+offsetX,cpy=outline[i++]*scale+offsetY,cpx1=outline[i++]*scale+offsetX,cpy1=outline[i++]*scale+offsetY,cpx2=outline[i++]*scale+offsetX,cpy2=outline[i++]*scale+offsetY,path.bezierCurveTo(cpx1,cpy1,cpx2,cpy2,cpx,cpy)}}}return{offsetX:glyph.ha*scale,path}}function FontLoader(manager){Loader.call(this,manager)}let _context;ImageBitmapLoader.prototype=Object.assign(Object.create(Loader.prototype),{constructor:ImageBitmapLoader,isImageBitmapLoader:!0,setOptions:function(options){return this.options=options,this},load:function(url,onLoad,onProgress,onError){void 0===url&&(url=""),void 0!==this.path&&(url=this.path+url),url=this.manager.resolveURL(url);const scope=this,cached=Cache.get(url);if(void 0!==cached)return scope.manager.itemStart(url),setTimeout((function(){onLoad&&onLoad(cached),scope.manager.itemEnd(url)}),0),cached;fetch(url).then((function(res){return res.blob()})).then((function(blob){return createImageBitmap(blob,scope.options)})).then((function(imageBitmap){Cache.add(url,imageBitmap),onLoad&&onLoad(imageBitmap),scope.manager.itemEnd(url)})).catch((function(e){onError&&onError(e),scope.manager.itemError(url),scope.manager.itemEnd(url)})),scope.manager.itemStart(url)}}),Object.assign(ShapePath.prototype,{moveTo:function(x,y){return this.currentPath=new Path,this.subPaths.push(this.currentPath),this.currentPath.moveTo(x,y),this},lineTo:function(x,y){return this.currentPath.lineTo(x,y),this},quadraticCurveTo:function(aCPx,aCPy,aX,aY){return this.currentPath.quadraticCurveTo(aCPx,aCPy,aX,aY),this},bezierCurveTo:function(aCP1x,aCP1y,aCP2x,aCP2y,aX,aY){return this.currentPath.bezierCurveTo(aCP1x,aCP1y,aCP2x,aCP2y,aX,aY),this},splineThru:function(pts){return this.currentPath.splineThru(pts),this},toShapes:function(isCCW,noHoles){function toShapesNoHoles(inSubpaths){const shapes=[];for(let i=0,l=inSubpaths.length;i<l;i++){const tmpPath=inSubpaths[i],tmpShape=new Shape;tmpShape.curves=tmpPath.curves,shapes.push(tmpShape)}return shapes}function isPointInsidePolygon(inPt,inPolygon){const polyLen=inPolygon.length;let inside=!1;for(let p=polyLen-1,q=0;q<polyLen;p=q++){let edgeLowPt=inPolygon[p],edgeHighPt=inPolygon[q],edgeDx=edgeHighPt.x-edgeLowPt.x,edgeDy=edgeHighPt.y-edgeLowPt.y;if(Math.abs(edgeDy)>Number.EPSILON){if(edgeDy<0&&(edgeLowPt=inPolygon[q],edgeDx=-edgeDx,edgeHighPt=inPolygon[p],edgeDy=-edgeDy),inPt.y<edgeLowPt.y||inPt.y>edgeHighPt.y)continue;if(inPt.y===edgeLowPt.y){if(inPt.x===edgeLowPt.x)return!0}else{const perpEdge=edgeDy*(inPt.x-edgeLowPt.x)-edgeDx*(inPt.y-edgeLowPt.y);if(0===perpEdge)return!0;if(perpEdge<0)continue;inside=!inside}}else{if(inPt.y!==edgeLowPt.y)continue;if(edgeHighPt.x<=inPt.x&&inPt.x<=edgeLowPt.x||edgeLowPt.x<=inPt.x&&inPt.x<=edgeHighPt.x)return!0}}return inside}const isClockWise=ShapeUtils.isClockWise,subPaths=this.subPaths;if(0===subPaths.length)return[];if(!0===noHoles)return toShapesNoHoles(subPaths);let solid,tmpPath,tmpShape,shapes=[];if(1===subPaths.length)return tmpPath=subPaths[0],tmpShape=new Shape,tmpShape.curves=tmpPath.curves,shapes.push(tmpShape),shapes;let holesFirst=!isClockWise(subPaths[0].getPoints());holesFirst=isCCW?!holesFirst:holesFirst;const betterShapeHoles=[],newShapes=[];let tmpPoints,tmpHoles,newShapeHoles=[],mainIdx=0;newShapes[mainIdx]=void 0,newShapeHoles[mainIdx]=[];for(let i=0,l=subPaths.length;i<l;i++)tmpPath=subPaths[i],tmpPoints=tmpPath.getPoints(),solid=isClockWise(tmpPoints),solid=isCCW?!solid:solid,solid?(!holesFirst&&newShapes[mainIdx]&&mainIdx++,newShapes[mainIdx]={s:new Shape,p:tmpPoints},newShapes[mainIdx].s.curves=tmpPath.curves,holesFirst&&mainIdx++,newShapeHoles[mainIdx]=[]):newShapeHoles[mainIdx].push({h:tmpPath,p:tmpPoints[0]});if(!newShapes[0])return toShapesNoHoles(subPaths);if(newShapes.length>1){let ambiguous=!1;const toChange=[];for(let sIdx=0,sLen=newShapes.length;sIdx<sLen;sIdx++)betterShapeHoles[sIdx]=[];for(let sIdx=0,sLen=newShapes.length;sIdx<sLen;sIdx++){const sho=newShapeHoles[sIdx];for(let hIdx=0;hIdx<sho.length;hIdx++){const ho=sho[hIdx];let hole_unassigned=!0;for(let s2Idx=0;s2Idx<newShapes.length;s2Idx++)isPointInsidePolygon(ho.p,newShapes[s2Idx].p)&&(sIdx!==s2Idx&&toChange.push({froms:sIdx,tos:s2Idx,hole:hIdx}),hole_unassigned?(hole_unassigned=!1,betterShapeHoles[s2Idx].push(ho)):ambiguous=!0);hole_unassigned&&betterShapeHoles[sIdx].push(ho)}}toChange.length>0&&(ambiguous||(newShapeHoles=betterShapeHoles))}for(let i=0,il=newShapes.length;i<il;i++){tmpShape=newShapes[i].s,shapes.push(tmpShape),tmpHoles=newShapeHoles[i];for(let j=0,jl=tmpHoles.length;j<jl;j++)tmpShape.holes.push(tmpHoles[j].h)}return shapes}}),Object.assign(Font.prototype,{isFont:!0,generateShapes:function(text,size){void 0===size&&(size=100);const shapes=[],paths=function(text,size,data){const chars=Array.from?Array.from(text):String(text).split(""),scale=size/data.resolution,line_height=(data.boundingBox.yMax-data.boundingBox.yMin+data.underlineThickness)*scale,paths=[];let offsetX=0,offsetY=0;for(let i=0;i<chars.length;i++){const char=chars[i];if("\n"===char)offsetX=0,offsetY-=line_height;else{const ret=createPath(char,scale,offsetX,offsetY,data);offsetX+=ret.offsetX,paths.push(ret.path)}}return paths}(text,size,this.data);for(let p=0,pl=paths.length;p<pl;p++)Array.prototype.push.apply(shapes,paths[p].toShapes());return shapes}}),FontLoader.prototype=Object.assign(Object.create(Loader.prototype),{constructor:FontLoader,load:function(url,onLoad,onProgress,onError){const scope=this,loader=new FileLoader(this.manager);loader.setPath(this.path),loader.setRequestHeader(this.requestHeader),loader.load(url,(function(text){let json;try{json=JSON.parse(text)}catch(e){console.warn("THREE.FontLoader: typeface.js support is being deprecated. Use typeface.json instead."),json=JSON.parse(text.substring(65,text.length-2))}const font=scope.parse(json);onLoad&&onLoad(font)}),onProgress,onError)},parse:function(json){return new Font(json)}});const AudioContext_getContext=function(){return void 0===_context&&(_context=new(window.AudioContext||window.webkitAudioContext)),_context};function AudioLoader(manager){Loader.call(this,manager)}function HemisphereLightProbe(skyColor,groundColor,intensity){LightProbe.call(this,void 0,intensity);const color1=(new Color).set(skyColor),color2=(new Color).set(groundColor),sky=new Vector3(color1.r,color1.g,color1.b),ground=new Vector3(color2.r,color2.g,color2.b),c0=Math.sqrt(Math.PI),c1=c0*Math.sqrt(.75);this.sh.coefficients[0].copy(sky).add(ground).multiplyScalar(c0),this.sh.coefficients[1].copy(sky).sub(ground).multiplyScalar(c1)}function AmbientLightProbe(color,intensity){LightProbe.call(this,void 0,intensity);const color1=(new Color).set(color);this.sh.coefficients[0].set(color1.r,color1.g,color1.b).multiplyScalar(2*Math.sqrt(Math.PI))}AudioLoader.prototype=Object.assign(Object.create(Loader.prototype),{constructor:AudioLoader,load:function(url,onLoad,onProgress,onError){const scope=this,loader=new FileLoader(scope.manager);loader.setResponseType("arraybuffer"),loader.setPath(scope.path),loader.setRequestHeader(scope.requestHeader),loader.load(url,(function(buffer){try{const bufferCopy=buffer.slice(0);AudioContext_getContext().decodeAudioData(bufferCopy,(function(audioBuffer){onLoad(audioBuffer)}))}catch(e){onError?onError(e):console.error(e),scope.manager.itemError(url)}}),onProgress,onError)}}),HemisphereLightProbe.prototype=Object.assign(Object.create(LightProbe.prototype),{constructor:HemisphereLightProbe,isHemisphereLightProbe:!0,copy:function(source){return LightProbe.prototype.copy.call(this,source),this},toJSON:function(meta){return LightProbe.prototype.toJSON.call(this,meta)}}),AmbientLightProbe.prototype=Object.assign(Object.create(LightProbe.prototype),{constructor:AmbientLightProbe,isAmbientLightProbe:!0,copy:function(source){return LightProbe.prototype.copy.call(this,source),this},toJSON:function(meta){return LightProbe.prototype.toJSON.call(this,meta)}});const _eyeRight=new Matrix4,_eyeLeft=new Matrix4;function Clock(autoStart){this.autoStart=void 0===autoStart||autoStart,this.startTime=0,this.oldTime=0,this.elapsedTime=0,this.running=!1}Object.assign(function(){this.type="StereoCamera",this.aspect=1,this.eyeSep=.064,this.cameraL=new PerspectiveCamera,this.cameraL.layers.enable(1),this.cameraL.matrixAutoUpdate=!1,this.cameraR=new PerspectiveCamera,this.cameraR.layers.enable(2),this.cameraR.matrixAutoUpdate=!1,this._cache={focus:null,fov:null,aspect:null,near:null,far:null,zoom:null,eyeSep:null}}.prototype,{update:function(camera){const cache=this._cache;if(cache.focus!==camera.focus||cache.fov!==camera.fov||cache.aspect!==camera.aspect*this.aspect||cache.near!==camera.near||cache.far!==camera.far||cache.zoom!==camera.zoom||cache.eyeSep!==this.eyeSep){cache.focus=camera.focus,cache.fov=camera.fov,cache.aspect=camera.aspect*this.aspect,cache.near=camera.near,cache.far=camera.far,cache.zoom=camera.zoom,cache.eyeSep=this.eyeSep;const projectionMatrix=camera.projectionMatrix.clone(),eyeSepHalf=cache.eyeSep/2,eyeSepOnProjection=eyeSepHalf*cache.near/cache.focus,ymax=cache.near*Math.tan(MathUtils.DEG2RAD*cache.fov*.5)/cache.zoom;let xmin,xmax;_eyeLeft.elements[12]=-eyeSepHalf,_eyeRight.elements[12]=eyeSepHalf,xmin=-ymax*cache.aspect+eyeSepOnProjection,xmax=ymax*cache.aspect+eyeSepOnProjection,projectionMatrix.elements[0]=2*cache.near/(xmax-xmin),projectionMatrix.elements[8]=(xmax+xmin)/(xmax-xmin),this.cameraL.projectionMatrix.copy(projectionMatrix),xmin=-ymax*cache.aspect-eyeSepOnProjection,xmax=ymax*cache.aspect-eyeSepOnProjection,projectionMatrix.elements[0]=2*cache.near/(xmax-xmin),projectionMatrix.elements[8]=(xmax+xmin)/(xmax-xmin),this.cameraR.projectionMatrix.copy(projectionMatrix)}this.cameraL.matrixWorld.copy(camera.matrixWorld).multiply(_eyeLeft),this.cameraR.matrixWorld.copy(camera.matrixWorld).multiply(_eyeRight)}}),Object.assign(Clock.prototype,{start:function(){this.startTime=("undefined"==typeof performance?Date:performance).now(),this.oldTime=this.startTime,this.elapsedTime=0,this.running=!0},stop:function(){this.getElapsedTime(),this.running=!1,this.autoStart=!1},getElapsedTime:function(){return this.getDelta(),this.elapsedTime},getDelta:function(){let diff=0;if(this.autoStart&&!this.running)return this.start(),0;if(this.running){const newTime=("undefined"==typeof performance?Date:performance).now();diff=(newTime-this.oldTime)/1e3,this.oldTime=newTime,this.elapsedTime+=diff}return diff}});const _position$2=new Vector3,_quaternion$3=new Quaternion,_scale$1=new Vector3,_orientation=new Vector3;function AudioListener(){Object3D.call(this),this.type="AudioListener",this.context=AudioContext_getContext(),this.gain=this.context.createGain(),this.gain.connect(this.context.destination),this.filter=null,this.timeDelta=0,this._clock=new Clock}function Audio(listener){Object3D.call(this),this.type="Audio",this.listener=listener,this.context=listener.context,this.gain=this.context.createGain(),this.gain.connect(listener.getInput()),this.autoplay=!1,this.buffer=null,this.detune=0,this.loop=!1,this.loopStart=0,this.loopEnd=0,this.offset=0,this.duration=void 0,this.playbackRate=1,this.isPlaying=!1,this.hasPlaybackControl=!0,this.sourceType="empty",this._startedAt=0,this._progress=0,this.filters=[]}AudioListener.prototype=Object.assign(Object.create(Object3D.prototype),{constructor:AudioListener,getInput:function(){return this.gain},removeFilter:function(){return null!==this.filter&&(this.gain.disconnect(this.filter),this.filter.disconnect(this.context.destination),this.gain.connect(this.context.destination),this.filter=null),this},getFilter:function(){return this.filter},setFilter:function(value){return null!==this.filter?(this.gain.disconnect(this.filter),this.filter.disconnect(this.context.destination)):this.gain.disconnect(this.context.destination),this.filter=value,this.gain.connect(this.filter),this.filter.connect(this.context.destination),this},getMasterVolume:function(){return this.gain.gain.value},setMasterVolume:function(value){return this.gain.gain.setTargetAtTime(value,this.context.currentTime,.01),this},updateMatrixWorld:function(force){Object3D.prototype.updateMatrixWorld.call(this,force);const listener=this.context.listener,up=this.up;if(this.timeDelta=this._clock.getDelta(),this.matrixWorld.decompose(_position$2,_quaternion$3,_scale$1),_orientation.set(0,0,-1).applyQuaternion(_quaternion$3),listener.positionX){const endTime=this.context.currentTime+this.timeDelta;listener.positionX.linearRampToValueAtTime(_position$2.x,endTime),listener.positionY.linearRampToValueAtTime(_position$2.y,endTime),listener.positionZ.linearRampToValueAtTime(_position$2.z,endTime),listener.forwardX.linearRampToValueAtTime(_orientation.x,endTime),listener.forwardY.linearRampToValueAtTime(_orientation.y,endTime),listener.forwardZ.linearRampToValueAtTime(_orientation.z,endTime),listener.upX.linearRampToValueAtTime(up.x,endTime),listener.upY.linearRampToValueAtTime(up.y,endTime),listener.upZ.linearRampToValueAtTime(up.z,endTime)}else listener.setPosition(_position$2.x,_position$2.y,_position$2.z),listener.setOrientation(_orientation.x,_orientation.y,_orientation.z,up.x,up.y,up.z)}}),Audio.prototype=Object.assign(Object.create(Object3D.prototype),{constructor:Audio,getOutput:function(){return this.gain},setNodeSource:function(audioNode){return this.hasPlaybackControl=!1,this.sourceType="audioNode",this.source=audioNode,this.connect(),this},setMediaElementSource:function(mediaElement){return this.hasPlaybackControl=!1,this.sourceType="mediaNode",this.source=this.context.createMediaElementSource(mediaElement),this.connect(),this},setMediaStreamSource:function(mediaStream){return this.hasPlaybackControl=!1,this.sourceType="mediaStreamNode",this.source=this.context.createMediaStreamSource(mediaStream),this.connect(),this},setBuffer:function(audioBuffer){return this.buffer=audioBuffer,this.sourceType="buffer",this.autoplay&&this.play(),this},play:function(delay){if(void 0===delay&&(delay=0),!0===this.isPlaying)return void console.warn("THREE.Audio: Audio is already playing.");if(!1===this.hasPlaybackControl)return void console.warn("THREE.Audio: this Audio has no playback control.");this._startedAt=this.context.currentTime+delay;const source=this.context.createBufferSource();return source.buffer=this.buffer,source.loop=this.loop,source.loopStart=this.loopStart,source.loopEnd=this.loopEnd,source.onended=this.onEnded.bind(this),source.start(this._startedAt,this._progress+this.offset,this.duration),this.isPlaying=!0,this.source=source,this.setDetune(this.detune),this.setPlaybackRate(this.playbackRate),this.connect()},pause:function(){if(!1!==this.hasPlaybackControl)return!0===this.isPlaying&&(this._progress+=Math.max(this.context.currentTime-this._startedAt,0)*this.playbackRate,!0===this.loop&&(this._progress=this._progress%(this.duration||this.buffer.duration)),this.source.stop(),this.source.onended=null,this.isPlaying=!1),this;console.warn("THREE.Audio: this Audio has no playback control.")},stop:function(){if(!1!==this.hasPlaybackControl)return this._progress=0,this.source.stop(),this.source.onended=null,this.isPlaying=!1,this;console.warn("THREE.Audio: this Audio has no playback control.")},connect:function(){if(this.filters.length>0){this.source.connect(this.filters[0]);for(let i=1,l=this.filters.length;i<l;i++)this.filters[i-1].connect(this.filters[i]);this.filters[this.filters.length-1].connect(this.getOutput())}else this.source.connect(this.getOutput());return this},disconnect:function(){if(this.filters.length>0){this.source.disconnect(this.filters[0]);for(let i=1,l=this.filters.length;i<l;i++)this.filters[i-1].disconnect(this.filters[i]);this.filters[this.filters.length-1].disconnect(this.getOutput())}else this.source.disconnect(this.getOutput());return this},getFilters:function(){return this.filters},setFilters:function(value){return value||(value=[]),!0===this.isPlaying?(this.disconnect(),this.filters=value,this.connect()):this.filters=value,this},setDetune:function(value){if(this.detune=value,void 0!==this.source.detune)return!0===this.isPlaying&&this.source.detune.setTargetAtTime(this.detune,this.context.currentTime,.01),this},getDetune:function(){return this.detune},getFilter:function(){return this.getFilters()[0]},setFilter:function(filter){return this.setFilters(filter?[filter]:[])},setPlaybackRate:function(value){if(!1!==this.hasPlaybackControl)return this.playbackRate=value,!0===this.isPlaying&&this.source.playbackRate.setTargetAtTime(this.playbackRate,this.context.currentTime,.01),this;console.warn("THREE.Audio: this Audio has no playback control.")},getPlaybackRate:function(){return this.playbackRate},onEnded:function(){this.isPlaying=!1},getLoop:function(){return!1===this.hasPlaybackControl?(console.warn("THREE.Audio: this Audio has no playback control."),!1):this.loop},setLoop:function(value){if(!1!==this.hasPlaybackControl)return this.loop=value,!0===this.isPlaying&&(this.source.loop=this.loop),this;console.warn("THREE.Audio: this Audio has no playback control.")},setLoopStart:function(value){return this.loopStart=value,this},setLoopEnd:function(value){return this.loopEnd=value,this},getVolume:function(){return this.gain.gain.value},setVolume:function(value){return this.gain.gain.setTargetAtTime(value,this.context.currentTime,.01),this}});const _position$3=new Vector3,_quaternion$4=new Quaternion,_scale$2=new Vector3,_orientation$1=new Vector3;function PositionalAudio(listener){Audio.call(this,listener),this.panner=this.context.createPanner(),this.panner.panningModel="HRTF",this.panner.connect(this.gain)}function AudioAnalyser(audio,fftSize){this.analyser=audio.context.createAnalyser(),this.analyser.fftSize=void 0!==fftSize?fftSize:2048,this.data=new Uint8Array(this.analyser.frequencyBinCount),audio.getOutput().connect(this.analyser)}function PropertyMixer(binding,typeName,valueSize){let mixFunction,mixFunctionAdditive,setIdentity;switch(this.binding=binding,this.valueSize=valueSize,typeName){case"quaternion":mixFunction=this._slerp,mixFunctionAdditive=this._slerpAdditive,setIdentity=this._setAdditiveIdentityQuaternion,this.buffer=new Float64Array(6*valueSize),this._workIndex=5;break;case"string":case"bool":mixFunction=this._select,mixFunctionAdditive=this._select,setIdentity=this._setAdditiveIdentityOther,this.buffer=new Array(5*valueSize);break;default:mixFunction=this._lerp,mixFunctionAdditive=this._lerpAdditive,setIdentity=this._setAdditiveIdentityNumeric,this.buffer=new Float64Array(5*valueSize)}this._mixBufferRegion=mixFunction,this._mixBufferRegionAdditive=mixFunctionAdditive,this._setIdentity=setIdentity,this._origIndex=3,this._addIndex=4,this.cumulativeWeight=0,this.cumulativeWeightAdditive=0,this.useCount=0,this.referenceCount=0}PositionalAudio.prototype=Object.assign(Object.create(Audio.prototype),{constructor:PositionalAudio,getOutput:function(){return this.panner},getRefDistance:function(){return this.panner.refDistance},setRefDistance:function(value){return this.panner.refDistance=value,this},getRolloffFactor:function(){return this.panner.rolloffFactor},setRolloffFactor:function(value){return this.panner.rolloffFactor=value,this},getDistanceModel:function(){return this.panner.distanceModel},setDistanceModel:function(value){return this.panner.distanceModel=value,this},getMaxDistance:function(){return this.panner.maxDistance},setMaxDistance:function(value){return this.panner.maxDistance=value,this},setDirectionalCone:function(coneInnerAngle,coneOuterAngle,coneOuterGain){return this.panner.coneInnerAngle=coneInnerAngle,this.panner.coneOuterAngle=coneOuterAngle,this.panner.coneOuterGain=coneOuterGain,this},updateMatrixWorld:function(force){if(Object3D.prototype.updateMatrixWorld.call(this,force),!0===this.hasPlaybackControl&&!1===this.isPlaying)return;this.matrixWorld.decompose(_position$3,_quaternion$4,_scale$2),_orientation$1.set(0,0,1).applyQuaternion(_quaternion$4);const panner=this.panner;if(panner.positionX){const endTime=this.context.currentTime+this.listener.timeDelta;panner.positionX.linearRampToValueAtTime(_position$3.x,endTime),panner.positionY.linearRampToValueAtTime(_position$3.y,endTime),panner.positionZ.linearRampToValueAtTime(_position$3.z,endTime),panner.orientationX.linearRampToValueAtTime(_orientation$1.x,endTime),panner.orientationY.linearRampToValueAtTime(_orientation$1.y,endTime),panner.orientationZ.linearRampToValueAtTime(_orientation$1.z,endTime)}else panner.setPosition(_position$3.x,_position$3.y,_position$3.z),panner.setOrientation(_orientation$1.x,_orientation$1.y,_orientation$1.z)}}),Object.assign(AudioAnalyser.prototype,{getFrequencyData:function(){return this.analyser.getByteFrequencyData(this.data),this.data},getAverageFrequency:function(){let value=0;const data=this.getFrequencyData();for(let i=0;i<data.length;i++)value+=data[i];return value/data.length}}),Object.assign(PropertyMixer.prototype,{accumulate:function(accuIndex,weight){const buffer=this.buffer,stride=this.valueSize,offset=accuIndex*stride+stride;let currentWeight=this.cumulativeWeight;if(0===currentWeight){for(let i=0;i!==stride;++i)buffer[offset+i]=buffer[i];currentWeight=weight}else{currentWeight+=weight;const mix=weight/currentWeight;this._mixBufferRegion(buffer,offset,0,mix,stride)}this.cumulativeWeight=currentWeight},accumulateAdditive:function(weight){const buffer=this.buffer,stride=this.valueSize,offset=stride*this._addIndex;0===this.cumulativeWeightAdditive&&this._setIdentity(),this._mixBufferRegionAdditive(buffer,offset,0,weight,stride),this.cumulativeWeightAdditive+=weight},apply:function(accuIndex){const stride=this.valueSize,buffer=this.buffer,offset=accuIndex*stride+stride,weight=this.cumulativeWeight,weightAdditive=this.cumulativeWeightAdditive,binding=this.binding;if(this.cumulativeWeight=0,this.cumulativeWeightAdditive=0,weight<1){const originalValueOffset=stride*this._origIndex;this._mixBufferRegion(buffer,offset,originalValueOffset,1-weight,stride)}weightAdditive>0&&this._mixBufferRegionAdditive(buffer,offset,this._addIndex*stride,1,stride);for(let i=stride,e=stride+stride;i!==e;++i)if(buffer[i]!==buffer[i+stride]){binding.setValue(buffer,offset);break}},saveOriginalState:function(){const binding=this.binding,buffer=this.buffer,stride=this.valueSize,originalValueOffset=stride*this._origIndex;binding.getValue(buffer,originalValueOffset);for(let i=stride,e=originalValueOffset;i!==e;++i)buffer[i]=buffer[originalValueOffset+i%stride];this._setIdentity(),this.cumulativeWeight=0,this.cumulativeWeightAdditive=0},restoreOriginalState:function(){const originalValueOffset=3*this.valueSize;this.binding.setValue(this.buffer,originalValueOffset)},_setAdditiveIdentityNumeric:function(){const startIndex=this._addIndex*this.valueSize,endIndex=startIndex+this.valueSize;for(let i=startIndex;i<endIndex;i++)this.buffer[i]=0},_setAdditiveIdentityQuaternion:function(){this._setAdditiveIdentityNumeric(),this.buffer[4*this._addIndex+3]=1},_setAdditiveIdentityOther:function(){const startIndex=this._origIndex*this.valueSize,targetIndex=this._addIndex*this.valueSize;for(let i=0;i<this.valueSize;i++)this.buffer[targetIndex+i]=this.buffer[startIndex+i]},_select:function(buffer,dstOffset,srcOffset,t,stride){if(t>=.5)for(let i=0;i!==stride;++i)buffer[dstOffset+i]=buffer[srcOffset+i]},_slerp:function(buffer,dstOffset,srcOffset,t){Quaternion.slerpFlat(buffer,dstOffset,buffer,dstOffset,buffer,srcOffset,t)},_slerpAdditive:function(buffer,dstOffset,srcOffset,t,stride){const workOffset=this._workIndex*stride;Quaternion.multiplyQuaternionsFlat(buffer,workOffset,buffer,dstOffset,buffer,srcOffset),Quaternion.slerpFlat(buffer,dstOffset,buffer,dstOffset,buffer,workOffset,t)},_lerp:function(buffer,dstOffset,srcOffset,t,stride){const s=1-t;for(let i=0;i!==stride;++i){const j=dstOffset+i;buffer[j]=buffer[j]*s+buffer[srcOffset+i]*t}},_lerpAdditive:function(buffer,dstOffset,srcOffset,t,stride){for(let i=0;i!==stride;++i){const j=dstOffset+i;buffer[j]=buffer[j]+buffer[srcOffset+i]*t}}});const _reservedRe=new RegExp("[\\[\\]\\.:\\/]","g"),_wordCharOrDot="[^"+"\\[\\]\\.:\\/".replace("\\.","")+"]",_directoryRe=/((?:WC+[\/:])*)/.source.replace("WC","[^\\[\\]\\.:\\/]"),_nodeRe=/(WCOD+)?/.source.replace("WCOD",_wordCharOrDot),_objectRe=/(?:\.(WC+)(?:\[(.+)\])?)?/.source.replace("WC","[^\\[\\]\\.:\\/]"),_propertyRe=/\.(WC+)(?:\[(.+)\])?/.source.replace("WC","[^\\[\\]\\.:\\/]"),_trackRe=new RegExp("^"+_directoryRe+_nodeRe+_objectRe+_propertyRe+"$"),_supportedObjectNames=["material","materials","bones"];function Composite(targetGroup,path,optionalParsedPath){const parsedPath=optionalParsedPath||PropertyBinding.parseTrackName(path);this._targetGroup=targetGroup,this._bindings=targetGroup.subscribe_(path,parsedPath)}function PropertyBinding(rootNode,path,parsedPath){this.path=path,this.parsedPath=parsedPath||PropertyBinding.parseTrackName(path),this.node=PropertyBinding.findNode(rootNode,this.parsedPath.nodeName)||rootNode,this.rootNode=rootNode}function AnimationAction(mixer,clip,localRoot,blendMode){this._mixer=mixer,this._clip=clip,this._localRoot=localRoot||null,this.blendMode=blendMode||clip.blendMode;const tracks=clip.tracks,nTracks=tracks.length,interpolants=new Array(nTracks),interpolantSettings={endingStart:2400,endingEnd:2400};for(let i=0;i!==nTracks;++i){const interpolant=tracks[i].createInterpolant(null);interpolants[i]=interpolant,interpolant.settings=interpolantSettings}this._interpolantSettings=interpolantSettings,this._interpolants=interpolants,this._propertyBindings=new Array(nTracks),this._cacheIndex=null,this._byClipCacheIndex=null,this._timeScaleInterpolant=null,this._weightInterpolant=null,this.loop=2201,this._loopCount=-1,this._startTime=null,this.time=0,this.timeScale=1,this._effectiveTimeScale=1,this.weight=1,this._effectiveWeight=1,this.repetitions=1/0,this.paused=!1,this.enabled=!0,this.clampWhenFinished=!1,this.zeroSlopeAtStart=!0,this.zeroSlopeAtEnd=!0}function AnimationMixer(root){this._root=root,this._initMemoryManager(),this._accuIndex=0,this.time=0,this.timeScale=1}function Uniform(value){"string"==typeof value&&(console.warn("THREE.Uniform: Type parameter is no longer needed."),value=arguments[1]),this.value=value}function InstancedInterleavedBuffer(array,stride,meshPerAttribute){InterleavedBuffer.call(this,array,stride),this.meshPerAttribute=meshPerAttribute||1}function Raycaster(origin,direction,near,far){this.ray=new Ray(origin,direction),this.near=near||0,this.far=far||1/0,this.camera=null,this.layers=new Layers,this.params={Mesh:{},Line:{threshold:1},LOD:{},Points:{threshold:1},Sprite:{}},Object.defineProperties(this.params,{PointCloud:{get:function(){return console.warn("THREE.Raycaster: params.PointCloud has been renamed to params.Points."),this.Points}}})}function ascSort(a,b){return a.distance-b.distance}function intersectObject(object,raycaster,intersects,recursive){if(object.layers.test(raycaster.layers)&&object.raycast(raycaster,intersects),!0===recursive){const children=object.children;for(let i=0,l=children.length;i<l;i++)intersectObject(children[i],raycaster,intersects,!0)}}Object.assign(Composite.prototype,{getValue:function(array,offset){this.bind();const firstValidIndex=this._targetGroup.nCachedObjects_,binding=this._bindings[firstValidIndex];void 0!==binding&&binding.getValue(array,offset)},setValue:function(array,offset){const bindings=this._bindings;for(let i=this._targetGroup.nCachedObjects_,n=bindings.length;i!==n;++i)bindings[i].setValue(array,offset)},bind:function(){const bindings=this._bindings;for(let i=this._targetGroup.nCachedObjects_,n=bindings.length;i!==n;++i)bindings[i].bind()},unbind:function(){const bindings=this._bindings;for(let i=this._targetGroup.nCachedObjects_,n=bindings.length;i!==n;++i)bindings[i].unbind()}}),Object.assign(PropertyBinding,{Composite,create:function(root,path,parsedPath){return root&&root.isAnimationObjectGroup?new PropertyBinding.Composite(root,path,parsedPath):new PropertyBinding(root,path,parsedPath)},sanitizeNodeName:function(name){return name.replace(/\s/g,"_").replace(_reservedRe,"")},parseTrackName:function(trackName){const matches=_trackRe.exec(trackName);if(!matches)throw new Error("PropertyBinding: Cannot parse trackName: "+trackName);const results={nodeName:matches[2],objectName:matches[3],objectIndex:matches[4],propertyName:matches[5],propertyIndex:matches[6]},lastDot=results.nodeName&&results.nodeName.lastIndexOf(".");if(void 0!==lastDot&&-1!==lastDot){const objectName=results.nodeName.substring(lastDot+1);-1!==_supportedObjectNames.indexOf(objectName)&&(results.nodeName=results.nodeName.substring(0,lastDot),results.objectName=objectName)}if(null===results.propertyName||0===results.propertyName.length)throw new Error("PropertyBinding: can not parse propertyName from trackName: "+trackName);return results},findNode:function(root,nodeName){if(!nodeName||""===nodeName||"."===nodeName||-1===nodeName||nodeName===root.name||nodeName===root.uuid)return root;if(root.skeleton){const bone=root.skeleton.getBoneByName(nodeName);if(void 0!==bone)return bone}if(root.children){const searchNodeSubtree=function(children){for(let i=0;i<children.length;i++){const childNode=children[i];if(childNode.name===nodeName||childNode.uuid===nodeName)return childNode;const result=searchNodeSubtree(childNode.children);if(result)return result}return null},subTreeNode=searchNodeSubtree(root.children);if(subTreeNode)return subTreeNode}return null}}),Object.assign(PropertyBinding.prototype,{_getValue_unavailable:function(){},_setValue_unavailable:function(){},BindingType:{Direct:0,EntireArray:1,ArrayElement:2,HasFromToArray:3},Versioning:{None:0,NeedsUpdate:1,MatrixWorldNeedsUpdate:2},GetterByBindingType:[function(buffer,offset){buffer[offset]=this.node[this.propertyName]},function(buffer,offset){const source=this.resolvedProperty;for(let i=0,n=source.length;i!==n;++i)buffer[offset++]=source[i]},function(buffer,offset){buffer[offset]=this.resolvedProperty[this.propertyIndex]},function(buffer,offset){this.resolvedProperty.toArray(buffer,offset)}],SetterByBindingTypeAndVersioning:[[function(buffer,offset){this.targetObject[this.propertyName]=buffer[offset]},function(buffer,offset){this.targetObject[this.propertyName]=buffer[offset],this.targetObject.needsUpdate=!0},function(buffer,offset){this.targetObject[this.propertyName]=buffer[offset],this.targetObject.matrixWorldNeedsUpdate=!0}],[function(buffer,offset){const dest=this.resolvedProperty;for(let i=0,n=dest.length;i!==n;++i)dest[i]=buffer[offset++]},function(buffer,offset){const dest=this.resolvedProperty;for(let i=0,n=dest.length;i!==n;++i)dest[i]=buffer[offset++];this.targetObject.needsUpdate=!0},function(buffer,offset){const dest=this.resolvedProperty;for(let i=0,n=dest.length;i!==n;++i)dest[i]=buffer[offset++];this.targetObject.matrixWorldNeedsUpdate=!0}],[function(buffer,offset){this.resolvedProperty[this.propertyIndex]=buffer[offset]},function(buffer,offset){this.resolvedProperty[this.propertyIndex]=buffer[offset],this.targetObject.needsUpdate=!0},function(buffer,offset){this.resolvedProperty[this.propertyIndex]=buffer[offset],this.targetObject.matrixWorldNeedsUpdate=!0}],[function(buffer,offset){this.resolvedProperty.fromArray(buffer,offset)},function(buffer,offset){this.resolvedProperty.fromArray(buffer,offset),this.targetObject.needsUpdate=!0},function(buffer,offset){this.resolvedProperty.fromArray(buffer,offset),this.targetObject.matrixWorldNeedsUpdate=!0}]],getValue:function(targetArray,offset){this.bind(),this.getValue(targetArray,offset)},setValue:function(sourceArray,offset){this.bind(),this.setValue(sourceArray,offset)},bind:function(){let targetObject=this.node,parsedPath=this.parsedPath,objectName=parsedPath.objectName,propertyName=parsedPath.propertyName,propertyIndex=parsedPath.propertyIndex;if(targetObject||(targetObject=PropertyBinding.findNode(this.rootNode,parsedPath.nodeName)||this.rootNode,this.node=targetObject),this.getValue=this._getValue_unavailable,this.setValue=this._setValue_unavailable,!targetObject)return void console.error("THREE.PropertyBinding: Trying to update node for track: "+this.path+" but it wasn't found.");if(objectName){let objectIndex=parsedPath.objectIndex;switch(objectName){case"materials":if(!targetObject.material)return void console.error("THREE.PropertyBinding: Can not bind to material as node does not have a material.",this);if(!targetObject.material.materials)return void console.error("THREE.PropertyBinding: Can not bind to material.materials as node.material does not have a materials array.",this);targetObject=targetObject.material.materials;break;case"bones":if(!targetObject.skeleton)return void console.error("THREE.PropertyBinding: Can not bind to bones as node does not have a skeleton.",this);targetObject=targetObject.skeleton.bones;for(let i=0;i<targetObject.length;i++)if(targetObject[i].name===objectIndex){objectIndex=i;break}break;default:if(void 0===targetObject[objectName])return void console.error("THREE.PropertyBinding: Can not bind to objectName of node undefined.",this);targetObject=targetObject[objectName]}if(void 0!==objectIndex){if(void 0===targetObject[objectIndex])return void console.error("THREE.PropertyBinding: Trying to bind to objectIndex of objectName, but is undefined.",this,targetObject);targetObject=targetObject[objectIndex]}}const nodeProperty=targetObject[propertyName];if(void 0===nodeProperty){const nodeName=parsedPath.nodeName;return void console.error("THREE.PropertyBinding: Trying to update property for track: "+nodeName+"."+propertyName+" but it wasn't found.",targetObject)}let versioning=this.Versioning.None;this.targetObject=targetObject,void 0!==targetObject.needsUpdate?versioning=this.Versioning.NeedsUpdate:void 0!==targetObject.matrixWorldNeedsUpdate&&(versioning=this.Versioning.MatrixWorldNeedsUpdate);let bindingType=this.BindingType.Direct;if(void 0!==propertyIndex){if("morphTargetInfluences"===propertyName){if(!targetObject.geometry)return void console.error("THREE.PropertyBinding: Can not bind to morphTargetInfluences because node does not have a geometry.",this);if(!targetObject.geometry.isBufferGeometry)return void console.error("THREE.PropertyBinding: Can not bind to morphTargetInfluences on THREE.Geometry. Use THREE.BufferGeometry instead.",this);if(!targetObject.geometry.morphAttributes)return void console.error("THREE.PropertyBinding: Can not bind to morphTargetInfluences because node does not have a geometry.morphAttributes.",this);void 0!==targetObject.morphTargetDictionary[propertyIndex]&&(propertyIndex=targetObject.morphTargetDictionary[propertyIndex])}bindingType=this.BindingType.ArrayElement,this.resolvedProperty=nodeProperty,this.propertyIndex=propertyIndex}else void 0!==nodeProperty.fromArray&&void 0!==nodeProperty.toArray?(bindingType=this.BindingType.HasFromToArray,this.resolvedProperty=nodeProperty):Array.isArray(nodeProperty)?(bindingType=this.BindingType.EntireArray,this.resolvedProperty=nodeProperty):this.propertyName=propertyName;this.getValue=this.GetterByBindingType[bindingType],this.setValue=this.SetterByBindingTypeAndVersioning[bindingType][versioning]},unbind:function(){this.node=null,this.getValue=this._getValue_unbound,this.setValue=this._setValue_unbound}}),Object.assign(PropertyBinding.prototype,{_getValue_unbound:PropertyBinding.prototype.getValue,_setValue_unbound:PropertyBinding.prototype.setValue}),Object.assign(function(){this.uuid=MathUtils.generateUUID(),this._objects=Array.prototype.slice.call(arguments),this.nCachedObjects_=0;const indices={};this._indicesByUUID=indices;for(let i=0,n=arguments.length;i!==n;++i)indices[arguments[i].uuid]=i;this._paths=[],this._parsedPaths=[],this._bindings=[],this._bindingsIndicesByPath={};const scope=this;this.stats={objects:{get total(){return scope._objects.length},get inUse(){return this.total-scope.nCachedObjects_}},get bindingsPerObject(){return scope._bindings.length}}}.prototype,{isAnimationObjectGroup:!0,add:function(){const objects=this._objects,indicesByUUID=this._indicesByUUID,paths=this._paths,parsedPaths=this._parsedPaths,bindings=this._bindings,nBindings=bindings.length;let knownObject=void 0,nObjects=objects.length,nCachedObjects=this.nCachedObjects_;for(let i=0,n=arguments.length;i!==n;++i){const object=arguments[i],uuid=object.uuid;let index=indicesByUUID[uuid];if(void 0===index){index=nObjects++,indicesByUUID[uuid]=index,objects.push(object);for(let j=0,m=nBindings;j!==m;++j)bindings[j].push(new PropertyBinding(object,paths[j],parsedPaths[j]))}else if(index<nCachedObjects){knownObject=objects[index];const firstActiveIndex=--nCachedObjects,lastCachedObject=objects[firstActiveIndex];indicesByUUID[lastCachedObject.uuid]=index,objects[index]=lastCachedObject,indicesByUUID[uuid]=firstActiveIndex,objects[firstActiveIndex]=object;for(let j=0,m=nBindings;j!==m;++j){const bindingsForPath=bindings[j],lastCached=bindingsForPath[firstActiveIndex];let binding=bindingsForPath[index];bindingsForPath[index]=lastCached,void 0===binding&&(binding=new PropertyBinding(object,paths[j],parsedPaths[j])),bindingsForPath[firstActiveIndex]=binding}}else objects[index]!==knownObject&&console.error("THREE.AnimationObjectGroup: Different objects with the same UUID detected. Clean the caches or recreate your infrastructure when reloading scenes.")}this.nCachedObjects_=nCachedObjects},remove:function(){const objects=this._objects,indicesByUUID=this._indicesByUUID,bindings=this._bindings,nBindings=bindings.length;let nCachedObjects=this.nCachedObjects_;for(let i=0,n=arguments.length;i!==n;++i){const object=arguments[i],uuid=object.uuid,index=indicesByUUID[uuid];if(void 0!==index&&index>=nCachedObjects){const lastCachedIndex=nCachedObjects++,firstActiveObject=objects[lastCachedIndex];indicesByUUID[firstActiveObject.uuid]=index,objects[index]=firstActiveObject,indicesByUUID[uuid]=lastCachedIndex,objects[lastCachedIndex]=object;for(let j=0,m=nBindings;j!==m;++j){const bindingsForPath=bindings[j],firstActive=bindingsForPath[lastCachedIndex],binding=bindingsForPath[index];bindingsForPath[index]=firstActive,bindingsForPath[lastCachedIndex]=binding}}}this.nCachedObjects_=nCachedObjects},uncache:function(){const objects=this._objects,indicesByUUID=this._indicesByUUID,bindings=this._bindings,nBindings=bindings.length;let nCachedObjects=this.nCachedObjects_,nObjects=objects.length;for(let i=0,n=arguments.length;i!==n;++i){const uuid=arguments[i].uuid,index=indicesByUUID[uuid];if(void 0!==index)if(delete indicesByUUID[uuid],index<nCachedObjects){const firstActiveIndex=--nCachedObjects,lastCachedObject=objects[firstActiveIndex],lastIndex=--nObjects,lastObject=objects[lastIndex];indicesByUUID[lastCachedObject.uuid]=index,objects[index]=lastCachedObject,indicesByUUID[lastObject.uuid]=firstActiveIndex,objects[firstActiveIndex]=lastObject,objects.pop();for(let j=0,m=nBindings;j!==m;++j){const bindingsForPath=bindings[j],lastCached=bindingsForPath[firstActiveIndex],last=bindingsForPath[lastIndex];bindingsForPath[index]=lastCached,bindingsForPath[firstActiveIndex]=last,bindingsForPath.pop()}}else{const lastIndex=--nObjects,lastObject=objects[lastIndex];indicesByUUID[lastObject.uuid]=index,objects[index]=lastObject,objects.pop();for(let j=0,m=nBindings;j!==m;++j){const bindingsForPath=bindings[j];bindingsForPath[index]=bindingsForPath[lastIndex],bindingsForPath.pop()}}}this.nCachedObjects_=nCachedObjects},subscribe_:function(path,parsedPath){let indicesByPath=this._bindingsIndicesByPath,index=indicesByPath[path],bindings=this._bindings;if(void 0!==index)return bindings[index];const paths=this._paths,parsedPaths=this._parsedPaths,objects=this._objects,nObjects=objects.length,nCachedObjects=this.nCachedObjects_,bindingsForPath=new Array(nObjects);index=bindings.length,indicesByPath[path]=index,paths.push(path),parsedPaths.push(parsedPath),bindings.push(bindingsForPath);for(let i=nCachedObjects,n=objects.length;i!==n;++i){const object=objects[i];bindingsForPath[i]=new PropertyBinding(object,path,parsedPath)}return bindingsForPath},unsubscribe_:function(path){const indicesByPath=this._bindingsIndicesByPath,index=indicesByPath[path];if(void 0!==index){const paths=this._paths,parsedPaths=this._parsedPaths,bindings=this._bindings,lastBindingsIndex=bindings.length-1,lastBindings=bindings[lastBindingsIndex];indicesByPath[path[lastBindingsIndex]]=index,bindings[index]=lastBindings,bindings.pop(),parsedPaths[index]=parsedPaths[lastBindingsIndex],parsedPaths.pop(),paths[index]=paths[lastBindingsIndex],paths.pop()}}}),Object.assign(AnimationAction.prototype,{play:function(){return this._mixer._activateAction(this),this},stop:function(){return this._mixer._deactivateAction(this),this.reset()},reset:function(){return this.paused=!1,this.enabled=!0,this.time=0,this._loopCount=-1,this._startTime=null,this.stopFading().stopWarping()},isRunning:function(){return this.enabled&&!this.paused&&0!==this.timeScale&&null===this._startTime&&this._mixer._isActiveAction(this)},isScheduled:function(){return this._mixer._isActiveAction(this)},startAt:function(time){return this._startTime=time,this},setLoop:function(mode,repetitions){return this.loop=mode,this.repetitions=repetitions,this},setEffectiveWeight:function(weight){return this.weight=weight,this._effectiveWeight=this.enabled?weight:0,this.stopFading()},getEffectiveWeight:function(){return this._effectiveWeight},fadeIn:function(duration){return this._scheduleFading(duration,0,1)},fadeOut:function(duration){return this._scheduleFading(duration,1,0)},crossFadeFrom:function(fadeOutAction,duration,warp){if(fadeOutAction.fadeOut(duration),this.fadeIn(duration),warp){const fadeInDuration=this._clip.duration,fadeOutDuration=fadeOutAction._clip.duration,startEndRatio=fadeOutDuration/fadeInDuration,endStartRatio=fadeInDuration/fadeOutDuration;fadeOutAction.warp(1,startEndRatio,duration),this.warp(endStartRatio,1,duration)}return this},crossFadeTo:function(fadeInAction,duration,warp){return fadeInAction.crossFadeFrom(this,duration,warp)},stopFading:function(){let weightInterpolant=this._weightInterpolant;return null!==weightInterpolant&&(this._weightInterpolant=null,this._mixer._takeBackControlInterpolant(weightInterpolant)),this},setEffectiveTimeScale:function(timeScale){return this.timeScale=timeScale,this._effectiveTimeScale=this.paused?0:timeScale,this.stopWarping()},getEffectiveTimeScale:function(){return this._effectiveTimeScale},setDuration:function(duration){return this.timeScale=this._clip.duration/duration,this.stopWarping()},syncWith:function(action){return this.time=action.time,this.timeScale=action.timeScale,this.stopWarping()},halt:function(duration){return this.warp(this._effectiveTimeScale,0,duration)},warp:function(startTimeScale,endTimeScale,duration){const mixer=this._mixer,now=mixer.time,timeScale=this.timeScale;let interpolant=this._timeScaleInterpolant;null===interpolant&&(interpolant=mixer._lendControlInterpolant(),this._timeScaleInterpolant=interpolant);const times=interpolant.parameterPositions,values=interpolant.sampleValues;return times[0]=now,times[1]=now+duration,values[0]=startTimeScale/timeScale,values[1]=endTimeScale/timeScale,this},stopWarping:function(){let timeScaleInterpolant=this._timeScaleInterpolant;return null!==timeScaleInterpolant&&(this._timeScaleInterpolant=null,this._mixer._takeBackControlInterpolant(timeScaleInterpolant)),this},getMixer:function(){return this._mixer},getClip:function(){return this._clip},getRoot:function(){return this._localRoot||this._mixer._root},_update:function(time,deltaTime,timeDirection,accuIndex){if(!this.enabled)return void this._updateWeight(time);const startTime=this._startTime;if(null!==startTime){const timeRunning=(time-startTime)*timeDirection;if(timeRunning<0||0===timeDirection)return;this._startTime=null,deltaTime=timeDirection*timeRunning}deltaTime*=this._updateTimeScale(time);const clipTime=this._updateTime(deltaTime),weight=this._updateWeight(time);if(weight>0){const interpolants=this._interpolants,propertyMixers=this._propertyBindings;switch(this.blendMode){case 2501:for(let j=0,m=interpolants.length;j!==m;++j)interpolants[j].evaluate(clipTime),propertyMixers[j].accumulateAdditive(weight);break;case 2500:default:for(let j=0,m=interpolants.length;j!==m;++j)interpolants[j].evaluate(clipTime),propertyMixers[j].accumulate(accuIndex,weight)}}},_updateWeight:function(time){let weight=0;if(this.enabled){weight=this.weight;const interpolant=this._weightInterpolant;if(null!==interpolant){const interpolantValue=interpolant.evaluate(time)[0];weight*=interpolantValue,time>interpolant.parameterPositions[1]&&(this.stopFading(),0===interpolantValue&&(this.enabled=!1))}}return this._effectiveWeight=weight,weight},_updateTimeScale:function(time){let timeScale=0;if(!this.paused){timeScale=this.timeScale;const interpolant=this._timeScaleInterpolant;if(null!==interpolant){timeScale*=interpolant.evaluate(time)[0],time>interpolant.parameterPositions[1]&&(this.stopWarping(),0===timeScale?this.paused=!0:this.timeScale=timeScale)}}return this._effectiveTimeScale=timeScale,timeScale},_updateTime:function(deltaTime){const duration=this._clip.duration,loop=this.loop;let time=this.time+deltaTime,loopCount=this._loopCount;const pingPong=2202===loop;if(0===deltaTime)return-1===loopCount?time:pingPong&&1==(1&loopCount)?duration-time:time;if(2200===loop){-1===loopCount&&(this._loopCount=0,this._setEndings(!0,!0,!1));handle_stop:{if(time>=duration)time=duration;else{if(!(time<0)){this.time=time;break handle_stop}time=0}this.clampWhenFinished?this.paused=!0:this.enabled=!1,this.time=time,this._mixer.dispatchEvent({type:"finished",action:this,direction:deltaTime<0?-1:1})}}else{if(-1===loopCount&&(deltaTime>=0?(loopCount=0,this._setEndings(!0,0===this.repetitions,pingPong)):this._setEndings(0===this.repetitions,!0,pingPong)),time>=duration||time<0){const loopDelta=Math.floor(time/duration);time-=duration*loopDelta,loopCount+=Math.abs(loopDelta);const pending=this.repetitions-loopCount;if(pending<=0)this.clampWhenFinished?this.paused=!0:this.enabled=!1,time=deltaTime>0?duration:0,this.time=time,this._mixer.dispatchEvent({type:"finished",action:this,direction:deltaTime>0?1:-1});else{if(1===pending){const atStart=deltaTime<0;this._setEndings(atStart,!atStart,pingPong)}else this._setEndings(!1,!1,pingPong);this._loopCount=loopCount,this.time=time,this._mixer.dispatchEvent({type:"loop",action:this,loopDelta})}}else this.time=time;if(pingPong&&1==(1&loopCount))return duration-time}return time},_setEndings:function(atStart,atEnd,pingPong){const settings=this._interpolantSettings;pingPong?(settings.endingStart=2401,settings.endingEnd=2401):(settings.endingStart=atStart?this.zeroSlopeAtStart?2401:2400:2402,settings.endingEnd=atEnd?this.zeroSlopeAtEnd?2401:2400:2402)},_scheduleFading:function(duration,weightNow,weightThen){const mixer=this._mixer,now=mixer.time;let interpolant=this._weightInterpolant;null===interpolant&&(interpolant=mixer._lendControlInterpolant(),this._weightInterpolant=interpolant);const times=interpolant.parameterPositions,values=interpolant.sampleValues;return times[0]=now,values[0]=weightNow,times[1]=now+duration,values[1]=weightThen,this}}),AnimationMixer.prototype=Object.assign(Object.create(EventDispatcher.prototype),{constructor:AnimationMixer,_bindAction:function(action,prototypeAction){const root=action._localRoot||this._root,tracks=action._clip.tracks,nTracks=tracks.length,bindings=action._propertyBindings,interpolants=action._interpolants,rootUuid=root.uuid,bindingsByRoot=this._bindingsByRootAndName;let bindingsByName=bindingsByRoot[rootUuid];void 0===bindingsByName&&(bindingsByName={},bindingsByRoot[rootUuid]=bindingsByName);for(let i=0;i!==nTracks;++i){const track=tracks[i],trackName=track.name;let binding=bindingsByName[trackName];if(void 0!==binding)bindings[i]=binding;else{if(binding=bindings[i],void 0!==binding){null===binding._cacheIndex&&(++binding.referenceCount,this._addInactiveBinding(binding,rootUuid,trackName));continue}const path=prototypeAction&&prototypeAction._propertyBindings[i].binding.parsedPath;binding=new PropertyMixer(PropertyBinding.create(root,trackName,path),track.ValueTypeName,track.getValueSize()),++binding.referenceCount,this._addInactiveBinding(binding,rootUuid,trackName),bindings[i]=binding}interpolants[i].resultBuffer=binding.buffer}},_activateAction:function(action){if(!this._isActiveAction(action)){if(null===action._cacheIndex){const rootUuid=(action._localRoot||this._root).uuid,clipUuid=action._clip.uuid,actionsForClip=this._actionsByClip[clipUuid];this._bindAction(action,actionsForClip&&actionsForClip.knownActions[0]),this._addInactiveAction(action,clipUuid,rootUuid)}const bindings=action._propertyBindings;for(let i=0,n=bindings.length;i!==n;++i){const binding=bindings[i];0==binding.useCount++&&(this._lendBinding(binding),binding.saveOriginalState())}this._lendAction(action)}},_deactivateAction:function(action){if(this._isActiveAction(action)){const bindings=action._propertyBindings;for(let i=0,n=bindings.length;i!==n;++i){const binding=bindings[i];0==--binding.useCount&&(binding.restoreOriginalState(),this._takeBackBinding(binding))}this._takeBackAction(action)}},_initMemoryManager:function(){this._actions=[],this._nActiveActions=0,this._actionsByClip={},this._bindings=[],this._nActiveBindings=0,this._bindingsByRootAndName={},this._controlInterpolants=[],this._nActiveControlInterpolants=0;const scope=this;this.stats={actions:{get total(){return scope._actions.length},get inUse(){return scope._nActiveActions}},bindings:{get total(){return scope._bindings.length},get inUse(){return scope._nActiveBindings}},controlInterpolants:{get total(){return scope._controlInterpolants.length},get inUse(){return scope._nActiveControlInterpolants}}}},_isActiveAction:function(action){const index=action._cacheIndex;return null!==index&&index<this._nActiveActions},_addInactiveAction:function(action,clipUuid,rootUuid){const actions=this._actions,actionsByClip=this._actionsByClip;let actionsForClip=actionsByClip[clipUuid];if(void 0===actionsForClip)actionsForClip={knownActions:[action],actionByRoot:{}},action._byClipCacheIndex=0,actionsByClip[clipUuid]=actionsForClip;else{const knownActions=actionsForClip.knownActions;action._byClipCacheIndex=knownActions.length,knownActions.push(action)}action._cacheIndex=actions.length,actions.push(action),actionsForClip.actionByRoot[rootUuid]=action},_removeInactiveAction:function(action){const actions=this._actions,lastInactiveAction=actions[actions.length-1],cacheIndex=action._cacheIndex;lastInactiveAction._cacheIndex=cacheIndex,actions[cacheIndex]=lastInactiveAction,actions.pop(),action._cacheIndex=null;const clipUuid=action._clip.uuid,actionsByClip=this._actionsByClip,actionsForClip=actionsByClip[clipUuid],knownActionsForClip=actionsForClip.knownActions,lastKnownAction=knownActionsForClip[knownActionsForClip.length-1],byClipCacheIndex=action._byClipCacheIndex;lastKnownAction._byClipCacheIndex=byClipCacheIndex,knownActionsForClip[byClipCacheIndex]=lastKnownAction,knownActionsForClip.pop(),action._byClipCacheIndex=null;delete actionsForClip.actionByRoot[(action._localRoot||this._root).uuid],0===knownActionsForClip.length&&delete actionsByClip[clipUuid],this._removeInactiveBindingsForAction(action)},_removeInactiveBindingsForAction:function(action){const bindings=action._propertyBindings;for(let i=0,n=bindings.length;i!==n;++i){const binding=bindings[i];0==--binding.referenceCount&&this._removeInactiveBinding(binding)}},_lendAction:function(action){const actions=this._actions,prevIndex=action._cacheIndex,lastActiveIndex=this._nActiveActions++,firstInactiveAction=actions[lastActiveIndex];action._cacheIndex=lastActiveIndex,actions[lastActiveIndex]=action,firstInactiveAction._cacheIndex=prevIndex,actions[prevIndex]=firstInactiveAction},_takeBackAction:function(action){const actions=this._actions,prevIndex=action._cacheIndex,firstInactiveIndex=--this._nActiveActions,lastActiveAction=actions[firstInactiveIndex];action._cacheIndex=firstInactiveIndex,actions[firstInactiveIndex]=action,lastActiveAction._cacheIndex=prevIndex,actions[prevIndex]=lastActiveAction},_addInactiveBinding:function(binding,rootUuid,trackName){const bindingsByRoot=this._bindingsByRootAndName,bindings=this._bindings;let bindingByName=bindingsByRoot[rootUuid];void 0===bindingByName&&(bindingByName={},bindingsByRoot[rootUuid]=bindingByName),bindingByName[trackName]=binding,binding._cacheIndex=bindings.length,bindings.push(binding)},_removeInactiveBinding:function(binding){const bindings=this._bindings,propBinding=binding.binding,rootUuid=propBinding.rootNode.uuid,trackName=propBinding.path,bindingsByRoot=this._bindingsByRootAndName,bindingByName=bindingsByRoot[rootUuid],lastInactiveBinding=bindings[bindings.length-1],cacheIndex=binding._cacheIndex;lastInactiveBinding._cacheIndex=cacheIndex,bindings[cacheIndex]=lastInactiveBinding,bindings.pop(),delete bindingByName[trackName],0===Object.keys(bindingByName).length&&delete bindingsByRoot[rootUuid]},_lendBinding:function(binding){const bindings=this._bindings,prevIndex=binding._cacheIndex,lastActiveIndex=this._nActiveBindings++,firstInactiveBinding=bindings[lastActiveIndex];binding._cacheIndex=lastActiveIndex,bindings[lastActiveIndex]=binding,firstInactiveBinding._cacheIndex=prevIndex,bindings[prevIndex]=firstInactiveBinding},_takeBackBinding:function(binding){const bindings=this._bindings,prevIndex=binding._cacheIndex,firstInactiveIndex=--this._nActiveBindings,lastActiveBinding=bindings[firstInactiveIndex];binding._cacheIndex=firstInactiveIndex,bindings[firstInactiveIndex]=binding,lastActiveBinding._cacheIndex=prevIndex,bindings[prevIndex]=lastActiveBinding},_lendControlInterpolant:function(){const interpolants=this._controlInterpolants,lastActiveIndex=this._nActiveControlInterpolants++;let interpolant=interpolants[lastActiveIndex];return void 0===interpolant&&(interpolant=new LinearInterpolant(new Float32Array(2),new Float32Array(2),1,this._controlInterpolantsResultBuffer),interpolant.__cacheIndex=lastActiveIndex,interpolants[lastActiveIndex]=interpolant),interpolant},_takeBackControlInterpolant:function(interpolant){const interpolants=this._controlInterpolants,prevIndex=interpolant.__cacheIndex,firstInactiveIndex=--this._nActiveControlInterpolants,lastActiveInterpolant=interpolants[firstInactiveIndex];interpolant.__cacheIndex=firstInactiveIndex,interpolants[firstInactiveIndex]=interpolant,lastActiveInterpolant.__cacheIndex=prevIndex,interpolants[prevIndex]=lastActiveInterpolant},_controlInterpolantsResultBuffer:new Float32Array(1),clipAction:function(clip,optionalRoot,blendMode){const root=optionalRoot||this._root,rootUuid=root.uuid;let clipObject="string"==typeof clip?AnimationClip.findByName(root,clip):clip;const clipUuid=null!==clipObject?clipObject.uuid:clip;let actionsForClip=this._actionsByClip[clipUuid],prototypeAction=null;if(void 0===blendMode&&(blendMode=null!==clipObject?clipObject.blendMode:2500),void 0!==actionsForClip){const existingAction=actionsForClip.actionByRoot[rootUuid];if(void 0!==existingAction&&existingAction.blendMode===blendMode)return existingAction;prototypeAction=actionsForClip.knownActions[0],null===clipObject&&(clipObject=prototypeAction._clip)}if(null===clipObject)return null;const newAction=new AnimationAction(this,clipObject,optionalRoot,blendMode);return this._bindAction(newAction,prototypeAction),this._addInactiveAction(newAction,clipUuid,rootUuid),newAction},existingAction:function(clip,optionalRoot){const root=optionalRoot||this._root,rootUuid=root.uuid,clipObject="string"==typeof clip?AnimationClip.findByName(root,clip):clip,clipUuid=clipObject?clipObject.uuid:clip,actionsForClip=this._actionsByClip[clipUuid];return void 0!==actionsForClip&&actionsForClip.actionByRoot[rootUuid]||null},stopAllAction:function(){const actions=this._actions;for(let i=this._nActiveActions-1;i>=0;--i)actions[i].stop();return this},update:function(deltaTime){deltaTime*=this.timeScale;const actions=this._actions,nActions=this._nActiveActions,time=this.time+=deltaTime,timeDirection=Math.sign(deltaTime),accuIndex=this._accuIndex^=1;for(let i=0;i!==nActions;++i){actions[i]._update(time,deltaTime,timeDirection,accuIndex)}const bindings=this._bindings,nBindings=this._nActiveBindings;for(let i=0;i!==nBindings;++i)bindings[i].apply(accuIndex);return this},setTime:function(timeInSeconds){this.time=0;for(let i=0;i<this._actions.length;i++)this._actions[i].time=0;return this.update(timeInSeconds)},getRoot:function(){return this._root},uncacheClip:function(clip){const actions=this._actions,clipUuid=clip.uuid,actionsByClip=this._actionsByClip,actionsForClip=actionsByClip[clipUuid];if(void 0!==actionsForClip){const actionsToRemove=actionsForClip.knownActions;for(let i=0,n=actionsToRemove.length;i!==n;++i){const action=actionsToRemove[i];this._deactivateAction(action);const cacheIndex=action._cacheIndex,lastInactiveAction=actions[actions.length-1];action._cacheIndex=null,action._byClipCacheIndex=null,lastInactiveAction._cacheIndex=cacheIndex,actions[cacheIndex]=lastInactiveAction,actions.pop(),this._removeInactiveBindingsForAction(action)}delete actionsByClip[clipUuid]}},uncacheRoot:function(root){const rootUuid=root.uuid,actionsByClip=this._actionsByClip;for(const clipUuid in actionsByClip){const action=actionsByClip[clipUuid].actionByRoot[rootUuid];void 0!==action&&(this._deactivateAction(action),this._removeInactiveAction(action))}const bindingByName=this._bindingsByRootAndName[rootUuid];if(void 0!==bindingByName)for(const trackName in bindingByName){const binding=bindingByName[trackName];binding.restoreOriginalState(),this._removeInactiveBinding(binding)}},uncacheAction:function(clip,optionalRoot){const action=this.existingAction(clip,optionalRoot);null!==action&&(this._deactivateAction(action),this._removeInactiveAction(action))}}),Uniform.prototype.clone=function(){return new Uniform(void 0===this.value.clone?this.value:this.value.clone())},InstancedInterleavedBuffer.prototype=Object.assign(Object.create(InterleavedBuffer.prototype),{constructor:InstancedInterleavedBuffer,isInstancedInterleavedBuffer:!0,copy:function(source){return InterleavedBuffer.prototype.copy.call(this,source),this.meshPerAttribute=source.meshPerAttribute,this},clone:function(data){const ib=InterleavedBuffer.prototype.clone.call(this,data);return ib.meshPerAttribute=this.meshPerAttribute,ib},toJSON:function(data){const json=InterleavedBuffer.prototype.toJSON.call(this,data);return json.isInstancedInterleavedBuffer=!0,json.meshPerAttribute=this.meshPerAttribute,json}}),Object.assign(Raycaster.prototype,{set:function(origin,direction){this.ray.set(origin,direction)},setFromCamera:function(coords,camera){camera&&camera.isPerspectiveCamera?(this.ray.origin.setFromMatrixPosition(camera.matrixWorld),this.ray.direction.set(coords.x,coords.y,.5).unproject(camera).sub(this.ray.origin).normalize(),this.camera=camera):camera&&camera.isOrthographicCamera?(this.ray.origin.set(coords.x,coords.y,(camera.near+camera.far)/(camera.near-camera.far)).unproject(camera),this.ray.direction.set(0,0,-1).transformDirection(camera.matrixWorld),this.camera=camera):console.error("THREE.Raycaster: Unsupported camera type.")},intersectObject:function(object,recursive,optionalTarget){const intersects=optionalTarget||[];return intersectObject(object,this,intersects,recursive),intersects.sort(ascSort),intersects},intersectObjects:function(objects,recursive,optionalTarget){const intersects=optionalTarget||[];if(!1===Array.isArray(objects))return console.warn("THREE.Raycaster.intersectObjects: objects is not an Array."),intersects;for(let i=0,l=objects.length;i<l;i++)intersectObject(objects[i],this,intersects,recursive);return intersects.sort(ascSort),intersects}});class Spherical{constructor(radius=1,phi=0,theta=0){return this.radius=radius,this.phi=phi,this.theta=theta,this}set(radius,phi,theta){return this.radius=radius,this.phi=phi,this.theta=theta,this}clone(){return(new this.constructor).copy(this)}copy(other){return this.radius=other.radius,this.phi=other.phi,this.theta=other.theta,this}makeSafe(){return this.phi=Math.max(1e-6,Math.min(Math.PI-1e-6,this.phi)),this}setFromVector3(v){return this.setFromCartesianCoords(v.x,v.y,v.z)}setFromCartesianCoords(x,y,z){return this.radius=Math.sqrt(x*x+y*y+z*z),0===this.radius?(this.theta=0,this.phi=0):(this.theta=Math.atan2(x,z),this.phi=Math.acos(MathUtils.clamp(y/this.radius,-1,1))),this}}Object.assign(function(radius,theta,y){return this.radius=void 0!==radius?radius:1,this.theta=void 0!==theta?theta:0,this.y=void 0!==y?y:0,this}.prototype,{set:function(radius,theta,y){return this.radius=radius,this.theta=theta,this.y=y,this},clone:function(){return(new this.constructor).copy(this)},copy:function(other){return this.radius=other.radius,this.theta=other.theta,this.y=other.y,this},setFromVector3:function(v){return this.setFromCartesianCoords(v.x,v.y,v.z)},setFromCartesianCoords:function(x,y,z){return this.radius=Math.sqrt(x*x+z*z),this.theta=Math.atan2(x,z),this.y=y,this}});const _vector$7=new Vector2;function Box2(min,max){this.min=void 0!==min?min:new Vector2(1/0,1/0),this.max=void 0!==max?max:new Vector2(-1/0,-1/0)}Object.assign(Box2.prototype,{set:function(min,max){return this.min.copy(min),this.max.copy(max),this},setFromPoints:function(points){this.makeEmpty();for(let i=0,il=points.length;i<il;i++)this.expandByPoint(points[i]);return this},setFromCenterAndSize:function(center,size){const halfSize=_vector$7.copy(size).multiplyScalar(.5);return this.min.copy(center).sub(halfSize),this.max.copy(center).add(halfSize),this},clone:function(){return(new this.constructor).copy(this)},copy:function(box){return this.min.copy(box.min),this.max.copy(box.max),this},makeEmpty:function(){return this.min.x=this.min.y=1/0,this.max.x=this.max.y=-1/0,this},isEmpty:function(){return this.max.x<this.min.x||this.max.y<this.min.y},getCenter:function(target){return void 0===target&&(console.warn("THREE.Box2: .getCenter() target is now required"),target=new Vector2),this.isEmpty()?target.set(0,0):target.addVectors(this.min,this.max).multiplyScalar(.5)},getSize:function(target){return void 0===target&&(console.warn("THREE.Box2: .getSize() target is now required"),target=new Vector2),this.isEmpty()?target.set(0,0):target.subVectors(this.max,this.min)},expandByPoint:function(point){return this.min.min(point),this.max.max(point),this},expandByVector:function(vector){return this.min.sub(vector),this.max.add(vector),this},expandByScalar:function(scalar){return this.min.addScalar(-scalar),this.max.addScalar(scalar),this},containsPoint:function(point){return!(point.x<this.min.x||point.x>this.max.x||point.y<this.min.y||point.y>this.max.y)},containsBox:function(box){return this.min.x<=box.min.x&&box.max.x<=this.max.x&&this.min.y<=box.min.y&&box.max.y<=this.max.y},getParameter:function(point,target){return void 0===target&&(console.warn("THREE.Box2: .getParameter() target is now required"),target=new Vector2),target.set((point.x-this.min.x)/(this.max.x-this.min.x),(point.y-this.min.y)/(this.max.y-this.min.y))},intersectsBox:function(box){return!(box.max.x<this.min.x||box.min.x>this.max.x||box.max.y<this.min.y||box.min.y>this.max.y)},clampPoint:function(point,target){return void 0===target&&(console.warn("THREE.Box2: .clampPoint() target is now required"),target=new Vector2),target.copy(point).clamp(this.min,this.max)},distanceToPoint:function(point){return _vector$7.copy(point).clamp(this.min,this.max).sub(point).length()},intersect:function(box){return this.min.max(box.min),this.max.min(box.max),this},union:function(box){return this.min.min(box.min),this.max.max(box.max),this},translate:function(offset){return this.min.add(offset),this.max.add(offset),this},equals:function(box){return box.min.equals(this.min)&&box.max.equals(this.max)}});const _startP=new Vector3,_startEnd=new Vector3;function Line3(start,end){this.start=void 0!==start?start:new Vector3,this.end=void 0!==end?end:new Vector3}function ImmediateRenderObject(material){Object3D.call(this),this.material=material,this.render=function(){},this.hasPositions=!1,this.hasNormals=!1,this.hasColors=!1,this.hasUvs=!1,this.positionArray=null,this.normalArray=null,this.colorArray=null,this.uvArray=null,this.count=0}Object.assign(Line3.prototype,{set:function(start,end){return this.start.copy(start),this.end.copy(end),this},clone:function(){return(new this.constructor).copy(this)},copy:function(line){return this.start.copy(line.start),this.end.copy(line.end),this},getCenter:function(target){return void 0===target&&(console.warn("THREE.Line3: .getCenter() target is now required"),target=new Vector3),target.addVectors(this.start,this.end).multiplyScalar(.5)},delta:function(target){return void 0===target&&(console.warn("THREE.Line3: .delta() target is now required"),target=new Vector3),target.subVectors(this.end,this.start)},distanceSq:function(){return this.start.distanceToSquared(this.end)},distance:function(){return this.start.distanceTo(this.end)},at:function(t,target){return void 0===target&&(console.warn("THREE.Line3: .at() target is now required"),target=new Vector3),this.delta(target).multiplyScalar(t).add(this.start)},closestPointToPointParameter:function(point,clampToLine){_startP.subVectors(point,this.start),_startEnd.subVectors(this.end,this.start);const startEnd2=_startEnd.dot(_startEnd);let t=_startEnd.dot(_startP)/startEnd2;return clampToLine&&(t=MathUtils.clamp(t,0,1)),t},closestPointToPoint:function(point,clampToLine,target){const t=this.closestPointToPointParameter(point,clampToLine);return void 0===target&&(console.warn("THREE.Line3: .closestPointToPoint() target is now required"),target=new Vector3),this.delta(target).multiplyScalar(t).add(this.start)},applyMatrix4:function(matrix){return this.start.applyMatrix4(matrix),this.end.applyMatrix4(matrix),this},equals:function(line){return line.start.equals(this.start)&&line.end.equals(this.end)}}),ImmediateRenderObject.prototype=Object.create(Object3D.prototype),ImmediateRenderObject.prototype.constructor=ImmediateRenderObject,ImmediateRenderObject.prototype.isImmediateRenderObject=!0;const _vector$8=new Vector3;function SpotLightHelper(light,color){Object3D.call(this),this.light=light,this.light.updateMatrixWorld(),this.matrix=light.matrixWorld,this.matrixAutoUpdate=!1,this.color=color;const geometry=new BufferGeometry,positions=[0,0,0,0,0,1,0,0,0,1,0,1,0,0,0,-1,0,1,0,0,0,0,1,1,0,0,0,0,-1,1];for(let i=0,j=1,l=32;i<l;i++,j++){const p1=i/l*Math.PI*2,p2=j/l*Math.PI*2;positions.push(Math.cos(p1),Math.sin(p1),1,Math.cos(p2),Math.sin(p2),1)}geometry.setAttribute("position",new Float32BufferAttribute(positions,3));const material=new LineBasicMaterial({fog:!1,toneMapped:!1});this.cone=new LineSegments(geometry,material),this.add(this.cone),this.update()}SpotLightHelper.prototype=Object.create(Object3D.prototype),SpotLightHelper.prototype.constructor=SpotLightHelper,SpotLightHelper.prototype.dispose=function(){this.cone.geometry.dispose(),this.cone.material.dispose()},SpotLightHelper.prototype.update=function(){this.light.updateMatrixWorld();const coneLength=this.light.distance?this.light.distance:1e3,coneWidth=coneLength*Math.tan(this.light.angle);this.cone.scale.set(coneWidth,coneWidth,coneLength),_vector$8.setFromMatrixPosition(this.light.target.matrixWorld),this.cone.lookAt(_vector$8),void 0!==this.color?this.cone.material.color.set(this.color):this.cone.material.color.copy(this.light.color)};const _vector$9=new Vector3,_boneMatrix=new Matrix4,_matrixWorldInv=new Matrix4;function SkeletonHelper(object){const bones=function getBoneList(object){const boneList=[];object&&object.isBone&&boneList.push(object);for(let i=0;i<object.children.length;i++)boneList.push.apply(boneList,getBoneList(object.children[i]));return boneList}(object),geometry=new BufferGeometry,vertices=[],colors=[],color1=new Color(0,0,1),color2=new Color(0,1,0);for(let i=0;i<bones.length;i++){const bone=bones[i];bone.parent&&bone.parent.isBone&&(vertices.push(0,0,0),vertices.push(0,0,0),colors.push(color1.r,color1.g,color1.b),colors.push(color2.r,color2.g,color2.b))}geometry.setAttribute("position",new Float32BufferAttribute(vertices,3)),geometry.setAttribute("color",new Float32BufferAttribute(colors,3));const material=new LineBasicMaterial({vertexColors:!0,depthTest:!1,depthWrite:!1,toneMapped:!1,transparent:!0});LineSegments.call(this,geometry,material),this.type="SkeletonHelper",this.root=object,this.bones=bones,this.matrix=object.matrixWorld,this.matrixAutoUpdate=!1}function PointLightHelper(light,sphereSize,color){this.light=light,this.light.updateMatrixWorld(),this.color=color;const geometry=new SphereBufferGeometry(sphereSize,4,2),material=new MeshBasicMaterial({wireframe:!0,fog:!1,toneMapped:!1});Mesh.call(this,geometry,material),this.type="PointLightHelper",this.matrix=this.light.matrixWorld,this.matrixAutoUpdate=!1,this.update()}SkeletonHelper.prototype=Object.create(LineSegments.prototype),SkeletonHelper.prototype.constructor=SkeletonHelper,SkeletonHelper.prototype.isSkeletonHelper=!0,SkeletonHelper.prototype.updateMatrixWorld=function(force){const bones=this.bones,geometry=this.geometry,position=geometry.getAttribute("position");_matrixWorldInv.getInverse(this.root.matrixWorld);for(let i=0,j=0;i<bones.length;i++){const bone=bones[i];bone.parent&&bone.parent.isBone&&(_boneMatrix.multiplyMatrices(_matrixWorldInv,bone.matrixWorld),_vector$9.setFromMatrixPosition(_boneMatrix),position.setXYZ(j,_vector$9.x,_vector$9.y,_vector$9.z),_boneMatrix.multiplyMatrices(_matrixWorldInv,bone.parent.matrixWorld),_vector$9.setFromMatrixPosition(_boneMatrix),position.setXYZ(j+1,_vector$9.x,_vector$9.y,_vector$9.z),j+=2)}geometry.getAttribute("position").needsUpdate=!0,Object3D.prototype.updateMatrixWorld.call(this,force)},PointLightHelper.prototype=Object.create(Mesh.prototype),PointLightHelper.prototype.constructor=PointLightHelper,PointLightHelper.prototype.dispose=function(){this.geometry.dispose(),this.material.dispose()},PointLightHelper.prototype.update=function(){void 0!==this.color?this.material.color.set(this.color):this.material.color.copy(this.light.color)};const _vector$a=new Vector3,_color1=new Color,_color2=new Color;function HemisphereLightHelper(light,size,color){Object3D.call(this),this.light=light,this.light.updateMatrixWorld(),this.matrix=light.matrixWorld,this.matrixAutoUpdate=!1,this.color=color;const geometry=new OctahedronBufferGeometry(size);geometry.rotateY(.5*Math.PI),this.material=new MeshBasicMaterial({wireframe:!0,fog:!1,toneMapped:!1}),void 0===this.color&&(this.material.vertexColors=!0);const position=geometry.getAttribute("position"),colors=new Float32Array(3*position.count);geometry.setAttribute("color",new BufferAttribute(colors,3)),this.add(new Mesh(geometry,this.material)),this.update()}function GridHelper(size,divisions,color1,color2){size=size||10,divisions=divisions||10,color1=new Color(void 0!==color1?color1:4473924),color2=new Color(void 0!==color2?color2:8947848);const center=divisions/2,step=size/divisions,halfSize=size/2,vertices=[],colors=[];for(let i=0,j=0,k=-halfSize;i<=divisions;i++,k+=step){vertices.push(-halfSize,0,k,halfSize,0,k),vertices.push(k,0,-halfSize,k,0,halfSize);const color=i===center?color1:color2;color.toArray(colors,j),j+=3,color.toArray(colors,j),j+=3,color.toArray(colors,j),j+=3,color.toArray(colors,j),j+=3}const geometry=new BufferGeometry;geometry.setAttribute("position",new Float32BufferAttribute(vertices,3)),geometry.setAttribute("color",new Float32BufferAttribute(colors,3));const material=new LineBasicMaterial({vertexColors:!0,toneMapped:!1});LineSegments.call(this,geometry,material),this.type="GridHelper"}function PolarGridHelper(radius,radials,circles,divisions,color1,color2){radius=radius||10,radials=radials||16,circles=circles||8,divisions=divisions||64,color1=new Color(void 0!==color1?color1:4473924),color2=new Color(void 0!==color2?color2:8947848);const vertices=[],colors=[];for(let i=0;i<=radials;i++){const v=i/radials*(2*Math.PI),x=Math.sin(v)*radius,z=Math.cos(v)*radius;vertices.push(0,0,0),vertices.push(x,0,z);const color=1&i?color1:color2;colors.push(color.r,color.g,color.b),colors.push(color.r,color.g,color.b)}for(let i=0;i<=circles;i++){const color=1&i?color1:color2,r=radius-radius/circles*i;for(let j=0;j<divisions;j++){let v=j/divisions*(2*Math.PI),x=Math.sin(v)*r,z=Math.cos(v)*r;vertices.push(x,0,z),colors.push(color.r,color.g,color.b),v=(j+1)/divisions*(2*Math.PI),x=Math.sin(v)*r,z=Math.cos(v)*r,vertices.push(x,0,z),colors.push(color.r,color.g,color.b)}}const geometry=new BufferGeometry;geometry.setAttribute("position",new Float32BufferAttribute(vertices,3)),geometry.setAttribute("color",new Float32BufferAttribute(colors,3));const material=new LineBasicMaterial({vertexColors:!0,toneMapped:!1});LineSegments.call(this,geometry,material),this.type="PolarGridHelper"}HemisphereLightHelper.prototype=Object.create(Object3D.prototype),HemisphereLightHelper.prototype.constructor=HemisphereLightHelper,HemisphereLightHelper.prototype.dispose=function(){this.children[0].geometry.dispose(),this.children[0].material.dispose()},HemisphereLightHelper.prototype.update=function(){const mesh=this.children[0];if(void 0!==this.color)this.material.color.set(this.color);else{const colors=mesh.geometry.getAttribute("color");_color1.copy(this.light.color),_color2.copy(this.light.groundColor);for(let i=0,l=colors.count;i<l;i++){const color=i<l/2?_color1:_color2;colors.setXYZ(i,color.r,color.g,color.b)}colors.needsUpdate=!0}mesh.lookAt(_vector$a.setFromMatrixPosition(this.light.matrixWorld).negate())},GridHelper.prototype=Object.create(LineSegments.prototype),GridHelper.prototype.constructor=GridHelper,PolarGridHelper.prototype=Object.create(LineSegments.prototype),PolarGridHelper.prototype.constructor=PolarGridHelper;const _v1$5=new Vector3,_v2$3=new Vector3,_v3$1=new Vector3;function DirectionalLightHelper(light,size,color){Object3D.call(this),this.light=light,this.light.updateMatrixWorld(),this.matrix=light.matrixWorld,this.matrixAutoUpdate=!1,this.color=color,void 0===size&&(size=1);let geometry=new BufferGeometry;geometry.setAttribute("position",new Float32BufferAttribute([-size,size,0,size,size,0,size,-size,0,-size,-size,0,-size,size,0],3));const material=new LineBasicMaterial({fog:!1,toneMapped:!1});this.lightPlane=new Line(geometry,material),this.add(this.lightPlane),geometry=new BufferGeometry,geometry.setAttribute("position",new Float32BufferAttribute([0,0,0,0,0,1],3)),this.targetLine=new Line(geometry,material),this.add(this.targetLine),this.update()}DirectionalLightHelper.prototype=Object.create(Object3D.prototype),DirectionalLightHelper.prototype.constructor=DirectionalLightHelper,DirectionalLightHelper.prototype.dispose=function(){this.lightPlane.geometry.dispose(),this.lightPlane.material.dispose(),this.targetLine.geometry.dispose(),this.targetLine.material.dispose()},DirectionalLightHelper.prototype.update=function(){_v1$5.setFromMatrixPosition(this.light.matrixWorld),_v2$3.setFromMatrixPosition(this.light.target.matrixWorld),_v3$1.subVectors(_v2$3,_v1$5),this.lightPlane.lookAt(_v2$3),void 0!==this.color?(this.lightPlane.material.color.set(this.color),this.targetLine.material.color.set(this.color)):(this.lightPlane.material.color.copy(this.light.color),this.targetLine.material.color.copy(this.light.color)),this.targetLine.lookAt(_v2$3),this.targetLine.scale.z=_v3$1.length()};const _vector$b=new Vector3,_camera=new Camera;function CameraHelper(camera){const geometry=new BufferGeometry,material=new LineBasicMaterial({color:16777215,vertexColors:!0,toneMapped:!1}),vertices=[],colors=[],pointMap={},colorFrustum=new Color(16755200),colorCone=new Color(16711680),colorUp=new Color(43775),colorTarget=new Color(16777215),colorCross=new Color(3355443);function addLine(a,b,color){addPoint(a,color),addPoint(b,color)}function addPoint(id,color){vertices.push(0,0,0),colors.push(color.r,color.g,color.b),void 0===pointMap[id]&&(pointMap[id]=[]),pointMap[id].push(vertices.length/3-1)}addLine("n1","n2",colorFrustum),addLine("n2","n4",colorFrustum),addLine("n4","n3",colorFrustum),addLine("n3","n1",colorFrustum),addLine("f1","f2",colorFrustum),addLine("f2","f4",colorFrustum),addLine("f4","f3",colorFrustum),addLine("f3","f1",colorFrustum),addLine("n1","f1",colorFrustum),addLine("n2","f2",colorFrustum),addLine("n3","f3",colorFrustum),addLine("n4","f4",colorFrustum),addLine("p","n1",colorCone),addLine("p","n2",colorCone),addLine("p","n3",colorCone),addLine("p","n4",colorCone),addLine("u1","u2",colorUp),addLine("u2","u3",colorUp),addLine("u3","u1",colorUp),addLine("c","t",colorTarget),addLine("p","c",colorCross),addLine("cn1","cn2",colorCross),addLine("cn3","cn4",colorCross),addLine("cf1","cf2",colorCross),addLine("cf3","cf4",colorCross),geometry.setAttribute("position",new Float32BufferAttribute(vertices,3)),geometry.setAttribute("color",new Float32BufferAttribute(colors,3)),LineSegments.call(this,geometry,material),this.type="CameraHelper",this.camera=camera,this.camera.updateProjectionMatrix&&this.camera.updateProjectionMatrix(),this.matrix=camera.matrixWorld,this.matrixAutoUpdate=!1,this.pointMap=pointMap,this.update()}function setPoint(point,pointMap,geometry,camera,x,y,z){_vector$b.set(x,y,z).unproject(camera);const points=pointMap[point];if(void 0!==points){const position=geometry.getAttribute("position");for(let i=0,l=points.length;i<l;i++)position.setXYZ(points[i],_vector$b.x,_vector$b.y,_vector$b.z)}}CameraHelper.prototype=Object.create(LineSegments.prototype),CameraHelper.prototype.constructor=CameraHelper,CameraHelper.prototype.update=function(){const geometry=this.geometry,pointMap=this.pointMap;_camera.projectionMatrixInverse.copy(this.camera.projectionMatrixInverse),setPoint("c",pointMap,geometry,_camera,0,0,-1),setPoint("t",pointMap,geometry,_camera,0,0,1),setPoint("n1",pointMap,geometry,_camera,-1,-1,-1),setPoint("n2",pointMap,geometry,_camera,1,-1,-1),setPoint("n3",pointMap,geometry,_camera,-1,1,-1),setPoint("n4",pointMap,geometry,_camera,1,1,-1),setPoint("f1",pointMap,geometry,_camera,-1,-1,1),setPoint("f2",pointMap,geometry,_camera,1,-1,1),setPoint("f3",pointMap,geometry,_camera,-1,1,1),setPoint("f4",pointMap,geometry,_camera,1,1,1),setPoint("u1",pointMap,geometry,_camera,.7,1.1,-1),setPoint("u2",pointMap,geometry,_camera,-.7,1.1,-1),setPoint("u3",pointMap,geometry,_camera,0,2,-1),setPoint("cf1",pointMap,geometry,_camera,-1,0,1),setPoint("cf2",pointMap,geometry,_camera,1,0,1),setPoint("cf3",pointMap,geometry,_camera,0,-1,1),setPoint("cf4",pointMap,geometry,_camera,0,1,1),setPoint("cn1",pointMap,geometry,_camera,-1,0,-1),setPoint("cn2",pointMap,geometry,_camera,1,0,-1),setPoint("cn3",pointMap,geometry,_camera,0,-1,-1),setPoint("cn4",pointMap,geometry,_camera,0,1,-1),geometry.getAttribute("position").needsUpdate=!0};const _box$3=new Box3;function BoxHelper(object,color){this.object=object,void 0===color&&(color=16776960);const indices=new Uint16Array([0,1,1,2,2,3,3,0,4,5,5,6,6,7,7,4,0,4,1,5,2,6,3,7]),positions=new Float32Array(24),geometry=new BufferGeometry;geometry.setIndex(new BufferAttribute(indices,1)),geometry.setAttribute("position",new BufferAttribute(positions,3)),LineSegments.call(this,geometry,new LineBasicMaterial({color,toneMapped:!1})),this.type="BoxHelper",this.matrixAutoUpdate=!1,this.update()}function Box3Helper(box,color){this.type="Box3Helper",this.box=box,void 0===color&&(color=16776960);const indices=new Uint16Array([0,1,1,2,2,3,3,0,4,5,5,6,6,7,7,4,0,4,1,5,2,6,3,7]),geometry=new BufferGeometry;geometry.setIndex(new BufferAttribute(indices,1)),geometry.setAttribute("position",new Float32BufferAttribute([1,1,1,-1,1,1,-1,-1,1,1,-1,1,1,1,-1,-1,1,-1,-1,-1,-1,1,-1,-1],3)),LineSegments.call(this,geometry,new LineBasicMaterial({color,toneMapped:!1})),this.type="Box3Helper",this.geometry.computeBoundingSphere()}function PlaneHelper(plane,size,hex){this.plane=plane,this.size=void 0===size?1:size;const color=void 0!==hex?hex:16776960,geometry=new BufferGeometry;geometry.setAttribute("position",new Float32BufferAttribute([1,-1,1,-1,1,1,-1,-1,1,1,1,1,-1,1,1,-1,-1,1,1,-1,1,1,1,1,0,0,1,0,0,0],3)),geometry.computeBoundingSphere(),Line.call(this,geometry,new LineBasicMaterial({color,toneMapped:!1})),this.type="PlaneHelper";const geometry2=new BufferGeometry;geometry2.setAttribute("position",new Float32BufferAttribute([1,1,1,-1,1,1,-1,-1,1,1,1,1,-1,-1,1,1,-1,1],3)),geometry2.computeBoundingSphere(),this.add(new Mesh(geometry2,new MeshBasicMaterial({color,opacity:.2,transparent:!0,depthWrite:!1,toneMapped:!1})))}BoxHelper.prototype=Object.create(LineSegments.prototype),BoxHelper.prototype.constructor=BoxHelper,BoxHelper.prototype.update=function(object){if(void 0!==object&&console.warn("THREE.BoxHelper: .update() has no longer arguments."),void 0!==this.object&&_box$3.setFromObject(this.object),_box$3.isEmpty())return;const min=_box$3.min,max=_box$3.max,position=this.geometry.attributes.position,array=position.array;array[0]=max.x,array[1]=max.y,array[2]=max.z,array[3]=min.x,array[4]=max.y,array[5]=max.z,array[6]=min.x,array[7]=min.y,array[8]=max.z,array[9]=max.x,array[10]=min.y,array[11]=max.z,array[12]=max.x,array[13]=max.y,array[14]=min.z,array[15]=min.x,array[16]=max.y,array[17]=min.z,array[18]=min.x,array[19]=min.y,array[20]=min.z,array[21]=max.x,array[22]=min.y,array[23]=min.z,position.needsUpdate=!0,this.geometry.computeBoundingSphere()},BoxHelper.prototype.setFromObject=function(object){return this.object=object,this.update(),this},BoxHelper.prototype.copy=function(source){return LineSegments.prototype.copy.call(this,source),this.object=source.object,this},Box3Helper.prototype=Object.create(LineSegments.prototype),Box3Helper.prototype.constructor=Box3Helper,Box3Helper.prototype.updateMatrixWorld=function(force){const box=this.box;box.isEmpty()||(box.getCenter(this.position),box.getSize(this.scale),this.scale.multiplyScalar(.5),Object3D.prototype.updateMatrixWorld.call(this,force))},PlaneHelper.prototype=Object.create(Line.prototype),PlaneHelper.prototype.constructor=PlaneHelper,PlaneHelper.prototype.updateMatrixWorld=function(force){let scale=-this.plane.constant;Math.abs(scale)<1e-8&&(scale=1e-8),this.scale.set(.5*this.size,.5*this.size,scale),this.children[0].material.side=scale<0?1:0,this.lookAt(this.plane.normal),Object3D.prototype.updateMatrixWorld.call(this,force)};const _axis=new Vector3;let _lineGeometry,_coneGeometry;function ArrowHelper(dir,origin,length,color,headLength,headWidth){Object3D.call(this),this.type="ArrowHelper",void 0===dir&&(dir=new Vector3(0,0,1)),void 0===origin&&(origin=new Vector3(0,0,0)),void 0===length&&(length=1),void 0===color&&(color=16776960),void 0===headLength&&(headLength=.2*length),void 0===headWidth&&(headWidth=.2*headLength),void 0===_lineGeometry&&(_lineGeometry=new BufferGeometry,_lineGeometry.setAttribute("position",new Float32BufferAttribute([0,0,0,0,1,0],3)),_coneGeometry=new CylinderBufferGeometry(0,.5,1,5,1),_coneGeometry.translate(0,-.5,0)),this.position.copy(origin),this.line=new Line(_lineGeometry,new LineBasicMaterial({color,toneMapped:!1})),this.line.matrixAutoUpdate=!1,this.add(this.line),this.cone=new Mesh(_coneGeometry,new MeshBasicMaterial({color,toneMapped:!1})),this.cone.matrixAutoUpdate=!1,this.add(this.cone),this.setDirection(dir),this.setLength(length,headLength,headWidth)}function AxesHelper(size){const vertices=[0,0,0,size=size||1,0,0,0,0,0,0,size,0,0,0,0,0,0,size],geometry=new BufferGeometry;geometry.setAttribute("position",new Float32BufferAttribute(vertices,3)),geometry.setAttribute("color",new Float32BufferAttribute([1,0,0,1,.6,0,0,1,0,.6,1,0,0,0,1,0,.6,1],3));const material=new LineBasicMaterial({vertexColors:!0,toneMapped:!1});LineSegments.call(this,geometry,material),this.type="AxesHelper"}ArrowHelper.prototype=Object.create(Object3D.prototype),ArrowHelper.prototype.constructor=ArrowHelper,ArrowHelper.prototype.setDirection=function(dir){if(dir.y>.99999)this.quaternion.set(0,0,0,1);else if(dir.y<-.99999)this.quaternion.set(1,0,0,0);else{_axis.set(dir.z,0,-dir.x).normalize();const radians=Math.acos(dir.y);this.quaternion.setFromAxisAngle(_axis,radians)}},ArrowHelper.prototype.setLength=function(length,headLength,headWidth){void 0===headLength&&(headLength=.2*length),void 0===headWidth&&(headWidth=.2*headLength),this.line.scale.set(1,Math.max(1e-4,length-headLength),1),this.line.updateMatrix(),this.cone.scale.set(headWidth,headLength,headWidth),this.cone.position.y=length,this.cone.updateMatrix()},ArrowHelper.prototype.setColor=function(color){this.line.material.color.set(color),this.cone.material.color.set(color)},ArrowHelper.prototype.copy=function(source){return Object3D.prototype.copy.call(this,source,!1),this.line.copy(source.line),this.cone.copy(source.cone),this},AxesHelper.prototype=Object.create(LineSegments.prototype),AxesHelper.prototype.constructor=AxesHelper;const SIZE_MAX=Math.pow(2,8),EXTRA_LOD_SIGMA=[.125,.215,.35,.446,.526,.582],TOTAL_LODS=5+EXTRA_LOD_SIGMA.length,ENCODINGS={3e3:0,3001:1,3002:2,3004:3,3005:4,3006:5,3007:6},_flatCamera=new OrthographicCamera,{_lodPlanes,_sizeLods,_sigmas}=function(){const _lodPlanes=[],_sizeLods=[],_sigmas=[];let lod=8;for(let i=0;i<TOTAL_LODS;i++){const sizeLod=Math.pow(2,lod);_sizeLods.push(sizeLod);let sigma=1/sizeLod;i>4?sigma=EXTRA_LOD_SIGMA[i-8+4-1]:0==i&&(sigma=0),_sigmas.push(sigma);const texelSize=1/(sizeLod-1),min=-texelSize/2,max=1+texelSize/2,uv1=[min,min,max,min,max,max,min,min,max,max,min,max],cubeFaces=6,vertices=6,positionSize=3,uvSize=2,faceIndexSize=1,position=new Float32Array(positionSize*vertices*cubeFaces),uv=new Float32Array(uvSize*vertices*cubeFaces),faceIndex=new Float32Array(faceIndexSize*vertices*cubeFaces);for(let face=0;face<cubeFaces;face++){const x=face%3*2/3-1,y=face>2?0:-1,coordinates=[x,y,0,x+2/3,y,0,x+2/3,y+1,0,x,y,0,x+2/3,y+1,0,x,y+1,0];position.set(coordinates,positionSize*vertices*face),uv.set(uv1,uvSize*vertices*face);const fill=[face,face,face,face,face,face];faceIndex.set(fill,faceIndexSize*vertices*face)}const planes=new BufferGeometry;planes.setAttribute("position",new BufferAttribute(position,positionSize)),planes.setAttribute("uv",new BufferAttribute(uv,uvSize)),planes.setAttribute("faceIndex",new BufferAttribute(faceIndex,faceIndexSize)),_lodPlanes.push(planes),lod>4&&lod--}return{_lodPlanes,_sizeLods,_sigmas}}();let _oldTarget=null;const PHI=(1+Math.sqrt(5))/2,INV_PHI=1/PHI,_axisDirections=[new Vector3(1,1,1),new Vector3(-1,1,1),new Vector3(1,1,-1),new Vector3(-1,1,-1),new Vector3(0,PHI,INV_PHI),new Vector3(0,PHI,-INV_PHI),new Vector3(INV_PHI,0,PHI),new Vector3(-INV_PHI,0,PHI),new Vector3(PHI,INV_PHI,0),new Vector3(-PHI,INV_PHI,0)];function PMREMGenerator(renderer){this._renderer=renderer,this._pingPongRenderTarget=null,this._blurMaterial=function(maxSamples){const weights=new Float32Array(maxSamples),poleAxis=new Vector3(0,1,0);return new RawShaderMaterial({name:"SphericalGaussianBlur",defines:{n:maxSamples},uniforms:{envMap:{value:null},samples:{value:1},weights:{value:weights},latitudinal:{value:!1},dTheta:{value:0},mipInt:{value:0},poleAxis:{value:poleAxis},inputEncoding:{value:ENCODINGS[3e3]},outputEncoding:{value:ENCODINGS[3e3]}},vertexShader:_getCommonVertexShader(),fragmentShader:`\n\n\t\t\tprecision mediump float;\n\t\t\tprecision mediump int;\n\n\t\t\tvarying vec3 vOutputDirection;\n\n\t\t\tuniform sampler2D envMap;\n\t\t\tuniform int samples;\n\t\t\tuniform float weights[ n ];\n\t\t\tuniform bool latitudinal;\n\t\t\tuniform float dTheta;\n\t\t\tuniform float mipInt;\n\t\t\tuniform vec3 poleAxis;\n\n\t\t\t${_getEncodings()}\n\n\t\t\t#define ENVMAP_TYPE_CUBE_UV\n\t\t\t#include <cube_uv_reflection_fragment>\n\n\t\t\tvec3 getSample( float theta, vec3 axis ) {\n\n\t\t\t\tfloat cosTheta = cos( theta );\n\t\t\t\t// Rodrigues' axis-angle rotation\n\t\t\t\tvec3 sampleDirection = vOutputDirection * cosTheta\n\t\t\t\t\t+ cross( axis, vOutputDirection ) * sin( theta )\n\t\t\t\t\t+ axis * dot( axis, vOutputDirection ) * ( 1.0 - cosTheta );\n\n\t\t\t\treturn bilinearCubeUV( envMap, sampleDirection, mipInt );\n\n\t\t\t}\n\n\t\t\tvoid main() {\n\n\t\t\t\tvec3 axis = latitudinal ? poleAxis : cross( poleAxis, vOutputDirection );\n\n\t\t\t\tif ( all( equal( axis, vec3( 0.0 ) ) ) ) {\n\n\t\t\t\t\taxis = vec3( vOutputDirection.z, 0.0, - vOutputDirection.x );\n\n\t\t\t\t}\n\n\t\t\t\taxis = normalize( axis );\n\n\t\t\t\tgl_FragColor = vec4( 0.0, 0.0, 0.0, 1.0 );\n\t\t\t\tgl_FragColor.rgb += weights[ 0 ] * getSample( 0.0, axis );\n\n\t\t\t\tfor ( int i = 1; i < n; i++ ) {\n\n\t\t\t\t\tif ( i >= samples ) {\n\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t}\n\n\t\t\t\t\tfloat theta = dTheta * float( i );\n\t\t\t\t\tgl_FragColor.rgb += weights[ i ] * getSample( -1.0 * theta, axis );\n\t\t\t\t\tgl_FragColor.rgb += weights[ i ] * getSample( theta, axis );\n\n\t\t\t\t}\n\n\t\t\t\tgl_FragColor = linearToOutputTexel( gl_FragColor );\n\n\t\t\t}\n\t\t`,blending:0,depthTest:!1,depthWrite:!1})}(20),this._equirectShader=null,this._cubemapShader=null,this._compileMaterial(this._blurMaterial)}function _isLDR(texture){return void 0!==texture&&1009===texture.type&&(3e3===texture.encoding||3001===texture.encoding||3007===texture.encoding)}function _createRenderTarget(params){const cubeUVRenderTarget=new WebGLRenderTarget(3*SIZE_MAX,3*SIZE_MAX,params);return cubeUVRenderTarget.texture.mapping=306,cubeUVRenderTarget.texture.name="PMREM.cubeUv",cubeUVRenderTarget.scissorTest=!0,cubeUVRenderTarget}function _setViewport(target,x,y,width,height){target.viewport.set(x,y,width,height),target.scissor.set(x,y,width,height)}function _getEquirectShader(){return new RawShaderMaterial({name:"EquirectangularToCubeUV",uniforms:{envMap:{value:null},texelSize:{value:new Vector2(1,1)},inputEncoding:{value:ENCODINGS[3e3]},outputEncoding:{value:ENCODINGS[3e3]}},vertexShader:_getCommonVertexShader(),fragmentShader:`\n\n\t\t\tprecision mediump float;\n\t\t\tprecision mediump int;\n\n\t\t\tvarying vec3 vOutputDirection;\n\n\t\t\tuniform sampler2D envMap;\n\t\t\tuniform vec2 texelSize;\n\n\t\t\t${_getEncodings()}\n\n\t\t\t#include <common>\n\n\t\t\tvoid main() {\n\n\t\t\t\tgl_FragColor = vec4( 0.0, 0.0, 0.0, 1.0 );\n\n\t\t\t\tvec3 outputDirection = normalize( vOutputDirection );\n\t\t\t\tvec2 uv = equirectUv( outputDirection );\n\n\t\t\t\tvec2 f = fract( uv / texelSize - 0.5 );\n\t\t\t\tuv -= f * texelSize;\n\t\t\t\tvec3 tl = envMapTexelToLinear( texture2D ( envMap, uv ) ).rgb;\n\t\t\t\tuv.x += texelSize.x;\n\t\t\t\tvec3 tr = envMapTexelToLinear( texture2D ( envMap, uv ) ).rgb;\n\t\t\t\tuv.y += texelSize.y;\n\t\t\t\tvec3 br = envMapTexelToLinear( texture2D ( envMap, uv ) ).rgb;\n\t\t\t\tuv.x -= texelSize.x;\n\t\t\t\tvec3 bl = envMapTexelToLinear( texture2D ( envMap, uv ) ).rgb;\n\n\t\t\t\tvec3 tm = mix( tl, tr, f.x );\n\t\t\t\tvec3 bm = mix( bl, br, f.x );\n\t\t\t\tgl_FragColor.rgb = mix( tm, bm, f.y );\n\n\t\t\t\tgl_FragColor = linearToOutputTexel( gl_FragColor );\n\n\t\t\t}\n\t\t`,blending:0,depthTest:!1,depthWrite:!1})}function _getCubemapShader(){return new RawShaderMaterial({name:"CubemapToCubeUV",uniforms:{envMap:{value:null},inputEncoding:{value:ENCODINGS[3e3]},outputEncoding:{value:ENCODINGS[3e3]}},vertexShader:_getCommonVertexShader(),fragmentShader:`\n\n\t\t\tprecision mediump float;\n\t\t\tprecision mediump int;\n\n\t\t\tvarying vec3 vOutputDirection;\n\n\t\t\tuniform samplerCube envMap;\n\n\t\t\t${_getEncodings()}\n\n\t\t\tvoid main() {\n\n\t\t\t\tgl_FragColor = vec4( 0.0, 0.0, 0.0, 1.0 );\n\t\t\t\tgl_FragColor.rgb = envMapTexelToLinear( textureCube( envMap, vec3( - vOutputDirection.x, vOutputDirection.yz ) ) ).rgb;\n\t\t\t\tgl_FragColor = linearToOutputTexel( gl_FragColor );\n\n\t\t\t}\n\t\t`,blending:0,depthTest:!1,depthWrite:!1})}function _getCommonVertexShader(){return"\n\n\t\tprecision mediump float;\n\t\tprecision mediump int;\n\n\t\tattribute vec3 position;\n\t\tattribute vec2 uv;\n\t\tattribute float faceIndex;\n\n\t\tvarying vec3 vOutputDirection;\n\n\t\t// RH coordinate system; PMREM face-indexing convention\n\t\tvec3 getDirection( vec2 uv, float face ) {\n\n\t\t\tuv = 2.0 * uv - 1.0;\n\n\t\t\tvec3 direction = vec3( uv, 1.0 );\n\n\t\t\tif ( face == 0.0 ) {\n\n\t\t\t\tdirection = direction.zyx; // ( 1, v, u ) pos x\n\n\t\t\t} else if ( face == 1.0 ) {\n\n\t\t\t\tdirection = direction.xzy;\n\t\t\t\tdirection.xz *= -1.0; // ( -u, 1, -v ) pos y\n\n\t\t\t} else if ( face == 2.0 ) {\n\n\t\t\t\tdirection.x *= -1.0; // ( -u, v, 1 ) pos z\n\n\t\t\t} else if ( face == 3.0 ) {\n\n\t\t\t\tdirection = direction.zyx;\n\t\t\t\tdirection.xz *= -1.0; // ( -1, v, -u ) neg x\n\n\t\t\t} else if ( face == 4.0 ) {\n\n\t\t\t\tdirection = direction.xzy;\n\t\t\t\tdirection.xy *= -1.0; // ( -u, -1, v ) neg y\n\n\t\t\t} else if ( face == 5.0 ) {\n\n\t\t\t\tdirection.z *= -1.0; // ( u, v, -1 ) neg z\n\n\t\t\t}\n\n\t\t\treturn direction;\n\n\t\t}\n\n\t\tvoid main() {\n\n\t\t\tvOutputDirection = getDirection( uv, faceIndex );\n\t\t\tgl_Position = vec4( position, 1.0 );\n\n\t\t}\n\t"}function _getEncodings(){return"\n\n\t\tuniform int inputEncoding;\n\t\tuniform int outputEncoding;\n\n\t\t#include <encodings_pars_fragment>\n\n\t\tvec4 inputTexelToLinear( vec4 value ) {\n\n\t\t\tif ( inputEncoding == 0 ) {\n\n\t\t\t\treturn value;\n\n\t\t\t} else if ( inputEncoding == 1 ) {\n\n\t\t\t\treturn sRGBToLinear( value );\n\n\t\t\t} else if ( inputEncoding == 2 ) {\n\n\t\t\t\treturn RGBEToLinear( value );\n\n\t\t\t} else if ( inputEncoding == 3 ) {\n\n\t\t\t\treturn RGBMToLinear( value, 7.0 );\n\n\t\t\t} else if ( inputEncoding == 4 ) {\n\n\t\t\t\treturn RGBMToLinear( value, 16.0 );\n\n\t\t\t} else if ( inputEncoding == 5 ) {\n\n\t\t\t\treturn RGBDToLinear( value, 256.0 );\n\n\t\t\t} else {\n\n\t\t\t\treturn GammaToLinear( value, 2.2 );\n\n\t\t\t}\n\n\t\t}\n\n\t\tvec4 linearToOutputTexel( vec4 value ) {\n\n\t\t\tif ( outputEncoding == 0 ) {\n\n\t\t\t\treturn value;\n\n\t\t\t} else if ( outputEncoding == 1 ) {\n\n\t\t\t\treturn LinearTosRGB( value );\n\n\t\t\t} else if ( outputEncoding == 2 ) {\n\n\t\t\t\treturn LinearToRGBE( value );\n\n\t\t\t} else if ( outputEncoding == 3 ) {\n\n\t\t\t\treturn LinearToRGBM( value, 7.0 );\n\n\t\t\t} else if ( outputEncoding == 4 ) {\n\n\t\t\t\treturn LinearToRGBM( value, 16.0 );\n\n\t\t\t} else if ( outputEncoding == 5 ) {\n\n\t\t\t\treturn LinearToRGBD( value, 256.0 );\n\n\t\t\t} else {\n\n\t\t\t\treturn LinearToGamma( value, 2.2 );\n\n\t\t\t}\n\n\t\t}\n\n\t\tvec4 envMapTexelToLinear( vec4 color ) {\n\n\t\t\treturn inputTexelToLinear( color );\n\n\t\t}\n\t"}PMREMGenerator.prototype={constructor:PMREMGenerator,fromScene:function(scene,sigma=0,near=.1,far=100){_oldTarget=this._renderer.getRenderTarget();const cubeUVRenderTarget=this._allocateTargets();return this._sceneToCubeUV(scene,near,far,cubeUVRenderTarget),sigma>0&&this._blur(cubeUVRenderTarget,0,0,sigma),this._applyPMREM(cubeUVRenderTarget),this._cleanup(cubeUVRenderTarget),cubeUVRenderTarget},fromEquirectangular:function(equirectangular){return this._fromTexture(equirectangular)},fromCubemap:function(cubemap){return this._fromTexture(cubemap)},compileCubemapShader:function(){null===this._cubemapShader&&(this._cubemapShader=_getCubemapShader(),this._compileMaterial(this._cubemapShader))},compileEquirectangularShader:function(){null===this._equirectShader&&(this._equirectShader=_getEquirectShader(),this._compileMaterial(this._equirectShader))},dispose:function(){this._blurMaterial.dispose(),null!==this._cubemapShader&&this._cubemapShader.dispose(),null!==this._equirectShader&&this._equirectShader.dispose();for(let i=0;i<_lodPlanes.length;i++)_lodPlanes[i].dispose()},_cleanup:function(outputTarget){this._pingPongRenderTarget.dispose(),this._renderer.setRenderTarget(_oldTarget),outputTarget.scissorTest=!1,_setViewport(outputTarget,0,0,outputTarget.width,outputTarget.height)},_fromTexture:function(texture){_oldTarget=this._renderer.getRenderTarget();const cubeUVRenderTarget=this._allocateTargets(texture);return this._textureToCubeUV(texture,cubeUVRenderTarget),this._applyPMREM(cubeUVRenderTarget),this._cleanup(cubeUVRenderTarget),cubeUVRenderTarget},_allocateTargets:function(texture){const params={magFilter:1003,minFilter:1003,generateMipmaps:!1,type:1009,format:1023,encoding:_isLDR(texture)?texture.encoding:3002,depthBuffer:!1,stencilBuffer:!1},cubeUVRenderTarget=_createRenderTarget(params);return cubeUVRenderTarget.depthBuffer=!texture,this._pingPongRenderTarget=_createRenderTarget(params),cubeUVRenderTarget},_compileMaterial:function(material){const tmpMesh=new Mesh(_lodPlanes[0],material);this._renderer.compile(tmpMesh,_flatCamera)},_sceneToCubeUV:function(scene,near,far,cubeUVRenderTarget){const cubeCamera=new PerspectiveCamera(90,1,near,far),upSign=[1,-1,1,1,1,1],forwardSign=[1,1,1,-1,-1,-1],renderer=this._renderer,outputEncoding=renderer.outputEncoding,toneMapping=renderer.toneMapping,clearColor=renderer.getClearColor(),clearAlpha=renderer.getClearAlpha();renderer.toneMapping=0,renderer.outputEncoding=3e3;let background=scene.background;if(background&&background.isColor){background.convertSRGBToLinear();const maxComponent=Math.max(background.r,background.g,background.b),fExp=Math.min(Math.max(Math.ceil(Math.log2(maxComponent)),-128),127);background=background.multiplyScalar(Math.pow(2,-fExp));const alpha=(fExp+128)/255;renderer.setClearColor(background,alpha),scene.background=null}for(let i=0;i<6;i++){const col=i%3;0==col?(cubeCamera.up.set(0,upSign[i],0),cubeCamera.lookAt(forwardSign[i],0,0)):1==col?(cubeCamera.up.set(0,0,upSign[i]),cubeCamera.lookAt(0,forwardSign[i],0)):(cubeCamera.up.set(0,upSign[i],0),cubeCamera.lookAt(0,0,forwardSign[i])),_setViewport(cubeUVRenderTarget,col*SIZE_MAX,i>2?SIZE_MAX:0,SIZE_MAX,SIZE_MAX),renderer.setRenderTarget(cubeUVRenderTarget),renderer.render(scene,cubeCamera)}renderer.toneMapping=toneMapping,renderer.outputEncoding=outputEncoding,renderer.setClearColor(clearColor,clearAlpha)},_textureToCubeUV:function(texture,cubeUVRenderTarget){const renderer=this._renderer;texture.isCubeTexture?null==this._cubemapShader&&(this._cubemapShader=_getCubemapShader()):null==this._equirectShader&&(this._equirectShader=_getEquirectShader());const material=texture.isCubeTexture?this._cubemapShader:this._equirectShader,mesh=new Mesh(_lodPlanes[0],material),uniforms=material.uniforms;uniforms.envMap.value=texture,texture.isCubeTexture||uniforms.texelSize.value.set(1/texture.image.width,1/texture.image.height),uniforms.inputEncoding.value=ENCODINGS[texture.encoding],uniforms.outputEncoding.value=ENCODINGS[cubeUVRenderTarget.texture.encoding],_setViewport(cubeUVRenderTarget,0,0,3*SIZE_MAX,2*SIZE_MAX),renderer.setRenderTarget(cubeUVRenderTarget),renderer.render(mesh,_flatCamera)},_applyPMREM:function(cubeUVRenderTarget){const renderer=this._renderer,autoClear=renderer.autoClear;renderer.autoClear=!1;for(let i=1;i<TOTAL_LODS;i++){const sigma=Math.sqrt(_sigmas[i]*_sigmas[i]-_sigmas[i-1]*_sigmas[i-1]),poleAxis=_axisDirections[(i-1)%_axisDirections.length];this._blur(cubeUVRenderTarget,i-1,i,sigma,poleAxis)}renderer.autoClear=autoClear},_blur:function(cubeUVRenderTarget,lodIn,lodOut,sigma,poleAxis){const pingPongRenderTarget=this._pingPongRenderTarget;this._halfBlur(cubeUVRenderTarget,pingPongRenderTarget,lodIn,lodOut,sigma,"latitudinal",poleAxis),this._halfBlur(pingPongRenderTarget,cubeUVRenderTarget,lodOut,lodOut,sigma,"longitudinal",poleAxis)},_halfBlur:function(targetIn,targetOut,lodIn,lodOut,sigmaRadians,direction,poleAxis){const renderer=this._renderer,blurMaterial=this._blurMaterial;"latitudinal"!==direction&&"longitudinal"!==direction&&console.error("blur direction must be either latitudinal or longitudinal!");const blurMesh=new Mesh(_lodPlanes[lodOut],blurMaterial),blurUniforms=blurMaterial.uniforms,pixels=_sizeLods[lodIn]-1,radiansPerPixel=isFinite(sigmaRadians)?Math.PI/(2*pixels):2*Math.PI/39,sigmaPixels=sigmaRadians/radiansPerPixel,samples=isFinite(sigmaRadians)?1+Math.floor(3*sigmaPixels):20;samples>20&&console.warn(`sigmaRadians, ${sigmaRadians}, is too large and will clip, as it requested ${samples} samples when the maximum is set to 20`);const weights=[];let sum=0;for(let i=0;i<20;++i){const x=i/sigmaPixels,weight=Math.exp(-x*x/2);weights.push(weight),0==i?sum+=weight:i<samples&&(sum+=2*weight)}for(let i=0;i<weights.length;i++)weights[i]=weights[i]/sum;blurUniforms.envMap.value=targetIn.texture,blurUniforms.samples.value=samples,blurUniforms.weights.value=weights,blurUniforms.latitudinal.value="latitudinal"===direction,poleAxis&&(blurUniforms.poleAxis.value=poleAxis),blurUniforms.dTheta.value=radiansPerPixel,blurUniforms.mipInt.value=8-lodIn,blurUniforms.inputEncoding.value=ENCODINGS[targetIn.texture.encoding],blurUniforms.outputEncoding.value=ENCODINGS[targetIn.texture.encoding];const outputSize=_sizeLods[lodOut];_setViewport(targetOut,3*Math.max(0,SIZE_MAX-2*outputSize),(0===lodOut?0:2*SIZE_MAX)+2*outputSize*(lodOut>4?lodOut-8+4:0),3*outputSize,2*outputSize),renderer.setRenderTarget(targetOut),renderer.render(blurMesh,_flatCamera)}};function Spline(points){console.warn("THREE.Spline has been removed. Use THREE.CatmullRomCurve3 instead."),CatmullRomCurve3.call(this,points),this.type="catmullrom"}Curve.create=function(construct,getPoint){return console.log("THREE.Curve.create() has been deprecated"),construct.prototype=Object.create(Curve.prototype),construct.prototype.constructor=construct,construct.prototype.getPoint=getPoint,construct},Object.assign(CurvePath.prototype,{createPointsGeometry:function(divisions){console.warn("THREE.CurvePath: .createPointsGeometry() has been removed. Use new THREE.Geometry().setFromPoints( points ) instead.");const pts=this.getPoints(divisions);return this.createGeometry(pts)},createSpacedPointsGeometry:function(divisions){console.warn("THREE.CurvePath: .createSpacedPointsGeometry() has been removed. Use new THREE.Geometry().setFromPoints( points ) instead.");const pts=this.getSpacedPoints(divisions);return this.createGeometry(pts)},createGeometry:function(points){console.warn("THREE.CurvePath: .createGeometry() has been removed. Use new THREE.Geometry().setFromPoints( points ) instead.");const geometry=new Geometry;for(let i=0,l=points.length;i<l;i++){const point=points[i];geometry.vertices.push(new Vector3(point.x,point.y,point.z||0))}return geometry}}),Object.assign(Path.prototype,{fromPoints:function(points){return console.warn("THREE.Path: .fromPoints() has been renamed to .setFromPoints()."),this.setFromPoints(points)}}),Object.create(CatmullRomCurve3.prototype),Object.create(CatmullRomCurve3.prototype),Spline.prototype=Object.create(CatmullRomCurve3.prototype),Object.assign(Spline.prototype,{initFromArray:function(){console.error("THREE.Spline: .initFromArray() has been removed.")},getControlPointsArray:function(){console.error("THREE.Spline: .getControlPointsArray() has been removed.")},reparametrizeByArcLength:function(){console.error("THREE.Spline: .reparametrizeByArcLength() has been removed.")}}),GridHelper.prototype.setColors=function(){console.error("THREE.GridHelper: setColors() has been deprecated, pass them in the constructor instead.")},SkeletonHelper.prototype.update=function(){console.error("THREE.SkeletonHelper: update() no longer needs to be called.")},Object.assign(Loader.prototype,{extractUrlBase:function(url){return console.warn("THREE.Loader: .extractUrlBase() has been deprecated. Use THREE.LoaderUtils.extractUrlBase() instead."),LoaderUtils_extractUrlBase(url)}}),Loader.Handlers={add:function(){console.error("THREE.Loader: Handlers.add() has been removed. Use LoadingManager.addHandler() instead.")},get:function(){console.error("THREE.Loader: Handlers.get() has been removed. Use LoadingManager.getHandler() instead.")}},Object.assign(ObjectLoader.prototype,{setTexturePath:function(value){return console.warn("THREE.ObjectLoader: .setTexturePath() has been renamed to .setResourcePath()."),this.setResourcePath(value)}}),Object.assign(Box2.prototype,{center:function(optionalTarget){return console.warn("THREE.Box2: .center() has been renamed to .getCenter()."),this.getCenter(optionalTarget)},empty:function(){return console.warn("THREE.Box2: .empty() has been renamed to .isEmpty()."),this.isEmpty()},isIntersectionBox:function(box){return console.warn("THREE.Box2: .isIntersectionBox() has been renamed to .intersectsBox()."),this.intersectsBox(box)},size:function(optionalTarget){return console.warn("THREE.Box2: .size() has been renamed to .getSize()."),this.getSize(optionalTarget)}}),Object.assign(Box3.prototype,{center:function(optionalTarget){return console.warn("THREE.Box3: .center() has been renamed to .getCenter()."),this.getCenter(optionalTarget)},empty:function(){return console.warn("THREE.Box3: .empty() has been renamed to .isEmpty()."),this.isEmpty()},isIntersectionBox:function(box){return console.warn("THREE.Box3: .isIntersectionBox() has been renamed to .intersectsBox()."),this.intersectsBox(box)},isIntersectionSphere:function(sphere){return console.warn("THREE.Box3: .isIntersectionSphere() has been renamed to .intersectsSphere()."),this.intersectsSphere(sphere)},size:function(optionalTarget){return console.warn("THREE.Box3: .size() has been renamed to .getSize()."),this.getSize(optionalTarget)}}),Object.assign(Sphere.prototype,{empty:function(){return console.warn("THREE.Sphere: .empty() has been renamed to .isEmpty()."),this.isEmpty()}}),Frustum.prototype.setFromMatrix=function(m){return console.warn("THREE.Frustum: .setFromMatrix() has been renamed to .setFromProjectionMatrix()."),this.setFromProjectionMatrix(m)},Line3.prototype.center=function(optionalTarget){return console.warn("THREE.Line3: .center() has been renamed to .getCenter()."),this.getCenter(optionalTarget)},Object.assign(MathUtils,{random16:function(){return console.warn("THREE.Math: .random16() has been deprecated. Use Math.random() instead."),Math.random()},nearestPowerOfTwo:function(value){return console.warn("THREE.Math: .nearestPowerOfTwo() has been renamed to .floorPowerOfTwo()."),MathUtils.floorPowerOfTwo(value)},nextPowerOfTwo:function(value){return console.warn("THREE.Math: .nextPowerOfTwo() has been renamed to .ceilPowerOfTwo()."),MathUtils.ceilPowerOfTwo(value)}}),Object.assign(Matrix3.prototype,{flattenToArrayOffset:function(array,offset){return console.warn("THREE.Matrix3: .flattenToArrayOffset() has been deprecated. Use .toArray() instead."),this.toArray(array,offset)},multiplyVector3:function(vector){return console.warn("THREE.Matrix3: .multiplyVector3() has been removed. Use vector.applyMatrix3( matrix ) instead."),vector.applyMatrix3(this)},multiplyVector3Array:function(){console.error("THREE.Matrix3: .multiplyVector3Array() has been removed.")},applyToBufferAttribute:function(attribute){return console.warn("THREE.Matrix3: .applyToBufferAttribute() has been removed. Use attribute.applyMatrix3( matrix ) instead."),attribute.applyMatrix3(this)},applyToVector3Array:function(){console.error("THREE.Matrix3: .applyToVector3Array() has been removed.")}}),Object.assign(Matrix4.prototype,{extractPosition:function(m){return console.warn("THREE.Matrix4: .extractPosition() has been renamed to .copyPosition()."),this.copyPosition(m)},flattenToArrayOffset:function(array,offset){return console.warn("THREE.Matrix4: .flattenToArrayOffset() has been deprecated. Use .toArray() instead."),this.toArray(array,offset)},getPosition:function(){return console.warn("THREE.Matrix4: .getPosition() has been removed. Use Vector3.setFromMatrixPosition( matrix ) instead."),(new Vector3).setFromMatrixColumn(this,3)},setRotationFromQuaternion:function(q){return console.warn("THREE.Matrix4: .setRotationFromQuaternion() has been renamed to .makeRotationFromQuaternion()."),this.makeRotationFromQuaternion(q)},multiplyToArray:function(){console.warn("THREE.Matrix4: .multiplyToArray() has been removed.")},multiplyVector3:function(vector){return console.warn("THREE.Matrix4: .multiplyVector3() has been removed. Use vector.applyMatrix4( matrix ) instead."),vector.applyMatrix4(this)},multiplyVector4:function(vector){return console.warn("THREE.Matrix4: .multiplyVector4() has been removed. Use vector.applyMatrix4( matrix ) instead."),vector.applyMatrix4(this)},multiplyVector3Array:function(){console.error("THREE.Matrix4: .multiplyVector3Array() has been removed.")},rotateAxis:function(v){console.warn("THREE.Matrix4: .rotateAxis() has been removed. Use Vector3.transformDirection( matrix ) instead."),v.transformDirection(this)},crossVector:function(vector){return console.warn("THREE.Matrix4: .crossVector() has been removed. Use vector.applyMatrix4( matrix ) instead."),vector.applyMatrix4(this)},translate:function(){console.error("THREE.Matrix4: .translate() has been removed.")},rotateX:function(){console.error("THREE.Matrix4: .rotateX() has been removed.")},rotateY:function(){console.error("THREE.Matrix4: .rotateY() has been removed.")},rotateZ:function(){console.error("THREE.Matrix4: .rotateZ() has been removed.")},rotateByAxis:function(){console.error("THREE.Matrix4: .rotateByAxis() has been removed.")},applyToBufferAttribute:function(attribute){return console.warn("THREE.Matrix4: .applyToBufferAttribute() has been removed. Use attribute.applyMatrix4( matrix ) instead."),attribute.applyMatrix4(this)},applyToVector3Array:function(){console.error("THREE.Matrix4: .applyToVector3Array() has been removed.")},makeFrustum:function(left,right,bottom,top,near,far){return console.warn("THREE.Matrix4: .makeFrustum() has been removed. Use .makePerspective( left, right, top, bottom, near, far ) instead."),this.makePerspective(left,right,top,bottom,near,far)}}),Plane.prototype.isIntersectionLine=function(line){return console.warn("THREE.Plane: .isIntersectionLine() has been renamed to .intersectsLine()."),this.intersectsLine(line)},Quaternion.prototype.multiplyVector3=function(vector){return console.warn("THREE.Quaternion: .multiplyVector3() has been removed. Use is now vector.applyQuaternion( quaternion ) instead."),vector.applyQuaternion(this)},Object.assign(Ray.prototype,{isIntersectionBox:function(box){return console.warn("THREE.Ray: .isIntersectionBox() has been renamed to .intersectsBox()."),this.intersectsBox(box)},isIntersectionPlane:function(plane){return console.warn("THREE.Ray: .isIntersectionPlane() has been renamed to .intersectsPlane()."),this.intersectsPlane(plane)},isIntersectionSphere:function(sphere){return console.warn("THREE.Ray: .isIntersectionSphere() has been renamed to .intersectsSphere()."),this.intersectsSphere(sphere)}}),Object.assign(Triangle.prototype,{area:function(){return console.warn("THREE.Triangle: .area() has been renamed to .getArea()."),this.getArea()},barycoordFromPoint:function(point,target){return console.warn("THREE.Triangle: .barycoordFromPoint() has been renamed to .getBarycoord()."),this.getBarycoord(point,target)},midpoint:function(target){return console.warn("THREE.Triangle: .midpoint() has been renamed to .getMidpoint()."),this.getMidpoint(target)},normal:function(target){return console.warn("THREE.Triangle: .normal() has been renamed to .getNormal()."),this.getNormal(target)},plane:function(target){return console.warn("THREE.Triangle: .plane() has been renamed to .getPlane()."),this.getPlane(target)}}),Object.assign(Triangle,{barycoordFromPoint:function(point,a,b,c,target){return console.warn("THREE.Triangle: .barycoordFromPoint() has been renamed to .getBarycoord()."),Triangle.getBarycoord(point,a,b,c,target)},normal:function(a,b,c,target){return console.warn("THREE.Triangle: .normal() has been renamed to .getNormal()."),Triangle.getNormal(a,b,c,target)}}),Object.assign(Shape.prototype,{extractAllPoints:function(divisions){return console.warn("THREE.Shape: .extractAllPoints() has been removed. Use .extractPoints() instead."),this.extractPoints(divisions)},extrude:function(options){return console.warn("THREE.Shape: .extrude() has been removed. Use ExtrudeGeometry() instead."),new ExtrudeGeometry(this,options)},makeGeometry:function(options){return console.warn("THREE.Shape: .makeGeometry() has been removed. Use ShapeGeometry() instead."),new ShapeGeometry(this,options)}}),Object.assign(Vector2.prototype,{fromAttribute:function(attribute,index,offset){return console.warn("THREE.Vector2: .fromAttribute() has been renamed to .fromBufferAttribute()."),this.fromBufferAttribute(attribute,index,offset)},distanceToManhattan:function(v){return console.warn("THREE.Vector2: .distanceToManhattan() has been renamed to .manhattanDistanceTo()."),this.manhattanDistanceTo(v)},lengthManhattan:function(){return console.warn("THREE.Vector2: .lengthManhattan() has been renamed to .manhattanLength()."),this.manhattanLength()}}),Object.assign(Vector3.prototype,{setEulerFromRotationMatrix:function(){console.error("THREE.Vector3: .setEulerFromRotationMatrix() has been removed. Use Euler.setFromRotationMatrix() instead.")},setEulerFromQuaternion:function(){console.error("THREE.Vector3: .setEulerFromQuaternion() has been removed. Use Euler.setFromQuaternion() instead.")},getPositionFromMatrix:function(m){return console.warn("THREE.Vector3: .getPositionFromMatrix() has been renamed to .setFromMatrixPosition()."),this.setFromMatrixPosition(m)},getScaleFromMatrix:function(m){return console.warn("THREE.Vector3: .getScaleFromMatrix() has been renamed to .setFromMatrixScale()."),this.setFromMatrixScale(m)},getColumnFromMatrix:function(index,matrix){return console.warn("THREE.Vector3: .getColumnFromMatrix() has been renamed to .setFromMatrixColumn()."),this.setFromMatrixColumn(matrix,index)},applyProjection:function(m){return console.warn("THREE.Vector3: .applyProjection() has been removed. Use .applyMatrix4( m ) instead."),this.applyMatrix4(m)},fromAttribute:function(attribute,index,offset){return console.warn("THREE.Vector3: .fromAttribute() has been renamed to .fromBufferAttribute()."),this.fromBufferAttribute(attribute,index,offset)},distanceToManhattan:function(v){return console.warn("THREE.Vector3: .distanceToManhattan() has been renamed to .manhattanDistanceTo()."),this.manhattanDistanceTo(v)},lengthManhattan:function(){return console.warn("THREE.Vector3: .lengthManhattan() has been renamed to .manhattanLength()."),this.manhattanLength()}}),Object.assign(Vector4.prototype,{fromAttribute:function(attribute,index,offset){return console.warn("THREE.Vector4: .fromAttribute() has been renamed to .fromBufferAttribute()."),this.fromBufferAttribute(attribute,index,offset)},lengthManhattan:function(){return console.warn("THREE.Vector4: .lengthManhattan() has been renamed to .manhattanLength()."),this.manhattanLength()}}),Object.assign(Geometry.prototype,{computeTangents:function(){console.error("THREE.Geometry: .computeTangents() has been removed.")},computeLineDistances:function(){console.error("THREE.Geometry: .computeLineDistances() has been removed. Use THREE.Line.computeLineDistances() instead.")},applyMatrix:function(matrix){return console.warn("THREE.Geometry: .applyMatrix() has been renamed to .applyMatrix4()."),this.applyMatrix4(matrix)}}),Object.assign(Object3D.prototype,{getChildByName:function(name){return console.warn("THREE.Object3D: .getChildByName() has been renamed to .getObjectByName()."),this.getObjectByName(name)},renderDepth:function(){console.warn("THREE.Object3D: .renderDepth has been removed. Use .renderOrder, instead.")},translate:function(distance,axis){return console.warn("THREE.Object3D: .translate() has been removed. Use .translateOnAxis( axis, distance ) instead."),this.translateOnAxis(axis,distance)},getWorldRotation:function(){console.error("THREE.Object3D: .getWorldRotation() has been removed. Use THREE.Object3D.getWorldQuaternion( target ) instead.")},applyMatrix:function(matrix){return console.warn("THREE.Object3D: .applyMatrix() has been renamed to .applyMatrix4()."),this.applyMatrix4(matrix)}}),Object.defineProperties(Object3D.prototype,{eulerOrder:{get:function(){return console.warn("THREE.Object3D: .eulerOrder is now .rotation.order."),this.rotation.order},set:function(value){console.warn("THREE.Object3D: .eulerOrder is now .rotation.order."),this.rotation.order=value}},useQuaternion:{get:function(){console.warn("THREE.Object3D: .useQuaternion has been removed. The library now uses quaternions by default.")},set:function(){console.warn("THREE.Object3D: .useQuaternion has been removed. The library now uses quaternions by default.")}}}),Object.assign(Mesh.prototype,{setDrawMode:function(){console.error("THREE.Mesh: .setDrawMode() has been removed. The renderer now always assumes THREE.TrianglesDrawMode. Transform your geometry via BufferGeometryUtils.toTrianglesDrawMode() if necessary.")}}),Object.defineProperties(Mesh.prototype,{drawMode:{get:function(){return console.error("THREE.Mesh: .drawMode has been removed. The renderer now always assumes THREE.TrianglesDrawMode."),0},set:function(){console.error("THREE.Mesh: .drawMode has been removed. The renderer now always assumes THREE.TrianglesDrawMode. Transform your geometry via BufferGeometryUtils.toTrianglesDrawMode() if necessary.")}}}),Object.defineProperties(LOD.prototype,{objects:{get:function(){return console.warn("THREE.LOD: .objects has been renamed to .levels."),this.levels}}}),Object.defineProperty(Skeleton.prototype,"useVertexTexture",{get:function(){console.warn("THREE.Skeleton: useVertexTexture has been removed.")},set:function(){console.warn("THREE.Skeleton: useVertexTexture has been removed.")}}),SkinnedMesh.prototype.initBones=function(){console.error("THREE.SkinnedMesh: initBones() has been removed.")},Object.defineProperty(Curve.prototype,"__arcLengthDivisions",{get:function(){return console.warn("THREE.Curve: .__arcLengthDivisions is now .arcLengthDivisions."),this.arcLengthDivisions},set:function(value){console.warn("THREE.Curve: .__arcLengthDivisions is now .arcLengthDivisions."),this.arcLengthDivisions=value}}),PerspectiveCamera.prototype.setLens=function(focalLength,filmGauge){console.warn("THREE.PerspectiveCamera.setLens is deprecated. Use .setFocalLength and .filmGauge for a photographic setup."),void 0!==filmGauge&&(this.filmGauge=filmGauge),this.setFocalLength(focalLength)},Object.defineProperties(Light.prototype,{onlyShadow:{set:function(){console.warn("THREE.Light: .onlyShadow has been removed.")}},shadowCameraFov:{set:function(value){console.warn("THREE.Light: .shadowCameraFov is now .shadow.camera.fov."),this.shadow.camera.fov=value}},shadowCameraLeft:{set:function(value){console.warn("THREE.Light: .shadowCameraLeft is now .shadow.camera.left."),this.shadow.camera.left=value}},shadowCameraRight:{set:function(value){console.warn("THREE.Light: .shadowCameraRight is now .shadow.camera.right."),this.shadow.camera.right=value}},shadowCameraTop:{set:function(value){console.warn("THREE.Light: .shadowCameraTop is now .shadow.camera.top."),this.shadow.camera.top=value}},shadowCameraBottom:{set:function(value){console.warn("THREE.Light: .shadowCameraBottom is now .shadow.camera.bottom."),this.shadow.camera.bottom=value}},shadowCameraNear:{set:function(value){console.warn("THREE.Light: .shadowCameraNear is now .shadow.camera.near."),this.shadow.camera.near=value}},shadowCameraFar:{set:function(value){console.warn("THREE.Light: .shadowCameraFar is now .shadow.camera.far."),this.shadow.camera.far=value}},shadowCameraVisible:{set:function(){console.warn("THREE.Light: .shadowCameraVisible has been removed. Use new THREE.CameraHelper( light.shadow.camera ) instead.")}},shadowBias:{set:function(value){console.warn("THREE.Light: .shadowBias is now .shadow.bias."),this.shadow.bias=value}},shadowDarkness:{set:function(){console.warn("THREE.Light: .shadowDarkness has been removed.")}},shadowMapWidth:{set:function(value){console.warn("THREE.Light: .shadowMapWidth is now .shadow.mapSize.width."),this.shadow.mapSize.width=value}},shadowMapHeight:{set:function(value){console.warn("THREE.Light: .shadowMapHeight is now .shadow.mapSize.height."),this.shadow.mapSize.height=value}}}),Object.defineProperties(BufferAttribute.prototype,{length:{get:function(){return console.warn("THREE.BufferAttribute: .length has been deprecated. Use .count instead."),this.array.length}},dynamic:{get:function(){return console.warn("THREE.BufferAttribute: .dynamic has been deprecated. Use .usage instead."),35048===this.usage},set:function(){console.warn("THREE.BufferAttribute: .dynamic has been deprecated. Use .usage instead."),this.setUsage(35048)}}}),Object.assign(BufferAttribute.prototype,{setDynamic:function(value){return console.warn("THREE.BufferAttribute: .setDynamic() has been deprecated. Use .setUsage() instead."),this.setUsage(!0===value?35048:35044),this},copyIndicesArray:function(){console.error("THREE.BufferAttribute: .copyIndicesArray() has been removed.")},setArray:function(){console.error("THREE.BufferAttribute: .setArray has been removed. Use BufferGeometry .setAttribute to replace/resize attribute buffers")}}),Object.assign(BufferGeometry.prototype,{addIndex:function(index){console.warn("THREE.BufferGeometry: .addIndex() has been renamed to .setIndex()."),this.setIndex(index)},addAttribute:function(name,attribute){return console.warn("THREE.BufferGeometry: .addAttribute() has been renamed to .setAttribute()."),attribute&&attribute.isBufferAttribute||attribute&&attribute.isInterleavedBufferAttribute?"index"===name?(console.warn("THREE.BufferGeometry.addAttribute: Use .setIndex() for index attribute."),this.setIndex(attribute),this):this.setAttribute(name,attribute):(console.warn("THREE.BufferGeometry: .addAttribute() now expects ( name, attribute )."),this.setAttribute(name,new BufferAttribute(arguments[1],arguments[2])))},addDrawCall:function(start,count,indexOffset){void 0!==indexOffset&&console.warn("THREE.BufferGeometry: .addDrawCall() no longer supports indexOffset."),console.warn("THREE.BufferGeometry: .addDrawCall() is now .addGroup()."),this.addGroup(start,count)},clearDrawCalls:function(){console.warn("THREE.BufferGeometry: .clearDrawCalls() is now .clearGroups()."),this.clearGroups()},computeTangents:function(){console.warn("THREE.BufferGeometry: .computeTangents() has been removed.")},computeOffsets:function(){console.warn("THREE.BufferGeometry: .computeOffsets() has been removed.")},removeAttribute:function(name){return console.warn("THREE.BufferGeometry: .removeAttribute() has been renamed to .deleteAttribute()."),this.deleteAttribute(name)},applyMatrix:function(matrix){return console.warn("THREE.BufferGeometry: .applyMatrix() has been renamed to .applyMatrix4()."),this.applyMatrix4(matrix)}}),Object.defineProperties(BufferGeometry.prototype,{drawcalls:{get:function(){return console.error("THREE.BufferGeometry: .drawcalls has been renamed to .groups."),this.groups}},offsets:{get:function(){return console.warn("THREE.BufferGeometry: .offsets has been renamed to .groups."),this.groups}}}),Object.defineProperties(InstancedBufferGeometry.prototype,{maxInstancedCount:{get:function(){return console.warn("THREE.InstancedBufferGeometry: .maxInstancedCount has been renamed to .instanceCount."),this.instanceCount},set:function(value){console.warn("THREE.InstancedBufferGeometry: .maxInstancedCount has been renamed to .instanceCount."),this.instanceCount=value}}}),Object.defineProperties(Raycaster.prototype,{linePrecision:{get:function(){return console.warn("THREE.Raycaster: .linePrecision has been deprecated. Use .params.Line.threshold instead."),this.params.Line.threshold},set:function(value){console.warn("THREE.Raycaster: .linePrecision has been deprecated. Use .params.Line.threshold instead."),this.params.Line.threshold=value}}}),Object.defineProperties(InterleavedBuffer.prototype,{dynamic:{get:function(){return console.warn("THREE.InterleavedBuffer: .length has been deprecated. Use .usage instead."),35048===this.usage},set:function(value){console.warn("THREE.InterleavedBuffer: .length has been deprecated. Use .usage instead."),this.setUsage(value)}}}),Object.assign(InterleavedBuffer.prototype,{setDynamic:function(value){return console.warn("THREE.InterleavedBuffer: .setDynamic() has been deprecated. Use .setUsage() instead."),this.setUsage(!0===value?35048:35044),this},setArray:function(){console.error("THREE.InterleavedBuffer: .setArray has been removed. Use BufferGeometry .setAttribute to replace/resize attribute buffers")}}),Object.assign(ExtrudeBufferGeometry.prototype,{getArrays:function(){console.error("THREE.ExtrudeBufferGeometry: .getArrays() has been removed.")},addShapeList:function(){console.error("THREE.ExtrudeBufferGeometry: .addShapeList() has been removed.")},addShape:function(){console.error("THREE.ExtrudeBufferGeometry: .addShape() has been removed.")}}),Object.defineProperties(Uniform.prototype,{dynamic:{set:function(){console.warn("THREE.Uniform: .dynamic has been removed. Use object.onBeforeRender() instead.")}},onUpdate:{value:function(){return console.warn("THREE.Uniform: .onUpdate() has been removed. Use object.onBeforeRender() instead."),this}}}),Object.defineProperties(Material.prototype,{wrapAround:{get:function(){console.warn("THREE.Material: .wrapAround has been removed.")},set:function(){console.warn("THREE.Material: .wrapAround has been removed.")}},overdraw:{get:function(){console.warn("THREE.Material: .overdraw has been removed.")},set:function(){console.warn("THREE.Material: .overdraw has been removed.")}},wrapRGB:{get:function(){return console.warn("THREE.Material: .wrapRGB has been removed."),new Color}},shading:{get:function(){console.error("THREE."+this.type+": .shading has been removed. Use the boolean .flatShading instead.")},set:function(value){console.warn("THREE."+this.type+": .shading has been removed. Use the boolean .flatShading instead."),this.flatShading=1===value}},stencilMask:{get:function(){return console.warn("THREE."+this.type+": .stencilMask has been removed. Use .stencilFuncMask instead."),this.stencilFuncMask},set:function(value){console.warn("THREE."+this.type+": .stencilMask has been removed. Use .stencilFuncMask instead."),this.stencilFuncMask=value}}}),Object.defineProperties(MeshPhongMaterial.prototype,{metal:{get:function(){return console.warn("THREE.MeshPhongMaterial: .metal has been removed. Use THREE.MeshStandardMaterial instead."),!1},set:function(){console.warn("THREE.MeshPhongMaterial: .metal has been removed. Use THREE.MeshStandardMaterial instead")}}}),Object.defineProperties(MeshPhysicalMaterial.prototype,{transparency:{get:function(){return console.warn("THREE.MeshPhysicalMaterial: .transparency has been renamed to .transmission."),this.transmission},set:function(value){console.warn("THREE.MeshPhysicalMaterial: .transparency has been renamed to .transmission."),this.transmission=value}}}),Object.defineProperties(ShaderMaterial.prototype,{derivatives:{get:function(){return console.warn("THREE.ShaderMaterial: .derivatives has been moved to .extensions.derivatives."),this.extensions.derivatives},set:function(value){console.warn("THREE. ShaderMaterial: .derivatives has been moved to .extensions.derivatives."),this.extensions.derivatives=value}}}),Object.assign(WebGLRenderer.prototype,{clearTarget:function(renderTarget,color,depth,stencil){console.warn("THREE.WebGLRenderer: .clearTarget() has been deprecated. Use .setRenderTarget() and .clear() instead."),this.setRenderTarget(renderTarget),this.clear(color,depth,stencil)},animate:function(callback){console.warn("THREE.WebGLRenderer: .animate() is now .setAnimationLoop()."),this.setAnimationLoop(callback)},getCurrentRenderTarget:function(){return console.warn("THREE.WebGLRenderer: .getCurrentRenderTarget() is now .getRenderTarget()."),this.getRenderTarget()},getMaxAnisotropy:function(){return console.warn("THREE.WebGLRenderer: .getMaxAnisotropy() is now .capabilities.getMaxAnisotropy()."),this.capabilities.getMaxAnisotropy()},getPrecision:function(){return console.warn("THREE.WebGLRenderer: .getPrecision() is now .capabilities.precision."),this.capabilities.precision},resetGLState:function(){return console.warn("THREE.WebGLRenderer: .resetGLState() is now .state.reset()."),this.state.reset()},supportsFloatTextures:function(){return console.warn("THREE.WebGLRenderer: .supportsFloatTextures() is now .extensions.get( 'OES_texture_float' )."),this.extensions.get("OES_texture_float")},supportsHalfFloatTextures:function(){return console.warn("THREE.WebGLRenderer: .supportsHalfFloatTextures() is now .extensions.get( 'OES_texture_half_float' )."),this.extensions.get("OES_texture_half_float")},supportsStandardDerivatives:function(){return console.warn("THREE.WebGLRenderer: .supportsStandardDerivatives() is now .extensions.get( 'OES_standard_derivatives' )."),this.extensions.get("OES_standard_derivatives")},supportsCompressedTextureS3TC:function(){return console.warn("THREE.WebGLRenderer: .supportsCompressedTextureS3TC() is now .extensions.get( 'WEBGL_compressed_texture_s3tc' )."),this.extensions.get("WEBGL_compressed_texture_s3tc")},supportsCompressedTexturePVRTC:function(){return console.warn("THREE.WebGLRenderer: .supportsCompressedTexturePVRTC() is now .extensions.get( 'WEBGL_compressed_texture_pvrtc' )."),this.extensions.get("WEBGL_compressed_texture_pvrtc")},supportsBlendMinMax:function(){return console.warn("THREE.WebGLRenderer: .supportsBlendMinMax() is now .extensions.get( 'EXT_blend_minmax' )."),this.extensions.get("EXT_blend_minmax")},supportsVertexTextures:function(){return console.warn("THREE.WebGLRenderer: .supportsVertexTextures() is now .capabilities.vertexTextures."),this.capabilities.vertexTextures},supportsInstancedArrays:function(){return console.warn("THREE.WebGLRenderer: .supportsInstancedArrays() is now .extensions.get( 'ANGLE_instanced_arrays' )."),this.extensions.get("ANGLE_instanced_arrays")},enableScissorTest:function(boolean){console.warn("THREE.WebGLRenderer: .enableScissorTest() is now .setScissorTest()."),this.setScissorTest(boolean)},initMaterial:function(){console.warn("THREE.WebGLRenderer: .initMaterial() has been removed.")},addPrePlugin:function(){console.warn("THREE.WebGLRenderer: .addPrePlugin() has been removed.")},addPostPlugin:function(){console.warn("THREE.WebGLRenderer: .addPostPlugin() has been removed.")},updateShadowMap:function(){console.warn("THREE.WebGLRenderer: .updateShadowMap() has been removed.")},setFaceCulling:function(){console.warn("THREE.WebGLRenderer: .setFaceCulling() has been removed.")},allocTextureUnit:function(){console.warn("THREE.WebGLRenderer: .allocTextureUnit() has been removed.")},setTexture:function(){console.warn("THREE.WebGLRenderer: .setTexture() has been removed.")},setTexture2D:function(){console.warn("THREE.WebGLRenderer: .setTexture2D() has been removed.")},setTextureCube:function(){console.warn("THREE.WebGLRenderer: .setTextureCube() has been removed.")},getActiveMipMapLevel:function(){return console.warn("THREE.WebGLRenderer: .getActiveMipMapLevel() is now .getActiveMipmapLevel()."),this.getActiveMipmapLevel()}}),Object.defineProperties(WebGLRenderer.prototype,{shadowMapEnabled:{get:function(){return this.shadowMap.enabled},set:function(value){console.warn("THREE.WebGLRenderer: .shadowMapEnabled is now .shadowMap.enabled."),this.shadowMap.enabled=value}},shadowMapType:{get:function(){return this.shadowMap.type},set:function(value){console.warn("THREE.WebGLRenderer: .shadowMapType is now .shadowMap.type."),this.shadowMap.type=value}},shadowMapCullFace:{get:function(){console.warn("THREE.WebGLRenderer: .shadowMapCullFace has been removed. Set Material.shadowSide instead.")},set:function(){console.warn("THREE.WebGLRenderer: .shadowMapCullFace has been removed. Set Material.shadowSide instead.")}},context:{get:function(){return console.warn("THREE.WebGLRenderer: .context has been removed. Use .getContext() instead."),this.getContext()}},vr:{get:function(){return console.warn("THREE.WebGLRenderer: .vr has been renamed to .xr"),this.xr}},gammaInput:{get:function(){return console.warn("THREE.WebGLRenderer: .gammaInput has been removed. Set the encoding for textures via Texture.encoding instead."),!1},set:function(){console.warn("THREE.WebGLRenderer: .gammaInput has been removed. Set the encoding for textures via Texture.encoding instead.")}},gammaOutput:{get:function(){return console.warn("THREE.WebGLRenderer: .gammaOutput has been removed. Set WebGLRenderer.outputEncoding instead."),!1},set:function(value){console.warn("THREE.WebGLRenderer: .gammaOutput has been removed. Set WebGLRenderer.outputEncoding instead."),this.outputEncoding=!0===value?3001:3e3}},toneMappingWhitePoint:{get:function(){return console.warn("THREE.WebGLRenderer: .toneMappingWhitePoint has been removed."),1},set:function(){console.warn("THREE.WebGLRenderer: .toneMappingWhitePoint has been removed.")}}}),Object.defineProperties(WebGLShadowMap.prototype,{cullFace:{get:function(){console.warn("THREE.WebGLRenderer: .shadowMap.cullFace has been removed. Set Material.shadowSide instead.")},set:function(){console.warn("THREE.WebGLRenderer: .shadowMap.cullFace has been removed. Set Material.shadowSide instead.")}},renderReverseSided:{get:function(){console.warn("THREE.WebGLRenderer: .shadowMap.renderReverseSided has been removed. Set Material.shadowSide instead.")},set:function(){console.warn("THREE.WebGLRenderer: .shadowMap.renderReverseSided has been removed. Set Material.shadowSide instead.")}},renderSingleSided:{get:function(){console.warn("THREE.WebGLRenderer: .shadowMap.renderSingleSided has been removed. Set Material.shadowSide instead.")},set:function(){console.warn("THREE.WebGLRenderer: .shadowMap.renderSingleSided has been removed. Set Material.shadowSide instead.")}}}),Object.defineProperties(WebGLRenderTarget.prototype,{wrapS:{get:function(){return console.warn("THREE.WebGLRenderTarget: .wrapS is now .texture.wrapS."),this.texture.wrapS},set:function(value){console.warn("THREE.WebGLRenderTarget: .wrapS is now .texture.wrapS."),this.texture.wrapS=value}},wrapT:{get:function(){return console.warn("THREE.WebGLRenderTarget: .wrapT is now .texture.wrapT."),this.texture.wrapT},set:function(value){console.warn("THREE.WebGLRenderTarget: .wrapT is now .texture.wrapT."),this.texture.wrapT=value}},magFilter:{get:function(){return console.warn("THREE.WebGLRenderTarget: .magFilter is now .texture.magFilter."),this.texture.magFilter},set:function(value){console.warn("THREE.WebGLRenderTarget: .magFilter is now .texture.magFilter."),this.texture.magFilter=value}},minFilter:{get:function(){return console.warn("THREE.WebGLRenderTarget: .minFilter is now .texture.minFilter."),this.texture.minFilter},set:function(value){console.warn("THREE.WebGLRenderTarget: .minFilter is now .texture.minFilter."),this.texture.minFilter=value}},anisotropy:{get:function(){return console.warn("THREE.WebGLRenderTarget: .anisotropy is now .texture.anisotropy."),this.texture.anisotropy},set:function(value){console.warn("THREE.WebGLRenderTarget: .anisotropy is now .texture.anisotropy."),this.texture.anisotropy=value}},offset:{get:function(){return console.warn("THREE.WebGLRenderTarget: .offset is now .texture.offset."),this.texture.offset},set:function(value){console.warn("THREE.WebGLRenderTarget: .offset is now .texture.offset."),this.texture.offset=value}},repeat:{get:function(){return console.warn("THREE.WebGLRenderTarget: .repeat is now .texture.repeat."),this.texture.repeat},set:function(value){console.warn("THREE.WebGLRenderTarget: .repeat is now .texture.repeat."),this.texture.repeat=value}},format:{get:function(){return console.warn("THREE.WebGLRenderTarget: .format is now .texture.format."),this.texture.format},set:function(value){console.warn("THREE.WebGLRenderTarget: .format is now .texture.format."),this.texture.format=value}},type:{get:function(){return console.warn("THREE.WebGLRenderTarget: .type is now .texture.type."),this.texture.type},set:function(value){console.warn("THREE.WebGLRenderTarget: .type is now .texture.type."),this.texture.type=value}},generateMipmaps:{get:function(){return console.warn("THREE.WebGLRenderTarget: .generateMipmaps is now .texture.generateMipmaps."),this.texture.generateMipmaps},set:function(value){console.warn("THREE.WebGLRenderTarget: .generateMipmaps is now .texture.generateMipmaps."),this.texture.generateMipmaps=value}}}),Object.defineProperties(Audio.prototype,{load:{value:function(file){console.warn("THREE.Audio: .load has been deprecated. Use THREE.AudioLoader instead.");const scope=this;return(new AudioLoader).load(file,(function(buffer){scope.setBuffer(buffer)})),this}},startTime:{set:function(){console.warn("THREE.Audio: .startTime is now .play( delay ).")}}}),AudioAnalyser.prototype.getData=function(){return console.warn("THREE.AudioAnalyser: .getData() is now .getFrequencyData()."),this.getFrequencyData()},CubeCamera.prototype.updateCubeMap=function(renderer,scene){return console.warn("THREE.CubeCamera: .updateCubeMap() is now .update()."),this.update(renderer,scene)};ImageUtils.crossOrigin=void 0,ImageUtils.loadTexture=function(url,mapping,onLoad,onError){console.warn("THREE.ImageUtils.loadTexture has been deprecated. Use THREE.TextureLoader() instead.");const loader=new TextureLoader;loader.setCrossOrigin(this.crossOrigin);const texture=loader.load(url,onLoad,void 0,onError);return mapping&&(texture.mapping=mapping),texture},ImageUtils.loadTextureCube=function(urls,mapping,onLoad,onError){console.warn("THREE.ImageUtils.loadTextureCube has been deprecated. Use THREE.CubeTextureLoader() instead.");const loader=new CubeTextureLoader;loader.setCrossOrigin(this.crossOrigin);const texture=loader.load(urls,onLoad,void 0,onError);return mapping&&(texture.mapping=mapping),texture},ImageUtils.loadCompressedTexture=function(){console.error("THREE.ImageUtils.loadCompressedTexture has been removed. Use THREE.DDSLoader instead.")},ImageUtils.loadCompressedTextureCube=function(){console.error("THREE.ImageUtils.loadCompressedTextureCube has been removed. Use THREE.DDSLoader instead.")};"undefined"!=typeof __THREE_DEVTOOLS__&&__THREE_DEVTOOLS__.dispatchEvent(new CustomEvent("register",{detail:{revision:"119"}}));var dist_e,dist_a=(function(t,e){var a="undefined"!=typeof Uint8Array&&"undefined"!=typeof Uint16Array&&"undefined"!=typeof Int32Array;function n(t,e){return Object.prototype.hasOwnProperty.call(t,e)}e.assign=function(t){for(var e=Array.prototype.slice.call(arguments,1);e.length;){var a=e.shift();if(a){if("object"!=typeof a)throw new TypeError(a+"must be non-object");for(var i in a)n(a,i)&&(t[i]=a[i])}}return t},e.shrinkBuf=function(t,e){return t.length===e?t:t.subarray?t.subarray(0,e):(t.length=e,t)};var i={arraySet:function(t,e,a,n,i){if(e.subarray&&t.subarray)t.set(e.subarray(a,a+n),i);else for(var r=0;r<n;r++)t[i+r]=e[a+r]},flattenChunks:function(t){var e,a,n,i,r,s;for(n=0,e=0,a=t.length;e<a;e++)n+=t[e].length;for(s=new Uint8Array(n),i=0,e=0,a=t.length;e<a;e++)r=t[e],s.set(r,i),i+=r.length;return s}},r={arraySet:function(t,e,a,n,i){for(var r=0;r<n;r++)t[i+r]=e[a+r]},flattenChunks:function(t){return[].concat.apply([],t)}};e.setTyped=function(t){t?(e.Buf8=Uint8Array,e.Buf16=Uint16Array,e.Buf32=Int32Array,e.assign(e,i)):(e.Buf8=Array,e.Buf16=Array,e.Buf32=Array,e.assign(e,r))},e.setTyped(a)}(dist_e={path:void 0,exports:{},require:function(t,a){return function(){throw new Error("Dynamic requires are not currently supported by @rollup/plugin-commonjs")}(null==a&&dist_e.path)}},dist_e.exports),dist_e.exports);function dist_n(t){for(var e=t.length;--e>=0;)t[e]=0}var dist_i=[0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0],dist_r=[0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13],dist_s=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,7],dist_d=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15],dist_o=new Array(576);dist_n(dist_o);var dist_l=new Array(60);dist_n(dist_l);var dist_f=new Array(512);dist_n(dist_f);var h=new Array(256);dist_n(h);var dist_u=new Array(29);dist_n(dist_u);var dist_c,dist_b,dist_v,dist_w=new Array(30);function dist_p(t,e,a,n,i){this.static_tree=t,this.extra_bits=e,this.extra_base=a,this.elems=n,this.max_length=i,this.has_stree=t&&t.length}function dist_m(t,e){this.dyn_tree=t,this.max_code=0,this.stat_desc=e}function dist_k(t){return t<256?dist_f[t]:dist_f[256+(t>>>7)]}function dist_x(t,e){t.pending_buf[t.pending++]=255&e,t.pending_buf[t.pending++]=e>>>8&255}function X(t,e,a){t.bi_valid>16-a?(t.bi_buf|=e<<t.bi_valid&65535,dist_x(t,t.bi_buf),t.bi_buf=e>>16-t.bi_valid,t.bi_valid+=a-16):(t.bi_buf|=e<<t.bi_valid&65535,t.bi_valid+=a)}function dist_g(t,e,a){X(t,a[2*e],a[2*e+1])}function dist_z(t,e){var a=0;do{a|=1&t,t>>>=1,a<<=1}while(--e>0);return a>>>1}function L(t,e,a){var n,i,r=new Array(16),s=0;for(n=1;n<=15;n++)r[n]=s=s+a[n-1]<<1;for(i=0;i<=e;i++){var d=t[2*i+1];0!==d&&(t[2*i]=dist_z(r[d]++,d))}}function dist_y(t){var e;for(e=0;e<286;e++)t.dyn_ltree[2*e]=0;for(e=0;e<30;e++)t.dyn_dtree[2*e]=0;for(e=0;e<19;e++)t.bl_tree[2*e]=0;t.dyn_ltree[512]=1,t.opt_len=t.static_len=0,t.last_lit=t.matches=0}function P(t){t.bi_valid>8?dist_x(t,t.bi_buf):t.bi_valid>0&&(t.pending_buf[t.pending++]=t.bi_buf),t.bi_buf=0,t.bi_valid=0}function dist_q(t,e,a,n){var i=2*e,r=2*a;return t[i]<t[r]||t[i]===t[r]&&n[e]<=n[a]}function O(t,e,a){for(var n=t.heap[a],i=a<<1;i<=t.heap_len&&(i<t.heap_len&&dist_q(e,t.heap[i+1],t.heap[i],t.depth)&&i++,!dist_q(e,n,t.heap[i],t.depth));)t.heap[a]=t.heap[i],a=i,i<<=1;t.heap[a]=n}function dist_Z(t,e,a){var n,s,d,o,l=0;if(0!==t.last_lit)do{n=t.pending_buf[t.d_buf+2*l]<<8|t.pending_buf[t.d_buf+2*l+1],s=t.pending_buf[t.l_buf+l],l++,0===n?dist_g(t,s,e):(dist_g(t,(d=h[s])+256+1,e),0!==(o=dist_i[d])&&X(t,s-=dist_u[d],o),dist_g(t,d=dist_k(--n),a),0!==(o=dist_r[d])&&X(t,n-=dist_w[d],o))}while(l<t.last_lit);dist_g(t,256,e)}function V(t,e){var a,n,i,r=e.dyn_tree,s=e.stat_desc.static_tree,d=e.stat_desc.has_stree,o=e.stat_desc.elems,l=-1;for(t.heap_len=0,t.heap_max=573,a=0;a<o;a++)0!==r[2*a]?(t.heap[++t.heap_len]=l=a,t.depth[a]=0):r[2*a+1]=0;for(;t.heap_len<2;)r[2*(i=t.heap[++t.heap_len]=l<2?++l:0)]=1,t.depth[i]=0,t.opt_len--,d&&(t.static_len-=s[2*i+1]);for(e.max_code=l,a=t.heap_len>>1;a>=1;a--)O(t,r,a);i=o;do{a=t.heap[1],t.heap[1]=t.heap[t.heap_len--],O(t,r,1),n=t.heap[1],t.heap[--t.heap_max]=a,t.heap[--t.heap_max]=n,r[2*i]=r[2*a]+r[2*n],t.depth[i]=(t.depth[a]>=t.depth[n]?t.depth[a]:t.depth[n])+1,r[2*a+1]=r[2*n+1]=i,t.heap[1]=i++,O(t,r,1)}while(t.heap_len>=2);t.heap[--t.heap_max]=t.heap[1],function(t,e){var a,n,i,r,s,d,o=e.dyn_tree,l=e.max_code,f=e.stat_desc.static_tree,h=e.stat_desc.has_stree,u=e.stat_desc.extra_bits,c=e.stat_desc.extra_base,b=e.stat_desc.max_length,v=0;for(r=0;r<=15;r++)t.bl_count[r]=0;for(o[2*t.heap[t.heap_max]+1]=0,a=t.heap_max+1;a<573;a++)(r=o[2*o[2*(n=t.heap[a])+1]+1]+1)>b&&(r=b,v++),o[2*n+1]=r,n>l||(t.bl_count[r]++,s=0,n>=c&&(s=u[n-c]),d=o[2*n],t.opt_len+=d*(r+s),h&&(t.static_len+=d*(f[2*n+1]+s)));if(0!==v){do{for(r=b-1;0===t.bl_count[r];)r--;t.bl_count[r]--,t.bl_count[r+1]+=2,t.bl_count[b]--,v-=2}while(v>0);for(r=b;0!==r;r--)for(n=t.bl_count[r];0!==n;)(i=t.heap[--a])>l||(o[2*i+1]!==r&&(t.opt_len+=(r-o[2*i+1])*o[2*i],o[2*i+1]=r),n--)}}(t,e),L(r,l,t.bl_count)}function dist_j(t,e,a){var n,i,r=-1,s=e[1],d=0,o=7,l=4;for(0===s&&(o=138,l=3),e[2*(a+1)+1]=65535,n=0;n<=a;n++)i=s,s=e[2*(n+1)+1],++d<o&&i===s||(d<l?t.bl_tree[2*i]+=d:0!==i?(i!==r&&t.bl_tree[2*i]++,t.bl_tree[32]++):d<=10?t.bl_tree[34]++:t.bl_tree[36]++,d=0,r=i,0===s?(o=138,l=3):i===s?(o=6,l=3):(o=7,l=4))}function H(t,e,a){var n,i,r=-1,s=e[1],d=0,o=7,l=4;for(0===s&&(o=138,l=3),n=0;n<=a;n++)if(i=s,s=e[2*(n+1)+1],!(++d<o&&i===s)){if(d<l)do{dist_g(t,i,t.bl_tree)}while(0!=--d);else 0!==i?(i!==r&&(dist_g(t,i,t.bl_tree),d--),dist_g(t,16,t.bl_tree),X(t,d-3,2)):d<=10?(dist_g(t,17,t.bl_tree),X(t,d-3,3)):(dist_g(t,18,t.bl_tree),X(t,d-11,7));d=0,r=i,0===s?(o=138,l=3):i===s?(o=6,l=3):(o=7,l=4)}}dist_n(dist_w);var B=!1;function dist_W(t,e,n,i){X(t,0+(i?1:0),3),function(t,e,n,i){P(t),dist_x(t,n),dist_x(t,~n),dist_a.arraySet(t.pending_buf,t.window,e,n,t.pending),t.pending+=n}(t,e,n)}var dist_S,U={_tr_init:function(t){B||(function(){var t,e,a,n,d,m=new Array(16);for(a=0,n=0;n<28;n++)for(dist_u[n]=a,t=0;t<1<<dist_i[n];t++)h[a++]=n;for(h[a-1]=n,d=0,n=0;n<16;n++)for(dist_w[n]=d,t=0;t<1<<dist_r[n];t++)dist_f[d++]=n;for(d>>=7;n<30;n++)for(dist_w[n]=d<<7,t=0;t<1<<dist_r[n]-7;t++)dist_f[256+d++]=n;for(e=0;e<=15;e++)m[e]=0;for(t=0;t<=143;)dist_o[2*t+1]=8,t++,m[8]++;for(;t<=255;)dist_o[2*t+1]=9,t++,m[9]++;for(;t<=279;)dist_o[2*t+1]=7,t++,m[7]++;for(;t<=287;)dist_o[2*t+1]=8,t++,m[8]++;for(L(dist_o,287,m),t=0;t<30;t++)dist_l[2*t+1]=5,dist_l[2*t]=dist_z(t,5);dist_c=new dist_p(dist_o,dist_i,257,286,15),dist_b=new dist_p(dist_l,dist_r,0,30,15),dist_v=new dist_p(new Array(0),dist_s,0,19,7)}(),B=!0),t.l_desc=new dist_m(t.dyn_ltree,dist_c),t.d_desc=new dist_m(t.dyn_dtree,dist_b),t.bl_desc=new dist_m(t.bl_tree,dist_v),t.bi_buf=0,t.bi_valid=0,dist_y(t)},_tr_stored_block:dist_W,_tr_flush_block:function(t,e,a,n){var i,r,s=0;t.level>0?(2===t.strm.data_type&&(t.strm.data_type=function(t){var e,a=4093624447;for(e=0;e<=31;e++,a>>>=1)if(1&a&&0!==t.dyn_ltree[2*e])return 0;if(0!==t.dyn_ltree[18]||0!==t.dyn_ltree[20]||0!==t.dyn_ltree[26])return 1;for(e=32;e<256;e++)if(0!==t.dyn_ltree[2*e])return 1;return 0}(t)),V(t,t.l_desc),V(t,t.d_desc),s=function(t){var e;for(dist_j(t,t.dyn_ltree,t.l_desc.max_code),dist_j(t,t.dyn_dtree,t.d_desc.max_code),V(t,t.bl_desc),e=18;e>=3&&0===t.bl_tree[2*dist_d[e]+1];e--);return t.opt_len+=3*(e+1)+5+5+4,e}(t),i=t.opt_len+3+7>>>3,(r=t.static_len+3+7>>>3)<=i&&(i=r)):i=r=a+5,a+4<=i&&-1!==e?dist_W(t,e,a,n):4===t.strategy||r===i?(X(t,2+(n?1:0),3),dist_Z(t,dist_o,dist_l)):(X(t,4+(n?1:0),3),function(t,e,a,n){var i;for(X(t,e-257,5),X(t,a-1,5),X(t,n-4,4),i=0;i<n;i++)X(t,t.bl_tree[2*dist_d[i]+1],3);H(t,t.dyn_ltree,e-1),H(t,t.dyn_dtree,a-1)}(t,t.l_desc.max_code+1,t.d_desc.max_code+1,s+1),dist_Z(t,t.dyn_ltree,t.dyn_dtree)),dist_y(t),n&&P(t)},_tr_tally:function(t,e,a){return t.pending_buf[t.d_buf+2*t.last_lit]=e>>>8&255,t.pending_buf[t.d_buf+2*t.last_lit+1]=255&e,t.pending_buf[t.l_buf+t.last_lit]=255&a,t.last_lit++,0===e?t.dyn_ltree[2*a]++:(t.matches++,e--,t.dyn_ltree[2*(h[a]+256+1)]++,t.dyn_dtree[2*dist_k(e)]++),t.last_lit===t.lit_bufsize-1},_tr_align:function(t){X(t,2,3),dist_g(t,256,dist_o),function(t){16===t.bi_valid?(dist_x(t,t.bi_buf),t.bi_buf=0,t.bi_valid=0):t.bi_valid>=8&&(t.pending_buf[t.pending++]=255&t.bi_buf,t.bi_buf>>=8,t.bi_valid-=8)}(t)}},D=function(t,e,a,n){for(var i=65535&t|0,r=t>>>16&65535|0,s=0;0!==a;){a-=s=a>2e3?2e3:a;do{r=r+(i=i+e[n++]|0)|0}while(--s);i%=65521,r%=65521}return i|r<<16|0},A=function(){for(var t,e=[],a=0;a<256;a++){t=a;for(var n=0;n<8;n++)t=1&t?3988292384^t>>>1:t>>>1;e[a]=t}return e}(),T=function(t,e,a,n){var i=A,r=n+a;t^=-1;for(var s=n;s<r;s++)t=t>>>8^i[255&(t^e[s])];return-1^t},dist_N={2:"need dictionary",1:"stream end",0:"","-1":"file error","-2":"stream error","-3":"data error","-4":"insufficient memory","-5":"buffer error","-6":"incompatible version"};function M(t,e){return t.msg=dist_N[e],e}function G(t){return(t<<1)-(t>4?9:0)}function J(t){for(var e=t.length;--e>=0;)t[e]=0}function R(t){var e=t.state,n=e.pending;n>t.avail_out&&(n=t.avail_out),0!==n&&(dist_a.arraySet(t.output,e.pending_buf,e.pending_out,n,t.next_out),t.next_out+=n,e.pending_out+=n,t.total_out+=n,t.avail_out-=n,e.pending-=n,0===e.pending&&(e.pending_out=0))}function F(t,e){U._tr_flush_block(t,t.block_start>=0?t.block_start:-1,t.strstart-t.block_start,e),t.block_start=t.strstart,R(t.strm)}function dist_E(t,e){t.pending_buf[t.pending++]=e}function C(t,e){t.pending_buf[t.pending++]=e>>>8&255,t.pending_buf[t.pending++]=255&e}function Y(t,e){var a,n,i=t.max_chain_length,r=t.strstart,s=t.prev_length,d=t.nice_match,o=t.strstart>t.w_size-262?t.strstart-(t.w_size-262):0,l=t.window,f=t.w_mask,h=t.prev,u=t.strstart+258,c=l[r+s-1],b=l[r+s];t.prev_length>=t.good_match&&(i>>=2),d>t.lookahead&&(d=t.lookahead);do{if(l[(a=e)+s]===b&&l[a+s-1]===c&&l[a]===l[r]&&l[++a]===l[r+1]){r+=2,a++;do{}while(l[++r]===l[++a]&&l[++r]===l[++a]&&l[++r]===l[++a]&&l[++r]===l[++a]&&l[++r]===l[++a]&&l[++r]===l[++a]&&l[++r]===l[++a]&&l[++r]===l[++a]&&r<u);if(n=258-(u-r),r=u-258,n>s){if(t.match_start=e,s=n,n>=d)break;c=l[r+s-1],b=l[r+s]}}}while((e=h[e&f])>o&&0!=--i);return s<=t.lookahead?s:t.lookahead}function K(t){var e,n,i,r,s,d,o,l,f,h,u=t.w_size;do{if(r=t.window_size-t.lookahead-t.strstart,t.strstart>=u+(u-262)){dist_a.arraySet(t.window,t.window,u,u,0),t.match_start-=u,t.strstart-=u,t.block_start-=u,e=n=t.hash_size;do{i=t.head[--e],t.head[e]=i>=u?i-u:0}while(--n);e=n=u;do{i=t.prev[--e],t.prev[e]=i>=u?i-u:0}while(--n);r+=u}if(0===t.strm.avail_in)break;if(d=t.strm,o=t.window,l=t.strstart+t.lookahead,f=r,h=void 0,(h=d.avail_in)>f&&(h=f),n=0===h?0:(d.avail_in-=h,dist_a.arraySet(o,d.input,d.next_in,h,l),1===d.state.wrap?d.adler=D(d.adler,o,h,l):2===d.state.wrap&&(d.adler=T(d.adler,o,h,l)),d.next_in+=h,d.total_in+=h,h),t.lookahead+=n,t.lookahead+t.insert>=3)for(s=t.strstart-t.insert,t.ins_h=t.window[s],t.ins_h=(t.ins_h<<t.hash_shift^t.window[s+1])&t.hash_mask;t.insert&&(t.ins_h=(t.ins_h<<t.hash_shift^t.window[s+3-1])&t.hash_mask,t.prev[s&t.w_mask]=t.head[t.ins_h],t.head[t.ins_h]=s,s++,t.insert--,!(t.lookahead+t.insert<3)););}while(t.lookahead<262&&0!==t.strm.avail_in)}function I(t,e){for(var a,n;;){if(t.lookahead<262){if(K(t),t.lookahead<262&&0===e)return 1;if(0===t.lookahead)break}if(a=0,t.lookahead>=3&&(t.ins_h=(t.ins_h<<t.hash_shift^t.window[t.strstart+3-1])&t.hash_mask,a=t.prev[t.strstart&t.w_mask]=t.head[t.ins_h],t.head[t.ins_h]=t.strstart),0!==a&&t.strstart-a<=t.w_size-262&&(t.match_length=Y(t,a)),t.match_length>=3)if(n=U._tr_tally(t,t.strstart-t.match_start,t.match_length-3),t.lookahead-=t.match_length,t.match_length<=t.max_lazy_match&&t.lookahead>=3){t.match_length--;do{t.strstart++,t.ins_h=(t.ins_h<<t.hash_shift^t.window[t.strstart+3-1])&t.hash_mask,a=t.prev[t.strstart&t.w_mask]=t.head[t.ins_h],t.head[t.ins_h]=t.strstart}while(0!=--t.match_length);t.strstart++}else t.strstart+=t.match_length,t.match_length=0,t.ins_h=t.window[t.strstart],t.ins_h=(t.ins_h<<t.hash_shift^t.window[t.strstart+1])&t.hash_mask;else n=U._tr_tally(t,0,t.window[t.strstart]),t.lookahead--,t.strstart++;if(n&&(F(t,!1),0===t.strm.avail_out))return 1}return t.insert=t.strstart<2?t.strstart:2,4===e?(F(t,!0),0===t.strm.avail_out?3:4):t.last_lit&&(F(t,!1),0===t.strm.avail_out)?1:2}function Q(t,e){for(var a,n,i;;){if(t.lookahead<262){if(K(t),t.lookahead<262&&0===e)return 1;if(0===t.lookahead)break}if(a=0,t.lookahead>=3&&(t.ins_h=(t.ins_h<<t.hash_shift^t.window[t.strstart+3-1])&t.hash_mask,a=t.prev[t.strstart&t.w_mask]=t.head[t.ins_h],t.head[t.ins_h]=t.strstart),t.prev_length=t.match_length,t.prev_match=t.match_start,t.match_length=2,0!==a&&t.prev_length<t.max_lazy_match&&t.strstart-a<=t.w_size-262&&(t.match_length=Y(t,a),t.match_length<=5&&(1===t.strategy||3===t.match_length&&t.strstart-t.match_start>4096)&&(t.match_length=2)),t.prev_length>=3&&t.match_length<=t.prev_length){i=t.strstart+t.lookahead-3,n=U._tr_tally(t,t.strstart-1-t.prev_match,t.prev_length-3),t.lookahead-=t.prev_length-1,t.prev_length-=2;do{++t.strstart<=i&&(t.ins_h=(t.ins_h<<t.hash_shift^t.window[t.strstart+3-1])&t.hash_mask,a=t.prev[t.strstart&t.w_mask]=t.head[t.ins_h],t.head[t.ins_h]=t.strstart)}while(0!=--t.prev_length);if(t.match_available=0,t.match_length=2,t.strstart++,n&&(F(t,!1),0===t.strm.avail_out))return 1}else if(t.match_available){if((n=U._tr_tally(t,0,t.window[t.strstart-1]))&&F(t,!1),t.strstart++,t.lookahead--,0===t.strm.avail_out)return 1}else t.match_available=1,t.strstart++,t.lookahead--}return t.match_available&&(n=U._tr_tally(t,0,t.window[t.strstart-1]),t.match_available=0),t.insert=t.strstart<2?t.strstart:2,4===e?(F(t,!0),0===t.strm.avail_out?3:4):t.last_lit&&(F(t,!1),0===t.strm.avail_out)?1:2}function dist_(t,e,a,n,i){this.good_length=t,this.max_lazy=e,this.nice_length=a,this.max_chain=n,this.func=i}function $(){this.strm=null,this.status=0,this.pending_buf=null,this.pending_buf_size=0,this.pending_out=0,this.pending=0,this.wrap=0,this.gzhead=null,this.gzindex=0,this.method=8,this.last_flush=-1,this.w_size=0,this.w_bits=0,this.w_mask=0,this.window=null,this.window_size=0,this.prev=null,this.head=null,this.ins_h=0,this.hash_size=0,this.hash_bits=0,this.hash_mask=0,this.hash_shift=0,this.block_start=0,this.match_length=0,this.prev_match=0,this.match_available=0,this.strstart=0,this.match_start=0,this.lookahead=0,this.prev_length=0,this.max_chain_length=0,this.max_lazy_match=0,this.level=0,this.strategy=0,this.good_match=0,this.nice_match=0,this.dyn_ltree=new dist_a.Buf16(1146),this.dyn_dtree=new dist_a.Buf16(122),this.bl_tree=new dist_a.Buf16(78),J(this.dyn_ltree),J(this.dyn_dtree),J(this.bl_tree),this.l_desc=null,this.d_desc=null,this.bl_desc=null,this.bl_count=new dist_a.Buf16(16),this.heap=new dist_a.Buf16(573),J(this.heap),this.heap_len=0,this.heap_max=0,this.depth=new dist_a.Buf16(573),J(this.depth),this.l_buf=0,this.lit_bufsize=0,this.last_lit=0,this.d_buf=0,this.opt_len=0,this.static_len=0,this.matches=0,this.insert=0,this.bi_buf=0,this.bi_valid=0}function tt(t){var e;return t&&t.state?(t.total_in=t.total_out=0,t.data_type=2,(e=t.state).pending=0,e.pending_out=0,e.wrap<0&&(e.wrap=-e.wrap),e.status=e.wrap?42:113,t.adler=2===e.wrap?0:1,e.last_flush=0,U._tr_init(e),0):M(t,-2)}function et(t){var e,a=tt(t);return 0===a&&((e=t.state).window_size=2*e.w_size,J(e.head),e.max_lazy_match=dist_S[e.level].max_lazy,e.good_match=dist_S[e.level].good_length,e.nice_match=dist_S[e.level].nice_length,e.max_chain_length=dist_S[e.level].max_chain,e.strstart=0,e.block_start=0,e.lookahead=0,e.insert=0,e.match_length=e.prev_length=2,e.match_available=0,e.ins_h=0),a}function at(t,e,n,i,r,s){if(!t)return-2;var d=1;if(-1===e&&(e=6),i<0?(d=0,i=-i):i>15&&(d=2,i-=16),r<1||r>9||8!==n||i<8||i>15||e<0||e>9||s<0||s>4)return M(t,-2);8===i&&(i=9);var o=new $;return t.state=o,o.strm=t,o.wrap=d,o.gzhead=null,o.w_bits=i,o.w_size=1<<o.w_bits,o.w_mask=o.w_size-1,o.hash_bits=r+7,o.hash_size=1<<o.hash_bits,o.hash_mask=o.hash_size-1,o.hash_shift=~~((o.hash_bits+3-1)/3),o.window=new dist_a.Buf8(2*o.w_size),o.head=new dist_a.Buf16(o.hash_size),o.prev=new dist_a.Buf16(o.w_size),o.lit_bufsize=1<<r+6,o.pending_buf_size=4*o.lit_bufsize,o.pending_buf=new dist_a.Buf8(o.pending_buf_size),o.d_buf=1*o.lit_bufsize,o.l_buf=3*o.lit_bufsize,o.level=e,o.strategy=s,o.method=n,et(t)}dist_S=[new dist_(0,0,0,0,(function(t,e){var a=65535;for(a>t.pending_buf_size-5&&(a=t.pending_buf_size-5);;){if(t.lookahead<=1){if(K(t),0===t.lookahead&&0===e)return 1;if(0===t.lookahead)break}t.strstart+=t.lookahead,t.lookahead=0;var n=t.block_start+a;if((0===t.strstart||t.strstart>=n)&&(t.lookahead=t.strstart-n,t.strstart=n,F(t,!1),0===t.strm.avail_out))return 1;if(t.strstart-t.block_start>=t.w_size-262&&(F(t,!1),0===t.strm.avail_out))return 1}return t.insert=0,4===e?(F(t,!0),0===t.strm.avail_out?3:4):(t.strstart>t.block_start&&(F(t,!1),t.strm.avail_out),1)})),new dist_(4,4,8,4,I),new dist_(4,5,16,8,I),new dist_(4,6,32,32,I),new dist_(4,4,16,16,Q),new dist_(8,16,32,32,Q),new dist_(8,16,128,128,Q),new dist_(8,32,128,256,Q),new dist_(32,128,258,1024,Q),new dist_(32,258,258,4096,Q)];var nt={deflateInit:function(t,e){return at(t,e,8,15,8,0)},deflateInit2:at,deflateReset:et,deflateResetKeep:tt,deflateSetHeader:function(t,e){return t&&t.state?2!==t.state.wrap?-2:(t.state.gzhead=e,0):-2},deflate:function(t,e){var a,n,i,r;if(!t||!t.state||e>5||e<0)return t?M(t,-2):-2;if(n=t.state,!t.output||!t.input&&0!==t.avail_in||666===n.status&&4!==e)return M(t,0===t.avail_out?-5:-2);if(n.strm=t,a=n.last_flush,n.last_flush=e,42===n.status)if(2===n.wrap)t.adler=0,dist_E(n,31),dist_E(n,139),dist_E(n,8),n.gzhead?(dist_E(n,(n.gzhead.text?1:0)+(n.gzhead.hcrc?2:0)+(n.gzhead.extra?4:0)+(n.gzhead.name?8:0)+(n.gzhead.comment?16:0)),dist_E(n,255&n.gzhead.time),dist_E(n,n.gzhead.time>>8&255),dist_E(n,n.gzhead.time>>16&255),dist_E(n,n.gzhead.time>>24&255),dist_E(n,9===n.level?2:n.strategy>=2||n.level<2?4:0),dist_E(n,255&n.gzhead.os),n.gzhead.extra&&n.gzhead.extra.length&&(dist_E(n,255&n.gzhead.extra.length),dist_E(n,n.gzhead.extra.length>>8&255)),n.gzhead.hcrc&&(t.adler=T(t.adler,n.pending_buf,n.pending,0)),n.gzindex=0,n.status=69):(dist_E(n,0),dist_E(n,0),dist_E(n,0),dist_E(n,0),dist_E(n,0),dist_E(n,9===n.level?2:n.strategy>=2||n.level<2?4:0),dist_E(n,3),n.status=113);else{var s=8+(n.w_bits-8<<4)<<8;s|=(n.strategy>=2||n.level<2?0:n.level<6?1:6===n.level?2:3)<<6,0!==n.strstart&&(s|=32),s+=31-s%31,n.status=113,C(n,s),0!==n.strstart&&(C(n,t.adler>>>16),C(n,65535&t.adler)),t.adler=1}if(69===n.status)if(n.gzhead.extra){for(i=n.pending;n.gzindex<(65535&n.gzhead.extra.length)&&(n.pending!==n.pending_buf_size||(n.gzhead.hcrc&&n.pending>i&&(t.adler=T(t.adler,n.pending_buf,n.pending-i,i)),R(t),i=n.pending,n.pending!==n.pending_buf_size));)dist_E(n,255&n.gzhead.extra[n.gzindex]),n.gzindex++;n.gzhead.hcrc&&n.pending>i&&(t.adler=T(t.adler,n.pending_buf,n.pending-i,i)),n.gzindex===n.gzhead.extra.length&&(n.gzindex=0,n.status=73)}else n.status=73;if(73===n.status)if(n.gzhead.name){i=n.pending;do{if(n.pending===n.pending_buf_size&&(n.gzhead.hcrc&&n.pending>i&&(t.adler=T(t.adler,n.pending_buf,n.pending-i,i)),R(t),i=n.pending,n.pending===n.pending_buf_size)){r=1;break}r=n.gzindex<n.gzhead.name.length?255&n.gzhead.name.charCodeAt(n.gzindex++):0,dist_E(n,r)}while(0!==r);n.gzhead.hcrc&&n.pending>i&&(t.adler=T(t.adler,n.pending_buf,n.pending-i,i)),0===r&&(n.gzindex=0,n.status=91)}else n.status=91;if(91===n.status)if(n.gzhead.comment){i=n.pending;do{if(n.pending===n.pending_buf_size&&(n.gzhead.hcrc&&n.pending>i&&(t.adler=T(t.adler,n.pending_buf,n.pending-i,i)),R(t),i=n.pending,n.pending===n.pending_buf_size)){r=1;break}r=n.gzindex<n.gzhead.comment.length?255&n.gzhead.comment.charCodeAt(n.gzindex++):0,dist_E(n,r)}while(0!==r);n.gzhead.hcrc&&n.pending>i&&(t.adler=T(t.adler,n.pending_buf,n.pending-i,i)),0===r&&(n.status=103)}else n.status=103;if(103===n.status&&(n.gzhead.hcrc?(n.pending+2>n.pending_buf_size&&R(t),n.pending+2<=n.pending_buf_size&&(dist_E(n,255&t.adler),dist_E(n,t.adler>>8&255),t.adler=0,n.status=113)):n.status=113),0!==n.pending){if(R(t),0===t.avail_out)return n.last_flush=-1,0}else if(0===t.avail_in&&G(e)<=G(a)&&4!==e)return M(t,-5);if(666===n.status&&0!==t.avail_in)return M(t,-5);if(0!==t.avail_in||0!==n.lookahead||0!==e&&666!==n.status){var d=2===n.strategy?function(t,e){for(var a;;){if(0===t.lookahead&&(K(t),0===t.lookahead)){if(0===e)return 1;break}if(t.match_length=0,a=U._tr_tally(t,0,t.window[t.strstart]),t.lookahead--,t.strstart++,a&&(F(t,!1),0===t.strm.avail_out))return 1}return t.insert=0,4===e?(F(t,!0),0===t.strm.avail_out?3:4):t.last_lit&&(F(t,!1),0===t.strm.avail_out)?1:2}(n,e):3===n.strategy?function(t,e){for(var a,n,i,r,s=t.window;;){if(t.lookahead<=258){if(K(t),t.lookahead<=258&&0===e)return 1;if(0===t.lookahead)break}if(t.match_length=0,t.lookahead>=3&&t.strstart>0&&(n=s[i=t.strstart-1])===s[++i]&&n===s[++i]&&n===s[++i]){r=t.strstart+258;do{}while(n===s[++i]&&n===s[++i]&&n===s[++i]&&n===s[++i]&&n===s[++i]&&n===s[++i]&&n===s[++i]&&n===s[++i]&&i<r);t.match_length=258-(r-i),t.match_length>t.lookahead&&(t.match_length=t.lookahead)}if(t.match_length>=3?(a=U._tr_tally(t,1,t.match_length-3),t.lookahead-=t.match_length,t.strstart+=t.match_length,t.match_length=0):(a=U._tr_tally(t,0,t.window[t.strstart]),t.lookahead--,t.strstart++),a&&(F(t,!1),0===t.strm.avail_out))return 1}return t.insert=0,4===e?(F(t,!0),0===t.strm.avail_out?3:4):t.last_lit&&(F(t,!1),0===t.strm.avail_out)?1:2}(n,e):dist_S[n.level].func(n,e);if(3!==d&&4!==d||(n.status=666),1===d||3===d)return 0===t.avail_out&&(n.last_flush=-1),0;if(2===d&&(1===e?U._tr_align(n):5!==e&&(U._tr_stored_block(n,0,0,!1),3===e&&(J(n.head),0===n.lookahead&&(n.strstart=0,n.block_start=0,n.insert=0))),R(t),0===t.avail_out))return n.last_flush=-1,0}return 4!==e?0:n.wrap<=0?1:(2===n.wrap?(dist_E(n,255&t.adler),dist_E(n,t.adler>>8&255),dist_E(n,t.adler>>16&255),dist_E(n,t.adler>>24&255),dist_E(n,255&t.total_in),dist_E(n,t.total_in>>8&255),dist_E(n,t.total_in>>16&255),dist_E(n,t.total_in>>24&255)):(C(n,t.adler>>>16),C(n,65535&t.adler)),R(t),n.wrap>0&&(n.wrap=-n.wrap),0!==n.pending?0:1)},deflateEnd:function(t){var e;return t&&t.state?42!==(e=t.state.status)&&69!==e&&73!==e&&91!==e&&103!==e&&113!==e&&666!==e?M(t,-2):(t.state=null,113===e?M(t,-3):0):-2},deflateSetDictionary:function(t,e){var n,i,r,s,d,o,l,f,h=e.length;if(!t||!t.state)return-2;if(2===(s=(n=t.state).wrap)||1===s&&42!==n.status||n.lookahead)return-2;for(1===s&&(t.adler=D(t.adler,e,h,0)),n.wrap=0,h>=n.w_size&&(0===s&&(J(n.head),n.strstart=0,n.block_start=0,n.insert=0),f=new dist_a.Buf8(n.w_size),dist_a.arraySet(f,e,h-n.w_size,n.w_size,0),e=f,h=n.w_size),d=t.avail_in,o=t.next_in,l=t.input,t.avail_in=h,t.next_in=0,t.input=e,K(n);n.lookahead>=3;){i=n.strstart,r=n.lookahead-2;do{n.ins_h=(n.ins_h<<n.hash_shift^n.window[i+3-1])&n.hash_mask,n.prev[i&n.w_mask]=n.head[n.ins_h],n.head[n.ins_h]=i,i++}while(--r);n.strstart=i,n.lookahead=2,K(n)}return n.strstart+=n.lookahead,n.block_start=n.strstart,n.insert=n.lookahead,n.lookahead=0,n.match_length=n.prev_length=2,n.match_available=0,t.next_in=o,t.input=l,t.avail_in=d,n.wrap=s,0},deflateInfo:"pako deflate (from Nodeca project)"},it=!0,rt=!0;try{String.fromCharCode.apply(null,[0])}catch(t){it=!1}try{String.fromCharCode.apply(null,new Uint8Array(1))}catch(t){rt=!1}for(var st=new dist_a.Buf8(256),dt=0;dt<256;dt++)st[dt]=dt>=252?6:dt>=248?5:dt>=240?4:dt>=224?3:dt>=192?2:1;function ot(t,e){if(e<65534&&(t.subarray&&rt||!t.subarray&&it))return String.fromCharCode.apply(null,dist_a.shrinkBuf(t,e));for(var n="",i=0;i<e;i++)n+=String.fromCharCode(t[i]);return n}st[254]=st[254]=1;var lt=function(t){var e,n,i,r,s,d=t.length,o=0;for(r=0;r<d;r++)55296==(64512&(n=t.charCodeAt(r)))&&r+1<d&&56320==(64512&(i=t.charCodeAt(r+1)))&&(n=65536+(n-55296<<10)+(i-56320),r++),o+=n<128?1:n<2048?2:n<65536?3:4;for(e=new dist_a.Buf8(o),s=0,r=0;s<o;r++)55296==(64512&(n=t.charCodeAt(r)))&&r+1<d&&56320==(64512&(i=t.charCodeAt(r+1)))&&(n=65536+(n-55296<<10)+(i-56320),r++),n<128?e[s++]=n:n<2048?(e[s++]=192|n>>>6,e[s++]=128|63&n):n<65536?(e[s++]=224|n>>>12,e[s++]=128|n>>>6&63,e[s++]=128|63&n):(e[s++]=240|n>>>18,e[s++]=128|n>>>12&63,e[s++]=128|n>>>6&63,e[s++]=128|63&n);return e},ft=function(t){return ot(t,t.length)},ut=function(t,e){var a,n,i,r,s=e||t.length,d=new Array(2*s);for(n=0,a=0;a<s;)if((i=t[a++])<128)d[n++]=i;else if((r=st[i])>4)d[n++]=65533,a+=r-1;else{for(i&=2===r?31:3===r?15:7;r>1&&a<s;)i=i<<6|63&t[a++],r--;r>1?d[n++]=65533:i<65536?d[n++]=i:(i-=65536,d[n++]=55296|i>>10&1023,d[n++]=56320|1023&i)}return ot(d,n)},ct=function(t,e){var a;for((e=e||t.length)>t.length&&(e=t.length),a=e-1;a>=0&&128==(192&t[a]);)a--;return a<0||0===a?e:a+st[t[a]]>e?a:e},bt=function(){this.input=null,this.next_in=0,this.avail_in=0,this.total_in=0,this.output=null,this.next_out=0,this.avail_out=0,this.total_out=0,this.msg="",this.state=null,this.data_type=2,this.adler=0},vt=Object.prototype.toString;function wt(t){if(!(this instanceof wt))return new wt(t);this.options=dist_a.assign({level:-1,method:8,chunkSize:16384,windowBits:15,memLevel:8,strategy:0,to:""},t||{});var e=this.options;e.raw&&e.windowBits>0?e.windowBits=-e.windowBits:e.gzip&&e.windowBits>0&&e.windowBits<16&&(e.windowBits+=16),this.err=0,this.msg="",this.ended=!1,this.chunks=[],this.strm=new bt,this.strm.avail_out=0;var n=nt.deflateInit2(this.strm,e.level,e.method,e.windowBits,e.memLevel,e.strategy);if(0!==n)throw new Error(dist_N[n]);if(e.header&&nt.deflateSetHeader(this.strm,e.header),e.dictionary){var i;if(i="string"==typeof e.dictionary?lt(e.dictionary):"[object ArrayBuffer]"===vt.call(e.dictionary)?new Uint8Array(e.dictionary):e.dictionary,0!==(n=nt.deflateSetDictionary(this.strm,i)))throw new Error(dist_N[n]);this._dict_set=!0}}function pt(t,e){var a=new wt(e);if(a.push(t,!0),a.err)throw a.msg||dist_N[a.err];return a.result}wt.prototype.push=function(t,e){var n,i,r=this.strm,s=this.options.chunkSize;if(this.ended)return!1;i=e===~~e?e:!0===e?4:0,"string"==typeof t?r.input=lt(t):"[object ArrayBuffer]"===vt.call(t)?r.input=new Uint8Array(t):r.input=t,r.next_in=0,r.avail_in=r.input.length;do{if(0===r.avail_out&&(r.output=new dist_a.Buf8(s),r.next_out=0,r.avail_out=s),1!==(n=nt.deflate(r,i))&&0!==n)return this.onEnd(n),this.ended=!0,!1;0!==r.avail_out&&(0!==r.avail_in||4!==i&&2!==i)||("string"===this.options.to?this.onData(ft(dist_a.shrinkBuf(r.output,r.next_out))):this.onData(dist_a.shrinkBuf(r.output,r.next_out)))}while((r.avail_in>0||0===r.avail_out)&&1!==n);return 4===i?(n=nt.deflateEnd(this.strm),this.onEnd(n),this.ended=!0,0===n):2!==i||(this.onEnd(0),r.avail_out=0,!0)},wt.prototype.onData=function(t){this.chunks.push(t)},wt.prototype.onEnd=function(t){0===t&&("string"===this.options.to?this.result=this.chunks.join(""):this.result=dist_a.flattenChunks(this.chunks)),this.chunks=[],this.err=t,this.msg=this.strm.msg};var mt={Deflate:wt,deflate:pt,deflateRaw:function(t,e){return(e=e||{}).raw=!0,pt(t,e)},gzip:function(t,e){return(e=e||{}).gzip=!0,pt(t,e)}},kt=function(t,e){var a,n,i,r,s,d,o,l,f,h,u,c,b,v,w,p,m,k,x,X,g,z,L,y,P;a=t.state,n=t.next_in,y=t.input,i=n+(t.avail_in-5),r=t.next_out,P=t.output,s=r-(e-t.avail_out),d=r+(t.avail_out-257),o=a.dmax,l=a.wsize,f=a.whave,h=a.wnext,u=a.window,c=a.hold,b=a.bits,v=a.lencode,w=a.distcode,p=(1<<a.lenbits)-1,m=(1<<a.distbits)-1;t:do{b<15&&(c+=y[n++]<<b,b+=8,c+=y[n++]<<b,b+=8),k=v[c&p];e:for(;;){if(c>>>=x=k>>>24,b-=x,0==(x=k>>>16&255))P[r++]=65535&k;else{if(!(16&x)){if(0==(64&x)){k=v[(65535&k)+(c&(1<<x)-1)];continue e}if(32&x){a.mode=12;break t}t.msg="invalid literal/length code",a.mode=30;break t}X=65535&k,(x&=15)&&(b<x&&(c+=y[n++]<<b,b+=8),X+=c&(1<<x)-1,c>>>=x,b-=x),b<15&&(c+=y[n++]<<b,b+=8,c+=y[n++]<<b,b+=8),k=w[c&m];a:for(;;){if(c>>>=x=k>>>24,b-=x,!(16&(x=k>>>16&255))){if(0==(64&x)){k=w[(65535&k)+(c&(1<<x)-1)];continue a}t.msg="invalid distance code",a.mode=30;break t}if(g=65535&k,b<(x&=15)&&(c+=y[n++]<<b,(b+=8)<x&&(c+=y[n++]<<b,b+=8)),(g+=c&(1<<x)-1)>o){t.msg="invalid distance too far back",a.mode=30;break t}if(c>>>=x,b-=x,g>(x=r-s)){if((x=g-x)>f&&a.sane){t.msg="invalid distance too far back",a.mode=30;break t}if(z=0,L=u,0===h){if(z+=l-x,x<X){X-=x;do{P[r++]=u[z++]}while(--x);z=r-g,L=P}}else if(h<x){if(z+=l+h-x,(x-=h)<X){X-=x;do{P[r++]=u[z++]}while(--x);if(z=0,h<X){X-=x=h;do{P[r++]=u[z++]}while(--x);z=r-g,L=P}}}else if(z+=h-x,x<X){X-=x;do{P[r++]=u[z++]}while(--x);z=r-g,L=P}for(;X>2;)P[r++]=L[z++],P[r++]=L[z++],P[r++]=L[z++],X-=3;X&&(P[r++]=L[z++],X>1&&(P[r++]=L[z++]))}else{z=r-g;do{P[r++]=P[z++],P[r++]=P[z++],P[r++]=P[z++],X-=3}while(X>2);X&&(P[r++]=P[z++],X>1&&(P[r++]=P[z++]))}break}}break}}while(n<i&&r<d);n-=X=b>>3,c&=(1<<(b-=X<<3))-1,t.next_in=n,t.next_out=r,t.avail_in=n<i?i-n+5:5-(n-i),t.avail_out=r<d?d-r+257:257-(r-d),a.hold=c,a.bits=b},xt=[3,4,5,6,7,8,9,10,11,13,15,17,19,23,27,31,35,43,51,59,67,83,99,115,131,163,195,227,258,0,0],Xt=[16,16,16,16,16,16,16,16,17,17,17,17,18,18,18,18,19,19,19,19,20,20,20,20,21,21,21,21,16,72,78],gt=[1,2,3,4,5,7,9,13,17,25,33,49,65,97,129,193,257,385,513,769,1025,1537,2049,3073,4097,6145,8193,12289,16385,24577,0,0],zt=[16,16,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,25,25,26,26,27,27,28,28,29,29,64,64],Lt=function(t,e,n,i,r,s,d,o){var l,f,h,u,c,b,v,w,p,m=o.bits,k=0,x=0,X=0,g=0,z=0,L=0,y=0,P=0,q=0,O=0,Z=null,V=0,j=new dist_a.Buf16(16),H=new dist_a.Buf16(16),B=null,W=0;for(k=0;k<=15;k++)j[k]=0;for(x=0;x<i;x++)j[e[n+x]]++;for(z=m,g=15;g>=1&&0===j[g];g--);if(z>g&&(z=g),0===g)return r[s++]=20971520,r[s++]=20971520,o.bits=1,0;for(X=1;X<g&&0===j[X];X++);for(z<X&&(z=X),P=1,k=1;k<=15;k++)if(P<<=1,(P-=j[k])<0)return-1;if(P>0&&(0===t||1!==g))return-1;for(H[1]=0,k=1;k<15;k++)H[k+1]=H[k]+j[k];for(x=0;x<i;x++)0!==e[n+x]&&(d[H[e[n+x]]++]=x);if(0===t?(Z=B=d,b=19):1===t?(Z=xt,V-=257,B=Xt,W-=257,b=256):(Z=gt,B=zt,b=-1),O=0,x=0,k=X,c=s,L=z,y=0,h=-1,u=(q=1<<z)-1,1===t&&q>852||2===t&&q>592)return 1;for(;;){v=k-y,d[x]<b?(w=0,p=d[x]):d[x]>b?(w=B[W+d[x]],p=Z[V+d[x]]):(w=96,p=0),l=1<<k-y,X=f=1<<L;do{r[c+(O>>y)+(f-=l)]=v<<24|w<<16|p|0}while(0!==f);for(l=1<<k-1;O&l;)l>>=1;if(0!==l?(O&=l-1,O+=l):O=0,x++,0==--j[k]){if(k===g)break;k=e[n+d[x]]}if(k>z&&(O&u)!==h){for(0===y&&(y=z),c+=X,P=1<<(L=k-y);L+y<g&&!((P-=j[L+y])<=0);)L++,P<<=1;if(q+=1<<L,1===t&&q>852||2===t&&q>592)return 1;r[h=O&u]=z<<24|L<<16|c-s|0}}return 0!==O&&(r[c+O]=k-y<<24|64<<16|0),o.bits=z,0};function yt(t){return(t>>>24&255)+(t>>>8&65280)+((65280&t)<<8)+((255&t)<<24)}function Pt(){this.mode=0,this.last=!1,this.wrap=0,this.havedict=!1,this.flags=0,this.dmax=0,this.check=0,this.total=0,this.head=null,this.wbits=0,this.wsize=0,this.whave=0,this.wnext=0,this.window=null,this.hold=0,this.bits=0,this.length=0,this.offset=0,this.extra=0,this.lencode=null,this.distcode=null,this.lenbits=0,this.distbits=0,this.ncode=0,this.nlen=0,this.ndist=0,this.have=0,this.next=null,this.lens=new dist_a.Buf16(320),this.work=new dist_a.Buf16(288),this.lendyn=null,this.distdyn=null,this.sane=0,this.back=0,this.was=0}function qt(t){var e;return t&&t.state?(e=t.state,t.total_in=t.total_out=e.total=0,t.msg="",e.wrap&&(t.adler=1&e.wrap),e.mode=1,e.last=0,e.havedict=0,e.dmax=32768,e.head=null,e.hold=0,e.bits=0,e.lencode=e.lendyn=new dist_a.Buf32(852),e.distcode=e.distdyn=new dist_a.Buf32(592),e.sane=1,e.back=-1,0):-2}function Ot(t){var e;return t&&t.state?((e=t.state).wsize=0,e.whave=0,e.wnext=0,qt(t)):-2}function Zt(t,e){var a,n;return t&&t.state?(n=t.state,e<0?(a=0,e=-e):(a=1+(e>>4),e<48&&(e&=15)),e&&(e<8||e>15)?-2:(null!==n.window&&n.wbits!==e&&(n.window=null),n.wrap=a,n.wbits=e,Ot(t))):-2}function Vt(t,e){var a,n;return t?(n=new Pt,t.state=n,n.window=null,0!==(a=Zt(t,e))&&(t.state=null),a):-2}var jt,Ht,Bt=!0;function Wt(t){if(Bt){var e;for(jt=new dist_a.Buf32(512),Ht=new dist_a.Buf32(32),e=0;e<144;)t.lens[e++]=8;for(;e<256;)t.lens[e++]=9;for(;e<280;)t.lens[e++]=7;for(;e<288;)t.lens[e++]=8;for(Lt(1,t.lens,0,288,jt,0,t.work,{bits:9}),e=0;e<32;)t.lens[e++]=5;Lt(2,t.lens,0,32,Ht,0,t.work,{bits:5}),Bt=!1}t.lencode=jt,t.lenbits=9,t.distcode=Ht,t.distbits=5}function Ut(t,e,n,i){var r,s=t.state;return null===s.window&&(s.wsize=1<<s.wbits,s.wnext=0,s.whave=0,s.window=new dist_a.Buf8(s.wsize)),i>=s.wsize?(dist_a.arraySet(s.window,e,n-s.wsize,s.wsize,0),s.wnext=0,s.whave=s.wsize):((r=s.wsize-s.wnext)>i&&(r=i),dist_a.arraySet(s.window,e,n-i,r,s.wnext),(i-=r)?(dist_a.arraySet(s.window,e,n-i,i,0),s.wnext=i,s.whave=s.wsize):(s.wnext+=r,s.wnext===s.wsize&&(s.wnext=0),s.whave<s.wsize&&(s.whave+=r))),0}var Dt={inflateReset:Ot,inflateReset2:Zt,inflateResetKeep:qt,inflateInit:function(t){return Vt(t,15)},inflateInit2:Vt,inflate:function(t,e){var n,i,r,s,d,o,l,f,h,u,c,b,v,w,p,m,k,x,X,g,z,L,y,P,q=0,O=new dist_a.Buf8(4),Z=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15];if(!t||!t.state||!t.output||!t.input&&0!==t.avail_in)return-2;12===(n=t.state).mode&&(n.mode=13),d=t.next_out,r=t.output,l=t.avail_out,s=t.next_in,i=t.input,o=t.avail_in,f=n.hold,h=n.bits,u=o,c=l,L=0;t:for(;;)switch(n.mode){case 1:if(0===n.wrap){n.mode=13;break}for(;h<16;){if(0===o)break t;o--,f+=i[s++]<<h,h+=8}if(2&n.wrap&&35615===f){n.check=0,O[0]=255&f,O[1]=f>>>8&255,n.check=T(n.check,O,2,0),f=0,h=0,n.mode=2;break}if(n.flags=0,n.head&&(n.head.done=!1),!(1&n.wrap)||(((255&f)<<8)+(f>>8))%31){t.msg="incorrect header check",n.mode=30;break}if(8!=(15&f)){t.msg="unknown compression method",n.mode=30;break}if(h-=4,z=8+(15&(f>>>=4)),0===n.wbits)n.wbits=z;else if(z>n.wbits){t.msg="invalid window size",n.mode=30;break}n.dmax=1<<z,t.adler=n.check=1,n.mode=512&f?10:12,f=0,h=0;break;case 2:for(;h<16;){if(0===o)break t;o--,f+=i[s++]<<h,h+=8}if(n.flags=f,8!=(255&n.flags)){t.msg="unknown compression method",n.mode=30;break}if(57344&n.flags){t.msg="unknown header flags set",n.mode=30;break}n.head&&(n.head.text=f>>8&1),512&n.flags&&(O[0]=255&f,O[1]=f>>>8&255,n.check=T(n.check,O,2,0)),f=0,h=0,n.mode=3;case 3:for(;h<32;){if(0===o)break t;o--,f+=i[s++]<<h,h+=8}n.head&&(n.head.time=f),512&n.flags&&(O[0]=255&f,O[1]=f>>>8&255,O[2]=f>>>16&255,O[3]=f>>>24&255,n.check=T(n.check,O,4,0)),f=0,h=0,n.mode=4;case 4:for(;h<16;){if(0===o)break t;o--,f+=i[s++]<<h,h+=8}n.head&&(n.head.xflags=255&f,n.head.os=f>>8),512&n.flags&&(O[0]=255&f,O[1]=f>>>8&255,n.check=T(n.check,O,2,0)),f=0,h=0,n.mode=5;case 5:if(1024&n.flags){for(;h<16;){if(0===o)break t;o--,f+=i[s++]<<h,h+=8}n.length=f,n.head&&(n.head.extra_len=f),512&n.flags&&(O[0]=255&f,O[1]=f>>>8&255,n.check=T(n.check,O,2,0)),f=0,h=0}else n.head&&(n.head.extra=null);n.mode=6;case 6:if(1024&n.flags&&((b=n.length)>o&&(b=o),b&&(n.head&&(z=n.head.extra_len-n.length,n.head.extra||(n.head.extra=new Array(n.head.extra_len)),dist_a.arraySet(n.head.extra,i,s,b,z)),512&n.flags&&(n.check=T(n.check,i,b,s)),o-=b,s+=b,n.length-=b),n.length))break t;n.length=0,n.mode=7;case 7:if(2048&n.flags){if(0===o)break t;b=0;do{z=i[s+b++],n.head&&z&&n.length<65536&&(n.head.name+=String.fromCharCode(z))}while(z&&b<o);if(512&n.flags&&(n.check=T(n.check,i,b,s)),o-=b,s+=b,z)break t}else n.head&&(n.head.name=null);n.length=0,n.mode=8;case 8:if(4096&n.flags){if(0===o)break t;b=0;do{z=i[s+b++],n.head&&z&&n.length<65536&&(n.head.comment+=String.fromCharCode(z))}while(z&&b<o);if(512&n.flags&&(n.check=T(n.check,i,b,s)),o-=b,s+=b,z)break t}else n.head&&(n.head.comment=null);n.mode=9;case 9:if(512&n.flags){for(;h<16;){if(0===o)break t;o--,f+=i[s++]<<h,h+=8}if(f!==(65535&n.check)){t.msg="header crc mismatch",n.mode=30;break}f=0,h=0}n.head&&(n.head.hcrc=n.flags>>9&1,n.head.done=!0),t.adler=n.check=0,n.mode=12;break;case 10:for(;h<32;){if(0===o)break t;o--,f+=i[s++]<<h,h+=8}t.adler=n.check=yt(f),f=0,h=0,n.mode=11;case 11:if(0===n.havedict)return t.next_out=d,t.avail_out=l,t.next_in=s,t.avail_in=o,n.hold=f,n.bits=h,2;t.adler=n.check=1,n.mode=12;case 12:if(5===e||6===e)break t;case 13:if(n.last){f>>>=7&h,h-=7&h,n.mode=27;break}for(;h<3;){if(0===o)break t;o--,f+=i[s++]<<h,h+=8}switch(n.last=1&f,h-=1,3&(f>>>=1)){case 0:n.mode=14;break;case 1:if(Wt(n),n.mode=20,6===e){f>>>=2,h-=2;break t}break;case 2:n.mode=17;break;case 3:t.msg="invalid block type",n.mode=30}f>>>=2,h-=2;break;case 14:for(f>>>=7&h,h-=7&h;h<32;){if(0===o)break t;o--,f+=i[s++]<<h,h+=8}if((65535&f)!=(f>>>16^65535)){t.msg="invalid stored block lengths",n.mode=30;break}if(n.length=65535&f,f=0,h=0,n.mode=15,6===e)break t;case 15:n.mode=16;case 16:if(b=n.length){if(b>o&&(b=o),b>l&&(b=l),0===b)break t;dist_a.arraySet(r,i,s,b,d),o-=b,s+=b,l-=b,d+=b,n.length-=b;break}n.mode=12;break;case 17:for(;h<14;){if(0===o)break t;o--,f+=i[s++]<<h,h+=8}if(n.nlen=257+(31&f),f>>>=5,h-=5,n.ndist=1+(31&f),f>>>=5,h-=5,n.ncode=4+(15&f),f>>>=4,h-=4,n.nlen>286||n.ndist>30){t.msg="too many length or distance symbols",n.mode=30;break}n.have=0,n.mode=18;case 18:for(;n.have<n.ncode;){for(;h<3;){if(0===o)break t;o--,f+=i[s++]<<h,h+=8}n.lens[Z[n.have++]]=7&f,f>>>=3,h-=3}for(;n.have<19;)n.lens[Z[n.have++]]=0;if(n.lencode=n.lendyn,n.lenbits=7,y={bits:n.lenbits},L=Lt(0,n.lens,0,19,n.lencode,0,n.work,y),n.lenbits=y.bits,L){t.msg="invalid code lengths set",n.mode=30;break}n.have=0,n.mode=19;case 19:for(;n.have<n.nlen+n.ndist;){for(;m=(q=n.lencode[f&(1<<n.lenbits)-1])>>>16&255,k=65535&q,!((p=q>>>24)<=h);){if(0===o)break t;o--,f+=i[s++]<<h,h+=8}if(k<16)f>>>=p,h-=p,n.lens[n.have++]=k;else{if(16===k){for(P=p+2;h<P;){if(0===o)break t;o--,f+=i[s++]<<h,h+=8}if(f>>>=p,h-=p,0===n.have){t.msg="invalid bit length repeat",n.mode=30;break}z=n.lens[n.have-1],b=3+(3&f),f>>>=2,h-=2}else if(17===k){for(P=p+3;h<P;){if(0===o)break t;o--,f+=i[s++]<<h,h+=8}h-=p,z=0,b=3+(7&(f>>>=p)),f>>>=3,h-=3}else{for(P=p+7;h<P;){if(0===o)break t;o--,f+=i[s++]<<h,h+=8}h-=p,z=0,b=11+(127&(f>>>=p)),f>>>=7,h-=7}if(n.have+b>n.nlen+n.ndist){t.msg="invalid bit length repeat",n.mode=30;break}for(;b--;)n.lens[n.have++]=z}}if(30===n.mode)break;if(0===n.lens[256]){t.msg="invalid code -- missing end-of-block",n.mode=30;break}if(n.lenbits=9,y={bits:n.lenbits},L=Lt(1,n.lens,0,n.nlen,n.lencode,0,n.work,y),n.lenbits=y.bits,L){t.msg="invalid literal/lengths set",n.mode=30;break}if(n.distbits=6,n.distcode=n.distdyn,y={bits:n.distbits},L=Lt(2,n.lens,n.nlen,n.ndist,n.distcode,0,n.work,y),n.distbits=y.bits,L){t.msg="invalid distances set",n.mode=30;break}if(n.mode=20,6===e)break t;case 20:n.mode=21;case 21:if(o>=6&&l>=258){t.next_out=d,t.avail_out=l,t.next_in=s,t.avail_in=o,n.hold=f,n.bits=h,kt(t,c),d=t.next_out,r=t.output,l=t.avail_out,s=t.next_in,i=t.input,o=t.avail_in,f=n.hold,h=n.bits,12===n.mode&&(n.back=-1);break}for(n.back=0;m=(q=n.lencode[f&(1<<n.lenbits)-1])>>>16&255,k=65535&q,!((p=q>>>24)<=h);){if(0===o)break t;o--,f+=i[s++]<<h,h+=8}if(m&&0==(240&m)){for(x=p,X=m,g=k;m=(q=n.lencode[g+((f&(1<<x+X)-1)>>x)])>>>16&255,k=65535&q,!(x+(p=q>>>24)<=h);){if(0===o)break t;o--,f+=i[s++]<<h,h+=8}f>>>=x,h-=x,n.back+=x}if(f>>>=p,h-=p,n.back+=p,n.length=k,0===m){n.mode=26;break}if(32&m){n.back=-1,n.mode=12;break}if(64&m){t.msg="invalid literal/length code",n.mode=30;break}n.extra=15&m,n.mode=22;case 22:if(n.extra){for(P=n.extra;h<P;){if(0===o)break t;o--,f+=i[s++]<<h,h+=8}n.length+=f&(1<<n.extra)-1,f>>>=n.extra,h-=n.extra,n.back+=n.extra}n.was=n.length,n.mode=23;case 23:for(;m=(q=n.distcode[f&(1<<n.distbits)-1])>>>16&255,k=65535&q,!((p=q>>>24)<=h);){if(0===o)break t;o--,f+=i[s++]<<h,h+=8}if(0==(240&m)){for(x=p,X=m,g=k;m=(q=n.distcode[g+((f&(1<<x+X)-1)>>x)])>>>16&255,k=65535&q,!(x+(p=q>>>24)<=h);){if(0===o)break t;o--,f+=i[s++]<<h,h+=8}f>>>=x,h-=x,n.back+=x}if(f>>>=p,h-=p,n.back+=p,64&m){t.msg="invalid distance code",n.mode=30;break}n.offset=k,n.extra=15&m,n.mode=24;case 24:if(n.extra){for(P=n.extra;h<P;){if(0===o)break t;o--,f+=i[s++]<<h,h+=8}n.offset+=f&(1<<n.extra)-1,f>>>=n.extra,h-=n.extra,n.back+=n.extra}if(n.offset>n.dmax){t.msg="invalid distance too far back",n.mode=30;break}n.mode=25;case 25:if(0===l)break t;if(b=c-l,n.offset>b){if((b=n.offset-b)>n.whave&&n.sane){t.msg="invalid distance too far back",n.mode=30;break}b>n.wnext?(b-=n.wnext,v=n.wsize-b):v=n.wnext-b,b>n.length&&(b=n.length),w=n.window}else w=r,v=d-n.offset,b=n.length;b>l&&(b=l),l-=b,n.length-=b;do{r[d++]=w[v++]}while(--b);0===n.length&&(n.mode=21);break;case 26:if(0===l)break t;r[d++]=n.length,l--,n.mode=21;break;case 27:if(n.wrap){for(;h<32;){if(0===o)break t;o--,f|=i[s++]<<h,h+=8}if(c-=l,t.total_out+=c,n.total+=c,c&&(t.adler=n.check=n.flags?T(n.check,r,c,d-c):D(n.check,r,c,d-c)),c=l,(n.flags?f:yt(f))!==n.check){t.msg="incorrect data check",n.mode=30;break}f=0,h=0}n.mode=28;case 28:if(n.wrap&&n.flags){for(;h<32;){if(0===o)break t;o--,f+=i[s++]<<h,h+=8}if(f!==(4294967295&n.total)){t.msg="incorrect length check",n.mode=30;break}f=0,h=0}n.mode=29;case 29:L=1;break t;case 30:L=-3;break t;case 31:return-4;case 32:default:return-2}return t.next_out=d,t.avail_out=l,t.next_in=s,t.avail_in=o,n.hold=f,n.bits=h,(n.wsize||c!==t.avail_out&&n.mode<30&&(n.mode<27||4!==e))&&Ut(t,t.output,t.next_out,c-t.avail_out),u-=t.avail_in,c-=t.avail_out,t.total_in+=u,t.total_out+=c,n.total+=c,n.wrap&&c&&(t.adler=n.check=n.flags?T(n.check,r,c,t.next_out-c):D(n.check,r,c,t.next_out-c)),t.data_type=n.bits+(n.last?64:0)+(12===n.mode?128:0)+(20===n.mode||15===n.mode?256:0),(0===u&&0===c||4===e)&&0===L&&(L=-5),L},inflateEnd:function(t){if(!t||!t.state)return-2;var e=t.state;return e.window&&(e.window=null),t.state=null,0},inflateGetHeader:function(t,e){var a;return t&&t.state?0==(2&(a=t.state).wrap)?-2:(a.head=e,e.done=!1,0):-2},inflateSetDictionary:function(t,e){var a,n=e.length;return t&&t.state?0!==(a=t.state).wrap&&11!==a.mode?-2:11===a.mode&&D(1,e,n,0)!==a.check?-3:Ut(t,e,n,n)?(a.mode=31,-4):(a.havedict=1,0):-2},inflateInfo:"pako inflate (from Nodeca project)"},At={Z_NO_FLUSH:0,Z_PARTIAL_FLUSH:1,Z_SYNC_FLUSH:2,Z_FULL_FLUSH:3,Z_FINISH:4,Z_BLOCK:5,Z_TREES:6,Z_OK:0,Z_STREAM_END:1,Z_NEED_DICT:2,Z_ERRNO:-1,Z_STREAM_ERROR:-2,Z_DATA_ERROR:-3,Z_BUF_ERROR:-5,Z_NO_COMPRESSION:0,Z_BEST_SPEED:1,Z_BEST_COMPRESSION:9,Z_DEFAULT_COMPRESSION:-1,Z_FILTERED:1,Z_HUFFMAN_ONLY:2,Z_RLE:3,Z_FIXED:4,Z_DEFAULT_STRATEGY:0,Z_BINARY:0,Z_TEXT:1,Z_UNKNOWN:2,Z_DEFLATED:8},St=function(){this.text=0,this.time=0,this.xflags=0,this.os=0,this.extra=null,this.extra_len=0,this.name="",this.comment="",this.hcrc=0,this.done=!1},Tt=Object.prototype.toString;function Nt(t){if(!(this instanceof Nt))return new Nt(t);this.options=dist_a.assign({chunkSize:16384,windowBits:0,to:""},t||{});var e=this.options;e.raw&&e.windowBits>=0&&e.windowBits<16&&(e.windowBits=-e.windowBits,0===e.windowBits&&(e.windowBits=-15)),!(e.windowBits>=0&&e.windowBits<16)||t&&t.windowBits||(e.windowBits+=32),e.windowBits>15&&e.windowBits<48&&0==(15&e.windowBits)&&(e.windowBits|=15),this.err=0,this.msg="",this.ended=!1,this.chunks=[],this.strm=new bt,this.strm.avail_out=0;var n=Dt.inflateInit2(this.strm,e.windowBits);if(n!==At.Z_OK)throw new Error(dist_N[n]);if(this.header=new St,Dt.inflateGetHeader(this.strm,this.header),e.dictionary&&("string"==typeof e.dictionary?e.dictionary=lt(e.dictionary):"[object ArrayBuffer]"===Tt.call(e.dictionary)&&(e.dictionary=new Uint8Array(e.dictionary)),e.raw&&(n=Dt.inflateSetDictionary(this.strm,e.dictionary))!==At.Z_OK))throw new Error(dist_N[n])}function Mt(t,e){var a=new Nt(e);if(a.push(t,!0),a.err)throw a.msg||dist_N[a.err];return a.result}Nt.prototype.push=function(t,e){var n,i,r,s,d,o=this.strm,l=this.options.chunkSize,f=this.options.dictionary,h=!1;if(this.ended)return!1;i=e===~~e?e:!0===e?At.Z_FINISH:At.Z_NO_FLUSH,"string"==typeof t?o.input=function(t){for(var e=new dist_a.Buf8(t.length),n=0,i=e.length;n<i;n++)e[n]=t.charCodeAt(n);return e}(t):"[object ArrayBuffer]"===Tt.call(t)?o.input=new Uint8Array(t):o.input=t,o.next_in=0,o.avail_in=o.input.length;do{if(0===o.avail_out&&(o.output=new dist_a.Buf8(l),o.next_out=0,o.avail_out=l),(n=Dt.inflate(o,At.Z_NO_FLUSH))===At.Z_NEED_DICT&&f&&(n=Dt.inflateSetDictionary(this.strm,f)),n===At.Z_BUF_ERROR&&!0===h&&(n=At.Z_OK,h=!1),n!==At.Z_STREAM_END&&n!==At.Z_OK)return this.onEnd(n),this.ended=!0,!1;o.next_out&&(0!==o.avail_out&&n!==At.Z_STREAM_END&&(0!==o.avail_in||i!==At.Z_FINISH&&i!==At.Z_SYNC_FLUSH)||("string"===this.options.to?(r=ct(o.output,o.next_out),s=o.next_out-r,d=ut(o.output,r),o.next_out=s,o.avail_out=l-s,s&&dist_a.arraySet(o.output,o.output,r,s,0),this.onData(d)):this.onData(dist_a.shrinkBuf(o.output,o.next_out)))),0===o.avail_in&&0===o.avail_out&&(h=!0)}while((o.avail_in>0||0===o.avail_out)&&n!==At.Z_STREAM_END);return n===At.Z_STREAM_END&&(i=At.Z_FINISH),i===At.Z_FINISH?(n=Dt.inflateEnd(this.strm),this.onEnd(n),this.ended=!0,n===At.Z_OK):i!==At.Z_SYNC_FLUSH||(this.onEnd(At.Z_OK),o.avail_out=0,!0)},Nt.prototype.onData=function(t){this.chunks.push(t)},Nt.prototype.onEnd=function(t){t===At.Z_OK&&("string"===this.options.to?this.result=this.chunks.join(""):this.result=dist_a.flattenChunks(this.chunks)),this.chunks=[],this.err=t,this.msg=this.strm.msg};var Gt={Inflate:Nt,inflate:Mt,inflateRaw:function(t,e){return(e=e||{}).raw=!0,Mt(t,e)},ungzip:Mt},Jt={};(0,dist_a.assign)(Jt,mt,Gt,At);var Rt=Jt;const Ft=URL.createObjectURL(new Blob([Rt.inflate(atob("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"))],{type:"text/javascript"})),Et=Uint8Array.from(Rt.inflate(atob("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