"""
This package contains all tools that are useful for training system identification models
as well as things that can be applied to neural network training in general.
This includes:
  - context_managers: managing device state and eval state
  - cyclers: objects for cycling through the data
  - early_stopping: controlling the training loop
  - tracking: objects that can be used for training performance and progress during training
"""

from .context_managers import eval_state, device_state
from .early_stopping import early_stopping
from .tracking import TimeObjectiveTracker, MultipleObjectiveTracker
