# Quingo Runtime System

Along with quingo compilers, the Quingo runtime system which provides users the capability to program and simulate Quingo programs.

## Installation

The Quingo installation comprises of two main steps:

### Install the Runtime system and simulator
Install Quingo runtime system with required simulators using the following command:
```sh
pip install quingo
```

Upon success, it will automatically install the Quingo runtime system (this package), the PyQCAS simulator and the PyQCISim simulator.

### Install the Quingo compiler

Two versions of Quingo compiler has been developed:
1. the mlir-based compiler, it can generate QCIS instructions which can be simulated by PyQCISim.
2. the xtext-based compiler, it can generate eQASM instructions which can be simulated by PyQCAS


#### Install the Mlir-based Compiler

Install the mlir-based Quingo compiler using the following command:
```sh
python -m quingo.install_quingoc
```

#### Install the Xtext-based Compiler

At present, the java executable file of xtext-based compiler has not yet been automatically downloaded, so users need to download [java executable](https://github.com/Quingo/compiler_xtext/releases) separately to get the xtext-based compiler.

After downloading the binary, you need to call specify the compiler path for once in python using the following commands:
```python
import quingo
# for xtext compiler
quingo.set_xtext_compiler_path(<path-to-quingo.jar>)
```

## Usage
A simple example can be found in the directory `src/examples`. You can simply run the bell_state example by running:
```sh
cd src/examples/bell_state
python host.py
```
If everything runs correctly, you should see the following output:
```sh
connecting pyqcisim_quantumsim...
num_qubits:  2
The result of bell_state is:
(['q0', 'q1'], {'00': 504, '01': 0, '10': 0, '11': 496})
```

## APIs of the Quingo runtime system
The `Quingo_interface` class expose the following methods:
 - `set_log_level(<log_level>)`: `<log_level>` can be one of `DEBUG`, `INFO`, `WARNING`, `ERROR`, or `CRITICAL`.
 - `connect_backend(<backend>)`: `<backend>` currently can be `'pyqcas_quantumsim'` or `'pyqcisim_quantumsim'`.
- `get_backend_name()`: return the name of the backend that is being used. An empty string will be returned if no backend has been set.
- `set_compiler(<compiler_name>)`: `<compiler_name>` can be `'mlir'` or `'xtext'`.
- `get_last_qasm()`: get the qasm code generated by the last execution.
- `config_execution(<mode>, <num_shots>)`:
  -  Configure the execution mode to `'one_shot'` or `'state_vector'`.
  -  When the execution mode is `'one_shot'`, the number of times to run the uploaded quantum circuit can be configured using the parameter `num_shots` at the same time.
-  `call_quingo(<qg_filename>, <qg_func_name>, *args)`:
   - the main entry to call Quingo operation.
   - `<qg_filename (str)>` :  the name of the Qingo file which contains the quantum function called by the host program.
   - `<qg_func_name (str)>` : the name of the quantum function
   - `<args (dict)>`: a variable length of parameters used to call the Quingo operation in the form `qg_func_name(<args>)`.
 - `read_result()`: read the computation result from the quantum kernel.
   - For eQASM-based backend, the result is a binary block which encodes the quantum computation result.
   - For QCIS-based backend, the result format is defined by PyQCISim. Please refer to the docstring of `quingo.if_backend.non_arch_backend.pyqcisim_quantumsim.PyQCISim_quantumsim::execute()`

## Quingo programming tutorial
At present, Qingguo runtime system has included sample programs such as `Bell_state`, `GHZ`, `VQE`, etc. Details can be found [here](https://gitee.com/quingo/quingo-runtime/tree/master/src/examples).