interface HandlerResponse {
    readonly status: 'SUCCESS' | 'FAILED';
    readonly reason: 'OK' | string;
    readonly data?: any;
}
export declare abstract class CustomResourceHandler<Request extends object, Response extends object> {
    protected readonly event: AWSLambda.CloudFormationCustomResourceEvent;
    protected readonly context: AWSLambda.Context;
    readonly physicalResourceId: string;
    private readonly timeout;
    private timedOut;
    constructor(event: AWSLambda.CloudFormationCustomResourceEvent, context: AWSLambda.Context);
    /**
     * Handles executing the custom resource event. If `stateMachineArn` is present
     * in the props then trigger the waiter statemachine
     */
    handle(): Promise<Response | undefined>;
    /**
     * Handle async requests from the waiter state machine
     */
    handleIsComplete(): Promise<Response | undefined>;
    /**
     * Start a step function state machine which will wait for the request
     * to be successful.
     */
    private startExecution;
    protected abstract processEvent(request: Request): Promise<Response | undefined>;
    respond(response: HandlerResponse): Promise<unknown> | undefined;
}
export {};
