# -*- coding: utf-8 -*-

"""
coingeckoapiv3

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from coingeckoapiv3.api_helper import APIHelper
from coingeckoapiv3.configuration import Server
from coingeckoapiv3.controllers.base_controller import BaseController


class IndexesController(BaseController):

    """A Controller to access Endpoints in the coingeckoapiv3 API."""

    def __init__(self, config, call_back=None):
        super(IndexesController, self).__init__(config, call_back)

    def listallmarketindexes(self,
                             per_page=None,
                             page=None):
        """Does a GET request to /indexes.

        List all market indexes

        Args:
            per_page (int, optional): Total results per page
            page (int, optional): Page through results

        Returns:
            void: Response from the API. List all market indexes

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/indexes'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            'per_page': per_page,
            'page': page
        }
        _query_builder = APIHelper.append_url_with_query_parameters(
            _query_builder,
            _query_parameters
        )
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        _response = self.execute_request(_request)
        self.validate_response(_response)

    def getmarketindexbymarketidandindexid(self,
                                           market_id,
                                           id):
        """Does a GET request to /indexes/{market_id}/{id}.

        get market index by market id and index id

        Args:
            market_id (string): pass the market id (can be obtained from
                /exchanges/list)
            id (string): pass the index id (can be obtained from
                /indexes/list)

        Returns:
            void: Response from the API. get market index by market id and
                index id

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/indexes/{market_id}/{id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'market_id': {'value': market_id, 'encode': True},
            'id': {'value': id, 'encode': True}
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        _response = self.execute_request(_request)
        self.validate_response(_response)

    def listmarketindexesidandname(self):
        """Does a GET request to /indexes/list.

        list market indexes id and name

        Returns:
            void: Response from the API. list market indexes id and name

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/indexes/list'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        _response = self.execute_request(_request)
        self.validate_response(_response)
