yaml = '''
---
apiVersion: v1
kind: PersistentVolume
metadata:
  name: storage-loki
  labels:
    app: loki
spec:
  capacity:
    storage: 5Gi
  volumeMode: Filesystem
  accessModes:
    - ReadWriteOnce
  persistentVolumeReclaimPolicy: Retain
  storageClassName: local-storage
  local:
    path: /opt/loki
  nodeAffinity:
    required:
      nodeSelectorTerms:
        - matchExpressions:
            - key: kubernetes.io/hostname
              operator: In
              values:
                - <node-name>
---
apiVersion: v1
kind: PersistentVolume
metadata:
  name: storage-grafana
  labels:
    app: grafana
spec:
  capacity:
    storage: 1Gi
  volumeMode: Filesystem
  accessModes:
    - ReadWriteOnce
  persistentVolumeReclaimPolicy: Retain
  storageClassName: local-storage
  local:
    path: /opt/grafana
  nodeAffinity:
    required:
      nodeSelectorTerms:
        - matchExpressions:
            - key: kubernetes.io/hostname
              operator: In
              values:
                - <node-name>
---
apiVersion: v1
kind: PersistentVolume
metadata:
  name: storage-prometheus
  labels:
    app: prometheus
    prometheus: prometheus-kube-prometheus-prometheus
spec:
  capacity:
    storage: 5Gi
  volumeMode: Filesystem
  accessModes:
    - ReadWriteOnce
  persistentVolumeReclaimPolicy: Retain
  local:
    path: /opt/prometheus
  nodeAffinity:
    required:
      nodeSelectorTerms:
        - matchExpressions:
            - key: kubernetes.io/hostname
              operator: In
              values:
                - <node-name>
---
apiVersion: v1
kind: PersistentVolume
metadata:
  name: storage-rabbitmq
  namespace: service
  labels:
    app: rabbitmq
spec:
  capacity:
    storage: 10Gi
  volumeMode: Filesystem
  accessModes:
    - ReadWriteOnce
  persistentVolumeReclaimPolicy: Retain
  storageClassName: local-storage
  local:
    path: /opt/rabbitmq
  nodeAffinity:
    required:
      nodeSelectorTerms:
        - matchExpressions:
            - key: kubernetes.io/hostname
              operator: In
              values:
                - <node-name>
---
#if you neeed to deploy onfra-git
#apiVersion: v1
#kind: PersistentVolume
#metadata:
#  name: repos-volume
#  labels:
#    app: repos-volume
#spec:
#  capacity:
#    storage: 5Gi
#  volumeMode: Filesystem
#  accessModes:
#    - ReadWriteMany
#  persistentVolumeReclaimPolicy: Retain
#  storageClassName: local-storage
#  local:
#    path: /opt/git
#  nodeAffinity:
#    required:
#      nodeSelectorTerms:
#        - matchExpressions:
#            - key: kubernetes.io/hostname
#              operator: In
#              values:
#                - <node-name>
'''
