"use strict";
// Copyright 2012-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
exports.VPNMetrics = exports.TransitGatewayMetrics = exports.NATGatewayMetrics = exports.EC2Metrics = exports.EBSMetrics = exports.EC2CapacityReservationsMetrics = void 0;
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class EC2CapacityReservationsMetrics {
    static instanceUtilizationAverage(dimensions) {
        return {
            namespace: 'AWS/EC2CapacityReservations',
            metricName: 'InstanceUtilization',
            dimensions,
            statistic: 'Average',
        };
    }
    static usedInstanceCountAverage(dimensions) {
        return {
            namespace: 'AWS/EC2CapacityReservations',
            metricName: 'UsedInstanceCount',
            dimensions,
            statistic: 'Average',
        };
    }
    static availableInstanceCountAverage(dimensions) {
        return {
            namespace: 'AWS/EC2CapacityReservations',
            metricName: 'AvailableInstanceCount',
            dimensions,
            statistic: 'Average',
        };
    }
    static totalInstanceCountAverage(dimensions) {
        return {
            namespace: 'AWS/EC2CapacityReservations',
            metricName: 'TotalInstanceCount',
            dimensions,
            statistic: 'Average',
        };
    }
}
exports.EC2CapacityReservationsMetrics = EC2CapacityReservationsMetrics;
class EBSMetrics {
    static volumeReadBytesSum(dimensions) {
        return {
            namespace: 'AWS/EBS',
            metricName: 'VolumeReadBytes',
            dimensions,
            statistic: 'Sum',
        };
    }
    static volumeWriteBytesSum(dimensions) {
        return {
            namespace: 'AWS/EBS',
            metricName: 'VolumeWriteBytes',
            dimensions,
            statistic: 'Sum',
        };
    }
    static volumeReadOpsSum(dimensions) {
        return {
            namespace: 'AWS/EBS',
            metricName: 'VolumeReadOps',
            dimensions,
            statistic: 'Sum',
        };
    }
    static volumeTotalReadTimeAverage(dimensions) {
        return {
            namespace: 'AWS/EBS',
            metricName: 'VolumeTotalReadTime',
            dimensions,
            statistic: 'Average',
        };
    }
    static volumeWriteOpsSum(dimensions) {
        return {
            namespace: 'AWS/EBS',
            metricName: 'VolumeWriteOps',
            dimensions,
            statistic: 'Sum',
        };
    }
    static volumeTotalWriteTimeAverage(dimensions) {
        return {
            namespace: 'AWS/EBS',
            metricName: 'VolumeTotalWriteTime',
            dimensions,
            statistic: 'Average',
        };
    }
    static volumeIdleTimeAverage(dimensions) {
        return {
            namespace: 'AWS/EBS',
            metricName: 'VolumeIdleTime',
            dimensions,
            statistic: 'Average',
        };
    }
    static volumeQueueLengthAverage(dimensions) {
        return {
            namespace: 'AWS/EBS',
            metricName: 'VolumeQueueLength',
            dimensions,
            statistic: 'Average',
        };
    }
    static burstBalanceAverage(dimensions) {
        return {
            namespace: 'AWS/EBS',
            metricName: 'BurstBalance',
            dimensions,
            statistic: 'Average',
        };
    }
}
exports.EBSMetrics = EBSMetrics;
class EC2Metrics {
    static cpuUtilizationAverage(dimensions) {
        return {
            namespace: 'AWS/EC2',
            metricName: 'CPUUtilization',
            dimensions,
            statistic: 'Average',
        };
    }
    static statusCheckFailedSum(dimensions) {
        return {
            namespace: 'AWS/EC2',
            metricName: 'StatusCheckFailed',
            dimensions,
            statistic: 'Sum',
        };
    }
    static statusCheckFailedInstanceSum(dimensions) {
        return {
            namespace: 'AWS/EC2',
            metricName: 'StatusCheckFailed_Instance',
            dimensions,
            statistic: 'Sum',
        };
    }
    static statusCheckFailedSystemSum(dimensions) {
        return {
            namespace: 'AWS/EC2',
            metricName: 'StatusCheckFailed_System',
            dimensions,
            statistic: 'Sum',
        };
    }
    static diskReadBytesAverage(dimensions) {
        return {
            namespace: 'AWS/EC2',
            metricName: 'DiskReadBytes',
            dimensions,
            statistic: 'Average',
        };
    }
    static diskReadOpsAverage(dimensions) {
        return {
            namespace: 'AWS/EC2',
            metricName: 'DiskReadOps',
            dimensions,
            statistic: 'Average',
        };
    }
    static diskWriteBytesAverage(dimensions) {
        return {
            namespace: 'AWS/EC2',
            metricName: 'DiskWriteBytes',
            dimensions,
            statistic: 'Average',
        };
    }
    static diskWriteOpsAverage(dimensions) {
        return {
            namespace: 'AWS/EC2',
            metricName: 'DiskWriteOps',
            dimensions,
            statistic: 'Average',
        };
    }
    static networkInAverage(dimensions) {
        return {
            namespace: 'AWS/EC2',
            metricName: 'NetworkIn',
            dimensions,
            statistic: 'Average',
        };
    }
    static networkOutAverage(dimensions) {
        return {
            namespace: 'AWS/EC2',
            metricName: 'NetworkOut',
            dimensions,
            statistic: 'Average',
        };
    }
    static networkPacketsInAverage(dimensions) {
        return {
            namespace: 'AWS/EC2',
            metricName: 'NetworkPacketsIn',
            dimensions,
            statistic: 'Average',
        };
    }
    static networkPacketsOutAverage(dimensions) {
        return {
            namespace: 'AWS/EC2',
            metricName: 'NetworkPacketsOut',
            dimensions,
            statistic: 'Average',
        };
    }
}
exports.EC2Metrics = EC2Metrics;
class NATGatewayMetrics {
    static activeConnectionCountMaximum(dimensions) {
        return {
            namespace: 'AWS/NATGateway',
            metricName: 'ActiveConnectionCount',
            dimensions,
            statistic: 'Maximum',
        };
    }
    static packetsDropCountSum(dimensions) {
        return {
            namespace: 'AWS/NATGateway',
            metricName: 'PacketsDropCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static bytesInFromDestinationSum(dimensions) {
        return {
            namespace: 'AWS/NATGateway',
            metricName: 'BytesInFromDestination',
            dimensions,
            statistic: 'Sum',
        };
    }
    static bytesInFromSourceSum(dimensions) {
        return {
            namespace: 'AWS/NATGateway',
            metricName: 'BytesInFromSource',
            dimensions,
            statistic: 'Sum',
        };
    }
    static bytesOutToDestinationSum(dimensions) {
        return {
            namespace: 'AWS/NATGateway',
            metricName: 'BytesOutToDestination',
            dimensions,
            statistic: 'Sum',
        };
    }
    static bytesOutToSourceSum(dimensions) {
        return {
            namespace: 'AWS/NATGateway',
            metricName: 'BytesOutToSource',
            dimensions,
            statistic: 'Sum',
        };
    }
    static connectionAttemptCountSum(dimensions) {
        return {
            namespace: 'AWS/NATGateway',
            metricName: 'ConnectionAttemptCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static connectionEstablishedCountSum(dimensions) {
        return {
            namespace: 'AWS/NATGateway',
            metricName: 'ConnectionEstablishedCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static errorPortAllocationSum(dimensions) {
        return {
            namespace: 'AWS/NATGateway',
            metricName: 'ErrorPortAllocation',
            dimensions,
            statistic: 'Sum',
        };
    }
    static idleTimeoutCountSum(dimensions) {
        return {
            namespace: 'AWS/NATGateway',
            metricName: 'IdleTimeoutCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static packetsInFromDestinationSum(dimensions) {
        return {
            namespace: 'AWS/NATGateway',
            metricName: 'PacketsInFromDestination',
            dimensions,
            statistic: 'Sum',
        };
    }
    static packetsInFromSourceSum(dimensions) {
        return {
            namespace: 'AWS/NATGateway',
            metricName: 'PacketsInFromSource',
            dimensions,
            statistic: 'Sum',
        };
    }
    static packetsOutToDestinationSum(dimensions) {
        return {
            namespace: 'AWS/NATGateway',
            metricName: 'PacketsOutToDestination',
            dimensions,
            statistic: 'Sum',
        };
    }
    static packetsOutToSourceSum(dimensions) {
        return {
            namespace: 'AWS/NATGateway',
            metricName: 'PacketsOutToSource',
            dimensions,
            statistic: 'Sum',
        };
    }
}
exports.NATGatewayMetrics = NATGatewayMetrics;
class TransitGatewayMetrics {
    static bytesInSum(dimensions) {
        return {
            namespace: 'AWS/TransitGateway',
            metricName: 'BytesIn',
            dimensions,
            statistic: 'Sum',
        };
    }
    static bytesOutSum(dimensions) {
        return {
            namespace: 'AWS/TransitGateway',
            metricName: 'BytesOut',
            dimensions,
            statistic: 'Sum',
        };
    }
    static packetDropCountBlackholeSum(dimensions) {
        return {
            namespace: 'AWS/TransitGateway',
            metricName: 'PacketDropCountBlackhole',
            dimensions,
            statistic: 'Sum',
        };
    }
    static packetDropCountNoRouteSum(dimensions) {
        return {
            namespace: 'AWS/TransitGateway',
            metricName: 'PacketDropCountNoRoute',
            dimensions,
            statistic: 'Sum',
        };
    }
    static packetsInSum(dimensions) {
        return {
            namespace: 'AWS/TransitGateway',
            metricName: 'PacketsIn',
            dimensions,
            statistic: 'Sum',
        };
    }
    static packetsOutSum(dimensions) {
        return {
            namespace: 'AWS/TransitGateway',
            metricName: 'PacketsOut',
            dimensions,
            statistic: 'Sum',
        };
    }
}
exports.TransitGatewayMetrics = TransitGatewayMetrics;
class VPNMetrics {
    static tunnelDataInSum(dimensions) {
        return {
            namespace: 'AWS/VPN',
            metricName: 'TunnelDataIn',
            dimensions,
            statistic: 'Sum',
        };
    }
    static tunnelStateAverage(dimensions) {
        return {
            namespace: 'AWS/VPN',
            metricName: 'TunnelState',
            dimensions,
            statistic: 'Average',
        };
    }
    static tunnelDataOutSum(dimensions) {
        return {
            namespace: 'AWS/VPN',
            metricName: 'TunnelDataOut',
            dimensions,
            statistic: 'Sum',
        };
    }
}
exports.VPNMetrics = VPNMetrics;
//# sourceMappingURL=data:application/json;base64,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