import * as cdk from '@aws-cdk/core';
/**
 * Opsgenie Team resource schema.
 *
 * @schema CfnTeamProps
 */
export interface CfnTeamProps {
    /**
     * Team name.
     *
     * @schema CfnTeamProps#Name
     */
    readonly name: string;
    /**
     * Team description.
     *
     * @schema CfnTeamProps#Description
     */
    readonly description?: string;
    /**
     * Array of members.
     *
     * @schema CfnTeamProps#Members
     */
    readonly members?: Member[];
    /**
     * Api Key.
     *
     * @schema CfnTeamProps#OpsgenieApiKey
     */
    readonly opsgenieApiKey?: string;
    /**
     * Api endpoint.
     *
     * @schema CfnTeamProps#OpsgenieApiEndpoint
     */
    readonly opsgenieApiEndpoint?: string;
}
/**
 * Converts an object of type 'CfnTeamProps' to JSON representation.
 */
export declare function toJson_CfnTeamProps(obj: CfnTeamProps | undefined): Record<string, any> | undefined;
/**
 * @schema Member
 */
export interface Member {
    /**
     * @schema Member#UserId
     */
    readonly userId?: string;
    /**
     * @schema Member#Role
     */
    readonly role?: string;
}
/**
 * Converts an object of type 'Member' to JSON representation.
 */
export declare function toJson_Member(obj: Member | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `Atlassian::Opsgenie::Team`.
 *
 * @external
 * @cloudformationResource Atlassian::Opsgenie::Team
 * @link https://github.com/opsgenie/opsgenie-cloudformation-resources
 */
export declare class CfnTeam extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "Atlassian::Opsgenie::Team";
    /**
     * Resource props.
     *
     * @external
     */
    readonly props: CfnTeamProps;
    /**
     * Attribute `Atlassian::Opsgenie::Team.TeamId`.
     *
     * @external
     * @link https://github.com/opsgenie/opsgenie-cloudformation-resources
     */
    readonly attrTeamId: string;
    /**
     * Create a new `Atlassian::Opsgenie::Team`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTeamProps);
}
