import sinterbot.algorithms as algo
import unittest
from collections import defaultdict
import ast

class TestFunctions(unittest.TestCase):
    # All derangements of length 5
    all5 = [[1, 0, 3, 4, 2], [1, 0, 4, 2, 3], [1, 2, 0, 4, 3], [1, 2, 3, 4, 0], [1, 2, 4, 0, 3], [1, 3, 0, 4, 2], [1, 3, 4, 0, 2], [1, 3, 4, 2, 0], [1, 4, 0, 2, 3], [1, 4, 3, 0, 2], [1, 4, 3, 2, 0], [2, 0, 1, 4, 3], [2, 0, 3, 4, 1], [2, 0, 4, 1, 3], [2, 3, 0, 4, 1], [2, 3, 1, 4, 0], [2, 3, 4, 0, 1], [2, 3, 4, 1, 0], [2, 4, 0, 1, 3], [2, 4, 1, 0, 3], [2, 4, 3, 0, 1], [2, 4, 3, 1, 0], [3, 0, 1, 4, 2], [3, 0, 4, 1, 2], [3, 0, 4, 2, 1], [3, 2, 0, 4, 1], [3, 2, 1, 4, 0], [3, 2, 4, 0, 1], [3, 2, 4, 1, 0], [3, 4, 0, 1, 2], [3, 4, 0, 2, 1], [3, 4, 1, 0, 2], [3, 4, 1, 2, 0], [4, 0, 1, 2, 3], [4, 0, 3, 1, 2], [4, 0, 3, 2, 1], [4, 2, 0, 1, 3], [4, 2, 1, 0, 3], [4, 2, 3, 0, 1], [4, 2, 3, 1, 0], [4, 3, 0, 1, 2], [4, 3, 0, 2, 1], [4, 3, 1, 0, 2], [4, 3, 1, 2, 0]]
   
    def test_generate_5(self):
        """
        Test that all of the generation functions generate all 44 derangements
        correctly.
        """
        ITERATIONS = 1000
        functs = ['generate_backtrack', 'generate_all', 'generate_rejection', 'rand_derangement']
        for f in functs:
           func = getattr(algo, f)
           d = defaultdict(int)
           for i in range(ITERATIONS):
               p = func(5)
               d[repr(p)] += 1
           for p in d.keys():
               perm = ast.literal_eval(p)
               self.assertTrue(perm in self.all5)

    def test_constrained(self):
        d = defaultdict(int)
        for i in range(1000):
            p = algo.constrained(5,3,[(0,1)])
            d[repr(p)] += 1
        self.assertEqual(12, len(d.keys()))

class TestUtilities(unittest.TestCase):

    oeis_dn = [1, 0, 1, 2, 9, 44, 265, 1854, 14833, 133496, 1334961, 14684570, 176214841, 2290792932, 32071101049, 481066515734, 7697064251745, 130850092279664, 2355301661033953, 44750731559645106, 895014631192902121, 18795307255050944540, 413496759611120779881, 9510425471055777937262]

    def test_dn(self):
        for i in range(len(self.oeis_dn)):
            dn = algo.Dn(i)
            self.assertEqual(dn, self.oeis_dn[i])

    def all_derangements(self):
        for i in range(5):
            dn = len(list(algo.all_derangements(i)))
            self.assertEqual(dn, self.oeis_dn(i))

    def test_decompose(self):
        # All decompositions for n=5
        gold = {(0, 1, 2, 3, 4): [[0], [1], [2], [3], [4]], (0, 1, 2, 4, 3): [[0], [1], [2], [4, 3]], (0, 1, 3, 2, 4): [[0], [1], [3, 2], [4]], (0, 1, 3, 4, 2): [[0], [1], [3, 4, 2]], (0, 1, 4, 2, 3): [[0], [1], [4, 3, 2]], (0, 1, 4, 3, 2): [[0], [1], [4, 2], [3]], (0, 2, 1, 3, 4): [[0], [2, 1], [3], [4]], (0, 2, 1, 4, 3): [[0], [2, 1], [4, 3]], (0, 2, 3, 1, 4): [[0], [2, 3, 1], [4]], (0, 2, 3, 4, 1): [[0], [2, 3, 4, 1]], (0, 2, 4, 1, 3): [[0], [2, 4, 3, 1]], (0, 2, 4, 3, 1): [[0], [2, 4, 1], [3]], (0, 3, 1, 2, 4): [[0], [3, 2, 1], [4]], (0, 3, 1, 4, 2): [[0], [3, 4, 2, 1]], (0, 3, 2, 1, 4): [[0], [3, 1], [2], [4]], (0, 3, 2, 4, 1): [[0], [3, 4, 1], [2]], (0, 3, 4, 1, 2): [[0], [3, 1], [4, 2]], (0, 3, 4, 2, 1): [[0], [3, 2, 4, 1]], (0, 4, 1, 2, 3): [[0], [4, 3, 2, 1]], (0, 4, 1, 3, 2): [[0], [4, 2, 1], [3]], (0, 4, 2, 1, 3): [[0], [4, 3, 1], [2]], (0, 4, 2, 3, 1): [[0], [4, 1], [2], [3]], (0, 4, 3, 1, 2): [[0], [4, 2, 3, 1]], (0, 4, 3, 2, 1): [[0], [4, 1], [3, 2]], (1, 0, 2, 3, 4): [[1, 0], [2], [3], [4]], (1, 0, 2, 4, 3): [[1, 0], [2], [4, 3]], (1, 0, 3, 2, 4): [[1, 0], [3, 2], [4]], (1, 0, 3, 4, 2): [[1, 0], [3, 4, 2]], (1, 0, 4, 2, 3): [[1, 0], [4, 3, 2]], (1, 0, 4, 3, 2): [[1, 0], [4, 2], [3]], (1, 2, 0, 3, 4): [[1, 2, 0], [3], [4]], (1, 2, 0, 4, 3): [[1, 2, 0], [4, 3]], (1, 2, 3, 0, 4): [[1, 2, 3, 0], [4]], (1, 2, 3, 4, 0): [[1, 2, 3, 4, 0]], (1, 2, 4, 0, 3): [[1, 2, 4, 3, 0]], (1, 2, 4, 3, 0): [[1, 2, 4, 0], [3]], (1, 3, 0, 2, 4): [[1, 3, 2, 0], [4]], (1, 3, 0, 4, 2): [[1, 3, 4, 2, 0]], (1, 3, 2, 0, 4): [[1, 3, 0], [2], [4]], (1, 3, 2, 4, 0): [[1, 3, 4, 0], [2]], (1, 3, 4, 0, 2): [[1, 3, 0], [4, 2]], (1, 3, 4, 2, 0): [[1, 3, 2, 4, 0]], (1, 4, 0, 2, 3): [[1, 4, 3, 2, 0]], (1, 4, 0, 3, 2): [[1, 4, 2, 0], [3]], (1, 4, 2, 0, 3): [[1, 4, 3, 0], [2]], (1, 4, 2, 3, 0): [[1, 4, 0], [2], [3]], (1, 4, 3, 0, 2): [[1, 4, 2, 3, 0]], (1, 4, 3, 2, 0): [[1, 4, 0], [3, 2]], (2, 0, 1, 3, 4): [[2, 1, 0], [3], [4]], (2, 0, 1, 4, 3): [[2, 1, 0], [4, 3]], (2, 0, 3, 1, 4): [[2, 3, 1, 0], [4]], (2, 0, 3, 4, 1): [[2, 3, 4, 1, 0]], (2, 0, 4, 1, 3): [[2, 4, 3, 1, 0]], (2, 0, 4, 3, 1): [[2, 4, 1, 0], [3]], (2, 1, 0, 3, 4): [[2, 0], [1], [3], [4]], (2, 1, 0, 4, 3): [[2, 0], [1], [4, 3]], (2, 1, 3, 0, 4): [[2, 3, 0], [1], [4]], (2, 1, 3, 4, 0): [[2, 3, 4, 0], [1]], (2, 1, 4, 0, 3): [[2, 4, 3, 0], [1]], (2, 1, 4, 3, 0): [[2, 4, 0], [1], [3]], (2, 3, 0, 1, 4): [[2, 0], [3, 1], [4]], (2, 3, 0, 4, 1): [[2, 0], [3, 4, 1]], (2, 3, 1, 0, 4): [[2, 1, 3, 0], [4]], (2, 3, 1, 4, 0): [[2, 1, 3, 4, 0]], (2, 3, 4, 0, 1): [[2, 4, 1, 3, 0]], (2, 3, 4, 1, 0): [[2, 4, 0], [3, 1]], (2, 4, 0, 1, 3): [[2, 0], [4, 3, 1]], (2, 4, 0, 3, 1): [[2, 0], [4, 1], [3]], (2, 4, 1, 0, 3): [[2, 1, 4, 3, 0]], (2, 4, 1, 3, 0): [[2, 1, 4, 0], [3]], (2, 4, 3, 0, 1): [[2, 3, 0], [4, 1]], (2, 4, 3, 1, 0): [[2, 3, 1, 4, 0]], (3, 0, 1, 2, 4): [[3, 2, 1, 0], [4]], (3, 0, 1, 4, 2): [[3, 4, 2, 1, 0]], (3, 0, 2, 1, 4): [[3, 1, 0], [2], [4]], (3, 0, 2, 4, 1): [[3, 4, 1, 0], [2]], (3, 0, 4, 1, 2): [[3, 1, 0], [4, 2]], (3, 0, 4, 2, 1): [[3, 2, 4, 1, 0]], (3, 1, 0, 2, 4): [[3, 2, 0], [1], [4]], (3, 1, 0, 4, 2): [[3, 4, 2, 0], [1]], (3, 1, 2, 0, 4): [[3, 0], [1], [2], [4]], (3, 1, 2, 4, 0): [[3, 4, 0], [1], [2]], (3, 1, 4, 0, 2): [[3, 0], [1], [4, 2]], (3, 1, 4, 2, 0): [[3, 2, 4, 0], [1]], (3, 2, 0, 1, 4): [[3, 1, 2, 0], [4]], (3, 2, 0, 4, 1): [[3, 4, 1, 2, 0]], (3, 2, 1, 0, 4): [[3, 0], [2, 1], [4]], (3, 2, 1, 4, 0): [[3, 4, 0], [2, 1]], (3, 2, 4, 0, 1): [[3, 0], [2, 4, 1]], (3, 2, 4, 1, 0): [[3, 1, 2, 4, 0]], (3, 4, 0, 1, 2): [[3, 1, 4, 2, 0]], (3, 4, 0, 2, 1): [[3, 2, 0], [4, 1]], (3, 4, 1, 0, 2): [[3, 0], [4, 2, 1]], (3, 4, 1, 2, 0): [[3, 2, 1, 4, 0]], (3, 4, 2, 0, 1): [[3, 0], [4, 1], [2]], (3, 4, 2, 1, 0): [[3, 1, 4, 0], [2]], (4, 0, 1, 2, 3): [[4, 3, 2, 1, 0]], (4, 0, 1, 3, 2): [[4, 2, 1, 0], [3]], (4, 0, 2, 1, 3): [[4, 3, 1, 0], [2]], (4, 0, 2, 3, 1): [[4, 1, 0], [2], [3]], (4, 0, 3, 1, 2): [[4, 2, 3, 1, 0]], (4, 0, 3, 2, 1): [[4, 1, 0], [3, 2]], (4, 1, 0, 2, 3): [[4, 3, 2, 0], [1]], (4, 1, 0, 3, 2): [[4, 2, 0], [1], [3]], (4, 1, 2, 0, 3): [[4, 3, 0], [1], [2]], (4, 1, 2, 3, 0): [[4, 0], [1], [2], [3]], (4, 1, 3, 0, 2): [[4, 2, 3, 0], [1]], (4, 1, 3, 2, 0): [[4, 0], [1], [3, 2]], (4, 2, 0, 1, 3): [[4, 3, 1, 2, 0]], (4, 2, 0, 3, 1): [[4, 1, 2, 0], [3]], (4, 2, 1, 0, 3): [[4, 3, 0], [2, 1]], (4, 2, 1, 3, 0): [[4, 0], [2, 1], [3]], (4, 2, 3, 0, 1): [[4, 1, 2, 3, 0]], (4, 2, 3, 1, 0): [[4, 0], [2, 3, 1]], (4, 3, 0, 1, 2): [[4, 2, 0], [3, 1]], (4, 3, 0, 2, 1): [[4, 1, 3, 2, 0]], (4, 3, 1, 0, 2): [[4, 2, 1, 3, 0]], (4, 3, 1, 2, 0): [[4, 0], [3, 2, 1]], (4, 3, 2, 0, 1): [[4, 1, 3, 0], [2]], (4, 3, 2, 1, 0): [[4, 0], [3, 1], [2]]}
        for k, v in gold.items():
            self.assertEqual(algo.decompose(k), v)

    def test_check_deranged(self):
        self.assertFalse(algo.check_deranged([0,2,1,4,3]))
