import sys

import logging


server_logger = logging.getLogger('server')


class Port:
    def __set__(self, instance, value):
        if not 1023 < value < 65536:
            server_logger.critical(
                f'Попытка запуска с указанием неподходящего порта '
                f'{value}. Допустимы адреса с 1024 до 65535.')
            sys.exit(1)
            # Если порт прошел проверку, добавляем его в список атрибутов
            # экземпляра

        instance.__dict__[self.name] = value

    def __set_name__(self, owner, name):
        # owner -   объект класса Server
        # name - port
        self.name = name
