# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IotRouteArgs', 'IotRoute']

@pulumi.input_type
class IotRouteArgs:
    def __init__(__self__, *,
                 hub_id: pulumi.Input[str],
                 topic: pulumi.Input[str],
                 database: Optional[pulumi.Input['IotRouteDatabaseArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 rest: Optional[pulumi.Input['IotRouteRestArgs']] = None,
                 s3: Optional[pulumi.Input['IotRouteS3Args']] = None):
        """
        The set of arguments for constructing a IotRoute resource.
        :param pulumi.Input[str] hub_id: The ID of the route's hub
        :param pulumi.Input[str] topic: The Topic the route subscribes to (wildcards allowed)
        :param pulumi.Input['IotRouteDatabaseArgs'] database: Database Route parameters
        :param pulumi.Input[str] name: The name of the route
        :param pulumi.Input[str] region: The region you want to attach the resource to
        :param pulumi.Input['IotRouteRestArgs'] rest: Rest Route parameters
        :param pulumi.Input['IotRouteS3Args'] s3: S3 Route parameters
        """
        pulumi.set(__self__, "hub_id", hub_id)
        pulumi.set(__self__, "topic", topic)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rest is not None:
            pulumi.set(__self__, "rest", rest)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)

    @property
    @pulumi.getter(name="hubId")
    def hub_id(self) -> pulumi.Input[str]:
        """
        The ID of the route's hub
        """
        return pulumi.get(self, "hub_id")

    @hub_id.setter
    def hub_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "hub_id", value)

    @property
    @pulumi.getter
    def topic(self) -> pulumi.Input[str]:
        """
        The Topic the route subscribes to (wildcards allowed)
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: pulumi.Input[str]):
        pulumi.set(self, "topic", value)

    @property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input['IotRouteDatabaseArgs']]:
        """
        Database Route parameters
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input['IotRouteDatabaseArgs']]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the route
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region you want to attach the resource to
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def rest(self) -> Optional[pulumi.Input['IotRouteRestArgs']]:
        """
        Rest Route parameters
        """
        return pulumi.get(self, "rest")

    @rest.setter
    def rest(self, value: Optional[pulumi.Input['IotRouteRestArgs']]):
        pulumi.set(self, "rest", value)

    @property
    @pulumi.getter
    def s3(self) -> Optional[pulumi.Input['IotRouteS3Args']]:
        """
        S3 Route parameters
        """
        return pulumi.get(self, "s3")

    @s3.setter
    def s3(self, value: Optional[pulumi.Input['IotRouteS3Args']]):
        pulumi.set(self, "s3", value)


@pulumi.input_type
class _IotRouteState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[str]] = None,
                 database: Optional[pulumi.Input['IotRouteDatabaseArgs']] = None,
                 hub_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 rest: Optional[pulumi.Input['IotRouteRestArgs']] = None,
                 s3: Optional[pulumi.Input['IotRouteS3Args']] = None,
                 topic: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering IotRoute resources.
        :param pulumi.Input[str] created_at: The date and time of the creation of the IoT Route
        :param pulumi.Input['IotRouteDatabaseArgs'] database: Database Route parameters
        :param pulumi.Input[str] hub_id: The ID of the route's hub
        :param pulumi.Input[str] name: The name of the route
        :param pulumi.Input[str] region: The region you want to attach the resource to
        :param pulumi.Input['IotRouteRestArgs'] rest: Rest Route parameters
        :param pulumi.Input['IotRouteS3Args'] s3: S3 Route parameters
        :param pulumi.Input[str] topic: The Topic the route subscribes to (wildcards allowed)
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if hub_id is not None:
            pulumi.set(__self__, "hub_id", hub_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rest is not None:
            pulumi.set(__self__, "rest", rest)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)
        if topic is not None:
            pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time of the creation of the IoT Route
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input['IotRouteDatabaseArgs']]:
        """
        Database Route parameters
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input['IotRouteDatabaseArgs']]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter(name="hubId")
    def hub_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the route's hub
        """
        return pulumi.get(self, "hub_id")

    @hub_id.setter
    def hub_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hub_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the route
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region you want to attach the resource to
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def rest(self) -> Optional[pulumi.Input['IotRouteRestArgs']]:
        """
        Rest Route parameters
        """
        return pulumi.get(self, "rest")

    @rest.setter
    def rest(self, value: Optional[pulumi.Input['IotRouteRestArgs']]):
        pulumi.set(self, "rest", value)

    @property
    @pulumi.getter
    def s3(self) -> Optional[pulumi.Input['IotRouteS3Args']]:
        """
        S3 Route parameters
        """
        return pulumi.get(self, "s3")

    @s3.setter
    def s3(self, value: Optional[pulumi.Input['IotRouteS3Args']]):
        pulumi.set(self, "s3", value)

    @property
    @pulumi.getter
    def topic(self) -> Optional[pulumi.Input[str]]:
        """
        The Topic the route subscribes to (wildcards allowed)
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topic", value)


class IotRoute(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database: Optional[pulumi.Input[pulumi.InputType['IotRouteDatabaseArgs']]] = None,
                 hub_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 rest: Optional[pulumi.Input[pulumi.InputType['IotRouteRestArgs']]] = None,
                 s3: Optional[pulumi.Input[pulumi.InputType['IotRouteS3Args']]] = None,
                 topic: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a IotRoute resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['IotRouteDatabaseArgs']] database: Database Route parameters
        :param pulumi.Input[str] hub_id: The ID of the route's hub
        :param pulumi.Input[str] name: The name of the route
        :param pulumi.Input[str] region: The region you want to attach the resource to
        :param pulumi.Input[pulumi.InputType['IotRouteRestArgs']] rest: Rest Route parameters
        :param pulumi.Input[pulumi.InputType['IotRouteS3Args']] s3: S3 Route parameters
        :param pulumi.Input[str] topic: The Topic the route subscribes to (wildcards allowed)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IotRouteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a IotRoute resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param IotRouteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IotRouteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database: Optional[pulumi.Input[pulumi.InputType['IotRouteDatabaseArgs']]] = None,
                 hub_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 rest: Optional[pulumi.Input[pulumi.InputType['IotRouteRestArgs']]] = None,
                 s3: Optional[pulumi.Input[pulumi.InputType['IotRouteS3Args']]] = None,
                 topic: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IotRouteArgs.__new__(IotRouteArgs)

            __props__.__dict__["database"] = database
            if hub_id is None and not opts.urn:
                raise TypeError("Missing required property 'hub_id'")
            __props__.__dict__["hub_id"] = hub_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["rest"] = rest
            __props__.__dict__["s3"] = s3
            if topic is None and not opts.urn:
                raise TypeError("Missing required property 'topic'")
            __props__.__dict__["topic"] = topic
            __props__.__dict__["created_at"] = None
        super(IotRoute, __self__).__init__(
            'scaleway:index/iotRoute:IotRoute',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            database: Optional[pulumi.Input[pulumi.InputType['IotRouteDatabaseArgs']]] = None,
            hub_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            rest: Optional[pulumi.Input[pulumi.InputType['IotRouteRestArgs']]] = None,
            s3: Optional[pulumi.Input[pulumi.InputType['IotRouteS3Args']]] = None,
            topic: Optional[pulumi.Input[str]] = None) -> 'IotRoute':
        """
        Get an existing IotRoute resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] created_at: The date and time of the creation of the IoT Route
        :param pulumi.Input[pulumi.InputType['IotRouteDatabaseArgs']] database: Database Route parameters
        :param pulumi.Input[str] hub_id: The ID of the route's hub
        :param pulumi.Input[str] name: The name of the route
        :param pulumi.Input[str] region: The region you want to attach the resource to
        :param pulumi.Input[pulumi.InputType['IotRouteRestArgs']] rest: Rest Route parameters
        :param pulumi.Input[pulumi.InputType['IotRouteS3Args']] s3: S3 Route parameters
        :param pulumi.Input[str] topic: The Topic the route subscribes to (wildcards allowed)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IotRouteState.__new__(_IotRouteState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["database"] = database
        __props__.__dict__["hub_id"] = hub_id
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["rest"] = rest
        __props__.__dict__["s3"] = s3
        __props__.__dict__["topic"] = topic
        return IotRoute(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The date and time of the creation of the IoT Route
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def database(self) -> pulumi.Output[Optional['outputs.IotRouteDatabase']]:
        """
        Database Route parameters
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter(name="hubId")
    def hub_id(self) -> pulumi.Output[str]:
        """
        The ID of the route's hub
        """
        return pulumi.get(self, "hub_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the route
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region you want to attach the resource to
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def rest(self) -> pulumi.Output[Optional['outputs.IotRouteRest']]:
        """
        Rest Route parameters
        """
        return pulumi.get(self, "rest")

    @property
    @pulumi.getter
    def s3(self) -> pulumi.Output[Optional['outputs.IotRouteS3']]:
        """
        S3 Route parameters
        """
        return pulumi.get(self, "s3")

    @property
    @pulumi.getter
    def topic(self) -> pulumi.Output[str]:
        """
        The Topic the route subscribes to (wildcards allowed)
        """
        return pulumi.get(self, "topic")

