from typing import Dict

from hyperstyle.src.python.review.inspectors.issue import IssueType

CHECK_CLASS_NAME_TO_ISSUE_TYPE: Dict[str, IssueType] = {
    # ---- Annotations ----
    # 'AnnotationLocationCheck': IssueType.CODE_STYLE,
    # 'AnnotationOnSameLineCheck': IssueType.CODE_STYLE,
    # 'AnnotationUseStyleCheck': IssueType.CODE_STYLE,
    # 'MissingDeprecatedCheck': IssueType.CODE_STYLE,
    # 'MissingOverrideCheck': IssueType.CODE_STYLE,
    # 'PackageAnnotationCheck': IssueType.CODE_STYLE,
    # 'SuppressWarningsCheck': IssueType.BEST_PRACTICES,
    # 'SuppressWarningsHolderCheck': IssueType.BEST_PRACTICES,

    # ---- Block Checks ----
    'AvoidNestedBlocksCheck': IssueType.BEST_PRACTICES,
    'EmptyBlockCheck': IssueType.BEST_PRACTICES,
    'EmptyCatchBlockCheck': IssueType.BEST_PRACTICES,
    'LeftCurlyCheck': IssueType.CODE_STYLE,
    'NeedBracesCheck': IssueType.CODE_STYLE,
    'RightCurlyCheck': IssueType.CODE_STYLE,

    # ---- Class Design ----
    # 'DesignForExtensionCheck': IssueType.CODE_STYLE,
    # 'FinalClassCheck': IssueType.CODE_STYLE,
    # 'HideUtilityClassConstructorCheck': IssueType.CODE_STYLE,
    # 'InnerTypeLastCheck': IssueType.CODE_STYLE,
    # 'InterfaceIsTypeCheck': IssueType.CODE_STYLE,
    # 'MutableExceptionCheck': IssueType.BEST_PRACTICES,
    # 'OneTopLevelClassCheck': IssueType.BEST_PRACTICES,
    # 'ThrowsCountCheck': IssueType.BEST_PRACTICES,
    # 'VisibilityModifierCheck': IssueType.BEST_PRACTICES,

    # ---- Coding ----
    'ArrayTrailingCommaCheck': IssueType.INFO,
    'CovariantEqualsCheck': IssueType.ERROR_PRONE,
    'DefaultComesLastCheck': IssueType.BEST_PRACTICES,
    'EmptyStatementCheck': IssueType.ERROR_PRONE,
    'EqualsAvoidNullCheck': IssueType.BEST_PRACTICES,
    'EqualsHashCodeCheck': IssueType.ERROR_PRONE,
    'FallThroughCheck': IssueType.ERROR_PRONE,
    'MagicNumberCheck': IssueType.INFO,
    'MissingSwitchDefaultCheck': IssueType.ERROR_PRONE,
    'ModifiedControlVariableCheck': IssueType.BEST_PRACTICES,
    'MultipleStringLiteralsCheck': IssueType.BEST_PRACTICES,
    'MultipleVariableDeclarationsCheck': IssueType.CODE_STYLE,
    'NoFinalizerCheck': IssueType.ERROR_PRONE,
    'OneStatementPerLineCheck': IssueType.CODE_STYLE,
    'OverloadMethodsDeclarationOrderCheck': IssueType.BEST_PRACTICES,
    'ParameterAssignmentCheck': IssueType.BEST_PRACTICES,
    'SimplifyBooleanExpressionCheck': IssueType.BEST_PRACTICES,
    'SimplifyBooleanReturnCheck': IssueType.BEST_PRACTICES,
    'StringLiteralEqualityCheck': IssueType.ERROR_PRONE,
    'UnnecessaryParenthesesCheck': IssueType.CODE_STYLE,
    # 'AvoidDoubleBraceInitializationCheck': IssueType.BEST_PRACTICES,
    # 'AvoidInlineConditionalsCheck': IssueType.BEST_PRACTICES,
    # 'AvoidNoArgumentSuperConstructorCallCheck': IssueType.BEST_PRACTICES,
    # 'DeclarationOrderCheck': IssueType.CODE_STYLE,
    # 'ExplicitInitializationCheck': IssueType.BEST_PRACTICES,
    # 'FinalLocalVariableCheck': IssueType.CODE_STYLE,
    # 'HiddenFieldCheck': IssueType.CODE_STYLE,
    # 'IllegalCatchCheck': IssueType.ERROR_PRONE,
    # 'IllegalInstantiationCheck': IssueType.ERROR_PRONE,
    # 'IllegalThrowsCheck': IssueType.ERROR_PRONE,
    # 'IllegalTokenCheck': IssueType.ERROR_PRONE,
    # 'IllegalTokenTextCheck': IssueType.ERROR_PRONE,
    # 'IllegalTypeCheck': IssueType.ERROR_PRONE,
    # 'InnerAssignmentCheck': IssueType.CODE_STYLE,
    # 'MatchXpathCheck': IssueType.BEST_PRACTICES,
    # 'MissingCtorCheck': IssueType.ERROR_PRONE,
    # 'NestedForDepthCheck': IssueType.BEST_PRACTICES,
    # 'NestedIfDepthCheck': IssueType.BEST_PRACTICES,
    # 'NestedTryDepthCheck': IssueType.BEST_PRACTICES,
    # 'NoArrayTrailingCommaCheck': IssueType.CODE_STYLE,
    # 'NoCloneCheck': IssueType.ERROR_PRONE,
    # 'NoEnumTrailingCommaCheck': IssueType.CODE_STYLE,
    # 'PackageDeclarationCheck': IssueType.CODE_STYLE,
    # 'RequireThisCheck': IssueType.ERROR_PRONE,
    # 'ReturnCountCheck': IssueType.BEST_PRACTICES,
    # 'SuperCloneCheck': IssueType.ERROR_PRONE,
    # 'SuperFinalizeCheck': IssueType.ERROR_PRONE,
    # 'UnnecessarySemicolonAfterOuterTypeDeclarationCheck': IssueType.CODE_STYLE,
    # 'UnnecessarySemicolonAfterTypeMemberDeclarationCheck': IssueType.CODE_STYLE,
    # 'UnnecessarySemicolonInEnumerationCheck': IssueType.CODE_STYLE,
    # 'UnnecessarySemicolonInTryWithResourcesCheck': IssueType.CODE_STYLE,
    # 'VariableDeclarationUsageDistanceCheck': IssueType.CODE_STYLE,

    # ---- Headers ----
    # 'HeaderCheck': IssueType.CODE_STYLE,
    # 'RegexpHeaderCheck': IssueType.ERROR_PRONE,

    # ---- Imports ----
    'RedundantImportCheck': IssueType.BEST_PRACTICES,
    'UnusedImportsCheck': IssueType.BEST_PRACTICES,
    # 'AvoidStarImportCheck': IssueType.BEST_PRACTICES,
    # 'AvoidStaticImportCheck': IssueType.BEST_PRACTICES,
    # 'CustomImportOrderCheck': IssueType.CODE_STYLE,
    # 'IllegalImportCheck': IssueType.ERROR_PRONE,
    # 'ImportControlCheck': IssueType.CODE_STYLE,
    # 'ImportOrderCheck': IssueType.CODE_STYLE,

    # ---- Javadoc Comments ----
    # 'AtclauseOrderCheck': IssueType.CODE_STYLE,
    # 'InvalidJavadocPositionCheck': IssueType.CODE_STYLE,
    # 'JavadocBlockTagLocationCheck': IssueType.CODE_STYLE,
    # 'JavadocContentLocationCheck': IssueType.CODE_STYLE,
    # 'JavadocMethodCheck': IssueType.CODE_STYLE,
    # 'JavadocMissingLeadingAsteriskCheck': IssueType.CODE_STYLE,
    # 'JavadocMissingWhitespaceAfterAsteriskCheck': IssueType.CODE_STYLE,
    # 'JavadocPackageCheck': IssueType.CODE_STYLE,
    # 'JavadocParagraphCheck': IssueType.CODE_STYLE,
    # 'JavadocStyleCheck': IssueType.CODE_STYLE,
    # 'JavadocTagContinuationIndentationCheck': IssueType.CODE_STYLE,
    # 'JavadocTypeCheck': IssueType.CODE_STYLE,
    # 'JavadocVariableCheck': IssueType.CODE_STYLE,
    # 'MissingJavadocMethodCheck': IssueType.CODE_STYLE,
    # 'MissingJavadocPackageCheck': IssueType.CODE_STYLE,
    # 'MissingJavadocTypeCheck': IssueType.CODE_STYLE,
    # 'NonEmptyAtclauseDescriptionCheck': IssueType.CODE_STYLE,
    # 'RequireEmptyLineBeforeBlockTagGroupCheck': IssueType.CODE_STYLE,
    # 'SingleLineJavadocCheck': IssueType.CODE_STYLE,
    # 'SummaryJavadocCheck': IssueType.CODE_STYLE,
    # 'WriteTagCheck': IssueType.CODE_STYLE,

    # ---- Metrics ----
    'BooleanExpressionComplexityCheck': IssueType.BOOL_EXPR_LEN,
    'CyclomaticComplexityCheck': IssueType.CYCLOMATIC_COMPLEXITY,
    'JavaNCSSCheck': IssueType.FUNC_LEN,
    # 'ClassDataAbstractionCouplingCheck': IssueType.COUPLING,
    # 'ClassFanOutComplexityCheck': IssueType.CODE_STYLE,
    # 'NPathComplexityCheck': IssueType.COMPLEXITY,

    # ---- Miscellaneous ----
    'ArrayTypeStyleCheck': IssueType.CODE_STYLE,
    'CommentsIndentationCheck': IssueType.CODE_STYLE,
    'IndentationCheck': IssueType.CODE_STYLE,
    'UpperEllCheck': IssueType.BEST_PRACTICES,
    # 'AvoidEscapedUnicodeCharactersCheck': IssueType.CODE_STYLE,
    # 'DescendantTokenCheck': IssueType.CODE_STYLE,
    # 'FinalParametersCheck': IssueType.CODE_STYLE,
    # 'NewlineAtEndOfFileCheck': IssueType.CODE_STYLE,
    # 'NoCodeInFileCheck': IssueType.BEST_PRACTICES,
    # 'OrderedPropertiesCheck': IssueType.CODE_STYLE,
    # 'OuterTypeFilenameCheck': IssueType.CODE_STYLE,
    # 'TodoCommentCheck': IssueType.BEST_PRACTICES,
    # 'TrailingCommentCheck': IssueType.CODE_STYLE,
    # 'TranslationCheck': IssueType.BEST_PRACTICES,
    # 'UncommentedMainCheck': IssueType.BEST_PRACTICES,
    # 'UniquePropertiesCheck': IssueType.ERROR_PRONE,

    # ---- Modifiers ----
    'ModifierOrderCheck': IssueType.CODE_STYLE,
    # 'ClassMemberImpliedModifierCheck': IssueType.BEST_PRACTICES,
    # 'InterfaceMemberImpliedModifierCheck': IssueType.BEST_PRACTICES,
    # 'RedundantModifierCheck': IssueType.BEST_PRACTICES,

    # ---- Naming Conventions ----
    'AbbreviationAsWordInNameCheck': IssueType.CODE_STYLE,
    'ConstantNameCheck': IssueType.CODE_STYLE,
    'LambdaParameterNameCheck': IssueType.CODE_STYLE,
    'LocalFinalVariableNameCheck': IssueType.CODE_STYLE,
    'LocalVariableNameCheck': IssueType.CODE_STYLE,
    'MemberNameCheck': IssueType.CODE_STYLE,
    'MethodNameCheck': IssueType.CODE_STYLE,
    'PackageNameCheck': IssueType.CODE_STYLE,
    'ParameterNameCheck': IssueType.CODE_STYLE,
    'StaticVariableNameCheck': IssueType.CODE_STYLE,
    'TypeNameCheck': IssueType.CODE_STYLE,
    # 'AbstractClassNameCheck': IssueType.CODE_STYLE,
    # 'CatchParameterNameCheck': IssueType.CODE_STYLE,
    # 'ClassTypeParameterNameCheck': IssueType.CODE_STYLE,
    # 'IllegalIdentifierNameCheck': IssueType.CODE_STYLE,
    # 'InterfaceTypeParameterNameCheck': IssueType.CODE_STYLE,
    # 'MethodTypeParameterNameCheck': IssueType.CODE_STYLE,
    # 'PatternVariableNameCheck': IssueType.CODE_STYLE,
    # 'RecordComponentNameCheck': IssueType.CODE_STYLE,
    # 'RecordTypeParameterNameCheck': IssueType.CODE_STYLE,

    # ---- Regexp ----
    # 'RegexpCheck': IssueType.ERROR_PRONE,
    # 'RegexpMultilineCheck': IssueType.ERROR_PRONE,
    # 'RegexpOnFilenameCheck': IssueType.ERROR_PRONE,
    # 'RegexpSinglelineCheck': IssueType.BEST_PRACTICES,
    # 'RegexpSinglelineJavaCheck': IssueType.ERROR_PRONE,

    # ---- Size Violations ----
    # 'AnonInnerLengthCheck': IssueType.CODE_STYLE,
    # 'ExecutableStatementCountCheck': IssueType.BEST_PRACTICES,
    # 'FileLengthCheck': IssueType.CODE_STYLE,
    # 'LambdaBodyLengthCheck': IssueType.BEST_PRACTICES,
    'LineLengthCheck': IssueType.LINE_LEN,
    # 'MethodCountCheck': IssueType.CODE_STYLE,
    # 'MethodLengthCheck': IssueType.BEST_PRACTICES,
    # 'OuterTypeNumberCheck': IssueType.CODE_STYLE,
    'ParameterNumberCheck': IssueType.COMPLEXITY,
    # 'RecordComponentNumberCheck': IssueType.BEST_PRACTICES,

    # ---- Whitespace ----
    'EmptyForIteratorPadCheck': IssueType.CODE_STYLE,
    'EmptyLineSeparatorCheck': IssueType.CODE_STYLE,
    'GenericWhitespaceCheck': IssueType.CODE_STYLE,
    'MethodParamPadCheck': IssueType.CODE_STYLE,
    'NoWhitespaceAfterCheck': IssueType.CODE_STYLE,
    'NoWhitespaceBeforeCheck': IssueType.CODE_STYLE,
    'OperatorWrapCheck': IssueType.CODE_STYLE,
    'ParenPadCheck': IssueType.CODE_STYLE,
    'TypecastParenPadCheck': IssueType.CODE_STYLE,
    'WhitespaceAfterCheck': IssueType.CODE_STYLE,
    'WhitespaceAroundCheck': IssueType.CODE_STYLE,
    # 'EmptyForInitializerPadCheck': IssueType.BEST_PRACTICES,
    # 'FileTabCharacterCheck': IssueType.CODE_STYLE,
    # 'NoLineWrapCheck': IssueType.CODE_STYLE,
    # 'SeparatorWrapCheck': IssueType.CODE_STYLE,
    # 'SingleSpaceSeparatorCheck': IssueType.CODE_STYLE,
}
