/*!
 * Copyright (c) 2012 - 2021, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
(function(root, factory) {
  factory(root["Bokeh"], "2.4.0-dev.6");
})(this, function(Bokeh, version) {
  let define;
  return (function(modules, entry, aliases, externals) {
    const bokeh = typeof Bokeh !== "undefined" && (version != null ? Bokeh[version] : Bokeh);
    if (bokeh != null) {
      return bokeh.register_plugin(modules, entry, aliases);
    } else {
      throw new Error("Cannot find Bokeh " + version + ". You have to load it prior to loading plugins.");
    }
  })
({
538: function _(t,_,n,o,r){o(),(0,t(1).__exportStar)(t(539),n)},
539: function _(t,r,a,_,i){_();var o=t(1),n=(0,o.__importStar)(t(540));a.LinAlg=n;var p=(0,o.__importStar)(t(541));a.Charts=p;var m=(0,o.__importStar)(t(544));a.Plotting=m;var e=(0,o.__importStar)(t(542));a.Palettes=e,i("Document",t(120).Document),i("sprintf",t(264).sprintf),(0,o.__exportStar)(t(543),a)},
540: function _(e,t,r,_,a){_();var s=e(1),x=e(128);a("keys",x.keys),a("values",x.values),a("entries",x.entries),a("size",x.size),a("extend",x.extend),(0,s.__exportStar)(e(124),r),(0,s.__exportStar)(e(149),r),(0,s.__exportStar)(e(349),r),(0,s.__exportStar)(e(123),r),(0,s.__exportStar)(e(141),r)},
541: function _(e,t,r,a,n){a();var l=e(1),o=(0,l.__importStar)(e(542)),i=e(137),s=e(124),u=e(123),d=e(264),_=e(543);function c(e){return void 0===e&&(e="Spectral11"),(0,u.isArray)(e)?e:o[e]}r.pie=function(e,t){var r;void 0===t&&(t={});for(var a=[],n=[],o=0;o<Math.min(e.labels.length,e.values.length);o++)e.values[o]>0&&(a.push(e.labels[o]),n.push(e.values[o]));var f,p,g=null!=t.start_angle?t.start_angle:0,h=null!=t.end_angle?t.end_angle:g+2*Math.PI,v=Math.abs(h-g),m=(0,s.sum)(n),w=n.map((function(e){return e/m})),y=(0,s.cumsum)(w).map((function(e){return g+v*e})),b=[g].concat(y.slice(0,-1)),x=(0,s.zip)(b,y).map((function(e){var t=(0,l.__read)(e,2);return(t[0]+t[1])/2}));null==t.center?(f=0,p=0):(0,u.isArray)(t.center)?(f=t.center[0],p=t.center[1]):(f=t.center.x,p=t.center.y);var M=null!=t.inner_radius?t.inner_radius:0,R=null!=t.outer_radius?t.outer_radius:1,S=c(t.palette),A=[];for(o=0;o<w.length;o++)A.push(S[o%S.length]);var k=A.map((function(e){return(0,i.is_dark)((0,i.color2rgba)(e))?"white":"black"})),z=(M+R)/2,D=(0,l.__read)((0,s.unzip)(x.map((function(e){return r=e,[(t=z)*Math.cos(r),t*Math.sin(r)];var t,r}))),2),P=D[0],C=D[1];P=P.map((function(e){return e+f})),C=C.map((function(e){return e+p}));var T=x.map((function(e){return e>=Math.PI/2&&e<=3*Math.PI/2?e+Math.PI:e})),G=new _.ColumnDataSource({data:{labels:a,values:n,percentages:w.map((function(e){return(0,d.sprintf)("%.2f%%",100*e)})),start_angles:b,end_angles:y,text_angles:T,colors:A,text_colors:k,text_cx:P,text_cy:C}}),I=new _.AnnularWedge({x:f,y:p,inner_radius:M,outer_radius:R,start_angle:{field:"start_angles"},end_angle:{field:"end_angles"},line_color:null,line_width:1,fill_color:{field:"colors"}}),F=new _.AnnularWedge({x:f,y:p,inner_radius:M,outer_radius:R,start_angle:{field:"start_angles"},end_angle:{field:"end_angles"},line_color:null,line_width:1,fill_color:{field:"colors"},fill_alpha:.8}),H=new _.GlyphRenderer({data_source:G,glyph:I,hover_glyph:F}),L=new _.Text({x:{field:"text_cx"},y:{field:"text_cy"},text:{field:null!==(r=t.slice_labels)&&void 0!==r?r:"labels"},angle:{field:"text_angles"},text_align:"center",text_baseline:"middle",text_color:{field:"text_colors"},text_font_size:"12px"}),Q=new _.GlyphRenderer({data_source:G,glyph:L}),W=new _.DataRange1d({renderers:[H],range_padding:.2}),B=new _.DataRange1d({renderers:[H],range_padding:.2}),N=new _.Plot({x_range:W,y_range:B});N.add_renderers(H,Q);var j=new _.HoverTool({renderers:[H],tooltips:"<div>@labels</div><div><b>@values</b> (@percentages)</div>"});return N.add_tools(j),N},r.bar=function(e,t){var r,a,n,o,i,u,d;void 0===t&&(t={});var f,p=e[0],g=e.slice(1),h=(0,s.transpose)(g),v=h[0].map((function(e){return e.toString()})),m=h.slice(1),w=new _.CategoricalAxis,y=new _.FactorRange({factors:v}),b=new _.CategoricalScale;f=null!=t.axis_number_format?new _.NumeralTickFormatter({format:t.axis_number_format}):new _.BasicTickFormatter;var x=new _.LinearAxis({formatter:f}),M=new _.DataRange1d({start:0}),R=new _.LinearScale,S=c(t.palette),A=null!=t.stacked&&t.stacked,k=null!=t.orientation?t.orientation:"horizontal",z=[];if(A)for(var D=[],P=[],C=function(e){for(var t=[],r=[],a=0;a<v.length;a++){var n=v[a];0==e?(D.push(0),P.push(m[e][a])):(D[a]+=m[e-1][a],P[a]+=m[e][a]),t.push([n,-.5]),r.push([n,.5])}var l=new _.ColumnDataSource({data:{left:(0,s.copy)(D),right:(0,s.copy)(P),top:r,bottom:t,labels:v,values:m[e],columns:m[e].map((function(t){return p[e+1]}))}}),o=new _.Quad({left:{field:"left"},bottom:{field:"bottom"},right:{field:"right"},top:{field:"top"},line_color:null,fill_color:S[e%S.length]}),i=new _.GlyphRenderer({data_source:l,glyph:o});z.push(i)},T=0;T<m.length;T++)C(T);else{var G=1/m.length,I=function(e){for(var t=[],r=[],a=[],n=[],l=0;l<v.length;l++){var o=v[l];t.push(0),r.push(m[e][l]),a.push([o,e*G-.5]),n.push([o,(e+1)*G-.5])}var i=new _.ColumnDataSource({data:{left:t,right:r,top:n,bottom:a,labels:v,values:m[e],columns:m[e].map((function(t){return p[e+1]}))}}),s=new _.Quad({left:{field:"left"},bottom:{field:"bottom"},right:{field:"right"},top:{field:"top"},line_color:null,fill_color:S[e%S.length]}),u=new _.GlyphRenderer({data_source:i,glyph:s});z.push(u)};for(T=0;T<m.length;T++)I(T)}if("vertical"==k){M=(r=(0,l.__read)([y,M],2))[0],y=r[1],x=(a=(0,l.__read)([w,x],2))[0],w=a[1],R=(n=(0,l.__read)([b,R],2))[0],b=n[1];try{for(var F=(0,l.__values)(z),H=F.next();!H.done;H=F.next()){var L=H.value.data_source.data;u=(0,l.__read)([L.bottom,L.left],2),L.left=u[0],L.bottom=u[1],d=(0,l.__read)([L.top,L.right],2),L.right=d[0],L.top=d[1]}}catch(e){o={error:e}}finally{try{H&&!H.done&&(i=F.return)&&i.call(F)}finally{if(o)throw o.error}}}var Q,W,B=new _.Plot({x_range:M,y_range:y,x_scale:R,y_scale:b});B.add_renderers.apply(B,(0,l.__spreadArray)([],(0,l.__read)(z),!1)),B.add_layout(w,"left"),B.add_layout(x,"below"),"horizontal"==k?(Q="center_right",W="horizontal"):(Q="top_center",W="vertical");var N=new _.HoverTool({renderers:z,tooltips:"<div>@labels</div><div>@columns:&nbsp<b>@values</b></div>",point_policy:"snap_to_data",anchor:Q,attachment:W});return B.add_tools(N),B}},
542: function _(r,e,a,t,u){t(),a.Greens4=a.Greens3=a.Blues9=a.Blues8=a.Blues7=a.Blues6=a.Blues5=a.Blues4=a.Blues3=a.Purples9=a.Purples8=a.Purples7=a.Purples6=a.Purples5=a.Purples4=a.Purples3=a.YlOrBr9=a.YlOrBr8=a.YlOrBr7=a.YlOrBr6=a.YlOrBr5=a.YlOrBr4=a.YlOrBr3=a.YlOrRd9=a.YlOrRd8=a.YlOrRd7=a.YlOrRd6=a.YlOrRd5=a.YlOrRd4=a.YlOrRd3=a.OrRd9=a.OrRd8=a.OrRd7=a.OrRd6=a.OrRd5=a.OrRd4=a.OrRd3=a.PuRd9=a.PuRd8=a.PuRd7=a.PuRd6=a.PuRd5=a.PuRd4=a.PuRd3=a.RdPu9=a.RdPu8=a.RdPu7=a.RdPu6=a.RdPu5=a.RdPu4=void 0,a.PRGn5=a.PRGn4=a.PRGn3=a.BrBG11=a.BrBG10=a.BrBG9=a.BrBG8=a.BrBG7=a.BrBG6=a.BrBG5=a.BrBG4=a.BrBG3=a.PuOr11=a.PuOr10=a.PuOr9=a.PuOr8=a.PuOr7=a.PuOr6=a.PuOr5=a.PuOr4=a.PuOr3=a.Greys256=a.Greys11=a.Greys10=a.Greys9=a.Greys8=a.Greys7=a.Greys6=a.Greys5=a.Greys4=a.Greys3=a.Reds9=a.Reds8=a.Reds7=a.Reds6=a.Reds5=a.Reds4=a.Reds3=a.Oranges9=a.Oranges8=a.Oranges7=a.Oranges6=a.Oranges5=a.Oranges4=a.Oranges3=a.Greens9=a.Greens8=a.Greens7=a.Greens6=a.Greens5=void 0,a.Spectral10=a.Spectral9=a.Spectral8=a.Spectral7=a.Spectral6=a.Spectral5=a.Spectral4=a.Spectral3=a.RdYlBu11=a.RdYlBu10=a.RdYlBu9=a.RdYlBu8=a.RdYlBu7=a.RdYlBu6=a.RdYlBu5=a.RdYlBu4=a.RdYlBu3=a.RdGy11=a.RdGy10=a.RdGy9=a.RdGy8=a.RdGy7=a.RdGy6=a.RdGy5=a.RdGy4=a.RdGy3=a.RdBu11=a.RdBu10=a.RdBu9=a.RdBu8=a.RdBu7=a.RdBu6=a.RdBu5=a.RdBu4=a.RdBu3=a.PiYG11=a.PiYG10=a.PiYG9=a.PiYG8=a.PiYG7=a.PiYG6=a.PiYG5=a.PiYG4=a.PiYG3=a.PRGn11=a.PRGn10=a.PRGn9=a.PRGn8=a.PRGn7=a.PRGn6=void 0,a.Viridis256=a.Viridis11=a.Viridis10=a.Viridis9=a.Viridis8=a.Viridis7=a.Viridis6=a.Viridis5=a.Viridis4=a.Viridis3=a.Plasma256=a.Plasma11=a.Plasma10=a.Plasma9=a.Plasma8=a.Plasma7=a.Plasma6=a.Plasma5=a.Plasma4=a.Plasma3=a.Magma256=a.Magma11=a.Magma10=a.Magma9=a.Magma8=a.Magma7=a.Magma6=a.Magma5=a.Magma4=a.Magma3=a.Inferno256=a.Inferno11=a.Inferno10=a.Inferno9=a.Inferno8=a.Inferno7=a.Inferno6=a.Inferno5=a.Inferno4=a.Inferno3=a.RdYlGn11=a.RdYlGn10=a.RdYlGn9=a.RdYlGn8=a.RdYlGn7=a.RdYlGn6=a.RdYlGn5=a.RdYlGn4=a.RdYlGn3=a.Spectral11=void 0,a.Pastel2_3=a.Pastel1_9=a.Pastel1_8=a.Pastel1_7=a.Pastel1_6=a.Pastel1_5=a.Pastel1_4=a.Pastel1_3=a.Paired12=a.Paired11=a.Paired10=a.Paired9=a.Paired8=a.Paired7=a.Paired6=a.Paired5=a.Paired4=a.Paired3=a.Dark2_8=a.Dark2_7=a.Dark2_6=a.Dark2_5=a.Dark2_4=a.Dark2_3=a.Accent8=a.Accent7=a.Accent6=a.Accent5=a.Accent4=a.Accent3=a.Turbo256=a.Turbo11=a.Turbo10=a.Turbo9=a.Turbo8=a.Turbo7=a.Turbo6=a.Turbo5=a.Turbo4=a.Turbo3=a.Cividis256=a.Cividis11=a.Cividis10=a.Cividis9=a.Cividis8=a.Cividis7=a.Cividis6=a.Cividis5=a.Cividis4=a.Cividis3=void 0,a.Category20_16=a.Category20_15=a.Category20_14=a.Category20_13=a.Category20_12=a.Category20_11=a.Category20_10=a.Category20_9=a.Category20_8=a.Category20_7=a.Category20_6=a.Category20_5=a.Category20_4=a.Category20_3=a.Category10_10=a.Category10_9=a.Category10_8=a.Category10_7=a.Category10_6=a.Category10_5=a.Category10_4=a.Category10_3=a.Set3_12=a.Set3_11=a.Set3_10=a.Set3_9=a.Set3_8=a.Set3_7=a.Set3_6=a.Set3_5=a.Set3_4=a.Set3_3=a.Set2_8=a.Set2_7=a.Set2_6=a.Set2_5=a.Set2_4=a.Set2_3=a.Set1_9=a.Set1_8=a.Set1_7=a.Set1_6=a.Set1_5=a.Set1_4=a.Set1_3=a.Pastel2_8=a.Pastel2_7=a.Pastel2_6=a.Pastel2_5=a.Pastel2_4=void 0,a.BuGn=a.GnBu=a.YlGnBu=a.YlGn=a.Colorblind8=a.Colorblind7=a.Colorblind6=a.Colorblind5=a.Colorblind4=a.Colorblind3=a.Category20c_20=a.Category20c_19=a.Category20c_18=a.Category20c_17=a.Category20c_16=a.Category20c_15=a.Category20c_14=a.Category20c_13=a.Category20c_12=a.Category20c_11=a.Category20c_10=a.Category20c_9=a.Category20c_8=a.Category20c_7=a.Category20c_6=a.Category20c_5=a.Category20c_4=a.Category20c_3=a.Category20b_20=a.Category20b_19=a.Category20b_18=a.Category20b_17=a.Category20b_16=a.Category20b_15=a.Category20b_14=a.Category20b_13=a.Category20b_12=a.Category20b_11=a.Category20b_10=a.Category20b_9=a.Category20b_8=a.Category20b_7=a.Category20b_6=a.Category20b_5=a.Category20b_4=a.Category20b_3=a.Category20_20=a.Category20_19=a.Category20_18=a.Category20_17=void 0,a.grey=a.turbo=a.cividis=a.viridis=a.plasma=a.inferno=a.magma=a.linear_palette=a.Colorblind=a.Category20c=a.Category20b=a.Category20=a.Category10=a.Set3=a.Set2=a.Set1=a.Pastel2=a.Pastel1=a.Paired=a.Dark2=a.Accent=a.Viridis=a.Plasma=a.Magma=a.Inferno=a.RdYlGn=a.Spectral=a.RdYlBu=a.RdGy=a.RdBu=a.PiYG=a.PRGn=a.BrBG=a.PuOr=a.Greys=a.Reds=a.Oranges=a.Greens=a.Blues=a.Purples=a.YlOrBr=a.YlOrRd=a.OrRd=a.PuRd=a.RdPu=a.BuPu=a.PuBu=a.PuBuGn=void 0;var d=r(124);function l(r,e){if(e<=r.length)return(0,d.linspace)(0,r.length-1,e).map((function(e){return r[0|e]}));throw new Error("too many color entries requested")}a.YlGn3=[832787711,2916978431,4160535039],a.YlGn4=[595870719,2026273279,3269892607,4294954239],a.YlGn5=[6830079,832787711,2026273279,3269892607,4294954239],a.YlGn6=[6830079,832787711,2026273279,2916978431,3656426495,4294954239],a.YlGn7=[5911295,595870719,1101749759,2026273279,2916978431,3656426495,4294954239],a.YlGn8=[5911295,595870719,1101749759,2026273279,2916978431,3656426495,4160535039,4294960639],a.YlGn9=[4532735,6830079,595870719,1101749759,2026273279,2916978431,3656426495,4160535039,4294960639],a.YlGnBu3=[746567935,2144189439,3992498687],a.YlGnBu4=[576628991,1102497023,2715464959,4294954239],a.YlGnBu5=[624203007,746567935,1102497023,2715464959,4294954239],a.YlGnBu6=[624203007,746567935,1102497023,2144189439,3353982207,4294954239],a.YlGnBu7=[204244223,576628991,496091391,1102497023,2144189439,3353982207,4294954239],a.YlGnBu8=[204244223,576628991,496091391,1102497023,2144189439,3353982207,3992498687,4294957567],a.YlGnBu9=[136141055,624203007,576628991,496091391,1102497023,2144189439,3353982207,3992498687,4294957567],a.GnBu3=[1134742271,2833102335,3774077951],a.GnBu4=[730644223,2077017343,3135552767,4042909951],a.GnBu5=[141077759,1134742271,2077017343,3135552767,4042909951],a.GnBu6=[141077759,1134742271,2077017343,2833102335,3438003711,4042909951],a.GnBu7=[140025599,730644223,1320408063,2077017343,2833102335,3438003711,4042909951],a.GnBu8=[140025599,730644223,1320408063,2077017343,2833102335,3438003711,3774077951,4160549119],a.GnBu9=[138445311,141077759,730644223,1320408063,2077017343,2833102335,3438003711,3774077951,4160549119],a.BuGn3=[748838911,2581121535,3858102783],a.BuGn4=[596329983,1724032255,3001213695,3992517631],a.BuGn5=[7154943,748838911,1724032255,3001213695,3992517631],a.BuGn6=[7154943,748838911,1724032255,2581121535,3438077695,3992517631],a.BuGn7=[5776639,596329983,1101952767,1724032255,2581121535,3438077695,3992517631],a.BuGn8=[5776639,596329983,1101952767,1724032255,2581121535,3438077695,3858102783,4160552447],a.BuGn9=[4463615,7154943,596329983,1101952767,1724032255,2581121535,3438077695,3858102783,4160552447],a.PuBuGn3=[479238655,2797460479,3974295807],a.PuBuGn4=[42044159,1739182079,3184124415,4142921727],a.PuBuGn5=[23878143,479238655,1739182079,3184124415,4142921727],a.PuBuGn6=[23878143,479238655,1739182079,2797460479,3503417087,4142921727],a.PuBuGn7=[23351551,42044159,915456255,1739182079,2797460479,3503417087,4142921727],a.PuBuGn8=[23351551,42044159,915456255,1739182079,2797460479,3503417087,3974295807,4294441983],a.PuBuGn9=[21378815,23878143,42044159,915456255,1739182079,2797460479,3503417087,3974295807,4294441983],a.PuBu3=[730644223,2797460479,3974623999],a.PuBu4=[91271423,1957285887,3184124415,4058969855],a.PuBu5=[73043455,730644223,1957285887,3184124415,4058969855],a.PuBu6=[73043455,730644223,1957285887,2797460479,3503417087,4058969855],a.PuBu7=[55475199,91271423,915456255,1957285887,2797460479,3503417087,4058969855],a.PuBu8=[55475199,91271423,915456255,1957285887,2797460479,3503417087,3974623999,4294441983],a.PuBu9=[37247231,73043455,91271423,915456255,1957285887,2797460479,3503417087,3974623999,4294441983],a.BuPu3=[2287380479,2663176959,3773625599],a.BuPu4=[2286001663,2358691583,3016614911,3992517631],a.BuPu5=[2165275903,2287380479,2358691583,3016614911,3992517631],a.BuPu6=[2165275903,2287380479,2358691583,2663176959,3218335487,3992517631],a.BuPu7=[1845586943,2286001663,2355868159,2358691583,2663176959,3218335487,3992517631],a.BuPu8=[1845586943,2286001663,2355868159,2358691583,2663176959,3218335487,3773625599,4160552447],a.BuPu9=[1291865087,2165275903,2286001663,2355868159,2358691583,2663176959,3218335487,3773625599,4160552447],a.RdPu3=[3306916607,4204770815,4259372543],a.RdPu4=[2919333631,4150829567,4222925311,4276871935],a.RdPu5=[2046916607,3306916607,4150829567,4222925311,4276871935],a.RdPu6=[2046916607,3306916607,4150829567,4204770815,4240818431,4276871935],a.RdPu7=[2046916607,2919333631,3711211519,4150829567,4204770815,4240818431,4276871935],a.RdPu8=[2046916607,2919333631,3711211519,4150829567,4204770815,4240818431,4259372543,4294439935],a.RdPu9=[1224764159,2046916607,2919333631,3711211519,4150829567,4204770815,4240818431,4259372543,4294439935],a.PuRd3=[3709630463,3381970943,3890343935],a.PuRd4=[3457308415,3747983615,3619019007,4058969855],a.PuRd5=[2550154239,3709630463,3747983615,3619019007,4058969855],a.PuRd6=[2550154239,3709630463,3747983615,3381970943,3568950015,4058969855],a.PuRd7=[2432712703,3457308415,3878259455,3747983615,3381970943,3568950015,4058969855],a.PuRd8=[2432712703,3457308415,3878259455,3747983615,3381970943,3568950015,3890343935,4160027135],a.PuRd9=[1728061439,2550154239,3457308415,3878259455,3747983615,3381970943,3568950015,3890343935,4160027135],a.OrRd3=[3813291007,4256924927,4276668671],a.OrRd4=[3610255359,4237122047,4258040575,4277197311],a.OrRd5=[3003121919,3813291007,4237122047,4258040575,4277197311],a.OrRd6=[3003121919,3813291007,4237122047,4256924927,4258569983,4277197311],a.OrRd7=[2566914303,3610255359,4016392447,4237122047,4256924927,4258569983,4277197311],a.OrRd8=[2566914303,3610255359,4016392447,4237122047,4256924927,4258569983,4276668671,4294438143],a.OrRd9=[2130706687,3003121919,3610255359,4016392447,4237122047,4256924927,4258569983,4276668671,4294438143],a.YlOrRd3=[4030406911,4273097983,4293763327],a.YlOrRd4=[3810139391,4253891839,4274806015,4294947583],a.YlOrRd5=[3170903807,4030406911,4253891839,4274806015,4294947583],a.YlOrRd6=[3170903807,4030406911,4253891839,4273097983,4275664639,4294947583],a.YlOrRd7=[2969577215,3810139391,4232981247,4253891839,4273097983,4275664639,4294947583],a.YlOrRd8=[2969577215,3810139391,4232981247,4253891839,4273097983,4275664639,4293763327,4294954239],a.YlOrRd9=[2147493631,3170903807,3810139391,4232981247,4253891839,4273097983,4275664639,4293763327,4294954239],a.YlOrBr3=[3646885631,4274278399,4294425855],a.YlOrBr4=[3427533567,4271450623,4275670783,4294956287],a.YlOrBr5=[2570323199,3646885631,4271450623,4275670783,4294956287],a.YlOrBr6=[2570323199,3646885631,4271450623,4274278399,4276326911,4294956287],a.YlOrBr7=[2351760639,3427533567,3966768383,4271450623,4274278399,4276326911,4294956287],a.YlOrBr8=[2351760639,3427533567,3966768383,4271450623,4274278399,4276326911,4294425855,4294960639],a.YlOrBr9=[1713702655,2570323199,3427533567,3966768383,4271450623,4274278399,4276326911,4294425855,4294960639],a.Purples3=[1969992191,3166559487,4025349631],a.Purples4=[1783735295,2660944127,3419005695,4075878399],a.Purples5=[1411878911,1969992191,2660944127,3419005695,4075878399],a.Purples6=[1411878911,1969992191,2660944127,3166559487,3671780351,4075878399],a.Purples7=[1242859263,1783735295,2155723519,2660944127,3166559487,3671780351,4075878399],a.Purples8=[1242859263,1783735295,2155723519,2660944127,3166559487,3671780351,4025349631,4244372991],a.Purples9=[1056996863,1411878911,1783735295,2155723519,2660944127,3166559487,3671780351,4025349631,4244372991],a.Blues3=[830651903,2664096255,3740006399],a.Blues4=[561100287,1806620415,3185043455,4025745407],a.Blues5=[139566335,830651903,1806620415,3185043455,4025745407],a.Blues6=[139566335,830651903,1806620415,2664096255,3336302591,4025745407],a.Blues7=[138777855,561100287,1116915455,1806620415,2664096255,3336302591,4025745407],a.Blues8=[138777855,561100287,1116915455,1806620415,2664096255,3336302591,3740006399,4160487423],a.Blues9=[137391103,139566335,561100287,1116915455,1806620415,2664096255,3336302591,3740006399,4160487423],a.Greens3=[832787711,2715393023,3858096383],a.Greens4=[596329983,1959032575,3135550463,3992513023],a.Greens5=[7154943,832787711,1959032575,3135550463,3992513023],a.Greens6=[7154943,832787711,1959032575,2715393023,3353985279,3992513023],a.Greens7=[5911295,596329983,1101749759,1959032575,2715393023,3353985279,3992513023],a.Greens8=[5911295,596329983,1101749759,1959032575,2715393023,3353985279,3858096383,4160550399],a.Greens9=[4463615,7154943,596329983,1101749759,1959032575,2715393023,3353985279,3858096383,4160550399],a.Oranges3=[3864333823,4256066559,4276539135],a.Oranges4=[3645309439,4253891839,4257121791,4277001983],a.Oranges5=[2788557823,3864333823,4253891839,4257121791,4277001983],a.Oranges6=[2788557823,3864333823,4253891839,4256066559,4258308863,4277001983],a.Oranges7=[2351760639,3645374975,4050195455,4253891839,4256066559,4258308863,4277001983],a.Oranges8=[2351760639,3645374975,4050195455,4253891839,4256066559,4258308863,4276539135,4294306815],a.Oranges9=[2133263615,2788557823,3645374975,4050195455,4253891839,4256066559,4258308863,4276539135,4294306815],a.Reds3=[3727501055,4237456127,4276146943],a.Reds4=[3407355391,4218047231,4239299071,4276476415],a.Reds5=[2769229311,3727501055,4218047231,4239299071,4276476415],a.Reds6=[2769229311,3727501055,4218047231,4237456127,4240155135,4276476415],a.Reds7=[2566917631,3407355391,4013632767,4218047231,4237456127,4240155135,4276476415],a.Reds8=[2566917631,3407355391,4013632767,4218047231,4237456127,4240155135,4276146943,4294308095],a.Reds9=[1728056831,2769229311,3407355391,4013632767,4218047231,4237456127,4240155135,4276146943,4294308095],a.Greys3=[1667458047,3183328767,4042322175],a.Greys4=[1381126911,2526451455,3435973887,4160223231],a.Greys5=[623191551,1667458047,2526451455,3435973887,4160223231],a.Greys6=[623191551,1667458047,2526451455,3183328767,3654932991,4160223231],a.Greys7=[623191551,1381126911,1936946175,2526451455,3183328767,3654932991,4160223231],a.Greys8=[623191551,1381126911,1936946175,2526451455,3183328767,3654932991,4042322175,4294967295],a.Greys9=[255,623191551,1381126911,1936946175,2526451455,3183328767,3654932991,4042322175,4294967295],a.Greys10=[255,471604479,943208703,1431655935,1903260159,2374864383,2863311615,3334915839,3806520063,4294967295],a.Greys11=[255,421075455,858993663,1280068863,1717987071,2139062271,2576980479,2998055679,3435973887,3857049087,4294967295],a.Greys256=[255,16843263,33686271,50529279,67372287,84215295,101058303,117901311,134744319,151587327,168430335,185273343,202116351,218959359,235802367,252645375,269488383,286331391,303174399,320017407,336860415,353703423,370546431,387389439,404232447,421075455,437918463,454761471,471604479,488447487,505290495,522133503,538976511,555819519,572662527,589505535,606348543,623191551,640034559,656877567,673720575,690563583,707406591,724249599,741092607,757935615,774778623,791621631,808464639,825307647,842150655,858993663,875836671,892679679,909522687,926365695,943208703,960051711,976894719,993737727,1010580735,1027423743,1044266751,1061109759,1077952767,1094795775,1111638783,1128481791,1145324799,1162167807,1179010815,1195853823,1212696831,1229539839,1246382847,1263225855,1280068863,1296911871,1313754879,1330597887,1347440895,1364283903,1381126911,1397969919,1414812927,1431655935,1448498943,1465341951,1482184959,1499027967,1515870975,1532713983,1549556991,1566399999,1583243007,1600086015,1616929023,1633772031,1650615039,1667458047,1684301055,1701144063,1717987071,1734830079,1751673087,1768516095,1785359103,1802202111,1819045119,1835888127,1852731135,1869574143,1886417151,1903260159,1920103167,1936946175,1953789183,1970632191,1987475199,2004318207,2021161215,2038004223,2054847231,2071690239,2088533247,2105376255,2122219263,2139062271,2155905279,2172748287,2189591295,2206434303,2223277311,2240120319,2256963327,2273806335,2290649343,2307492351,2324335359,2341178367,2358021375,2374864383,2391707391,2408550399,2425393407,2442236415,2459079423,2475922431,2492765439,2509608447,2526451455,2543294463,2560137471,2576980479,2593823487,2610666495,2627509503,2644352511,2661195519,2678038527,2694881535,2711724543,2728567551,2745410559,2762253567,2779096575,2795939583,2812782591,2829625599,2846468607,2863311615,2880154623,2896997631,2913840639,2930683647,2947526655,2964369663,2981212671,2998055679,3014898687,3031741695,3048584703,3065427711,3082270719,3099113727,3115956735,3132799743,3149642751,3166485759,3183328767,3200171775,3217014783,3233857791,3250700799,3267543807,3284386815,3301229823,3318072831,3334915839,3351758847,3368601855,3385444863,3402287871,3419130879,3435973887,3452816895,3469659903,3486502911,3503345919,3520188927,3537031935,3553874943,3570717951,3587560959,3604403967,3621246975,3638089983,3654932991,3671775999,3688619007,3705462015,3722305023,3739148031,3755991039,3772834047,3789677055,3806520063,3823363071,3840206079,3857049087,3873892095,3890735103,3907578111,3924421119,3941264127,3958107135,3974950143,3991793151,4008636159,4025479167,4042322175,4059165183,4076008191,4092851199,4109694207,4126537215,4143380223,4160223231,4177066239,4193909247,4210752255,4227595263,4244438271,4261281279,4278124287,4294967295],a.PuOr3=[2576270335,4160223231,4054008063],a.PuOr4=[1581029887,2997605119,4256719871,3865117183],a.PuOr5=[1581029887,2997605119,4160223231,4256719871,3865117183],a.PuOr6=[1411877119,2576270335,3638225919,4276139775,4054008063,3008890623],a.PuOr7=[1411877119,2576270335,3638225919,4160223231,4276139775,4054008063,3008890623],a.PuOr8=[1411877119,2155064575,2997605119,3638225919,4276139775,4256719871,3766621439,3008890623],a.PuOr9=[1411877119,2155064575,2997605119,3638225919,4160223231,4276139775,4256719871,3766621439,3008890623],a.PuOr10=[754994175,1411877119,2155064575,2997605119,3638225919,4276139775,4256719871,3766621439,3008890623,2134575359],a.PuOr11=[754994175,1411877119,2155064575,2997605119,3638225919,4160223231,4276139775,4256719871,3766621439,3008890623,2134575359],a.BrBG3=[1521790207,4126537215,3635635711],a.BrBG4=[25522687,2160968191,3754065407,2791381759],a.BrBG5=[25522687,2160968191,4126537215,3754065407,2791381759],a.BrBG6=[23486207,1521790207,3354060287,4142449663,3635635711,2354121471],a.BrBG7=[23486207,1521790207,3354060287,4126537215,4142449663,3635635711,2354121471],a.BrBG8=[23486207,899125247,2160968191,3354060287,4142449663,3754065407,3212914175,2354121471],a.BrBG9=[23486207,899125247,2160968191,3354060287,4126537215,4142449663,3754065407,3212914175,2354121471],a.BrBG10=[3944703,23486207,899125247,2160968191,3354060287,4142449663,3754065407,3212914175,2354121471,1412433407],a.BrBG11=[3944703,23486207,899125247,2160968191,3354060287,4126537215,4142449663,3754065407,3212914175,2354121471,1412433407],a.PRGn3=[2143255551,4160223231,2945303551],a.PRGn4=[8927231,2799411455,3265646591,2066912511],a.PRGn5=[8927231,2799411455,4160223231,3265646591,2066912511],a.PRGn6=[460863487,2143255551,3656438783,3889490175,2945303551,1982497791],a.PRGn7=[460863487,2143255551,3656438783,4160223231,3889490175,2945303551,1982497791],a.PRGn8=[460863487,1521377791,2799411455,3656438783,3889490175,3265646591,2574298111,1982497791],a.PRGn9=[460863487,1521377791,2799411455,3656438783,4160223231,3889490175,3265646591,2574298111,1982497791],a.PRGn10=[4463615,460863487,1521377791,2799411455,3656438783,3889490175,3265646591,2574298111,1982497791,1073761279],a.PRGn11=[4463615,460863487,1521377791,2799411455,3656438783,4160223231,3889490175,3265646591,2574298111,1982497791,1073761279],a.PiYG3=[2715249407,4160223231,3919825407],a.PiYG4=[1303127807,3101787903,4055292671,3491531775],a.PiYG5=[1303127807,3101787903,4160223231,4055292671,3491531775],a.PiYG6=[1301422591,2715249407,3874869503,4259377151,3919825407,3306913279],a.PiYG7=[1301422591,2715249407,3874869503,4160223231,4259377151,3919825407,3306913279],a.PiYG8=[1301422591,2143044095,3101787903,3874869503,4259377151,4055292671,3732385535,3306913279],a.PiYG9=[1301422591,2143044095,3101787903,3874869503,4160223231,4259377151,4055292671,3732385535,3306913279],a.PiYG10=[660871679,1301422591,2143044095,3101787903,3874869503,4259377151,4055292671,3732385535,3306913279,2382451455],a.PiYG11=[660871679,1301422591,2143044095,3101787903,3874869503,4160223231,4259377151,4055292671,3732385535,3306913279,2382451455],a.RdBu3=[1739182079,4160223231,4018823935],a.RdBu4=[91336959,2462441215,4104487679,3389006079],a.RdBu5=[91336959,2462441215,4160223231,4104487679,3389006079],a.RdBu6=[560377087,1739182079,3521507583,4259039231,4018823935,2987928575],a.RdBu7=[560377087,1739182079,3521507583,4160223231,4259039231,4018823935,2987928575],a.RdBu8=[560377087,1133757439,2462441215,3521507583,4259039231,4104487679,3596635647,2987928575],a.RdBu9=[560377087,1133757439,2462441215,3521507583,4160223231,4259039231,4104487679,3596635647,2987928575],a.RdBu10=[87056895,560377087,1133757439,2462441215,3521507583,4259039231,4104487679,3596635647,2987928575,1728061439],a.RdBu11=[87056895,560377087,1133757439,2462441215,3521507583,4160223231,4259039231,4104487679,3596635647,2987928575,1728061439],a.RdGy3=[2576980479,4294967295,4018823935],a.RdGy4=[1077952767,3132799743,4104487679,3389006079],a.RdGy5=[1077952767,3132799743,4294967295,4104487679,3389006079],a.RdGy6=[1296911871,2576980479,3772834047,4259039231,4018823935,2987928575],a.RdGy7=[1296911871,2576980479,3772834047,4294967295,4259039231,4018823935,2987928575],a.RdGy8=[1296911871,2273806335,3132799743,3772834047,4259039231,4104487679,3596635647,2987928575],a.RdGy9=[1296911871,2273806335,3132799743,3772834047,4294967295,4259039231,4104487679,3596635647,2987928575],a.RdGy10=[437918463,1296911871,2273806335,3132799743,3772834047,4259039231,4104487679,3596635647,2987928575,1728061439],a.RdGy11=[437918463,1296911871,2273806335,3132799743,3772834047,4294967295,4259039231,4104487679,3596635647,2987928575,1728061439],a.RdYlBu3=[2445270015,4294950911,4237122047],a.RdYlBu4=[746305279,2883185151,4256063999,3608747263],a.RdYlBu5=[746305279,2883185151,4294950911,4256063999,3608747263],a.RdYlBu6=[1165341951,2445270015,3774085375,4276130047,4237122047,3610257407],a.RdYlBu7=[1165341951,2445270015,3774085375,4294950911,4276130047,4237122047,3610257407],a.RdYlBu8=[1165341951,1957548543,2883185151,3774085375,4276130047,4256063999,4100801535,3610257407],a.RdYlBu9=[1165341951,1957548543,2883185151,3774085375,4294950911,4276130047,4256063999,4100801535,3610257407],a.RdYlBu10=[825660927,1165341951,1957548543,2883185151,3774085375,4276130047,4256063999,4100801535,3610257407,2768250623],a.RdYlBu11=[825660927,1165341951,1957548543,2883185151,3774085375,4294950911,4276130047,4256063999,4100801535,3610257407,2768250623],a.Spectral3=[2580911359,4294950911,4237122047],a.Spectral4=[730053375,2883429631,4256063999,3608747263],a.Spectral5=[730053375,2883429631,4294950911,4256063999,3608747263],a.Spectral6=[847822335,2580911359,3874855167,4276128767,4237122047,3577630719],a.Spectral7=[847822335,2580911359,3874855167,4294950911,4276128767,4237122047,3577630719],a.Spectral8=[847822335,1724032511,2883429631,3874855167,4276128767,4256063999,4100801535,3577630719],a.Spectral9=[847822335,1724032511,2883429631,3874855167,4294950911,4276128767,4256063999,4100801535,3577630719],a.Spectral10=[1582277375,847822335,1724032511,2883429631,3874855167,4276128767,4256063999,4100801535,3577630719,2650882815],a.Spectral11=[1582277375,847822335,1724032511,2883429631,3874855167,4294950911,4276128767,4256063999,4100801535,3577630719,2650882815],a.RdYlGn3=[2446287103,4294950911,4237122047],a.RdYlGn4=[446054911,2799266559,4256063999,3608747263],a.RdYlGn5=[446054911,2799266559,4294950911,4256063999,3608747263],a.RdYlGn6=[446189823,2446287103,3656354815,4276128767,4237122047,3610257407],a.RdYlGn7=[446189823,2446287103,3656354815,4294950911,4276128767,4237122047,3610257407],a.RdYlGn8=[446189823,1723687935,2799266559,3656354815,4276128767,4256063999,4100801535,3610257407],a.RdYlGn9=[446189823,1723687935,2799266559,3656354815,4294950911,4276128767,4256063999,4100801535,3610257407],a.RdYlGn10=[6830079,446189823,1723687935,2799266559,3656354815,4276128767,4256063999,4100801535,3610257407,2768250623],a.RdYlGn11=[6830079,446189823,1723687935,2799266559,3656354815,4294950911,4276128767,4256063999,4100801535,3610257407,2768250623],a.Inferno3=[1023,3124123135,4244546815],a.Inferno4=[1023,2015129087,3983025663,4244546815],a.Inferno5=[1023,1427074559,3124123135,4186704383,4244546815],a.Inferno6=[1023,1091135487,2468702207,3696245247,4221831935,4244546815],a.Inferno7=[1023,839474687,2015129087,3124123135,3983025663,4222818559,4244546815],a.Inferno8=[1023,655053567,1662283519,2653512703,3527885567,4118550015,4206831103,4244546815],a.Inferno9=[1023,520898559,1427074559,2283891455,3124123135,3814208255,4186704383,4173935103,4244546815],a.Inferno10=[1023,436945151,1242262271,2015129087,2754371839,3443673087,3983025663,4221110015,4157553407,4244546815],a.Inferno11=[1023,369834495,1091135487,1779920639,2468702207,3124123135,3696245247,4067760895,4221831935,4141171455,4244546815],a.Inferno256=[1023,1279,1791,16779263,16845311,16845823,33623807,33689855,50467583,67310847,67311359,84154623,100932607,117775871,134619135,151396863,168240127,185018111,218638591,235416319,252259839,269037567,302658303,319436031,336279295,369834495,386612223,420167423,436945151,470565887,487343615,520898559,537676543,571165951,604720895,638275839,655053567,688608511,722097919,755652863,772430591,805985535,839474687,873029631,889807103,923361791,956916479,990471423,1007248895,1040803583,1074358015,1091135487,1124755711,1158310399,1175087615,1208707839,1242262271,1259105279,1292659711,1326279935,1343057151,1376677119,1393454591,1427074559,1460628991,1477471743,1511091711,1527869183,1561489151,1595043583,1611886335,1645506303,1662283519,1695903487,1712680703,1746300671,1779920639,1796697855,1830317823,1847095039,1880715007,1914269183,1931111935,1964731903,1981509119,2015129087,2048683519,2065526015,2099080447,2115923199,2149542911,2166320127,2199940095,2233494271,2250337023,2283891455,2300733951,2334288383,2367908351,2384750847,2418305279,2435147775,2468702207,2502321919,2519099135,2552718847,2569561343,2603115775,2619958271,2653512703,2687132415,2703974911,2737529343,2754371839,2787926015,2804768767,2838388479,2871942655,2888785151,2922404863,2939247615,2972801791,2989644287,3023263999,3040040959,3073660671,3090503423,3124123135,3140965631,3174519807,3191362303,3208204799,3241824511,3258667007,3292286719,3309129215,3342748927,3359525887,3376368383,3409988095,3426830591,3443673087,3477358335,3494200575,3511043071,3527885567,3561505279,3578347775,3595190271,3612032767,3645718015,3662560255,3679402751,3696245247,3713153279,3729995775,3746838271,3763746047,3797365759,3814208255,3831116287,3847958783,3864801023,3864931839,3881774335,3898682367,3915524863,3932432639,3949275135,3966183167,3983025663,3983156223,4000064255,4016906751,4033814527,4033879807,4050787839,4067695871,4067760895,4084668927,4084799743,4101641983,4118550015,4118680831,4135588607,4135653887,4152561919,4152692479,4169600511,4169665791,4169796607,4186704383,4186835199,4186966271,4203808767,4203939583,4204070655,4204201727,4221110015,4221241087,4221372159,4221437951,4221569023,4221700351,4221831935,4221963263,4222094847,4222226175,4222357759,4222489343,4222620927,4222686975,4222818559,4222950143,4223081727,4223213311,4206567935,4206699519,4206831103,4206962943,4190317311,4190448895,4190580735,4173935103,4174066943,4174198783,4157553407,4157684991,4141039615,4141171455,4124526079,4124657919,4108012543,4108079103,4091433727,4091565823,4091697663,4075052543,4075184383,4058539263,4058605823,4058737919,4058870015,4058936575,4059068927,4059201023,4076044799,4076111359,4093020671,4109864447,4126708223,4143617535,4160461311,4194082303,4210925823,4244546815],a.Magma3=[1023,3040246271,4227645439],a.Magma4=[1023,1897890303,4032847359,4227645439],a.Magma5=[1023,1326545919,3040246271,4219887871,4227645439],a.Magma6=[1023,990867455,2351530239,3712575743,4255083775,4227645439],a.Magma7=[1023,722558719,1897890303,3040246271,4032847359,4272846591,4227645439],a.Magma8=[1023,571560191,1561820927,2536275967,3510791935,4168441087,4273569791,4227645439],a.Magma9=[1023,454051071,1326545919,2166718975,3040246271,3847250943,4219887871,4274161407,4227645439],a.Magma10=[1023,386874623,1125086719,1897890303,2653847295,3409867263,4032847359,4237518591,4274490367,4227645439],a.Magma11=[1023,336410111,990867455,1662615551,2351530239,3040246271,3712575743,4134427647,4255083775,4258107647,4227645439],a.Magma256=[1023,1279,1791,16779263,16845311,16845823,33689087,33689599,50532863,67310591,67376639,84154367,100997631,117775359,134618623,151461887,168239871,185083135,201926399,218769663,235547391,252390655,269234175,286011903,302855167,336410111,353253631,370031359,386874623,403652607,437273087,454051071,470828799,504383999,521227263,538004991,571560191,588337919,621893119,638670847,672225791,705780991,722558719,756048127,789603071,806381055,839935999,873490687,890202879,923757823,957312767,990867455,1007645183,1041199871,1074754559,1108309247,1125086719,1158641407,1192196095,1209039103,1242593791,1259371007,1292991231,1326545919,1343388671,1376943359,1393786111,1427340799,1460960767,1477803775,1511358207,1528200959,1561820927,1578598399,1612218367,1628995583,1662615551,1696235775,1713012991,1746632959,1763475711,1797030143,1813872895,1847493119,1864270335,1897890303,1931444735,1948287487,1981907455,1998684671,2032304639,2049081855,2082701823,2116321791,2133099007,2166718975,2183496191,2217116159,2233893375,2267513343,2301133311,2317910527,2351530239,2368307455,2401927423,2435481855,2452324607,2485879039,2502721791,2536275967,2569895935,2586673151,2620293119,2653847295,2670690047,2704244479,2737864447,2754641407,2788261375,2805038591,2838658303,2872278271,2889055231,2922675199,2956229631,2973072127,3006626559,3040246271,3057023487,3090643199,3107420415,3141040127,3174660095,3191437055,3225056767,3258611199,3275453695,3309073663,3325850623,3359470335,3393090303,3409867263,3443486975,3460329727,3493949439,3510791935,3544346111,3561188863,3594808575,3611651071,3645270783,3662113279,3695733247,3712575743,3729418239,3763037951,3779880703,3796723199,3830342911,3847250943,3864093439,3880936191,3897844223,3931463935,3948306687,3965214719,3982057471,3998965503,3999096319,4015939071,4032847359,4049689855,4066598143,4083506431,4083637247,4100479999,4117388287,4117519359,4134427647,4134558719,4151401471,4151532799,4168441087,4168572159,4185480447,4185611775,4185742847,4202651391,4202716927,4202848255,4219756799,4219887871,4220019199,4220150527,4237059071,4237190143,4237321471,4237452799,4237518591,4254427135,4254558463,4254689791,4254821119,4254952447,4255083775,4255215359,4255281151,4255412479,4272321023,4272452607,4272583935,4272715263,4272846591,4272912639,4273043967,4273175551,4273306879,4273438207,4273569791,4273701119,4273767167,4273898495,4274030079,4274161407,4274292991,4274424319,4274490367,4274621951,4274753279,4258107647,4258239231,4258370559,4258436607,4258568191,4258699519,4258831103,4258962687,4259094015,4259160063,4259291647,4259423231,4242777599,4242908927,4242974975,4243106559,4243238143,4243369727,4243501311,4243632639,4243698687,4243830271,4243961855,4227316223,4227447807,4227513855,4227645439],a.Plasma3=[201819903,3393616127,4026016255],a.Plasma4=[201819903,2602016511,3967308799,4026016255],a.Plasma5=[201819903,2080548863,3393616127,4153623039,4026016255],a.Plasma6=[201819903,1778427903,2955579391,3764675071,4238751231,4026016255],a.Plasma7=[201819903,1543546367,2602016511,3393616127,3967308799,4256313343,4026016255],a.Plasma8=[201819903,1375839231,2299045375,3090319871,3663358207,4085729535,4256902143,4026016255],a.Plasma9=[201819903,1241686271,2080548863,2820839167,3393616127,3849018623,4153623039,4257425663,4026016255],a.Plasma10=[201819903,1157865215,1912645887,2602016511,3157689855,3612765439,3967308799,4204608255,4240910079,4026016255],a.Plasma11=[201819903,1073978623,1778427903,2400035839,2955579391,3393616127,3764675071,4051848447,4238751231,4241237503,4026016255],a.Plasma256=[201819903,268929023,319195647,352750335,403082239,453414143,486968831,520457983,554012671,587567359,621122047,654676735,688231423,721786111,755275007,788829695,822384383,855939071,872716543,906270975,939825663,973380351,990092031,1023646719,1057201407,1073978623,1107533311,1141087999,1157865215,1191354367,1224908799,1241686271,1275240959,1308795391,1325572863,1359061759,1375839231,1409393663,1442948095,1459725567,1493279999,1509991935,1543546367,1577100799,1593878271,1627432703,1644209919,1677764607,1694541823,1728096255,1744873471,1778427903,1811982591,1828759807,1862314239,1879091455,1912645887,1929423103,1962977535,1979820287,2013374719,2030151935,2063771903,2080548863,2114168831,2130946047,2164566015,2181343231,2214962943,2231805695,2248648447,2282202623,2299045375,2332665087,2349507839,2383193343,2400035839,2416878591,2450498303,2467340799,2500960767,2517803263,2534646015,2568265727,2585108223,2602016511,2635636223,2652478719,2669321215,2686163967,2719783679,2736626175,2753468671,2770311167,2803996671,2820839167,2837681663,2854524159,2888143871,2904986367,2921828863,2938671359,2955579391,2972422143,2989264639,3022884351,3039726847,3056569343,3073411839,3090319871,3107162367,3124004863,3140847359,3157689855,3174532351,3191374847,3208217343,3225125375,3241967871,3258810623,3275653119,3292495615,3309338111,3326180607,3343023103,3359931135,3376773631,3393616127,3410458623,3427301119,3444143615,3460986367,3477828863,3494736895,3511579391,3511644671,3528487167,3545329663,3562172159,3579014655,3595922943,3612765439,3612830719,3629673215,3646515711,3663358207,3680200703,3697108735,3697174271,3714016767,3730859263,3747701759,3747767039,3764675071,3781517567,3798360319,3815202815,3815268095,3832176127,3849018623,3849083903,3865926399,3882769151,3899677183,3899742463,3916584959,3933427455,3933492735,3950400767,3967243519,3967308799,3984151295,3984282111,4001124607,4017967103,4018032383,4034940415,4035005951,4051848447,4068756479,4068821759,4085664255,4085729535,4102637567,4102703103,4119545599,4119676415,4136518911,4136584191,4136715007,4153557503,4153623039,4170531071,4170596351,4170727167,4187569663,4187634943,4204542975,4204608255,4204739327,4204804607,4221712639,4221777919,4221843199,4238751231,4238816767,4238947583,4239012863,4239143679,4239208959,4256117247,4256182527,4256313343,4256378623,4256509439,4256574975,4256705791,4256771071,4256902143,4256967423,4257098239,4257229311,4257294591,4257425663,4257490943,4257621759,4240910079,4241041151,4241171967,4241237503,4241368575,4224722175,4224787711,4224918783,4208272639,4208338175,4208469247,4191757567,4191888639,4175242495,4175373567,4158661887,4158793215,4142147071,4142212607,4125566719,4125697791,4108986111,4092339967,4092471039,4075824895,4075890431,4059244287,4042597887,4042662911,4026016255],a.Viridis3=[1140937983,546278655,4259783935],a.Viridis4=[1140937983,812092927,901216511,4259783935],a.Viridis5=[1140937983,995199743,546278655,1539859199,4259783935],a.Viridis6=[1140937983,1078167551,695766783,581403903,2043761151,4259783935],a.Viridis7=[1140937983,1144619775,812092927,546278655,901216511,2379629823,4259783935],a.Viridis8=[1140937983,1177648895,911903999,662605567,513837055,1237413375,2648259327,4259783935],a.Viridis9=[1140937983,1194031871,995199743,745639679,546278655,665682175,1539859199,2866492159,4259783935],a.Viridis10=[1140937983,1193768959,1045006847,812092927,629313279,513575423,901216511,1808620031,3000839423,4259783935],a.Viridis11=[1140937983,1210283263,1078167551,878611967,695766783,546278655,581403903,1119777279,2043761151,3135121407,4259783935],a.Viridis256=[1140937983,1141003775,1141069823,1157978367,1158044415,1158175743,1175018751,1175150335,1175216127,1175347711,1192190719,1192322047,1192388095,1192519423,1192585215,1192651263,1192782591,1209625599,1209691391,1209822975,1209888767,1209954559,1210085887,1210151679,1210217471,1210283263,1193637375,1193703167,1193768959,1193834751,1193966079,1194031871,1194097663,1177386239,1177517311,1177583103,1177648895,1160937471,1161068543,1161134335,1161200127,1144488447,1144619775,1127908351,1127973887,1128039679,1111327999,1111393791,1111524863,1094813439,1094878975,1078167551,1078233087,1061521407,1061652735,1044941055,1045006847,1028295167,1028360703,1028426239,1011714815,1011780351,995134207,995199743,978488319,978553855,961842175,961907711,945196031,945261823,928550143,928615679,911903999,911969535,895257855,895323391,878611967,878677503,861965823,862031359,845319679,845385215,828673535,828739071,828804607,812092927,812158463,795446783,795512319,778800895,778866431,778931967,762220287,762285823,745574143,745639679,745705215,728993535,729059071,712347391,712412927,712478463,695766783,695832319,679120639,679120639,679186175,662474495,662540031,662605567,645893887,645959423,646024959,629313279,629378559,612666879,612732415,612797951,596086271,596151807,596217343,579440127,579505663,579571199,562859519,562924799,562990335,546278655,546344191,546409727,529698047,529763327,529828863,529894399,529959935,513247999,513313535,513379071,513379071,513444351,513509887,513575423,513640703,513706239,513771775,513837055,530679807,530745087,530810623,547653119,547718655,564561407,564626687,581403903,598246399,598311679,615154431,631996927,648839679,665682175,682524671,699367423,716209919,733052415,749829631,783449343,800291839,817134335,850754303,867596799,901216511,918059007,951678719,968455935,1002075647,1035695359,1052537855,1086157567,1119777279,1153331455,1170173951,1203793663,1237413375,1271033087,1304587263,1338206719,1371826431,1405446143,1439065855,1472620031,1506239743,1539859199,1590256127,1623810303,1657430015,1691049471,1741446399,1775000575,1808620031,1842239743,1892570879,1926190591,1959810303,2010141439,2043761151,2094157823,2127711999,2178108671,2211662847,2262059519,2295678975,2346010367,2379629823,2429961215,2463580671,2513911807,2547531519,2597862655,2648259327,2681813247,2732210175,2782541311,2816160767,2866492159,2916888831,2950442751,3000839423,3051170815,3084724735,3135121407,3185452799,3219072255,3269403391,3319734783,3353354239,3403685631,3454017023,3487636735,3537968127,3571522303,3621919231,3672250623,3705805055,3756202239,3789756671,3840088319,3890485759,3924040191,3974372095,4007992319,4058324223,4091879167,4142276607,4175831551,4209386239,4259783935],a.Cividis3=[2116863,2071689471,16771397],a.Cividis4=[2116863,1448897791,2795271679,16771397],a.Cividis5=[2116863,1078750207,2071689471,3165548287,16771397],a.Cividis6=[2116863,826567679,1718120703,2509207807,3401148927,16771397],a.Cividis7=[2116863,574450943,1448897791,2071689471,2795271679,3552601599,16771397],a.Cividis8=[2116863,356085247,1230203903,1819112191,2374531327,2997252863,3653657087,16771397],a.Cividis9=[2116863,20279039,1078750207,1600351999,2071689471,2610132991,3165548287,3754647039,16771397],a.Cividis10=[2116863,3370751,927427583,1448897791,1869640703,2307225855,2795271679,3283381503,3821886463,16771397],a.Cividis11=[2116863,3239935,826567679,1297443839,1718120703,2071689471,2509207807,2929947647,3401148927,3872414207,16771397],a.Cividis256=[2116863,2117375,2183423,2249215,2315263,2315775,2381567,2447615,2513663,2513919,2579967,2646015,2646527,2712575,2778367,2778879,2844927,2910975,2977023,2977279,3043071,3043327,3108863,3108863,3174399,3239935,3239935,3305215,3370751,3436287,3436287,20279039,104230655,171404799,238513663,305688063,356085247,389639679,440036607,473656575,507276543,540830975,574450943,608070911,641625343,658468095,692087807,725707775,742484991,776104959,792947711,826567679,843344895,860187647,893807615,910584831,927427583,944270335,977890303,994667519,1011510271,1028353023,1045130239,1078750207,1095592959,1112435711,1129212927,1146055679,1162898431,1179675647,1196518399,1213361151,1230203903,1246981119,1263823871,1280666623,1297443839,1314286591,1331129599,1347972351,1364749567,1381592319,1398435071,1415212287,1432055039,1448897791,1465740799,1482518015,1499360767,1516203519,1532980735,1549823487,1566666495,1583509247,1600286463,1600351999,1617194751,1634037759,1650814975,1667657727,1684500479,1701277695,1718120703,1734963455,1751806207,1751806207,1768649215,1785491967,1802334719,1819112191,1835954943,1852797695,1869574911,1869640703,1886483455,1903326207,1920103679,1936946431,1953789439,1970632191,1970632191,1987475199,2004317951,2021160703,2037938175,2054780927,2071623679,2071689471,2088466687,2105309439,2122152191,2138994943,2155772159,2172614911,2189457663,2206300415,2223077631,2239920383,2256763135,2273605887,2290448639,2307225855,2324068607,2340911359,2357754111,2374531327,2391374079,2408216831,2425059583,2441902335,2458679551,2475522303,2492365055,2509207807,2525984767,2542827519,2559670271,2576513023,2593355775,2610132991,2626975743,2643818495,2660660991,2677503743,2694346495,2711123711,2727966463,2744808959,2761651711,2778494463,2795271679,2812114431,2828956927,2845799679,2862642431,2879485183,2896262143,2913104895,2929947647,2946790399,2963632895,2980475647,2997252863,3030872575,3047715327,3064558079,3081400575,3098243327,3115020543,3131863039,3148705791,3165548287,3182391039,3199233791,3216076287,3232853503,3249695999,3266538751,3283381503,3317001215,3333843967,3350686463,3367529215,3384306175,3401148927,3417991423,3434834175,3451676671,3468519423,3502139135,3518981887,3535824383,3552601599,3569444095,3586286591,3603129343,3619971839,3636814335,3653657087,3687276799,3704119551,3720962047,3737804543,3754647039,3771424255,3788266751,3821886463,3838729215,3855571711,3872414207,3889256703,3906099199,3922941695,3956561663,3973404159,3990246655,4007089151,4023931647,4040774143,4057616639,4091236351,4108078847,4124921343,4141763839,4158606335,4192225791,4209002751,4225845247,4242687743,4259530239,4293149695,4293214975,4293280511,4293346303,4293412095,4293477887],a.Turbo3=[806501375,2717662719,7996418],a.Turbo4=[806501375,451196671,4189731071,7996418],a.Turbo5=[806501375,716828159,2717662719,4219478783,7996418],a.Turbo6=[806501375,1050410751,1190626303,3789305855,4015657471,7996418],a.Turbo7=[806501375,1166342655,451196671,2717662719,4189731071,3846572799,7996418],a.Turbo8=[806501375,1182133759,483252223,1643932927,3488232703,4271582719,3678013439,7996418],a.Turbo9=[806501375,1181278463,716828159,804297471,2717662719,3973134847,4219478783,3526362623,7996418],a.Turbo10=[806501375,1163974399,917043711,451196671,1912430591,3320787967,4189731071,4134213887,3408593919,7996418],a.Turbo11=[806501375,1146670079,1050410751,416664831,1190626303,2717662719,3789305855,4255527423,4015657471,3307602687,7996418],a.Turbo256=[806501375,823476991,840452863,874205695,891181311,908156927,925066751,942042367,959017727,975993343,992968703,1009944063,1010142207,1027052031,1044027135,1061002495,1077977599,1078175487,1095085055,1095282943,1112258047,1129233151,1129365247,1129562879,1146537983,1146670079,1163644671,1163842303,1163974399,1164171775,1181146623,1181278463,1181475839,1181607679,1181804799,1182002175,1182133759,1182331135,1182462719,1182659839,1182791423,1182988543,1166342655,1166539775,1166671103,1150090751,1133444607,1116864255,1100218111,1083637503,1066991359,1050410751,1016987135,1000406271,966982911,950402047,917043711,883620095,866973439,833615359,800191487,766833151,733409279,716828159,683404287,649980415,633399039,599975167,566551039,549904383,516545791,499899135,483252223,466605311,449958655,433311743,416664831,416795391,400148479,400213247,400343807,400474111,417381887,417446655,434354431,451196671,468038911,501723647,518565887,552185087,585869823,619489023,669885439,703504639,753901055,804297471,854693887,905155839,955552255,1005882879,1073056511,1123452927,1190626303,1257799935,1308196095,1375304191,1442477823,1509651199,1576759295,1643932927,1711040767,1778214399,1845322495,1912430591,1962827007,2029935103,2097043199,2164151295,2231259391,2281590271,2348698623,2399029503,2466137855,2516468991,2566800127,2617065727,2667396863,2717662719,2767993855,2801482495,2851813887,2902079487,2935568383,2985834239,3019388415,3069654527,3119854847,3153343743,3203609855,3237098495,3287364607,3320787967,3371054079,3404542975,3454743807,3488232703,3521656063,3571922431,3605345791,3638769151,3672258303,3722458879,3755882239,3789305855,3822729215,3856152831,3889641727,3906287871,3939711487,3973134847,3989780991,4023204351,4039850751,4073208575,4089854719,4106500863,4139924223,4156570111,4173216255,4189862399,4189731071,4206311423,4222957567,4222826239,4239406591,4239275263,4255855615,4255724287,4255527423,4255330559,4271976447,4271779583,4271582719,4271385855,4254411775,4254214655,4254017791,4253820927,4236846847,4236649727,4219675647,4219478783,4202504447,4202307583,4185333503,4168359167,4151385087,4151188223,4134213887,4117239807,4100265727,4083357183,4066383103,4049409023,4015657471,3998748927,3981774847,3964800767,3931115007,3914141183,3897232639,3863546879,3846572799,3812887295,3795978751,3762292991,3728607487,3711698943,3678013439,3644327679,3610642175,3593733631,3560048127,3526362623,3492742399,3459056895,3408593919,3374908415,3341288447,3307602687,3273917183,3223519999,3189834495,3139371519,3105751551,3055288831,3021668863,2971206143,2920808959,2887123455,2836726271,2786329087,2735866367,2685469183,2635071999,2584609279,2534212095,2483814911,2433417727,2383020543,2332623359,2265448959,2215051775,2164654847,2097480447,2047083263],a.Accent3=[2143911935,3199128831,4257253119],a.Accent4=[2143911935,3199128831,4257253119,4294941183],a.Accent5=[2143911935,3199128831,4257253119,4294941183,946647295],a.Accent6=[2143911935,3199128831,4257253119,4294941183,946647295,4026695679],a.Accent7=[2143911935,3199128831,4257253119,4294941183,946647295,4026695679,3210418175],a.Accent8=[2143911935,3199128831,4257253119,4294941183,946647295,4026695679,3210418175,1717987071],a.Dark2_3=[463370239,3646882559,1970320383],a.Dark2_4=[463370239,3646882559,1970320383,3878259455],a.Dark2_5=[463370239,3646882559,1970320383,3878259455,1722162943],a.Dark2_6=[463370239,3646882559,1970320383,3878259455,1722162943,3869967103],a.Dark2_7=[463370239,3646882559,1970320383,3878259455,1722162943,3869967103,2792758783],a.Dark2_8=[463370239,3646882559,1970320383,3878259455,1722162943,3869967103,2792758783,1717987071],a.Paired3=[2798576639,528004351,3000994559],a.Paired4=[2798576639,528004351,3000994559,866135295],a.Paired5=[2798576639,528004351,3000994559,866135295,4221213183],a.Paired6=[2798576639,528004351,3000994559,866135295,4221213183,3810139391],a.Paired7=[2798576639,528004351,3000994559,866135295,4221213183,3810139391,4257181695],a.Paired8=[2798576639,528004351,3000994559,866135295,4221213183,3810139391,4257181695,4286513407],a.Paired9=[2798576639,528004351,3000994559,866135295,4221213183,3810139391,4257181695,4286513407,3400718079],a.Paired10=[2798576639,528004351,3000994559,866135295,4221213183,3810139391,4257181695,4286513407,3400718079,1782422271],a.Paired11=[2798576639,528004351,3000994559,866135295,4221213183,3810139391,4257181695,4286513407,3400718079,1782422271,4294941183],a.Paired12=[2798576639,528004351,3000994559,866135295,4221213183,3810139391,4257181695,4286513407,3400718079,1782422271,4294941183,2975410431],a.Pastel1_3=[4222922495,3016614911,3438003711],a.Pastel1_4=[4222922495,3016614911,3438003711,3737904383],a.Pastel1_5=[4222922495,3016614911,3438003711,3737904383,4275676927],a.Pastel1_6=[4222922495,3016614911,3438003711,3737904383,4275676927,4294954239],a.Pastel1_7=[4222922495,3016614911,3438003711,3737904383,4275676927,4294954239,3856186879],a.Pastel1_8=[4222922495,3016614911,3438003711,3737904383,4275676927,4294954239,3856186879,4258983167],a.Pastel1_9=[4222922495,3016614911,3438003711,3737904383,4275676927,4294954239,3856186879,4258983167,4076008191],a.Pastel2_3=[3017985535,4258114815,3419793663],a.Pastel2_4=[3017985535,4258114815,3419793663,4106937599],a.Pastel2_5=[3017985535,4258114815,3419793663,4106937599,3874867711],a.Pastel2_6=[3017985535,4258114815,3419793663,4106937599,3874867711,4294094591],a.Pastel2_7=[3017985535,4258114815,3419793663,4106937599,3874867711,4294094591,4058172671],a.Pastel2_8=[3017985535,4258114815,3419793663,4106937599,3874867711,4294094591,4058172671,3435973887],a.Set1_3=[3826916607,931051775,1303333631],a.Set1_4=[3826916607,931051775,1303333631,2555290623],a.Set1_5=[3826916607,931051775,1303333631,2555290623,4286513407],a.Set1_6=[3826916607,931051775,1303333631,2555290623,4286513407,4294915071],a.Set1_7=[3826916607,931051775,1303333631,2555290623,4286513407,4294915071,2790664447],a.Set1_8=[3826916607,931051775,1303333631,2555290623,4286513407,4294915071,2790664447,4152475647],a.Set1_9=[3826916607,931051775,1303333631,2555290623,4286513407,4294915071,2790664447,4152475647,2576980479],a.Set2_3=[1724032511,4237124351,2376125439],a.Set2_4=[1724032511,4237124351,2376125439,3884631039],a.Set2_5=[1724032511,4237124351,2376125439,3884631039,2799195391],a.Set2_6=[1724032511,4237124351,2376125439,3884631039,2799195391,4292423679],a.Set2_7=[1724032511,4237124351,2376125439,3884631039,2799195391,4292423679,3854865663],a.Set2_8=[1724032511,4237124351,2376125439,3884631039,2799195391,4292423679,3854865663,3014898687],a.Set3_3=[2379466751,4294947839,3199916799],a.Set3_4=[2379466751,4294947839,3199916799,4219499263],a.Set3_5=[2379466751,4294947839,3199916799,4219499263,2159137791],a.Set3_6=[2379466751,4294947839,3199916799,4219499263,2159137791,4256457471],a.Set3_7=[2379466751,4294947839,3199916799,4219499263,2159137791,4256457471,3017697791],a.Set3_8=[2379466751,4294947839,3199916799,4219499263,2159137791,4256457471,3017697791,4241352191],a.Set3_9=[2379466751,4294947839,3199916799,4219499263,2159137791,4256457471,3017697791,4241352191,3654932991],a.Set3_10=[2379466751,4294947839,3199916799,4219499263,2159137791,4256457471,3017697791,4241352191,3654932991,3162553855],a.Set3_11=[2379466751,4294947839,3199916799,4219499263,2159137791,4256457471,3017697791,4241352191,3654932991,3162553855,3438003711],a.Set3_12=[2379466751,4294947839,3199916799,4219499263,2159137791,4256457471,3017697791,4241352191,3654932991,3162553855,3438003711,4293750783],a.Category10_3=[527938815,4286516991,748694783],a.Category10_4=[527938815,4286516991,748694783,3592890623],a.Category10_5=[527938815,4286516991,748694783,3592890623,2489826815],a.Category10_6=[527938815,4286516991,748694783,3592890623,2489826815,2354465791],a.Category10_7=[527938815,4286516991,748694783,3592890623,2489826815,2354465791,3816276735],a.Category10_8=[527938815,4286516991,748694783,3592890623,2489826815,2354465791,3816276735,2139062271],a.Category10_9=[527938815,4286516991,748694783,3592890623,2489826815,2354465791,3816276735,2139062271,3166511871],a.Category10_10=[527938815,4286516991,748694783,3592890623,2489826815,2354465791,3816276735,2139062271,3166511871,398381055],a.Category20_3=[527938815,2932336895,4286516991],a.Category20_4=[527938815,2932336895,4286516991,4290476287],a.Category20_5=[527938815,2932336895,4286516991,4290476287,748694783],a.Category20_6=[527938815,2932336895,4286516991,4290476287,748694783,2564786943],a.Category20_7=[527938815,2932336895,4286516991,4290476287,748694783,2564786943,3592890623],a.Category20_8=[527938815,2932336895,4286516991,4290476287,748694783,2564786943,3592890623,4288190207],a.Category20_9=[527938815,2932336895,4286516991,4290476287,748694783,2564786943,3592890623,4288190207,2489826815],a.Category20_10=[527938815,2932336895,4286516991,4290476287,748694783,2564786943,3592890623,4288190207,2489826815,3316700671],a.Category20_11=[527938815,2932336895,4286516991,4290476287,748694783,2564786943,3592890623,4288190207,2489826815,3316700671,2354465791],a.Category20_12=[527938815,2932336895,4286516991,4290476287,748694783,2564786943,3592890623,4288190207,2489826815,3316700671,2354465791,3298596095],a.Category20_13=[527938815,2932336895,4286516991,4290476287,748694783,2564786943,3592890623,4288190207,2489826815,3316700671,2354465791,3298596095,3816276735],a.Category20_14=[527938815,2932336895,4286516991,4290476287,748694783,2564786943,3592890623,4288190207,2489826815,3316700671,2354465791,3298596095,3816276735,4155953919],a.Category20_15=[527938815,2932336895,4286516991,4290476287,748694783,2564786943,3592890623,4288190207,2489826815,3316700671,2354465791,3298596095,3816276735,4155953919,2139062271],a.Category20_16=[527938815,2932336895,4286516991,4290476287,748694783,2564786943,3592890623,4288190207,2489826815,3316700671,2354465791,3298596095,3816276735,4155953919,2139062271,3351758847],a.Category20_17=[527938815,2932336895,4286516991,4290476287,748694783,2564786943,3592890623,4288190207,2489826815,3316700671,2354465791,3298596095,3816276735,4155953919,2139062271,3351758847,3166511871],a.Category20_18=[527938815,2932336895,4286516991,4290476287,748694783,2564786943,3592890623,4288190207,2489826815,3316700671,2354465791,3298596095,3816276735,4155953919,2139062271,3351758847,3166511871,3688599039],a.Category20_19=[527938815,2932336895,4286516991,4290476287,748694783,2564786943,3592890623,4288190207,2489826815,3316700671,2354465791,3298596095,3816276735,4155953919,2139062271,3351758847,3166511871,3688599039,398381055],a.Category20_20=[527938815,2932336895,4286516991,4290476287,748694783,2564786943,3592890623,4288190207,2489826815,3316700671,2354465791,3298596095,3816276735,4155953919,2139062271,3351758847,3166511871,3688599039,398381055,2665145855],a.Category20b_3=[960199167,1381278719,1802424319],a.Category20b_4=[960199167,1381278719,1802424319,2627657471],a.Category20b_5=[960199167,1381278719,1802424319,2627657471,1668889087],a.Category20b_6=[960199167,1381278719,1802424319,2627657471,1668889087,2359448319],a.Category20b_7=[960199167,1381278719,1802424319,2627657471,1668889087,2359448319,3050269695],a.Category20b_8=[960199167,1381278719,1802424319,2627657471,1668889087,2359448319,3050269695,3470499071],a.Category20b_9=[960199167,1381278719,1802424319,2627657471,1668889087,2359448319,3050269695,3470499071,2355966463],a.Category20b_10=[960199167,1381278719,1802424319,2627657471,1668889087,2359448319,3050269695,3470499071,2355966463,3181263359],a.Category20b_11=[960199167,1381278719,1802424319,2627657471,1668889087,2359448319,3050269695,3470499071,2355966463,3181263359,3887747839],a.Category20b_12=[960199167,1381278719,1802424319,2627657471,1668889087,2359448319,3050269695,3470499071,2355966463,3181263359,3887747839,3888878847],a.Category20b_13=[960199167,1381278719,1802424319,2627657471,1668889087,2359448319,3050269695,3470499071,2355966463,3181263359,3887747839,3888878847,2218539519],a.Category20b_14=[960199167,1381278719,1802424319,2627657471,1668889087,2359448319,3050269695,3470499071,2355966463,3181263359,3887747839,3888878847,2218539519,2907261695],a.Category20b_15=[960199167,1381278719,1802424319,2627657471,1668889087,2359448319,3050269695,3470499071,2355966463,3181263359,3887747839,3888878847,2218539519,2907261695,3596708863],a.Category20b_16=[960199167,1381278719,1802424319,2627657471,1668889087,2359448319,3050269695,3470499071,2355966463,3181263359,3887747839,3888878847,2218539519,2907261695,3596708863,3885407487],a.Category20b_17=[960199167,1381278719,1802424319,2627657471,1668889087,2359448319,3050269695,3470499071,2355966463,3181263359,3887747839,3888878847,2218539519,2907261695,3596708863,3885407487,2067887103],a.Category20b_18=[960199167,1381278719,1802424319,2627657471,1668889087,2359448319,3050269695,3470499071,2355966463,3181263359,3887747839,3888878847,2218539519,2907261695,3596708863,3885407487,2067887103,2773587199],a.Category20b_19=[960199167,1381278719,1802424319,2627657471,1668889087,2359448319,3050269695,3470499071,2355966463,3181263359,3887747839,3888878847,2218539519,2907261695,3596708863,3885407487,2067887103,2773587199,3463298559],a.Category20b_20=[960199167,1381278719,1802424319,2627657471,1668889087,2359448319,3050269695,3470499071,2355966463,3181263359,3887747839,3888878847,2218539519,2907261695,3596708863,3885407487,2067887103,2773587199,3463298559,3734951679],a.Category20c_3=[830651903,1806620415,2664096255],a.Category20c_4=[830651903,1806620415,2664096255,3336302591],a.Category20c_5=[830651903,1806620415,2664096255,3336302591,3864333823],a.Category20c_6=[830651903,1806620415,2664096255,3336302591,3864333823,4253891839],a.Category20c_7=[830651903,1806620415,2664096255,3336302591,3864333823,4253891839,4256066559],a.Category20c_8=[830651903,1806620415,2664096255,3336302591,3864333823,4253891839,4256066559,4258308863],a.Category20c_9=[830651903,1806620415,2664096255,3336302591,3864333823,4253891839,4256066559,4258308863,832787711],a.Category20c_10=[830651903,1806620415,2664096255,3336302591,3864333823,4253891839,4256066559,4258308863,832787711,1959032575],a.Category20c_11=[830651903,1806620415,2664096255,3336302591,3864333823,4253891839,4256066559,4258308863,832787711,1959032575,2715393023],a.Category20c_12=[830651903,1806620415,2664096255,3336302591,3864333823,4253891839,4256066559,4258308863,832787711,1959032575,2715393023,3353985279],a.Category20c_13=[830651903,1806620415,2664096255,3336302591,3864333823,4253891839,4256066559,4258308863,832787711,1959032575,2715393023,3353985279,1969992191],a.Category20c_14=[830651903,1806620415,2664096255,3336302591,3864333823,4253891839,4256066559,4258308863,832787711,1959032575,2715393023,3353985279,1969992191,2660944127],a.Category20c_15=[830651903,1806620415,2664096255,3336302591,3864333823,4253891839,4256066559,4258308863,832787711,1959032575,2715393023,3353985279,1969992191,2660944127,3166559487],a.Category20c_16=[830651903,1806620415,2664096255,3336302591,3864333823,4253891839,4256066559,4258308863,832787711,1959032575,2715393023,3353985279,1969992191,2660944127,3166559487,3671780351],a.Category20c_17=[830651903,1806620415,2664096255,3336302591,3864333823,4253891839,4256066559,4258308863,832787711,1959032575,2715393023,3353985279,1969992191,2660944127,3166559487,3671780351,1667458047],a.Category20c_18=[830651903,1806620415,2664096255,3336302591,3864333823,4253891839,4256066559,4258308863,832787711,1959032575,2715393023,3353985279,1969992191,2660944127,3166559487,3671780351,1667458047,2526451455],a.Category20c_19=[830651903,1806620415,2664096255,3336302591,3864333823,4253891839,4256066559,4258308863,832787711,1959032575,2715393023,3353985279,1969992191,2660944127,3166559487,3671780351,1667458047,2526451455,3183328767],a.Category20c_20=[830651903,1806620415,2664096255,3336302591,3864333823,4253891839,4256066559,4258308863,832787711,1959032575,2715393023,3353985279,1969992191,2660944127,3166559487,3671780351,1667458047,2526451455,3183328767,3654932991],a.Colorblind3=[7516927,3869180159,4041491199],a.Colorblind4=[7516927,3869180159,4041491199,10384383],a.Colorblind5=[7516927,3869180159,4041491199,10384383,1454696959],a.Colorblind6=[7516927,3869180159,4041491199,10384383,1454696959,3579707647],a.Colorblind7=[7516927,3869180159,4041491199,10384383,1454696959,3579707647,3430524927],a.Colorblind8=[7516927,3869180159,4041491199,10384383,1454696959,3579707647,3430524927,255],a.YlGn={YlGn3:a.YlGn3,YlGn4:a.YlGn4,YlGn5:a.YlGn5,YlGn6:a.YlGn6,YlGn7:a.YlGn7,YlGn8:a.YlGn8,YlGn9:a.YlGn9},a.YlGnBu={YlGnBu3:a.YlGnBu3,YlGnBu4:a.YlGnBu4,YlGnBu5:a.YlGnBu5,YlGnBu6:a.YlGnBu6,YlGnBu7:a.YlGnBu7,YlGnBu8:a.YlGnBu8,YlGnBu9:a.YlGnBu9},a.GnBu={GnBu3:a.GnBu3,GnBu4:a.GnBu4,GnBu5:a.GnBu5,GnBu6:a.GnBu6,GnBu7:a.GnBu7,GnBu8:a.GnBu8,GnBu9:a.GnBu9},a.BuGn={BuGn3:a.BuGn3,BuGn4:a.BuGn4,BuGn5:a.BuGn5,BuGn6:a.BuGn6,BuGn7:a.BuGn7,BuGn8:a.BuGn8,BuGn9:a.BuGn9},a.PuBuGn={PuBuGn3:a.PuBuGn3,PuBuGn4:a.PuBuGn4,PuBuGn5:a.PuBuGn5,PuBuGn6:a.PuBuGn6,PuBuGn7:a.PuBuGn7,PuBuGn8:a.PuBuGn8,PuBuGn9:a.PuBuGn9},a.PuBu={PuBu3:a.PuBu3,PuBu4:a.PuBu4,PuBu5:a.PuBu5,PuBu6:a.PuBu6,PuBu7:a.PuBu7,PuBu8:a.PuBu8,PuBu9:a.PuBu9},a.BuPu={BuPu3:a.BuPu3,BuPu4:a.BuPu4,BuPu5:a.BuPu5,BuPu6:a.BuPu6,BuPu7:a.BuPu7,BuPu8:a.BuPu8,BuPu9:a.BuPu9},a.RdPu={RdPu3:a.RdPu3,RdPu4:a.RdPu4,RdPu5:a.RdPu5,RdPu6:a.RdPu6,RdPu7:a.RdPu7,RdPu8:a.RdPu8,RdPu9:a.RdPu9},a.PuRd={PuRd3:a.PuRd3,PuRd4:a.PuRd4,PuRd5:a.PuRd5,PuRd6:a.PuRd6,PuRd7:a.PuRd7,PuRd8:a.PuRd8,PuRd9:a.PuRd9},a.OrRd={OrRd3:a.OrRd3,OrRd4:a.OrRd4,OrRd5:a.OrRd5,OrRd6:a.OrRd6,OrRd7:a.OrRd7,OrRd8:a.OrRd8,OrRd9:a.OrRd9},a.YlOrRd={YlOrRd3:a.YlOrRd3,YlOrRd4:a.YlOrRd4,YlOrRd5:a.YlOrRd5,YlOrRd6:a.YlOrRd6,YlOrRd7:a.YlOrRd7,YlOrRd8:a.YlOrRd8,YlOrRd9:a.YlOrRd9},a.YlOrBr={YlOrBr3:a.YlOrBr3,YlOrBr4:a.YlOrBr4,YlOrBr5:a.YlOrBr5,YlOrBr6:a.YlOrBr6,YlOrBr7:a.YlOrBr7,YlOrBr8:a.YlOrBr8,YlOrBr9:a.YlOrBr9},a.Purples={Purples3:a.Purples3,Purples4:a.Purples4,Purples5:a.Purples5,Purples6:a.Purples6,Purples7:a.Purples7,Purples8:a.Purples8,Purples9:a.Purples9},a.Blues={Blues3:a.Blues3,Blues4:a.Blues4,Blues5:a.Blues5,Blues6:a.Blues6,Blues7:a.Blues7,Blues8:a.Blues8,Blues9:a.Blues9},a.Greens={Greens3:a.Greens3,Greens4:a.Greens4,Greens5:a.Greens5,Greens6:a.Greens6,Greens7:a.Greens7,Greens8:a.Greens8,Greens9:a.Greens9},a.Oranges={Oranges3:a.Oranges3,Oranges4:a.Oranges4,Oranges5:a.Oranges5,Oranges6:a.Oranges6,Oranges7:a.Oranges7,Oranges8:a.Oranges8,Oranges9:a.Oranges9},a.Reds={Reds3:a.Reds3,Reds4:a.Reds4,Reds5:a.Reds5,Reds6:a.Reds6,Reds7:a.Reds7,Reds8:a.Reds8,Reds9:a.Reds9},a.Greys={Greys3:a.Greys3,Greys4:a.Greys4,Greys5:a.Greys5,Greys6:a.Greys6,Greys7:a.Greys7,Greys8:a.Greys8,Greys9:a.Greys9,Greys10:a.Greys10,Greys11:a.Greys11,Greys256:a.Greys256},a.PuOr={PuOr3:a.PuOr3,PuOr4:a.PuOr4,PuOr5:a.PuOr5,PuOr6:a.PuOr6,PuOr7:a.PuOr7,PuOr8:a.PuOr8,PuOr9:a.PuOr9,PuOr10:a.PuOr10,PuOr11:a.PuOr11},a.BrBG={BrBG3:a.BrBG3,BrBG4:a.BrBG4,BrBG5:a.BrBG5,BrBG6:a.BrBG6,BrBG7:a.BrBG7,BrBG8:a.BrBG8,BrBG9:a.BrBG9,BrBG10:a.BrBG10,BrBG11:a.BrBG11},a.PRGn={PRGn3:a.PRGn3,PRGn4:a.PRGn4,PRGn5:a.PRGn5,PRGn6:a.PRGn6,PRGn7:a.PRGn7,PRGn8:a.PRGn8,PRGn9:a.PRGn9,PRGn10:a.PRGn10,PRGn11:a.PRGn11},a.PiYG={PiYG3:a.PiYG3,PiYG4:a.PiYG4,PiYG5:a.PiYG5,PiYG6:a.PiYG6,PiYG7:a.PiYG7,PiYG8:a.PiYG8,PiYG9:a.PiYG9,PiYG10:a.PiYG10,PiYG11:a.PiYG11},a.RdBu={RdBu3:a.RdBu3,RdBu4:a.RdBu4,RdBu5:a.RdBu5,RdBu6:a.RdBu6,RdBu7:a.RdBu7,RdBu8:a.RdBu8,RdBu9:a.RdBu9,RdBu10:a.RdBu10,RdBu11:a.RdBu11},a.RdGy={RdGy3:a.RdGy3,RdGy4:a.RdGy4,RdGy5:a.RdGy5,RdGy6:a.RdGy6,RdGy7:a.RdGy7,RdGy8:a.RdGy8,RdGy9:a.RdGy9,RdGy10:a.RdGy10,RdGy11:a.RdGy11},a.RdYlBu={RdYlBu3:a.RdYlBu3,RdYlBu4:a.RdYlBu4,RdYlBu5:a.RdYlBu5,RdYlBu6:a.RdYlBu6,RdYlBu7:a.RdYlBu7,RdYlBu8:a.RdYlBu8,RdYlBu9:a.RdYlBu9,RdYlBu10:a.RdYlBu10,RdYlBu11:a.RdYlBu11},a.Spectral={Spectral3:a.Spectral3,Spectral4:a.Spectral4,Spectral5:a.Spectral5,Spectral6:a.Spectral6,Spectral7:a.Spectral7,Spectral8:a.Spectral8,Spectral9:a.Spectral9,Spectral10:a.Spectral10,Spectral11:a.Spectral11},a.RdYlGn={RdYlGn3:a.RdYlGn3,RdYlGn4:a.RdYlGn4,RdYlGn5:a.RdYlGn5,RdYlGn6:a.RdYlGn6,RdYlGn7:a.RdYlGn7,RdYlGn8:a.RdYlGn8,RdYlGn9:a.RdYlGn9,RdYlGn10:a.RdYlGn10,RdYlGn11:a.RdYlGn11},a.Inferno={Inferno3:a.Inferno3,Inferno4:a.Inferno4,Inferno5:a.Inferno5,Inferno6:a.Inferno6,Inferno7:a.Inferno7,Inferno8:a.Inferno8,Inferno9:a.Inferno9,Inferno10:a.Inferno10,Inferno11:a.Inferno11,Inferno256:a.Inferno256},a.Magma={Magma3:a.Magma3,Magma4:a.Magma4,Magma5:a.Magma5,Magma6:a.Magma6,Magma7:a.Magma7,Magma8:a.Magma8,Magma9:a.Magma9,Magma10:a.Magma10,Magma11:a.Magma11,Magma256:a.Magma256},a.Plasma={Plasma3:a.Plasma3,Plasma4:a.Plasma4,Plasma5:a.Plasma5,Plasma6:a.Plasma6,Plasma7:a.Plasma7,Plasma8:a.Plasma8,Plasma9:a.Plasma9,Plasma10:a.Plasma10,Plasma11:a.Plasma11,Plasma256:a.Plasma256},a.Viridis={Viridis3:a.Viridis3,Viridis4:a.Viridis4,Viridis5:a.Viridis5,Viridis6:a.Viridis6,Viridis7:a.Viridis7,Viridis8:a.Viridis8,Viridis9:a.Viridis9,Viridis10:a.Viridis10,Viridis11:a.Viridis11,Viridis256:a.Viridis256},a.Accent={Accent3:a.Accent3,Accent4:a.Accent4,Accent5:a.Accent5,Accent6:a.Accent6,Accent7:a.Accent7,Accent8:a.Accent8},a.Dark2={Dark2_3:a.Dark2_3,Dark2_4:a.Dark2_4,Dark2_5:a.Dark2_5,Dark2_6:a.Dark2_6,Dark2_7:a.Dark2_7,Dark2_8:a.Dark2_8},a.Paired={Paired3:a.Paired3,Paired4:a.Paired4,Paired5:a.Paired5,Paired6:a.Paired6,Paired7:a.Paired7,Paired8:a.Paired8,Paired9:a.Paired9,Paired10:a.Paired10,Paired11:a.Paired11,Paired12:a.Paired12},a.Pastel1={Pastel1_3:a.Pastel1_3,Pastel1_4:a.Pastel1_4,Pastel1_5:a.Pastel1_5,Pastel1_6:a.Pastel1_6,Pastel1_7:a.Pastel1_7,Pastel1_8:a.Pastel1_8,Pastel1_9:a.Pastel1_9},a.Pastel2={Pastel2_3:a.Pastel2_3,Pastel2_4:a.Pastel2_4,Pastel2_5:a.Pastel2_5,Pastel2_6:a.Pastel2_6,Pastel2_7:a.Pastel2_7,Pastel2_8:a.Pastel2_8},a.Set1={Set1_3:a.Set1_3,Set1_4:a.Set1_4,Set1_5:a.Set1_5,Set1_6:a.Set1_6,Set1_7:a.Set1_7,Set1_8:a.Set1_8,Set1_9:a.Set1_9},a.Set2={Set2_3:a.Set2_3,Set2_4:a.Set2_4,Set2_5:a.Set2_5,Set2_6:a.Set2_6,Set2_7:a.Set2_7,Set2_8:a.Set2_8},a.Set3={Set3_3:a.Set3_3,Set3_4:a.Set3_4,Set3_5:a.Set3_5,Set3_6:a.Set3_6,Set3_7:a.Set3_7,Set3_8:a.Set3_8,Set3_9:a.Set3_9,Set3_10:a.Set3_10,Set3_11:a.Set3_11,Set3_12:a.Set3_12},a.Category10={Category10_3:a.Category10_3,Category10_4:a.Category10_4,Category10_5:a.Category10_5,Category10_6:a.Category10_6,Category10_7:a.Category10_7,Category10_8:a.Category10_8,Category10_9:a.Category10_9,Category10_10:a.Category10_10},a.Category20={Category20_3:a.Category20_3,Category20_4:a.Category20_4,Category20_5:a.Category20_5,Category20_6:a.Category20_6,Category20_7:a.Category20_7,Category20_8:a.Category20_8,Category20_9:a.Category20_9,Category20_10:a.Category20_10,Category20_11:a.Category20_11,Category20_12:a.Category20_12,Category20_13:a.Category20_13,Category20_14:a.Category20_14,Category20_15:a.Category20_15,Category20_16:a.Category20_16,Category20_17:a.Category20_17,Category20_18:a.Category20_18,Category20_19:a.Category20_19,Category20_20:a.Category20_20},a.Category20b={Category20b_3:a.Category20b_3,Category20b_4:a.Category20b_4,Category20b_5:a.Category20b_5,Category20b_6:a.Category20b_6,Category20b_7:a.Category20b_7,Category20b_8:a.Category20b_8,Category20b_9:a.Category20b_9,Category20b_10:a.Category20b_10,Category20b_11:a.Category20b_11,Category20b_12:a.Category20b_12,Category20b_13:a.Category20b_13,Category20b_14:a.Category20b_14,Category20b_15:a.Category20b_15,Category20b_16:a.Category20b_16,Category20b_17:a.Category20b_17,Category20b_18:a.Category20b_18,Category20b_19:a.Category20b_19,Category20b_20:a.Category20b_20},a.Category20c={Category20c_3:a.Category20c_3,Category20c_4:a.Category20c_4,Category20c_5:a.Category20c_5,Category20c_6:a.Category20c_6,Category20c_7:a.Category20c_7,Category20c_8:a.Category20c_8,Category20c_9:a.Category20c_9,Category20c_10:a.Category20c_10,Category20c_11:a.Category20c_11,Category20c_12:a.Category20c_12,Category20c_13:a.Category20c_13,Category20c_14:a.Category20c_14,Category20c_15:a.Category20c_15,Category20c_16:a.Category20c_16,Category20c_17:a.Category20c_17,Category20c_18:a.Category20c_18,Category20c_19:a.Category20c_19,Category20c_20:a.Category20c_20},a.Colorblind={Colorblind3:a.Colorblind3,Colorblind4:a.Colorblind4,Colorblind5:a.Colorblind5,Colorblind6:a.Colorblind6,Colorblind7:a.Colorblind7,Colorblind8:a.Colorblind8},a.linear_palette=l,a.magma=function(r){return l(a.Magma256,r)},a.inferno=function(r){return l(a.Inferno256,r)},a.plasma=function(r){return l(a.Plasma256,r)},a.viridis=function(r){return l(a.Viridis256,r)},a.cividis=function(r){return l(a.Cividis256,r)},a.turbo=function(r){return l(a.Turbo256,r)},a.grey=function(r){return l(a.Greys256,r)}},
543: function _(t,_,n,o,r){o(),(0,t(1).__exportStar)(t(153),n)},
544: function _(e,t,r,n,o){n();var a=e(1),i=e(120),l=(0,a.__importStar)(e(119)),s=e(133),_=e(141),u=e(124),c=e(128),p=e(123),h=e(158),f=e(346),y=(0,a.__importStar)(e(144)),g=e(543),d=e(379),v=e(326),x=e(327);o("gridplot",e(545).gridplot),o("color",e(137).color2css);var m=Object.prototype.hasOwnProperty,w=["pan","wheel_zoom","box_zoom","save","reset","help"];function b(e,t){return void 0===e?t:e}var A=function(e){function t(r){void 0===r&&(r={});var n=this,o=b((r=(0,a.__assign)({},r)).tools,w);delete r.tools;var i=b(r.x_axis_type,"auto"),l=b(r.y_axis_type,"auto");delete r.x_axis_type,delete r.y_axis_type;var s=null!=r.x_minor_ticks?r.x_minor_ticks:"auto",_=null!=r.y_minor_ticks?r.y_minor_ticks:"auto";delete r.x_minor_ticks,delete r.y_minor_ticks;var u=null!=r.x_axis_location?r.x_axis_location:"below",c=null!=r.y_axis_location?r.y_axis_location:"left";delete r.x_axis_location,delete r.y_axis_location;var p=null!=r.x_axis_label?r.x_axis_label:"",h=null!=r.y_axis_label?r.y_axis_label:"";delete r.x_axis_label,delete r.y_axis_label;var f=t._get_range(r.x_range),y=t._get_range(r.y_range);delete r.x_range,delete r.y_range;var g=null!=r.x_scale?r.x_scale:t._get_scale(f,i),d=null!=r.y_scale?r.y_scale:t._get_scale(y,l);return delete r.x_scale,delete r.y_scale,(n=e.call(this,(0,a.__assign)((0,a.__assign)({},r),{x_range:f,y_range:y,x_scale:g,y_scale:d}))||this)._process_axis_and_grid(i,u,s,p,f,0),n._process_axis_and_grid(l,c,_,h,y,1),n.add_tools.apply(n,(0,a.__spreadArray)([],(0,a.__read)(n._process_tools(o)),!1)),n}return(0,a.__extends)(t,e),Object.defineProperty(t.prototype,"xgrid",{get:function(){return this.center.filter((function(e){return e instanceof g.Grid&&0==e.dimension}))},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"ygrid",{get:function(){return this.center.filter((function(e){return e instanceof g.Grid&&1==e.dimension}))},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"xaxis",{get:function(){return(0,a.__spreadArray)((0,a.__spreadArray)([],(0,a.__read)(this.below),!1),(0,a.__read)(this.above),!1).filter((function(e){return e instanceof g.Axis}))},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"yaxis",{get:function(){return(0,a.__spreadArray)((0,a.__spreadArray)([],(0,a.__read)(this.left),!1),(0,a.__read)(this.right),!1).filter((function(e){return e instanceof g.Axis}))},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"grid",{get:function(){return this.center.filter((function(e){return e instanceof g.Grid}))},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"axis",{get:function(){return(0,a.__spreadArray)((0,a.__spreadArray)((0,a.__spreadArray)((0,a.__spreadArray)([],(0,a.__read)(this.below),!1),(0,a.__read)(this.above),!1),(0,a.__read)(this.left),!1),(0,a.__read)(this.right),!1).filter((function(e){return e instanceof g.Axis}))},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"legend",{get:function(){var e=this.panels.filter((function(e){return e instanceof v.Legend}));if(0==e.length){var t=new v.Legend;return this.add_layout(t),t}return t=(0,a.__read)(e,1)[0]},enumerable:!1,configurable:!0}),t.prototype.annular_wedge=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._glyph(d.AnnularWedge,"x,y,inner_radius,outer_radius,start_angle,end_angle",e)},t.prototype.annulus=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._glyph(d.Annulus,"x,y,inner_radius,outer_radius",e)},t.prototype.arc=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._glyph(d.Arc,"x,y,radius,start_angle,end_angle",e)},t.prototype.bezier=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._glyph(d.Bezier,"x0,y0,x1,y1,cx0,cy0,cx1,cy1",e)},t.prototype.circle=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._glyph(d.Circle,"x,y",e)},t.prototype.ellipse=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._glyph(d.Ellipse,"x,y,width,height",e)},t.prototype.harea=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._glyph(d.HArea,"x1,x2,y",e)},t.prototype.hbar=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._glyph(d.HBar,"y,height,right,left",e)},t.prototype.hex_tile=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._glyph(d.HexTile,"q,r",e)},t.prototype.image=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._glyph(d.Image,"color_mapper,image,rows,cols,x,y,dw,dh",e)},t.prototype.image_rgba=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._glyph(d.ImageRGBA,"image,rows,cols,x,y,dw,dh",e)},t.prototype.image_url=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._glyph(d.ImageURL,"url,x,y,w,h",e)},t.prototype.line=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._glyph(d.Line,"x,y",e)},t.prototype.multi_line=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._glyph(d.MultiLine,"xs,ys",e)},t.prototype.multi_polygons=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._glyph(d.MultiPolygons,"xs,ys",e)},t.prototype.oval=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._glyph(d.Oval,"x,y,width,height",e)},t.prototype.patch=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._glyph(d.Patch,"x,y",e)},t.prototype.patches=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._glyph(d.Patches,"xs,ys",e)},t.prototype.quad=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._glyph(d.Quad,"left,right,bottom,top",e)},t.prototype.quadratic=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._glyph(d.Quadratic,"x0,y0,x1,y1,cx,cy",e)},t.prototype.ray=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._glyph(d.Ray,"x,y,length",e)},t.prototype.rect=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._glyph(d.Rect,"x,y,width,height",e)},t.prototype.segment=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._glyph(d.Segment,"x0,y0,x1,y1",e)},t.prototype.spline=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._glyph(d.Spline,"x,y",e)},t.prototype.step=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._glyph(d.Step,"x,y,mode",e)},t.prototype.text=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._glyph(d.Text,"x,y,text",e)},t.prototype.varea=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._glyph(d.VArea,"x,y1,y2",e)},t.prototype.vbar=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._glyph(d.VBar,"x,width,top,bottom",e)},t.prototype.wedge=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._glyph(d.Wedge,"x,y,radius,start_angle,end_angle",e)},t.prototype._scatter=function(e,t){return this._glyph(d.Scatter,"x,y",e,null!=t?{marker:t}:void 0)},t.prototype.scatter=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._scatter(e)},t.prototype.asterisk=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._scatter(e,"asterisk")},t.prototype.circle_cross=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._scatter(e,"circle_cross")},t.prototype.circle_dot=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._scatter(e,"circle_dot")},t.prototype.circle_x=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._scatter(e,"circle_x")},t.prototype.circle_y=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._scatter(e,"circle_y")},t.prototype.cross=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._scatter(e,"cross")},t.prototype.dash=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._scatter(e,"dash")},t.prototype.diamond=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._scatter(e,"diamond")},t.prototype.diamond_cross=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._scatter(e,"diamond_cross")},t.prototype.diamond_dot=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._scatter(e,"diamond_dot")},t.prototype.dot=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._scatter(e,"dot")},t.prototype.hex=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._scatter(e,"hex")},t.prototype.hex_dot=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._scatter(e,"hex_dot")},t.prototype.inverted_triangle=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._scatter(e,"inverted_triangle")},t.prototype.plus=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._scatter(e,"plus")},t.prototype.square=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._scatter(e,"square")},t.prototype.square_cross=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._scatter(e,"square_cross")},t.prototype.square_dot=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._scatter(e,"square_dot")},t.prototype.square_pin=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._scatter(e,"square_pin")},t.prototype.square_x=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._scatter(e,"square_x")},t.prototype.star=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._scatter(e,"star")},t.prototype.star_dot=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._scatter(e,"star_dot")},t.prototype.triangle=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._scatter(e,"triangle")},t.prototype.triangle_dot=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._scatter(e,"triangle_dot")},t.prototype.triangle_pin=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._scatter(e,"triangle_pin")},t.prototype.x=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._scatter(e,"x")},t.prototype.y=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return this._scatter(e,"y")},t.prototype._pop_visuals=function(e,t,r,n,o){var i,l,s,_;void 0===r&&(r=""),void 0===n&&(n={}),void 0===o&&(o={});var p=function(e){var t=e.split("_",2);return 2==t.length?t:t.concat([""])},h=function(e){var t=(0,a.__read)(p(e),2),r=t[0],n=t[1];return(0,u.includes)(["line","fill","hatch","text","global"],r)&&""!==n};n=(0,a.__assign)({},n),m.call(n,"text_color")||(n.text_color="black"),m.call(n,"hatch_color")||(n.hatch_color="black");var f={};m.call(f,"color")||(f.color="#1f77b4"),m.call(f,"alpha")||(f.alpha=1);var y={},g=new Set;try{for(var d=(0,a.__values)((0,c.keys)(e.prototype._props)),v=d.next();!v.done;v=d.next()){var x=v.value;if(h(x)){var w=p(x)[1];m.call(t,r+x)?(y[x]=t[r+x],delete t[r+x]):!m.call(e.prototype._props,w)&&m.call(t,r+w)?y[x]=t[r+w]:m.call(o,w)?y[x]=o[w]:m.call(n,x)?y[x]=n[x]:m.call(f,w)&&(y[x]=f[w]),m.call(e.prototype._props,w)||g.add(w)}}}catch(e){i={error:e}}finally{try{v&&!v.done&&(l=d.return)&&l.call(d)}finally{if(i)throw i.error}}try{for(var b=(0,a.__values)(g),A=b.next();!A.done;A=b.next()){delete t[r+A.value]}}catch(e){s={error:e}}finally{try{A&&!A.done&&(_=b.return)&&_.call(b)}finally{if(s)throw s.error}}return y},t.prototype._find_uniq_name=function(e,t){for(var r=1;;){var n=t+"__"+r;if(null==e[n])return n;r+=1}},t.prototype._fixup_values=function(e,t,r){var n,o;try{for(var i=(0,a.__values)((0,c.entries)(r)),l=i.next();!l.done;l=i.next()){var _=(0,a.__read)(l.value,2),u=_[0],h=_[1],f=e.prototype._props[u];if(null!=f&&f.type.prototype instanceof s.VectorSpec&&null!=h)if((0,p.isArray)(h)||y.is_NDArray(h)){var g=void 0;null!=t[u]?t[u]!==h?t[g=this._find_uniq_name(t,u)]=h:g=u:t[g=u]=h,r[u]={field:g}}else((0,p.isNumber)(h)||(0,p.isString)(h))&&(r[u]={value:h})}}catch(e){n={error:e}}finally{try{l&&!l.done&&(o=i.return)&&o.call(i)}finally{if(n)throw n.error}}},t.prototype._glyph=function(e,t,r,n){var o,i,l,s=t.split(",");if(0==r.length)l={};else if(1==r.length)l=(0,a.__assign)({},r[0]);else{l=r.length==s.length?{}:(0,a.__assign)({},r[r.length-1]);try{for(var _=(0,a.__values)((0,f.enumerate)(s)),u=_.next();!u.done;u=_.next()){var p=(0,a.__read)(u.value,2),h=p[0],y=p[1];l[h]=r[y]}}catch(e){o={error:e}}finally{try{u&&!u.done&&(i=_.return)&&i.call(_)}finally{if(o)throw o.error}}}null!=n&&(l=(0,a.__assign)((0,a.__assign)({},l),n));var d=function(){var e=l.source;return null==e?new g.ColumnDataSource:e instanceof g.ColumnarDataSource?e:new g.ColumnDataSource({data:e})}(),v=(0,c.clone)(d.data);delete l.source;var x=null!=l.view?l.view:new g.CDSView({source:d});delete l.view;var m=this._process_legend(l.legend,d);delete l.legend;var w=l.name;delete l.name;var b=l.level;delete l.level;var A=l.visible;delete l.visible;var k=l.x_range_name;delete l.x_range_name;var S=l.y_range_name;delete l.y_range_name;var L=this._pop_visuals(e,l),q=this._pop_visuals(e,l,"nonselection_",L,{alpha:.1}),P=this._pop_visuals(e,l,"selection_",L),R=this._pop_visuals(e,l,"hover_",L),E=this._pop_visuals(e,l,"muted_",L,{alpha:.2});this._fixup_values(e,v,L),this._fixup_values(e,v,q),this._fixup_values(e,v,P),this._fixup_values(e,v,R),this._fixup_values(e,v,E),this._fixup_values(e,v,l),d.data=v;var O=function(e,t,r){return new e((0,a.__assign)((0,a.__assign)({},t),r))},D=O(e,l,L),j=(0,c.is_empty)(q)?"auto":O(e,l,q),C=(0,c.is_empty)(P)?"auto":O(e,l,P),T=(0,c.is_empty)(R)?void 0:O(e,l,R),G=(0,c.is_empty)(E)?"auto":O(e,l,E),H=new g.GlyphRenderer({data_source:d,view:x,glyph:D,nonselection_glyph:j,selection_glyph:C,hover_glyph:T,muted_glyph:G,name:w,level:b,visible:A,x_range_name:k,y_range_name:S});return null!=m&&this._update_legend(m,H),this.add_renderers(H),H},t._get_range=function(e){if(null==e)return new g.DataRange1d;if(e instanceof g.Range)return e;if((0,p.isArray)(e)){if((0,p.isArrayOf)(e,p.isString)){var t=e;return new g.FactorRange({factors:t})}var r=(0,a.__read)(e,2),n=r[0],o=r[1];return new g.Range1d({start:n,end:o})}throw new Error("unable to determine proper range for: '"+e+"'")},t._get_scale=function(e,t){if(e instanceof g.DataRange1d||e instanceof g.Range1d)switch(t){case null:case"auto":case"linear":case"datetime":case"mercator":return new g.LinearScale;case"log":return new g.LogScale}if(e instanceof g.FactorRange)return new g.CategoricalScale;throw new Error("unable to determine proper scale for: '"+e+"'")},t.prototype._process_axis_and_grid=function(e,t,r,n,o,a){var i=this._get_axis(e,o,a);if(null!=i){i instanceof g.LogAxis&&(0==a?this.x_scale=new g.LogScale:this.y_scale=new g.LogScale),i.ticker instanceof g.ContinuousTicker&&(i.ticker.num_minor_ticks=this._get_num_minor_ticks(i,r)),i.axis_label=n;var l=new g.Grid({dimension:a,ticker:i.ticker});null!==t&&this.add_layout(i,t),this.add_layout(l)}},t.prototype._get_axis=function(e,t,r){switch(e){case null:return null;case"linear":return new g.LinearAxis;case"log":return new g.LogAxis;case"datetime":return new g.DatetimeAxis;case"mercator":var n=new g.MercatorAxis,o=0==r?"lon":"lat";return n.ticker.dimension=o,n.formatter.dimension=o,n;case"auto":return t instanceof g.FactorRange?new g.CategoricalAxis:new g.LinearAxis;default:throw new Error("shouldn't have happened")}},t.prototype._get_num_minor_ticks=function(e,t){if((0,p.isNumber)(t)){if(t<=1)throw new Error("num_minor_ticks must be > 1");return t}if(null==t)return 0;if("auto"===t)return e instanceof g.LogAxis?10:5;throw new Error("shouldn't have happened")},t.prototype._process_tools=function(e){return(0,p.isString)(e)&&(e=e.split(/\s*,\s*/).filter((function(e){return e.length>0}))),e.map((function(e){return(0,p.isString)(e)?g.Tool.from_string(e):e}))},t.prototype._process_legend=function(e,t){var r=null;return null!=e&&((0,p.isString)(e)?(r={value:e},null!=t.columns()&&(0,u.includes)(t.columns(),e)&&(r={field:e})):r=e),r},t.prototype._update_legend=function(e,t){var r,n,o=this.legend,i=!1;try{for(var l=(0,a.__values)(o.items),s=l.next();!s.done;s=l.next()){var u=s.value;if(null!=u.label&&(0,_.is_equal)(u.label,e)){var c=u.label;if("value"in c){u.renderers.push(t),i=!0;break}if("field"in c&&t.data_source==u.renderers[0].data_source){u.renderers.push(t),i=!0;break}}}}catch(e){r={error:e}}finally{try{s&&!s.done&&(n=l.return)&&n.call(l)}finally{if(r)throw r.error}}if(!i){var p=new x.LegendItem({label:e,renderers:[t]});o.items.push(p)}},t}(g.Plot);r.Figure=A,A.__name__="Plot",r.figure=function(e){return new A(e)},r.show=function(e,t){return(0,a.__awaiter)(this,void 0,void 0,(function(){var r,n,o,s,_,u,c,f,y;return(0,a.__generator)(this,(function(g){switch(g.label){case 0:r=new i.Document;try{for(n=(0,a.__values)((0,p.isArray)(e)?e:[e]),o=n.next();!o.done;o=n.next())s=o.value,r.add_root(s)}catch(e){f={error:e}}finally{try{o&&!o.done&&(y=n.return)&&y.call(n)}finally{if(f)throw f.error}}return[4,(0,h.dom_ready)()];case 1:if(g.sent(),null==t)_=document.body;else if((0,p.isString)(t)){if(!(null!=(u=document.querySelector(t))&&u instanceof HTMLElement))throw new Error("'"+t+"' selector didn't match any elements");_=u}else if(t instanceof HTMLElement)_=t;else{if(!("undefined"!=typeof $&&t instanceof $))throw new Error("target should be HTMLElement, string selector, $ or null");_=t[0]}return[4,l.add_document_standalone(r,_)];case 2:return c=g.sent(),[2,new Promise((function(t,n){var o=(0,p.isArray)(e)?c:c[0];r.is_idle?t(o):r.idle.connect((function(){return t(o)}))}))]}}))}))}},
545: function _(r,o,e,l,n){l();var t=r(1),i=r(543),a=r(546),h=r(126);function u(r,o){return void 0===r?o:r}e.gridplot=function(r,o){var e,l,n,d;void 0===o&&(o={});var _=u(o.toolbar_location,"above"),c=u(o.merge_tools,!0),s=u(o.sizing_mode,null),w=a.Matrix.from(r),v=[],f=[];try{for(var g=(0,t.__values)(w),b=g.next();!b.done;b=g.next()){var p=(0,t.__read)(b.value,3),y=p[0],m=p[1],x=p[2];null!=y&&(y instanceof i.Plot&&(c&&(f.push(y.toolbar),y.toolbar_location=null),null!=o.plot_width&&(y.width=o.plot_width),null!=o.plot_height&&(y.height=o.plot_height)),null!=o.width&&(y.width=o.width),null!=o.height&&(y.height=o.height),v.push([y,m,x]))}}catch(r){e={error:r}}finally{try{b&&!b.done&&(l=g.return)&&l.call(g)}finally{if(e)throw e.error}}var z=new i.GridBox({children:v,sizing_mode:s});if(!c||null==_)return z;var B=[];try{for(var C=(0,t.__values)(f),P=C.next();!P.done;P=C.next()){var R=P.value;B.push.apply(B,(0,t.__spreadArray)([],(0,t.__read)(R.tools),!1))}}catch(r){n={error:r}}finally{try{P&&!P.done&&(d=C.return)&&d.call(C)}finally{if(n)throw n.error}}var T=new i.ToolbarBox({toolbar:new i.ProxyToolbar({toolbars:f,tools:B}),toolbar_location:_});switch(_){case"above":return new i.Column({children:[T,z],sizing_mode:s});case"below":return new i.Column({children:[z,T],sizing_mode:s});case"left":return new i.Row({children:[T,z],sizing_mode:s});case"right":return new i.Row({children:[z,T],sizing_mode:s});default:(0,h.unreachable)()}}},
546: function _(r,t,n,e,a){e();var o=r(1),s=r(124),i=function(){function r(r,t,n){this.nrows=r,this.ncols=t,this._matrix=new Array(r);for(var e=0;e<r;e++){this._matrix[e]=new Array(t);for(var a=0;a<t;a++)this._matrix[e][a]=n(e,a)}}return r.prototype.at=function(r,t){return this._matrix[r][t]},r.prototype[Symbol.iterator]=function(){var r,t;return(0,o.__generator)(this,(function(n){switch(n.label){case 0:r=0,n.label=1;case 1:if(!(r<this.nrows))return[3,6];t=0,n.label=2;case 2:return t<this.ncols?[4,[this._matrix[r][t],r,t]]:[3,5];case 3:n.sent(),n.label=4;case 4:return t++,[3,2];case 5:return r++,[3,1];case 6:return[2]}}))},r.prototype.values=function(){var r,t,n,e,a,s;return(0,o.__generator)(this,(function(i){switch(i.label){case 0:i.trys.push([0,5,6,7]),r=(0,o.__values)(this),t=r.next(),i.label=1;case 1:return t.done?[3,4]:(n=(0,o.__read)(t.value,1),[4,n[0]]);case 2:i.sent(),i.label=3;case 3:return t=r.next(),[3,1];case 4:return[3,7];case 5:return e=i.sent(),a={error:e},[3,7];case 6:try{t&&!t.done&&(s=r.return)&&s.call(r)}finally{if(a)throw a.error}return[7];case 7:return[2]}}))},r.prototype.map=function(t){var n=this;return new r(this.nrows,this.ncols,(function(r,e){return t(n.at(r,e),r,e)}))},r.prototype.apply=function(t){var n=this,e=r.from(t),a=this.nrows,o=this.ncols;if(a==e.nrows&&o==e.ncols)return new r(a,o,(function(r,t){return e.at(r,t)(n.at(r,t),r,t)}));throw new Error("dimensions don't match")},r.prototype.to_sparse=function(){return(0,o.__spreadArray)([],(0,o.__read)(this),!1)},r.from=function(t,n){if(t instanceof r)return t;if(null!=n){var e=t;return new r(Math.floor(e.length/n),n,(function(r,t){return e[r*n+t]}))}var a=t;return new r(t.length,(0,s.min)(a.map((function(r){return r.length}))),(function(r,t){return a[r][t]}))},r}();n.Matrix=i,i.__name__="Matrix"},
}, 538, {"api/main":538,"api/index":539,"api/linalg":540,"api/charts":541,"api/palettes":542,"api/models":543,"api/plotting":544,"api/gridplot":545,"core/util/matrix":546}, {});});
