SEANLAB Algorithms4
Pythonic Data Structures and Algorithms
=========================================
Minimal and clean example implementations of data structures and algorithms in Python 3.

## Contributing
Thanks for your interest in contributing! There are many ways to contribute to this project. [Get started here](CONTRIBUTING.md)

## Tests

### Use unittest
For running all tests write down:

    $ python3 -m unittest discover tests

For running some specific tests you can do this as following (Ex: sort):

    $ python3 -m unittest tests.test_sort

### Use pytest
For running all tests write down:

    $ python3 -m pytest tests

## Install
If you want to use the API algorithms in your code, it is as simple as:

    $ pip3 install seanalgorithms4

You can test by creating a python file: (Ex: use `merge_sort` in `sort`)

```python3
from seanalgorithms4.sort import merge_sort

if __name__ == "__main__":
    my_list = [1, 8, 3, 5, 6]
    my_list = merge_sort(my_list)
    print(my_list)
```

## Uninstall
If you want to uninstall seanalgorithms4, it is as simple as:

    $ pip3 uninstall -y seanalgorithms4


## Arithmetic Analysis
  * [bisection](https://github.com/TheAlgorithms/Python/blob/master/arithmetic_analysis/bisection.py)
  * [in static equilibrium](https://github.com/TheAlgorithms/Python/blob/master/arithmetic_analysis/in_static_equilibrium.py)
  * [intersection](https://github.com/TheAlgorithms/Python/blob/master/arithmetic_analysis/intersection.py)
  * [lu decomposition](https://github.com/TheAlgorithms/Python/blob/master/arithmetic_analysis/lu_decomposition.py)
  * [newton method](https://github.com/TheAlgorithms/Python/blob/master/arithmetic_analysis/newton_method.py)
  * [newton raphson method](https://github.com/TheAlgorithms/Python/blob/master/arithmetic_analysis/newton_raphson_method.py)
## Backtracking
  * [all combinations](https://github.com/TheAlgorithms/Python/blob/master/backtracking/all_combinations.py)
  * [all permutations](https://github.com/TheAlgorithms/Python/blob/master/backtracking/all_permutations.py)
  * [all subsequences](https://github.com/TheAlgorithms/Python/blob/master/backtracking/all_subsequences.py)
  * [minimax](https://github.com/TheAlgorithms/Python/blob/master/backtracking/minimax.py)
  * [n queens](https://github.com/TheAlgorithms/Python/blob/master/backtracking/n_queens.py)
  * [sudoku](https://github.com/TheAlgorithms/Python/blob/master/backtracking/sudoku.py)
  * [sum of subsets](https://github.com/TheAlgorithms/Python/blob/master/backtracking/sum_of_subsets.py)
## Boolean Algebra
  * [quine mc cluskey](https://github.com/TheAlgorithms/Python/blob/master/boolean_algebra/quine_mc_cluskey.py)
## Ciphers
  * [affine cipher](https://github.com/TheAlgorithms/Python/blob/master/ciphers/affine_cipher.py)
  * [atbash](https://github.com/TheAlgorithms/Python/blob/master/ciphers/atbash.py)
  * [base16](https://github.com/TheAlgorithms/Python/blob/master/ciphers/base16.py)
  * [base32](https://github.com/TheAlgorithms/Python/blob/master/ciphers/base32.py)
  * [base64 cipher](https://github.com/TheAlgorithms/Python/blob/master/ciphers/base64_cipher.py)
  * [base85](https://github.com/TheAlgorithms/Python/blob/master/ciphers/base85.py)
  * [brute force caesar cipher](https://github.com/TheAlgorithms/Python/blob/master/ciphers/brute_force_caesar_cipher.py)
  * [caesar cipher](https://github.com/TheAlgorithms/Python/blob/master/ciphers/caesar_cipher.py)
  * [cryptomath module](https://github.com/TheAlgorithms/Python/blob/master/ciphers/cryptomath_module.py)
  * [elgamal key generator](https://github.com/TheAlgorithms/Python/blob/master/ciphers/elgamal_key_generator.py)
  * [hill cipher](https://github.com/TheAlgorithms/Python/blob/master/ciphers/hill_cipher.py)
  * [morse code implementation](https://github.com/TheAlgorithms/Python/blob/master/ciphers/morse_code_implementation.py)
  * [onepad cipher](https://github.com/TheAlgorithms/Python/blob/master/ciphers/onepad_cipher.py)
  * [playfair cipher](https://github.com/TheAlgorithms/Python/blob/master/ciphers/playfair_cipher.py)
  * [rabin miller](https://github.com/TheAlgorithms/Python/blob/master/ciphers/rabin_miller.py)
  * [rot13](https://github.com/TheAlgorithms/Python/blob/master/ciphers/rot13.py)
  * [rsa cipher](https://github.com/TheAlgorithms/Python/blob/master/ciphers/rsa_cipher.py)
  * [rsa key generator](https://github.com/TheAlgorithms/Python/blob/master/ciphers/rsa_key_generator.py)
  * [simple substitution cipher](https://github.com/TheAlgorithms/Python/blob/master/ciphers/simple_substitution_cipher.py)
  * [trafid cipher](https://github.com/TheAlgorithms/Python/blob/master/ciphers/trafid_cipher.py)
  * [transposition cipher](https://github.com/TheAlgorithms/Python/blob/master/ciphers/transposition_cipher.py)
  * [transposition cipher encrypt decrypt file](https://github.com/TheAlgorithms/Python/blob/master/ciphers/transposition_cipher_encrypt_decrypt_file.py)
  * [vigenere cipher](https://github.com/TheAlgorithms/Python/blob/master/ciphers/vigenere_cipher.py)
  * [xor cipher](https://github.com/TheAlgorithms/Python/blob/master/ciphers/xor_cipher.py)
## Compression
  * [burrows wheeler](https://github.com/TheAlgorithms/Python/blob/master/compression/burrows_wheeler.py)
  * [huffman](https://github.com/TheAlgorithms/Python/blob/master/compression/huffman.py)
  * [peak signal to noise ratio](https://github.com/TheAlgorithms/Python/blob/master/compression/peak_signal_to_noise_ratio.py)
## Conversions
  * [decimal to binary](https://github.com/TheAlgorithms/Python/blob/master/conversions/decimal_to_binary.py)
  * [decimal to hexadecimal](https://github.com/TheAlgorithms/Python/blob/master/conversions/decimal_to_hexadecimal.py)
  * [decimal to octal](https://github.com/TheAlgorithms/Python/blob/master/conversions/decimal_to_octal.py)
## Data Structures
  * Binary Tree
    * [avl tree](https://github.com/TheAlgorithms/Python/blob/master/data_structures/avl_tree.py)
    * [basic binary tree](https://github.com/TheAlgorithms/Python/blob/master/data_structures/basic_binary_tree.py)
    * [binary search tree](https://github.com/TheAlgorithms/Python/blob/master/data_structures/binary_search_tree.py)
    * [fenwick tree](https://github.com/TheAlgorithms/Python/blob/master/data_structures/fenwick_tree.py)
    * [lazy segment tree](https://github.com/TheAlgorithms/Python/blob/master/data_structures/lazy_segment_tree.py)
    * [lca](https://github.com/TheAlgorithms/Python/blob/master/data_structures/lca.py)
    * [red black tree](https://github.com/TheAlgorithms/Python/blob/master/data_structures/red_black_tree.py)
    * [segment tree](https://github.com/TheAlgorithms/Python/blob/master/data_structures/segment_tree.py)
    * [treap](https://github.com/TheAlgorithms/Python/blob/master/data_structures/treap.py)
  * Hashing
    * [double hash](https://github.com/TheAlgorithms/Python/blob/master/data_structures/double_hash.py)
    * [hash table](https://github.com/TheAlgorithms/Python/blob/master/data_structures/hash_table.py)
    * [hash table with linked list](https://github.com/TheAlgorithms/Python/blob/master/data_structures/hash_table_with_linked_list.py)
  * Number Theory
    * [prime numbers](https://github.com/TheAlgorithms/Python/blob/master/data_structures/prime_numbers.py)
    * [quadratic probing](https://github.com/TheAlgorithms/Python/blob/master/data_structures/quadratic_probing.py)
  * Heap
    * [heap](https://github.com/TheAlgorithms/Python/blob/master/data_structures/heap.py)
  * Linked List
    * [doubly linked list](https://github.com/TheAlgorithms/Python/blob/master/data_structures/doubly_linked_list.py)
    * [is palindrome](https://github.com/TheAlgorithms/Python/blob/master/data_structures/is_palindrome.py)
    * [singly linked list](https://github.com/TheAlgorithms/Python/blob/master/data_structures/singly_linked_list.py)
    * [swap nodes](https://github.com/TheAlgorithms/Python/blob/master/data_structures/swap_nodes.py)
  * Queue
    * [double ended queue](https://github.com/TheAlgorithms/Python/blob/master/data_structures/double_ended_queue.py)
    * [queue on list](https://github.com/TheAlgorithms/Python/blob/master/data_structures/queue_on_list.py)
    * [queue on pseudo stack](https://github.com/TheAlgorithms/Python/blob/master/data_structures/queue_on_pseudo_stack.py)
  * Stacks
    * [balanced parentheses](https://github.com/TheAlgorithms/Python/blob/master/data_structures/balanced_parentheses.py)
    * [infix to postfix conversion](https://github.com/TheAlgorithms/Python/blob/master/data_structures/infix_to_postfix_conversion.py)
    * [infix to prefix conversion](https://github.com/TheAlgorithms/Python/blob/master/data_structures/infix_to_prefix_conversion.py)
    * [next greater element](https://github.com/TheAlgorithms/Python/blob/master/data_structures/next_greater_element.py)
    * [postfix evaluation](https://github.com/TheAlgorithms/Python/blob/master/data_structures/postfix_evaluation.py)
    * [stack](https://github.com/TheAlgorithms/Python/blob/master/data_structures/stack.py)
    * [stock span problem](https://github.com/TheAlgorithms/Python/blob/master/data_structures/stock_span_problem.py)
  * Trie
    * [trie](https://github.com/TheAlgorithms/Python/blob/master/data_structures/trie.py)
## Digital Image Processing
    * [change contrast](https://github.com/TheAlgorithms/Python/blob/master/digital_image_processing/change_contrast.py)
  * Edge Detection
    * [canny](https://github.com/TheAlgorithms/Python/blob/master/digital_image_processing/canny.py)
  * Filters
    * [convolve](https://github.com/TheAlgorithms/Python/blob/master/digital_image_processing/convolve.py)
    * [gaussian filter](https://github.com/TheAlgorithms/Python/blob/master/digital_image_processing/gaussian_filter.py)
    * [median filter](https://github.com/TheAlgorithms/Python/blob/master/digital_image_processing/median_filter.py)
    * [sobel filter](https://github.com/TheAlgorithms/Python/blob/master/digital_image_processing/sobel_filter.py)
    * [test digital image processing](https://github.com/TheAlgorithms/Python/blob/master/digital_image_processing/test_digital_image_processing.py)
## Divide And Conquer
  * [closest pair of points](https://github.com/TheAlgorithms/Python/blob/master/divide_and_conquer/closest_pair_of_points.py)
  * [convex hull](https://github.com/TheAlgorithms/Python/blob/master/divide_and_conquer/convex_hull.py)
  * [inversions](https://github.com/TheAlgorithms/Python/blob/master/divide_and_conquer/inversions.py)
  * [max subarray sum](https://github.com/TheAlgorithms/Python/blob/master/divide_and_conquer/max_subarray_sum.py)
## Dynamic Programming
  * [abbreviation](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/abbreviation.py)
  * [bitmask](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/bitmask.py)
  * [climbing stairs](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/climbing_stairs.py)
  * [coin change](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/coin_change.py)
  * [edit distance](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/edit_distance.py)
  * [factorial](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/factorial.py)
  * [fast fibonacci](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/fast_fibonacci.py)
  * [fibonacci](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/fibonacci.py)
  * [floyd warshall](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/floyd_warshall.py)
  * [fractional knapsack](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/fractional_knapsack.py)
  * [integer partition](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/integer_partition.py)
  * [k means clustering tensorflow](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/k_means_clustering_tensorflow.py)
  * [knapsack](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/knapsack.py)
  * [longest common subsequence](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/longest_common_subsequence.py)
  * [longest increasing subsequence](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/longest_increasing_subsequence.py)
  * [longest increasing subsequence o(nlogn)](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/longest_increasing_subsequence_o(nlogn).py)
  * [longest sub array](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/longest_sub_array.py)
  * [matrix chain order](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/matrix_chain_order.py)
  * [max sub array](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/max_sub_array.py)
  * [minimum partition](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/minimum_partition.py)
  * [rod cutting](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/rod_cutting.py)
  * [subset generation](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/subset_generation.py)
  * [sum of subset](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/sum_of_subset.py)
## File Transfer
  * [recieve file](https://github.com/TheAlgorithms/Python/blob/master/file_transfer/recieve_file.py)
  * [send file](https://github.com/TheAlgorithms/Python/blob/master/file_transfer/send_file.py)
## Graphs
  * [a star](https://github.com/TheAlgorithms/Python/blob/master/graphs/a_star.py)
  * [articulation points](https://github.com/TheAlgorithms/Python/blob/master/graphs/articulation_points.py)
  * [basic graphs](https://github.com/TheAlgorithms/Python/blob/master/graphs/basic_graphs.py)
  * [bellman ford](https://github.com/TheAlgorithms/Python/blob/master/graphs/bellman_ford.py)
  * [bfs](https://github.com/TheAlgorithms/Python/blob/master/graphs/bfs.py)
  * [bfs shortest path](https://github.com/TheAlgorithms/Python/blob/master/graphs/bfs_shortest_path.py)
  * [breadth first search](https://github.com/TheAlgorithms/Python/blob/master/graphs/breadth_first_search.py)
  * [check bipartite graph bfs](https://github.com/TheAlgorithms/Python/blob/master/graphs/check_bipartite_graph_bfs.py)
  * [check bipartite graph dfs](https://github.com/TheAlgorithms/Python/blob/master/graphs/check_bipartite_graph_dfs.py)
  * [depth first search](https://github.com/TheAlgorithms/Python/blob/master/graphs/depth_first_search.py)
  * [dfs](https://github.com/TheAlgorithms/Python/blob/master/graphs/dfs.py)
  * [dijkstra](https://github.com/TheAlgorithms/Python/blob/master/graphs/dijkstra.py)
  * [dijkstra 2](https://github.com/TheAlgorithms/Python/blob/master/graphs/dijkstra_2.py)
  * [dijkstra algorithm](https://github.com/TheAlgorithms/Python/blob/master/graphs/dijkstra_algorithm.py)
  * [directed and undirected (weighted) graph](https://github.com/TheAlgorithms/Python/blob/master/graphs/directed_and_undirected_(weighted)_graph.py)
  * [edmonds karp multiple source and sink](https://github.com/TheAlgorithms/Python/blob/master/graphs/edmonds_karp_multiple_source_and_sink.py)
  * [eulerian path and circuit for undirected graph](https://github.com/TheAlgorithms/Python/blob/master/graphs/eulerian_path_and_circuit_for_undirected_graph.py)
  * [even tree](https://github.com/TheAlgorithms/Python/blob/master/graphs/even_tree.py)
  * [finding bridges](https://github.com/TheAlgorithms/Python/blob/master/graphs/finding_bridges.py)
  * [graph list](https://github.com/TheAlgorithms/Python/blob/master/graphs/graph_list.py)
  * [graph matrix](https://github.com/TheAlgorithms/Python/blob/master/graphs/graph_matrix.py)
  * [graphs floyd warshall](https://github.com/TheAlgorithms/Python/blob/master/graphs/graphs_floyd_warshall.py)
  * [kahns algorithm long](https://github.com/TheAlgorithms/Python/blob/master/graphs/kahns_algorithm_long.py)
  * [kahns algorithm topo](https://github.com/TheAlgorithms/Python/blob/master/graphs/kahns_algorithm_topo.py)
  * [minimum spanning tree kruskal](https://github.com/TheAlgorithms/Python/blob/master/graphs/minimum_spanning_tree_kruskal.py)
  * [minimum spanning tree prims](https://github.com/TheAlgorithms/Python/blob/master/graphs/minimum_spanning_tree_prims.py)
  * [multi hueristic astar](https://github.com/TheAlgorithms/Python/blob/master/graphs/multi_hueristic_astar.py)
  * [page rank](https://github.com/TheAlgorithms/Python/blob/master/graphs/page_rank.py)
  * [prim](https://github.com/TheAlgorithms/Python/blob/master/graphs/prim.py)
  * [scc kosaraju](https://github.com/TheAlgorithms/Python/blob/master/graphs/scc_kosaraju.py)
  * [tarjans scc](https://github.com/TheAlgorithms/Python/blob/master/graphs/tarjans_scc.py)
## Hashes
  * [chaos machine](https://github.com/TheAlgorithms/Python/blob/master/hashes/chaos_machine.py)
  * [enigma machine](https://github.com/TheAlgorithms/Python/blob/master/hashes/enigma_machine.py)
  * [md5](https://github.com/TheAlgorithms/Python/blob/master/hashes/md5.py)
  * [sha1](https://github.com/TheAlgorithms/Python/blob/master/hashes/sha1.py)
## Linear Algebra
  * Src
    * [lib](https://github.com/TheAlgorithms/Python/blob/master/linear_algebra/lib.py)
    * [polynom-for-points](https://github.com/TheAlgorithms/Python/blob/master/linear_algebra/polynom-for-points.py)
    * [tests](https://github.com/TheAlgorithms/Python/blob/master/linear_algebra/tests.py)
## Machine Learning
  * [decision tree](https://github.com/TheAlgorithms/Python/blob/master/machine_learning/decision_tree.py)
  * [gradient descent](https://github.com/TheAlgorithms/Python/blob/master/machine_learning/gradient_descent.py)
  * [k means clust](https://github.com/TheAlgorithms/Python/blob/master/machine_learning/k_means_clust.py)
  * [knn sklearn](https://github.com/TheAlgorithms/Python/blob/master/machine_learning/knn_sklearn.py)
  * [linear regression](https://github.com/TheAlgorithms/Python/blob/master/machine_learning/linear_regression.py)
  * [logistic regression](https://github.com/TheAlgorithms/Python/blob/master/machine_learning/logistic_regression.py)
  * [naive bayes](https://github.com/TheAlgorithms/Python/blob/master/machine_learning/naive_bayes.ipynb)
  * Random Forest Classification
    * [random forest classification](https://github.com/TheAlgorithms/Python/blob/master/machine_learning/random_forest_classification.py)
    * [random forest classifier](https://github.com/TheAlgorithms/Python/blob/master/machine_learning/random_forest_classifier.ipynb)
  * Random Forest Regression
    * [random forest regression](https://github.com/TheAlgorithms/Python/blob/master/machine_learning/random_forest_regression.ipynb)
    * [random forest regression](https://github.com/TheAlgorithms/Python/blob/master/machine_learning/random_forest_regression.py)
  * [reuters one vs rest classifier](https://github.com/TheAlgorithms/Python/blob/master/machine_learning/reuters_one_vs_rest_classifier.ipynb)
  * [scoring functions](https://github.com/TheAlgorithms/Python/blob/master/machine_learning/scoring_functions.py)
  * [sorted vector machines](https://github.com/TheAlgorithms/Python/blob/master/machine_learning/sorted_vector_machines.py)
## Maths
  * [3n+1](https://github.com/TheAlgorithms/Python/blob/master/maths/3n+1.py)
  * [abs](https://github.com/TheAlgorithms/Python/blob/master/maths/abs.py)
  * [abs max](https://github.com/TheAlgorithms/Python/blob/master/maths/abs_max.py)
  * [abs min](https://github.com/TheAlgorithms/Python/blob/master/maths/abs_min.py)
  * [average mean](https://github.com/TheAlgorithms/Python/blob/master/maths/average_mean.py)
  * [average median](https://github.com/TheAlgorithms/Python/blob/master/maths/average_median.py)
  * [basic maths](https://github.com/TheAlgorithms/Python/blob/master/maths/basic_maths.py)
  * [binary exponentiation](https://github.com/TheAlgorithms/Python/blob/master/maths/binary_exponentiation.py)
  * [collatz sequence](https://github.com/TheAlgorithms/Python/blob/master/maths/collatz_sequence.py)
  * [extended euclidean algorithm](https://github.com/TheAlgorithms/Python/blob/master/maths/extended_euclidean_algorithm.py)
  * [factorial python](https://github.com/TheAlgorithms/Python/blob/master/maths/factorial_python.py)
  * [factorial recursive](https://github.com/TheAlgorithms/Python/blob/master/maths/factorial_recursive.py)
  * [fermat little theorem](https://github.com/TheAlgorithms/Python/blob/master/maths/fermat_little_theorem.py)
  * [fibonacci](https://github.com/TheAlgorithms/Python/blob/master/maths/fibonacci.py)
  * [fibonacci sequence recursion](https://github.com/TheAlgorithms/Python/blob/master/maths/fibonacci_sequence_recursion.py)
  * [find lcm](https://github.com/TheAlgorithms/Python/blob/master/maths/find_lcm.py)
  * [find max](https://github.com/TheAlgorithms/Python/blob/master/maths/find_max.py)
  * [find min](https://github.com/TheAlgorithms/Python/blob/master/maths/find_min.py)
  * [gaussian](https://github.com/TheAlgorithms/Python/blob/master/maths/gaussian.py)
  * [greater common divisor](https://github.com/TheAlgorithms/Python/blob/master/maths/greater_common_divisor.py)
  * [is square free](https://github.com/TheAlgorithms/Python/blob/master/maths/is_square_free.py)
  * [largest of very large numbers](https://github.com/TheAlgorithms/Python/blob/master/maths/largest_of_very_large_numbers.py)
  * [lucas lehmer primality test](https://github.com/TheAlgorithms/Python/blob/master/maths/lucas_lehmer_primality_test.py)
  * [lucas series](https://github.com/TheAlgorithms/Python/blob/master/maths/lucas_series.py)
  * [mobius function](https://github.com/TheAlgorithms/Python/blob/master/maths/mobius_function.py)
  * [modular exponential](https://github.com/TheAlgorithms/Python/blob/master/maths/modular_exponential.py)
  * [newton raphson](https://github.com/TheAlgorithms/Python/blob/master/maths/newton_raphson.py)
  * [prime check](https://github.com/TheAlgorithms/Python/blob/master/maths/prime_check.py)
  * [prime factors](https://github.com/TheAlgorithms/Python/blob/master/maths/prime_factors.py)
  * [quadratic equations complex numbers](https://github.com/TheAlgorithms/Python/blob/master/maths/quadratic_equations_complex_numbers.py)
  * [segmented sieve](https://github.com/TheAlgorithms/Python/blob/master/maths/segmented_sieve.py)
  * [sieve of eratosthenes](https://github.com/TheAlgorithms/Python/blob/master/maths/sieve_of_eratosthenes.py)
  * [simpson rule](https://github.com/TheAlgorithms/Python/blob/master/maths/simpson_rule.py)
  * [test prime check](https://github.com/TheAlgorithms/Python/blob/master/maths/test_prime_check.py)
  * [trapezoidal rule](https://github.com/TheAlgorithms/Python/blob/master/maths/trapezoidal_rule.py)
  * [volume](https://github.com/TheAlgorithms/Python/blob/master/maths/volume.py)
  * [zellers congruence](https://github.com/TheAlgorithms/Python/blob/master/maths/zellers_congruence.py)
## Matrix
  * [matrix operation](https://github.com/TheAlgorithms/Python/blob/master/matrix/matrix_operation.py)
  * [nth fibonacci using matrix exponentiation](https://github.com/TheAlgorithms/Python/blob/master/matrix/nth_fibonacci_using_matrix_exponentiation.py)
  * [rotate matrix](https://github.com/TheAlgorithms/Python/blob/master/matrix/rotate_matrix.py)
  * [searching in sorted matrix](https://github.com/TheAlgorithms/Python/blob/master/matrix/searching_in_sorted_matrix.py)
  * [spiral print](https://github.com/TheAlgorithms/Python/blob/master/matrix/spiral_print.py)
  * Tests
    * [test matrix operation](https://github.com/TheAlgorithms/Python/blob/master/matrix/test_matrix_operation.py)
## Networking Flow
  * [ford fulkerson](https://github.com/TheAlgorithms/Python/blob/master/networking_flow/ford_fulkerson.py)
  * [minimum cut](https://github.com/TheAlgorithms/Python/blob/master/networking_flow/minimum_cut.py)
## Neural Network
  * [back propagation neural network](https://github.com/TheAlgorithms/Python/blob/master/neural_network/back_propagation_neural_network.py)
  * [convolution neural network](https://github.com/TheAlgorithms/Python/blob/master/neural_network/convolution_neural_network.py)
  * [fully connected neural network](https://github.com/TheAlgorithms/Python/blob/master/neural_network/fully_connected_neural_network.ipynb)
  * [perceptron](https://github.com/TheAlgorithms/Python/blob/master/neural_network/perceptron.py)
## Other
  * [anagrams](https://github.com/TheAlgorithms/Python/blob/master/other/anagrams.py)
  * [binary exponentiation](https://github.com/TheAlgorithms/Python/blob/master/other/binary_exponentiation.py)
  * [binary exponentiation 2](https://github.com/TheAlgorithms/Python/blob/master/other/binary_exponentiation_2.py)
  * [detecting english programmatically](https://github.com/TheAlgorithms/Python/blob/master/other/detecting_english_programmatically.py)
  * [euclidean gcd](https://github.com/TheAlgorithms/Python/blob/master/other/euclidean_gcd.py)
  * [fischer yates shuffle](https://github.com/TheAlgorithms/Python/blob/master/other/fischer_yates_shuffle.py)
  * [food wastage analysis from 1961-2013 fao](https://github.com/TheAlgorithms/Python/blob/master/other/food_wastage_analysis_from_1961-2013_fao.ipynb)
  * [frequency finder](https://github.com/TheAlgorithms/Python/blob/master/other/frequency_finder.py)
  * [game of life](https://github.com/TheAlgorithms/Python/blob/master/other/game_of_life.py)
  * [linear congruential generator](https://github.com/TheAlgorithms/Python/blob/master/other/linear_congruential_generator.py)
  * [nested brackets](https://github.com/TheAlgorithms/Python/blob/master/other/nested_brackets.py)
  * [palindrome](https://github.com/TheAlgorithms/Python/blob/master/other/palindrome.py)
  * [password generator](https://github.com/TheAlgorithms/Python/blob/master/other/password_generator.py)
  * [primelib](https://github.com/TheAlgorithms/Python/blob/master/other/primelib.py)
  * [sierpinski triangle](https://github.com/TheAlgorithms/Python/blob/master/other/sierpinski_triangle.py)
  * [tower of hanoi](https://github.com/TheAlgorithms/Python/blob/master/other/tower_of_hanoi.py)
  * [two sum](https://github.com/TheAlgorithms/Python/blob/master/other/two_sum.py)
  * [word patterns](https://github.com/TheAlgorithms/Python/blob/master/other/word_patterns.py)
## Project Euler
  * Problem 01
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
    * [sol2](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol2.py)
    * [sol3](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol3.py)
    * [sol4](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol4.py)
    * [sol5](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol5.py)
    * [sol6](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol6.py)
  * Problem 02
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
    * [sol2](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol2.py)
    * [sol3](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol3.py)
    * [sol4](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol4.py)
  * Problem 03
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
    * [sol2](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol2.py)
  * Problem 04
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
    * [sol2](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol2.py)
  * Problem 05
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
    * [sol2](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol2.py)
  * Problem 06
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
    * [sol2](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol2.py)
    * [sol3](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol3.py)
  * Problem 07
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
    * [sol2](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol2.py)
    * [sol3](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol3.py)
  * Problem 08
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
    * [sol2](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol2.py)
  * Problem 09
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
    * [sol2](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol2.py)
    * [sol3](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol3.py)
  * Problem 10
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
    * [sol2](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol2.py)
    * [sol3](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol3.py)
  * Problem 11
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
    * [sol2](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol2.py)
  * Problem 12
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
    * [sol2](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol2.py)
  * Problem 13
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
  * Problem 14
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
    * [sol2](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol2.py)
  * Problem 15
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
  * Problem 16
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
    * [sol2](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol2.py)
  * Problem 17
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
  * Problem 18
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
  * Problem 19
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
  * Problem 20
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
    * [sol2](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol2.py)
  * Problem 21
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
  * Problem 22
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
    * [sol2](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol2.py)
  * Problem 234
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
  * Problem 24
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
  * Problem 25
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
    * [sol2](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol2.py)
  * Problem 28
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
  * Problem 29
    * [solution](https://github.com/TheAlgorithms/Python/blob/master/project_euler/solution.py)
  * Problem 31
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
  * Problem 36
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
  * Problem 40
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
  * Problem 48
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
  * Problem 52
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
  * Problem 53
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
  * Problem 56
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
  * Problem 76
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
## Searches
  * [binary search](https://github.com/TheAlgorithms/Python/blob/master/searches/binary_search.py)
  * [interpolation search](https://github.com/TheAlgorithms/Python/blob/master/searches/interpolation_search.py)
  * [jump search](https://github.com/TheAlgorithms/Python/blob/master/searches/jump_search.py)
  * [linear search](https://github.com/TheAlgorithms/Python/blob/master/searches/linear_search.py)
  * [quick select](https://github.com/TheAlgorithms/Python/blob/master/searches/quick_select.py)
  * [sentinel linear search](https://github.com/TheAlgorithms/Python/blob/master/searches/sentinel_linear_search.py)
  * [tabu search](https://github.com/TheAlgorithms/Python/blob/master/searches/tabu_search.py)
  * [ternary search](https://github.com/TheAlgorithms/Python/blob/master/searches/ternary_search.py)
## Sorts
  * [bitonic sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/bitonic_sort.py)
  * [bogo sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/bogo_sort.py)
  * [bubble sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/bubble_sort.py)
  * [bucket sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/bucket_sort.py)
  * [cocktail shaker sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/cocktail_shaker_sort.py)
  * [comb sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/comb_sort.py)
  * [counting sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/counting_sort.py)
  * [cycle sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/cycle_sort.py)
  * [external sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/external_sort.py)
  * [gnome sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/gnome_sort.py)
  * [heap sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/heap_sort.py)
  * [insertion sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/insertion_sort.py)
  * [merge sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/merge_sort.py)
  * [merge sort fastest](https://github.com/TheAlgorithms/Python/blob/master/sorts/merge_sort_fastest.py)
  * [odd even transposition parallel](https://github.com/TheAlgorithms/Python/blob/master/sorts/odd_even_transposition_parallel.py)
  * [odd even transposition single threaded](https://github.com/TheAlgorithms/Python/blob/master/sorts/odd_even_transposition_single_threaded.py)
  * [pancake sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/pancake_sort.py)
  * [pigeon sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/pigeon_sort.py)
  * [quick sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/quick_sort.py)
  * [quick sort 3 partition](https://github.com/TheAlgorithms/Python/blob/master/sorts/quick_sort_3_partition.py)
  * [radix sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/radix_sort.py)
  * [random normal distribution quicksort](https://github.com/TheAlgorithms/Python/blob/master/sorts/random_normal_distribution_quicksort.py)
  * [random pivot quick sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/random_pivot_quick_sort.py)
  * [selection sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/selection_sort.py)
  * [shell sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/shell_sort.py)
  * [tim sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/tim_sort.py)
  * [topological sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/topological_sort.py)
  * [tree sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/tree_sort.py)
  * [wiggle sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/wiggle_sort.py)
## Strings
  * [boyer moore search](https://github.com/TheAlgorithms/Python/blob/master/strings/boyer_moore_search.py)
  * [knuth morris pratt](https://github.com/TheAlgorithms/Python/blob/master/strings/knuth_morris_pratt.py)
  * [levenshtein distance](https://github.com/TheAlgorithms/Python/blob/master/strings/levenshtein_distance.py)
  * [manacher](https://github.com/TheAlgorithms/Python/blob/master/strings/manacher.py)
  * [min cost string conversion](https://github.com/TheAlgorithms/Python/blob/master/strings/min_cost_string_conversion.py)
  * [naive string search](https://github.com/TheAlgorithms/Python/blob/master/strings/naive_string_search.py)
  * [rabin karp](https://github.com/TheAlgorithms/Python/blob/master/strings/rabin_karp.py)
## Traversals
  * [binary tree traversals](https://github.com/TheAlgorithms/Python/blob/master/traversals/binary_tree_traversals.py)

