# coding: utf-8

"""
    3Di API

    3Di simulation API (latest version: 3.0)   Framework release: 1.0.11   3Di core release: 2.0.12  deployed on:  13:48AM (UTC) on July 15, 2020  # noqa: E501

    The version of the OpenAPI document: 3.0
    Contact: info@nelen-schuurmans.nl
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openapi_client.api_client import ApiClient
from openapi_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ThreedimodelsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def threedimodels_boundaryconditions_create(self, threedimodel_pk, data, **kwargs):  # noqa: E501
        """threedimodels_boundaryconditions_create  # noqa: E501

        A simple ViewSet for viewing boundary conditions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_boundaryconditions_create(threedimodel_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str threedimodel_pk: (required)
        :param BoundaryCondition data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BoundaryCondition
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_boundaryconditions_create_with_http_info(threedimodel_pk, data, **kwargs)  # noqa: E501

    def threedimodels_boundaryconditions_create_with_http_info(self, threedimodel_pk, data, **kwargs):  # noqa: E501
        """threedimodels_boundaryconditions_create  # noqa: E501

        A simple ViewSet for viewing boundary conditions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_boundaryconditions_create_with_http_info(threedimodel_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str threedimodel_pk: (required)
        :param BoundaryCondition data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BoundaryCondition, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'threedimodel_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_boundaryconditions_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'threedimodel_pk' is set
        if self.api_client.client_side_validation and ('threedimodel_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['threedimodel_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `threedimodel_pk` when calling `threedimodels_boundaryconditions_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `threedimodels_boundaryconditions_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'threedimodel_pk' in local_var_params:
            path_params['threedimodel_pk'] = local_var_params['threedimodel_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{threedimodel_pk}/boundaryconditions/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BoundaryCondition',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_boundaryconditions_delete(self, id, threedimodel_pk, **kwargs):  # noqa: E501
        """threedimodels_boundaryconditions_delete  # noqa: E501

        A simple ViewSet for viewing boundary conditions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_boundaryconditions_delete(id, threedimodel_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this boundary condition. (required)
        :param str threedimodel_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_boundaryconditions_delete_with_http_info(id, threedimodel_pk, **kwargs)  # noqa: E501

    def threedimodels_boundaryconditions_delete_with_http_info(self, id, threedimodel_pk, **kwargs):  # noqa: E501
        """threedimodels_boundaryconditions_delete  # noqa: E501

        A simple ViewSet for viewing boundary conditions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_boundaryconditions_delete_with_http_info(id, threedimodel_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this boundary condition. (required)
        :param str threedimodel_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'threedimodel_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_boundaryconditions_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_boundaryconditions_delete`")  # noqa: E501
        # verify the required parameter 'threedimodel_pk' is set
        if self.api_client.client_side_validation and ('threedimodel_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['threedimodel_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `threedimodel_pk` when calling `threedimodels_boundaryconditions_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'threedimodel_pk' in local_var_params:
            path_params['threedimodel_pk'] = local_var_params['threedimodel_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{threedimodel_pk}/boundaryconditions/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_boundaryconditions_list(self, threedimodel_pk, **kwargs):  # noqa: E501
        """threedimodels_boundaryconditions_list  # noqa: E501

        A simple ViewSet for viewing boundary conditions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_boundaryconditions_list(threedimodel_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str threedimodel_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20047
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_boundaryconditions_list_with_http_info(threedimodel_pk, **kwargs)  # noqa: E501

    def threedimodels_boundaryconditions_list_with_http_info(self, threedimodel_pk, **kwargs):  # noqa: E501
        """threedimodels_boundaryconditions_list  # noqa: E501

        A simple ViewSet for viewing boundary conditions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_boundaryconditions_list_with_http_info(threedimodel_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str threedimodel_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20047, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'threedimodel_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_boundaryconditions_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'threedimodel_pk' is set
        if self.api_client.client_side_validation and ('threedimodel_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['threedimodel_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `threedimodel_pk` when calling `threedimodels_boundaryconditions_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'threedimodel_pk' in local_var_params:
            path_params['threedimodel_pk'] = local_var_params['threedimodel_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{threedimodel_pk}/boundaryconditions/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20047',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_boundaryconditions_partial_update(self, id, threedimodel_pk, data, **kwargs):  # noqa: E501
        """threedimodels_boundaryconditions_partial_update  # noqa: E501

        A simple ViewSet for viewing boundary conditions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_boundaryconditions_partial_update(id, threedimodel_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this boundary condition. (required)
        :param str threedimodel_pk: (required)
        :param BoundaryCondition data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BoundaryCondition
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_boundaryconditions_partial_update_with_http_info(id, threedimodel_pk, data, **kwargs)  # noqa: E501

    def threedimodels_boundaryconditions_partial_update_with_http_info(self, id, threedimodel_pk, data, **kwargs):  # noqa: E501
        """threedimodels_boundaryconditions_partial_update  # noqa: E501

        A simple ViewSet for viewing boundary conditions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_boundaryconditions_partial_update_with_http_info(id, threedimodel_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this boundary condition. (required)
        :param str threedimodel_pk: (required)
        :param BoundaryCondition data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BoundaryCondition, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'threedimodel_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_boundaryconditions_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_boundaryconditions_partial_update`")  # noqa: E501
        # verify the required parameter 'threedimodel_pk' is set
        if self.api_client.client_side_validation and ('threedimodel_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['threedimodel_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `threedimodel_pk` when calling `threedimodels_boundaryconditions_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `threedimodels_boundaryconditions_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'threedimodel_pk' in local_var_params:
            path_params['threedimodel_pk'] = local_var_params['threedimodel_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{threedimodel_pk}/boundaryconditions/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BoundaryCondition',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_boundaryconditions_read(self, id, threedimodel_pk, **kwargs):  # noqa: E501
        """threedimodels_boundaryconditions_read  # noqa: E501

        A simple ViewSet for viewing boundary conditions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_boundaryconditions_read(id, threedimodel_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this boundary condition. (required)
        :param str threedimodel_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BoundaryCondition
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_boundaryconditions_read_with_http_info(id, threedimodel_pk, **kwargs)  # noqa: E501

    def threedimodels_boundaryconditions_read_with_http_info(self, id, threedimodel_pk, **kwargs):  # noqa: E501
        """threedimodels_boundaryconditions_read  # noqa: E501

        A simple ViewSet for viewing boundary conditions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_boundaryconditions_read_with_http_info(id, threedimodel_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this boundary condition. (required)
        :param str threedimodel_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BoundaryCondition, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'threedimodel_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_boundaryconditions_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_boundaryconditions_read`")  # noqa: E501
        # verify the required parameter 'threedimodel_pk' is set
        if self.api_client.client_side_validation and ('threedimodel_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['threedimodel_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `threedimodel_pk` when calling `threedimodels_boundaryconditions_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'threedimodel_pk' in local_var_params:
            path_params['threedimodel_pk'] = local_var_params['threedimodel_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{threedimodel_pk}/boundaryconditions/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BoundaryCondition',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_boundaryconditions_update(self, id, threedimodel_pk, data, **kwargs):  # noqa: E501
        """threedimodels_boundaryconditions_update  # noqa: E501

        A simple ViewSet for viewing boundary conditions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_boundaryconditions_update(id, threedimodel_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this boundary condition. (required)
        :param str threedimodel_pk: (required)
        :param BoundaryCondition data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BoundaryCondition
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_boundaryconditions_update_with_http_info(id, threedimodel_pk, data, **kwargs)  # noqa: E501

    def threedimodels_boundaryconditions_update_with_http_info(self, id, threedimodel_pk, data, **kwargs):  # noqa: E501
        """threedimodels_boundaryconditions_update  # noqa: E501

        A simple ViewSet for viewing boundary conditions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_boundaryconditions_update_with_http_info(id, threedimodel_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this boundary condition. (required)
        :param str threedimodel_pk: (required)
        :param BoundaryCondition data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BoundaryCondition, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'threedimodel_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_boundaryconditions_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_boundaryconditions_update`")  # noqa: E501
        # verify the required parameter 'threedimodel_pk' is set
        if self.api_client.client_side_validation and ('threedimodel_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['threedimodel_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `threedimodel_pk` when calling `threedimodels_boundaryconditions_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `threedimodels_boundaryconditions_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'threedimodel_pk' in local_var_params:
            path_params['threedimodel_pk'] = local_var_params['threedimodel_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{threedimodel_pk}/boundaryconditions/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BoundaryCondition',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_breaches_geojson_upload(self, id, data, **kwargs):  # noqa: E501
        """threedimodels_breaches_geojson_upload  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_breaches_geojson_upload(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param Upload data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Upload
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_breaches_geojson_upload_with_http_info(id, data, **kwargs)  # noqa: E501

    def threedimodels_breaches_geojson_upload_with_http_info(self, id, data, **kwargs):  # noqa: E501
        """threedimodels_breaches_geojson_upload  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_breaches_geojson_upload_with_http_info(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param Upload data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Upload, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_breaches_geojson_upload" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_breaches_geojson_upload`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `threedimodels_breaches_geojson_upload`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{id}/geojson/breaches/upload/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Upload',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_bulk_potentialbreaches_create(self, threedimodel_pk, data, **kwargs):  # noqa: E501
        """threedimodels_bulk_potentialbreaches_create  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_bulk_potentialbreaches_create(threedimodel_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str threedimodel_pk: (required)
        :param list[PotentialBreach] data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[PotentialBreach]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_bulk_potentialbreaches_create_with_http_info(threedimodel_pk, data, **kwargs)  # noqa: E501

    def threedimodels_bulk_potentialbreaches_create_with_http_info(self, threedimodel_pk, data, **kwargs):  # noqa: E501
        """threedimodels_bulk_potentialbreaches_create  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_bulk_potentialbreaches_create_with_http_info(threedimodel_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str threedimodel_pk: (required)
        :param list[PotentialBreach] data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[PotentialBreach], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'threedimodel_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_bulk_potentialbreaches_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'threedimodel_pk' is set
        if self.api_client.client_side_validation and ('threedimodel_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['threedimodel_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `threedimodel_pk` when calling `threedimodels_bulk_potentialbreaches_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `threedimodels_bulk_potentialbreaches_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'threedimodel_pk' in local_var_params:
            path_params['threedimodel_pk'] = local_var_params['threedimodel_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{threedimodel_pk}/bulk_potentialbreaches/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PotentialBreach]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_bulk_rasters_create(self, threedimodel_pk, data, **kwargs):  # noqa: E501
        """threedimodels_bulk_rasters_create  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_bulk_rasters_create(threedimodel_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str threedimodel_pk: (required)
        :param list[Raster] data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Raster]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_bulk_rasters_create_with_http_info(threedimodel_pk, data, **kwargs)  # noqa: E501

    def threedimodels_bulk_rasters_create_with_http_info(self, threedimodel_pk, data, **kwargs):  # noqa: E501
        """threedimodels_bulk_rasters_create  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_bulk_rasters_create_with_http_info(threedimodel_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str threedimodel_pk: (required)
        :param list[Raster] data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Raster], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'threedimodel_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_bulk_rasters_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'threedimodel_pk' is set
        if self.api_client.client_side_validation and ('threedimodel_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['threedimodel_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `threedimodel_pk` when calling `threedimodels_bulk_rasters_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `threedimodels_bulk_rasters_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'threedimodel_pk' in local_var_params:
            path_params['threedimodel_pk'] = local_var_params['threedimodel_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{threedimodel_pk}/bulk_rasters/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Raster]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_cells_geojson_upload(self, id, data, **kwargs):  # noqa: E501
        """threedimodels_cells_geojson_upload  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_cells_geojson_upload(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param Upload data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Upload
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_cells_geojson_upload_with_http_info(id, data, **kwargs)  # noqa: E501

    def threedimodels_cells_geojson_upload_with_http_info(self, id, data, **kwargs):  # noqa: E501
        """threedimodels_cells_geojson_upload  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_cells_geojson_upload_with_http_info(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param Upload data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Upload, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_cells_geojson_upload" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_cells_geojson_upload`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `threedimodels_cells_geojson_upload`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{id}/geojson/cells/upload/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Upload',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_channels_geojson_upload(self, id, data, **kwargs):  # noqa: E501
        """threedimodels_channels_geojson_upload  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_channels_geojson_upload(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param Upload data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Upload
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_channels_geojson_upload_with_http_info(id, data, **kwargs)  # noqa: E501

    def threedimodels_channels_geojson_upload_with_http_info(self, id, data, **kwargs):  # noqa: E501
        """threedimodels_channels_geojson_upload  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_channels_geojson_upload_with_http_info(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param Upload data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Upload, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_channels_geojson_upload" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_channels_geojson_upload`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `threedimodels_channels_geojson_upload`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{id}/geojson/channels/upload/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Upload',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_create(self, data, **kwargs):  # noqa: E501
        """threedimodels_create  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_create(data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ThreediModel data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ThreediModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_create_with_http_info(data, **kwargs)  # noqa: E501

    def threedimodels_create_with_http_info(self, data, **kwargs):  # noqa: E501
        """threedimodels_create  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_create_with_http_info(data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ThreediModel data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ThreediModel, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `threedimodels_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ThreediModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_culverts_geojson_upload(self, id, data, **kwargs):  # noqa: E501
        """threedimodels_culverts_geojson_upload  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_culverts_geojson_upload(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param Upload data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Upload
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_culverts_geojson_upload_with_http_info(id, data, **kwargs)  # noqa: E501

    def threedimodels_culverts_geojson_upload_with_http_info(self, id, data, **kwargs):  # noqa: E501
        """threedimodels_culverts_geojson_upload  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_culverts_geojson_upload_with_http_info(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param Upload data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Upload, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_culverts_geojson_upload" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_culverts_geojson_upload`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `threedimodels_culverts_geojson_upload`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{id}/geojson/culverts/upload/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Upload',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_delete(self, id, **kwargs):  # noqa: E501
        """threedimodels_delete  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_delete(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_delete_with_http_info(id, **kwargs)  # noqa: E501

    def threedimodels_delete_with_http_info(self, id, **kwargs):  # noqa: E501
        """threedimodels_delete  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_delete_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_geojson_breaches_download(self, id, **kwargs):  # noqa: E501
        """threedimodels_geojson_breaches_download  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_geojson_breaches_download(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Download
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_geojson_breaches_download_with_http_info(id, **kwargs)  # noqa: E501

    def threedimodels_geojson_breaches_download_with_http_info(self, id, **kwargs):  # noqa: E501
        """threedimodels_geojson_breaches_download  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_geojson_breaches_download_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Download, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_geojson_breaches_download" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_geojson_breaches_download`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{id}/geojson/breaches/download/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Download',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_geojson_cells_download(self, id, **kwargs):  # noqa: E501
        """threedimodels_geojson_cells_download  # noqa: E501

        Note that this is the subset of 2d open_water cells  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_geojson_cells_download(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Download
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_geojson_cells_download_with_http_info(id, **kwargs)  # noqa: E501

    def threedimodels_geojson_cells_download_with_http_info(self, id, **kwargs):  # noqa: E501
        """threedimodels_geojson_cells_download  # noqa: E501

        Note that this is the subset of 2d open_water cells  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_geojson_cells_download_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Download, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_geojson_cells_download" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_geojson_cells_download`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{id}/geojson/cells/download/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Download',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_geojson_channels_download(self, id, **kwargs):  # noqa: E501
        """threedimodels_geojson_channels_download  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_geojson_channels_download(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Download
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_geojson_channels_download_with_http_info(id, **kwargs)  # noqa: E501

    def threedimodels_geojson_channels_download_with_http_info(self, id, **kwargs):  # noqa: E501
        """threedimodels_geojson_channels_download  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_geojson_channels_download_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Download, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_geojson_channels_download" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_geojson_channels_download`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{id}/geojson/channels/download/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Download',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_geojson_culverts_download(self, id, **kwargs):  # noqa: E501
        """threedimodels_geojson_culverts_download  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_geojson_culverts_download(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Download
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_geojson_culverts_download_with_http_info(id, **kwargs)  # noqa: E501

    def threedimodels_geojson_culverts_download_with_http_info(self, id, **kwargs):  # noqa: E501
        """threedimodels_geojson_culverts_download  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_geojson_culverts_download_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Download, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_geojson_culverts_download" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_geojson_culverts_download`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{id}/geojson/culverts/download/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Download',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_geojson_download(self, id, **kwargs):  # noqa: E501
        """threedimodels_geojson_download  # noqa: E501

        Endpoint for downloading geojson file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_geojson_download(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Download
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_geojson_download_with_http_info(id, **kwargs)  # noqa: E501

    def threedimodels_geojson_download_with_http_info(self, id, **kwargs):  # noqa: E501
        """threedimodels_geojson_download  # noqa: E501

        Endpoint for downloading geojson file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_geojson_download_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Download, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_geojson_download" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_geojson_download`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{id}/geojson/all/download/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Download',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_geojson_levees_download(self, id, **kwargs):  # noqa: E501
        """threedimodels_geojson_levees_download  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_geojson_levees_download(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Download
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_geojson_levees_download_with_http_info(id, **kwargs)  # noqa: E501

    def threedimodels_geojson_levees_download_with_http_info(self, id, **kwargs):  # noqa: E501
        """threedimodels_geojson_levees_download  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_geojson_levees_download_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Download, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_geojson_levees_download" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_geojson_levees_download`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{id}/geojson/levees/download/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Download',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_geojson_manholes_download(self, id, **kwargs):  # noqa: E501
        """threedimodels_geojson_manholes_download  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_geojson_manholes_download(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Download
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_geojson_manholes_download_with_http_info(id, **kwargs)  # noqa: E501

    def threedimodels_geojson_manholes_download_with_http_info(self, id, **kwargs):  # noqa: E501
        """threedimodels_geojson_manholes_download  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_geojson_manholes_download_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Download, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_geojson_manholes_download" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_geojson_manholes_download`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{id}/geojson/manholes/download/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Download',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_geojson_orifices_download(self, id, **kwargs):  # noqa: E501
        """threedimodels_geojson_orifices_download  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_geojson_orifices_download(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Download
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_geojson_orifices_download_with_http_info(id, **kwargs)  # noqa: E501

    def threedimodels_geojson_orifices_download_with_http_info(self, id, **kwargs):  # noqa: E501
        """threedimodels_geojson_orifices_download  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_geojson_orifices_download_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Download, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_geojson_orifices_download" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_geojson_orifices_download`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{id}/geojson/orifices/download/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Download',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_geojson_pipes_download(self, id, **kwargs):  # noqa: E501
        """threedimodels_geojson_pipes_download  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_geojson_pipes_download(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Download
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_geojson_pipes_download_with_http_info(id, **kwargs)  # noqa: E501

    def threedimodels_geojson_pipes_download_with_http_info(self, id, **kwargs):  # noqa: E501
        """threedimodels_geojson_pipes_download  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_geojson_pipes_download_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Download, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_geojson_pipes_download" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_geojson_pipes_download`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{id}/geojson/pipes/download/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Download',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_geojson_pumps_download(self, id, **kwargs):  # noqa: E501
        """threedimodels_geojson_pumps_download  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_geojson_pumps_download(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Download
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_geojson_pumps_download_with_http_info(id, **kwargs)  # noqa: E501

    def threedimodels_geojson_pumps_download_with_http_info(self, id, **kwargs):  # noqa: E501
        """threedimodels_geojson_pumps_download  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_geojson_pumps_download_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Download, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_geojson_pumps_download" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_geojson_pumps_download`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{id}/geojson/pumps/download/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Download',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_geojson_upload(self, id, data, **kwargs):  # noqa: E501
        """threedimodels_geojson_upload  # noqa: E501

        Endpoint for uploading the geojson file Replaces the geojson file if there already exists one.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_geojson_upload(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param Upload data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Upload
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_geojson_upload_with_http_info(id, data, **kwargs)  # noqa: E501

    def threedimodels_geojson_upload_with_http_info(self, id, data, **kwargs):  # noqa: E501
        """threedimodels_geojson_upload  # noqa: E501

        Endpoint for uploading the geojson file Replaces the geojson file if there already exists one.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_geojson_upload_with_http_info(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param Upload data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Upload, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_geojson_upload" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_geojson_upload`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `threedimodels_geojson_upload`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{id}/geojson/all/upload/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Upload',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_geojson_weirs_download(self, id, **kwargs):  # noqa: E501
        """threedimodels_geojson_weirs_download  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_geojson_weirs_download(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Download
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_geojson_weirs_download_with_http_info(id, **kwargs)  # noqa: E501

    def threedimodels_geojson_weirs_download_with_http_info(self, id, **kwargs):  # noqa: E501
        """threedimodels_geojson_weirs_download  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_geojson_weirs_download_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Download, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_geojson_weirs_download" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_geojson_weirs_download`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{id}/geojson/weirs/download/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Download',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_gridadmin_download(self, id, **kwargs):  # noqa: E501
        """threedimodels_gridadmin_download  # noqa: E501

        Endpoint for downloading files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_gridadmin_download(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Download
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_gridadmin_download_with_http_info(id, **kwargs)  # noqa: E501

    def threedimodels_gridadmin_download_with_http_info(self, id, **kwargs):  # noqa: E501
        """threedimodels_gridadmin_download  # noqa: E501

        Endpoint for downloading files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_gridadmin_download_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Download, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_gridadmin_download" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_gridadmin_download`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{id}/gridadmin/download/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Download',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_gridadmin_upload(self, id, data, **kwargs):  # noqa: E501
        """Endpoint for uploading the gridadmin file  # noqa: E501

        Replaces the gridadmin if there already exists one.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_gridadmin_upload(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param Upload data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Upload
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_gridadmin_upload_with_http_info(id, data, **kwargs)  # noqa: E501

    def threedimodels_gridadmin_upload_with_http_info(self, id, data, **kwargs):  # noqa: E501
        """Endpoint for uploading the gridadmin file  # noqa: E501

        Replaces the gridadmin if there already exists one.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_gridadmin_upload_with_http_info(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param Upload data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Upload, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_gridadmin_upload" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_gridadmin_upload`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `threedimodels_gridadmin_upload`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{id}/gridadmin/upload/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Upload',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_initial_waterlevels_create(self, threedimodel_pk, data, **kwargs):  # noqa: E501
        """threedimodels_initial_waterlevels_create  # noqa: E501

        Initial waterlevels are determined for all nodes by aggregating the values in `source_raster` per node using max, min and mean operators. The resulting values are stored in a file linked under `file`.  This file can be inspected using Python (3.7 or higher) using the serializer in the asyncio_rpc package.(pip install asyncio_rpc)       from asyncio_rpc.serialization.msgpack import loadb      data = loadb(binary_file_data)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_initial_waterlevels_create(threedimodel_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str threedimodel_pk: (required)
        :param InitialWaterlevel data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InitialWaterlevel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_initial_waterlevels_create_with_http_info(threedimodel_pk, data, **kwargs)  # noqa: E501

    def threedimodels_initial_waterlevels_create_with_http_info(self, threedimodel_pk, data, **kwargs):  # noqa: E501
        """threedimodels_initial_waterlevels_create  # noqa: E501

        Initial waterlevels are determined for all nodes by aggregating the values in `source_raster` per node using max, min and mean operators. The resulting values are stored in a file linked under `file`.  This file can be inspected using Python (3.7 or higher) using the serializer in the asyncio_rpc package.(pip install asyncio_rpc)       from asyncio_rpc.serialization.msgpack import loadb      data = loadb(binary_file_data)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_initial_waterlevels_create_with_http_info(threedimodel_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str threedimodel_pk: (required)
        :param InitialWaterlevel data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InitialWaterlevel, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'threedimodel_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_initial_waterlevels_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'threedimodel_pk' is set
        if self.api_client.client_side_validation and ('threedimodel_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['threedimodel_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `threedimodel_pk` when calling `threedimodels_initial_waterlevels_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `threedimodels_initial_waterlevels_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'threedimodel_pk' in local_var_params:
            path_params['threedimodel_pk'] = local_var_params['threedimodel_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{threedimodel_pk}/initial_waterlevels/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InitialWaterlevel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_initial_waterlevels_delete(self, id, threedimodel_pk, **kwargs):  # noqa: E501
        """threedimodels_initial_waterlevels_delete  # noqa: E501

        Initial waterlevels are determined for all nodes by aggregating the values in `source_raster` per node using max, min and mean operators. The resulting values are stored in a file linked under `file`.  This file can be inspected using Python (3.7 or higher) using the serializer in the asyncio_rpc package.(pip install asyncio_rpc)       from asyncio_rpc.serialization.msgpack import loadb      data = loadb(binary_file_data)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_initial_waterlevels_delete(id, threedimodel_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this initial waterlevel. (required)
        :param str threedimodel_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_initial_waterlevels_delete_with_http_info(id, threedimodel_pk, **kwargs)  # noqa: E501

    def threedimodels_initial_waterlevels_delete_with_http_info(self, id, threedimodel_pk, **kwargs):  # noqa: E501
        """threedimodels_initial_waterlevels_delete  # noqa: E501

        Initial waterlevels are determined for all nodes by aggregating the values in `source_raster` per node using max, min and mean operators. The resulting values are stored in a file linked under `file`.  This file can be inspected using Python (3.7 or higher) using the serializer in the asyncio_rpc package.(pip install asyncio_rpc)       from asyncio_rpc.serialization.msgpack import loadb      data = loadb(binary_file_data)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_initial_waterlevels_delete_with_http_info(id, threedimodel_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this initial waterlevel. (required)
        :param str threedimodel_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'threedimodel_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_initial_waterlevels_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_initial_waterlevels_delete`")  # noqa: E501
        # verify the required parameter 'threedimodel_pk' is set
        if self.api_client.client_side_validation and ('threedimodel_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['threedimodel_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `threedimodel_pk` when calling `threedimodels_initial_waterlevels_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'threedimodel_pk' in local_var_params:
            path_params['threedimodel_pk'] = local_var_params['threedimodel_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{threedimodel_pk}/initial_waterlevels/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_initial_waterlevels_download(self, id, threedimodel_pk, **kwargs):  # noqa: E501
        """threedimodels_initial_waterlevels_download  # noqa: E501

        Endpoint for downloading files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_initial_waterlevels_download(id, threedimodel_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this initial waterlevel. (required)
        :param str threedimodel_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Download
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_initial_waterlevels_download_with_http_info(id, threedimodel_pk, **kwargs)  # noqa: E501

    def threedimodels_initial_waterlevels_download_with_http_info(self, id, threedimodel_pk, **kwargs):  # noqa: E501
        """threedimodels_initial_waterlevels_download  # noqa: E501

        Endpoint for downloading files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_initial_waterlevels_download_with_http_info(id, threedimodel_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this initial waterlevel. (required)
        :param str threedimodel_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Download, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'threedimodel_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_initial_waterlevels_download" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_initial_waterlevels_download`")  # noqa: E501
        # verify the required parameter 'threedimodel_pk' is set
        if self.api_client.client_side_validation and ('threedimodel_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['threedimodel_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `threedimodel_pk` when calling `threedimodels_initial_waterlevels_download`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'threedimodel_pk' in local_var_params:
            path_params['threedimodel_pk'] = local_var_params['threedimodel_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{threedimodel_pk}/initial_waterlevels/{id}/download/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Download',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_initial_waterlevels_list(self, threedimodel_pk, **kwargs):  # noqa: E501
        """threedimodels_initial_waterlevels_list  # noqa: E501

        Initial waterlevels are determined for all nodes by aggregating the values in `source_raster` per node using max, min and mean operators. The resulting values are stored in a file linked under `file`.  This file can be inspected using Python (3.7 or higher) using the serializer in the asyncio_rpc package.(pip install asyncio_rpc)       from asyncio_rpc.serialization.msgpack import loadb      data = loadb(binary_file_data)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_initial_waterlevels_list(threedimodel_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str threedimodel_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20048
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_initial_waterlevels_list_with_http_info(threedimodel_pk, **kwargs)  # noqa: E501

    def threedimodels_initial_waterlevels_list_with_http_info(self, threedimodel_pk, **kwargs):  # noqa: E501
        """threedimodels_initial_waterlevels_list  # noqa: E501

        Initial waterlevels are determined for all nodes by aggregating the values in `source_raster` per node using max, min and mean operators. The resulting values are stored in a file linked under `file`.  This file can be inspected using Python (3.7 or higher) using the serializer in the asyncio_rpc package.(pip install asyncio_rpc)       from asyncio_rpc.serialization.msgpack import loadb      data = loadb(binary_file_data)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_initial_waterlevels_list_with_http_info(threedimodel_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str threedimodel_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20048, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'threedimodel_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_initial_waterlevels_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'threedimodel_pk' is set
        if self.api_client.client_side_validation and ('threedimodel_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['threedimodel_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `threedimodel_pk` when calling `threedimodels_initial_waterlevels_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'threedimodel_pk' in local_var_params:
            path_params['threedimodel_pk'] = local_var_params['threedimodel_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{threedimodel_pk}/initial_waterlevels/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20048',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_initial_waterlevels_partial_update(self, id, threedimodel_pk, data, **kwargs):  # noqa: E501
        """threedimodels_initial_waterlevels_partial_update  # noqa: E501

        Initial waterlevels are determined for all nodes by aggregating the values in `source_raster` per node using max, min and mean operators. The resulting values are stored in a file linked under `file`.  This file can be inspected using Python (3.7 or higher) using the serializer in the asyncio_rpc package.(pip install asyncio_rpc)       from asyncio_rpc.serialization.msgpack import loadb      data = loadb(binary_file_data)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_initial_waterlevels_partial_update(id, threedimodel_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this initial waterlevel. (required)
        :param str threedimodel_pk: (required)
        :param InitialWaterlevel data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InitialWaterlevel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_initial_waterlevels_partial_update_with_http_info(id, threedimodel_pk, data, **kwargs)  # noqa: E501

    def threedimodels_initial_waterlevels_partial_update_with_http_info(self, id, threedimodel_pk, data, **kwargs):  # noqa: E501
        """threedimodels_initial_waterlevels_partial_update  # noqa: E501

        Initial waterlevels are determined for all nodes by aggregating the values in `source_raster` per node using max, min and mean operators. The resulting values are stored in a file linked under `file`.  This file can be inspected using Python (3.7 or higher) using the serializer in the asyncio_rpc package.(pip install asyncio_rpc)       from asyncio_rpc.serialization.msgpack import loadb      data = loadb(binary_file_data)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_initial_waterlevels_partial_update_with_http_info(id, threedimodel_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this initial waterlevel. (required)
        :param str threedimodel_pk: (required)
        :param InitialWaterlevel data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InitialWaterlevel, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'threedimodel_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_initial_waterlevels_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_initial_waterlevels_partial_update`")  # noqa: E501
        # verify the required parameter 'threedimodel_pk' is set
        if self.api_client.client_side_validation and ('threedimodel_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['threedimodel_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `threedimodel_pk` when calling `threedimodels_initial_waterlevels_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `threedimodels_initial_waterlevels_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'threedimodel_pk' in local_var_params:
            path_params['threedimodel_pk'] = local_var_params['threedimodel_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{threedimodel_pk}/initial_waterlevels/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InitialWaterlevel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_initial_waterlevels_read(self, id, threedimodel_pk, **kwargs):  # noqa: E501
        """threedimodels_initial_waterlevels_read  # noqa: E501

        Initial waterlevels are determined for all nodes by aggregating the values in `source_raster` per node using max, min and mean operators. The resulting values are stored in a file linked under `file`.  This file can be inspected using Python (3.7 or higher) using the serializer in the asyncio_rpc package.(pip install asyncio_rpc)       from asyncio_rpc.serialization.msgpack import loadb      data = loadb(binary_file_data)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_initial_waterlevels_read(id, threedimodel_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this initial waterlevel. (required)
        :param str threedimodel_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InitialWaterlevel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_initial_waterlevels_read_with_http_info(id, threedimodel_pk, **kwargs)  # noqa: E501

    def threedimodels_initial_waterlevels_read_with_http_info(self, id, threedimodel_pk, **kwargs):  # noqa: E501
        """threedimodels_initial_waterlevels_read  # noqa: E501

        Initial waterlevels are determined for all nodes by aggregating the values in `source_raster` per node using max, min and mean operators. The resulting values are stored in a file linked under `file`.  This file can be inspected using Python (3.7 or higher) using the serializer in the asyncio_rpc package.(pip install asyncio_rpc)       from asyncio_rpc.serialization.msgpack import loadb      data = loadb(binary_file_data)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_initial_waterlevels_read_with_http_info(id, threedimodel_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this initial waterlevel. (required)
        :param str threedimodel_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InitialWaterlevel, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'threedimodel_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_initial_waterlevels_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_initial_waterlevels_read`")  # noqa: E501
        # verify the required parameter 'threedimodel_pk' is set
        if self.api_client.client_side_validation and ('threedimodel_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['threedimodel_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `threedimodel_pk` when calling `threedimodels_initial_waterlevels_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'threedimodel_pk' in local_var_params:
            path_params['threedimodel_pk'] = local_var_params['threedimodel_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{threedimodel_pk}/initial_waterlevels/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InitialWaterlevel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_initial_waterlevels_update(self, id, threedimodel_pk, data, **kwargs):  # noqa: E501
        """threedimodels_initial_waterlevels_update  # noqa: E501

        Initial waterlevels are determined for all nodes by aggregating the values in `source_raster` per node using max, min and mean operators. The resulting values are stored in a file linked under `file`.  This file can be inspected using Python (3.7 or higher) using the serializer in the asyncio_rpc package.(pip install asyncio_rpc)       from asyncio_rpc.serialization.msgpack import loadb      data = loadb(binary_file_data)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_initial_waterlevels_update(id, threedimodel_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this initial waterlevel. (required)
        :param str threedimodel_pk: (required)
        :param InitialWaterlevel data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InitialWaterlevel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_initial_waterlevels_update_with_http_info(id, threedimodel_pk, data, **kwargs)  # noqa: E501

    def threedimodels_initial_waterlevels_update_with_http_info(self, id, threedimodel_pk, data, **kwargs):  # noqa: E501
        """threedimodels_initial_waterlevels_update  # noqa: E501

        Initial waterlevels are determined for all nodes by aggregating the values in `source_raster` per node using max, min and mean operators. The resulting values are stored in a file linked under `file`.  This file can be inspected using Python (3.7 or higher) using the serializer in the asyncio_rpc package.(pip install asyncio_rpc)       from asyncio_rpc.serialization.msgpack import loadb      data = loadb(binary_file_data)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_initial_waterlevels_update_with_http_info(id, threedimodel_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this initial waterlevel. (required)
        :param str threedimodel_pk: (required)
        :param InitialWaterlevel data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InitialWaterlevel, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'threedimodel_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_initial_waterlevels_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_initial_waterlevels_update`")  # noqa: E501
        # verify the required parameter 'threedimodel_pk' is set
        if self.api_client.client_side_validation and ('threedimodel_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['threedimodel_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `threedimodel_pk` when calling `threedimodels_initial_waterlevels_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `threedimodels_initial_waterlevels_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'threedimodel_pk' in local_var_params:
            path_params['threedimodel_pk'] = local_var_params['threedimodel_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{threedimodel_pk}/initial_waterlevels/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InitialWaterlevel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_initial_waterlevels_upload(self, id, threedimodel_pk, data, **kwargs):  # noqa: E501
        """threedimodels_initial_waterlevels_upload  # noqa: E501

        Endpoint for uploading a raster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_initial_waterlevels_upload(id, threedimodel_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this initial waterlevel. (required)
        :param str threedimodel_pk: (required)
        :param Upload data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Upload
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_initial_waterlevels_upload_with_http_info(id, threedimodel_pk, data, **kwargs)  # noqa: E501

    def threedimodels_initial_waterlevels_upload_with_http_info(self, id, threedimodel_pk, data, **kwargs):  # noqa: E501
        """threedimodels_initial_waterlevels_upload  # noqa: E501

        Endpoint for uploading a raster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_initial_waterlevels_upload_with_http_info(id, threedimodel_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this initial waterlevel. (required)
        :param str threedimodel_pk: (required)
        :param Upload data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Upload, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'threedimodel_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_initial_waterlevels_upload" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_initial_waterlevels_upload`")  # noqa: E501
        # verify the required parameter 'threedimodel_pk' is set
        if self.api_client.client_side_validation and ('threedimodel_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['threedimodel_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `threedimodel_pk` when calling `threedimodels_initial_waterlevels_upload`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `threedimodels_initial_waterlevels_upload`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'threedimodel_pk' in local_var_params:
            path_params['threedimodel_pk'] = local_var_params['threedimodel_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{threedimodel_pk}/initial_waterlevels/{id}/upload/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Upload',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_levees_geojson_upload(self, id, data, **kwargs):  # noqa: E501
        """threedimodels_levees_geojson_upload  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_levees_geojson_upload(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param Upload data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Upload
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_levees_geojson_upload_with_http_info(id, data, **kwargs)  # noqa: E501

    def threedimodels_levees_geojson_upload_with_http_info(self, id, data, **kwargs):  # noqa: E501
        """threedimodels_levees_geojson_upload  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_levees_geojson_upload_with_http_info(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param Upload data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Upload, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_levees_geojson_upload" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_levees_geojson_upload`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `threedimodels_levees_geojson_upload`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{id}/geojson/levees/upload/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Upload',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_list(self, **kwargs):  # noqa: E501
        """threedimodels_list  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name:
        :param str name__contains:
        :param str name__icontains:
        :param str name__in: Multiple values may be separated by commas.
        :param str name__startswith:
        :param str name__istartswith:
        :param str name__endswith:
        :param str name__regex:
        :param str slug:
        :param str slug__contains:
        :param str slug__icontains:
        :param str slug__in: Multiple values may be separated by commas.
        :param str slug__startswith:
        :param str slug__istartswith:
        :param str slug__endswith:
        :param str slug__regex:
        :param float epsg:
        :param str inpy_version__slug:
        :param str inpy_version__slug__contains:
        :param str inpy_version__slug__icontains:
        :param str inpy_version__slug__in: Multiple values may be separated by commas.
        :param str inpy_version__slug__startswith:
        :param str inpy_version__slug__istartswith:
        :param str inpy_version__slug__endswith:
        :param str inpy_version__slug__regex:
        :param str inpy_version__threedi_version:
        :param str inpy_version__threedi_version__contains:
        :param str inpy_version__threedi_version__icontains:
        :param str inpy_version__threedi_version__in: Multiple values may be separated by commas.
        :param str inpy_version__threedi_version__startswith:
        :param str inpy_version__threedi_version__istartswith:
        :param str inpy_version__threedi_version__endswith:
        :param str inpy_version__threedi_version__regex:
        :param str inpy_version__threedicore_version:
        :param str inpy_version__threedicore_version__contains:
        :param str inpy_version__threedicore_version__icontains:
        :param str inpy_version__threedicore_version__in: Multiple values may be separated by commas.
        :param str inpy_version__threedicore_version__startswith:
        :param str inpy_version__threedicore_version__istartswith:
        :param str inpy_version__threedicore_version__endswith:
        :param str inpy_version__threedicore_version__regex:
        :param float revision__number:
        :param float revision__number__range: Multiple values may be separated by commas.
        :param float revision__number__gt:
        :param float revision__number__gte:
        :param float revision__number__lt:
        :param float revision__number__lte:
        :param str revision__number__isnull:
        :param str revision__hash:
        :param str revision__hash__contains:
        :param str revision__hash__icontains:
        :param str revision__hash__in: Multiple values may be separated by commas.
        :param str revision__hash__startswith:
        :param str revision__hash__istartswith:
        :param str revision__hash__endswith:
        :param str revision__hash__regex:
        :param str revision__is_pinned:
        :param str disabled:
        :param str inp_success:
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20046
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_list_with_http_info(**kwargs)  # noqa: E501

    def threedimodels_list_with_http_info(self, **kwargs):  # noqa: E501
        """threedimodels_list  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name:
        :param str name__contains:
        :param str name__icontains:
        :param str name__in: Multiple values may be separated by commas.
        :param str name__startswith:
        :param str name__istartswith:
        :param str name__endswith:
        :param str name__regex:
        :param str slug:
        :param str slug__contains:
        :param str slug__icontains:
        :param str slug__in: Multiple values may be separated by commas.
        :param str slug__startswith:
        :param str slug__istartswith:
        :param str slug__endswith:
        :param str slug__regex:
        :param float epsg:
        :param str inpy_version__slug:
        :param str inpy_version__slug__contains:
        :param str inpy_version__slug__icontains:
        :param str inpy_version__slug__in: Multiple values may be separated by commas.
        :param str inpy_version__slug__startswith:
        :param str inpy_version__slug__istartswith:
        :param str inpy_version__slug__endswith:
        :param str inpy_version__slug__regex:
        :param str inpy_version__threedi_version:
        :param str inpy_version__threedi_version__contains:
        :param str inpy_version__threedi_version__icontains:
        :param str inpy_version__threedi_version__in: Multiple values may be separated by commas.
        :param str inpy_version__threedi_version__startswith:
        :param str inpy_version__threedi_version__istartswith:
        :param str inpy_version__threedi_version__endswith:
        :param str inpy_version__threedi_version__regex:
        :param str inpy_version__threedicore_version:
        :param str inpy_version__threedicore_version__contains:
        :param str inpy_version__threedicore_version__icontains:
        :param str inpy_version__threedicore_version__in: Multiple values may be separated by commas.
        :param str inpy_version__threedicore_version__startswith:
        :param str inpy_version__threedicore_version__istartswith:
        :param str inpy_version__threedicore_version__endswith:
        :param str inpy_version__threedicore_version__regex:
        :param float revision__number:
        :param float revision__number__range: Multiple values may be separated by commas.
        :param float revision__number__gt:
        :param float revision__number__gte:
        :param float revision__number__lt:
        :param float revision__number__lte:
        :param str revision__number__isnull:
        :param str revision__hash:
        :param str revision__hash__contains:
        :param str revision__hash__icontains:
        :param str revision__hash__in: Multiple values may be separated by commas.
        :param str revision__hash__startswith:
        :param str revision__hash__istartswith:
        :param str revision__hash__endswith:
        :param str revision__hash__regex:
        :param str revision__is_pinned:
        :param str disabled:
        :param str inp_success:
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20046, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'name',
            'name__contains',
            'name__icontains',
            'name__in',
            'name__startswith',
            'name__istartswith',
            'name__endswith',
            'name__regex',
            'slug',
            'slug__contains',
            'slug__icontains',
            'slug__in',
            'slug__startswith',
            'slug__istartswith',
            'slug__endswith',
            'slug__regex',
            'epsg',
            'inpy_version__slug',
            'inpy_version__slug__contains',
            'inpy_version__slug__icontains',
            'inpy_version__slug__in',
            'inpy_version__slug__startswith',
            'inpy_version__slug__istartswith',
            'inpy_version__slug__endswith',
            'inpy_version__slug__regex',
            'inpy_version__threedi_version',
            'inpy_version__threedi_version__contains',
            'inpy_version__threedi_version__icontains',
            'inpy_version__threedi_version__in',
            'inpy_version__threedi_version__startswith',
            'inpy_version__threedi_version__istartswith',
            'inpy_version__threedi_version__endswith',
            'inpy_version__threedi_version__regex',
            'inpy_version__threedicore_version',
            'inpy_version__threedicore_version__contains',
            'inpy_version__threedicore_version__icontains',
            'inpy_version__threedicore_version__in',
            'inpy_version__threedicore_version__startswith',
            'inpy_version__threedicore_version__istartswith',
            'inpy_version__threedicore_version__endswith',
            'inpy_version__threedicore_version__regex',
            'revision__number',
            'revision__number__range',
            'revision__number__gt',
            'revision__number__gte',
            'revision__number__lt',
            'revision__number__lte',
            'revision__number__isnull',
            'revision__hash',
            'revision__hash__contains',
            'revision__hash__icontains',
            'revision__hash__in',
            'revision__hash__startswith',
            'revision__hash__istartswith',
            'revision__hash__endswith',
            'revision__hash__regex',
            'revision__is_pinned',
            'disabled',
            'inp_success',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'name__contains' in local_var_params and local_var_params['name__contains'] is not None:  # noqa: E501
            query_params.append(('name__contains', local_var_params['name__contains']))  # noqa: E501
        if 'name__icontains' in local_var_params and local_var_params['name__icontains'] is not None:  # noqa: E501
            query_params.append(('name__icontains', local_var_params['name__icontains']))  # noqa: E501
        if 'name__in' in local_var_params and local_var_params['name__in'] is not None:  # noqa: E501
            query_params.append(('name__in', local_var_params['name__in']))  # noqa: E501
        if 'name__startswith' in local_var_params and local_var_params['name__startswith'] is not None:  # noqa: E501
            query_params.append(('name__startswith', local_var_params['name__startswith']))  # noqa: E501
        if 'name__istartswith' in local_var_params and local_var_params['name__istartswith'] is not None:  # noqa: E501
            query_params.append(('name__istartswith', local_var_params['name__istartswith']))  # noqa: E501
        if 'name__endswith' in local_var_params and local_var_params['name__endswith'] is not None:  # noqa: E501
            query_params.append(('name__endswith', local_var_params['name__endswith']))  # noqa: E501
        if 'name__regex' in local_var_params and local_var_params['name__regex'] is not None:  # noqa: E501
            query_params.append(('name__regex', local_var_params['name__regex']))  # noqa: E501
        if 'slug' in local_var_params and local_var_params['slug'] is not None:  # noqa: E501
            query_params.append(('slug', local_var_params['slug']))  # noqa: E501
        if 'slug__contains' in local_var_params and local_var_params['slug__contains'] is not None:  # noqa: E501
            query_params.append(('slug__contains', local_var_params['slug__contains']))  # noqa: E501
        if 'slug__icontains' in local_var_params and local_var_params['slug__icontains'] is not None:  # noqa: E501
            query_params.append(('slug__icontains', local_var_params['slug__icontains']))  # noqa: E501
        if 'slug__in' in local_var_params and local_var_params['slug__in'] is not None:  # noqa: E501
            query_params.append(('slug__in', local_var_params['slug__in']))  # noqa: E501
        if 'slug__startswith' in local_var_params and local_var_params['slug__startswith'] is not None:  # noqa: E501
            query_params.append(('slug__startswith', local_var_params['slug__startswith']))  # noqa: E501
        if 'slug__istartswith' in local_var_params and local_var_params['slug__istartswith'] is not None:  # noqa: E501
            query_params.append(('slug__istartswith', local_var_params['slug__istartswith']))  # noqa: E501
        if 'slug__endswith' in local_var_params and local_var_params['slug__endswith'] is not None:  # noqa: E501
            query_params.append(('slug__endswith', local_var_params['slug__endswith']))  # noqa: E501
        if 'slug__regex' in local_var_params and local_var_params['slug__regex'] is not None:  # noqa: E501
            query_params.append(('slug__regex', local_var_params['slug__regex']))  # noqa: E501
        if 'epsg' in local_var_params and local_var_params['epsg'] is not None:  # noqa: E501
            query_params.append(('epsg', local_var_params['epsg']))  # noqa: E501
        if 'inpy_version__slug' in local_var_params and local_var_params['inpy_version__slug'] is not None:  # noqa: E501
            query_params.append(('inpy_version__slug', local_var_params['inpy_version__slug']))  # noqa: E501
        if 'inpy_version__slug__contains' in local_var_params and local_var_params['inpy_version__slug__contains'] is not None:  # noqa: E501
            query_params.append(('inpy_version__slug__contains', local_var_params['inpy_version__slug__contains']))  # noqa: E501
        if 'inpy_version__slug__icontains' in local_var_params and local_var_params['inpy_version__slug__icontains'] is not None:  # noqa: E501
            query_params.append(('inpy_version__slug__icontains', local_var_params['inpy_version__slug__icontains']))  # noqa: E501
        if 'inpy_version__slug__in' in local_var_params and local_var_params['inpy_version__slug__in'] is not None:  # noqa: E501
            query_params.append(('inpy_version__slug__in', local_var_params['inpy_version__slug__in']))  # noqa: E501
        if 'inpy_version__slug__startswith' in local_var_params and local_var_params['inpy_version__slug__startswith'] is not None:  # noqa: E501
            query_params.append(('inpy_version__slug__startswith', local_var_params['inpy_version__slug__startswith']))  # noqa: E501
        if 'inpy_version__slug__istartswith' in local_var_params and local_var_params['inpy_version__slug__istartswith'] is not None:  # noqa: E501
            query_params.append(('inpy_version__slug__istartswith', local_var_params['inpy_version__slug__istartswith']))  # noqa: E501
        if 'inpy_version__slug__endswith' in local_var_params and local_var_params['inpy_version__slug__endswith'] is not None:  # noqa: E501
            query_params.append(('inpy_version__slug__endswith', local_var_params['inpy_version__slug__endswith']))  # noqa: E501
        if 'inpy_version__slug__regex' in local_var_params and local_var_params['inpy_version__slug__regex'] is not None:  # noqa: E501
            query_params.append(('inpy_version__slug__regex', local_var_params['inpy_version__slug__regex']))  # noqa: E501
        if 'inpy_version__threedi_version' in local_var_params and local_var_params['inpy_version__threedi_version'] is not None:  # noqa: E501
            query_params.append(('inpy_version__threedi_version', local_var_params['inpy_version__threedi_version']))  # noqa: E501
        if 'inpy_version__threedi_version__contains' in local_var_params and local_var_params['inpy_version__threedi_version__contains'] is not None:  # noqa: E501
            query_params.append(('inpy_version__threedi_version__contains', local_var_params['inpy_version__threedi_version__contains']))  # noqa: E501
        if 'inpy_version__threedi_version__icontains' in local_var_params and local_var_params['inpy_version__threedi_version__icontains'] is not None:  # noqa: E501
            query_params.append(('inpy_version__threedi_version__icontains', local_var_params['inpy_version__threedi_version__icontains']))  # noqa: E501
        if 'inpy_version__threedi_version__in' in local_var_params and local_var_params['inpy_version__threedi_version__in'] is not None:  # noqa: E501
            query_params.append(('inpy_version__threedi_version__in', local_var_params['inpy_version__threedi_version__in']))  # noqa: E501
        if 'inpy_version__threedi_version__startswith' in local_var_params and local_var_params['inpy_version__threedi_version__startswith'] is not None:  # noqa: E501
            query_params.append(('inpy_version__threedi_version__startswith', local_var_params['inpy_version__threedi_version__startswith']))  # noqa: E501
        if 'inpy_version__threedi_version__istartswith' in local_var_params and local_var_params['inpy_version__threedi_version__istartswith'] is not None:  # noqa: E501
            query_params.append(('inpy_version__threedi_version__istartswith', local_var_params['inpy_version__threedi_version__istartswith']))  # noqa: E501
        if 'inpy_version__threedi_version__endswith' in local_var_params and local_var_params['inpy_version__threedi_version__endswith'] is not None:  # noqa: E501
            query_params.append(('inpy_version__threedi_version__endswith', local_var_params['inpy_version__threedi_version__endswith']))  # noqa: E501
        if 'inpy_version__threedi_version__regex' in local_var_params and local_var_params['inpy_version__threedi_version__regex'] is not None:  # noqa: E501
            query_params.append(('inpy_version__threedi_version__regex', local_var_params['inpy_version__threedi_version__regex']))  # noqa: E501
        if 'inpy_version__threedicore_version' in local_var_params and local_var_params['inpy_version__threedicore_version'] is not None:  # noqa: E501
            query_params.append(('inpy_version__threedicore_version', local_var_params['inpy_version__threedicore_version']))  # noqa: E501
        if 'inpy_version__threedicore_version__contains' in local_var_params and local_var_params['inpy_version__threedicore_version__contains'] is not None:  # noqa: E501
            query_params.append(('inpy_version__threedicore_version__contains', local_var_params['inpy_version__threedicore_version__contains']))  # noqa: E501
        if 'inpy_version__threedicore_version__icontains' in local_var_params and local_var_params['inpy_version__threedicore_version__icontains'] is not None:  # noqa: E501
            query_params.append(('inpy_version__threedicore_version__icontains', local_var_params['inpy_version__threedicore_version__icontains']))  # noqa: E501
        if 'inpy_version__threedicore_version__in' in local_var_params and local_var_params['inpy_version__threedicore_version__in'] is not None:  # noqa: E501
            query_params.append(('inpy_version__threedicore_version__in', local_var_params['inpy_version__threedicore_version__in']))  # noqa: E501
        if 'inpy_version__threedicore_version__startswith' in local_var_params and local_var_params['inpy_version__threedicore_version__startswith'] is not None:  # noqa: E501
            query_params.append(('inpy_version__threedicore_version__startswith', local_var_params['inpy_version__threedicore_version__startswith']))  # noqa: E501
        if 'inpy_version__threedicore_version__istartswith' in local_var_params and local_var_params['inpy_version__threedicore_version__istartswith'] is not None:  # noqa: E501
            query_params.append(('inpy_version__threedicore_version__istartswith', local_var_params['inpy_version__threedicore_version__istartswith']))  # noqa: E501
        if 'inpy_version__threedicore_version__endswith' in local_var_params and local_var_params['inpy_version__threedicore_version__endswith'] is not None:  # noqa: E501
            query_params.append(('inpy_version__threedicore_version__endswith', local_var_params['inpy_version__threedicore_version__endswith']))  # noqa: E501
        if 'inpy_version__threedicore_version__regex' in local_var_params and local_var_params['inpy_version__threedicore_version__regex'] is not None:  # noqa: E501
            query_params.append(('inpy_version__threedicore_version__regex', local_var_params['inpy_version__threedicore_version__regex']))  # noqa: E501
        if 'revision__number' in local_var_params and local_var_params['revision__number'] is not None:  # noqa: E501
            query_params.append(('revision__number', local_var_params['revision__number']))  # noqa: E501
        if 'revision__number__range' in local_var_params and local_var_params['revision__number__range'] is not None:  # noqa: E501
            query_params.append(('revision__number__range', local_var_params['revision__number__range']))  # noqa: E501
        if 'revision__number__gt' in local_var_params and local_var_params['revision__number__gt'] is not None:  # noqa: E501
            query_params.append(('revision__number__gt', local_var_params['revision__number__gt']))  # noqa: E501
        if 'revision__number__gte' in local_var_params and local_var_params['revision__number__gte'] is not None:  # noqa: E501
            query_params.append(('revision__number__gte', local_var_params['revision__number__gte']))  # noqa: E501
        if 'revision__number__lt' in local_var_params and local_var_params['revision__number__lt'] is not None:  # noqa: E501
            query_params.append(('revision__number__lt', local_var_params['revision__number__lt']))  # noqa: E501
        if 'revision__number__lte' in local_var_params and local_var_params['revision__number__lte'] is not None:  # noqa: E501
            query_params.append(('revision__number__lte', local_var_params['revision__number__lte']))  # noqa: E501
        if 'revision__number__isnull' in local_var_params and local_var_params['revision__number__isnull'] is not None:  # noqa: E501
            query_params.append(('revision__number__isnull', local_var_params['revision__number__isnull']))  # noqa: E501
        if 'revision__hash' in local_var_params and local_var_params['revision__hash'] is not None:  # noqa: E501
            query_params.append(('revision__hash', local_var_params['revision__hash']))  # noqa: E501
        if 'revision__hash__contains' in local_var_params and local_var_params['revision__hash__contains'] is not None:  # noqa: E501
            query_params.append(('revision__hash__contains', local_var_params['revision__hash__contains']))  # noqa: E501
        if 'revision__hash__icontains' in local_var_params and local_var_params['revision__hash__icontains'] is not None:  # noqa: E501
            query_params.append(('revision__hash__icontains', local_var_params['revision__hash__icontains']))  # noqa: E501
        if 'revision__hash__in' in local_var_params and local_var_params['revision__hash__in'] is not None:  # noqa: E501
            query_params.append(('revision__hash__in', local_var_params['revision__hash__in']))  # noqa: E501
        if 'revision__hash__startswith' in local_var_params and local_var_params['revision__hash__startswith'] is not None:  # noqa: E501
            query_params.append(('revision__hash__startswith', local_var_params['revision__hash__startswith']))  # noqa: E501
        if 'revision__hash__istartswith' in local_var_params and local_var_params['revision__hash__istartswith'] is not None:  # noqa: E501
            query_params.append(('revision__hash__istartswith', local_var_params['revision__hash__istartswith']))  # noqa: E501
        if 'revision__hash__endswith' in local_var_params and local_var_params['revision__hash__endswith'] is not None:  # noqa: E501
            query_params.append(('revision__hash__endswith', local_var_params['revision__hash__endswith']))  # noqa: E501
        if 'revision__hash__regex' in local_var_params and local_var_params['revision__hash__regex'] is not None:  # noqa: E501
            query_params.append(('revision__hash__regex', local_var_params['revision__hash__regex']))  # noqa: E501
        if 'revision__is_pinned' in local_var_params and local_var_params['revision__is_pinned'] is not None:  # noqa: E501
            query_params.append(('revision__is_pinned', local_var_params['revision__is_pinned']))  # noqa: E501
        if 'disabled' in local_var_params and local_var_params['disabled'] is not None:  # noqa: E501
            query_params.append(('disabled', local_var_params['disabled']))  # noqa: E501
        if 'inp_success' in local_var_params and local_var_params['inp_success'] is not None:  # noqa: E501
            query_params.append(('inp_success', local_var_params['inp_success']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20046',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_manholes_geojson_upload(self, id, data, **kwargs):  # noqa: E501
        """threedimodels_manholes_geojson_upload  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_manholes_geojson_upload(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param Upload data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Upload
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_manholes_geojson_upload_with_http_info(id, data, **kwargs)  # noqa: E501

    def threedimodels_manholes_geojson_upload_with_http_info(self, id, data, **kwargs):  # noqa: E501
        """threedimodels_manholes_geojson_upload  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_manholes_geojson_upload_with_http_info(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param Upload data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Upload, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_manholes_geojson_upload" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_manholes_geojson_upload`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `threedimodels_manholes_geojson_upload`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{id}/geojson/manholes/upload/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Upload',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_orifices_geojson_upload(self, id, data, **kwargs):  # noqa: E501
        """threedimodels_orifices_geojson_upload  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_orifices_geojson_upload(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param Upload data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Upload
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_orifices_geojson_upload_with_http_info(id, data, **kwargs)  # noqa: E501

    def threedimodels_orifices_geojson_upload_with_http_info(self, id, data, **kwargs):  # noqa: E501
        """threedimodels_orifices_geojson_upload  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_orifices_geojson_upload_with_http_info(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param Upload data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Upload, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_orifices_geojson_upload" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_orifices_geojson_upload`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `threedimodels_orifices_geojson_upload`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{id}/geojson/orifices/upload/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Upload',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_partial_update(self, id, data, **kwargs):  # noqa: E501
        """threedimodels_partial_update  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_partial_update(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param ThreediModel data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ThreediModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_partial_update_with_http_info(id, data, **kwargs)  # noqa: E501

    def threedimodels_partial_update_with_http_info(self, id, data, **kwargs):  # noqa: E501
        """threedimodels_partial_update  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_partial_update_with_http_info(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param ThreediModel data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ThreediModel, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `threedimodels_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ThreediModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_pipes_geojson_upload(self, id, data, **kwargs):  # noqa: E501
        """threedimodels_pipes_geojson_upload  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_pipes_geojson_upload(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param Upload data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Upload
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_pipes_geojson_upload_with_http_info(id, data, **kwargs)  # noqa: E501

    def threedimodels_pipes_geojson_upload_with_http_info(self, id, data, **kwargs):  # noqa: E501
        """threedimodels_pipes_geojson_upload  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_pipes_geojson_upload_with_http_info(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param Upload data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Upload, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_pipes_geojson_upload" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_pipes_geojson_upload`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `threedimodels_pipes_geojson_upload`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{id}/geojson/pipes/upload/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Upload',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_potentialbreaches_create(self, threedimodel_pk, data, **kwargs):  # noqa: E501
        """threedimodels_potentialbreaches_create  # noqa: E501

        A simple ViewSet for viewing breaches  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_potentialbreaches_create(threedimodel_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str threedimodel_pk: (required)
        :param PotentialBreach data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PotentialBreach
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_potentialbreaches_create_with_http_info(threedimodel_pk, data, **kwargs)  # noqa: E501

    def threedimodels_potentialbreaches_create_with_http_info(self, threedimodel_pk, data, **kwargs):  # noqa: E501
        """threedimodels_potentialbreaches_create  # noqa: E501

        A simple ViewSet for viewing breaches  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_potentialbreaches_create_with_http_info(threedimodel_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str threedimodel_pk: (required)
        :param PotentialBreach data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PotentialBreach, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'threedimodel_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_potentialbreaches_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'threedimodel_pk' is set
        if self.api_client.client_side_validation and ('threedimodel_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['threedimodel_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `threedimodel_pk` when calling `threedimodels_potentialbreaches_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `threedimodels_potentialbreaches_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'threedimodel_pk' in local_var_params:
            path_params['threedimodel_pk'] = local_var_params['threedimodel_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{threedimodel_pk}/potentialbreaches/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PotentialBreach',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_potentialbreaches_delete(self, id, threedimodel_pk, **kwargs):  # noqa: E501
        """threedimodels_potentialbreaches_delete  # noqa: E501

        A simple ViewSet for viewing breaches  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_potentialbreaches_delete(id, threedimodel_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this potential breach. (required)
        :param str threedimodel_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_potentialbreaches_delete_with_http_info(id, threedimodel_pk, **kwargs)  # noqa: E501

    def threedimodels_potentialbreaches_delete_with_http_info(self, id, threedimodel_pk, **kwargs):  # noqa: E501
        """threedimodels_potentialbreaches_delete  # noqa: E501

        A simple ViewSet for viewing breaches  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_potentialbreaches_delete_with_http_info(id, threedimodel_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this potential breach. (required)
        :param str threedimodel_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'threedimodel_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_potentialbreaches_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_potentialbreaches_delete`")  # noqa: E501
        # verify the required parameter 'threedimodel_pk' is set
        if self.api_client.client_side_validation and ('threedimodel_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['threedimodel_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `threedimodel_pk` when calling `threedimodels_potentialbreaches_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'threedimodel_pk' in local_var_params:
            path_params['threedimodel_pk'] = local_var_params['threedimodel_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{threedimodel_pk}/potentialbreaches/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_potentialbreaches_list(self, threedimodel_pk, **kwargs):  # noqa: E501
        """threedimodels_potentialbreaches_list  # noqa: E501

        A simple ViewSet for viewing breaches  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_potentialbreaches_list(threedimodel_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str threedimodel_pk: (required)
        :param float connected_pnt_id:
        :param float connected_pnt_id__range: Multiple values may be separated by commas.
        :param float connected_pnt_id__gt:
        :param float connected_pnt_id__gte:
        :param float connected_pnt_id__lt:
        :param float connected_pnt_id__lte:
        :param str connected_pnt_id__isnull:
        :param float threedimodel__id:
        :param float threedimodel__id__range: Multiple values may be separated by commas.
        :param float threedimodel__id__gt:
        :param float threedimodel__id__gte:
        :param float threedimodel__id__lt:
        :param float threedimodel__id__lte:
        :param str threedimodel__id__isnull:
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20049
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_potentialbreaches_list_with_http_info(threedimodel_pk, **kwargs)  # noqa: E501

    def threedimodels_potentialbreaches_list_with_http_info(self, threedimodel_pk, **kwargs):  # noqa: E501
        """threedimodels_potentialbreaches_list  # noqa: E501

        A simple ViewSet for viewing breaches  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_potentialbreaches_list_with_http_info(threedimodel_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str threedimodel_pk: (required)
        :param float connected_pnt_id:
        :param float connected_pnt_id__range: Multiple values may be separated by commas.
        :param float connected_pnt_id__gt:
        :param float connected_pnt_id__gte:
        :param float connected_pnt_id__lt:
        :param float connected_pnt_id__lte:
        :param str connected_pnt_id__isnull:
        :param float threedimodel__id:
        :param float threedimodel__id__range: Multiple values may be separated by commas.
        :param float threedimodel__id__gt:
        :param float threedimodel__id__gte:
        :param float threedimodel__id__lt:
        :param float threedimodel__id__lte:
        :param str threedimodel__id__isnull:
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20049, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'threedimodel_pk',
            'connected_pnt_id',
            'connected_pnt_id__range',
            'connected_pnt_id__gt',
            'connected_pnt_id__gte',
            'connected_pnt_id__lt',
            'connected_pnt_id__lte',
            'connected_pnt_id__isnull',
            'threedimodel__id',
            'threedimodel__id__range',
            'threedimodel__id__gt',
            'threedimodel__id__gte',
            'threedimodel__id__lt',
            'threedimodel__id__lte',
            'threedimodel__id__isnull',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_potentialbreaches_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'threedimodel_pk' is set
        if self.api_client.client_side_validation and ('threedimodel_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['threedimodel_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `threedimodel_pk` when calling `threedimodels_potentialbreaches_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'threedimodel_pk' in local_var_params:
            path_params['threedimodel_pk'] = local_var_params['threedimodel_pk']  # noqa: E501

        query_params = []
        if 'connected_pnt_id' in local_var_params and local_var_params['connected_pnt_id'] is not None:  # noqa: E501
            query_params.append(('connected_pnt_id', local_var_params['connected_pnt_id']))  # noqa: E501
        if 'connected_pnt_id__range' in local_var_params and local_var_params['connected_pnt_id__range'] is not None:  # noqa: E501
            query_params.append(('connected_pnt_id__range', local_var_params['connected_pnt_id__range']))  # noqa: E501
        if 'connected_pnt_id__gt' in local_var_params and local_var_params['connected_pnt_id__gt'] is not None:  # noqa: E501
            query_params.append(('connected_pnt_id__gt', local_var_params['connected_pnt_id__gt']))  # noqa: E501
        if 'connected_pnt_id__gte' in local_var_params and local_var_params['connected_pnt_id__gte'] is not None:  # noqa: E501
            query_params.append(('connected_pnt_id__gte', local_var_params['connected_pnt_id__gte']))  # noqa: E501
        if 'connected_pnt_id__lt' in local_var_params and local_var_params['connected_pnt_id__lt'] is not None:  # noqa: E501
            query_params.append(('connected_pnt_id__lt', local_var_params['connected_pnt_id__lt']))  # noqa: E501
        if 'connected_pnt_id__lte' in local_var_params and local_var_params['connected_pnt_id__lte'] is not None:  # noqa: E501
            query_params.append(('connected_pnt_id__lte', local_var_params['connected_pnt_id__lte']))  # noqa: E501
        if 'connected_pnt_id__isnull' in local_var_params and local_var_params['connected_pnt_id__isnull'] is not None:  # noqa: E501
            query_params.append(('connected_pnt_id__isnull', local_var_params['connected_pnt_id__isnull']))  # noqa: E501
        if 'threedimodel__id' in local_var_params and local_var_params['threedimodel__id'] is not None:  # noqa: E501
            query_params.append(('threedimodel__id', local_var_params['threedimodel__id']))  # noqa: E501
        if 'threedimodel__id__range' in local_var_params and local_var_params['threedimodel__id__range'] is not None:  # noqa: E501
            query_params.append(('threedimodel__id__range', local_var_params['threedimodel__id__range']))  # noqa: E501
        if 'threedimodel__id__gt' in local_var_params and local_var_params['threedimodel__id__gt'] is not None:  # noqa: E501
            query_params.append(('threedimodel__id__gt', local_var_params['threedimodel__id__gt']))  # noqa: E501
        if 'threedimodel__id__gte' in local_var_params and local_var_params['threedimodel__id__gte'] is not None:  # noqa: E501
            query_params.append(('threedimodel__id__gte', local_var_params['threedimodel__id__gte']))  # noqa: E501
        if 'threedimodel__id__lt' in local_var_params and local_var_params['threedimodel__id__lt'] is not None:  # noqa: E501
            query_params.append(('threedimodel__id__lt', local_var_params['threedimodel__id__lt']))  # noqa: E501
        if 'threedimodel__id__lte' in local_var_params and local_var_params['threedimodel__id__lte'] is not None:  # noqa: E501
            query_params.append(('threedimodel__id__lte', local_var_params['threedimodel__id__lte']))  # noqa: E501
        if 'threedimodel__id__isnull' in local_var_params and local_var_params['threedimodel__id__isnull'] is not None:  # noqa: E501
            query_params.append(('threedimodel__id__isnull', local_var_params['threedimodel__id__isnull']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{threedimodel_pk}/potentialbreaches/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20049',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_potentialbreaches_partial_update(self, id, threedimodel_pk, data, **kwargs):  # noqa: E501
        """threedimodels_potentialbreaches_partial_update  # noqa: E501

        A simple ViewSet for viewing breaches  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_potentialbreaches_partial_update(id, threedimodel_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this potential breach. (required)
        :param str threedimodel_pk: (required)
        :param PotentialBreach data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PotentialBreach
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_potentialbreaches_partial_update_with_http_info(id, threedimodel_pk, data, **kwargs)  # noqa: E501

    def threedimodels_potentialbreaches_partial_update_with_http_info(self, id, threedimodel_pk, data, **kwargs):  # noqa: E501
        """threedimodels_potentialbreaches_partial_update  # noqa: E501

        A simple ViewSet for viewing breaches  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_potentialbreaches_partial_update_with_http_info(id, threedimodel_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this potential breach. (required)
        :param str threedimodel_pk: (required)
        :param PotentialBreach data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PotentialBreach, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'threedimodel_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_potentialbreaches_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_potentialbreaches_partial_update`")  # noqa: E501
        # verify the required parameter 'threedimodel_pk' is set
        if self.api_client.client_side_validation and ('threedimodel_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['threedimodel_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `threedimodel_pk` when calling `threedimodels_potentialbreaches_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `threedimodels_potentialbreaches_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'threedimodel_pk' in local_var_params:
            path_params['threedimodel_pk'] = local_var_params['threedimodel_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{threedimodel_pk}/potentialbreaches/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PotentialBreach',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_potentialbreaches_read(self, id, threedimodel_pk, **kwargs):  # noqa: E501
        """threedimodels_potentialbreaches_read  # noqa: E501

        A simple ViewSet for viewing breaches  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_potentialbreaches_read(id, threedimodel_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this potential breach. (required)
        :param str threedimodel_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PotentialBreach
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_potentialbreaches_read_with_http_info(id, threedimodel_pk, **kwargs)  # noqa: E501

    def threedimodels_potentialbreaches_read_with_http_info(self, id, threedimodel_pk, **kwargs):  # noqa: E501
        """threedimodels_potentialbreaches_read  # noqa: E501

        A simple ViewSet for viewing breaches  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_potentialbreaches_read_with_http_info(id, threedimodel_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this potential breach. (required)
        :param str threedimodel_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PotentialBreach, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'threedimodel_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_potentialbreaches_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_potentialbreaches_read`")  # noqa: E501
        # verify the required parameter 'threedimodel_pk' is set
        if self.api_client.client_side_validation and ('threedimodel_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['threedimodel_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `threedimodel_pk` when calling `threedimodels_potentialbreaches_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'threedimodel_pk' in local_var_params:
            path_params['threedimodel_pk'] = local_var_params['threedimodel_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{threedimodel_pk}/potentialbreaches/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PotentialBreach',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_potentialbreaches_update(self, id, threedimodel_pk, data, **kwargs):  # noqa: E501
        """threedimodels_potentialbreaches_update  # noqa: E501

        A simple ViewSet for viewing breaches  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_potentialbreaches_update(id, threedimodel_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this potential breach. (required)
        :param str threedimodel_pk: (required)
        :param PotentialBreach data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PotentialBreach
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_potentialbreaches_update_with_http_info(id, threedimodel_pk, data, **kwargs)  # noqa: E501

    def threedimodels_potentialbreaches_update_with_http_info(self, id, threedimodel_pk, data, **kwargs):  # noqa: E501
        """threedimodels_potentialbreaches_update  # noqa: E501

        A simple ViewSet for viewing breaches  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_potentialbreaches_update_with_http_info(id, threedimodel_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this potential breach. (required)
        :param str threedimodel_pk: (required)
        :param PotentialBreach data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PotentialBreach, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'threedimodel_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_potentialbreaches_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_potentialbreaches_update`")  # noqa: E501
        # verify the required parameter 'threedimodel_pk' is set
        if self.api_client.client_side_validation and ('threedimodel_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['threedimodel_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `threedimodel_pk` when calling `threedimodels_potentialbreaches_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `threedimodels_potentialbreaches_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'threedimodel_pk' in local_var_params:
            path_params['threedimodel_pk'] = local_var_params['threedimodel_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{threedimodel_pk}/potentialbreaches/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PotentialBreach',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_pumps_geojson_upload(self, id, data, **kwargs):  # noqa: E501
        """threedimodels_pumps_geojson_upload  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_pumps_geojson_upload(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param Upload data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Upload
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_pumps_geojson_upload_with_http_info(id, data, **kwargs)  # noqa: E501

    def threedimodels_pumps_geojson_upload_with_http_info(self, id, data, **kwargs):  # noqa: E501
        """threedimodels_pumps_geojson_upload  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_pumps_geojson_upload_with_http_info(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param Upload data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Upload, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_pumps_geojson_upload" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_pumps_geojson_upload`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `threedimodels_pumps_geojson_upload`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{id}/geojson/pumps/upload/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Upload',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_raster_options(self, id, **kwargs):  # noqa: E501
        """threedimodels_raster_options  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_raster_options(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RasterOptions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_raster_options_with_http_info(id, **kwargs)  # noqa: E501

    def threedimodels_raster_options_with_http_info(self, id, **kwargs):  # noqa: E501
        """threedimodels_raster_options  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_raster_options_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RasterOptions, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_raster_options" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_raster_options`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{id}/raster_options/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RasterOptions',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_rasters_create(self, threedimodel_pk, data, **kwargs):  # noqa: E501
        """threedimodels_rasters_create  # noqa: E501

        View rasters for threedimodel  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_rasters_create(threedimodel_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str threedimodel_pk: (required)
        :param Raster data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Raster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_rasters_create_with_http_info(threedimodel_pk, data, **kwargs)  # noqa: E501

    def threedimodels_rasters_create_with_http_info(self, threedimodel_pk, data, **kwargs):  # noqa: E501
        """threedimodels_rasters_create  # noqa: E501

        View rasters for threedimodel  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_rasters_create_with_http_info(threedimodel_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str threedimodel_pk: (required)
        :param Raster data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Raster, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'threedimodel_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_rasters_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'threedimodel_pk' is set
        if self.api_client.client_side_validation and ('threedimodel_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['threedimodel_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `threedimodel_pk` when calling `threedimodels_rasters_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `threedimodels_rasters_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'threedimodel_pk' in local_var_params:
            path_params['threedimodel_pk'] = local_var_params['threedimodel_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{threedimodel_pk}/rasters/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Raster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_rasters_delete(self, id, threedimodel_pk, **kwargs):  # noqa: E501
        """threedimodels_rasters_delete  # noqa: E501

        View rasters for threedimodel  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_rasters_delete(id, threedimodel_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this raster. (required)
        :param str threedimodel_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_rasters_delete_with_http_info(id, threedimodel_pk, **kwargs)  # noqa: E501

    def threedimodels_rasters_delete_with_http_info(self, id, threedimodel_pk, **kwargs):  # noqa: E501
        """threedimodels_rasters_delete  # noqa: E501

        View rasters for threedimodel  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_rasters_delete_with_http_info(id, threedimodel_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this raster. (required)
        :param str threedimodel_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'threedimodel_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_rasters_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_rasters_delete`")  # noqa: E501
        # verify the required parameter 'threedimodel_pk' is set
        if self.api_client.client_side_validation and ('threedimodel_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['threedimodel_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `threedimodel_pk` when calling `threedimodels_rasters_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'threedimodel_pk' in local_var_params:
            path_params['threedimodel_pk'] = local_var_params['threedimodel_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{threedimodel_pk}/rasters/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_rasters_download(self, id, threedimodel_pk, **kwargs):  # noqa: E501
        """threedimodels_rasters_download  # noqa: E501

        Endpoint for downloading files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_rasters_download(id, threedimodel_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this raster. (required)
        :param str threedimodel_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Download
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_rasters_download_with_http_info(id, threedimodel_pk, **kwargs)  # noqa: E501

    def threedimodels_rasters_download_with_http_info(self, id, threedimodel_pk, **kwargs):  # noqa: E501
        """threedimodels_rasters_download  # noqa: E501

        Endpoint for downloading files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_rasters_download_with_http_info(id, threedimodel_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this raster. (required)
        :param str threedimodel_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Download, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'threedimodel_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_rasters_download" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_rasters_download`")  # noqa: E501
        # verify the required parameter 'threedimodel_pk' is set
        if self.api_client.client_side_validation and ('threedimodel_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['threedimodel_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `threedimodel_pk` when calling `threedimodels_rasters_download`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'threedimodel_pk' in local_var_params:
            path_params['threedimodel_pk'] = local_var_params['threedimodel_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{threedimodel_pk}/rasters/{id}/download/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Download',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_rasters_list(self, threedimodel_pk, **kwargs):  # noqa: E501
        """threedimodels_rasters_list  # noqa: E501

        View rasters for threedimodel  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_rasters_list(threedimodel_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str threedimodel_pk: (required)
        :param str type:
        :param str type__contains:
        :param str type__icontains:
        :param str type__in: Multiple values may be separated by commas.
        :param str type__startswith:
        :param str type__istartswith:
        :param str type__endswith:
        :param str type__regex:
        :param str name:
        :param str name__contains:
        :param str name__icontains:
        :param str name__in: Multiple values may be separated by commas.
        :param str name__startswith:
        :param str name__istartswith:
        :param str name__endswith:
        :param str name__regex:
        :param float threedimodel__id:
        :param float threedimodel__id__range: Multiple values may be separated by commas.
        :param float threedimodel__id__gt:
        :param float threedimodel__id__gte:
        :param float threedimodel__id__lt:
        :param float threedimodel__id__lte:
        :param str threedimodel__id__isnull:
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20050
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_rasters_list_with_http_info(threedimodel_pk, **kwargs)  # noqa: E501

    def threedimodels_rasters_list_with_http_info(self, threedimodel_pk, **kwargs):  # noqa: E501
        """threedimodels_rasters_list  # noqa: E501

        View rasters for threedimodel  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_rasters_list_with_http_info(threedimodel_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str threedimodel_pk: (required)
        :param str type:
        :param str type__contains:
        :param str type__icontains:
        :param str type__in: Multiple values may be separated by commas.
        :param str type__startswith:
        :param str type__istartswith:
        :param str type__endswith:
        :param str type__regex:
        :param str name:
        :param str name__contains:
        :param str name__icontains:
        :param str name__in: Multiple values may be separated by commas.
        :param str name__startswith:
        :param str name__istartswith:
        :param str name__endswith:
        :param str name__regex:
        :param float threedimodel__id:
        :param float threedimodel__id__range: Multiple values may be separated by commas.
        :param float threedimodel__id__gt:
        :param float threedimodel__id__gte:
        :param float threedimodel__id__lt:
        :param float threedimodel__id__lte:
        :param str threedimodel__id__isnull:
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20050, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'threedimodel_pk',
            'type',
            'type__contains',
            'type__icontains',
            'type__in',
            'type__startswith',
            'type__istartswith',
            'type__endswith',
            'type__regex',
            'name',
            'name__contains',
            'name__icontains',
            'name__in',
            'name__startswith',
            'name__istartswith',
            'name__endswith',
            'name__regex',
            'threedimodel__id',
            'threedimodel__id__range',
            'threedimodel__id__gt',
            'threedimodel__id__gte',
            'threedimodel__id__lt',
            'threedimodel__id__lte',
            'threedimodel__id__isnull',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_rasters_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'threedimodel_pk' is set
        if self.api_client.client_side_validation and ('threedimodel_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['threedimodel_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `threedimodel_pk` when calling `threedimodels_rasters_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'threedimodel_pk' in local_var_params:
            path_params['threedimodel_pk'] = local_var_params['threedimodel_pk']  # noqa: E501

        query_params = []
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'type__contains' in local_var_params and local_var_params['type__contains'] is not None:  # noqa: E501
            query_params.append(('type__contains', local_var_params['type__contains']))  # noqa: E501
        if 'type__icontains' in local_var_params and local_var_params['type__icontains'] is not None:  # noqa: E501
            query_params.append(('type__icontains', local_var_params['type__icontains']))  # noqa: E501
        if 'type__in' in local_var_params and local_var_params['type__in'] is not None:  # noqa: E501
            query_params.append(('type__in', local_var_params['type__in']))  # noqa: E501
        if 'type__startswith' in local_var_params and local_var_params['type__startswith'] is not None:  # noqa: E501
            query_params.append(('type__startswith', local_var_params['type__startswith']))  # noqa: E501
        if 'type__istartswith' in local_var_params and local_var_params['type__istartswith'] is not None:  # noqa: E501
            query_params.append(('type__istartswith', local_var_params['type__istartswith']))  # noqa: E501
        if 'type__endswith' in local_var_params and local_var_params['type__endswith'] is not None:  # noqa: E501
            query_params.append(('type__endswith', local_var_params['type__endswith']))  # noqa: E501
        if 'type__regex' in local_var_params and local_var_params['type__regex'] is not None:  # noqa: E501
            query_params.append(('type__regex', local_var_params['type__regex']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'name__contains' in local_var_params and local_var_params['name__contains'] is not None:  # noqa: E501
            query_params.append(('name__contains', local_var_params['name__contains']))  # noqa: E501
        if 'name__icontains' in local_var_params and local_var_params['name__icontains'] is not None:  # noqa: E501
            query_params.append(('name__icontains', local_var_params['name__icontains']))  # noqa: E501
        if 'name__in' in local_var_params and local_var_params['name__in'] is not None:  # noqa: E501
            query_params.append(('name__in', local_var_params['name__in']))  # noqa: E501
        if 'name__startswith' in local_var_params and local_var_params['name__startswith'] is not None:  # noqa: E501
            query_params.append(('name__startswith', local_var_params['name__startswith']))  # noqa: E501
        if 'name__istartswith' in local_var_params and local_var_params['name__istartswith'] is not None:  # noqa: E501
            query_params.append(('name__istartswith', local_var_params['name__istartswith']))  # noqa: E501
        if 'name__endswith' in local_var_params and local_var_params['name__endswith'] is not None:  # noqa: E501
            query_params.append(('name__endswith', local_var_params['name__endswith']))  # noqa: E501
        if 'name__regex' in local_var_params and local_var_params['name__regex'] is not None:  # noqa: E501
            query_params.append(('name__regex', local_var_params['name__regex']))  # noqa: E501
        if 'threedimodel__id' in local_var_params and local_var_params['threedimodel__id'] is not None:  # noqa: E501
            query_params.append(('threedimodel__id', local_var_params['threedimodel__id']))  # noqa: E501
        if 'threedimodel__id__range' in local_var_params and local_var_params['threedimodel__id__range'] is not None:  # noqa: E501
            query_params.append(('threedimodel__id__range', local_var_params['threedimodel__id__range']))  # noqa: E501
        if 'threedimodel__id__gt' in local_var_params and local_var_params['threedimodel__id__gt'] is not None:  # noqa: E501
            query_params.append(('threedimodel__id__gt', local_var_params['threedimodel__id__gt']))  # noqa: E501
        if 'threedimodel__id__gte' in local_var_params and local_var_params['threedimodel__id__gte'] is not None:  # noqa: E501
            query_params.append(('threedimodel__id__gte', local_var_params['threedimodel__id__gte']))  # noqa: E501
        if 'threedimodel__id__lt' in local_var_params and local_var_params['threedimodel__id__lt'] is not None:  # noqa: E501
            query_params.append(('threedimodel__id__lt', local_var_params['threedimodel__id__lt']))  # noqa: E501
        if 'threedimodel__id__lte' in local_var_params and local_var_params['threedimodel__id__lte'] is not None:  # noqa: E501
            query_params.append(('threedimodel__id__lte', local_var_params['threedimodel__id__lte']))  # noqa: E501
        if 'threedimodel__id__isnull' in local_var_params and local_var_params['threedimodel__id__isnull'] is not None:  # noqa: E501
            query_params.append(('threedimodel__id__isnull', local_var_params['threedimodel__id__isnull']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{threedimodel_pk}/rasters/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20050',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_rasters_partial_update(self, id, threedimodel_pk, data, **kwargs):  # noqa: E501
        """threedimodels_rasters_partial_update  # noqa: E501

        View rasters for threedimodel  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_rasters_partial_update(id, threedimodel_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this raster. (required)
        :param str threedimodel_pk: (required)
        :param Raster data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Raster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_rasters_partial_update_with_http_info(id, threedimodel_pk, data, **kwargs)  # noqa: E501

    def threedimodels_rasters_partial_update_with_http_info(self, id, threedimodel_pk, data, **kwargs):  # noqa: E501
        """threedimodels_rasters_partial_update  # noqa: E501

        View rasters for threedimodel  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_rasters_partial_update_with_http_info(id, threedimodel_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this raster. (required)
        :param str threedimodel_pk: (required)
        :param Raster data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Raster, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'threedimodel_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_rasters_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_rasters_partial_update`")  # noqa: E501
        # verify the required parameter 'threedimodel_pk' is set
        if self.api_client.client_side_validation and ('threedimodel_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['threedimodel_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `threedimodel_pk` when calling `threedimodels_rasters_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `threedimodels_rasters_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'threedimodel_pk' in local_var_params:
            path_params['threedimodel_pk'] = local_var_params['threedimodel_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{threedimodel_pk}/rasters/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Raster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_rasters_read(self, id, threedimodel_pk, **kwargs):  # noqa: E501
        """threedimodels_rasters_read  # noqa: E501

        View rasters for threedimodel  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_rasters_read(id, threedimodel_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this raster. (required)
        :param str threedimodel_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Raster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_rasters_read_with_http_info(id, threedimodel_pk, **kwargs)  # noqa: E501

    def threedimodels_rasters_read_with_http_info(self, id, threedimodel_pk, **kwargs):  # noqa: E501
        """threedimodels_rasters_read  # noqa: E501

        View rasters for threedimodel  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_rasters_read_with_http_info(id, threedimodel_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this raster. (required)
        :param str threedimodel_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Raster, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'threedimodel_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_rasters_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_rasters_read`")  # noqa: E501
        # verify the required parameter 'threedimodel_pk' is set
        if self.api_client.client_side_validation and ('threedimodel_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['threedimodel_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `threedimodel_pk` when calling `threedimodels_rasters_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'threedimodel_pk' in local_var_params:
            path_params['threedimodel_pk'] = local_var_params['threedimodel_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{threedimodel_pk}/rasters/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Raster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_rasters_update(self, id, threedimodel_pk, data, **kwargs):  # noqa: E501
        """threedimodels_rasters_update  # noqa: E501

        View rasters for threedimodel  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_rasters_update(id, threedimodel_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this raster. (required)
        :param str threedimodel_pk: (required)
        :param Raster data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Raster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_rasters_update_with_http_info(id, threedimodel_pk, data, **kwargs)  # noqa: E501

    def threedimodels_rasters_update_with_http_info(self, id, threedimodel_pk, data, **kwargs):  # noqa: E501
        """threedimodels_rasters_update  # noqa: E501

        View rasters for threedimodel  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_rasters_update_with_http_info(id, threedimodel_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this raster. (required)
        :param str threedimodel_pk: (required)
        :param Raster data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Raster, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'threedimodel_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_rasters_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_rasters_update`")  # noqa: E501
        # verify the required parameter 'threedimodel_pk' is set
        if self.api_client.client_side_validation and ('threedimodel_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['threedimodel_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `threedimodel_pk` when calling `threedimodels_rasters_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `threedimodels_rasters_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'threedimodel_pk' in local_var_params:
            path_params['threedimodel_pk'] = local_var_params['threedimodel_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{threedimodel_pk}/rasters/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Raster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_rasters_upload(self, id, threedimodel_pk, data, **kwargs):  # noqa: E501
        """threedimodels_rasters_upload  # noqa: E501

        Endpoint for uploading a raster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_rasters_upload(id, threedimodel_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this raster. (required)
        :param str threedimodel_pk: (required)
        :param Upload data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Upload
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_rasters_upload_with_http_info(id, threedimodel_pk, data, **kwargs)  # noqa: E501

    def threedimodels_rasters_upload_with_http_info(self, id, threedimodel_pk, data, **kwargs):  # noqa: E501
        """threedimodels_rasters_upload  # noqa: E501

        Endpoint for uploading a raster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_rasters_upload_with_http_info(id, threedimodel_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this raster. (required)
        :param str threedimodel_pk: (required)
        :param Upload data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Upload, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'threedimodel_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_rasters_upload" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_rasters_upload`")  # noqa: E501
        # verify the required parameter 'threedimodel_pk' is set
        if self.api_client.client_side_validation and ('threedimodel_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['threedimodel_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `threedimodel_pk` when calling `threedimodels_rasters_upload`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `threedimodels_rasters_upload`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'threedimodel_pk' in local_var_params:
            path_params['threedimodel_pk'] = local_var_params['threedimodel_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{threedimodel_pk}/rasters/{id}/upload/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Upload',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_read(self, id, **kwargs):  # noqa: E501
        """threedimodels_read  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_read(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ThreediModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_read_with_http_info(id, **kwargs)  # noqa: E501

    def threedimodels_read_with_http_info(self, id, **kwargs):  # noqa: E501
        """threedimodels_read  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_read_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ThreediModel, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ThreediModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_saved_states_delete(self, id, threedimodel_pk, **kwargs):  # noqa: E501
        """threedimodels_saved_states_delete  # noqa: E501

        View saved states created for this 3Di model  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_saved_states_delete(id, threedimodel_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str threedimodel_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_saved_states_delete_with_http_info(id, threedimodel_pk, **kwargs)  # noqa: E501

    def threedimodels_saved_states_delete_with_http_info(self, id, threedimodel_pk, **kwargs):  # noqa: E501
        """threedimodels_saved_states_delete  # noqa: E501

        View saved states created for this 3Di model  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_saved_states_delete_with_http_info(id, threedimodel_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str threedimodel_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'threedimodel_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_saved_states_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_saved_states_delete`")  # noqa: E501
        # verify the required parameter 'threedimodel_pk' is set
        if self.api_client.client_side_validation and ('threedimodel_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['threedimodel_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `threedimodel_pk` when calling `threedimodels_saved_states_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'threedimodel_pk' in local_var_params:
            path_params['threedimodel_pk'] = local_var_params['threedimodel_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{threedimodel_pk}/saved_states/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_saved_states_list(self, threedimodel_pk, **kwargs):  # noqa: E501
        """threedimodels_saved_states_list  # noqa: E501

        View saved states created for this 3Di model  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_saved_states_list(threedimodel_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str threedimodel_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20051
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_saved_states_list_with_http_info(threedimodel_pk, **kwargs)  # noqa: E501

    def threedimodels_saved_states_list_with_http_info(self, threedimodel_pk, **kwargs):  # noqa: E501
        """threedimodels_saved_states_list  # noqa: E501

        View saved states created for this 3Di model  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_saved_states_list_with_http_info(threedimodel_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str threedimodel_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20051, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'threedimodel_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_saved_states_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'threedimodel_pk' is set
        if self.api_client.client_side_validation and ('threedimodel_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['threedimodel_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `threedimodel_pk` when calling `threedimodels_saved_states_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'threedimodel_pk' in local_var_params:
            path_params['threedimodel_pk'] = local_var_params['threedimodel_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{threedimodel_pk}/saved_states/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20051',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_saved_states_read(self, id, threedimodel_pk, **kwargs):  # noqa: E501
        """threedimodels_saved_states_read  # noqa: E501

        View saved states created for this 3Di model  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_saved_states_read(id, threedimodel_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str threedimodel_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ThreediModelSavedState
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_saved_states_read_with_http_info(id, threedimodel_pk, **kwargs)  # noqa: E501

    def threedimodels_saved_states_read_with_http_info(self, id, threedimodel_pk, **kwargs):  # noqa: E501
        """threedimodels_saved_states_read  # noqa: E501

        View saved states created for this 3Di model  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_saved_states_read_with_http_info(id, threedimodel_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str threedimodel_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ThreediModelSavedState, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'threedimodel_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_saved_states_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_saved_states_read`")  # noqa: E501
        # verify the required parameter 'threedimodel_pk' is set
        if self.api_client.client_side_validation and ('threedimodel_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['threedimodel_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `threedimodel_pk` when calling `threedimodels_saved_states_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'threedimodel_pk' in local_var_params:
            path_params['threedimodel_pk'] = local_var_params['threedimodel_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{threedimodel_pk}/saved_states/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ThreediModelSavedState',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_update(self, id, data, **kwargs):  # noqa: E501
        """threedimodels_update  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_update(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param ThreediModel data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ThreediModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_update_with_http_info(id, data, **kwargs)  # noqa: E501

    def threedimodels_update_with_http_info(self, id, data, **kwargs):  # noqa: E501
        """threedimodels_update  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_update_with_http_info(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param ThreediModel data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ThreediModel, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `threedimodels_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ThreediModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def threedimodels_weirs_geojson_upload(self, id, data, **kwargs):  # noqa: E501
        """threedimodels_weirs_geojson_upload  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_weirs_geojson_upload(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param Upload data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Upload
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.threedimodels_weirs_geojson_upload_with_http_info(id, data, **kwargs)  # noqa: E501

    def threedimodels_weirs_geojson_upload_with_http_info(self, id, data, **kwargs):  # noqa: E501
        """threedimodels_weirs_geojson_upload  # noqa: E501

        A simple ViewSet for viewing threedimodels  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.threedimodels_weirs_geojson_upload_with_http_info(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this threedi model. (required)
        :param Upload data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Upload, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method threedimodels_weirs_geojson_upload" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `threedimodels_weirs_geojson_upload`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `threedimodels_weirs_geojson_upload`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/threedimodels/{id}/geojson/weirs/upload/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Upload',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
