# pulp_container-client
Fetch, Upload, Organize, and Distribute Software Packages

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v3
- Package version: 2.13.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://pulpproject.org](https://pulpproject.org)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import pulpcore.client.pulp_container
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import pulpcore.client.pulp_container
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import pulpcore.client.pulp_container
from pulpcore.client.pulp_container.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://pulp
# See configuration.py for a list of all supported configuration parameters.
configuration = pulpcore.client.pulp_container.Configuration(
    host = "https://pulp"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure HTTP basic authorization: basicAuth
configuration = pulpcore.client.pulp_container.Configuration(
    username = 'YOUR_USERNAME',
    password = 'YOUR_PASSWORD'
)

# Configure API key authorization: cookieAuth
configuration = pulpcore.client.pulp_container.Configuration(
    host = "https://pulp",
    api_key = {
        'sessionid': 'YOUR_API_KEY'
    }
)
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['sessionid'] = 'Bearer'


# Enter a context with an instance of the API client
with pulpcore.client.pulp_container.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = pulpcore.client.pulp_container.ContentBlobsApi(api_client)
    digest = 'digest_example' # str | Filter results where digest matches value (optional)
digest__in = ['digest__in_example'] # list[str] | Filter results where digest is in a comma-separated list of values (optional)
limit = 56 # int | Number of results to return per page. (optional)
offset = 56 # int | The initial index from which to return the results. (optional)
ordering = ['ordering_example'] # list[str] | Ordering (optional)
repository_version = 'repository_version_example' # str | Repository Version referenced by HREF (optional)
repository_version_added = 'repository_version_added_example' # str | Repository Version referenced by HREF (optional)
repository_version_removed = 'repository_version_removed_example' # str | Repository Version referenced by HREF (optional)
fields = 'fields_example' # str | A list of fields to include in the response. (optional)
exclude_fields = 'exclude_fields_example' # str | A list of fields to exclude from the response. (optional)

    try:
        # List blobs
        api_response = api_instance.list(digest=digest, digest__in=digest__in, limit=limit, offset=offset, ordering=ordering, repository_version=repository_version, repository_version_added=repository_version_added, repository_version_removed=repository_version_removed, fields=fields, exclude_fields=exclude_fields)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ContentBlobsApi->list: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *https://pulp*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ContentBlobsApi* | [**list**](docs/ContentBlobsApi.md#list) | **GET** /pulp/api/v3/content/container/blobs/ | List blobs
*ContentBlobsApi* | [**read**](docs/ContentBlobsApi.md#read) | **GET** {container_blob_href} | Inspect a blob
*ContentManifestsApi* | [**list**](docs/ContentManifestsApi.md#list) | **GET** /pulp/api/v3/content/container/manifests/ | List manifests
*ContentManifestsApi* | [**read**](docs/ContentManifestsApi.md#read) | **GET** {container_manifest_href} | Inspect a manifest
*ContentSignaturesApi* | [**list**](docs/ContentSignaturesApi.md#list) | **GET** /pulp/api/v3/content/container/signatures/ | List manifest signatures
*ContentSignaturesApi* | [**read**](docs/ContentSignaturesApi.md#read) | **GET** {container_manifest_signature_href} | Inspect a manifest signature
*ContentTagsApi* | [**list**](docs/ContentTagsApi.md#list) | **GET** /pulp/api/v3/content/container/tags/ | List tags
*ContentTagsApi* | [**read**](docs/ContentTagsApi.md#read) | **GET** {container_tag_href} | Inspect a tag
*DistributionsContainerApi* | [**add_role**](docs/DistributionsContainerApi.md#add_role) | **POST** {container_container_distribution_href}add_role/ | 
*DistributionsContainerApi* | [**create**](docs/DistributionsContainerApi.md#create) | **POST** /pulp/api/v3/distributions/container/container/ | Create a container distribution
*DistributionsContainerApi* | [**delete**](docs/DistributionsContainerApi.md#delete) | **DELETE** {container_container_distribution_href} | Delete a container distribution
*DistributionsContainerApi* | [**list**](docs/DistributionsContainerApi.md#list) | **GET** /pulp/api/v3/distributions/container/container/ | List container distributions
*DistributionsContainerApi* | [**list_roles**](docs/DistributionsContainerApi.md#list_roles) | **GET** {container_container_distribution_href}list_roles/ | 
*DistributionsContainerApi* | [**my_permissions**](docs/DistributionsContainerApi.md#my_permissions) | **GET** {container_container_distribution_href}my_permissions/ | 
*DistributionsContainerApi* | [**partial_update**](docs/DistributionsContainerApi.md#partial_update) | **PATCH** {container_container_distribution_href} | Update a container distribution
*DistributionsContainerApi* | [**read**](docs/DistributionsContainerApi.md#read) | **GET** {container_container_distribution_href} | Inspect a container distribution
*DistributionsContainerApi* | [**remove_role**](docs/DistributionsContainerApi.md#remove_role) | **POST** {container_container_distribution_href}remove_role/ | 
*DistributionsContainerApi* | [**update**](docs/DistributionsContainerApi.md#update) | **PUT** {container_container_distribution_href} | Update a container distribution
*PulpContainerNamespacesApi* | [**add_role**](docs/PulpContainerNamespacesApi.md#add_role) | **POST** {container_container_namespace_href}add_role/ | 
*PulpContainerNamespacesApi* | [**create**](docs/PulpContainerNamespacesApi.md#create) | **POST** /pulp/api/v3/pulp_container/namespaces/ | Create a container namespace
*PulpContainerNamespacesApi* | [**delete**](docs/PulpContainerNamespacesApi.md#delete) | **DELETE** {container_container_namespace_href} | Delete a container namespace
*PulpContainerNamespacesApi* | [**list**](docs/PulpContainerNamespacesApi.md#list) | **GET** /pulp/api/v3/pulp_container/namespaces/ | List container namespaces
*PulpContainerNamespacesApi* | [**list_roles**](docs/PulpContainerNamespacesApi.md#list_roles) | **GET** {container_container_namespace_href}list_roles/ | 
*PulpContainerNamespacesApi* | [**my_permissions**](docs/PulpContainerNamespacesApi.md#my_permissions) | **GET** {container_container_namespace_href}my_permissions/ | 
*PulpContainerNamespacesApi* | [**read**](docs/PulpContainerNamespacesApi.md#read) | **GET** {container_container_namespace_href} | Inspect a container namespace
*PulpContainerNamespacesApi* | [**remove_role**](docs/PulpContainerNamespacesApi.md#remove_role) | **POST** {container_container_namespace_href}remove_role/ | 
*RemotesContainerApi* | [**add_role**](docs/RemotesContainerApi.md#add_role) | **POST** {container_container_remote_href}add_role/ | 
*RemotesContainerApi* | [**create**](docs/RemotesContainerApi.md#create) | **POST** /pulp/api/v3/remotes/container/container/ | Create a container remote
*RemotesContainerApi* | [**delete**](docs/RemotesContainerApi.md#delete) | **DELETE** {container_container_remote_href} | Delete a container remote
*RemotesContainerApi* | [**list**](docs/RemotesContainerApi.md#list) | **GET** /pulp/api/v3/remotes/container/container/ | List container remotes
*RemotesContainerApi* | [**list_roles**](docs/RemotesContainerApi.md#list_roles) | **GET** {container_container_remote_href}list_roles/ | 
*RemotesContainerApi* | [**my_permissions**](docs/RemotesContainerApi.md#my_permissions) | **GET** {container_container_remote_href}my_permissions/ | 
*RemotesContainerApi* | [**partial_update**](docs/RemotesContainerApi.md#partial_update) | **PATCH** {container_container_remote_href} | Update a container remote
*RemotesContainerApi* | [**read**](docs/RemotesContainerApi.md#read) | **GET** {container_container_remote_href} | Inspect a container remote
*RemotesContainerApi* | [**remove_role**](docs/RemotesContainerApi.md#remove_role) | **POST** {container_container_remote_href}remove_role/ | 
*RemotesContainerApi* | [**update**](docs/RemotesContainerApi.md#update) | **PUT** {container_container_remote_href} | Update a container remote
*RepositoriesContainerApi* | [**add**](docs/RepositoriesContainerApi.md#add) | **POST** {container_container_repository_href}add/ | Add content
*RepositoriesContainerApi* | [**add_role**](docs/RepositoriesContainerApi.md#add_role) | **POST** {container_container_repository_href}add_role/ | 
*RepositoriesContainerApi* | [**build_image**](docs/RepositoriesContainerApi.md#build_image) | **POST** {container_container_repository_href}build_image/ | Build an Image
*RepositoriesContainerApi* | [**copy_manifests**](docs/RepositoriesContainerApi.md#copy_manifests) | **POST** {container_container_repository_href}copy_manifests/ | Copy manifests
*RepositoriesContainerApi* | [**copy_tags**](docs/RepositoriesContainerApi.md#copy_tags) | **POST** {container_container_repository_href}copy_tags/ | Copy tags
*RepositoriesContainerApi* | [**create**](docs/RepositoriesContainerApi.md#create) | **POST** /pulp/api/v3/repositories/container/container/ | Create a container repository
*RepositoriesContainerApi* | [**delete**](docs/RepositoriesContainerApi.md#delete) | **DELETE** {container_container_repository_href} | Delete a container repository
*RepositoriesContainerApi* | [**list**](docs/RepositoriesContainerApi.md#list) | **GET** /pulp/api/v3/repositories/container/container/ | List container repositorys
*RepositoriesContainerApi* | [**list_roles**](docs/RepositoriesContainerApi.md#list_roles) | **GET** {container_container_repository_href}list_roles/ | 
*RepositoriesContainerApi* | [**my_permissions**](docs/RepositoriesContainerApi.md#my_permissions) | **GET** {container_container_repository_href}my_permissions/ | 
*RepositoriesContainerApi* | [**partial_update**](docs/RepositoriesContainerApi.md#partial_update) | **PATCH** {container_container_repository_href} | Update a container repository
*RepositoriesContainerApi* | [**read**](docs/RepositoriesContainerApi.md#read) | **GET** {container_container_repository_href} | Inspect a container repository
*RepositoriesContainerApi* | [**remove**](docs/RepositoriesContainerApi.md#remove) | **POST** {container_container_repository_href}remove/ | Remove content
*RepositoriesContainerApi* | [**remove_role**](docs/RepositoriesContainerApi.md#remove_role) | **POST** {container_container_repository_href}remove_role/ | 
*RepositoriesContainerApi* | [**sign**](docs/RepositoriesContainerApi.md#sign) | **POST** {container_container_repository_href}sign/ | Sign images in the repo
*RepositoriesContainerApi* | [**sync**](docs/RepositoriesContainerApi.md#sync) | **POST** {container_container_repository_href}sync/ | Sync from a remote
*RepositoriesContainerApi* | [**tag**](docs/RepositoriesContainerApi.md#tag) | **POST** {container_container_repository_href}tag/ | Create a Tag
*RepositoriesContainerApi* | [**untag**](docs/RepositoriesContainerApi.md#untag) | **POST** {container_container_repository_href}untag/ | Delete a tag
*RepositoriesContainerApi* | [**update**](docs/RepositoriesContainerApi.md#update) | **PUT** {container_container_repository_href} | Update a container repository
*RepositoriesContainerPushApi* | [**add_role**](docs/RepositoriesContainerPushApi.md#add_role) | **POST** {container_container_push_repository_href}add_role/ | 
*RepositoriesContainerPushApi* | [**list**](docs/RepositoriesContainerPushApi.md#list) | **GET** /pulp/api/v3/repositories/container/container-push/ | List container push repositorys
*RepositoriesContainerPushApi* | [**list_roles**](docs/RepositoriesContainerPushApi.md#list_roles) | **GET** {container_container_push_repository_href}list_roles/ | 
*RepositoriesContainerPushApi* | [**my_permissions**](docs/RepositoriesContainerPushApi.md#my_permissions) | **GET** {container_container_push_repository_href}my_permissions/ | 
*RepositoriesContainerPushApi* | [**partial_update**](docs/RepositoriesContainerPushApi.md#partial_update) | **PATCH** {container_container_push_repository_href} | Update a container push repository
*RepositoriesContainerPushApi* | [**read**](docs/RepositoriesContainerPushApi.md#read) | **GET** {container_container_push_repository_href} | Inspect a container push repository
*RepositoriesContainerPushApi* | [**remove_image**](docs/RepositoriesContainerPushApi.md#remove_image) | **POST** {container_container_push_repository_href}remove_image/ | Delete an image from a repository
*RepositoriesContainerPushApi* | [**remove_role**](docs/RepositoriesContainerPushApi.md#remove_role) | **POST** {container_container_push_repository_href}remove_role/ | 
*RepositoriesContainerPushApi* | [**remove_signatures**](docs/RepositoriesContainerPushApi.md#remove_signatures) | **POST** {container_container_push_repository_href}remove_signatures/ | 
*RepositoriesContainerPushApi* | [**sign**](docs/RepositoriesContainerPushApi.md#sign) | **POST** {container_container_push_repository_href}sign/ | Sign images in the repo
*RepositoriesContainerPushApi* | [**tag**](docs/RepositoriesContainerPushApi.md#tag) | **POST** {container_container_push_repository_href}tag/ | Create a Tag
*RepositoriesContainerPushApi* | [**untag**](docs/RepositoriesContainerPushApi.md#untag) | **POST** {container_container_push_repository_href}untag/ | Delete a tag
*RepositoriesContainerPushApi* | [**update**](docs/RepositoriesContainerPushApi.md#update) | **PUT** {container_container_push_repository_href} | Update a container push repository
*RepositoriesContainerPushVersionsApi* | [**delete**](docs/RepositoriesContainerPushVersionsApi.md#delete) | **DELETE** {container_container_push_repository_version_href} | Delete a repository version
*RepositoriesContainerPushVersionsApi* | [**list**](docs/RepositoriesContainerPushVersionsApi.md#list) | **GET** {container_container_push_repository_href}versions/ | List repository versions
*RepositoriesContainerPushVersionsApi* | [**read**](docs/RepositoriesContainerPushVersionsApi.md#read) | **GET** {container_container_push_repository_version_href} | Inspect a repository version
*RepositoriesContainerPushVersionsApi* | [**repair**](docs/RepositoriesContainerPushVersionsApi.md#repair) | **POST** {container_container_push_repository_version_href}repair/ | 
*RepositoriesContainerVersionsApi* | [**delete**](docs/RepositoriesContainerVersionsApi.md#delete) | **DELETE** {container_container_repository_version_href} | Delete a repository version
*RepositoriesContainerVersionsApi* | [**list**](docs/RepositoriesContainerVersionsApi.md#list) | **GET** {container_container_repository_href}versions/ | List repository versions
*RepositoriesContainerVersionsApi* | [**read**](docs/RepositoriesContainerVersionsApi.md#read) | **GET** {container_container_repository_version_href} | Inspect a repository version
*RepositoriesContainerVersionsApi* | [**repair**](docs/RepositoriesContainerVersionsApi.md#repair) | **POST** {container_container_repository_version_href}repair/ | 
*TokenApi* | [**get**](docs/TokenApi.md#get) | **GET** /token/ | 


## Documentation For Models

 - [AsyncOperationResponse](docs/AsyncOperationResponse.md)
 - [ContainerBlobResponse](docs/ContainerBlobResponse.md)
 - [ContainerContainerDistribution](docs/ContainerContainerDistribution.md)
 - [ContainerContainerDistributionResponse](docs/ContainerContainerDistributionResponse.md)
 - [ContainerContainerNamespace](docs/ContainerContainerNamespace.md)
 - [ContainerContainerNamespaceResponse](docs/ContainerContainerNamespaceResponse.md)
 - [ContainerContainerPushRepository](docs/ContainerContainerPushRepository.md)
 - [ContainerContainerPushRepositoryResponse](docs/ContainerContainerPushRepositoryResponse.md)
 - [ContainerContainerRemote](docs/ContainerContainerRemote.md)
 - [ContainerContainerRemoteResponse](docs/ContainerContainerRemoteResponse.md)
 - [ContainerContainerRepository](docs/ContainerContainerRepository.md)
 - [ContainerContainerRepositoryResponse](docs/ContainerContainerRepositoryResponse.md)
 - [ContainerManifestResponse](docs/ContainerManifestResponse.md)
 - [ContainerManifestSignatureResponse](docs/ContainerManifestSignatureResponse.md)
 - [ContainerRepositorySyncURL](docs/ContainerRepositorySyncURL.md)
 - [ContainerTagResponse](docs/ContainerTagResponse.md)
 - [ContentSummaryResponse](docs/ContentSummaryResponse.md)
 - [ManifestCopy](docs/ManifestCopy.md)
 - [MediaTypesEnum](docs/MediaTypesEnum.md)
 - [MyPermissionsResponse](docs/MyPermissionsResponse.md)
 - [NestedRole](docs/NestedRole.md)
 - [NestedRoleResponse](docs/NestedRoleResponse.md)
 - [OCIBuildImage](docs/OCIBuildImage.md)
 - [ObjectRolesResponse](docs/ObjectRolesResponse.md)
 - [PaginatedRepositoryVersionResponseList](docs/PaginatedRepositoryVersionResponseList.md)
 - [PaginatedcontainerBlobResponseList](docs/PaginatedcontainerBlobResponseList.md)
 - [PaginatedcontainerContainerDistributionResponseList](docs/PaginatedcontainerContainerDistributionResponseList.md)
 - [PaginatedcontainerContainerNamespaceResponseList](docs/PaginatedcontainerContainerNamespaceResponseList.md)
 - [PaginatedcontainerContainerPushRepositoryResponseList](docs/PaginatedcontainerContainerPushRepositoryResponseList.md)
 - [PaginatedcontainerContainerRemoteResponseList](docs/PaginatedcontainerContainerRemoteResponseList.md)
 - [PaginatedcontainerContainerRepositoryResponseList](docs/PaginatedcontainerContainerRepositoryResponseList.md)
 - [PaginatedcontainerManifestResponseList](docs/PaginatedcontainerManifestResponseList.md)
 - [PaginatedcontainerManifestSignatureResponseList](docs/PaginatedcontainerManifestSignatureResponseList.md)
 - [PaginatedcontainerTagResponseList](docs/PaginatedcontainerTagResponseList.md)
 - [PatchedcontainerContainerDistribution](docs/PatchedcontainerContainerDistribution.md)
 - [PatchedcontainerContainerPushRepository](docs/PatchedcontainerContainerPushRepository.md)
 - [PatchedcontainerContainerRemote](docs/PatchedcontainerContainerRemote.md)
 - [PatchedcontainerContainerRepository](docs/PatchedcontainerContainerRepository.md)
 - [PolicyEnum](docs/PolicyEnum.md)
 - [RecursiveManage](docs/RecursiveManage.md)
 - [RemoveImage](docs/RemoveImage.md)
 - [RemoveSignatures](docs/RemoveSignatures.md)
 - [RemoveSignaturesResponse](docs/RemoveSignaturesResponse.md)
 - [Repair](docs/Repair.md)
 - [RepositorySign](docs/RepositorySign.md)
 - [RepositoryVersionResponse](docs/RepositoryVersionResponse.md)
 - [TagCopy](docs/TagCopy.md)
 - [TagImage](docs/TagImage.md)
 - [UnTagImage](docs/UnTagImage.md)


## Documentation For Authorization


## basicAuth

- **Type**: HTTP basic authentication


## cookieAuth

- **Type**: API key
- **API key parameter name**: sessionid
- **Location**: 


## Author

pulp-list@redhat.com


